/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.tracing;

import java.util.AbstractList;
import java.util.List;
import org.semanticweb.elk.reasoner.tracing.Conclusion;
import org.semanticweb.elk.reasoner.tracing.ConclusionBaseFactory;
import org.semanticweb.elk.reasoner.tracing.TracingInference;
import org.semanticweb.elk.reasoner.tracing.TracingInferenceConclusionGetter;
import org.semanticweb.elk.reasoner.tracing.TracingInferencePrinter;

public abstract class AbstractTracingInference
implements TracingInference {
    private static final Conclusion.Factory CONCLUSION_FACTORY_ = ConclusionBaseFactory.getInstance();
    private final TracingInference.Visitor<Conclusion> CONCLUSION_GETTER_ = new TracingInferenceConclusionGetter(CONCLUSION_FACTORY_);

    public abstract int getPremiseCount();

    public abstract Conclusion getPremise(int var1, Conclusion.Factory var2);

    protected static <T> T failGetPremise(int index) {
        throw new IndexOutOfBoundsException("No premise with index: " + index);
    }

    protected void checkPremiseIndex(int index) {
        if (index < 0 || index >= this.getPremiseCount()) {
            AbstractTracingInference.failGetPremise(index);
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public final Conclusion getConclusion() {
        return this.accept(this.CONCLUSION_GETTER_);
    }

    @Override
    public final List<? extends Conclusion> getPremises() {
        return new AbstractList<Conclusion>(){

            @Override
            public Conclusion get(int index) {
                return AbstractTracingInference.this.getPremise(index, CONCLUSION_FACTORY_);
            }

            @Override
            public int size() {
                return AbstractTracingInference.this.getPremiseCount();
            }
        };
    }

    public String toString() {
        return TracingInferencePrinter.toString(this);
    }
}

