/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.tracing;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.semanticweb.elk.owl.visitors.DummyElkAxiomVisitor;
import org.semanticweb.elk.owl.visitors.ElkAxiomVisitor;
import org.semanticweb.elk.reasoner.tracing.Conclusion;
import org.semanticweb.elk.reasoner.tracing.DummyConclusionVisitor;
import org.semanticweb.elk.reasoner.tracing.TraceUnwinder;
import org.semanticweb.elk.reasoner.tracing.TracingInference;
import org.semanticweb.elk.reasoner.tracing.TracingInferencePremiseVisitor;
import org.semanticweb.elk.reasoner.tracing.TracingProof;

public class RecursiveTraceUnwinder
implements TraceUnwinder<Boolean> {
    private final TracingProof proof_;
    private final Queue<TracingInference> innferencesToDo_ = new LinkedList<TracingInference>();

    public RecursiveTraceUnwinder(TracingProof proof) {
        this.proof_ = proof;
    }

    @Override
    public void accept(Conclusion conclusion, TracingInference.Visitor<Boolean> inferenceVisitor) {
        TracingInference next;
        final HashSet<TracingInference> seenInferences = new HashSet<TracingInference>();
        this.innferencesToDo_.clear();
        this.addToQueue(conclusion, seenInferences);
        TracingInferencePremiseVisitor premiseVisitor = new TracingInferencePremiseVisitor((Conclusion.Visitor<?>)new DummyConclusionVisitor<Void>(){

            @Override
            protected Void defaultVisit(Conclusion newConclusion) {
                RecursiveTraceUnwinder.this.addToQueue(newConclusion, seenInferences);
                return null;
            }
        }, (ElkAxiomVisitor<?>)new DummyElkAxiomVisitor());
        while ((next = this.innferencesToDo_.poll()) != null) {
            if (!next.accept(inferenceVisitor).booleanValue()) continue;
            next.accept(premiseVisitor);
        }
    }

    private void addToQueue(Conclusion conclusion, Set<TracingInference> seenInferences) {
        boolean derived = false;
        for (TracingInference inference : this.proof_.getInferences(conclusion)) {
            if (!seenInferences.contains(inference)) {
                seenInferences.add(inference);
                this.innferencesToDo_.add(inference);
            }
            derived = true;
        }
        if (!derived) {
            this.handleUntraced(conclusion);
        }
    }

    protected void handleUntraced(Conclusion untraced) {
    }
}

