/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.concurrent.computation;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.semanticweb.elk.util.concurrent.computation.ConcurrentComputation;
import org.semanticweb.elk.util.concurrent.computation.ConcurrentExecutor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;

public class ConcurrentComputationWithInputs<I, F extends InputProcessorFactory<I, ?>>
extends ConcurrentComputation<F> {
    private final BlockingQueue<I> buffer_;
    private final int bufferCapacity_;
    private final I poison_pill_ = new Object();

    public ConcurrentComputationWithInputs(F inputProcessorFactory, ConcurrentExecutor executor, int maxWorkers, int bufferCapacity) {
        super(inputProcessorFactory, executor, maxWorkers);
        if (bufferCapacity <= maxWorkers) {
            bufferCapacity = maxWorkers + 1;
        }
        this.bufferCapacity_ = bufferCapacity;
        this.buffer_ = new ArrayBlockingQueue<I>(bufferCapacity);
    }

    public ConcurrentComputationWithInputs(F inputProcessorFactory, ConcurrentExecutor executor, int maxWorkers) {
        this(inputProcessorFactory, executor, maxWorkers, 512 + 32 * maxWorkers);
    }

    public synchronized boolean submit(I input) throws InterruptedException {
        if (this.termination || this.isInterrupted()) {
            return false;
        }
        this.buffer_.put(input);
        return true;
    }

    private void wakeUpWorker() {
        if (this.buffer_.isEmpty()) {
            this.buffer_.offer(this.poison_pill_);
        }
    }

    @Override
    protected synchronized void waitWorkers() throws InterruptedException {
        this.wakeUpWorker();
        super.waitWorkers();
        while (this.buffer_.peek() == this.poison_pill_) {
            this.buffer_.remove();
        }
    }

    @Override
    Runnable getWorker() {
        return new Worker();
    }

    private class Worker
    implements Runnable {
        private RuntimeException workerException_ = null;

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            InputProcessor inputProcessor = (InputProcessor)((InputProcessorFactory)ConcurrentComputationWithInputs.this.processorFactory).getEngine();
            try {
                boolean doneProcess = false;
                while (true) {
                    Object nextInput;
                    if (!doneProcess) {
                        inputProcessor.process();
                        doneProcess = true;
                    }
                    if ((nextInput = ConcurrentComputationWithInputs.this.buffer_.take()) != ConcurrentComputationWithInputs.this.poison_pill_) {
                        inputProcessor.submit(nextInput);
                        inputProcessor.process();
                    }
                    if (!ConcurrentComputationWithInputs.this.termination && !ConcurrentComputationWithInputs.this.isInterrupted()) continue;
                    if (ConcurrentComputationWithInputs.this.buffer_.isEmpty()) {
                    } else if (!ConcurrentComputationWithInputs.this.isInterrupted() || ConcurrentComputationWithInputs.this.buffer_.size() == ConcurrentComputationWithInputs.this.bufferCapacity_) {
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable e) {
                this.workerException_ = new RuntimeException("Exception in worker thread: ", e);
            }
            finally {
                ConcurrentComputationWithInputs.this.wakeUpWorker();
                if (this.workerException_ != null) {
                    throw this.workerException_;
                }
                inputProcessor.finish();
            }
        }
    }
}

