/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.printers;

import java.io.IOException;
import org.semanticweb.elk.owl.interfaces.ElkAnnotation;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationProperty;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAnonymousIndividual;
import org.semanticweb.elk.owl.interfaces.ElkAsymmetricObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkCardinalityRestriction;
import org.semanticweb.elk.owl.interfaces.ElkCardinalityRestrictionQualified;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataAllValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkDataComplementOf;
import org.semanticweb.elk.owl.interfaces.ElkDataExactCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkDataExactCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkDataHasValue;
import org.semanticweb.elk.owl.interfaces.ElkDataIntersectionOf;
import org.semanticweb.elk.owl.interfaces.ElkDataMaxCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkDataMaxCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkDataMinCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkDataMinCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkDataOneOf;
import org.semanticweb.elk.owl.interfaces.ElkDataProperty;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataSomeValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkDataUnionOf;
import org.semanticweb.elk.owl.interfaces.ElkDatatype;
import org.semanticweb.elk.owl.interfaces.ElkDatatypeDefinitionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDatatypeRestriction;
import org.semanticweb.elk.owl.interfaces.ElkDeclarationAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDifferentIndividualsAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointDataPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointUnionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentDataPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkFacetRestriction;
import org.semanticweb.elk.owl.interfaces.ElkFunctionalDataPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkFunctionalObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkHasKeyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkInverseObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkIrreflexiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkLiteral;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkNegativeDataPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectAllValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkObjectComplementOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectExactCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectExactCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectHasSelf;
import org.semanticweb.elk.owl.interfaces.ElkObjectHasValue;
import org.semanticweb.elk.owl.interfaces.ElkObjectIntersectionOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectInverseOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectMaxCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectMaxCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectMinCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectMinCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectOneOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyChain;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectSomeValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkObjectUnionOf;
import org.semanticweb.elk.owl.interfaces.ElkPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkPropertyRestriction;
import org.semanticweb.elk.owl.interfaces.ElkPropertyRestrictionQualified;
import org.semanticweb.elk.owl.interfaces.ElkReflexiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSWRLRule;
import org.semanticweb.elk.owl.interfaces.ElkSameIndividualAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubAnnotationPropertyOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubDataPropertyOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSymmetricObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkTransitiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.iris.ElkAbbreviatedIri;
import org.semanticweb.elk.owl.iris.ElkFullIri;
import org.semanticweb.elk.owl.predefined.PredefinedElkIris;
import org.semanticweb.elk.owl.printers.PrintingException;
import org.semanticweb.elk.owl.visitors.ElkEntityVisitor;
import org.semanticweb.elk.owl.visitors.ElkObjectVisitor;

class OwlFunctionalStylePrinterVisitor
implements ElkObjectVisitor<Void> {
    private final Appendable writer;
    private final EntityPrinter entityPrinter;
    private boolean expandAbbreviatedIris = false;

    OwlFunctionalStylePrinterVisitor(Appendable writer, boolean expandAbbreviatedIris) {
        this.writer = writer;
        this.entityPrinter = new EntityPrinter();
        this.expandAbbreviatedIris = expandAbbreviatedIris;
    }

    OwlFunctionalStylePrinterVisitor(Appendable writer) {
        this(writer, false);
    }

    @Override
    public Void visit(ElkAnnotationProperty elkAnnotationProperty) {
        this.write(elkAnnotationProperty);
        return null;
    }

    @Override
    public Void visit(ElkAnonymousIndividual elkAnonymousIndividual) {
        this.write(elkAnonymousIndividual.getNodeId());
        return null;
    }

    @Override
    public Void visit(ElkAsymmetricObjectPropertyAxiom elkAsymmetricObjectPropertyAxiom) {
        this.write("AsymmetricObjectProperty(");
        this.write(elkAsymmetricObjectPropertyAxiom);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkClass elkClass) {
        this.write(elkClass);
        return null;
    }

    @Override
    public Void visit(ElkClassAssertionAxiom elkClassAssertionAxiom) {
        this.write("ClassAssertion(");
        this.write(elkClassAssertionAxiom.getClassExpression());
        this.write(' ');
        this.write(elkClassAssertionAxiom.getIndividual());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDataAllValuesFrom elkDataAllValuesFrom) {
        this.write("DataAllValuesFrom(");
        this.write(elkDataAllValuesFrom.getDataPropertyExpressions());
        this.write(' ');
        this.write(elkDataAllValuesFrom.getDataRange());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDataComplementOf elkDataComplementOf) {
        this.write("DataComplementOf(");
        this.write(elkDataComplementOf.getDataRange());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDataExactCardinalityUnqualified elkDataExactCardinality) {
        this.write("DataExactCardinality(");
        this.write(elkDataExactCardinality);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDataExactCardinalityQualified elkDataExactCardinalityQualified) {
        this.write("DataExactCardinality(");
        this.write(elkDataExactCardinalityQualified);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDataHasValue elkDataHasValue) {
        this.write("DataHasValue(");
        this.write(elkDataHasValue);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDataIntersectionOf elkDataIntersectionOf) {
        this.write("DataIntersectionOf(");
        this.write(elkDataIntersectionOf.getDataRanges());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDataMaxCardinalityUnqualified elkDataMaxCardinality) {
        this.write("DataMaxCardinality(");
        this.write(elkDataMaxCardinality);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDataMaxCardinalityQualified elkDataMaxCardinalityQualified) {
        this.write("DataMaxCardinality(");
        this.write(elkDataMaxCardinalityQualified);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDataMinCardinalityUnqualified elkDataMinCardinality) {
        this.write("DataMinCardinality(");
        this.write(elkDataMinCardinality);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDataMinCardinalityQualified elkDataMinCardinalityQualified) {
        this.write("DataMinCardinality(");
        this.write(elkDataMinCardinalityQualified);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDataOneOf elkDataOneOf) {
        this.write("DataOneOf(");
        this.write(elkDataOneOf.getLiterals());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDataProperty elkDataProperty) {
        this.write(elkDataProperty);
        return null;
    }

    @Override
    public Void visit(ElkDataPropertyAssertionAxiom elkDataPropertyAssertionAxiom) {
        this.write("DataPropertyAssertion(");
        this.write(elkDataPropertyAssertionAxiom);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDataPropertyDomainAxiom elkDataPropertyDomainAxiom) {
        this.write("DataPropertyDomain(");
        this.write(elkDataPropertyDomainAxiom);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDataPropertyRangeAxiom elkDataPropertyRangeAxiom) {
        this.write("DataPropertyRange(");
        this.write(elkDataPropertyRangeAxiom);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDataSomeValuesFrom elkDataSomeValuesFrom) {
        this.write("DataSomeValuesFrom(");
        this.write(elkDataSomeValuesFrom.getDataPropertyExpressions());
        this.write(' ');
        this.write(elkDataSomeValuesFrom.getDataRange());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDatatype elkDatatype) {
        this.write(elkDatatype);
        return null;
    }

    @Override
    public Void visit(ElkDatatypeRestriction elkDatatypeRestriction) {
        this.write("DatatypeRestriction(");
        this.write(elkDatatypeRestriction.getDatatype());
        this.write(' ');
        this.write(elkDatatypeRestriction.getFacetRestrictions());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDataUnionOf elkDataUnionOf) {
        this.write("DataUnionOf(");
        this.write(elkDataUnionOf.getDataRanges());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDeclarationAxiom elkDeclarationAxiom) {
        this.write("Declaration(");
        elkDeclarationAxiom.getEntity().accept(this.entityPrinter);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDifferentIndividualsAxiom elkDifferentIndividualsAxiom) {
        this.write("DifferentIndividuals(");
        this.write(elkDifferentIndividualsAxiom.getIndividuals());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDisjointClassesAxiom elkDisjointClasses) {
        this.write("DisjointClasses(");
        this.write(elkDisjointClasses.getClassExpressions());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDisjointDataPropertiesAxiom elkDisjointDataPropertiesAxiom) {
        this.write("DisjointDataProperties(");
        this.write(elkDisjointDataPropertiesAxiom.getDataPropertyExpressions());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDisjointObjectPropertiesAxiom elkDisjointObjectPropertiesAxiom) {
        this.write("DisjointObjectProperties(");
        this.write(elkDisjointObjectPropertiesAxiom.getObjectPropertyExpressions());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkDisjointUnionAxiom elkDisjointUnionAxiom) {
        this.write("DisjointUnion(");
        this.write(elkDisjointUnionAxiom.getDefinedClass());
        this.write(' ');
        this.write(elkDisjointUnionAxiom.getClassExpressions());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkEquivalentClassesAxiom elkEquivalentClassesAxiom) {
        this.write("EquivalentClasses(");
        this.write(elkEquivalentClassesAxiom.getClassExpressions());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkEquivalentDataPropertiesAxiom elkEquivalentDataProperties) {
        this.write("EquivalentDataProperties(");
        this.write(elkEquivalentDataProperties.getDataPropertyExpressions());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkEquivalentObjectPropertiesAxiom elkEquivalentObjectProperties) {
        this.write("EquivalentObjectProperties(");
        this.write(elkEquivalentObjectProperties.getObjectPropertyExpressions());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkFacetRestriction restricition) {
        this.write(restricition.getConstrainingFacet());
        this.write(' ');
        this.write(restricition.getRestrictionValue());
        return null;
    }

    @Override
    public Void visit(ElkFunctionalDataPropertyAxiom elkFunctionalDataPropertyAxiom) {
        this.write("FunctionalDataProperty(");
        this.write(elkFunctionalDataPropertyAxiom);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkFunctionalObjectPropertyAxiom elkFunctionalObjectPropertyAxiom) {
        this.write("FunctionalObjectProperty(");
        this.write(elkFunctionalObjectPropertyAxiom);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkInverseFunctionalObjectPropertyAxiom elkInverseFunctionalObjectPropertyAxiom) {
        this.write("InverseFunctionalObjectProperty(");
        this.write(elkInverseFunctionalObjectPropertyAxiom);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkInverseObjectPropertiesAxiom elkInverseObjectPropertiesAxiom) {
        this.write("InverseObjectProperties(");
        this.write(elkInverseObjectPropertiesAxiom.getFirstObjectPropertyExpression());
        this.write(' ');
        this.write(elkInverseObjectPropertiesAxiom.getSecondObjectPropertyExpression());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkIrreflexiveObjectPropertyAxiom elkIrreflexiveObjectPropertyAxiom) {
        this.write("IrreflexiveObjectProperty(");
        this.write(elkIrreflexiveObjectPropertyAxiom);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkLiteral elkLiteral) {
        this.write("\"");
        this.write(elkLiteral.getLexicalForm());
        this.write("\"");
        if (!OwlFunctionalStylePrinterVisitor.isPlain(elkLiteral)) {
            this.write("^^");
            this.write(elkLiteral.getDatatype());
        }
        return null;
    }

    private static boolean isPlain(ElkLiteral elkLiteral) {
        return elkLiteral.getDatatype() == null || PredefinedElkIris.RDF_PLAIN_LITERAL.equals(elkLiteral.getDatatype().getIri());
    }

    @Override
    public Void visit(ElkNamedIndividual elkNamedIndividual) {
        this.write(elkNamedIndividual);
        return null;
    }

    @Override
    public Void visit(ElkNegativeDataPropertyAssertionAxiom elkNegativeDataPropertyAssertion) {
        this.write("NegativeDataPropertyAssertion(");
        this.write(elkNegativeDataPropertyAssertion);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkNegativeObjectPropertyAssertionAxiom elkNegativeObjectPropertyAssertion) {
        this.write("NegativeObjectPropertyAssertion(");
        this.write(elkNegativeObjectPropertyAssertion);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectAllValuesFrom elkObjectAllValuesFrom) {
        this.write("ObjectAllValuesFrom(");
        this.write(elkObjectAllValuesFrom);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectComplementOf elkObjectComplementOf) {
        this.write("ObjectComplementOf(");
        this.write(elkObjectComplementOf.getClassExpression());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectExactCardinalityUnqualified elkObjectExactCardinality) {
        this.write("ObjectExactCardinality(");
        this.write(elkObjectExactCardinality);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectExactCardinalityQualified elkObjectExactCardinalityQualified) {
        this.write("ObjectExactCardinality(");
        this.write(elkObjectExactCardinalityQualified);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectHasSelf elkObjectHasSelf) {
        this.write("ObjectHasSelf(");
        this.write(elkObjectHasSelf);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectHasValue elkObjectHasValue) {
        this.write("ObjectHasValue(");
        this.write(elkObjectHasValue);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectIntersectionOf elkObjectIntersectionOf) {
        this.write("ObjectIntersectionOf(");
        this.write(elkObjectIntersectionOf.getClassExpressions());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectInverseOf elkObjectInverseOf) {
        this.write("ObjectInverseOf(");
        this.write(elkObjectInverseOf.getObjectProperty());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectMaxCardinalityUnqualified elkObjectMaxCardinality) {
        this.write("ObjectMaxCardinality(");
        this.write(elkObjectMaxCardinality);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectMaxCardinalityQualified elkObjectMaxCardinalityQualified) {
        this.write("ObjectMaxCardinality(");
        this.write(elkObjectMaxCardinalityQualified);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectMinCardinalityUnqualified elkObjectMinCardinality) {
        this.write("ObjectMinCardinality(");
        this.write(elkObjectMinCardinality);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectMinCardinalityQualified elkObjectMinCardinalityQualified) {
        this.write("ObjectMinCardinality(");
        this.write(elkObjectMinCardinalityQualified);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectOneOf elkObjectOneOf) {
        this.write("ObjectOneOf(");
        this.write(elkObjectOneOf.getIndividuals());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectProperty elkObjectProperty) {
        this.write(elkObjectProperty);
        return null;
    }

    @Override
    public Void visit(ElkObjectPropertyAssertionAxiom elkObjectPropertyAssertionAxiom) {
        this.write("ObjectPropertyAssertion(");
        this.write(elkObjectPropertyAssertionAxiom);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectPropertyChain elkObjectPropertyChain) {
        this.write("ObjectPropertyChain(");
        this.write(elkObjectPropertyChain.getObjectPropertyExpressions());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectPropertyDomainAxiom elkObjectPropertyDomainAxiom) {
        this.write("ObjectPropertyDomain(");
        this.write(elkObjectPropertyDomainAxiom);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectPropertyRangeAxiom elkObjectPropertyRangeAxiom) {
        this.write("ObjectPropertyRange(");
        this.write(elkObjectPropertyRangeAxiom);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectSomeValuesFrom elkObjectSomeValuesFrom) {
        this.write("ObjectSomeValuesFrom(");
        this.write(elkObjectSomeValuesFrom);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkObjectUnionOf elkObjectUnionOf) {
        this.write("ObjectUnionOf(");
        this.write(elkObjectUnionOf.getClassExpressions());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkReflexiveObjectPropertyAxiom elkReflexiveObjectPropertyAxiom) {
        this.write("ReflexiveObjectProperty(");
        this.write(elkReflexiveObjectPropertyAxiom);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkSameIndividualAxiom elkSameIndividualAxiom) {
        this.write("SameIndividual(");
        this.write(elkSameIndividualAxiom.getIndividuals());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkSubClassOfAxiom elkSubClassOfAxiom) {
        this.write("SubClassOf(");
        this.write(elkSubClassOfAxiom.getSubClassExpression());
        this.write(' ');
        this.write(elkSubClassOfAxiom.getSuperClassExpression());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkSubDataPropertyOfAxiom elkSubDataPropertyOfAxiom) {
        this.write("SubDataPropertyOf(");
        this.write(elkSubDataPropertyOfAxiom.getSubDataPropertyExpression());
        this.write(' ');
        this.write(elkSubDataPropertyOfAxiom.getSuperDataPropertyExpression());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkSubObjectPropertyOfAxiom elkSubObjectPropertyOfAxiom) {
        this.write("SubObjectPropertyOf(");
        this.write(elkSubObjectPropertyOfAxiom.getSubObjectPropertyExpression());
        this.write(' ');
        this.write(elkSubObjectPropertyOfAxiom.getSuperObjectPropertyExpression());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkSymmetricObjectPropertyAxiom elkSymmetricObjectPropertyAxiom) {
        this.write("SymmetricObjectProperty(");
        this.write(elkSymmetricObjectPropertyAxiom);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkTransitiveObjectPropertyAxiom elkTransitiveObjectPropertyAxiom) {
        this.write("TransitiveObjectProperty(");
        this.write(elkTransitiveObjectPropertyAxiom);
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkHasKeyAxiom elkHasKey) {
        this.write("HasKey( ");
        this.write(elkHasKey.getClassExpression());
        this.write(" ( ");
        this.write(elkHasKey.getObjectPropertyExpressions());
        this.write(" )( ");
        this.write(elkHasKey.getDataPropertyExpressions());
        this.write(" )) ");
        return null;
    }

    @Override
    public Void visit(ElkDatatypeDefinitionAxiom elkDatatypeDefn) {
        this.write("DatatypeDefinition( ");
        this.write(elkDatatypeDefn.getDatatype());
        this.write(" ");
        this.write(elkDatatypeDefn.getDataRange());
        this.write(" )");
        return null;
    }

    @Override
    public Void visit(ElkAnnotationAssertionAxiom annAssertionAxiom) {
        this.write("AnnotationAssertion( ");
        this.write(annAssertionAxiom.getProperty());
        this.write(' ');
        this.write(annAssertionAxiom.getSubject());
        this.write(' ');
        this.write(annAssertionAxiom.getValue());
        this.write(" )");
        return null;
    }

    @Override
    public Void visit(ElkFullIri iri) {
        this.write(iri.toString());
        return null;
    }

    @Override
    public Void visit(ElkAbbreviatedIri iri) {
        this.write(this.expandAbbreviatedIris ? "<" + iri.getFullIriAsString() + ">" : iri.toString());
        return null;
    }

    @Override
    public Void visit(ElkSubAnnotationPropertyOfAxiom subAnnotationPropertyOfAxiom) {
        this.write("SubAnnotationPropertyOf(");
        this.write(subAnnotationPropertyOfAxiom.getSubAnnotationProperty());
        this.write(' ');
        this.write(subAnnotationPropertyOfAxiom.getSuperAnnotationProperty());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkAnnotationPropertyDomainAxiom annotationPropertyDomainAxiom) {
        this.write("AnnotationPropertyDomain(");
        this.write((ElkEntity)annotationPropertyDomainAxiom.getProperty());
        this.write(' ');
        this.write((ElkObject)annotationPropertyDomainAxiom.getDomain());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkAnnotationPropertyRangeAxiom annotationPropertyRangeAxiom) {
        this.write("AnnotationPropertyRange(");
        this.write((ElkEntity)annotationPropertyRangeAxiom.getProperty());
        this.write(' ');
        this.write((ElkObject)annotationPropertyRangeAxiom.getRange());
        this.write(')');
        return null;
    }

    @Override
    public Void visit(ElkAnnotation elkAnnotation) {
        this.write("Annotation(");
        this.write(elkAnnotation.getProperty());
        this.write(' ');
        this.write(elkAnnotation.getValue());
        this.write(')');
        return null;
    }

    private final void write(char ch) {
        try {
            this.writer.append(ch);
        }
        catch (IOException e) {
            throw new PrintingException(e.getMessage(), e.getCause());
        }
    }

    private final void write(ElkEntity elkEntity) {
        this.write(elkEntity.getIri());
    }

    private final void write(ElkObject elkObject) {
        elkObject.accept(this);
    }

    private final void write(Integer n) {
        try {
            this.writer.append(n.toString());
        }
        catch (IOException e) {
            throw new PrintingException(e.getMessage(), e.getCause());
        }
    }

    private final void write(Iterable<? extends ElkObject> elkObjects) {
        boolean first = true;
        for (ElkObject elkObject : elkObjects) {
            if (!first) {
                this.write(' ');
            } else {
                first = false;
            }
            this.write(elkObject);
        }
    }

    private final void write(String string) {
        try {
            this.writer.append(string);
        }
        catch (IOException e) {
            throw new PrintingException(e.getMessage(), e.getCause());
        }
    }

    private final <P extends ElkObject> void write(ElkPropertyRestriction<P> elkPropertyRestriction) {
        this.write((ElkObject)elkPropertyRestriction.getProperty());
    }

    private final <P extends ElkObject> void write(ElkPropertyAxiom<P> elkPropertyAxiom) {
        this.write((ElkObject)elkPropertyAxiom.getProperty());
    }

    private final <P extends ElkObject, F extends ElkObject> void write(ElkPropertyRestrictionQualified<P, F> elkQualifiedPropertyRestriction) {
        this.write((ElkPropertyRestriction<P>)elkQualifiedPropertyRestriction);
        this.write(' ');
        this.write((ElkObject)elkQualifiedPropertyRestriction.getFiller());
    }

    private final <P extends ElkObject> void write(ElkCardinalityRestriction<P> elkCardinalityRestriction) {
        this.write(elkCardinalityRestriction.getCardinality());
        this.write(' ');
        this.write((ElkPropertyRestriction<P>)elkCardinalityRestriction);
    }

    private final <P extends ElkObject, F extends ElkObject> void write(ElkCardinalityRestrictionQualified<P, F> elkQualifiedCardinalityRestriction) {
        this.write((ElkCardinalityRestriction<P>)elkQualifiedCardinalityRestriction);
        this.write(' ');
        this.write((ElkObject)elkQualifiedCardinalityRestriction.getFiller());
    }

    private final <P extends ElkObject, O extends ElkObject, R extends ElkObject> void write(ElkPropertyAssertionAxiom<P, O, R> elkPropertyAssertionAxiom) {
        this.write((ElkPropertyAxiom<P>)elkPropertyAssertionAxiom);
        this.write(' ');
        this.write((ElkObject)elkPropertyAssertionAxiom.getSubject());
        this.write(' ');
        this.write((ElkObject)elkPropertyAssertionAxiom.getObject());
    }

    private final <P extends ElkObject, D extends ElkObject> void write(ElkPropertyDomainAxiom<P, D> elkPropertyDomainAxiom) {
        this.write((ElkPropertyAxiom<P>)elkPropertyDomainAxiom);
        this.write(' ');
        this.write((ElkObject)elkPropertyDomainAxiom.getDomain());
    }

    private final <P extends ElkObject, R extends ElkObject> void write(ElkPropertyRangeAxiom<P, R> elkPropertyRangeAxiom) {
        this.write((ElkPropertyAxiom<P>)elkPropertyRangeAxiom);
        this.write(' ');
        this.write((ElkObject)elkPropertyRangeAxiom.getRange());
    }

    @Override
    public Void visit(ElkSWRLRule rule) {
        this.write("DLSafeRule(  )");
        return null;
    }

    class EntityPrinter
    implements ElkEntityVisitor<Void> {
        EntityPrinter() {
        }

        @Override
        public Void visit(ElkAnnotationProperty elkAnnotationProperty) {
            OwlFunctionalStylePrinterVisitor.this.write("AnnotationProperty(");
            OwlFunctionalStylePrinterVisitor.this.write(elkAnnotationProperty);
            OwlFunctionalStylePrinterVisitor.this.write(')');
            return null;
        }

        @Override
        public Void visit(ElkClass elkClass) {
            OwlFunctionalStylePrinterVisitor.this.write("Class(");
            OwlFunctionalStylePrinterVisitor.this.write(elkClass);
            OwlFunctionalStylePrinterVisitor.this.write(')');
            return null;
        }

        @Override
        public Void visit(ElkDataProperty elkDataProperty) {
            OwlFunctionalStylePrinterVisitor.this.write("DataProperty(");
            OwlFunctionalStylePrinterVisitor.this.write(elkDataProperty);
            OwlFunctionalStylePrinterVisitor.this.write(')');
            return null;
        }

        @Override
        public Void visit(ElkDatatype elkDatatype) {
            OwlFunctionalStylePrinterVisitor.this.write("Datatype(");
            OwlFunctionalStylePrinterVisitor.this.write(elkDatatype);
            OwlFunctionalStylePrinterVisitor.this.write(')');
            return null;
        }

        @Override
        public Void visit(ElkNamedIndividual elkNamedIndividual) {
            OwlFunctionalStylePrinterVisitor.this.write("NamedIndividual(");
            OwlFunctionalStylePrinterVisitor.this.write(elkNamedIndividual);
            OwlFunctionalStylePrinterVisitor.this.write(')');
            return null;
        }

        @Override
        public Void visit(ElkObjectProperty elkObjectProperty) {
            OwlFunctionalStylePrinterVisitor.this.write("ObjectProperty(");
            OwlFunctionalStylePrinterVisitor.this.write(elkObjectProperty);
            OwlFunctionalStylePrinterVisitor.this.write(')');
            return null;
        }
    }
}

