/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.metrics;

import java.util.HashSet;
import java.util.List;
import org.semanticweb.owlapi.metrics.IntegerValuedMetric;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.NamedConjunctChecker;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class NumberOfClassesWithMultipleInheritance
extends IntegerValuedMetric {
    public NumberOfClassesWithMultipleInheritance(OWLOntology o) {
        super(o);
    }

    @Override
    public String getName() {
        return "Number of classes with asserted multiple inheritance";
    }

    @Override
    public Integer recomputeMetric() {
        HashSet<OWLClass> processed = new HashSet<OWLClass>();
        HashSet<OWLClass> clses = new HashSet<OWLClass>();
        NamedConjunctChecker checker = new NamedConjunctChecker();
        for (OWLOntology ont : OWLAPIStreamUtils.asList(this.getOntologies())) {
            block1: for (OWLClass cls : OWLAPIStreamUtils.asList(ont.classesInSignature())) {
                if (processed.contains(cls)) continue;
                processed.add(cls);
                int count = 0;
                for (OWLClassExpression sup : OWLAPIStreamUtils.asList(Searcher.equivalent(ont.equivalentClassesAxioms(cls), OWLClassExpression.class))) {
                    if (checker.hasNamedConjunct(sup)) {
                        ++count;
                    }
                    if (count <= 1) continue;
                    clses.add(cls);
                    continue block1;
                }
            }
        }
        return clses.size();
    }

    @Override
    protected boolean isMetricInvalidated(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !(oWLOntologyChange.getAxiom() instanceof OWLSubClassOfAxiom)) continue;
            return true;
        }
        return false;
    }
}

