/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLDatatypeImpl
extends OWLObjectImpl
implements OWLDatatype {
    private final IRI iri;
    private final boolean top;
    private final boolean builtin;

    public OWLDatatypeImpl(IRI iri) {
        this.iri = OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null");
        this.top = iri.equals(OWLRDFVocabulary.RDFS_LITERAL.getIRI());
        this.builtin = this.top || OWL2Datatype.isBuiltIn(iri) || iri.equals(OWLRDFVocabulary.RDF_PLAIN_LITERAL.getIRI());
    }

    @Override
    public boolean isTopEntity() {
        return this.top;
    }

    @Override
    public boolean isRDFPlainLiteral() {
        return this.iri.isPlainLiteral();
    }

    @Override
    public String toStringID() {
        return this.iri.toString();
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    @Override
    public boolean isBuiltIn() {
        return this.builtin;
    }

    @Override
    public OWL2Datatype getBuiltInDatatype() {
        if (!this.builtin) {
            throw new OWLRuntimeException(this.iri + " is not a built in datatype.  The getBuiltInDatatype() method should only be called on built in datatypes.");
        }
        return OWL2Datatype.getDatatype(this.iri);
    }

    @Override
    public boolean isDouble() {
        return this.iri.equals(OWL2Datatype.XSD_DOUBLE.getIRI());
    }

    @Override
    public boolean isFloat() {
        return this.iri.equals(OWL2Datatype.XSD_FLOAT.getIRI());
    }

    @Override
    public boolean isInteger() {
        return this.iri.equals(OWL2Datatype.XSD_INTEGER.getIRI());
    }

    @Override
    public boolean isString() {
        return this.iri.equals(OWL2Datatype.XSD_STRING.getIRI());
    }

    @Override
    public boolean isBoolean() {
        return this.iri.equals(OWL2Datatype.XSD_BOOLEAN.getIRI());
    }

    @Override
    public boolean isTopDatatype() {
        return this.top;
    }

    @Override
    public boolean isOWLDatatype() {
        return true;
    }
}

