/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.BitUtil;
import com.carrotsearch.hppcrt.BufferAllocationException;

public final class HashContainers {
    public static final int MAX_HASH_ARRAY_LENGTH = 0x40000000;
    public static final int MIN_HASH_ARRAY_LENGTH = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final double MIN_LOAD_FACTOR = 0.1;
    public static final double MAX_LOAD_FACTOR = 0.9;

    private HashContainers() {
    }

    public static int maxElements(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.1, 0.9);
        return HashContainers.expandAtCount(0x40000000, loadFactor) - 1;
    }

    public static int minBufferSize(int elements, double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.1, 0.9);
        long length = (long)((double)elements / loadFactor) + 2L;
        length = Math.max(8L, BitUtil.nextHighestPowerOfTwo(length));
        if (length > 0x40000000L) {
            throw new BufferAllocationException("Maximum array size exceeded for this load factor (elements: %d, load factor: %f)", elements, loadFactor);
        }
        return (int)length;
    }

    public static int nextBufferSize(int arraySize, int elements, double loadFactor) {
        HashContainers.checkPowerOfTwo(arraySize);
        if (arraySize == 0x40000000) {
            throw new BufferAllocationException("Maximum array size exceeded for this load factor (elements: %d, load factor: %f)", elements, loadFactor);
        }
        return arraySize << 1;
    }

    public static int expandAtCount(int arraySize, double loadFactor) {
        HashContainers.checkPowerOfTwo(arraySize);
        return Math.min(arraySize - 1, (int)Math.ceil((double)arraySize * loadFactor));
    }

    private static void checkLoadFactor(double loadFactor, double minAllowedInclusive, double maxAllowedInclusive) {
        if (loadFactor < minAllowedInclusive || loadFactor > maxAllowedInclusive) {
            throw new BufferAllocationException("The load factor should be in range [%.2f, %.2f]: %f", minAllowedInclusive, maxAllowedInclusive, loadFactor);
        }
    }

    private static void checkPowerOfTwo(int arraySize) {
        if (BitUtil.nextHighestPowerOfTwo(arraySize) != arraySize) {
            throw new IllegalArgumentException("arraySize must be a power of two !");
        }
    }
}

