/*
 * Decompiled with CFR 0.152.
 */
package openllet.aterm.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.Logger;
import openllet.shared.tools.Log;

public class BufferedOutputStreamWriter
extends Writer {
    public static final Logger _logger = Log.getLogger(BufferedOutputStreamWriter.class);
    private static final int DEFAULTBUFFERSIZE = 8192;
    private final OutputStream _stream;
    private byte[] _buffer = null;
    private int _bufferPos = 0;
    private int _limit = 0;
    private boolean _failures = false;

    public BufferedOutputStreamWriter(OutputStream stream) {
        this(stream, 8192);
    }

    public BufferedOutputStreamWriter(OutputStream stream, int bufferSize) {
        this._stream = stream;
        this._buffer = new byte[bufferSize];
        this._limit = this._buffer.length;
    }

    public void write(char c) {
        this._buffer[this._bufferPos++] = (byte)c;
        if (this._bufferPos == this._limit) {
            this.flush();
        }
    }

    @Override
    public void write(char[] cbuf, int offset, int length) {
        this.write(new String(cbuf, offset, length));
    }

    @Override
    public void write(String s) {
        byte[] bytes = s.getBytes();
        int bytesLeft = bytes.length;
        int startPos = 0;
        while (bytesLeft > 0) {
            int freeSpace = this._limit - this._bufferPos;
            int bytesToWrite = bytesLeft;
            if (freeSpace < bytesToWrite) {
                bytesToWrite = freeSpace;
            }
            System.arraycopy(bytes, startPos, this._buffer, this._bufferPos, bytesToWrite);
            this._bufferPos += bytesToWrite;
            if (this._bufferPos == this._limit) {
                this.flush();
            }
            bytesLeft -= bytesToWrite;
            startPos += bytesToWrite;
        }
    }

    @Override
    public void flush() {
        try {
            this._stream.write(this._buffer, 0, this._bufferPos);
            this._bufferPos = 0;
            this._stream.flush();
        }
        catch (IOException ioex) {
            this._failures = true;
            Log.error(_logger, ioex);
        }
    }

    @Override
    public void close() {
        try {
            this.flush();
            this._stream.close();
        }
        catch (IOException ioex) {
            this._failures = true;
            Log.error(_logger, ioex);
        }
    }

    public boolean hasFailed() {
        return this._failures;
    }
}

