/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.model.AtLeastConcept;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Constant;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.DatatypeRestriction;
import org.semanticweb.HermiT.model.DescriptionGraph;
import org.semanticweb.HermiT.model.ExistsDescriptionGraph;
import org.semanticweb.HermiT.model.Individual;
import org.semanticweb.HermiT.model.LiteralConcept;
import org.semanticweb.HermiT.model.Role;
import org.semanticweb.HermiT.model.Term;

public class DLOntology
implements Serializable {
    private static final long serialVersionUID = 3189937959595369812L;
    protected static final String CRLF = "\n";
    protected final String m_ontologyIRI;
    protected final Collection<DLClause> m_dlClauses;
    protected final Set<Atom> m_positiveFacts;
    protected final Set<Atom> m_negativeFacts;
    protected final boolean m_hasInverseRoles;
    protected final boolean m_hasAtMostRestrictions;
    protected final boolean m_hasNominals;
    protected final boolean m_hasDatatypes;
    protected final boolean m_isHorn;
    protected final Set<AtomicConcept> m_allAtomicConcepts;
    protected final int m_numberOfExternalConcepts;
    protected final Set<AtomicRole> m_allAtomicObjectRoles;
    protected final Set<Role> m_allComplexObjectRoles;
    protected final Set<AtomicRole> m_allAtomicDataRoles;
    protected final Set<DatatypeRestriction> m_allUnknownDatatypeRestrictions;
    protected final Set<String> m_definedDatatypeIRIs;
    protected final Set<Individual> m_allIndividuals;
    protected final Set<DescriptionGraph> m_allDescriptionGraphs;
    protected final Map<AtomicRole, Map<Individual, Set<Constant>>> m_dataPropertyAssertions;

    public DLOntology(String ontologyIRI, Collection<DLClause> dlClauses, Set<Atom> positiveFacts, Set<Atom> negativeFacts, Set<AtomicConcept> atomicConcepts, Set<AtomicRole> atomicObjectRoles, Set<Role> allComplexObjectRoles, Set<AtomicRole> atomicDataRoles, Set<DatatypeRestriction> allUnknownDatatypeRestrictions, Set<String> definedDatatypeIRIs, Set<Individual> individuals, boolean hasInverseRoles, boolean hasAtMostRestrictions, boolean hasNominals, boolean hasDatatypes) {
        Term argument;
        this.m_ontologyIRI = ontologyIRI;
        this.m_dlClauses = dlClauses;
        this.m_positiveFacts = positiveFacts;
        this.m_negativeFacts = negativeFacts;
        this.m_hasInverseRoles = hasInverseRoles;
        this.m_hasAtMostRestrictions = hasAtMostRestrictions;
        this.m_hasNominals = hasNominals;
        this.m_hasDatatypes = hasDatatypes;
        if (atomicConcepts == null) {
            this.m_allAtomicConcepts = new TreeSet<AtomicConcept>(Comparator.comparing(AtomicConcept::getIRI));
        } else {
            this.m_allAtomicConcepts = Collections.newSetFromMap(new IdentityHashMap());
            this.m_allAtomicConcepts.addAll(atomicConcepts);
        }
        int numberOfExternalConcepts = 0;
        for (AtomicConcept c : this.m_allAtomicConcepts) {
            if (Prefixes.isInternalIRI(c.getIRI())) continue;
            ++numberOfExternalConcepts;
        }
        this.m_numberOfExternalConcepts = numberOfExternalConcepts;
        this.m_allAtomicObjectRoles = atomicObjectRoles == null ? new TreeSet<AtomicRole>(Comparator.comparing(AtomicRole::getIRI)) : atomicObjectRoles;
        this.m_allComplexObjectRoles = allComplexObjectRoles == null ? new HashSet<Role>() : allComplexObjectRoles;
        this.m_allAtomicDataRoles = atomicDataRoles == null ? new TreeSet<AtomicRole>(Comparator.comparing(AtomicRole::getIRI)) : atomicDataRoles;
        this.m_allUnknownDatatypeRestrictions = allUnknownDatatypeRestrictions == null ? new HashSet<DatatypeRestriction>() : allUnknownDatatypeRestrictions;
        this.m_definedDatatypeIRIs = definedDatatypeIRIs == null ? new HashSet<String>() : definedDatatypeIRIs;
        this.m_allIndividuals = individuals == null ? new TreeSet<Individual>(Comparator.comparing(Individual::getIRI)) : individuals;
        this.m_allDescriptionGraphs = new HashSet<DescriptionGraph>();
        boolean isHorn = true;
        for (DLClause dlClause : this.m_dlClauses) {
            DLPredicate dlPredicate;
            if (dlClause.getHeadLength() > 1) {
                isHorn = false;
            }
            for (int bodyIndex = dlClause.getBodyLength() - 1; bodyIndex >= 0; --bodyIndex) {
                dlPredicate = dlClause.getBodyAtom(bodyIndex).getDLPredicate();
                this.addDLPredicate(dlPredicate);
            }
            for (int headIndex = dlClause.getHeadLength() - 1; headIndex >= 0; --headIndex) {
                dlPredicate = dlClause.getHeadAtom(headIndex).getDLPredicate();
                this.addDLPredicate(dlPredicate);
            }
        }
        this.m_isHorn = isHorn;
        this.m_dataPropertyAssertions = new HashMap<AtomicRole, Map<Individual, Set<Constant>>>();
        for (Atom atom : this.m_positiveFacts) {
            Set<Constant> constants2;
            Map<Object, Object> individualsToConstants;
            Term possibleConstant;
            this.addDLPredicate(atom.getDLPredicate());
            for (int i = 0; i < atom.getArity(); ++i) {
                argument = atom.getArgument(i);
                if (!(argument instanceof Individual)) continue;
                this.m_allIndividuals.add((Individual)argument);
            }
            if (atom.getArity() != 2 || !((possibleConstant = atom.getArgument(1)) instanceof Constant)) continue;
            Individual sourceIndividual = (Individual)atom.getArgument(0);
            assert (atom.getDLPredicate() instanceof AtomicRole);
            AtomicRole atomicRole = (AtomicRole)atom.getDLPredicate();
            if (this.m_dataPropertyAssertions.containsKey(atomicRole)) {
                individualsToConstants = this.m_dataPropertyAssertions.get(atomicRole);
            } else {
                individualsToConstants = new HashMap();
                this.m_dataPropertyAssertions.put(atomicRole, individualsToConstants);
            }
            if (individualsToConstants.containsKey(sourceIndividual)) {
                constants2 = (Set)individualsToConstants.get(sourceIndividual);
            } else {
                constants2 = new HashSet();
                individualsToConstants.put(sourceIndividual, constants2);
            }
            constants2.add((Constant)possibleConstant);
        }
        for (Atom atom : this.m_negativeFacts) {
            this.addDLPredicate(atom.getDLPredicate());
            for (int i = 0; i < atom.getArity(); ++i) {
                argument = atom.getArgument(i);
                if (!(argument instanceof Individual)) continue;
                this.m_allIndividuals.add((Individual)argument);
            }
        }
    }

    protected void addDLPredicate(DLPredicate dlPredicate) {
        if (dlPredicate instanceof AtomicConcept) {
            this.m_allAtomicConcepts.add((AtomicConcept)dlPredicate);
        } else if (dlPredicate instanceof AtLeastConcept) {
            LiteralConcept literalConcept = ((AtLeastConcept)dlPredicate).getToConcept();
            if (literalConcept instanceof AtomicConcept) {
                this.m_allAtomicConcepts.add((AtomicConcept)literalConcept);
            }
        } else if (dlPredicate instanceof DescriptionGraph) {
            this.m_allDescriptionGraphs.add((DescriptionGraph)dlPredicate);
        } else if (dlPredicate instanceof ExistsDescriptionGraph) {
            this.m_allDescriptionGraphs.add(((ExistsDescriptionGraph)dlPredicate).getDescriptionGraph());
        }
    }

    public String getOntologyIRI() {
        return this.m_ontologyIRI;
    }

    public Set<AtomicConcept> getAllAtomicConcepts() {
        return this.m_allAtomicConcepts;
    }

    public boolean containsAtomicConcept(AtomicConcept concept) {
        return this.m_allAtomicConcepts.contains(concept);
    }

    public int getNumberOfExternalConcepts() {
        return this.m_numberOfExternalConcepts;
    }

    public Set<AtomicRole> getAllAtomicObjectRoles() {
        return this.m_allAtomicObjectRoles;
    }

    public boolean containsObjectRole(AtomicRole role) {
        return this.m_allAtomicObjectRoles.contains(role);
    }

    public Set<Role> getAllComplexObjectRoles() {
        return this.m_allComplexObjectRoles;
    }

    public boolean isComplexObjectRole(Role role) {
        return this.m_allComplexObjectRoles.contains(role);
    }

    public Set<AtomicRole> getAllAtomicDataRoles() {
        return this.m_allAtomicDataRoles;
    }

    public boolean containsDataRole(AtomicRole role) {
        return this.m_allAtomicDataRoles.contains(role);
    }

    public Set<DatatypeRestriction> getAllUnknownDatatypeRestrictions() {
        return this.m_allUnknownDatatypeRestrictions;
    }

    public Set<Individual> getAllIndividuals() {
        return this.m_allIndividuals;
    }

    public boolean containsIndividual(Individual individual) {
        return this.m_allIndividuals.contains(individual);
    }

    public Set<DescriptionGraph> getAllDescriptionGraphs() {
        return this.m_allDescriptionGraphs;
    }

    public Collection<DLClause> getDLClauses() {
        return this.m_dlClauses;
    }

    public Set<Atom> getPositiveFacts() {
        return this.m_positiveFacts;
    }

    public Map<AtomicRole, Map<Individual, Set<Constant>>> getDataPropertyAssertions() {
        return this.m_dataPropertyAssertions;
    }

    public Set<Atom> getNegativeFacts() {
        return this.m_negativeFacts;
    }

    public boolean hasInverseRoles() {
        return this.m_hasInverseRoles;
    }

    public boolean hasAtMostRestrictions() {
        return this.m_hasAtMostRestrictions;
    }

    public boolean hasNominals() {
        return this.m_hasNominals;
    }

    public boolean hasDatatypes() {
        return this.m_hasDatatypes;
    }

    public boolean hasUnknownDatatypeRestrictions() {
        return !this.m_allUnknownDatatypeRestrictions.isEmpty();
    }

    public boolean isHorn() {
        return this.m_isHorn;
    }

    public Set<String> getDefinedDatatypeIRIs() {
        return this.m_definedDatatypeIRIs;
    }

    protected Set<AtomicConcept> getBodyOnlyAtomicConcepts() {
        HashSet<AtomicConcept> bodyOnlyAtomicConcepts = new HashSet<AtomicConcept>(this.m_allAtomicConcepts);
        for (DLClause dlClause : this.m_dlClauses) {
            for (int headIndex = 0; headIndex < dlClause.getHeadLength(); ++headIndex) {
                DLPredicate dlPredicate = dlClause.getHeadAtom(headIndex).getDLPredicate();
                bodyOnlyAtomicConcepts.remove(dlPredicate);
                if (!(dlPredicate instanceof AtLeastConcept)) continue;
                bodyOnlyAtomicConcepts.remove(((AtLeastConcept)dlPredicate).getToConcept());
            }
        }
        return bodyOnlyAtomicConcepts;
    }

    protected Set<AtomicRole> computeGraphAtomicRoles() {
        HashSet<AtomicRole> graphAtomicRoles = new HashSet<AtomicRole>();
        for (DescriptionGraph descriptionGraph : this.m_allDescriptionGraphs) {
            for (int edgeIndex = 0; edgeIndex < descriptionGraph.getNumberOfEdges(); ++edgeIndex) {
                DescriptionGraph.Edge edge = descriptionGraph.getEdge(edgeIndex);
                graphAtomicRoles.add(edge.getAtomicRole());
            }
        }
        boolean change = true;
        while (change) {
            change = false;
            for (DLClause dlClause : this.m_dlClauses) {
                if (!this.containsAtomicRoles(dlClause, graphAtomicRoles) || !this.addAtomicRoles(dlClause, graphAtomicRoles)) continue;
                change = true;
            }
        }
        return graphAtomicRoles;
    }

    protected boolean containsAtomicRoles(DLClause dlClause, Set<AtomicRole> roles) {
        DLPredicate dlPredicate;
        int atomIndex;
        for (atomIndex = 0; atomIndex < dlClause.getBodyLength(); ++atomIndex) {
            dlPredicate = dlClause.getBodyAtom(atomIndex).getDLPredicate();
            if (!(dlPredicate instanceof AtomicRole) || !roles.contains(dlPredicate)) continue;
            return true;
        }
        for (atomIndex = 0; atomIndex < dlClause.getHeadLength(); ++atomIndex) {
            dlPredicate = dlClause.getHeadAtom(atomIndex).getDLPredicate();
            if (!(dlPredicate instanceof AtomicRole) || !roles.contains(dlPredicate)) continue;
            return true;
        }
        return false;
    }

    protected boolean addAtomicRoles(DLClause dlClause, Set<AtomicRole> roles) {
        DLPredicate dlPredicate;
        int atomIndex;
        boolean change = false;
        for (atomIndex = 0; atomIndex < dlClause.getBodyLength(); ++atomIndex) {
            dlPredicate = dlClause.getBodyAtom(atomIndex).getDLPredicate();
            if (!(dlPredicate instanceof AtomicRole) || !roles.add((AtomicRole)dlPredicate)) continue;
            change = true;
        }
        for (atomIndex = 0; atomIndex < dlClause.getHeadLength(); ++atomIndex) {
            dlPredicate = dlClause.getHeadAtom(atomIndex).getDLPredicate();
            if (!(dlPredicate instanceof AtomicRole) || !roles.add((AtomicRole)dlPredicate)) continue;
            change = true;
        }
        return change;
    }

    /*
     * WARNING - void declaration
     */
    public String toString(Prefixes prefixes) {
        void var4_8;
        StringBuilder StringBuilder2 = new StringBuilder("Prefixes: [").append(CRLF);
        for (Map.Entry<String, String> entry : prefixes.getPrefixIRIsByPrefixName().entrySet()) {
            StringBuilder2.append("  ").append(entry.getKey()).append(" = <").append(entry.getValue()).append('>').append(CRLF);
        }
        StringBuilder2.append("]").append(CRLF).append("Deterministic DL-clauses: [").append(CRLF);
        int numDeterministicClauses = 0;
        for (DLClause dlClause : this.m_dlClauses) {
            if (dlClause.getHeadLength() > 1) continue;
            ++numDeterministicClauses;
            StringBuilder2.append("  ").append(dlClause.toString(prefixes)).append(CRLF);
        }
        StringBuilder2.append("]").append(CRLF).append("Disjunctive DL-clauses: [").append(CRLF);
        boolean bl = false;
        int numDisjunctions = 0;
        for (DLClause dlClause : this.m_dlClauses) {
            if (dlClause.getHeadLength() <= 1) continue;
            ++var4_8;
            numDisjunctions += dlClause.getHeadLength();
            StringBuilder2.append("  ").append(dlClause.toString(prefixes)).append(CRLF);
        }
        StringBuilder2.append("]").append(CRLF).append("ABox: [").append(CRLF);
        for (Atom atom : this.m_positiveFacts) {
            StringBuilder2.append("  ").append(atom.toString(prefixes)).append(CRLF);
        }
        for (Atom atom : this.m_negativeFacts) {
            StringBuilder2.append("  !").append(atom.toString(prefixes)).append(CRLF);
        }
        StringBuilder2.append("]").append(CRLF).append("Statistics: [").append(CRLF).append("  Number of deterministic clauses: " + numDeterministicClauses).append(CRLF).append("  Number of nondeterministic clauses: " + (int)var4_8).append(CRLF).append("  Number of disjunctions: " + numDisjunctions).append(CRLF).append("  Number of positive facts: " + this.m_positiveFacts.size()).append(CRLF).append("  Number of negative facts: " + this.m_negativeFacts.size()).append(CRLF).append("]");
        return StringBuilder2.toString();
    }

    public String getStatistics() {
        return this.getStatistics(null, null, null);
    }

    protected String getStatistics(Integer _numDeterministicClauses, Integer _numNondeterministicClauses, Integer _numDisjunctions) {
        int numDisjunctions;
        int numNondeterministicClauses;
        int numDeterministicClauses;
        if (_numDeterministicClauses == null || _numNondeterministicClauses == null || _numDisjunctions == null) {
            numDeterministicClauses = 0;
            numNondeterministicClauses = 0;
            numDisjunctions = 0;
            for (DLClause dlClause : this.m_dlClauses) {
                if (dlClause.getHeadLength() <= 1) {
                    ++numDeterministicClauses;
                    continue;
                }
                ++numNondeterministicClauses;
                numDisjunctions += dlClause.getHeadLength();
            }
        } else {
            numDeterministicClauses = _numDeterministicClauses;
            numNondeterministicClauses = _numNondeterministicClauses;
            numDisjunctions = _numDisjunctions;
        }
        StringBuilder StringBuilder2 = new StringBuilder("DL clauses statistics: [").append(CRLF).append("  Number of deterministic clauses: ").append(numDeterministicClauses).append(CRLF).append("  Number of nondeterministic clauses: ").append(numNondeterministicClauses).append(CRLF).append("  Overall number of disjunctions: ").append(numDisjunctions).append(CRLF).append("  Number of positive facts: ").append(this.m_positiveFacts.size()).append(CRLF).append("  Number of negative facts: ").append(this.m_negativeFacts.size()).append(CRLF).append("  Inverses: ").append(this.hasInverseRoles()).append(CRLF).append("  At-Mosts: ").append(this.hasAtMostRestrictions()).append(CRLF).append("  Datatypes: ").append(this.hasDatatypes()).append(CRLF).append("  Nominals: ").append(this.hasNominals()).append(CRLF).append("  Number of atomic concepts: ").append(this.m_allAtomicConcepts.size()).append(CRLF).append("  Number of object properties: ").append(this.m_allAtomicObjectRoles.size()).append(CRLF).append("  Number of data properties: ").append(this.m_allAtomicDataRoles.size()).append(CRLF).append("  Number of individuals: ").append(this.m_allIndividuals.size()).append(CRLF).append("]");
        return StringBuilder2.toString();
    }

    public String toString() {
        return this.toString(Prefixes.STANDARD_PREFIXES);
    }

    public void save(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.flush();
    }

    public static DLOntology load(InputStream inputStream) throws IOException {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            return (DLOntology)objectInputStream.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }
}

