/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.structural;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;

public class ExpressionManager {
    protected final OWLDataFactory m_factory;
    protected final DescriptionNNFVisitor m_descriptionNNFVisitor;
    protected final DataRangeNNFVisitor m_dataRangeNNFVisitor;
    protected final DescriptionComplementNNFVisitor m_descriptionComplementNNFVisitor;
    protected final DataRangeComplementNNFVisitor m_dataRangeComplementNNFVisitor;
    protected final DescriptionSimplificationVisitor m_descriptionSimplificationVisitor;
    protected final DataRangeSimplificationVisitor m_dataRangeSimplificationVisitor;

    public ExpressionManager(OWLDataFactory factory) {
        this.m_factory = factory;
        this.m_descriptionNNFVisitor = new DescriptionNNFVisitor();
        this.m_dataRangeNNFVisitor = new DataRangeNNFVisitor();
        this.m_descriptionComplementNNFVisitor = new DescriptionComplementNNFVisitor();
        this.m_dataRangeComplementNNFVisitor = new DataRangeComplementNNFVisitor();
        this.m_descriptionSimplificationVisitor = new DescriptionSimplificationVisitor();
        this.m_dataRangeSimplificationVisitor = new DataRangeSimplificationVisitor();
    }

    <T> List<T> transform(List<T> t, Function<T, T> f) {
        ArrayList<T> list = new ArrayList<T>(t);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, f.apply(list.get(i)));
        }
        return list;
    }

    public OWLClassExpression getNNF(OWLClassExpression description) {
        return (OWLClassExpression)description.accept((OWLClassExpressionVisitorEx)this.m_descriptionNNFVisitor);
    }

    public OWLDataRange getNNF(OWLDataRange dataRange) {
        return (OWLDataRange)dataRange.accept((OWLDataVisitorEx)this.m_dataRangeNNFVisitor);
    }

    public OWLClassExpression getComplementNNF(OWLClassExpression description) {
        return (OWLClassExpression)description.accept((OWLClassExpressionVisitorEx)this.m_descriptionComplementNNFVisitor);
    }

    public OWLDataRange getComplementNNF(OWLDataRange dataRange) {
        return (OWLDataRange)dataRange.accept((OWLDataVisitorEx)this.m_dataRangeComplementNNFVisitor);
    }

    public OWLClassExpression getSimplified(OWLClassExpression description) {
        return (OWLClassExpression)description.accept((OWLClassExpressionVisitorEx)this.m_descriptionSimplificationVisitor);
    }

    public OWLDataRange getSimplified(OWLDataRange dataRange) {
        return (OWLDataRange)dataRange.accept((OWLDataVisitorEx)this.m_dataRangeSimplificationVisitor);
    }

    protected class DataRangeSimplificationVisitor
    implements OWLDataVisitorEx<OWLDataRange> {
        protected DataRangeSimplificationVisitor() {
        }

        public OWLDataRange visit(OWLDatatype o) {
            return o;
        }

        public OWLDataRange visit(OWLDataComplementOf o) {
            OWLDataRange dataRangeSimplified = ExpressionManager.this.getSimplified(o.getDataRange());
            if (dataRangeSimplified instanceof OWLDataComplementOf) {
                return ((OWLDataComplementOf)dataRangeSimplified).getDataRange();
            }
            return ExpressionManager.this.m_factory.getOWLDataComplementOf(dataRangeSimplified);
        }

        public OWLDataRange visit(OWLDataOneOf o) {
            return o;
        }

        public OWLDataRange visit(OWLDatatypeRestriction o) {
            return o;
        }

        public OWLDataRange visit(OWLFacetRestriction o) {
            return null;
        }

        public OWLDataRange visit(OWLLiteral o) {
            return null;
        }

        public OWLDataRange visit(OWLDataIntersectionOf range) {
            ArrayList<OWLDataRange> newConjuncts = new ArrayList<OWLDataRange>();
            for (OWLDataRange dr : range.getOperandsAsList()) {
                OWLDataRange drSimplified;
                if (dr.isTopDatatype() || (drSimplified = ExpressionManager.this.getSimplified(dr)).isTopDatatype()) continue;
                if (drSimplified instanceof OWLDataIntersectionOf) {
                    newConjuncts.addAll(((OWLDataIntersectionOf)drSimplified).getOperandsAsList());
                    continue;
                }
                newConjuncts.add(drSimplified);
            }
            return ExpressionManager.this.m_factory.getOWLDataIntersectionOf(newConjuncts);
        }

        public OWLDataRange visit(OWLDataUnionOf range) {
            ArrayList<OWLDataRange> newDisjuncts = new ArrayList<OWLDataRange>();
            for (OWLDataRange dr : range.getOperandsAsList()) {
                if (dr.isTopDatatype()) {
                    return ExpressionManager.this.m_factory.getTopDatatype();
                }
                OWLDataRange drSimplified = ExpressionManager.this.getSimplified(dr);
                if (drSimplified.isTopDatatype()) {
                    return ExpressionManager.this.m_factory.getTopDatatype();
                }
                if (drSimplified instanceof OWLDataUnionOf) {
                    newDisjuncts.addAll(((OWLDataUnionOf)drSimplified).getOperandsAsList());
                    continue;
                }
                newDisjuncts.add(drSimplified);
            }
            return ExpressionManager.this.m_factory.getOWLDataUnionOf(newDisjuncts);
        }
    }

    protected class DescriptionSimplificationVisitor
    implements OWLClassExpressionVisitorEx<OWLClassExpression> {
        protected DescriptionSimplificationVisitor() {
        }

        public OWLClassExpression visit(OWLClass d) {
            return d;
        }

        public OWLClassExpression visit(OWLObjectIntersectionOf d) {
            ArrayList<OWLClassExpression> newConjuncts = new ArrayList<OWLClassExpression>();
            for (OWLClassExpression description : d.getOperandsAsList()) {
                OWLClassExpression descriptionSimplified = ExpressionManager.this.getSimplified(description);
                if (descriptionSimplified.isOWLThing()) continue;
                if (descriptionSimplified.isOWLNothing()) {
                    return ExpressionManager.this.m_factory.getOWLNothing();
                }
                if (descriptionSimplified instanceof OWLObjectIntersectionOf) {
                    newConjuncts.addAll(((OWLObjectIntersectionOf)descriptionSimplified).getOperandsAsList());
                    continue;
                }
                newConjuncts.add(descriptionSimplified);
            }
            return d;
        }

        public OWLClassExpression visit(OWLObjectUnionOf d) {
            ArrayList<OWLClassExpression> newDisjuncts = new ArrayList<OWLClassExpression>();
            for (OWLClassExpression description : d.getOperandsAsList()) {
                OWLClassExpression descriptionSimplified = ExpressionManager.this.getSimplified(description);
                if (descriptionSimplified.isOWLThing()) {
                    return ExpressionManager.this.m_factory.getOWLThing();
                }
                if (descriptionSimplified.isOWLNothing()) continue;
                if (descriptionSimplified instanceof OWLObjectUnionOf) {
                    newDisjuncts.addAll(((OWLObjectUnionOf)descriptionSimplified).getOperandsAsList());
                    continue;
                }
                newDisjuncts.add(descriptionSimplified);
            }
            return ExpressionManager.this.m_factory.getOWLObjectUnionOf(newDisjuncts);
        }

        public OWLClassExpression visit(OWLObjectComplementOf d) {
            OWLClassExpression operandSimplified = ExpressionManager.this.getSimplified(d.getOperand());
            if (operandSimplified.isOWLThing()) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (operandSimplified.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (operandSimplified instanceof OWLObjectComplementOf) {
                return ((OWLObjectComplementOf)operandSimplified).getOperand();
            }
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf(operandSimplified);
        }

        public OWLClassExpression visit(OWLObjectOneOf d) {
            return d;
        }

        public OWLClassExpression visit(OWLObjectSomeValuesFrom d) {
            OWLClassExpression filler = ExpressionManager.this.getSimplified((OWLClassExpression)d.getFiller());
            if (filler.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            return ExpressionManager.this.m_factory.getOWLObjectSomeValuesFrom(d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLObjectAllValuesFrom d) {
            OWLClassExpression filler = ExpressionManager.this.getSimplified((OWLClassExpression)d.getFiller());
            if (filler.isOWLThing()) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            return ExpressionManager.this.m_factory.getOWLObjectAllValuesFrom(d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLObjectHasValue d) {
            OWLObjectOneOf nominal = ExpressionManager.this.m_factory.getOWLObjectOneOf(new OWLIndividual[]{(OWLIndividual)d.getFiller()});
            return ExpressionManager.this.m_factory.getOWLObjectSomeValuesFrom(d.getProperty(), (OWLClassExpression)nominal);
        }

        public OWLClassExpression visit(OWLObjectHasSelf d) {
            return ExpressionManager.this.m_factory.getOWLObjectHasSelf(d.getProperty());
        }

        public OWLClassExpression visit(OWLObjectMinCardinality d) {
            OWLClassExpression filler = ExpressionManager.this.getSimplified((OWLClassExpression)d.getFiller());
            if (d.getCardinality() <= 0) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (filler.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (d.getCardinality() == 1) {
                return ExpressionManager.this.m_factory.getOWLObjectSomeValuesFrom(d.getProperty(), filler);
            }
            return ExpressionManager.this.m_factory.getOWLObjectMinCardinality(d.getCardinality(), d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLObjectMaxCardinality d) {
            OWLClassExpression filler = ExpressionManager.this.getSimplified((OWLClassExpression)d.getFiller());
            if (filler.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (d.getCardinality() <= 0) {
                return ExpressionManager.this.m_factory.getOWLObjectAllValuesFrom(d.getProperty(), (OWLClassExpression)ExpressionManager.this.m_factory.getOWLObjectComplementOf(filler));
            }
            return ExpressionManager.this.m_factory.getOWLObjectMaxCardinality(d.getCardinality(), d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLObjectExactCardinality d) {
            OWLClassExpression filler = ExpressionManager.this.getSimplified((OWLClassExpression)d.getFiller());
            if (d.getCardinality() < 0) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (d.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLObjectAllValuesFrom(d.getProperty(), (OWLClassExpression)ExpressionManager.this.m_factory.getOWLObjectComplementOf(filler));
            }
            if (filler.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            OWLObjectMinCardinality minCardinality = ExpressionManager.this.m_factory.getOWLObjectMinCardinality(d.getCardinality(), d.getProperty(), filler);
            OWLObjectMaxCardinality maxCardinality = ExpressionManager.this.m_factory.getOWLObjectMaxCardinality(d.getCardinality(), d.getProperty(), filler);
            return ExpressionManager.this.m_factory.getOWLObjectIntersectionOf(new OWLClassExpression[]{minCardinality, maxCardinality});
        }

        public OWLClassExpression visit(OWLDataSomeValuesFrom d) {
            if (this.isBottomDataRange((OWLDataRange)d.getFiller())) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (this.isBottomDataRange(ExpressionManager.this.getSimplified((OWLDataRange)d.getFiller()))) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            return ExpressionManager.this.m_factory.getOWLDataSomeValuesFrom(d.getProperty(), ExpressionManager.this.getSimplified((OWLDataRange)d.getFiller()));
        }

        public OWLClassExpression visit(OWLDataAllValuesFrom d) {
            if (((OWLDataRange)d.getFiller()).isTopDatatype()) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (ExpressionManager.this.getSimplified((OWLDataRange)d.getFiller()).isTopDatatype()) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            return ExpressionManager.this.m_factory.getOWLDataAllValuesFrom(d.getProperty(), ExpressionManager.this.getSimplified((OWLDataRange)d.getFiller()));
        }

        public OWLClassExpression visit(OWLDataHasValue d) {
            OWLDataOneOf nominal = ExpressionManager.this.m_factory.getOWLDataOneOf(new OWLLiteral[]{(OWLLiteral)d.getFiller()});
            return ExpressionManager.this.m_factory.getOWLDataSomeValuesFrom(d.getProperty(), (OWLDataRange)nominal);
        }

        public OWLClassExpression visit(OWLDataMinCardinality d) {
            if (d.getCardinality() <= 0) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (this.isBottomDataRange(ExpressionManager.this.getSimplified((OWLDataRange)d.getFiller()))) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (d.getCardinality() == 1) {
                return ExpressionManager.this.m_factory.getOWLDataSomeValuesFrom(d.getProperty(), ExpressionManager.this.getSimplified((OWLDataRange)d.getFiller()));
            }
            return ExpressionManager.this.m_factory.getOWLDataMinCardinality(d.getCardinality(), d.getProperty(), ExpressionManager.this.getSimplified((OWLDataRange)d.getFiller()));
        }

        public OWLClassExpression visit(OWLDataMaxCardinality d) {
            if (this.isBottomDataRange((OWLDataRange)d.getFiller())) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (this.isBottomDataRange(ExpressionManager.this.getSimplified((OWLDataRange)d.getFiller()))) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (d.getCardinality() <= 0) {
                return ExpressionManager.this.m_factory.getOWLDataAllValuesFrom(d.getProperty(), (OWLDataRange)ExpressionManager.this.m_factory.getOWLDataComplementOf(ExpressionManager.this.getSimplified((OWLDataRange)d.getFiller())));
            }
            return ExpressionManager.this.m_factory.getOWLDataMaxCardinality(d.getCardinality(), d.getProperty(), ExpressionManager.this.getSimplified((OWLDataRange)d.getFiller()));
        }

        public OWLClassExpression visit(OWLDataExactCardinality d) {
            if (d.getCardinality() < 0) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            OWLDataRange filler = ExpressionManager.this.getSimplified((OWLDataRange)d.getFiller());
            if (d.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLDataAllValuesFrom(d.getProperty(), (OWLDataRange)ExpressionManager.this.m_factory.getOWLDataComplementOf(filler));
            }
            if (this.isBottomDataRange(filler)) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            OWLDataMinCardinality minCardinality = ExpressionManager.this.m_factory.getOWLDataMinCardinality(d.getCardinality(), d.getProperty(), filler);
            OWLDataMaxCardinality maxCardinality = ExpressionManager.this.m_factory.getOWLDataMaxCardinality(d.getCardinality(), d.getProperty(), filler);
            return ExpressionManager.this.m_factory.getOWLObjectIntersectionOf(new OWLClassExpression[]{minCardinality, maxCardinality});
        }

        protected boolean isBottomDataRange(OWLDataRange dataRange) {
            return dataRange instanceof OWLDataComplementOf && ((OWLDataComplementOf)dataRange).getDataRange().isTopDatatype();
        }
    }

    protected class DataRangeComplementNNFVisitor
    implements OWLDataVisitorEx<OWLDataRange> {
        protected DataRangeComplementNNFVisitor() {
        }

        public OWLDataRange visit(OWLDatatype o) {
            return ExpressionManager.this.m_factory.getOWLDataComplementOf((OWLDataRange)o);
        }

        public OWLDataRange visit(OWLDataComplementOf o) {
            return ExpressionManager.this.getNNF(o.getDataRange());
        }

        public OWLDataRange visit(OWLDataOneOf o) {
            return ExpressionManager.this.m_factory.getOWLDataComplementOf((OWLDataRange)o);
        }

        public OWLDataRange visit(OWLDatatypeRestriction o) {
            return ExpressionManager.this.m_factory.getOWLDataComplementOf((OWLDataRange)o);
        }

        public OWLDataRange visit(OWLFacetRestriction o) {
            return null;
        }

        public OWLDataRange visit(OWLLiteral o) {
            return null;
        }

        public OWLDataRange visit(OWLDataIntersectionOf range) {
            return ExpressionManager.this.m_factory.getOWLDataUnionOf(range.operands().map(ExpressionManager.this::getComplementNNF));
        }

        public OWLDataRange visit(OWLDataUnionOf range) {
            return ExpressionManager.this.m_factory.getOWLDataIntersectionOf(range.operands().map(ExpressionManager.this::getComplementNNF));
        }
    }

    protected class DescriptionComplementNNFVisitor
    implements OWLClassExpressionVisitorEx<OWLClassExpression> {
        protected DescriptionComplementNNFVisitor() {
        }

        public OWLClassExpression visit(OWLClass d) {
            if (d.isOWLThing()) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (d.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf((OWLClassExpression)d);
        }

        public OWLClassExpression visit(OWLObjectIntersectionOf d) {
            List<OWLClassExpression> list = ExpressionManager.this.transform(d.getOperandsAsList(), ExpressionManager.this::getComplementNNF);
            return ExpressionManager.this.m_factory.getOWLObjectUnionOf(list);
        }

        public OWLClassExpression visit(OWLObjectUnionOf d) {
            List<OWLClassExpression> list = ExpressionManager.this.transform(d.getOperandsAsList(), ExpressionManager.this::getComplementNNF);
            return ExpressionManager.this.m_factory.getOWLObjectIntersectionOf(list);
        }

        public OWLClassExpression visit(OWLObjectComplementOf d) {
            return ExpressionManager.this.getNNF(d.getOperand());
        }

        public OWLClassExpression visit(OWLObjectOneOf d) {
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf((OWLClassExpression)d);
        }

        public OWLClassExpression visit(OWLObjectSomeValuesFrom d) {
            OWLClassExpression filler = ExpressionManager.this.getComplementNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectAllValuesFrom(d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLObjectAllValuesFrom d) {
            OWLClassExpression filler = ExpressionManager.this.getComplementNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectSomeValuesFrom(d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLObjectHasValue d) {
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf(ExpressionManager.this.getNNF((OWLClassExpression)d));
        }

        public OWLClassExpression visit(OWLObjectHasSelf d) {
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf(ExpressionManager.this.getNNF((OWLClassExpression)d));
        }

        public OWLClassExpression visit(OWLObjectMinCardinality d) {
            if (d.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            OWLClassExpression filler = ExpressionManager.this.getNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectMaxCardinality(d.getCardinality() - 1, d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLObjectMaxCardinality d) {
            OWLClassExpression filler = ExpressionManager.this.getNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectMinCardinality(d.getCardinality() + 1, d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLObjectExactCardinality d) {
            OWLClassExpression filler = ExpressionManager.this.getNNF((OWLClassExpression)d.getFiller());
            if (d.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLObjectMinCardinality(1, d.getProperty(), filler);
            }
            return ExpressionManager.this.m_factory.getOWLObjectUnionOf(Stream.of(ExpressionManager.this.m_factory.getOWLObjectMaxCardinality(d.getCardinality() - 1, d.getProperty(), filler), ExpressionManager.this.m_factory.getOWLObjectMinCardinality(d.getCardinality() + 1, d.getProperty(), filler)));
        }

        public OWLClassExpression visit(OWLDataSomeValuesFrom d) {
            OWLDataRange filler = ExpressionManager.this.getComplementNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataAllValuesFrom(d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLDataAllValuesFrom d) {
            OWLDataRange filler = ExpressionManager.this.getComplementNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataSomeValuesFrom(d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLDataHasValue d) {
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf((OWLClassExpression)d);
        }

        public OWLClassExpression visit(OWLDataMinCardinality d) {
            if (d.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            OWLDataRange filler = ExpressionManager.this.getNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataMaxCardinality(d.getCardinality() - 1, d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLDataMaxCardinality d) {
            OWLDataRange filler = ExpressionManager.this.getNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataMinCardinality(d.getCardinality() + 1, d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLDataExactCardinality d) {
            OWLDataRange filler = ExpressionManager.this.getNNF((OWLDataRange)d.getFiller());
            if (d.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLDataMinCardinality(1, d.getProperty(), filler);
            }
            return ExpressionManager.this.m_factory.getOWLObjectUnionOf(Stream.of(ExpressionManager.this.m_factory.getOWLDataMaxCardinality(d.getCardinality() - 1, d.getProperty(), filler), ExpressionManager.this.m_factory.getOWLDataMinCardinality(d.getCardinality() + 1, d.getProperty(), filler)));
        }
    }

    protected class DataRangeNNFVisitor
    implements OWLDataVisitorEx<OWLDataRange> {
        protected DataRangeNNFVisitor() {
        }

        public OWLDataRange visit(OWLDatatype o) {
            return o;
        }

        public OWLDataRange visit(OWLDataComplementOf o) {
            return ExpressionManager.this.getComplementNNF(o.getDataRange());
        }

        public OWLDataRange visit(OWLDataOneOf o) {
            return o;
        }

        public OWLDataRange visit(OWLDataRange o) {
            return o;
        }

        public OWLDataRange visit(OWLDatatypeRestriction o) {
            return o;
        }

        public OWLDataRange visit(OWLFacetRestriction node) {
            return null;
        }

        public OWLDataRange visit(OWLLiteral o) {
            return null;
        }

        public OWLDataRange visit(OWLDataIntersectionOf range) {
            return ExpressionManager.this.m_factory.getOWLDataIntersectionOf(range.operands().map(ExpressionManager.this::getNNF));
        }

        public OWLDataRange visit(OWLDataUnionOf range) {
            return ExpressionManager.this.m_factory.getOWLDataUnionOf(range.operands().map(ExpressionManager.this::getNNF));
        }
    }

    protected class DescriptionNNFVisitor
    implements OWLClassExpressionVisitorEx<OWLClassExpression> {
        protected DescriptionNNFVisitor() {
        }

        public OWLClassExpression visit(OWLClass d) {
            return d;
        }

        public OWLClassExpression visit(OWLObjectIntersectionOf d) {
            List<OWLClassExpression> list = ExpressionManager.this.transform(d.getOperandsAsList(), ExpressionManager.this::getNNF);
            return ExpressionManager.this.m_factory.getOWLObjectIntersectionOf(list);
        }

        public OWLClassExpression visit(OWLObjectUnionOf d) {
            List<OWLClassExpression> list = ExpressionManager.this.transform(d.getOperandsAsList(), ExpressionManager.this::getNNF);
            return ExpressionManager.this.m_factory.getOWLObjectUnionOf(list);
        }

        public OWLClassExpression visit(OWLObjectComplementOf d) {
            return ExpressionManager.this.getComplementNNF(d.getOperand());
        }

        public OWLClassExpression visit(OWLObjectOneOf d) {
            return d;
        }

        public OWLClassExpression visit(OWLObjectSomeValuesFrom d) {
            OWLClassExpression filler = ExpressionManager.this.getNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectSomeValuesFrom(d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLObjectAllValuesFrom d) {
            OWLClassExpression filler = ExpressionManager.this.getNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectAllValuesFrom(d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLObjectHasValue d) {
            return ExpressionManager.this.m_factory.getOWLObjectHasValue(d.getProperty(), (OWLIndividual)d.getFiller());
        }

        public OWLClassExpression visit(OWLObjectHasSelf d) {
            return ExpressionManager.this.m_factory.getOWLObjectHasSelf(d.getProperty());
        }

        public OWLClassExpression visit(OWLObjectMinCardinality d) {
            OWLClassExpression filler = ExpressionManager.this.getNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectMinCardinality(d.getCardinality(), d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLObjectMaxCardinality d) {
            OWLClassExpression filler = ExpressionManager.this.getNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectMaxCardinality(d.getCardinality(), d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLObjectExactCardinality d) {
            OWLClassExpression filler = ExpressionManager.this.getNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectExactCardinality(d.getCardinality(), d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLDataSomeValuesFrom d) {
            OWLDataRange filler = ExpressionManager.this.getNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataSomeValuesFrom(d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLDataAllValuesFrom d) {
            OWLDataRange filler = ExpressionManager.this.getNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataAllValuesFrom(d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLDataHasValue d) {
            return d;
        }

        public OWLClassExpression visit(OWLDataMinCardinality d) {
            OWLDataRange filler = ExpressionManager.this.getNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataMinCardinality(d.getCardinality(), d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLDataMaxCardinality d) {
            OWLDataRange filler = ExpressionManager.this.getNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataMaxCardinality(d.getCardinality(), d.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLDataExactCardinality d) {
            OWLDataRange filler = ExpressionManager.this.getNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataExactCardinality(d.getCardinality(), d.getProperty(), filler);
        }
    }
}

