/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.DefaultNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.jfact.OWLEntityTranslator;
import uk.ac.manchester.cs.jfact.TranslationMachinery;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleComplexExpression;

public class ComplexObjectPropertyTranslator
extends OWLEntityTranslator<OWLObjectPropertyExpression, ObjectRoleComplexExpression> {
    public ComplexObjectPropertyTranslator(ExpressionCache em, OWLDataFactory df, TranslationMachinery tr) {
        super(em, df, tr);
    }

    @Override
    @Nullable
    protected ObjectRoleComplexExpression getTopEntityPointer() {
        return this.em.objectRole((OWLEntity)this.df.getOWLObjectProperty((HasIRI)OWLRDFVocabulary.OWL_TOP_OBJECT_PROPERTY));
    }

    @Override
    @Nullable
    protected ObjectRoleComplexExpression getBottomEntityPointer() {
        return this.em.objectRole((OWLEntity)this.df.getOWLObjectProperty((HasIRI)OWLRDFVocabulary.OWL_BOTTOM_OBJECT_PROPERTY));
    }

    @Override
    protected ObjectRoleComplexExpression registerNewEntity(OWLObjectPropertyExpression entity) {
        ObjectRoleComplexExpression pointer = this.createPointerForEntity(entity);
        this.fillMaps(entity, pointer);
        OWLObjectPropertyExpression inverseentity = entity.getInverseProperty().getSimplified();
        this.fillMaps(inverseentity, this.createPointerForEntity(inverseentity));
        return pointer;
    }

    @Override
    protected ObjectRoleComplexExpression createPointerForEntity(OWLObjectPropertyExpression entity) {
        return this.em.objectRole((OWLEntity)entity.getNamedProperty());
    }

    @Override
    @Nullable
    protected OWLObjectProperty getTopEntity() {
        return this.df.getOWLTopObjectProperty();
    }

    @Override
    @Nullable
    protected OWLObjectProperty getBottomEntity() {
        return this.df.getOWLBottomObjectProperty();
    }

    @Override
    protected DefaultNode<OWLObjectPropertyExpression> createDefaultNode(Stream<OWLObjectPropertyExpression> stream) {
        return new OWLObjectPropertyNode(stream);
    }

    @Override
    protected DefaultNodeSet<OWLObjectPropertyExpression> createDefaultNodeSet(Stream<Node<OWLObjectPropertyExpression>> stream) {
        return new OWLObjectPropertyNodeSet(stream);
    }
}

