/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.DefaultNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import uk.ac.manchester.cs.jfact.OWLEntityTranslator;
import uk.ac.manchester.cs.jfact.TranslationMachinery;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;

public class ObjectPropertyTranslator
extends OWLEntityTranslator<OWLObjectPropertyExpression, ObjectRoleExpression> {
    public ObjectPropertyTranslator(ExpressionCache em, OWLDataFactory df, TranslationMachinery tr) {
        super(em, df, tr);
    }

    @Override
    @Nullable
    protected ObjectRoleExpression getTopEntityPointer() {
        return this.em.objectRole((OWLEntity)this.df.getOWLTopObjectProperty());
    }

    @Override
    @Nullable
    protected ObjectRoleExpression getBottomEntityPointer() {
        return this.em.objectRole((OWLEntity)this.df.getOWLBottomObjectProperty());
    }

    @Override
    protected ObjectRoleExpression registerNewEntity(OWLObjectPropertyExpression entity) {
        ObjectRoleExpression pointer = this.createPointerForEntity(entity);
        this.fillMaps(entity, pointer);
        OWLObjectPropertyExpression inverseentity = entity.getInverseProperty().getSimplified();
        this.fillMaps(inverseentity, this.createPointerForEntity(inverseentity));
        return pointer;
    }

    @Override
    protected ObjectRoleExpression createPointerForEntity(OWLObjectPropertyExpression entity) {
        ObjectRoleExpression p = this.em.objectRole((OWLEntity)entity.getNamedProperty());
        if (entity.isAnonymous()) {
            p = this.em.inverse(p);
        }
        return p;
    }

    @Override
    @Nullable
    protected OWLObjectProperty getTopEntity() {
        return this.df.getOWLTopObjectProperty();
    }

    @Override
    @Nullable
    protected OWLObjectProperty getBottomEntity() {
        return this.df.getOWLBottomObjectProperty();
    }

    @Override
    protected DefaultNode<OWLObjectPropertyExpression> createDefaultNode(Stream<OWLObjectPropertyExpression> stream) {
        return new OWLObjectPropertyNode(stream);
    }

    @Override
    protected DefaultNodeSet<OWLObjectPropertyExpression> createDefaultNodeSet(Stream<Node<OWLObjectPropertyExpression>> stream) {
        return new OWLObjectPropertyNodeSet(stream);
    }
}

