/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import uk.ac.manchester.cs.jfact.datatypes.AbstractDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.datatypes.NumericDatatype;
import uk.ac.manchester.cs.jfact.datatypes.OrderedDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Utils;
import uk.ac.manchester.cs.jfact.datatypes.cardinality;
import uk.ac.manchester.cs.jfact.datatypes.ordered;

class DatatypeExpressionImpl<O extends Comparable<O>>
extends AbstractDatatype<O>
implements DatatypeExpression<O> {
    @Nonnull
    private final Datatype<O> host;

    public DatatypeExpressionImpl(Datatype<O> b) {
        super(DatatypeFactory.getIndex(b.getDatatypeIRI() + "_"), b.getFacets(), Utils.generateAncestors(b.host()));
        this.host = b.host();
        this.knownNumericFacetValues.putAll(b.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.putAll(b.getKnownNonNumericFacetValues());
    }

    @Override
    public O parseValue(String s) {
        return this.host.parseValue(s);
    }

    @Override
    public boolean isInValueSpace(O l) {
        return this.host.isInValueSpace(l);
    }

    @Override
    public ordered getOrdered() {
        return this.host.getOrdered();
    }

    @Override
    public boolean getNumeric() {
        return this.host.getNumeric();
    }

    @Override
    public cardinality getCardinality() {
        return this.host.getCardinality();
    }

    @Override
    public boolean getBounded() {
        return this.host.getBounded();
    }

    @Override
    public Collection<Literal<O>> listValues() {
        return this.host.listValues();
    }

    @Override
    public Datatype<O> getHostType() {
        return this.host;
    }

    @Override
    public DatatypeExpression<O> addNumericFacet(Facet f, @Nullable Comparable<?> value) {
        if (!this.facets.contains(f)) {
            throw new IllegalArgumentException("Facet " + f + " not allowed tor datatype " + this.getHostType());
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        DatatypeExpressionImpl<O> toReturn = new DatatypeExpressionImpl<O>(this.host);
        toReturn.knownNumericFacetValues.putAll(this.knownNumericFacetValues);
        toReturn.knownNonNumericFacetValues.putAll(this.knownNonNumericFacetValues);
        if (f.equals(Facets.minExclusive) || f.equals(Facets.minInclusive)) {
            toReturn.knownNumericFacetValues.remove(Facets.minExclusive);
            toReturn.knownNumericFacetValues.remove(Facets.minInclusive);
        }
        if (f.equals(Facets.maxExclusive) || f.equals(Facets.maxInclusive)) {
            toReturn.knownNumericFacetValues.remove(Facets.maxExclusive);
            toReturn.knownNumericFacetValues.remove(Facets.maxInclusive);
        }
        toReturn.knownNumericFacetValues.put(f, value);
        return toReturn;
    }

    @Override
    public DatatypeExpression<O> addNonNumericFacet(Facet f, @Nullable Comparable<?> value) {
        if (!this.facets.contains(f)) {
            throw new IllegalArgumentException("Facet " + f + " not allowed tor datatype " + this.getHostType());
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        DatatypeExpressionImpl<O> toReturn = new DatatypeExpressionImpl<O>(this.host);
        toReturn.knownNumericFacetValues.putAll(this.knownNumericFacetValues);
        toReturn.knownNonNumericFacetValues.putAll(this.knownNonNumericFacetValues);
        toReturn.knownNonNumericFacetValues.put(f, value);
        return toReturn;
    }

    @Override
    public boolean isExpression() {
        return true;
    }

    @Override
    public boolean emptyValueSpace() {
        if (this.getNumeric()) {
            Comparable max;
            int excluded = 0;
            Comparable min = this.getNumericFacetValue(Facets.minInclusive);
            if (min == null) {
                min = this.getNumericFacetValue(Facets.minExclusive);
                ++excluded;
            }
            if ((max = this.getNumericFacetValue(Facets.maxInclusive)) == null) {
                max = this.getNumericFacetValue(Facets.maxExclusive);
                ++excluded;
            }
            return !DatatypeFactory.intervalWithValues(min, max, excluded);
        }
        return false;
    }

    @Override
    public boolean isNumericDatatype() {
        return this.host.isNumericDatatype();
    }

    @Override
    public NumericDatatype<O> asNumericDatatype() {
        return (NumericDatatype)((Object)this);
    }

    @Override
    public boolean isOrderedDatatype() {
        return this.host.isOrderedDatatype();
    }

    @Override
    public OrderedDatatype<O> asOrderedDatatype() {
        return (OrderedDatatype)((Object)this);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + '(' + this.host.toString() + "(extra facets:" + this.knownNumericFacetValues + "))";
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof DatatypeExpression) {
            DatatypeExpression datatypeExpression = (DatatypeExpression)obj;
            return this.host.equals(datatypeExpression.getHostType()) && this.knownNumericFacetValues.equals(datatypeExpression.getKnownNumericFacetValues()) && this.knownNonNumericFacetValues.equals(datatypeExpression.getKnownNonNumericFacetValues());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.host.hashCode() + this.knownNumericFacetValues.hashCode();
    }
}

