/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeCombination;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Literal;

public class DatatypeUnion
implements DatatypeCombination<DatatypeUnion, Datatype<?>> {
    private final Set<Datatype<?>> basics = new HashSet();
    private final IRI uri = DatatypeFactory.getIndex("urn:union#a").getIRI();
    private final Datatype<?> host;

    public DatatypeUnion(Datatype<?> host, Collection<Datatype<?>> list) {
        this(host);
        this.basics.addAll(list);
    }

    public DatatypeUnion(Datatype<?> host) {
        this.host = host;
    }

    @Override
    public Datatype<?> getHost() {
        return this.host;
    }

    @Override
    public Iterable<Datatype<?>> getList() {
        return this.basics;
    }

    @Override
    public DatatypeUnion add(Datatype<?> d) {
        DatatypeUnion toReturn = new DatatypeUnion(this.host, this.basics);
        toReturn.basics.add(d);
        return toReturn;
    }

    @Override
    public boolean isCompatible(Literal<?> l) {
        if (!this.host.isCompatible(l)) {
            return false;
        }
        return this.basics.stream().anyMatch(d -> d.isCompatible(l));
    }

    @Override
    public IRI getDatatypeIRI() {
        return this.uri;
    }

    @Override
    public boolean isCompatible(Datatype<?> type) {
        if (!this.host.isCompatible(type)) {
            return false;
        }
        return this.basics.stream().anyMatch(d -> d.isCompatible(type));
    }

    @Override
    public boolean isContradictory(Datatype<?> type) {
        return !this.isCompatible(type);
    }

    @Override
    public boolean emptyValueSpace() {
        return this.basics.stream().allMatch(d -> d.isExpression() && d.asExpression().emptyValueSpace());
    }

    public String toString() {
        return this.uri + "{" + this.basics + '}';
    }
}

