/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.INTEGERDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Utils;

class NONPOSITIVEINTEGERDatatype<R extends Comparable<R>>
extends INTEGERDatatype<R> {
    protected NONPOSITIVEINTEGERDatatype() {
        this((HasIRI)XSDVocabulary.NON_POSITIVE_INTEGER, Utils.generateAncestors(DatatypeFactory.INTEGER));
    }

    protected NONPOSITIVEINTEGERDatatype(HasIRI uri, Set<Datatype<?>> ancestors) {
        super(uri, ancestors);
        this.knownNonNumericFacetValues.putAll(super.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(super.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.put(Facets.whiteSpace, DatatypeFactory.WHITESPACE);
        this.knownNonNumericFacetValues.put(Facets.pattern, DatatypeFactory.NUMBER_EXPRESSION);
        this.knownNumericFacetValues.put(Facets.maxInclusive, new BigDecimal(0L));
    }

    @Override
    public R parseValue(String s) {
        BigInteger parse = new BigInteger(s);
        if (parse.compareTo(BigInteger.ZERO) > 0) {
            throw new ArithmeticException("Non positive integer required, but found: " + s);
        }
        return (R)parse;
    }
}

