/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.math.BigDecimal;
import java.util.Set;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.jfact.datatypes.AbstractNumericDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.Utils;

class REALDatatype<R extends Comparable<R>>
extends AbstractNumericDatatype<R> {
    public REALDatatype() {
        this((HasIRI)OWL2Datatype.OWL_REAL);
    }

    REALDatatype(HasIRI uri) {
        this(uri, Utils.getFacets(DatatypeFactory.MINMAX), Utils.generateAncestors(DatatypeFactory.LITERAL));
    }

    REALDatatype(HasIRI uri, Set<Facet> f, Set<Datatype<?>> ancestors) {
        super(uri, f, ancestors);
        this.knownNonNumericFacetValues.putAll(DatatypeFactory.LITERAL.getKnownNonNumericFacetValues());
        this.knownNumericFacetValues.putAll(DatatypeFactory.LITERAL.getKnownNumericFacetValues());
    }

    @Override
    public R parseValue(String s) {
        return (R)new BigDecimal(s);
    }

    @Override
    public boolean isInValueSpace(R l) {
        Comparable input;
        Comparable v;
        if (this.knownNumericFacetValues.containsKey(Facets.minExclusive)) {
            v = this.getNumericFacetValue(Facets.minExclusive);
            input = Facets.minExclusive.parseNumber(l);
            if (input.compareTo((Comparable)v) <= 0) {
                return false;
            }
        }
        if (this.knownNumericFacetValues.containsKey(Facets.minInclusive)) {
            v = this.getNumericFacetValue(Facets.minInclusive);
            input = Facets.minInclusive.parseNumber(l);
            if (input.compareTo((Comparable)v) < 0) {
                return false;
            }
        }
        if (this.knownNumericFacetValues.containsKey(Facets.maxInclusive)) {
            v = this.getNumericFacetValue(Facets.maxInclusive);
            input = Facets.maxInclusive.parseNumber(l);
            if (input.compareTo((Comparable)v) > 0) {
                return false;
            }
        }
        if (this.knownNumericFacetValues.containsKey(Facets.maxExclusive)) {
            v = this.getNumericFacetValue(Facets.maxExclusive);
            input = Facets.maxExclusive.parseNumber(l);
            if (input.compareTo((Comparable)v) >= 0) {
                return false;
            }
        }
        return true;
    }
}

