/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import uk.ac.manchester.cs.jfact.helpers.CloningVisitor;
import uk.ac.manchester.cs.jfact.helpers.DLTreeVisitor;
import uk.ac.manchester.cs.jfact.helpers.DLTreeVisitorEx;
import uk.ac.manchester.cs.jfact.helpers.LEAFDLTree;
import uk.ac.manchester.cs.jfact.helpers.ONEDLTree;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.Token;

@PortedFrom(file="dltree.h", name="TsTTree")
public abstract class DLTree
implements Serializable {
    private static final CloningVisitor cloner = new CloningVisitor();
    protected Lexeme elem;
    protected List<DLTree> children;
    protected DLTree ancestor;

    protected DLTree(Lexeme l) {
        this.elem = l;
    }

    public Token token() {
        return this.elem.getToken();
    }

    public boolean isTOP() {
        return this.elem.getToken() == Token.TOP;
    }

    public boolean isNOT() {
        return this.elem.getToken() == Token.NOT;
    }

    public boolean isBOTTOM() {
        return this.elem.getToken() == Token.BOTTOM;
    }

    public boolean isAND() {
        return this.elem.getToken() == Token.AND;
    }

    public Lexeme elem() {
        return this.elem;
    }

    public abstract DLTree getChild();

    public abstract DLTree getLeft();

    public abstract DLTree getRight();

    public DLTree getAncestor() {
        return this.ancestor;
    }

    public void addChild(@Nullable DLTree d) {
        if (d != null) {
            this.children.add(d);
            d.ancestor = this;
        }
    }

    public void addFirstChild(@Nullable DLTree d) {
        if (d != null) {
            this.children.add(0, d);
            d.ancestor = this;
        }
    }

    public void addFirstChildren(@Nullable Collection<DLTree> d) {
        if (d != null) {
            this.children.addAll(0, d);
            d.forEach(t -> {
                DLTree dLTree = t.ancestor = this;
            });
        }
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof DLTree) {
            DLTree t2 = (DLTree)obj;
            return DLTree.equalTrees(this, t2);
        }
        return false;
    }

    public String toString() {
        if (!this.getChildren().isEmpty()) {
            return "(" + this.elem + " " + this.children().map(Object::toString).collect(Collectors.joining(" ")) + ")";
        }
        return this.elem.toString();
    }

    public int hashCode() {
        return this.elem.hashCode() + (this.children == null ? 0 : this.children.hashCode());
    }

    public abstract void accept(DLTreeVisitor var1);

    public abstract <O> O accept(DLTreeVisitorEx<O> var1);

    public abstract void replace(DLTree var1, @Nullable DLTree var2);

    public List<DLTree> getChildren() {
        return this.children;
    }

    public Stream<DLTree> children() {
        return this.getChildren().stream();
    }

    public static boolean equalTrees(@Nullable DLTree t1, @Nullable DLTree t2) {
        if (t1 == null && t2 == null) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        if (t1.elem.equals(t2.elem)) {
            if (t1 instanceof LEAFDLTree) {
                return true;
            }
            if (t1 instanceof ONEDLTree) {
                return t1.getChild().equals(t2.getChild());
            }
            List<DLTree> c1 = t1.getChildren();
            List<DLTree> c2 = t2.getChildren();
            return c1.size() == c2.size() && c1.containsAll(c2) && c2.containsAll(c1);
        }
        return false;
    }

    public DLTree copy() {
        return this.accept(cloner);
    }

    public boolean isCN() {
        return this.isConst() || this.isName();
    }

    public boolean isConst() {
        return this.isTOP() || this.isBOTTOM();
    }

    public boolean isName() {
        return this.isCName() || this.token() == Token.INAME;
    }

    public boolean isCName() {
        return this.token() == Token.CNAME;
    }
}

