/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import java.io.Serializable;
import java.util.Arrays;

class SortedIntList
implements Serializable {
    protected int[] values;
    protected int size = 0;
    protected static final int DEFAULTSIZE = 16;

    SortedIntList() {
    }

    protected int insertionIndex(int key) {
        if (this.size == 0) {
            return 0;
        }
        int i = 0;
        while (i < this.size) {
            if (key > this.values[i]) {
                return i;
            }
            if (key == this.values[i]) {
                return -1;
            }
            ++i;
        }
        return this.size;
    }

    public int get(int i) {
        if (this.values != null) {
            return this.values[i];
        }
        throw new IllegalArgumentException("Illegal argument " + i + ": no such element");
    }

    protected void init() {
        this.values = new int[16];
        Arrays.fill(this.values, Integer.MIN_VALUE);
        this.size = 0;
    }

    public void add(int e) {
        int pos;
        if (this.values == null) {
            this.init();
        }
        if ((pos = this.insertionIndex(e)) < 0) {
            return;
        }
        int i = pos;
        if (i >= this.values.length || this.size >= this.values.length) {
            this.values = Arrays.copyOf(this.values, this.values.length + 16);
        }
        int j = this.size - 1;
        while (j >= i) {
            this.values[j + 1] = this.values[j];
            --j;
        }
        this.values[i] = e;
        ++this.size;
    }

    public void removeAt(int i) {
        if (this.values == null) {
            return;
        }
        if (i > -1 && i < this.size) {
            if (this.size == 1) {
                this.values = null;
                this.size = 0;
                return;
            }
            int j = i;
            while (j < this.size - 1) {
                this.values[j] = this.values[j + 1];
                ++j;
            }
            --this.size;
        }
        if (this.size == 0) {
            this.values = null;
        }
    }
}

