/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLEntity;
import uk.ac.manchester.cs.jfact.kernel.NameSet;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptOneOf;
import uk.ac.manchester.cs.jfact.kernel.dl.DataRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.IndividualName;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleName;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.IndividualExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;

public class ExpressionCache
implements Serializable {
    @PortedFrom(file="tExpressionManager.h", name="NS_C")
    private NameSet<ConceptName, OWLEntity> conceptNameset = new NameSet();
    @PortedFrom(file="tExpressionManager.h", name="NS_I")
    private NameSet<IndividualName, OWLEntity> individualNameset = new NameSet();
    @PortedFrom(file="tExpressionManager.h", name="NS_OR")
    private NameSet<ObjectRoleName, OWLEntity> objectRoleNameset = new NameSet();
    @PortedFrom(file="tExpressionManager.h", name="NS_DR")
    private NameSet<DataRoleName, OWLEntity> dataRoleNameset = new NameSet();
    @PortedFrom(file="tExpressionManager.h", name="InverseRoleCache")
    @Nonnull
    private final InverseRoleCache inverseRoleCache = new InverseRoleCache();
    @PortedFrom(file="tExpressionManager.h", name="OneOfCache")
    private final Map<IndividualExpression, ConceptExpression> oneOfCache = new HashMap<IndividualExpression, ConceptExpression>();

    @PortedFrom(file="tExpressionManager.h", name="concept")
    public ConceptName concept(OWLEntity name) {
        return this.conceptNameset.insert(name, ConceptName::new);
    }

    @PortedFrom(file="tExpressionManager.h", name="OneOf")
    public ConceptExpression oneOf(List<IndividualExpression> l) {
        if (l.size() == 1) {
            return this.oneOfCache.computeIfAbsent(l.get(0), x -> new ConceptOneOf(l));
        }
        return new ConceptOneOf<IndividualExpression>(l);
    }

    @PortedFrom(file="tExpressionManager.h", name="inverse")
    public ObjectRoleExpression inverse(ObjectRoleExpression r) {
        return this.inverseRoleCache.get(r);
    }

    @PortedFrom(file="tExpressionManager.h", name="OneOf")
    public ConceptExpression oneOf(IndividualExpression i) {
        return this.oneOf(Arrays.asList(i));
    }

    @PortedFrom(file="tExpressionManager.h", name="clearNameCache")
    public void clearNameCache() {
        this.conceptNameset.clear();
        this.objectRoleNameset.clear();
        this.dataRoleNameset.clear();
        this.individualNameset.clear();
    }

    @PortedFrom(file="tExpressionManager.h", name="clear")
    public void clear() {
        this.clearNameCache();
        this.inverseRoleCache.clear();
        this.oneOfCache.clear();
    }

    @PortedFrom(file="tExpressionManager.h", name="nConcepts")
    public int nConcepts() {
        return this.conceptNameset.size();
    }

    @PortedFrom(file="tExpressionManager.h", name="nIndividuals")
    public int nIndividuals() {
        return this.individualNameset.size();
    }

    @PortedFrom(file="tExpressionManager.h", name="nORoles")
    public int nORoles() {
        return this.objectRoleNameset.size();
    }

    @PortedFrom(file="tExpressionManager.h", name="nDRoles")
    public int nDRoles() {
        return this.dataRoleNameset.size();
    }

    @PortedFrom(file="tExpressionManager.h", name="individual")
    public IndividualName individual(OWLEntity name) {
        return this.individualNameset.insert(name, IndividualName::new);
    }

    @PortedFrom(file="tExpressionManager.h", name="ObjectRole")
    public ObjectRoleName objectRole(OWLEntity name) {
        return this.objectRoleNameset.insert(name, ObjectRoleName::new);
    }

    @PortedFrom(file="tExpressionManager.h", name="DataRole")
    public DataRoleName dataRole(OWLEntity name) {
        return this.dataRoleNameset.insert(name, DataRoleName::new);
    }

    protected static class InverseRoleCache
    implements Serializable {
        private Map<ObjectRoleExpression, ObjectRoleExpression> map;

        protected InverseRoleCache() {
        }

        public ObjectRoleExpression get(ObjectRoleExpression tail) {
            ObjectRoleExpression concat = null;
            if (this.map != null) {
                concat = this.map.get(tail);
            }
            if (concat != null) {
                return concat;
            }
            concat = this.build(tail);
            if (this.map == null) {
                this.map = new HashMap<ObjectRoleExpression, ObjectRoleExpression>();
            }
            this.map.put(tail, concat);
            return concat;
        }

        public void clear() {
            if (this.map != null) {
                this.map.clear();
            }
        }

        public ObjectRoleExpression build(ObjectRoleExpression tail) {
            return new ObjectRoleInverse(tail);
        }
    }
}

