/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.ExpressionManager;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.RoleExpression;

@PortedFrom(file="tDag2Interface.h", name="TDag2Interface")
public class TDag2Interface
implements Serializable {
    @PortedFrom(file="tDag2Interface.h", name="Dag")
    private final DLDag dag;
    @PortedFrom(file="tDag2Interface.h", name="Manager")
    private final ExpressionCache cache;
    @PortedFrom(file="tDag2Interface.h", name="TransC")
    private final List<ConceptExpression> transConcept = new ArrayList<ConceptExpression>();
    @PortedFrom(file="tDag2Interface.h", name="TransD")
    private final List<DataExpression> transData = new ArrayList<DataExpression>();

    public TDag2Interface(DLDag dag, ExpressionCache manager) {
        this.dag = dag;
        this.cache = manager;
        Helper.resize(this.transConcept, dag.size(), null);
        Helper.resize(this.transData, dag.size(), null);
    }

    @PortedFrom(file="tDag2Interface.h", name="buildCExpr")
    public ConceptExpression buildCExpr(DLVertex v) {
        switch (v.getType()) {
            case TOP: {
                return ExpressionManager.top();
            }
            case PCONCEPT: 
            case NCONCEPT: {
                return this.cache.concept(v.getConcept().getEntity().getEntity());
            }
            case PSINGLETON: 
            case NSINGLETON: {
                return this.cache.oneOf(this.cache.individual(v.getConcept().getEntity().getEntity()));
            }
            case AND: 
            case COLLECTION: {
                ArrayList<ConceptExpression> list = new ArrayList<ConceptExpression>();
                int[] nArray = v.begin();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int p = nArray[n2];
                    list.add(this.getCExpr(p));
                    ++n2;
                }
                return ExpressionManager.and(list);
            }
            case FORALL: {
                if (v.getRole().isDataRole()) {
                    return ExpressionManager.forall(this.cache.dataRole(v.getRole().getEntity().getEntity()), this.getDExpr(v.getConceptIndex()));
                }
                return ExpressionManager.forall(this.cache.objectRole(v.getRole().getEntity().getEntity()), this.getCExpr(v.getConceptIndex()));
            }
            case LE: {
                if (v.getRole().isDataRole()) {
                    return ExpressionManager.maxCardinality(v.getNumberLE(), this.cache.dataRole(v.getRole().getEntity().getEntity()), this.getDExpr(v.getConceptIndex()));
                }
                return ExpressionManager.maxCardinality(v.getNumberLE(), this.cache.objectRole(v.getRole().getEntity().getEntity()), this.getCExpr(v.getConceptIndex()));
            }
            case IRR: {
                return ExpressionManager.not(ExpressionManager.selfReference(this.cache.objectRole(v.getRole().getEntity().getEntity())));
            }
            case PROJ: 
            case NN: 
            case CHOOSE: {
                return ExpressionManager.top();
            }
        }
        throw new UnreachableSituationException();
    }

    @PortedFrom(file="tDag2Interface.h", name="buildDExpr")
    public DataExpression buildDExpr(DLVertex v) {
        switch (v.getType()) {
            case TOP: {
                return ExpressionManager.dataTop();
            }
            case DATATYPE: 
            case DATAVALUE: 
            case DATAEXPR: {
                return ExpressionManager.dataTop();
            }
            case AND: 
            case COLLECTION: {
                ArrayList<DataExpression> list = new ArrayList<DataExpression>();
                int[] nArray = v.begin();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int p = nArray[n2];
                    list.add(this.getDExpr(p));
                    ++n2;
                }
                return ExpressionManager.dataAnd(list);
            }
        }
        throw new UnreachableSituationException();
    }

    @Original
    public RoleExpression getDataRoleExpression(Role r) {
        return this.cache.dataRole(r.getEntity().getEntity());
    }

    @Original
    public RoleExpression getObjectRoleExpression(Role r) {
        return this.cache.objectRole(r.getEntity().getEntity());
    }

    @PortedFrom(file="tDag2Interface.h", name="ensureDagSize")
    public void ensureDagSize() {
        int ts;
        int ds = this.dag.size();
        if (ds == (ts = this.transConcept.size())) {
            return;
        }
        Helper.resize(this.transConcept, ds, null);
        Helper.resize(this.transData, ds, null);
    }

    @PortedFrom(file="tDag2Interface.h", name="getCExpr")
    public ConceptExpression getCExpr(int p) {
        if (p < 0) {
            return ExpressionManager.not(this.getCExpr(-p));
        }
        if (this.transConcept.get(p) == null) {
            this.transConcept.set(p, this.buildCExpr(this.dag.get(p)));
        }
        return this.transConcept.get(p);
    }

    @PortedFrom(file="tDag2Interface.h", name="getDExpr")
    public DataExpression getDExpr(int p) {
        if (p < 0) {
            return ExpressionManager.dataNot(this.getDExpr(-p));
        }
        DataExpression expression = this.transData.get(p);
        if (expression == null) {
            expression = this.buildDExpr(this.dag.get(p));
            this.transData.set(p, expression);
        }
        return expression;
    }

    @PortedFrom(file="tDag2Interface.h", name="getExpr")
    public Expression getExpr(int p, boolean data) {
        if (data) {
            return this.getDExpr(p);
        }
        return this.getCExpr(p);
    }
}

