/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.actors;

import conformance.Original;
import conformance.PortedFrom;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;
import uk.ac.manchester.cs.jfact.kernel.actors.TaxGatheringWalker;

@Original
public class ActorImpl
extends TaxGatheringWalker {
    @PortedFrom(file="Actor.h", name="isRole")
    protected boolean isRole;
    @PortedFrom(file="Actor.h", name="isStandard")
    protected boolean isStandard;
    @PortedFrom(file="Actor.h", name="interrupt")
    protected boolean interrupt;

    @Override
    @PortedFrom(file="Actor.h", name="applicable")
    protected boolean applicable(ClassifiableEntry entry) {
        if (this.isRole) {
            if (this.isStandard) {
                return true;
            }
            return entry.getId() > -1;
        }
        return entry instanceof Concept && ((Concept)entry).isSingleton() != this.isStandard;
    }

    @PortedFrom(file="Actor.h", name="fillArray")
    protected List<ClassifiableEntry> fillArray(TaxonomyVertex v) {
        ArrayList<ClassifiableEntry> array = new ArrayList<ClassifiableEntry>();
        if (this.tryEntry(v.getPrimer())) {
            array.add(v.getPrimer());
        }
        OWLAPIStreamUtils.add(array, v.synonyms().filter(this::tryEntry));
        return array;
    }

    @Override
    public boolean applicable(TaxonomyVertex v) {
        if (this.tryEntry(v.getPrimer())) {
            return true;
        }
        return v.synonyms().anyMatch(this::tryEntry);
    }

    @PortedFrom(file="Actor.h", name="needConcepts")
    public void needConcepts() {
        this.isRole = false;
        this.isStandard = true;
    }

    @PortedFrom(file="Actor.h", name="needIndividuals")
    public void needIndividuals() {
        this.isRole = false;
        this.isStandard = false;
    }

    @PortedFrom(file="Actor.h", name="needObjectRoles")
    public void needObjectRoles() {
        this.isRole = true;
        this.isStandard = true;
    }

    @PortedFrom(file="Actor.h", name="needDataRoles")
    public void needDataRoles() {
        this.isRole = true;
        this.isStandard = false;
    }

    @PortedFrom(file="Actor.h", name="setInterruptAfterFirstFound")
    public void setInterruptAfterFirstFound(boolean value) {
        this.interrupt = value;
    }

    @PortedFrom(file="Actor.h", name="getElements2D")
    public List<List<ClassifiableEntry>> getElements2D() {
        return OWLAPIStreamUtils.asList(this.found.stream().map(this::fillArray));
    }

    @PortedFrom(file="Actor.h", name="getElements1D")
    public List<ClassifiableEntry> getElements1D() {
        return OWLAPIStreamUtils.asList(this.found.stream().flatMap(p -> this.fillArray((TaxonomyVertex)p).stream()));
    }
}

