/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.modelcaches;

import conformance.PortedFrom;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheType;

@PortedFrom(file="modelCacheSingleton.h", name="modelCacheSingleton")
public class ModelCacheSingleton
extends ModelCacheInterface {
    @PortedFrom(file="modelCacheSingleton.h", name="Singleton")
    private final int singleton;

    public ModelCacheSingleton(int bp) {
        super(false);
        this.singleton = bp;
    }

    @Override
    @PortedFrom(file="modelCacheSingleton.h", name="getState")
    public ModelCacheState getState() {
        return ModelCacheState.VALID;
    }

    @PortedFrom(file="modelCacheSingleton.h", name="getValue")
    public int getValue() {
        return this.singleton;
    }

    @Override
    @PortedFrom(file="modelCacheSingleton.h", name="canMerge")
    public ModelCacheState canMerge(ModelCacheInterface p) {
        switch (p.getCacheType()) {
            case CONST: {
                return p.getState();
            }
            case SINGLETON: {
                return ((ModelCacheSingleton)p).singleton == -this.singleton ? ModelCacheState.INVALID : ModelCacheState.VALID;
            }
            case IAN: {
                return p.canMerge(this);
            }
        }
        return ModelCacheState.UNKNOWN;
    }

    @Override
    @PortedFrom(file="modelCacheSingleton.h", name="getCacheType")
    public ModelCacheType getCacheType() {
        return ModelCacheType.SINGLETON;
    }

    @Override
    @PortedFrom(file="modelCacheSingleton.h", name="logCacheEntry")
    public void logCacheEntry(int level, LogAdapter l) {
        l.print("\nSingleton cache: element ").print(this.singleton);
    }
}

