/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.options;

import conformance.PortedFrom;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.NullReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.helpers.Templates;

public class JFactReasonerConfiguration
implements OWLReasonerConfiguration,
Serializable {
    private static final String OR_SORT_SAT = "orSortSat";
    private static final String OR_SORT_SUB = "orSortSub";
    private boolean dumpQuery = false;
    private static StringOption absorptionFlags = JFactReasonerConfiguration.getOption("absorptionFlags", "BTEfCFSR");
    private boolean alwaysPreferEquals = true;
    private static StringOption orSortSub = JFactReasonerConfiguration.getOption("orSortSub", "0");
    private static StringOption orSortSat = JFactReasonerConfiguration.getOption("orSortSat", "0");
    private static final StringOption IAOEFLG = JFactReasonerConfiguration.getOption("IAOEFLG", "1263005");
    @PortedFrom(file="dlTBox.h", name="useSemanticBranching")
    private boolean useSemanticBranching = true;
    private boolean useBackjumping = true;
    private boolean verboseOutput = false;
    @PortedFrom(file="dlTBox.h", name="useLazyBlocking")
    private boolean useLazyBlocking = true;
    @PortedFrom(file="dlTBox.h", name="useAnywhereBlocking")
    private boolean useAnywhereBlocking = true;
    private boolean useCompletelyDefined = true;
    @PortedFrom(file="dlTBox.h", name="useSpecialDomains")
    private boolean useSpecialDomains = true;
    private boolean useIncrementalReasoning = false;
    @PortedFrom(file="Kernel.h", name="useAxiomSplitting")
    private boolean useAxiomSplitting = false;
    @PortedFrom(file="dlTBox.h", name="useNodeCache")
    private boolean useNodeCache = true;
    @PortedFrom(file="dlTBox.h", name="useSortedReasoning")
    private boolean useSortedReasoning = true;
    @PortedFrom(file="Kernel.h", name="allowUndefinedNames")
    private boolean allowUndefinedNames = true;
    private boolean needLogging = false;
    @PortedFrom(file="Kernel.h", name="queryAnswering")
    private boolean queryAnswering = false;
    protected static final LogAdapter empty = new LogAdapterImpl();
    private LogAdapterStream logAdapterStream;
    private final Map<String, StringOption> base = new HashMap<String, StringOption>();
    private ReasonerProgressMonitor progressMonitor = new NullReasonerProgressMonitor();
    @Nonnull
    private FreshEntityPolicy freshEntityPolicy = FreshEntityPolicy.ALLOW;
    @Nonnull
    private IndividualNodeSetPolicy individualNodeSetPolicy = IndividualNodeSetPolicy.BY_NAME;
    private long timeOut = Long.MAX_VALUE;
    private LogAdapterStream logAbsorptionAdapterStream;
    private boolean useADInModuleExtraction = true;
    private boolean useLogging = false;
    private boolean debugAbsorption = false;
    private boolean improveSaveRestoreDepset = false;
    private boolean printDagUsage = false;
    private boolean useSimpleRules = false;
    private boolean useReasoningStatistics = false;
    private boolean updaterndFromSuperRoles = false;
    private boolean useBlockingStatistics = false;
    private boolean useDynamicBackjumping = false;
    private boolean printTaxonomyInfo = false;
    private boolean debugSaveRestore = false;
    private boolean useFairness = false;
    private boolean debugSplitModules = false;
    private boolean splits = false;
    private boolean useELReasoner = false;
    private boolean useUndefinedNames = true;
    private int nSkipBeforeBlock = 0;

    public JFactReasonerConfiguration() {
        this.base.put(absorptionFlags.getOptionName(), absorptionFlags);
        this.base.put(IAOEFLG.getOptionName(), IAOEFLG);
        this.base.put(orSortSat.getOptionName(), orSortSat);
        this.base.put(orSortSub.getOptionName(), orSortSub);
    }

    public JFactReasonerConfiguration(OWLReasonerConfiguration source) {
        this();
        this.progressMonitor = source.getProgressMonitor();
        this.freshEntityPolicy = source.getFreshEntityPolicy();
        this.individualNodeSetPolicy = source.getIndividualNodeSetPolicy();
        this.timeOut = source.getTimeOut();
    }

    public JFactReasonerConfiguration(JFactReasonerConfiguration source) {
        this((OWLReasonerConfiguration)source);
        this.alwaysPreferEquals = source.alwaysPreferEquals;
        this.debugSaveRestore = source.debugSaveRestore;
        this.dumpQuery = source.dumpQuery;
        this.debugSplitModules = source.debugSplitModules;
        this.freshEntityPolicy = source.freshEntityPolicy;
        this.individualNodeSetPolicy = source.individualNodeSetPolicy;
        this.debugAbsorption = source.debugAbsorption;
        this.improveSaveRestoreDepset = source.improveSaveRestoreDepset;
        this.printDagUsage = source.printDagUsage;
        this.updaterndFromSuperRoles = source.updaterndFromSuperRoles;
        this.useDynamicBackjumping = source.useDynamicBackjumping;
        this.useFairness = source.useFairness;
        this.nSkipBeforeBlock = source.nSkipBeforeBlock;
        this.useSimpleRules = source.useSimpleRules;
        this.splits = source.splits;
        this.timeOut = source.timeOut;
        this.printTaxonomyInfo = source.printTaxonomyInfo;
        this.useBlockingStatistics = source.useBlockingStatistics;
        this.useLogging = source.useLogging;
        this.useReasoningStatistics = source.useReasoningStatistics;
        this.useADInModuleExtraction = source.useADInModuleExtraction;
        this.useAnywhereBlocking = source.useAnywhereBlocking;
        this.useAxiomSplitting = source.useAxiomSplitting;
        this.useBackjumping = source.useBackjumping;
        this.useCompletelyDefined = source.useCompletelyDefined;
        this.useELReasoner = source.useELReasoner;
        this.useIncrementalReasoning = source.useIncrementalReasoning;
        this.useLazyBlocking = source.useLazyBlocking;
        this.useSemanticBranching = source.useSemanticBranching;
        this.useSpecialDomains = source.useSpecialDomains;
        this.useUndefinedNames = source.useUndefinedNames;
        this.verboseOutput = source.verboseOutput;
    }

    public JFactReasonerConfiguration setNeedLogging(boolean b) {
        this.needLogging = b;
        return this;
    }

    public boolean isNeedLogging() {
        return this.needLogging;
    }

    public boolean isUseSortedReasoning() {
        return this.useSortedReasoning;
    }

    public JFactReasonerConfiguration setUseSortedReasoning(boolean useSortedReasoning) {
        this.useSortedReasoning = useSortedReasoning;
        return this;
    }

    public boolean isUseSpecialDomains() {
        return this.useSpecialDomains;
    }

    public JFactReasonerConfiguration setAllowUndefinedNames(boolean b) {
        this.allowUndefinedNames = b;
        return this;
    }

    public boolean isAllowUndefinedNames() {
        return this.allowUndefinedNames;
    }

    public JFactReasonerConfiguration setQueryAnswering(boolean b) {
        this.queryAnswering = b;
        return this;
    }

    public boolean isQueryAnswering() {
        return this.queryAnswering;
    }

    public JFactReasonerConfiguration setUseSpecialDomains(boolean b) {
        this.useSpecialDomains = b;
        return this;
    }

    public boolean isUseLazyBlocking() {
        return this.useLazyBlocking;
    }

    public JFactReasonerConfiguration setUseLazyBlocking(boolean b) {
        this.useLazyBlocking = b;
        return this;
    }

    public boolean getUseAnywhereBlocking() {
        return this.useAnywhereBlocking;
    }

    public JFactReasonerConfiguration setUseAnywhereBlocking(boolean b) {
        this.useAnywhereBlocking = b;
        return this;
    }

    public boolean isUseSemanticBranching() {
        return this.useSemanticBranching;
    }

    public JFactReasonerConfiguration setUseSemanticBranching(boolean b) {
        this.useSemanticBranching = b;
        return this;
    }

    @PortedFrom(file="dlTBox.h", name="setUseNodeCache")
    public JFactReasonerConfiguration setUseNodeCache(boolean val) {
        this.useNodeCache = val;
        return this;
    }

    public boolean isUseNodeCache() {
        return this.useNodeCache;
    }

    public static StringOption getOption(String name, String s) {
        return new StringOption(name, s);
    }

    private JFactReasonerConfiguration registerOption(StringOption defVal) {
        this.base.put(defVal.getOptionName(), defVal);
        return this;
    }

    public <O> O get(String name) {
        return this.base.get(name).getValue();
    }

    public String getORSortSat() {
        return (String)this.get(OR_SORT_SAT);
    }

    public JFactReasonerConfiguration setorSortSat(String defSat) {
        this.registerOption(JFactReasonerConfiguration.getOption(OR_SORT_SAT, defSat));
        return this;
    }

    public String getORSortSub() {
        return (String)this.get(OR_SORT_SUB);
    }

    public JFactReasonerConfiguration setorSortSub(String defSat) {
        this.registerOption(JFactReasonerConfiguration.getOption(OR_SORT_SUB, defSat));
        return this;
    }

    public boolean getuseBackjumping() {
        return this.useBackjumping;
    }

    public boolean getuseLazyBlocking() {
        return this.useLazyBlocking;
    }

    public boolean getuseSemanticBranching() {
        return this.useSemanticBranching;
    }

    public boolean getverboseOutput() {
        return this.verboseOutput;
    }

    public boolean getdumpQuery() {
        return this.dumpQuery;
    }

    public JFactReasonerConfiguration setdumpQuery(boolean value) {
        this.dumpQuery = value;
        return this;
    }

    public boolean getuseCompletelyDefined() {
        return this.useCompletelyDefined;
    }

    public boolean getalwaysPreferEquals() {
        return this.alwaysPreferEquals;
    }

    public String getabsorptionFlags() {
        return (String)this.get("absorptionFlags");
    }

    public String getIAOEFLG() {
        return (String)this.get("IAOEFLG");
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.freshEntityPolicy;
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.individualNodeSetPolicy;
    }

    public ReasonerProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = new ReasonerProgressMonitor(){};
        }
        return this.progressMonitor;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public JFactReasonerConfiguration setverboseOutput(boolean b) {
        this.verboseOutput = b;
        return this;
    }

    public boolean isLoggingActive() {
        return this.useLogging;
    }

    public JFactReasonerConfiguration setLoggingActive(boolean b) {
        this.useLogging = b;
        return this;
    }

    public boolean isAbsorptionLoggingActive() {
        return this.debugAbsorption;
    }

    public JFactReasonerConfiguration setAbsorptionLoggingActive(boolean b) {
        this.debugAbsorption = b;
        return this;
    }

    public boolean isImproveSaveRestoreDepset() {
        return this.improveSaveRestoreDepset;
    }

    public JFactReasonerConfiguration setImproveSaveRestoreDepset(boolean b) {
        this.improveSaveRestoreDepset = b;
        return this;
    }

    public boolean isPrintDagUsage() {
        return this.printDagUsage;
    }

    public JFactReasonerConfiguration setPrintDagUsage(boolean b) {
        this.printDagUsage = b;
        return this;
    }

    public boolean isUseSimpleRules() {
        return this.useSimpleRules;
    }

    public JFactReasonerConfiguration setUseSimpleRules(boolean b) {
        this.useSimpleRules = b;
        return this;
    }

    public boolean isUseReasoningStatistics() {
        return this.useReasoningStatistics;
    }

    public JFactReasonerConfiguration setUseReasoningStatistics(boolean b) {
        this.useReasoningStatistics = b;
        return this;
    }

    public boolean isUpdaterndFromSuperRoles() {
        return this.updaterndFromSuperRoles;
    }

    public JFactReasonerConfiguration setUpdaterndFromSuperRoles(boolean b) {
        this.updaterndFromSuperRoles = b;
        return this;
    }

    public boolean isUseBlockingStatistics() {
        return this.useBlockingStatistics;
    }

    public JFactReasonerConfiguration setUseBlockingStatistics(boolean b) {
        this.useBlockingStatistics = b;
        return this;
    }

    public boolean isUseDynamicBackjumping() {
        return this.useDynamicBackjumping;
    }

    public JFactReasonerConfiguration setUseDynamicBackjumping(boolean b) {
        this.useDynamicBackjumping = b;
        return this;
    }

    public boolean isPrintTaxonomyInfo() {
        return this.printTaxonomyInfo;
    }

    public JFactReasonerConfiguration setPrintTaxonomyInfo(boolean b) {
        this.printTaxonomyInfo = b;
        return this;
    }

    public boolean isDebugSaveRestore() {
        return this.debugSaveRestore;
    }

    public JFactReasonerConfiguration setDebugSaveRestore(boolean b) {
        this.debugSaveRestore = b;
        return this;
    }

    public boolean isUseFairness() {
        return this.useFairness;
    }

    public JFactReasonerConfiguration setUseFairness(boolean b) {
        this.useFairness = b;
        return this;
    }

    public int getnSkipBeforeBlock() {
        return this.nSkipBeforeBlock;
    }

    public void setnSkipBeforeBlock(int nSkipBeforeBlock) {
        this.nSkipBeforeBlock = nSkipBeforeBlock;
    }

    public boolean isDebugSplitModules() {
        return this.debugSplitModules;
    }

    public JFactReasonerConfiguration setDebugSplitModules(boolean b) {
        this.debugSplitModules = b;
        return this;
    }

    public boolean isSplits() {
        return this.splits;
    }

    public JFactReasonerConfiguration setSplits(boolean splits) {
        this.splits = splits;
        return this;
    }

    public LogAdapter getLog() {
        if (this.useLogging) {
            if (this.logAdapterStream == null) {
                this.logAdapterStream = new LogAdapterStream(System.out);
            }
            return this.logAdapterStream;
        }
        return empty;
    }

    public LogAdapter getAbsorptionLog() {
        if (this.debugAbsorption) {
            if (this.logAbsorptionAdapterStream == null) {
                this.logAbsorptionAdapterStream = new LogAdapterStream(System.out);
            }
            return this.logAbsorptionAdapterStream;
        }
        return empty;
    }

    public JFactReasonerConfiguration setAbsorptionLog(OutputStream out) {
        this.logAbsorptionAdapterStream = new LogAdapterStream(out);
        return this;
    }

    public JFactReasonerConfiguration setRegularLogOutputStream(OutputStream o) {
        this.logAdapterStream = new LogAdapterStream(o);
        return this;
    }

    public JFactReasonerConfiguration setAbsorptionLogOutputStream(OutputStream o) {
        this.logAbsorptionAdapterStream = new LogAdapterStream(o);
        return this;
    }

    public boolean isUseELReasoner() {
        return this.useELReasoner;
    }

    public JFactReasonerConfiguration setUseELReasoner(boolean useELReasoner) {
        this.useELReasoner = useELReasoner;
        return this;
    }

    public boolean isUseUndefinedNames() {
        return this.useUndefinedNames;
    }

    public JFactReasonerConfiguration setUseUndefinedNames(boolean useUndefinedNames) {
        this.useUndefinedNames = useUndefinedNames;
        return this;
    }

    public boolean isUseAxiomSplitting() {
        return this.useAxiomSplitting;
    }

    public JFactReasonerConfiguration setUseAxiomSplitting(boolean useAxiomSplitting) {
        this.useAxiomSplitting = useAxiomSplitting;
        return this;
    }

    public boolean isUseADInModuleExtraction() {
        return this.useADInModuleExtraction;
    }

    public JFactReasonerConfiguration setUseADInModuleExtraction(boolean value) {
        this.useADInModuleExtraction = value;
        return this;
    }

    public boolean isUseIncrementalReasoning() {
        return this.useIncrementalReasoning;
    }

    public JFactReasonerConfiguration setUseIncrementalReasoning(boolean useIncrementalReasoning) {
        this.useIncrementalReasoning = useIncrementalReasoning;
        return this;
    }

    static class LogAdapterImpl
    implements LogAdapter,
    Serializable {
        LogAdapterImpl() {
        }
    }

    static class LogAdapterStream
    implements LogAdapter,
    Serializable {
        private transient PrintStream out;

        public LogAdapterStream(OutputStream o) {
            this.out = new PrintStream(o);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.out = System.out;
        }

        @Override
        public LogAdapter printTemplate(Templates t, Object ... strings) {
            this.print(String.format(t.getTemplate(), strings));
            return this;
        }

        @Override
        public LogAdapter printTemplateInt(Templates t, int ... strings) {
            ArrayList<Integer> l = new ArrayList<Integer>(strings.length + 1);
            int[] nArray = strings;
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                l.add(i);
                ++n2;
            }
            this.print(String.format(t.getTemplate(), l.toArray()));
            return this;
        }

        @Override
        public LogAdapter printTemplateMixInt(Templates t, Object s, int ... strings) {
            ArrayList<Object> l = new ArrayList<Object>(strings.length + 1);
            l.add(s);
            int[] nArray = strings;
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                l.add(i);
                ++n2;
            }
            this.print(String.format(t.getTemplate(), l.toArray()));
            return this;
        }

        @Override
        public LogAdapter print(int i) {
            this.out.print(i);
            return this;
        }

        @Override
        public LogAdapter print(double i) {
            this.out.print(i);
            return this;
        }

        @Override
        public LogAdapter print(float i) {
            this.out.print(i);
            return this;
        }

        @Override
        public LogAdapter print(boolean i) {
            this.out.print(i);
            return this;
        }

        @Override
        public LogAdapter print(byte i) {
            this.print(i);
            return this;
        }

        @Override
        public LogAdapter print(char i) {
            this.print(i);
            return this;
        }

        @Override
        public LogAdapter print(short i) {
            this.print(i);
            return this;
        }

        @Override
        public LogAdapter print(String i) {
            this.out.print(i);
            this.out.flush();
            return this;
        }

        @Override
        public LogAdapter println() {
            this.print('\n');
            return this;
        }

        @Override
        public LogAdapter print(@Nullable Object s) {
            this.print(s == null ? "null" : s.toString());
            return this;
        }

        @Override
        public LogAdapter print(Object ... s) {
            Object[] objectArray = s;
            int n = s.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.print(o == null ? "null" : o.toString());
                ++n2;
            }
            return this;
        }

        @Override
        public LogAdapter print(Object s1, Object s2) {
            this.print(s1.toString());
            this.print(s2.toString());
            return this;
        }

        @Override
        public LogAdapter print(Object s1, Object s2, Object s3) {
            this.print(s1.toString());
            this.print(s2.toString());
            this.print(s3.toString());
            return this;
        }

        @Override
        public LogAdapter print(Object s1, Object s2, Object s3, Object s4) {
            this.print(s1.toString());
            this.print(s2.toString());
            this.print(s3.toString());
            this.print(s4.toString());
            return this;
        }

        @Override
        public LogAdapter print(Object s1, Object s2, Object s3, Object s4, Object s5) {
            this.print(s1.toString());
            this.print(s2.toString());
            this.print(s3.toString());
            this.print(s4.toString());
            this.print(s5.toString());
            return this;
        }
    }

    static class StringOption
    implements Serializable {
        private final String optionName;
        private final String value;

        public StringOption(String name, String defVal) {
            this.optionName = name;
            this.value = defVal;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public <O> O getValue() {
            return (O)this.value;
        }
    }
}

