/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import java.util.HashSet;
import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.exceptions.ElkRuntimeException;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationProperty;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationSubject;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationValue;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDataProperty;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkDataRange;
import org.semanticweb.elk.owl.interfaces.ElkDatatype;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkFacetRestriction;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkLiteral;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.owl.visitors.ElkObjectVisitor;
import org.semanticweb.elk.owlapi.AbstractElkObjectConverter;
import org.semanticweb.elk.owlapi.wrapper.ElkAnnotationPropertyWrap;
import org.semanticweb.elk.owlapi.wrapper.ElkAxiomWrap;
import org.semanticweb.elk.owlapi.wrapper.ElkClassExpressionWrap;
import org.semanticweb.elk.owlapi.wrapper.ElkClassWrap;
import org.semanticweb.elk.owlapi.wrapper.ElkDataPropertyExpressionWrap;
import org.semanticweb.elk.owlapi.wrapper.ElkDataPropertyWrap;
import org.semanticweb.elk.owlapi.wrapper.ElkDataRangeWrap;
import org.semanticweb.elk.owlapi.wrapper.ElkDatatypeWrap;
import org.semanticweb.elk.owlapi.wrapper.ElkEntityWrap;
import org.semanticweb.elk.owlapi.wrapper.ElkFacetRestrictionWrap;
import org.semanticweb.elk.owlapi.wrapper.ElkIndividualWrap;
import org.semanticweb.elk.owlapi.wrapper.ElkLiteralWrap;
import org.semanticweb.elk.owlapi.wrapper.ElkNamedIndividualWrap;
import org.semanticweb.elk.owlapi.wrapper.ElkObjectPropertyExpressionWrap;
import org.semanticweb.elk.owlapi.wrapper.ElkObjectPropertyWrap;
import org.semanticweb.elk.reasoner.ElkFreshEntitiesException;
import org.semanticweb.elk.reasoner.ElkInconsistentOntologyException;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.NodeFactory;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;

public class ElkConverter
extends AbstractElkObjectConverter {
    private static ElkConverter INSTANCE_ = new ElkConverter();

    public static ElkConverter getInstance() {
        return INSTANCE_;
    }

    private ElkConverter() {
    }

    @Override
    public OWLAnnotationProperty convert(ElkAnnotationProperty input) {
        if (input instanceof ElkAnnotationPropertyWrap) {
            return (OWLAnnotationProperty)((ElkAnnotationPropertyWrap)input).getOwlObject();
        }
        return this.visit(input);
    }

    @Override
    public OWLAnnotationSubject convert(ElkAnnotationSubject input) {
        return (OWLAnnotationSubject)input.accept((ElkObjectVisitor)this);
    }

    @Override
    public OWLAnnotationValue convert(ElkAnnotationValue input) {
        return (OWLAnnotationValue)input.accept((ElkObjectVisitor)this);
    }

    @Override
    public OWLAxiom convert(ElkAxiom input) {
        if (input instanceof ElkAxiomWrap) {
            return (OWLAxiom)((ElkAxiomWrap)input).getOwlObject();
        }
        return (OWLAxiom)input.accept((ElkObjectVisitor)this);
    }

    @Override
    public OWLClass convert(ElkClass input) {
        if (input instanceof ElkClassWrap) {
            return (OWLClass)((ElkClassWrap)input).getOwlObject();
        }
        return this.visit(input);
    }

    @Override
    public OWLClassExpression convert(ElkClassExpression input) {
        if (input instanceof ElkClassExpressionWrap) {
            return (OWLClassExpression)((ElkClassExpressionWrap)input).getOwlObject();
        }
        return (OWLClassExpression)input.accept((ElkObjectVisitor)this);
    }

    @Override
    public OWLDataProperty convert(ElkDataProperty input) {
        if (input instanceof ElkDataPropertyWrap) {
            return (OWLDataProperty)((ElkDataPropertyWrap)input).getOwlObject();
        }
        return this.visit(input);
    }

    @Override
    public OWLDataPropertyExpression convert(ElkDataPropertyExpression input) {
        if (input instanceof ElkDataPropertyExpressionWrap) {
            return (OWLDataPropertyExpression)((ElkDataPropertyExpressionWrap)input).getOwlObject();
        }
        return (OWLDataPropertyExpression)input.accept((ElkObjectVisitor)this);
    }

    @Override
    public OWLDataRange convert(ElkDataRange input) {
        if (input instanceof ElkDataRangeWrap) {
            return (OWLDataRange)((ElkDataRangeWrap)input).getOwlObject();
        }
        return (OWLDataRange)input.accept((ElkObjectVisitor)this);
    }

    @Override
    public OWLDatatype convert(ElkDatatype input) {
        if (input instanceof ElkDatatypeWrap) {
            return (OWLDatatype)((ElkDatatypeWrap)input).getOwlObject();
        }
        return this.visit(input);
    }

    @Override
    public OWLEntity convert(ElkEntity input) {
        if (input instanceof ElkEntityWrap) {
            return (OWLEntity)((ElkEntityWrap)input).getOwlObject();
        }
        return (OWLEntity)input.accept((ElkObjectVisitor)this);
    }

    public OWLRuntimeException convert(ElkException e) {
        if (e instanceof ElkFreshEntitiesException) {
            return this.convert((ElkFreshEntitiesException)e);
        }
        if (e instanceof ElkInconsistentOntologyException) {
            return this.convert((ElkInconsistentOntologyException)e);
        }
        if (e instanceof ElkInterruptedException) {
            return this.convert((ElkInterruptedException)e);
        }
        return new OWLRuntimeException((Throwable)e);
    }

    @Override
    public OWLFacetRestriction convert(ElkFacetRestriction input) {
        if (input instanceof ElkFacetRestrictionWrap) {
            return (OWLFacetRestriction)((ElkFacetRestrictionWrap)input).getOwlObject();
        }
        return this.visit(input);
    }

    public FreshEntitiesException convert(ElkFreshEntitiesException e) {
        HashSet<OWLEntity> owlEntities = new HashSet<OWLEntity>();
        for (ElkEntity elkEntity : e.getEntities()) {
            owlEntities.add(this.convert(elkEntity));
        }
        return new FreshEntitiesException(owlEntities);
    }

    public InconsistentOntologyException convert(ElkInconsistentOntologyException e) {
        return new InconsistentOntologyException();
    }

    @Override
    public OWLIndividual convert(ElkIndividual input) {
        if (input instanceof ElkIndividualWrap) {
            return (OWLIndividual)((ElkIndividualWrap)input).getOwlObject();
        }
        return (OWLIndividual)input.accept((ElkObjectVisitor)this);
    }

    public ReasonerInterruptedException convert(ElkInterruptedException e) {
        return new ReasonerInterruptedException((Throwable)e);
    }

    @Override
    public IRI convert(ElkIri input) {
        return (IRI)input.accept((ElkObjectVisitor)this);
    }

    @Override
    public OWLLiteral convert(ElkLiteral input) {
        if (input instanceof ElkLiteralWrap) {
            return (OWLLiteral)((ElkLiteralWrap)input).getOwlObject();
        }
        return this.visit(input);
    }

    @Override
    public OWLNamedIndividual convert(ElkNamedIndividual input) {
        if (input instanceof ElkNamedIndividualWrap) {
            return (OWLNamedIndividual)((ElkNamedIndividualWrap)input).getOwlObject();
        }
        return this.visit(input);
    }

    @Override
    public OWLObjectProperty convert(ElkObjectProperty input) {
        if (input instanceof ElkObjectPropertyWrap) {
            return (OWLObjectProperty)((ElkObjectPropertyWrap)input).getOwlObject();
        }
        return this.visit(input);
    }

    @Override
    public OWLObjectPropertyExpression convert(ElkObjectPropertyExpression input) {
        if (input instanceof ElkObjectPropertyExpressionWrap) {
            return (OWLObjectPropertyExpression)((ElkObjectPropertyExpressionWrap)input).getOwlObject();
        }
        return (OWLObjectPropertyExpression)input.accept((ElkObjectVisitor)this);
    }

    public OWLRuntimeException convert(ElkRuntimeException e) {
        return new ReasonerInternalException((Throwable)e);
    }

    public DefaultNode<OWLClass> convertClassNode(Node<ElkClass> node) {
        HashSet<OWLClass> owlClasses = new HashSet<OWLClass>();
        for (ElkClass cls : node) {
            owlClasses.add(this.convert(cls));
        }
        return NodeFactory.getOWLClassNode(owlClasses);
    }

    public OWLClassNodeSet convertClassNodes(Iterable<? extends Node<ElkClass>> nodes) {
        HashSet<DefaultNode<OWLClass>> owlNodes = new HashSet<DefaultNode<OWLClass>>();
        for (Node<ElkClass> node : nodes) {
            owlNodes.add(this.convertClassNode(node));
        }
        return new OWLClassNodeSet(owlNodes);
    }

    public DefaultNode<OWLNamedIndividual> convertIndividualNode(Node<ElkNamedIndividual> node) {
        HashSet<OWLNamedIndividual> owlIndividuals = new HashSet<OWLNamedIndividual>();
        for (ElkNamedIndividual ind : node) {
            owlIndividuals.add(this.convert(ind));
        }
        return NodeFactory.getOWLNamedIndividualNode(owlIndividuals);
    }

    public OWLNamedIndividualNodeSet convertIndividualNodes(Iterable<? extends Node<ElkNamedIndividual>> nodes) {
        HashSet<DefaultNode<OWLNamedIndividual>> owlNodes = new HashSet<DefaultNode<OWLNamedIndividual>>();
        for (Node<ElkNamedIndividual> node : nodes) {
            owlNodes.add(this.convertIndividualNode(node));
        }
        return new OWLNamedIndividualNodeSet(owlNodes);
    }

    public DefaultNode<OWLObjectPropertyExpression> convertObjectPropertyNode(Node<ElkObjectProperty> node) {
        HashSet<OWLObjectProperty> owlObjectProps = new HashSet<OWLObjectProperty>();
        for (ElkObjectProperty cls : node) {
            owlObjectProps.add(this.convert(cls));
        }
        return NodeFactory.getOWLObjectPropertyNode(owlObjectProps);
    }

    public OWLObjectPropertyNodeSet convertObjectPropertyNodes(Iterable<? extends Node<ElkObjectProperty>> nodes) {
        HashSet<DefaultNode<OWLObjectPropertyExpression>> owlNodes = new HashSet<DefaultNode<OWLObjectPropertyExpression>>();
        for (Node<ElkObjectProperty> node : nodes) {
            owlNodes.add(this.convertObjectPropertyNode(node));
        }
        return new OWLObjectPropertyNodeSet(owlNodes);
    }
}

