/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.logging.statistics;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class StatisticsPrinter {
    private static final int FORMAT_WIDTH_ = 80;
    private static final Pattern REGEXP = Pattern.compile("(%[^\\{]*)\\{([^\\.\\}]*)\\}(.)");
    private final Logger logger_;
    private final String headerFormat_;
    private final Object[] headerParams_;
    private final String valuesFormat_;
    private final int maxPaddingWidth_;

    public StatisticsPrinter(Logger logger, String pattern, Object ... sampleValues) {
        this.logger_ = logger;
        Matcher matcher = REGEXP.matcher(pattern);
        Matcher m = REGEXP.matcher(pattern);
        LinkedList<String> headers = new LinkedList<String>();
        StringBuffer headerFormatBuilder = new StringBuffer();
        StringBuffer lineFormatBuilder = new StringBuffer();
        String firstSampleValue = "";
        int i = 0;
        while (matcher.find()) {
            m.find();
            String header = matcher.group(2);
            headers.add(header);
            String formattedSample = String.format(matcher.group(1) + matcher.group(3), sampleValues[i]);
            if (i == 0) {
                firstSampleValue = formattedSample;
                matcher.appendReplacement(lineFormatBuilder, matcher.group(1) + matcher.group(3));
                m.appendReplacement(headerFormatBuilder, "%s");
            } else {
                int width = Math.max(header.length(), formattedSample.length());
                matcher.appendReplacement(lineFormatBuilder, matcher.group(1) + width + matcher.group(3));
                m.appendReplacement(headerFormatBuilder, "%" + width + "s");
            }
            ++i;
        }
        matcher.appendTail(lineFormatBuilder);
        m.appendTail(headerFormatBuilder);
        this.headerFormat_ = headerFormatBuilder.toString();
        this.headerParams_ = headers.toArray();
        this.valuesFormat_ = lineFormatBuilder.toString();
        this.maxPaddingWidth_ = 80 - String.format(this.valuesFormat_, sampleValues).length() + firstSampleValue.length();
    }

    public void printSeparator() {
        String separator = StatisticsPrinter.getString('-', 80);
        this.logger_.debug(separator);
    }

    public void printHeader() {
        this.printSeparator();
        this.addPadding(' ', this.headerParams_);
        this.logger_.debug(String.format(this.headerFormat_, this.headerParams_));
        this.printSeparator();
    }

    Object[] addPadding(char c, Object ... values) {
        String firstValue = values[0].toString();
        int paddingLength = this.maxPaddingWidth_ - firstValue.length();
        if (paddingLength > 0) {
            String padding = StatisticsPrinter.getString(c, paddingLength);
            values[0] = firstValue + padding;
        }
        return values;
    }

    public void print(Object ... values) {
        this.addPadding('.', values);
        this.logger_.debug(String.format(this.valuesFormat_, values));
    }

    static String getString(char c, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }
}

