import numpy as np
import numba
import scipy.optimize as sopt
import json

sin = np.sin
cos = np.cos
atan2 = np.arctan2
sqrt = np.sqrt 


class pv_plant_class: 

    def __init__(self): 

        self.t_end = 10.000000 
        self.Dt = 0.0010000 
        self.decimation = 10.000000 
        self.itol = 1e-6 
        self.Dt_max = 0.001000 
        self.Dt_min = 0.001000 
        self.solvern = 5 
        self.imax = 100 
        self.N_x = 78
        self.N_y = 298 
        self.N_z = 0 
        self.N_store = 10000 
        self.params_list = ['u_ctrl_v_INV_1', 'K_p_v_INV_1', 'K_i_v_INV_1', 'V_base_INV_1', 'V_base_TR_1_2_mv', 'S_base_INV_1', 'I_max_INV_1', 'u_ctrl_v_INV_2', 'K_p_v_INV_2', 'K_i_v_INV_2', 'V_base_INV_2', 'S_base_INV_2', 'I_max_INV_2', 'u_ctrl_v_INV_3', 'K_p_v_INV_3', 'K_i_v_INV_3', 'V_base_INV_3', 'V_base_TR_3_4_mv', 'S_base_INV_3', 'I_max_INV_3', 'u_ctrl_v_INV_4', 'K_p_v_INV_4', 'K_i_v_INV_4', 'V_base_INV_4', 'S_base_INV_4', 'I_max_INV_4', 'u_ctrl_v_INV_5', 'K_p_v_INV_5', 'K_i_v_INV_5', 'V_base_INV_5', 'V_base_TR_5_6_mv', 'S_base_INV_5', 'I_max_INV_5', 'u_ctrl_v_INV_6', 'K_p_v_INV_6', 'K_i_v_INV_6', 'V_base_INV_6', 'S_base_INV_6', 'I_max_INV_6', 'u_ctrl_v_INV_7', 'K_p_v_INV_7', 'K_i_v_INV_7', 'V_base_INV_7', 'V_base_TR_7_8_mv', 'S_base_INV_7', 'I_max_INV_7', 'u_ctrl_v_INV_8', 'K_p_v_INV_8', 'K_i_v_INV_8', 'V_base_INV_8', 'S_base_INV_8', 'I_max_INV_8', 'u_ctrl_v_INV_9', 'K_p_v_INV_9', 'K_i_v_INV_9', 'V_base_INV_9', 'V_base_TR_9_10_mv', 'S_base_INV_9', 'I_max_INV_9', 'u_ctrl_v_INV_10', 'K_p_v_INV_10', 'K_i_v_INV_10', 'V_base_INV_10', 'S_base_INV_10', 'I_max_INV_10', 'u_ctrl_v_INV_11', 'K_p_v_INV_11', 'K_i_v_INV_11', 'V_base_INV_11', 'V_base_TR_11_12_mv', 'S_base_INV_11', 'I_max_INV_11', 'u_ctrl_v_INV_12', 'K_p_v_INV_12', 'K_i_v_INV_12', 'V_base_INV_12', 'S_base_INV_12', 'I_max_INV_12', 'u_ctrl_v_INV_13', 'K_p_v_INV_13', 'K_i_v_INV_13', 'V_base_INV_13', 'V_base_TR_13_mv', 'S_base_INV_13', 'I_max_INV_13'] 
        self.params_values_list  = [0.0, 0.1, 0.1, 230.94010767585033, 230.94010767585033, 2000000.0, 0.5, 0.0, 0.1, 0.1, 230.94010767585033, 2000000.0, 0.5, 0.0, 0.1, 0.1, 230.94010767585033, 230.94010767585033, 2000000.0, 0.5, 0.0, 0.1, 0.1, 230.94010767585033, 2000000.0, 0.5, 0.0, 0.1, 0.1, 230.94010767585033, 230.94010767585033, 2000000.0, 0.5, 0.0, 0.1, 0.1, 230.94010767585033, 2000000.0, 0.5, 0.0, 0.1, 0.1, 230.94010767585033, 230.94010767585033, 2000000.0, 0.5, 0.0, 0.1, 0.1, 230.94010767585033, 2000000.0, 0.5, 0.0, 0.1, 0.1, 230.94010767585033, 230.94010767585033, 2000000.0, 0.5, 0.0, 0.1, 0.1, 230.94010767585033, 2000000.0, 0.5, 0.0, 0.1, 0.1, 230.94010767585033, 230.94010767585033, 2000000.0, 0.5, 0.0, 0.1, 0.1, 230.94010767585033, 2000000.0, 0.5, 0.0, 0.1, 0.1, 230.94010767585033, 230.94010767585033, 2000000.0, 0.5] 
        self.inputs_ini_list = ['v_GRID_a_r', 'v_GRID_a_i', 'v_GRID_b_r', 'v_GRID_b_i', 'v_GRID_c_r', 'v_GRID_c_i', 'i_POIhv_a_r', 'i_POIhv_a_i', 'i_POIhv_b_r', 'i_POIhv_b_i', 'i_POIhv_c_r', 'i_POIhv_c_i', 'i_POImv_a_r', 'i_POImv_a_i', 'i_POImv_b_r', 'i_POImv_b_i', 'i_POImv_c_r', 'i_POImv_c_i', 'i_TR_1_2_mv_a_r', 'i_TR_1_2_mv_a_i', 'i_TR_1_2_mv_b_r', 'i_TR_1_2_mv_b_i', 'i_TR_1_2_mv_c_r', 'i_TR_1_2_mv_c_i', 'i_TR_1_2_lv_a_r', 'i_TR_1_2_lv_a_i', 'i_TR_1_2_lv_b_r', 'i_TR_1_2_lv_b_i', 'i_TR_1_2_lv_c_r', 'i_TR_1_2_lv_c_i', 'i_TR_3_4_mv_a_r', 'i_TR_3_4_mv_a_i', 'i_TR_3_4_mv_b_r', 'i_TR_3_4_mv_b_i', 'i_TR_3_4_mv_c_r', 'i_TR_3_4_mv_c_i', 'i_TR_3_4_lv_a_r', 'i_TR_3_4_lv_a_i', 'i_TR_3_4_lv_b_r', 'i_TR_3_4_lv_b_i', 'i_TR_3_4_lv_c_r', 'i_TR_3_4_lv_c_i', 'i_TR_5_6_mv_a_r', 'i_TR_5_6_mv_a_i', 'i_TR_5_6_mv_b_r', 'i_TR_5_6_mv_b_i', 'i_TR_5_6_mv_c_r', 'i_TR_5_6_mv_c_i', 'i_TR_5_6_lv_a_r', 'i_TR_5_6_lv_a_i', 'i_TR_5_6_lv_b_r', 'i_TR_5_6_lv_b_i', 'i_TR_5_6_lv_c_r', 'i_TR_5_6_lv_c_i', 'i_TR_7_8_mv_a_r', 'i_TR_7_8_mv_a_i', 'i_TR_7_8_mv_b_r', 'i_TR_7_8_mv_b_i', 'i_TR_7_8_mv_c_r', 'i_TR_7_8_mv_c_i', 'i_TR_7_8_lv_a_r', 'i_TR_7_8_lv_a_i', 'i_TR_7_8_lv_b_r', 'i_TR_7_8_lv_b_i', 'i_TR_7_8_lv_c_r', 'i_TR_7_8_lv_c_i', 'i_TR_9_10_mv_a_r', 'i_TR_9_10_mv_a_i', 'i_TR_9_10_mv_b_r', 'i_TR_9_10_mv_b_i', 'i_TR_9_10_mv_c_r', 'i_TR_9_10_mv_c_i', 'i_TR_9_10_lv_a_r', 'i_TR_9_10_lv_a_i', 'i_TR_9_10_lv_b_r', 'i_TR_9_10_lv_b_i', 'i_TR_9_10_lv_c_r', 'i_TR_9_10_lv_c_i', 'i_TR_11_12_mv_a_r', 'i_TR_11_12_mv_a_i', 'i_TR_11_12_mv_b_r', 'i_TR_11_12_mv_b_i', 'i_TR_11_12_mv_c_r', 'i_TR_11_12_mv_c_i', 'i_TR_11_12_lv_a_r', 'i_TR_11_12_lv_a_i', 'i_TR_11_12_lv_b_r', 'i_TR_11_12_lv_b_i', 'i_TR_11_12_lv_c_r', 'i_TR_11_12_lv_c_i', 'i_TR_13_mv_a_r', 'i_TR_13_mv_a_i', 'i_TR_13_mv_b_r', 'i_TR_13_mv_b_i', 'i_TR_13_mv_c_r', 'i_TR_13_mv_c_i', 'i_TR_13_lv_a_r', 'i_TR_13_lv_a_i', 'i_TR_13_lv_b_r', 'i_TR_13_lv_b_i', 'i_TR_13_lv_c_r', 'i_TR_13_lv_c_i', 'p_ref_INV_1', 'T_pq_INV_1', 'v_loc_ref_INV_1', 'Dv_r_INV_1', 'Dq_r_INV_1', 'p_ref_INV_2', 'T_pq_INV_2', 'v_loc_ref_INV_2', 'Dv_r_INV_2', 'Dq_r_INV_2', 'p_ref_INV_3', 'T_pq_INV_3', 'v_loc_ref_INV_3', 'Dv_r_INV_3', 'Dq_r_INV_3', 'p_ref_INV_4', 'T_pq_INV_4', 'v_loc_ref_INV_4', 'Dv_r_INV_4', 'Dq_r_INV_4', 'p_ref_INV_5', 'T_pq_INV_5', 'v_loc_ref_INV_5', 'Dv_r_INV_5', 'Dq_r_INV_5', 'p_ref_INV_6', 'T_pq_INV_6', 'v_loc_ref_INV_6', 'Dv_r_INV_6', 'Dq_r_INV_6', 'p_ref_INV_7', 'T_pq_INV_7', 'v_loc_ref_INV_7', 'Dv_r_INV_7', 'Dq_r_INV_7', 'p_ref_INV_8', 'T_pq_INV_8', 'v_loc_ref_INV_8', 'Dv_r_INV_8', 'Dq_r_INV_8', 'p_ref_INV_9', 'T_pq_INV_9', 'v_loc_ref_INV_9', 'Dv_r_INV_9', 'Dq_r_INV_9', 'p_ref_INV_10', 'T_pq_INV_10', 'v_loc_ref_INV_10', 'Dv_r_INV_10', 'Dq_r_INV_10', 'p_ref_INV_11', 'T_pq_INV_11', 'v_loc_ref_INV_11', 'Dv_r_INV_11', 'Dq_r_INV_11', 'p_ref_INV_12', 'T_pq_INV_12', 'v_loc_ref_INV_12', 'Dv_r_INV_12', 'Dq_r_INV_12', 'p_ref_INV_13', 'T_pq_INV_13', 'v_loc_ref_INV_13', 'Dv_r_INV_13', 'Dq_r_INV_13'] 
        self.inputs_ini_values_list  = [32999.89801120604, 19052.499999999996, -32999.89801120604, 19052.499999999996, -6.999774942226484e-12, -38105.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.0396477490721736e-05, 1.634204608080836e-05, 0.0, 0.0, 0.0, 0.0, 1000000.005913838, 0.2, 1, 0, 0, 1000000.0057466463, 0.2, 1, 0, 0, 1000000.005535075, 0.2, 1, 0, 0, 1000000.0069329473, 0.2, 1, 0, 0, 1000000.0058054462, 0.2, 1, 0, 0, 1000000.0069361846, 0.2, 1, 0, 0, 1000000.004805406, 0.2, 1, 0, 0, 1000000.005736879, 0.2, 1, 0, 0, 1000000.0057615642, 0.2, 1, 0, 0, 1000000.0062956584, 0.2, 1, 0, 0, 1000000.0061703005, 0.2, 1, 0, 0, 1000000.0056400693, 0.2, 1, 0, 0, 1000000.0049489803, 0.2, 1, 0, 0] 
        self.inputs_run_list = ['v_GRID_a_r', 'v_GRID_a_i', 'v_GRID_b_r', 'v_GRID_b_i', 'v_GRID_c_r', 'v_GRID_c_i', 'i_POIhv_a_r', 'i_POIhv_a_i', 'i_POIhv_b_r', 'i_POIhv_b_i', 'i_POIhv_c_r', 'i_POIhv_c_i', 'i_POImv_a_r', 'i_POImv_a_i', 'i_POImv_b_r', 'i_POImv_b_i', 'i_POImv_c_r', 'i_POImv_c_i', 'i_TR_1_2_mv_a_r', 'i_TR_1_2_mv_a_i', 'i_TR_1_2_mv_b_r', 'i_TR_1_2_mv_b_i', 'i_TR_1_2_mv_c_r', 'i_TR_1_2_mv_c_i', 'i_TR_1_2_lv_a_r', 'i_TR_1_2_lv_a_i', 'i_TR_1_2_lv_b_r', 'i_TR_1_2_lv_b_i', 'i_TR_1_2_lv_c_r', 'i_TR_1_2_lv_c_i', 'i_TR_3_4_mv_a_r', 'i_TR_3_4_mv_a_i', 'i_TR_3_4_mv_b_r', 'i_TR_3_4_mv_b_i', 'i_TR_3_4_mv_c_r', 'i_TR_3_4_mv_c_i', 'i_TR_3_4_lv_a_r', 'i_TR_3_4_lv_a_i', 'i_TR_3_4_lv_b_r', 'i_TR_3_4_lv_b_i', 'i_TR_3_4_lv_c_r', 'i_TR_3_4_lv_c_i', 'i_TR_5_6_mv_a_r', 'i_TR_5_6_mv_a_i', 'i_TR_5_6_mv_b_r', 'i_TR_5_6_mv_b_i', 'i_TR_5_6_mv_c_r', 'i_TR_5_6_mv_c_i', 'i_TR_5_6_lv_a_r', 'i_TR_5_6_lv_a_i', 'i_TR_5_6_lv_b_r', 'i_TR_5_6_lv_b_i', 'i_TR_5_6_lv_c_r', 'i_TR_5_6_lv_c_i', 'i_TR_7_8_mv_a_r', 'i_TR_7_8_mv_a_i', 'i_TR_7_8_mv_b_r', 'i_TR_7_8_mv_b_i', 'i_TR_7_8_mv_c_r', 'i_TR_7_8_mv_c_i', 'i_TR_7_8_lv_a_r', 'i_TR_7_8_lv_a_i', 'i_TR_7_8_lv_b_r', 'i_TR_7_8_lv_b_i', 'i_TR_7_8_lv_c_r', 'i_TR_7_8_lv_c_i', 'i_TR_9_10_mv_a_r', 'i_TR_9_10_mv_a_i', 'i_TR_9_10_mv_b_r', 'i_TR_9_10_mv_b_i', 'i_TR_9_10_mv_c_r', 'i_TR_9_10_mv_c_i', 'i_TR_9_10_lv_a_r', 'i_TR_9_10_lv_a_i', 'i_TR_9_10_lv_b_r', 'i_TR_9_10_lv_b_i', 'i_TR_9_10_lv_c_r', 'i_TR_9_10_lv_c_i', 'i_TR_11_12_mv_a_r', 'i_TR_11_12_mv_a_i', 'i_TR_11_12_mv_b_r', 'i_TR_11_12_mv_b_i', 'i_TR_11_12_mv_c_r', 'i_TR_11_12_mv_c_i', 'i_TR_11_12_lv_a_r', 'i_TR_11_12_lv_a_i', 'i_TR_11_12_lv_b_r', 'i_TR_11_12_lv_b_i', 'i_TR_11_12_lv_c_r', 'i_TR_11_12_lv_c_i', 'i_TR_13_mv_a_r', 'i_TR_13_mv_a_i', 'i_TR_13_mv_b_r', 'i_TR_13_mv_b_i', 'i_TR_13_mv_c_r', 'i_TR_13_mv_c_i', 'i_TR_13_lv_a_r', 'i_TR_13_lv_a_i', 'i_TR_13_lv_b_r', 'i_TR_13_lv_b_i', 'i_TR_13_lv_c_r', 'i_TR_13_lv_c_i', 'p_ref_INV_1', 'T_pq_INV_1', 'v_loc_ref_INV_1', 'Dv_r_INV_1', 'Dq_r_INV_1', 'p_ref_INV_2', 'T_pq_INV_2', 'v_loc_ref_INV_2', 'Dv_r_INV_2', 'Dq_r_INV_2', 'p_ref_INV_3', 'T_pq_INV_3', 'v_loc_ref_INV_3', 'Dv_r_INV_3', 'Dq_r_INV_3', 'p_ref_INV_4', 'T_pq_INV_4', 'v_loc_ref_INV_4', 'Dv_r_INV_4', 'Dq_r_INV_4', 'p_ref_INV_5', 'T_pq_INV_5', 'v_loc_ref_INV_5', 'Dv_r_INV_5', 'Dq_r_INV_5', 'p_ref_INV_6', 'T_pq_INV_6', 'v_loc_ref_INV_6', 'Dv_r_INV_6', 'Dq_r_INV_6', 'p_ref_INV_7', 'T_pq_INV_7', 'v_loc_ref_INV_7', 'Dv_r_INV_7', 'Dq_r_INV_7', 'p_ref_INV_8', 'T_pq_INV_8', 'v_loc_ref_INV_8', 'Dv_r_INV_8', 'Dq_r_INV_8', 'p_ref_INV_9', 'T_pq_INV_9', 'v_loc_ref_INV_9', 'Dv_r_INV_9', 'Dq_r_INV_9', 'p_ref_INV_10', 'T_pq_INV_10', 'v_loc_ref_INV_10', 'Dv_r_INV_10', 'Dq_r_INV_10', 'p_ref_INV_11', 'T_pq_INV_11', 'v_loc_ref_INV_11', 'Dv_r_INV_11', 'Dq_r_INV_11', 'p_ref_INV_12', 'T_pq_INV_12', 'v_loc_ref_INV_12', 'Dv_r_INV_12', 'Dq_r_INV_12', 'p_ref_INV_13', 'T_pq_INV_13', 'v_loc_ref_INV_13', 'Dv_r_INV_13', 'Dq_r_INV_13'] 
        self.inputs_run_values_list = [32999.89801120604, 19052.499999999996, -32999.89801120604, 19052.499999999996, -6.999774942226484e-12, -38105.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.0396477490721736e-05, 1.634204608080836e-05, 0.0, 0.0, 0.0, 0.0, 1000000.005913838, 0.2, 1, 0, 0, 1000000.0057466463, 0.2, 1, 0, 0, 1000000.005535075, 0.2, 1, 0, 0, 1000000.0069329473, 0.2, 1, 0, 0, 1000000.0058054462, 0.2, 1, 0, 0, 1000000.0069361846, 0.2, 1, 0, 0, 1000000.004805406, 0.2, 1, 0, 0, 1000000.005736879, 0.2, 1, 0, 0, 1000000.0057615642, 0.2, 1, 0, 0, 1000000.0062956584, 0.2, 1, 0, 0, 1000000.0061703005, 0.2, 1, 0, 0, 1000000.0056400693, 0.2, 1, 0, 0, 1000000.0049489803, 0.2, 1, 0, 0] 
        self.outputs_list = ['v_GRID_a_m', 'v_GRID_b_m', 'v_GRID_c_m', 'v_INV_1_a_m', 'v_INV_1_b_m', 'v_INV_1_c_m', 'v_INV_2_a_m', 'v_INV_2_b_m', 'v_INV_2_c_m', 'v_INV_3_a_m', 'v_INV_3_b_m', 'v_INV_3_c_m', 'v_INV_4_a_m', 'v_INV_4_b_m', 'v_INV_4_c_m', 'v_INV_5_a_m', 'v_INV_5_b_m', 'v_INV_5_c_m', 'v_INV_6_a_m', 'v_INV_6_b_m', 'v_INV_6_c_m', 'v_INV_7_a_m', 'v_INV_7_b_m', 'v_INV_7_c_m', 'v_INV_8_a_m', 'v_INV_8_b_m', 'v_INV_8_c_m', 'v_INV_9_a_m', 'v_INV_9_b_m', 'v_INV_9_c_m', 'v_INV_10_a_m', 'v_INV_10_b_m', 'v_INV_10_c_m', 'v_INV_11_a_m', 'v_INV_11_b_m', 'v_INV_11_c_m', 'v_INV_12_a_m', 'v_INV_12_b_m', 'v_INV_12_c_m', 'v_INV_13_a_m', 'v_INV_13_b_m', 'v_INV_13_c_m', 'v_POIhv_a_m', 'v_POIhv_b_m', 'v_POIhv_c_m', 'v_POImv_a_m', 'v_POImv_b_m', 'v_POImv_c_m', 'v_TR_1_2_mv_a_m', 'v_TR_1_2_mv_b_m', 'v_TR_1_2_mv_c_m', 'v_TR_1_2_lv_a_m', 'v_TR_1_2_lv_b_m', 'v_TR_1_2_lv_c_m', 'v_TR_3_4_mv_a_m', 'v_TR_3_4_mv_b_m', 'v_TR_3_4_mv_c_m', 'v_TR_3_4_lv_a_m', 'v_TR_3_4_lv_b_m', 'v_TR_3_4_lv_c_m', 'v_TR_5_6_mv_a_m', 'v_TR_5_6_mv_b_m', 'v_TR_5_6_mv_c_m', 'v_TR_5_6_lv_a_m', 'v_TR_5_6_lv_b_m', 'v_TR_5_6_lv_c_m', 'v_TR_7_8_mv_a_m', 'v_TR_7_8_mv_b_m', 'v_TR_7_8_mv_c_m', 'v_TR_7_8_lv_a_m', 'v_TR_7_8_lv_b_m', 'v_TR_7_8_lv_c_m', 'v_TR_9_10_mv_a_m', 'v_TR_9_10_mv_b_m', 'v_TR_9_10_mv_c_m', 'v_TR_9_10_lv_a_m', 'v_TR_9_10_lv_b_m', 'v_TR_9_10_lv_c_m', 'v_TR_11_12_mv_a_m', 'v_TR_11_12_mv_b_m', 'v_TR_11_12_mv_c_m', 'v_TR_11_12_lv_a_m', 'v_TR_11_12_lv_b_m', 'v_TR_11_12_lv_c_m', 'v_TR_13_mv_a_m', 'v_TR_13_mv_b_m', 'v_TR_13_mv_c_m', 'v_TR_13_lv_a_m', 'v_TR_13_lv_b_m', 'v_TR_13_lv_c_m'] 
        self.x_list = ['p_INV_1_a', 'p_INV_1_b', 'p_INV_1_c', 'q_INV_1_a', 'q_INV_1_b', 'q_INV_1_c', 'p_INV_2_a', 'p_INV_2_b', 'p_INV_2_c', 'q_INV_2_a', 'q_INV_2_b', 'q_INV_2_c', 'p_INV_3_a', 'p_INV_3_b', 'p_INV_3_c', 'q_INV_3_a', 'q_INV_3_b', 'q_INV_3_c', 'p_INV_4_a', 'p_INV_4_b', 'p_INV_4_c', 'q_INV_4_a', 'q_INV_4_b', 'q_INV_4_c', 'p_INV_5_a', 'p_INV_5_b', 'p_INV_5_c', 'q_INV_5_a', 'q_INV_5_b', 'q_INV_5_c', 'p_INV_6_a', 'p_INV_6_b', 'p_INV_6_c', 'q_INV_6_a', 'q_INV_6_b', 'q_INV_6_c', 'p_INV_7_a', 'p_INV_7_b', 'p_INV_7_c', 'q_INV_7_a', 'q_INV_7_b', 'q_INV_7_c', 'p_INV_8_a', 'p_INV_8_b', 'p_INV_8_c', 'q_INV_8_a', 'q_INV_8_b', 'q_INV_8_c', 'p_INV_9_a', 'p_INV_9_b', 'p_INV_9_c', 'q_INV_9_a', 'q_INV_9_b', 'q_INV_9_c', 'p_INV_10_a', 'p_INV_10_b', 'p_INV_10_c', 'q_INV_10_a', 'q_INV_10_b', 'q_INV_10_c', 'p_INV_11_a', 'p_INV_11_b', 'p_INV_11_c', 'q_INV_11_a', 'q_INV_11_b', 'q_INV_11_c', 'p_INV_12_a', 'p_INV_12_b', 'p_INV_12_c', 'q_INV_12_a', 'q_INV_12_b', 'q_INV_12_c', 'p_INV_13_a', 'p_INV_13_b', 'p_INV_13_c', 'q_INV_13_a', 'q_INV_13_b', 'q_INV_13_c'] 
        self.y_run_list = ['v_INV_1_a_r', 'v_INV_1_a_i', 'v_INV_1_b_r', 'v_INV_1_b_i', 'v_INV_1_c_r', 'v_INV_1_c_i', 'v_INV_2_a_r', 'v_INV_2_a_i', 'v_INV_2_b_r', 'v_INV_2_b_i', 'v_INV_2_c_r', 'v_INV_2_c_i', 'v_INV_3_a_r', 'v_INV_3_a_i', 'v_INV_3_b_r', 'v_INV_3_b_i', 'v_INV_3_c_r', 'v_INV_3_c_i', 'v_INV_4_a_r', 'v_INV_4_a_i', 'v_INV_4_b_r', 'v_INV_4_b_i', 'v_INV_4_c_r', 'v_INV_4_c_i', 'v_INV_5_a_r', 'v_INV_5_a_i', 'v_INV_5_b_r', 'v_INV_5_b_i', 'v_INV_5_c_r', 'v_INV_5_c_i', 'v_INV_6_a_r', 'v_INV_6_a_i', 'v_INV_6_b_r', 'v_INV_6_b_i', 'v_INV_6_c_r', 'v_INV_6_c_i', 'v_INV_7_a_r', 'v_INV_7_a_i', 'v_INV_7_b_r', 'v_INV_7_b_i', 'v_INV_7_c_r', 'v_INV_7_c_i', 'v_INV_8_a_r', 'v_INV_8_a_i', 'v_INV_8_b_r', 'v_INV_8_b_i', 'v_INV_8_c_r', 'v_INV_8_c_i', 'v_INV_9_a_r', 'v_INV_9_a_i', 'v_INV_9_b_r', 'v_INV_9_b_i', 'v_INV_9_c_r', 'v_INV_9_c_i', 'v_INV_10_a_r', 'v_INV_10_a_i', 'v_INV_10_b_r', 'v_INV_10_b_i', 'v_INV_10_c_r', 'v_INV_10_c_i', 'v_INV_11_a_r', 'v_INV_11_a_i', 'v_INV_11_b_r', 'v_INV_11_b_i', 'v_INV_11_c_r', 'v_INV_11_c_i', 'v_INV_12_a_r', 'v_INV_12_a_i', 'v_INV_12_b_r', 'v_INV_12_b_i', 'v_INV_12_c_r', 'v_INV_12_c_i', 'v_INV_13_a_r', 'v_INV_13_a_i', 'v_INV_13_b_r', 'v_INV_13_b_i', 'v_INV_13_c_r', 'v_INV_13_c_i', 'v_POIhv_a_r', 'v_POIhv_a_i', 'v_POIhv_b_r', 'v_POIhv_b_i', 'v_POIhv_c_r', 'v_POIhv_c_i', 'v_POImv_a_r', 'v_POImv_a_i', 'v_POImv_b_r', 'v_POImv_b_i', 'v_POImv_c_r', 'v_POImv_c_i', 'v_TR_1_2_mv_a_r', 'v_TR_1_2_mv_a_i', 'v_TR_1_2_mv_b_r', 'v_TR_1_2_mv_b_i', 'v_TR_1_2_mv_c_r', 'v_TR_1_2_mv_c_i', 'v_TR_1_2_lv_a_r', 'v_TR_1_2_lv_a_i', 'v_TR_1_2_lv_b_r', 'v_TR_1_2_lv_b_i', 'v_TR_1_2_lv_c_r', 'v_TR_1_2_lv_c_i', 'v_TR_3_4_mv_a_r', 'v_TR_3_4_mv_a_i', 'v_TR_3_4_mv_b_r', 'v_TR_3_4_mv_b_i', 'v_TR_3_4_mv_c_r', 'v_TR_3_4_mv_c_i', 'v_TR_3_4_lv_a_r', 'v_TR_3_4_lv_a_i', 'v_TR_3_4_lv_b_r', 'v_TR_3_4_lv_b_i', 'v_TR_3_4_lv_c_r', 'v_TR_3_4_lv_c_i', 'v_TR_5_6_mv_a_r', 'v_TR_5_6_mv_a_i', 'v_TR_5_6_mv_b_r', 'v_TR_5_6_mv_b_i', 'v_TR_5_6_mv_c_r', 'v_TR_5_6_mv_c_i', 'v_TR_5_6_lv_a_r', 'v_TR_5_6_lv_a_i', 'v_TR_5_6_lv_b_r', 'v_TR_5_6_lv_b_i', 'v_TR_5_6_lv_c_r', 'v_TR_5_6_lv_c_i', 'v_TR_7_8_mv_a_r', 'v_TR_7_8_mv_a_i', 'v_TR_7_8_mv_b_r', 'v_TR_7_8_mv_b_i', 'v_TR_7_8_mv_c_r', 'v_TR_7_8_mv_c_i', 'v_TR_7_8_lv_a_r', 'v_TR_7_8_lv_a_i', 'v_TR_7_8_lv_b_r', 'v_TR_7_8_lv_b_i', 'v_TR_7_8_lv_c_r', 'v_TR_7_8_lv_c_i', 'v_TR_9_10_mv_a_r', 'v_TR_9_10_mv_a_i', 'v_TR_9_10_mv_b_r', 'v_TR_9_10_mv_b_i', 'v_TR_9_10_mv_c_r', 'v_TR_9_10_mv_c_i', 'v_TR_9_10_lv_a_r', 'v_TR_9_10_lv_a_i', 'v_TR_9_10_lv_b_r', 'v_TR_9_10_lv_b_i', 'v_TR_9_10_lv_c_r', 'v_TR_9_10_lv_c_i', 'v_TR_11_12_mv_a_r', 'v_TR_11_12_mv_a_i', 'v_TR_11_12_mv_b_r', 'v_TR_11_12_mv_b_i', 'v_TR_11_12_mv_c_r', 'v_TR_11_12_mv_c_i', 'v_TR_11_12_lv_a_r', 'v_TR_11_12_lv_a_i', 'v_TR_11_12_lv_b_r', 'v_TR_11_12_lv_b_i', 'v_TR_11_12_lv_c_r', 'v_TR_11_12_lv_c_i', 'v_TR_13_mv_a_r', 'v_TR_13_mv_a_i', 'v_TR_13_mv_b_r', 'v_TR_13_mv_b_i', 'v_TR_13_mv_c_r', 'v_TR_13_mv_c_i', 'v_TR_13_lv_a_r', 'v_TR_13_lv_a_i', 'v_TR_13_lv_b_r', 'v_TR_13_lv_b_i', 'v_TR_13_lv_c_r', 'v_TR_13_lv_c_i', 'i_INV_1_a_r', 'i_INV_1_a_i', 'i_INV_1_b_r', 'i_INV_1_b_i', 'i_INV_1_c_r', 'i_INV_1_c_i', 'v_m_INV_1', 'v_m_TR_1_2_mv', 'i_reac_ref_INV_1', 'q_ref_INV_1', 'i_INV_2_a_r', 'i_INV_2_a_i', 'i_INV_2_b_r', 'i_INV_2_b_i', 'i_INV_2_c_r', 'i_INV_2_c_i', 'v_m_INV_2', 'i_reac_ref_INV_2', 'q_ref_INV_2', 'i_INV_3_a_r', 'i_INV_3_a_i', 'i_INV_3_b_r', 'i_INV_3_b_i', 'i_INV_3_c_r', 'i_INV_3_c_i', 'v_m_INV_3', 'v_m_TR_3_4_mv', 'i_reac_ref_INV_3', 'q_ref_INV_3', 'i_INV_4_a_r', 'i_INV_4_a_i', 'i_INV_4_b_r', 'i_INV_4_b_i', 'i_INV_4_c_r', 'i_INV_4_c_i', 'v_m_INV_4', 'i_reac_ref_INV_4', 'q_ref_INV_4', 'i_INV_5_a_r', 'i_INV_5_a_i', 'i_INV_5_b_r', 'i_INV_5_b_i', 'i_INV_5_c_r', 'i_INV_5_c_i', 'v_m_INV_5', 'v_m_TR_5_6_mv', 'i_reac_ref_INV_5', 'q_ref_INV_5', 'i_INV_6_a_r', 'i_INV_6_a_i', 'i_INV_6_b_r', 'i_INV_6_b_i', 'i_INV_6_c_r', 'i_INV_6_c_i', 'v_m_INV_6', 'i_reac_ref_INV_6', 'q_ref_INV_6', 'i_INV_7_a_r', 'i_INV_7_a_i', 'i_INV_7_b_r', 'i_INV_7_b_i', 'i_INV_7_c_r', 'i_INV_7_c_i', 'v_m_INV_7', 'v_m_TR_7_8_mv', 'i_reac_ref_INV_7', 'q_ref_INV_7', 'i_INV_8_a_r', 'i_INV_8_a_i', 'i_INV_8_b_r', 'i_INV_8_b_i', 'i_INV_8_c_r', 'i_INV_8_c_i', 'v_m_INV_8', 'i_reac_ref_INV_8', 'q_ref_INV_8', 'i_INV_9_a_r', 'i_INV_9_a_i', 'i_INV_9_b_r', 'i_INV_9_b_i', 'i_INV_9_c_r', 'i_INV_9_c_i', 'v_m_INV_9', 'v_m_TR_9_10_mv', 'i_reac_ref_INV_9', 'q_ref_INV_9', 'i_INV_10_a_r', 'i_INV_10_a_i', 'i_INV_10_b_r', 'i_INV_10_b_i', 'i_INV_10_c_r', 'i_INV_10_c_i', 'v_m_INV_10', 'i_reac_ref_INV_10', 'q_ref_INV_10', 'i_INV_11_a_r', 'i_INV_11_a_i', 'i_INV_11_b_r', 'i_INV_11_b_i', 'i_INV_11_c_r', 'i_INV_11_c_i', 'v_m_INV_11', 'v_m_TR_11_12_mv', 'i_reac_ref_INV_11', 'q_ref_INV_11', 'i_INV_12_a_r', 'i_INV_12_a_i', 'i_INV_12_b_r', 'i_INV_12_b_i', 'i_INV_12_c_r', 'i_INV_12_c_i', 'v_m_INV_12', 'i_reac_ref_INV_12', 'q_ref_INV_12', 'i_INV_13_a_r', 'i_INV_13_a_i', 'i_INV_13_b_r', 'i_INV_13_b_i', 'i_INV_13_c_r', 'i_INV_13_c_i', 'v_m_INV_13', 'v_m_TR_13_mv', 'i_reac_ref_INV_13', 'q_ref_INV_13'] 
        self.xy_list = self.x_list + self.y_run_list 
        self.y_ini_list = ['v_INV_1_a_r', 'v_INV_1_a_i', 'v_INV_1_b_r', 'v_INV_1_b_i', 'v_INV_1_c_r', 'v_INV_1_c_i', 'v_INV_2_a_r', 'v_INV_2_a_i', 'v_INV_2_b_r', 'v_INV_2_b_i', 'v_INV_2_c_r', 'v_INV_2_c_i', 'v_INV_3_a_r', 'v_INV_3_a_i', 'v_INV_3_b_r', 'v_INV_3_b_i', 'v_INV_3_c_r', 'v_INV_3_c_i', 'v_INV_4_a_r', 'v_INV_4_a_i', 'v_INV_4_b_r', 'v_INV_4_b_i', 'v_INV_4_c_r', 'v_INV_4_c_i', 'v_INV_5_a_r', 'v_INV_5_a_i', 'v_INV_5_b_r', 'v_INV_5_b_i', 'v_INV_5_c_r', 'v_INV_5_c_i', 'v_INV_6_a_r', 'v_INV_6_a_i', 'v_INV_6_b_r', 'v_INV_6_b_i', 'v_INV_6_c_r', 'v_INV_6_c_i', 'v_INV_7_a_r', 'v_INV_7_a_i', 'v_INV_7_b_r', 'v_INV_7_b_i', 'v_INV_7_c_r', 'v_INV_7_c_i', 'v_INV_8_a_r', 'v_INV_8_a_i', 'v_INV_8_b_r', 'v_INV_8_b_i', 'v_INV_8_c_r', 'v_INV_8_c_i', 'v_INV_9_a_r', 'v_INV_9_a_i', 'v_INV_9_b_r', 'v_INV_9_b_i', 'v_INV_9_c_r', 'v_INV_9_c_i', 'v_INV_10_a_r', 'v_INV_10_a_i', 'v_INV_10_b_r', 'v_INV_10_b_i', 'v_INV_10_c_r', 'v_INV_10_c_i', 'v_INV_11_a_r', 'v_INV_11_a_i', 'v_INV_11_b_r', 'v_INV_11_b_i', 'v_INV_11_c_r', 'v_INV_11_c_i', 'v_INV_12_a_r', 'v_INV_12_a_i', 'v_INV_12_b_r', 'v_INV_12_b_i', 'v_INV_12_c_r', 'v_INV_12_c_i', 'v_INV_13_a_r', 'v_INV_13_a_i', 'v_INV_13_b_r', 'v_INV_13_b_i', 'v_INV_13_c_r', 'v_INV_13_c_i', 'v_POIhv_a_r', 'v_POIhv_a_i', 'v_POIhv_b_r', 'v_POIhv_b_i', 'v_POIhv_c_r', 'v_POIhv_c_i', 'v_POImv_a_r', 'v_POImv_a_i', 'v_POImv_b_r', 'v_POImv_b_i', 'v_POImv_c_r', 'v_POImv_c_i', 'v_TR_1_2_mv_a_r', 'v_TR_1_2_mv_a_i', 'v_TR_1_2_mv_b_r', 'v_TR_1_2_mv_b_i', 'v_TR_1_2_mv_c_r', 'v_TR_1_2_mv_c_i', 'v_TR_1_2_lv_a_r', 'v_TR_1_2_lv_a_i', 'v_TR_1_2_lv_b_r', 'v_TR_1_2_lv_b_i', 'v_TR_1_2_lv_c_r', 'v_TR_1_2_lv_c_i', 'v_TR_3_4_mv_a_r', 'v_TR_3_4_mv_a_i', 'v_TR_3_4_mv_b_r', 'v_TR_3_4_mv_b_i', 'v_TR_3_4_mv_c_r', 'v_TR_3_4_mv_c_i', 'v_TR_3_4_lv_a_r', 'v_TR_3_4_lv_a_i', 'v_TR_3_4_lv_b_r', 'v_TR_3_4_lv_b_i', 'v_TR_3_4_lv_c_r', 'v_TR_3_4_lv_c_i', 'v_TR_5_6_mv_a_r', 'v_TR_5_6_mv_a_i', 'v_TR_5_6_mv_b_r', 'v_TR_5_6_mv_b_i', 'v_TR_5_6_mv_c_r', 'v_TR_5_6_mv_c_i', 'v_TR_5_6_lv_a_r', 'v_TR_5_6_lv_a_i', 'v_TR_5_6_lv_b_r', 'v_TR_5_6_lv_b_i', 'v_TR_5_6_lv_c_r', 'v_TR_5_6_lv_c_i', 'v_TR_7_8_mv_a_r', 'v_TR_7_8_mv_a_i', 'v_TR_7_8_mv_b_r', 'v_TR_7_8_mv_b_i', 'v_TR_7_8_mv_c_r', 'v_TR_7_8_mv_c_i', 'v_TR_7_8_lv_a_r', 'v_TR_7_8_lv_a_i', 'v_TR_7_8_lv_b_r', 'v_TR_7_8_lv_b_i', 'v_TR_7_8_lv_c_r', 'v_TR_7_8_lv_c_i', 'v_TR_9_10_mv_a_r', 'v_TR_9_10_mv_a_i', 'v_TR_9_10_mv_b_r', 'v_TR_9_10_mv_b_i', 'v_TR_9_10_mv_c_r', 'v_TR_9_10_mv_c_i', 'v_TR_9_10_lv_a_r', 'v_TR_9_10_lv_a_i', 'v_TR_9_10_lv_b_r', 'v_TR_9_10_lv_b_i', 'v_TR_9_10_lv_c_r', 'v_TR_9_10_lv_c_i', 'v_TR_11_12_mv_a_r', 'v_TR_11_12_mv_a_i', 'v_TR_11_12_mv_b_r', 'v_TR_11_12_mv_b_i', 'v_TR_11_12_mv_c_r', 'v_TR_11_12_mv_c_i', 'v_TR_11_12_lv_a_r', 'v_TR_11_12_lv_a_i', 'v_TR_11_12_lv_b_r', 'v_TR_11_12_lv_b_i', 'v_TR_11_12_lv_c_r', 'v_TR_11_12_lv_c_i', 'v_TR_13_mv_a_r', 'v_TR_13_mv_a_i', 'v_TR_13_mv_b_r', 'v_TR_13_mv_b_i', 'v_TR_13_mv_c_r', 'v_TR_13_mv_c_i', 'v_TR_13_lv_a_r', 'v_TR_13_lv_a_i', 'v_TR_13_lv_b_r', 'v_TR_13_lv_b_i', 'v_TR_13_lv_c_r', 'v_TR_13_lv_c_i', 'i_INV_1_a_r', 'i_INV_1_a_i', 'i_INV_1_b_r', 'i_INV_1_b_i', 'i_INV_1_c_r', 'i_INV_1_c_i', 'v_m_INV_1', 'v_m_TR_1_2_mv', 'i_reac_ref_INV_1', 'q_ref_INV_1', 'i_INV_2_a_r', 'i_INV_2_a_i', 'i_INV_2_b_r', 'i_INV_2_b_i', 'i_INV_2_c_r', 'i_INV_2_c_i', 'v_m_INV_2', 'i_reac_ref_INV_2', 'q_ref_INV_2', 'i_INV_3_a_r', 'i_INV_3_a_i', 'i_INV_3_b_r', 'i_INV_3_b_i', 'i_INV_3_c_r', 'i_INV_3_c_i', 'v_m_INV_3', 'v_m_TR_3_4_mv', 'i_reac_ref_INV_3', 'q_ref_INV_3', 'i_INV_4_a_r', 'i_INV_4_a_i', 'i_INV_4_b_r', 'i_INV_4_b_i', 'i_INV_4_c_r', 'i_INV_4_c_i', 'v_m_INV_4', 'i_reac_ref_INV_4', 'q_ref_INV_4', 'i_INV_5_a_r', 'i_INV_5_a_i', 'i_INV_5_b_r', 'i_INV_5_b_i', 'i_INV_5_c_r', 'i_INV_5_c_i', 'v_m_INV_5', 'v_m_TR_5_6_mv', 'i_reac_ref_INV_5', 'q_ref_INV_5', 'i_INV_6_a_r', 'i_INV_6_a_i', 'i_INV_6_b_r', 'i_INV_6_b_i', 'i_INV_6_c_r', 'i_INV_6_c_i', 'v_m_INV_6', 'i_reac_ref_INV_6', 'q_ref_INV_6', 'i_INV_7_a_r', 'i_INV_7_a_i', 'i_INV_7_b_r', 'i_INV_7_b_i', 'i_INV_7_c_r', 'i_INV_7_c_i', 'v_m_INV_7', 'v_m_TR_7_8_mv', 'i_reac_ref_INV_7', 'q_ref_INV_7', 'i_INV_8_a_r', 'i_INV_8_a_i', 'i_INV_8_b_r', 'i_INV_8_b_i', 'i_INV_8_c_r', 'i_INV_8_c_i', 'v_m_INV_8', 'i_reac_ref_INV_8', 'q_ref_INV_8', 'i_INV_9_a_r', 'i_INV_9_a_i', 'i_INV_9_b_r', 'i_INV_9_b_i', 'i_INV_9_c_r', 'i_INV_9_c_i', 'v_m_INV_9', 'v_m_TR_9_10_mv', 'i_reac_ref_INV_9', 'q_ref_INV_9', 'i_INV_10_a_r', 'i_INV_10_a_i', 'i_INV_10_b_r', 'i_INV_10_b_i', 'i_INV_10_c_r', 'i_INV_10_c_i', 'v_m_INV_10', 'i_reac_ref_INV_10', 'q_ref_INV_10', 'i_INV_11_a_r', 'i_INV_11_a_i', 'i_INV_11_b_r', 'i_INV_11_b_i', 'i_INV_11_c_r', 'i_INV_11_c_i', 'v_m_INV_11', 'v_m_TR_11_12_mv', 'i_reac_ref_INV_11', 'q_ref_INV_11', 'i_INV_12_a_r', 'i_INV_12_a_i', 'i_INV_12_b_r', 'i_INV_12_b_i', 'i_INV_12_c_r', 'i_INV_12_c_i', 'v_m_INV_12', 'i_reac_ref_INV_12', 'q_ref_INV_12', 'i_INV_13_a_r', 'i_INV_13_a_i', 'i_INV_13_b_r', 'i_INV_13_b_i', 'i_INV_13_c_r', 'i_INV_13_c_i', 'v_m_INV_13', 'v_m_TR_13_mv', 'i_reac_ref_INV_13', 'q_ref_INV_13'] 
        self.xy_ini_list = self.x_list + self.y_ini_list 
        self.t = 0.0
        self.it = 0
        self.it_store = 0
        self.xy_prev = np.zeros((self.N_x+self.N_y,1))
        self.initialization_tol = 1e-6
        self.N_u = len(self.inputs_run_list) 
        self.sopt_root_method='hybr'
        self.sopt_root_jac=True
        self.u_ini_list = self.inputs_ini_list
        self.u_ini_values_list = self.inputs_ini_values_list
        self.u_run_list = self.inputs_run_list
        self.u_run_values_list = self.inputs_run_values_list
        
        self.update() 


    def update(self): 

        self.N_steps = int(np.ceil(self.t_end/self.Dt)) 
        dt = [  
              ('t_end', np.float64),
              ('Dt', np.float64),
              ('decimation', np.float64),
              ('itol', np.float64),
              ('Dt_max', np.float64),
              ('Dt_min', np.float64),
              ('solvern', np.int64),
              ('imax', np.int64),
              ('N_steps', np.int64),
              ('N_store', np.int64),
              ('N_x', np.int64),
              ('N_y', np.int64),
              ('N_z', np.int64),
              ('t', np.float64),
              ('it', np.int64),
              ('it_store', np.int64),
              ('idx', np.int64),
              ('idy', np.int64),
              ('f', np.float64, (self.N_x,1)),
              ('x', np.float64, (self.N_x,1)),
              ('x_0', np.float64, (self.N_x,1)),
              ('g', np.float64, (self.N_y,1)),
              ('y_run', np.float64, (self.N_y,1)),
              ('y_ini', np.float64, (self.N_y,1)),
              ('y_0', np.float64, (self.N_y,1)),
              ('h', np.float64, (self.N_z,1)),
              ('Fx', np.float64, (self.N_x,self.N_x)),
              ('Fy', np.float64, (self.N_x,self.N_y)),
              ('Gx', np.float64, (self.N_y,self.N_x)),
              ('Gy', np.float64, (self.N_y,self.N_y)),
              ('Fu', np.float64, (self.N_x,self.N_u)),
              ('Gu', np.float64, (self.N_y,self.N_u)),
              ('Hx', np.float64, (self.N_z,self.N_x)),
              ('Hy', np.float64, (self.N_z,self.N_y)),
              ('Hu', np.float64, (self.N_z,self.N_u)),
              ('Fx_ini', np.float64, (self.N_x,self.N_x)),
              ('Fy_ini', np.float64, (self.N_x,self.N_y)),
              ('Gx_ini', np.float64, (self.N_y,self.N_x)),
              ('Gy_ini', np.float64, (self.N_y,self.N_y)),
              ('T', np.float64, (self.N_store+1,1)),
              ('X', np.float64, (self.N_store+1,self.N_x)),
              ('Y', np.float64, (self.N_store+1,self.N_y)),
              ('Z', np.float64, (self.N_store+1,self.N_z)),
              ('iters', np.float64, (self.N_store+1,1)),
             ]

        values = [
                self.t_end,                          
                self.Dt,
                self.decimation,
                self.itol,
                self.Dt_max,
                self.Dt_min,
                self.solvern,
                self.imax,
                self.N_steps,
                self.N_store,
                self.N_x,
                self.N_y,
                self.N_z,
                self.t,
                self.it,
                self.it_store,
                0,                                     # idx
                0,                                     # idy
                np.zeros((self.N_x,1)),                # f
                np.zeros((self.N_x,1)),                # x
                np.zeros((self.N_x,1)),                # x_0
                np.zeros((self.N_y,1)),                # g
                np.zeros((self.N_y,1)),                # y_run
                np.zeros((self.N_y,1)),                # y_ini
                np.zeros((self.N_y,1)),                # y_0
                np.zeros((self.N_z,1)),                # h
                np.zeros((self.N_x,self.N_x)),         # Fx   
                np.zeros((self.N_x,self.N_y)),         # Fy 
                np.zeros((self.N_y,self.N_x)),         # Gx 
                np.zeros((self.N_y,self.N_y)),         # Fy
                np.zeros((self.N_x,self.N_u)),         # Fu 
                np.zeros((self.N_y,self.N_u)),         # Gu 
                np.zeros((self.N_z,self.N_x)),         # Hx 
                np.zeros((self.N_z,self.N_y)),         # Hy 
                np.zeros((self.N_z,self.N_u)),         # Hu 
                np.zeros((self.N_x,self.N_x)),         # Fx_ini  
                np.zeros((self.N_x,self.N_y)),         # Fy_ini 
                np.zeros((self.N_y,self.N_x)),         # Gx_ini 
                np.zeros((self.N_y,self.N_y)),         # Fy_ini 
                np.zeros((self.N_store+1,1)),          # T
                np.zeros((self.N_store+1,self.N_x)),   # X
                np.zeros((self.N_store+1,self.N_y)),   # Y
                np.zeros((self.N_store+1,self.N_z)),   # Z
                np.zeros((self.N_store+1,1)),          # iters
                ]  

        dt += [(item,np.float64) for item in self.params_list]
        values += [item for item in self.params_values_list]

        for item_id,item_val in zip(self.inputs_ini_list,self.inputs_ini_values_list):
            if item_id in self.inputs_run_list: continue
            dt += [(item_id,np.float64)]
            values += [item_val]

        dt += [(item,np.float64) for item in self.inputs_run_list]
        values += [item for item in self.inputs_run_values_list]

        self.struct = np.rec.array([tuple(values)], dtype=np.dtype(dt))

    def load_params(self,data_input):

        if type(data_input) == str:
            json_file = data_input
            self.json_file = json_file
            self.json_data = open(json_file).read().replace("'",'"')
            data = json.loads(self.json_data)
        elif type(data_input) == dict:
            data = data_input

        self.data = data
        for item in self.data:
            self.struct[0][item] = self.data[item]
            self.params_values_list[self.params_list.index(item)] = self.data[item]



    def ini_problem(self,x):
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_ini[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        ini(self.struct,2)
        ini(self.struct,3)       
        fg = np.vstack((self.struct[0].f,self.struct[0].g))[:,0]
        return fg

    def run_problem(self,x):
        t = self.struct[0].t
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_run[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        run(t,self.struct,2)
        run(t,self.struct,3)
        run(t,self.struct,10)
        run(t,self.struct,11)
        run(t,self.struct,12)
        run(t,self.struct,13)
        
        fg = np.vstack((self.struct[0].f,self.struct[0].g))[:,0]
        return fg
    

    def run_dae_jacobian(self,x):
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_run[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        run(0.0,self.struct,10)
        run(0.0,self.struct,11)     
        run(0.0,self.struct,12)
        run(0.0,self.struct,13)
        A_c = np.block([[self.struct[0].Fx,self.struct[0].Fy],
                        [self.struct[0].Gx,self.struct[0].Gy]])
        return A_c

    def run_dae_jacobian_nn(self,x):
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_run[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        run_nn(0.0,self.struct,10)
        run_nn(0.0,self.struct,11)     
        run_nn(0.0,self.struct,12)
        run_nn(0.0,self.struct,13)
 

    
    def eval_jacobians(self):

        run(0.0,self.struct,10)
        run(0.0,self.struct,11)  
        run(0.0,self.struct,12) 

        return 1


    def ini_dae_jacobian(self,x):
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_ini[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        ini(self.struct,10)
        ini(self.struct,11)       
        A_c = np.block([[self.struct[0].Fx_ini,self.struct[0].Fy_ini],
                        [self.struct[0].Gx_ini,self.struct[0].Gy_ini]])
        return A_c

    def ini_dae_jacobian_nn(self,x):
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_ini[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        ini_nn(self.struct,10)
        ini_nn(self.struct,11)       
 

    def f_ode(self,x):
        self.struct[0].x[:,0] = x
        run(self.struct,1)
        return self.struct[0].f[:,0]

    def f_odeint(self,x,t):
        self.struct[0].x[:,0] = x
        run(self.struct,1)
        return self.struct[0].f[:,0]

    def f_ivp(self,t,x):
        self.struct[0].x[:,0] = x
        run(self.struct,1)
        return self.struct[0].f[:,0]

    def Fx_ode(self,x):
        self.struct[0].x[:,0] = x
        run(self.struct,10)
        return self.struct[0].Fx

    def eval_A(self):
        
        Fx = self.struct[0].Fx
        Fy = self.struct[0].Fy
        Gx = self.struct[0].Gx
        Gy = self.struct[0].Gy
        
        A = Fx - Fy @ np.linalg.solve(Gy,Gx)
        
        self.A = A
        
        return A

    def eval_A_ini(self):
        
        Fx = self.struct[0].Fx_ini
        Fy = self.struct[0].Fy_ini
        Gx = self.struct[0].Gx_ini
        Gy = self.struct[0].Gy_ini
        
        A = Fx - Fy @ np.linalg.solve(Gy,Gx)
        
        
        return A
    
    def reset(self):
        for param,param_value in zip(self.params_list,self.params_values_list):
            self.struct[0][param] = param_value
        for input_name,input_value in zip(self.inputs_ini_list,self.inputs_ini_values_list):
            self.struct[0][input_name] = input_value   
        for input_name,input_value in zip(self.inputs_run_list,self.inputs_run_values_list):
            self.struct[0][input_name] = input_value  

    def simulate(self,events,xy0=0):
        
        # initialize both the ini and the run system
        self.initialize(events,xy0=xy0)
        
        ## solve 
        #daesolver(self.struct)    # run until first event

        # simulation run
        for event in events[1:]:  
            # make all the desired changes
            for item in event:
                self.struct[0][item] = event[item]
            daesolver(self.struct)    # run until next event
            
        
        T,X,Y,Z = self.post()
        
        return T,X,Y,Z
    
    def run(self,events):
        

        # simulation run
        for event in events:  
            # make all the desired changes
            for item in event:
                self.struct[0][item] = event[item]
            daesolver(self.struct)    # run until next event
            
        return 1
    
    
    def post(self):
        
        # post process result    
        T = self.struct[0]['T'][:self.struct[0].it_store]
        X = self.struct[0]['X'][:self.struct[0].it_store,:]
        Y = self.struct[0]['Y'][:self.struct[0].it_store,:]
        Z = self.struct[0]['Z'][:self.struct[0].it_store,:]
        iters = self.struct[0]['iters'][:self.struct[0].it_store,:]
    
        self.T = T
        self.X = X
        self.Y = Y
        self.Z = Z
        self.iters = iters
        
        return T,X,Y,Z
        
        
    def initialize(self,events=[{}],xy0=0):
        '''
        

        Parameters
        ----------
        events : dictionary 
            Dictionary with at least 't_end' and all inputs and parameters 
            that need to be changed.
        xy0 : float or string, optional
            0 means all states should be zero as initial guess. 
            If not zero all the states initial guess are the given input.
            If 'prev' it uses the last known initialization result as initial guess.

        Returns
        -------
        T : TYPE
            DESCRIPTION.
        X : TYPE
            DESCRIPTION.
        Y : TYPE
            DESCRIPTION.
        Z : TYPE
            DESCRIPTION.

        '''
        # simulation parameters
        self.struct[0].it = 0       # set time step to zero
        self.struct[0].it_store = 0 # set storage to zero
        self.struct[0].t = 0.0      # set time to zero
                    
        # initialization
        it_event = 0
        event = events[it_event]
        for item in event:
            self.struct[0][item] = event[item]
            
        
        ## compute initial conditions using x and y_ini 
        if xy0 == 0:
            xy0 = np.zeros(self.N_x+self.N_y)
        elif xy0 == 1:
            xy0 = np.ones(self.N_x+self.N_y)
        elif xy0 == 'prev':
            xy0 = self.xy_prev
        else:
            xy0 = xy0*np.ones(self.N_x+self.N_y)

        #xy = sopt.fsolve(self.ini_problem,xy0, jac=self.ini_dae_jacobian )
        self.ini_dae_jacobian_nn(xy0)
        self.run_dae_jacobian_nn(xy0)
        
        if self.sopt_root_jac:
            sol = sopt.root(self.ini_problem, xy0, 
                            jac=self.ini_dae_jacobian, 
                            method=self.sopt_root_method, tol=self.initialization_tol)
        else:
            sol = sopt.root(self.ini_problem, xy0, method=self.sopt_root_method)

        self.initialization_ok = True
        if sol.success == False:
            print('initialization not found!')
            self.initialization_ok = False

            T = self.struct[0]['T'][:self.struct[0].it_store]
            X = self.struct[0]['X'][:self.struct[0].it_store,:]
            Y = self.struct[0]['Y'][:self.struct[0].it_store,:]
            Z = self.struct[0]['Z'][:self.struct[0].it_store,:]
            iters = self.struct[0]['iters'][:self.struct[0].it_store,:]

        if self.initialization_ok:
            xy = sol.x
            self.xy_prev = xy
            self.struct[0].x[:,0] = xy[0:self.N_x]
            self.struct[0].y_run[:,0] = xy[self.N_x:]

            ## y_ini to u_run
            for item in self.inputs_run_list:
                if item in self.y_ini_list:
                    self.struct[0][item] = self.struct[0].y_ini[self.y_ini_list.index(item)]

            ## u_ini to y_run
            for item in self.inputs_ini_list:
                if item in self.y_run_list:
                    self.struct[0].y_run[self.y_run_list.index(item)] = self.struct[0][item]


            #xy = sopt.fsolve(self.ini_problem,xy0, jac=self.ini_dae_jacobian )
            if self.sopt_root_jac:
                sol = sopt.root(self.run_problem, xy0, 
                                jac=self.run_dae_jacobian, 
                                method=self.sopt_root_method, tol=self.initialization_tol)
            else:
                sol = sopt.root(self.run_problem, xy0, method=self.sopt_root_method)

            # evaluate f and g
            run(0.0,self.struct,2)
            run(0.0,self.struct,3)                

            
            # evaluate run jacobians 
            run(0.0,self.struct,10)
            run(0.0,self.struct,11)                
            run(0.0,self.struct,12) 
            run(0.0,self.struct,14) 
             
            # post process result    
            T = self.struct[0]['T'][:self.struct[0].it_store]
            X = self.struct[0]['X'][:self.struct[0].it_store,:]
            Y = self.struct[0]['Y'][:self.struct[0].it_store,:]
            Z = self.struct[0]['Z'][:self.struct[0].it_store,:]
            iters = self.struct[0]['iters'][:self.struct[0].it_store,:]
        
            self.T = T
            self.X = X
            self.Y = Y
            self.Z = Z
            self.iters = iters
            
        return self.initialization_ok
    
    
    def get_value(self,name):
        if name in self.inputs_run_list:
            value = self.struct[0][name]
        if name in self.x_list:
            idx = self.x_list.index(name)
            value = self.struct[0].x[idx,0]
        if name in self.y_run_list:
            idy = self.y_run_list.index(name)
            value = self.struct[0].y_run[idy,0]
        if name in self.params_list:
            value = self.struct[0][name]
        if name in self.outputs_list:
            value = self.struct[0].h[self.outputs_list.index(name),0] 

        return value
    
    def get_values(self,name):
        if name in self.x_list:
            values = self.X[:,self.x_list.index(name)]
        if name in self.y_run_list:
            values = self.Y[:,self.y_run_list.index(name)]
        if name in self.outputs_list:
            values = self.Z[:,self.outputs_list.index(name)]
                        
        return values

    def get_mvalue(self,names):
        '''

        Parameters
        ----------
        names : list
            list of variables names to return each value.

        Returns
        -------
        mvalue : TYPE
            list of value of each variable.

        '''
        mvalue = []
        for name in names:
            mvalue += [self.get_value(name)]
                        
        return mvalue
    
    def set_value(self,name,value):
        if name in self.inputs_run_list:
            self.struct[0][name] = value
        if name in self.params_list:
            self.struct[0][name] = value
            
    def report_x(self,value_format='5.2f'):
        for item in self.x_list:
            print(f'{item:5s} = {self.get_value(item):5.2f}')

    def report_y(self,value_format='5.2f'):
        for item in self.y_run_list:
            print(f'{item:5s} = {self.get_value(item):5.2f}')
            
    def report_u(self,value_format='5.2f'):
        for item in self.inputs_run_list:
            print(f'{item:5s} = {self.get_value(item):5.2f}')

    def report_z(self,value_format='5.2f'):
        for item in self.outputs_list:
            print(f'{item:5s} = {self.get_value(item):5.2f}')
            
    def get_x(self):
        return self.struct[0].x


@numba.njit(cache=True)
def ini(struct,mode):

    # Parameters:
    u_ctrl_v_INV_1 = struct[0].u_ctrl_v_INV_1
    K_p_v_INV_1 = struct[0].K_p_v_INV_1
    K_i_v_INV_1 = struct[0].K_i_v_INV_1
    V_base_INV_1 = struct[0].V_base_INV_1
    V_base_TR_1_2_mv = struct[0].V_base_TR_1_2_mv
    S_base_INV_1 = struct[0].S_base_INV_1
    I_max_INV_1 = struct[0].I_max_INV_1
    u_ctrl_v_INV_2 = struct[0].u_ctrl_v_INV_2
    K_p_v_INV_2 = struct[0].K_p_v_INV_2
    K_i_v_INV_2 = struct[0].K_i_v_INV_2
    V_base_INV_2 = struct[0].V_base_INV_2
    S_base_INV_2 = struct[0].S_base_INV_2
    I_max_INV_2 = struct[0].I_max_INV_2
    u_ctrl_v_INV_3 = struct[0].u_ctrl_v_INV_3
    K_p_v_INV_3 = struct[0].K_p_v_INV_3
    K_i_v_INV_3 = struct[0].K_i_v_INV_3
    V_base_INV_3 = struct[0].V_base_INV_3
    V_base_TR_3_4_mv = struct[0].V_base_TR_3_4_mv
    S_base_INV_3 = struct[0].S_base_INV_3
    I_max_INV_3 = struct[0].I_max_INV_3
    u_ctrl_v_INV_4 = struct[0].u_ctrl_v_INV_4
    K_p_v_INV_4 = struct[0].K_p_v_INV_4
    K_i_v_INV_4 = struct[0].K_i_v_INV_4
    V_base_INV_4 = struct[0].V_base_INV_4
    S_base_INV_4 = struct[0].S_base_INV_4
    I_max_INV_4 = struct[0].I_max_INV_4
    u_ctrl_v_INV_5 = struct[0].u_ctrl_v_INV_5
    K_p_v_INV_5 = struct[0].K_p_v_INV_5
    K_i_v_INV_5 = struct[0].K_i_v_INV_5
    V_base_INV_5 = struct[0].V_base_INV_5
    V_base_TR_5_6_mv = struct[0].V_base_TR_5_6_mv
    S_base_INV_5 = struct[0].S_base_INV_5
    I_max_INV_5 = struct[0].I_max_INV_5
    u_ctrl_v_INV_6 = struct[0].u_ctrl_v_INV_6
    K_p_v_INV_6 = struct[0].K_p_v_INV_6
    K_i_v_INV_6 = struct[0].K_i_v_INV_6
    V_base_INV_6 = struct[0].V_base_INV_6
    S_base_INV_6 = struct[0].S_base_INV_6
    I_max_INV_6 = struct[0].I_max_INV_6
    u_ctrl_v_INV_7 = struct[0].u_ctrl_v_INV_7
    K_p_v_INV_7 = struct[0].K_p_v_INV_7
    K_i_v_INV_7 = struct[0].K_i_v_INV_7
    V_base_INV_7 = struct[0].V_base_INV_7
    V_base_TR_7_8_mv = struct[0].V_base_TR_7_8_mv
    S_base_INV_7 = struct[0].S_base_INV_7
    I_max_INV_7 = struct[0].I_max_INV_7
    u_ctrl_v_INV_8 = struct[0].u_ctrl_v_INV_8
    K_p_v_INV_8 = struct[0].K_p_v_INV_8
    K_i_v_INV_8 = struct[0].K_i_v_INV_8
    V_base_INV_8 = struct[0].V_base_INV_8
    S_base_INV_8 = struct[0].S_base_INV_8
    I_max_INV_8 = struct[0].I_max_INV_8
    u_ctrl_v_INV_9 = struct[0].u_ctrl_v_INV_9
    K_p_v_INV_9 = struct[0].K_p_v_INV_9
    K_i_v_INV_9 = struct[0].K_i_v_INV_9
    V_base_INV_9 = struct[0].V_base_INV_9
    V_base_TR_9_10_mv = struct[0].V_base_TR_9_10_mv
    S_base_INV_9 = struct[0].S_base_INV_9
    I_max_INV_9 = struct[0].I_max_INV_9
    u_ctrl_v_INV_10 = struct[0].u_ctrl_v_INV_10
    K_p_v_INV_10 = struct[0].K_p_v_INV_10
    K_i_v_INV_10 = struct[0].K_i_v_INV_10
    V_base_INV_10 = struct[0].V_base_INV_10
    S_base_INV_10 = struct[0].S_base_INV_10
    I_max_INV_10 = struct[0].I_max_INV_10
    u_ctrl_v_INV_11 = struct[0].u_ctrl_v_INV_11
    K_p_v_INV_11 = struct[0].K_p_v_INV_11
    K_i_v_INV_11 = struct[0].K_i_v_INV_11
    V_base_INV_11 = struct[0].V_base_INV_11
    V_base_TR_11_12_mv = struct[0].V_base_TR_11_12_mv
    S_base_INV_11 = struct[0].S_base_INV_11
    I_max_INV_11 = struct[0].I_max_INV_11
    u_ctrl_v_INV_12 = struct[0].u_ctrl_v_INV_12
    K_p_v_INV_12 = struct[0].K_p_v_INV_12
    K_i_v_INV_12 = struct[0].K_i_v_INV_12
    V_base_INV_12 = struct[0].V_base_INV_12
    S_base_INV_12 = struct[0].S_base_INV_12
    I_max_INV_12 = struct[0].I_max_INV_12
    u_ctrl_v_INV_13 = struct[0].u_ctrl_v_INV_13
    K_p_v_INV_13 = struct[0].K_p_v_INV_13
    K_i_v_INV_13 = struct[0].K_i_v_INV_13
    V_base_INV_13 = struct[0].V_base_INV_13
    V_base_TR_13_mv = struct[0].V_base_TR_13_mv
    S_base_INV_13 = struct[0].S_base_INV_13
    I_max_INV_13 = struct[0].I_max_INV_13
    
    # Inputs:
    v_GRID_a_r = struct[0].v_GRID_a_r
    v_GRID_a_i = struct[0].v_GRID_a_i
    v_GRID_b_r = struct[0].v_GRID_b_r
    v_GRID_b_i = struct[0].v_GRID_b_i
    v_GRID_c_r = struct[0].v_GRID_c_r
    v_GRID_c_i = struct[0].v_GRID_c_i
    i_POIhv_a_r = struct[0].i_POIhv_a_r
    i_POIhv_a_i = struct[0].i_POIhv_a_i
    i_POIhv_b_r = struct[0].i_POIhv_b_r
    i_POIhv_b_i = struct[0].i_POIhv_b_i
    i_POIhv_c_r = struct[0].i_POIhv_c_r
    i_POIhv_c_i = struct[0].i_POIhv_c_i
    i_POImv_a_r = struct[0].i_POImv_a_r
    i_POImv_a_i = struct[0].i_POImv_a_i
    i_POImv_b_r = struct[0].i_POImv_b_r
    i_POImv_b_i = struct[0].i_POImv_b_i
    i_POImv_c_r = struct[0].i_POImv_c_r
    i_POImv_c_i = struct[0].i_POImv_c_i
    i_TR_1_2_mv_a_r = struct[0].i_TR_1_2_mv_a_r
    i_TR_1_2_mv_a_i = struct[0].i_TR_1_2_mv_a_i
    i_TR_1_2_mv_b_r = struct[0].i_TR_1_2_mv_b_r
    i_TR_1_2_mv_b_i = struct[0].i_TR_1_2_mv_b_i
    i_TR_1_2_mv_c_r = struct[0].i_TR_1_2_mv_c_r
    i_TR_1_2_mv_c_i = struct[0].i_TR_1_2_mv_c_i
    i_TR_1_2_lv_a_r = struct[0].i_TR_1_2_lv_a_r
    i_TR_1_2_lv_a_i = struct[0].i_TR_1_2_lv_a_i
    i_TR_1_2_lv_b_r = struct[0].i_TR_1_2_lv_b_r
    i_TR_1_2_lv_b_i = struct[0].i_TR_1_2_lv_b_i
    i_TR_1_2_lv_c_r = struct[0].i_TR_1_2_lv_c_r
    i_TR_1_2_lv_c_i = struct[0].i_TR_1_2_lv_c_i
    i_TR_3_4_mv_a_r = struct[0].i_TR_3_4_mv_a_r
    i_TR_3_4_mv_a_i = struct[0].i_TR_3_4_mv_a_i
    i_TR_3_4_mv_b_r = struct[0].i_TR_3_4_mv_b_r
    i_TR_3_4_mv_b_i = struct[0].i_TR_3_4_mv_b_i
    i_TR_3_4_mv_c_r = struct[0].i_TR_3_4_mv_c_r
    i_TR_3_4_mv_c_i = struct[0].i_TR_3_4_mv_c_i
    i_TR_3_4_lv_a_r = struct[0].i_TR_3_4_lv_a_r
    i_TR_3_4_lv_a_i = struct[0].i_TR_3_4_lv_a_i
    i_TR_3_4_lv_b_r = struct[0].i_TR_3_4_lv_b_r
    i_TR_3_4_lv_b_i = struct[0].i_TR_3_4_lv_b_i
    i_TR_3_4_lv_c_r = struct[0].i_TR_3_4_lv_c_r
    i_TR_3_4_lv_c_i = struct[0].i_TR_3_4_lv_c_i
    i_TR_5_6_mv_a_r = struct[0].i_TR_5_6_mv_a_r
    i_TR_5_6_mv_a_i = struct[0].i_TR_5_6_mv_a_i
    i_TR_5_6_mv_b_r = struct[0].i_TR_5_6_mv_b_r
    i_TR_5_6_mv_b_i = struct[0].i_TR_5_6_mv_b_i
    i_TR_5_6_mv_c_r = struct[0].i_TR_5_6_mv_c_r
    i_TR_5_6_mv_c_i = struct[0].i_TR_5_6_mv_c_i
    i_TR_5_6_lv_a_r = struct[0].i_TR_5_6_lv_a_r
    i_TR_5_6_lv_a_i = struct[0].i_TR_5_6_lv_a_i
    i_TR_5_6_lv_b_r = struct[0].i_TR_5_6_lv_b_r
    i_TR_5_6_lv_b_i = struct[0].i_TR_5_6_lv_b_i
    i_TR_5_6_lv_c_r = struct[0].i_TR_5_6_lv_c_r
    i_TR_5_6_lv_c_i = struct[0].i_TR_5_6_lv_c_i
    i_TR_7_8_mv_a_r = struct[0].i_TR_7_8_mv_a_r
    i_TR_7_8_mv_a_i = struct[0].i_TR_7_8_mv_a_i
    i_TR_7_8_mv_b_r = struct[0].i_TR_7_8_mv_b_r
    i_TR_7_8_mv_b_i = struct[0].i_TR_7_8_mv_b_i
    i_TR_7_8_mv_c_r = struct[0].i_TR_7_8_mv_c_r
    i_TR_7_8_mv_c_i = struct[0].i_TR_7_8_mv_c_i
    i_TR_7_8_lv_a_r = struct[0].i_TR_7_8_lv_a_r
    i_TR_7_8_lv_a_i = struct[0].i_TR_7_8_lv_a_i
    i_TR_7_8_lv_b_r = struct[0].i_TR_7_8_lv_b_r
    i_TR_7_8_lv_b_i = struct[0].i_TR_7_8_lv_b_i
    i_TR_7_8_lv_c_r = struct[0].i_TR_7_8_lv_c_r
    i_TR_7_8_lv_c_i = struct[0].i_TR_7_8_lv_c_i
    i_TR_9_10_mv_a_r = struct[0].i_TR_9_10_mv_a_r
    i_TR_9_10_mv_a_i = struct[0].i_TR_9_10_mv_a_i
    i_TR_9_10_mv_b_r = struct[0].i_TR_9_10_mv_b_r
    i_TR_9_10_mv_b_i = struct[0].i_TR_9_10_mv_b_i
    i_TR_9_10_mv_c_r = struct[0].i_TR_9_10_mv_c_r
    i_TR_9_10_mv_c_i = struct[0].i_TR_9_10_mv_c_i
    i_TR_9_10_lv_a_r = struct[0].i_TR_9_10_lv_a_r
    i_TR_9_10_lv_a_i = struct[0].i_TR_9_10_lv_a_i
    i_TR_9_10_lv_b_r = struct[0].i_TR_9_10_lv_b_r
    i_TR_9_10_lv_b_i = struct[0].i_TR_9_10_lv_b_i
    i_TR_9_10_lv_c_r = struct[0].i_TR_9_10_lv_c_r
    i_TR_9_10_lv_c_i = struct[0].i_TR_9_10_lv_c_i
    i_TR_11_12_mv_a_r = struct[0].i_TR_11_12_mv_a_r
    i_TR_11_12_mv_a_i = struct[0].i_TR_11_12_mv_a_i
    i_TR_11_12_mv_b_r = struct[0].i_TR_11_12_mv_b_r
    i_TR_11_12_mv_b_i = struct[0].i_TR_11_12_mv_b_i
    i_TR_11_12_mv_c_r = struct[0].i_TR_11_12_mv_c_r
    i_TR_11_12_mv_c_i = struct[0].i_TR_11_12_mv_c_i
    i_TR_11_12_lv_a_r = struct[0].i_TR_11_12_lv_a_r
    i_TR_11_12_lv_a_i = struct[0].i_TR_11_12_lv_a_i
    i_TR_11_12_lv_b_r = struct[0].i_TR_11_12_lv_b_r
    i_TR_11_12_lv_b_i = struct[0].i_TR_11_12_lv_b_i
    i_TR_11_12_lv_c_r = struct[0].i_TR_11_12_lv_c_r
    i_TR_11_12_lv_c_i = struct[0].i_TR_11_12_lv_c_i
    i_TR_13_mv_a_r = struct[0].i_TR_13_mv_a_r
    i_TR_13_mv_a_i = struct[0].i_TR_13_mv_a_i
    i_TR_13_mv_b_r = struct[0].i_TR_13_mv_b_r
    i_TR_13_mv_b_i = struct[0].i_TR_13_mv_b_i
    i_TR_13_mv_c_r = struct[0].i_TR_13_mv_c_r
    i_TR_13_mv_c_i = struct[0].i_TR_13_mv_c_i
    i_TR_13_lv_a_r = struct[0].i_TR_13_lv_a_r
    i_TR_13_lv_a_i = struct[0].i_TR_13_lv_a_i
    i_TR_13_lv_b_r = struct[0].i_TR_13_lv_b_r
    i_TR_13_lv_b_i = struct[0].i_TR_13_lv_b_i
    i_TR_13_lv_c_r = struct[0].i_TR_13_lv_c_r
    i_TR_13_lv_c_i = struct[0].i_TR_13_lv_c_i
    p_ref_INV_1 = struct[0].p_ref_INV_1
    T_pq_INV_1 = struct[0].T_pq_INV_1
    v_loc_ref_INV_1 = struct[0].v_loc_ref_INV_1
    Dv_r_INV_1 = struct[0].Dv_r_INV_1
    Dq_r_INV_1 = struct[0].Dq_r_INV_1
    p_ref_INV_2 = struct[0].p_ref_INV_2
    T_pq_INV_2 = struct[0].T_pq_INV_2
    v_loc_ref_INV_2 = struct[0].v_loc_ref_INV_2
    Dv_r_INV_2 = struct[0].Dv_r_INV_2
    Dq_r_INV_2 = struct[0].Dq_r_INV_2
    p_ref_INV_3 = struct[0].p_ref_INV_3
    T_pq_INV_3 = struct[0].T_pq_INV_3
    v_loc_ref_INV_3 = struct[0].v_loc_ref_INV_3
    Dv_r_INV_3 = struct[0].Dv_r_INV_3
    Dq_r_INV_3 = struct[0].Dq_r_INV_3
    p_ref_INV_4 = struct[0].p_ref_INV_4
    T_pq_INV_4 = struct[0].T_pq_INV_4
    v_loc_ref_INV_4 = struct[0].v_loc_ref_INV_4
    Dv_r_INV_4 = struct[0].Dv_r_INV_4
    Dq_r_INV_4 = struct[0].Dq_r_INV_4
    p_ref_INV_5 = struct[0].p_ref_INV_5
    T_pq_INV_5 = struct[0].T_pq_INV_5
    v_loc_ref_INV_5 = struct[0].v_loc_ref_INV_5
    Dv_r_INV_5 = struct[0].Dv_r_INV_5
    Dq_r_INV_5 = struct[0].Dq_r_INV_5
    p_ref_INV_6 = struct[0].p_ref_INV_6
    T_pq_INV_6 = struct[0].T_pq_INV_6
    v_loc_ref_INV_6 = struct[0].v_loc_ref_INV_6
    Dv_r_INV_6 = struct[0].Dv_r_INV_6
    Dq_r_INV_6 = struct[0].Dq_r_INV_6
    p_ref_INV_7 = struct[0].p_ref_INV_7
    T_pq_INV_7 = struct[0].T_pq_INV_7
    v_loc_ref_INV_7 = struct[0].v_loc_ref_INV_7
    Dv_r_INV_7 = struct[0].Dv_r_INV_7
    Dq_r_INV_7 = struct[0].Dq_r_INV_7
    p_ref_INV_8 = struct[0].p_ref_INV_8
    T_pq_INV_8 = struct[0].T_pq_INV_8
    v_loc_ref_INV_8 = struct[0].v_loc_ref_INV_8
    Dv_r_INV_8 = struct[0].Dv_r_INV_8
    Dq_r_INV_8 = struct[0].Dq_r_INV_8
    p_ref_INV_9 = struct[0].p_ref_INV_9
    T_pq_INV_9 = struct[0].T_pq_INV_9
    v_loc_ref_INV_9 = struct[0].v_loc_ref_INV_9
    Dv_r_INV_9 = struct[0].Dv_r_INV_9
    Dq_r_INV_9 = struct[0].Dq_r_INV_9
    p_ref_INV_10 = struct[0].p_ref_INV_10
    T_pq_INV_10 = struct[0].T_pq_INV_10
    v_loc_ref_INV_10 = struct[0].v_loc_ref_INV_10
    Dv_r_INV_10 = struct[0].Dv_r_INV_10
    Dq_r_INV_10 = struct[0].Dq_r_INV_10
    p_ref_INV_11 = struct[0].p_ref_INV_11
    T_pq_INV_11 = struct[0].T_pq_INV_11
    v_loc_ref_INV_11 = struct[0].v_loc_ref_INV_11
    Dv_r_INV_11 = struct[0].Dv_r_INV_11
    Dq_r_INV_11 = struct[0].Dq_r_INV_11
    p_ref_INV_12 = struct[0].p_ref_INV_12
    T_pq_INV_12 = struct[0].T_pq_INV_12
    v_loc_ref_INV_12 = struct[0].v_loc_ref_INV_12
    Dv_r_INV_12 = struct[0].Dv_r_INV_12
    Dq_r_INV_12 = struct[0].Dq_r_INV_12
    p_ref_INV_13 = struct[0].p_ref_INV_13
    T_pq_INV_13 = struct[0].T_pq_INV_13
    v_loc_ref_INV_13 = struct[0].v_loc_ref_INV_13
    Dv_r_INV_13 = struct[0].Dv_r_INV_13
    Dq_r_INV_13 = struct[0].Dq_r_INV_13
    
    # Dynamical states:
    p_INV_1_a = struct[0].x[0,0]
    p_INV_1_b = struct[0].x[1,0]
    p_INV_1_c = struct[0].x[2,0]
    q_INV_1_a = struct[0].x[3,0]
    q_INV_1_b = struct[0].x[4,0]
    q_INV_1_c = struct[0].x[5,0]
    p_INV_2_a = struct[0].x[6,0]
    p_INV_2_b = struct[0].x[7,0]
    p_INV_2_c = struct[0].x[8,0]
    q_INV_2_a = struct[0].x[9,0]
    q_INV_2_b = struct[0].x[10,0]
    q_INV_2_c = struct[0].x[11,0]
    p_INV_3_a = struct[0].x[12,0]
    p_INV_3_b = struct[0].x[13,0]
    p_INV_3_c = struct[0].x[14,0]
    q_INV_3_a = struct[0].x[15,0]
    q_INV_3_b = struct[0].x[16,0]
    q_INV_3_c = struct[0].x[17,0]
    p_INV_4_a = struct[0].x[18,0]
    p_INV_4_b = struct[0].x[19,0]
    p_INV_4_c = struct[0].x[20,0]
    q_INV_4_a = struct[0].x[21,0]
    q_INV_4_b = struct[0].x[22,0]
    q_INV_4_c = struct[0].x[23,0]
    p_INV_5_a = struct[0].x[24,0]
    p_INV_5_b = struct[0].x[25,0]
    p_INV_5_c = struct[0].x[26,0]
    q_INV_5_a = struct[0].x[27,0]
    q_INV_5_b = struct[0].x[28,0]
    q_INV_5_c = struct[0].x[29,0]
    p_INV_6_a = struct[0].x[30,0]
    p_INV_6_b = struct[0].x[31,0]
    p_INV_6_c = struct[0].x[32,0]
    q_INV_6_a = struct[0].x[33,0]
    q_INV_6_b = struct[0].x[34,0]
    q_INV_6_c = struct[0].x[35,0]
    p_INV_7_a = struct[0].x[36,0]
    p_INV_7_b = struct[0].x[37,0]
    p_INV_7_c = struct[0].x[38,0]
    q_INV_7_a = struct[0].x[39,0]
    q_INV_7_b = struct[0].x[40,0]
    q_INV_7_c = struct[0].x[41,0]
    p_INV_8_a = struct[0].x[42,0]
    p_INV_8_b = struct[0].x[43,0]
    p_INV_8_c = struct[0].x[44,0]
    q_INV_8_a = struct[0].x[45,0]
    q_INV_8_b = struct[0].x[46,0]
    q_INV_8_c = struct[0].x[47,0]
    p_INV_9_a = struct[0].x[48,0]
    p_INV_9_b = struct[0].x[49,0]
    p_INV_9_c = struct[0].x[50,0]
    q_INV_9_a = struct[0].x[51,0]
    q_INV_9_b = struct[0].x[52,0]
    q_INV_9_c = struct[0].x[53,0]
    p_INV_10_a = struct[0].x[54,0]
    p_INV_10_b = struct[0].x[55,0]
    p_INV_10_c = struct[0].x[56,0]
    q_INV_10_a = struct[0].x[57,0]
    q_INV_10_b = struct[0].x[58,0]
    q_INV_10_c = struct[0].x[59,0]
    p_INV_11_a = struct[0].x[60,0]
    p_INV_11_b = struct[0].x[61,0]
    p_INV_11_c = struct[0].x[62,0]
    q_INV_11_a = struct[0].x[63,0]
    q_INV_11_b = struct[0].x[64,0]
    q_INV_11_c = struct[0].x[65,0]
    p_INV_12_a = struct[0].x[66,0]
    p_INV_12_b = struct[0].x[67,0]
    p_INV_12_c = struct[0].x[68,0]
    q_INV_12_a = struct[0].x[69,0]
    q_INV_12_b = struct[0].x[70,0]
    q_INV_12_c = struct[0].x[71,0]
    p_INV_13_a = struct[0].x[72,0]
    p_INV_13_b = struct[0].x[73,0]
    p_INV_13_c = struct[0].x[74,0]
    q_INV_13_a = struct[0].x[75,0]
    q_INV_13_b = struct[0].x[76,0]
    q_INV_13_c = struct[0].x[77,0]
    
    # Algebraic states:
    v_INV_1_a_r = struct[0].y_ini[0,0]
    v_INV_1_a_i = struct[0].y_ini[1,0]
    v_INV_1_b_r = struct[0].y_ini[2,0]
    v_INV_1_b_i = struct[0].y_ini[3,0]
    v_INV_1_c_r = struct[0].y_ini[4,0]
    v_INV_1_c_i = struct[0].y_ini[5,0]
    v_INV_2_a_r = struct[0].y_ini[6,0]
    v_INV_2_a_i = struct[0].y_ini[7,0]
    v_INV_2_b_r = struct[0].y_ini[8,0]
    v_INV_2_b_i = struct[0].y_ini[9,0]
    v_INV_2_c_r = struct[0].y_ini[10,0]
    v_INV_2_c_i = struct[0].y_ini[11,0]
    v_INV_3_a_r = struct[0].y_ini[12,0]
    v_INV_3_a_i = struct[0].y_ini[13,0]
    v_INV_3_b_r = struct[0].y_ini[14,0]
    v_INV_3_b_i = struct[0].y_ini[15,0]
    v_INV_3_c_r = struct[0].y_ini[16,0]
    v_INV_3_c_i = struct[0].y_ini[17,0]
    v_INV_4_a_r = struct[0].y_ini[18,0]
    v_INV_4_a_i = struct[0].y_ini[19,0]
    v_INV_4_b_r = struct[0].y_ini[20,0]
    v_INV_4_b_i = struct[0].y_ini[21,0]
    v_INV_4_c_r = struct[0].y_ini[22,0]
    v_INV_4_c_i = struct[0].y_ini[23,0]
    v_INV_5_a_r = struct[0].y_ini[24,0]
    v_INV_5_a_i = struct[0].y_ini[25,0]
    v_INV_5_b_r = struct[0].y_ini[26,0]
    v_INV_5_b_i = struct[0].y_ini[27,0]
    v_INV_5_c_r = struct[0].y_ini[28,0]
    v_INV_5_c_i = struct[0].y_ini[29,0]
    v_INV_6_a_r = struct[0].y_ini[30,0]
    v_INV_6_a_i = struct[0].y_ini[31,0]
    v_INV_6_b_r = struct[0].y_ini[32,0]
    v_INV_6_b_i = struct[0].y_ini[33,0]
    v_INV_6_c_r = struct[0].y_ini[34,0]
    v_INV_6_c_i = struct[0].y_ini[35,0]
    v_INV_7_a_r = struct[0].y_ini[36,0]
    v_INV_7_a_i = struct[0].y_ini[37,0]
    v_INV_7_b_r = struct[0].y_ini[38,0]
    v_INV_7_b_i = struct[0].y_ini[39,0]
    v_INV_7_c_r = struct[0].y_ini[40,0]
    v_INV_7_c_i = struct[0].y_ini[41,0]
    v_INV_8_a_r = struct[0].y_ini[42,0]
    v_INV_8_a_i = struct[0].y_ini[43,0]
    v_INV_8_b_r = struct[0].y_ini[44,0]
    v_INV_8_b_i = struct[0].y_ini[45,0]
    v_INV_8_c_r = struct[0].y_ini[46,0]
    v_INV_8_c_i = struct[0].y_ini[47,0]
    v_INV_9_a_r = struct[0].y_ini[48,0]
    v_INV_9_a_i = struct[0].y_ini[49,0]
    v_INV_9_b_r = struct[0].y_ini[50,0]
    v_INV_9_b_i = struct[0].y_ini[51,0]
    v_INV_9_c_r = struct[0].y_ini[52,0]
    v_INV_9_c_i = struct[0].y_ini[53,0]
    v_INV_10_a_r = struct[0].y_ini[54,0]
    v_INV_10_a_i = struct[0].y_ini[55,0]
    v_INV_10_b_r = struct[0].y_ini[56,0]
    v_INV_10_b_i = struct[0].y_ini[57,0]
    v_INV_10_c_r = struct[0].y_ini[58,0]
    v_INV_10_c_i = struct[0].y_ini[59,0]
    v_INV_11_a_r = struct[0].y_ini[60,0]
    v_INV_11_a_i = struct[0].y_ini[61,0]
    v_INV_11_b_r = struct[0].y_ini[62,0]
    v_INV_11_b_i = struct[0].y_ini[63,0]
    v_INV_11_c_r = struct[0].y_ini[64,0]
    v_INV_11_c_i = struct[0].y_ini[65,0]
    v_INV_12_a_r = struct[0].y_ini[66,0]
    v_INV_12_a_i = struct[0].y_ini[67,0]
    v_INV_12_b_r = struct[0].y_ini[68,0]
    v_INV_12_b_i = struct[0].y_ini[69,0]
    v_INV_12_c_r = struct[0].y_ini[70,0]
    v_INV_12_c_i = struct[0].y_ini[71,0]
    v_INV_13_a_r = struct[0].y_ini[72,0]
    v_INV_13_a_i = struct[0].y_ini[73,0]
    v_INV_13_b_r = struct[0].y_ini[74,0]
    v_INV_13_b_i = struct[0].y_ini[75,0]
    v_INV_13_c_r = struct[0].y_ini[76,0]
    v_INV_13_c_i = struct[0].y_ini[77,0]
    v_POIhv_a_r = struct[0].y_ini[78,0]
    v_POIhv_a_i = struct[0].y_ini[79,0]
    v_POIhv_b_r = struct[0].y_ini[80,0]
    v_POIhv_b_i = struct[0].y_ini[81,0]
    v_POIhv_c_r = struct[0].y_ini[82,0]
    v_POIhv_c_i = struct[0].y_ini[83,0]
    v_POImv_a_r = struct[0].y_ini[84,0]
    v_POImv_a_i = struct[0].y_ini[85,0]
    v_POImv_b_r = struct[0].y_ini[86,0]
    v_POImv_b_i = struct[0].y_ini[87,0]
    v_POImv_c_r = struct[0].y_ini[88,0]
    v_POImv_c_i = struct[0].y_ini[89,0]
    v_TR_1_2_mv_a_r = struct[0].y_ini[90,0]
    v_TR_1_2_mv_a_i = struct[0].y_ini[91,0]
    v_TR_1_2_mv_b_r = struct[0].y_ini[92,0]
    v_TR_1_2_mv_b_i = struct[0].y_ini[93,0]
    v_TR_1_2_mv_c_r = struct[0].y_ini[94,0]
    v_TR_1_2_mv_c_i = struct[0].y_ini[95,0]
    v_TR_1_2_lv_a_r = struct[0].y_ini[96,0]
    v_TR_1_2_lv_a_i = struct[0].y_ini[97,0]
    v_TR_1_2_lv_b_r = struct[0].y_ini[98,0]
    v_TR_1_2_lv_b_i = struct[0].y_ini[99,0]
    v_TR_1_2_lv_c_r = struct[0].y_ini[100,0]
    v_TR_1_2_lv_c_i = struct[0].y_ini[101,0]
    v_TR_3_4_mv_a_r = struct[0].y_ini[102,0]
    v_TR_3_4_mv_a_i = struct[0].y_ini[103,0]
    v_TR_3_4_mv_b_r = struct[0].y_ini[104,0]
    v_TR_3_4_mv_b_i = struct[0].y_ini[105,0]
    v_TR_3_4_mv_c_r = struct[0].y_ini[106,0]
    v_TR_3_4_mv_c_i = struct[0].y_ini[107,0]
    v_TR_3_4_lv_a_r = struct[0].y_ini[108,0]
    v_TR_3_4_lv_a_i = struct[0].y_ini[109,0]
    v_TR_3_4_lv_b_r = struct[0].y_ini[110,0]
    v_TR_3_4_lv_b_i = struct[0].y_ini[111,0]
    v_TR_3_4_lv_c_r = struct[0].y_ini[112,0]
    v_TR_3_4_lv_c_i = struct[0].y_ini[113,0]
    v_TR_5_6_mv_a_r = struct[0].y_ini[114,0]
    v_TR_5_6_mv_a_i = struct[0].y_ini[115,0]
    v_TR_5_6_mv_b_r = struct[0].y_ini[116,0]
    v_TR_5_6_mv_b_i = struct[0].y_ini[117,0]
    v_TR_5_6_mv_c_r = struct[0].y_ini[118,0]
    v_TR_5_6_mv_c_i = struct[0].y_ini[119,0]
    v_TR_5_6_lv_a_r = struct[0].y_ini[120,0]
    v_TR_5_6_lv_a_i = struct[0].y_ini[121,0]
    v_TR_5_6_lv_b_r = struct[0].y_ini[122,0]
    v_TR_5_6_lv_b_i = struct[0].y_ini[123,0]
    v_TR_5_6_lv_c_r = struct[0].y_ini[124,0]
    v_TR_5_6_lv_c_i = struct[0].y_ini[125,0]
    v_TR_7_8_mv_a_r = struct[0].y_ini[126,0]
    v_TR_7_8_mv_a_i = struct[0].y_ini[127,0]
    v_TR_7_8_mv_b_r = struct[0].y_ini[128,0]
    v_TR_7_8_mv_b_i = struct[0].y_ini[129,0]
    v_TR_7_8_mv_c_r = struct[0].y_ini[130,0]
    v_TR_7_8_mv_c_i = struct[0].y_ini[131,0]
    v_TR_7_8_lv_a_r = struct[0].y_ini[132,0]
    v_TR_7_8_lv_a_i = struct[0].y_ini[133,0]
    v_TR_7_8_lv_b_r = struct[0].y_ini[134,0]
    v_TR_7_8_lv_b_i = struct[0].y_ini[135,0]
    v_TR_7_8_lv_c_r = struct[0].y_ini[136,0]
    v_TR_7_8_lv_c_i = struct[0].y_ini[137,0]
    v_TR_9_10_mv_a_r = struct[0].y_ini[138,0]
    v_TR_9_10_mv_a_i = struct[0].y_ini[139,0]
    v_TR_9_10_mv_b_r = struct[0].y_ini[140,0]
    v_TR_9_10_mv_b_i = struct[0].y_ini[141,0]
    v_TR_9_10_mv_c_r = struct[0].y_ini[142,0]
    v_TR_9_10_mv_c_i = struct[0].y_ini[143,0]
    v_TR_9_10_lv_a_r = struct[0].y_ini[144,0]
    v_TR_9_10_lv_a_i = struct[0].y_ini[145,0]
    v_TR_9_10_lv_b_r = struct[0].y_ini[146,0]
    v_TR_9_10_lv_b_i = struct[0].y_ini[147,0]
    v_TR_9_10_lv_c_r = struct[0].y_ini[148,0]
    v_TR_9_10_lv_c_i = struct[0].y_ini[149,0]
    v_TR_11_12_mv_a_r = struct[0].y_ini[150,0]
    v_TR_11_12_mv_a_i = struct[0].y_ini[151,0]
    v_TR_11_12_mv_b_r = struct[0].y_ini[152,0]
    v_TR_11_12_mv_b_i = struct[0].y_ini[153,0]
    v_TR_11_12_mv_c_r = struct[0].y_ini[154,0]
    v_TR_11_12_mv_c_i = struct[0].y_ini[155,0]
    v_TR_11_12_lv_a_r = struct[0].y_ini[156,0]
    v_TR_11_12_lv_a_i = struct[0].y_ini[157,0]
    v_TR_11_12_lv_b_r = struct[0].y_ini[158,0]
    v_TR_11_12_lv_b_i = struct[0].y_ini[159,0]
    v_TR_11_12_lv_c_r = struct[0].y_ini[160,0]
    v_TR_11_12_lv_c_i = struct[0].y_ini[161,0]
    v_TR_13_mv_a_r = struct[0].y_ini[162,0]
    v_TR_13_mv_a_i = struct[0].y_ini[163,0]
    v_TR_13_mv_b_r = struct[0].y_ini[164,0]
    v_TR_13_mv_b_i = struct[0].y_ini[165,0]
    v_TR_13_mv_c_r = struct[0].y_ini[166,0]
    v_TR_13_mv_c_i = struct[0].y_ini[167,0]
    v_TR_13_lv_a_r = struct[0].y_ini[168,0]
    v_TR_13_lv_a_i = struct[0].y_ini[169,0]
    v_TR_13_lv_b_r = struct[0].y_ini[170,0]
    v_TR_13_lv_b_i = struct[0].y_ini[171,0]
    v_TR_13_lv_c_r = struct[0].y_ini[172,0]
    v_TR_13_lv_c_i = struct[0].y_ini[173,0]
    i_INV_1_a_r = struct[0].y_ini[174,0]
    i_INV_1_a_i = struct[0].y_ini[175,0]
    i_INV_1_b_r = struct[0].y_ini[176,0]
    i_INV_1_b_i = struct[0].y_ini[177,0]
    i_INV_1_c_r = struct[0].y_ini[178,0]
    i_INV_1_c_i = struct[0].y_ini[179,0]
    v_m_INV_1 = struct[0].y_ini[180,0]
    v_m_TR_1_2_mv = struct[0].y_ini[181,0]
    i_reac_ref_INV_1 = struct[0].y_ini[182,0]
    q_ref_INV_1 = struct[0].y_ini[183,0]
    i_INV_2_a_r = struct[0].y_ini[184,0]
    i_INV_2_a_i = struct[0].y_ini[185,0]
    i_INV_2_b_r = struct[0].y_ini[186,0]
    i_INV_2_b_i = struct[0].y_ini[187,0]
    i_INV_2_c_r = struct[0].y_ini[188,0]
    i_INV_2_c_i = struct[0].y_ini[189,0]
    v_m_INV_2 = struct[0].y_ini[190,0]
    i_reac_ref_INV_2 = struct[0].y_ini[191,0]
    q_ref_INV_2 = struct[0].y_ini[192,0]
    i_INV_3_a_r = struct[0].y_ini[193,0]
    i_INV_3_a_i = struct[0].y_ini[194,0]
    i_INV_3_b_r = struct[0].y_ini[195,0]
    i_INV_3_b_i = struct[0].y_ini[196,0]
    i_INV_3_c_r = struct[0].y_ini[197,0]
    i_INV_3_c_i = struct[0].y_ini[198,0]
    v_m_INV_3 = struct[0].y_ini[199,0]
    v_m_TR_3_4_mv = struct[0].y_ini[200,0]
    i_reac_ref_INV_3 = struct[0].y_ini[201,0]
    q_ref_INV_3 = struct[0].y_ini[202,0]
    i_INV_4_a_r = struct[0].y_ini[203,0]
    i_INV_4_a_i = struct[0].y_ini[204,0]
    i_INV_4_b_r = struct[0].y_ini[205,0]
    i_INV_4_b_i = struct[0].y_ini[206,0]
    i_INV_4_c_r = struct[0].y_ini[207,0]
    i_INV_4_c_i = struct[0].y_ini[208,0]
    v_m_INV_4 = struct[0].y_ini[209,0]
    i_reac_ref_INV_4 = struct[0].y_ini[210,0]
    q_ref_INV_4 = struct[0].y_ini[211,0]
    i_INV_5_a_r = struct[0].y_ini[212,0]
    i_INV_5_a_i = struct[0].y_ini[213,0]
    i_INV_5_b_r = struct[0].y_ini[214,0]
    i_INV_5_b_i = struct[0].y_ini[215,0]
    i_INV_5_c_r = struct[0].y_ini[216,0]
    i_INV_5_c_i = struct[0].y_ini[217,0]
    v_m_INV_5 = struct[0].y_ini[218,0]
    v_m_TR_5_6_mv = struct[0].y_ini[219,0]
    i_reac_ref_INV_5 = struct[0].y_ini[220,0]
    q_ref_INV_5 = struct[0].y_ini[221,0]
    i_INV_6_a_r = struct[0].y_ini[222,0]
    i_INV_6_a_i = struct[0].y_ini[223,0]
    i_INV_6_b_r = struct[0].y_ini[224,0]
    i_INV_6_b_i = struct[0].y_ini[225,0]
    i_INV_6_c_r = struct[0].y_ini[226,0]
    i_INV_6_c_i = struct[0].y_ini[227,0]
    v_m_INV_6 = struct[0].y_ini[228,0]
    i_reac_ref_INV_6 = struct[0].y_ini[229,0]
    q_ref_INV_6 = struct[0].y_ini[230,0]
    i_INV_7_a_r = struct[0].y_ini[231,0]
    i_INV_7_a_i = struct[0].y_ini[232,0]
    i_INV_7_b_r = struct[0].y_ini[233,0]
    i_INV_7_b_i = struct[0].y_ini[234,0]
    i_INV_7_c_r = struct[0].y_ini[235,0]
    i_INV_7_c_i = struct[0].y_ini[236,0]
    v_m_INV_7 = struct[0].y_ini[237,0]
    v_m_TR_7_8_mv = struct[0].y_ini[238,0]
    i_reac_ref_INV_7 = struct[0].y_ini[239,0]
    q_ref_INV_7 = struct[0].y_ini[240,0]
    i_INV_8_a_r = struct[0].y_ini[241,0]
    i_INV_8_a_i = struct[0].y_ini[242,0]
    i_INV_8_b_r = struct[0].y_ini[243,0]
    i_INV_8_b_i = struct[0].y_ini[244,0]
    i_INV_8_c_r = struct[0].y_ini[245,0]
    i_INV_8_c_i = struct[0].y_ini[246,0]
    v_m_INV_8 = struct[0].y_ini[247,0]
    i_reac_ref_INV_8 = struct[0].y_ini[248,0]
    q_ref_INV_8 = struct[0].y_ini[249,0]
    i_INV_9_a_r = struct[0].y_ini[250,0]
    i_INV_9_a_i = struct[0].y_ini[251,0]
    i_INV_9_b_r = struct[0].y_ini[252,0]
    i_INV_9_b_i = struct[0].y_ini[253,0]
    i_INV_9_c_r = struct[0].y_ini[254,0]
    i_INV_9_c_i = struct[0].y_ini[255,0]
    v_m_INV_9 = struct[0].y_ini[256,0]
    v_m_TR_9_10_mv = struct[0].y_ini[257,0]
    i_reac_ref_INV_9 = struct[0].y_ini[258,0]
    q_ref_INV_9 = struct[0].y_ini[259,0]
    i_INV_10_a_r = struct[0].y_ini[260,0]
    i_INV_10_a_i = struct[0].y_ini[261,0]
    i_INV_10_b_r = struct[0].y_ini[262,0]
    i_INV_10_b_i = struct[0].y_ini[263,0]
    i_INV_10_c_r = struct[0].y_ini[264,0]
    i_INV_10_c_i = struct[0].y_ini[265,0]
    v_m_INV_10 = struct[0].y_ini[266,0]
    i_reac_ref_INV_10 = struct[0].y_ini[267,0]
    q_ref_INV_10 = struct[0].y_ini[268,0]
    i_INV_11_a_r = struct[0].y_ini[269,0]
    i_INV_11_a_i = struct[0].y_ini[270,0]
    i_INV_11_b_r = struct[0].y_ini[271,0]
    i_INV_11_b_i = struct[0].y_ini[272,0]
    i_INV_11_c_r = struct[0].y_ini[273,0]
    i_INV_11_c_i = struct[0].y_ini[274,0]
    v_m_INV_11 = struct[0].y_ini[275,0]
    v_m_TR_11_12_mv = struct[0].y_ini[276,0]
    i_reac_ref_INV_11 = struct[0].y_ini[277,0]
    q_ref_INV_11 = struct[0].y_ini[278,0]
    i_INV_12_a_r = struct[0].y_ini[279,0]
    i_INV_12_a_i = struct[0].y_ini[280,0]
    i_INV_12_b_r = struct[0].y_ini[281,0]
    i_INV_12_b_i = struct[0].y_ini[282,0]
    i_INV_12_c_r = struct[0].y_ini[283,0]
    i_INV_12_c_i = struct[0].y_ini[284,0]
    v_m_INV_12 = struct[0].y_ini[285,0]
    i_reac_ref_INV_12 = struct[0].y_ini[286,0]
    q_ref_INV_12 = struct[0].y_ini[287,0]
    i_INV_13_a_r = struct[0].y_ini[288,0]
    i_INV_13_a_i = struct[0].y_ini[289,0]
    i_INV_13_b_r = struct[0].y_ini[290,0]
    i_INV_13_b_i = struct[0].y_ini[291,0]
    i_INV_13_c_r = struct[0].y_ini[292,0]
    i_INV_13_c_i = struct[0].y_ini[293,0]
    v_m_INV_13 = struct[0].y_ini[294,0]
    v_m_TR_13_mv = struct[0].y_ini[295,0]
    i_reac_ref_INV_13 = struct[0].y_ini[296,0]
    q_ref_INV_13 = struct[0].y_ini[297,0]
    
    # Differential equations:
    if mode == 2:


        struct[0].f[0,0] = (-p_INV_1_a + p_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[1,0] = (-p_INV_1_b + p_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[2,0] = (-p_INV_1_c + p_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[3,0] = (-q_INV_1_a + q_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[4,0] = (-q_INV_1_b + q_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[5,0] = (-q_INV_1_c + q_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[6,0] = (-p_INV_2_a + p_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[7,0] = (-p_INV_2_b + p_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[8,0] = (-p_INV_2_c + p_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[9,0] = (-q_INV_2_a + q_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[10,0] = (-q_INV_2_b + q_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[11,0] = (-q_INV_2_c + q_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[12,0] = (-p_INV_3_a + p_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[13,0] = (-p_INV_3_b + p_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[14,0] = (-p_INV_3_c + p_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[15,0] = (-q_INV_3_a + q_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[16,0] = (-q_INV_3_b + q_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[17,0] = (-q_INV_3_c + q_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[18,0] = (-p_INV_4_a + p_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[19,0] = (-p_INV_4_b + p_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[20,0] = (-p_INV_4_c + p_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[21,0] = (-q_INV_4_a + q_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[22,0] = (-q_INV_4_b + q_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[23,0] = (-q_INV_4_c + q_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[24,0] = (-p_INV_5_a + p_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[25,0] = (-p_INV_5_b + p_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[26,0] = (-p_INV_5_c + p_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[27,0] = (-q_INV_5_a + q_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[28,0] = (-q_INV_5_b + q_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[29,0] = (-q_INV_5_c + q_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[30,0] = (-p_INV_6_a + p_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[31,0] = (-p_INV_6_b + p_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[32,0] = (-p_INV_6_c + p_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[33,0] = (-q_INV_6_a + q_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[34,0] = (-q_INV_6_b + q_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[35,0] = (-q_INV_6_c + q_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[36,0] = (-p_INV_7_a + p_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[37,0] = (-p_INV_7_b + p_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[38,0] = (-p_INV_7_c + p_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[39,0] = (-q_INV_7_a + q_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[40,0] = (-q_INV_7_b + q_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[41,0] = (-q_INV_7_c + q_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[42,0] = (-p_INV_8_a + p_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[43,0] = (-p_INV_8_b + p_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[44,0] = (-p_INV_8_c + p_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[45,0] = (-q_INV_8_a + q_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[46,0] = (-q_INV_8_b + q_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[47,0] = (-q_INV_8_c + q_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[48,0] = (-p_INV_9_a + p_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[49,0] = (-p_INV_9_b + p_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[50,0] = (-p_INV_9_c + p_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[51,0] = (-q_INV_9_a + q_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[52,0] = (-q_INV_9_b + q_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[53,0] = (-q_INV_9_c + q_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[54,0] = (-p_INV_10_a + p_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[55,0] = (-p_INV_10_b + p_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[56,0] = (-p_INV_10_c + p_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[57,0] = (-q_INV_10_a + q_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[58,0] = (-q_INV_10_b + q_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[59,0] = (-q_INV_10_c + q_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[60,0] = (-p_INV_11_a + p_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[61,0] = (-p_INV_11_b + p_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[62,0] = (-p_INV_11_c + p_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[63,0] = (-q_INV_11_a + q_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[64,0] = (-q_INV_11_b + q_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[65,0] = (-q_INV_11_c + q_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[66,0] = (-p_INV_12_a + p_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[67,0] = (-p_INV_12_b + p_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[68,0] = (-p_INV_12_c + p_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[69,0] = (-q_INV_12_a + q_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[70,0] = (-q_INV_12_b + q_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[71,0] = (-q_INV_12_c + q_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[72,0] = (-p_INV_13_a + p_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[73,0] = (-p_INV_13_b + p_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[74,0] = (-p_INV_13_c + p_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[75,0] = (-q_INV_13_a + q_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[76,0] = (-q_INV_13_b + q_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[77,0] = (-q_INV_13_c + q_ref_INV_13/3)/T_pq_INV_13
    
    # Algebraic equations:
    if mode == 3:


        struct[0].g[0,0] = i_INV_1_a_r - 89.5459479864169*v_INV_1_a_i - 172.82391182454*v_INV_1_a_r + 25.5846390702588*v_INV_1_b_i + 49.3782605212972*v_INV_1_b_r + 25.5846390702587*v_INV_1_c_i + 49.3782605212972*v_INV_1_c_r + 89.5460683028705*v_TR_1_2_lv_a_i + 172.82391182454*v_TR_1_2_lv_a_r - 25.5845909436773*v_TR_1_2_lv_b_i - 49.3782605212972*v_TR_1_2_lv_b_r - 25.5845909436773*v_TR_1_2_lv_c_i - 49.3782605212972*v_TR_1_2_lv_c_r
        struct[0].g[1,0] = i_INV_1_a_i - 172.82391182454*v_INV_1_a_i + 89.5459479864169*v_INV_1_a_r + 49.3782605212972*v_INV_1_b_i - 25.5846390702588*v_INV_1_b_r + 49.3782605212972*v_INV_1_c_i - 25.5846390702587*v_INV_1_c_r + 172.82391182454*v_TR_1_2_lv_a_i - 89.5460683028705*v_TR_1_2_lv_a_r - 49.3782605212972*v_TR_1_2_lv_b_i + 25.5845909436773*v_TR_1_2_lv_b_r - 49.3782605212972*v_TR_1_2_lv_c_i + 25.5845909436773*v_TR_1_2_lv_c_r
        struct[0].g[2,0] = i_INV_1_b_r + 25.5846390702587*v_INV_1_a_i + 49.3782605212972*v_INV_1_a_r - 89.5459479864168*v_INV_1_b_i - 172.82391182454*v_INV_1_b_r + 25.5846390702587*v_INV_1_c_i + 49.3782605212973*v_INV_1_c_r - 25.5845909436773*v_TR_1_2_lv_a_i - 49.3782605212972*v_TR_1_2_lv_a_r + 89.5460683028705*v_TR_1_2_lv_b_i + 172.82391182454*v_TR_1_2_lv_b_r - 25.5845909436773*v_TR_1_2_lv_c_i - 49.3782605212973*v_TR_1_2_lv_c_r
        struct[0].g[3,0] = i_INV_1_b_i + 49.3782605212972*v_INV_1_a_i - 25.5846390702587*v_INV_1_a_r - 172.82391182454*v_INV_1_b_i + 89.5459479864168*v_INV_1_b_r + 49.3782605212973*v_INV_1_c_i - 25.5846390702587*v_INV_1_c_r - 49.3782605212972*v_TR_1_2_lv_a_i + 25.5845909436773*v_TR_1_2_lv_a_r + 172.82391182454*v_TR_1_2_lv_b_i - 89.5460683028705*v_TR_1_2_lv_b_r - 49.3782605212973*v_TR_1_2_lv_c_i + 25.5845909436773*v_TR_1_2_lv_c_r
        struct[0].g[4,0] = i_INV_1_c_r + 25.5846390702588*v_INV_1_a_i + 49.3782605212972*v_INV_1_a_r + 25.5846390702587*v_INV_1_b_i + 49.3782605212973*v_INV_1_b_r - 89.5459479864168*v_INV_1_c_i - 172.82391182454*v_INV_1_c_r - 25.5845909436773*v_TR_1_2_lv_a_i - 49.3782605212972*v_TR_1_2_lv_a_r - 25.5845909436772*v_TR_1_2_lv_b_i - 49.3782605212973*v_TR_1_2_lv_b_r + 89.5460683028705*v_TR_1_2_lv_c_i + 172.82391182454*v_TR_1_2_lv_c_r
        struct[0].g[5,0] = i_INV_1_c_i + 49.3782605212972*v_INV_1_a_i - 25.5846390702588*v_INV_1_a_r + 49.3782605212973*v_INV_1_b_i - 25.5846390702587*v_INV_1_b_r - 172.82391182454*v_INV_1_c_i + 89.5459479864168*v_INV_1_c_r - 49.3782605212972*v_TR_1_2_lv_a_i + 25.5845909436773*v_TR_1_2_lv_a_r - 49.3782605212973*v_TR_1_2_lv_b_i + 25.5845909436772*v_TR_1_2_lv_b_r + 172.82391182454*v_TR_1_2_lv_c_i - 89.5460683028705*v_TR_1_2_lv_c_r
        struct[0].g[6,0] = i_INV_2_a_r - 97.8437661123124*v_INV_2_a_i - 188.83868111451*v_INV_2_a_r + 27.9554372523104*v_INV_2_b_i + 53.9539088898601*v_INV_2_b_r + 27.9554372523104*v_INV_2_c_i + 53.9539088898601*v_INV_2_c_r + 97.8438762251349*v_TR_1_2_lv_a_i + 188.83868111451*v_TR_1_2_lv_a_r - 27.9553932071814*v_TR_1_2_lv_b_i - 53.9539088898601*v_TR_1_2_lv_b_r - 27.9553932071814*v_TR_1_2_lv_c_i - 53.9539088898601*v_TR_1_2_lv_c_r
        struct[0].g[7,0] = i_INV_2_a_i - 188.83868111451*v_INV_2_a_i + 97.8437661123124*v_INV_2_a_r + 53.9539088898601*v_INV_2_b_i - 27.9554372523104*v_INV_2_b_r + 53.9539088898601*v_INV_2_c_i - 27.9554372523104*v_INV_2_c_r + 188.83868111451*v_TR_1_2_lv_a_i - 97.8438762251349*v_TR_1_2_lv_a_r - 53.9539088898601*v_TR_1_2_lv_b_i + 27.9553932071814*v_TR_1_2_lv_b_r - 53.9539088898601*v_TR_1_2_lv_c_i + 27.9553932071814*v_TR_1_2_lv_c_r
        struct[0].g[8,0] = i_INV_2_b_r + 27.9554372523104*v_INV_2_a_i + 53.9539088898601*v_INV_2_a_r - 97.8437661123124*v_INV_2_b_i - 188.83868111451*v_INV_2_b_r + 27.9554372523104*v_INV_2_c_i + 53.9539088898602*v_INV_2_c_r - 27.9553932071814*v_TR_1_2_lv_a_i - 53.9539088898601*v_TR_1_2_lv_a_r + 97.8438762251349*v_TR_1_2_lv_b_i + 188.83868111451*v_TR_1_2_lv_b_r - 27.9553932071814*v_TR_1_2_lv_c_i - 53.9539088898602*v_TR_1_2_lv_c_r
        struct[0].g[9,0] = i_INV_2_b_i + 53.9539088898601*v_INV_2_a_i - 27.9554372523104*v_INV_2_a_r - 188.83868111451*v_INV_2_b_i + 97.8437661123124*v_INV_2_b_r + 53.9539088898602*v_INV_2_c_i - 27.9554372523104*v_INV_2_c_r - 53.9539088898601*v_TR_1_2_lv_a_i + 27.9553932071814*v_TR_1_2_lv_a_r + 188.83868111451*v_TR_1_2_lv_b_i - 97.8438762251349*v_TR_1_2_lv_b_r - 53.9539088898602*v_TR_1_2_lv_c_i + 27.9553932071814*v_TR_1_2_lv_c_r
        struct[0].g[10,0] = i_INV_2_c_r + 27.9554372523104*v_INV_2_a_i + 53.9539088898601*v_INV_2_a_r + 27.9554372523103*v_INV_2_b_i + 53.9539088898602*v_INV_2_b_r - 97.8437661123124*v_INV_2_c_i - 188.83868111451*v_INV_2_c_r - 27.9553932071814*v_TR_1_2_lv_a_i - 53.9539088898601*v_TR_1_2_lv_a_r - 27.9553932071813*v_TR_1_2_lv_b_i - 53.9539088898602*v_TR_1_2_lv_b_r + 97.8438762251349*v_TR_1_2_lv_c_i + 188.83868111451*v_TR_1_2_lv_c_r
        struct[0].g[11,0] = i_INV_2_c_i + 53.9539088898601*v_INV_2_a_i - 27.9554372523104*v_INV_2_a_r + 53.9539088898602*v_INV_2_b_i - 27.9554372523103*v_INV_2_b_r - 188.83868111451*v_INV_2_c_i + 97.8437661123124*v_INV_2_c_r - 53.9539088898601*v_TR_1_2_lv_a_i + 27.9553932071814*v_TR_1_2_lv_a_r - 53.9539088898602*v_TR_1_2_lv_b_i + 27.9553932071813*v_TR_1_2_lv_b_r + 188.83868111451*v_TR_1_2_lv_c_i - 97.8438762251349*v_TR_1_2_lv_c_r
        struct[0].g[12,0] = i_INV_3_a_r - 107.758827330392*v_INV_3_a_i - 207.974729711346*v_INV_3_a_r + 30.7883049386397*v_INV_3_b_i + 59.4213513460989*v_INV_3_b_r + 30.7883049386397*v_INV_3_c_i + 59.4213513460989*v_INV_3_c_r + 107.758927311578*v_TR_3_4_lv_a_i + 207.974729711346*v_TR_3_4_lv_a_r - 30.7882649461652*v_TR_3_4_lv_b_i - 59.4213513460989*v_TR_3_4_lv_b_r - 30.7882649461652*v_TR_3_4_lv_c_i - 59.4213513460989*v_TR_3_4_lv_c_r
        struct[0].g[13,0] = i_INV_3_a_i - 207.974729711346*v_INV_3_a_i + 107.758827330392*v_INV_3_a_r + 59.4213513460989*v_INV_3_b_i - 30.7883049386397*v_INV_3_b_r + 59.4213513460989*v_INV_3_c_i - 30.7883049386397*v_INV_3_c_r + 207.974729711346*v_TR_3_4_lv_a_i - 107.758927311578*v_TR_3_4_lv_a_r - 59.4213513460989*v_TR_3_4_lv_b_i + 30.7882649461652*v_TR_3_4_lv_b_r - 59.4213513460989*v_TR_3_4_lv_c_i + 30.7882649461652*v_TR_3_4_lv_c_r
        struct[0].g[14,0] = i_INV_3_b_r + 30.7883049386397*v_INV_3_a_i + 59.4213513460989*v_INV_3_a_r - 107.758827330392*v_INV_3_b_i - 207.974729711346*v_INV_3_b_r + 30.7883049386396*v_INV_3_c_i + 59.421351346099*v_INV_3_c_r - 30.7882649461652*v_TR_3_4_lv_a_i - 59.4213513460989*v_TR_3_4_lv_a_r + 107.758927311578*v_TR_3_4_lv_b_i + 207.974729711346*v_TR_3_4_lv_b_r - 30.7882649461651*v_TR_3_4_lv_c_i - 59.421351346099*v_TR_3_4_lv_c_r
        struct[0].g[15,0] = i_INV_3_b_i + 59.4213513460989*v_INV_3_a_i - 30.7883049386397*v_INV_3_a_r - 207.974729711346*v_INV_3_b_i + 107.758827330392*v_INV_3_b_r + 59.421351346099*v_INV_3_c_i - 30.7883049386396*v_INV_3_c_r - 59.4213513460989*v_TR_3_4_lv_a_i + 30.7882649461652*v_TR_3_4_lv_a_r + 207.974729711346*v_TR_3_4_lv_b_i - 107.758927311578*v_TR_3_4_lv_b_r - 59.421351346099*v_TR_3_4_lv_c_i + 30.7882649461651*v_TR_3_4_lv_c_r
        struct[0].g[16,0] = i_INV_3_c_r + 30.7883049386397*v_INV_3_a_i + 59.4213513460989*v_INV_3_a_r + 30.7883049386396*v_INV_3_b_i + 59.421351346099*v_INV_3_b_r - 107.758827330392*v_INV_3_c_i - 207.974729711346*v_INV_3_c_r - 30.7882649461652*v_TR_3_4_lv_a_i - 59.4213513460989*v_TR_3_4_lv_a_r - 30.7882649461651*v_TR_3_4_lv_b_i - 59.421351346099*v_TR_3_4_lv_b_r + 107.758927311578*v_TR_3_4_lv_c_i + 207.974729711346*v_TR_3_4_lv_c_r
        struct[0].g[17,0] = i_INV_3_c_i + 59.4213513460989*v_INV_3_a_i - 30.7883049386397*v_INV_3_a_r + 59.421351346099*v_INV_3_b_i - 30.7883049386396*v_INV_3_b_r - 207.974729711346*v_INV_3_c_i + 107.758827330392*v_INV_3_c_r - 59.4213513460989*v_TR_3_4_lv_a_i + 30.7882649461652*v_TR_3_4_lv_a_r - 59.421351346099*v_TR_3_4_lv_b_i + 30.7882649461651*v_TR_3_4_lv_b_r + 207.974729711346*v_TR_3_4_lv_c_i - 107.758927311578*v_TR_3_4_lv_c_r
        struct[0].g[18,0] = i_INV_4_a_r - 58.4538966359303*v_INV_4_a_i - 112.816376232042*v_INV_4_a_r + 16.701239710824*v_INV_4_b_i + 32.2332503520119*v_INV_4_b_r + 16.701239710824*v_INV_4_c_i + 32.2332503520119*v_INV_4_c_r + 58.4540809492443*v_TR_3_4_lv_a_i + 112.816376232042*v_TR_3_4_lv_a_r - 16.7011659854984*v_TR_3_4_lv_b_i - 32.2332503520119*v_TR_3_4_lv_b_r - 16.7011659854984*v_TR_3_4_lv_c_i - 32.2332503520119*v_TR_3_4_lv_c_r
        struct[0].g[19,0] = i_INV_4_a_i - 112.816376232042*v_INV_4_a_i + 58.4538966359303*v_INV_4_a_r + 32.2332503520119*v_INV_4_b_i - 16.701239710824*v_INV_4_b_r + 32.2332503520119*v_INV_4_c_i - 16.701239710824*v_INV_4_c_r + 112.816376232042*v_TR_3_4_lv_a_i - 58.4540809492443*v_TR_3_4_lv_a_r - 32.2332503520119*v_TR_3_4_lv_b_i + 16.7011659854984*v_TR_3_4_lv_b_r - 32.2332503520119*v_TR_3_4_lv_c_i + 16.7011659854984*v_TR_3_4_lv_c_r
        struct[0].g[20,0] = i_INV_4_b_r + 16.701239710824*v_INV_4_a_i + 32.2332503520119*v_INV_4_a_r - 58.4538966359303*v_INV_4_b_i - 112.816376232042*v_INV_4_b_r + 16.701239710824*v_INV_4_c_i + 32.2332503520119*v_INV_4_c_r - 16.7011659854984*v_TR_3_4_lv_a_i - 32.2332503520119*v_TR_3_4_lv_a_r + 58.4540809492443*v_TR_3_4_lv_b_i + 112.816376232042*v_TR_3_4_lv_b_r - 16.7011659854984*v_TR_3_4_lv_c_i - 32.2332503520119*v_TR_3_4_lv_c_r
        struct[0].g[21,0] = i_INV_4_b_i + 32.2332503520119*v_INV_4_a_i - 16.701239710824*v_INV_4_a_r - 112.816376232042*v_INV_4_b_i + 58.4538966359303*v_INV_4_b_r + 32.2332503520119*v_INV_4_c_i - 16.701239710824*v_INV_4_c_r - 32.2332503520119*v_TR_3_4_lv_a_i + 16.7011659854984*v_TR_3_4_lv_a_r + 112.816376232042*v_TR_3_4_lv_b_i - 58.4540809492443*v_TR_3_4_lv_b_r - 32.2332503520119*v_TR_3_4_lv_c_i + 16.7011659854984*v_TR_3_4_lv_c_r
        struct[0].g[22,0] = i_INV_4_c_r + 16.701239710824*v_INV_4_a_i + 32.2332503520119*v_INV_4_a_r + 16.7012397108239*v_INV_4_b_i + 32.2332503520119*v_INV_4_b_r - 58.4538966359303*v_INV_4_c_i - 112.816376232042*v_INV_4_c_r - 16.7011659854984*v_TR_3_4_lv_a_i - 32.2332503520119*v_TR_3_4_lv_a_r - 16.7011659854983*v_TR_3_4_lv_b_i - 32.2332503520119*v_TR_3_4_lv_b_r + 58.4540809492443*v_TR_3_4_lv_c_i + 112.816376232042*v_TR_3_4_lv_c_r
        struct[0].g[23,0] = i_INV_4_c_i + 32.2332503520119*v_INV_4_a_i - 16.701239710824*v_INV_4_a_r + 32.2332503520119*v_INV_4_b_i - 16.7012397108239*v_INV_4_b_r - 112.816376232042*v_INV_4_c_i + 58.4538966359303*v_INV_4_c_r - 32.2332503520119*v_TR_3_4_lv_a_i + 16.7011659854984*v_TR_3_4_lv_a_r - 32.2332503520119*v_TR_3_4_lv_b_i + 16.7011659854983*v_TR_3_4_lv_b_r + 112.816376232042*v_TR_3_4_lv_c_i - 58.4540809492443*v_TR_3_4_lv_c_r
        struct[0].g[24,0] = i_INV_5_a_r - 92.6871232662334*v_INV_5_a_i - 178.886372244962*v_INV_5_a_r + 26.4821149256174*v_INV_5_b_i + 51.1103920699891*v_INV_5_b_r + 26.4821149256174*v_INV_5_c_i + 51.1103920699891*v_INV_5_c_r + 92.6872395051616*v_TR_5_6_lv_a_i + 178.886372244962*v_TR_5_6_lv_a_r - 26.4820684300462*v_TR_5_6_lv_b_i - 51.1103920699891*v_TR_5_6_lv_b_r - 26.4820684300462*v_TR_5_6_lv_c_i - 51.1103920699891*v_TR_5_6_lv_c_r
        struct[0].g[25,0] = i_INV_5_a_i - 178.886372244962*v_INV_5_a_i + 92.6871232662334*v_INV_5_a_r + 51.1103920699891*v_INV_5_b_i - 26.4821149256174*v_INV_5_b_r + 51.1103920699891*v_INV_5_c_i - 26.4821149256174*v_INV_5_c_r + 178.886372244962*v_TR_5_6_lv_a_i - 92.6872395051616*v_TR_5_6_lv_a_r - 51.1103920699891*v_TR_5_6_lv_b_i + 26.4820684300462*v_TR_5_6_lv_b_r - 51.1103920699891*v_TR_5_6_lv_c_i + 26.4820684300462*v_TR_5_6_lv_c_r
        struct[0].g[26,0] = i_INV_5_b_r + 26.4821149256174*v_INV_5_a_i + 51.1103920699891*v_INV_5_a_r - 92.6871232662333*v_INV_5_b_i - 178.886372244962*v_INV_5_b_r + 26.4821149256174*v_INV_5_c_i + 51.1103920699892*v_INV_5_c_r - 26.4820684300461*v_TR_5_6_lv_a_i - 51.1103920699891*v_TR_5_6_lv_a_r + 92.6872395051615*v_TR_5_6_lv_b_i + 178.886372244962*v_TR_5_6_lv_b_r - 26.4820684300461*v_TR_5_6_lv_c_i - 51.1103920699892*v_TR_5_6_lv_c_r
        struct[0].g[27,0] = i_INV_5_b_i + 51.1103920699891*v_INV_5_a_i - 26.4821149256174*v_INV_5_a_r - 178.886372244962*v_INV_5_b_i + 92.6871232662333*v_INV_5_b_r + 51.1103920699892*v_INV_5_c_i - 26.4821149256174*v_INV_5_c_r - 51.1103920699891*v_TR_5_6_lv_a_i + 26.4820684300461*v_TR_5_6_lv_a_r + 178.886372244962*v_TR_5_6_lv_b_i - 92.6872395051615*v_TR_5_6_lv_b_r - 51.1103920699892*v_TR_5_6_lv_c_i + 26.4820684300461*v_TR_5_6_lv_c_r
        struct[0].g[28,0] = i_INV_5_c_r + 26.4821149256174*v_INV_5_a_i + 51.1103920699891*v_INV_5_a_r + 26.4821149256174*v_INV_5_b_i + 51.1103920699892*v_INV_5_b_r - 92.6871232662333*v_INV_5_c_i - 178.886372244962*v_INV_5_c_r - 26.4820684300462*v_TR_5_6_lv_a_i - 51.1103920699891*v_TR_5_6_lv_a_r - 26.4820684300461*v_TR_5_6_lv_b_i - 51.1103920699892*v_TR_5_6_lv_b_r + 92.6872395051615*v_TR_5_6_lv_c_i + 178.886372244962*v_TR_5_6_lv_c_r
        struct[0].g[29,0] = i_INV_5_c_i + 51.1103920699891*v_INV_5_a_i - 26.4821149256174*v_INV_5_a_r + 51.1103920699892*v_INV_5_b_i - 26.4821149256174*v_INV_5_b_r - 178.886372244962*v_INV_5_c_i + 92.6871232662333*v_INV_5_c_r - 51.1103920699891*v_TR_5_6_lv_a_i + 26.4820684300462*v_TR_5_6_lv_a_r - 51.1103920699892*v_TR_5_6_lv_b_i + 26.4820684300461*v_TR_5_6_lv_b_r + 178.886372244962*v_TR_5_6_lv_c_i - 92.6872395051615*v_TR_5_6_lv_c_r
        struct[0].g[30,0] = i_INV_6_a_r - 58.4995981119106*v_INV_6_a_i - 112.904579802783*v_INV_6_a_r + 16.714297176654*v_INV_6_b_i + 32.2584513722238*v_INV_6_b_r + 16.714297176654*v_INV_6_c_i + 32.2584513722239*v_INV_6_c_r + 58.4997822812349*v_TR_5_6_lv_a_i + 112.904579802783*v_TR_5_6_lv_a_r - 16.7142235089243*v_TR_5_6_lv_b_i - 32.2584513722238*v_TR_5_6_lv_b_r - 16.7142235089243*v_TR_5_6_lv_c_i - 32.2584513722239*v_TR_5_6_lv_c_r
        struct[0].g[31,0] = i_INV_6_a_i - 112.904579802783*v_INV_6_a_i + 58.4995981119106*v_INV_6_a_r + 32.2584513722238*v_INV_6_b_i - 16.714297176654*v_INV_6_b_r + 32.2584513722239*v_INV_6_c_i - 16.714297176654*v_INV_6_c_r + 112.904579802783*v_TR_5_6_lv_a_i - 58.4997822812349*v_TR_5_6_lv_a_r - 32.2584513722238*v_TR_5_6_lv_b_i + 16.7142235089243*v_TR_5_6_lv_b_r - 32.2584513722239*v_TR_5_6_lv_c_i + 16.7142235089243*v_TR_5_6_lv_c_r
        struct[0].g[32,0] = i_INV_6_b_r + 16.714297176654*v_INV_6_a_i + 32.2584513722238*v_INV_6_a_r - 58.4995981119106*v_INV_6_b_i - 112.904579802783*v_INV_6_b_r + 16.714297176654*v_INV_6_c_i + 32.2584513722239*v_INV_6_c_r - 16.7142235089243*v_TR_5_6_lv_a_i - 32.2584513722238*v_TR_5_6_lv_a_r + 58.4997822812349*v_TR_5_6_lv_b_i + 112.904579802783*v_TR_5_6_lv_b_r - 16.7142235089242*v_TR_5_6_lv_c_i - 32.2584513722239*v_TR_5_6_lv_c_r
        struct[0].g[33,0] = i_INV_6_b_i + 32.2584513722238*v_INV_6_a_i - 16.714297176654*v_INV_6_a_r - 112.904579802783*v_INV_6_b_i + 58.4995981119106*v_INV_6_b_r + 32.2584513722239*v_INV_6_c_i - 16.714297176654*v_INV_6_c_r - 32.2584513722238*v_TR_5_6_lv_a_i + 16.7142235089243*v_TR_5_6_lv_a_r + 112.904579802783*v_TR_5_6_lv_b_i - 58.4997822812349*v_TR_5_6_lv_b_r - 32.2584513722239*v_TR_5_6_lv_c_i + 16.7142235089242*v_TR_5_6_lv_c_r
        struct[0].g[34,0] = i_INV_6_c_r + 16.714297176654*v_INV_6_a_i + 32.2584513722239*v_INV_6_a_r + 16.714297176654*v_INV_6_b_i + 32.2584513722239*v_INV_6_b_r - 58.4995981119106*v_INV_6_c_i - 112.904579802783*v_INV_6_c_r - 16.7142235089243*v_TR_5_6_lv_a_i - 32.2584513722239*v_TR_5_6_lv_a_r - 16.7142235089242*v_TR_5_6_lv_b_i - 32.2584513722239*v_TR_5_6_lv_b_r + 58.4997822812349*v_TR_5_6_lv_c_i + 112.904579802783*v_TR_5_6_lv_c_r
        struct[0].g[35,0] = i_INV_6_c_i + 32.2584513722239*v_INV_6_a_i - 16.714297176654*v_INV_6_a_r + 32.2584513722239*v_INV_6_b_i - 16.714297176654*v_INV_6_b_r - 112.904579802783*v_INV_6_c_i + 58.4995981119106*v_INV_6_c_r - 32.2584513722239*v_TR_5_6_lv_a_i + 16.7142235089243*v_TR_5_6_lv_a_r - 32.2584513722239*v_TR_5_6_lv_b_i + 16.7142235089242*v_TR_5_6_lv_b_r + 112.904579802783*v_TR_5_6_lv_c_i - 58.4997822812349*v_TR_5_6_lv_c_r
        struct[0].g[36,0] = i_INV_7_a_r - 246.057560640311*v_INV_7_a_i - 474.891176542679*v_INV_7_a_r + 70.3021902075957*v_INV_7_b_i + 135.683193297908*v_INV_7_b_r + 70.3021902075957*v_INV_7_c_i + 135.683193297908*v_INV_7_c_r + 246.057604426258*v_TR_7_8_lv_a_i + 474.891176542679*v_TR_7_8_lv_a_r - 70.3021726932167*v_TR_7_8_lv_b_i - 135.683193297908*v_TR_7_8_lv_b_r - 70.3021726932166*v_TR_7_8_lv_c_i - 135.683193297908*v_TR_7_8_lv_c_r
        struct[0].g[37,0] = i_INV_7_a_i - 474.891176542679*v_INV_7_a_i + 246.057560640311*v_INV_7_a_r + 135.683193297908*v_INV_7_b_i - 70.3021902075957*v_INV_7_b_r + 135.683193297908*v_INV_7_c_i - 70.3021902075957*v_INV_7_c_r + 474.891176542679*v_TR_7_8_lv_a_i - 246.057604426258*v_TR_7_8_lv_a_r - 135.683193297908*v_TR_7_8_lv_b_i + 70.3021726932167*v_TR_7_8_lv_b_r - 135.683193297908*v_TR_7_8_lv_c_i + 70.3021726932166*v_TR_7_8_lv_c_r
        struct[0].g[38,0] = i_INV_7_b_r + 70.3021902075957*v_INV_7_a_i + 135.683193297908*v_INV_7_a_r - 246.057560640311*v_INV_7_b_i - 474.891176542679*v_INV_7_b_r + 70.3021902075956*v_INV_7_c_i + 135.683193297909*v_INV_7_c_r - 70.3021726932166*v_TR_7_8_lv_a_i - 135.683193297908*v_TR_7_8_lv_a_r + 246.057604426258*v_TR_7_8_lv_b_i + 474.891176542679*v_TR_7_8_lv_b_r - 70.3021726932165*v_TR_7_8_lv_c_i - 135.683193297909*v_TR_7_8_lv_c_r
        struct[0].g[39,0] = i_INV_7_b_i + 135.683193297908*v_INV_7_a_i - 70.3021902075957*v_INV_7_a_r - 474.891176542679*v_INV_7_b_i + 246.057560640311*v_INV_7_b_r + 135.683193297909*v_INV_7_c_i - 70.3021902075956*v_INV_7_c_r - 135.683193297908*v_TR_7_8_lv_a_i + 70.3021726932166*v_TR_7_8_lv_a_r + 474.891176542679*v_TR_7_8_lv_b_i - 246.057604426258*v_TR_7_8_lv_b_r - 135.683193297909*v_TR_7_8_lv_c_i + 70.3021726932165*v_TR_7_8_lv_c_r
        struct[0].g[40,0] = i_INV_7_c_r + 70.3021902075957*v_INV_7_a_i + 135.683193297908*v_INV_7_a_r + 70.3021902075956*v_INV_7_b_i + 135.683193297909*v_INV_7_b_r - 246.057560640311*v_INV_7_c_i - 474.891176542679*v_INV_7_c_r - 70.3021726932167*v_TR_7_8_lv_a_i - 135.683193297908*v_TR_7_8_lv_a_r - 70.3021726932165*v_TR_7_8_lv_b_i - 135.683193297909*v_TR_7_8_lv_b_r + 246.057604426258*v_TR_7_8_lv_c_i + 474.891176542679*v_TR_7_8_lv_c_r
        struct[0].g[41,0] = i_INV_7_c_i + 135.683193297908*v_INV_7_a_i - 70.3021902075957*v_INV_7_a_r + 135.683193297909*v_INV_7_b_i - 70.3021902075956*v_INV_7_b_r - 474.891176542679*v_INV_7_c_i + 246.057560640311*v_INV_7_c_r - 135.683193297908*v_TR_7_8_lv_a_i + 70.3021726932167*v_TR_7_8_lv_a_r - 135.683193297909*v_TR_7_8_lv_b_i + 70.3021726932165*v_TR_7_8_lv_b_r + 474.891176542679*v_TR_7_8_lv_c_i - 246.057604426258*v_TR_7_8_lv_c_r
        struct[0].g[42,0] = i_INV_8_a_r - 106.794071531051*v_INV_8_a_i - 206.112752761809*v_INV_8_a_r + 30.5126610438848*v_INV_8_b_i + 58.8893579319454*v_INV_8_b_r + 30.5126610438848*v_INV_8_c_i + 58.8893579319454*v_INV_8_c_r + 106.794172415445*v_TR_7_8_lv_a_i + 206.112752761809*v_TR_7_8_lv_a_r - 30.5126206901271*v_TR_7_8_lv_b_i - 58.8893579319454*v_TR_7_8_lv_b_r - 30.5126206901271*v_TR_7_8_lv_c_i - 58.8893579319454*v_TR_7_8_lv_c_r
        struct[0].g[43,0] = i_INV_8_a_i - 206.112752761809*v_INV_8_a_i + 106.794071531051*v_INV_8_a_r + 58.8893579319454*v_INV_8_b_i - 30.5126610438848*v_INV_8_b_r + 58.8893579319454*v_INV_8_c_i - 30.5126610438848*v_INV_8_c_r + 206.112752761809*v_TR_7_8_lv_a_i - 106.794172415445*v_TR_7_8_lv_a_r - 58.8893579319454*v_TR_7_8_lv_b_i + 30.5126206901271*v_TR_7_8_lv_b_r - 58.8893579319454*v_TR_7_8_lv_c_i + 30.5126206901271*v_TR_7_8_lv_c_r
        struct[0].g[44,0] = i_INV_8_b_r + 30.5126610438847*v_INV_8_a_i + 58.8893579319454*v_INV_8_a_r - 106.794071531051*v_INV_8_b_i - 206.112752761809*v_INV_8_b_r + 30.5126610438847*v_INV_8_c_i + 58.8893579319455*v_INV_8_c_r - 30.5126206901271*v_TR_7_8_lv_a_i - 58.8893579319454*v_TR_7_8_lv_a_r + 106.794172415445*v_TR_7_8_lv_b_i + 206.112752761809*v_TR_7_8_lv_b_r - 30.5126206901271*v_TR_7_8_lv_c_i - 58.8893579319455*v_TR_7_8_lv_c_r
        struct[0].g[45,0] = i_INV_8_b_i + 58.8893579319454*v_INV_8_a_i - 30.5126610438847*v_INV_8_a_r - 206.112752761809*v_INV_8_b_i + 106.794071531051*v_INV_8_b_r + 58.8893579319455*v_INV_8_c_i - 30.5126610438847*v_INV_8_c_r - 58.8893579319454*v_TR_7_8_lv_a_i + 30.5126206901271*v_TR_7_8_lv_a_r + 206.112752761809*v_TR_7_8_lv_b_i - 106.794172415445*v_TR_7_8_lv_b_r - 58.8893579319455*v_TR_7_8_lv_c_i + 30.5126206901271*v_TR_7_8_lv_c_r
        struct[0].g[46,0] = i_INV_8_c_r + 30.5126610438848*v_INV_8_a_i + 58.8893579319454*v_INV_8_a_r + 30.5126610438847*v_INV_8_b_i + 58.8893579319455*v_INV_8_b_r - 106.794071531051*v_INV_8_c_i - 206.112752761809*v_INV_8_c_r - 30.5126206901272*v_TR_7_8_lv_a_i - 58.8893579319454*v_TR_7_8_lv_a_r - 30.5126206901271*v_TR_7_8_lv_b_i - 58.8893579319455*v_TR_7_8_lv_b_r + 106.794172415445*v_TR_7_8_lv_c_i + 206.112752761809*v_TR_7_8_lv_c_r
        struct[0].g[47,0] = i_INV_8_c_i + 58.8893579319454*v_INV_8_a_i - 30.5126610438848*v_INV_8_a_r + 58.8893579319455*v_INV_8_b_i - 30.5126610438847*v_INV_8_b_r - 206.112752761809*v_INV_8_c_i + 106.794071531051*v_INV_8_c_r - 58.8893579319454*v_TR_7_8_lv_a_i + 30.5126206901272*v_TR_7_8_lv_a_r - 58.8893579319455*v_TR_7_8_lv_b_i + 30.5126206901271*v_TR_7_8_lv_b_r + 206.112752761809*v_TR_7_8_lv_c_i - 106.794172415445*v_TR_7_8_lv_c_r
        struct[0].g[48,0] = i_INV_9_a_r - 98.1763901476198*v_INV_9_a_i - 189.48064478264*v_INV_9_a_r + 28.0504724351543*v_INV_9_b_i + 54.1373270807543*v_INV_9_b_r + 28.0504724351542*v_INV_9_c_i + 54.1373270807543*v_INV_9_c_r + 98.1764998873781*v_TR_9_10_lv_a_i + 189.48064478264*v_TR_9_10_lv_a_r - 28.0504285392509*v_TR_9_10_lv_b_i - 54.1373270807543*v_TR_9_10_lv_b_r - 28.0504285392509*v_TR_9_10_lv_c_i - 54.1373270807543*v_TR_9_10_lv_c_r
        struct[0].g[49,0] = i_INV_9_a_i - 189.48064478264*v_INV_9_a_i + 98.1763901476198*v_INV_9_a_r + 54.1373270807543*v_INV_9_b_i - 28.0504724351543*v_INV_9_b_r + 54.1373270807543*v_INV_9_c_i - 28.0504724351542*v_INV_9_c_r + 189.48064478264*v_TR_9_10_lv_a_i - 98.1764998873781*v_TR_9_10_lv_a_r - 54.1373270807543*v_TR_9_10_lv_b_i + 28.0504285392509*v_TR_9_10_lv_b_r - 54.1373270807543*v_TR_9_10_lv_c_i + 28.0504285392509*v_TR_9_10_lv_c_r
        struct[0].g[50,0] = i_INV_9_b_r + 28.0504724351542*v_INV_9_a_i + 54.1373270807543*v_INV_9_a_r - 98.1763901476198*v_INV_9_b_i - 189.48064478264*v_INV_9_b_r + 28.0504724351542*v_INV_9_c_i + 54.1373270807544*v_INV_9_c_r - 28.0504285392509*v_TR_9_10_lv_a_i - 54.1373270807543*v_TR_9_10_lv_a_r + 98.1764998873781*v_TR_9_10_lv_b_i + 189.48064478264*v_TR_9_10_lv_b_r - 28.0504285392509*v_TR_9_10_lv_c_i - 54.1373270807544*v_TR_9_10_lv_c_r
        struct[0].g[51,0] = i_INV_9_b_i + 54.1373270807543*v_INV_9_a_i - 28.0504724351542*v_INV_9_a_r - 189.48064478264*v_INV_9_b_i + 98.1763901476198*v_INV_9_b_r + 54.1373270807544*v_INV_9_c_i - 28.0504724351542*v_INV_9_c_r - 54.1373270807543*v_TR_9_10_lv_a_i + 28.0504285392509*v_TR_9_10_lv_a_r + 189.48064478264*v_TR_9_10_lv_b_i - 98.1764998873781*v_TR_9_10_lv_b_r - 54.1373270807544*v_TR_9_10_lv_c_i + 28.0504285392509*v_TR_9_10_lv_c_r
        struct[0].g[52,0] = i_INV_9_c_r + 28.0504724351543*v_INV_9_a_i + 54.1373270807543*v_INV_9_a_r + 28.0504724351542*v_INV_9_b_i + 54.1373270807543*v_INV_9_b_r - 98.1763901476198*v_INV_9_c_i - 189.48064478264*v_INV_9_c_r - 28.0504285392509*v_TR_9_10_lv_a_i - 54.1373270807543*v_TR_9_10_lv_a_r - 28.0504285392509*v_TR_9_10_lv_b_i - 54.1373270807543*v_TR_9_10_lv_b_r + 98.1764998873781*v_TR_9_10_lv_c_i + 189.48064478264*v_TR_9_10_lv_c_r
        struct[0].g[53,0] = i_INV_9_c_i + 54.1373270807543*v_INV_9_a_i - 28.0504724351543*v_INV_9_a_r + 54.1373270807543*v_INV_9_b_i - 28.0504724351542*v_INV_9_b_r - 189.48064478264*v_INV_9_c_i + 98.1763901476198*v_INV_9_c_r - 54.1373270807543*v_TR_9_10_lv_a_i + 28.0504285392509*v_TR_9_10_lv_a_r - 54.1373270807543*v_TR_9_10_lv_b_i + 28.0504285392509*v_TR_9_10_lv_b_r + 189.48064478264*v_TR_9_10_lv_c_i - 98.1764998873781*v_TR_9_10_lv_c_r
        struct[0].g[54,0] = i_INV_10_a_r - 75.8057696238346*v_INV_10_a_i - 146.305409673982*v_INV_10_a_r + 21.6588887777877*v_INV_10_b_i + 41.8015456211378*v_INV_10_b_r + 21.6588887777877*v_INV_10_c_i + 41.8015456211378*v_INV_10_c_r + 75.8059117481773*v_TR_9_10_lv_a_i + 146.305409673982*v_TR_9_10_lv_a_r - 21.6588319280506*v_TR_9_10_lv_b_i - 41.8015456211378*v_TR_9_10_lv_b_r - 21.6588319280506*v_TR_9_10_lv_c_i - 41.8015456211378*v_TR_9_10_lv_c_r
        struct[0].g[55,0] = i_INV_10_a_i - 146.305409673982*v_INV_10_a_i + 75.8057696238346*v_INV_10_a_r + 41.8015456211378*v_INV_10_b_i - 21.6588887777877*v_INV_10_b_r + 41.8015456211378*v_INV_10_c_i - 21.6588887777877*v_INV_10_c_r + 146.305409673982*v_TR_9_10_lv_a_i - 75.8059117481773*v_TR_9_10_lv_a_r - 41.8015456211378*v_TR_9_10_lv_b_i + 21.6588319280506*v_TR_9_10_lv_b_r - 41.8015456211378*v_TR_9_10_lv_c_i + 21.6588319280506*v_TR_9_10_lv_c_r
        struct[0].g[56,0] = i_INV_10_b_r + 21.6588887777877*v_INV_10_a_i + 41.8015456211377*v_INV_10_a_r - 75.8057696238346*v_INV_10_b_i - 146.305409673982*v_INV_10_b_r + 21.6588887777877*v_INV_10_c_i + 41.8015456211378*v_INV_10_c_r - 21.6588319280506*v_TR_9_10_lv_a_i - 41.8015456211377*v_TR_9_10_lv_a_r + 75.8059117481773*v_TR_9_10_lv_b_i + 146.305409673982*v_TR_9_10_lv_b_r - 21.6588319280506*v_TR_9_10_lv_c_i - 41.8015456211378*v_TR_9_10_lv_c_r
        struct[0].g[57,0] = i_INV_10_b_i + 41.8015456211377*v_INV_10_a_i - 21.6588887777877*v_INV_10_a_r - 146.305409673982*v_INV_10_b_i + 75.8057696238346*v_INV_10_b_r + 41.8015456211378*v_INV_10_c_i - 21.6588887777877*v_INV_10_c_r - 41.8015456211377*v_TR_9_10_lv_a_i + 21.6588319280506*v_TR_9_10_lv_a_r + 146.305409673982*v_TR_9_10_lv_b_i - 75.8059117481773*v_TR_9_10_lv_b_r - 41.8015456211378*v_TR_9_10_lv_c_i + 21.6588319280506*v_TR_9_10_lv_c_r
        struct[0].g[58,0] = i_INV_10_c_r + 21.6588887777877*v_INV_10_a_i + 41.8015456211378*v_INV_10_a_r + 21.6588887777877*v_INV_10_b_i + 41.8015456211378*v_INV_10_b_r - 75.8057696238346*v_INV_10_c_i - 146.305409673982*v_INV_10_c_r - 21.6588319280506*v_TR_9_10_lv_a_i - 41.8015456211378*v_TR_9_10_lv_a_r - 21.6588319280506*v_TR_9_10_lv_b_i - 41.8015456211378*v_TR_9_10_lv_b_r + 75.8059117481773*v_TR_9_10_lv_c_i + 146.305409673982*v_TR_9_10_lv_c_r
        struct[0].g[59,0] = i_INV_10_c_i + 41.8015456211378*v_INV_10_a_i - 21.6588887777877*v_INV_10_a_r + 41.8015456211378*v_INV_10_b_i - 21.6588887777877*v_INV_10_b_r - 146.305409673982*v_INV_10_c_i + 75.8057696238346*v_INV_10_c_r - 41.8015456211378*v_TR_9_10_lv_a_i + 21.6588319280506*v_TR_9_10_lv_a_r - 41.8015456211378*v_TR_9_10_lv_b_i + 21.6588319280506*v_TR_9_10_lv_b_r + 146.305409673982*v_TR_9_10_lv_c_i - 75.8059117481773*v_TR_9_10_lv_c_r
        struct[0].g[60,0] = i_INV_11_a_r - 81.5760299591651*v_INV_11_a_i - 157.441992718694*v_INV_11_a_r + 23.3075276943302*v_INV_11_b_i + 44.9834264910554*v_INV_11_b_r + 23.3075276943302*v_INV_11_c_i + 44.9834264910554*v_INV_11_c_r + 81.5761620304113*v_TR_11_12_lv_a_i + 157.441992718694*v_TR_11_12_lv_a_r - 23.3074748658318*v_TR_11_12_lv_b_i - 44.9834264910554*v_TR_11_12_lv_b_r - 23.3074748658318*v_TR_11_12_lv_c_i - 44.9834264910554*v_TR_11_12_lv_c_r
        struct[0].g[61,0] = i_INV_11_a_i - 157.441992718694*v_INV_11_a_i + 81.5760299591651*v_INV_11_a_r + 44.9834264910554*v_INV_11_b_i - 23.3075276943302*v_INV_11_b_r + 44.9834264910554*v_INV_11_c_i - 23.3075276943302*v_INV_11_c_r + 157.441992718694*v_TR_11_12_lv_a_i - 81.5761620304113*v_TR_11_12_lv_a_r - 44.9834264910554*v_TR_11_12_lv_b_i + 23.3074748658318*v_TR_11_12_lv_b_r - 44.9834264910554*v_TR_11_12_lv_c_i + 23.3074748658318*v_TR_11_12_lv_c_r
        struct[0].g[62,0] = i_INV_11_b_r + 23.3075276943302*v_INV_11_a_i + 44.9834264910554*v_INV_11_a_r - 81.5760299591651*v_INV_11_b_i - 157.441992718694*v_INV_11_b_r + 23.3075276943302*v_INV_11_c_i + 44.9834264910555*v_INV_11_c_r - 23.3074748658318*v_TR_11_12_lv_a_i - 44.9834264910554*v_TR_11_12_lv_a_r + 81.5761620304112*v_TR_11_12_lv_b_i + 157.441992718694*v_TR_11_12_lv_b_r - 23.3074748658317*v_TR_11_12_lv_c_i - 44.9834264910555*v_TR_11_12_lv_c_r
        struct[0].g[63,0] = i_INV_11_b_i + 44.9834264910554*v_INV_11_a_i - 23.3075276943302*v_INV_11_a_r - 157.441992718694*v_INV_11_b_i + 81.5760299591651*v_INV_11_b_r + 44.9834264910555*v_INV_11_c_i - 23.3075276943302*v_INV_11_c_r - 44.9834264910554*v_TR_11_12_lv_a_i + 23.3074748658318*v_TR_11_12_lv_a_r + 157.441992718694*v_TR_11_12_lv_b_i - 81.5761620304112*v_TR_11_12_lv_b_r - 44.9834264910555*v_TR_11_12_lv_c_i + 23.3074748658317*v_TR_11_12_lv_c_r
        struct[0].g[64,0] = i_INV_11_c_r + 23.3075276943302*v_INV_11_a_i + 44.9834264910554*v_INV_11_a_r + 23.3075276943302*v_INV_11_b_i + 44.9834264910554*v_INV_11_b_r - 81.5760299591651*v_INV_11_c_i - 157.441992718694*v_INV_11_c_r - 23.3074748658318*v_TR_11_12_lv_a_i - 44.9834264910554*v_TR_11_12_lv_a_r - 23.3074748658317*v_TR_11_12_lv_b_i - 44.9834264910554*v_TR_11_12_lv_b_r + 81.5761620304112*v_TR_11_12_lv_c_i + 157.441992718694*v_TR_11_12_lv_c_r
        struct[0].g[65,0] = i_INV_11_c_i + 44.9834264910554*v_INV_11_a_i - 23.3075276943302*v_INV_11_a_r + 44.9834264910554*v_INV_11_b_i - 23.3075276943302*v_INV_11_b_r - 157.441992718694*v_INV_11_c_i + 81.5760299591651*v_INV_11_c_r - 44.9834264910554*v_TR_11_12_lv_a_i + 23.3074748658318*v_TR_11_12_lv_a_r - 44.9834264910554*v_TR_11_12_lv_b_i + 23.3074748658317*v_TR_11_12_lv_b_r + 157.441992718694*v_TR_11_12_lv_c_i - 81.5761620304112*v_TR_11_12_lv_c_r
        struct[0].g[66,0] = i_INV_12_a_r - 107.907168174067*v_INV_12_a_i - 208.26102727437*v_INV_12_a_r + 30.8306879425848*v_INV_12_b_i + 59.5031506498201*v_INV_12_b_r + 30.8306879425848*v_INV_12_c_i + 59.5031506498201*v_INV_12_c_r + 107.907268017809*v_TR_11_12_lv_a_i + 208.26102727437*v_TR_11_12_lv_a_r - 30.8306480050881*v_TR_11_12_lv_b_i - 59.5031506498201*v_TR_11_12_lv_b_r - 30.8306480050881*v_TR_11_12_lv_c_i - 59.5031506498201*v_TR_11_12_lv_c_r
        struct[0].g[67,0] = i_INV_12_a_i - 208.26102727437*v_INV_12_a_i + 107.907168174067*v_INV_12_a_r + 59.5031506498201*v_INV_12_b_i - 30.8306879425848*v_INV_12_b_r + 59.5031506498201*v_INV_12_c_i - 30.8306879425848*v_INV_12_c_r + 208.26102727437*v_TR_11_12_lv_a_i - 107.907268017809*v_TR_11_12_lv_a_r - 59.5031506498201*v_TR_11_12_lv_b_i + 30.8306480050881*v_TR_11_12_lv_b_r - 59.5031506498201*v_TR_11_12_lv_c_i + 30.8306480050881*v_TR_11_12_lv_c_r
        struct[0].g[68,0] = i_INV_12_b_r + 30.8306879425848*v_INV_12_a_i + 59.5031506498201*v_INV_12_a_r - 107.907168174067*v_INV_12_b_i - 208.261027274371*v_INV_12_b_r + 30.8306879425847*v_INV_12_c_i + 59.5031506498202*v_INV_12_c_r - 30.8306480050881*v_TR_11_12_lv_a_i - 59.5031506498201*v_TR_11_12_lv_a_r + 107.907268017808*v_TR_11_12_lv_b_i + 208.261027274371*v_TR_11_12_lv_b_r - 30.8306480050881*v_TR_11_12_lv_c_i - 59.5031506498202*v_TR_11_12_lv_c_r
        struct[0].g[69,0] = i_INV_12_b_i + 59.5031506498201*v_INV_12_a_i - 30.8306879425848*v_INV_12_a_r - 208.261027274371*v_INV_12_b_i + 107.907168174067*v_INV_12_b_r + 59.5031506498202*v_INV_12_c_i - 30.8306879425847*v_INV_12_c_r - 59.5031506498201*v_TR_11_12_lv_a_i + 30.8306480050881*v_TR_11_12_lv_a_r + 208.261027274371*v_TR_11_12_lv_b_i - 107.907268017808*v_TR_11_12_lv_b_r - 59.5031506498202*v_TR_11_12_lv_c_i + 30.8306480050881*v_TR_11_12_lv_c_r
        struct[0].g[70,0] = i_INV_12_c_r + 30.8306879425848*v_INV_12_a_i + 59.5031506498201*v_INV_12_a_r + 30.8306879425847*v_INV_12_b_i + 59.5031506498202*v_INV_12_b_r - 107.907168174067*v_INV_12_c_i - 208.261027274371*v_INV_12_c_r - 30.8306480050882*v_TR_11_12_lv_a_i - 59.5031506498201*v_TR_11_12_lv_a_r - 30.8306480050881*v_TR_11_12_lv_b_i - 59.5031506498202*v_TR_11_12_lv_b_r + 107.907268017808*v_TR_11_12_lv_c_i + 208.261027274371*v_TR_11_12_lv_c_r
        struct[0].g[71,0] = i_INV_12_c_i + 59.5031506498201*v_INV_12_a_i - 30.8306879425848*v_INV_12_a_r + 59.5031506498202*v_INV_12_b_i - 30.8306879425847*v_INV_12_b_r - 208.261027274371*v_INV_12_c_i + 107.907168174067*v_INV_12_c_r - 59.5031506498201*v_TR_11_12_lv_a_i + 30.8306480050882*v_TR_11_12_lv_a_r - 59.5031506498202*v_TR_11_12_lv_b_i + 30.8306480050881*v_TR_11_12_lv_b_r + 208.261027274371*v_TR_11_12_lv_c_i - 107.907268017808*v_TR_11_12_lv_c_r
        struct[0].g[72,0] = i_INV_13_a_r - 225.77493151679*v_INV_13_a_i - 435.745709926008*v_INV_13_a_r + 64.5071560124429*v_INV_13_b_i + 124.498774264574*v_INV_13_b_r + 64.5071560124428*v_INV_13_c_i + 124.498774264574*v_INV_13_c_r + 225.774979236273*v_TR_13_lv_a_i + 435.745709926008*v_TR_13_lv_a_r - 64.5071369246495*v_TR_13_lv_b_i - 124.498774264574*v_TR_13_lv_b_r - 64.5071369246495*v_TR_13_lv_c_i - 124.498774264574*v_TR_13_lv_c_r
        struct[0].g[73,0] = i_INV_13_a_i - 435.745709926008*v_INV_13_a_i + 225.77493151679*v_INV_13_a_r + 124.498774264574*v_INV_13_b_i - 64.5071560124429*v_INV_13_b_r + 124.498774264574*v_INV_13_c_i - 64.5071560124428*v_INV_13_c_r + 435.745709926008*v_TR_13_lv_a_i - 225.774979236273*v_TR_13_lv_a_r - 124.498774264574*v_TR_13_lv_b_i + 64.5071369246495*v_TR_13_lv_b_r - 124.498774264574*v_TR_13_lv_c_i + 64.5071369246495*v_TR_13_lv_c_r
        struct[0].g[74,0] = i_INV_13_b_r + 64.5071560124428*v_INV_13_a_i + 124.498774264574*v_INV_13_a_r - 225.77493151679*v_INV_13_b_i - 435.745709926008*v_INV_13_b_r + 64.5071560124428*v_INV_13_c_i + 124.498774264574*v_INV_13_c_r - 64.5071369246495*v_TR_13_lv_a_i - 124.498774264574*v_TR_13_lv_a_r + 225.774979236273*v_TR_13_lv_b_i + 435.745709926008*v_TR_13_lv_b_r - 64.5071369246494*v_TR_13_lv_c_i - 124.498774264574*v_TR_13_lv_c_r
        struct[0].g[75,0] = i_INV_13_b_i + 124.498774264574*v_INV_13_a_i - 64.5071560124428*v_INV_13_a_r - 435.745709926008*v_INV_13_b_i + 225.77493151679*v_INV_13_b_r + 124.498774264574*v_INV_13_c_i - 64.5071560124428*v_INV_13_c_r - 124.498774264574*v_TR_13_lv_a_i + 64.5071369246495*v_TR_13_lv_a_r + 435.745709926008*v_TR_13_lv_b_i - 225.774979236273*v_TR_13_lv_b_r - 124.498774264574*v_TR_13_lv_c_i + 64.5071369246494*v_TR_13_lv_c_r
        struct[0].g[76,0] = i_INV_13_c_r + 64.5071560124429*v_INV_13_a_i + 124.498774264574*v_INV_13_a_r + 64.5071560124428*v_INV_13_b_i + 124.498774264574*v_INV_13_b_r - 225.77493151679*v_INV_13_c_i - 435.745709926008*v_INV_13_c_r - 64.5071369246495*v_TR_13_lv_a_i - 124.498774264574*v_TR_13_lv_a_r - 64.5071369246494*v_TR_13_lv_b_i - 124.498774264574*v_TR_13_lv_b_r + 225.774979236273*v_TR_13_lv_c_i + 435.745709926008*v_TR_13_lv_c_r
        struct[0].g[77,0] = i_INV_13_c_i + 124.498774264574*v_INV_13_a_i - 64.5071560124429*v_INV_13_a_r + 124.498774264574*v_INV_13_b_i - 64.5071560124428*v_INV_13_b_r - 435.745709926008*v_INV_13_c_i + 225.77493151679*v_INV_13_c_r - 124.498774264574*v_TR_13_lv_a_i + 64.5071369246495*v_TR_13_lv_a_r - 124.498774264574*v_TR_13_lv_b_i + 64.5071369246494*v_TR_13_lv_b_r + 435.745709926008*v_TR_13_lv_c_i - 225.774979236273*v_TR_13_lv_c_r
        struct[0].g[78,0] = i_POIhv_a_r + 0.040290088638195*v_GRID_a_i + 0.024174053182917*v_GRID_a_r + 4.66248501556824e-18*v_GRID_b_i - 4.31760362252812e-18*v_GRID_b_r + 4.19816664496737e-18*v_GRID_c_i - 3.49608108880335e-18*v_GRID_c_r - 0.0647773858527649*v_POIhv_a_i - 0.0272349653347382*v_POIhv_a_r + 0.012243648607285*v_POIhv_b_i + 0.00153045607591063*v_POIhv_b_r + 0.012243648607285*v_POIhv_c_i + 0.00153045607591062*v_POIhv_c_r + 0.0699818508108637*v_POImv_a_i + 0.00874773135135797*v_POImv_a_r - 0.0699818508108637*v_POImv_b_i - 0.00874773135135797*v_POImv_b_r
        struct[0].g[79,0] = i_POIhv_a_i + 0.024174053182917*v_GRID_a_i - 0.040290088638195*v_GRID_a_r - 4.31760362252812e-18*v_GRID_b_i - 4.66248501556824e-18*v_GRID_b_r - 3.49608108880335e-18*v_GRID_c_i - 4.19816664496737e-18*v_GRID_c_r - 0.0272349653347382*v_POIhv_a_i + 0.0647773858527649*v_POIhv_a_r + 0.00153045607591063*v_POIhv_b_i - 0.012243648607285*v_POIhv_b_r + 0.00153045607591062*v_POIhv_c_i - 0.012243648607285*v_POIhv_c_r + 0.00874773135135797*v_POImv_a_i - 0.0699818508108637*v_POImv_a_r - 0.00874773135135797*v_POImv_b_i + 0.0699818508108637*v_POImv_b_r
        struct[0].g[80,0] = i_POIhv_b_r + 6.30775359573304e-19*v_GRID_a_i - 2.07254761002657e-18*v_GRID_a_r + 0.040290088638195*v_GRID_b_i + 0.024174053182917*v_GRID_b_r + 9.01107656533306e-19*v_GRID_c_i - 1.78419315993592e-17*v_GRID_c_r + 0.012243648607285*v_POIhv_a_i + 0.00153045607591062*v_POIhv_a_r - 0.0647773858527649*v_POIhv_b_i - 0.0272349653347383*v_POIhv_b_r + 0.012243648607285*v_POIhv_c_i + 0.00153045607591064*v_POIhv_c_r + 0.0699818508108637*v_POImv_b_i + 0.00874773135135797*v_POImv_b_r - 0.0699818508108637*v_POImv_c_i - 0.00874773135135797*v_POImv_c_r
        struct[0].g[81,0] = i_POIhv_b_i - 2.07254761002657e-18*v_GRID_a_i - 6.30775359573304e-19*v_GRID_a_r + 0.024174053182917*v_GRID_b_i - 0.040290088638195*v_GRID_b_r - 1.78419315993592e-17*v_GRID_c_i - 9.01107656533306e-19*v_GRID_c_r + 0.00153045607591062*v_POIhv_a_i - 0.012243648607285*v_POIhv_a_r - 0.0272349653347383*v_POIhv_b_i + 0.0647773858527649*v_POIhv_b_r + 0.00153045607591064*v_POIhv_c_i - 0.012243648607285*v_POIhv_c_r + 0.00874773135135797*v_POImv_b_i - 0.0699818508108637*v_POImv_b_r - 0.00874773135135797*v_POImv_c_i + 0.0699818508108637*v_POImv_c_r
        struct[0].g[82,0] = i_POIhv_c_r - 7.20886125226632e-19*v_GRID_a_i - 1.35166148479994e-18*v_GRID_a_r - 4.50553828266631e-19*v_GRID_b_i - 1.71210454741325e-17*v_GRID_b_r + 0.040290088638195*v_GRID_c_i + 0.024174053182917*v_GRID_c_r + 0.012243648607285*v_POIhv_a_i + 0.00153045607591062*v_POIhv_a_r + 0.012243648607285*v_POIhv_b_i + 0.00153045607591064*v_POIhv_b_r - 0.0647773858527649*v_POIhv_c_i - 0.0272349653347383*v_POIhv_c_r - 0.0699818508108637*v_POImv_a_i - 0.00874773135135797*v_POImv_a_r + 0.0699818508108637*v_POImv_c_i + 0.00874773135135797*v_POImv_c_r
        struct[0].g[83,0] = i_POIhv_c_i - 1.35166148479994e-18*v_GRID_a_i + 7.20886125226632e-19*v_GRID_a_r - 1.71210454741325e-17*v_GRID_b_i + 4.50553828266631e-19*v_GRID_b_r + 0.024174053182917*v_GRID_c_i - 0.040290088638195*v_GRID_c_r + 0.00153045607591062*v_POIhv_a_i - 0.012243648607285*v_POIhv_a_r + 0.00153045607591064*v_POIhv_b_i - 0.012243648607285*v_POIhv_b_r - 0.0272349653347383*v_POIhv_c_i + 0.0647773858527649*v_POIhv_c_r - 0.00874773135135797*v_POImv_a_i + 0.0699818508108637*v_POImv_a_r + 0.00874773135135797*v_POImv_c_i - 0.0699818508108637*v_POImv_c_r
        struct[0].g[84,0] = i_POImv_a_r + 0.0699818508108637*v_POIhv_a_i + 0.00874773135135797*v_POIhv_a_r - 0.0699818508108637*v_POIhv_c_i - 0.00874773135135797*v_POIhv_c_r - 33.4156859296188*v_POImv_a_i - 24.8222322123875*v_POImv_a_r + 9.4330989270973*v_POImv_b_i + 7.0643874892536*v_POImv_b_r + 9.4330989270973*v_POImv_c_i + 7.0643874892536*v_POImv_c_r + 24.3777365097524*v_TR_1_2_mv_a_i + 18.2833023823143*v_TR_1_2_mv_a_r - 6.96506757421497*v_TR_1_2_mv_b_i - 5.22380068066123*v_TR_1_2_mv_b_r - 6.96506757421497*v_TR_1_2_mv_c_i - 5.22380068066123*v_TR_1_2_mv_c_r + 8.63801621787545*v_TR_5_6_mv_a_i + 6.47851216340659*v_TR_5_6_mv_a_r - 2.4680046336787*v_TR_5_6_mv_b_i - 1.85100347525903*v_TR_5_6_mv_b_r - 2.4680046336787*v_TR_5_6_mv_c_i - 1.85100347525903*v_TR_5_6_mv_c_r
        struct[0].g[85,0] = i_POImv_a_i + 0.00874773135135797*v_POIhv_a_i - 0.0699818508108637*v_POIhv_a_r - 0.00874773135135797*v_POIhv_c_i + 0.0699818508108637*v_POIhv_c_r - 24.8222322123875*v_POImv_a_i + 33.4156859296188*v_POImv_a_r + 7.0643874892536*v_POImv_b_i - 9.4330989270973*v_POImv_b_r + 7.0643874892536*v_POImv_c_i - 9.4330989270973*v_POImv_c_r + 18.2833023823143*v_TR_1_2_mv_a_i - 24.3777365097524*v_TR_1_2_mv_a_r - 5.22380068066123*v_TR_1_2_mv_b_i + 6.96506757421497*v_TR_1_2_mv_b_r - 5.22380068066123*v_TR_1_2_mv_c_i + 6.96506757421497*v_TR_1_2_mv_c_r + 6.47851216340659*v_TR_5_6_mv_a_i - 8.63801621787545*v_TR_5_6_mv_a_r - 1.85100347525903*v_TR_5_6_mv_b_i + 2.4680046336787*v_TR_5_6_mv_b_r - 1.85100347525903*v_TR_5_6_mv_c_i + 2.4680046336787*v_TR_5_6_mv_c_r
        struct[0].g[86,0] = i_POImv_b_r - 0.0699818508108637*v_POIhv_a_i - 0.00874773135135797*v_POIhv_a_r + 0.0699818508108637*v_POIhv_b_i + 0.00874773135135797*v_POIhv_b_r + 9.4330989270973*v_POImv_a_i + 7.0643874892536*v_POImv_a_r - 33.4156859296188*v_POImv_b_i - 24.8222322123876*v_POImv_b_r + 9.4330989270973*v_POImv_c_i + 7.06438748925361*v_POImv_c_r - 6.96506757421497*v_TR_1_2_mv_a_i - 5.22380068066123*v_TR_1_2_mv_a_r + 24.3777365097524*v_TR_1_2_mv_b_i + 18.2833023823143*v_TR_1_2_mv_b_r - 6.96506757421497*v_TR_1_2_mv_c_i - 5.22380068066124*v_TR_1_2_mv_c_r - 2.4680046336787*v_TR_5_6_mv_a_i - 1.85100347525903*v_TR_5_6_mv_a_r + 8.63801621787545*v_TR_5_6_mv_b_i + 6.47851216340659*v_TR_5_6_mv_b_r - 2.4680046336787*v_TR_5_6_mv_c_i - 1.85100347525903*v_TR_5_6_mv_c_r
        struct[0].g[87,0] = i_POImv_b_i - 0.00874773135135797*v_POIhv_a_i + 0.0699818508108637*v_POIhv_a_r + 0.00874773135135797*v_POIhv_b_i - 0.0699818508108637*v_POIhv_b_r + 7.0643874892536*v_POImv_a_i - 9.4330989270973*v_POImv_a_r - 24.8222322123876*v_POImv_b_i + 33.4156859296188*v_POImv_b_r + 7.06438748925361*v_POImv_c_i - 9.4330989270973*v_POImv_c_r - 5.22380068066123*v_TR_1_2_mv_a_i + 6.96506757421497*v_TR_1_2_mv_a_r + 18.2833023823143*v_TR_1_2_mv_b_i - 24.3777365097524*v_TR_1_2_mv_b_r - 5.22380068066124*v_TR_1_2_mv_c_i + 6.96506757421497*v_TR_1_2_mv_c_r - 1.85100347525903*v_TR_5_6_mv_a_i + 2.4680046336787*v_TR_5_6_mv_a_r + 6.47851216340659*v_TR_5_6_mv_b_i - 8.63801621787545*v_TR_5_6_mv_b_r - 1.85100347525903*v_TR_5_6_mv_c_i + 2.4680046336787*v_TR_5_6_mv_c_r
        struct[0].g[88,0] = i_POImv_c_r - 0.0699818508108637*v_POIhv_b_i - 0.00874773135135797*v_POIhv_b_r + 0.0699818508108637*v_POIhv_c_i + 0.00874773135135797*v_POIhv_c_r + 9.4330989270973*v_POImv_a_i + 7.06438748925359*v_POImv_a_r + 9.4330989270973*v_POImv_b_i + 7.06438748925361*v_POImv_b_r - 33.4156859296188*v_POImv_c_i - 24.8222322123876*v_POImv_c_r - 6.96506757421497*v_TR_1_2_mv_a_i - 5.22380068066123*v_TR_1_2_mv_a_r - 6.96506757421497*v_TR_1_2_mv_b_i - 5.22380068066124*v_TR_1_2_mv_b_r + 24.3777365097524*v_TR_1_2_mv_c_i + 18.2833023823143*v_TR_1_2_mv_c_r - 2.4680046336787*v_TR_5_6_mv_a_i - 1.85100347525903*v_TR_5_6_mv_a_r - 2.4680046336787*v_TR_5_6_mv_b_i - 1.85100347525903*v_TR_5_6_mv_b_r + 8.63801621787545*v_TR_5_6_mv_c_i + 6.47851216340659*v_TR_5_6_mv_c_r
        struct[0].g[89,0] = i_POImv_c_i - 0.00874773135135797*v_POIhv_b_i + 0.0699818508108637*v_POIhv_b_r + 0.00874773135135797*v_POIhv_c_i - 0.0699818508108637*v_POIhv_c_r + 7.06438748925359*v_POImv_a_i - 9.4330989270973*v_POImv_a_r + 7.06438748925361*v_POImv_b_i - 9.4330989270973*v_POImv_b_r - 24.8222322123876*v_POImv_c_i + 33.4156859296188*v_POImv_c_r - 5.22380068066123*v_TR_1_2_mv_a_i + 6.96506757421497*v_TR_1_2_mv_a_r - 5.22380068066124*v_TR_1_2_mv_b_i + 6.96506757421497*v_TR_1_2_mv_b_r + 18.2833023823143*v_TR_1_2_mv_c_i - 24.3777365097524*v_TR_1_2_mv_c_r - 1.85100347525903*v_TR_5_6_mv_a_i + 2.4680046336787*v_TR_5_6_mv_a_r - 1.85100347525903*v_TR_5_6_mv_b_i + 2.4680046336787*v_TR_5_6_mv_b_r + 6.47851216340659*v_TR_5_6_mv_c_i - 8.63801621787545*v_TR_5_6_mv_c_r
        struct[0].g[90,0] = i_TR_1_2_mv_a_r + 24.3777365097524*v_POImv_a_i + 18.2833023823143*v_POImv_a_r - 6.96506757421497*v_POImv_b_i - 5.22380068066123*v_POImv_b_r - 6.96506757421497*v_POImv_c_i - 5.22380068066123*v_POImv_c_r + 2.3406091994174*v_TR_1_2_lv_a_i + 0.390101533236234*v_TR_1_2_lv_a_r - 2.3406091994174*v_TR_1_2_lv_b_i - 0.390101533236234*v_TR_1_2_lv_b_r - 52.7347843860809*v_TR_1_2_mv_a_i - 39.5195811550486*v_TR_1_2_mv_a_r + 15.0786865705954*v_TR_1_2_mv_b_i + 11.293239403373*v_TR_1_2_mv_b_r + 15.0786865705954*v_TR_1_2_mv_c_i + 11.293239403373*v_TR_1_2_mv_c_r + 28.3030263516338*v_TR_3_4_mv_a_i + 21.2272697637253*v_TR_3_4_mv_a_r - 8.08657895760964*v_TR_3_4_mv_b_i - 6.06493421820724*v_TR_3_4_mv_b_r - 8.08657895760964*v_TR_3_4_mv_c_i - 6.06493421820724*v_TR_3_4_mv_c_r
        struct[0].g[91,0] = i_TR_1_2_mv_a_i + 18.2833023823143*v_POImv_a_i - 24.3777365097524*v_POImv_a_r - 5.22380068066123*v_POImv_b_i + 6.96506757421497*v_POImv_b_r - 5.22380068066123*v_POImv_c_i + 6.96506757421497*v_POImv_c_r + 0.390101533236234*v_TR_1_2_lv_a_i - 2.3406091994174*v_TR_1_2_lv_a_r - 0.390101533236234*v_TR_1_2_lv_b_i + 2.3406091994174*v_TR_1_2_lv_b_r - 39.5195811550486*v_TR_1_2_mv_a_i + 52.7347843860809*v_TR_1_2_mv_a_r + 11.293239403373*v_TR_1_2_mv_b_i - 15.0786865705954*v_TR_1_2_mv_b_r + 11.293239403373*v_TR_1_2_mv_c_i - 15.0786865705954*v_TR_1_2_mv_c_r + 21.2272697637253*v_TR_3_4_mv_a_i - 28.3030263516338*v_TR_3_4_mv_a_r - 6.06493421820724*v_TR_3_4_mv_b_i + 8.08657895760964*v_TR_3_4_mv_b_r - 6.06493421820724*v_TR_3_4_mv_c_i + 8.08657895760964*v_TR_3_4_mv_c_r
        struct[0].g[92,0] = i_TR_1_2_mv_b_r - 6.96506757421497*v_POImv_a_i - 5.22380068066123*v_POImv_a_r + 24.3777365097524*v_POImv_b_i + 18.2833023823143*v_POImv_b_r - 6.96506757421497*v_POImv_c_i - 5.22380068066124*v_POImv_c_r + 2.3406091994174*v_TR_1_2_lv_b_i + 0.390101533236234*v_TR_1_2_lv_b_r - 2.3406091994174*v_TR_1_2_lv_c_i - 0.390101533236234*v_TR_1_2_lv_c_r + 15.0786865705954*v_TR_1_2_mv_a_i + 11.293239403373*v_TR_1_2_mv_a_r - 52.7347843860809*v_TR_1_2_mv_b_i - 39.5195811550487*v_TR_1_2_mv_b_r + 15.0786865705954*v_TR_1_2_mv_c_i + 11.293239403373*v_TR_1_2_mv_c_r - 8.08657895760964*v_TR_3_4_mv_a_i - 6.06493421820724*v_TR_3_4_mv_a_r + 28.3030263516338*v_TR_3_4_mv_b_i + 21.2272697637253*v_TR_3_4_mv_b_r - 8.08657895760965*v_TR_3_4_mv_c_i - 6.06493421820725*v_TR_3_4_mv_c_r
        struct[0].g[93,0] = i_TR_1_2_mv_b_i - 5.22380068066123*v_POImv_a_i + 6.96506757421497*v_POImv_a_r + 18.2833023823143*v_POImv_b_i - 24.3777365097524*v_POImv_b_r - 5.22380068066124*v_POImv_c_i + 6.96506757421497*v_POImv_c_r + 0.390101533236234*v_TR_1_2_lv_b_i - 2.3406091994174*v_TR_1_2_lv_b_r - 0.390101533236234*v_TR_1_2_lv_c_i + 2.3406091994174*v_TR_1_2_lv_c_r + 11.293239403373*v_TR_1_2_mv_a_i - 15.0786865705954*v_TR_1_2_mv_a_r - 39.5195811550487*v_TR_1_2_mv_b_i + 52.7347843860809*v_TR_1_2_mv_b_r + 11.293239403373*v_TR_1_2_mv_c_i - 15.0786865705954*v_TR_1_2_mv_c_r - 6.06493421820724*v_TR_3_4_mv_a_i + 8.08657895760964*v_TR_3_4_mv_a_r + 21.2272697637253*v_TR_3_4_mv_b_i - 28.3030263516338*v_TR_3_4_mv_b_r - 6.06493421820725*v_TR_3_4_mv_c_i + 8.08657895760965*v_TR_3_4_mv_c_r
        struct[0].g[94,0] = i_TR_1_2_mv_c_r - 6.96506757421497*v_POImv_a_i - 5.22380068066123*v_POImv_a_r - 6.96506757421497*v_POImv_b_i - 5.22380068066124*v_POImv_b_r + 24.3777365097524*v_POImv_c_i + 18.2833023823143*v_POImv_c_r - 2.3406091994174*v_TR_1_2_lv_a_i - 0.390101533236234*v_TR_1_2_lv_a_r + 2.3406091994174*v_TR_1_2_lv_c_i + 0.390101533236234*v_TR_1_2_lv_c_r + 15.0786865705954*v_TR_1_2_mv_a_i + 11.293239403373*v_TR_1_2_mv_a_r + 15.0786865705954*v_TR_1_2_mv_b_i + 11.293239403373*v_TR_1_2_mv_b_r - 52.7347843860809*v_TR_1_2_mv_c_i - 39.5195811550487*v_TR_1_2_mv_c_r - 8.08657895760965*v_TR_3_4_mv_a_i - 6.06493421820724*v_TR_3_4_mv_a_r - 8.08657895760964*v_TR_3_4_mv_b_i - 6.06493421820725*v_TR_3_4_mv_b_r + 28.3030263516338*v_TR_3_4_mv_c_i + 21.2272697637253*v_TR_3_4_mv_c_r
        struct[0].g[95,0] = i_TR_1_2_mv_c_i - 5.22380068066123*v_POImv_a_i + 6.96506757421497*v_POImv_a_r - 5.22380068066124*v_POImv_b_i + 6.96506757421497*v_POImv_b_r + 18.2833023823143*v_POImv_c_i - 24.3777365097524*v_POImv_c_r - 0.390101533236234*v_TR_1_2_lv_a_i + 2.3406091994174*v_TR_1_2_lv_a_r + 0.390101533236234*v_TR_1_2_lv_c_i - 2.3406091994174*v_TR_1_2_lv_c_r + 11.293239403373*v_TR_1_2_mv_a_i - 15.0786865705954*v_TR_1_2_mv_a_r + 11.293239403373*v_TR_1_2_mv_b_i - 15.0786865705954*v_TR_1_2_mv_b_r - 39.5195811550487*v_TR_1_2_mv_c_i + 52.7347843860809*v_TR_1_2_mv_c_r - 6.06493421820724*v_TR_3_4_mv_a_i + 8.08657895760965*v_TR_3_4_mv_a_r - 6.06493421820725*v_TR_3_4_mv_b_i + 8.08657895760964*v_TR_3_4_mv_b_r + 21.2272697637253*v_TR_3_4_mv_c_i - 28.3030263516338*v_TR_3_4_mv_c_r
        struct[0].g[96,0] = i_TR_1_2_lv_a_r + 89.5460683028705*v_INV_1_a_i + 172.82391182454*v_INV_1_a_r - 25.5845909436773*v_INV_1_b_i - 49.3782605212972*v_INV_1_b_r - 25.5845909436773*v_INV_1_c_i - 49.3782605212972*v_INV_1_c_r + 97.8438762251349*v_INV_2_a_i + 188.83868111451*v_INV_2_a_r - 27.9553932071814*v_INV_2_b_i - 53.9539088898601*v_INV_2_b_r - 27.9553932071814*v_INV_2_c_i - 53.9539088898601*v_INV_2_c_r - 390.092416801432*v_TR_1_2_lv_a_i - 395.446376722834*v_TR_1_2_lv_a_r + 53.5400763225691*v_TR_1_2_lv_b_i + 103.332169411157*v_TR_1_2_lv_b_r + 53.5400763225691*v_TR_1_2_lv_c_i + 103.332169411157*v_TR_1_2_lv_c_r + 2.3406091994174*v_TR_1_2_mv_a_i + 0.390101533236234*v_TR_1_2_mv_a_r - 2.3406091994174*v_TR_1_2_mv_c_i - 0.390101533236234*v_TR_1_2_mv_c_r
        struct[0].g[97,0] = i_TR_1_2_lv_a_i + 172.82391182454*v_INV_1_a_i - 89.5460683028705*v_INV_1_a_r - 49.3782605212972*v_INV_1_b_i + 25.5845909436773*v_INV_1_b_r - 49.3782605212972*v_INV_1_c_i + 25.5845909436773*v_INV_1_c_r + 188.83868111451*v_INV_2_a_i - 97.8438762251349*v_INV_2_a_r - 53.9539088898601*v_INV_2_b_i + 27.9553932071814*v_INV_2_b_r - 53.9539088898601*v_INV_2_c_i + 27.9553932071814*v_INV_2_c_r - 395.446376722834*v_TR_1_2_lv_a_i + 390.092416801432*v_TR_1_2_lv_a_r + 103.332169411157*v_TR_1_2_lv_b_i - 53.5400763225691*v_TR_1_2_lv_b_r + 103.332169411157*v_TR_1_2_lv_c_i - 53.5400763225691*v_TR_1_2_lv_c_r + 0.390101533236234*v_TR_1_2_mv_a_i - 2.3406091994174*v_TR_1_2_mv_a_r - 0.390101533236234*v_TR_1_2_mv_c_i + 2.3406091994174*v_TR_1_2_mv_c_r
        struct[0].g[98,0] = i_TR_1_2_lv_b_r - 25.5845909436773*v_INV_1_a_i - 49.3782605212972*v_INV_1_a_r + 89.5460683028705*v_INV_1_b_i + 172.82391182454*v_INV_1_b_r - 25.5845909436773*v_INV_1_c_i - 49.3782605212973*v_INV_1_c_r - 27.9553932071814*v_INV_2_a_i - 53.9539088898601*v_INV_2_a_r + 97.8438762251349*v_INV_2_b_i + 188.83868111451*v_INV_2_b_r - 27.9553932071814*v_INV_2_c_i - 53.9539088898602*v_INV_2_c_r + 53.5400763225691*v_TR_1_2_lv_a_i + 103.332169411157*v_TR_1_2_lv_a_r - 390.092416801432*v_TR_1_2_lv_b_i - 395.446376722835*v_TR_1_2_lv_b_r + 53.5400763225691*v_TR_1_2_lv_c_i + 103.332169411157*v_TR_1_2_lv_c_r - 2.3406091994174*v_TR_1_2_mv_a_i - 0.390101533236234*v_TR_1_2_mv_a_r + 2.3406091994174*v_TR_1_2_mv_b_i + 0.390101533236234*v_TR_1_2_mv_b_r
        struct[0].g[99,0] = i_TR_1_2_lv_b_i - 49.3782605212972*v_INV_1_a_i + 25.5845909436773*v_INV_1_a_r + 172.82391182454*v_INV_1_b_i - 89.5460683028705*v_INV_1_b_r - 49.3782605212973*v_INV_1_c_i + 25.5845909436773*v_INV_1_c_r - 53.9539088898601*v_INV_2_a_i + 27.9553932071814*v_INV_2_a_r + 188.83868111451*v_INV_2_b_i - 97.8438762251349*v_INV_2_b_r - 53.9539088898602*v_INV_2_c_i + 27.9553932071814*v_INV_2_c_r + 103.332169411157*v_TR_1_2_lv_a_i - 53.5400763225691*v_TR_1_2_lv_a_r - 395.446376722835*v_TR_1_2_lv_b_i + 390.092416801432*v_TR_1_2_lv_b_r + 103.332169411157*v_TR_1_2_lv_c_i - 53.5400763225691*v_TR_1_2_lv_c_r - 0.390101533236234*v_TR_1_2_mv_a_i + 2.3406091994174*v_TR_1_2_mv_a_r + 0.390101533236234*v_TR_1_2_mv_b_i - 2.3406091994174*v_TR_1_2_mv_b_r
        struct[0].g[100,0] = i_TR_1_2_lv_c_r - 25.5845909436773*v_INV_1_a_i - 49.3782605212972*v_INV_1_a_r - 25.5845909436772*v_INV_1_b_i - 49.3782605212973*v_INV_1_b_r + 89.5460683028705*v_INV_1_c_i + 172.82391182454*v_INV_1_c_r - 27.9553932071814*v_INV_2_a_i - 53.9539088898601*v_INV_2_a_r - 27.9553932071813*v_INV_2_b_i - 53.9539088898602*v_INV_2_b_r + 97.8438762251349*v_INV_2_c_i + 188.83868111451*v_INV_2_c_r + 53.5400763225692*v_TR_1_2_lv_a_i + 103.332169411157*v_TR_1_2_lv_a_r + 53.5400763225691*v_TR_1_2_lv_b_i + 103.332169411157*v_TR_1_2_lv_b_r - 390.092416801432*v_TR_1_2_lv_c_i - 395.446376722835*v_TR_1_2_lv_c_r - 2.3406091994174*v_TR_1_2_mv_b_i - 0.390101533236234*v_TR_1_2_mv_b_r + 2.3406091994174*v_TR_1_2_mv_c_i + 0.390101533236234*v_TR_1_2_mv_c_r
        struct[0].g[101,0] = i_TR_1_2_lv_c_i - 49.3782605212972*v_INV_1_a_i + 25.5845909436773*v_INV_1_a_r - 49.3782605212973*v_INV_1_b_i + 25.5845909436772*v_INV_1_b_r + 172.82391182454*v_INV_1_c_i - 89.5460683028705*v_INV_1_c_r - 53.9539088898601*v_INV_2_a_i + 27.9553932071814*v_INV_2_a_r - 53.9539088898602*v_INV_2_b_i + 27.9553932071813*v_INV_2_b_r + 188.83868111451*v_INV_2_c_i - 97.8438762251349*v_INV_2_c_r + 103.332169411157*v_TR_1_2_lv_a_i - 53.5400763225692*v_TR_1_2_lv_a_r + 103.332169411157*v_TR_1_2_lv_b_i - 53.5400763225691*v_TR_1_2_lv_b_r - 395.446376722835*v_TR_1_2_lv_c_i + 390.092416801432*v_TR_1_2_lv_c_r - 0.390101533236234*v_TR_1_2_mv_b_i + 2.3406091994174*v_TR_1_2_mv_b_r + 0.390101533236234*v_TR_1_2_mv_c_i - 2.3406091994174*v_TR_1_2_mv_c_r
        struct[0].g[102,0] = i_TR_3_4_mv_a_r + 28.3030263516338*v_TR_1_2_mv_a_i + 21.2272697637253*v_TR_1_2_mv_a_r - 8.08657895760964*v_TR_1_2_mv_b_i - 6.06493421820724*v_TR_1_2_mv_b_r - 8.08657895760964*v_TR_1_2_mv_c_i - 6.06493421820724*v_TR_1_2_mv_c_r + 2.3406091994174*v_TR_3_4_lv_a_i + 0.390101533236234*v_TR_3_4_lv_a_r - 2.3406091994174*v_TR_3_4_lv_b_i - 0.390101533236234*v_TR_3_4_lv_b_r - 43.3991164322381*v_TR_3_4_mv_a_i - 41.678054303702*v_TR_3_4_mv_a_r + 12.4113478527151*v_TR_3_4_mv_b_i + 11.9099460172739*v_TR_3_4_mv_b_r + 12.4113478527151*v_TR_3_4_mv_c_i + 11.9099460172739*v_TR_3_4_mv_c_r + 15.0420612397687*v_TR_7_8_mv_a_i + 20.4417755309677*v_TR_7_8_mv_a_r - 4.29773178279105*v_TR_7_8_mv_b_i - 5.8405072945622*v_TR_7_8_mv_b_r - 4.29773178279104*v_TR_7_8_mv_c_i - 5.84050729456219*v_TR_7_8_mv_c_r
        struct[0].g[103,0] = i_TR_3_4_mv_a_i + 21.2272697637253*v_TR_1_2_mv_a_i - 28.3030263516338*v_TR_1_2_mv_a_r - 6.06493421820724*v_TR_1_2_mv_b_i + 8.08657895760964*v_TR_1_2_mv_b_r - 6.06493421820724*v_TR_1_2_mv_c_i + 8.08657895760964*v_TR_1_2_mv_c_r + 0.390101533236234*v_TR_3_4_lv_a_i - 2.3406091994174*v_TR_3_4_lv_a_r - 0.390101533236234*v_TR_3_4_lv_b_i + 2.3406091994174*v_TR_3_4_lv_b_r - 41.678054303702*v_TR_3_4_mv_a_i + 43.3991164322381*v_TR_3_4_mv_a_r + 11.9099460172739*v_TR_3_4_mv_b_i - 12.4113478527151*v_TR_3_4_mv_b_r + 11.9099460172739*v_TR_3_4_mv_c_i - 12.4113478527151*v_TR_3_4_mv_c_r + 20.4417755309677*v_TR_7_8_mv_a_i - 15.0420612397687*v_TR_7_8_mv_a_r - 5.8405072945622*v_TR_7_8_mv_b_i + 4.29773178279105*v_TR_7_8_mv_b_r - 5.84050729456219*v_TR_7_8_mv_c_i + 4.29773178279104*v_TR_7_8_mv_c_r
        struct[0].g[104,0] = i_TR_3_4_mv_b_r - 8.08657895760964*v_TR_1_2_mv_a_i - 6.06493421820724*v_TR_1_2_mv_a_r + 28.3030263516338*v_TR_1_2_mv_b_i + 21.2272697637253*v_TR_1_2_mv_b_r - 8.08657895760965*v_TR_1_2_mv_c_i - 6.06493421820725*v_TR_1_2_mv_c_r + 2.3406091994174*v_TR_3_4_lv_b_i + 0.390101533236234*v_TR_3_4_lv_b_r - 2.3406091994174*v_TR_3_4_lv_c_i - 0.390101533236234*v_TR_3_4_lv_c_r + 12.4113478527151*v_TR_3_4_mv_a_i + 11.9099460172739*v_TR_3_4_mv_a_r - 43.3991164322381*v_TR_3_4_mv_b_i - 41.678054303702*v_TR_3_4_mv_b_r + 12.4113478527151*v_TR_3_4_mv_c_i + 11.909946017274*v_TR_3_4_mv_c_r - 4.29773178279105*v_TR_7_8_mv_a_i - 5.8405072945622*v_TR_7_8_mv_a_r + 15.0420612397687*v_TR_7_8_mv_b_i + 20.4417755309677*v_TR_7_8_mv_b_r - 4.29773178279105*v_TR_7_8_mv_c_i - 5.8405072945622*v_TR_7_8_mv_c_r
        struct[0].g[105,0] = i_TR_3_4_mv_b_i - 6.06493421820724*v_TR_1_2_mv_a_i + 8.08657895760964*v_TR_1_2_mv_a_r + 21.2272697637253*v_TR_1_2_mv_b_i - 28.3030263516338*v_TR_1_2_mv_b_r - 6.06493421820725*v_TR_1_2_mv_c_i + 8.08657895760965*v_TR_1_2_mv_c_r + 0.390101533236234*v_TR_3_4_lv_b_i - 2.3406091994174*v_TR_3_4_lv_b_r - 0.390101533236234*v_TR_3_4_lv_c_i + 2.3406091994174*v_TR_3_4_lv_c_r + 11.9099460172739*v_TR_3_4_mv_a_i - 12.4113478527151*v_TR_3_4_mv_a_r - 41.678054303702*v_TR_3_4_mv_b_i + 43.3991164322381*v_TR_3_4_mv_b_r + 11.909946017274*v_TR_3_4_mv_c_i - 12.4113478527151*v_TR_3_4_mv_c_r - 5.8405072945622*v_TR_7_8_mv_a_i + 4.29773178279105*v_TR_7_8_mv_a_r + 20.4417755309677*v_TR_7_8_mv_b_i - 15.0420612397687*v_TR_7_8_mv_b_r - 5.8405072945622*v_TR_7_8_mv_c_i + 4.29773178279105*v_TR_7_8_mv_c_r
        struct[0].g[106,0] = i_TR_3_4_mv_c_r - 8.08657895760965*v_TR_1_2_mv_a_i - 6.06493421820724*v_TR_1_2_mv_a_r - 8.08657895760964*v_TR_1_2_mv_b_i - 6.06493421820725*v_TR_1_2_mv_b_r + 28.3030263516338*v_TR_1_2_mv_c_i + 21.2272697637253*v_TR_1_2_mv_c_r - 2.3406091994174*v_TR_3_4_lv_a_i - 0.390101533236234*v_TR_3_4_lv_a_r + 2.3406091994174*v_TR_3_4_lv_c_i + 0.390101533236234*v_TR_3_4_lv_c_r + 12.4113478527151*v_TR_3_4_mv_a_i + 11.9099460172739*v_TR_3_4_mv_a_r + 12.4113478527151*v_TR_3_4_mv_b_i + 11.909946017274*v_TR_3_4_mv_b_r - 43.3991164322381*v_TR_3_4_mv_c_i - 41.678054303702*v_TR_3_4_mv_c_r - 4.29773178279105*v_TR_7_8_mv_a_i - 5.84050729456219*v_TR_7_8_mv_a_r - 4.29773178279104*v_TR_7_8_mv_b_i - 5.84050729456221*v_TR_7_8_mv_b_r + 15.0420612397687*v_TR_7_8_mv_c_i + 20.4417755309677*v_TR_7_8_mv_c_r
        struct[0].g[107,0] = i_TR_3_4_mv_c_i - 6.06493421820724*v_TR_1_2_mv_a_i + 8.08657895760965*v_TR_1_2_mv_a_r - 6.06493421820725*v_TR_1_2_mv_b_i + 8.08657895760964*v_TR_1_2_mv_b_r + 21.2272697637253*v_TR_1_2_mv_c_i - 28.3030263516338*v_TR_1_2_mv_c_r - 0.390101533236234*v_TR_3_4_lv_a_i + 2.3406091994174*v_TR_3_4_lv_a_r + 0.390101533236234*v_TR_3_4_lv_c_i - 2.3406091994174*v_TR_3_4_lv_c_r + 11.9099460172739*v_TR_3_4_mv_a_i - 12.4113478527151*v_TR_3_4_mv_a_r + 11.909946017274*v_TR_3_4_mv_b_i - 12.4113478527151*v_TR_3_4_mv_b_r - 41.678054303702*v_TR_3_4_mv_c_i + 43.3991164322381*v_TR_3_4_mv_c_r - 5.84050729456219*v_TR_7_8_mv_a_i + 4.29773178279105*v_TR_7_8_mv_a_r - 5.84050729456221*v_TR_7_8_mv_b_i + 4.29773178279104*v_TR_7_8_mv_b_r + 20.4417755309677*v_TR_7_8_mv_c_i - 15.0420612397687*v_TR_7_8_mv_c_r
        struct[0].g[108,0] = i_TR_3_4_lv_a_r + 107.758927311578*v_INV_3_a_i + 207.974729711346*v_INV_3_a_r - 30.7882649461652*v_INV_3_b_i - 59.4213513460989*v_INV_3_b_r - 30.7882649461652*v_INV_3_c_i - 59.4213513460989*v_INV_3_c_r + 58.4540809492443*v_INV_4_a_i + 112.816376232042*v_INV_4_a_r - 16.7011659854984*v_INV_4_b_i - 32.2332503520119*v_INV_4_b_r - 16.7011659854984*v_INV_4_c_i - 32.2332503520119*v_INV_4_c_r - 368.915426669025*v_TR_3_4_lv_a_i - 354.574889727171*v_TR_3_4_lv_a_r + 47.4895446494637*v_TR_3_4_lv_b_i + 91.6546016981108*v_TR_3_4_lv_b_r + 47.4895446494637*v_TR_3_4_lv_c_i + 91.6546016981108*v_TR_3_4_lv_c_r + 2.3406091994174*v_TR_3_4_mv_a_i + 0.390101533236234*v_TR_3_4_mv_a_r - 2.3406091994174*v_TR_3_4_mv_c_i - 0.390101533236234*v_TR_3_4_mv_c_r
        struct[0].g[109,0] = i_TR_3_4_lv_a_i + 207.974729711346*v_INV_3_a_i - 107.758927311578*v_INV_3_a_r - 59.4213513460989*v_INV_3_b_i + 30.7882649461652*v_INV_3_b_r - 59.4213513460989*v_INV_3_c_i + 30.7882649461652*v_INV_3_c_r + 112.816376232042*v_INV_4_a_i - 58.4540809492443*v_INV_4_a_r - 32.2332503520119*v_INV_4_b_i + 16.7011659854984*v_INV_4_b_r - 32.2332503520119*v_INV_4_c_i + 16.7011659854984*v_INV_4_c_r - 354.574889727171*v_TR_3_4_lv_a_i + 368.915426669025*v_TR_3_4_lv_a_r + 91.6546016981108*v_TR_3_4_lv_b_i - 47.4895446494637*v_TR_3_4_lv_b_r + 91.6546016981108*v_TR_3_4_lv_c_i - 47.4895446494637*v_TR_3_4_lv_c_r + 0.390101533236234*v_TR_3_4_mv_a_i - 2.3406091994174*v_TR_3_4_mv_a_r - 0.390101533236234*v_TR_3_4_mv_c_i + 2.3406091994174*v_TR_3_4_mv_c_r
        struct[0].g[110,0] = i_TR_3_4_lv_b_r - 30.7882649461652*v_INV_3_a_i - 59.4213513460989*v_INV_3_a_r + 107.758927311578*v_INV_3_b_i + 207.974729711346*v_INV_3_b_r - 30.7882649461651*v_INV_3_c_i - 59.421351346099*v_INV_3_c_r - 16.7011659854984*v_INV_4_a_i - 32.2332503520119*v_INV_4_a_r + 58.4540809492443*v_INV_4_b_i + 112.816376232042*v_INV_4_b_r - 16.7011659854984*v_INV_4_c_i - 32.2332503520119*v_INV_4_c_r + 47.4895446494636*v_TR_3_4_lv_a_i + 91.6546016981107*v_TR_3_4_lv_a_r - 368.915426669025*v_TR_3_4_lv_b_i - 354.574889727172*v_TR_3_4_lv_b_r + 47.4895446494636*v_TR_3_4_lv_c_i + 91.6546016981109*v_TR_3_4_lv_c_r - 2.3406091994174*v_TR_3_4_mv_a_i - 0.390101533236234*v_TR_3_4_mv_a_r + 2.3406091994174*v_TR_3_4_mv_b_i + 0.390101533236234*v_TR_3_4_mv_b_r
        struct[0].g[111,0] = i_TR_3_4_lv_b_i - 59.4213513460989*v_INV_3_a_i + 30.7882649461652*v_INV_3_a_r + 207.974729711346*v_INV_3_b_i - 107.758927311578*v_INV_3_b_r - 59.421351346099*v_INV_3_c_i + 30.7882649461651*v_INV_3_c_r - 32.2332503520119*v_INV_4_a_i + 16.7011659854984*v_INV_4_a_r + 112.816376232042*v_INV_4_b_i - 58.4540809492443*v_INV_4_b_r - 32.2332503520119*v_INV_4_c_i + 16.7011659854984*v_INV_4_c_r + 91.6546016981107*v_TR_3_4_lv_a_i - 47.4895446494636*v_TR_3_4_lv_a_r - 354.574889727172*v_TR_3_4_lv_b_i + 368.915426669025*v_TR_3_4_lv_b_r + 91.6546016981109*v_TR_3_4_lv_c_i - 47.4895446494636*v_TR_3_4_lv_c_r - 0.390101533236234*v_TR_3_4_mv_a_i + 2.3406091994174*v_TR_3_4_mv_a_r + 0.390101533236234*v_TR_3_4_mv_b_i - 2.3406091994174*v_TR_3_4_mv_b_r
        struct[0].g[112,0] = i_TR_3_4_lv_c_r - 30.7882649461652*v_INV_3_a_i - 59.4213513460989*v_INV_3_a_r - 30.7882649461651*v_INV_3_b_i - 59.421351346099*v_INV_3_b_r + 107.758927311578*v_INV_3_c_i + 207.974729711346*v_INV_3_c_r - 16.7011659854984*v_INV_4_a_i - 32.2332503520119*v_INV_4_a_r - 16.7011659854983*v_INV_4_b_i - 32.2332503520119*v_INV_4_b_r + 58.4540809492443*v_INV_4_c_i + 112.816376232042*v_INV_4_c_r + 47.4895446494637*v_TR_3_4_lv_a_i + 91.6546016981108*v_TR_3_4_lv_a_r + 47.4895446494636*v_TR_3_4_lv_b_i + 91.6546016981109*v_TR_3_4_lv_b_r - 368.915426669025*v_TR_3_4_lv_c_i - 354.574889727171*v_TR_3_4_lv_c_r - 2.3406091994174*v_TR_3_4_mv_b_i - 0.390101533236234*v_TR_3_4_mv_b_r + 2.3406091994174*v_TR_3_4_mv_c_i + 0.390101533236234*v_TR_3_4_mv_c_r
        struct[0].g[113,0] = i_TR_3_4_lv_c_i - 59.4213513460989*v_INV_3_a_i + 30.7882649461652*v_INV_3_a_r - 59.421351346099*v_INV_3_b_i + 30.7882649461651*v_INV_3_b_r + 207.974729711346*v_INV_3_c_i - 107.758927311578*v_INV_3_c_r - 32.2332503520119*v_INV_4_a_i + 16.7011659854984*v_INV_4_a_r - 32.2332503520119*v_INV_4_b_i + 16.7011659854983*v_INV_4_b_r + 112.816376232042*v_INV_4_c_i - 58.4540809492443*v_INV_4_c_r + 91.6546016981108*v_TR_3_4_lv_a_i - 47.4895446494637*v_TR_3_4_lv_a_r + 91.6546016981109*v_TR_3_4_lv_b_i - 47.4895446494636*v_TR_3_4_lv_b_r - 354.574889727171*v_TR_3_4_lv_c_i + 368.915426669025*v_TR_3_4_lv_c_r - 0.390101533236234*v_TR_3_4_mv_b_i + 2.3406091994174*v_TR_3_4_mv_b_r + 0.390101533236234*v_TR_3_4_mv_c_i - 2.3406091994174*v_TR_3_4_mv_c_r
        struct[0].g[114,0] = i_TR_5_6_mv_a_r + 8.63801621787545*v_POImv_a_i + 6.47851216340659*v_POImv_a_r - 2.4680046336787*v_POImv_b_i - 1.85100347525903*v_POImv_b_r - 2.4680046336787*v_POImv_c_i - 1.85100347525903*v_POImv_c_r + 2.3406091994174*v_TR_5_6_lv_a_i + 0.390101533236234*v_TR_5_6_lv_a_r - 2.3406091994174*v_TR_5_6_lv_b_i - 0.390101533236234*v_TR_5_6_lv_b_r - 53.186989402129*v_TR_5_6_mv_a_i - 39.8587546923895*v_TR_5_6_mv_a_r + 15.2079060840306*v_TR_5_6_mv_b_i + 11.3901461283275*v_TR_5_6_mv_b_r + 15.2079060840306*v_TR_5_6_mv_c_i + 11.3901461283275*v_TR_5_6_mv_c_r + 44.4949780266318*v_TR_9_10_mv_a_i + 33.3712335199739*v_TR_9_10_mv_a_r - 12.7128508647519*v_TR_9_10_mv_b_i - 9.53463814856397*v_TR_9_10_mv_b_r - 12.7128508647519*v_TR_9_10_mv_c_i - 9.53463814856397*v_TR_9_10_mv_c_r
        struct[0].g[115,0] = i_TR_5_6_mv_a_i + 6.47851216340659*v_POImv_a_i - 8.63801621787545*v_POImv_a_r - 1.85100347525903*v_POImv_b_i + 2.4680046336787*v_POImv_b_r - 1.85100347525903*v_POImv_c_i + 2.4680046336787*v_POImv_c_r + 0.390101533236234*v_TR_5_6_lv_a_i - 2.3406091994174*v_TR_5_6_lv_a_r - 0.390101533236234*v_TR_5_6_lv_b_i + 2.3406091994174*v_TR_5_6_lv_b_r - 39.8587546923895*v_TR_5_6_mv_a_i + 53.186989402129*v_TR_5_6_mv_a_r + 11.3901461283275*v_TR_5_6_mv_b_i - 15.2079060840306*v_TR_5_6_mv_b_r + 11.3901461283275*v_TR_5_6_mv_c_i - 15.2079060840306*v_TR_5_6_mv_c_r + 33.3712335199739*v_TR_9_10_mv_a_i - 44.4949780266318*v_TR_9_10_mv_a_r - 9.53463814856397*v_TR_9_10_mv_b_i + 12.7128508647519*v_TR_9_10_mv_b_r - 9.53463814856397*v_TR_9_10_mv_c_i + 12.7128508647519*v_TR_9_10_mv_c_r
        struct[0].g[116,0] = i_TR_5_6_mv_b_r - 2.4680046336787*v_POImv_a_i - 1.85100347525903*v_POImv_a_r + 8.63801621787545*v_POImv_b_i + 6.47851216340659*v_POImv_b_r - 2.4680046336787*v_POImv_c_i - 1.85100347525903*v_POImv_c_r + 2.3406091994174*v_TR_5_6_lv_b_i + 0.390101533236234*v_TR_5_6_lv_b_r - 2.3406091994174*v_TR_5_6_lv_c_i - 0.390101533236234*v_TR_5_6_lv_c_r + 15.2079060840306*v_TR_5_6_mv_a_i + 11.3901461283275*v_TR_5_6_mv_a_r - 53.186989402129*v_TR_5_6_mv_b_i - 39.8587546923895*v_TR_5_6_mv_b_r + 15.2079060840306*v_TR_5_6_mv_c_i + 11.3901461283275*v_TR_5_6_mv_c_r - 12.7128508647519*v_TR_9_10_mv_a_i - 9.53463814856397*v_TR_9_10_mv_a_r + 44.4949780266318*v_TR_9_10_mv_b_i + 33.3712335199739*v_TR_9_10_mv_b_r - 12.712850864752*v_TR_9_10_mv_c_i - 9.53463814856399*v_TR_9_10_mv_c_r
        struct[0].g[117,0] = i_TR_5_6_mv_b_i - 1.85100347525903*v_POImv_a_i + 2.4680046336787*v_POImv_a_r + 6.47851216340659*v_POImv_b_i - 8.63801621787545*v_POImv_b_r - 1.85100347525903*v_POImv_c_i + 2.4680046336787*v_POImv_c_r + 0.390101533236234*v_TR_5_6_lv_b_i - 2.3406091994174*v_TR_5_6_lv_b_r - 0.390101533236234*v_TR_5_6_lv_c_i + 2.3406091994174*v_TR_5_6_lv_c_r + 11.3901461283275*v_TR_5_6_mv_a_i - 15.2079060840306*v_TR_5_6_mv_a_r - 39.8587546923895*v_TR_5_6_mv_b_i + 53.186989402129*v_TR_5_6_mv_b_r + 11.3901461283275*v_TR_5_6_mv_c_i - 15.2079060840306*v_TR_5_6_mv_c_r - 9.53463814856397*v_TR_9_10_mv_a_i + 12.7128508647519*v_TR_9_10_mv_a_r + 33.3712335199739*v_TR_9_10_mv_b_i - 44.4949780266318*v_TR_9_10_mv_b_r - 9.53463814856399*v_TR_9_10_mv_c_i + 12.712850864752*v_TR_9_10_mv_c_r
        struct[0].g[118,0] = i_TR_5_6_mv_c_r - 2.4680046336787*v_POImv_a_i - 1.85100347525903*v_POImv_a_r - 2.4680046336787*v_POImv_b_i - 1.85100347525903*v_POImv_b_r + 8.63801621787545*v_POImv_c_i + 6.47851216340659*v_POImv_c_r - 2.3406091994174*v_TR_5_6_lv_a_i - 0.390101533236234*v_TR_5_6_lv_a_r + 2.3406091994174*v_TR_5_6_lv_c_i + 0.390101533236234*v_TR_5_6_lv_c_r + 15.2079060840306*v_TR_5_6_mv_a_i + 11.3901461283275*v_TR_5_6_mv_a_r + 15.2079060840306*v_TR_5_6_mv_b_i + 11.3901461283275*v_TR_5_6_mv_b_r - 53.186989402129*v_TR_5_6_mv_c_i - 39.8587546923895*v_TR_5_6_mv_c_r - 12.7128508647519*v_TR_9_10_mv_a_i - 9.53463814856397*v_TR_9_10_mv_a_r - 12.712850864752*v_TR_9_10_mv_b_i - 9.53463814856399*v_TR_9_10_mv_b_r + 44.4949780266318*v_TR_9_10_mv_c_i + 33.3712335199739*v_TR_9_10_mv_c_r
        struct[0].g[119,0] = i_TR_5_6_mv_c_i - 1.85100347525903*v_POImv_a_i + 2.4680046336787*v_POImv_a_r - 1.85100347525903*v_POImv_b_i + 2.4680046336787*v_POImv_b_r + 6.47851216340659*v_POImv_c_i - 8.63801621787545*v_POImv_c_r - 0.390101533236234*v_TR_5_6_lv_a_i + 2.3406091994174*v_TR_5_6_lv_a_r + 0.390101533236234*v_TR_5_6_lv_c_i - 2.3406091994174*v_TR_5_6_lv_c_r + 11.3901461283275*v_TR_5_6_mv_a_i - 15.2079060840306*v_TR_5_6_mv_a_r + 11.3901461283275*v_TR_5_6_mv_b_i - 15.2079060840306*v_TR_5_6_mv_b_r - 39.8587546923895*v_TR_5_6_mv_c_i + 53.186989402129*v_TR_5_6_mv_c_r - 9.53463814856397*v_TR_9_10_mv_a_i + 12.7128508647519*v_TR_9_10_mv_a_r - 9.53463814856399*v_TR_9_10_mv_b_i + 12.712850864752*v_TR_9_10_mv_b_r + 33.3712335199739*v_TR_9_10_mv_c_i - 44.4949780266318*v_TR_9_10_mv_c_r
        struct[0].g[120,0] = i_TR_5_6_lv_a_r + 92.6872395051616*v_INV_5_a_i + 178.886372244962*v_INV_5_a_r - 26.4820684300462*v_INV_5_b_i - 51.1103920699891*v_INV_5_b_r - 26.4820684300462*v_INV_5_c_i - 51.1103920699891*v_INV_5_c_r + 58.4997822812349*v_INV_6_a_i + 112.904579802783*v_INV_6_a_r - 16.7142235089243*v_INV_6_b_i - 32.2584513722238*v_INV_6_b_r - 16.7142235089243*v_INV_6_c_i - 32.2584513722239*v_INV_6_c_r - 353.889424080847*v_TR_5_6_lv_a_i - 325.574735831529*v_TR_5_6_lv_a_r + 43.1964121022714*v_TR_5_6_lv_b_i + 83.3688434422129*v_TR_5_6_lv_b_r + 43.1964121022714*v_TR_5_6_lv_c_i + 83.368843442213*v_TR_5_6_lv_c_r + 2.3406091994174*v_TR_5_6_mv_a_i + 0.390101533236234*v_TR_5_6_mv_a_r - 2.3406091994174*v_TR_5_6_mv_c_i - 0.390101533236234*v_TR_5_6_mv_c_r
        struct[0].g[121,0] = i_TR_5_6_lv_a_i + 178.886372244962*v_INV_5_a_i - 92.6872395051616*v_INV_5_a_r - 51.1103920699891*v_INV_5_b_i + 26.4820684300462*v_INV_5_b_r - 51.1103920699891*v_INV_5_c_i + 26.4820684300462*v_INV_5_c_r + 112.904579802783*v_INV_6_a_i - 58.4997822812349*v_INV_6_a_r - 32.2584513722238*v_INV_6_b_i + 16.7142235089243*v_INV_6_b_r - 32.2584513722239*v_INV_6_c_i + 16.7142235089243*v_INV_6_c_r - 325.574735831529*v_TR_5_6_lv_a_i + 353.889424080847*v_TR_5_6_lv_a_r + 83.3688434422129*v_TR_5_6_lv_b_i - 43.1964121022714*v_TR_5_6_lv_b_r + 83.368843442213*v_TR_5_6_lv_c_i - 43.1964121022714*v_TR_5_6_lv_c_r + 0.390101533236234*v_TR_5_6_mv_a_i - 2.3406091994174*v_TR_5_6_mv_a_r - 0.390101533236234*v_TR_5_6_mv_c_i + 2.3406091994174*v_TR_5_6_mv_c_r
        struct[0].g[122,0] = i_TR_5_6_lv_b_r - 26.4820684300461*v_INV_5_a_i - 51.1103920699891*v_INV_5_a_r + 92.6872395051615*v_INV_5_b_i + 178.886372244962*v_INV_5_b_r - 26.4820684300461*v_INV_5_c_i - 51.1103920699892*v_INV_5_c_r - 16.7142235089243*v_INV_6_a_i - 32.2584513722238*v_INV_6_a_r + 58.4997822812349*v_INV_6_b_i + 112.904579802783*v_INV_6_b_r - 16.7142235089242*v_INV_6_c_i - 32.2584513722239*v_INV_6_c_r + 43.1964121022714*v_TR_5_6_lv_a_i + 83.3688434422129*v_TR_5_6_lv_a_r - 353.889424080846*v_TR_5_6_lv_b_i - 325.574735831529*v_TR_5_6_lv_b_r + 43.1964121022714*v_TR_5_6_lv_c_i + 83.3688434422131*v_TR_5_6_lv_c_r - 2.3406091994174*v_TR_5_6_mv_a_i - 0.390101533236234*v_TR_5_6_mv_a_r + 2.3406091994174*v_TR_5_6_mv_b_i + 0.390101533236234*v_TR_5_6_mv_b_r
        struct[0].g[123,0] = i_TR_5_6_lv_b_i - 51.1103920699891*v_INV_5_a_i + 26.4820684300461*v_INV_5_a_r + 178.886372244962*v_INV_5_b_i - 92.6872395051615*v_INV_5_b_r - 51.1103920699892*v_INV_5_c_i + 26.4820684300461*v_INV_5_c_r - 32.2584513722238*v_INV_6_a_i + 16.7142235089243*v_INV_6_a_r + 112.904579802783*v_INV_6_b_i - 58.4997822812349*v_INV_6_b_r - 32.2584513722239*v_INV_6_c_i + 16.7142235089242*v_INV_6_c_r + 83.3688434422129*v_TR_5_6_lv_a_i - 43.1964121022714*v_TR_5_6_lv_a_r - 325.574735831529*v_TR_5_6_lv_b_i + 353.889424080846*v_TR_5_6_lv_b_r + 83.3688434422131*v_TR_5_6_lv_c_i - 43.1964121022714*v_TR_5_6_lv_c_r - 0.390101533236234*v_TR_5_6_mv_a_i + 2.3406091994174*v_TR_5_6_mv_a_r + 0.390101533236234*v_TR_5_6_mv_b_i - 2.3406091994174*v_TR_5_6_mv_b_r
        struct[0].g[124,0] = i_TR_5_6_lv_c_r - 26.4820684300462*v_INV_5_a_i - 51.1103920699891*v_INV_5_a_r - 26.4820684300461*v_INV_5_b_i - 51.1103920699892*v_INV_5_b_r + 92.6872395051615*v_INV_5_c_i + 178.886372244962*v_INV_5_c_r - 16.7142235089243*v_INV_6_a_i - 32.2584513722239*v_INV_6_a_r - 16.7142235089242*v_INV_6_b_i - 32.2584513722239*v_INV_6_b_r + 58.4997822812349*v_INV_6_c_i + 112.904579802783*v_INV_6_c_r + 43.1964121022714*v_TR_5_6_lv_a_i + 83.368843442213*v_TR_5_6_lv_a_r + 43.1964121022714*v_TR_5_6_lv_b_i + 83.3688434422131*v_TR_5_6_lv_b_r - 353.889424080846*v_TR_5_6_lv_c_i - 325.574735831529*v_TR_5_6_lv_c_r - 2.3406091994174*v_TR_5_6_mv_b_i - 0.390101533236234*v_TR_5_6_mv_b_r + 2.3406091994174*v_TR_5_6_mv_c_i + 0.390101533236234*v_TR_5_6_mv_c_r
        struct[0].g[125,0] = i_TR_5_6_lv_c_i - 51.1103920699891*v_INV_5_a_i + 26.4820684300462*v_INV_5_a_r - 51.1103920699892*v_INV_5_b_i + 26.4820684300461*v_INV_5_b_r + 178.886372244962*v_INV_5_c_i - 92.6872395051615*v_INV_5_c_r - 32.2584513722239*v_INV_6_a_i + 16.7142235089243*v_INV_6_a_r - 32.2584513722239*v_INV_6_b_i + 16.7142235089242*v_INV_6_b_r + 112.904579802783*v_INV_6_c_i - 58.4997822812349*v_INV_6_c_r + 83.368843442213*v_TR_5_6_lv_a_i - 43.1964121022714*v_TR_5_6_lv_a_r + 83.3688434422131*v_TR_5_6_lv_b_i - 43.1964121022714*v_TR_5_6_lv_b_r - 325.574735831529*v_TR_5_6_lv_c_i + 353.889424080846*v_TR_5_6_lv_c_r - 0.390101533236234*v_TR_5_6_mv_b_i + 2.3406091994174*v_TR_5_6_mv_b_r + 0.390101533236234*v_TR_5_6_mv_c_i - 2.3406091994174*v_TR_5_6_mv_c_r
        struct[0].g[126,0] = i_TR_7_8_mv_a_r + 6.60088643956832*v_TR_13_mv_a_i + 8.97043541787489*v_TR_13_mv_a_r - 1.88596755416238*v_TR_13_mv_b_i - 2.56298154796426*v_TR_13_mv_b_r - 1.88596755416237*v_TR_13_mv_c_i - 2.56298154796426*v_TR_13_mv_c_r + 15.0420612397687*v_TR_3_4_mv_a_i + 20.4417755309677*v_TR_3_4_mv_a_r - 4.29773178279105*v_TR_3_4_mv_b_i - 5.8405072945622*v_TR_3_4_mv_b_r - 4.29773178279104*v_TR_3_4_mv_c_i - 5.84050729456219*v_TR_3_4_mv_c_r + 2.3406091994174*v_TR_7_8_lv_a_i + 0.390101533236234*v_TR_7_8_lv_a_r - 2.3406091994174*v_TR_7_8_lv_b_i - 0.390101533236234*v_TR_7_8_lv_b_r - 21.6969684194189*v_TR_7_8_mv_a_i - 29.4212199578516*v_TR_7_8_mv_a_r + 6.21073968956929*v_TR_7_8_mv_b_i + 8.40799334703096*v_TR_7_8_mv_b_r + 6.21073968956928*v_TR_7_8_mv_c_i + 8.40799334703096*v_TR_7_8_mv_c_r
        struct[0].g[127,0] = i_TR_7_8_mv_a_i + 8.97043541787489*v_TR_13_mv_a_i - 6.60088643956832*v_TR_13_mv_a_r - 2.56298154796426*v_TR_13_mv_b_i + 1.88596755416238*v_TR_13_mv_b_r - 2.56298154796426*v_TR_13_mv_c_i + 1.88596755416237*v_TR_13_mv_c_r + 20.4417755309677*v_TR_3_4_mv_a_i - 15.0420612397687*v_TR_3_4_mv_a_r - 5.8405072945622*v_TR_3_4_mv_b_i + 4.29773178279105*v_TR_3_4_mv_b_r - 5.84050729456219*v_TR_3_4_mv_c_i + 4.29773178279104*v_TR_3_4_mv_c_r + 0.390101533236234*v_TR_7_8_lv_a_i - 2.3406091994174*v_TR_7_8_lv_a_r - 0.390101533236234*v_TR_7_8_lv_b_i + 2.3406091994174*v_TR_7_8_lv_b_r - 29.4212199578516*v_TR_7_8_mv_a_i + 21.6969684194189*v_TR_7_8_mv_a_r + 8.40799334703096*v_TR_7_8_mv_b_i - 6.21073968956929*v_TR_7_8_mv_b_r + 8.40799334703096*v_TR_7_8_mv_c_i - 6.21073968956928*v_TR_7_8_mv_c_r
        struct[0].g[128,0] = i_TR_7_8_mv_b_r - 1.88596755416238*v_TR_13_mv_a_i - 2.56298154796426*v_TR_13_mv_a_r + 6.60088643956832*v_TR_13_mv_b_i + 8.9704354178749*v_TR_13_mv_b_r - 1.88596755416237*v_TR_13_mv_c_i - 2.56298154796426*v_TR_13_mv_c_r - 4.29773178279105*v_TR_3_4_mv_a_i - 5.8405072945622*v_TR_3_4_mv_a_r + 15.0420612397687*v_TR_3_4_mv_b_i + 20.4417755309677*v_TR_3_4_mv_b_r - 4.29773178279105*v_TR_3_4_mv_c_i - 5.8405072945622*v_TR_3_4_mv_c_r + 2.3406091994174*v_TR_7_8_lv_b_i + 0.390101533236234*v_TR_7_8_lv_b_r - 2.3406091994174*v_TR_7_8_lv_c_i - 0.390101533236234*v_TR_7_8_lv_c_r + 6.21073968956929*v_TR_7_8_mv_a_i + 8.40799334703096*v_TR_7_8_mv_a_r - 21.6969684194189*v_TR_7_8_mv_b_i - 29.4212199578516*v_TR_7_8_mv_b_r + 6.21073968956929*v_TR_7_8_mv_c_i + 8.40799334703097*v_TR_7_8_mv_c_r
        struct[0].g[129,0] = i_TR_7_8_mv_b_i - 2.56298154796426*v_TR_13_mv_a_i + 1.88596755416238*v_TR_13_mv_a_r + 8.9704354178749*v_TR_13_mv_b_i - 6.60088643956832*v_TR_13_mv_b_r - 2.56298154796426*v_TR_13_mv_c_i + 1.88596755416237*v_TR_13_mv_c_r - 5.8405072945622*v_TR_3_4_mv_a_i + 4.29773178279105*v_TR_3_4_mv_a_r + 20.4417755309677*v_TR_3_4_mv_b_i - 15.0420612397687*v_TR_3_4_mv_b_r - 5.8405072945622*v_TR_3_4_mv_c_i + 4.29773178279105*v_TR_3_4_mv_c_r + 0.390101533236234*v_TR_7_8_lv_b_i - 2.3406091994174*v_TR_7_8_lv_b_r - 0.390101533236234*v_TR_7_8_lv_c_i + 2.3406091994174*v_TR_7_8_lv_c_r + 8.40799334703096*v_TR_7_8_mv_a_i - 6.21073968956929*v_TR_7_8_mv_a_r - 29.4212199578516*v_TR_7_8_mv_b_i + 21.6969684194189*v_TR_7_8_mv_b_r + 8.40799334703097*v_TR_7_8_mv_c_i - 6.21073968956929*v_TR_7_8_mv_c_r
        struct[0].g[130,0] = i_TR_7_8_mv_c_r - 1.88596755416237*v_TR_13_mv_a_i - 2.56298154796426*v_TR_13_mv_a_r - 1.88596755416237*v_TR_13_mv_b_i - 2.56298154796426*v_TR_13_mv_b_r + 6.60088643956831*v_TR_13_mv_c_i + 8.9704354178749*v_TR_13_mv_c_r - 4.29773178279105*v_TR_3_4_mv_a_i - 5.84050729456219*v_TR_3_4_mv_a_r - 4.29773178279104*v_TR_3_4_mv_b_i - 5.84050729456221*v_TR_3_4_mv_b_r + 15.0420612397687*v_TR_3_4_mv_c_i + 20.4417755309677*v_TR_3_4_mv_c_r - 2.3406091994174*v_TR_7_8_lv_a_i - 0.390101533236234*v_TR_7_8_lv_a_r + 2.3406091994174*v_TR_7_8_lv_c_i + 0.390101533236234*v_TR_7_8_lv_c_r + 6.21073968956929*v_TR_7_8_mv_a_i + 8.40799334703095*v_TR_7_8_mv_a_r + 6.21073968956928*v_TR_7_8_mv_b_i + 8.40799334703097*v_TR_7_8_mv_b_r - 21.6969684194189*v_TR_7_8_mv_c_i - 29.4212199578516*v_TR_7_8_mv_c_r
        struct[0].g[131,0] = i_TR_7_8_mv_c_i - 2.56298154796426*v_TR_13_mv_a_i + 1.88596755416237*v_TR_13_mv_a_r - 2.56298154796426*v_TR_13_mv_b_i + 1.88596755416237*v_TR_13_mv_b_r + 8.9704354178749*v_TR_13_mv_c_i - 6.60088643956831*v_TR_13_mv_c_r - 5.84050729456219*v_TR_3_4_mv_a_i + 4.29773178279105*v_TR_3_4_mv_a_r - 5.84050729456221*v_TR_3_4_mv_b_i + 4.29773178279104*v_TR_3_4_mv_b_r + 20.4417755309677*v_TR_3_4_mv_c_i - 15.0420612397687*v_TR_3_4_mv_c_r - 0.390101533236234*v_TR_7_8_lv_a_i + 2.3406091994174*v_TR_7_8_lv_a_r + 0.390101533236234*v_TR_7_8_lv_c_i - 2.3406091994174*v_TR_7_8_lv_c_r + 8.40799334703095*v_TR_7_8_mv_a_i - 6.21073968956929*v_TR_7_8_mv_a_r + 8.40799334703097*v_TR_7_8_mv_b_i - 6.21073968956928*v_TR_7_8_mv_b_r - 29.4212199578516*v_TR_7_8_mv_c_i + 21.6969684194189*v_TR_7_8_mv_c_r
        struct[0].g[132,0] = i_TR_7_8_lv_a_r + 246.057604426258*v_INV_7_a_i + 474.891176542679*v_INV_7_a_r - 70.3021726932167*v_INV_7_b_i - 135.683193297908*v_INV_7_b_r - 70.3021726932166*v_INV_7_c_i - 135.683193297908*v_INV_7_c_r + 106.794172415445*v_INV_8_a_i + 206.112752761809*v_INV_8_a_r - 30.5126206901271*v_INV_8_b_i - 58.8893579319454*v_INV_8_b_r - 30.5126206901271*v_INV_8_c_i - 58.8893579319454*v_INV_8_c_r - 555.554334874064*v_TR_7_8_lv_a_i - 714.787713088272*v_TR_7_8_lv_a_r + 100.81485125148*v_TR_7_8_lv_b_i + 194.572551229854*v_TR_7_8_lv_b_r + 100.81485125148*v_TR_7_8_lv_c_i + 194.572551229854*v_TR_7_8_lv_c_r + 2.3406091994174*v_TR_7_8_mv_a_i + 0.390101533236234*v_TR_7_8_mv_a_r - 2.3406091994174*v_TR_7_8_mv_c_i - 0.390101533236234*v_TR_7_8_mv_c_r
        struct[0].g[133,0] = i_TR_7_8_lv_a_i + 474.891176542679*v_INV_7_a_i - 246.057604426258*v_INV_7_a_r - 135.683193297908*v_INV_7_b_i + 70.3021726932167*v_INV_7_b_r - 135.683193297908*v_INV_7_c_i + 70.3021726932166*v_INV_7_c_r + 206.112752761809*v_INV_8_a_i - 106.794172415445*v_INV_8_a_r - 58.8893579319454*v_INV_8_b_i + 30.5126206901271*v_INV_8_b_r - 58.8893579319454*v_INV_8_c_i + 30.5126206901271*v_INV_8_c_r - 714.787713088272*v_TR_7_8_lv_a_i + 555.554334874064*v_TR_7_8_lv_a_r + 194.572551229854*v_TR_7_8_lv_b_i - 100.81485125148*v_TR_7_8_lv_b_r + 194.572551229854*v_TR_7_8_lv_c_i - 100.81485125148*v_TR_7_8_lv_c_r + 0.390101533236234*v_TR_7_8_mv_a_i - 2.3406091994174*v_TR_7_8_mv_a_r - 0.390101533236234*v_TR_7_8_mv_c_i + 2.3406091994174*v_TR_7_8_mv_c_r
        struct[0].g[134,0] = i_TR_7_8_lv_b_r - 70.3021726932166*v_INV_7_a_i - 135.683193297908*v_INV_7_a_r + 246.057604426258*v_INV_7_b_i + 474.891176542679*v_INV_7_b_r - 70.3021726932165*v_INV_7_c_i - 135.683193297909*v_INV_7_c_r - 30.5126206901271*v_INV_8_a_i - 58.8893579319454*v_INV_8_a_r + 106.794172415445*v_INV_8_b_i + 206.112752761809*v_INV_8_b_r - 30.5126206901271*v_INV_8_c_i - 58.8893579319455*v_INV_8_c_r + 100.81485125148*v_TR_7_8_lv_a_i + 194.572551229854*v_TR_7_8_lv_a_r - 555.554334874064*v_TR_7_8_lv_b_i - 714.787713088272*v_TR_7_8_lv_b_r + 100.81485125148*v_TR_7_8_lv_c_i + 194.572551229854*v_TR_7_8_lv_c_r - 2.3406091994174*v_TR_7_8_mv_a_i - 0.390101533236234*v_TR_7_8_mv_a_r + 2.3406091994174*v_TR_7_8_mv_b_i + 0.390101533236234*v_TR_7_8_mv_b_r
        struct[0].g[135,0] = i_TR_7_8_lv_b_i - 135.683193297908*v_INV_7_a_i + 70.3021726932166*v_INV_7_a_r + 474.891176542679*v_INV_7_b_i - 246.057604426258*v_INV_7_b_r - 135.683193297909*v_INV_7_c_i + 70.3021726932165*v_INV_7_c_r - 58.8893579319454*v_INV_8_a_i + 30.5126206901271*v_INV_8_a_r + 206.112752761809*v_INV_8_b_i - 106.794172415445*v_INV_8_b_r - 58.8893579319455*v_INV_8_c_i + 30.5126206901271*v_INV_8_c_r + 194.572551229854*v_TR_7_8_lv_a_i - 100.81485125148*v_TR_7_8_lv_a_r - 714.787713088272*v_TR_7_8_lv_b_i + 555.554334874064*v_TR_7_8_lv_b_r + 194.572551229854*v_TR_7_8_lv_c_i - 100.81485125148*v_TR_7_8_lv_c_r - 0.390101533236234*v_TR_7_8_mv_a_i + 2.3406091994174*v_TR_7_8_mv_a_r + 0.390101533236234*v_TR_7_8_mv_b_i - 2.3406091994174*v_TR_7_8_mv_b_r
        struct[0].g[136,0] = i_TR_7_8_lv_c_r - 70.3021726932167*v_INV_7_a_i - 135.683193297908*v_INV_7_a_r - 70.3021726932165*v_INV_7_b_i - 135.683193297909*v_INV_7_b_r + 246.057604426258*v_INV_7_c_i + 474.891176542679*v_INV_7_c_r - 30.5126206901272*v_INV_8_a_i - 58.8893579319454*v_INV_8_a_r - 30.5126206901271*v_INV_8_b_i - 58.8893579319455*v_INV_8_b_r + 106.794172415445*v_INV_8_c_i + 206.112752761809*v_INV_8_c_r + 100.814851251481*v_TR_7_8_lv_a_i + 194.572551229854*v_TR_7_8_lv_a_r + 100.81485125148*v_TR_7_8_lv_b_i + 194.572551229854*v_TR_7_8_lv_b_r - 555.554334874064*v_TR_7_8_lv_c_i - 714.787713088272*v_TR_7_8_lv_c_r - 2.3406091994174*v_TR_7_8_mv_b_i - 0.390101533236234*v_TR_7_8_mv_b_r + 2.3406091994174*v_TR_7_8_mv_c_i + 0.390101533236234*v_TR_7_8_mv_c_r
        struct[0].g[137,0] = i_TR_7_8_lv_c_i - 135.683193297908*v_INV_7_a_i + 70.3021726932167*v_INV_7_a_r - 135.683193297909*v_INV_7_b_i + 70.3021726932165*v_INV_7_b_r + 474.891176542679*v_INV_7_c_i - 246.057604426258*v_INV_7_c_r - 58.8893579319454*v_INV_8_a_i + 30.5126206901272*v_INV_8_a_r - 58.8893579319455*v_INV_8_b_i + 30.5126206901271*v_INV_8_b_r + 206.112752761809*v_INV_8_c_i - 106.794172415445*v_INV_8_c_r + 194.572551229854*v_TR_7_8_lv_a_i - 100.814851251481*v_TR_7_8_lv_a_r + 194.572551229854*v_TR_7_8_lv_b_i - 100.81485125148*v_TR_7_8_lv_b_r - 714.787713088272*v_TR_7_8_lv_c_i + 555.554334874064*v_TR_7_8_lv_c_r - 0.390101533236234*v_TR_7_8_mv_b_i + 2.3406091994174*v_TR_7_8_mv_b_r + 0.390101533236234*v_TR_7_8_mv_c_i - 2.3406091994174*v_TR_7_8_mv_c_r
        struct[0].g[138,0] = i_TR_9_10_mv_a_r + 8.85995441972108*v_TR_11_12_mv_a_i + 12.0404508780825*v_TR_11_12_mv_a_r - 2.53141554849174*v_TR_11_12_mv_b_i - 3.44012882230928*v_TR_11_12_mv_b_r - 2.53141554849173*v_TR_11_12_mv_c_i - 3.44012882230929*v_TR_11_12_mv_c_r + 44.4949780266318*v_TR_5_6_mv_a_i + 33.3712335199739*v_TR_5_6_mv_a_r - 12.7128508647519*v_TR_5_6_mv_b_i - 9.53463814856397*v_TR_5_6_mv_b_r - 12.7128508647519*v_TR_5_6_mv_c_i - 9.53463814856397*v_TR_5_6_mv_c_r + 2.3406091994174*v_TR_9_10_lv_a_i + 0.390101533236234*v_TR_9_10_lv_a_r - 2.3406091994174*v_TR_9_10_lv_b_i - 0.390101533236234*v_TR_9_10_lv_b_r - 53.4089596754468*v_TR_9_10_mv_a_i - 45.4206934070654*v_TR_9_10_mv_a_r + 15.2713041702548*v_TR_9_10_mv_b_i + 12.9792714753778*v_TR_9_10_mv_b_r + 15.2713041702547*v_TR_9_10_mv_c_i + 12.9792714753778*v_TR_9_10_mv_c_r
        struct[0].g[139,0] = i_TR_9_10_mv_a_i + 12.0404508780825*v_TR_11_12_mv_a_i - 8.85995441972108*v_TR_11_12_mv_a_r - 3.44012882230928*v_TR_11_12_mv_b_i + 2.53141554849174*v_TR_11_12_mv_b_r - 3.44012882230929*v_TR_11_12_mv_c_i + 2.53141554849173*v_TR_11_12_mv_c_r + 33.3712335199739*v_TR_5_6_mv_a_i - 44.4949780266318*v_TR_5_6_mv_a_r - 9.53463814856397*v_TR_5_6_mv_b_i + 12.7128508647519*v_TR_5_6_mv_b_r - 9.53463814856397*v_TR_5_6_mv_c_i + 12.7128508647519*v_TR_5_6_mv_c_r + 0.390101533236234*v_TR_9_10_lv_a_i - 2.3406091994174*v_TR_9_10_lv_a_r - 0.390101533236234*v_TR_9_10_lv_b_i + 2.3406091994174*v_TR_9_10_lv_b_r - 45.4206934070654*v_TR_9_10_mv_a_i + 53.4089596754468*v_TR_9_10_mv_a_r + 12.9792714753778*v_TR_9_10_mv_b_i - 15.2713041702548*v_TR_9_10_mv_b_r + 12.9792714753778*v_TR_9_10_mv_c_i - 15.2713041702547*v_TR_9_10_mv_c_r
        struct[0].g[140,0] = i_TR_9_10_mv_b_r - 2.53141554849173*v_TR_11_12_mv_a_i - 3.44012882230929*v_TR_11_12_mv_a_r + 8.85995441972108*v_TR_11_12_mv_b_i + 12.0404508780825*v_TR_11_12_mv_b_r - 2.53141554849174*v_TR_11_12_mv_c_i - 3.44012882230929*v_TR_11_12_mv_c_r - 12.7128508647519*v_TR_5_6_mv_a_i - 9.53463814856397*v_TR_5_6_mv_a_r + 44.4949780266318*v_TR_5_6_mv_b_i + 33.3712335199739*v_TR_5_6_mv_b_r - 12.712850864752*v_TR_5_6_mv_c_i - 9.53463814856399*v_TR_5_6_mv_c_r + 2.3406091994174*v_TR_9_10_lv_b_i + 0.390101533236234*v_TR_9_10_lv_b_r - 2.3406091994174*v_TR_9_10_lv_c_i - 0.390101533236234*v_TR_9_10_lv_c_r + 15.2713041702548*v_TR_9_10_mv_a_i + 12.9792714753778*v_TR_9_10_mv_a_r - 53.4089596754469*v_TR_9_10_mv_b_i - 45.4206934070654*v_TR_9_10_mv_b_r + 15.2713041702548*v_TR_9_10_mv_c_i + 12.9792714753778*v_TR_9_10_mv_c_r
        struct[0].g[141,0] = i_TR_9_10_mv_b_i - 3.44012882230929*v_TR_11_12_mv_a_i + 2.53141554849173*v_TR_11_12_mv_a_r + 12.0404508780825*v_TR_11_12_mv_b_i - 8.85995441972108*v_TR_11_12_mv_b_r - 3.44012882230929*v_TR_11_12_mv_c_i + 2.53141554849174*v_TR_11_12_mv_c_r - 9.53463814856397*v_TR_5_6_mv_a_i + 12.7128508647519*v_TR_5_6_mv_a_r + 33.3712335199739*v_TR_5_6_mv_b_i - 44.4949780266318*v_TR_5_6_mv_b_r - 9.53463814856399*v_TR_5_6_mv_c_i + 12.712850864752*v_TR_5_6_mv_c_r + 0.390101533236234*v_TR_9_10_lv_b_i - 2.3406091994174*v_TR_9_10_lv_b_r - 0.390101533236234*v_TR_9_10_lv_c_i + 2.3406091994174*v_TR_9_10_lv_c_r + 12.9792714753778*v_TR_9_10_mv_a_i - 15.2713041702548*v_TR_9_10_mv_a_r - 45.4206934070654*v_TR_9_10_mv_b_i + 53.4089596754469*v_TR_9_10_mv_b_r + 12.9792714753778*v_TR_9_10_mv_c_i - 15.2713041702548*v_TR_9_10_mv_c_r
        struct[0].g[142,0] = i_TR_9_10_mv_c_r - 2.53141554849174*v_TR_11_12_mv_a_i - 3.44012882230928*v_TR_11_12_mv_a_r - 2.53141554849174*v_TR_11_12_mv_b_i - 3.44012882230929*v_TR_11_12_mv_b_r + 8.85995441972108*v_TR_11_12_mv_c_i + 12.0404508780825*v_TR_11_12_mv_c_r - 12.7128508647519*v_TR_5_6_mv_a_i - 9.53463814856397*v_TR_5_6_mv_a_r - 12.712850864752*v_TR_5_6_mv_b_i - 9.53463814856399*v_TR_5_6_mv_b_r + 44.4949780266318*v_TR_5_6_mv_c_i + 33.3712335199739*v_TR_5_6_mv_c_r - 2.3406091994174*v_TR_9_10_lv_a_i - 0.390101533236234*v_TR_9_10_lv_a_r + 2.3406091994174*v_TR_9_10_lv_c_i + 0.390101533236234*v_TR_9_10_lv_c_r + 15.2713041702548*v_TR_9_10_mv_a_i + 12.9792714753778*v_TR_9_10_mv_a_r + 15.2713041702548*v_TR_9_10_mv_b_i + 12.9792714753778*v_TR_9_10_mv_b_r - 53.4089596754468*v_TR_9_10_mv_c_i - 45.4206934070654*v_TR_9_10_mv_c_r
        struct[0].g[143,0] = i_TR_9_10_mv_c_i - 3.44012882230928*v_TR_11_12_mv_a_i + 2.53141554849174*v_TR_11_12_mv_a_r - 3.44012882230929*v_TR_11_12_mv_b_i + 2.53141554849174*v_TR_11_12_mv_b_r + 12.0404508780825*v_TR_11_12_mv_c_i - 8.85995441972108*v_TR_11_12_mv_c_r - 9.53463814856397*v_TR_5_6_mv_a_i + 12.7128508647519*v_TR_5_6_mv_a_r - 9.53463814856399*v_TR_5_6_mv_b_i + 12.712850864752*v_TR_5_6_mv_b_r + 33.3712335199739*v_TR_5_6_mv_c_i - 44.4949780266318*v_TR_5_6_mv_c_r - 0.390101533236234*v_TR_9_10_lv_a_i + 2.3406091994174*v_TR_9_10_lv_a_r + 0.390101533236234*v_TR_9_10_lv_c_i - 2.3406091994174*v_TR_9_10_lv_c_r + 12.9792714753778*v_TR_9_10_mv_a_i - 15.2713041702548*v_TR_9_10_mv_a_r + 12.9792714753778*v_TR_9_10_mv_b_i - 15.2713041702548*v_TR_9_10_mv_b_r - 45.4206934070654*v_TR_9_10_mv_c_i + 53.4089596754468*v_TR_9_10_mv_c_r
        struct[0].g[144,0] = i_TR_9_10_lv_a_r + 75.8059117481773*v_INV_10_a_i + 146.305409673982*v_INV_10_a_r - 21.6588319280506*v_INV_10_b_i - 41.8015456211378*v_INV_10_b_r - 21.6588319280506*v_INV_10_c_i - 41.8015456211378*v_INV_10_c_r + 98.1764998873781*v_INV_9_a_i + 189.48064478264*v_INV_9_a_r - 28.0504285392509*v_INV_9_b_i - 54.1373270807543*v_INV_9_b_r - 28.0504285392509*v_INV_9_c_i - 54.1373270807543*v_INV_9_c_r - 376.684862474157*v_TR_9_10_lv_a_i - 369.569838240406*v_TR_9_10_lv_a_r + 49.709361212942*v_TR_9_10_lv_b_i + 95.9388727018921*v_TR_9_10_lv_b_r + 49.7093612129419*v_TR_9_10_lv_c_i + 95.9388727018921*v_TR_9_10_lv_c_r + 2.3406091994174*v_TR_9_10_mv_a_i + 0.390101533236234*v_TR_9_10_mv_a_r - 2.3406091994174*v_TR_9_10_mv_c_i - 0.390101533236234*v_TR_9_10_mv_c_r
        struct[0].g[145,0] = i_TR_9_10_lv_a_i + 146.305409673982*v_INV_10_a_i - 75.8059117481773*v_INV_10_a_r - 41.8015456211378*v_INV_10_b_i + 21.6588319280506*v_INV_10_b_r - 41.8015456211378*v_INV_10_c_i + 21.6588319280506*v_INV_10_c_r + 189.48064478264*v_INV_9_a_i - 98.1764998873781*v_INV_9_a_r - 54.1373270807543*v_INV_9_b_i + 28.0504285392509*v_INV_9_b_r - 54.1373270807543*v_INV_9_c_i + 28.0504285392509*v_INV_9_c_r - 369.569838240406*v_TR_9_10_lv_a_i + 376.684862474157*v_TR_9_10_lv_a_r + 95.9388727018921*v_TR_9_10_lv_b_i - 49.709361212942*v_TR_9_10_lv_b_r + 95.9388727018921*v_TR_9_10_lv_c_i - 49.7093612129419*v_TR_9_10_lv_c_r + 0.390101533236234*v_TR_9_10_mv_a_i - 2.3406091994174*v_TR_9_10_mv_a_r - 0.390101533236234*v_TR_9_10_mv_c_i + 2.3406091994174*v_TR_9_10_mv_c_r
        struct[0].g[146,0] = i_TR_9_10_lv_b_r - 21.6588319280506*v_INV_10_a_i - 41.8015456211377*v_INV_10_a_r + 75.8059117481773*v_INV_10_b_i + 146.305409673982*v_INV_10_b_r - 21.6588319280506*v_INV_10_c_i - 41.8015456211378*v_INV_10_c_r - 28.0504285392509*v_INV_9_a_i - 54.1373270807543*v_INV_9_a_r + 98.1764998873781*v_INV_9_b_i + 189.48064478264*v_INV_9_b_r - 28.0504285392509*v_INV_9_c_i - 54.1373270807544*v_INV_9_c_r + 49.7093612129419*v_TR_9_10_lv_a_i + 95.938872701892*v_TR_9_10_lv_a_r - 376.684862474157*v_TR_9_10_lv_b_i - 369.569838240406*v_TR_9_10_lv_b_r + 49.7093612129419*v_TR_9_10_lv_c_i + 95.9388727018922*v_TR_9_10_lv_c_r - 2.3406091994174*v_TR_9_10_mv_a_i - 0.390101533236234*v_TR_9_10_mv_a_r + 2.3406091994174*v_TR_9_10_mv_b_i + 0.390101533236234*v_TR_9_10_mv_b_r
        struct[0].g[147,0] = i_TR_9_10_lv_b_i - 41.8015456211377*v_INV_10_a_i + 21.6588319280506*v_INV_10_a_r + 146.305409673982*v_INV_10_b_i - 75.8059117481773*v_INV_10_b_r - 41.8015456211378*v_INV_10_c_i + 21.6588319280506*v_INV_10_c_r - 54.1373270807543*v_INV_9_a_i + 28.0504285392509*v_INV_9_a_r + 189.48064478264*v_INV_9_b_i - 98.1764998873781*v_INV_9_b_r - 54.1373270807544*v_INV_9_c_i + 28.0504285392509*v_INV_9_c_r + 95.938872701892*v_TR_9_10_lv_a_i - 49.7093612129419*v_TR_9_10_lv_a_r - 369.569838240406*v_TR_9_10_lv_b_i + 376.684862474157*v_TR_9_10_lv_b_r + 95.9388727018922*v_TR_9_10_lv_c_i - 49.7093612129419*v_TR_9_10_lv_c_r - 0.390101533236234*v_TR_9_10_mv_a_i + 2.3406091994174*v_TR_9_10_mv_a_r + 0.390101533236234*v_TR_9_10_mv_b_i - 2.3406091994174*v_TR_9_10_mv_b_r
        struct[0].g[148,0] = i_TR_9_10_lv_c_r - 21.6588319280506*v_INV_10_a_i - 41.8015456211378*v_INV_10_a_r - 21.6588319280506*v_INV_10_b_i - 41.8015456211378*v_INV_10_b_r + 75.8059117481773*v_INV_10_c_i + 146.305409673982*v_INV_10_c_r - 28.0504285392509*v_INV_9_a_i - 54.1373270807543*v_INV_9_a_r - 28.0504285392509*v_INV_9_b_i - 54.1373270807543*v_INV_9_b_r + 98.1764998873781*v_INV_9_c_i + 189.48064478264*v_INV_9_c_r + 49.709361212942*v_TR_9_10_lv_a_i + 95.9388727018921*v_TR_9_10_lv_a_r + 49.7093612129419*v_TR_9_10_lv_b_i + 95.9388727018921*v_TR_9_10_lv_b_r - 376.684862474157*v_TR_9_10_lv_c_i - 369.569838240406*v_TR_9_10_lv_c_r - 2.3406091994174*v_TR_9_10_mv_b_i - 0.390101533236234*v_TR_9_10_mv_b_r + 2.3406091994174*v_TR_9_10_mv_c_i + 0.390101533236234*v_TR_9_10_mv_c_r
        struct[0].g[149,0] = i_TR_9_10_lv_c_i - 41.8015456211378*v_INV_10_a_i + 21.6588319280506*v_INV_10_a_r - 41.8015456211378*v_INV_10_b_i + 21.6588319280506*v_INV_10_b_r + 146.305409673982*v_INV_10_c_i - 75.8059117481773*v_INV_10_c_r - 54.1373270807543*v_INV_9_a_i + 28.0504285392509*v_INV_9_a_r - 54.1373270807543*v_INV_9_b_i + 28.0504285392509*v_INV_9_b_r + 189.48064478264*v_INV_9_c_i - 98.1764998873781*v_INV_9_c_r + 95.9388727018921*v_TR_9_10_lv_a_i - 49.709361212942*v_TR_9_10_lv_a_r + 95.9388727018921*v_TR_9_10_lv_b_i - 49.7093612129419*v_TR_9_10_lv_b_r - 369.569838240406*v_TR_9_10_lv_c_i + 376.684862474157*v_TR_9_10_lv_c_r - 0.390101533236234*v_TR_9_10_mv_b_i + 2.3406091994174*v_TR_9_10_mv_b_r + 0.390101533236234*v_TR_9_10_mv_c_i - 2.3406091994174*v_TR_9_10_mv_c_r
        struct[0].g[150,0] = i_TR_11_12_mv_a_r + 2.3406091994174*v_TR_11_12_lv_a_i + 0.390101533236234*v_TR_11_12_lv_a_r - 2.3406091994174*v_TR_11_12_lv_b_i - 0.390101533236234*v_TR_11_12_lv_b_r - 8.91399122381347*v_TR_11_12_mv_a_i - 12.0494598870915*v_TR_11_12_mv_a_r + 2.55844947550343*v_TR_11_12_mv_b_i + 3.44463332681379*v_TR_11_12_mv_b_r + 2.55844947550343*v_TR_11_12_mv_c_i + 3.44463332681379*v_TR_11_12_mv_c_r + 8.85995441972108*v_TR_9_10_mv_a_i + 12.0404508780825*v_TR_9_10_mv_a_r - 2.53141554849174*v_TR_9_10_mv_b_i - 3.44012882230928*v_TR_9_10_mv_b_r - 2.53141554849173*v_TR_9_10_mv_c_i - 3.44012882230929*v_TR_9_10_mv_c_r
        struct[0].g[151,0] = i_TR_11_12_mv_a_i + 0.390101533236234*v_TR_11_12_lv_a_i - 2.3406091994174*v_TR_11_12_lv_a_r - 0.390101533236234*v_TR_11_12_lv_b_i + 2.3406091994174*v_TR_11_12_lv_b_r - 12.0494598870915*v_TR_11_12_mv_a_i + 8.91399122381347*v_TR_11_12_mv_a_r + 3.44463332681379*v_TR_11_12_mv_b_i - 2.55844947550343*v_TR_11_12_mv_b_r + 3.44463332681379*v_TR_11_12_mv_c_i - 2.55844947550343*v_TR_11_12_mv_c_r + 12.0404508780825*v_TR_9_10_mv_a_i - 8.85995441972108*v_TR_9_10_mv_a_r - 3.44012882230928*v_TR_9_10_mv_b_i + 2.53141554849174*v_TR_9_10_mv_b_r - 3.44012882230929*v_TR_9_10_mv_c_i + 2.53141554849173*v_TR_9_10_mv_c_r
        struct[0].g[152,0] = i_TR_11_12_mv_b_r + 2.3406091994174*v_TR_11_12_lv_b_i + 0.390101533236234*v_TR_11_12_lv_b_r - 2.3406091994174*v_TR_11_12_lv_c_i - 0.390101533236234*v_TR_11_12_lv_c_r + 2.55844947550343*v_TR_11_12_mv_a_i + 3.44463332681379*v_TR_11_12_mv_a_r - 8.91399122381347*v_TR_11_12_mv_b_i - 12.0494598870915*v_TR_11_12_mv_b_r + 2.55844947550343*v_TR_11_12_mv_c_i + 3.4446333268138*v_TR_11_12_mv_c_r - 2.53141554849173*v_TR_9_10_mv_a_i - 3.44012882230929*v_TR_9_10_mv_a_r + 8.85995441972108*v_TR_9_10_mv_b_i + 12.0404508780825*v_TR_9_10_mv_b_r - 2.53141554849174*v_TR_9_10_mv_c_i - 3.44012882230929*v_TR_9_10_mv_c_r
        struct[0].g[153,0] = i_TR_11_12_mv_b_i + 0.390101533236234*v_TR_11_12_lv_b_i - 2.3406091994174*v_TR_11_12_lv_b_r - 0.390101533236234*v_TR_11_12_lv_c_i + 2.3406091994174*v_TR_11_12_lv_c_r + 3.44463332681379*v_TR_11_12_mv_a_i - 2.55844947550343*v_TR_11_12_mv_a_r - 12.0494598870915*v_TR_11_12_mv_b_i + 8.91399122381347*v_TR_11_12_mv_b_r + 3.4446333268138*v_TR_11_12_mv_c_i - 2.55844947550343*v_TR_11_12_mv_c_r - 3.44012882230929*v_TR_9_10_mv_a_i + 2.53141554849173*v_TR_9_10_mv_a_r + 12.0404508780825*v_TR_9_10_mv_b_i - 8.85995441972108*v_TR_9_10_mv_b_r - 3.44012882230929*v_TR_9_10_mv_c_i + 2.53141554849174*v_TR_9_10_mv_c_r
        struct[0].g[154,0] = i_TR_11_12_mv_c_r - 2.3406091994174*v_TR_11_12_lv_a_i - 0.390101533236234*v_TR_11_12_lv_a_r + 2.3406091994174*v_TR_11_12_lv_c_i + 0.390101533236234*v_TR_11_12_lv_c_r + 2.55844947550343*v_TR_11_12_mv_a_i + 3.44463332681379*v_TR_11_12_mv_a_r + 2.55844947550343*v_TR_11_12_mv_b_i + 3.4446333268138*v_TR_11_12_mv_b_r - 8.91399122381347*v_TR_11_12_mv_c_i - 12.0494598870915*v_TR_11_12_mv_c_r - 2.53141554849174*v_TR_9_10_mv_a_i - 3.44012882230928*v_TR_9_10_mv_a_r - 2.53141554849174*v_TR_9_10_mv_b_i - 3.44012882230929*v_TR_9_10_mv_b_r + 8.85995441972108*v_TR_9_10_mv_c_i + 12.0404508780825*v_TR_9_10_mv_c_r
        struct[0].g[155,0] = i_TR_11_12_mv_c_i - 0.390101533236234*v_TR_11_12_lv_a_i + 2.3406091994174*v_TR_11_12_lv_a_r + 0.390101533236234*v_TR_11_12_lv_c_i - 2.3406091994174*v_TR_11_12_lv_c_r + 3.44463332681379*v_TR_11_12_mv_a_i - 2.55844947550343*v_TR_11_12_mv_a_r + 3.4446333268138*v_TR_11_12_mv_b_i - 2.55844947550343*v_TR_11_12_mv_b_r - 12.0494598870915*v_TR_11_12_mv_c_i + 8.91399122381347*v_TR_11_12_mv_c_r - 3.44012882230928*v_TR_9_10_mv_a_i + 2.53141554849174*v_TR_9_10_mv_a_r - 3.44012882230929*v_TR_9_10_mv_b_i + 2.53141554849174*v_TR_9_10_mv_b_r + 12.0404508780825*v_TR_9_10_mv_c_i - 8.85995441972108*v_TR_9_10_mv_c_r
        struct[0].g[156,0] = i_TR_11_12_lv_a_r + 81.5761620304113*v_INV_11_a_i + 157.441992718694*v_INV_11_a_r - 23.3074748658318*v_INV_11_b_i - 44.9834264910554*v_INV_11_b_r - 23.3074748658318*v_INV_11_c_i - 44.9834264910554*v_INV_11_c_r + 107.907268017809*v_INV_12_a_i + 208.26102727437*v_INV_12_a_r - 30.8306480050881*v_INV_12_b_i - 59.5031506498201*v_INV_12_b_r - 30.8306480050881*v_INV_12_c_i - 59.5031506498201*v_INV_12_c_r - 392.185900835935*v_TR_11_12_lv_a_i - 399.486803776848*v_TR_11_12_lv_a_r + 54.138215636915*v_TR_11_12_lv_b_i + 104.486577140876*v_TR_11_12_lv_b_r + 54.138215636915*v_TR_11_12_lv_c_i + 104.486577140876*v_TR_11_12_lv_c_r + 2.3406091994174*v_TR_11_12_mv_a_i + 0.390101533236234*v_TR_11_12_mv_a_r - 2.3406091994174*v_TR_11_12_mv_c_i - 0.390101533236234*v_TR_11_12_mv_c_r
        struct[0].g[157,0] = i_TR_11_12_lv_a_i + 157.441992718694*v_INV_11_a_i - 81.5761620304113*v_INV_11_a_r - 44.9834264910554*v_INV_11_b_i + 23.3074748658318*v_INV_11_b_r - 44.9834264910554*v_INV_11_c_i + 23.3074748658318*v_INV_11_c_r + 208.26102727437*v_INV_12_a_i - 107.907268017809*v_INV_12_a_r - 59.5031506498201*v_INV_12_b_i + 30.8306480050881*v_INV_12_b_r - 59.5031506498201*v_INV_12_c_i + 30.8306480050881*v_INV_12_c_r - 399.486803776848*v_TR_11_12_lv_a_i + 392.185900835935*v_TR_11_12_lv_a_r + 104.486577140876*v_TR_11_12_lv_b_i - 54.138215636915*v_TR_11_12_lv_b_r + 104.486577140876*v_TR_11_12_lv_c_i - 54.138215636915*v_TR_11_12_lv_c_r + 0.390101533236234*v_TR_11_12_mv_a_i - 2.3406091994174*v_TR_11_12_mv_a_r - 0.390101533236234*v_TR_11_12_mv_c_i + 2.3406091994174*v_TR_11_12_mv_c_r
        struct[0].g[158,0] = i_TR_11_12_lv_b_r - 23.3074748658318*v_INV_11_a_i - 44.9834264910554*v_INV_11_a_r + 81.5761620304112*v_INV_11_b_i + 157.441992718694*v_INV_11_b_r - 23.3074748658317*v_INV_11_c_i - 44.9834264910555*v_INV_11_c_r - 30.8306480050881*v_INV_12_a_i - 59.5031506498201*v_INV_12_a_r + 107.907268017808*v_INV_12_b_i + 208.261027274371*v_INV_12_b_r - 30.8306480050881*v_INV_12_c_i - 59.5031506498202*v_INV_12_c_r + 54.138215636915*v_TR_11_12_lv_a_i + 104.486577140876*v_TR_11_12_lv_a_r - 392.185900835935*v_TR_11_12_lv_b_i - 399.486803776848*v_TR_11_12_lv_b_r + 54.138215636915*v_TR_11_12_lv_c_i + 104.486577140876*v_TR_11_12_lv_c_r - 2.3406091994174*v_TR_11_12_mv_a_i - 0.390101533236234*v_TR_11_12_mv_a_r + 2.3406091994174*v_TR_11_12_mv_b_i + 0.390101533236234*v_TR_11_12_mv_b_r
        struct[0].g[159,0] = i_TR_11_12_lv_b_i - 44.9834264910554*v_INV_11_a_i + 23.3074748658318*v_INV_11_a_r + 157.441992718694*v_INV_11_b_i - 81.5761620304112*v_INV_11_b_r - 44.9834264910555*v_INV_11_c_i + 23.3074748658317*v_INV_11_c_r - 59.5031506498201*v_INV_12_a_i + 30.8306480050881*v_INV_12_a_r + 208.261027274371*v_INV_12_b_i - 107.907268017808*v_INV_12_b_r - 59.5031506498202*v_INV_12_c_i + 30.8306480050881*v_INV_12_c_r + 104.486577140876*v_TR_11_12_lv_a_i - 54.138215636915*v_TR_11_12_lv_a_r - 399.486803776848*v_TR_11_12_lv_b_i + 392.185900835935*v_TR_11_12_lv_b_r + 104.486577140876*v_TR_11_12_lv_c_i - 54.138215636915*v_TR_11_12_lv_c_r - 0.390101533236234*v_TR_11_12_mv_a_i + 2.3406091994174*v_TR_11_12_mv_a_r + 0.390101533236234*v_TR_11_12_mv_b_i - 2.3406091994174*v_TR_11_12_mv_b_r
        struct[0].g[160,0] = i_TR_11_12_lv_c_r - 23.3074748658318*v_INV_11_a_i - 44.9834264910554*v_INV_11_a_r - 23.3074748658317*v_INV_11_b_i - 44.9834264910554*v_INV_11_b_r + 81.5761620304112*v_INV_11_c_i + 157.441992718694*v_INV_11_c_r - 30.8306480050882*v_INV_12_a_i - 59.5031506498201*v_INV_12_a_r - 30.8306480050881*v_INV_12_b_i - 59.5031506498202*v_INV_12_b_r + 107.907268017808*v_INV_12_c_i + 208.261027274371*v_INV_12_c_r + 54.138215636915*v_TR_11_12_lv_a_i + 104.486577140876*v_TR_11_12_lv_a_r + 54.138215636915*v_TR_11_12_lv_b_i + 104.486577140876*v_TR_11_12_lv_b_r - 392.185900835935*v_TR_11_12_lv_c_i - 399.486803776848*v_TR_11_12_lv_c_r - 2.3406091994174*v_TR_11_12_mv_b_i - 0.390101533236234*v_TR_11_12_mv_b_r + 2.3406091994174*v_TR_11_12_mv_c_i + 0.390101533236234*v_TR_11_12_mv_c_r
        struct[0].g[161,0] = i_TR_11_12_lv_c_i - 44.9834264910554*v_INV_11_a_i + 23.3074748658318*v_INV_11_a_r - 44.9834264910554*v_INV_11_b_i + 23.3074748658317*v_INV_11_b_r + 157.441992718694*v_INV_11_c_i - 81.5761620304112*v_INV_11_c_r - 59.5031506498201*v_INV_12_a_i + 30.8306480050882*v_INV_12_a_r - 59.5031506498202*v_INV_12_b_i + 30.8306480050881*v_INV_12_b_r + 208.261027274371*v_INV_12_c_i - 107.907268017808*v_INV_12_c_r + 104.486577140876*v_TR_11_12_lv_a_i - 54.138215636915*v_TR_11_12_lv_a_r + 104.486577140876*v_TR_11_12_lv_b_i - 54.138215636915*v_TR_11_12_lv_b_r - 399.486803776848*v_TR_11_12_lv_c_i + 392.185900835935*v_TR_11_12_lv_c_r - 0.390101533236234*v_TR_11_12_mv_b_i + 2.3406091994174*v_TR_11_12_mv_b_r + 0.390101533236234*v_TR_11_12_mv_c_i - 2.3406091994174*v_TR_11_12_mv_c_r
        struct[0].g[162,0] = i_TR_13_mv_a_r + 1.1703045997087*v_TR_13_lv_a_i + 0.195050766618117*v_TR_13_lv_a_r - 1.1703045997087*v_TR_13_lv_b_i - 0.195050766618117*v_TR_13_lv_b_r - 6.62789031305749*v_TR_13_mv_a_i - 8.9749399223794*v_TR_13_mv_a_r + 1.89949032909103*v_TR_13_mv_b_i + 2.56523380021651*v_TR_13_mv_b_r + 1.89949032909103*v_TR_13_mv_c_i + 2.56523380021651*v_TR_13_mv_c_r + 6.60088643956832*v_TR_7_8_mv_a_i + 8.97043541787489*v_TR_7_8_mv_a_r - 1.88596755416238*v_TR_7_8_mv_b_i - 2.56298154796426*v_TR_7_8_mv_b_r - 1.88596755416237*v_TR_7_8_mv_c_i - 2.56298154796426*v_TR_7_8_mv_c_r
        struct[0].g[163,0] = i_TR_13_mv_a_i + 0.195050766618117*v_TR_13_lv_a_i - 1.1703045997087*v_TR_13_lv_a_r - 0.195050766618117*v_TR_13_lv_b_i + 1.1703045997087*v_TR_13_lv_b_r - 8.9749399223794*v_TR_13_mv_a_i + 6.62789031305749*v_TR_13_mv_a_r + 2.56523380021651*v_TR_13_mv_b_i - 1.89949032909103*v_TR_13_mv_b_r + 2.56523380021651*v_TR_13_mv_c_i - 1.89949032909103*v_TR_13_mv_c_r + 8.97043541787489*v_TR_7_8_mv_a_i - 6.60088643956832*v_TR_7_8_mv_a_r - 2.56298154796426*v_TR_7_8_mv_b_i + 1.88596755416238*v_TR_7_8_mv_b_r - 2.56298154796426*v_TR_7_8_mv_c_i + 1.88596755416237*v_TR_7_8_mv_c_r
        struct[0].g[164,0] = i_TR_13_mv_b_r + 1.1703045997087*v_TR_13_lv_b_i + 0.195050766618117*v_TR_13_lv_b_r - 1.1703045997087*v_TR_13_lv_c_i - 0.195050766618117*v_TR_13_lv_c_r + 1.89949032909103*v_TR_13_mv_a_i + 2.56523380021651*v_TR_13_mv_a_r - 6.62789031305749*v_TR_13_mv_b_i - 8.97493992237941*v_TR_13_mv_b_r + 1.89949032909103*v_TR_13_mv_c_i + 2.56523380021651*v_TR_13_mv_c_r - 1.88596755416238*v_TR_7_8_mv_a_i - 2.56298154796426*v_TR_7_8_mv_a_r + 6.60088643956832*v_TR_7_8_mv_b_i + 8.9704354178749*v_TR_7_8_mv_b_r - 1.88596755416237*v_TR_7_8_mv_c_i - 2.56298154796426*v_TR_7_8_mv_c_r
        struct[0].g[165,0] = i_TR_13_mv_b_i + 0.195050766618117*v_TR_13_lv_b_i - 1.1703045997087*v_TR_13_lv_b_r - 0.195050766618117*v_TR_13_lv_c_i + 1.1703045997087*v_TR_13_lv_c_r + 2.56523380021651*v_TR_13_mv_a_i - 1.89949032909103*v_TR_13_mv_a_r - 8.97493992237941*v_TR_13_mv_b_i + 6.62789031305749*v_TR_13_mv_b_r + 2.56523380021651*v_TR_13_mv_c_i - 1.89949032909103*v_TR_13_mv_c_r - 2.56298154796426*v_TR_7_8_mv_a_i + 1.88596755416238*v_TR_7_8_mv_a_r + 8.9704354178749*v_TR_7_8_mv_b_i - 6.60088643956832*v_TR_7_8_mv_b_r - 2.56298154796426*v_TR_7_8_mv_c_i + 1.88596755416237*v_TR_7_8_mv_c_r
        struct[0].g[166,0] = i_TR_13_mv_c_r - 1.1703045997087*v_TR_13_lv_a_i - 0.195050766618117*v_TR_13_lv_a_r + 1.1703045997087*v_TR_13_lv_c_i + 0.195050766618117*v_TR_13_lv_c_r + 1.89949032909103*v_TR_13_mv_a_i + 2.56523380021651*v_TR_13_mv_a_r + 1.89949032909103*v_TR_13_mv_b_i + 2.56523380021651*v_TR_13_mv_b_r - 6.62789031305748*v_TR_13_mv_c_i - 8.9749399223794*v_TR_13_mv_c_r - 1.88596755416237*v_TR_7_8_mv_a_i - 2.56298154796426*v_TR_7_8_mv_a_r - 1.88596755416237*v_TR_7_8_mv_b_i - 2.56298154796426*v_TR_7_8_mv_b_r + 6.60088643956831*v_TR_7_8_mv_c_i + 8.9704354178749*v_TR_7_8_mv_c_r
        struct[0].g[167,0] = i_TR_13_mv_c_i - 0.195050766618117*v_TR_13_lv_a_i + 1.1703045997087*v_TR_13_lv_a_r + 0.195050766618117*v_TR_13_lv_c_i - 1.1703045997087*v_TR_13_lv_c_r + 2.56523380021651*v_TR_13_mv_a_i - 1.89949032909103*v_TR_13_mv_a_r + 2.56523380021651*v_TR_13_mv_b_i - 1.89949032909103*v_TR_13_mv_b_r - 8.9749399223794*v_TR_13_mv_c_i + 6.62789031305748*v_TR_13_mv_c_r - 2.56298154796426*v_TR_7_8_mv_a_i + 1.88596755416237*v_TR_7_8_mv_a_r - 2.56298154796426*v_TR_7_8_mv_b_i + 1.88596755416237*v_TR_7_8_mv_b_r + 8.9704354178749*v_TR_7_8_mv_c_i - 6.60088643956831*v_TR_7_8_mv_c_r
        struct[0].g[168,0] = i_TR_13_lv_a_r + 225.774979236273*v_INV_13_a_i + 435.745709926008*v_INV_13_a_r - 64.5071369246495*v_INV_13_b_i - 124.498774264574*v_INV_13_b_r - 64.5071369246495*v_INV_13_c_i - 124.498774264574*v_INV_13_c_r - 327.126282868141*v_TR_13_lv_a_i - 452.6376018179*v_TR_13_lv_a_r + 64.5071560124429*v_TR_13_lv_b_i + 124.498774264574*v_TR_13_lv_b_r + 64.5071560124428*v_TR_13_lv_c_i + 124.498774264574*v_TR_13_lv_c_r + 1.1703045997087*v_TR_13_mv_a_i + 0.195050766618117*v_TR_13_mv_a_r - 1.1703045997087*v_TR_13_mv_c_i - 0.195050766618117*v_TR_13_mv_c_r
        struct[0].g[169,0] = i_TR_13_lv_a_i + 435.745709926008*v_INV_13_a_i - 225.774979236273*v_INV_13_a_r - 124.498774264574*v_INV_13_b_i + 64.5071369246495*v_INV_13_b_r - 124.498774264574*v_INV_13_c_i + 64.5071369246495*v_INV_13_c_r - 452.6376018179*v_TR_13_lv_a_i + 327.126282868141*v_TR_13_lv_a_r + 124.498774264574*v_TR_13_lv_b_i - 64.5071560124429*v_TR_13_lv_b_r + 124.498774264574*v_TR_13_lv_c_i - 64.5071560124428*v_TR_13_lv_c_r + 0.195050766618117*v_TR_13_mv_a_i - 1.1703045997087*v_TR_13_mv_a_r - 0.195050766618117*v_TR_13_mv_c_i + 1.1703045997087*v_TR_13_mv_c_r
        struct[0].g[170,0] = i_TR_13_lv_b_r - 64.5071369246495*v_INV_13_a_i - 124.498774264574*v_INV_13_a_r + 225.774979236273*v_INV_13_b_i + 435.745709926008*v_INV_13_b_r - 64.5071369246494*v_INV_13_c_i - 124.498774264574*v_INV_13_c_r + 64.5071560124428*v_TR_13_lv_a_i + 124.498774264574*v_TR_13_lv_a_r - 327.126282868141*v_TR_13_lv_b_i - 452.6376018179*v_TR_13_lv_b_r + 64.5071560124428*v_TR_13_lv_c_i + 124.498774264574*v_TR_13_lv_c_r - 1.1703045997087*v_TR_13_mv_a_i - 0.195050766618117*v_TR_13_mv_a_r + 1.1703045997087*v_TR_13_mv_b_i + 0.195050766618117*v_TR_13_mv_b_r
        struct[0].g[171,0] = i_TR_13_lv_b_i - 124.498774264574*v_INV_13_a_i + 64.5071369246495*v_INV_13_a_r + 435.745709926008*v_INV_13_b_i - 225.774979236273*v_INV_13_b_r - 124.498774264574*v_INV_13_c_i + 64.5071369246494*v_INV_13_c_r + 124.498774264574*v_TR_13_lv_a_i - 64.5071560124428*v_TR_13_lv_a_r - 452.6376018179*v_TR_13_lv_b_i + 327.126282868141*v_TR_13_lv_b_r + 124.498774264574*v_TR_13_lv_c_i - 64.5071560124428*v_TR_13_lv_c_r - 0.195050766618117*v_TR_13_mv_a_i + 1.1703045997087*v_TR_13_mv_a_r + 0.195050766618117*v_TR_13_mv_b_i - 1.1703045997087*v_TR_13_mv_b_r
        struct[0].g[172,0] = i_TR_13_lv_c_r - 64.5071369246495*v_INV_13_a_i - 124.498774264574*v_INV_13_a_r - 64.5071369246494*v_INV_13_b_i - 124.498774264574*v_INV_13_b_r + 225.774979236273*v_INV_13_c_i + 435.745709926008*v_INV_13_c_r + 64.5071560124429*v_TR_13_lv_a_i + 124.498774264574*v_TR_13_lv_a_r + 64.5071560124428*v_TR_13_lv_b_i + 124.498774264574*v_TR_13_lv_b_r - 327.126282868141*v_TR_13_lv_c_i - 452.6376018179*v_TR_13_lv_c_r - 1.1703045997087*v_TR_13_mv_b_i - 0.195050766618117*v_TR_13_mv_b_r + 1.1703045997087*v_TR_13_mv_c_i + 0.195050766618117*v_TR_13_mv_c_r
        struct[0].g[173,0] = i_TR_13_lv_c_i - 124.498774264574*v_INV_13_a_i + 64.5071369246495*v_INV_13_a_r - 124.498774264574*v_INV_13_b_i + 64.5071369246494*v_INV_13_b_r + 435.745709926008*v_INV_13_c_i - 225.774979236273*v_INV_13_c_r + 124.498774264574*v_TR_13_lv_a_i - 64.5071560124429*v_TR_13_lv_a_r + 124.498774264574*v_TR_13_lv_b_i - 64.5071560124428*v_TR_13_lv_b_r - 452.6376018179*v_TR_13_lv_c_i + 327.126282868141*v_TR_13_lv_c_r - 0.195050766618117*v_TR_13_mv_b_i + 1.1703045997087*v_TR_13_mv_b_r + 0.195050766618117*v_TR_13_mv_c_i - 1.1703045997087*v_TR_13_mv_c_r
        struct[0].g[174,0] = i_INV_1_a_i*v_INV_1_a_i + i_INV_1_a_r*v_INV_1_a_r - p_INV_1_a
        struct[0].g[175,0] = i_INV_1_b_i*v_INV_1_b_i + i_INV_1_b_r*v_INV_1_b_r - p_INV_1_b
        struct[0].g[176,0] = i_INV_1_c_i*v_INV_1_c_i + i_INV_1_c_r*v_INV_1_c_r - p_INV_1_c
        struct[0].g[177,0] = -i_INV_1_a_i*v_INV_1_a_r + i_INV_1_a_r*v_INV_1_a_i - q_INV_1_a
        struct[0].g[178,0] = -i_INV_1_b_i*v_INV_1_b_r + i_INV_1_b_r*v_INV_1_b_i - q_INV_1_b
        struct[0].g[179,0] = -i_INV_1_c_i*v_INV_1_c_r + i_INV_1_c_r*v_INV_1_c_i - q_INV_1_c
        struct[0].g[180,0] = -v_m_INV_1 + (v_INV_1_a_i**2 + v_INV_1_a_r**2)**0.5/V_base_INV_1
        struct[0].g[181,0] = -v_m_TR_1_2_mv + (v_TR_1_2_mv_a_i**2 + v_TR_1_2_mv_a_r**2)**0.5/V_base_TR_1_2_mv
        struct[0].g[182,0] = Dq_r_INV_1 + K_p_v_INV_1*(Dv_r_INV_1 - u_ctrl_v_INV_1*v_m_TR_1_2_mv + v_loc_ref_INV_1 - v_m_INV_1*(1.0 - u_ctrl_v_INV_1)) - i_reac_ref_INV_1
        struct[0].g[183,0] = S_base_INV_1*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_1, I_max_INV_1 < -i_reac_ref_INV_1), (I_max_INV_1, I_max_INV_1 < i_reac_ref_INV_1), (i_reac_ref_INV_1, True)])) - q_ref_INV_1
        struct[0].g[184,0] = i_INV_2_a_i*v_INV_2_a_i + i_INV_2_a_r*v_INV_2_a_r - p_INV_2_a
        struct[0].g[185,0] = i_INV_2_b_i*v_INV_2_b_i + i_INV_2_b_r*v_INV_2_b_r - p_INV_2_b
        struct[0].g[186,0] = i_INV_2_c_i*v_INV_2_c_i + i_INV_2_c_r*v_INV_2_c_r - p_INV_2_c
        struct[0].g[187,0] = -i_INV_2_a_i*v_INV_2_a_r + i_INV_2_a_r*v_INV_2_a_i - q_INV_2_a
        struct[0].g[188,0] = -i_INV_2_b_i*v_INV_2_b_r + i_INV_2_b_r*v_INV_2_b_i - q_INV_2_b
        struct[0].g[189,0] = -i_INV_2_c_i*v_INV_2_c_r + i_INV_2_c_r*v_INV_2_c_i - q_INV_2_c
        struct[0].g[190,0] = -v_m_INV_2 + (v_INV_2_a_i**2 + v_INV_2_a_r**2)**0.5/V_base_INV_2
        struct[0].g[191,0] = Dq_r_INV_2 + K_p_v_INV_2*(Dv_r_INV_2 - u_ctrl_v_INV_2*v_m_TR_1_2_mv + v_loc_ref_INV_2 - v_m_INV_2*(1.0 - u_ctrl_v_INV_2)) - i_reac_ref_INV_2
        struct[0].g[192,0] = S_base_INV_2*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_2, I_max_INV_2 < -i_reac_ref_INV_2), (I_max_INV_2, I_max_INV_2 < i_reac_ref_INV_2), (i_reac_ref_INV_2, True)])) - q_ref_INV_2
        struct[0].g[193,0] = i_INV_3_a_i*v_INV_3_a_i + i_INV_3_a_r*v_INV_3_a_r - p_INV_3_a
        struct[0].g[194,0] = i_INV_3_b_i*v_INV_3_b_i + i_INV_3_b_r*v_INV_3_b_r - p_INV_3_b
        struct[0].g[195,0] = i_INV_3_c_i*v_INV_3_c_i + i_INV_3_c_r*v_INV_3_c_r - p_INV_3_c
        struct[0].g[196,0] = -i_INV_3_a_i*v_INV_3_a_r + i_INV_3_a_r*v_INV_3_a_i - q_INV_3_a
        struct[0].g[197,0] = -i_INV_3_b_i*v_INV_3_b_r + i_INV_3_b_r*v_INV_3_b_i - q_INV_3_b
        struct[0].g[198,0] = -i_INV_3_c_i*v_INV_3_c_r + i_INV_3_c_r*v_INV_3_c_i - q_INV_3_c
        struct[0].g[199,0] = -v_m_INV_3 + (v_INV_3_a_i**2 + v_INV_3_a_r**2)**0.5/V_base_INV_3
        struct[0].g[200,0] = -v_m_TR_3_4_mv + (v_TR_3_4_mv_a_i**2 + v_TR_3_4_mv_a_r**2)**0.5/V_base_TR_3_4_mv
        struct[0].g[201,0] = Dq_r_INV_3 + K_p_v_INV_3*(Dv_r_INV_3 - u_ctrl_v_INV_3*v_m_TR_3_4_mv + v_loc_ref_INV_3 - v_m_INV_3*(1.0 - u_ctrl_v_INV_3)) - i_reac_ref_INV_3
        struct[0].g[202,0] = S_base_INV_3*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_3, I_max_INV_3 < -i_reac_ref_INV_3), (I_max_INV_3, I_max_INV_3 < i_reac_ref_INV_3), (i_reac_ref_INV_3, True)])) - q_ref_INV_3
        struct[0].g[203,0] = i_INV_4_a_i*v_INV_4_a_i + i_INV_4_a_r*v_INV_4_a_r - p_INV_4_a
        struct[0].g[204,0] = i_INV_4_b_i*v_INV_4_b_i + i_INV_4_b_r*v_INV_4_b_r - p_INV_4_b
        struct[0].g[205,0] = i_INV_4_c_i*v_INV_4_c_i + i_INV_4_c_r*v_INV_4_c_r - p_INV_4_c
        struct[0].g[206,0] = -i_INV_4_a_i*v_INV_4_a_r + i_INV_4_a_r*v_INV_4_a_i - q_INV_4_a
        struct[0].g[207,0] = -i_INV_4_b_i*v_INV_4_b_r + i_INV_4_b_r*v_INV_4_b_i - q_INV_4_b
        struct[0].g[208,0] = -i_INV_4_c_i*v_INV_4_c_r + i_INV_4_c_r*v_INV_4_c_i - q_INV_4_c
        struct[0].g[209,0] = -v_m_INV_4 + (v_INV_4_a_i**2 + v_INV_4_a_r**2)**0.5/V_base_INV_4
        struct[0].g[210,0] = Dq_r_INV_4 + K_p_v_INV_4*(Dv_r_INV_4 - u_ctrl_v_INV_4*v_m_TR_3_4_mv + v_loc_ref_INV_4 - v_m_INV_4*(1.0 - u_ctrl_v_INV_4)) - i_reac_ref_INV_4
        struct[0].g[211,0] = S_base_INV_4*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_4, I_max_INV_4 < -i_reac_ref_INV_4), (I_max_INV_4, I_max_INV_4 < i_reac_ref_INV_4), (i_reac_ref_INV_4, True)])) - q_ref_INV_4
        struct[0].g[212,0] = i_INV_5_a_i*v_INV_5_a_i + i_INV_5_a_r*v_INV_5_a_r - p_INV_5_a
        struct[0].g[213,0] = i_INV_5_b_i*v_INV_5_b_i + i_INV_5_b_r*v_INV_5_b_r - p_INV_5_b
        struct[0].g[214,0] = i_INV_5_c_i*v_INV_5_c_i + i_INV_5_c_r*v_INV_5_c_r - p_INV_5_c
        struct[0].g[215,0] = -i_INV_5_a_i*v_INV_5_a_r + i_INV_5_a_r*v_INV_5_a_i - q_INV_5_a
        struct[0].g[216,0] = -i_INV_5_b_i*v_INV_5_b_r + i_INV_5_b_r*v_INV_5_b_i - q_INV_5_b
        struct[0].g[217,0] = -i_INV_5_c_i*v_INV_5_c_r + i_INV_5_c_r*v_INV_5_c_i - q_INV_5_c
        struct[0].g[218,0] = -v_m_INV_5 + (v_INV_5_a_i**2 + v_INV_5_a_r**2)**0.5/V_base_INV_5
        struct[0].g[219,0] = -v_m_TR_5_6_mv + (v_TR_5_6_mv_a_i**2 + v_TR_5_6_mv_a_r**2)**0.5/V_base_TR_5_6_mv
        struct[0].g[220,0] = Dq_r_INV_5 + K_p_v_INV_5*(Dv_r_INV_5 - u_ctrl_v_INV_5*v_m_TR_5_6_mv + v_loc_ref_INV_5 - v_m_INV_5*(1.0 - u_ctrl_v_INV_5)) - i_reac_ref_INV_5
        struct[0].g[221,0] = S_base_INV_5*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_5, I_max_INV_5 < -i_reac_ref_INV_5), (I_max_INV_5, I_max_INV_5 < i_reac_ref_INV_5), (i_reac_ref_INV_5, True)])) - q_ref_INV_5
        struct[0].g[222,0] = i_INV_6_a_i*v_INV_6_a_i + i_INV_6_a_r*v_INV_6_a_r - p_INV_6_a
        struct[0].g[223,0] = i_INV_6_b_i*v_INV_6_b_i + i_INV_6_b_r*v_INV_6_b_r - p_INV_6_b
        struct[0].g[224,0] = i_INV_6_c_i*v_INV_6_c_i + i_INV_6_c_r*v_INV_6_c_r - p_INV_6_c
        struct[0].g[225,0] = -i_INV_6_a_i*v_INV_6_a_r + i_INV_6_a_r*v_INV_6_a_i - q_INV_6_a
        struct[0].g[226,0] = -i_INV_6_b_i*v_INV_6_b_r + i_INV_6_b_r*v_INV_6_b_i - q_INV_6_b
        struct[0].g[227,0] = -i_INV_6_c_i*v_INV_6_c_r + i_INV_6_c_r*v_INV_6_c_i - q_INV_6_c
        struct[0].g[228,0] = -v_m_INV_6 + (v_INV_6_a_i**2 + v_INV_6_a_r**2)**0.5/V_base_INV_6
        struct[0].g[229,0] = Dq_r_INV_6 + K_p_v_INV_6*(Dv_r_INV_6 - u_ctrl_v_INV_6*v_m_TR_5_6_mv + v_loc_ref_INV_6 - v_m_INV_6*(1.0 - u_ctrl_v_INV_6)) - i_reac_ref_INV_6
        struct[0].g[230,0] = S_base_INV_6*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_6, I_max_INV_6 < -i_reac_ref_INV_6), (I_max_INV_6, I_max_INV_6 < i_reac_ref_INV_6), (i_reac_ref_INV_6, True)])) - q_ref_INV_6
        struct[0].g[231,0] = i_INV_7_a_i*v_INV_7_a_i + i_INV_7_a_r*v_INV_7_a_r - p_INV_7_a
        struct[0].g[232,0] = i_INV_7_b_i*v_INV_7_b_i + i_INV_7_b_r*v_INV_7_b_r - p_INV_7_b
        struct[0].g[233,0] = i_INV_7_c_i*v_INV_7_c_i + i_INV_7_c_r*v_INV_7_c_r - p_INV_7_c
        struct[0].g[234,0] = -i_INV_7_a_i*v_INV_7_a_r + i_INV_7_a_r*v_INV_7_a_i - q_INV_7_a
        struct[0].g[235,0] = -i_INV_7_b_i*v_INV_7_b_r + i_INV_7_b_r*v_INV_7_b_i - q_INV_7_b
        struct[0].g[236,0] = -i_INV_7_c_i*v_INV_7_c_r + i_INV_7_c_r*v_INV_7_c_i - q_INV_7_c
        struct[0].g[237,0] = -v_m_INV_7 + (v_INV_7_a_i**2 + v_INV_7_a_r**2)**0.5/V_base_INV_7
        struct[0].g[238,0] = -v_m_TR_7_8_mv + (v_TR_7_8_mv_a_i**2 + v_TR_7_8_mv_a_r**2)**0.5/V_base_TR_7_8_mv
        struct[0].g[239,0] = Dq_r_INV_7 + K_p_v_INV_7*(Dv_r_INV_7 - u_ctrl_v_INV_7*v_m_TR_7_8_mv + v_loc_ref_INV_7 - v_m_INV_7*(1.0 - u_ctrl_v_INV_7)) - i_reac_ref_INV_7
        struct[0].g[240,0] = S_base_INV_7*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_7, I_max_INV_7 < -i_reac_ref_INV_7), (I_max_INV_7, I_max_INV_7 < i_reac_ref_INV_7), (i_reac_ref_INV_7, True)])) - q_ref_INV_7
        struct[0].g[241,0] = i_INV_8_a_i*v_INV_8_a_i + i_INV_8_a_r*v_INV_8_a_r - p_INV_8_a
        struct[0].g[242,0] = i_INV_8_b_i*v_INV_8_b_i + i_INV_8_b_r*v_INV_8_b_r - p_INV_8_b
        struct[0].g[243,0] = i_INV_8_c_i*v_INV_8_c_i + i_INV_8_c_r*v_INV_8_c_r - p_INV_8_c
        struct[0].g[244,0] = -i_INV_8_a_i*v_INV_8_a_r + i_INV_8_a_r*v_INV_8_a_i - q_INV_8_a
        struct[0].g[245,0] = -i_INV_8_b_i*v_INV_8_b_r + i_INV_8_b_r*v_INV_8_b_i - q_INV_8_b
        struct[0].g[246,0] = -i_INV_8_c_i*v_INV_8_c_r + i_INV_8_c_r*v_INV_8_c_i - q_INV_8_c
        struct[0].g[247,0] = -v_m_INV_8 + (v_INV_8_a_i**2 + v_INV_8_a_r**2)**0.5/V_base_INV_8
        struct[0].g[248,0] = Dq_r_INV_8 + K_p_v_INV_8*(Dv_r_INV_8 - u_ctrl_v_INV_8*v_m_TR_7_8_mv + v_loc_ref_INV_8 - v_m_INV_8*(1.0 - u_ctrl_v_INV_8)) - i_reac_ref_INV_8
        struct[0].g[249,0] = S_base_INV_8*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_8, I_max_INV_8 < -i_reac_ref_INV_8), (I_max_INV_8, I_max_INV_8 < i_reac_ref_INV_8), (i_reac_ref_INV_8, True)])) - q_ref_INV_8
        struct[0].g[250,0] = i_INV_9_a_i*v_INV_9_a_i + i_INV_9_a_r*v_INV_9_a_r - p_INV_9_a
        struct[0].g[251,0] = i_INV_9_b_i*v_INV_9_b_i + i_INV_9_b_r*v_INV_9_b_r - p_INV_9_b
        struct[0].g[252,0] = i_INV_9_c_i*v_INV_9_c_i + i_INV_9_c_r*v_INV_9_c_r - p_INV_9_c
        struct[0].g[253,0] = -i_INV_9_a_i*v_INV_9_a_r + i_INV_9_a_r*v_INV_9_a_i - q_INV_9_a
        struct[0].g[254,0] = -i_INV_9_b_i*v_INV_9_b_r + i_INV_9_b_r*v_INV_9_b_i - q_INV_9_b
        struct[0].g[255,0] = -i_INV_9_c_i*v_INV_9_c_r + i_INV_9_c_r*v_INV_9_c_i - q_INV_9_c
        struct[0].g[256,0] = -v_m_INV_9 + (v_INV_9_a_i**2 + v_INV_9_a_r**2)**0.5/V_base_INV_9
        struct[0].g[257,0] = -v_m_TR_9_10_mv + (v_TR_9_10_mv_a_i**2 + v_TR_9_10_mv_a_r**2)**0.5/V_base_TR_9_10_mv
        struct[0].g[258,0] = Dq_r_INV_9 + K_p_v_INV_9*(Dv_r_INV_9 - u_ctrl_v_INV_9*v_m_TR_9_10_mv + v_loc_ref_INV_9 - v_m_INV_9*(1.0 - u_ctrl_v_INV_9)) - i_reac_ref_INV_9
        struct[0].g[259,0] = S_base_INV_9*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_9, I_max_INV_9 < -i_reac_ref_INV_9), (I_max_INV_9, I_max_INV_9 < i_reac_ref_INV_9), (i_reac_ref_INV_9, True)])) - q_ref_INV_9
        struct[0].g[260,0] = i_INV_10_a_i*v_INV_10_a_i + i_INV_10_a_r*v_INV_10_a_r - p_INV_10_a
        struct[0].g[261,0] = i_INV_10_b_i*v_INV_10_b_i + i_INV_10_b_r*v_INV_10_b_r - p_INV_10_b
        struct[0].g[262,0] = i_INV_10_c_i*v_INV_10_c_i + i_INV_10_c_r*v_INV_10_c_r - p_INV_10_c
        struct[0].g[263,0] = -i_INV_10_a_i*v_INV_10_a_r + i_INV_10_a_r*v_INV_10_a_i - q_INV_10_a
        struct[0].g[264,0] = -i_INV_10_b_i*v_INV_10_b_r + i_INV_10_b_r*v_INV_10_b_i - q_INV_10_b
        struct[0].g[265,0] = -i_INV_10_c_i*v_INV_10_c_r + i_INV_10_c_r*v_INV_10_c_i - q_INV_10_c
        struct[0].g[266,0] = -v_m_INV_10 + (v_INV_10_a_i**2 + v_INV_10_a_r**2)**0.5/V_base_INV_10
        struct[0].g[267,0] = Dq_r_INV_10 + K_p_v_INV_10*(Dv_r_INV_10 - u_ctrl_v_INV_10*v_m_TR_9_10_mv + v_loc_ref_INV_10 - v_m_INV_10*(1.0 - u_ctrl_v_INV_10)) - i_reac_ref_INV_10
        struct[0].g[268,0] = S_base_INV_10*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_10, I_max_INV_10 < -i_reac_ref_INV_10), (I_max_INV_10, I_max_INV_10 < i_reac_ref_INV_10), (i_reac_ref_INV_10, True)])) - q_ref_INV_10
        struct[0].g[269,0] = i_INV_11_a_i*v_INV_11_a_i + i_INV_11_a_r*v_INV_11_a_r - p_INV_11_a
        struct[0].g[270,0] = i_INV_11_b_i*v_INV_11_b_i + i_INV_11_b_r*v_INV_11_b_r - p_INV_11_b
        struct[0].g[271,0] = i_INV_11_c_i*v_INV_11_c_i + i_INV_11_c_r*v_INV_11_c_r - p_INV_11_c
        struct[0].g[272,0] = -i_INV_11_a_i*v_INV_11_a_r + i_INV_11_a_r*v_INV_11_a_i - q_INV_11_a
        struct[0].g[273,0] = -i_INV_11_b_i*v_INV_11_b_r + i_INV_11_b_r*v_INV_11_b_i - q_INV_11_b
        struct[0].g[274,0] = -i_INV_11_c_i*v_INV_11_c_r + i_INV_11_c_r*v_INV_11_c_i - q_INV_11_c
        struct[0].g[275,0] = -v_m_INV_11 + (v_INV_11_a_i**2 + v_INV_11_a_r**2)**0.5/V_base_INV_11
        struct[0].g[276,0] = -v_m_TR_11_12_mv + (v_TR_11_12_mv_a_i**2 + v_TR_11_12_mv_a_r**2)**0.5/V_base_TR_11_12_mv
        struct[0].g[277,0] = Dq_r_INV_11 + K_p_v_INV_11*(Dv_r_INV_11 - u_ctrl_v_INV_11*v_m_TR_11_12_mv + v_loc_ref_INV_11 - v_m_INV_11*(1.0 - u_ctrl_v_INV_11)) - i_reac_ref_INV_11
        struct[0].g[278,0] = S_base_INV_11*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_11, I_max_INV_11 < -i_reac_ref_INV_11), (I_max_INV_11, I_max_INV_11 < i_reac_ref_INV_11), (i_reac_ref_INV_11, True)])) - q_ref_INV_11
        struct[0].g[279,0] = i_INV_12_a_i*v_INV_12_a_i + i_INV_12_a_r*v_INV_12_a_r - p_INV_12_a
        struct[0].g[280,0] = i_INV_12_b_i*v_INV_12_b_i + i_INV_12_b_r*v_INV_12_b_r - p_INV_12_b
        struct[0].g[281,0] = i_INV_12_c_i*v_INV_12_c_i + i_INV_12_c_r*v_INV_12_c_r - p_INV_12_c
        struct[0].g[282,0] = -i_INV_12_a_i*v_INV_12_a_r + i_INV_12_a_r*v_INV_12_a_i - q_INV_12_a
        struct[0].g[283,0] = -i_INV_12_b_i*v_INV_12_b_r + i_INV_12_b_r*v_INV_12_b_i - q_INV_12_b
        struct[0].g[284,0] = -i_INV_12_c_i*v_INV_12_c_r + i_INV_12_c_r*v_INV_12_c_i - q_INV_12_c
        struct[0].g[285,0] = -v_m_INV_12 + (v_INV_12_a_i**2 + v_INV_12_a_r**2)**0.5/V_base_INV_12
        struct[0].g[286,0] = Dq_r_INV_12 + K_p_v_INV_12*(Dv_r_INV_12 - u_ctrl_v_INV_12*v_m_TR_11_12_mv + v_loc_ref_INV_12 - v_m_INV_12*(1.0 - u_ctrl_v_INV_12)) - i_reac_ref_INV_12
        struct[0].g[287,0] = S_base_INV_12*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_12, I_max_INV_12 < -i_reac_ref_INV_12), (I_max_INV_12, I_max_INV_12 < i_reac_ref_INV_12), (i_reac_ref_INV_12, True)])) - q_ref_INV_12
        struct[0].g[288,0] = i_INV_13_a_i*v_INV_13_a_i + i_INV_13_a_r*v_INV_13_a_r - p_INV_13_a
        struct[0].g[289,0] = i_INV_13_b_i*v_INV_13_b_i + i_INV_13_b_r*v_INV_13_b_r - p_INV_13_b
        struct[0].g[290,0] = i_INV_13_c_i*v_INV_13_c_i + i_INV_13_c_r*v_INV_13_c_r - p_INV_13_c
        struct[0].g[291,0] = -i_INV_13_a_i*v_INV_13_a_r + i_INV_13_a_r*v_INV_13_a_i - q_INV_13_a
        struct[0].g[292,0] = -i_INV_13_b_i*v_INV_13_b_r + i_INV_13_b_r*v_INV_13_b_i - q_INV_13_b
        struct[0].g[293,0] = -i_INV_13_c_i*v_INV_13_c_r + i_INV_13_c_r*v_INV_13_c_i - q_INV_13_c
        struct[0].g[294,0] = -v_m_INV_13 + (v_INV_13_a_i**2 + v_INV_13_a_r**2)**0.5/V_base_INV_13
        struct[0].g[295,0] = -v_m_TR_13_mv + (v_TR_13_mv_a_i**2 + v_TR_13_mv_a_r**2)**0.5/V_base_TR_13_mv
        struct[0].g[296,0] = Dq_r_INV_13 + K_p_v_INV_13*(Dv_r_INV_13 - u_ctrl_v_INV_13*v_m_TR_13_mv + v_loc_ref_INV_13 - v_m_INV_13*(1.0 - u_ctrl_v_INV_13)) - i_reac_ref_INV_13
        struct[0].g[297,0] = S_base_INV_13*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_13, I_max_INV_13 < -i_reac_ref_INV_13), (I_max_INV_13, I_max_INV_13 < i_reac_ref_INV_13), (i_reac_ref_INV_13, True)])) - q_ref_INV_13
    
    # Outputs:
    if mode == 3:

    
        pass

    if mode == 10:

        struct[0].Fx_ini[0,0] = -1/T_pq_INV_1
        struct[0].Fx_ini[1,1] = -1/T_pq_INV_1
        struct[0].Fx_ini[2,2] = -1/T_pq_INV_1
        struct[0].Fx_ini[3,3] = -1/T_pq_INV_1
        struct[0].Fx_ini[4,4] = -1/T_pq_INV_1
        struct[0].Fx_ini[5,5] = -1/T_pq_INV_1
        struct[0].Fx_ini[6,6] = -1/T_pq_INV_2
        struct[0].Fx_ini[7,7] = -1/T_pq_INV_2
        struct[0].Fx_ini[8,8] = -1/T_pq_INV_2
        struct[0].Fx_ini[9,9] = -1/T_pq_INV_2
        struct[0].Fx_ini[10,10] = -1/T_pq_INV_2
        struct[0].Fx_ini[11,11] = -1/T_pq_INV_2
        struct[0].Fx_ini[12,12] = -1/T_pq_INV_3
        struct[0].Fx_ini[13,13] = -1/T_pq_INV_3
        struct[0].Fx_ini[14,14] = -1/T_pq_INV_3
        struct[0].Fx_ini[15,15] = -1/T_pq_INV_3
        struct[0].Fx_ini[16,16] = -1/T_pq_INV_3
        struct[0].Fx_ini[17,17] = -1/T_pq_INV_3
        struct[0].Fx_ini[18,18] = -1/T_pq_INV_4
        struct[0].Fx_ini[19,19] = -1/T_pq_INV_4
        struct[0].Fx_ini[20,20] = -1/T_pq_INV_4
        struct[0].Fx_ini[21,21] = -1/T_pq_INV_4
        struct[0].Fx_ini[22,22] = -1/T_pq_INV_4
        struct[0].Fx_ini[23,23] = -1/T_pq_INV_4
        struct[0].Fx_ini[24,24] = -1/T_pq_INV_5
        struct[0].Fx_ini[25,25] = -1/T_pq_INV_5
        struct[0].Fx_ini[26,26] = -1/T_pq_INV_5
        struct[0].Fx_ini[27,27] = -1/T_pq_INV_5
        struct[0].Fx_ini[28,28] = -1/T_pq_INV_5
        struct[0].Fx_ini[29,29] = -1/T_pq_INV_5
        struct[0].Fx_ini[30,30] = -1/T_pq_INV_6
        struct[0].Fx_ini[31,31] = -1/T_pq_INV_6
        struct[0].Fx_ini[32,32] = -1/T_pq_INV_6
        struct[0].Fx_ini[33,33] = -1/T_pq_INV_6
        struct[0].Fx_ini[34,34] = -1/T_pq_INV_6
        struct[0].Fx_ini[35,35] = -1/T_pq_INV_6
        struct[0].Fx_ini[36,36] = -1/T_pq_INV_7
        struct[0].Fx_ini[37,37] = -1/T_pq_INV_7
        struct[0].Fx_ini[38,38] = -1/T_pq_INV_7
        struct[0].Fx_ini[39,39] = -1/T_pq_INV_7
        struct[0].Fx_ini[40,40] = -1/T_pq_INV_7
        struct[0].Fx_ini[41,41] = -1/T_pq_INV_7
        struct[0].Fx_ini[42,42] = -1/T_pq_INV_8
        struct[0].Fx_ini[43,43] = -1/T_pq_INV_8
        struct[0].Fx_ini[44,44] = -1/T_pq_INV_8
        struct[0].Fx_ini[45,45] = -1/T_pq_INV_8
        struct[0].Fx_ini[46,46] = -1/T_pq_INV_8
        struct[0].Fx_ini[47,47] = -1/T_pq_INV_8
        struct[0].Fx_ini[48,48] = -1/T_pq_INV_9
        struct[0].Fx_ini[49,49] = -1/T_pq_INV_9
        struct[0].Fx_ini[50,50] = -1/T_pq_INV_9
        struct[0].Fx_ini[51,51] = -1/T_pq_INV_9
        struct[0].Fx_ini[52,52] = -1/T_pq_INV_9
        struct[0].Fx_ini[53,53] = -1/T_pq_INV_9
        struct[0].Fx_ini[54,54] = -1/T_pq_INV_10
        struct[0].Fx_ini[55,55] = -1/T_pq_INV_10
        struct[0].Fx_ini[56,56] = -1/T_pq_INV_10
        struct[0].Fx_ini[57,57] = -1/T_pq_INV_10
        struct[0].Fx_ini[58,58] = -1/T_pq_INV_10
        struct[0].Fx_ini[59,59] = -1/T_pq_INV_10
        struct[0].Fx_ini[60,60] = -1/T_pq_INV_11
        struct[0].Fx_ini[61,61] = -1/T_pq_INV_11
        struct[0].Fx_ini[62,62] = -1/T_pq_INV_11
        struct[0].Fx_ini[63,63] = -1/T_pq_INV_11
        struct[0].Fx_ini[64,64] = -1/T_pq_INV_11
        struct[0].Fx_ini[65,65] = -1/T_pq_INV_11
        struct[0].Fx_ini[66,66] = -1/T_pq_INV_12
        struct[0].Fx_ini[67,67] = -1/T_pq_INV_12
        struct[0].Fx_ini[68,68] = -1/T_pq_INV_12
        struct[0].Fx_ini[69,69] = -1/T_pq_INV_12
        struct[0].Fx_ini[70,70] = -1/T_pq_INV_12
        struct[0].Fx_ini[71,71] = -1/T_pq_INV_12
        struct[0].Fx_ini[72,72] = -1/T_pq_INV_13
        struct[0].Fx_ini[73,73] = -1/T_pq_INV_13
        struct[0].Fx_ini[74,74] = -1/T_pq_INV_13
        struct[0].Fx_ini[75,75] = -1/T_pq_INV_13
        struct[0].Fx_ini[76,76] = -1/T_pq_INV_13
        struct[0].Fx_ini[77,77] = -1/T_pq_INV_13

    if mode == 11:

        struct[0].Fy_ini[3,183] = 1/(3*T_pq_INV_1) 
        struct[0].Fy_ini[4,183] = 1/(3*T_pq_INV_1) 
        struct[0].Fy_ini[5,183] = 1/(3*T_pq_INV_1) 
        struct[0].Fy_ini[9,192] = 1/(3*T_pq_INV_2) 
        struct[0].Fy_ini[10,192] = 1/(3*T_pq_INV_2) 
        struct[0].Fy_ini[11,192] = 1/(3*T_pq_INV_2) 
        struct[0].Fy_ini[15,202] = 1/(3*T_pq_INV_3) 
        struct[0].Fy_ini[16,202] = 1/(3*T_pq_INV_3) 
        struct[0].Fy_ini[17,202] = 1/(3*T_pq_INV_3) 
        struct[0].Fy_ini[21,211] = 1/(3*T_pq_INV_4) 
        struct[0].Fy_ini[22,211] = 1/(3*T_pq_INV_4) 
        struct[0].Fy_ini[23,211] = 1/(3*T_pq_INV_4) 
        struct[0].Fy_ini[27,221] = 1/(3*T_pq_INV_5) 
        struct[0].Fy_ini[28,221] = 1/(3*T_pq_INV_5) 
        struct[0].Fy_ini[29,221] = 1/(3*T_pq_INV_5) 
        struct[0].Fy_ini[33,230] = 1/(3*T_pq_INV_6) 
        struct[0].Fy_ini[34,230] = 1/(3*T_pq_INV_6) 
        struct[0].Fy_ini[35,230] = 1/(3*T_pq_INV_6) 
        struct[0].Fy_ini[39,240] = 1/(3*T_pq_INV_7) 
        struct[0].Fy_ini[40,240] = 1/(3*T_pq_INV_7) 
        struct[0].Fy_ini[41,240] = 1/(3*T_pq_INV_7) 
        struct[0].Fy_ini[45,249] = 1/(3*T_pq_INV_8) 
        struct[0].Fy_ini[46,249] = 1/(3*T_pq_INV_8) 
        struct[0].Fy_ini[47,249] = 1/(3*T_pq_INV_8) 
        struct[0].Fy_ini[51,259] = 1/(3*T_pq_INV_9) 
        struct[0].Fy_ini[52,259] = 1/(3*T_pq_INV_9) 
        struct[0].Fy_ini[53,259] = 1/(3*T_pq_INV_9) 
        struct[0].Fy_ini[57,268] = 1/(3*T_pq_INV_10) 
        struct[0].Fy_ini[58,268] = 1/(3*T_pq_INV_10) 
        struct[0].Fy_ini[59,268] = 1/(3*T_pq_INV_10) 
        struct[0].Fy_ini[63,278] = 1/(3*T_pq_INV_11) 
        struct[0].Fy_ini[64,278] = 1/(3*T_pq_INV_11) 
        struct[0].Fy_ini[65,278] = 1/(3*T_pq_INV_11) 
        struct[0].Fy_ini[69,287] = 1/(3*T_pq_INV_12) 
        struct[0].Fy_ini[70,287] = 1/(3*T_pq_INV_12) 
        struct[0].Fy_ini[71,287] = 1/(3*T_pq_INV_12) 
        struct[0].Fy_ini[75,297] = 1/(3*T_pq_INV_13) 
        struct[0].Fy_ini[76,297] = 1/(3*T_pq_INV_13) 
        struct[0].Fy_ini[77,297] = 1/(3*T_pq_INV_13) 

        struct[0].Gx_ini[174,0] = -1
        struct[0].Gx_ini[175,1] = -1
        struct[0].Gx_ini[176,2] = -1
        struct[0].Gx_ini[177,3] = -1
        struct[0].Gx_ini[178,4] = -1
        struct[0].Gx_ini[179,5] = -1
        struct[0].Gx_ini[184,6] = -1
        struct[0].Gx_ini[185,7] = -1
        struct[0].Gx_ini[186,8] = -1
        struct[0].Gx_ini[187,9] = -1
        struct[0].Gx_ini[188,10] = -1
        struct[0].Gx_ini[189,11] = -1
        struct[0].Gx_ini[193,12] = -1
        struct[0].Gx_ini[194,13] = -1
        struct[0].Gx_ini[195,14] = -1
        struct[0].Gx_ini[196,15] = -1
        struct[0].Gx_ini[197,16] = -1
        struct[0].Gx_ini[198,17] = -1
        struct[0].Gx_ini[203,18] = -1
        struct[0].Gx_ini[204,19] = -1
        struct[0].Gx_ini[205,20] = -1
        struct[0].Gx_ini[206,21] = -1
        struct[0].Gx_ini[207,22] = -1
        struct[0].Gx_ini[208,23] = -1
        struct[0].Gx_ini[212,24] = -1
        struct[0].Gx_ini[213,25] = -1
        struct[0].Gx_ini[214,26] = -1
        struct[0].Gx_ini[215,27] = -1
        struct[0].Gx_ini[216,28] = -1
        struct[0].Gx_ini[217,29] = -1
        struct[0].Gx_ini[222,30] = -1
        struct[0].Gx_ini[223,31] = -1
        struct[0].Gx_ini[224,32] = -1
        struct[0].Gx_ini[225,33] = -1
        struct[0].Gx_ini[226,34] = -1
        struct[0].Gx_ini[227,35] = -1
        struct[0].Gx_ini[231,36] = -1
        struct[0].Gx_ini[232,37] = -1
        struct[0].Gx_ini[233,38] = -1
        struct[0].Gx_ini[234,39] = -1
        struct[0].Gx_ini[235,40] = -1
        struct[0].Gx_ini[236,41] = -1
        struct[0].Gx_ini[241,42] = -1
        struct[0].Gx_ini[242,43] = -1
        struct[0].Gx_ini[243,44] = -1
        struct[0].Gx_ini[244,45] = -1
        struct[0].Gx_ini[245,46] = -1
        struct[0].Gx_ini[246,47] = -1
        struct[0].Gx_ini[250,48] = -1
        struct[0].Gx_ini[251,49] = -1
        struct[0].Gx_ini[252,50] = -1
        struct[0].Gx_ini[253,51] = -1
        struct[0].Gx_ini[254,52] = -1
        struct[0].Gx_ini[255,53] = -1
        struct[0].Gx_ini[260,54] = -1
        struct[0].Gx_ini[261,55] = -1
        struct[0].Gx_ini[262,56] = -1
        struct[0].Gx_ini[263,57] = -1
        struct[0].Gx_ini[264,58] = -1
        struct[0].Gx_ini[265,59] = -1
        struct[0].Gx_ini[269,60] = -1
        struct[0].Gx_ini[270,61] = -1
        struct[0].Gx_ini[271,62] = -1
        struct[0].Gx_ini[272,63] = -1
        struct[0].Gx_ini[273,64] = -1
        struct[0].Gx_ini[274,65] = -1
        struct[0].Gx_ini[279,66] = -1
        struct[0].Gx_ini[280,67] = -1
        struct[0].Gx_ini[281,68] = -1
        struct[0].Gx_ini[282,69] = -1
        struct[0].Gx_ini[283,70] = -1
        struct[0].Gx_ini[284,71] = -1
        struct[0].Gx_ini[288,72] = -1
        struct[0].Gx_ini[289,73] = -1
        struct[0].Gx_ini[290,74] = -1
        struct[0].Gx_ini[291,75] = -1
        struct[0].Gx_ini[292,76] = -1
        struct[0].Gx_ini[293,77] = -1

        struct[0].Gy_ini[174,0] = i_INV_1_a_r
        struct[0].Gy_ini[174,1] = i_INV_1_a_i
        struct[0].Gy_ini[174,174] = v_INV_1_a_r
        struct[0].Gy_ini[174,175] = v_INV_1_a_i
        struct[0].Gy_ini[175,2] = i_INV_1_b_r
        struct[0].Gy_ini[175,3] = i_INV_1_b_i
        struct[0].Gy_ini[175,176] = v_INV_1_b_r
        struct[0].Gy_ini[175,177] = v_INV_1_b_i
        struct[0].Gy_ini[176,4] = i_INV_1_c_r
        struct[0].Gy_ini[176,5] = i_INV_1_c_i
        struct[0].Gy_ini[176,178] = v_INV_1_c_r
        struct[0].Gy_ini[176,179] = v_INV_1_c_i
        struct[0].Gy_ini[177,0] = -i_INV_1_a_i
        struct[0].Gy_ini[177,1] = i_INV_1_a_r
        struct[0].Gy_ini[177,174] = v_INV_1_a_i
        struct[0].Gy_ini[177,175] = -v_INV_1_a_r
        struct[0].Gy_ini[178,2] = -i_INV_1_b_i
        struct[0].Gy_ini[178,3] = i_INV_1_b_r
        struct[0].Gy_ini[178,176] = v_INV_1_b_i
        struct[0].Gy_ini[178,177] = -v_INV_1_b_r
        struct[0].Gy_ini[179,4] = -i_INV_1_c_i
        struct[0].Gy_ini[179,5] = i_INV_1_c_r
        struct[0].Gy_ini[179,178] = v_INV_1_c_i
        struct[0].Gy_ini[179,179] = -v_INV_1_c_r
        struct[0].Gy_ini[180,0] = 1.0*v_INV_1_a_r*(v_INV_1_a_i**2 + v_INV_1_a_r**2)**(-0.5)/V_base_INV_1
        struct[0].Gy_ini[180,1] = 1.0*v_INV_1_a_i*(v_INV_1_a_i**2 + v_INV_1_a_r**2)**(-0.5)/V_base_INV_1
        struct[0].Gy_ini[181,90] = 1.0*v_TR_1_2_mv_a_r*(v_TR_1_2_mv_a_i**2 + v_TR_1_2_mv_a_r**2)**(-0.5)/V_base_TR_1_2_mv
        struct[0].Gy_ini[181,91] = 1.0*v_TR_1_2_mv_a_i*(v_TR_1_2_mv_a_i**2 + v_TR_1_2_mv_a_r**2)**(-0.5)/V_base_TR_1_2_mv
        struct[0].Gy_ini[182,180] = K_p_v_INV_1*(u_ctrl_v_INV_1 - 1.0)
        struct[0].Gy_ini[182,181] = -K_p_v_INV_1*u_ctrl_v_INV_1
        struct[0].Gy_ini[183,172] = 1.0*S_base_INV_1*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_1, I_max_INV_1 < -i_reac_ref_INV_1), (I_max_INV_1, I_max_INV_1 < i_reac_ref_INV_1), (i_reac_ref_INV_1, True)]))
        struct[0].Gy_ini[183,173] = 1.0*S_base_INV_1*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_1, I_max_INV_1 < -i_reac_ref_INV_1), (I_max_INV_1, I_max_INV_1 < i_reac_ref_INV_1), (i_reac_ref_INV_1, True)]))
        struct[0].Gy_ini[183,182] = S_base_INV_1*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_1 < i_reac_ref_INV_1) | (I_max_INV_1 < -i_reac_ref_INV_1)), (1, True)]))
        struct[0].Gy_ini[184,6] = i_INV_2_a_r
        struct[0].Gy_ini[184,7] = i_INV_2_a_i
        struct[0].Gy_ini[184,184] = v_INV_2_a_r
        struct[0].Gy_ini[184,185] = v_INV_2_a_i
        struct[0].Gy_ini[185,8] = i_INV_2_b_r
        struct[0].Gy_ini[185,9] = i_INV_2_b_i
        struct[0].Gy_ini[185,186] = v_INV_2_b_r
        struct[0].Gy_ini[185,187] = v_INV_2_b_i
        struct[0].Gy_ini[186,10] = i_INV_2_c_r
        struct[0].Gy_ini[186,11] = i_INV_2_c_i
        struct[0].Gy_ini[186,188] = v_INV_2_c_r
        struct[0].Gy_ini[186,189] = v_INV_2_c_i
        struct[0].Gy_ini[187,6] = -i_INV_2_a_i
        struct[0].Gy_ini[187,7] = i_INV_2_a_r
        struct[0].Gy_ini[187,184] = v_INV_2_a_i
        struct[0].Gy_ini[187,185] = -v_INV_2_a_r
        struct[0].Gy_ini[188,8] = -i_INV_2_b_i
        struct[0].Gy_ini[188,9] = i_INV_2_b_r
        struct[0].Gy_ini[188,186] = v_INV_2_b_i
        struct[0].Gy_ini[188,187] = -v_INV_2_b_r
        struct[0].Gy_ini[189,10] = -i_INV_2_c_i
        struct[0].Gy_ini[189,11] = i_INV_2_c_r
        struct[0].Gy_ini[189,188] = v_INV_2_c_i
        struct[0].Gy_ini[189,189] = -v_INV_2_c_r
        struct[0].Gy_ini[190,6] = 1.0*v_INV_2_a_r*(v_INV_2_a_i**2 + v_INV_2_a_r**2)**(-0.5)/V_base_INV_2
        struct[0].Gy_ini[190,7] = 1.0*v_INV_2_a_i*(v_INV_2_a_i**2 + v_INV_2_a_r**2)**(-0.5)/V_base_INV_2
        struct[0].Gy_ini[191,181] = -K_p_v_INV_2*u_ctrl_v_INV_2
        struct[0].Gy_ini[191,190] = K_p_v_INV_2*(u_ctrl_v_INV_2 - 1.0)
        struct[0].Gy_ini[192,172] = 1.0*S_base_INV_2*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_2, I_max_INV_2 < -i_reac_ref_INV_2), (I_max_INV_2, I_max_INV_2 < i_reac_ref_INV_2), (i_reac_ref_INV_2, True)]))
        struct[0].Gy_ini[192,173] = 1.0*S_base_INV_2*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_2, I_max_INV_2 < -i_reac_ref_INV_2), (I_max_INV_2, I_max_INV_2 < i_reac_ref_INV_2), (i_reac_ref_INV_2, True)]))
        struct[0].Gy_ini[192,191] = S_base_INV_2*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_2 < i_reac_ref_INV_2) | (I_max_INV_2 < -i_reac_ref_INV_2)), (1, True)]))
        struct[0].Gy_ini[193,12] = i_INV_3_a_r
        struct[0].Gy_ini[193,13] = i_INV_3_a_i
        struct[0].Gy_ini[193,193] = v_INV_3_a_r
        struct[0].Gy_ini[193,194] = v_INV_3_a_i
        struct[0].Gy_ini[194,14] = i_INV_3_b_r
        struct[0].Gy_ini[194,15] = i_INV_3_b_i
        struct[0].Gy_ini[194,195] = v_INV_3_b_r
        struct[0].Gy_ini[194,196] = v_INV_3_b_i
        struct[0].Gy_ini[195,16] = i_INV_3_c_r
        struct[0].Gy_ini[195,17] = i_INV_3_c_i
        struct[0].Gy_ini[195,197] = v_INV_3_c_r
        struct[0].Gy_ini[195,198] = v_INV_3_c_i
        struct[0].Gy_ini[196,12] = -i_INV_3_a_i
        struct[0].Gy_ini[196,13] = i_INV_3_a_r
        struct[0].Gy_ini[196,193] = v_INV_3_a_i
        struct[0].Gy_ini[196,194] = -v_INV_3_a_r
        struct[0].Gy_ini[197,14] = -i_INV_3_b_i
        struct[0].Gy_ini[197,15] = i_INV_3_b_r
        struct[0].Gy_ini[197,195] = v_INV_3_b_i
        struct[0].Gy_ini[197,196] = -v_INV_3_b_r
        struct[0].Gy_ini[198,16] = -i_INV_3_c_i
        struct[0].Gy_ini[198,17] = i_INV_3_c_r
        struct[0].Gy_ini[198,197] = v_INV_3_c_i
        struct[0].Gy_ini[198,198] = -v_INV_3_c_r
        struct[0].Gy_ini[199,12] = 1.0*v_INV_3_a_r*(v_INV_3_a_i**2 + v_INV_3_a_r**2)**(-0.5)/V_base_INV_3
        struct[0].Gy_ini[199,13] = 1.0*v_INV_3_a_i*(v_INV_3_a_i**2 + v_INV_3_a_r**2)**(-0.5)/V_base_INV_3
        struct[0].Gy_ini[200,102] = 1.0*v_TR_3_4_mv_a_r*(v_TR_3_4_mv_a_i**2 + v_TR_3_4_mv_a_r**2)**(-0.5)/V_base_TR_3_4_mv
        struct[0].Gy_ini[200,103] = 1.0*v_TR_3_4_mv_a_i*(v_TR_3_4_mv_a_i**2 + v_TR_3_4_mv_a_r**2)**(-0.5)/V_base_TR_3_4_mv
        struct[0].Gy_ini[201,199] = K_p_v_INV_3*(u_ctrl_v_INV_3 - 1.0)
        struct[0].Gy_ini[201,200] = -K_p_v_INV_3*u_ctrl_v_INV_3
        struct[0].Gy_ini[202,172] = 1.0*S_base_INV_3*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_3, I_max_INV_3 < -i_reac_ref_INV_3), (I_max_INV_3, I_max_INV_3 < i_reac_ref_INV_3), (i_reac_ref_INV_3, True)]))
        struct[0].Gy_ini[202,173] = 1.0*S_base_INV_3*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_3, I_max_INV_3 < -i_reac_ref_INV_3), (I_max_INV_3, I_max_INV_3 < i_reac_ref_INV_3), (i_reac_ref_INV_3, True)]))
        struct[0].Gy_ini[202,201] = S_base_INV_3*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_3 < i_reac_ref_INV_3) | (I_max_INV_3 < -i_reac_ref_INV_3)), (1, True)]))
        struct[0].Gy_ini[203,18] = i_INV_4_a_r
        struct[0].Gy_ini[203,19] = i_INV_4_a_i
        struct[0].Gy_ini[203,203] = v_INV_4_a_r
        struct[0].Gy_ini[203,204] = v_INV_4_a_i
        struct[0].Gy_ini[204,20] = i_INV_4_b_r
        struct[0].Gy_ini[204,21] = i_INV_4_b_i
        struct[0].Gy_ini[204,205] = v_INV_4_b_r
        struct[0].Gy_ini[204,206] = v_INV_4_b_i
        struct[0].Gy_ini[205,22] = i_INV_4_c_r
        struct[0].Gy_ini[205,23] = i_INV_4_c_i
        struct[0].Gy_ini[205,207] = v_INV_4_c_r
        struct[0].Gy_ini[205,208] = v_INV_4_c_i
        struct[0].Gy_ini[206,18] = -i_INV_4_a_i
        struct[0].Gy_ini[206,19] = i_INV_4_a_r
        struct[0].Gy_ini[206,203] = v_INV_4_a_i
        struct[0].Gy_ini[206,204] = -v_INV_4_a_r
        struct[0].Gy_ini[207,20] = -i_INV_4_b_i
        struct[0].Gy_ini[207,21] = i_INV_4_b_r
        struct[0].Gy_ini[207,205] = v_INV_4_b_i
        struct[0].Gy_ini[207,206] = -v_INV_4_b_r
        struct[0].Gy_ini[208,22] = -i_INV_4_c_i
        struct[0].Gy_ini[208,23] = i_INV_4_c_r
        struct[0].Gy_ini[208,207] = v_INV_4_c_i
        struct[0].Gy_ini[208,208] = -v_INV_4_c_r
        struct[0].Gy_ini[209,18] = 1.0*v_INV_4_a_r*(v_INV_4_a_i**2 + v_INV_4_a_r**2)**(-0.5)/V_base_INV_4
        struct[0].Gy_ini[209,19] = 1.0*v_INV_4_a_i*(v_INV_4_a_i**2 + v_INV_4_a_r**2)**(-0.5)/V_base_INV_4
        struct[0].Gy_ini[210,200] = -K_p_v_INV_4*u_ctrl_v_INV_4
        struct[0].Gy_ini[210,209] = K_p_v_INV_4*(u_ctrl_v_INV_4 - 1.0)
        struct[0].Gy_ini[211,172] = 1.0*S_base_INV_4*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_4, I_max_INV_4 < -i_reac_ref_INV_4), (I_max_INV_4, I_max_INV_4 < i_reac_ref_INV_4), (i_reac_ref_INV_4, True)]))
        struct[0].Gy_ini[211,173] = 1.0*S_base_INV_4*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_4, I_max_INV_4 < -i_reac_ref_INV_4), (I_max_INV_4, I_max_INV_4 < i_reac_ref_INV_4), (i_reac_ref_INV_4, True)]))
        struct[0].Gy_ini[211,210] = S_base_INV_4*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_4 < i_reac_ref_INV_4) | (I_max_INV_4 < -i_reac_ref_INV_4)), (1, True)]))
        struct[0].Gy_ini[212,24] = i_INV_5_a_r
        struct[0].Gy_ini[212,25] = i_INV_5_a_i
        struct[0].Gy_ini[212,212] = v_INV_5_a_r
        struct[0].Gy_ini[212,213] = v_INV_5_a_i
        struct[0].Gy_ini[213,26] = i_INV_5_b_r
        struct[0].Gy_ini[213,27] = i_INV_5_b_i
        struct[0].Gy_ini[213,214] = v_INV_5_b_r
        struct[0].Gy_ini[213,215] = v_INV_5_b_i
        struct[0].Gy_ini[214,28] = i_INV_5_c_r
        struct[0].Gy_ini[214,29] = i_INV_5_c_i
        struct[0].Gy_ini[214,216] = v_INV_5_c_r
        struct[0].Gy_ini[214,217] = v_INV_5_c_i
        struct[0].Gy_ini[215,24] = -i_INV_5_a_i
        struct[0].Gy_ini[215,25] = i_INV_5_a_r
        struct[0].Gy_ini[215,212] = v_INV_5_a_i
        struct[0].Gy_ini[215,213] = -v_INV_5_a_r
        struct[0].Gy_ini[216,26] = -i_INV_5_b_i
        struct[0].Gy_ini[216,27] = i_INV_5_b_r
        struct[0].Gy_ini[216,214] = v_INV_5_b_i
        struct[0].Gy_ini[216,215] = -v_INV_5_b_r
        struct[0].Gy_ini[217,28] = -i_INV_5_c_i
        struct[0].Gy_ini[217,29] = i_INV_5_c_r
        struct[0].Gy_ini[217,216] = v_INV_5_c_i
        struct[0].Gy_ini[217,217] = -v_INV_5_c_r
        struct[0].Gy_ini[218,24] = 1.0*v_INV_5_a_r*(v_INV_5_a_i**2 + v_INV_5_a_r**2)**(-0.5)/V_base_INV_5
        struct[0].Gy_ini[218,25] = 1.0*v_INV_5_a_i*(v_INV_5_a_i**2 + v_INV_5_a_r**2)**(-0.5)/V_base_INV_5
        struct[0].Gy_ini[219,114] = 1.0*v_TR_5_6_mv_a_r*(v_TR_5_6_mv_a_i**2 + v_TR_5_6_mv_a_r**2)**(-0.5)/V_base_TR_5_6_mv
        struct[0].Gy_ini[219,115] = 1.0*v_TR_5_6_mv_a_i*(v_TR_5_6_mv_a_i**2 + v_TR_5_6_mv_a_r**2)**(-0.5)/V_base_TR_5_6_mv
        struct[0].Gy_ini[220,218] = K_p_v_INV_5*(u_ctrl_v_INV_5 - 1.0)
        struct[0].Gy_ini[220,219] = -K_p_v_INV_5*u_ctrl_v_INV_5
        struct[0].Gy_ini[221,172] = 1.0*S_base_INV_5*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_5, I_max_INV_5 < -i_reac_ref_INV_5), (I_max_INV_5, I_max_INV_5 < i_reac_ref_INV_5), (i_reac_ref_INV_5, True)]))
        struct[0].Gy_ini[221,173] = 1.0*S_base_INV_5*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_5, I_max_INV_5 < -i_reac_ref_INV_5), (I_max_INV_5, I_max_INV_5 < i_reac_ref_INV_5), (i_reac_ref_INV_5, True)]))
        struct[0].Gy_ini[221,220] = S_base_INV_5*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_5 < i_reac_ref_INV_5) | (I_max_INV_5 < -i_reac_ref_INV_5)), (1, True)]))
        struct[0].Gy_ini[222,30] = i_INV_6_a_r
        struct[0].Gy_ini[222,31] = i_INV_6_a_i
        struct[0].Gy_ini[222,222] = v_INV_6_a_r
        struct[0].Gy_ini[222,223] = v_INV_6_a_i
        struct[0].Gy_ini[223,32] = i_INV_6_b_r
        struct[0].Gy_ini[223,33] = i_INV_6_b_i
        struct[0].Gy_ini[223,224] = v_INV_6_b_r
        struct[0].Gy_ini[223,225] = v_INV_6_b_i
        struct[0].Gy_ini[224,34] = i_INV_6_c_r
        struct[0].Gy_ini[224,35] = i_INV_6_c_i
        struct[0].Gy_ini[224,226] = v_INV_6_c_r
        struct[0].Gy_ini[224,227] = v_INV_6_c_i
        struct[0].Gy_ini[225,30] = -i_INV_6_a_i
        struct[0].Gy_ini[225,31] = i_INV_6_a_r
        struct[0].Gy_ini[225,222] = v_INV_6_a_i
        struct[0].Gy_ini[225,223] = -v_INV_6_a_r
        struct[0].Gy_ini[226,32] = -i_INV_6_b_i
        struct[0].Gy_ini[226,33] = i_INV_6_b_r
        struct[0].Gy_ini[226,224] = v_INV_6_b_i
        struct[0].Gy_ini[226,225] = -v_INV_6_b_r
        struct[0].Gy_ini[227,34] = -i_INV_6_c_i
        struct[0].Gy_ini[227,35] = i_INV_6_c_r
        struct[0].Gy_ini[227,226] = v_INV_6_c_i
        struct[0].Gy_ini[227,227] = -v_INV_6_c_r
        struct[0].Gy_ini[228,30] = 1.0*v_INV_6_a_r*(v_INV_6_a_i**2 + v_INV_6_a_r**2)**(-0.5)/V_base_INV_6
        struct[0].Gy_ini[228,31] = 1.0*v_INV_6_a_i*(v_INV_6_a_i**2 + v_INV_6_a_r**2)**(-0.5)/V_base_INV_6
        struct[0].Gy_ini[229,219] = -K_p_v_INV_6*u_ctrl_v_INV_6
        struct[0].Gy_ini[229,228] = K_p_v_INV_6*(u_ctrl_v_INV_6 - 1.0)
        struct[0].Gy_ini[230,172] = 1.0*S_base_INV_6*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_6, I_max_INV_6 < -i_reac_ref_INV_6), (I_max_INV_6, I_max_INV_6 < i_reac_ref_INV_6), (i_reac_ref_INV_6, True)]))
        struct[0].Gy_ini[230,173] = 1.0*S_base_INV_6*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_6, I_max_INV_6 < -i_reac_ref_INV_6), (I_max_INV_6, I_max_INV_6 < i_reac_ref_INV_6), (i_reac_ref_INV_6, True)]))
        struct[0].Gy_ini[230,229] = S_base_INV_6*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_6 < i_reac_ref_INV_6) | (I_max_INV_6 < -i_reac_ref_INV_6)), (1, True)]))
        struct[0].Gy_ini[231,36] = i_INV_7_a_r
        struct[0].Gy_ini[231,37] = i_INV_7_a_i
        struct[0].Gy_ini[231,231] = v_INV_7_a_r
        struct[0].Gy_ini[231,232] = v_INV_7_a_i
        struct[0].Gy_ini[232,38] = i_INV_7_b_r
        struct[0].Gy_ini[232,39] = i_INV_7_b_i
        struct[0].Gy_ini[232,233] = v_INV_7_b_r
        struct[0].Gy_ini[232,234] = v_INV_7_b_i
        struct[0].Gy_ini[233,40] = i_INV_7_c_r
        struct[0].Gy_ini[233,41] = i_INV_7_c_i
        struct[0].Gy_ini[233,235] = v_INV_7_c_r
        struct[0].Gy_ini[233,236] = v_INV_7_c_i
        struct[0].Gy_ini[234,36] = -i_INV_7_a_i
        struct[0].Gy_ini[234,37] = i_INV_7_a_r
        struct[0].Gy_ini[234,231] = v_INV_7_a_i
        struct[0].Gy_ini[234,232] = -v_INV_7_a_r
        struct[0].Gy_ini[235,38] = -i_INV_7_b_i
        struct[0].Gy_ini[235,39] = i_INV_7_b_r
        struct[0].Gy_ini[235,233] = v_INV_7_b_i
        struct[0].Gy_ini[235,234] = -v_INV_7_b_r
        struct[0].Gy_ini[236,40] = -i_INV_7_c_i
        struct[0].Gy_ini[236,41] = i_INV_7_c_r
        struct[0].Gy_ini[236,235] = v_INV_7_c_i
        struct[0].Gy_ini[236,236] = -v_INV_7_c_r
        struct[0].Gy_ini[237,36] = 1.0*v_INV_7_a_r*(v_INV_7_a_i**2 + v_INV_7_a_r**2)**(-0.5)/V_base_INV_7
        struct[0].Gy_ini[237,37] = 1.0*v_INV_7_a_i*(v_INV_7_a_i**2 + v_INV_7_a_r**2)**(-0.5)/V_base_INV_7
        struct[0].Gy_ini[238,126] = 1.0*v_TR_7_8_mv_a_r*(v_TR_7_8_mv_a_i**2 + v_TR_7_8_mv_a_r**2)**(-0.5)/V_base_TR_7_8_mv
        struct[0].Gy_ini[238,127] = 1.0*v_TR_7_8_mv_a_i*(v_TR_7_8_mv_a_i**2 + v_TR_7_8_mv_a_r**2)**(-0.5)/V_base_TR_7_8_mv
        struct[0].Gy_ini[239,237] = K_p_v_INV_7*(u_ctrl_v_INV_7 - 1.0)
        struct[0].Gy_ini[239,238] = -K_p_v_INV_7*u_ctrl_v_INV_7
        struct[0].Gy_ini[240,172] = 1.0*S_base_INV_7*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_7, I_max_INV_7 < -i_reac_ref_INV_7), (I_max_INV_7, I_max_INV_7 < i_reac_ref_INV_7), (i_reac_ref_INV_7, True)]))
        struct[0].Gy_ini[240,173] = 1.0*S_base_INV_7*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_7, I_max_INV_7 < -i_reac_ref_INV_7), (I_max_INV_7, I_max_INV_7 < i_reac_ref_INV_7), (i_reac_ref_INV_7, True)]))
        struct[0].Gy_ini[240,239] = S_base_INV_7*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_7 < i_reac_ref_INV_7) | (I_max_INV_7 < -i_reac_ref_INV_7)), (1, True)]))
        struct[0].Gy_ini[241,42] = i_INV_8_a_r
        struct[0].Gy_ini[241,43] = i_INV_8_a_i
        struct[0].Gy_ini[241,241] = v_INV_8_a_r
        struct[0].Gy_ini[241,242] = v_INV_8_a_i
        struct[0].Gy_ini[242,44] = i_INV_8_b_r
        struct[0].Gy_ini[242,45] = i_INV_8_b_i
        struct[0].Gy_ini[242,243] = v_INV_8_b_r
        struct[0].Gy_ini[242,244] = v_INV_8_b_i
        struct[0].Gy_ini[243,46] = i_INV_8_c_r
        struct[0].Gy_ini[243,47] = i_INV_8_c_i
        struct[0].Gy_ini[243,245] = v_INV_8_c_r
        struct[0].Gy_ini[243,246] = v_INV_8_c_i
        struct[0].Gy_ini[244,42] = -i_INV_8_a_i
        struct[0].Gy_ini[244,43] = i_INV_8_a_r
        struct[0].Gy_ini[244,241] = v_INV_8_a_i
        struct[0].Gy_ini[244,242] = -v_INV_8_a_r
        struct[0].Gy_ini[245,44] = -i_INV_8_b_i
        struct[0].Gy_ini[245,45] = i_INV_8_b_r
        struct[0].Gy_ini[245,243] = v_INV_8_b_i
        struct[0].Gy_ini[245,244] = -v_INV_8_b_r
        struct[0].Gy_ini[246,46] = -i_INV_8_c_i
        struct[0].Gy_ini[246,47] = i_INV_8_c_r
        struct[0].Gy_ini[246,245] = v_INV_8_c_i
        struct[0].Gy_ini[246,246] = -v_INV_8_c_r
        struct[0].Gy_ini[247,42] = 1.0*v_INV_8_a_r*(v_INV_8_a_i**2 + v_INV_8_a_r**2)**(-0.5)/V_base_INV_8
        struct[0].Gy_ini[247,43] = 1.0*v_INV_8_a_i*(v_INV_8_a_i**2 + v_INV_8_a_r**2)**(-0.5)/V_base_INV_8
        struct[0].Gy_ini[248,238] = -K_p_v_INV_8*u_ctrl_v_INV_8
        struct[0].Gy_ini[248,247] = K_p_v_INV_8*(u_ctrl_v_INV_8 - 1.0)
        struct[0].Gy_ini[249,172] = 1.0*S_base_INV_8*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_8, I_max_INV_8 < -i_reac_ref_INV_8), (I_max_INV_8, I_max_INV_8 < i_reac_ref_INV_8), (i_reac_ref_INV_8, True)]))
        struct[0].Gy_ini[249,173] = 1.0*S_base_INV_8*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_8, I_max_INV_8 < -i_reac_ref_INV_8), (I_max_INV_8, I_max_INV_8 < i_reac_ref_INV_8), (i_reac_ref_INV_8, True)]))
        struct[0].Gy_ini[249,248] = S_base_INV_8*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_8 < i_reac_ref_INV_8) | (I_max_INV_8 < -i_reac_ref_INV_8)), (1, True)]))
        struct[0].Gy_ini[250,48] = i_INV_9_a_r
        struct[0].Gy_ini[250,49] = i_INV_9_a_i
        struct[0].Gy_ini[250,250] = v_INV_9_a_r
        struct[0].Gy_ini[250,251] = v_INV_9_a_i
        struct[0].Gy_ini[251,50] = i_INV_9_b_r
        struct[0].Gy_ini[251,51] = i_INV_9_b_i
        struct[0].Gy_ini[251,252] = v_INV_9_b_r
        struct[0].Gy_ini[251,253] = v_INV_9_b_i
        struct[0].Gy_ini[252,52] = i_INV_9_c_r
        struct[0].Gy_ini[252,53] = i_INV_9_c_i
        struct[0].Gy_ini[252,254] = v_INV_9_c_r
        struct[0].Gy_ini[252,255] = v_INV_9_c_i
        struct[0].Gy_ini[253,48] = -i_INV_9_a_i
        struct[0].Gy_ini[253,49] = i_INV_9_a_r
        struct[0].Gy_ini[253,250] = v_INV_9_a_i
        struct[0].Gy_ini[253,251] = -v_INV_9_a_r
        struct[0].Gy_ini[254,50] = -i_INV_9_b_i
        struct[0].Gy_ini[254,51] = i_INV_9_b_r
        struct[0].Gy_ini[254,252] = v_INV_9_b_i
        struct[0].Gy_ini[254,253] = -v_INV_9_b_r
        struct[0].Gy_ini[255,52] = -i_INV_9_c_i
        struct[0].Gy_ini[255,53] = i_INV_9_c_r
        struct[0].Gy_ini[255,254] = v_INV_9_c_i
        struct[0].Gy_ini[255,255] = -v_INV_9_c_r
        struct[0].Gy_ini[256,48] = 1.0*v_INV_9_a_r*(v_INV_9_a_i**2 + v_INV_9_a_r**2)**(-0.5)/V_base_INV_9
        struct[0].Gy_ini[256,49] = 1.0*v_INV_9_a_i*(v_INV_9_a_i**2 + v_INV_9_a_r**2)**(-0.5)/V_base_INV_9
        struct[0].Gy_ini[257,138] = 1.0*v_TR_9_10_mv_a_r*(v_TR_9_10_mv_a_i**2 + v_TR_9_10_mv_a_r**2)**(-0.5)/V_base_TR_9_10_mv
        struct[0].Gy_ini[257,139] = 1.0*v_TR_9_10_mv_a_i*(v_TR_9_10_mv_a_i**2 + v_TR_9_10_mv_a_r**2)**(-0.5)/V_base_TR_9_10_mv
        struct[0].Gy_ini[258,256] = K_p_v_INV_9*(u_ctrl_v_INV_9 - 1.0)
        struct[0].Gy_ini[258,257] = -K_p_v_INV_9*u_ctrl_v_INV_9
        struct[0].Gy_ini[259,172] = 1.0*S_base_INV_9*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_9, I_max_INV_9 < -i_reac_ref_INV_9), (I_max_INV_9, I_max_INV_9 < i_reac_ref_INV_9), (i_reac_ref_INV_9, True)]))
        struct[0].Gy_ini[259,173] = 1.0*S_base_INV_9*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_9, I_max_INV_9 < -i_reac_ref_INV_9), (I_max_INV_9, I_max_INV_9 < i_reac_ref_INV_9), (i_reac_ref_INV_9, True)]))
        struct[0].Gy_ini[259,258] = S_base_INV_9*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_9 < i_reac_ref_INV_9) | (I_max_INV_9 < -i_reac_ref_INV_9)), (1, True)]))
        struct[0].Gy_ini[260,54] = i_INV_10_a_r
        struct[0].Gy_ini[260,55] = i_INV_10_a_i
        struct[0].Gy_ini[260,260] = v_INV_10_a_r
        struct[0].Gy_ini[260,261] = v_INV_10_a_i
        struct[0].Gy_ini[261,56] = i_INV_10_b_r
        struct[0].Gy_ini[261,57] = i_INV_10_b_i
        struct[0].Gy_ini[261,262] = v_INV_10_b_r
        struct[0].Gy_ini[261,263] = v_INV_10_b_i
        struct[0].Gy_ini[262,58] = i_INV_10_c_r
        struct[0].Gy_ini[262,59] = i_INV_10_c_i
        struct[0].Gy_ini[262,264] = v_INV_10_c_r
        struct[0].Gy_ini[262,265] = v_INV_10_c_i
        struct[0].Gy_ini[263,54] = -i_INV_10_a_i
        struct[0].Gy_ini[263,55] = i_INV_10_a_r
        struct[0].Gy_ini[263,260] = v_INV_10_a_i
        struct[0].Gy_ini[263,261] = -v_INV_10_a_r
        struct[0].Gy_ini[264,56] = -i_INV_10_b_i
        struct[0].Gy_ini[264,57] = i_INV_10_b_r
        struct[0].Gy_ini[264,262] = v_INV_10_b_i
        struct[0].Gy_ini[264,263] = -v_INV_10_b_r
        struct[0].Gy_ini[265,58] = -i_INV_10_c_i
        struct[0].Gy_ini[265,59] = i_INV_10_c_r
        struct[0].Gy_ini[265,264] = v_INV_10_c_i
        struct[0].Gy_ini[265,265] = -v_INV_10_c_r
        struct[0].Gy_ini[266,54] = 1.0*v_INV_10_a_r*(v_INV_10_a_i**2 + v_INV_10_a_r**2)**(-0.5)/V_base_INV_10
        struct[0].Gy_ini[266,55] = 1.0*v_INV_10_a_i*(v_INV_10_a_i**2 + v_INV_10_a_r**2)**(-0.5)/V_base_INV_10
        struct[0].Gy_ini[267,257] = -K_p_v_INV_10*u_ctrl_v_INV_10
        struct[0].Gy_ini[267,266] = K_p_v_INV_10*(u_ctrl_v_INV_10 - 1.0)
        struct[0].Gy_ini[268,172] = 1.0*S_base_INV_10*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_10, I_max_INV_10 < -i_reac_ref_INV_10), (I_max_INV_10, I_max_INV_10 < i_reac_ref_INV_10), (i_reac_ref_INV_10, True)]))
        struct[0].Gy_ini[268,173] = 1.0*S_base_INV_10*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_10, I_max_INV_10 < -i_reac_ref_INV_10), (I_max_INV_10, I_max_INV_10 < i_reac_ref_INV_10), (i_reac_ref_INV_10, True)]))
        struct[0].Gy_ini[268,267] = S_base_INV_10*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_10 < i_reac_ref_INV_10) | (I_max_INV_10 < -i_reac_ref_INV_10)), (1, True)]))
        struct[0].Gy_ini[269,60] = i_INV_11_a_r
        struct[0].Gy_ini[269,61] = i_INV_11_a_i
        struct[0].Gy_ini[269,269] = v_INV_11_a_r
        struct[0].Gy_ini[269,270] = v_INV_11_a_i
        struct[0].Gy_ini[270,62] = i_INV_11_b_r
        struct[0].Gy_ini[270,63] = i_INV_11_b_i
        struct[0].Gy_ini[270,271] = v_INV_11_b_r
        struct[0].Gy_ini[270,272] = v_INV_11_b_i
        struct[0].Gy_ini[271,64] = i_INV_11_c_r
        struct[0].Gy_ini[271,65] = i_INV_11_c_i
        struct[0].Gy_ini[271,273] = v_INV_11_c_r
        struct[0].Gy_ini[271,274] = v_INV_11_c_i
        struct[0].Gy_ini[272,60] = -i_INV_11_a_i
        struct[0].Gy_ini[272,61] = i_INV_11_a_r
        struct[0].Gy_ini[272,269] = v_INV_11_a_i
        struct[0].Gy_ini[272,270] = -v_INV_11_a_r
        struct[0].Gy_ini[273,62] = -i_INV_11_b_i
        struct[0].Gy_ini[273,63] = i_INV_11_b_r
        struct[0].Gy_ini[273,271] = v_INV_11_b_i
        struct[0].Gy_ini[273,272] = -v_INV_11_b_r
        struct[0].Gy_ini[274,64] = -i_INV_11_c_i
        struct[0].Gy_ini[274,65] = i_INV_11_c_r
        struct[0].Gy_ini[274,273] = v_INV_11_c_i
        struct[0].Gy_ini[274,274] = -v_INV_11_c_r
        struct[0].Gy_ini[275,60] = 1.0*v_INV_11_a_r*(v_INV_11_a_i**2 + v_INV_11_a_r**2)**(-0.5)/V_base_INV_11
        struct[0].Gy_ini[275,61] = 1.0*v_INV_11_a_i*(v_INV_11_a_i**2 + v_INV_11_a_r**2)**(-0.5)/V_base_INV_11
        struct[0].Gy_ini[276,150] = 1.0*v_TR_11_12_mv_a_r*(v_TR_11_12_mv_a_i**2 + v_TR_11_12_mv_a_r**2)**(-0.5)/V_base_TR_11_12_mv
        struct[0].Gy_ini[276,151] = 1.0*v_TR_11_12_mv_a_i*(v_TR_11_12_mv_a_i**2 + v_TR_11_12_mv_a_r**2)**(-0.5)/V_base_TR_11_12_mv
        struct[0].Gy_ini[277,275] = K_p_v_INV_11*(u_ctrl_v_INV_11 - 1.0)
        struct[0].Gy_ini[277,276] = -K_p_v_INV_11*u_ctrl_v_INV_11
        struct[0].Gy_ini[278,172] = 1.0*S_base_INV_11*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_11, I_max_INV_11 < -i_reac_ref_INV_11), (I_max_INV_11, I_max_INV_11 < i_reac_ref_INV_11), (i_reac_ref_INV_11, True)]))
        struct[0].Gy_ini[278,173] = 1.0*S_base_INV_11*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_11, I_max_INV_11 < -i_reac_ref_INV_11), (I_max_INV_11, I_max_INV_11 < i_reac_ref_INV_11), (i_reac_ref_INV_11, True)]))
        struct[0].Gy_ini[278,277] = S_base_INV_11*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_11 < i_reac_ref_INV_11) | (I_max_INV_11 < -i_reac_ref_INV_11)), (1, True)]))
        struct[0].Gy_ini[279,66] = i_INV_12_a_r
        struct[0].Gy_ini[279,67] = i_INV_12_a_i
        struct[0].Gy_ini[279,279] = v_INV_12_a_r
        struct[0].Gy_ini[279,280] = v_INV_12_a_i
        struct[0].Gy_ini[280,68] = i_INV_12_b_r
        struct[0].Gy_ini[280,69] = i_INV_12_b_i
        struct[0].Gy_ini[280,281] = v_INV_12_b_r
        struct[0].Gy_ini[280,282] = v_INV_12_b_i
        struct[0].Gy_ini[281,70] = i_INV_12_c_r
        struct[0].Gy_ini[281,71] = i_INV_12_c_i
        struct[0].Gy_ini[281,283] = v_INV_12_c_r
        struct[0].Gy_ini[281,284] = v_INV_12_c_i
        struct[0].Gy_ini[282,66] = -i_INV_12_a_i
        struct[0].Gy_ini[282,67] = i_INV_12_a_r
        struct[0].Gy_ini[282,279] = v_INV_12_a_i
        struct[0].Gy_ini[282,280] = -v_INV_12_a_r
        struct[0].Gy_ini[283,68] = -i_INV_12_b_i
        struct[0].Gy_ini[283,69] = i_INV_12_b_r
        struct[0].Gy_ini[283,281] = v_INV_12_b_i
        struct[0].Gy_ini[283,282] = -v_INV_12_b_r
        struct[0].Gy_ini[284,70] = -i_INV_12_c_i
        struct[0].Gy_ini[284,71] = i_INV_12_c_r
        struct[0].Gy_ini[284,283] = v_INV_12_c_i
        struct[0].Gy_ini[284,284] = -v_INV_12_c_r
        struct[0].Gy_ini[285,66] = 1.0*v_INV_12_a_r*(v_INV_12_a_i**2 + v_INV_12_a_r**2)**(-0.5)/V_base_INV_12
        struct[0].Gy_ini[285,67] = 1.0*v_INV_12_a_i*(v_INV_12_a_i**2 + v_INV_12_a_r**2)**(-0.5)/V_base_INV_12
        struct[0].Gy_ini[286,276] = -K_p_v_INV_12*u_ctrl_v_INV_12
        struct[0].Gy_ini[286,285] = K_p_v_INV_12*(u_ctrl_v_INV_12 - 1.0)
        struct[0].Gy_ini[287,172] = 1.0*S_base_INV_12*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_12, I_max_INV_12 < -i_reac_ref_INV_12), (I_max_INV_12, I_max_INV_12 < i_reac_ref_INV_12), (i_reac_ref_INV_12, True)]))
        struct[0].Gy_ini[287,173] = 1.0*S_base_INV_12*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_12, I_max_INV_12 < -i_reac_ref_INV_12), (I_max_INV_12, I_max_INV_12 < i_reac_ref_INV_12), (i_reac_ref_INV_12, True)]))
        struct[0].Gy_ini[287,286] = S_base_INV_12*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_12 < i_reac_ref_INV_12) | (I_max_INV_12 < -i_reac_ref_INV_12)), (1, True)]))
        struct[0].Gy_ini[288,72] = i_INV_13_a_r
        struct[0].Gy_ini[288,73] = i_INV_13_a_i
        struct[0].Gy_ini[288,288] = v_INV_13_a_r
        struct[0].Gy_ini[288,289] = v_INV_13_a_i
        struct[0].Gy_ini[289,74] = i_INV_13_b_r
        struct[0].Gy_ini[289,75] = i_INV_13_b_i
        struct[0].Gy_ini[289,290] = v_INV_13_b_r
        struct[0].Gy_ini[289,291] = v_INV_13_b_i
        struct[0].Gy_ini[290,76] = i_INV_13_c_r
        struct[0].Gy_ini[290,77] = i_INV_13_c_i
        struct[0].Gy_ini[290,292] = v_INV_13_c_r
        struct[0].Gy_ini[290,293] = v_INV_13_c_i
        struct[0].Gy_ini[291,72] = -i_INV_13_a_i
        struct[0].Gy_ini[291,73] = i_INV_13_a_r
        struct[0].Gy_ini[291,288] = v_INV_13_a_i
        struct[0].Gy_ini[291,289] = -v_INV_13_a_r
        struct[0].Gy_ini[292,74] = -i_INV_13_b_i
        struct[0].Gy_ini[292,75] = i_INV_13_b_r
        struct[0].Gy_ini[292,290] = v_INV_13_b_i
        struct[0].Gy_ini[292,291] = -v_INV_13_b_r
        struct[0].Gy_ini[293,76] = -i_INV_13_c_i
        struct[0].Gy_ini[293,77] = i_INV_13_c_r
        struct[0].Gy_ini[293,292] = v_INV_13_c_i
        struct[0].Gy_ini[293,293] = -v_INV_13_c_r
        struct[0].Gy_ini[294,72] = 1.0*v_INV_13_a_r*(v_INV_13_a_i**2 + v_INV_13_a_r**2)**(-0.5)/V_base_INV_13
        struct[0].Gy_ini[294,73] = 1.0*v_INV_13_a_i*(v_INV_13_a_i**2 + v_INV_13_a_r**2)**(-0.5)/V_base_INV_13
        struct[0].Gy_ini[295,162] = 1.0*v_TR_13_mv_a_r*(v_TR_13_mv_a_i**2 + v_TR_13_mv_a_r**2)**(-0.5)/V_base_TR_13_mv
        struct[0].Gy_ini[295,163] = 1.0*v_TR_13_mv_a_i*(v_TR_13_mv_a_i**2 + v_TR_13_mv_a_r**2)**(-0.5)/V_base_TR_13_mv
        struct[0].Gy_ini[296,294] = K_p_v_INV_13*(u_ctrl_v_INV_13 - 1.0)
        struct[0].Gy_ini[296,295] = -K_p_v_INV_13*u_ctrl_v_INV_13
        struct[0].Gy_ini[297,172] = 1.0*S_base_INV_13*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_13, I_max_INV_13 < -i_reac_ref_INV_13), (I_max_INV_13, I_max_INV_13 < i_reac_ref_INV_13), (i_reac_ref_INV_13, True)]))
        struct[0].Gy_ini[297,173] = 1.0*S_base_INV_13*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_13, I_max_INV_13 < -i_reac_ref_INV_13), (I_max_INV_13, I_max_INV_13 < i_reac_ref_INV_13), (i_reac_ref_INV_13, True)]))
        struct[0].Gy_ini[297,296] = S_base_INV_13*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_13 < i_reac_ref_INV_13) | (I_max_INV_13 < -i_reac_ref_INV_13)), (1, True)]))



@numba.njit(cache=True)
def run(t,struct,mode):

    # Parameters:
    u_ctrl_v_INV_1 = struct[0].u_ctrl_v_INV_1
    K_p_v_INV_1 = struct[0].K_p_v_INV_1
    K_i_v_INV_1 = struct[0].K_i_v_INV_1
    V_base_INV_1 = struct[0].V_base_INV_1
    V_base_TR_1_2_mv = struct[0].V_base_TR_1_2_mv
    S_base_INV_1 = struct[0].S_base_INV_1
    I_max_INV_1 = struct[0].I_max_INV_1
    u_ctrl_v_INV_2 = struct[0].u_ctrl_v_INV_2
    K_p_v_INV_2 = struct[0].K_p_v_INV_2
    K_i_v_INV_2 = struct[0].K_i_v_INV_2
    V_base_INV_2 = struct[0].V_base_INV_2
    S_base_INV_2 = struct[0].S_base_INV_2
    I_max_INV_2 = struct[0].I_max_INV_2
    u_ctrl_v_INV_3 = struct[0].u_ctrl_v_INV_3
    K_p_v_INV_3 = struct[0].K_p_v_INV_3
    K_i_v_INV_3 = struct[0].K_i_v_INV_3
    V_base_INV_3 = struct[0].V_base_INV_3
    V_base_TR_3_4_mv = struct[0].V_base_TR_3_4_mv
    S_base_INV_3 = struct[0].S_base_INV_3
    I_max_INV_3 = struct[0].I_max_INV_3
    u_ctrl_v_INV_4 = struct[0].u_ctrl_v_INV_4
    K_p_v_INV_4 = struct[0].K_p_v_INV_4
    K_i_v_INV_4 = struct[0].K_i_v_INV_4
    V_base_INV_4 = struct[0].V_base_INV_4
    S_base_INV_4 = struct[0].S_base_INV_4
    I_max_INV_4 = struct[0].I_max_INV_4
    u_ctrl_v_INV_5 = struct[0].u_ctrl_v_INV_5
    K_p_v_INV_5 = struct[0].K_p_v_INV_5
    K_i_v_INV_5 = struct[0].K_i_v_INV_5
    V_base_INV_5 = struct[0].V_base_INV_5
    V_base_TR_5_6_mv = struct[0].V_base_TR_5_6_mv
    S_base_INV_5 = struct[0].S_base_INV_5
    I_max_INV_5 = struct[0].I_max_INV_5
    u_ctrl_v_INV_6 = struct[0].u_ctrl_v_INV_6
    K_p_v_INV_6 = struct[0].K_p_v_INV_6
    K_i_v_INV_6 = struct[0].K_i_v_INV_6
    V_base_INV_6 = struct[0].V_base_INV_6
    S_base_INV_6 = struct[0].S_base_INV_6
    I_max_INV_6 = struct[0].I_max_INV_6
    u_ctrl_v_INV_7 = struct[0].u_ctrl_v_INV_7
    K_p_v_INV_7 = struct[0].K_p_v_INV_7
    K_i_v_INV_7 = struct[0].K_i_v_INV_7
    V_base_INV_7 = struct[0].V_base_INV_7
    V_base_TR_7_8_mv = struct[0].V_base_TR_7_8_mv
    S_base_INV_7 = struct[0].S_base_INV_7
    I_max_INV_7 = struct[0].I_max_INV_7
    u_ctrl_v_INV_8 = struct[0].u_ctrl_v_INV_8
    K_p_v_INV_8 = struct[0].K_p_v_INV_8
    K_i_v_INV_8 = struct[0].K_i_v_INV_8
    V_base_INV_8 = struct[0].V_base_INV_8
    S_base_INV_8 = struct[0].S_base_INV_8
    I_max_INV_8 = struct[0].I_max_INV_8
    u_ctrl_v_INV_9 = struct[0].u_ctrl_v_INV_9
    K_p_v_INV_9 = struct[0].K_p_v_INV_9
    K_i_v_INV_9 = struct[0].K_i_v_INV_9
    V_base_INV_9 = struct[0].V_base_INV_9
    V_base_TR_9_10_mv = struct[0].V_base_TR_9_10_mv
    S_base_INV_9 = struct[0].S_base_INV_9
    I_max_INV_9 = struct[0].I_max_INV_9
    u_ctrl_v_INV_10 = struct[0].u_ctrl_v_INV_10
    K_p_v_INV_10 = struct[0].K_p_v_INV_10
    K_i_v_INV_10 = struct[0].K_i_v_INV_10
    V_base_INV_10 = struct[0].V_base_INV_10
    S_base_INV_10 = struct[0].S_base_INV_10
    I_max_INV_10 = struct[0].I_max_INV_10
    u_ctrl_v_INV_11 = struct[0].u_ctrl_v_INV_11
    K_p_v_INV_11 = struct[0].K_p_v_INV_11
    K_i_v_INV_11 = struct[0].K_i_v_INV_11
    V_base_INV_11 = struct[0].V_base_INV_11
    V_base_TR_11_12_mv = struct[0].V_base_TR_11_12_mv
    S_base_INV_11 = struct[0].S_base_INV_11
    I_max_INV_11 = struct[0].I_max_INV_11
    u_ctrl_v_INV_12 = struct[0].u_ctrl_v_INV_12
    K_p_v_INV_12 = struct[0].K_p_v_INV_12
    K_i_v_INV_12 = struct[0].K_i_v_INV_12
    V_base_INV_12 = struct[0].V_base_INV_12
    S_base_INV_12 = struct[0].S_base_INV_12
    I_max_INV_12 = struct[0].I_max_INV_12
    u_ctrl_v_INV_13 = struct[0].u_ctrl_v_INV_13
    K_p_v_INV_13 = struct[0].K_p_v_INV_13
    K_i_v_INV_13 = struct[0].K_i_v_INV_13
    V_base_INV_13 = struct[0].V_base_INV_13
    V_base_TR_13_mv = struct[0].V_base_TR_13_mv
    S_base_INV_13 = struct[0].S_base_INV_13
    I_max_INV_13 = struct[0].I_max_INV_13
    
    # Inputs:
    v_GRID_a_r = struct[0].v_GRID_a_r
    v_GRID_a_i = struct[0].v_GRID_a_i
    v_GRID_b_r = struct[0].v_GRID_b_r
    v_GRID_b_i = struct[0].v_GRID_b_i
    v_GRID_c_r = struct[0].v_GRID_c_r
    v_GRID_c_i = struct[0].v_GRID_c_i
    i_POIhv_a_r = struct[0].i_POIhv_a_r
    i_POIhv_a_i = struct[0].i_POIhv_a_i
    i_POIhv_b_r = struct[0].i_POIhv_b_r
    i_POIhv_b_i = struct[0].i_POIhv_b_i
    i_POIhv_c_r = struct[0].i_POIhv_c_r
    i_POIhv_c_i = struct[0].i_POIhv_c_i
    i_POImv_a_r = struct[0].i_POImv_a_r
    i_POImv_a_i = struct[0].i_POImv_a_i
    i_POImv_b_r = struct[0].i_POImv_b_r
    i_POImv_b_i = struct[0].i_POImv_b_i
    i_POImv_c_r = struct[0].i_POImv_c_r
    i_POImv_c_i = struct[0].i_POImv_c_i
    i_TR_1_2_mv_a_r = struct[0].i_TR_1_2_mv_a_r
    i_TR_1_2_mv_a_i = struct[0].i_TR_1_2_mv_a_i
    i_TR_1_2_mv_b_r = struct[0].i_TR_1_2_mv_b_r
    i_TR_1_2_mv_b_i = struct[0].i_TR_1_2_mv_b_i
    i_TR_1_2_mv_c_r = struct[0].i_TR_1_2_mv_c_r
    i_TR_1_2_mv_c_i = struct[0].i_TR_1_2_mv_c_i
    i_TR_1_2_lv_a_r = struct[0].i_TR_1_2_lv_a_r
    i_TR_1_2_lv_a_i = struct[0].i_TR_1_2_lv_a_i
    i_TR_1_2_lv_b_r = struct[0].i_TR_1_2_lv_b_r
    i_TR_1_2_lv_b_i = struct[0].i_TR_1_2_lv_b_i
    i_TR_1_2_lv_c_r = struct[0].i_TR_1_2_lv_c_r
    i_TR_1_2_lv_c_i = struct[0].i_TR_1_2_lv_c_i
    i_TR_3_4_mv_a_r = struct[0].i_TR_3_4_mv_a_r
    i_TR_3_4_mv_a_i = struct[0].i_TR_3_4_mv_a_i
    i_TR_3_4_mv_b_r = struct[0].i_TR_3_4_mv_b_r
    i_TR_3_4_mv_b_i = struct[0].i_TR_3_4_mv_b_i
    i_TR_3_4_mv_c_r = struct[0].i_TR_3_4_mv_c_r
    i_TR_3_4_mv_c_i = struct[0].i_TR_3_4_mv_c_i
    i_TR_3_4_lv_a_r = struct[0].i_TR_3_4_lv_a_r
    i_TR_3_4_lv_a_i = struct[0].i_TR_3_4_lv_a_i
    i_TR_3_4_lv_b_r = struct[0].i_TR_3_4_lv_b_r
    i_TR_3_4_lv_b_i = struct[0].i_TR_3_4_lv_b_i
    i_TR_3_4_lv_c_r = struct[0].i_TR_3_4_lv_c_r
    i_TR_3_4_lv_c_i = struct[0].i_TR_3_4_lv_c_i
    i_TR_5_6_mv_a_r = struct[0].i_TR_5_6_mv_a_r
    i_TR_5_6_mv_a_i = struct[0].i_TR_5_6_mv_a_i
    i_TR_5_6_mv_b_r = struct[0].i_TR_5_6_mv_b_r
    i_TR_5_6_mv_b_i = struct[0].i_TR_5_6_mv_b_i
    i_TR_5_6_mv_c_r = struct[0].i_TR_5_6_mv_c_r
    i_TR_5_6_mv_c_i = struct[0].i_TR_5_6_mv_c_i
    i_TR_5_6_lv_a_r = struct[0].i_TR_5_6_lv_a_r
    i_TR_5_6_lv_a_i = struct[0].i_TR_5_6_lv_a_i
    i_TR_5_6_lv_b_r = struct[0].i_TR_5_6_lv_b_r
    i_TR_5_6_lv_b_i = struct[0].i_TR_5_6_lv_b_i
    i_TR_5_6_lv_c_r = struct[0].i_TR_5_6_lv_c_r
    i_TR_5_6_lv_c_i = struct[0].i_TR_5_6_lv_c_i
    i_TR_7_8_mv_a_r = struct[0].i_TR_7_8_mv_a_r
    i_TR_7_8_mv_a_i = struct[0].i_TR_7_8_mv_a_i
    i_TR_7_8_mv_b_r = struct[0].i_TR_7_8_mv_b_r
    i_TR_7_8_mv_b_i = struct[0].i_TR_7_8_mv_b_i
    i_TR_7_8_mv_c_r = struct[0].i_TR_7_8_mv_c_r
    i_TR_7_8_mv_c_i = struct[0].i_TR_7_8_mv_c_i
    i_TR_7_8_lv_a_r = struct[0].i_TR_7_8_lv_a_r
    i_TR_7_8_lv_a_i = struct[0].i_TR_7_8_lv_a_i
    i_TR_7_8_lv_b_r = struct[0].i_TR_7_8_lv_b_r
    i_TR_7_8_lv_b_i = struct[0].i_TR_7_8_lv_b_i
    i_TR_7_8_lv_c_r = struct[0].i_TR_7_8_lv_c_r
    i_TR_7_8_lv_c_i = struct[0].i_TR_7_8_lv_c_i
    i_TR_9_10_mv_a_r = struct[0].i_TR_9_10_mv_a_r
    i_TR_9_10_mv_a_i = struct[0].i_TR_9_10_mv_a_i
    i_TR_9_10_mv_b_r = struct[0].i_TR_9_10_mv_b_r
    i_TR_9_10_mv_b_i = struct[0].i_TR_9_10_mv_b_i
    i_TR_9_10_mv_c_r = struct[0].i_TR_9_10_mv_c_r
    i_TR_9_10_mv_c_i = struct[0].i_TR_9_10_mv_c_i
    i_TR_9_10_lv_a_r = struct[0].i_TR_9_10_lv_a_r
    i_TR_9_10_lv_a_i = struct[0].i_TR_9_10_lv_a_i
    i_TR_9_10_lv_b_r = struct[0].i_TR_9_10_lv_b_r
    i_TR_9_10_lv_b_i = struct[0].i_TR_9_10_lv_b_i
    i_TR_9_10_lv_c_r = struct[0].i_TR_9_10_lv_c_r
    i_TR_9_10_lv_c_i = struct[0].i_TR_9_10_lv_c_i
    i_TR_11_12_mv_a_r = struct[0].i_TR_11_12_mv_a_r
    i_TR_11_12_mv_a_i = struct[0].i_TR_11_12_mv_a_i
    i_TR_11_12_mv_b_r = struct[0].i_TR_11_12_mv_b_r
    i_TR_11_12_mv_b_i = struct[0].i_TR_11_12_mv_b_i
    i_TR_11_12_mv_c_r = struct[0].i_TR_11_12_mv_c_r
    i_TR_11_12_mv_c_i = struct[0].i_TR_11_12_mv_c_i
    i_TR_11_12_lv_a_r = struct[0].i_TR_11_12_lv_a_r
    i_TR_11_12_lv_a_i = struct[0].i_TR_11_12_lv_a_i
    i_TR_11_12_lv_b_r = struct[0].i_TR_11_12_lv_b_r
    i_TR_11_12_lv_b_i = struct[0].i_TR_11_12_lv_b_i
    i_TR_11_12_lv_c_r = struct[0].i_TR_11_12_lv_c_r
    i_TR_11_12_lv_c_i = struct[0].i_TR_11_12_lv_c_i
    i_TR_13_mv_a_r = struct[0].i_TR_13_mv_a_r
    i_TR_13_mv_a_i = struct[0].i_TR_13_mv_a_i
    i_TR_13_mv_b_r = struct[0].i_TR_13_mv_b_r
    i_TR_13_mv_b_i = struct[0].i_TR_13_mv_b_i
    i_TR_13_mv_c_r = struct[0].i_TR_13_mv_c_r
    i_TR_13_mv_c_i = struct[0].i_TR_13_mv_c_i
    i_TR_13_lv_a_r = struct[0].i_TR_13_lv_a_r
    i_TR_13_lv_a_i = struct[0].i_TR_13_lv_a_i
    i_TR_13_lv_b_r = struct[0].i_TR_13_lv_b_r
    i_TR_13_lv_b_i = struct[0].i_TR_13_lv_b_i
    i_TR_13_lv_c_r = struct[0].i_TR_13_lv_c_r
    i_TR_13_lv_c_i = struct[0].i_TR_13_lv_c_i
    p_ref_INV_1 = struct[0].p_ref_INV_1
    T_pq_INV_1 = struct[0].T_pq_INV_1
    v_loc_ref_INV_1 = struct[0].v_loc_ref_INV_1
    Dv_r_INV_1 = struct[0].Dv_r_INV_1
    Dq_r_INV_1 = struct[0].Dq_r_INV_1
    p_ref_INV_2 = struct[0].p_ref_INV_2
    T_pq_INV_2 = struct[0].T_pq_INV_2
    v_loc_ref_INV_2 = struct[0].v_loc_ref_INV_2
    Dv_r_INV_2 = struct[0].Dv_r_INV_2
    Dq_r_INV_2 = struct[0].Dq_r_INV_2
    p_ref_INV_3 = struct[0].p_ref_INV_3
    T_pq_INV_3 = struct[0].T_pq_INV_3
    v_loc_ref_INV_3 = struct[0].v_loc_ref_INV_3
    Dv_r_INV_3 = struct[0].Dv_r_INV_3
    Dq_r_INV_3 = struct[0].Dq_r_INV_3
    p_ref_INV_4 = struct[0].p_ref_INV_4
    T_pq_INV_4 = struct[0].T_pq_INV_4
    v_loc_ref_INV_4 = struct[0].v_loc_ref_INV_4
    Dv_r_INV_4 = struct[0].Dv_r_INV_4
    Dq_r_INV_4 = struct[0].Dq_r_INV_4
    p_ref_INV_5 = struct[0].p_ref_INV_5
    T_pq_INV_5 = struct[0].T_pq_INV_5
    v_loc_ref_INV_5 = struct[0].v_loc_ref_INV_5
    Dv_r_INV_5 = struct[0].Dv_r_INV_5
    Dq_r_INV_5 = struct[0].Dq_r_INV_5
    p_ref_INV_6 = struct[0].p_ref_INV_6
    T_pq_INV_6 = struct[0].T_pq_INV_6
    v_loc_ref_INV_6 = struct[0].v_loc_ref_INV_6
    Dv_r_INV_6 = struct[0].Dv_r_INV_6
    Dq_r_INV_6 = struct[0].Dq_r_INV_6
    p_ref_INV_7 = struct[0].p_ref_INV_7
    T_pq_INV_7 = struct[0].T_pq_INV_7
    v_loc_ref_INV_7 = struct[0].v_loc_ref_INV_7
    Dv_r_INV_7 = struct[0].Dv_r_INV_7
    Dq_r_INV_7 = struct[0].Dq_r_INV_7
    p_ref_INV_8 = struct[0].p_ref_INV_8
    T_pq_INV_8 = struct[0].T_pq_INV_8
    v_loc_ref_INV_8 = struct[0].v_loc_ref_INV_8
    Dv_r_INV_8 = struct[0].Dv_r_INV_8
    Dq_r_INV_8 = struct[0].Dq_r_INV_8
    p_ref_INV_9 = struct[0].p_ref_INV_9
    T_pq_INV_9 = struct[0].T_pq_INV_9
    v_loc_ref_INV_9 = struct[0].v_loc_ref_INV_9
    Dv_r_INV_9 = struct[0].Dv_r_INV_9
    Dq_r_INV_9 = struct[0].Dq_r_INV_9
    p_ref_INV_10 = struct[0].p_ref_INV_10
    T_pq_INV_10 = struct[0].T_pq_INV_10
    v_loc_ref_INV_10 = struct[0].v_loc_ref_INV_10
    Dv_r_INV_10 = struct[0].Dv_r_INV_10
    Dq_r_INV_10 = struct[0].Dq_r_INV_10
    p_ref_INV_11 = struct[0].p_ref_INV_11
    T_pq_INV_11 = struct[0].T_pq_INV_11
    v_loc_ref_INV_11 = struct[0].v_loc_ref_INV_11
    Dv_r_INV_11 = struct[0].Dv_r_INV_11
    Dq_r_INV_11 = struct[0].Dq_r_INV_11
    p_ref_INV_12 = struct[0].p_ref_INV_12
    T_pq_INV_12 = struct[0].T_pq_INV_12
    v_loc_ref_INV_12 = struct[0].v_loc_ref_INV_12
    Dv_r_INV_12 = struct[0].Dv_r_INV_12
    Dq_r_INV_12 = struct[0].Dq_r_INV_12
    p_ref_INV_13 = struct[0].p_ref_INV_13
    T_pq_INV_13 = struct[0].T_pq_INV_13
    v_loc_ref_INV_13 = struct[0].v_loc_ref_INV_13
    Dv_r_INV_13 = struct[0].Dv_r_INV_13
    Dq_r_INV_13 = struct[0].Dq_r_INV_13
    
    # Dynamical states:
    p_INV_1_a = struct[0].x[0,0]
    p_INV_1_b = struct[0].x[1,0]
    p_INV_1_c = struct[0].x[2,0]
    q_INV_1_a = struct[0].x[3,0]
    q_INV_1_b = struct[0].x[4,0]
    q_INV_1_c = struct[0].x[5,0]
    p_INV_2_a = struct[0].x[6,0]
    p_INV_2_b = struct[0].x[7,0]
    p_INV_2_c = struct[0].x[8,0]
    q_INV_2_a = struct[0].x[9,0]
    q_INV_2_b = struct[0].x[10,0]
    q_INV_2_c = struct[0].x[11,0]
    p_INV_3_a = struct[0].x[12,0]
    p_INV_3_b = struct[0].x[13,0]
    p_INV_3_c = struct[0].x[14,0]
    q_INV_3_a = struct[0].x[15,0]
    q_INV_3_b = struct[0].x[16,0]
    q_INV_3_c = struct[0].x[17,0]
    p_INV_4_a = struct[0].x[18,0]
    p_INV_4_b = struct[0].x[19,0]
    p_INV_4_c = struct[0].x[20,0]
    q_INV_4_a = struct[0].x[21,0]
    q_INV_4_b = struct[0].x[22,0]
    q_INV_4_c = struct[0].x[23,0]
    p_INV_5_a = struct[0].x[24,0]
    p_INV_5_b = struct[0].x[25,0]
    p_INV_5_c = struct[0].x[26,0]
    q_INV_5_a = struct[0].x[27,0]
    q_INV_5_b = struct[0].x[28,0]
    q_INV_5_c = struct[0].x[29,0]
    p_INV_6_a = struct[0].x[30,0]
    p_INV_6_b = struct[0].x[31,0]
    p_INV_6_c = struct[0].x[32,0]
    q_INV_6_a = struct[0].x[33,0]
    q_INV_6_b = struct[0].x[34,0]
    q_INV_6_c = struct[0].x[35,0]
    p_INV_7_a = struct[0].x[36,0]
    p_INV_7_b = struct[0].x[37,0]
    p_INV_7_c = struct[0].x[38,0]
    q_INV_7_a = struct[0].x[39,0]
    q_INV_7_b = struct[0].x[40,0]
    q_INV_7_c = struct[0].x[41,0]
    p_INV_8_a = struct[0].x[42,0]
    p_INV_8_b = struct[0].x[43,0]
    p_INV_8_c = struct[0].x[44,0]
    q_INV_8_a = struct[0].x[45,0]
    q_INV_8_b = struct[0].x[46,0]
    q_INV_8_c = struct[0].x[47,0]
    p_INV_9_a = struct[0].x[48,0]
    p_INV_9_b = struct[0].x[49,0]
    p_INV_9_c = struct[0].x[50,0]
    q_INV_9_a = struct[0].x[51,0]
    q_INV_9_b = struct[0].x[52,0]
    q_INV_9_c = struct[0].x[53,0]
    p_INV_10_a = struct[0].x[54,0]
    p_INV_10_b = struct[0].x[55,0]
    p_INV_10_c = struct[0].x[56,0]
    q_INV_10_a = struct[0].x[57,0]
    q_INV_10_b = struct[0].x[58,0]
    q_INV_10_c = struct[0].x[59,0]
    p_INV_11_a = struct[0].x[60,0]
    p_INV_11_b = struct[0].x[61,0]
    p_INV_11_c = struct[0].x[62,0]
    q_INV_11_a = struct[0].x[63,0]
    q_INV_11_b = struct[0].x[64,0]
    q_INV_11_c = struct[0].x[65,0]
    p_INV_12_a = struct[0].x[66,0]
    p_INV_12_b = struct[0].x[67,0]
    p_INV_12_c = struct[0].x[68,0]
    q_INV_12_a = struct[0].x[69,0]
    q_INV_12_b = struct[0].x[70,0]
    q_INV_12_c = struct[0].x[71,0]
    p_INV_13_a = struct[0].x[72,0]
    p_INV_13_b = struct[0].x[73,0]
    p_INV_13_c = struct[0].x[74,0]
    q_INV_13_a = struct[0].x[75,0]
    q_INV_13_b = struct[0].x[76,0]
    q_INV_13_c = struct[0].x[77,0]
    
    # Algebraic states:
    v_INV_1_a_r = struct[0].y_run[0,0]
    v_INV_1_a_i = struct[0].y_run[1,0]
    v_INV_1_b_r = struct[0].y_run[2,0]
    v_INV_1_b_i = struct[0].y_run[3,0]
    v_INV_1_c_r = struct[0].y_run[4,0]
    v_INV_1_c_i = struct[0].y_run[5,0]
    v_INV_2_a_r = struct[0].y_run[6,0]
    v_INV_2_a_i = struct[0].y_run[7,0]
    v_INV_2_b_r = struct[0].y_run[8,0]
    v_INV_2_b_i = struct[0].y_run[9,0]
    v_INV_2_c_r = struct[0].y_run[10,0]
    v_INV_2_c_i = struct[0].y_run[11,0]
    v_INV_3_a_r = struct[0].y_run[12,0]
    v_INV_3_a_i = struct[0].y_run[13,0]
    v_INV_3_b_r = struct[0].y_run[14,0]
    v_INV_3_b_i = struct[0].y_run[15,0]
    v_INV_3_c_r = struct[0].y_run[16,0]
    v_INV_3_c_i = struct[0].y_run[17,0]
    v_INV_4_a_r = struct[0].y_run[18,0]
    v_INV_4_a_i = struct[0].y_run[19,0]
    v_INV_4_b_r = struct[0].y_run[20,0]
    v_INV_4_b_i = struct[0].y_run[21,0]
    v_INV_4_c_r = struct[0].y_run[22,0]
    v_INV_4_c_i = struct[0].y_run[23,0]
    v_INV_5_a_r = struct[0].y_run[24,0]
    v_INV_5_a_i = struct[0].y_run[25,0]
    v_INV_5_b_r = struct[0].y_run[26,0]
    v_INV_5_b_i = struct[0].y_run[27,0]
    v_INV_5_c_r = struct[0].y_run[28,0]
    v_INV_5_c_i = struct[0].y_run[29,0]
    v_INV_6_a_r = struct[0].y_run[30,0]
    v_INV_6_a_i = struct[0].y_run[31,0]
    v_INV_6_b_r = struct[0].y_run[32,0]
    v_INV_6_b_i = struct[0].y_run[33,0]
    v_INV_6_c_r = struct[0].y_run[34,0]
    v_INV_6_c_i = struct[0].y_run[35,0]
    v_INV_7_a_r = struct[0].y_run[36,0]
    v_INV_7_a_i = struct[0].y_run[37,0]
    v_INV_7_b_r = struct[0].y_run[38,0]
    v_INV_7_b_i = struct[0].y_run[39,0]
    v_INV_7_c_r = struct[0].y_run[40,0]
    v_INV_7_c_i = struct[0].y_run[41,0]
    v_INV_8_a_r = struct[0].y_run[42,0]
    v_INV_8_a_i = struct[0].y_run[43,0]
    v_INV_8_b_r = struct[0].y_run[44,0]
    v_INV_8_b_i = struct[0].y_run[45,0]
    v_INV_8_c_r = struct[0].y_run[46,0]
    v_INV_8_c_i = struct[0].y_run[47,0]
    v_INV_9_a_r = struct[0].y_run[48,0]
    v_INV_9_a_i = struct[0].y_run[49,0]
    v_INV_9_b_r = struct[0].y_run[50,0]
    v_INV_9_b_i = struct[0].y_run[51,0]
    v_INV_9_c_r = struct[0].y_run[52,0]
    v_INV_9_c_i = struct[0].y_run[53,0]
    v_INV_10_a_r = struct[0].y_run[54,0]
    v_INV_10_a_i = struct[0].y_run[55,0]
    v_INV_10_b_r = struct[0].y_run[56,0]
    v_INV_10_b_i = struct[0].y_run[57,0]
    v_INV_10_c_r = struct[0].y_run[58,0]
    v_INV_10_c_i = struct[0].y_run[59,0]
    v_INV_11_a_r = struct[0].y_run[60,0]
    v_INV_11_a_i = struct[0].y_run[61,0]
    v_INV_11_b_r = struct[0].y_run[62,0]
    v_INV_11_b_i = struct[0].y_run[63,0]
    v_INV_11_c_r = struct[0].y_run[64,0]
    v_INV_11_c_i = struct[0].y_run[65,0]
    v_INV_12_a_r = struct[0].y_run[66,0]
    v_INV_12_a_i = struct[0].y_run[67,0]
    v_INV_12_b_r = struct[0].y_run[68,0]
    v_INV_12_b_i = struct[0].y_run[69,0]
    v_INV_12_c_r = struct[0].y_run[70,0]
    v_INV_12_c_i = struct[0].y_run[71,0]
    v_INV_13_a_r = struct[0].y_run[72,0]
    v_INV_13_a_i = struct[0].y_run[73,0]
    v_INV_13_b_r = struct[0].y_run[74,0]
    v_INV_13_b_i = struct[0].y_run[75,0]
    v_INV_13_c_r = struct[0].y_run[76,0]
    v_INV_13_c_i = struct[0].y_run[77,0]
    v_POIhv_a_r = struct[0].y_run[78,0]
    v_POIhv_a_i = struct[0].y_run[79,0]
    v_POIhv_b_r = struct[0].y_run[80,0]
    v_POIhv_b_i = struct[0].y_run[81,0]
    v_POIhv_c_r = struct[0].y_run[82,0]
    v_POIhv_c_i = struct[0].y_run[83,0]
    v_POImv_a_r = struct[0].y_run[84,0]
    v_POImv_a_i = struct[0].y_run[85,0]
    v_POImv_b_r = struct[0].y_run[86,0]
    v_POImv_b_i = struct[0].y_run[87,0]
    v_POImv_c_r = struct[0].y_run[88,0]
    v_POImv_c_i = struct[0].y_run[89,0]
    v_TR_1_2_mv_a_r = struct[0].y_run[90,0]
    v_TR_1_2_mv_a_i = struct[0].y_run[91,0]
    v_TR_1_2_mv_b_r = struct[0].y_run[92,0]
    v_TR_1_2_mv_b_i = struct[0].y_run[93,0]
    v_TR_1_2_mv_c_r = struct[0].y_run[94,0]
    v_TR_1_2_mv_c_i = struct[0].y_run[95,0]
    v_TR_1_2_lv_a_r = struct[0].y_run[96,0]
    v_TR_1_2_lv_a_i = struct[0].y_run[97,0]
    v_TR_1_2_lv_b_r = struct[0].y_run[98,0]
    v_TR_1_2_lv_b_i = struct[0].y_run[99,0]
    v_TR_1_2_lv_c_r = struct[0].y_run[100,0]
    v_TR_1_2_lv_c_i = struct[0].y_run[101,0]
    v_TR_3_4_mv_a_r = struct[0].y_run[102,0]
    v_TR_3_4_mv_a_i = struct[0].y_run[103,0]
    v_TR_3_4_mv_b_r = struct[0].y_run[104,0]
    v_TR_3_4_mv_b_i = struct[0].y_run[105,0]
    v_TR_3_4_mv_c_r = struct[0].y_run[106,0]
    v_TR_3_4_mv_c_i = struct[0].y_run[107,0]
    v_TR_3_4_lv_a_r = struct[0].y_run[108,0]
    v_TR_3_4_lv_a_i = struct[0].y_run[109,0]
    v_TR_3_4_lv_b_r = struct[0].y_run[110,0]
    v_TR_3_4_lv_b_i = struct[0].y_run[111,0]
    v_TR_3_4_lv_c_r = struct[0].y_run[112,0]
    v_TR_3_4_lv_c_i = struct[0].y_run[113,0]
    v_TR_5_6_mv_a_r = struct[0].y_run[114,0]
    v_TR_5_6_mv_a_i = struct[0].y_run[115,0]
    v_TR_5_6_mv_b_r = struct[0].y_run[116,0]
    v_TR_5_6_mv_b_i = struct[0].y_run[117,0]
    v_TR_5_6_mv_c_r = struct[0].y_run[118,0]
    v_TR_5_6_mv_c_i = struct[0].y_run[119,0]
    v_TR_5_6_lv_a_r = struct[0].y_run[120,0]
    v_TR_5_6_lv_a_i = struct[0].y_run[121,0]
    v_TR_5_6_lv_b_r = struct[0].y_run[122,0]
    v_TR_5_6_lv_b_i = struct[0].y_run[123,0]
    v_TR_5_6_lv_c_r = struct[0].y_run[124,0]
    v_TR_5_6_lv_c_i = struct[0].y_run[125,0]
    v_TR_7_8_mv_a_r = struct[0].y_run[126,0]
    v_TR_7_8_mv_a_i = struct[0].y_run[127,0]
    v_TR_7_8_mv_b_r = struct[0].y_run[128,0]
    v_TR_7_8_mv_b_i = struct[0].y_run[129,0]
    v_TR_7_8_mv_c_r = struct[0].y_run[130,0]
    v_TR_7_8_mv_c_i = struct[0].y_run[131,0]
    v_TR_7_8_lv_a_r = struct[0].y_run[132,0]
    v_TR_7_8_lv_a_i = struct[0].y_run[133,0]
    v_TR_7_8_lv_b_r = struct[0].y_run[134,0]
    v_TR_7_8_lv_b_i = struct[0].y_run[135,0]
    v_TR_7_8_lv_c_r = struct[0].y_run[136,0]
    v_TR_7_8_lv_c_i = struct[0].y_run[137,0]
    v_TR_9_10_mv_a_r = struct[0].y_run[138,0]
    v_TR_9_10_mv_a_i = struct[0].y_run[139,0]
    v_TR_9_10_mv_b_r = struct[0].y_run[140,0]
    v_TR_9_10_mv_b_i = struct[0].y_run[141,0]
    v_TR_9_10_mv_c_r = struct[0].y_run[142,0]
    v_TR_9_10_mv_c_i = struct[0].y_run[143,0]
    v_TR_9_10_lv_a_r = struct[0].y_run[144,0]
    v_TR_9_10_lv_a_i = struct[0].y_run[145,0]
    v_TR_9_10_lv_b_r = struct[0].y_run[146,0]
    v_TR_9_10_lv_b_i = struct[0].y_run[147,0]
    v_TR_9_10_lv_c_r = struct[0].y_run[148,0]
    v_TR_9_10_lv_c_i = struct[0].y_run[149,0]
    v_TR_11_12_mv_a_r = struct[0].y_run[150,0]
    v_TR_11_12_mv_a_i = struct[0].y_run[151,0]
    v_TR_11_12_mv_b_r = struct[0].y_run[152,0]
    v_TR_11_12_mv_b_i = struct[0].y_run[153,0]
    v_TR_11_12_mv_c_r = struct[0].y_run[154,0]
    v_TR_11_12_mv_c_i = struct[0].y_run[155,0]
    v_TR_11_12_lv_a_r = struct[0].y_run[156,0]
    v_TR_11_12_lv_a_i = struct[0].y_run[157,0]
    v_TR_11_12_lv_b_r = struct[0].y_run[158,0]
    v_TR_11_12_lv_b_i = struct[0].y_run[159,0]
    v_TR_11_12_lv_c_r = struct[0].y_run[160,0]
    v_TR_11_12_lv_c_i = struct[0].y_run[161,0]
    v_TR_13_mv_a_r = struct[0].y_run[162,0]
    v_TR_13_mv_a_i = struct[0].y_run[163,0]
    v_TR_13_mv_b_r = struct[0].y_run[164,0]
    v_TR_13_mv_b_i = struct[0].y_run[165,0]
    v_TR_13_mv_c_r = struct[0].y_run[166,0]
    v_TR_13_mv_c_i = struct[0].y_run[167,0]
    v_TR_13_lv_a_r = struct[0].y_run[168,0]
    v_TR_13_lv_a_i = struct[0].y_run[169,0]
    v_TR_13_lv_b_r = struct[0].y_run[170,0]
    v_TR_13_lv_b_i = struct[0].y_run[171,0]
    v_TR_13_lv_c_r = struct[0].y_run[172,0]
    v_TR_13_lv_c_i = struct[0].y_run[173,0]
    i_INV_1_a_r = struct[0].y_run[174,0]
    i_INV_1_a_i = struct[0].y_run[175,0]
    i_INV_1_b_r = struct[0].y_run[176,0]
    i_INV_1_b_i = struct[0].y_run[177,0]
    i_INV_1_c_r = struct[0].y_run[178,0]
    i_INV_1_c_i = struct[0].y_run[179,0]
    v_m_INV_1 = struct[0].y_run[180,0]
    v_m_TR_1_2_mv = struct[0].y_run[181,0]
    i_reac_ref_INV_1 = struct[0].y_run[182,0]
    q_ref_INV_1 = struct[0].y_run[183,0]
    i_INV_2_a_r = struct[0].y_run[184,0]
    i_INV_2_a_i = struct[0].y_run[185,0]
    i_INV_2_b_r = struct[0].y_run[186,0]
    i_INV_2_b_i = struct[0].y_run[187,0]
    i_INV_2_c_r = struct[0].y_run[188,0]
    i_INV_2_c_i = struct[0].y_run[189,0]
    v_m_INV_2 = struct[0].y_run[190,0]
    i_reac_ref_INV_2 = struct[0].y_run[191,0]
    q_ref_INV_2 = struct[0].y_run[192,0]
    i_INV_3_a_r = struct[0].y_run[193,0]
    i_INV_3_a_i = struct[0].y_run[194,0]
    i_INV_3_b_r = struct[0].y_run[195,0]
    i_INV_3_b_i = struct[0].y_run[196,0]
    i_INV_3_c_r = struct[0].y_run[197,0]
    i_INV_3_c_i = struct[0].y_run[198,0]
    v_m_INV_3 = struct[0].y_run[199,0]
    v_m_TR_3_4_mv = struct[0].y_run[200,0]
    i_reac_ref_INV_3 = struct[0].y_run[201,0]
    q_ref_INV_3 = struct[0].y_run[202,0]
    i_INV_4_a_r = struct[0].y_run[203,0]
    i_INV_4_a_i = struct[0].y_run[204,0]
    i_INV_4_b_r = struct[0].y_run[205,0]
    i_INV_4_b_i = struct[0].y_run[206,0]
    i_INV_4_c_r = struct[0].y_run[207,0]
    i_INV_4_c_i = struct[0].y_run[208,0]
    v_m_INV_4 = struct[0].y_run[209,0]
    i_reac_ref_INV_4 = struct[0].y_run[210,0]
    q_ref_INV_4 = struct[0].y_run[211,0]
    i_INV_5_a_r = struct[0].y_run[212,0]
    i_INV_5_a_i = struct[0].y_run[213,0]
    i_INV_5_b_r = struct[0].y_run[214,0]
    i_INV_5_b_i = struct[0].y_run[215,0]
    i_INV_5_c_r = struct[0].y_run[216,0]
    i_INV_5_c_i = struct[0].y_run[217,0]
    v_m_INV_5 = struct[0].y_run[218,0]
    v_m_TR_5_6_mv = struct[0].y_run[219,0]
    i_reac_ref_INV_5 = struct[0].y_run[220,0]
    q_ref_INV_5 = struct[0].y_run[221,0]
    i_INV_6_a_r = struct[0].y_run[222,0]
    i_INV_6_a_i = struct[0].y_run[223,0]
    i_INV_6_b_r = struct[0].y_run[224,0]
    i_INV_6_b_i = struct[0].y_run[225,0]
    i_INV_6_c_r = struct[0].y_run[226,0]
    i_INV_6_c_i = struct[0].y_run[227,0]
    v_m_INV_6 = struct[0].y_run[228,0]
    i_reac_ref_INV_6 = struct[0].y_run[229,0]
    q_ref_INV_6 = struct[0].y_run[230,0]
    i_INV_7_a_r = struct[0].y_run[231,0]
    i_INV_7_a_i = struct[0].y_run[232,0]
    i_INV_7_b_r = struct[0].y_run[233,0]
    i_INV_7_b_i = struct[0].y_run[234,0]
    i_INV_7_c_r = struct[0].y_run[235,0]
    i_INV_7_c_i = struct[0].y_run[236,0]
    v_m_INV_7 = struct[0].y_run[237,0]
    v_m_TR_7_8_mv = struct[0].y_run[238,0]
    i_reac_ref_INV_7 = struct[0].y_run[239,0]
    q_ref_INV_7 = struct[0].y_run[240,0]
    i_INV_8_a_r = struct[0].y_run[241,0]
    i_INV_8_a_i = struct[0].y_run[242,0]
    i_INV_8_b_r = struct[0].y_run[243,0]
    i_INV_8_b_i = struct[0].y_run[244,0]
    i_INV_8_c_r = struct[0].y_run[245,0]
    i_INV_8_c_i = struct[0].y_run[246,0]
    v_m_INV_8 = struct[0].y_run[247,0]
    i_reac_ref_INV_8 = struct[0].y_run[248,0]
    q_ref_INV_8 = struct[0].y_run[249,0]
    i_INV_9_a_r = struct[0].y_run[250,0]
    i_INV_9_a_i = struct[0].y_run[251,0]
    i_INV_9_b_r = struct[0].y_run[252,0]
    i_INV_9_b_i = struct[0].y_run[253,0]
    i_INV_9_c_r = struct[0].y_run[254,0]
    i_INV_9_c_i = struct[0].y_run[255,0]
    v_m_INV_9 = struct[0].y_run[256,0]
    v_m_TR_9_10_mv = struct[0].y_run[257,0]
    i_reac_ref_INV_9 = struct[0].y_run[258,0]
    q_ref_INV_9 = struct[0].y_run[259,0]
    i_INV_10_a_r = struct[0].y_run[260,0]
    i_INV_10_a_i = struct[0].y_run[261,0]
    i_INV_10_b_r = struct[0].y_run[262,0]
    i_INV_10_b_i = struct[0].y_run[263,0]
    i_INV_10_c_r = struct[0].y_run[264,0]
    i_INV_10_c_i = struct[0].y_run[265,0]
    v_m_INV_10 = struct[0].y_run[266,0]
    i_reac_ref_INV_10 = struct[0].y_run[267,0]
    q_ref_INV_10 = struct[0].y_run[268,0]
    i_INV_11_a_r = struct[0].y_run[269,0]
    i_INV_11_a_i = struct[0].y_run[270,0]
    i_INV_11_b_r = struct[0].y_run[271,0]
    i_INV_11_b_i = struct[0].y_run[272,0]
    i_INV_11_c_r = struct[0].y_run[273,0]
    i_INV_11_c_i = struct[0].y_run[274,0]
    v_m_INV_11 = struct[0].y_run[275,0]
    v_m_TR_11_12_mv = struct[0].y_run[276,0]
    i_reac_ref_INV_11 = struct[0].y_run[277,0]
    q_ref_INV_11 = struct[0].y_run[278,0]
    i_INV_12_a_r = struct[0].y_run[279,0]
    i_INV_12_a_i = struct[0].y_run[280,0]
    i_INV_12_b_r = struct[0].y_run[281,0]
    i_INV_12_b_i = struct[0].y_run[282,0]
    i_INV_12_c_r = struct[0].y_run[283,0]
    i_INV_12_c_i = struct[0].y_run[284,0]
    v_m_INV_12 = struct[0].y_run[285,0]
    i_reac_ref_INV_12 = struct[0].y_run[286,0]
    q_ref_INV_12 = struct[0].y_run[287,0]
    i_INV_13_a_r = struct[0].y_run[288,0]
    i_INV_13_a_i = struct[0].y_run[289,0]
    i_INV_13_b_r = struct[0].y_run[290,0]
    i_INV_13_b_i = struct[0].y_run[291,0]
    i_INV_13_c_r = struct[0].y_run[292,0]
    i_INV_13_c_i = struct[0].y_run[293,0]
    v_m_INV_13 = struct[0].y_run[294,0]
    v_m_TR_13_mv = struct[0].y_run[295,0]
    i_reac_ref_INV_13 = struct[0].y_run[296,0]
    q_ref_INV_13 = struct[0].y_run[297,0]
    
    # Differential equations:
    if mode == 2:


        struct[0].f[0,0] = (-p_INV_1_a + p_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[1,0] = (-p_INV_1_b + p_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[2,0] = (-p_INV_1_c + p_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[3,0] = (-q_INV_1_a + q_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[4,0] = (-q_INV_1_b + q_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[5,0] = (-q_INV_1_c + q_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[6,0] = (-p_INV_2_a + p_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[7,0] = (-p_INV_2_b + p_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[8,0] = (-p_INV_2_c + p_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[9,0] = (-q_INV_2_a + q_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[10,0] = (-q_INV_2_b + q_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[11,0] = (-q_INV_2_c + q_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[12,0] = (-p_INV_3_a + p_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[13,0] = (-p_INV_3_b + p_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[14,0] = (-p_INV_3_c + p_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[15,0] = (-q_INV_3_a + q_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[16,0] = (-q_INV_3_b + q_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[17,0] = (-q_INV_3_c + q_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[18,0] = (-p_INV_4_a + p_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[19,0] = (-p_INV_4_b + p_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[20,0] = (-p_INV_4_c + p_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[21,0] = (-q_INV_4_a + q_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[22,0] = (-q_INV_4_b + q_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[23,0] = (-q_INV_4_c + q_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[24,0] = (-p_INV_5_a + p_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[25,0] = (-p_INV_5_b + p_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[26,0] = (-p_INV_5_c + p_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[27,0] = (-q_INV_5_a + q_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[28,0] = (-q_INV_5_b + q_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[29,0] = (-q_INV_5_c + q_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[30,0] = (-p_INV_6_a + p_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[31,0] = (-p_INV_6_b + p_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[32,0] = (-p_INV_6_c + p_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[33,0] = (-q_INV_6_a + q_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[34,0] = (-q_INV_6_b + q_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[35,0] = (-q_INV_6_c + q_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[36,0] = (-p_INV_7_a + p_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[37,0] = (-p_INV_7_b + p_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[38,0] = (-p_INV_7_c + p_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[39,0] = (-q_INV_7_a + q_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[40,0] = (-q_INV_7_b + q_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[41,0] = (-q_INV_7_c + q_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[42,0] = (-p_INV_8_a + p_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[43,0] = (-p_INV_8_b + p_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[44,0] = (-p_INV_8_c + p_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[45,0] = (-q_INV_8_a + q_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[46,0] = (-q_INV_8_b + q_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[47,0] = (-q_INV_8_c + q_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[48,0] = (-p_INV_9_a + p_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[49,0] = (-p_INV_9_b + p_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[50,0] = (-p_INV_9_c + p_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[51,0] = (-q_INV_9_a + q_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[52,0] = (-q_INV_9_b + q_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[53,0] = (-q_INV_9_c + q_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[54,0] = (-p_INV_10_a + p_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[55,0] = (-p_INV_10_b + p_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[56,0] = (-p_INV_10_c + p_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[57,0] = (-q_INV_10_a + q_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[58,0] = (-q_INV_10_b + q_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[59,0] = (-q_INV_10_c + q_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[60,0] = (-p_INV_11_a + p_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[61,0] = (-p_INV_11_b + p_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[62,0] = (-p_INV_11_c + p_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[63,0] = (-q_INV_11_a + q_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[64,0] = (-q_INV_11_b + q_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[65,0] = (-q_INV_11_c + q_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[66,0] = (-p_INV_12_a + p_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[67,0] = (-p_INV_12_b + p_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[68,0] = (-p_INV_12_c + p_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[69,0] = (-q_INV_12_a + q_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[70,0] = (-q_INV_12_b + q_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[71,0] = (-q_INV_12_c + q_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[72,0] = (-p_INV_13_a + p_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[73,0] = (-p_INV_13_b + p_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[74,0] = (-p_INV_13_c + p_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[75,0] = (-q_INV_13_a + q_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[76,0] = (-q_INV_13_b + q_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[77,0] = (-q_INV_13_c + q_ref_INV_13/3)/T_pq_INV_13
    
    # Algebraic equations:
    if mode == 3:


        struct[0].g[0,0] = i_INV_1_a_r - 89.5459479864169*v_INV_1_a_i - 172.82391182454*v_INV_1_a_r + 25.5846390702588*v_INV_1_b_i + 49.3782605212972*v_INV_1_b_r + 25.5846390702587*v_INV_1_c_i + 49.3782605212972*v_INV_1_c_r + 89.5460683028705*v_TR_1_2_lv_a_i + 172.82391182454*v_TR_1_2_lv_a_r - 25.5845909436773*v_TR_1_2_lv_b_i - 49.3782605212972*v_TR_1_2_lv_b_r - 25.5845909436773*v_TR_1_2_lv_c_i - 49.3782605212972*v_TR_1_2_lv_c_r
        struct[0].g[1,0] = i_INV_1_a_i - 172.82391182454*v_INV_1_a_i + 89.5459479864169*v_INV_1_a_r + 49.3782605212972*v_INV_1_b_i - 25.5846390702588*v_INV_1_b_r + 49.3782605212972*v_INV_1_c_i - 25.5846390702587*v_INV_1_c_r + 172.82391182454*v_TR_1_2_lv_a_i - 89.5460683028705*v_TR_1_2_lv_a_r - 49.3782605212972*v_TR_1_2_lv_b_i + 25.5845909436773*v_TR_1_2_lv_b_r - 49.3782605212972*v_TR_1_2_lv_c_i + 25.5845909436773*v_TR_1_2_lv_c_r
        struct[0].g[2,0] = i_INV_1_b_r + 25.5846390702587*v_INV_1_a_i + 49.3782605212972*v_INV_1_a_r - 89.5459479864168*v_INV_1_b_i - 172.82391182454*v_INV_1_b_r + 25.5846390702587*v_INV_1_c_i + 49.3782605212973*v_INV_1_c_r - 25.5845909436773*v_TR_1_2_lv_a_i - 49.3782605212972*v_TR_1_2_lv_a_r + 89.5460683028705*v_TR_1_2_lv_b_i + 172.82391182454*v_TR_1_2_lv_b_r - 25.5845909436773*v_TR_1_2_lv_c_i - 49.3782605212973*v_TR_1_2_lv_c_r
        struct[0].g[3,0] = i_INV_1_b_i + 49.3782605212972*v_INV_1_a_i - 25.5846390702587*v_INV_1_a_r - 172.82391182454*v_INV_1_b_i + 89.5459479864168*v_INV_1_b_r + 49.3782605212973*v_INV_1_c_i - 25.5846390702587*v_INV_1_c_r - 49.3782605212972*v_TR_1_2_lv_a_i + 25.5845909436773*v_TR_1_2_lv_a_r + 172.82391182454*v_TR_1_2_lv_b_i - 89.5460683028705*v_TR_1_2_lv_b_r - 49.3782605212973*v_TR_1_2_lv_c_i + 25.5845909436773*v_TR_1_2_lv_c_r
        struct[0].g[4,0] = i_INV_1_c_r + 25.5846390702588*v_INV_1_a_i + 49.3782605212972*v_INV_1_a_r + 25.5846390702587*v_INV_1_b_i + 49.3782605212973*v_INV_1_b_r - 89.5459479864168*v_INV_1_c_i - 172.82391182454*v_INV_1_c_r - 25.5845909436773*v_TR_1_2_lv_a_i - 49.3782605212972*v_TR_1_2_lv_a_r - 25.5845909436772*v_TR_1_2_lv_b_i - 49.3782605212973*v_TR_1_2_lv_b_r + 89.5460683028705*v_TR_1_2_lv_c_i + 172.82391182454*v_TR_1_2_lv_c_r
        struct[0].g[5,0] = i_INV_1_c_i + 49.3782605212972*v_INV_1_a_i - 25.5846390702588*v_INV_1_a_r + 49.3782605212973*v_INV_1_b_i - 25.5846390702587*v_INV_1_b_r - 172.82391182454*v_INV_1_c_i + 89.5459479864168*v_INV_1_c_r - 49.3782605212972*v_TR_1_2_lv_a_i + 25.5845909436773*v_TR_1_2_lv_a_r - 49.3782605212973*v_TR_1_2_lv_b_i + 25.5845909436772*v_TR_1_2_lv_b_r + 172.82391182454*v_TR_1_2_lv_c_i - 89.5460683028705*v_TR_1_2_lv_c_r
        struct[0].g[6,0] = i_INV_2_a_r - 97.8437661123124*v_INV_2_a_i - 188.83868111451*v_INV_2_a_r + 27.9554372523104*v_INV_2_b_i + 53.9539088898601*v_INV_2_b_r + 27.9554372523104*v_INV_2_c_i + 53.9539088898601*v_INV_2_c_r + 97.8438762251349*v_TR_1_2_lv_a_i + 188.83868111451*v_TR_1_2_lv_a_r - 27.9553932071814*v_TR_1_2_lv_b_i - 53.9539088898601*v_TR_1_2_lv_b_r - 27.9553932071814*v_TR_1_2_lv_c_i - 53.9539088898601*v_TR_1_2_lv_c_r
        struct[0].g[7,0] = i_INV_2_a_i - 188.83868111451*v_INV_2_a_i + 97.8437661123124*v_INV_2_a_r + 53.9539088898601*v_INV_2_b_i - 27.9554372523104*v_INV_2_b_r + 53.9539088898601*v_INV_2_c_i - 27.9554372523104*v_INV_2_c_r + 188.83868111451*v_TR_1_2_lv_a_i - 97.8438762251349*v_TR_1_2_lv_a_r - 53.9539088898601*v_TR_1_2_lv_b_i + 27.9553932071814*v_TR_1_2_lv_b_r - 53.9539088898601*v_TR_1_2_lv_c_i + 27.9553932071814*v_TR_1_2_lv_c_r
        struct[0].g[8,0] = i_INV_2_b_r + 27.9554372523104*v_INV_2_a_i + 53.9539088898601*v_INV_2_a_r - 97.8437661123124*v_INV_2_b_i - 188.83868111451*v_INV_2_b_r + 27.9554372523104*v_INV_2_c_i + 53.9539088898602*v_INV_2_c_r - 27.9553932071814*v_TR_1_2_lv_a_i - 53.9539088898601*v_TR_1_2_lv_a_r + 97.8438762251349*v_TR_1_2_lv_b_i + 188.83868111451*v_TR_1_2_lv_b_r - 27.9553932071814*v_TR_1_2_lv_c_i - 53.9539088898602*v_TR_1_2_lv_c_r
        struct[0].g[9,0] = i_INV_2_b_i + 53.9539088898601*v_INV_2_a_i - 27.9554372523104*v_INV_2_a_r - 188.83868111451*v_INV_2_b_i + 97.8437661123124*v_INV_2_b_r + 53.9539088898602*v_INV_2_c_i - 27.9554372523104*v_INV_2_c_r - 53.9539088898601*v_TR_1_2_lv_a_i + 27.9553932071814*v_TR_1_2_lv_a_r + 188.83868111451*v_TR_1_2_lv_b_i - 97.8438762251349*v_TR_1_2_lv_b_r - 53.9539088898602*v_TR_1_2_lv_c_i + 27.9553932071814*v_TR_1_2_lv_c_r
        struct[0].g[10,0] = i_INV_2_c_r + 27.9554372523104*v_INV_2_a_i + 53.9539088898601*v_INV_2_a_r + 27.9554372523103*v_INV_2_b_i + 53.9539088898602*v_INV_2_b_r - 97.8437661123124*v_INV_2_c_i - 188.83868111451*v_INV_2_c_r - 27.9553932071814*v_TR_1_2_lv_a_i - 53.9539088898601*v_TR_1_2_lv_a_r - 27.9553932071813*v_TR_1_2_lv_b_i - 53.9539088898602*v_TR_1_2_lv_b_r + 97.8438762251349*v_TR_1_2_lv_c_i + 188.83868111451*v_TR_1_2_lv_c_r
        struct[0].g[11,0] = i_INV_2_c_i + 53.9539088898601*v_INV_2_a_i - 27.9554372523104*v_INV_2_a_r + 53.9539088898602*v_INV_2_b_i - 27.9554372523103*v_INV_2_b_r - 188.83868111451*v_INV_2_c_i + 97.8437661123124*v_INV_2_c_r - 53.9539088898601*v_TR_1_2_lv_a_i + 27.9553932071814*v_TR_1_2_lv_a_r - 53.9539088898602*v_TR_1_2_lv_b_i + 27.9553932071813*v_TR_1_2_lv_b_r + 188.83868111451*v_TR_1_2_lv_c_i - 97.8438762251349*v_TR_1_2_lv_c_r
        struct[0].g[12,0] = i_INV_3_a_r - 107.758827330392*v_INV_3_a_i - 207.974729711346*v_INV_3_a_r + 30.7883049386397*v_INV_3_b_i + 59.4213513460989*v_INV_3_b_r + 30.7883049386397*v_INV_3_c_i + 59.4213513460989*v_INV_3_c_r + 107.758927311578*v_TR_3_4_lv_a_i + 207.974729711346*v_TR_3_4_lv_a_r - 30.7882649461652*v_TR_3_4_lv_b_i - 59.4213513460989*v_TR_3_4_lv_b_r - 30.7882649461652*v_TR_3_4_lv_c_i - 59.4213513460989*v_TR_3_4_lv_c_r
        struct[0].g[13,0] = i_INV_3_a_i - 207.974729711346*v_INV_3_a_i + 107.758827330392*v_INV_3_a_r + 59.4213513460989*v_INV_3_b_i - 30.7883049386397*v_INV_3_b_r + 59.4213513460989*v_INV_3_c_i - 30.7883049386397*v_INV_3_c_r + 207.974729711346*v_TR_3_4_lv_a_i - 107.758927311578*v_TR_3_4_lv_a_r - 59.4213513460989*v_TR_3_4_lv_b_i + 30.7882649461652*v_TR_3_4_lv_b_r - 59.4213513460989*v_TR_3_4_lv_c_i + 30.7882649461652*v_TR_3_4_lv_c_r
        struct[0].g[14,0] = i_INV_3_b_r + 30.7883049386397*v_INV_3_a_i + 59.4213513460989*v_INV_3_a_r - 107.758827330392*v_INV_3_b_i - 207.974729711346*v_INV_3_b_r + 30.7883049386396*v_INV_3_c_i + 59.421351346099*v_INV_3_c_r - 30.7882649461652*v_TR_3_4_lv_a_i - 59.4213513460989*v_TR_3_4_lv_a_r + 107.758927311578*v_TR_3_4_lv_b_i + 207.974729711346*v_TR_3_4_lv_b_r - 30.7882649461651*v_TR_3_4_lv_c_i - 59.421351346099*v_TR_3_4_lv_c_r
        struct[0].g[15,0] = i_INV_3_b_i + 59.4213513460989*v_INV_3_a_i - 30.7883049386397*v_INV_3_a_r - 207.974729711346*v_INV_3_b_i + 107.758827330392*v_INV_3_b_r + 59.421351346099*v_INV_3_c_i - 30.7883049386396*v_INV_3_c_r - 59.4213513460989*v_TR_3_4_lv_a_i + 30.7882649461652*v_TR_3_4_lv_a_r + 207.974729711346*v_TR_3_4_lv_b_i - 107.758927311578*v_TR_3_4_lv_b_r - 59.421351346099*v_TR_3_4_lv_c_i + 30.7882649461651*v_TR_3_4_lv_c_r
        struct[0].g[16,0] = i_INV_3_c_r + 30.7883049386397*v_INV_3_a_i + 59.4213513460989*v_INV_3_a_r + 30.7883049386396*v_INV_3_b_i + 59.421351346099*v_INV_3_b_r - 107.758827330392*v_INV_3_c_i - 207.974729711346*v_INV_3_c_r - 30.7882649461652*v_TR_3_4_lv_a_i - 59.4213513460989*v_TR_3_4_lv_a_r - 30.7882649461651*v_TR_3_4_lv_b_i - 59.421351346099*v_TR_3_4_lv_b_r + 107.758927311578*v_TR_3_4_lv_c_i + 207.974729711346*v_TR_3_4_lv_c_r
        struct[0].g[17,0] = i_INV_3_c_i + 59.4213513460989*v_INV_3_a_i - 30.7883049386397*v_INV_3_a_r + 59.421351346099*v_INV_3_b_i - 30.7883049386396*v_INV_3_b_r - 207.974729711346*v_INV_3_c_i + 107.758827330392*v_INV_3_c_r - 59.4213513460989*v_TR_3_4_lv_a_i + 30.7882649461652*v_TR_3_4_lv_a_r - 59.421351346099*v_TR_3_4_lv_b_i + 30.7882649461651*v_TR_3_4_lv_b_r + 207.974729711346*v_TR_3_4_lv_c_i - 107.758927311578*v_TR_3_4_lv_c_r
        struct[0].g[18,0] = i_INV_4_a_r - 58.4538966359303*v_INV_4_a_i - 112.816376232042*v_INV_4_a_r + 16.701239710824*v_INV_4_b_i + 32.2332503520119*v_INV_4_b_r + 16.701239710824*v_INV_4_c_i + 32.2332503520119*v_INV_4_c_r + 58.4540809492443*v_TR_3_4_lv_a_i + 112.816376232042*v_TR_3_4_lv_a_r - 16.7011659854984*v_TR_3_4_lv_b_i - 32.2332503520119*v_TR_3_4_lv_b_r - 16.7011659854984*v_TR_3_4_lv_c_i - 32.2332503520119*v_TR_3_4_lv_c_r
        struct[0].g[19,0] = i_INV_4_a_i - 112.816376232042*v_INV_4_a_i + 58.4538966359303*v_INV_4_a_r + 32.2332503520119*v_INV_4_b_i - 16.701239710824*v_INV_4_b_r + 32.2332503520119*v_INV_4_c_i - 16.701239710824*v_INV_4_c_r + 112.816376232042*v_TR_3_4_lv_a_i - 58.4540809492443*v_TR_3_4_lv_a_r - 32.2332503520119*v_TR_3_4_lv_b_i + 16.7011659854984*v_TR_3_4_lv_b_r - 32.2332503520119*v_TR_3_4_lv_c_i + 16.7011659854984*v_TR_3_4_lv_c_r
        struct[0].g[20,0] = i_INV_4_b_r + 16.701239710824*v_INV_4_a_i + 32.2332503520119*v_INV_4_a_r - 58.4538966359303*v_INV_4_b_i - 112.816376232042*v_INV_4_b_r + 16.701239710824*v_INV_4_c_i + 32.2332503520119*v_INV_4_c_r - 16.7011659854984*v_TR_3_4_lv_a_i - 32.2332503520119*v_TR_3_4_lv_a_r + 58.4540809492443*v_TR_3_4_lv_b_i + 112.816376232042*v_TR_3_4_lv_b_r - 16.7011659854984*v_TR_3_4_lv_c_i - 32.2332503520119*v_TR_3_4_lv_c_r
        struct[0].g[21,0] = i_INV_4_b_i + 32.2332503520119*v_INV_4_a_i - 16.701239710824*v_INV_4_a_r - 112.816376232042*v_INV_4_b_i + 58.4538966359303*v_INV_4_b_r + 32.2332503520119*v_INV_4_c_i - 16.701239710824*v_INV_4_c_r - 32.2332503520119*v_TR_3_4_lv_a_i + 16.7011659854984*v_TR_3_4_lv_a_r + 112.816376232042*v_TR_3_4_lv_b_i - 58.4540809492443*v_TR_3_4_lv_b_r - 32.2332503520119*v_TR_3_4_lv_c_i + 16.7011659854984*v_TR_3_4_lv_c_r
        struct[0].g[22,0] = i_INV_4_c_r + 16.701239710824*v_INV_4_a_i + 32.2332503520119*v_INV_4_a_r + 16.7012397108239*v_INV_4_b_i + 32.2332503520119*v_INV_4_b_r - 58.4538966359303*v_INV_4_c_i - 112.816376232042*v_INV_4_c_r - 16.7011659854984*v_TR_3_4_lv_a_i - 32.2332503520119*v_TR_3_4_lv_a_r - 16.7011659854983*v_TR_3_4_lv_b_i - 32.2332503520119*v_TR_3_4_lv_b_r + 58.4540809492443*v_TR_3_4_lv_c_i + 112.816376232042*v_TR_3_4_lv_c_r
        struct[0].g[23,0] = i_INV_4_c_i + 32.2332503520119*v_INV_4_a_i - 16.701239710824*v_INV_4_a_r + 32.2332503520119*v_INV_4_b_i - 16.7012397108239*v_INV_4_b_r - 112.816376232042*v_INV_4_c_i + 58.4538966359303*v_INV_4_c_r - 32.2332503520119*v_TR_3_4_lv_a_i + 16.7011659854984*v_TR_3_4_lv_a_r - 32.2332503520119*v_TR_3_4_lv_b_i + 16.7011659854983*v_TR_3_4_lv_b_r + 112.816376232042*v_TR_3_4_lv_c_i - 58.4540809492443*v_TR_3_4_lv_c_r
        struct[0].g[24,0] = i_INV_5_a_r - 92.6871232662334*v_INV_5_a_i - 178.886372244962*v_INV_5_a_r + 26.4821149256174*v_INV_5_b_i + 51.1103920699891*v_INV_5_b_r + 26.4821149256174*v_INV_5_c_i + 51.1103920699891*v_INV_5_c_r + 92.6872395051616*v_TR_5_6_lv_a_i + 178.886372244962*v_TR_5_6_lv_a_r - 26.4820684300462*v_TR_5_6_lv_b_i - 51.1103920699891*v_TR_5_6_lv_b_r - 26.4820684300462*v_TR_5_6_lv_c_i - 51.1103920699891*v_TR_5_6_lv_c_r
        struct[0].g[25,0] = i_INV_5_a_i - 178.886372244962*v_INV_5_a_i + 92.6871232662334*v_INV_5_a_r + 51.1103920699891*v_INV_5_b_i - 26.4821149256174*v_INV_5_b_r + 51.1103920699891*v_INV_5_c_i - 26.4821149256174*v_INV_5_c_r + 178.886372244962*v_TR_5_6_lv_a_i - 92.6872395051616*v_TR_5_6_lv_a_r - 51.1103920699891*v_TR_5_6_lv_b_i + 26.4820684300462*v_TR_5_6_lv_b_r - 51.1103920699891*v_TR_5_6_lv_c_i + 26.4820684300462*v_TR_5_6_lv_c_r
        struct[0].g[26,0] = i_INV_5_b_r + 26.4821149256174*v_INV_5_a_i + 51.1103920699891*v_INV_5_a_r - 92.6871232662333*v_INV_5_b_i - 178.886372244962*v_INV_5_b_r + 26.4821149256174*v_INV_5_c_i + 51.1103920699892*v_INV_5_c_r - 26.4820684300461*v_TR_5_6_lv_a_i - 51.1103920699891*v_TR_5_6_lv_a_r + 92.6872395051615*v_TR_5_6_lv_b_i + 178.886372244962*v_TR_5_6_lv_b_r - 26.4820684300461*v_TR_5_6_lv_c_i - 51.1103920699892*v_TR_5_6_lv_c_r
        struct[0].g[27,0] = i_INV_5_b_i + 51.1103920699891*v_INV_5_a_i - 26.4821149256174*v_INV_5_a_r - 178.886372244962*v_INV_5_b_i + 92.6871232662333*v_INV_5_b_r + 51.1103920699892*v_INV_5_c_i - 26.4821149256174*v_INV_5_c_r - 51.1103920699891*v_TR_5_6_lv_a_i + 26.4820684300461*v_TR_5_6_lv_a_r + 178.886372244962*v_TR_5_6_lv_b_i - 92.6872395051615*v_TR_5_6_lv_b_r - 51.1103920699892*v_TR_5_6_lv_c_i + 26.4820684300461*v_TR_5_6_lv_c_r
        struct[0].g[28,0] = i_INV_5_c_r + 26.4821149256174*v_INV_5_a_i + 51.1103920699891*v_INV_5_a_r + 26.4821149256174*v_INV_5_b_i + 51.1103920699892*v_INV_5_b_r - 92.6871232662333*v_INV_5_c_i - 178.886372244962*v_INV_5_c_r - 26.4820684300462*v_TR_5_6_lv_a_i - 51.1103920699891*v_TR_5_6_lv_a_r - 26.4820684300461*v_TR_5_6_lv_b_i - 51.1103920699892*v_TR_5_6_lv_b_r + 92.6872395051615*v_TR_5_6_lv_c_i + 178.886372244962*v_TR_5_6_lv_c_r
        struct[0].g[29,0] = i_INV_5_c_i + 51.1103920699891*v_INV_5_a_i - 26.4821149256174*v_INV_5_a_r + 51.1103920699892*v_INV_5_b_i - 26.4821149256174*v_INV_5_b_r - 178.886372244962*v_INV_5_c_i + 92.6871232662333*v_INV_5_c_r - 51.1103920699891*v_TR_5_6_lv_a_i + 26.4820684300462*v_TR_5_6_lv_a_r - 51.1103920699892*v_TR_5_6_lv_b_i + 26.4820684300461*v_TR_5_6_lv_b_r + 178.886372244962*v_TR_5_6_lv_c_i - 92.6872395051615*v_TR_5_6_lv_c_r
        struct[0].g[30,0] = i_INV_6_a_r - 58.4995981119106*v_INV_6_a_i - 112.904579802783*v_INV_6_a_r + 16.714297176654*v_INV_6_b_i + 32.2584513722238*v_INV_6_b_r + 16.714297176654*v_INV_6_c_i + 32.2584513722239*v_INV_6_c_r + 58.4997822812349*v_TR_5_6_lv_a_i + 112.904579802783*v_TR_5_6_lv_a_r - 16.7142235089243*v_TR_5_6_lv_b_i - 32.2584513722238*v_TR_5_6_lv_b_r - 16.7142235089243*v_TR_5_6_lv_c_i - 32.2584513722239*v_TR_5_6_lv_c_r
        struct[0].g[31,0] = i_INV_6_a_i - 112.904579802783*v_INV_6_a_i + 58.4995981119106*v_INV_6_a_r + 32.2584513722238*v_INV_6_b_i - 16.714297176654*v_INV_6_b_r + 32.2584513722239*v_INV_6_c_i - 16.714297176654*v_INV_6_c_r + 112.904579802783*v_TR_5_6_lv_a_i - 58.4997822812349*v_TR_5_6_lv_a_r - 32.2584513722238*v_TR_5_6_lv_b_i + 16.7142235089243*v_TR_5_6_lv_b_r - 32.2584513722239*v_TR_5_6_lv_c_i + 16.7142235089243*v_TR_5_6_lv_c_r
        struct[0].g[32,0] = i_INV_6_b_r + 16.714297176654*v_INV_6_a_i + 32.2584513722238*v_INV_6_a_r - 58.4995981119106*v_INV_6_b_i - 112.904579802783*v_INV_6_b_r + 16.714297176654*v_INV_6_c_i + 32.2584513722239*v_INV_6_c_r - 16.7142235089243*v_TR_5_6_lv_a_i - 32.2584513722238*v_TR_5_6_lv_a_r + 58.4997822812349*v_TR_5_6_lv_b_i + 112.904579802783*v_TR_5_6_lv_b_r - 16.7142235089242*v_TR_5_6_lv_c_i - 32.2584513722239*v_TR_5_6_lv_c_r
        struct[0].g[33,0] = i_INV_6_b_i + 32.2584513722238*v_INV_6_a_i - 16.714297176654*v_INV_6_a_r - 112.904579802783*v_INV_6_b_i + 58.4995981119106*v_INV_6_b_r + 32.2584513722239*v_INV_6_c_i - 16.714297176654*v_INV_6_c_r - 32.2584513722238*v_TR_5_6_lv_a_i + 16.7142235089243*v_TR_5_6_lv_a_r + 112.904579802783*v_TR_5_6_lv_b_i - 58.4997822812349*v_TR_5_6_lv_b_r - 32.2584513722239*v_TR_5_6_lv_c_i + 16.7142235089242*v_TR_5_6_lv_c_r
        struct[0].g[34,0] = i_INV_6_c_r + 16.714297176654*v_INV_6_a_i + 32.2584513722239*v_INV_6_a_r + 16.714297176654*v_INV_6_b_i + 32.2584513722239*v_INV_6_b_r - 58.4995981119106*v_INV_6_c_i - 112.904579802783*v_INV_6_c_r - 16.7142235089243*v_TR_5_6_lv_a_i - 32.2584513722239*v_TR_5_6_lv_a_r - 16.7142235089242*v_TR_5_6_lv_b_i - 32.2584513722239*v_TR_5_6_lv_b_r + 58.4997822812349*v_TR_5_6_lv_c_i + 112.904579802783*v_TR_5_6_lv_c_r
        struct[0].g[35,0] = i_INV_6_c_i + 32.2584513722239*v_INV_6_a_i - 16.714297176654*v_INV_6_a_r + 32.2584513722239*v_INV_6_b_i - 16.714297176654*v_INV_6_b_r - 112.904579802783*v_INV_6_c_i + 58.4995981119106*v_INV_6_c_r - 32.2584513722239*v_TR_5_6_lv_a_i + 16.7142235089243*v_TR_5_6_lv_a_r - 32.2584513722239*v_TR_5_6_lv_b_i + 16.7142235089242*v_TR_5_6_lv_b_r + 112.904579802783*v_TR_5_6_lv_c_i - 58.4997822812349*v_TR_5_6_lv_c_r
        struct[0].g[36,0] = i_INV_7_a_r - 246.057560640311*v_INV_7_a_i - 474.891176542679*v_INV_7_a_r + 70.3021902075957*v_INV_7_b_i + 135.683193297908*v_INV_7_b_r + 70.3021902075957*v_INV_7_c_i + 135.683193297908*v_INV_7_c_r + 246.057604426258*v_TR_7_8_lv_a_i + 474.891176542679*v_TR_7_8_lv_a_r - 70.3021726932167*v_TR_7_8_lv_b_i - 135.683193297908*v_TR_7_8_lv_b_r - 70.3021726932166*v_TR_7_8_lv_c_i - 135.683193297908*v_TR_7_8_lv_c_r
        struct[0].g[37,0] = i_INV_7_a_i - 474.891176542679*v_INV_7_a_i + 246.057560640311*v_INV_7_a_r + 135.683193297908*v_INV_7_b_i - 70.3021902075957*v_INV_7_b_r + 135.683193297908*v_INV_7_c_i - 70.3021902075957*v_INV_7_c_r + 474.891176542679*v_TR_7_8_lv_a_i - 246.057604426258*v_TR_7_8_lv_a_r - 135.683193297908*v_TR_7_8_lv_b_i + 70.3021726932167*v_TR_7_8_lv_b_r - 135.683193297908*v_TR_7_8_lv_c_i + 70.3021726932166*v_TR_7_8_lv_c_r
        struct[0].g[38,0] = i_INV_7_b_r + 70.3021902075957*v_INV_7_a_i + 135.683193297908*v_INV_7_a_r - 246.057560640311*v_INV_7_b_i - 474.891176542679*v_INV_7_b_r + 70.3021902075956*v_INV_7_c_i + 135.683193297909*v_INV_7_c_r - 70.3021726932166*v_TR_7_8_lv_a_i - 135.683193297908*v_TR_7_8_lv_a_r + 246.057604426258*v_TR_7_8_lv_b_i + 474.891176542679*v_TR_7_8_lv_b_r - 70.3021726932165*v_TR_7_8_lv_c_i - 135.683193297909*v_TR_7_8_lv_c_r
        struct[0].g[39,0] = i_INV_7_b_i + 135.683193297908*v_INV_7_a_i - 70.3021902075957*v_INV_7_a_r - 474.891176542679*v_INV_7_b_i + 246.057560640311*v_INV_7_b_r + 135.683193297909*v_INV_7_c_i - 70.3021902075956*v_INV_7_c_r - 135.683193297908*v_TR_7_8_lv_a_i + 70.3021726932166*v_TR_7_8_lv_a_r + 474.891176542679*v_TR_7_8_lv_b_i - 246.057604426258*v_TR_7_8_lv_b_r - 135.683193297909*v_TR_7_8_lv_c_i + 70.3021726932165*v_TR_7_8_lv_c_r
        struct[0].g[40,0] = i_INV_7_c_r + 70.3021902075957*v_INV_7_a_i + 135.683193297908*v_INV_7_a_r + 70.3021902075956*v_INV_7_b_i + 135.683193297909*v_INV_7_b_r - 246.057560640311*v_INV_7_c_i - 474.891176542679*v_INV_7_c_r - 70.3021726932167*v_TR_7_8_lv_a_i - 135.683193297908*v_TR_7_8_lv_a_r - 70.3021726932165*v_TR_7_8_lv_b_i - 135.683193297909*v_TR_7_8_lv_b_r + 246.057604426258*v_TR_7_8_lv_c_i + 474.891176542679*v_TR_7_8_lv_c_r
        struct[0].g[41,0] = i_INV_7_c_i + 135.683193297908*v_INV_7_a_i - 70.3021902075957*v_INV_7_a_r + 135.683193297909*v_INV_7_b_i - 70.3021902075956*v_INV_7_b_r - 474.891176542679*v_INV_7_c_i + 246.057560640311*v_INV_7_c_r - 135.683193297908*v_TR_7_8_lv_a_i + 70.3021726932167*v_TR_7_8_lv_a_r - 135.683193297909*v_TR_7_8_lv_b_i + 70.3021726932165*v_TR_7_8_lv_b_r + 474.891176542679*v_TR_7_8_lv_c_i - 246.057604426258*v_TR_7_8_lv_c_r
        struct[0].g[42,0] = i_INV_8_a_r - 106.794071531051*v_INV_8_a_i - 206.112752761809*v_INV_8_a_r + 30.5126610438848*v_INV_8_b_i + 58.8893579319454*v_INV_8_b_r + 30.5126610438848*v_INV_8_c_i + 58.8893579319454*v_INV_8_c_r + 106.794172415445*v_TR_7_8_lv_a_i + 206.112752761809*v_TR_7_8_lv_a_r - 30.5126206901271*v_TR_7_8_lv_b_i - 58.8893579319454*v_TR_7_8_lv_b_r - 30.5126206901271*v_TR_7_8_lv_c_i - 58.8893579319454*v_TR_7_8_lv_c_r
        struct[0].g[43,0] = i_INV_8_a_i - 206.112752761809*v_INV_8_a_i + 106.794071531051*v_INV_8_a_r + 58.8893579319454*v_INV_8_b_i - 30.5126610438848*v_INV_8_b_r + 58.8893579319454*v_INV_8_c_i - 30.5126610438848*v_INV_8_c_r + 206.112752761809*v_TR_7_8_lv_a_i - 106.794172415445*v_TR_7_8_lv_a_r - 58.8893579319454*v_TR_7_8_lv_b_i + 30.5126206901271*v_TR_7_8_lv_b_r - 58.8893579319454*v_TR_7_8_lv_c_i + 30.5126206901271*v_TR_7_8_lv_c_r
        struct[0].g[44,0] = i_INV_8_b_r + 30.5126610438847*v_INV_8_a_i + 58.8893579319454*v_INV_8_a_r - 106.794071531051*v_INV_8_b_i - 206.112752761809*v_INV_8_b_r + 30.5126610438847*v_INV_8_c_i + 58.8893579319455*v_INV_8_c_r - 30.5126206901271*v_TR_7_8_lv_a_i - 58.8893579319454*v_TR_7_8_lv_a_r + 106.794172415445*v_TR_7_8_lv_b_i + 206.112752761809*v_TR_7_8_lv_b_r - 30.5126206901271*v_TR_7_8_lv_c_i - 58.8893579319455*v_TR_7_8_lv_c_r
        struct[0].g[45,0] = i_INV_8_b_i + 58.8893579319454*v_INV_8_a_i - 30.5126610438847*v_INV_8_a_r - 206.112752761809*v_INV_8_b_i + 106.794071531051*v_INV_8_b_r + 58.8893579319455*v_INV_8_c_i - 30.5126610438847*v_INV_8_c_r - 58.8893579319454*v_TR_7_8_lv_a_i + 30.5126206901271*v_TR_7_8_lv_a_r + 206.112752761809*v_TR_7_8_lv_b_i - 106.794172415445*v_TR_7_8_lv_b_r - 58.8893579319455*v_TR_7_8_lv_c_i + 30.5126206901271*v_TR_7_8_lv_c_r
        struct[0].g[46,0] = i_INV_8_c_r + 30.5126610438848*v_INV_8_a_i + 58.8893579319454*v_INV_8_a_r + 30.5126610438847*v_INV_8_b_i + 58.8893579319455*v_INV_8_b_r - 106.794071531051*v_INV_8_c_i - 206.112752761809*v_INV_8_c_r - 30.5126206901272*v_TR_7_8_lv_a_i - 58.8893579319454*v_TR_7_8_lv_a_r - 30.5126206901271*v_TR_7_8_lv_b_i - 58.8893579319455*v_TR_7_8_lv_b_r + 106.794172415445*v_TR_7_8_lv_c_i + 206.112752761809*v_TR_7_8_lv_c_r
        struct[0].g[47,0] = i_INV_8_c_i + 58.8893579319454*v_INV_8_a_i - 30.5126610438848*v_INV_8_a_r + 58.8893579319455*v_INV_8_b_i - 30.5126610438847*v_INV_8_b_r - 206.112752761809*v_INV_8_c_i + 106.794071531051*v_INV_8_c_r - 58.8893579319454*v_TR_7_8_lv_a_i + 30.5126206901272*v_TR_7_8_lv_a_r - 58.8893579319455*v_TR_7_8_lv_b_i + 30.5126206901271*v_TR_7_8_lv_b_r + 206.112752761809*v_TR_7_8_lv_c_i - 106.794172415445*v_TR_7_8_lv_c_r
        struct[0].g[48,0] = i_INV_9_a_r - 98.1763901476198*v_INV_9_a_i - 189.48064478264*v_INV_9_a_r + 28.0504724351543*v_INV_9_b_i + 54.1373270807543*v_INV_9_b_r + 28.0504724351542*v_INV_9_c_i + 54.1373270807543*v_INV_9_c_r + 98.1764998873781*v_TR_9_10_lv_a_i + 189.48064478264*v_TR_9_10_lv_a_r - 28.0504285392509*v_TR_9_10_lv_b_i - 54.1373270807543*v_TR_9_10_lv_b_r - 28.0504285392509*v_TR_9_10_lv_c_i - 54.1373270807543*v_TR_9_10_lv_c_r
        struct[0].g[49,0] = i_INV_9_a_i - 189.48064478264*v_INV_9_a_i + 98.1763901476198*v_INV_9_a_r + 54.1373270807543*v_INV_9_b_i - 28.0504724351543*v_INV_9_b_r + 54.1373270807543*v_INV_9_c_i - 28.0504724351542*v_INV_9_c_r + 189.48064478264*v_TR_9_10_lv_a_i - 98.1764998873781*v_TR_9_10_lv_a_r - 54.1373270807543*v_TR_9_10_lv_b_i + 28.0504285392509*v_TR_9_10_lv_b_r - 54.1373270807543*v_TR_9_10_lv_c_i + 28.0504285392509*v_TR_9_10_lv_c_r
        struct[0].g[50,0] = i_INV_9_b_r + 28.0504724351542*v_INV_9_a_i + 54.1373270807543*v_INV_9_a_r - 98.1763901476198*v_INV_9_b_i - 189.48064478264*v_INV_9_b_r + 28.0504724351542*v_INV_9_c_i + 54.1373270807544*v_INV_9_c_r - 28.0504285392509*v_TR_9_10_lv_a_i - 54.1373270807543*v_TR_9_10_lv_a_r + 98.1764998873781*v_TR_9_10_lv_b_i + 189.48064478264*v_TR_9_10_lv_b_r - 28.0504285392509*v_TR_9_10_lv_c_i - 54.1373270807544*v_TR_9_10_lv_c_r
        struct[0].g[51,0] = i_INV_9_b_i + 54.1373270807543*v_INV_9_a_i - 28.0504724351542*v_INV_9_a_r - 189.48064478264*v_INV_9_b_i + 98.1763901476198*v_INV_9_b_r + 54.1373270807544*v_INV_9_c_i - 28.0504724351542*v_INV_9_c_r - 54.1373270807543*v_TR_9_10_lv_a_i + 28.0504285392509*v_TR_9_10_lv_a_r + 189.48064478264*v_TR_9_10_lv_b_i - 98.1764998873781*v_TR_9_10_lv_b_r - 54.1373270807544*v_TR_9_10_lv_c_i + 28.0504285392509*v_TR_9_10_lv_c_r
        struct[0].g[52,0] = i_INV_9_c_r + 28.0504724351543*v_INV_9_a_i + 54.1373270807543*v_INV_9_a_r + 28.0504724351542*v_INV_9_b_i + 54.1373270807543*v_INV_9_b_r - 98.1763901476198*v_INV_9_c_i - 189.48064478264*v_INV_9_c_r - 28.0504285392509*v_TR_9_10_lv_a_i - 54.1373270807543*v_TR_9_10_lv_a_r - 28.0504285392509*v_TR_9_10_lv_b_i - 54.1373270807543*v_TR_9_10_lv_b_r + 98.1764998873781*v_TR_9_10_lv_c_i + 189.48064478264*v_TR_9_10_lv_c_r
        struct[0].g[53,0] = i_INV_9_c_i + 54.1373270807543*v_INV_9_a_i - 28.0504724351543*v_INV_9_a_r + 54.1373270807543*v_INV_9_b_i - 28.0504724351542*v_INV_9_b_r - 189.48064478264*v_INV_9_c_i + 98.1763901476198*v_INV_9_c_r - 54.1373270807543*v_TR_9_10_lv_a_i + 28.0504285392509*v_TR_9_10_lv_a_r - 54.1373270807543*v_TR_9_10_lv_b_i + 28.0504285392509*v_TR_9_10_lv_b_r + 189.48064478264*v_TR_9_10_lv_c_i - 98.1764998873781*v_TR_9_10_lv_c_r
        struct[0].g[54,0] = i_INV_10_a_r - 75.8057696238346*v_INV_10_a_i - 146.305409673982*v_INV_10_a_r + 21.6588887777877*v_INV_10_b_i + 41.8015456211378*v_INV_10_b_r + 21.6588887777877*v_INV_10_c_i + 41.8015456211378*v_INV_10_c_r + 75.8059117481773*v_TR_9_10_lv_a_i + 146.305409673982*v_TR_9_10_lv_a_r - 21.6588319280506*v_TR_9_10_lv_b_i - 41.8015456211378*v_TR_9_10_lv_b_r - 21.6588319280506*v_TR_9_10_lv_c_i - 41.8015456211378*v_TR_9_10_lv_c_r
        struct[0].g[55,0] = i_INV_10_a_i - 146.305409673982*v_INV_10_a_i + 75.8057696238346*v_INV_10_a_r + 41.8015456211378*v_INV_10_b_i - 21.6588887777877*v_INV_10_b_r + 41.8015456211378*v_INV_10_c_i - 21.6588887777877*v_INV_10_c_r + 146.305409673982*v_TR_9_10_lv_a_i - 75.8059117481773*v_TR_9_10_lv_a_r - 41.8015456211378*v_TR_9_10_lv_b_i + 21.6588319280506*v_TR_9_10_lv_b_r - 41.8015456211378*v_TR_9_10_lv_c_i + 21.6588319280506*v_TR_9_10_lv_c_r
        struct[0].g[56,0] = i_INV_10_b_r + 21.6588887777877*v_INV_10_a_i + 41.8015456211377*v_INV_10_a_r - 75.8057696238346*v_INV_10_b_i - 146.305409673982*v_INV_10_b_r + 21.6588887777877*v_INV_10_c_i + 41.8015456211378*v_INV_10_c_r - 21.6588319280506*v_TR_9_10_lv_a_i - 41.8015456211377*v_TR_9_10_lv_a_r + 75.8059117481773*v_TR_9_10_lv_b_i + 146.305409673982*v_TR_9_10_lv_b_r - 21.6588319280506*v_TR_9_10_lv_c_i - 41.8015456211378*v_TR_9_10_lv_c_r
        struct[0].g[57,0] = i_INV_10_b_i + 41.8015456211377*v_INV_10_a_i - 21.6588887777877*v_INV_10_a_r - 146.305409673982*v_INV_10_b_i + 75.8057696238346*v_INV_10_b_r + 41.8015456211378*v_INV_10_c_i - 21.6588887777877*v_INV_10_c_r - 41.8015456211377*v_TR_9_10_lv_a_i + 21.6588319280506*v_TR_9_10_lv_a_r + 146.305409673982*v_TR_9_10_lv_b_i - 75.8059117481773*v_TR_9_10_lv_b_r - 41.8015456211378*v_TR_9_10_lv_c_i + 21.6588319280506*v_TR_9_10_lv_c_r
        struct[0].g[58,0] = i_INV_10_c_r + 21.6588887777877*v_INV_10_a_i + 41.8015456211378*v_INV_10_a_r + 21.6588887777877*v_INV_10_b_i + 41.8015456211378*v_INV_10_b_r - 75.8057696238346*v_INV_10_c_i - 146.305409673982*v_INV_10_c_r - 21.6588319280506*v_TR_9_10_lv_a_i - 41.8015456211378*v_TR_9_10_lv_a_r - 21.6588319280506*v_TR_9_10_lv_b_i - 41.8015456211378*v_TR_9_10_lv_b_r + 75.8059117481773*v_TR_9_10_lv_c_i + 146.305409673982*v_TR_9_10_lv_c_r
        struct[0].g[59,0] = i_INV_10_c_i + 41.8015456211378*v_INV_10_a_i - 21.6588887777877*v_INV_10_a_r + 41.8015456211378*v_INV_10_b_i - 21.6588887777877*v_INV_10_b_r - 146.305409673982*v_INV_10_c_i + 75.8057696238346*v_INV_10_c_r - 41.8015456211378*v_TR_9_10_lv_a_i + 21.6588319280506*v_TR_9_10_lv_a_r - 41.8015456211378*v_TR_9_10_lv_b_i + 21.6588319280506*v_TR_9_10_lv_b_r + 146.305409673982*v_TR_9_10_lv_c_i - 75.8059117481773*v_TR_9_10_lv_c_r
        struct[0].g[60,0] = i_INV_11_a_r - 81.5760299591651*v_INV_11_a_i - 157.441992718694*v_INV_11_a_r + 23.3075276943302*v_INV_11_b_i + 44.9834264910554*v_INV_11_b_r + 23.3075276943302*v_INV_11_c_i + 44.9834264910554*v_INV_11_c_r + 81.5761620304113*v_TR_11_12_lv_a_i + 157.441992718694*v_TR_11_12_lv_a_r - 23.3074748658318*v_TR_11_12_lv_b_i - 44.9834264910554*v_TR_11_12_lv_b_r - 23.3074748658318*v_TR_11_12_lv_c_i - 44.9834264910554*v_TR_11_12_lv_c_r
        struct[0].g[61,0] = i_INV_11_a_i - 157.441992718694*v_INV_11_a_i + 81.5760299591651*v_INV_11_a_r + 44.9834264910554*v_INV_11_b_i - 23.3075276943302*v_INV_11_b_r + 44.9834264910554*v_INV_11_c_i - 23.3075276943302*v_INV_11_c_r + 157.441992718694*v_TR_11_12_lv_a_i - 81.5761620304113*v_TR_11_12_lv_a_r - 44.9834264910554*v_TR_11_12_lv_b_i + 23.3074748658318*v_TR_11_12_lv_b_r - 44.9834264910554*v_TR_11_12_lv_c_i + 23.3074748658318*v_TR_11_12_lv_c_r
        struct[0].g[62,0] = i_INV_11_b_r + 23.3075276943302*v_INV_11_a_i + 44.9834264910554*v_INV_11_a_r - 81.5760299591651*v_INV_11_b_i - 157.441992718694*v_INV_11_b_r + 23.3075276943302*v_INV_11_c_i + 44.9834264910555*v_INV_11_c_r - 23.3074748658318*v_TR_11_12_lv_a_i - 44.9834264910554*v_TR_11_12_lv_a_r + 81.5761620304112*v_TR_11_12_lv_b_i + 157.441992718694*v_TR_11_12_lv_b_r - 23.3074748658317*v_TR_11_12_lv_c_i - 44.9834264910555*v_TR_11_12_lv_c_r
        struct[0].g[63,0] = i_INV_11_b_i + 44.9834264910554*v_INV_11_a_i - 23.3075276943302*v_INV_11_a_r - 157.441992718694*v_INV_11_b_i + 81.5760299591651*v_INV_11_b_r + 44.9834264910555*v_INV_11_c_i - 23.3075276943302*v_INV_11_c_r - 44.9834264910554*v_TR_11_12_lv_a_i + 23.3074748658318*v_TR_11_12_lv_a_r + 157.441992718694*v_TR_11_12_lv_b_i - 81.5761620304112*v_TR_11_12_lv_b_r - 44.9834264910555*v_TR_11_12_lv_c_i + 23.3074748658317*v_TR_11_12_lv_c_r
        struct[0].g[64,0] = i_INV_11_c_r + 23.3075276943302*v_INV_11_a_i + 44.9834264910554*v_INV_11_a_r + 23.3075276943302*v_INV_11_b_i + 44.9834264910554*v_INV_11_b_r - 81.5760299591651*v_INV_11_c_i - 157.441992718694*v_INV_11_c_r - 23.3074748658318*v_TR_11_12_lv_a_i - 44.9834264910554*v_TR_11_12_lv_a_r - 23.3074748658317*v_TR_11_12_lv_b_i - 44.9834264910554*v_TR_11_12_lv_b_r + 81.5761620304112*v_TR_11_12_lv_c_i + 157.441992718694*v_TR_11_12_lv_c_r
        struct[0].g[65,0] = i_INV_11_c_i + 44.9834264910554*v_INV_11_a_i - 23.3075276943302*v_INV_11_a_r + 44.9834264910554*v_INV_11_b_i - 23.3075276943302*v_INV_11_b_r - 157.441992718694*v_INV_11_c_i + 81.5760299591651*v_INV_11_c_r - 44.9834264910554*v_TR_11_12_lv_a_i + 23.3074748658318*v_TR_11_12_lv_a_r - 44.9834264910554*v_TR_11_12_lv_b_i + 23.3074748658317*v_TR_11_12_lv_b_r + 157.441992718694*v_TR_11_12_lv_c_i - 81.5761620304112*v_TR_11_12_lv_c_r
        struct[0].g[66,0] = i_INV_12_a_r - 107.907168174067*v_INV_12_a_i - 208.26102727437*v_INV_12_a_r + 30.8306879425848*v_INV_12_b_i + 59.5031506498201*v_INV_12_b_r + 30.8306879425848*v_INV_12_c_i + 59.5031506498201*v_INV_12_c_r + 107.907268017809*v_TR_11_12_lv_a_i + 208.26102727437*v_TR_11_12_lv_a_r - 30.8306480050881*v_TR_11_12_lv_b_i - 59.5031506498201*v_TR_11_12_lv_b_r - 30.8306480050881*v_TR_11_12_lv_c_i - 59.5031506498201*v_TR_11_12_lv_c_r
        struct[0].g[67,0] = i_INV_12_a_i - 208.26102727437*v_INV_12_a_i + 107.907168174067*v_INV_12_a_r + 59.5031506498201*v_INV_12_b_i - 30.8306879425848*v_INV_12_b_r + 59.5031506498201*v_INV_12_c_i - 30.8306879425848*v_INV_12_c_r + 208.26102727437*v_TR_11_12_lv_a_i - 107.907268017809*v_TR_11_12_lv_a_r - 59.5031506498201*v_TR_11_12_lv_b_i + 30.8306480050881*v_TR_11_12_lv_b_r - 59.5031506498201*v_TR_11_12_lv_c_i + 30.8306480050881*v_TR_11_12_lv_c_r
        struct[0].g[68,0] = i_INV_12_b_r + 30.8306879425848*v_INV_12_a_i + 59.5031506498201*v_INV_12_a_r - 107.907168174067*v_INV_12_b_i - 208.261027274371*v_INV_12_b_r + 30.8306879425847*v_INV_12_c_i + 59.5031506498202*v_INV_12_c_r - 30.8306480050881*v_TR_11_12_lv_a_i - 59.5031506498201*v_TR_11_12_lv_a_r + 107.907268017808*v_TR_11_12_lv_b_i + 208.261027274371*v_TR_11_12_lv_b_r - 30.8306480050881*v_TR_11_12_lv_c_i - 59.5031506498202*v_TR_11_12_lv_c_r
        struct[0].g[69,0] = i_INV_12_b_i + 59.5031506498201*v_INV_12_a_i - 30.8306879425848*v_INV_12_a_r - 208.261027274371*v_INV_12_b_i + 107.907168174067*v_INV_12_b_r + 59.5031506498202*v_INV_12_c_i - 30.8306879425847*v_INV_12_c_r - 59.5031506498201*v_TR_11_12_lv_a_i + 30.8306480050881*v_TR_11_12_lv_a_r + 208.261027274371*v_TR_11_12_lv_b_i - 107.907268017808*v_TR_11_12_lv_b_r - 59.5031506498202*v_TR_11_12_lv_c_i + 30.8306480050881*v_TR_11_12_lv_c_r
        struct[0].g[70,0] = i_INV_12_c_r + 30.8306879425848*v_INV_12_a_i + 59.5031506498201*v_INV_12_a_r + 30.8306879425847*v_INV_12_b_i + 59.5031506498202*v_INV_12_b_r - 107.907168174067*v_INV_12_c_i - 208.261027274371*v_INV_12_c_r - 30.8306480050882*v_TR_11_12_lv_a_i - 59.5031506498201*v_TR_11_12_lv_a_r - 30.8306480050881*v_TR_11_12_lv_b_i - 59.5031506498202*v_TR_11_12_lv_b_r + 107.907268017808*v_TR_11_12_lv_c_i + 208.261027274371*v_TR_11_12_lv_c_r
        struct[0].g[71,0] = i_INV_12_c_i + 59.5031506498201*v_INV_12_a_i - 30.8306879425848*v_INV_12_a_r + 59.5031506498202*v_INV_12_b_i - 30.8306879425847*v_INV_12_b_r - 208.261027274371*v_INV_12_c_i + 107.907168174067*v_INV_12_c_r - 59.5031506498201*v_TR_11_12_lv_a_i + 30.8306480050882*v_TR_11_12_lv_a_r - 59.5031506498202*v_TR_11_12_lv_b_i + 30.8306480050881*v_TR_11_12_lv_b_r + 208.261027274371*v_TR_11_12_lv_c_i - 107.907268017808*v_TR_11_12_lv_c_r
        struct[0].g[72,0] = i_INV_13_a_r - 225.77493151679*v_INV_13_a_i - 435.745709926008*v_INV_13_a_r + 64.5071560124429*v_INV_13_b_i + 124.498774264574*v_INV_13_b_r + 64.5071560124428*v_INV_13_c_i + 124.498774264574*v_INV_13_c_r + 225.774979236273*v_TR_13_lv_a_i + 435.745709926008*v_TR_13_lv_a_r - 64.5071369246495*v_TR_13_lv_b_i - 124.498774264574*v_TR_13_lv_b_r - 64.5071369246495*v_TR_13_lv_c_i - 124.498774264574*v_TR_13_lv_c_r
        struct[0].g[73,0] = i_INV_13_a_i - 435.745709926008*v_INV_13_a_i + 225.77493151679*v_INV_13_a_r + 124.498774264574*v_INV_13_b_i - 64.5071560124429*v_INV_13_b_r + 124.498774264574*v_INV_13_c_i - 64.5071560124428*v_INV_13_c_r + 435.745709926008*v_TR_13_lv_a_i - 225.774979236273*v_TR_13_lv_a_r - 124.498774264574*v_TR_13_lv_b_i + 64.5071369246495*v_TR_13_lv_b_r - 124.498774264574*v_TR_13_lv_c_i + 64.5071369246495*v_TR_13_lv_c_r
        struct[0].g[74,0] = i_INV_13_b_r + 64.5071560124428*v_INV_13_a_i + 124.498774264574*v_INV_13_a_r - 225.77493151679*v_INV_13_b_i - 435.745709926008*v_INV_13_b_r + 64.5071560124428*v_INV_13_c_i + 124.498774264574*v_INV_13_c_r - 64.5071369246495*v_TR_13_lv_a_i - 124.498774264574*v_TR_13_lv_a_r + 225.774979236273*v_TR_13_lv_b_i + 435.745709926008*v_TR_13_lv_b_r - 64.5071369246494*v_TR_13_lv_c_i - 124.498774264574*v_TR_13_lv_c_r
        struct[0].g[75,0] = i_INV_13_b_i + 124.498774264574*v_INV_13_a_i - 64.5071560124428*v_INV_13_a_r - 435.745709926008*v_INV_13_b_i + 225.77493151679*v_INV_13_b_r + 124.498774264574*v_INV_13_c_i - 64.5071560124428*v_INV_13_c_r - 124.498774264574*v_TR_13_lv_a_i + 64.5071369246495*v_TR_13_lv_a_r + 435.745709926008*v_TR_13_lv_b_i - 225.774979236273*v_TR_13_lv_b_r - 124.498774264574*v_TR_13_lv_c_i + 64.5071369246494*v_TR_13_lv_c_r
        struct[0].g[76,0] = i_INV_13_c_r + 64.5071560124429*v_INV_13_a_i + 124.498774264574*v_INV_13_a_r + 64.5071560124428*v_INV_13_b_i + 124.498774264574*v_INV_13_b_r - 225.77493151679*v_INV_13_c_i - 435.745709926008*v_INV_13_c_r - 64.5071369246495*v_TR_13_lv_a_i - 124.498774264574*v_TR_13_lv_a_r - 64.5071369246494*v_TR_13_lv_b_i - 124.498774264574*v_TR_13_lv_b_r + 225.774979236273*v_TR_13_lv_c_i + 435.745709926008*v_TR_13_lv_c_r
        struct[0].g[77,0] = i_INV_13_c_i + 124.498774264574*v_INV_13_a_i - 64.5071560124429*v_INV_13_a_r + 124.498774264574*v_INV_13_b_i - 64.5071560124428*v_INV_13_b_r - 435.745709926008*v_INV_13_c_i + 225.77493151679*v_INV_13_c_r - 124.498774264574*v_TR_13_lv_a_i + 64.5071369246495*v_TR_13_lv_a_r - 124.498774264574*v_TR_13_lv_b_i + 64.5071369246494*v_TR_13_lv_b_r + 435.745709926008*v_TR_13_lv_c_i - 225.774979236273*v_TR_13_lv_c_r
        struct[0].g[78,0] = i_POIhv_a_r + 0.040290088638195*v_GRID_a_i + 0.024174053182917*v_GRID_a_r + 4.66248501556824e-18*v_GRID_b_i - 4.31760362252812e-18*v_GRID_b_r + 4.19816664496737e-18*v_GRID_c_i - 3.49608108880335e-18*v_GRID_c_r - 0.0647773858527649*v_POIhv_a_i - 0.0272349653347382*v_POIhv_a_r + 0.012243648607285*v_POIhv_b_i + 0.00153045607591063*v_POIhv_b_r + 0.012243648607285*v_POIhv_c_i + 0.00153045607591062*v_POIhv_c_r + 0.0699818508108637*v_POImv_a_i + 0.00874773135135797*v_POImv_a_r - 0.0699818508108637*v_POImv_b_i - 0.00874773135135797*v_POImv_b_r
        struct[0].g[79,0] = i_POIhv_a_i + 0.024174053182917*v_GRID_a_i - 0.040290088638195*v_GRID_a_r - 4.31760362252812e-18*v_GRID_b_i - 4.66248501556824e-18*v_GRID_b_r - 3.49608108880335e-18*v_GRID_c_i - 4.19816664496737e-18*v_GRID_c_r - 0.0272349653347382*v_POIhv_a_i + 0.0647773858527649*v_POIhv_a_r + 0.00153045607591063*v_POIhv_b_i - 0.012243648607285*v_POIhv_b_r + 0.00153045607591062*v_POIhv_c_i - 0.012243648607285*v_POIhv_c_r + 0.00874773135135797*v_POImv_a_i - 0.0699818508108637*v_POImv_a_r - 0.00874773135135797*v_POImv_b_i + 0.0699818508108637*v_POImv_b_r
        struct[0].g[80,0] = i_POIhv_b_r + 6.30775359573304e-19*v_GRID_a_i - 2.07254761002657e-18*v_GRID_a_r + 0.040290088638195*v_GRID_b_i + 0.024174053182917*v_GRID_b_r + 9.01107656533306e-19*v_GRID_c_i - 1.78419315993592e-17*v_GRID_c_r + 0.012243648607285*v_POIhv_a_i + 0.00153045607591062*v_POIhv_a_r - 0.0647773858527649*v_POIhv_b_i - 0.0272349653347383*v_POIhv_b_r + 0.012243648607285*v_POIhv_c_i + 0.00153045607591064*v_POIhv_c_r + 0.0699818508108637*v_POImv_b_i + 0.00874773135135797*v_POImv_b_r - 0.0699818508108637*v_POImv_c_i - 0.00874773135135797*v_POImv_c_r
        struct[0].g[81,0] = i_POIhv_b_i - 2.07254761002657e-18*v_GRID_a_i - 6.30775359573304e-19*v_GRID_a_r + 0.024174053182917*v_GRID_b_i - 0.040290088638195*v_GRID_b_r - 1.78419315993592e-17*v_GRID_c_i - 9.01107656533306e-19*v_GRID_c_r + 0.00153045607591062*v_POIhv_a_i - 0.012243648607285*v_POIhv_a_r - 0.0272349653347383*v_POIhv_b_i + 0.0647773858527649*v_POIhv_b_r + 0.00153045607591064*v_POIhv_c_i - 0.012243648607285*v_POIhv_c_r + 0.00874773135135797*v_POImv_b_i - 0.0699818508108637*v_POImv_b_r - 0.00874773135135797*v_POImv_c_i + 0.0699818508108637*v_POImv_c_r
        struct[0].g[82,0] = i_POIhv_c_r - 7.20886125226632e-19*v_GRID_a_i - 1.35166148479994e-18*v_GRID_a_r - 4.50553828266631e-19*v_GRID_b_i - 1.71210454741325e-17*v_GRID_b_r + 0.040290088638195*v_GRID_c_i + 0.024174053182917*v_GRID_c_r + 0.012243648607285*v_POIhv_a_i + 0.00153045607591062*v_POIhv_a_r + 0.012243648607285*v_POIhv_b_i + 0.00153045607591064*v_POIhv_b_r - 0.0647773858527649*v_POIhv_c_i - 0.0272349653347383*v_POIhv_c_r - 0.0699818508108637*v_POImv_a_i - 0.00874773135135797*v_POImv_a_r + 0.0699818508108637*v_POImv_c_i + 0.00874773135135797*v_POImv_c_r
        struct[0].g[83,0] = i_POIhv_c_i - 1.35166148479994e-18*v_GRID_a_i + 7.20886125226632e-19*v_GRID_a_r - 1.71210454741325e-17*v_GRID_b_i + 4.50553828266631e-19*v_GRID_b_r + 0.024174053182917*v_GRID_c_i - 0.040290088638195*v_GRID_c_r + 0.00153045607591062*v_POIhv_a_i - 0.012243648607285*v_POIhv_a_r + 0.00153045607591064*v_POIhv_b_i - 0.012243648607285*v_POIhv_b_r - 0.0272349653347383*v_POIhv_c_i + 0.0647773858527649*v_POIhv_c_r - 0.00874773135135797*v_POImv_a_i + 0.0699818508108637*v_POImv_a_r + 0.00874773135135797*v_POImv_c_i - 0.0699818508108637*v_POImv_c_r
        struct[0].g[84,0] = i_POImv_a_r + 0.0699818508108637*v_POIhv_a_i + 0.00874773135135797*v_POIhv_a_r - 0.0699818508108637*v_POIhv_c_i - 0.00874773135135797*v_POIhv_c_r - 33.4156859296188*v_POImv_a_i - 24.8222322123875*v_POImv_a_r + 9.4330989270973*v_POImv_b_i + 7.0643874892536*v_POImv_b_r + 9.4330989270973*v_POImv_c_i + 7.0643874892536*v_POImv_c_r + 24.3777365097524*v_TR_1_2_mv_a_i + 18.2833023823143*v_TR_1_2_mv_a_r - 6.96506757421497*v_TR_1_2_mv_b_i - 5.22380068066123*v_TR_1_2_mv_b_r - 6.96506757421497*v_TR_1_2_mv_c_i - 5.22380068066123*v_TR_1_2_mv_c_r + 8.63801621787545*v_TR_5_6_mv_a_i + 6.47851216340659*v_TR_5_6_mv_a_r - 2.4680046336787*v_TR_5_6_mv_b_i - 1.85100347525903*v_TR_5_6_mv_b_r - 2.4680046336787*v_TR_5_6_mv_c_i - 1.85100347525903*v_TR_5_6_mv_c_r
        struct[0].g[85,0] = i_POImv_a_i + 0.00874773135135797*v_POIhv_a_i - 0.0699818508108637*v_POIhv_a_r - 0.00874773135135797*v_POIhv_c_i + 0.0699818508108637*v_POIhv_c_r - 24.8222322123875*v_POImv_a_i + 33.4156859296188*v_POImv_a_r + 7.0643874892536*v_POImv_b_i - 9.4330989270973*v_POImv_b_r + 7.0643874892536*v_POImv_c_i - 9.4330989270973*v_POImv_c_r + 18.2833023823143*v_TR_1_2_mv_a_i - 24.3777365097524*v_TR_1_2_mv_a_r - 5.22380068066123*v_TR_1_2_mv_b_i + 6.96506757421497*v_TR_1_2_mv_b_r - 5.22380068066123*v_TR_1_2_mv_c_i + 6.96506757421497*v_TR_1_2_mv_c_r + 6.47851216340659*v_TR_5_6_mv_a_i - 8.63801621787545*v_TR_5_6_mv_a_r - 1.85100347525903*v_TR_5_6_mv_b_i + 2.4680046336787*v_TR_5_6_mv_b_r - 1.85100347525903*v_TR_5_6_mv_c_i + 2.4680046336787*v_TR_5_6_mv_c_r
        struct[0].g[86,0] = i_POImv_b_r - 0.0699818508108637*v_POIhv_a_i - 0.00874773135135797*v_POIhv_a_r + 0.0699818508108637*v_POIhv_b_i + 0.00874773135135797*v_POIhv_b_r + 9.4330989270973*v_POImv_a_i + 7.0643874892536*v_POImv_a_r - 33.4156859296188*v_POImv_b_i - 24.8222322123876*v_POImv_b_r + 9.4330989270973*v_POImv_c_i + 7.06438748925361*v_POImv_c_r - 6.96506757421497*v_TR_1_2_mv_a_i - 5.22380068066123*v_TR_1_2_mv_a_r + 24.3777365097524*v_TR_1_2_mv_b_i + 18.2833023823143*v_TR_1_2_mv_b_r - 6.96506757421497*v_TR_1_2_mv_c_i - 5.22380068066124*v_TR_1_2_mv_c_r - 2.4680046336787*v_TR_5_6_mv_a_i - 1.85100347525903*v_TR_5_6_mv_a_r + 8.63801621787545*v_TR_5_6_mv_b_i + 6.47851216340659*v_TR_5_6_mv_b_r - 2.4680046336787*v_TR_5_6_mv_c_i - 1.85100347525903*v_TR_5_6_mv_c_r
        struct[0].g[87,0] = i_POImv_b_i - 0.00874773135135797*v_POIhv_a_i + 0.0699818508108637*v_POIhv_a_r + 0.00874773135135797*v_POIhv_b_i - 0.0699818508108637*v_POIhv_b_r + 7.0643874892536*v_POImv_a_i - 9.4330989270973*v_POImv_a_r - 24.8222322123876*v_POImv_b_i + 33.4156859296188*v_POImv_b_r + 7.06438748925361*v_POImv_c_i - 9.4330989270973*v_POImv_c_r - 5.22380068066123*v_TR_1_2_mv_a_i + 6.96506757421497*v_TR_1_2_mv_a_r + 18.2833023823143*v_TR_1_2_mv_b_i - 24.3777365097524*v_TR_1_2_mv_b_r - 5.22380068066124*v_TR_1_2_mv_c_i + 6.96506757421497*v_TR_1_2_mv_c_r - 1.85100347525903*v_TR_5_6_mv_a_i + 2.4680046336787*v_TR_5_6_mv_a_r + 6.47851216340659*v_TR_5_6_mv_b_i - 8.63801621787545*v_TR_5_6_mv_b_r - 1.85100347525903*v_TR_5_6_mv_c_i + 2.4680046336787*v_TR_5_6_mv_c_r
        struct[0].g[88,0] = i_POImv_c_r - 0.0699818508108637*v_POIhv_b_i - 0.00874773135135797*v_POIhv_b_r + 0.0699818508108637*v_POIhv_c_i + 0.00874773135135797*v_POIhv_c_r + 9.4330989270973*v_POImv_a_i + 7.06438748925359*v_POImv_a_r + 9.4330989270973*v_POImv_b_i + 7.06438748925361*v_POImv_b_r - 33.4156859296188*v_POImv_c_i - 24.8222322123876*v_POImv_c_r - 6.96506757421497*v_TR_1_2_mv_a_i - 5.22380068066123*v_TR_1_2_mv_a_r - 6.96506757421497*v_TR_1_2_mv_b_i - 5.22380068066124*v_TR_1_2_mv_b_r + 24.3777365097524*v_TR_1_2_mv_c_i + 18.2833023823143*v_TR_1_2_mv_c_r - 2.4680046336787*v_TR_5_6_mv_a_i - 1.85100347525903*v_TR_5_6_mv_a_r - 2.4680046336787*v_TR_5_6_mv_b_i - 1.85100347525903*v_TR_5_6_mv_b_r + 8.63801621787545*v_TR_5_6_mv_c_i + 6.47851216340659*v_TR_5_6_mv_c_r
        struct[0].g[89,0] = i_POImv_c_i - 0.00874773135135797*v_POIhv_b_i + 0.0699818508108637*v_POIhv_b_r + 0.00874773135135797*v_POIhv_c_i - 0.0699818508108637*v_POIhv_c_r + 7.06438748925359*v_POImv_a_i - 9.4330989270973*v_POImv_a_r + 7.06438748925361*v_POImv_b_i - 9.4330989270973*v_POImv_b_r - 24.8222322123876*v_POImv_c_i + 33.4156859296188*v_POImv_c_r - 5.22380068066123*v_TR_1_2_mv_a_i + 6.96506757421497*v_TR_1_2_mv_a_r - 5.22380068066124*v_TR_1_2_mv_b_i + 6.96506757421497*v_TR_1_2_mv_b_r + 18.2833023823143*v_TR_1_2_mv_c_i - 24.3777365097524*v_TR_1_2_mv_c_r - 1.85100347525903*v_TR_5_6_mv_a_i + 2.4680046336787*v_TR_5_6_mv_a_r - 1.85100347525903*v_TR_5_6_mv_b_i + 2.4680046336787*v_TR_5_6_mv_b_r + 6.47851216340659*v_TR_5_6_mv_c_i - 8.63801621787545*v_TR_5_6_mv_c_r
        struct[0].g[90,0] = i_TR_1_2_mv_a_r + 24.3777365097524*v_POImv_a_i + 18.2833023823143*v_POImv_a_r - 6.96506757421497*v_POImv_b_i - 5.22380068066123*v_POImv_b_r - 6.96506757421497*v_POImv_c_i - 5.22380068066123*v_POImv_c_r + 2.3406091994174*v_TR_1_2_lv_a_i + 0.390101533236234*v_TR_1_2_lv_a_r - 2.3406091994174*v_TR_1_2_lv_b_i - 0.390101533236234*v_TR_1_2_lv_b_r - 52.7347843860809*v_TR_1_2_mv_a_i - 39.5195811550486*v_TR_1_2_mv_a_r + 15.0786865705954*v_TR_1_2_mv_b_i + 11.293239403373*v_TR_1_2_mv_b_r + 15.0786865705954*v_TR_1_2_mv_c_i + 11.293239403373*v_TR_1_2_mv_c_r + 28.3030263516338*v_TR_3_4_mv_a_i + 21.2272697637253*v_TR_3_4_mv_a_r - 8.08657895760964*v_TR_3_4_mv_b_i - 6.06493421820724*v_TR_3_4_mv_b_r - 8.08657895760964*v_TR_3_4_mv_c_i - 6.06493421820724*v_TR_3_4_mv_c_r
        struct[0].g[91,0] = i_TR_1_2_mv_a_i + 18.2833023823143*v_POImv_a_i - 24.3777365097524*v_POImv_a_r - 5.22380068066123*v_POImv_b_i + 6.96506757421497*v_POImv_b_r - 5.22380068066123*v_POImv_c_i + 6.96506757421497*v_POImv_c_r + 0.390101533236234*v_TR_1_2_lv_a_i - 2.3406091994174*v_TR_1_2_lv_a_r - 0.390101533236234*v_TR_1_2_lv_b_i + 2.3406091994174*v_TR_1_2_lv_b_r - 39.5195811550486*v_TR_1_2_mv_a_i + 52.7347843860809*v_TR_1_2_mv_a_r + 11.293239403373*v_TR_1_2_mv_b_i - 15.0786865705954*v_TR_1_2_mv_b_r + 11.293239403373*v_TR_1_2_mv_c_i - 15.0786865705954*v_TR_1_2_mv_c_r + 21.2272697637253*v_TR_3_4_mv_a_i - 28.3030263516338*v_TR_3_4_mv_a_r - 6.06493421820724*v_TR_3_4_mv_b_i + 8.08657895760964*v_TR_3_4_mv_b_r - 6.06493421820724*v_TR_3_4_mv_c_i + 8.08657895760964*v_TR_3_4_mv_c_r
        struct[0].g[92,0] = i_TR_1_2_mv_b_r - 6.96506757421497*v_POImv_a_i - 5.22380068066123*v_POImv_a_r + 24.3777365097524*v_POImv_b_i + 18.2833023823143*v_POImv_b_r - 6.96506757421497*v_POImv_c_i - 5.22380068066124*v_POImv_c_r + 2.3406091994174*v_TR_1_2_lv_b_i + 0.390101533236234*v_TR_1_2_lv_b_r - 2.3406091994174*v_TR_1_2_lv_c_i - 0.390101533236234*v_TR_1_2_lv_c_r + 15.0786865705954*v_TR_1_2_mv_a_i + 11.293239403373*v_TR_1_2_mv_a_r - 52.7347843860809*v_TR_1_2_mv_b_i - 39.5195811550487*v_TR_1_2_mv_b_r + 15.0786865705954*v_TR_1_2_mv_c_i + 11.293239403373*v_TR_1_2_mv_c_r - 8.08657895760964*v_TR_3_4_mv_a_i - 6.06493421820724*v_TR_3_4_mv_a_r + 28.3030263516338*v_TR_3_4_mv_b_i + 21.2272697637253*v_TR_3_4_mv_b_r - 8.08657895760965*v_TR_3_4_mv_c_i - 6.06493421820725*v_TR_3_4_mv_c_r
        struct[0].g[93,0] = i_TR_1_2_mv_b_i - 5.22380068066123*v_POImv_a_i + 6.96506757421497*v_POImv_a_r + 18.2833023823143*v_POImv_b_i - 24.3777365097524*v_POImv_b_r - 5.22380068066124*v_POImv_c_i + 6.96506757421497*v_POImv_c_r + 0.390101533236234*v_TR_1_2_lv_b_i - 2.3406091994174*v_TR_1_2_lv_b_r - 0.390101533236234*v_TR_1_2_lv_c_i + 2.3406091994174*v_TR_1_2_lv_c_r + 11.293239403373*v_TR_1_2_mv_a_i - 15.0786865705954*v_TR_1_2_mv_a_r - 39.5195811550487*v_TR_1_2_mv_b_i + 52.7347843860809*v_TR_1_2_mv_b_r + 11.293239403373*v_TR_1_2_mv_c_i - 15.0786865705954*v_TR_1_2_mv_c_r - 6.06493421820724*v_TR_3_4_mv_a_i + 8.08657895760964*v_TR_3_4_mv_a_r + 21.2272697637253*v_TR_3_4_mv_b_i - 28.3030263516338*v_TR_3_4_mv_b_r - 6.06493421820725*v_TR_3_4_mv_c_i + 8.08657895760965*v_TR_3_4_mv_c_r
        struct[0].g[94,0] = i_TR_1_2_mv_c_r - 6.96506757421497*v_POImv_a_i - 5.22380068066123*v_POImv_a_r - 6.96506757421497*v_POImv_b_i - 5.22380068066124*v_POImv_b_r + 24.3777365097524*v_POImv_c_i + 18.2833023823143*v_POImv_c_r - 2.3406091994174*v_TR_1_2_lv_a_i - 0.390101533236234*v_TR_1_2_lv_a_r + 2.3406091994174*v_TR_1_2_lv_c_i + 0.390101533236234*v_TR_1_2_lv_c_r + 15.0786865705954*v_TR_1_2_mv_a_i + 11.293239403373*v_TR_1_2_mv_a_r + 15.0786865705954*v_TR_1_2_mv_b_i + 11.293239403373*v_TR_1_2_mv_b_r - 52.7347843860809*v_TR_1_2_mv_c_i - 39.5195811550487*v_TR_1_2_mv_c_r - 8.08657895760965*v_TR_3_4_mv_a_i - 6.06493421820724*v_TR_3_4_mv_a_r - 8.08657895760964*v_TR_3_4_mv_b_i - 6.06493421820725*v_TR_3_4_mv_b_r + 28.3030263516338*v_TR_3_4_mv_c_i + 21.2272697637253*v_TR_3_4_mv_c_r
        struct[0].g[95,0] = i_TR_1_2_mv_c_i - 5.22380068066123*v_POImv_a_i + 6.96506757421497*v_POImv_a_r - 5.22380068066124*v_POImv_b_i + 6.96506757421497*v_POImv_b_r + 18.2833023823143*v_POImv_c_i - 24.3777365097524*v_POImv_c_r - 0.390101533236234*v_TR_1_2_lv_a_i + 2.3406091994174*v_TR_1_2_lv_a_r + 0.390101533236234*v_TR_1_2_lv_c_i - 2.3406091994174*v_TR_1_2_lv_c_r + 11.293239403373*v_TR_1_2_mv_a_i - 15.0786865705954*v_TR_1_2_mv_a_r + 11.293239403373*v_TR_1_2_mv_b_i - 15.0786865705954*v_TR_1_2_mv_b_r - 39.5195811550487*v_TR_1_2_mv_c_i + 52.7347843860809*v_TR_1_2_mv_c_r - 6.06493421820724*v_TR_3_4_mv_a_i + 8.08657895760965*v_TR_3_4_mv_a_r - 6.06493421820725*v_TR_3_4_mv_b_i + 8.08657895760964*v_TR_3_4_mv_b_r + 21.2272697637253*v_TR_3_4_mv_c_i - 28.3030263516338*v_TR_3_4_mv_c_r
        struct[0].g[96,0] = i_TR_1_2_lv_a_r + 89.5460683028705*v_INV_1_a_i + 172.82391182454*v_INV_1_a_r - 25.5845909436773*v_INV_1_b_i - 49.3782605212972*v_INV_1_b_r - 25.5845909436773*v_INV_1_c_i - 49.3782605212972*v_INV_1_c_r + 97.8438762251349*v_INV_2_a_i + 188.83868111451*v_INV_2_a_r - 27.9553932071814*v_INV_2_b_i - 53.9539088898601*v_INV_2_b_r - 27.9553932071814*v_INV_2_c_i - 53.9539088898601*v_INV_2_c_r - 390.092416801432*v_TR_1_2_lv_a_i - 395.446376722834*v_TR_1_2_lv_a_r + 53.5400763225691*v_TR_1_2_lv_b_i + 103.332169411157*v_TR_1_2_lv_b_r + 53.5400763225691*v_TR_1_2_lv_c_i + 103.332169411157*v_TR_1_2_lv_c_r + 2.3406091994174*v_TR_1_2_mv_a_i + 0.390101533236234*v_TR_1_2_mv_a_r - 2.3406091994174*v_TR_1_2_mv_c_i - 0.390101533236234*v_TR_1_2_mv_c_r
        struct[0].g[97,0] = i_TR_1_2_lv_a_i + 172.82391182454*v_INV_1_a_i - 89.5460683028705*v_INV_1_a_r - 49.3782605212972*v_INV_1_b_i + 25.5845909436773*v_INV_1_b_r - 49.3782605212972*v_INV_1_c_i + 25.5845909436773*v_INV_1_c_r + 188.83868111451*v_INV_2_a_i - 97.8438762251349*v_INV_2_a_r - 53.9539088898601*v_INV_2_b_i + 27.9553932071814*v_INV_2_b_r - 53.9539088898601*v_INV_2_c_i + 27.9553932071814*v_INV_2_c_r - 395.446376722834*v_TR_1_2_lv_a_i + 390.092416801432*v_TR_1_2_lv_a_r + 103.332169411157*v_TR_1_2_lv_b_i - 53.5400763225691*v_TR_1_2_lv_b_r + 103.332169411157*v_TR_1_2_lv_c_i - 53.5400763225691*v_TR_1_2_lv_c_r + 0.390101533236234*v_TR_1_2_mv_a_i - 2.3406091994174*v_TR_1_2_mv_a_r - 0.390101533236234*v_TR_1_2_mv_c_i + 2.3406091994174*v_TR_1_2_mv_c_r
        struct[0].g[98,0] = i_TR_1_2_lv_b_r - 25.5845909436773*v_INV_1_a_i - 49.3782605212972*v_INV_1_a_r + 89.5460683028705*v_INV_1_b_i + 172.82391182454*v_INV_1_b_r - 25.5845909436773*v_INV_1_c_i - 49.3782605212973*v_INV_1_c_r - 27.9553932071814*v_INV_2_a_i - 53.9539088898601*v_INV_2_a_r + 97.8438762251349*v_INV_2_b_i + 188.83868111451*v_INV_2_b_r - 27.9553932071814*v_INV_2_c_i - 53.9539088898602*v_INV_2_c_r + 53.5400763225691*v_TR_1_2_lv_a_i + 103.332169411157*v_TR_1_2_lv_a_r - 390.092416801432*v_TR_1_2_lv_b_i - 395.446376722835*v_TR_1_2_lv_b_r + 53.5400763225691*v_TR_1_2_lv_c_i + 103.332169411157*v_TR_1_2_lv_c_r - 2.3406091994174*v_TR_1_2_mv_a_i - 0.390101533236234*v_TR_1_2_mv_a_r + 2.3406091994174*v_TR_1_2_mv_b_i + 0.390101533236234*v_TR_1_2_mv_b_r
        struct[0].g[99,0] = i_TR_1_2_lv_b_i - 49.3782605212972*v_INV_1_a_i + 25.5845909436773*v_INV_1_a_r + 172.82391182454*v_INV_1_b_i - 89.5460683028705*v_INV_1_b_r - 49.3782605212973*v_INV_1_c_i + 25.5845909436773*v_INV_1_c_r - 53.9539088898601*v_INV_2_a_i + 27.9553932071814*v_INV_2_a_r + 188.83868111451*v_INV_2_b_i - 97.8438762251349*v_INV_2_b_r - 53.9539088898602*v_INV_2_c_i + 27.9553932071814*v_INV_2_c_r + 103.332169411157*v_TR_1_2_lv_a_i - 53.5400763225691*v_TR_1_2_lv_a_r - 395.446376722835*v_TR_1_2_lv_b_i + 390.092416801432*v_TR_1_2_lv_b_r + 103.332169411157*v_TR_1_2_lv_c_i - 53.5400763225691*v_TR_1_2_lv_c_r - 0.390101533236234*v_TR_1_2_mv_a_i + 2.3406091994174*v_TR_1_2_mv_a_r + 0.390101533236234*v_TR_1_2_mv_b_i - 2.3406091994174*v_TR_1_2_mv_b_r
        struct[0].g[100,0] = i_TR_1_2_lv_c_r - 25.5845909436773*v_INV_1_a_i - 49.3782605212972*v_INV_1_a_r - 25.5845909436772*v_INV_1_b_i - 49.3782605212973*v_INV_1_b_r + 89.5460683028705*v_INV_1_c_i + 172.82391182454*v_INV_1_c_r - 27.9553932071814*v_INV_2_a_i - 53.9539088898601*v_INV_2_a_r - 27.9553932071813*v_INV_2_b_i - 53.9539088898602*v_INV_2_b_r + 97.8438762251349*v_INV_2_c_i + 188.83868111451*v_INV_2_c_r + 53.5400763225692*v_TR_1_2_lv_a_i + 103.332169411157*v_TR_1_2_lv_a_r + 53.5400763225691*v_TR_1_2_lv_b_i + 103.332169411157*v_TR_1_2_lv_b_r - 390.092416801432*v_TR_1_2_lv_c_i - 395.446376722835*v_TR_1_2_lv_c_r - 2.3406091994174*v_TR_1_2_mv_b_i - 0.390101533236234*v_TR_1_2_mv_b_r + 2.3406091994174*v_TR_1_2_mv_c_i + 0.390101533236234*v_TR_1_2_mv_c_r
        struct[0].g[101,0] = i_TR_1_2_lv_c_i - 49.3782605212972*v_INV_1_a_i + 25.5845909436773*v_INV_1_a_r - 49.3782605212973*v_INV_1_b_i + 25.5845909436772*v_INV_1_b_r + 172.82391182454*v_INV_1_c_i - 89.5460683028705*v_INV_1_c_r - 53.9539088898601*v_INV_2_a_i + 27.9553932071814*v_INV_2_a_r - 53.9539088898602*v_INV_2_b_i + 27.9553932071813*v_INV_2_b_r + 188.83868111451*v_INV_2_c_i - 97.8438762251349*v_INV_2_c_r + 103.332169411157*v_TR_1_2_lv_a_i - 53.5400763225692*v_TR_1_2_lv_a_r + 103.332169411157*v_TR_1_2_lv_b_i - 53.5400763225691*v_TR_1_2_lv_b_r - 395.446376722835*v_TR_1_2_lv_c_i + 390.092416801432*v_TR_1_2_lv_c_r - 0.390101533236234*v_TR_1_2_mv_b_i + 2.3406091994174*v_TR_1_2_mv_b_r + 0.390101533236234*v_TR_1_2_mv_c_i - 2.3406091994174*v_TR_1_2_mv_c_r
        struct[0].g[102,0] = i_TR_3_4_mv_a_r + 28.3030263516338*v_TR_1_2_mv_a_i + 21.2272697637253*v_TR_1_2_mv_a_r - 8.08657895760964*v_TR_1_2_mv_b_i - 6.06493421820724*v_TR_1_2_mv_b_r - 8.08657895760964*v_TR_1_2_mv_c_i - 6.06493421820724*v_TR_1_2_mv_c_r + 2.3406091994174*v_TR_3_4_lv_a_i + 0.390101533236234*v_TR_3_4_lv_a_r - 2.3406091994174*v_TR_3_4_lv_b_i - 0.390101533236234*v_TR_3_4_lv_b_r - 43.3991164322381*v_TR_3_4_mv_a_i - 41.678054303702*v_TR_3_4_mv_a_r + 12.4113478527151*v_TR_3_4_mv_b_i + 11.9099460172739*v_TR_3_4_mv_b_r + 12.4113478527151*v_TR_3_4_mv_c_i + 11.9099460172739*v_TR_3_4_mv_c_r + 15.0420612397687*v_TR_7_8_mv_a_i + 20.4417755309677*v_TR_7_8_mv_a_r - 4.29773178279105*v_TR_7_8_mv_b_i - 5.8405072945622*v_TR_7_8_mv_b_r - 4.29773178279104*v_TR_7_8_mv_c_i - 5.84050729456219*v_TR_7_8_mv_c_r
        struct[0].g[103,0] = i_TR_3_4_mv_a_i + 21.2272697637253*v_TR_1_2_mv_a_i - 28.3030263516338*v_TR_1_2_mv_a_r - 6.06493421820724*v_TR_1_2_mv_b_i + 8.08657895760964*v_TR_1_2_mv_b_r - 6.06493421820724*v_TR_1_2_mv_c_i + 8.08657895760964*v_TR_1_2_mv_c_r + 0.390101533236234*v_TR_3_4_lv_a_i - 2.3406091994174*v_TR_3_4_lv_a_r - 0.390101533236234*v_TR_3_4_lv_b_i + 2.3406091994174*v_TR_3_4_lv_b_r - 41.678054303702*v_TR_3_4_mv_a_i + 43.3991164322381*v_TR_3_4_mv_a_r + 11.9099460172739*v_TR_3_4_mv_b_i - 12.4113478527151*v_TR_3_4_mv_b_r + 11.9099460172739*v_TR_3_4_mv_c_i - 12.4113478527151*v_TR_3_4_mv_c_r + 20.4417755309677*v_TR_7_8_mv_a_i - 15.0420612397687*v_TR_7_8_mv_a_r - 5.8405072945622*v_TR_7_8_mv_b_i + 4.29773178279105*v_TR_7_8_mv_b_r - 5.84050729456219*v_TR_7_8_mv_c_i + 4.29773178279104*v_TR_7_8_mv_c_r
        struct[0].g[104,0] = i_TR_3_4_mv_b_r - 8.08657895760964*v_TR_1_2_mv_a_i - 6.06493421820724*v_TR_1_2_mv_a_r + 28.3030263516338*v_TR_1_2_mv_b_i + 21.2272697637253*v_TR_1_2_mv_b_r - 8.08657895760965*v_TR_1_2_mv_c_i - 6.06493421820725*v_TR_1_2_mv_c_r + 2.3406091994174*v_TR_3_4_lv_b_i + 0.390101533236234*v_TR_3_4_lv_b_r - 2.3406091994174*v_TR_3_4_lv_c_i - 0.390101533236234*v_TR_3_4_lv_c_r + 12.4113478527151*v_TR_3_4_mv_a_i + 11.9099460172739*v_TR_3_4_mv_a_r - 43.3991164322381*v_TR_3_4_mv_b_i - 41.678054303702*v_TR_3_4_mv_b_r + 12.4113478527151*v_TR_3_4_mv_c_i + 11.909946017274*v_TR_3_4_mv_c_r - 4.29773178279105*v_TR_7_8_mv_a_i - 5.8405072945622*v_TR_7_8_mv_a_r + 15.0420612397687*v_TR_7_8_mv_b_i + 20.4417755309677*v_TR_7_8_mv_b_r - 4.29773178279105*v_TR_7_8_mv_c_i - 5.8405072945622*v_TR_7_8_mv_c_r
        struct[0].g[105,0] = i_TR_3_4_mv_b_i - 6.06493421820724*v_TR_1_2_mv_a_i + 8.08657895760964*v_TR_1_2_mv_a_r + 21.2272697637253*v_TR_1_2_mv_b_i - 28.3030263516338*v_TR_1_2_mv_b_r - 6.06493421820725*v_TR_1_2_mv_c_i + 8.08657895760965*v_TR_1_2_mv_c_r + 0.390101533236234*v_TR_3_4_lv_b_i - 2.3406091994174*v_TR_3_4_lv_b_r - 0.390101533236234*v_TR_3_4_lv_c_i + 2.3406091994174*v_TR_3_4_lv_c_r + 11.9099460172739*v_TR_3_4_mv_a_i - 12.4113478527151*v_TR_3_4_mv_a_r - 41.678054303702*v_TR_3_4_mv_b_i + 43.3991164322381*v_TR_3_4_mv_b_r + 11.909946017274*v_TR_3_4_mv_c_i - 12.4113478527151*v_TR_3_4_mv_c_r - 5.8405072945622*v_TR_7_8_mv_a_i + 4.29773178279105*v_TR_7_8_mv_a_r + 20.4417755309677*v_TR_7_8_mv_b_i - 15.0420612397687*v_TR_7_8_mv_b_r - 5.8405072945622*v_TR_7_8_mv_c_i + 4.29773178279105*v_TR_7_8_mv_c_r
        struct[0].g[106,0] = i_TR_3_4_mv_c_r - 8.08657895760965*v_TR_1_2_mv_a_i - 6.06493421820724*v_TR_1_2_mv_a_r - 8.08657895760964*v_TR_1_2_mv_b_i - 6.06493421820725*v_TR_1_2_mv_b_r + 28.3030263516338*v_TR_1_2_mv_c_i + 21.2272697637253*v_TR_1_2_mv_c_r - 2.3406091994174*v_TR_3_4_lv_a_i - 0.390101533236234*v_TR_3_4_lv_a_r + 2.3406091994174*v_TR_3_4_lv_c_i + 0.390101533236234*v_TR_3_4_lv_c_r + 12.4113478527151*v_TR_3_4_mv_a_i + 11.9099460172739*v_TR_3_4_mv_a_r + 12.4113478527151*v_TR_3_4_mv_b_i + 11.909946017274*v_TR_3_4_mv_b_r - 43.3991164322381*v_TR_3_4_mv_c_i - 41.678054303702*v_TR_3_4_mv_c_r - 4.29773178279105*v_TR_7_8_mv_a_i - 5.84050729456219*v_TR_7_8_mv_a_r - 4.29773178279104*v_TR_7_8_mv_b_i - 5.84050729456221*v_TR_7_8_mv_b_r + 15.0420612397687*v_TR_7_8_mv_c_i + 20.4417755309677*v_TR_7_8_mv_c_r
        struct[0].g[107,0] = i_TR_3_4_mv_c_i - 6.06493421820724*v_TR_1_2_mv_a_i + 8.08657895760965*v_TR_1_2_mv_a_r - 6.06493421820725*v_TR_1_2_mv_b_i + 8.08657895760964*v_TR_1_2_mv_b_r + 21.2272697637253*v_TR_1_2_mv_c_i - 28.3030263516338*v_TR_1_2_mv_c_r - 0.390101533236234*v_TR_3_4_lv_a_i + 2.3406091994174*v_TR_3_4_lv_a_r + 0.390101533236234*v_TR_3_4_lv_c_i - 2.3406091994174*v_TR_3_4_lv_c_r + 11.9099460172739*v_TR_3_4_mv_a_i - 12.4113478527151*v_TR_3_4_mv_a_r + 11.909946017274*v_TR_3_4_mv_b_i - 12.4113478527151*v_TR_3_4_mv_b_r - 41.678054303702*v_TR_3_4_mv_c_i + 43.3991164322381*v_TR_3_4_mv_c_r - 5.84050729456219*v_TR_7_8_mv_a_i + 4.29773178279105*v_TR_7_8_mv_a_r - 5.84050729456221*v_TR_7_8_mv_b_i + 4.29773178279104*v_TR_7_8_mv_b_r + 20.4417755309677*v_TR_7_8_mv_c_i - 15.0420612397687*v_TR_7_8_mv_c_r
        struct[0].g[108,0] = i_TR_3_4_lv_a_r + 107.758927311578*v_INV_3_a_i + 207.974729711346*v_INV_3_a_r - 30.7882649461652*v_INV_3_b_i - 59.4213513460989*v_INV_3_b_r - 30.7882649461652*v_INV_3_c_i - 59.4213513460989*v_INV_3_c_r + 58.4540809492443*v_INV_4_a_i + 112.816376232042*v_INV_4_a_r - 16.7011659854984*v_INV_4_b_i - 32.2332503520119*v_INV_4_b_r - 16.7011659854984*v_INV_4_c_i - 32.2332503520119*v_INV_4_c_r - 368.915426669025*v_TR_3_4_lv_a_i - 354.574889727171*v_TR_3_4_lv_a_r + 47.4895446494637*v_TR_3_4_lv_b_i + 91.6546016981108*v_TR_3_4_lv_b_r + 47.4895446494637*v_TR_3_4_lv_c_i + 91.6546016981108*v_TR_3_4_lv_c_r + 2.3406091994174*v_TR_3_4_mv_a_i + 0.390101533236234*v_TR_3_4_mv_a_r - 2.3406091994174*v_TR_3_4_mv_c_i - 0.390101533236234*v_TR_3_4_mv_c_r
        struct[0].g[109,0] = i_TR_3_4_lv_a_i + 207.974729711346*v_INV_3_a_i - 107.758927311578*v_INV_3_a_r - 59.4213513460989*v_INV_3_b_i + 30.7882649461652*v_INV_3_b_r - 59.4213513460989*v_INV_3_c_i + 30.7882649461652*v_INV_3_c_r + 112.816376232042*v_INV_4_a_i - 58.4540809492443*v_INV_4_a_r - 32.2332503520119*v_INV_4_b_i + 16.7011659854984*v_INV_4_b_r - 32.2332503520119*v_INV_4_c_i + 16.7011659854984*v_INV_4_c_r - 354.574889727171*v_TR_3_4_lv_a_i + 368.915426669025*v_TR_3_4_lv_a_r + 91.6546016981108*v_TR_3_4_lv_b_i - 47.4895446494637*v_TR_3_4_lv_b_r + 91.6546016981108*v_TR_3_4_lv_c_i - 47.4895446494637*v_TR_3_4_lv_c_r + 0.390101533236234*v_TR_3_4_mv_a_i - 2.3406091994174*v_TR_3_4_mv_a_r - 0.390101533236234*v_TR_3_4_mv_c_i + 2.3406091994174*v_TR_3_4_mv_c_r
        struct[0].g[110,0] = i_TR_3_4_lv_b_r - 30.7882649461652*v_INV_3_a_i - 59.4213513460989*v_INV_3_a_r + 107.758927311578*v_INV_3_b_i + 207.974729711346*v_INV_3_b_r - 30.7882649461651*v_INV_3_c_i - 59.421351346099*v_INV_3_c_r - 16.7011659854984*v_INV_4_a_i - 32.2332503520119*v_INV_4_a_r + 58.4540809492443*v_INV_4_b_i + 112.816376232042*v_INV_4_b_r - 16.7011659854984*v_INV_4_c_i - 32.2332503520119*v_INV_4_c_r + 47.4895446494636*v_TR_3_4_lv_a_i + 91.6546016981107*v_TR_3_4_lv_a_r - 368.915426669025*v_TR_3_4_lv_b_i - 354.574889727172*v_TR_3_4_lv_b_r + 47.4895446494636*v_TR_3_4_lv_c_i + 91.6546016981109*v_TR_3_4_lv_c_r - 2.3406091994174*v_TR_3_4_mv_a_i - 0.390101533236234*v_TR_3_4_mv_a_r + 2.3406091994174*v_TR_3_4_mv_b_i + 0.390101533236234*v_TR_3_4_mv_b_r
        struct[0].g[111,0] = i_TR_3_4_lv_b_i - 59.4213513460989*v_INV_3_a_i + 30.7882649461652*v_INV_3_a_r + 207.974729711346*v_INV_3_b_i - 107.758927311578*v_INV_3_b_r - 59.421351346099*v_INV_3_c_i + 30.7882649461651*v_INV_3_c_r - 32.2332503520119*v_INV_4_a_i + 16.7011659854984*v_INV_4_a_r + 112.816376232042*v_INV_4_b_i - 58.4540809492443*v_INV_4_b_r - 32.2332503520119*v_INV_4_c_i + 16.7011659854984*v_INV_4_c_r + 91.6546016981107*v_TR_3_4_lv_a_i - 47.4895446494636*v_TR_3_4_lv_a_r - 354.574889727172*v_TR_3_4_lv_b_i + 368.915426669025*v_TR_3_4_lv_b_r + 91.6546016981109*v_TR_3_4_lv_c_i - 47.4895446494636*v_TR_3_4_lv_c_r - 0.390101533236234*v_TR_3_4_mv_a_i + 2.3406091994174*v_TR_3_4_mv_a_r + 0.390101533236234*v_TR_3_4_mv_b_i - 2.3406091994174*v_TR_3_4_mv_b_r
        struct[0].g[112,0] = i_TR_3_4_lv_c_r - 30.7882649461652*v_INV_3_a_i - 59.4213513460989*v_INV_3_a_r - 30.7882649461651*v_INV_3_b_i - 59.421351346099*v_INV_3_b_r + 107.758927311578*v_INV_3_c_i + 207.974729711346*v_INV_3_c_r - 16.7011659854984*v_INV_4_a_i - 32.2332503520119*v_INV_4_a_r - 16.7011659854983*v_INV_4_b_i - 32.2332503520119*v_INV_4_b_r + 58.4540809492443*v_INV_4_c_i + 112.816376232042*v_INV_4_c_r + 47.4895446494637*v_TR_3_4_lv_a_i + 91.6546016981108*v_TR_3_4_lv_a_r + 47.4895446494636*v_TR_3_4_lv_b_i + 91.6546016981109*v_TR_3_4_lv_b_r - 368.915426669025*v_TR_3_4_lv_c_i - 354.574889727171*v_TR_3_4_lv_c_r - 2.3406091994174*v_TR_3_4_mv_b_i - 0.390101533236234*v_TR_3_4_mv_b_r + 2.3406091994174*v_TR_3_4_mv_c_i + 0.390101533236234*v_TR_3_4_mv_c_r
        struct[0].g[113,0] = i_TR_3_4_lv_c_i - 59.4213513460989*v_INV_3_a_i + 30.7882649461652*v_INV_3_a_r - 59.421351346099*v_INV_3_b_i + 30.7882649461651*v_INV_3_b_r + 207.974729711346*v_INV_3_c_i - 107.758927311578*v_INV_3_c_r - 32.2332503520119*v_INV_4_a_i + 16.7011659854984*v_INV_4_a_r - 32.2332503520119*v_INV_4_b_i + 16.7011659854983*v_INV_4_b_r + 112.816376232042*v_INV_4_c_i - 58.4540809492443*v_INV_4_c_r + 91.6546016981108*v_TR_3_4_lv_a_i - 47.4895446494637*v_TR_3_4_lv_a_r + 91.6546016981109*v_TR_3_4_lv_b_i - 47.4895446494636*v_TR_3_4_lv_b_r - 354.574889727171*v_TR_3_4_lv_c_i + 368.915426669025*v_TR_3_4_lv_c_r - 0.390101533236234*v_TR_3_4_mv_b_i + 2.3406091994174*v_TR_3_4_mv_b_r + 0.390101533236234*v_TR_3_4_mv_c_i - 2.3406091994174*v_TR_3_4_mv_c_r
        struct[0].g[114,0] = i_TR_5_6_mv_a_r + 8.63801621787545*v_POImv_a_i + 6.47851216340659*v_POImv_a_r - 2.4680046336787*v_POImv_b_i - 1.85100347525903*v_POImv_b_r - 2.4680046336787*v_POImv_c_i - 1.85100347525903*v_POImv_c_r + 2.3406091994174*v_TR_5_6_lv_a_i + 0.390101533236234*v_TR_5_6_lv_a_r - 2.3406091994174*v_TR_5_6_lv_b_i - 0.390101533236234*v_TR_5_6_lv_b_r - 53.186989402129*v_TR_5_6_mv_a_i - 39.8587546923895*v_TR_5_6_mv_a_r + 15.2079060840306*v_TR_5_6_mv_b_i + 11.3901461283275*v_TR_5_6_mv_b_r + 15.2079060840306*v_TR_5_6_mv_c_i + 11.3901461283275*v_TR_5_6_mv_c_r + 44.4949780266318*v_TR_9_10_mv_a_i + 33.3712335199739*v_TR_9_10_mv_a_r - 12.7128508647519*v_TR_9_10_mv_b_i - 9.53463814856397*v_TR_9_10_mv_b_r - 12.7128508647519*v_TR_9_10_mv_c_i - 9.53463814856397*v_TR_9_10_mv_c_r
        struct[0].g[115,0] = i_TR_5_6_mv_a_i + 6.47851216340659*v_POImv_a_i - 8.63801621787545*v_POImv_a_r - 1.85100347525903*v_POImv_b_i + 2.4680046336787*v_POImv_b_r - 1.85100347525903*v_POImv_c_i + 2.4680046336787*v_POImv_c_r + 0.390101533236234*v_TR_5_6_lv_a_i - 2.3406091994174*v_TR_5_6_lv_a_r - 0.390101533236234*v_TR_5_6_lv_b_i + 2.3406091994174*v_TR_5_6_lv_b_r - 39.8587546923895*v_TR_5_6_mv_a_i + 53.186989402129*v_TR_5_6_mv_a_r + 11.3901461283275*v_TR_5_6_mv_b_i - 15.2079060840306*v_TR_5_6_mv_b_r + 11.3901461283275*v_TR_5_6_mv_c_i - 15.2079060840306*v_TR_5_6_mv_c_r + 33.3712335199739*v_TR_9_10_mv_a_i - 44.4949780266318*v_TR_9_10_mv_a_r - 9.53463814856397*v_TR_9_10_mv_b_i + 12.7128508647519*v_TR_9_10_mv_b_r - 9.53463814856397*v_TR_9_10_mv_c_i + 12.7128508647519*v_TR_9_10_mv_c_r
        struct[0].g[116,0] = i_TR_5_6_mv_b_r - 2.4680046336787*v_POImv_a_i - 1.85100347525903*v_POImv_a_r + 8.63801621787545*v_POImv_b_i + 6.47851216340659*v_POImv_b_r - 2.4680046336787*v_POImv_c_i - 1.85100347525903*v_POImv_c_r + 2.3406091994174*v_TR_5_6_lv_b_i + 0.390101533236234*v_TR_5_6_lv_b_r - 2.3406091994174*v_TR_5_6_lv_c_i - 0.390101533236234*v_TR_5_6_lv_c_r + 15.2079060840306*v_TR_5_6_mv_a_i + 11.3901461283275*v_TR_5_6_mv_a_r - 53.186989402129*v_TR_5_6_mv_b_i - 39.8587546923895*v_TR_5_6_mv_b_r + 15.2079060840306*v_TR_5_6_mv_c_i + 11.3901461283275*v_TR_5_6_mv_c_r - 12.7128508647519*v_TR_9_10_mv_a_i - 9.53463814856397*v_TR_9_10_mv_a_r + 44.4949780266318*v_TR_9_10_mv_b_i + 33.3712335199739*v_TR_9_10_mv_b_r - 12.712850864752*v_TR_9_10_mv_c_i - 9.53463814856399*v_TR_9_10_mv_c_r
        struct[0].g[117,0] = i_TR_5_6_mv_b_i - 1.85100347525903*v_POImv_a_i + 2.4680046336787*v_POImv_a_r + 6.47851216340659*v_POImv_b_i - 8.63801621787545*v_POImv_b_r - 1.85100347525903*v_POImv_c_i + 2.4680046336787*v_POImv_c_r + 0.390101533236234*v_TR_5_6_lv_b_i - 2.3406091994174*v_TR_5_6_lv_b_r - 0.390101533236234*v_TR_5_6_lv_c_i + 2.3406091994174*v_TR_5_6_lv_c_r + 11.3901461283275*v_TR_5_6_mv_a_i - 15.2079060840306*v_TR_5_6_mv_a_r - 39.8587546923895*v_TR_5_6_mv_b_i + 53.186989402129*v_TR_5_6_mv_b_r + 11.3901461283275*v_TR_5_6_mv_c_i - 15.2079060840306*v_TR_5_6_mv_c_r - 9.53463814856397*v_TR_9_10_mv_a_i + 12.7128508647519*v_TR_9_10_mv_a_r + 33.3712335199739*v_TR_9_10_mv_b_i - 44.4949780266318*v_TR_9_10_mv_b_r - 9.53463814856399*v_TR_9_10_mv_c_i + 12.712850864752*v_TR_9_10_mv_c_r
        struct[0].g[118,0] = i_TR_5_6_mv_c_r - 2.4680046336787*v_POImv_a_i - 1.85100347525903*v_POImv_a_r - 2.4680046336787*v_POImv_b_i - 1.85100347525903*v_POImv_b_r + 8.63801621787545*v_POImv_c_i + 6.47851216340659*v_POImv_c_r - 2.3406091994174*v_TR_5_6_lv_a_i - 0.390101533236234*v_TR_5_6_lv_a_r + 2.3406091994174*v_TR_5_6_lv_c_i + 0.390101533236234*v_TR_5_6_lv_c_r + 15.2079060840306*v_TR_5_6_mv_a_i + 11.3901461283275*v_TR_5_6_mv_a_r + 15.2079060840306*v_TR_5_6_mv_b_i + 11.3901461283275*v_TR_5_6_mv_b_r - 53.186989402129*v_TR_5_6_mv_c_i - 39.8587546923895*v_TR_5_6_mv_c_r - 12.7128508647519*v_TR_9_10_mv_a_i - 9.53463814856397*v_TR_9_10_mv_a_r - 12.712850864752*v_TR_9_10_mv_b_i - 9.53463814856399*v_TR_9_10_mv_b_r + 44.4949780266318*v_TR_9_10_mv_c_i + 33.3712335199739*v_TR_9_10_mv_c_r
        struct[0].g[119,0] = i_TR_5_6_mv_c_i - 1.85100347525903*v_POImv_a_i + 2.4680046336787*v_POImv_a_r - 1.85100347525903*v_POImv_b_i + 2.4680046336787*v_POImv_b_r + 6.47851216340659*v_POImv_c_i - 8.63801621787545*v_POImv_c_r - 0.390101533236234*v_TR_5_6_lv_a_i + 2.3406091994174*v_TR_5_6_lv_a_r + 0.390101533236234*v_TR_5_6_lv_c_i - 2.3406091994174*v_TR_5_6_lv_c_r + 11.3901461283275*v_TR_5_6_mv_a_i - 15.2079060840306*v_TR_5_6_mv_a_r + 11.3901461283275*v_TR_5_6_mv_b_i - 15.2079060840306*v_TR_5_6_mv_b_r - 39.8587546923895*v_TR_5_6_mv_c_i + 53.186989402129*v_TR_5_6_mv_c_r - 9.53463814856397*v_TR_9_10_mv_a_i + 12.7128508647519*v_TR_9_10_mv_a_r - 9.53463814856399*v_TR_9_10_mv_b_i + 12.712850864752*v_TR_9_10_mv_b_r + 33.3712335199739*v_TR_9_10_mv_c_i - 44.4949780266318*v_TR_9_10_mv_c_r
        struct[0].g[120,0] = i_TR_5_6_lv_a_r + 92.6872395051616*v_INV_5_a_i + 178.886372244962*v_INV_5_a_r - 26.4820684300462*v_INV_5_b_i - 51.1103920699891*v_INV_5_b_r - 26.4820684300462*v_INV_5_c_i - 51.1103920699891*v_INV_5_c_r + 58.4997822812349*v_INV_6_a_i + 112.904579802783*v_INV_6_a_r - 16.7142235089243*v_INV_6_b_i - 32.2584513722238*v_INV_6_b_r - 16.7142235089243*v_INV_6_c_i - 32.2584513722239*v_INV_6_c_r - 353.889424080847*v_TR_5_6_lv_a_i - 325.574735831529*v_TR_5_6_lv_a_r + 43.1964121022714*v_TR_5_6_lv_b_i + 83.3688434422129*v_TR_5_6_lv_b_r + 43.1964121022714*v_TR_5_6_lv_c_i + 83.368843442213*v_TR_5_6_lv_c_r + 2.3406091994174*v_TR_5_6_mv_a_i + 0.390101533236234*v_TR_5_6_mv_a_r - 2.3406091994174*v_TR_5_6_mv_c_i - 0.390101533236234*v_TR_5_6_mv_c_r
        struct[0].g[121,0] = i_TR_5_6_lv_a_i + 178.886372244962*v_INV_5_a_i - 92.6872395051616*v_INV_5_a_r - 51.1103920699891*v_INV_5_b_i + 26.4820684300462*v_INV_5_b_r - 51.1103920699891*v_INV_5_c_i + 26.4820684300462*v_INV_5_c_r + 112.904579802783*v_INV_6_a_i - 58.4997822812349*v_INV_6_a_r - 32.2584513722238*v_INV_6_b_i + 16.7142235089243*v_INV_6_b_r - 32.2584513722239*v_INV_6_c_i + 16.7142235089243*v_INV_6_c_r - 325.574735831529*v_TR_5_6_lv_a_i + 353.889424080847*v_TR_5_6_lv_a_r + 83.3688434422129*v_TR_5_6_lv_b_i - 43.1964121022714*v_TR_5_6_lv_b_r + 83.368843442213*v_TR_5_6_lv_c_i - 43.1964121022714*v_TR_5_6_lv_c_r + 0.390101533236234*v_TR_5_6_mv_a_i - 2.3406091994174*v_TR_5_6_mv_a_r - 0.390101533236234*v_TR_5_6_mv_c_i + 2.3406091994174*v_TR_5_6_mv_c_r
        struct[0].g[122,0] = i_TR_5_6_lv_b_r - 26.4820684300461*v_INV_5_a_i - 51.1103920699891*v_INV_5_a_r + 92.6872395051615*v_INV_5_b_i + 178.886372244962*v_INV_5_b_r - 26.4820684300461*v_INV_5_c_i - 51.1103920699892*v_INV_5_c_r - 16.7142235089243*v_INV_6_a_i - 32.2584513722238*v_INV_6_a_r + 58.4997822812349*v_INV_6_b_i + 112.904579802783*v_INV_6_b_r - 16.7142235089242*v_INV_6_c_i - 32.2584513722239*v_INV_6_c_r + 43.1964121022714*v_TR_5_6_lv_a_i + 83.3688434422129*v_TR_5_6_lv_a_r - 353.889424080846*v_TR_5_6_lv_b_i - 325.574735831529*v_TR_5_6_lv_b_r + 43.1964121022714*v_TR_5_6_lv_c_i + 83.3688434422131*v_TR_5_6_lv_c_r - 2.3406091994174*v_TR_5_6_mv_a_i - 0.390101533236234*v_TR_5_6_mv_a_r + 2.3406091994174*v_TR_5_6_mv_b_i + 0.390101533236234*v_TR_5_6_mv_b_r
        struct[0].g[123,0] = i_TR_5_6_lv_b_i - 51.1103920699891*v_INV_5_a_i + 26.4820684300461*v_INV_5_a_r + 178.886372244962*v_INV_5_b_i - 92.6872395051615*v_INV_5_b_r - 51.1103920699892*v_INV_5_c_i + 26.4820684300461*v_INV_5_c_r - 32.2584513722238*v_INV_6_a_i + 16.7142235089243*v_INV_6_a_r + 112.904579802783*v_INV_6_b_i - 58.4997822812349*v_INV_6_b_r - 32.2584513722239*v_INV_6_c_i + 16.7142235089242*v_INV_6_c_r + 83.3688434422129*v_TR_5_6_lv_a_i - 43.1964121022714*v_TR_5_6_lv_a_r - 325.574735831529*v_TR_5_6_lv_b_i + 353.889424080846*v_TR_5_6_lv_b_r + 83.3688434422131*v_TR_5_6_lv_c_i - 43.1964121022714*v_TR_5_6_lv_c_r - 0.390101533236234*v_TR_5_6_mv_a_i + 2.3406091994174*v_TR_5_6_mv_a_r + 0.390101533236234*v_TR_5_6_mv_b_i - 2.3406091994174*v_TR_5_6_mv_b_r
        struct[0].g[124,0] = i_TR_5_6_lv_c_r - 26.4820684300462*v_INV_5_a_i - 51.1103920699891*v_INV_5_a_r - 26.4820684300461*v_INV_5_b_i - 51.1103920699892*v_INV_5_b_r + 92.6872395051615*v_INV_5_c_i + 178.886372244962*v_INV_5_c_r - 16.7142235089243*v_INV_6_a_i - 32.2584513722239*v_INV_6_a_r - 16.7142235089242*v_INV_6_b_i - 32.2584513722239*v_INV_6_b_r + 58.4997822812349*v_INV_6_c_i + 112.904579802783*v_INV_6_c_r + 43.1964121022714*v_TR_5_6_lv_a_i + 83.368843442213*v_TR_5_6_lv_a_r + 43.1964121022714*v_TR_5_6_lv_b_i + 83.3688434422131*v_TR_5_6_lv_b_r - 353.889424080846*v_TR_5_6_lv_c_i - 325.574735831529*v_TR_5_6_lv_c_r - 2.3406091994174*v_TR_5_6_mv_b_i - 0.390101533236234*v_TR_5_6_mv_b_r + 2.3406091994174*v_TR_5_6_mv_c_i + 0.390101533236234*v_TR_5_6_mv_c_r
        struct[0].g[125,0] = i_TR_5_6_lv_c_i - 51.1103920699891*v_INV_5_a_i + 26.4820684300462*v_INV_5_a_r - 51.1103920699892*v_INV_5_b_i + 26.4820684300461*v_INV_5_b_r + 178.886372244962*v_INV_5_c_i - 92.6872395051615*v_INV_5_c_r - 32.2584513722239*v_INV_6_a_i + 16.7142235089243*v_INV_6_a_r - 32.2584513722239*v_INV_6_b_i + 16.7142235089242*v_INV_6_b_r + 112.904579802783*v_INV_6_c_i - 58.4997822812349*v_INV_6_c_r + 83.368843442213*v_TR_5_6_lv_a_i - 43.1964121022714*v_TR_5_6_lv_a_r + 83.3688434422131*v_TR_5_6_lv_b_i - 43.1964121022714*v_TR_5_6_lv_b_r - 325.574735831529*v_TR_5_6_lv_c_i + 353.889424080846*v_TR_5_6_lv_c_r - 0.390101533236234*v_TR_5_6_mv_b_i + 2.3406091994174*v_TR_5_6_mv_b_r + 0.390101533236234*v_TR_5_6_mv_c_i - 2.3406091994174*v_TR_5_6_mv_c_r
        struct[0].g[126,0] = i_TR_7_8_mv_a_r + 6.60088643956832*v_TR_13_mv_a_i + 8.97043541787489*v_TR_13_mv_a_r - 1.88596755416238*v_TR_13_mv_b_i - 2.56298154796426*v_TR_13_mv_b_r - 1.88596755416237*v_TR_13_mv_c_i - 2.56298154796426*v_TR_13_mv_c_r + 15.0420612397687*v_TR_3_4_mv_a_i + 20.4417755309677*v_TR_3_4_mv_a_r - 4.29773178279105*v_TR_3_4_mv_b_i - 5.8405072945622*v_TR_3_4_mv_b_r - 4.29773178279104*v_TR_3_4_mv_c_i - 5.84050729456219*v_TR_3_4_mv_c_r + 2.3406091994174*v_TR_7_8_lv_a_i + 0.390101533236234*v_TR_7_8_lv_a_r - 2.3406091994174*v_TR_7_8_lv_b_i - 0.390101533236234*v_TR_7_8_lv_b_r - 21.6969684194189*v_TR_7_8_mv_a_i - 29.4212199578516*v_TR_7_8_mv_a_r + 6.21073968956929*v_TR_7_8_mv_b_i + 8.40799334703096*v_TR_7_8_mv_b_r + 6.21073968956928*v_TR_7_8_mv_c_i + 8.40799334703096*v_TR_7_8_mv_c_r
        struct[0].g[127,0] = i_TR_7_8_mv_a_i + 8.97043541787489*v_TR_13_mv_a_i - 6.60088643956832*v_TR_13_mv_a_r - 2.56298154796426*v_TR_13_mv_b_i + 1.88596755416238*v_TR_13_mv_b_r - 2.56298154796426*v_TR_13_mv_c_i + 1.88596755416237*v_TR_13_mv_c_r + 20.4417755309677*v_TR_3_4_mv_a_i - 15.0420612397687*v_TR_3_4_mv_a_r - 5.8405072945622*v_TR_3_4_mv_b_i + 4.29773178279105*v_TR_3_4_mv_b_r - 5.84050729456219*v_TR_3_4_mv_c_i + 4.29773178279104*v_TR_3_4_mv_c_r + 0.390101533236234*v_TR_7_8_lv_a_i - 2.3406091994174*v_TR_7_8_lv_a_r - 0.390101533236234*v_TR_7_8_lv_b_i + 2.3406091994174*v_TR_7_8_lv_b_r - 29.4212199578516*v_TR_7_8_mv_a_i + 21.6969684194189*v_TR_7_8_mv_a_r + 8.40799334703096*v_TR_7_8_mv_b_i - 6.21073968956929*v_TR_7_8_mv_b_r + 8.40799334703096*v_TR_7_8_mv_c_i - 6.21073968956928*v_TR_7_8_mv_c_r
        struct[0].g[128,0] = i_TR_7_8_mv_b_r - 1.88596755416238*v_TR_13_mv_a_i - 2.56298154796426*v_TR_13_mv_a_r + 6.60088643956832*v_TR_13_mv_b_i + 8.9704354178749*v_TR_13_mv_b_r - 1.88596755416237*v_TR_13_mv_c_i - 2.56298154796426*v_TR_13_mv_c_r - 4.29773178279105*v_TR_3_4_mv_a_i - 5.8405072945622*v_TR_3_4_mv_a_r + 15.0420612397687*v_TR_3_4_mv_b_i + 20.4417755309677*v_TR_3_4_mv_b_r - 4.29773178279105*v_TR_3_4_mv_c_i - 5.8405072945622*v_TR_3_4_mv_c_r + 2.3406091994174*v_TR_7_8_lv_b_i + 0.390101533236234*v_TR_7_8_lv_b_r - 2.3406091994174*v_TR_7_8_lv_c_i - 0.390101533236234*v_TR_7_8_lv_c_r + 6.21073968956929*v_TR_7_8_mv_a_i + 8.40799334703096*v_TR_7_8_mv_a_r - 21.6969684194189*v_TR_7_8_mv_b_i - 29.4212199578516*v_TR_7_8_mv_b_r + 6.21073968956929*v_TR_7_8_mv_c_i + 8.40799334703097*v_TR_7_8_mv_c_r
        struct[0].g[129,0] = i_TR_7_8_mv_b_i - 2.56298154796426*v_TR_13_mv_a_i + 1.88596755416238*v_TR_13_mv_a_r + 8.9704354178749*v_TR_13_mv_b_i - 6.60088643956832*v_TR_13_mv_b_r - 2.56298154796426*v_TR_13_mv_c_i + 1.88596755416237*v_TR_13_mv_c_r - 5.8405072945622*v_TR_3_4_mv_a_i + 4.29773178279105*v_TR_3_4_mv_a_r + 20.4417755309677*v_TR_3_4_mv_b_i - 15.0420612397687*v_TR_3_4_mv_b_r - 5.8405072945622*v_TR_3_4_mv_c_i + 4.29773178279105*v_TR_3_4_mv_c_r + 0.390101533236234*v_TR_7_8_lv_b_i - 2.3406091994174*v_TR_7_8_lv_b_r - 0.390101533236234*v_TR_7_8_lv_c_i + 2.3406091994174*v_TR_7_8_lv_c_r + 8.40799334703096*v_TR_7_8_mv_a_i - 6.21073968956929*v_TR_7_8_mv_a_r - 29.4212199578516*v_TR_7_8_mv_b_i + 21.6969684194189*v_TR_7_8_mv_b_r + 8.40799334703097*v_TR_7_8_mv_c_i - 6.21073968956929*v_TR_7_8_mv_c_r
        struct[0].g[130,0] = i_TR_7_8_mv_c_r - 1.88596755416237*v_TR_13_mv_a_i - 2.56298154796426*v_TR_13_mv_a_r - 1.88596755416237*v_TR_13_mv_b_i - 2.56298154796426*v_TR_13_mv_b_r + 6.60088643956831*v_TR_13_mv_c_i + 8.9704354178749*v_TR_13_mv_c_r - 4.29773178279105*v_TR_3_4_mv_a_i - 5.84050729456219*v_TR_3_4_mv_a_r - 4.29773178279104*v_TR_3_4_mv_b_i - 5.84050729456221*v_TR_3_4_mv_b_r + 15.0420612397687*v_TR_3_4_mv_c_i + 20.4417755309677*v_TR_3_4_mv_c_r - 2.3406091994174*v_TR_7_8_lv_a_i - 0.390101533236234*v_TR_7_8_lv_a_r + 2.3406091994174*v_TR_7_8_lv_c_i + 0.390101533236234*v_TR_7_8_lv_c_r + 6.21073968956929*v_TR_7_8_mv_a_i + 8.40799334703095*v_TR_7_8_mv_a_r + 6.21073968956928*v_TR_7_8_mv_b_i + 8.40799334703097*v_TR_7_8_mv_b_r - 21.6969684194189*v_TR_7_8_mv_c_i - 29.4212199578516*v_TR_7_8_mv_c_r
        struct[0].g[131,0] = i_TR_7_8_mv_c_i - 2.56298154796426*v_TR_13_mv_a_i + 1.88596755416237*v_TR_13_mv_a_r - 2.56298154796426*v_TR_13_mv_b_i + 1.88596755416237*v_TR_13_mv_b_r + 8.9704354178749*v_TR_13_mv_c_i - 6.60088643956831*v_TR_13_mv_c_r - 5.84050729456219*v_TR_3_4_mv_a_i + 4.29773178279105*v_TR_3_4_mv_a_r - 5.84050729456221*v_TR_3_4_mv_b_i + 4.29773178279104*v_TR_3_4_mv_b_r + 20.4417755309677*v_TR_3_4_mv_c_i - 15.0420612397687*v_TR_3_4_mv_c_r - 0.390101533236234*v_TR_7_8_lv_a_i + 2.3406091994174*v_TR_7_8_lv_a_r + 0.390101533236234*v_TR_7_8_lv_c_i - 2.3406091994174*v_TR_7_8_lv_c_r + 8.40799334703095*v_TR_7_8_mv_a_i - 6.21073968956929*v_TR_7_8_mv_a_r + 8.40799334703097*v_TR_7_8_mv_b_i - 6.21073968956928*v_TR_7_8_mv_b_r - 29.4212199578516*v_TR_7_8_mv_c_i + 21.6969684194189*v_TR_7_8_mv_c_r
        struct[0].g[132,0] = i_TR_7_8_lv_a_r + 246.057604426258*v_INV_7_a_i + 474.891176542679*v_INV_7_a_r - 70.3021726932167*v_INV_7_b_i - 135.683193297908*v_INV_7_b_r - 70.3021726932166*v_INV_7_c_i - 135.683193297908*v_INV_7_c_r + 106.794172415445*v_INV_8_a_i + 206.112752761809*v_INV_8_a_r - 30.5126206901271*v_INV_8_b_i - 58.8893579319454*v_INV_8_b_r - 30.5126206901271*v_INV_8_c_i - 58.8893579319454*v_INV_8_c_r - 555.554334874064*v_TR_7_8_lv_a_i - 714.787713088272*v_TR_7_8_lv_a_r + 100.81485125148*v_TR_7_8_lv_b_i + 194.572551229854*v_TR_7_8_lv_b_r + 100.81485125148*v_TR_7_8_lv_c_i + 194.572551229854*v_TR_7_8_lv_c_r + 2.3406091994174*v_TR_7_8_mv_a_i + 0.390101533236234*v_TR_7_8_mv_a_r - 2.3406091994174*v_TR_7_8_mv_c_i - 0.390101533236234*v_TR_7_8_mv_c_r
        struct[0].g[133,0] = i_TR_7_8_lv_a_i + 474.891176542679*v_INV_7_a_i - 246.057604426258*v_INV_7_a_r - 135.683193297908*v_INV_7_b_i + 70.3021726932167*v_INV_7_b_r - 135.683193297908*v_INV_7_c_i + 70.3021726932166*v_INV_7_c_r + 206.112752761809*v_INV_8_a_i - 106.794172415445*v_INV_8_a_r - 58.8893579319454*v_INV_8_b_i + 30.5126206901271*v_INV_8_b_r - 58.8893579319454*v_INV_8_c_i + 30.5126206901271*v_INV_8_c_r - 714.787713088272*v_TR_7_8_lv_a_i + 555.554334874064*v_TR_7_8_lv_a_r + 194.572551229854*v_TR_7_8_lv_b_i - 100.81485125148*v_TR_7_8_lv_b_r + 194.572551229854*v_TR_7_8_lv_c_i - 100.81485125148*v_TR_7_8_lv_c_r + 0.390101533236234*v_TR_7_8_mv_a_i - 2.3406091994174*v_TR_7_8_mv_a_r - 0.390101533236234*v_TR_7_8_mv_c_i + 2.3406091994174*v_TR_7_8_mv_c_r
        struct[0].g[134,0] = i_TR_7_8_lv_b_r - 70.3021726932166*v_INV_7_a_i - 135.683193297908*v_INV_7_a_r + 246.057604426258*v_INV_7_b_i + 474.891176542679*v_INV_7_b_r - 70.3021726932165*v_INV_7_c_i - 135.683193297909*v_INV_7_c_r - 30.5126206901271*v_INV_8_a_i - 58.8893579319454*v_INV_8_a_r + 106.794172415445*v_INV_8_b_i + 206.112752761809*v_INV_8_b_r - 30.5126206901271*v_INV_8_c_i - 58.8893579319455*v_INV_8_c_r + 100.81485125148*v_TR_7_8_lv_a_i + 194.572551229854*v_TR_7_8_lv_a_r - 555.554334874064*v_TR_7_8_lv_b_i - 714.787713088272*v_TR_7_8_lv_b_r + 100.81485125148*v_TR_7_8_lv_c_i + 194.572551229854*v_TR_7_8_lv_c_r - 2.3406091994174*v_TR_7_8_mv_a_i - 0.390101533236234*v_TR_7_8_mv_a_r + 2.3406091994174*v_TR_7_8_mv_b_i + 0.390101533236234*v_TR_7_8_mv_b_r
        struct[0].g[135,0] = i_TR_7_8_lv_b_i - 135.683193297908*v_INV_7_a_i + 70.3021726932166*v_INV_7_a_r + 474.891176542679*v_INV_7_b_i - 246.057604426258*v_INV_7_b_r - 135.683193297909*v_INV_7_c_i + 70.3021726932165*v_INV_7_c_r - 58.8893579319454*v_INV_8_a_i + 30.5126206901271*v_INV_8_a_r + 206.112752761809*v_INV_8_b_i - 106.794172415445*v_INV_8_b_r - 58.8893579319455*v_INV_8_c_i + 30.5126206901271*v_INV_8_c_r + 194.572551229854*v_TR_7_8_lv_a_i - 100.81485125148*v_TR_7_8_lv_a_r - 714.787713088272*v_TR_7_8_lv_b_i + 555.554334874064*v_TR_7_8_lv_b_r + 194.572551229854*v_TR_7_8_lv_c_i - 100.81485125148*v_TR_7_8_lv_c_r - 0.390101533236234*v_TR_7_8_mv_a_i + 2.3406091994174*v_TR_7_8_mv_a_r + 0.390101533236234*v_TR_7_8_mv_b_i - 2.3406091994174*v_TR_7_8_mv_b_r
        struct[0].g[136,0] = i_TR_7_8_lv_c_r - 70.3021726932167*v_INV_7_a_i - 135.683193297908*v_INV_7_a_r - 70.3021726932165*v_INV_7_b_i - 135.683193297909*v_INV_7_b_r + 246.057604426258*v_INV_7_c_i + 474.891176542679*v_INV_7_c_r - 30.5126206901272*v_INV_8_a_i - 58.8893579319454*v_INV_8_a_r - 30.5126206901271*v_INV_8_b_i - 58.8893579319455*v_INV_8_b_r + 106.794172415445*v_INV_8_c_i + 206.112752761809*v_INV_8_c_r + 100.814851251481*v_TR_7_8_lv_a_i + 194.572551229854*v_TR_7_8_lv_a_r + 100.81485125148*v_TR_7_8_lv_b_i + 194.572551229854*v_TR_7_8_lv_b_r - 555.554334874064*v_TR_7_8_lv_c_i - 714.787713088272*v_TR_7_8_lv_c_r - 2.3406091994174*v_TR_7_8_mv_b_i - 0.390101533236234*v_TR_7_8_mv_b_r + 2.3406091994174*v_TR_7_8_mv_c_i + 0.390101533236234*v_TR_7_8_mv_c_r
        struct[0].g[137,0] = i_TR_7_8_lv_c_i - 135.683193297908*v_INV_7_a_i + 70.3021726932167*v_INV_7_a_r - 135.683193297909*v_INV_7_b_i + 70.3021726932165*v_INV_7_b_r + 474.891176542679*v_INV_7_c_i - 246.057604426258*v_INV_7_c_r - 58.8893579319454*v_INV_8_a_i + 30.5126206901272*v_INV_8_a_r - 58.8893579319455*v_INV_8_b_i + 30.5126206901271*v_INV_8_b_r + 206.112752761809*v_INV_8_c_i - 106.794172415445*v_INV_8_c_r + 194.572551229854*v_TR_7_8_lv_a_i - 100.814851251481*v_TR_7_8_lv_a_r + 194.572551229854*v_TR_7_8_lv_b_i - 100.81485125148*v_TR_7_8_lv_b_r - 714.787713088272*v_TR_7_8_lv_c_i + 555.554334874064*v_TR_7_8_lv_c_r - 0.390101533236234*v_TR_7_8_mv_b_i + 2.3406091994174*v_TR_7_8_mv_b_r + 0.390101533236234*v_TR_7_8_mv_c_i - 2.3406091994174*v_TR_7_8_mv_c_r
        struct[0].g[138,0] = i_TR_9_10_mv_a_r + 8.85995441972108*v_TR_11_12_mv_a_i + 12.0404508780825*v_TR_11_12_mv_a_r - 2.53141554849174*v_TR_11_12_mv_b_i - 3.44012882230928*v_TR_11_12_mv_b_r - 2.53141554849173*v_TR_11_12_mv_c_i - 3.44012882230929*v_TR_11_12_mv_c_r + 44.4949780266318*v_TR_5_6_mv_a_i + 33.3712335199739*v_TR_5_6_mv_a_r - 12.7128508647519*v_TR_5_6_mv_b_i - 9.53463814856397*v_TR_5_6_mv_b_r - 12.7128508647519*v_TR_5_6_mv_c_i - 9.53463814856397*v_TR_5_6_mv_c_r + 2.3406091994174*v_TR_9_10_lv_a_i + 0.390101533236234*v_TR_9_10_lv_a_r - 2.3406091994174*v_TR_9_10_lv_b_i - 0.390101533236234*v_TR_9_10_lv_b_r - 53.4089596754468*v_TR_9_10_mv_a_i - 45.4206934070654*v_TR_9_10_mv_a_r + 15.2713041702548*v_TR_9_10_mv_b_i + 12.9792714753778*v_TR_9_10_mv_b_r + 15.2713041702547*v_TR_9_10_mv_c_i + 12.9792714753778*v_TR_9_10_mv_c_r
        struct[0].g[139,0] = i_TR_9_10_mv_a_i + 12.0404508780825*v_TR_11_12_mv_a_i - 8.85995441972108*v_TR_11_12_mv_a_r - 3.44012882230928*v_TR_11_12_mv_b_i + 2.53141554849174*v_TR_11_12_mv_b_r - 3.44012882230929*v_TR_11_12_mv_c_i + 2.53141554849173*v_TR_11_12_mv_c_r + 33.3712335199739*v_TR_5_6_mv_a_i - 44.4949780266318*v_TR_5_6_mv_a_r - 9.53463814856397*v_TR_5_6_mv_b_i + 12.7128508647519*v_TR_5_6_mv_b_r - 9.53463814856397*v_TR_5_6_mv_c_i + 12.7128508647519*v_TR_5_6_mv_c_r + 0.390101533236234*v_TR_9_10_lv_a_i - 2.3406091994174*v_TR_9_10_lv_a_r - 0.390101533236234*v_TR_9_10_lv_b_i + 2.3406091994174*v_TR_9_10_lv_b_r - 45.4206934070654*v_TR_9_10_mv_a_i + 53.4089596754468*v_TR_9_10_mv_a_r + 12.9792714753778*v_TR_9_10_mv_b_i - 15.2713041702548*v_TR_9_10_mv_b_r + 12.9792714753778*v_TR_9_10_mv_c_i - 15.2713041702547*v_TR_9_10_mv_c_r
        struct[0].g[140,0] = i_TR_9_10_mv_b_r - 2.53141554849173*v_TR_11_12_mv_a_i - 3.44012882230929*v_TR_11_12_mv_a_r + 8.85995441972108*v_TR_11_12_mv_b_i + 12.0404508780825*v_TR_11_12_mv_b_r - 2.53141554849174*v_TR_11_12_mv_c_i - 3.44012882230929*v_TR_11_12_mv_c_r - 12.7128508647519*v_TR_5_6_mv_a_i - 9.53463814856397*v_TR_5_6_mv_a_r + 44.4949780266318*v_TR_5_6_mv_b_i + 33.3712335199739*v_TR_5_6_mv_b_r - 12.712850864752*v_TR_5_6_mv_c_i - 9.53463814856399*v_TR_5_6_mv_c_r + 2.3406091994174*v_TR_9_10_lv_b_i + 0.390101533236234*v_TR_9_10_lv_b_r - 2.3406091994174*v_TR_9_10_lv_c_i - 0.390101533236234*v_TR_9_10_lv_c_r + 15.2713041702548*v_TR_9_10_mv_a_i + 12.9792714753778*v_TR_9_10_mv_a_r - 53.4089596754469*v_TR_9_10_mv_b_i - 45.4206934070654*v_TR_9_10_mv_b_r + 15.2713041702548*v_TR_9_10_mv_c_i + 12.9792714753778*v_TR_9_10_mv_c_r
        struct[0].g[141,0] = i_TR_9_10_mv_b_i - 3.44012882230929*v_TR_11_12_mv_a_i + 2.53141554849173*v_TR_11_12_mv_a_r + 12.0404508780825*v_TR_11_12_mv_b_i - 8.85995441972108*v_TR_11_12_mv_b_r - 3.44012882230929*v_TR_11_12_mv_c_i + 2.53141554849174*v_TR_11_12_mv_c_r - 9.53463814856397*v_TR_5_6_mv_a_i + 12.7128508647519*v_TR_5_6_mv_a_r + 33.3712335199739*v_TR_5_6_mv_b_i - 44.4949780266318*v_TR_5_6_mv_b_r - 9.53463814856399*v_TR_5_6_mv_c_i + 12.712850864752*v_TR_5_6_mv_c_r + 0.390101533236234*v_TR_9_10_lv_b_i - 2.3406091994174*v_TR_9_10_lv_b_r - 0.390101533236234*v_TR_9_10_lv_c_i + 2.3406091994174*v_TR_9_10_lv_c_r + 12.9792714753778*v_TR_9_10_mv_a_i - 15.2713041702548*v_TR_9_10_mv_a_r - 45.4206934070654*v_TR_9_10_mv_b_i + 53.4089596754469*v_TR_9_10_mv_b_r + 12.9792714753778*v_TR_9_10_mv_c_i - 15.2713041702548*v_TR_9_10_mv_c_r
        struct[0].g[142,0] = i_TR_9_10_mv_c_r - 2.53141554849174*v_TR_11_12_mv_a_i - 3.44012882230928*v_TR_11_12_mv_a_r - 2.53141554849174*v_TR_11_12_mv_b_i - 3.44012882230929*v_TR_11_12_mv_b_r + 8.85995441972108*v_TR_11_12_mv_c_i + 12.0404508780825*v_TR_11_12_mv_c_r - 12.7128508647519*v_TR_5_6_mv_a_i - 9.53463814856397*v_TR_5_6_mv_a_r - 12.712850864752*v_TR_5_6_mv_b_i - 9.53463814856399*v_TR_5_6_mv_b_r + 44.4949780266318*v_TR_5_6_mv_c_i + 33.3712335199739*v_TR_5_6_mv_c_r - 2.3406091994174*v_TR_9_10_lv_a_i - 0.390101533236234*v_TR_9_10_lv_a_r + 2.3406091994174*v_TR_9_10_lv_c_i + 0.390101533236234*v_TR_9_10_lv_c_r + 15.2713041702548*v_TR_9_10_mv_a_i + 12.9792714753778*v_TR_9_10_mv_a_r + 15.2713041702548*v_TR_9_10_mv_b_i + 12.9792714753778*v_TR_9_10_mv_b_r - 53.4089596754468*v_TR_9_10_mv_c_i - 45.4206934070654*v_TR_9_10_mv_c_r
        struct[0].g[143,0] = i_TR_9_10_mv_c_i - 3.44012882230928*v_TR_11_12_mv_a_i + 2.53141554849174*v_TR_11_12_mv_a_r - 3.44012882230929*v_TR_11_12_mv_b_i + 2.53141554849174*v_TR_11_12_mv_b_r + 12.0404508780825*v_TR_11_12_mv_c_i - 8.85995441972108*v_TR_11_12_mv_c_r - 9.53463814856397*v_TR_5_6_mv_a_i + 12.7128508647519*v_TR_5_6_mv_a_r - 9.53463814856399*v_TR_5_6_mv_b_i + 12.712850864752*v_TR_5_6_mv_b_r + 33.3712335199739*v_TR_5_6_mv_c_i - 44.4949780266318*v_TR_5_6_mv_c_r - 0.390101533236234*v_TR_9_10_lv_a_i + 2.3406091994174*v_TR_9_10_lv_a_r + 0.390101533236234*v_TR_9_10_lv_c_i - 2.3406091994174*v_TR_9_10_lv_c_r + 12.9792714753778*v_TR_9_10_mv_a_i - 15.2713041702548*v_TR_9_10_mv_a_r + 12.9792714753778*v_TR_9_10_mv_b_i - 15.2713041702548*v_TR_9_10_mv_b_r - 45.4206934070654*v_TR_9_10_mv_c_i + 53.4089596754468*v_TR_9_10_mv_c_r
        struct[0].g[144,0] = i_TR_9_10_lv_a_r + 75.8059117481773*v_INV_10_a_i + 146.305409673982*v_INV_10_a_r - 21.6588319280506*v_INV_10_b_i - 41.8015456211378*v_INV_10_b_r - 21.6588319280506*v_INV_10_c_i - 41.8015456211378*v_INV_10_c_r + 98.1764998873781*v_INV_9_a_i + 189.48064478264*v_INV_9_a_r - 28.0504285392509*v_INV_9_b_i - 54.1373270807543*v_INV_9_b_r - 28.0504285392509*v_INV_9_c_i - 54.1373270807543*v_INV_9_c_r - 376.684862474157*v_TR_9_10_lv_a_i - 369.569838240406*v_TR_9_10_lv_a_r + 49.709361212942*v_TR_9_10_lv_b_i + 95.9388727018921*v_TR_9_10_lv_b_r + 49.7093612129419*v_TR_9_10_lv_c_i + 95.9388727018921*v_TR_9_10_lv_c_r + 2.3406091994174*v_TR_9_10_mv_a_i + 0.390101533236234*v_TR_9_10_mv_a_r - 2.3406091994174*v_TR_9_10_mv_c_i - 0.390101533236234*v_TR_9_10_mv_c_r
        struct[0].g[145,0] = i_TR_9_10_lv_a_i + 146.305409673982*v_INV_10_a_i - 75.8059117481773*v_INV_10_a_r - 41.8015456211378*v_INV_10_b_i + 21.6588319280506*v_INV_10_b_r - 41.8015456211378*v_INV_10_c_i + 21.6588319280506*v_INV_10_c_r + 189.48064478264*v_INV_9_a_i - 98.1764998873781*v_INV_9_a_r - 54.1373270807543*v_INV_9_b_i + 28.0504285392509*v_INV_9_b_r - 54.1373270807543*v_INV_9_c_i + 28.0504285392509*v_INV_9_c_r - 369.569838240406*v_TR_9_10_lv_a_i + 376.684862474157*v_TR_9_10_lv_a_r + 95.9388727018921*v_TR_9_10_lv_b_i - 49.709361212942*v_TR_9_10_lv_b_r + 95.9388727018921*v_TR_9_10_lv_c_i - 49.7093612129419*v_TR_9_10_lv_c_r + 0.390101533236234*v_TR_9_10_mv_a_i - 2.3406091994174*v_TR_9_10_mv_a_r - 0.390101533236234*v_TR_9_10_mv_c_i + 2.3406091994174*v_TR_9_10_mv_c_r
        struct[0].g[146,0] = i_TR_9_10_lv_b_r - 21.6588319280506*v_INV_10_a_i - 41.8015456211377*v_INV_10_a_r + 75.8059117481773*v_INV_10_b_i + 146.305409673982*v_INV_10_b_r - 21.6588319280506*v_INV_10_c_i - 41.8015456211378*v_INV_10_c_r - 28.0504285392509*v_INV_9_a_i - 54.1373270807543*v_INV_9_a_r + 98.1764998873781*v_INV_9_b_i + 189.48064478264*v_INV_9_b_r - 28.0504285392509*v_INV_9_c_i - 54.1373270807544*v_INV_9_c_r + 49.7093612129419*v_TR_9_10_lv_a_i + 95.938872701892*v_TR_9_10_lv_a_r - 376.684862474157*v_TR_9_10_lv_b_i - 369.569838240406*v_TR_9_10_lv_b_r + 49.7093612129419*v_TR_9_10_lv_c_i + 95.9388727018922*v_TR_9_10_lv_c_r - 2.3406091994174*v_TR_9_10_mv_a_i - 0.390101533236234*v_TR_9_10_mv_a_r + 2.3406091994174*v_TR_9_10_mv_b_i + 0.390101533236234*v_TR_9_10_mv_b_r
        struct[0].g[147,0] = i_TR_9_10_lv_b_i - 41.8015456211377*v_INV_10_a_i + 21.6588319280506*v_INV_10_a_r + 146.305409673982*v_INV_10_b_i - 75.8059117481773*v_INV_10_b_r - 41.8015456211378*v_INV_10_c_i + 21.6588319280506*v_INV_10_c_r - 54.1373270807543*v_INV_9_a_i + 28.0504285392509*v_INV_9_a_r + 189.48064478264*v_INV_9_b_i - 98.1764998873781*v_INV_9_b_r - 54.1373270807544*v_INV_9_c_i + 28.0504285392509*v_INV_9_c_r + 95.938872701892*v_TR_9_10_lv_a_i - 49.7093612129419*v_TR_9_10_lv_a_r - 369.569838240406*v_TR_9_10_lv_b_i + 376.684862474157*v_TR_9_10_lv_b_r + 95.9388727018922*v_TR_9_10_lv_c_i - 49.7093612129419*v_TR_9_10_lv_c_r - 0.390101533236234*v_TR_9_10_mv_a_i + 2.3406091994174*v_TR_9_10_mv_a_r + 0.390101533236234*v_TR_9_10_mv_b_i - 2.3406091994174*v_TR_9_10_mv_b_r
        struct[0].g[148,0] = i_TR_9_10_lv_c_r - 21.6588319280506*v_INV_10_a_i - 41.8015456211378*v_INV_10_a_r - 21.6588319280506*v_INV_10_b_i - 41.8015456211378*v_INV_10_b_r + 75.8059117481773*v_INV_10_c_i + 146.305409673982*v_INV_10_c_r - 28.0504285392509*v_INV_9_a_i - 54.1373270807543*v_INV_9_a_r - 28.0504285392509*v_INV_9_b_i - 54.1373270807543*v_INV_9_b_r + 98.1764998873781*v_INV_9_c_i + 189.48064478264*v_INV_9_c_r + 49.709361212942*v_TR_9_10_lv_a_i + 95.9388727018921*v_TR_9_10_lv_a_r + 49.7093612129419*v_TR_9_10_lv_b_i + 95.9388727018921*v_TR_9_10_lv_b_r - 376.684862474157*v_TR_9_10_lv_c_i - 369.569838240406*v_TR_9_10_lv_c_r - 2.3406091994174*v_TR_9_10_mv_b_i - 0.390101533236234*v_TR_9_10_mv_b_r + 2.3406091994174*v_TR_9_10_mv_c_i + 0.390101533236234*v_TR_9_10_mv_c_r
        struct[0].g[149,0] = i_TR_9_10_lv_c_i - 41.8015456211378*v_INV_10_a_i + 21.6588319280506*v_INV_10_a_r - 41.8015456211378*v_INV_10_b_i + 21.6588319280506*v_INV_10_b_r + 146.305409673982*v_INV_10_c_i - 75.8059117481773*v_INV_10_c_r - 54.1373270807543*v_INV_9_a_i + 28.0504285392509*v_INV_9_a_r - 54.1373270807543*v_INV_9_b_i + 28.0504285392509*v_INV_9_b_r + 189.48064478264*v_INV_9_c_i - 98.1764998873781*v_INV_9_c_r + 95.9388727018921*v_TR_9_10_lv_a_i - 49.709361212942*v_TR_9_10_lv_a_r + 95.9388727018921*v_TR_9_10_lv_b_i - 49.7093612129419*v_TR_9_10_lv_b_r - 369.569838240406*v_TR_9_10_lv_c_i + 376.684862474157*v_TR_9_10_lv_c_r - 0.390101533236234*v_TR_9_10_mv_b_i + 2.3406091994174*v_TR_9_10_mv_b_r + 0.390101533236234*v_TR_9_10_mv_c_i - 2.3406091994174*v_TR_9_10_mv_c_r
        struct[0].g[150,0] = i_TR_11_12_mv_a_r + 2.3406091994174*v_TR_11_12_lv_a_i + 0.390101533236234*v_TR_11_12_lv_a_r - 2.3406091994174*v_TR_11_12_lv_b_i - 0.390101533236234*v_TR_11_12_lv_b_r - 8.91399122381347*v_TR_11_12_mv_a_i - 12.0494598870915*v_TR_11_12_mv_a_r + 2.55844947550343*v_TR_11_12_mv_b_i + 3.44463332681379*v_TR_11_12_mv_b_r + 2.55844947550343*v_TR_11_12_mv_c_i + 3.44463332681379*v_TR_11_12_mv_c_r + 8.85995441972108*v_TR_9_10_mv_a_i + 12.0404508780825*v_TR_9_10_mv_a_r - 2.53141554849174*v_TR_9_10_mv_b_i - 3.44012882230928*v_TR_9_10_mv_b_r - 2.53141554849173*v_TR_9_10_mv_c_i - 3.44012882230929*v_TR_9_10_mv_c_r
        struct[0].g[151,0] = i_TR_11_12_mv_a_i + 0.390101533236234*v_TR_11_12_lv_a_i - 2.3406091994174*v_TR_11_12_lv_a_r - 0.390101533236234*v_TR_11_12_lv_b_i + 2.3406091994174*v_TR_11_12_lv_b_r - 12.0494598870915*v_TR_11_12_mv_a_i + 8.91399122381347*v_TR_11_12_mv_a_r + 3.44463332681379*v_TR_11_12_mv_b_i - 2.55844947550343*v_TR_11_12_mv_b_r + 3.44463332681379*v_TR_11_12_mv_c_i - 2.55844947550343*v_TR_11_12_mv_c_r + 12.0404508780825*v_TR_9_10_mv_a_i - 8.85995441972108*v_TR_9_10_mv_a_r - 3.44012882230928*v_TR_9_10_mv_b_i + 2.53141554849174*v_TR_9_10_mv_b_r - 3.44012882230929*v_TR_9_10_mv_c_i + 2.53141554849173*v_TR_9_10_mv_c_r
        struct[0].g[152,0] = i_TR_11_12_mv_b_r + 2.3406091994174*v_TR_11_12_lv_b_i + 0.390101533236234*v_TR_11_12_lv_b_r - 2.3406091994174*v_TR_11_12_lv_c_i - 0.390101533236234*v_TR_11_12_lv_c_r + 2.55844947550343*v_TR_11_12_mv_a_i + 3.44463332681379*v_TR_11_12_mv_a_r - 8.91399122381347*v_TR_11_12_mv_b_i - 12.0494598870915*v_TR_11_12_mv_b_r + 2.55844947550343*v_TR_11_12_mv_c_i + 3.4446333268138*v_TR_11_12_mv_c_r - 2.53141554849173*v_TR_9_10_mv_a_i - 3.44012882230929*v_TR_9_10_mv_a_r + 8.85995441972108*v_TR_9_10_mv_b_i + 12.0404508780825*v_TR_9_10_mv_b_r - 2.53141554849174*v_TR_9_10_mv_c_i - 3.44012882230929*v_TR_9_10_mv_c_r
        struct[0].g[153,0] = i_TR_11_12_mv_b_i + 0.390101533236234*v_TR_11_12_lv_b_i - 2.3406091994174*v_TR_11_12_lv_b_r - 0.390101533236234*v_TR_11_12_lv_c_i + 2.3406091994174*v_TR_11_12_lv_c_r + 3.44463332681379*v_TR_11_12_mv_a_i - 2.55844947550343*v_TR_11_12_mv_a_r - 12.0494598870915*v_TR_11_12_mv_b_i + 8.91399122381347*v_TR_11_12_mv_b_r + 3.4446333268138*v_TR_11_12_mv_c_i - 2.55844947550343*v_TR_11_12_mv_c_r - 3.44012882230929*v_TR_9_10_mv_a_i + 2.53141554849173*v_TR_9_10_mv_a_r + 12.0404508780825*v_TR_9_10_mv_b_i - 8.85995441972108*v_TR_9_10_mv_b_r - 3.44012882230929*v_TR_9_10_mv_c_i + 2.53141554849174*v_TR_9_10_mv_c_r
        struct[0].g[154,0] = i_TR_11_12_mv_c_r - 2.3406091994174*v_TR_11_12_lv_a_i - 0.390101533236234*v_TR_11_12_lv_a_r + 2.3406091994174*v_TR_11_12_lv_c_i + 0.390101533236234*v_TR_11_12_lv_c_r + 2.55844947550343*v_TR_11_12_mv_a_i + 3.44463332681379*v_TR_11_12_mv_a_r + 2.55844947550343*v_TR_11_12_mv_b_i + 3.4446333268138*v_TR_11_12_mv_b_r - 8.91399122381347*v_TR_11_12_mv_c_i - 12.0494598870915*v_TR_11_12_mv_c_r - 2.53141554849174*v_TR_9_10_mv_a_i - 3.44012882230928*v_TR_9_10_mv_a_r - 2.53141554849174*v_TR_9_10_mv_b_i - 3.44012882230929*v_TR_9_10_mv_b_r + 8.85995441972108*v_TR_9_10_mv_c_i + 12.0404508780825*v_TR_9_10_mv_c_r
        struct[0].g[155,0] = i_TR_11_12_mv_c_i - 0.390101533236234*v_TR_11_12_lv_a_i + 2.3406091994174*v_TR_11_12_lv_a_r + 0.390101533236234*v_TR_11_12_lv_c_i - 2.3406091994174*v_TR_11_12_lv_c_r + 3.44463332681379*v_TR_11_12_mv_a_i - 2.55844947550343*v_TR_11_12_mv_a_r + 3.4446333268138*v_TR_11_12_mv_b_i - 2.55844947550343*v_TR_11_12_mv_b_r - 12.0494598870915*v_TR_11_12_mv_c_i + 8.91399122381347*v_TR_11_12_mv_c_r - 3.44012882230928*v_TR_9_10_mv_a_i + 2.53141554849174*v_TR_9_10_mv_a_r - 3.44012882230929*v_TR_9_10_mv_b_i + 2.53141554849174*v_TR_9_10_mv_b_r + 12.0404508780825*v_TR_9_10_mv_c_i - 8.85995441972108*v_TR_9_10_mv_c_r
        struct[0].g[156,0] = i_TR_11_12_lv_a_r + 81.5761620304113*v_INV_11_a_i + 157.441992718694*v_INV_11_a_r - 23.3074748658318*v_INV_11_b_i - 44.9834264910554*v_INV_11_b_r - 23.3074748658318*v_INV_11_c_i - 44.9834264910554*v_INV_11_c_r + 107.907268017809*v_INV_12_a_i + 208.26102727437*v_INV_12_a_r - 30.8306480050881*v_INV_12_b_i - 59.5031506498201*v_INV_12_b_r - 30.8306480050881*v_INV_12_c_i - 59.5031506498201*v_INV_12_c_r - 392.185900835935*v_TR_11_12_lv_a_i - 399.486803776848*v_TR_11_12_lv_a_r + 54.138215636915*v_TR_11_12_lv_b_i + 104.486577140876*v_TR_11_12_lv_b_r + 54.138215636915*v_TR_11_12_lv_c_i + 104.486577140876*v_TR_11_12_lv_c_r + 2.3406091994174*v_TR_11_12_mv_a_i + 0.390101533236234*v_TR_11_12_mv_a_r - 2.3406091994174*v_TR_11_12_mv_c_i - 0.390101533236234*v_TR_11_12_mv_c_r
        struct[0].g[157,0] = i_TR_11_12_lv_a_i + 157.441992718694*v_INV_11_a_i - 81.5761620304113*v_INV_11_a_r - 44.9834264910554*v_INV_11_b_i + 23.3074748658318*v_INV_11_b_r - 44.9834264910554*v_INV_11_c_i + 23.3074748658318*v_INV_11_c_r + 208.26102727437*v_INV_12_a_i - 107.907268017809*v_INV_12_a_r - 59.5031506498201*v_INV_12_b_i + 30.8306480050881*v_INV_12_b_r - 59.5031506498201*v_INV_12_c_i + 30.8306480050881*v_INV_12_c_r - 399.486803776848*v_TR_11_12_lv_a_i + 392.185900835935*v_TR_11_12_lv_a_r + 104.486577140876*v_TR_11_12_lv_b_i - 54.138215636915*v_TR_11_12_lv_b_r + 104.486577140876*v_TR_11_12_lv_c_i - 54.138215636915*v_TR_11_12_lv_c_r + 0.390101533236234*v_TR_11_12_mv_a_i - 2.3406091994174*v_TR_11_12_mv_a_r - 0.390101533236234*v_TR_11_12_mv_c_i + 2.3406091994174*v_TR_11_12_mv_c_r
        struct[0].g[158,0] = i_TR_11_12_lv_b_r - 23.3074748658318*v_INV_11_a_i - 44.9834264910554*v_INV_11_a_r + 81.5761620304112*v_INV_11_b_i + 157.441992718694*v_INV_11_b_r - 23.3074748658317*v_INV_11_c_i - 44.9834264910555*v_INV_11_c_r - 30.8306480050881*v_INV_12_a_i - 59.5031506498201*v_INV_12_a_r + 107.907268017808*v_INV_12_b_i + 208.261027274371*v_INV_12_b_r - 30.8306480050881*v_INV_12_c_i - 59.5031506498202*v_INV_12_c_r + 54.138215636915*v_TR_11_12_lv_a_i + 104.486577140876*v_TR_11_12_lv_a_r - 392.185900835935*v_TR_11_12_lv_b_i - 399.486803776848*v_TR_11_12_lv_b_r + 54.138215636915*v_TR_11_12_lv_c_i + 104.486577140876*v_TR_11_12_lv_c_r - 2.3406091994174*v_TR_11_12_mv_a_i - 0.390101533236234*v_TR_11_12_mv_a_r + 2.3406091994174*v_TR_11_12_mv_b_i + 0.390101533236234*v_TR_11_12_mv_b_r
        struct[0].g[159,0] = i_TR_11_12_lv_b_i - 44.9834264910554*v_INV_11_a_i + 23.3074748658318*v_INV_11_a_r + 157.441992718694*v_INV_11_b_i - 81.5761620304112*v_INV_11_b_r - 44.9834264910555*v_INV_11_c_i + 23.3074748658317*v_INV_11_c_r - 59.5031506498201*v_INV_12_a_i + 30.8306480050881*v_INV_12_a_r + 208.261027274371*v_INV_12_b_i - 107.907268017808*v_INV_12_b_r - 59.5031506498202*v_INV_12_c_i + 30.8306480050881*v_INV_12_c_r + 104.486577140876*v_TR_11_12_lv_a_i - 54.138215636915*v_TR_11_12_lv_a_r - 399.486803776848*v_TR_11_12_lv_b_i + 392.185900835935*v_TR_11_12_lv_b_r + 104.486577140876*v_TR_11_12_lv_c_i - 54.138215636915*v_TR_11_12_lv_c_r - 0.390101533236234*v_TR_11_12_mv_a_i + 2.3406091994174*v_TR_11_12_mv_a_r + 0.390101533236234*v_TR_11_12_mv_b_i - 2.3406091994174*v_TR_11_12_mv_b_r
        struct[0].g[160,0] = i_TR_11_12_lv_c_r - 23.3074748658318*v_INV_11_a_i - 44.9834264910554*v_INV_11_a_r - 23.3074748658317*v_INV_11_b_i - 44.9834264910554*v_INV_11_b_r + 81.5761620304112*v_INV_11_c_i + 157.441992718694*v_INV_11_c_r - 30.8306480050882*v_INV_12_a_i - 59.5031506498201*v_INV_12_a_r - 30.8306480050881*v_INV_12_b_i - 59.5031506498202*v_INV_12_b_r + 107.907268017808*v_INV_12_c_i + 208.261027274371*v_INV_12_c_r + 54.138215636915*v_TR_11_12_lv_a_i + 104.486577140876*v_TR_11_12_lv_a_r + 54.138215636915*v_TR_11_12_lv_b_i + 104.486577140876*v_TR_11_12_lv_b_r - 392.185900835935*v_TR_11_12_lv_c_i - 399.486803776848*v_TR_11_12_lv_c_r - 2.3406091994174*v_TR_11_12_mv_b_i - 0.390101533236234*v_TR_11_12_mv_b_r + 2.3406091994174*v_TR_11_12_mv_c_i + 0.390101533236234*v_TR_11_12_mv_c_r
        struct[0].g[161,0] = i_TR_11_12_lv_c_i - 44.9834264910554*v_INV_11_a_i + 23.3074748658318*v_INV_11_a_r - 44.9834264910554*v_INV_11_b_i + 23.3074748658317*v_INV_11_b_r + 157.441992718694*v_INV_11_c_i - 81.5761620304112*v_INV_11_c_r - 59.5031506498201*v_INV_12_a_i + 30.8306480050882*v_INV_12_a_r - 59.5031506498202*v_INV_12_b_i + 30.8306480050881*v_INV_12_b_r + 208.261027274371*v_INV_12_c_i - 107.907268017808*v_INV_12_c_r + 104.486577140876*v_TR_11_12_lv_a_i - 54.138215636915*v_TR_11_12_lv_a_r + 104.486577140876*v_TR_11_12_lv_b_i - 54.138215636915*v_TR_11_12_lv_b_r - 399.486803776848*v_TR_11_12_lv_c_i + 392.185900835935*v_TR_11_12_lv_c_r - 0.390101533236234*v_TR_11_12_mv_b_i + 2.3406091994174*v_TR_11_12_mv_b_r + 0.390101533236234*v_TR_11_12_mv_c_i - 2.3406091994174*v_TR_11_12_mv_c_r
        struct[0].g[162,0] = i_TR_13_mv_a_r + 1.1703045997087*v_TR_13_lv_a_i + 0.195050766618117*v_TR_13_lv_a_r - 1.1703045997087*v_TR_13_lv_b_i - 0.195050766618117*v_TR_13_lv_b_r - 6.62789031305749*v_TR_13_mv_a_i - 8.9749399223794*v_TR_13_mv_a_r + 1.89949032909103*v_TR_13_mv_b_i + 2.56523380021651*v_TR_13_mv_b_r + 1.89949032909103*v_TR_13_mv_c_i + 2.56523380021651*v_TR_13_mv_c_r + 6.60088643956832*v_TR_7_8_mv_a_i + 8.97043541787489*v_TR_7_8_mv_a_r - 1.88596755416238*v_TR_7_8_mv_b_i - 2.56298154796426*v_TR_7_8_mv_b_r - 1.88596755416237*v_TR_7_8_mv_c_i - 2.56298154796426*v_TR_7_8_mv_c_r
        struct[0].g[163,0] = i_TR_13_mv_a_i + 0.195050766618117*v_TR_13_lv_a_i - 1.1703045997087*v_TR_13_lv_a_r - 0.195050766618117*v_TR_13_lv_b_i + 1.1703045997087*v_TR_13_lv_b_r - 8.9749399223794*v_TR_13_mv_a_i + 6.62789031305749*v_TR_13_mv_a_r + 2.56523380021651*v_TR_13_mv_b_i - 1.89949032909103*v_TR_13_mv_b_r + 2.56523380021651*v_TR_13_mv_c_i - 1.89949032909103*v_TR_13_mv_c_r + 8.97043541787489*v_TR_7_8_mv_a_i - 6.60088643956832*v_TR_7_8_mv_a_r - 2.56298154796426*v_TR_7_8_mv_b_i + 1.88596755416238*v_TR_7_8_mv_b_r - 2.56298154796426*v_TR_7_8_mv_c_i + 1.88596755416237*v_TR_7_8_mv_c_r
        struct[0].g[164,0] = i_TR_13_mv_b_r + 1.1703045997087*v_TR_13_lv_b_i + 0.195050766618117*v_TR_13_lv_b_r - 1.1703045997087*v_TR_13_lv_c_i - 0.195050766618117*v_TR_13_lv_c_r + 1.89949032909103*v_TR_13_mv_a_i + 2.56523380021651*v_TR_13_mv_a_r - 6.62789031305749*v_TR_13_mv_b_i - 8.97493992237941*v_TR_13_mv_b_r + 1.89949032909103*v_TR_13_mv_c_i + 2.56523380021651*v_TR_13_mv_c_r - 1.88596755416238*v_TR_7_8_mv_a_i - 2.56298154796426*v_TR_7_8_mv_a_r + 6.60088643956832*v_TR_7_8_mv_b_i + 8.9704354178749*v_TR_7_8_mv_b_r - 1.88596755416237*v_TR_7_8_mv_c_i - 2.56298154796426*v_TR_7_8_mv_c_r
        struct[0].g[165,0] = i_TR_13_mv_b_i + 0.195050766618117*v_TR_13_lv_b_i - 1.1703045997087*v_TR_13_lv_b_r - 0.195050766618117*v_TR_13_lv_c_i + 1.1703045997087*v_TR_13_lv_c_r + 2.56523380021651*v_TR_13_mv_a_i - 1.89949032909103*v_TR_13_mv_a_r - 8.97493992237941*v_TR_13_mv_b_i + 6.62789031305749*v_TR_13_mv_b_r + 2.56523380021651*v_TR_13_mv_c_i - 1.89949032909103*v_TR_13_mv_c_r - 2.56298154796426*v_TR_7_8_mv_a_i + 1.88596755416238*v_TR_7_8_mv_a_r + 8.9704354178749*v_TR_7_8_mv_b_i - 6.60088643956832*v_TR_7_8_mv_b_r - 2.56298154796426*v_TR_7_8_mv_c_i + 1.88596755416237*v_TR_7_8_mv_c_r
        struct[0].g[166,0] = i_TR_13_mv_c_r - 1.1703045997087*v_TR_13_lv_a_i - 0.195050766618117*v_TR_13_lv_a_r + 1.1703045997087*v_TR_13_lv_c_i + 0.195050766618117*v_TR_13_lv_c_r + 1.89949032909103*v_TR_13_mv_a_i + 2.56523380021651*v_TR_13_mv_a_r + 1.89949032909103*v_TR_13_mv_b_i + 2.56523380021651*v_TR_13_mv_b_r - 6.62789031305748*v_TR_13_mv_c_i - 8.9749399223794*v_TR_13_mv_c_r - 1.88596755416237*v_TR_7_8_mv_a_i - 2.56298154796426*v_TR_7_8_mv_a_r - 1.88596755416237*v_TR_7_8_mv_b_i - 2.56298154796426*v_TR_7_8_mv_b_r + 6.60088643956831*v_TR_7_8_mv_c_i + 8.9704354178749*v_TR_7_8_mv_c_r
        struct[0].g[167,0] = i_TR_13_mv_c_i - 0.195050766618117*v_TR_13_lv_a_i + 1.1703045997087*v_TR_13_lv_a_r + 0.195050766618117*v_TR_13_lv_c_i - 1.1703045997087*v_TR_13_lv_c_r + 2.56523380021651*v_TR_13_mv_a_i - 1.89949032909103*v_TR_13_mv_a_r + 2.56523380021651*v_TR_13_mv_b_i - 1.89949032909103*v_TR_13_mv_b_r - 8.9749399223794*v_TR_13_mv_c_i + 6.62789031305748*v_TR_13_mv_c_r - 2.56298154796426*v_TR_7_8_mv_a_i + 1.88596755416237*v_TR_7_8_mv_a_r - 2.56298154796426*v_TR_7_8_mv_b_i + 1.88596755416237*v_TR_7_8_mv_b_r + 8.9704354178749*v_TR_7_8_mv_c_i - 6.60088643956831*v_TR_7_8_mv_c_r
        struct[0].g[168,0] = i_TR_13_lv_a_r + 225.774979236273*v_INV_13_a_i + 435.745709926008*v_INV_13_a_r - 64.5071369246495*v_INV_13_b_i - 124.498774264574*v_INV_13_b_r - 64.5071369246495*v_INV_13_c_i - 124.498774264574*v_INV_13_c_r - 327.126282868141*v_TR_13_lv_a_i - 452.6376018179*v_TR_13_lv_a_r + 64.5071560124429*v_TR_13_lv_b_i + 124.498774264574*v_TR_13_lv_b_r + 64.5071560124428*v_TR_13_lv_c_i + 124.498774264574*v_TR_13_lv_c_r + 1.1703045997087*v_TR_13_mv_a_i + 0.195050766618117*v_TR_13_mv_a_r - 1.1703045997087*v_TR_13_mv_c_i - 0.195050766618117*v_TR_13_mv_c_r
        struct[0].g[169,0] = i_TR_13_lv_a_i + 435.745709926008*v_INV_13_a_i - 225.774979236273*v_INV_13_a_r - 124.498774264574*v_INV_13_b_i + 64.5071369246495*v_INV_13_b_r - 124.498774264574*v_INV_13_c_i + 64.5071369246495*v_INV_13_c_r - 452.6376018179*v_TR_13_lv_a_i + 327.126282868141*v_TR_13_lv_a_r + 124.498774264574*v_TR_13_lv_b_i - 64.5071560124429*v_TR_13_lv_b_r + 124.498774264574*v_TR_13_lv_c_i - 64.5071560124428*v_TR_13_lv_c_r + 0.195050766618117*v_TR_13_mv_a_i - 1.1703045997087*v_TR_13_mv_a_r - 0.195050766618117*v_TR_13_mv_c_i + 1.1703045997087*v_TR_13_mv_c_r
        struct[0].g[170,0] = i_TR_13_lv_b_r - 64.5071369246495*v_INV_13_a_i - 124.498774264574*v_INV_13_a_r + 225.774979236273*v_INV_13_b_i + 435.745709926008*v_INV_13_b_r - 64.5071369246494*v_INV_13_c_i - 124.498774264574*v_INV_13_c_r + 64.5071560124428*v_TR_13_lv_a_i + 124.498774264574*v_TR_13_lv_a_r - 327.126282868141*v_TR_13_lv_b_i - 452.6376018179*v_TR_13_lv_b_r + 64.5071560124428*v_TR_13_lv_c_i + 124.498774264574*v_TR_13_lv_c_r - 1.1703045997087*v_TR_13_mv_a_i - 0.195050766618117*v_TR_13_mv_a_r + 1.1703045997087*v_TR_13_mv_b_i + 0.195050766618117*v_TR_13_mv_b_r
        struct[0].g[171,0] = i_TR_13_lv_b_i - 124.498774264574*v_INV_13_a_i + 64.5071369246495*v_INV_13_a_r + 435.745709926008*v_INV_13_b_i - 225.774979236273*v_INV_13_b_r - 124.498774264574*v_INV_13_c_i + 64.5071369246494*v_INV_13_c_r + 124.498774264574*v_TR_13_lv_a_i - 64.5071560124428*v_TR_13_lv_a_r - 452.6376018179*v_TR_13_lv_b_i + 327.126282868141*v_TR_13_lv_b_r + 124.498774264574*v_TR_13_lv_c_i - 64.5071560124428*v_TR_13_lv_c_r - 0.195050766618117*v_TR_13_mv_a_i + 1.1703045997087*v_TR_13_mv_a_r + 0.195050766618117*v_TR_13_mv_b_i - 1.1703045997087*v_TR_13_mv_b_r
        struct[0].g[172,0] = i_TR_13_lv_c_r - 64.5071369246495*v_INV_13_a_i - 124.498774264574*v_INV_13_a_r - 64.5071369246494*v_INV_13_b_i - 124.498774264574*v_INV_13_b_r + 225.774979236273*v_INV_13_c_i + 435.745709926008*v_INV_13_c_r + 64.5071560124429*v_TR_13_lv_a_i + 124.498774264574*v_TR_13_lv_a_r + 64.5071560124428*v_TR_13_lv_b_i + 124.498774264574*v_TR_13_lv_b_r - 327.126282868141*v_TR_13_lv_c_i - 452.6376018179*v_TR_13_lv_c_r - 1.1703045997087*v_TR_13_mv_b_i - 0.195050766618117*v_TR_13_mv_b_r + 1.1703045997087*v_TR_13_mv_c_i + 0.195050766618117*v_TR_13_mv_c_r
        struct[0].g[173,0] = i_TR_13_lv_c_i - 124.498774264574*v_INV_13_a_i + 64.5071369246495*v_INV_13_a_r - 124.498774264574*v_INV_13_b_i + 64.5071369246494*v_INV_13_b_r + 435.745709926008*v_INV_13_c_i - 225.774979236273*v_INV_13_c_r + 124.498774264574*v_TR_13_lv_a_i - 64.5071560124429*v_TR_13_lv_a_r + 124.498774264574*v_TR_13_lv_b_i - 64.5071560124428*v_TR_13_lv_b_r - 452.6376018179*v_TR_13_lv_c_i + 327.126282868141*v_TR_13_lv_c_r - 0.195050766618117*v_TR_13_mv_b_i + 1.1703045997087*v_TR_13_mv_b_r + 0.195050766618117*v_TR_13_mv_c_i - 1.1703045997087*v_TR_13_mv_c_r
        struct[0].g[174,0] = i_INV_1_a_i*v_INV_1_a_i + i_INV_1_a_r*v_INV_1_a_r - p_INV_1_a
        struct[0].g[175,0] = i_INV_1_b_i*v_INV_1_b_i + i_INV_1_b_r*v_INV_1_b_r - p_INV_1_b
        struct[0].g[176,0] = i_INV_1_c_i*v_INV_1_c_i + i_INV_1_c_r*v_INV_1_c_r - p_INV_1_c
        struct[0].g[177,0] = -i_INV_1_a_i*v_INV_1_a_r + i_INV_1_a_r*v_INV_1_a_i - q_INV_1_a
        struct[0].g[178,0] = -i_INV_1_b_i*v_INV_1_b_r + i_INV_1_b_r*v_INV_1_b_i - q_INV_1_b
        struct[0].g[179,0] = -i_INV_1_c_i*v_INV_1_c_r + i_INV_1_c_r*v_INV_1_c_i - q_INV_1_c
        struct[0].g[180,0] = -v_m_INV_1 + (v_INV_1_a_i**2 + v_INV_1_a_r**2)**0.5/V_base_INV_1
        struct[0].g[181,0] = -v_m_TR_1_2_mv + (v_TR_1_2_mv_a_i**2 + v_TR_1_2_mv_a_r**2)**0.5/V_base_TR_1_2_mv
        struct[0].g[182,0] = Dq_r_INV_1 + K_p_v_INV_1*(Dv_r_INV_1 - u_ctrl_v_INV_1*v_m_TR_1_2_mv + v_loc_ref_INV_1 - v_m_INV_1*(1.0 - u_ctrl_v_INV_1)) - i_reac_ref_INV_1
        struct[0].g[183,0] = S_base_INV_1*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_1, I_max_INV_1 < -i_reac_ref_INV_1), (I_max_INV_1, I_max_INV_1 < i_reac_ref_INV_1), (i_reac_ref_INV_1, True)])) - q_ref_INV_1
        struct[0].g[184,0] = i_INV_2_a_i*v_INV_2_a_i + i_INV_2_a_r*v_INV_2_a_r - p_INV_2_a
        struct[0].g[185,0] = i_INV_2_b_i*v_INV_2_b_i + i_INV_2_b_r*v_INV_2_b_r - p_INV_2_b
        struct[0].g[186,0] = i_INV_2_c_i*v_INV_2_c_i + i_INV_2_c_r*v_INV_2_c_r - p_INV_2_c
        struct[0].g[187,0] = -i_INV_2_a_i*v_INV_2_a_r + i_INV_2_a_r*v_INV_2_a_i - q_INV_2_a
        struct[0].g[188,0] = -i_INV_2_b_i*v_INV_2_b_r + i_INV_2_b_r*v_INV_2_b_i - q_INV_2_b
        struct[0].g[189,0] = -i_INV_2_c_i*v_INV_2_c_r + i_INV_2_c_r*v_INV_2_c_i - q_INV_2_c
        struct[0].g[190,0] = -v_m_INV_2 + (v_INV_2_a_i**2 + v_INV_2_a_r**2)**0.5/V_base_INV_2
        struct[0].g[191,0] = Dq_r_INV_2 + K_p_v_INV_2*(Dv_r_INV_2 - u_ctrl_v_INV_2*v_m_TR_1_2_mv + v_loc_ref_INV_2 - v_m_INV_2*(1.0 - u_ctrl_v_INV_2)) - i_reac_ref_INV_2
        struct[0].g[192,0] = S_base_INV_2*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_2, I_max_INV_2 < -i_reac_ref_INV_2), (I_max_INV_2, I_max_INV_2 < i_reac_ref_INV_2), (i_reac_ref_INV_2, True)])) - q_ref_INV_2
        struct[0].g[193,0] = i_INV_3_a_i*v_INV_3_a_i + i_INV_3_a_r*v_INV_3_a_r - p_INV_3_a
        struct[0].g[194,0] = i_INV_3_b_i*v_INV_3_b_i + i_INV_3_b_r*v_INV_3_b_r - p_INV_3_b
        struct[0].g[195,0] = i_INV_3_c_i*v_INV_3_c_i + i_INV_3_c_r*v_INV_3_c_r - p_INV_3_c
        struct[0].g[196,0] = -i_INV_3_a_i*v_INV_3_a_r + i_INV_3_a_r*v_INV_3_a_i - q_INV_3_a
        struct[0].g[197,0] = -i_INV_3_b_i*v_INV_3_b_r + i_INV_3_b_r*v_INV_3_b_i - q_INV_3_b
        struct[0].g[198,0] = -i_INV_3_c_i*v_INV_3_c_r + i_INV_3_c_r*v_INV_3_c_i - q_INV_3_c
        struct[0].g[199,0] = -v_m_INV_3 + (v_INV_3_a_i**2 + v_INV_3_a_r**2)**0.5/V_base_INV_3
        struct[0].g[200,0] = -v_m_TR_3_4_mv + (v_TR_3_4_mv_a_i**2 + v_TR_3_4_mv_a_r**2)**0.5/V_base_TR_3_4_mv
        struct[0].g[201,0] = Dq_r_INV_3 + K_p_v_INV_3*(Dv_r_INV_3 - u_ctrl_v_INV_3*v_m_TR_3_4_mv + v_loc_ref_INV_3 - v_m_INV_3*(1.0 - u_ctrl_v_INV_3)) - i_reac_ref_INV_3
        struct[0].g[202,0] = S_base_INV_3*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_3, I_max_INV_3 < -i_reac_ref_INV_3), (I_max_INV_3, I_max_INV_3 < i_reac_ref_INV_3), (i_reac_ref_INV_3, True)])) - q_ref_INV_3
        struct[0].g[203,0] = i_INV_4_a_i*v_INV_4_a_i + i_INV_4_a_r*v_INV_4_a_r - p_INV_4_a
        struct[0].g[204,0] = i_INV_4_b_i*v_INV_4_b_i + i_INV_4_b_r*v_INV_4_b_r - p_INV_4_b
        struct[0].g[205,0] = i_INV_4_c_i*v_INV_4_c_i + i_INV_4_c_r*v_INV_4_c_r - p_INV_4_c
        struct[0].g[206,0] = -i_INV_4_a_i*v_INV_4_a_r + i_INV_4_a_r*v_INV_4_a_i - q_INV_4_a
        struct[0].g[207,0] = -i_INV_4_b_i*v_INV_4_b_r + i_INV_4_b_r*v_INV_4_b_i - q_INV_4_b
        struct[0].g[208,0] = -i_INV_4_c_i*v_INV_4_c_r + i_INV_4_c_r*v_INV_4_c_i - q_INV_4_c
        struct[0].g[209,0] = -v_m_INV_4 + (v_INV_4_a_i**2 + v_INV_4_a_r**2)**0.5/V_base_INV_4
        struct[0].g[210,0] = Dq_r_INV_4 + K_p_v_INV_4*(Dv_r_INV_4 - u_ctrl_v_INV_4*v_m_TR_3_4_mv + v_loc_ref_INV_4 - v_m_INV_4*(1.0 - u_ctrl_v_INV_4)) - i_reac_ref_INV_4
        struct[0].g[211,0] = S_base_INV_4*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_4, I_max_INV_4 < -i_reac_ref_INV_4), (I_max_INV_4, I_max_INV_4 < i_reac_ref_INV_4), (i_reac_ref_INV_4, True)])) - q_ref_INV_4
        struct[0].g[212,0] = i_INV_5_a_i*v_INV_5_a_i + i_INV_5_a_r*v_INV_5_a_r - p_INV_5_a
        struct[0].g[213,0] = i_INV_5_b_i*v_INV_5_b_i + i_INV_5_b_r*v_INV_5_b_r - p_INV_5_b
        struct[0].g[214,0] = i_INV_5_c_i*v_INV_5_c_i + i_INV_5_c_r*v_INV_5_c_r - p_INV_5_c
        struct[0].g[215,0] = -i_INV_5_a_i*v_INV_5_a_r + i_INV_5_a_r*v_INV_5_a_i - q_INV_5_a
        struct[0].g[216,0] = -i_INV_5_b_i*v_INV_5_b_r + i_INV_5_b_r*v_INV_5_b_i - q_INV_5_b
        struct[0].g[217,0] = -i_INV_5_c_i*v_INV_5_c_r + i_INV_5_c_r*v_INV_5_c_i - q_INV_5_c
        struct[0].g[218,0] = -v_m_INV_5 + (v_INV_5_a_i**2 + v_INV_5_a_r**2)**0.5/V_base_INV_5
        struct[0].g[219,0] = -v_m_TR_5_6_mv + (v_TR_5_6_mv_a_i**2 + v_TR_5_6_mv_a_r**2)**0.5/V_base_TR_5_6_mv
        struct[0].g[220,0] = Dq_r_INV_5 + K_p_v_INV_5*(Dv_r_INV_5 - u_ctrl_v_INV_5*v_m_TR_5_6_mv + v_loc_ref_INV_5 - v_m_INV_5*(1.0 - u_ctrl_v_INV_5)) - i_reac_ref_INV_5
        struct[0].g[221,0] = S_base_INV_5*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_5, I_max_INV_5 < -i_reac_ref_INV_5), (I_max_INV_5, I_max_INV_5 < i_reac_ref_INV_5), (i_reac_ref_INV_5, True)])) - q_ref_INV_5
        struct[0].g[222,0] = i_INV_6_a_i*v_INV_6_a_i + i_INV_6_a_r*v_INV_6_a_r - p_INV_6_a
        struct[0].g[223,0] = i_INV_6_b_i*v_INV_6_b_i + i_INV_6_b_r*v_INV_6_b_r - p_INV_6_b
        struct[0].g[224,0] = i_INV_6_c_i*v_INV_6_c_i + i_INV_6_c_r*v_INV_6_c_r - p_INV_6_c
        struct[0].g[225,0] = -i_INV_6_a_i*v_INV_6_a_r + i_INV_6_a_r*v_INV_6_a_i - q_INV_6_a
        struct[0].g[226,0] = -i_INV_6_b_i*v_INV_6_b_r + i_INV_6_b_r*v_INV_6_b_i - q_INV_6_b
        struct[0].g[227,0] = -i_INV_6_c_i*v_INV_6_c_r + i_INV_6_c_r*v_INV_6_c_i - q_INV_6_c
        struct[0].g[228,0] = -v_m_INV_6 + (v_INV_6_a_i**2 + v_INV_6_a_r**2)**0.5/V_base_INV_6
        struct[0].g[229,0] = Dq_r_INV_6 + K_p_v_INV_6*(Dv_r_INV_6 - u_ctrl_v_INV_6*v_m_TR_5_6_mv + v_loc_ref_INV_6 - v_m_INV_6*(1.0 - u_ctrl_v_INV_6)) - i_reac_ref_INV_6
        struct[0].g[230,0] = S_base_INV_6*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_6, I_max_INV_6 < -i_reac_ref_INV_6), (I_max_INV_6, I_max_INV_6 < i_reac_ref_INV_6), (i_reac_ref_INV_6, True)])) - q_ref_INV_6
        struct[0].g[231,0] = i_INV_7_a_i*v_INV_7_a_i + i_INV_7_a_r*v_INV_7_a_r - p_INV_7_a
        struct[0].g[232,0] = i_INV_7_b_i*v_INV_7_b_i + i_INV_7_b_r*v_INV_7_b_r - p_INV_7_b
        struct[0].g[233,0] = i_INV_7_c_i*v_INV_7_c_i + i_INV_7_c_r*v_INV_7_c_r - p_INV_7_c
        struct[0].g[234,0] = -i_INV_7_a_i*v_INV_7_a_r + i_INV_7_a_r*v_INV_7_a_i - q_INV_7_a
        struct[0].g[235,0] = -i_INV_7_b_i*v_INV_7_b_r + i_INV_7_b_r*v_INV_7_b_i - q_INV_7_b
        struct[0].g[236,0] = -i_INV_7_c_i*v_INV_7_c_r + i_INV_7_c_r*v_INV_7_c_i - q_INV_7_c
        struct[0].g[237,0] = -v_m_INV_7 + (v_INV_7_a_i**2 + v_INV_7_a_r**2)**0.5/V_base_INV_7
        struct[0].g[238,0] = -v_m_TR_7_8_mv + (v_TR_7_8_mv_a_i**2 + v_TR_7_8_mv_a_r**2)**0.5/V_base_TR_7_8_mv
        struct[0].g[239,0] = Dq_r_INV_7 + K_p_v_INV_7*(Dv_r_INV_7 - u_ctrl_v_INV_7*v_m_TR_7_8_mv + v_loc_ref_INV_7 - v_m_INV_7*(1.0 - u_ctrl_v_INV_7)) - i_reac_ref_INV_7
        struct[0].g[240,0] = S_base_INV_7*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_7, I_max_INV_7 < -i_reac_ref_INV_7), (I_max_INV_7, I_max_INV_7 < i_reac_ref_INV_7), (i_reac_ref_INV_7, True)])) - q_ref_INV_7
        struct[0].g[241,0] = i_INV_8_a_i*v_INV_8_a_i + i_INV_8_a_r*v_INV_8_a_r - p_INV_8_a
        struct[0].g[242,0] = i_INV_8_b_i*v_INV_8_b_i + i_INV_8_b_r*v_INV_8_b_r - p_INV_8_b
        struct[0].g[243,0] = i_INV_8_c_i*v_INV_8_c_i + i_INV_8_c_r*v_INV_8_c_r - p_INV_8_c
        struct[0].g[244,0] = -i_INV_8_a_i*v_INV_8_a_r + i_INV_8_a_r*v_INV_8_a_i - q_INV_8_a
        struct[0].g[245,0] = -i_INV_8_b_i*v_INV_8_b_r + i_INV_8_b_r*v_INV_8_b_i - q_INV_8_b
        struct[0].g[246,0] = -i_INV_8_c_i*v_INV_8_c_r + i_INV_8_c_r*v_INV_8_c_i - q_INV_8_c
        struct[0].g[247,0] = -v_m_INV_8 + (v_INV_8_a_i**2 + v_INV_8_a_r**2)**0.5/V_base_INV_8
        struct[0].g[248,0] = Dq_r_INV_8 + K_p_v_INV_8*(Dv_r_INV_8 - u_ctrl_v_INV_8*v_m_TR_7_8_mv + v_loc_ref_INV_8 - v_m_INV_8*(1.0 - u_ctrl_v_INV_8)) - i_reac_ref_INV_8
        struct[0].g[249,0] = S_base_INV_8*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_8, I_max_INV_8 < -i_reac_ref_INV_8), (I_max_INV_8, I_max_INV_8 < i_reac_ref_INV_8), (i_reac_ref_INV_8, True)])) - q_ref_INV_8
        struct[0].g[250,0] = i_INV_9_a_i*v_INV_9_a_i + i_INV_9_a_r*v_INV_9_a_r - p_INV_9_a
        struct[0].g[251,0] = i_INV_9_b_i*v_INV_9_b_i + i_INV_9_b_r*v_INV_9_b_r - p_INV_9_b
        struct[0].g[252,0] = i_INV_9_c_i*v_INV_9_c_i + i_INV_9_c_r*v_INV_9_c_r - p_INV_9_c
        struct[0].g[253,0] = -i_INV_9_a_i*v_INV_9_a_r + i_INV_9_a_r*v_INV_9_a_i - q_INV_9_a
        struct[0].g[254,0] = -i_INV_9_b_i*v_INV_9_b_r + i_INV_9_b_r*v_INV_9_b_i - q_INV_9_b
        struct[0].g[255,0] = -i_INV_9_c_i*v_INV_9_c_r + i_INV_9_c_r*v_INV_9_c_i - q_INV_9_c
        struct[0].g[256,0] = -v_m_INV_9 + (v_INV_9_a_i**2 + v_INV_9_a_r**2)**0.5/V_base_INV_9
        struct[0].g[257,0] = -v_m_TR_9_10_mv + (v_TR_9_10_mv_a_i**2 + v_TR_9_10_mv_a_r**2)**0.5/V_base_TR_9_10_mv
        struct[0].g[258,0] = Dq_r_INV_9 + K_p_v_INV_9*(Dv_r_INV_9 - u_ctrl_v_INV_9*v_m_TR_9_10_mv + v_loc_ref_INV_9 - v_m_INV_9*(1.0 - u_ctrl_v_INV_9)) - i_reac_ref_INV_9
        struct[0].g[259,0] = S_base_INV_9*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_9, I_max_INV_9 < -i_reac_ref_INV_9), (I_max_INV_9, I_max_INV_9 < i_reac_ref_INV_9), (i_reac_ref_INV_9, True)])) - q_ref_INV_9
        struct[0].g[260,0] = i_INV_10_a_i*v_INV_10_a_i + i_INV_10_a_r*v_INV_10_a_r - p_INV_10_a
        struct[0].g[261,0] = i_INV_10_b_i*v_INV_10_b_i + i_INV_10_b_r*v_INV_10_b_r - p_INV_10_b
        struct[0].g[262,0] = i_INV_10_c_i*v_INV_10_c_i + i_INV_10_c_r*v_INV_10_c_r - p_INV_10_c
        struct[0].g[263,0] = -i_INV_10_a_i*v_INV_10_a_r + i_INV_10_a_r*v_INV_10_a_i - q_INV_10_a
        struct[0].g[264,0] = -i_INV_10_b_i*v_INV_10_b_r + i_INV_10_b_r*v_INV_10_b_i - q_INV_10_b
        struct[0].g[265,0] = -i_INV_10_c_i*v_INV_10_c_r + i_INV_10_c_r*v_INV_10_c_i - q_INV_10_c
        struct[0].g[266,0] = -v_m_INV_10 + (v_INV_10_a_i**2 + v_INV_10_a_r**2)**0.5/V_base_INV_10
        struct[0].g[267,0] = Dq_r_INV_10 + K_p_v_INV_10*(Dv_r_INV_10 - u_ctrl_v_INV_10*v_m_TR_9_10_mv + v_loc_ref_INV_10 - v_m_INV_10*(1.0 - u_ctrl_v_INV_10)) - i_reac_ref_INV_10
        struct[0].g[268,0] = S_base_INV_10*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_10, I_max_INV_10 < -i_reac_ref_INV_10), (I_max_INV_10, I_max_INV_10 < i_reac_ref_INV_10), (i_reac_ref_INV_10, True)])) - q_ref_INV_10
        struct[0].g[269,0] = i_INV_11_a_i*v_INV_11_a_i + i_INV_11_a_r*v_INV_11_a_r - p_INV_11_a
        struct[0].g[270,0] = i_INV_11_b_i*v_INV_11_b_i + i_INV_11_b_r*v_INV_11_b_r - p_INV_11_b
        struct[0].g[271,0] = i_INV_11_c_i*v_INV_11_c_i + i_INV_11_c_r*v_INV_11_c_r - p_INV_11_c
        struct[0].g[272,0] = -i_INV_11_a_i*v_INV_11_a_r + i_INV_11_a_r*v_INV_11_a_i - q_INV_11_a
        struct[0].g[273,0] = -i_INV_11_b_i*v_INV_11_b_r + i_INV_11_b_r*v_INV_11_b_i - q_INV_11_b
        struct[0].g[274,0] = -i_INV_11_c_i*v_INV_11_c_r + i_INV_11_c_r*v_INV_11_c_i - q_INV_11_c
        struct[0].g[275,0] = -v_m_INV_11 + (v_INV_11_a_i**2 + v_INV_11_a_r**2)**0.5/V_base_INV_11
        struct[0].g[276,0] = -v_m_TR_11_12_mv + (v_TR_11_12_mv_a_i**2 + v_TR_11_12_mv_a_r**2)**0.5/V_base_TR_11_12_mv
        struct[0].g[277,0] = Dq_r_INV_11 + K_p_v_INV_11*(Dv_r_INV_11 - u_ctrl_v_INV_11*v_m_TR_11_12_mv + v_loc_ref_INV_11 - v_m_INV_11*(1.0 - u_ctrl_v_INV_11)) - i_reac_ref_INV_11
        struct[0].g[278,0] = S_base_INV_11*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_11, I_max_INV_11 < -i_reac_ref_INV_11), (I_max_INV_11, I_max_INV_11 < i_reac_ref_INV_11), (i_reac_ref_INV_11, True)])) - q_ref_INV_11
        struct[0].g[279,0] = i_INV_12_a_i*v_INV_12_a_i + i_INV_12_a_r*v_INV_12_a_r - p_INV_12_a
        struct[0].g[280,0] = i_INV_12_b_i*v_INV_12_b_i + i_INV_12_b_r*v_INV_12_b_r - p_INV_12_b
        struct[0].g[281,0] = i_INV_12_c_i*v_INV_12_c_i + i_INV_12_c_r*v_INV_12_c_r - p_INV_12_c
        struct[0].g[282,0] = -i_INV_12_a_i*v_INV_12_a_r + i_INV_12_a_r*v_INV_12_a_i - q_INV_12_a
        struct[0].g[283,0] = -i_INV_12_b_i*v_INV_12_b_r + i_INV_12_b_r*v_INV_12_b_i - q_INV_12_b
        struct[0].g[284,0] = -i_INV_12_c_i*v_INV_12_c_r + i_INV_12_c_r*v_INV_12_c_i - q_INV_12_c
        struct[0].g[285,0] = -v_m_INV_12 + (v_INV_12_a_i**2 + v_INV_12_a_r**2)**0.5/V_base_INV_12
        struct[0].g[286,0] = Dq_r_INV_12 + K_p_v_INV_12*(Dv_r_INV_12 - u_ctrl_v_INV_12*v_m_TR_11_12_mv + v_loc_ref_INV_12 - v_m_INV_12*(1.0 - u_ctrl_v_INV_12)) - i_reac_ref_INV_12
        struct[0].g[287,0] = S_base_INV_12*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_12, I_max_INV_12 < -i_reac_ref_INV_12), (I_max_INV_12, I_max_INV_12 < i_reac_ref_INV_12), (i_reac_ref_INV_12, True)])) - q_ref_INV_12
        struct[0].g[288,0] = i_INV_13_a_i*v_INV_13_a_i + i_INV_13_a_r*v_INV_13_a_r - p_INV_13_a
        struct[0].g[289,0] = i_INV_13_b_i*v_INV_13_b_i + i_INV_13_b_r*v_INV_13_b_r - p_INV_13_b
        struct[0].g[290,0] = i_INV_13_c_i*v_INV_13_c_i + i_INV_13_c_r*v_INV_13_c_r - p_INV_13_c
        struct[0].g[291,0] = -i_INV_13_a_i*v_INV_13_a_r + i_INV_13_a_r*v_INV_13_a_i - q_INV_13_a
        struct[0].g[292,0] = -i_INV_13_b_i*v_INV_13_b_r + i_INV_13_b_r*v_INV_13_b_i - q_INV_13_b
        struct[0].g[293,0] = -i_INV_13_c_i*v_INV_13_c_r + i_INV_13_c_r*v_INV_13_c_i - q_INV_13_c
        struct[0].g[294,0] = -v_m_INV_13 + (v_INV_13_a_i**2 + v_INV_13_a_r**2)**0.5/V_base_INV_13
        struct[0].g[295,0] = -v_m_TR_13_mv + (v_TR_13_mv_a_i**2 + v_TR_13_mv_a_r**2)**0.5/V_base_TR_13_mv
        struct[0].g[296,0] = Dq_r_INV_13 + K_p_v_INV_13*(Dv_r_INV_13 - u_ctrl_v_INV_13*v_m_TR_13_mv + v_loc_ref_INV_13 - v_m_INV_13*(1.0 - u_ctrl_v_INV_13)) - i_reac_ref_INV_13
        struct[0].g[297,0] = S_base_INV_13*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_13, I_max_INV_13 < -i_reac_ref_INV_13), (I_max_INV_13, I_max_INV_13 < i_reac_ref_INV_13), (i_reac_ref_INV_13, True)])) - q_ref_INV_13
    
    # Outputs:
    if mode == 3:

    
        pass

    if mode == 10:

        struct[0].Fx[0,0] = -1/T_pq_INV_1
        struct[0].Fx[1,1] = -1/T_pq_INV_1
        struct[0].Fx[2,2] = -1/T_pq_INV_1
        struct[0].Fx[3,3] = -1/T_pq_INV_1
        struct[0].Fx[4,4] = -1/T_pq_INV_1
        struct[0].Fx[5,5] = -1/T_pq_INV_1
        struct[0].Fx[6,6] = -1/T_pq_INV_2
        struct[0].Fx[7,7] = -1/T_pq_INV_2
        struct[0].Fx[8,8] = -1/T_pq_INV_2
        struct[0].Fx[9,9] = -1/T_pq_INV_2
        struct[0].Fx[10,10] = -1/T_pq_INV_2
        struct[0].Fx[11,11] = -1/T_pq_INV_2
        struct[0].Fx[12,12] = -1/T_pq_INV_3
        struct[0].Fx[13,13] = -1/T_pq_INV_3
        struct[0].Fx[14,14] = -1/T_pq_INV_3
        struct[0].Fx[15,15] = -1/T_pq_INV_3
        struct[0].Fx[16,16] = -1/T_pq_INV_3
        struct[0].Fx[17,17] = -1/T_pq_INV_3
        struct[0].Fx[18,18] = -1/T_pq_INV_4
        struct[0].Fx[19,19] = -1/T_pq_INV_4
        struct[0].Fx[20,20] = -1/T_pq_INV_4
        struct[0].Fx[21,21] = -1/T_pq_INV_4
        struct[0].Fx[22,22] = -1/T_pq_INV_4
        struct[0].Fx[23,23] = -1/T_pq_INV_4
        struct[0].Fx[24,24] = -1/T_pq_INV_5
        struct[0].Fx[25,25] = -1/T_pq_INV_5
        struct[0].Fx[26,26] = -1/T_pq_INV_5
        struct[0].Fx[27,27] = -1/T_pq_INV_5
        struct[0].Fx[28,28] = -1/T_pq_INV_5
        struct[0].Fx[29,29] = -1/T_pq_INV_5
        struct[0].Fx[30,30] = -1/T_pq_INV_6
        struct[0].Fx[31,31] = -1/T_pq_INV_6
        struct[0].Fx[32,32] = -1/T_pq_INV_6
        struct[0].Fx[33,33] = -1/T_pq_INV_6
        struct[0].Fx[34,34] = -1/T_pq_INV_6
        struct[0].Fx[35,35] = -1/T_pq_INV_6
        struct[0].Fx[36,36] = -1/T_pq_INV_7
        struct[0].Fx[37,37] = -1/T_pq_INV_7
        struct[0].Fx[38,38] = -1/T_pq_INV_7
        struct[0].Fx[39,39] = -1/T_pq_INV_7
        struct[0].Fx[40,40] = -1/T_pq_INV_7
        struct[0].Fx[41,41] = -1/T_pq_INV_7
        struct[0].Fx[42,42] = -1/T_pq_INV_8
        struct[0].Fx[43,43] = -1/T_pq_INV_8
        struct[0].Fx[44,44] = -1/T_pq_INV_8
        struct[0].Fx[45,45] = -1/T_pq_INV_8
        struct[0].Fx[46,46] = -1/T_pq_INV_8
        struct[0].Fx[47,47] = -1/T_pq_INV_8
        struct[0].Fx[48,48] = -1/T_pq_INV_9
        struct[0].Fx[49,49] = -1/T_pq_INV_9
        struct[0].Fx[50,50] = -1/T_pq_INV_9
        struct[0].Fx[51,51] = -1/T_pq_INV_9
        struct[0].Fx[52,52] = -1/T_pq_INV_9
        struct[0].Fx[53,53] = -1/T_pq_INV_9
        struct[0].Fx[54,54] = -1/T_pq_INV_10
        struct[0].Fx[55,55] = -1/T_pq_INV_10
        struct[0].Fx[56,56] = -1/T_pq_INV_10
        struct[0].Fx[57,57] = -1/T_pq_INV_10
        struct[0].Fx[58,58] = -1/T_pq_INV_10
        struct[0].Fx[59,59] = -1/T_pq_INV_10
        struct[0].Fx[60,60] = -1/T_pq_INV_11
        struct[0].Fx[61,61] = -1/T_pq_INV_11
        struct[0].Fx[62,62] = -1/T_pq_INV_11
        struct[0].Fx[63,63] = -1/T_pq_INV_11
        struct[0].Fx[64,64] = -1/T_pq_INV_11
        struct[0].Fx[65,65] = -1/T_pq_INV_11
        struct[0].Fx[66,66] = -1/T_pq_INV_12
        struct[0].Fx[67,67] = -1/T_pq_INV_12
        struct[0].Fx[68,68] = -1/T_pq_INV_12
        struct[0].Fx[69,69] = -1/T_pq_INV_12
        struct[0].Fx[70,70] = -1/T_pq_INV_12
        struct[0].Fx[71,71] = -1/T_pq_INV_12
        struct[0].Fx[72,72] = -1/T_pq_INV_13
        struct[0].Fx[73,73] = -1/T_pq_INV_13
        struct[0].Fx[74,74] = -1/T_pq_INV_13
        struct[0].Fx[75,75] = -1/T_pq_INV_13
        struct[0].Fx[76,76] = -1/T_pq_INV_13
        struct[0].Fx[77,77] = -1/T_pq_INV_13

    if mode == 11:

        struct[0].Fy[3,183] = 1/(3*T_pq_INV_1)
        struct[0].Fy[4,183] = 1/(3*T_pq_INV_1)
        struct[0].Fy[5,183] = 1/(3*T_pq_INV_1)
        struct[0].Fy[9,192] = 1/(3*T_pq_INV_2)
        struct[0].Fy[10,192] = 1/(3*T_pq_INV_2)
        struct[0].Fy[11,192] = 1/(3*T_pq_INV_2)
        struct[0].Fy[15,202] = 1/(3*T_pq_INV_3)
        struct[0].Fy[16,202] = 1/(3*T_pq_INV_3)
        struct[0].Fy[17,202] = 1/(3*T_pq_INV_3)
        struct[0].Fy[21,211] = 1/(3*T_pq_INV_4)
        struct[0].Fy[22,211] = 1/(3*T_pq_INV_4)
        struct[0].Fy[23,211] = 1/(3*T_pq_INV_4)
        struct[0].Fy[27,221] = 1/(3*T_pq_INV_5)
        struct[0].Fy[28,221] = 1/(3*T_pq_INV_5)
        struct[0].Fy[29,221] = 1/(3*T_pq_INV_5)
        struct[0].Fy[33,230] = 1/(3*T_pq_INV_6)
        struct[0].Fy[34,230] = 1/(3*T_pq_INV_6)
        struct[0].Fy[35,230] = 1/(3*T_pq_INV_6)
        struct[0].Fy[39,240] = 1/(3*T_pq_INV_7)
        struct[0].Fy[40,240] = 1/(3*T_pq_INV_7)
        struct[0].Fy[41,240] = 1/(3*T_pq_INV_7)
        struct[0].Fy[45,249] = 1/(3*T_pq_INV_8)
        struct[0].Fy[46,249] = 1/(3*T_pq_INV_8)
        struct[0].Fy[47,249] = 1/(3*T_pq_INV_8)
        struct[0].Fy[51,259] = 1/(3*T_pq_INV_9)
        struct[0].Fy[52,259] = 1/(3*T_pq_INV_9)
        struct[0].Fy[53,259] = 1/(3*T_pq_INV_9)
        struct[0].Fy[57,268] = 1/(3*T_pq_INV_10)
        struct[0].Fy[58,268] = 1/(3*T_pq_INV_10)
        struct[0].Fy[59,268] = 1/(3*T_pq_INV_10)
        struct[0].Fy[63,278] = 1/(3*T_pq_INV_11)
        struct[0].Fy[64,278] = 1/(3*T_pq_INV_11)
        struct[0].Fy[65,278] = 1/(3*T_pq_INV_11)
        struct[0].Fy[69,287] = 1/(3*T_pq_INV_12)
        struct[0].Fy[70,287] = 1/(3*T_pq_INV_12)
        struct[0].Fy[71,287] = 1/(3*T_pq_INV_12)
        struct[0].Fy[75,297] = 1/(3*T_pq_INV_13)
        struct[0].Fy[76,297] = 1/(3*T_pq_INV_13)
        struct[0].Fy[77,297] = 1/(3*T_pq_INV_13)

        struct[0].Gx[174,0] = -1
        struct[0].Gx[175,1] = -1
        struct[0].Gx[176,2] = -1
        struct[0].Gx[177,3] = -1
        struct[0].Gx[178,4] = -1
        struct[0].Gx[179,5] = -1
        struct[0].Gx[184,6] = -1
        struct[0].Gx[185,7] = -1
        struct[0].Gx[186,8] = -1
        struct[0].Gx[187,9] = -1
        struct[0].Gx[188,10] = -1
        struct[0].Gx[189,11] = -1
        struct[0].Gx[193,12] = -1
        struct[0].Gx[194,13] = -1
        struct[0].Gx[195,14] = -1
        struct[0].Gx[196,15] = -1
        struct[0].Gx[197,16] = -1
        struct[0].Gx[198,17] = -1
        struct[0].Gx[203,18] = -1
        struct[0].Gx[204,19] = -1
        struct[0].Gx[205,20] = -1
        struct[0].Gx[206,21] = -1
        struct[0].Gx[207,22] = -1
        struct[0].Gx[208,23] = -1
        struct[0].Gx[212,24] = -1
        struct[0].Gx[213,25] = -1
        struct[0].Gx[214,26] = -1
        struct[0].Gx[215,27] = -1
        struct[0].Gx[216,28] = -1
        struct[0].Gx[217,29] = -1
        struct[0].Gx[222,30] = -1
        struct[0].Gx[223,31] = -1
        struct[0].Gx[224,32] = -1
        struct[0].Gx[225,33] = -1
        struct[0].Gx[226,34] = -1
        struct[0].Gx[227,35] = -1
        struct[0].Gx[231,36] = -1
        struct[0].Gx[232,37] = -1
        struct[0].Gx[233,38] = -1
        struct[0].Gx[234,39] = -1
        struct[0].Gx[235,40] = -1
        struct[0].Gx[236,41] = -1
        struct[0].Gx[241,42] = -1
        struct[0].Gx[242,43] = -1
        struct[0].Gx[243,44] = -1
        struct[0].Gx[244,45] = -1
        struct[0].Gx[245,46] = -1
        struct[0].Gx[246,47] = -1
        struct[0].Gx[250,48] = -1
        struct[0].Gx[251,49] = -1
        struct[0].Gx[252,50] = -1
        struct[0].Gx[253,51] = -1
        struct[0].Gx[254,52] = -1
        struct[0].Gx[255,53] = -1
        struct[0].Gx[260,54] = -1
        struct[0].Gx[261,55] = -1
        struct[0].Gx[262,56] = -1
        struct[0].Gx[263,57] = -1
        struct[0].Gx[264,58] = -1
        struct[0].Gx[265,59] = -1
        struct[0].Gx[269,60] = -1
        struct[0].Gx[270,61] = -1
        struct[0].Gx[271,62] = -1
        struct[0].Gx[272,63] = -1
        struct[0].Gx[273,64] = -1
        struct[0].Gx[274,65] = -1
        struct[0].Gx[279,66] = -1
        struct[0].Gx[280,67] = -1
        struct[0].Gx[281,68] = -1
        struct[0].Gx[282,69] = -1
        struct[0].Gx[283,70] = -1
        struct[0].Gx[284,71] = -1
        struct[0].Gx[288,72] = -1
        struct[0].Gx[289,73] = -1
        struct[0].Gx[290,74] = -1
        struct[0].Gx[291,75] = -1
        struct[0].Gx[292,76] = -1
        struct[0].Gx[293,77] = -1

        struct[0].Gy[174,0] = i_INV_1_a_r
        struct[0].Gy[174,1] = i_INV_1_a_i
        struct[0].Gy[174,174] = v_INV_1_a_r
        struct[0].Gy[174,175] = v_INV_1_a_i
        struct[0].Gy[175,2] = i_INV_1_b_r
        struct[0].Gy[175,3] = i_INV_1_b_i
        struct[0].Gy[175,176] = v_INV_1_b_r
        struct[0].Gy[175,177] = v_INV_1_b_i
        struct[0].Gy[176,4] = i_INV_1_c_r
        struct[0].Gy[176,5] = i_INV_1_c_i
        struct[0].Gy[176,178] = v_INV_1_c_r
        struct[0].Gy[176,179] = v_INV_1_c_i
        struct[0].Gy[177,0] = -i_INV_1_a_i
        struct[0].Gy[177,1] = i_INV_1_a_r
        struct[0].Gy[177,174] = v_INV_1_a_i
        struct[0].Gy[177,175] = -v_INV_1_a_r
        struct[0].Gy[178,2] = -i_INV_1_b_i
        struct[0].Gy[178,3] = i_INV_1_b_r
        struct[0].Gy[178,176] = v_INV_1_b_i
        struct[0].Gy[178,177] = -v_INV_1_b_r
        struct[0].Gy[179,4] = -i_INV_1_c_i
        struct[0].Gy[179,5] = i_INV_1_c_r
        struct[0].Gy[179,178] = v_INV_1_c_i
        struct[0].Gy[179,179] = -v_INV_1_c_r
        struct[0].Gy[180,0] = 1.0*v_INV_1_a_r*(v_INV_1_a_i**2 + v_INV_1_a_r**2)**(-0.5)/V_base_INV_1
        struct[0].Gy[180,1] = 1.0*v_INV_1_a_i*(v_INV_1_a_i**2 + v_INV_1_a_r**2)**(-0.5)/V_base_INV_1
        struct[0].Gy[181,90] = 1.0*v_TR_1_2_mv_a_r*(v_TR_1_2_mv_a_i**2 + v_TR_1_2_mv_a_r**2)**(-0.5)/V_base_TR_1_2_mv
        struct[0].Gy[181,91] = 1.0*v_TR_1_2_mv_a_i*(v_TR_1_2_mv_a_i**2 + v_TR_1_2_mv_a_r**2)**(-0.5)/V_base_TR_1_2_mv
        struct[0].Gy[182,180] = K_p_v_INV_1*(u_ctrl_v_INV_1 - 1.0)
        struct[0].Gy[182,181] = -K_p_v_INV_1*u_ctrl_v_INV_1
        struct[0].Gy[183,172] = 1.0*S_base_INV_1*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_1, I_max_INV_1 < -i_reac_ref_INV_1), (I_max_INV_1, I_max_INV_1 < i_reac_ref_INV_1), (i_reac_ref_INV_1, True)]))
        struct[0].Gy[183,173] = 1.0*S_base_INV_1*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_1, I_max_INV_1 < -i_reac_ref_INV_1), (I_max_INV_1, I_max_INV_1 < i_reac_ref_INV_1), (i_reac_ref_INV_1, True)]))
        struct[0].Gy[183,182] = S_base_INV_1*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_1 < i_reac_ref_INV_1) | (I_max_INV_1 < -i_reac_ref_INV_1)), (1, True)]))
        struct[0].Gy[184,6] = i_INV_2_a_r
        struct[0].Gy[184,7] = i_INV_2_a_i
        struct[0].Gy[184,184] = v_INV_2_a_r
        struct[0].Gy[184,185] = v_INV_2_a_i
        struct[0].Gy[185,8] = i_INV_2_b_r
        struct[0].Gy[185,9] = i_INV_2_b_i
        struct[0].Gy[185,186] = v_INV_2_b_r
        struct[0].Gy[185,187] = v_INV_2_b_i
        struct[0].Gy[186,10] = i_INV_2_c_r
        struct[0].Gy[186,11] = i_INV_2_c_i
        struct[0].Gy[186,188] = v_INV_2_c_r
        struct[0].Gy[186,189] = v_INV_2_c_i
        struct[0].Gy[187,6] = -i_INV_2_a_i
        struct[0].Gy[187,7] = i_INV_2_a_r
        struct[0].Gy[187,184] = v_INV_2_a_i
        struct[0].Gy[187,185] = -v_INV_2_a_r
        struct[0].Gy[188,8] = -i_INV_2_b_i
        struct[0].Gy[188,9] = i_INV_2_b_r
        struct[0].Gy[188,186] = v_INV_2_b_i
        struct[0].Gy[188,187] = -v_INV_2_b_r
        struct[0].Gy[189,10] = -i_INV_2_c_i
        struct[0].Gy[189,11] = i_INV_2_c_r
        struct[0].Gy[189,188] = v_INV_2_c_i
        struct[0].Gy[189,189] = -v_INV_2_c_r
        struct[0].Gy[190,6] = 1.0*v_INV_2_a_r*(v_INV_2_a_i**2 + v_INV_2_a_r**2)**(-0.5)/V_base_INV_2
        struct[0].Gy[190,7] = 1.0*v_INV_2_a_i*(v_INV_2_a_i**2 + v_INV_2_a_r**2)**(-0.5)/V_base_INV_2
        struct[0].Gy[191,181] = -K_p_v_INV_2*u_ctrl_v_INV_2
        struct[0].Gy[191,190] = K_p_v_INV_2*(u_ctrl_v_INV_2 - 1.0)
        struct[0].Gy[192,172] = 1.0*S_base_INV_2*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_2, I_max_INV_2 < -i_reac_ref_INV_2), (I_max_INV_2, I_max_INV_2 < i_reac_ref_INV_2), (i_reac_ref_INV_2, True)]))
        struct[0].Gy[192,173] = 1.0*S_base_INV_2*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_2, I_max_INV_2 < -i_reac_ref_INV_2), (I_max_INV_2, I_max_INV_2 < i_reac_ref_INV_2), (i_reac_ref_INV_2, True)]))
        struct[0].Gy[192,191] = S_base_INV_2*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_2 < i_reac_ref_INV_2) | (I_max_INV_2 < -i_reac_ref_INV_2)), (1, True)]))
        struct[0].Gy[193,12] = i_INV_3_a_r
        struct[0].Gy[193,13] = i_INV_3_a_i
        struct[0].Gy[193,193] = v_INV_3_a_r
        struct[0].Gy[193,194] = v_INV_3_a_i
        struct[0].Gy[194,14] = i_INV_3_b_r
        struct[0].Gy[194,15] = i_INV_3_b_i
        struct[0].Gy[194,195] = v_INV_3_b_r
        struct[0].Gy[194,196] = v_INV_3_b_i
        struct[0].Gy[195,16] = i_INV_3_c_r
        struct[0].Gy[195,17] = i_INV_3_c_i
        struct[0].Gy[195,197] = v_INV_3_c_r
        struct[0].Gy[195,198] = v_INV_3_c_i
        struct[0].Gy[196,12] = -i_INV_3_a_i
        struct[0].Gy[196,13] = i_INV_3_a_r
        struct[0].Gy[196,193] = v_INV_3_a_i
        struct[0].Gy[196,194] = -v_INV_3_a_r
        struct[0].Gy[197,14] = -i_INV_3_b_i
        struct[0].Gy[197,15] = i_INV_3_b_r
        struct[0].Gy[197,195] = v_INV_3_b_i
        struct[0].Gy[197,196] = -v_INV_3_b_r
        struct[0].Gy[198,16] = -i_INV_3_c_i
        struct[0].Gy[198,17] = i_INV_3_c_r
        struct[0].Gy[198,197] = v_INV_3_c_i
        struct[0].Gy[198,198] = -v_INV_3_c_r
        struct[0].Gy[199,12] = 1.0*v_INV_3_a_r*(v_INV_3_a_i**2 + v_INV_3_a_r**2)**(-0.5)/V_base_INV_3
        struct[0].Gy[199,13] = 1.0*v_INV_3_a_i*(v_INV_3_a_i**2 + v_INV_3_a_r**2)**(-0.5)/V_base_INV_3
        struct[0].Gy[200,102] = 1.0*v_TR_3_4_mv_a_r*(v_TR_3_4_mv_a_i**2 + v_TR_3_4_mv_a_r**2)**(-0.5)/V_base_TR_3_4_mv
        struct[0].Gy[200,103] = 1.0*v_TR_3_4_mv_a_i*(v_TR_3_4_mv_a_i**2 + v_TR_3_4_mv_a_r**2)**(-0.5)/V_base_TR_3_4_mv
        struct[0].Gy[201,199] = K_p_v_INV_3*(u_ctrl_v_INV_3 - 1.0)
        struct[0].Gy[201,200] = -K_p_v_INV_3*u_ctrl_v_INV_3
        struct[0].Gy[202,172] = 1.0*S_base_INV_3*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_3, I_max_INV_3 < -i_reac_ref_INV_3), (I_max_INV_3, I_max_INV_3 < i_reac_ref_INV_3), (i_reac_ref_INV_3, True)]))
        struct[0].Gy[202,173] = 1.0*S_base_INV_3*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_3, I_max_INV_3 < -i_reac_ref_INV_3), (I_max_INV_3, I_max_INV_3 < i_reac_ref_INV_3), (i_reac_ref_INV_3, True)]))
        struct[0].Gy[202,201] = S_base_INV_3*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_3 < i_reac_ref_INV_3) | (I_max_INV_3 < -i_reac_ref_INV_3)), (1, True)]))
        struct[0].Gy[203,18] = i_INV_4_a_r
        struct[0].Gy[203,19] = i_INV_4_a_i
        struct[0].Gy[203,203] = v_INV_4_a_r
        struct[0].Gy[203,204] = v_INV_4_a_i
        struct[0].Gy[204,20] = i_INV_4_b_r
        struct[0].Gy[204,21] = i_INV_4_b_i
        struct[0].Gy[204,205] = v_INV_4_b_r
        struct[0].Gy[204,206] = v_INV_4_b_i
        struct[0].Gy[205,22] = i_INV_4_c_r
        struct[0].Gy[205,23] = i_INV_4_c_i
        struct[0].Gy[205,207] = v_INV_4_c_r
        struct[0].Gy[205,208] = v_INV_4_c_i
        struct[0].Gy[206,18] = -i_INV_4_a_i
        struct[0].Gy[206,19] = i_INV_4_a_r
        struct[0].Gy[206,203] = v_INV_4_a_i
        struct[0].Gy[206,204] = -v_INV_4_a_r
        struct[0].Gy[207,20] = -i_INV_4_b_i
        struct[0].Gy[207,21] = i_INV_4_b_r
        struct[0].Gy[207,205] = v_INV_4_b_i
        struct[0].Gy[207,206] = -v_INV_4_b_r
        struct[0].Gy[208,22] = -i_INV_4_c_i
        struct[0].Gy[208,23] = i_INV_4_c_r
        struct[0].Gy[208,207] = v_INV_4_c_i
        struct[0].Gy[208,208] = -v_INV_4_c_r
        struct[0].Gy[209,18] = 1.0*v_INV_4_a_r*(v_INV_4_a_i**2 + v_INV_4_a_r**2)**(-0.5)/V_base_INV_4
        struct[0].Gy[209,19] = 1.0*v_INV_4_a_i*(v_INV_4_a_i**2 + v_INV_4_a_r**2)**(-0.5)/V_base_INV_4
        struct[0].Gy[210,200] = -K_p_v_INV_4*u_ctrl_v_INV_4
        struct[0].Gy[210,209] = K_p_v_INV_4*(u_ctrl_v_INV_4 - 1.0)
        struct[0].Gy[211,172] = 1.0*S_base_INV_4*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_4, I_max_INV_4 < -i_reac_ref_INV_4), (I_max_INV_4, I_max_INV_4 < i_reac_ref_INV_4), (i_reac_ref_INV_4, True)]))
        struct[0].Gy[211,173] = 1.0*S_base_INV_4*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_4, I_max_INV_4 < -i_reac_ref_INV_4), (I_max_INV_4, I_max_INV_4 < i_reac_ref_INV_4), (i_reac_ref_INV_4, True)]))
        struct[0].Gy[211,210] = S_base_INV_4*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_4 < i_reac_ref_INV_4) | (I_max_INV_4 < -i_reac_ref_INV_4)), (1, True)]))
        struct[0].Gy[212,24] = i_INV_5_a_r
        struct[0].Gy[212,25] = i_INV_5_a_i
        struct[0].Gy[212,212] = v_INV_5_a_r
        struct[0].Gy[212,213] = v_INV_5_a_i
        struct[0].Gy[213,26] = i_INV_5_b_r
        struct[0].Gy[213,27] = i_INV_5_b_i
        struct[0].Gy[213,214] = v_INV_5_b_r
        struct[0].Gy[213,215] = v_INV_5_b_i
        struct[0].Gy[214,28] = i_INV_5_c_r
        struct[0].Gy[214,29] = i_INV_5_c_i
        struct[0].Gy[214,216] = v_INV_5_c_r
        struct[0].Gy[214,217] = v_INV_5_c_i
        struct[0].Gy[215,24] = -i_INV_5_a_i
        struct[0].Gy[215,25] = i_INV_5_a_r
        struct[0].Gy[215,212] = v_INV_5_a_i
        struct[0].Gy[215,213] = -v_INV_5_a_r
        struct[0].Gy[216,26] = -i_INV_5_b_i
        struct[0].Gy[216,27] = i_INV_5_b_r
        struct[0].Gy[216,214] = v_INV_5_b_i
        struct[0].Gy[216,215] = -v_INV_5_b_r
        struct[0].Gy[217,28] = -i_INV_5_c_i
        struct[0].Gy[217,29] = i_INV_5_c_r
        struct[0].Gy[217,216] = v_INV_5_c_i
        struct[0].Gy[217,217] = -v_INV_5_c_r
        struct[0].Gy[218,24] = 1.0*v_INV_5_a_r*(v_INV_5_a_i**2 + v_INV_5_a_r**2)**(-0.5)/V_base_INV_5
        struct[0].Gy[218,25] = 1.0*v_INV_5_a_i*(v_INV_5_a_i**2 + v_INV_5_a_r**2)**(-0.5)/V_base_INV_5
        struct[0].Gy[219,114] = 1.0*v_TR_5_6_mv_a_r*(v_TR_5_6_mv_a_i**2 + v_TR_5_6_mv_a_r**2)**(-0.5)/V_base_TR_5_6_mv
        struct[0].Gy[219,115] = 1.0*v_TR_5_6_mv_a_i*(v_TR_5_6_mv_a_i**2 + v_TR_5_6_mv_a_r**2)**(-0.5)/V_base_TR_5_6_mv
        struct[0].Gy[220,218] = K_p_v_INV_5*(u_ctrl_v_INV_5 - 1.0)
        struct[0].Gy[220,219] = -K_p_v_INV_5*u_ctrl_v_INV_5
        struct[0].Gy[221,172] = 1.0*S_base_INV_5*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_5, I_max_INV_5 < -i_reac_ref_INV_5), (I_max_INV_5, I_max_INV_5 < i_reac_ref_INV_5), (i_reac_ref_INV_5, True)]))
        struct[0].Gy[221,173] = 1.0*S_base_INV_5*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_5, I_max_INV_5 < -i_reac_ref_INV_5), (I_max_INV_5, I_max_INV_5 < i_reac_ref_INV_5), (i_reac_ref_INV_5, True)]))
        struct[0].Gy[221,220] = S_base_INV_5*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_5 < i_reac_ref_INV_5) | (I_max_INV_5 < -i_reac_ref_INV_5)), (1, True)]))
        struct[0].Gy[222,30] = i_INV_6_a_r
        struct[0].Gy[222,31] = i_INV_6_a_i
        struct[0].Gy[222,222] = v_INV_6_a_r
        struct[0].Gy[222,223] = v_INV_6_a_i
        struct[0].Gy[223,32] = i_INV_6_b_r
        struct[0].Gy[223,33] = i_INV_6_b_i
        struct[0].Gy[223,224] = v_INV_6_b_r
        struct[0].Gy[223,225] = v_INV_6_b_i
        struct[0].Gy[224,34] = i_INV_6_c_r
        struct[0].Gy[224,35] = i_INV_6_c_i
        struct[0].Gy[224,226] = v_INV_6_c_r
        struct[0].Gy[224,227] = v_INV_6_c_i
        struct[0].Gy[225,30] = -i_INV_6_a_i
        struct[0].Gy[225,31] = i_INV_6_a_r
        struct[0].Gy[225,222] = v_INV_6_a_i
        struct[0].Gy[225,223] = -v_INV_6_a_r
        struct[0].Gy[226,32] = -i_INV_6_b_i
        struct[0].Gy[226,33] = i_INV_6_b_r
        struct[0].Gy[226,224] = v_INV_6_b_i
        struct[0].Gy[226,225] = -v_INV_6_b_r
        struct[0].Gy[227,34] = -i_INV_6_c_i
        struct[0].Gy[227,35] = i_INV_6_c_r
        struct[0].Gy[227,226] = v_INV_6_c_i
        struct[0].Gy[227,227] = -v_INV_6_c_r
        struct[0].Gy[228,30] = 1.0*v_INV_6_a_r*(v_INV_6_a_i**2 + v_INV_6_a_r**2)**(-0.5)/V_base_INV_6
        struct[0].Gy[228,31] = 1.0*v_INV_6_a_i*(v_INV_6_a_i**2 + v_INV_6_a_r**2)**(-0.5)/V_base_INV_6
        struct[0].Gy[229,219] = -K_p_v_INV_6*u_ctrl_v_INV_6
        struct[0].Gy[229,228] = K_p_v_INV_6*(u_ctrl_v_INV_6 - 1.0)
        struct[0].Gy[230,172] = 1.0*S_base_INV_6*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_6, I_max_INV_6 < -i_reac_ref_INV_6), (I_max_INV_6, I_max_INV_6 < i_reac_ref_INV_6), (i_reac_ref_INV_6, True)]))
        struct[0].Gy[230,173] = 1.0*S_base_INV_6*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_6, I_max_INV_6 < -i_reac_ref_INV_6), (I_max_INV_6, I_max_INV_6 < i_reac_ref_INV_6), (i_reac_ref_INV_6, True)]))
        struct[0].Gy[230,229] = S_base_INV_6*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_6 < i_reac_ref_INV_6) | (I_max_INV_6 < -i_reac_ref_INV_6)), (1, True)]))
        struct[0].Gy[231,36] = i_INV_7_a_r
        struct[0].Gy[231,37] = i_INV_7_a_i
        struct[0].Gy[231,231] = v_INV_7_a_r
        struct[0].Gy[231,232] = v_INV_7_a_i
        struct[0].Gy[232,38] = i_INV_7_b_r
        struct[0].Gy[232,39] = i_INV_7_b_i
        struct[0].Gy[232,233] = v_INV_7_b_r
        struct[0].Gy[232,234] = v_INV_7_b_i
        struct[0].Gy[233,40] = i_INV_7_c_r
        struct[0].Gy[233,41] = i_INV_7_c_i
        struct[0].Gy[233,235] = v_INV_7_c_r
        struct[0].Gy[233,236] = v_INV_7_c_i
        struct[0].Gy[234,36] = -i_INV_7_a_i
        struct[0].Gy[234,37] = i_INV_7_a_r
        struct[0].Gy[234,231] = v_INV_7_a_i
        struct[0].Gy[234,232] = -v_INV_7_a_r
        struct[0].Gy[235,38] = -i_INV_7_b_i
        struct[0].Gy[235,39] = i_INV_7_b_r
        struct[0].Gy[235,233] = v_INV_7_b_i
        struct[0].Gy[235,234] = -v_INV_7_b_r
        struct[0].Gy[236,40] = -i_INV_7_c_i
        struct[0].Gy[236,41] = i_INV_7_c_r
        struct[0].Gy[236,235] = v_INV_7_c_i
        struct[0].Gy[236,236] = -v_INV_7_c_r
        struct[0].Gy[237,36] = 1.0*v_INV_7_a_r*(v_INV_7_a_i**2 + v_INV_7_a_r**2)**(-0.5)/V_base_INV_7
        struct[0].Gy[237,37] = 1.0*v_INV_7_a_i*(v_INV_7_a_i**2 + v_INV_7_a_r**2)**(-0.5)/V_base_INV_7
        struct[0].Gy[238,126] = 1.0*v_TR_7_8_mv_a_r*(v_TR_7_8_mv_a_i**2 + v_TR_7_8_mv_a_r**2)**(-0.5)/V_base_TR_7_8_mv
        struct[0].Gy[238,127] = 1.0*v_TR_7_8_mv_a_i*(v_TR_7_8_mv_a_i**2 + v_TR_7_8_mv_a_r**2)**(-0.5)/V_base_TR_7_8_mv
        struct[0].Gy[239,237] = K_p_v_INV_7*(u_ctrl_v_INV_7 - 1.0)
        struct[0].Gy[239,238] = -K_p_v_INV_7*u_ctrl_v_INV_7
        struct[0].Gy[240,172] = 1.0*S_base_INV_7*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_7, I_max_INV_7 < -i_reac_ref_INV_7), (I_max_INV_7, I_max_INV_7 < i_reac_ref_INV_7), (i_reac_ref_INV_7, True)]))
        struct[0].Gy[240,173] = 1.0*S_base_INV_7*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_7, I_max_INV_7 < -i_reac_ref_INV_7), (I_max_INV_7, I_max_INV_7 < i_reac_ref_INV_7), (i_reac_ref_INV_7, True)]))
        struct[0].Gy[240,239] = S_base_INV_7*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_7 < i_reac_ref_INV_7) | (I_max_INV_7 < -i_reac_ref_INV_7)), (1, True)]))
        struct[0].Gy[241,42] = i_INV_8_a_r
        struct[0].Gy[241,43] = i_INV_8_a_i
        struct[0].Gy[241,241] = v_INV_8_a_r
        struct[0].Gy[241,242] = v_INV_8_a_i
        struct[0].Gy[242,44] = i_INV_8_b_r
        struct[0].Gy[242,45] = i_INV_8_b_i
        struct[0].Gy[242,243] = v_INV_8_b_r
        struct[0].Gy[242,244] = v_INV_8_b_i
        struct[0].Gy[243,46] = i_INV_8_c_r
        struct[0].Gy[243,47] = i_INV_8_c_i
        struct[0].Gy[243,245] = v_INV_8_c_r
        struct[0].Gy[243,246] = v_INV_8_c_i
        struct[0].Gy[244,42] = -i_INV_8_a_i
        struct[0].Gy[244,43] = i_INV_8_a_r
        struct[0].Gy[244,241] = v_INV_8_a_i
        struct[0].Gy[244,242] = -v_INV_8_a_r
        struct[0].Gy[245,44] = -i_INV_8_b_i
        struct[0].Gy[245,45] = i_INV_8_b_r
        struct[0].Gy[245,243] = v_INV_8_b_i
        struct[0].Gy[245,244] = -v_INV_8_b_r
        struct[0].Gy[246,46] = -i_INV_8_c_i
        struct[0].Gy[246,47] = i_INV_8_c_r
        struct[0].Gy[246,245] = v_INV_8_c_i
        struct[0].Gy[246,246] = -v_INV_8_c_r
        struct[0].Gy[247,42] = 1.0*v_INV_8_a_r*(v_INV_8_a_i**2 + v_INV_8_a_r**2)**(-0.5)/V_base_INV_8
        struct[0].Gy[247,43] = 1.0*v_INV_8_a_i*(v_INV_8_a_i**2 + v_INV_8_a_r**2)**(-0.5)/V_base_INV_8
        struct[0].Gy[248,238] = -K_p_v_INV_8*u_ctrl_v_INV_8
        struct[0].Gy[248,247] = K_p_v_INV_8*(u_ctrl_v_INV_8 - 1.0)
        struct[0].Gy[249,172] = 1.0*S_base_INV_8*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_8, I_max_INV_8 < -i_reac_ref_INV_8), (I_max_INV_8, I_max_INV_8 < i_reac_ref_INV_8), (i_reac_ref_INV_8, True)]))
        struct[0].Gy[249,173] = 1.0*S_base_INV_8*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_8, I_max_INV_8 < -i_reac_ref_INV_8), (I_max_INV_8, I_max_INV_8 < i_reac_ref_INV_8), (i_reac_ref_INV_8, True)]))
        struct[0].Gy[249,248] = S_base_INV_8*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_8 < i_reac_ref_INV_8) | (I_max_INV_8 < -i_reac_ref_INV_8)), (1, True)]))
        struct[0].Gy[250,48] = i_INV_9_a_r
        struct[0].Gy[250,49] = i_INV_9_a_i
        struct[0].Gy[250,250] = v_INV_9_a_r
        struct[0].Gy[250,251] = v_INV_9_a_i
        struct[0].Gy[251,50] = i_INV_9_b_r
        struct[0].Gy[251,51] = i_INV_9_b_i
        struct[0].Gy[251,252] = v_INV_9_b_r
        struct[0].Gy[251,253] = v_INV_9_b_i
        struct[0].Gy[252,52] = i_INV_9_c_r
        struct[0].Gy[252,53] = i_INV_9_c_i
        struct[0].Gy[252,254] = v_INV_9_c_r
        struct[0].Gy[252,255] = v_INV_9_c_i
        struct[0].Gy[253,48] = -i_INV_9_a_i
        struct[0].Gy[253,49] = i_INV_9_a_r
        struct[0].Gy[253,250] = v_INV_9_a_i
        struct[0].Gy[253,251] = -v_INV_9_a_r
        struct[0].Gy[254,50] = -i_INV_9_b_i
        struct[0].Gy[254,51] = i_INV_9_b_r
        struct[0].Gy[254,252] = v_INV_9_b_i
        struct[0].Gy[254,253] = -v_INV_9_b_r
        struct[0].Gy[255,52] = -i_INV_9_c_i
        struct[0].Gy[255,53] = i_INV_9_c_r
        struct[0].Gy[255,254] = v_INV_9_c_i
        struct[0].Gy[255,255] = -v_INV_9_c_r
        struct[0].Gy[256,48] = 1.0*v_INV_9_a_r*(v_INV_9_a_i**2 + v_INV_9_a_r**2)**(-0.5)/V_base_INV_9
        struct[0].Gy[256,49] = 1.0*v_INV_9_a_i*(v_INV_9_a_i**2 + v_INV_9_a_r**2)**(-0.5)/V_base_INV_9
        struct[0].Gy[257,138] = 1.0*v_TR_9_10_mv_a_r*(v_TR_9_10_mv_a_i**2 + v_TR_9_10_mv_a_r**2)**(-0.5)/V_base_TR_9_10_mv
        struct[0].Gy[257,139] = 1.0*v_TR_9_10_mv_a_i*(v_TR_9_10_mv_a_i**2 + v_TR_9_10_mv_a_r**2)**(-0.5)/V_base_TR_9_10_mv
        struct[0].Gy[258,256] = K_p_v_INV_9*(u_ctrl_v_INV_9 - 1.0)
        struct[0].Gy[258,257] = -K_p_v_INV_9*u_ctrl_v_INV_9
        struct[0].Gy[259,172] = 1.0*S_base_INV_9*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_9, I_max_INV_9 < -i_reac_ref_INV_9), (I_max_INV_9, I_max_INV_9 < i_reac_ref_INV_9), (i_reac_ref_INV_9, True)]))
        struct[0].Gy[259,173] = 1.0*S_base_INV_9*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_9, I_max_INV_9 < -i_reac_ref_INV_9), (I_max_INV_9, I_max_INV_9 < i_reac_ref_INV_9), (i_reac_ref_INV_9, True)]))
        struct[0].Gy[259,258] = S_base_INV_9*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_9 < i_reac_ref_INV_9) | (I_max_INV_9 < -i_reac_ref_INV_9)), (1, True)]))
        struct[0].Gy[260,54] = i_INV_10_a_r
        struct[0].Gy[260,55] = i_INV_10_a_i
        struct[0].Gy[260,260] = v_INV_10_a_r
        struct[0].Gy[260,261] = v_INV_10_a_i
        struct[0].Gy[261,56] = i_INV_10_b_r
        struct[0].Gy[261,57] = i_INV_10_b_i
        struct[0].Gy[261,262] = v_INV_10_b_r
        struct[0].Gy[261,263] = v_INV_10_b_i
        struct[0].Gy[262,58] = i_INV_10_c_r
        struct[0].Gy[262,59] = i_INV_10_c_i
        struct[0].Gy[262,264] = v_INV_10_c_r
        struct[0].Gy[262,265] = v_INV_10_c_i
        struct[0].Gy[263,54] = -i_INV_10_a_i
        struct[0].Gy[263,55] = i_INV_10_a_r
        struct[0].Gy[263,260] = v_INV_10_a_i
        struct[0].Gy[263,261] = -v_INV_10_a_r
        struct[0].Gy[264,56] = -i_INV_10_b_i
        struct[0].Gy[264,57] = i_INV_10_b_r
        struct[0].Gy[264,262] = v_INV_10_b_i
        struct[0].Gy[264,263] = -v_INV_10_b_r
        struct[0].Gy[265,58] = -i_INV_10_c_i
        struct[0].Gy[265,59] = i_INV_10_c_r
        struct[0].Gy[265,264] = v_INV_10_c_i
        struct[0].Gy[265,265] = -v_INV_10_c_r
        struct[0].Gy[266,54] = 1.0*v_INV_10_a_r*(v_INV_10_a_i**2 + v_INV_10_a_r**2)**(-0.5)/V_base_INV_10
        struct[0].Gy[266,55] = 1.0*v_INV_10_a_i*(v_INV_10_a_i**2 + v_INV_10_a_r**2)**(-0.5)/V_base_INV_10
        struct[0].Gy[267,257] = -K_p_v_INV_10*u_ctrl_v_INV_10
        struct[0].Gy[267,266] = K_p_v_INV_10*(u_ctrl_v_INV_10 - 1.0)
        struct[0].Gy[268,172] = 1.0*S_base_INV_10*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_10, I_max_INV_10 < -i_reac_ref_INV_10), (I_max_INV_10, I_max_INV_10 < i_reac_ref_INV_10), (i_reac_ref_INV_10, True)]))
        struct[0].Gy[268,173] = 1.0*S_base_INV_10*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_10, I_max_INV_10 < -i_reac_ref_INV_10), (I_max_INV_10, I_max_INV_10 < i_reac_ref_INV_10), (i_reac_ref_INV_10, True)]))
        struct[0].Gy[268,267] = S_base_INV_10*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_10 < i_reac_ref_INV_10) | (I_max_INV_10 < -i_reac_ref_INV_10)), (1, True)]))
        struct[0].Gy[269,60] = i_INV_11_a_r
        struct[0].Gy[269,61] = i_INV_11_a_i
        struct[0].Gy[269,269] = v_INV_11_a_r
        struct[0].Gy[269,270] = v_INV_11_a_i
        struct[0].Gy[270,62] = i_INV_11_b_r
        struct[0].Gy[270,63] = i_INV_11_b_i
        struct[0].Gy[270,271] = v_INV_11_b_r
        struct[0].Gy[270,272] = v_INV_11_b_i
        struct[0].Gy[271,64] = i_INV_11_c_r
        struct[0].Gy[271,65] = i_INV_11_c_i
        struct[0].Gy[271,273] = v_INV_11_c_r
        struct[0].Gy[271,274] = v_INV_11_c_i
        struct[0].Gy[272,60] = -i_INV_11_a_i
        struct[0].Gy[272,61] = i_INV_11_a_r
        struct[0].Gy[272,269] = v_INV_11_a_i
        struct[0].Gy[272,270] = -v_INV_11_a_r
        struct[0].Gy[273,62] = -i_INV_11_b_i
        struct[0].Gy[273,63] = i_INV_11_b_r
        struct[0].Gy[273,271] = v_INV_11_b_i
        struct[0].Gy[273,272] = -v_INV_11_b_r
        struct[0].Gy[274,64] = -i_INV_11_c_i
        struct[0].Gy[274,65] = i_INV_11_c_r
        struct[0].Gy[274,273] = v_INV_11_c_i
        struct[0].Gy[274,274] = -v_INV_11_c_r
        struct[0].Gy[275,60] = 1.0*v_INV_11_a_r*(v_INV_11_a_i**2 + v_INV_11_a_r**2)**(-0.5)/V_base_INV_11
        struct[0].Gy[275,61] = 1.0*v_INV_11_a_i*(v_INV_11_a_i**2 + v_INV_11_a_r**2)**(-0.5)/V_base_INV_11
        struct[0].Gy[276,150] = 1.0*v_TR_11_12_mv_a_r*(v_TR_11_12_mv_a_i**2 + v_TR_11_12_mv_a_r**2)**(-0.5)/V_base_TR_11_12_mv
        struct[0].Gy[276,151] = 1.0*v_TR_11_12_mv_a_i*(v_TR_11_12_mv_a_i**2 + v_TR_11_12_mv_a_r**2)**(-0.5)/V_base_TR_11_12_mv
        struct[0].Gy[277,275] = K_p_v_INV_11*(u_ctrl_v_INV_11 - 1.0)
        struct[0].Gy[277,276] = -K_p_v_INV_11*u_ctrl_v_INV_11
        struct[0].Gy[278,172] = 1.0*S_base_INV_11*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_11, I_max_INV_11 < -i_reac_ref_INV_11), (I_max_INV_11, I_max_INV_11 < i_reac_ref_INV_11), (i_reac_ref_INV_11, True)]))
        struct[0].Gy[278,173] = 1.0*S_base_INV_11*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_11, I_max_INV_11 < -i_reac_ref_INV_11), (I_max_INV_11, I_max_INV_11 < i_reac_ref_INV_11), (i_reac_ref_INV_11, True)]))
        struct[0].Gy[278,277] = S_base_INV_11*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_11 < i_reac_ref_INV_11) | (I_max_INV_11 < -i_reac_ref_INV_11)), (1, True)]))
        struct[0].Gy[279,66] = i_INV_12_a_r
        struct[0].Gy[279,67] = i_INV_12_a_i
        struct[0].Gy[279,279] = v_INV_12_a_r
        struct[0].Gy[279,280] = v_INV_12_a_i
        struct[0].Gy[280,68] = i_INV_12_b_r
        struct[0].Gy[280,69] = i_INV_12_b_i
        struct[0].Gy[280,281] = v_INV_12_b_r
        struct[0].Gy[280,282] = v_INV_12_b_i
        struct[0].Gy[281,70] = i_INV_12_c_r
        struct[0].Gy[281,71] = i_INV_12_c_i
        struct[0].Gy[281,283] = v_INV_12_c_r
        struct[0].Gy[281,284] = v_INV_12_c_i
        struct[0].Gy[282,66] = -i_INV_12_a_i
        struct[0].Gy[282,67] = i_INV_12_a_r
        struct[0].Gy[282,279] = v_INV_12_a_i
        struct[0].Gy[282,280] = -v_INV_12_a_r
        struct[0].Gy[283,68] = -i_INV_12_b_i
        struct[0].Gy[283,69] = i_INV_12_b_r
        struct[0].Gy[283,281] = v_INV_12_b_i
        struct[0].Gy[283,282] = -v_INV_12_b_r
        struct[0].Gy[284,70] = -i_INV_12_c_i
        struct[0].Gy[284,71] = i_INV_12_c_r
        struct[0].Gy[284,283] = v_INV_12_c_i
        struct[0].Gy[284,284] = -v_INV_12_c_r
        struct[0].Gy[285,66] = 1.0*v_INV_12_a_r*(v_INV_12_a_i**2 + v_INV_12_a_r**2)**(-0.5)/V_base_INV_12
        struct[0].Gy[285,67] = 1.0*v_INV_12_a_i*(v_INV_12_a_i**2 + v_INV_12_a_r**2)**(-0.5)/V_base_INV_12
        struct[0].Gy[286,276] = -K_p_v_INV_12*u_ctrl_v_INV_12
        struct[0].Gy[286,285] = K_p_v_INV_12*(u_ctrl_v_INV_12 - 1.0)
        struct[0].Gy[287,172] = 1.0*S_base_INV_12*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_12, I_max_INV_12 < -i_reac_ref_INV_12), (I_max_INV_12, I_max_INV_12 < i_reac_ref_INV_12), (i_reac_ref_INV_12, True)]))
        struct[0].Gy[287,173] = 1.0*S_base_INV_12*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_12, I_max_INV_12 < -i_reac_ref_INV_12), (I_max_INV_12, I_max_INV_12 < i_reac_ref_INV_12), (i_reac_ref_INV_12, True)]))
        struct[0].Gy[287,286] = S_base_INV_12*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_12 < i_reac_ref_INV_12) | (I_max_INV_12 < -i_reac_ref_INV_12)), (1, True)]))
        struct[0].Gy[288,72] = i_INV_13_a_r
        struct[0].Gy[288,73] = i_INV_13_a_i
        struct[0].Gy[288,288] = v_INV_13_a_r
        struct[0].Gy[288,289] = v_INV_13_a_i
        struct[0].Gy[289,74] = i_INV_13_b_r
        struct[0].Gy[289,75] = i_INV_13_b_i
        struct[0].Gy[289,290] = v_INV_13_b_r
        struct[0].Gy[289,291] = v_INV_13_b_i
        struct[0].Gy[290,76] = i_INV_13_c_r
        struct[0].Gy[290,77] = i_INV_13_c_i
        struct[0].Gy[290,292] = v_INV_13_c_r
        struct[0].Gy[290,293] = v_INV_13_c_i
        struct[0].Gy[291,72] = -i_INV_13_a_i
        struct[0].Gy[291,73] = i_INV_13_a_r
        struct[0].Gy[291,288] = v_INV_13_a_i
        struct[0].Gy[291,289] = -v_INV_13_a_r
        struct[0].Gy[292,74] = -i_INV_13_b_i
        struct[0].Gy[292,75] = i_INV_13_b_r
        struct[0].Gy[292,290] = v_INV_13_b_i
        struct[0].Gy[292,291] = -v_INV_13_b_r
        struct[0].Gy[293,76] = -i_INV_13_c_i
        struct[0].Gy[293,77] = i_INV_13_c_r
        struct[0].Gy[293,292] = v_INV_13_c_i
        struct[0].Gy[293,293] = -v_INV_13_c_r
        struct[0].Gy[294,72] = 1.0*v_INV_13_a_r*(v_INV_13_a_i**2 + v_INV_13_a_r**2)**(-0.5)/V_base_INV_13
        struct[0].Gy[294,73] = 1.0*v_INV_13_a_i*(v_INV_13_a_i**2 + v_INV_13_a_r**2)**(-0.5)/V_base_INV_13
        struct[0].Gy[295,162] = 1.0*v_TR_13_mv_a_r*(v_TR_13_mv_a_i**2 + v_TR_13_mv_a_r**2)**(-0.5)/V_base_TR_13_mv
        struct[0].Gy[295,163] = 1.0*v_TR_13_mv_a_i*(v_TR_13_mv_a_i**2 + v_TR_13_mv_a_r**2)**(-0.5)/V_base_TR_13_mv
        struct[0].Gy[296,294] = K_p_v_INV_13*(u_ctrl_v_INV_13 - 1.0)
        struct[0].Gy[296,295] = -K_p_v_INV_13*u_ctrl_v_INV_13
        struct[0].Gy[297,172] = 1.0*S_base_INV_13*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_13, I_max_INV_13 < -i_reac_ref_INV_13), (I_max_INV_13, I_max_INV_13 < i_reac_ref_INV_13), (i_reac_ref_INV_13, True)]))
        struct[0].Gy[297,173] = 1.0*S_base_INV_13*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_13, I_max_INV_13 < -i_reac_ref_INV_13), (I_max_INV_13, I_max_INV_13 < i_reac_ref_INV_13), (i_reac_ref_INV_13, True)]))
        struct[0].Gy[297,296] = S_base_INV_13*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_13 < i_reac_ref_INV_13) | (I_max_INV_13 < -i_reac_ref_INV_13)), (1, True)]))

    if mode > 12:

        struct[0].Fu[0,102] = 1/(3*T_pq_INV_1)
        struct[0].Fu[0,103] = -(-p_INV_1_a + p_ref_INV_1/3)/T_pq_INV_1**2
        struct[0].Fu[1,102] = 1/(3*T_pq_INV_1)
        struct[0].Fu[1,103] = -(-p_INV_1_b + p_ref_INV_1/3)/T_pq_INV_1**2
        struct[0].Fu[2,102] = 1/(3*T_pq_INV_1)
        struct[0].Fu[2,103] = -(-p_INV_1_c + p_ref_INV_1/3)/T_pq_INV_1**2
        struct[0].Fu[3,103] = -(-q_INV_1_a + q_ref_INV_1/3)/T_pq_INV_1**2
        struct[0].Fu[4,103] = -(-q_INV_1_b + q_ref_INV_1/3)/T_pq_INV_1**2
        struct[0].Fu[5,103] = -(-q_INV_1_c + q_ref_INV_1/3)/T_pq_INV_1**2
        struct[0].Fu[6,107] = 1/(3*T_pq_INV_2)
        struct[0].Fu[6,108] = -(-p_INV_2_a + p_ref_INV_2/3)/T_pq_INV_2**2
        struct[0].Fu[7,107] = 1/(3*T_pq_INV_2)
        struct[0].Fu[7,108] = -(-p_INV_2_b + p_ref_INV_2/3)/T_pq_INV_2**2
        struct[0].Fu[8,107] = 1/(3*T_pq_INV_2)
        struct[0].Fu[8,108] = -(-p_INV_2_c + p_ref_INV_2/3)/T_pq_INV_2**2
        struct[0].Fu[9,108] = -(-q_INV_2_a + q_ref_INV_2/3)/T_pq_INV_2**2
        struct[0].Fu[10,108] = -(-q_INV_2_b + q_ref_INV_2/3)/T_pq_INV_2**2
        struct[0].Fu[11,108] = -(-q_INV_2_c + q_ref_INV_2/3)/T_pq_INV_2**2
        struct[0].Fu[12,112] = 1/(3*T_pq_INV_3)
        struct[0].Fu[12,113] = -(-p_INV_3_a + p_ref_INV_3/3)/T_pq_INV_3**2
        struct[0].Fu[13,112] = 1/(3*T_pq_INV_3)
        struct[0].Fu[13,113] = -(-p_INV_3_b + p_ref_INV_3/3)/T_pq_INV_3**2
        struct[0].Fu[14,112] = 1/(3*T_pq_INV_3)
        struct[0].Fu[14,113] = -(-p_INV_3_c + p_ref_INV_3/3)/T_pq_INV_3**2
        struct[0].Fu[15,113] = -(-q_INV_3_a + q_ref_INV_3/3)/T_pq_INV_3**2
        struct[0].Fu[16,113] = -(-q_INV_3_b + q_ref_INV_3/3)/T_pq_INV_3**2
        struct[0].Fu[17,113] = -(-q_INV_3_c + q_ref_INV_3/3)/T_pq_INV_3**2
        struct[0].Fu[18,117] = 1/(3*T_pq_INV_4)
        struct[0].Fu[18,118] = -(-p_INV_4_a + p_ref_INV_4/3)/T_pq_INV_4**2
        struct[0].Fu[19,117] = 1/(3*T_pq_INV_4)
        struct[0].Fu[19,118] = -(-p_INV_4_b + p_ref_INV_4/3)/T_pq_INV_4**2
        struct[0].Fu[20,117] = 1/(3*T_pq_INV_4)
        struct[0].Fu[20,118] = -(-p_INV_4_c + p_ref_INV_4/3)/T_pq_INV_4**2
        struct[0].Fu[21,118] = -(-q_INV_4_a + q_ref_INV_4/3)/T_pq_INV_4**2
        struct[0].Fu[22,118] = -(-q_INV_4_b + q_ref_INV_4/3)/T_pq_INV_4**2
        struct[0].Fu[23,118] = -(-q_INV_4_c + q_ref_INV_4/3)/T_pq_INV_4**2
        struct[0].Fu[24,122] = 1/(3*T_pq_INV_5)
        struct[0].Fu[24,123] = -(-p_INV_5_a + p_ref_INV_5/3)/T_pq_INV_5**2
        struct[0].Fu[25,122] = 1/(3*T_pq_INV_5)
        struct[0].Fu[25,123] = -(-p_INV_5_b + p_ref_INV_5/3)/T_pq_INV_5**2
        struct[0].Fu[26,122] = 1/(3*T_pq_INV_5)
        struct[0].Fu[26,123] = -(-p_INV_5_c + p_ref_INV_5/3)/T_pq_INV_5**2
        struct[0].Fu[27,123] = -(-q_INV_5_a + q_ref_INV_5/3)/T_pq_INV_5**2
        struct[0].Fu[28,123] = -(-q_INV_5_b + q_ref_INV_5/3)/T_pq_INV_5**2
        struct[0].Fu[29,123] = -(-q_INV_5_c + q_ref_INV_5/3)/T_pq_INV_5**2
        struct[0].Fu[30,127] = 1/(3*T_pq_INV_6)
        struct[0].Fu[30,128] = -(-p_INV_6_a + p_ref_INV_6/3)/T_pq_INV_6**2
        struct[0].Fu[31,127] = 1/(3*T_pq_INV_6)
        struct[0].Fu[31,128] = -(-p_INV_6_b + p_ref_INV_6/3)/T_pq_INV_6**2
        struct[0].Fu[32,127] = 1/(3*T_pq_INV_6)
        struct[0].Fu[32,128] = -(-p_INV_6_c + p_ref_INV_6/3)/T_pq_INV_6**2
        struct[0].Fu[33,128] = -(-q_INV_6_a + q_ref_INV_6/3)/T_pq_INV_6**2
        struct[0].Fu[34,128] = -(-q_INV_6_b + q_ref_INV_6/3)/T_pq_INV_6**2
        struct[0].Fu[35,128] = -(-q_INV_6_c + q_ref_INV_6/3)/T_pq_INV_6**2
        struct[0].Fu[36,132] = 1/(3*T_pq_INV_7)
        struct[0].Fu[36,133] = -(-p_INV_7_a + p_ref_INV_7/3)/T_pq_INV_7**2
        struct[0].Fu[37,132] = 1/(3*T_pq_INV_7)
        struct[0].Fu[37,133] = -(-p_INV_7_b + p_ref_INV_7/3)/T_pq_INV_7**2
        struct[0].Fu[38,132] = 1/(3*T_pq_INV_7)
        struct[0].Fu[38,133] = -(-p_INV_7_c + p_ref_INV_7/3)/T_pq_INV_7**2
        struct[0].Fu[39,133] = -(-q_INV_7_a + q_ref_INV_7/3)/T_pq_INV_7**2
        struct[0].Fu[40,133] = -(-q_INV_7_b + q_ref_INV_7/3)/T_pq_INV_7**2
        struct[0].Fu[41,133] = -(-q_INV_7_c + q_ref_INV_7/3)/T_pq_INV_7**2
        struct[0].Fu[42,137] = 1/(3*T_pq_INV_8)
        struct[0].Fu[42,138] = -(-p_INV_8_a + p_ref_INV_8/3)/T_pq_INV_8**2
        struct[0].Fu[43,137] = 1/(3*T_pq_INV_8)
        struct[0].Fu[43,138] = -(-p_INV_8_b + p_ref_INV_8/3)/T_pq_INV_8**2
        struct[0].Fu[44,137] = 1/(3*T_pq_INV_8)
        struct[0].Fu[44,138] = -(-p_INV_8_c + p_ref_INV_8/3)/T_pq_INV_8**2
        struct[0].Fu[45,138] = -(-q_INV_8_a + q_ref_INV_8/3)/T_pq_INV_8**2
        struct[0].Fu[46,138] = -(-q_INV_8_b + q_ref_INV_8/3)/T_pq_INV_8**2
        struct[0].Fu[47,138] = -(-q_INV_8_c + q_ref_INV_8/3)/T_pq_INV_8**2
        struct[0].Fu[48,142] = 1/(3*T_pq_INV_9)
        struct[0].Fu[48,143] = -(-p_INV_9_a + p_ref_INV_9/3)/T_pq_INV_9**2
        struct[0].Fu[49,142] = 1/(3*T_pq_INV_9)
        struct[0].Fu[49,143] = -(-p_INV_9_b + p_ref_INV_9/3)/T_pq_INV_9**2
        struct[0].Fu[50,142] = 1/(3*T_pq_INV_9)
        struct[0].Fu[50,143] = -(-p_INV_9_c + p_ref_INV_9/3)/T_pq_INV_9**2
        struct[0].Fu[51,143] = -(-q_INV_9_a + q_ref_INV_9/3)/T_pq_INV_9**2
        struct[0].Fu[52,143] = -(-q_INV_9_b + q_ref_INV_9/3)/T_pq_INV_9**2
        struct[0].Fu[53,143] = -(-q_INV_9_c + q_ref_INV_9/3)/T_pq_INV_9**2
        struct[0].Fu[54,147] = 1/(3*T_pq_INV_10)
        struct[0].Fu[54,148] = -(-p_INV_10_a + p_ref_INV_10/3)/T_pq_INV_10**2
        struct[0].Fu[55,147] = 1/(3*T_pq_INV_10)
        struct[0].Fu[55,148] = -(-p_INV_10_b + p_ref_INV_10/3)/T_pq_INV_10**2
        struct[0].Fu[56,147] = 1/(3*T_pq_INV_10)
        struct[0].Fu[56,148] = -(-p_INV_10_c + p_ref_INV_10/3)/T_pq_INV_10**2
        struct[0].Fu[57,148] = -(-q_INV_10_a + q_ref_INV_10/3)/T_pq_INV_10**2
        struct[0].Fu[58,148] = -(-q_INV_10_b + q_ref_INV_10/3)/T_pq_INV_10**2
        struct[0].Fu[59,148] = -(-q_INV_10_c + q_ref_INV_10/3)/T_pq_INV_10**2
        struct[0].Fu[60,152] = 1/(3*T_pq_INV_11)
        struct[0].Fu[60,153] = -(-p_INV_11_a + p_ref_INV_11/3)/T_pq_INV_11**2
        struct[0].Fu[61,152] = 1/(3*T_pq_INV_11)
        struct[0].Fu[61,153] = -(-p_INV_11_b + p_ref_INV_11/3)/T_pq_INV_11**2
        struct[0].Fu[62,152] = 1/(3*T_pq_INV_11)
        struct[0].Fu[62,153] = -(-p_INV_11_c + p_ref_INV_11/3)/T_pq_INV_11**2
        struct[0].Fu[63,153] = -(-q_INV_11_a + q_ref_INV_11/3)/T_pq_INV_11**2
        struct[0].Fu[64,153] = -(-q_INV_11_b + q_ref_INV_11/3)/T_pq_INV_11**2
        struct[0].Fu[65,153] = -(-q_INV_11_c + q_ref_INV_11/3)/T_pq_INV_11**2
        struct[0].Fu[66,157] = 1/(3*T_pq_INV_12)
        struct[0].Fu[66,158] = -(-p_INV_12_a + p_ref_INV_12/3)/T_pq_INV_12**2
        struct[0].Fu[67,157] = 1/(3*T_pq_INV_12)
        struct[0].Fu[67,158] = -(-p_INV_12_b + p_ref_INV_12/3)/T_pq_INV_12**2
        struct[0].Fu[68,157] = 1/(3*T_pq_INV_12)
        struct[0].Fu[68,158] = -(-p_INV_12_c + p_ref_INV_12/3)/T_pq_INV_12**2
        struct[0].Fu[69,158] = -(-q_INV_12_a + q_ref_INV_12/3)/T_pq_INV_12**2
        struct[0].Fu[70,158] = -(-q_INV_12_b + q_ref_INV_12/3)/T_pq_INV_12**2
        struct[0].Fu[71,158] = -(-q_INV_12_c + q_ref_INV_12/3)/T_pq_INV_12**2
        struct[0].Fu[72,162] = 1/(3*T_pq_INV_13)
        struct[0].Fu[72,163] = -(-p_INV_13_a + p_ref_INV_13/3)/T_pq_INV_13**2
        struct[0].Fu[73,162] = 1/(3*T_pq_INV_13)
        struct[0].Fu[73,163] = -(-p_INV_13_b + p_ref_INV_13/3)/T_pq_INV_13**2
        struct[0].Fu[74,162] = 1/(3*T_pq_INV_13)
        struct[0].Fu[74,163] = -(-p_INV_13_c + p_ref_INV_13/3)/T_pq_INV_13**2
        struct[0].Fu[75,163] = -(-q_INV_13_a + q_ref_INV_13/3)/T_pq_INV_13**2
        struct[0].Fu[76,163] = -(-q_INV_13_b + q_ref_INV_13/3)/T_pq_INV_13**2
        struct[0].Fu[77,163] = -(-q_INV_13_c + q_ref_INV_13/3)/T_pq_INV_13**2

        struct[0].Gu[182,104] = K_p_v_INV_1
        struct[0].Gu[182,105] = K_p_v_INV_1
        struct[0].Gu[191,109] = K_p_v_INV_2
        struct[0].Gu[191,110] = K_p_v_INV_2
        struct[0].Gu[201,114] = K_p_v_INV_3
        struct[0].Gu[201,115] = K_p_v_INV_3
        struct[0].Gu[210,119] = K_p_v_INV_4
        struct[0].Gu[210,120] = K_p_v_INV_4
        struct[0].Gu[220,124] = K_p_v_INV_5
        struct[0].Gu[220,125] = K_p_v_INV_5
        struct[0].Gu[229,129] = K_p_v_INV_6
        struct[0].Gu[229,130] = K_p_v_INV_6
        struct[0].Gu[239,134] = K_p_v_INV_7
        struct[0].Gu[239,135] = K_p_v_INV_7
        struct[0].Gu[248,139] = K_p_v_INV_8
        struct[0].Gu[248,140] = K_p_v_INV_8
        struct[0].Gu[258,144] = K_p_v_INV_9
        struct[0].Gu[258,145] = K_p_v_INV_9
        struct[0].Gu[267,149] = K_p_v_INV_10
        struct[0].Gu[267,150] = K_p_v_INV_10
        struct[0].Gu[277,154] = K_p_v_INV_11
        struct[0].Gu[277,155] = K_p_v_INV_11
        struct[0].Gu[286,159] = K_p_v_INV_12
        struct[0].Gu[286,160] = K_p_v_INV_12
        struct[0].Gu[296,164] = K_p_v_INV_13
        struct[0].Gu[296,165] = K_p_v_INV_13






def ini_nn(struct,mode):

    # Parameters:
    u_ctrl_v_INV_1 = struct[0].u_ctrl_v_INV_1
    K_p_v_INV_1 = struct[0].K_p_v_INV_1
    K_i_v_INV_1 = struct[0].K_i_v_INV_1
    V_base_INV_1 = struct[0].V_base_INV_1
    V_base_TR_1_2_mv = struct[0].V_base_TR_1_2_mv
    S_base_INV_1 = struct[0].S_base_INV_1
    I_max_INV_1 = struct[0].I_max_INV_1
    u_ctrl_v_INV_2 = struct[0].u_ctrl_v_INV_2
    K_p_v_INV_2 = struct[0].K_p_v_INV_2
    K_i_v_INV_2 = struct[0].K_i_v_INV_2
    V_base_INV_2 = struct[0].V_base_INV_2
    S_base_INV_2 = struct[0].S_base_INV_2
    I_max_INV_2 = struct[0].I_max_INV_2
    u_ctrl_v_INV_3 = struct[0].u_ctrl_v_INV_3
    K_p_v_INV_3 = struct[0].K_p_v_INV_3
    K_i_v_INV_3 = struct[0].K_i_v_INV_3
    V_base_INV_3 = struct[0].V_base_INV_3
    V_base_TR_3_4_mv = struct[0].V_base_TR_3_4_mv
    S_base_INV_3 = struct[0].S_base_INV_3
    I_max_INV_3 = struct[0].I_max_INV_3
    u_ctrl_v_INV_4 = struct[0].u_ctrl_v_INV_4
    K_p_v_INV_4 = struct[0].K_p_v_INV_4
    K_i_v_INV_4 = struct[0].K_i_v_INV_4
    V_base_INV_4 = struct[0].V_base_INV_4
    S_base_INV_4 = struct[0].S_base_INV_4
    I_max_INV_4 = struct[0].I_max_INV_4
    u_ctrl_v_INV_5 = struct[0].u_ctrl_v_INV_5
    K_p_v_INV_5 = struct[0].K_p_v_INV_5
    K_i_v_INV_5 = struct[0].K_i_v_INV_5
    V_base_INV_5 = struct[0].V_base_INV_5
    V_base_TR_5_6_mv = struct[0].V_base_TR_5_6_mv
    S_base_INV_5 = struct[0].S_base_INV_5
    I_max_INV_5 = struct[0].I_max_INV_5
    u_ctrl_v_INV_6 = struct[0].u_ctrl_v_INV_6
    K_p_v_INV_6 = struct[0].K_p_v_INV_6
    K_i_v_INV_6 = struct[0].K_i_v_INV_6
    V_base_INV_6 = struct[0].V_base_INV_6
    S_base_INV_6 = struct[0].S_base_INV_6
    I_max_INV_6 = struct[0].I_max_INV_6
    u_ctrl_v_INV_7 = struct[0].u_ctrl_v_INV_7
    K_p_v_INV_7 = struct[0].K_p_v_INV_7
    K_i_v_INV_7 = struct[0].K_i_v_INV_7
    V_base_INV_7 = struct[0].V_base_INV_7
    V_base_TR_7_8_mv = struct[0].V_base_TR_7_8_mv
    S_base_INV_7 = struct[0].S_base_INV_7
    I_max_INV_7 = struct[0].I_max_INV_7
    u_ctrl_v_INV_8 = struct[0].u_ctrl_v_INV_8
    K_p_v_INV_8 = struct[0].K_p_v_INV_8
    K_i_v_INV_8 = struct[0].K_i_v_INV_8
    V_base_INV_8 = struct[0].V_base_INV_8
    S_base_INV_8 = struct[0].S_base_INV_8
    I_max_INV_8 = struct[0].I_max_INV_8
    u_ctrl_v_INV_9 = struct[0].u_ctrl_v_INV_9
    K_p_v_INV_9 = struct[0].K_p_v_INV_9
    K_i_v_INV_9 = struct[0].K_i_v_INV_9
    V_base_INV_9 = struct[0].V_base_INV_9
    V_base_TR_9_10_mv = struct[0].V_base_TR_9_10_mv
    S_base_INV_9 = struct[0].S_base_INV_9
    I_max_INV_9 = struct[0].I_max_INV_9
    u_ctrl_v_INV_10 = struct[0].u_ctrl_v_INV_10
    K_p_v_INV_10 = struct[0].K_p_v_INV_10
    K_i_v_INV_10 = struct[0].K_i_v_INV_10
    V_base_INV_10 = struct[0].V_base_INV_10
    S_base_INV_10 = struct[0].S_base_INV_10
    I_max_INV_10 = struct[0].I_max_INV_10
    u_ctrl_v_INV_11 = struct[0].u_ctrl_v_INV_11
    K_p_v_INV_11 = struct[0].K_p_v_INV_11
    K_i_v_INV_11 = struct[0].K_i_v_INV_11
    V_base_INV_11 = struct[0].V_base_INV_11
    V_base_TR_11_12_mv = struct[0].V_base_TR_11_12_mv
    S_base_INV_11 = struct[0].S_base_INV_11
    I_max_INV_11 = struct[0].I_max_INV_11
    u_ctrl_v_INV_12 = struct[0].u_ctrl_v_INV_12
    K_p_v_INV_12 = struct[0].K_p_v_INV_12
    K_i_v_INV_12 = struct[0].K_i_v_INV_12
    V_base_INV_12 = struct[0].V_base_INV_12
    S_base_INV_12 = struct[0].S_base_INV_12
    I_max_INV_12 = struct[0].I_max_INV_12
    u_ctrl_v_INV_13 = struct[0].u_ctrl_v_INV_13
    K_p_v_INV_13 = struct[0].K_p_v_INV_13
    K_i_v_INV_13 = struct[0].K_i_v_INV_13
    V_base_INV_13 = struct[0].V_base_INV_13
    V_base_TR_13_mv = struct[0].V_base_TR_13_mv
    S_base_INV_13 = struct[0].S_base_INV_13
    I_max_INV_13 = struct[0].I_max_INV_13
    
    # Inputs:
    v_GRID_a_r = struct[0].v_GRID_a_r
    v_GRID_a_i = struct[0].v_GRID_a_i
    v_GRID_b_r = struct[0].v_GRID_b_r
    v_GRID_b_i = struct[0].v_GRID_b_i
    v_GRID_c_r = struct[0].v_GRID_c_r
    v_GRID_c_i = struct[0].v_GRID_c_i
    i_POIhv_a_r = struct[0].i_POIhv_a_r
    i_POIhv_a_i = struct[0].i_POIhv_a_i
    i_POIhv_b_r = struct[0].i_POIhv_b_r
    i_POIhv_b_i = struct[0].i_POIhv_b_i
    i_POIhv_c_r = struct[0].i_POIhv_c_r
    i_POIhv_c_i = struct[0].i_POIhv_c_i
    i_POImv_a_r = struct[0].i_POImv_a_r
    i_POImv_a_i = struct[0].i_POImv_a_i
    i_POImv_b_r = struct[0].i_POImv_b_r
    i_POImv_b_i = struct[0].i_POImv_b_i
    i_POImv_c_r = struct[0].i_POImv_c_r
    i_POImv_c_i = struct[0].i_POImv_c_i
    i_TR_1_2_mv_a_r = struct[0].i_TR_1_2_mv_a_r
    i_TR_1_2_mv_a_i = struct[0].i_TR_1_2_mv_a_i
    i_TR_1_2_mv_b_r = struct[0].i_TR_1_2_mv_b_r
    i_TR_1_2_mv_b_i = struct[0].i_TR_1_2_mv_b_i
    i_TR_1_2_mv_c_r = struct[0].i_TR_1_2_mv_c_r
    i_TR_1_2_mv_c_i = struct[0].i_TR_1_2_mv_c_i
    i_TR_1_2_lv_a_r = struct[0].i_TR_1_2_lv_a_r
    i_TR_1_2_lv_a_i = struct[0].i_TR_1_2_lv_a_i
    i_TR_1_2_lv_b_r = struct[0].i_TR_1_2_lv_b_r
    i_TR_1_2_lv_b_i = struct[0].i_TR_1_2_lv_b_i
    i_TR_1_2_lv_c_r = struct[0].i_TR_1_2_lv_c_r
    i_TR_1_2_lv_c_i = struct[0].i_TR_1_2_lv_c_i
    i_TR_3_4_mv_a_r = struct[0].i_TR_3_4_mv_a_r
    i_TR_3_4_mv_a_i = struct[0].i_TR_3_4_mv_a_i
    i_TR_3_4_mv_b_r = struct[0].i_TR_3_4_mv_b_r
    i_TR_3_4_mv_b_i = struct[0].i_TR_3_4_mv_b_i
    i_TR_3_4_mv_c_r = struct[0].i_TR_3_4_mv_c_r
    i_TR_3_4_mv_c_i = struct[0].i_TR_3_4_mv_c_i
    i_TR_3_4_lv_a_r = struct[0].i_TR_3_4_lv_a_r
    i_TR_3_4_lv_a_i = struct[0].i_TR_3_4_lv_a_i
    i_TR_3_4_lv_b_r = struct[0].i_TR_3_4_lv_b_r
    i_TR_3_4_lv_b_i = struct[0].i_TR_3_4_lv_b_i
    i_TR_3_4_lv_c_r = struct[0].i_TR_3_4_lv_c_r
    i_TR_3_4_lv_c_i = struct[0].i_TR_3_4_lv_c_i
    i_TR_5_6_mv_a_r = struct[0].i_TR_5_6_mv_a_r
    i_TR_5_6_mv_a_i = struct[0].i_TR_5_6_mv_a_i
    i_TR_5_6_mv_b_r = struct[0].i_TR_5_6_mv_b_r
    i_TR_5_6_mv_b_i = struct[0].i_TR_5_6_mv_b_i
    i_TR_5_6_mv_c_r = struct[0].i_TR_5_6_mv_c_r
    i_TR_5_6_mv_c_i = struct[0].i_TR_5_6_mv_c_i
    i_TR_5_6_lv_a_r = struct[0].i_TR_5_6_lv_a_r
    i_TR_5_6_lv_a_i = struct[0].i_TR_5_6_lv_a_i
    i_TR_5_6_lv_b_r = struct[0].i_TR_5_6_lv_b_r
    i_TR_5_6_lv_b_i = struct[0].i_TR_5_6_lv_b_i
    i_TR_5_6_lv_c_r = struct[0].i_TR_5_6_lv_c_r
    i_TR_5_6_lv_c_i = struct[0].i_TR_5_6_lv_c_i
    i_TR_7_8_mv_a_r = struct[0].i_TR_7_8_mv_a_r
    i_TR_7_8_mv_a_i = struct[0].i_TR_7_8_mv_a_i
    i_TR_7_8_mv_b_r = struct[0].i_TR_7_8_mv_b_r
    i_TR_7_8_mv_b_i = struct[0].i_TR_7_8_mv_b_i
    i_TR_7_8_mv_c_r = struct[0].i_TR_7_8_mv_c_r
    i_TR_7_8_mv_c_i = struct[0].i_TR_7_8_mv_c_i
    i_TR_7_8_lv_a_r = struct[0].i_TR_7_8_lv_a_r
    i_TR_7_8_lv_a_i = struct[0].i_TR_7_8_lv_a_i
    i_TR_7_8_lv_b_r = struct[0].i_TR_7_8_lv_b_r
    i_TR_7_8_lv_b_i = struct[0].i_TR_7_8_lv_b_i
    i_TR_7_8_lv_c_r = struct[0].i_TR_7_8_lv_c_r
    i_TR_7_8_lv_c_i = struct[0].i_TR_7_8_lv_c_i
    i_TR_9_10_mv_a_r = struct[0].i_TR_9_10_mv_a_r
    i_TR_9_10_mv_a_i = struct[0].i_TR_9_10_mv_a_i
    i_TR_9_10_mv_b_r = struct[0].i_TR_9_10_mv_b_r
    i_TR_9_10_mv_b_i = struct[0].i_TR_9_10_mv_b_i
    i_TR_9_10_mv_c_r = struct[0].i_TR_9_10_mv_c_r
    i_TR_9_10_mv_c_i = struct[0].i_TR_9_10_mv_c_i
    i_TR_9_10_lv_a_r = struct[0].i_TR_9_10_lv_a_r
    i_TR_9_10_lv_a_i = struct[0].i_TR_9_10_lv_a_i
    i_TR_9_10_lv_b_r = struct[0].i_TR_9_10_lv_b_r
    i_TR_9_10_lv_b_i = struct[0].i_TR_9_10_lv_b_i
    i_TR_9_10_lv_c_r = struct[0].i_TR_9_10_lv_c_r
    i_TR_9_10_lv_c_i = struct[0].i_TR_9_10_lv_c_i
    i_TR_11_12_mv_a_r = struct[0].i_TR_11_12_mv_a_r
    i_TR_11_12_mv_a_i = struct[0].i_TR_11_12_mv_a_i
    i_TR_11_12_mv_b_r = struct[0].i_TR_11_12_mv_b_r
    i_TR_11_12_mv_b_i = struct[0].i_TR_11_12_mv_b_i
    i_TR_11_12_mv_c_r = struct[0].i_TR_11_12_mv_c_r
    i_TR_11_12_mv_c_i = struct[0].i_TR_11_12_mv_c_i
    i_TR_11_12_lv_a_r = struct[0].i_TR_11_12_lv_a_r
    i_TR_11_12_lv_a_i = struct[0].i_TR_11_12_lv_a_i
    i_TR_11_12_lv_b_r = struct[0].i_TR_11_12_lv_b_r
    i_TR_11_12_lv_b_i = struct[0].i_TR_11_12_lv_b_i
    i_TR_11_12_lv_c_r = struct[0].i_TR_11_12_lv_c_r
    i_TR_11_12_lv_c_i = struct[0].i_TR_11_12_lv_c_i
    i_TR_13_mv_a_r = struct[0].i_TR_13_mv_a_r
    i_TR_13_mv_a_i = struct[0].i_TR_13_mv_a_i
    i_TR_13_mv_b_r = struct[0].i_TR_13_mv_b_r
    i_TR_13_mv_b_i = struct[0].i_TR_13_mv_b_i
    i_TR_13_mv_c_r = struct[0].i_TR_13_mv_c_r
    i_TR_13_mv_c_i = struct[0].i_TR_13_mv_c_i
    i_TR_13_lv_a_r = struct[0].i_TR_13_lv_a_r
    i_TR_13_lv_a_i = struct[0].i_TR_13_lv_a_i
    i_TR_13_lv_b_r = struct[0].i_TR_13_lv_b_r
    i_TR_13_lv_b_i = struct[0].i_TR_13_lv_b_i
    i_TR_13_lv_c_r = struct[0].i_TR_13_lv_c_r
    i_TR_13_lv_c_i = struct[0].i_TR_13_lv_c_i
    p_ref_INV_1 = struct[0].p_ref_INV_1
    T_pq_INV_1 = struct[0].T_pq_INV_1
    v_loc_ref_INV_1 = struct[0].v_loc_ref_INV_1
    Dv_r_INV_1 = struct[0].Dv_r_INV_1
    Dq_r_INV_1 = struct[0].Dq_r_INV_1
    p_ref_INV_2 = struct[0].p_ref_INV_2
    T_pq_INV_2 = struct[0].T_pq_INV_2
    v_loc_ref_INV_2 = struct[0].v_loc_ref_INV_2
    Dv_r_INV_2 = struct[0].Dv_r_INV_2
    Dq_r_INV_2 = struct[0].Dq_r_INV_2
    p_ref_INV_3 = struct[0].p_ref_INV_3
    T_pq_INV_3 = struct[0].T_pq_INV_3
    v_loc_ref_INV_3 = struct[0].v_loc_ref_INV_3
    Dv_r_INV_3 = struct[0].Dv_r_INV_3
    Dq_r_INV_3 = struct[0].Dq_r_INV_3
    p_ref_INV_4 = struct[0].p_ref_INV_4
    T_pq_INV_4 = struct[0].T_pq_INV_4
    v_loc_ref_INV_4 = struct[0].v_loc_ref_INV_4
    Dv_r_INV_4 = struct[0].Dv_r_INV_4
    Dq_r_INV_4 = struct[0].Dq_r_INV_4
    p_ref_INV_5 = struct[0].p_ref_INV_5
    T_pq_INV_5 = struct[0].T_pq_INV_5
    v_loc_ref_INV_5 = struct[0].v_loc_ref_INV_5
    Dv_r_INV_5 = struct[0].Dv_r_INV_5
    Dq_r_INV_5 = struct[0].Dq_r_INV_5
    p_ref_INV_6 = struct[0].p_ref_INV_6
    T_pq_INV_6 = struct[0].T_pq_INV_6
    v_loc_ref_INV_6 = struct[0].v_loc_ref_INV_6
    Dv_r_INV_6 = struct[0].Dv_r_INV_6
    Dq_r_INV_6 = struct[0].Dq_r_INV_6
    p_ref_INV_7 = struct[0].p_ref_INV_7
    T_pq_INV_7 = struct[0].T_pq_INV_7
    v_loc_ref_INV_7 = struct[0].v_loc_ref_INV_7
    Dv_r_INV_7 = struct[0].Dv_r_INV_7
    Dq_r_INV_7 = struct[0].Dq_r_INV_7
    p_ref_INV_8 = struct[0].p_ref_INV_8
    T_pq_INV_8 = struct[0].T_pq_INV_8
    v_loc_ref_INV_8 = struct[0].v_loc_ref_INV_8
    Dv_r_INV_8 = struct[0].Dv_r_INV_8
    Dq_r_INV_8 = struct[0].Dq_r_INV_8
    p_ref_INV_9 = struct[0].p_ref_INV_9
    T_pq_INV_9 = struct[0].T_pq_INV_9
    v_loc_ref_INV_9 = struct[0].v_loc_ref_INV_9
    Dv_r_INV_9 = struct[0].Dv_r_INV_9
    Dq_r_INV_9 = struct[0].Dq_r_INV_9
    p_ref_INV_10 = struct[0].p_ref_INV_10
    T_pq_INV_10 = struct[0].T_pq_INV_10
    v_loc_ref_INV_10 = struct[0].v_loc_ref_INV_10
    Dv_r_INV_10 = struct[0].Dv_r_INV_10
    Dq_r_INV_10 = struct[0].Dq_r_INV_10
    p_ref_INV_11 = struct[0].p_ref_INV_11
    T_pq_INV_11 = struct[0].T_pq_INV_11
    v_loc_ref_INV_11 = struct[0].v_loc_ref_INV_11
    Dv_r_INV_11 = struct[0].Dv_r_INV_11
    Dq_r_INV_11 = struct[0].Dq_r_INV_11
    p_ref_INV_12 = struct[0].p_ref_INV_12
    T_pq_INV_12 = struct[0].T_pq_INV_12
    v_loc_ref_INV_12 = struct[0].v_loc_ref_INV_12
    Dv_r_INV_12 = struct[0].Dv_r_INV_12
    Dq_r_INV_12 = struct[0].Dq_r_INV_12
    p_ref_INV_13 = struct[0].p_ref_INV_13
    T_pq_INV_13 = struct[0].T_pq_INV_13
    v_loc_ref_INV_13 = struct[0].v_loc_ref_INV_13
    Dv_r_INV_13 = struct[0].Dv_r_INV_13
    Dq_r_INV_13 = struct[0].Dq_r_INV_13
    
    # Dynamical states:
    p_INV_1_a = struct[0].x[0,0]
    p_INV_1_b = struct[0].x[1,0]
    p_INV_1_c = struct[0].x[2,0]
    q_INV_1_a = struct[0].x[3,0]
    q_INV_1_b = struct[0].x[4,0]
    q_INV_1_c = struct[0].x[5,0]
    p_INV_2_a = struct[0].x[6,0]
    p_INV_2_b = struct[0].x[7,0]
    p_INV_2_c = struct[0].x[8,0]
    q_INV_2_a = struct[0].x[9,0]
    q_INV_2_b = struct[0].x[10,0]
    q_INV_2_c = struct[0].x[11,0]
    p_INV_3_a = struct[0].x[12,0]
    p_INV_3_b = struct[0].x[13,0]
    p_INV_3_c = struct[0].x[14,0]
    q_INV_3_a = struct[0].x[15,0]
    q_INV_3_b = struct[0].x[16,0]
    q_INV_3_c = struct[0].x[17,0]
    p_INV_4_a = struct[0].x[18,0]
    p_INV_4_b = struct[0].x[19,0]
    p_INV_4_c = struct[0].x[20,0]
    q_INV_4_a = struct[0].x[21,0]
    q_INV_4_b = struct[0].x[22,0]
    q_INV_4_c = struct[0].x[23,0]
    p_INV_5_a = struct[0].x[24,0]
    p_INV_5_b = struct[0].x[25,0]
    p_INV_5_c = struct[0].x[26,0]
    q_INV_5_a = struct[0].x[27,0]
    q_INV_5_b = struct[0].x[28,0]
    q_INV_5_c = struct[0].x[29,0]
    p_INV_6_a = struct[0].x[30,0]
    p_INV_6_b = struct[0].x[31,0]
    p_INV_6_c = struct[0].x[32,0]
    q_INV_6_a = struct[0].x[33,0]
    q_INV_6_b = struct[0].x[34,0]
    q_INV_6_c = struct[0].x[35,0]
    p_INV_7_a = struct[0].x[36,0]
    p_INV_7_b = struct[0].x[37,0]
    p_INV_7_c = struct[0].x[38,0]
    q_INV_7_a = struct[0].x[39,0]
    q_INV_7_b = struct[0].x[40,0]
    q_INV_7_c = struct[0].x[41,0]
    p_INV_8_a = struct[0].x[42,0]
    p_INV_8_b = struct[0].x[43,0]
    p_INV_8_c = struct[0].x[44,0]
    q_INV_8_a = struct[0].x[45,0]
    q_INV_8_b = struct[0].x[46,0]
    q_INV_8_c = struct[0].x[47,0]
    p_INV_9_a = struct[0].x[48,0]
    p_INV_9_b = struct[0].x[49,0]
    p_INV_9_c = struct[0].x[50,0]
    q_INV_9_a = struct[0].x[51,0]
    q_INV_9_b = struct[0].x[52,0]
    q_INV_9_c = struct[0].x[53,0]
    p_INV_10_a = struct[0].x[54,0]
    p_INV_10_b = struct[0].x[55,0]
    p_INV_10_c = struct[0].x[56,0]
    q_INV_10_a = struct[0].x[57,0]
    q_INV_10_b = struct[0].x[58,0]
    q_INV_10_c = struct[0].x[59,0]
    p_INV_11_a = struct[0].x[60,0]
    p_INV_11_b = struct[0].x[61,0]
    p_INV_11_c = struct[0].x[62,0]
    q_INV_11_a = struct[0].x[63,0]
    q_INV_11_b = struct[0].x[64,0]
    q_INV_11_c = struct[0].x[65,0]
    p_INV_12_a = struct[0].x[66,0]
    p_INV_12_b = struct[0].x[67,0]
    p_INV_12_c = struct[0].x[68,0]
    q_INV_12_a = struct[0].x[69,0]
    q_INV_12_b = struct[0].x[70,0]
    q_INV_12_c = struct[0].x[71,0]
    p_INV_13_a = struct[0].x[72,0]
    p_INV_13_b = struct[0].x[73,0]
    p_INV_13_c = struct[0].x[74,0]
    q_INV_13_a = struct[0].x[75,0]
    q_INV_13_b = struct[0].x[76,0]
    q_INV_13_c = struct[0].x[77,0]
    
    # Algebraic states:
    v_INV_1_a_r = struct[0].y_ini[0,0]
    v_INV_1_a_i = struct[0].y_ini[1,0]
    v_INV_1_b_r = struct[0].y_ini[2,0]
    v_INV_1_b_i = struct[0].y_ini[3,0]
    v_INV_1_c_r = struct[0].y_ini[4,0]
    v_INV_1_c_i = struct[0].y_ini[5,0]
    v_INV_2_a_r = struct[0].y_ini[6,0]
    v_INV_2_a_i = struct[0].y_ini[7,0]
    v_INV_2_b_r = struct[0].y_ini[8,0]
    v_INV_2_b_i = struct[0].y_ini[9,0]
    v_INV_2_c_r = struct[0].y_ini[10,0]
    v_INV_2_c_i = struct[0].y_ini[11,0]
    v_INV_3_a_r = struct[0].y_ini[12,0]
    v_INV_3_a_i = struct[0].y_ini[13,0]
    v_INV_3_b_r = struct[0].y_ini[14,0]
    v_INV_3_b_i = struct[0].y_ini[15,0]
    v_INV_3_c_r = struct[0].y_ini[16,0]
    v_INV_3_c_i = struct[0].y_ini[17,0]
    v_INV_4_a_r = struct[0].y_ini[18,0]
    v_INV_4_a_i = struct[0].y_ini[19,0]
    v_INV_4_b_r = struct[0].y_ini[20,0]
    v_INV_4_b_i = struct[0].y_ini[21,0]
    v_INV_4_c_r = struct[0].y_ini[22,0]
    v_INV_4_c_i = struct[0].y_ini[23,0]
    v_INV_5_a_r = struct[0].y_ini[24,0]
    v_INV_5_a_i = struct[0].y_ini[25,0]
    v_INV_5_b_r = struct[0].y_ini[26,0]
    v_INV_5_b_i = struct[0].y_ini[27,0]
    v_INV_5_c_r = struct[0].y_ini[28,0]
    v_INV_5_c_i = struct[0].y_ini[29,0]
    v_INV_6_a_r = struct[0].y_ini[30,0]
    v_INV_6_a_i = struct[0].y_ini[31,0]
    v_INV_6_b_r = struct[0].y_ini[32,0]
    v_INV_6_b_i = struct[0].y_ini[33,0]
    v_INV_6_c_r = struct[0].y_ini[34,0]
    v_INV_6_c_i = struct[0].y_ini[35,0]
    v_INV_7_a_r = struct[0].y_ini[36,0]
    v_INV_7_a_i = struct[0].y_ini[37,0]
    v_INV_7_b_r = struct[0].y_ini[38,0]
    v_INV_7_b_i = struct[0].y_ini[39,0]
    v_INV_7_c_r = struct[0].y_ini[40,0]
    v_INV_7_c_i = struct[0].y_ini[41,0]
    v_INV_8_a_r = struct[0].y_ini[42,0]
    v_INV_8_a_i = struct[0].y_ini[43,0]
    v_INV_8_b_r = struct[0].y_ini[44,0]
    v_INV_8_b_i = struct[0].y_ini[45,0]
    v_INV_8_c_r = struct[0].y_ini[46,0]
    v_INV_8_c_i = struct[0].y_ini[47,0]
    v_INV_9_a_r = struct[0].y_ini[48,0]
    v_INV_9_a_i = struct[0].y_ini[49,0]
    v_INV_9_b_r = struct[0].y_ini[50,0]
    v_INV_9_b_i = struct[0].y_ini[51,0]
    v_INV_9_c_r = struct[0].y_ini[52,0]
    v_INV_9_c_i = struct[0].y_ini[53,0]
    v_INV_10_a_r = struct[0].y_ini[54,0]
    v_INV_10_a_i = struct[0].y_ini[55,0]
    v_INV_10_b_r = struct[0].y_ini[56,0]
    v_INV_10_b_i = struct[0].y_ini[57,0]
    v_INV_10_c_r = struct[0].y_ini[58,0]
    v_INV_10_c_i = struct[0].y_ini[59,0]
    v_INV_11_a_r = struct[0].y_ini[60,0]
    v_INV_11_a_i = struct[0].y_ini[61,0]
    v_INV_11_b_r = struct[0].y_ini[62,0]
    v_INV_11_b_i = struct[0].y_ini[63,0]
    v_INV_11_c_r = struct[0].y_ini[64,0]
    v_INV_11_c_i = struct[0].y_ini[65,0]
    v_INV_12_a_r = struct[0].y_ini[66,0]
    v_INV_12_a_i = struct[0].y_ini[67,0]
    v_INV_12_b_r = struct[0].y_ini[68,0]
    v_INV_12_b_i = struct[0].y_ini[69,0]
    v_INV_12_c_r = struct[0].y_ini[70,0]
    v_INV_12_c_i = struct[0].y_ini[71,0]
    v_INV_13_a_r = struct[0].y_ini[72,0]
    v_INV_13_a_i = struct[0].y_ini[73,0]
    v_INV_13_b_r = struct[0].y_ini[74,0]
    v_INV_13_b_i = struct[0].y_ini[75,0]
    v_INV_13_c_r = struct[0].y_ini[76,0]
    v_INV_13_c_i = struct[0].y_ini[77,0]
    v_POIhv_a_r = struct[0].y_ini[78,0]
    v_POIhv_a_i = struct[0].y_ini[79,0]
    v_POIhv_b_r = struct[0].y_ini[80,0]
    v_POIhv_b_i = struct[0].y_ini[81,0]
    v_POIhv_c_r = struct[0].y_ini[82,0]
    v_POIhv_c_i = struct[0].y_ini[83,0]
    v_POImv_a_r = struct[0].y_ini[84,0]
    v_POImv_a_i = struct[0].y_ini[85,0]
    v_POImv_b_r = struct[0].y_ini[86,0]
    v_POImv_b_i = struct[0].y_ini[87,0]
    v_POImv_c_r = struct[0].y_ini[88,0]
    v_POImv_c_i = struct[0].y_ini[89,0]
    v_TR_1_2_mv_a_r = struct[0].y_ini[90,0]
    v_TR_1_2_mv_a_i = struct[0].y_ini[91,0]
    v_TR_1_2_mv_b_r = struct[0].y_ini[92,0]
    v_TR_1_2_mv_b_i = struct[0].y_ini[93,0]
    v_TR_1_2_mv_c_r = struct[0].y_ini[94,0]
    v_TR_1_2_mv_c_i = struct[0].y_ini[95,0]
    v_TR_1_2_lv_a_r = struct[0].y_ini[96,0]
    v_TR_1_2_lv_a_i = struct[0].y_ini[97,0]
    v_TR_1_2_lv_b_r = struct[0].y_ini[98,0]
    v_TR_1_2_lv_b_i = struct[0].y_ini[99,0]
    v_TR_1_2_lv_c_r = struct[0].y_ini[100,0]
    v_TR_1_2_lv_c_i = struct[0].y_ini[101,0]
    v_TR_3_4_mv_a_r = struct[0].y_ini[102,0]
    v_TR_3_4_mv_a_i = struct[0].y_ini[103,0]
    v_TR_3_4_mv_b_r = struct[0].y_ini[104,0]
    v_TR_3_4_mv_b_i = struct[0].y_ini[105,0]
    v_TR_3_4_mv_c_r = struct[0].y_ini[106,0]
    v_TR_3_4_mv_c_i = struct[0].y_ini[107,0]
    v_TR_3_4_lv_a_r = struct[0].y_ini[108,0]
    v_TR_3_4_lv_a_i = struct[0].y_ini[109,0]
    v_TR_3_4_lv_b_r = struct[0].y_ini[110,0]
    v_TR_3_4_lv_b_i = struct[0].y_ini[111,0]
    v_TR_3_4_lv_c_r = struct[0].y_ini[112,0]
    v_TR_3_4_lv_c_i = struct[0].y_ini[113,0]
    v_TR_5_6_mv_a_r = struct[0].y_ini[114,0]
    v_TR_5_6_mv_a_i = struct[0].y_ini[115,0]
    v_TR_5_6_mv_b_r = struct[0].y_ini[116,0]
    v_TR_5_6_mv_b_i = struct[0].y_ini[117,0]
    v_TR_5_6_mv_c_r = struct[0].y_ini[118,0]
    v_TR_5_6_mv_c_i = struct[0].y_ini[119,0]
    v_TR_5_6_lv_a_r = struct[0].y_ini[120,0]
    v_TR_5_6_lv_a_i = struct[0].y_ini[121,0]
    v_TR_5_6_lv_b_r = struct[0].y_ini[122,0]
    v_TR_5_6_lv_b_i = struct[0].y_ini[123,0]
    v_TR_5_6_lv_c_r = struct[0].y_ini[124,0]
    v_TR_5_6_lv_c_i = struct[0].y_ini[125,0]
    v_TR_7_8_mv_a_r = struct[0].y_ini[126,0]
    v_TR_7_8_mv_a_i = struct[0].y_ini[127,0]
    v_TR_7_8_mv_b_r = struct[0].y_ini[128,0]
    v_TR_7_8_mv_b_i = struct[0].y_ini[129,0]
    v_TR_7_8_mv_c_r = struct[0].y_ini[130,0]
    v_TR_7_8_mv_c_i = struct[0].y_ini[131,0]
    v_TR_7_8_lv_a_r = struct[0].y_ini[132,0]
    v_TR_7_8_lv_a_i = struct[0].y_ini[133,0]
    v_TR_7_8_lv_b_r = struct[0].y_ini[134,0]
    v_TR_7_8_lv_b_i = struct[0].y_ini[135,0]
    v_TR_7_8_lv_c_r = struct[0].y_ini[136,0]
    v_TR_7_8_lv_c_i = struct[0].y_ini[137,0]
    v_TR_9_10_mv_a_r = struct[0].y_ini[138,0]
    v_TR_9_10_mv_a_i = struct[0].y_ini[139,0]
    v_TR_9_10_mv_b_r = struct[0].y_ini[140,0]
    v_TR_9_10_mv_b_i = struct[0].y_ini[141,0]
    v_TR_9_10_mv_c_r = struct[0].y_ini[142,0]
    v_TR_9_10_mv_c_i = struct[0].y_ini[143,0]
    v_TR_9_10_lv_a_r = struct[0].y_ini[144,0]
    v_TR_9_10_lv_a_i = struct[0].y_ini[145,0]
    v_TR_9_10_lv_b_r = struct[0].y_ini[146,0]
    v_TR_9_10_lv_b_i = struct[0].y_ini[147,0]
    v_TR_9_10_lv_c_r = struct[0].y_ini[148,0]
    v_TR_9_10_lv_c_i = struct[0].y_ini[149,0]
    v_TR_11_12_mv_a_r = struct[0].y_ini[150,0]
    v_TR_11_12_mv_a_i = struct[0].y_ini[151,0]
    v_TR_11_12_mv_b_r = struct[0].y_ini[152,0]
    v_TR_11_12_mv_b_i = struct[0].y_ini[153,0]
    v_TR_11_12_mv_c_r = struct[0].y_ini[154,0]
    v_TR_11_12_mv_c_i = struct[0].y_ini[155,0]
    v_TR_11_12_lv_a_r = struct[0].y_ini[156,0]
    v_TR_11_12_lv_a_i = struct[0].y_ini[157,0]
    v_TR_11_12_lv_b_r = struct[0].y_ini[158,0]
    v_TR_11_12_lv_b_i = struct[0].y_ini[159,0]
    v_TR_11_12_lv_c_r = struct[0].y_ini[160,0]
    v_TR_11_12_lv_c_i = struct[0].y_ini[161,0]
    v_TR_13_mv_a_r = struct[0].y_ini[162,0]
    v_TR_13_mv_a_i = struct[0].y_ini[163,0]
    v_TR_13_mv_b_r = struct[0].y_ini[164,0]
    v_TR_13_mv_b_i = struct[0].y_ini[165,0]
    v_TR_13_mv_c_r = struct[0].y_ini[166,0]
    v_TR_13_mv_c_i = struct[0].y_ini[167,0]
    v_TR_13_lv_a_r = struct[0].y_ini[168,0]
    v_TR_13_lv_a_i = struct[0].y_ini[169,0]
    v_TR_13_lv_b_r = struct[0].y_ini[170,0]
    v_TR_13_lv_b_i = struct[0].y_ini[171,0]
    v_TR_13_lv_c_r = struct[0].y_ini[172,0]
    v_TR_13_lv_c_i = struct[0].y_ini[173,0]
    i_INV_1_a_r = struct[0].y_ini[174,0]
    i_INV_1_a_i = struct[0].y_ini[175,0]
    i_INV_1_b_r = struct[0].y_ini[176,0]
    i_INV_1_b_i = struct[0].y_ini[177,0]
    i_INV_1_c_r = struct[0].y_ini[178,0]
    i_INV_1_c_i = struct[0].y_ini[179,0]
    v_m_INV_1 = struct[0].y_ini[180,0]
    v_m_TR_1_2_mv = struct[0].y_ini[181,0]
    i_reac_ref_INV_1 = struct[0].y_ini[182,0]
    q_ref_INV_1 = struct[0].y_ini[183,0]
    i_INV_2_a_r = struct[0].y_ini[184,0]
    i_INV_2_a_i = struct[0].y_ini[185,0]
    i_INV_2_b_r = struct[0].y_ini[186,0]
    i_INV_2_b_i = struct[0].y_ini[187,0]
    i_INV_2_c_r = struct[0].y_ini[188,0]
    i_INV_2_c_i = struct[0].y_ini[189,0]
    v_m_INV_2 = struct[0].y_ini[190,0]
    i_reac_ref_INV_2 = struct[0].y_ini[191,0]
    q_ref_INV_2 = struct[0].y_ini[192,0]
    i_INV_3_a_r = struct[0].y_ini[193,0]
    i_INV_3_a_i = struct[0].y_ini[194,0]
    i_INV_3_b_r = struct[0].y_ini[195,0]
    i_INV_3_b_i = struct[0].y_ini[196,0]
    i_INV_3_c_r = struct[0].y_ini[197,0]
    i_INV_3_c_i = struct[0].y_ini[198,0]
    v_m_INV_3 = struct[0].y_ini[199,0]
    v_m_TR_3_4_mv = struct[0].y_ini[200,0]
    i_reac_ref_INV_3 = struct[0].y_ini[201,0]
    q_ref_INV_3 = struct[0].y_ini[202,0]
    i_INV_4_a_r = struct[0].y_ini[203,0]
    i_INV_4_a_i = struct[0].y_ini[204,0]
    i_INV_4_b_r = struct[0].y_ini[205,0]
    i_INV_4_b_i = struct[0].y_ini[206,0]
    i_INV_4_c_r = struct[0].y_ini[207,0]
    i_INV_4_c_i = struct[0].y_ini[208,0]
    v_m_INV_4 = struct[0].y_ini[209,0]
    i_reac_ref_INV_4 = struct[0].y_ini[210,0]
    q_ref_INV_4 = struct[0].y_ini[211,0]
    i_INV_5_a_r = struct[0].y_ini[212,0]
    i_INV_5_a_i = struct[0].y_ini[213,0]
    i_INV_5_b_r = struct[0].y_ini[214,0]
    i_INV_5_b_i = struct[0].y_ini[215,0]
    i_INV_5_c_r = struct[0].y_ini[216,0]
    i_INV_5_c_i = struct[0].y_ini[217,0]
    v_m_INV_5 = struct[0].y_ini[218,0]
    v_m_TR_5_6_mv = struct[0].y_ini[219,0]
    i_reac_ref_INV_5 = struct[0].y_ini[220,0]
    q_ref_INV_5 = struct[0].y_ini[221,0]
    i_INV_6_a_r = struct[0].y_ini[222,0]
    i_INV_6_a_i = struct[0].y_ini[223,0]
    i_INV_6_b_r = struct[0].y_ini[224,0]
    i_INV_6_b_i = struct[0].y_ini[225,0]
    i_INV_6_c_r = struct[0].y_ini[226,0]
    i_INV_6_c_i = struct[0].y_ini[227,0]
    v_m_INV_6 = struct[0].y_ini[228,0]
    i_reac_ref_INV_6 = struct[0].y_ini[229,0]
    q_ref_INV_6 = struct[0].y_ini[230,0]
    i_INV_7_a_r = struct[0].y_ini[231,0]
    i_INV_7_a_i = struct[0].y_ini[232,0]
    i_INV_7_b_r = struct[0].y_ini[233,0]
    i_INV_7_b_i = struct[0].y_ini[234,0]
    i_INV_7_c_r = struct[0].y_ini[235,0]
    i_INV_7_c_i = struct[0].y_ini[236,0]
    v_m_INV_7 = struct[0].y_ini[237,0]
    v_m_TR_7_8_mv = struct[0].y_ini[238,0]
    i_reac_ref_INV_7 = struct[0].y_ini[239,0]
    q_ref_INV_7 = struct[0].y_ini[240,0]
    i_INV_8_a_r = struct[0].y_ini[241,0]
    i_INV_8_a_i = struct[0].y_ini[242,0]
    i_INV_8_b_r = struct[0].y_ini[243,0]
    i_INV_8_b_i = struct[0].y_ini[244,0]
    i_INV_8_c_r = struct[0].y_ini[245,0]
    i_INV_8_c_i = struct[0].y_ini[246,0]
    v_m_INV_8 = struct[0].y_ini[247,0]
    i_reac_ref_INV_8 = struct[0].y_ini[248,0]
    q_ref_INV_8 = struct[0].y_ini[249,0]
    i_INV_9_a_r = struct[0].y_ini[250,0]
    i_INV_9_a_i = struct[0].y_ini[251,0]
    i_INV_9_b_r = struct[0].y_ini[252,0]
    i_INV_9_b_i = struct[0].y_ini[253,0]
    i_INV_9_c_r = struct[0].y_ini[254,0]
    i_INV_9_c_i = struct[0].y_ini[255,0]
    v_m_INV_9 = struct[0].y_ini[256,0]
    v_m_TR_9_10_mv = struct[0].y_ini[257,0]
    i_reac_ref_INV_9 = struct[0].y_ini[258,0]
    q_ref_INV_9 = struct[0].y_ini[259,0]
    i_INV_10_a_r = struct[0].y_ini[260,0]
    i_INV_10_a_i = struct[0].y_ini[261,0]
    i_INV_10_b_r = struct[0].y_ini[262,0]
    i_INV_10_b_i = struct[0].y_ini[263,0]
    i_INV_10_c_r = struct[0].y_ini[264,0]
    i_INV_10_c_i = struct[0].y_ini[265,0]
    v_m_INV_10 = struct[0].y_ini[266,0]
    i_reac_ref_INV_10 = struct[0].y_ini[267,0]
    q_ref_INV_10 = struct[0].y_ini[268,0]
    i_INV_11_a_r = struct[0].y_ini[269,0]
    i_INV_11_a_i = struct[0].y_ini[270,0]
    i_INV_11_b_r = struct[0].y_ini[271,0]
    i_INV_11_b_i = struct[0].y_ini[272,0]
    i_INV_11_c_r = struct[0].y_ini[273,0]
    i_INV_11_c_i = struct[0].y_ini[274,0]
    v_m_INV_11 = struct[0].y_ini[275,0]
    v_m_TR_11_12_mv = struct[0].y_ini[276,0]
    i_reac_ref_INV_11 = struct[0].y_ini[277,0]
    q_ref_INV_11 = struct[0].y_ini[278,0]
    i_INV_12_a_r = struct[0].y_ini[279,0]
    i_INV_12_a_i = struct[0].y_ini[280,0]
    i_INV_12_b_r = struct[0].y_ini[281,0]
    i_INV_12_b_i = struct[0].y_ini[282,0]
    i_INV_12_c_r = struct[0].y_ini[283,0]
    i_INV_12_c_i = struct[0].y_ini[284,0]
    v_m_INV_12 = struct[0].y_ini[285,0]
    i_reac_ref_INV_12 = struct[0].y_ini[286,0]
    q_ref_INV_12 = struct[0].y_ini[287,0]
    i_INV_13_a_r = struct[0].y_ini[288,0]
    i_INV_13_a_i = struct[0].y_ini[289,0]
    i_INV_13_b_r = struct[0].y_ini[290,0]
    i_INV_13_b_i = struct[0].y_ini[291,0]
    i_INV_13_c_r = struct[0].y_ini[292,0]
    i_INV_13_c_i = struct[0].y_ini[293,0]
    v_m_INV_13 = struct[0].y_ini[294,0]
    v_m_TR_13_mv = struct[0].y_ini[295,0]
    i_reac_ref_INV_13 = struct[0].y_ini[296,0]
    q_ref_INV_13 = struct[0].y_ini[297,0]
    
    # Differential equations:
    if mode == 2:


        struct[0].f[0,0] = (-p_INV_1_a + p_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[1,0] = (-p_INV_1_b + p_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[2,0] = (-p_INV_1_c + p_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[3,0] = (-q_INV_1_a + q_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[4,0] = (-q_INV_1_b + q_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[5,0] = (-q_INV_1_c + q_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[6,0] = (-p_INV_2_a + p_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[7,0] = (-p_INV_2_b + p_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[8,0] = (-p_INV_2_c + p_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[9,0] = (-q_INV_2_a + q_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[10,0] = (-q_INV_2_b + q_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[11,0] = (-q_INV_2_c + q_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[12,0] = (-p_INV_3_a + p_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[13,0] = (-p_INV_3_b + p_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[14,0] = (-p_INV_3_c + p_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[15,0] = (-q_INV_3_a + q_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[16,0] = (-q_INV_3_b + q_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[17,0] = (-q_INV_3_c + q_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[18,0] = (-p_INV_4_a + p_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[19,0] = (-p_INV_4_b + p_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[20,0] = (-p_INV_4_c + p_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[21,0] = (-q_INV_4_a + q_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[22,0] = (-q_INV_4_b + q_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[23,0] = (-q_INV_4_c + q_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[24,0] = (-p_INV_5_a + p_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[25,0] = (-p_INV_5_b + p_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[26,0] = (-p_INV_5_c + p_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[27,0] = (-q_INV_5_a + q_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[28,0] = (-q_INV_5_b + q_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[29,0] = (-q_INV_5_c + q_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[30,0] = (-p_INV_6_a + p_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[31,0] = (-p_INV_6_b + p_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[32,0] = (-p_INV_6_c + p_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[33,0] = (-q_INV_6_a + q_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[34,0] = (-q_INV_6_b + q_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[35,0] = (-q_INV_6_c + q_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[36,0] = (-p_INV_7_a + p_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[37,0] = (-p_INV_7_b + p_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[38,0] = (-p_INV_7_c + p_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[39,0] = (-q_INV_7_a + q_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[40,0] = (-q_INV_7_b + q_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[41,0] = (-q_INV_7_c + q_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[42,0] = (-p_INV_8_a + p_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[43,0] = (-p_INV_8_b + p_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[44,0] = (-p_INV_8_c + p_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[45,0] = (-q_INV_8_a + q_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[46,0] = (-q_INV_8_b + q_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[47,0] = (-q_INV_8_c + q_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[48,0] = (-p_INV_9_a + p_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[49,0] = (-p_INV_9_b + p_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[50,0] = (-p_INV_9_c + p_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[51,0] = (-q_INV_9_a + q_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[52,0] = (-q_INV_9_b + q_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[53,0] = (-q_INV_9_c + q_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[54,0] = (-p_INV_10_a + p_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[55,0] = (-p_INV_10_b + p_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[56,0] = (-p_INV_10_c + p_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[57,0] = (-q_INV_10_a + q_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[58,0] = (-q_INV_10_b + q_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[59,0] = (-q_INV_10_c + q_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[60,0] = (-p_INV_11_a + p_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[61,0] = (-p_INV_11_b + p_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[62,0] = (-p_INV_11_c + p_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[63,0] = (-q_INV_11_a + q_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[64,0] = (-q_INV_11_b + q_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[65,0] = (-q_INV_11_c + q_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[66,0] = (-p_INV_12_a + p_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[67,0] = (-p_INV_12_b + p_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[68,0] = (-p_INV_12_c + p_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[69,0] = (-q_INV_12_a + q_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[70,0] = (-q_INV_12_b + q_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[71,0] = (-q_INV_12_c + q_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[72,0] = (-p_INV_13_a + p_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[73,0] = (-p_INV_13_b + p_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[74,0] = (-p_INV_13_c + p_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[75,0] = (-q_INV_13_a + q_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[76,0] = (-q_INV_13_b + q_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[77,0] = (-q_INV_13_c + q_ref_INV_13/3)/T_pq_INV_13
    
    # Algebraic equations:
    if mode == 3:


        struct[0].g[0,0] = i_INV_1_a_r - 89.5459479864169*v_INV_1_a_i - 172.82391182454*v_INV_1_a_r + 25.5846390702588*v_INV_1_b_i + 49.3782605212972*v_INV_1_b_r + 25.5846390702587*v_INV_1_c_i + 49.3782605212972*v_INV_1_c_r + 89.5460683028705*v_TR_1_2_lv_a_i + 172.82391182454*v_TR_1_2_lv_a_r - 25.5845909436773*v_TR_1_2_lv_b_i - 49.3782605212972*v_TR_1_2_lv_b_r - 25.5845909436773*v_TR_1_2_lv_c_i - 49.3782605212972*v_TR_1_2_lv_c_r
        struct[0].g[1,0] = i_INV_1_a_i - 172.82391182454*v_INV_1_a_i + 89.5459479864169*v_INV_1_a_r + 49.3782605212972*v_INV_1_b_i - 25.5846390702588*v_INV_1_b_r + 49.3782605212972*v_INV_1_c_i - 25.5846390702587*v_INV_1_c_r + 172.82391182454*v_TR_1_2_lv_a_i - 89.5460683028705*v_TR_1_2_lv_a_r - 49.3782605212972*v_TR_1_2_lv_b_i + 25.5845909436773*v_TR_1_2_lv_b_r - 49.3782605212972*v_TR_1_2_lv_c_i + 25.5845909436773*v_TR_1_2_lv_c_r
        struct[0].g[2,0] = i_INV_1_b_r + 25.5846390702587*v_INV_1_a_i + 49.3782605212972*v_INV_1_a_r - 89.5459479864168*v_INV_1_b_i - 172.82391182454*v_INV_1_b_r + 25.5846390702587*v_INV_1_c_i + 49.3782605212973*v_INV_1_c_r - 25.5845909436773*v_TR_1_2_lv_a_i - 49.3782605212972*v_TR_1_2_lv_a_r + 89.5460683028705*v_TR_1_2_lv_b_i + 172.82391182454*v_TR_1_2_lv_b_r - 25.5845909436773*v_TR_1_2_lv_c_i - 49.3782605212973*v_TR_1_2_lv_c_r
        struct[0].g[3,0] = i_INV_1_b_i + 49.3782605212972*v_INV_1_a_i - 25.5846390702587*v_INV_1_a_r - 172.82391182454*v_INV_1_b_i + 89.5459479864168*v_INV_1_b_r + 49.3782605212973*v_INV_1_c_i - 25.5846390702587*v_INV_1_c_r - 49.3782605212972*v_TR_1_2_lv_a_i + 25.5845909436773*v_TR_1_2_lv_a_r + 172.82391182454*v_TR_1_2_lv_b_i - 89.5460683028705*v_TR_1_2_lv_b_r - 49.3782605212973*v_TR_1_2_lv_c_i + 25.5845909436773*v_TR_1_2_lv_c_r
        struct[0].g[4,0] = i_INV_1_c_r + 25.5846390702588*v_INV_1_a_i + 49.3782605212972*v_INV_1_a_r + 25.5846390702587*v_INV_1_b_i + 49.3782605212973*v_INV_1_b_r - 89.5459479864168*v_INV_1_c_i - 172.82391182454*v_INV_1_c_r - 25.5845909436773*v_TR_1_2_lv_a_i - 49.3782605212972*v_TR_1_2_lv_a_r - 25.5845909436772*v_TR_1_2_lv_b_i - 49.3782605212973*v_TR_1_2_lv_b_r + 89.5460683028705*v_TR_1_2_lv_c_i + 172.82391182454*v_TR_1_2_lv_c_r
        struct[0].g[5,0] = i_INV_1_c_i + 49.3782605212972*v_INV_1_a_i - 25.5846390702588*v_INV_1_a_r + 49.3782605212973*v_INV_1_b_i - 25.5846390702587*v_INV_1_b_r - 172.82391182454*v_INV_1_c_i + 89.5459479864168*v_INV_1_c_r - 49.3782605212972*v_TR_1_2_lv_a_i + 25.5845909436773*v_TR_1_2_lv_a_r - 49.3782605212973*v_TR_1_2_lv_b_i + 25.5845909436772*v_TR_1_2_lv_b_r + 172.82391182454*v_TR_1_2_lv_c_i - 89.5460683028705*v_TR_1_2_lv_c_r
        struct[0].g[6,0] = i_INV_2_a_r - 97.8437661123124*v_INV_2_a_i - 188.83868111451*v_INV_2_a_r + 27.9554372523104*v_INV_2_b_i + 53.9539088898601*v_INV_2_b_r + 27.9554372523104*v_INV_2_c_i + 53.9539088898601*v_INV_2_c_r + 97.8438762251349*v_TR_1_2_lv_a_i + 188.83868111451*v_TR_1_2_lv_a_r - 27.9553932071814*v_TR_1_2_lv_b_i - 53.9539088898601*v_TR_1_2_lv_b_r - 27.9553932071814*v_TR_1_2_lv_c_i - 53.9539088898601*v_TR_1_2_lv_c_r
        struct[0].g[7,0] = i_INV_2_a_i - 188.83868111451*v_INV_2_a_i + 97.8437661123124*v_INV_2_a_r + 53.9539088898601*v_INV_2_b_i - 27.9554372523104*v_INV_2_b_r + 53.9539088898601*v_INV_2_c_i - 27.9554372523104*v_INV_2_c_r + 188.83868111451*v_TR_1_2_lv_a_i - 97.8438762251349*v_TR_1_2_lv_a_r - 53.9539088898601*v_TR_1_2_lv_b_i + 27.9553932071814*v_TR_1_2_lv_b_r - 53.9539088898601*v_TR_1_2_lv_c_i + 27.9553932071814*v_TR_1_2_lv_c_r
        struct[0].g[8,0] = i_INV_2_b_r + 27.9554372523104*v_INV_2_a_i + 53.9539088898601*v_INV_2_a_r - 97.8437661123124*v_INV_2_b_i - 188.83868111451*v_INV_2_b_r + 27.9554372523104*v_INV_2_c_i + 53.9539088898602*v_INV_2_c_r - 27.9553932071814*v_TR_1_2_lv_a_i - 53.9539088898601*v_TR_1_2_lv_a_r + 97.8438762251349*v_TR_1_2_lv_b_i + 188.83868111451*v_TR_1_2_lv_b_r - 27.9553932071814*v_TR_1_2_lv_c_i - 53.9539088898602*v_TR_1_2_lv_c_r
        struct[0].g[9,0] = i_INV_2_b_i + 53.9539088898601*v_INV_2_a_i - 27.9554372523104*v_INV_2_a_r - 188.83868111451*v_INV_2_b_i + 97.8437661123124*v_INV_2_b_r + 53.9539088898602*v_INV_2_c_i - 27.9554372523104*v_INV_2_c_r - 53.9539088898601*v_TR_1_2_lv_a_i + 27.9553932071814*v_TR_1_2_lv_a_r + 188.83868111451*v_TR_1_2_lv_b_i - 97.8438762251349*v_TR_1_2_lv_b_r - 53.9539088898602*v_TR_1_2_lv_c_i + 27.9553932071814*v_TR_1_2_lv_c_r
        struct[0].g[10,0] = i_INV_2_c_r + 27.9554372523104*v_INV_2_a_i + 53.9539088898601*v_INV_2_a_r + 27.9554372523103*v_INV_2_b_i + 53.9539088898602*v_INV_2_b_r - 97.8437661123124*v_INV_2_c_i - 188.83868111451*v_INV_2_c_r - 27.9553932071814*v_TR_1_2_lv_a_i - 53.9539088898601*v_TR_1_2_lv_a_r - 27.9553932071813*v_TR_1_2_lv_b_i - 53.9539088898602*v_TR_1_2_lv_b_r + 97.8438762251349*v_TR_1_2_lv_c_i + 188.83868111451*v_TR_1_2_lv_c_r
        struct[0].g[11,0] = i_INV_2_c_i + 53.9539088898601*v_INV_2_a_i - 27.9554372523104*v_INV_2_a_r + 53.9539088898602*v_INV_2_b_i - 27.9554372523103*v_INV_2_b_r - 188.83868111451*v_INV_2_c_i + 97.8437661123124*v_INV_2_c_r - 53.9539088898601*v_TR_1_2_lv_a_i + 27.9553932071814*v_TR_1_2_lv_a_r - 53.9539088898602*v_TR_1_2_lv_b_i + 27.9553932071813*v_TR_1_2_lv_b_r + 188.83868111451*v_TR_1_2_lv_c_i - 97.8438762251349*v_TR_1_2_lv_c_r
        struct[0].g[12,0] = i_INV_3_a_r - 107.758827330392*v_INV_3_a_i - 207.974729711346*v_INV_3_a_r + 30.7883049386397*v_INV_3_b_i + 59.4213513460989*v_INV_3_b_r + 30.7883049386397*v_INV_3_c_i + 59.4213513460989*v_INV_3_c_r + 107.758927311578*v_TR_3_4_lv_a_i + 207.974729711346*v_TR_3_4_lv_a_r - 30.7882649461652*v_TR_3_4_lv_b_i - 59.4213513460989*v_TR_3_4_lv_b_r - 30.7882649461652*v_TR_3_4_lv_c_i - 59.4213513460989*v_TR_3_4_lv_c_r
        struct[0].g[13,0] = i_INV_3_a_i - 207.974729711346*v_INV_3_a_i + 107.758827330392*v_INV_3_a_r + 59.4213513460989*v_INV_3_b_i - 30.7883049386397*v_INV_3_b_r + 59.4213513460989*v_INV_3_c_i - 30.7883049386397*v_INV_3_c_r + 207.974729711346*v_TR_3_4_lv_a_i - 107.758927311578*v_TR_3_4_lv_a_r - 59.4213513460989*v_TR_3_4_lv_b_i + 30.7882649461652*v_TR_3_4_lv_b_r - 59.4213513460989*v_TR_3_4_lv_c_i + 30.7882649461652*v_TR_3_4_lv_c_r
        struct[0].g[14,0] = i_INV_3_b_r + 30.7883049386397*v_INV_3_a_i + 59.4213513460989*v_INV_3_a_r - 107.758827330392*v_INV_3_b_i - 207.974729711346*v_INV_3_b_r + 30.7883049386396*v_INV_3_c_i + 59.421351346099*v_INV_3_c_r - 30.7882649461652*v_TR_3_4_lv_a_i - 59.4213513460989*v_TR_3_4_lv_a_r + 107.758927311578*v_TR_3_4_lv_b_i + 207.974729711346*v_TR_3_4_lv_b_r - 30.7882649461651*v_TR_3_4_lv_c_i - 59.421351346099*v_TR_3_4_lv_c_r
        struct[0].g[15,0] = i_INV_3_b_i + 59.4213513460989*v_INV_3_a_i - 30.7883049386397*v_INV_3_a_r - 207.974729711346*v_INV_3_b_i + 107.758827330392*v_INV_3_b_r + 59.421351346099*v_INV_3_c_i - 30.7883049386396*v_INV_3_c_r - 59.4213513460989*v_TR_3_4_lv_a_i + 30.7882649461652*v_TR_3_4_lv_a_r + 207.974729711346*v_TR_3_4_lv_b_i - 107.758927311578*v_TR_3_4_lv_b_r - 59.421351346099*v_TR_3_4_lv_c_i + 30.7882649461651*v_TR_3_4_lv_c_r
        struct[0].g[16,0] = i_INV_3_c_r + 30.7883049386397*v_INV_3_a_i + 59.4213513460989*v_INV_3_a_r + 30.7883049386396*v_INV_3_b_i + 59.421351346099*v_INV_3_b_r - 107.758827330392*v_INV_3_c_i - 207.974729711346*v_INV_3_c_r - 30.7882649461652*v_TR_3_4_lv_a_i - 59.4213513460989*v_TR_3_4_lv_a_r - 30.7882649461651*v_TR_3_4_lv_b_i - 59.421351346099*v_TR_3_4_lv_b_r + 107.758927311578*v_TR_3_4_lv_c_i + 207.974729711346*v_TR_3_4_lv_c_r
        struct[0].g[17,0] = i_INV_3_c_i + 59.4213513460989*v_INV_3_a_i - 30.7883049386397*v_INV_3_a_r + 59.421351346099*v_INV_3_b_i - 30.7883049386396*v_INV_3_b_r - 207.974729711346*v_INV_3_c_i + 107.758827330392*v_INV_3_c_r - 59.4213513460989*v_TR_3_4_lv_a_i + 30.7882649461652*v_TR_3_4_lv_a_r - 59.421351346099*v_TR_3_4_lv_b_i + 30.7882649461651*v_TR_3_4_lv_b_r + 207.974729711346*v_TR_3_4_lv_c_i - 107.758927311578*v_TR_3_4_lv_c_r
        struct[0].g[18,0] = i_INV_4_a_r - 58.4538966359303*v_INV_4_a_i - 112.816376232042*v_INV_4_a_r + 16.701239710824*v_INV_4_b_i + 32.2332503520119*v_INV_4_b_r + 16.701239710824*v_INV_4_c_i + 32.2332503520119*v_INV_4_c_r + 58.4540809492443*v_TR_3_4_lv_a_i + 112.816376232042*v_TR_3_4_lv_a_r - 16.7011659854984*v_TR_3_4_lv_b_i - 32.2332503520119*v_TR_3_4_lv_b_r - 16.7011659854984*v_TR_3_4_lv_c_i - 32.2332503520119*v_TR_3_4_lv_c_r
        struct[0].g[19,0] = i_INV_4_a_i - 112.816376232042*v_INV_4_a_i + 58.4538966359303*v_INV_4_a_r + 32.2332503520119*v_INV_4_b_i - 16.701239710824*v_INV_4_b_r + 32.2332503520119*v_INV_4_c_i - 16.701239710824*v_INV_4_c_r + 112.816376232042*v_TR_3_4_lv_a_i - 58.4540809492443*v_TR_3_4_lv_a_r - 32.2332503520119*v_TR_3_4_lv_b_i + 16.7011659854984*v_TR_3_4_lv_b_r - 32.2332503520119*v_TR_3_4_lv_c_i + 16.7011659854984*v_TR_3_4_lv_c_r
        struct[0].g[20,0] = i_INV_4_b_r + 16.701239710824*v_INV_4_a_i + 32.2332503520119*v_INV_4_a_r - 58.4538966359303*v_INV_4_b_i - 112.816376232042*v_INV_4_b_r + 16.701239710824*v_INV_4_c_i + 32.2332503520119*v_INV_4_c_r - 16.7011659854984*v_TR_3_4_lv_a_i - 32.2332503520119*v_TR_3_4_lv_a_r + 58.4540809492443*v_TR_3_4_lv_b_i + 112.816376232042*v_TR_3_4_lv_b_r - 16.7011659854984*v_TR_3_4_lv_c_i - 32.2332503520119*v_TR_3_4_lv_c_r
        struct[0].g[21,0] = i_INV_4_b_i + 32.2332503520119*v_INV_4_a_i - 16.701239710824*v_INV_4_a_r - 112.816376232042*v_INV_4_b_i + 58.4538966359303*v_INV_4_b_r + 32.2332503520119*v_INV_4_c_i - 16.701239710824*v_INV_4_c_r - 32.2332503520119*v_TR_3_4_lv_a_i + 16.7011659854984*v_TR_3_4_lv_a_r + 112.816376232042*v_TR_3_4_lv_b_i - 58.4540809492443*v_TR_3_4_lv_b_r - 32.2332503520119*v_TR_3_4_lv_c_i + 16.7011659854984*v_TR_3_4_lv_c_r
        struct[0].g[22,0] = i_INV_4_c_r + 16.701239710824*v_INV_4_a_i + 32.2332503520119*v_INV_4_a_r + 16.7012397108239*v_INV_4_b_i + 32.2332503520119*v_INV_4_b_r - 58.4538966359303*v_INV_4_c_i - 112.816376232042*v_INV_4_c_r - 16.7011659854984*v_TR_3_4_lv_a_i - 32.2332503520119*v_TR_3_4_lv_a_r - 16.7011659854983*v_TR_3_4_lv_b_i - 32.2332503520119*v_TR_3_4_lv_b_r + 58.4540809492443*v_TR_3_4_lv_c_i + 112.816376232042*v_TR_3_4_lv_c_r
        struct[0].g[23,0] = i_INV_4_c_i + 32.2332503520119*v_INV_4_a_i - 16.701239710824*v_INV_4_a_r + 32.2332503520119*v_INV_4_b_i - 16.7012397108239*v_INV_4_b_r - 112.816376232042*v_INV_4_c_i + 58.4538966359303*v_INV_4_c_r - 32.2332503520119*v_TR_3_4_lv_a_i + 16.7011659854984*v_TR_3_4_lv_a_r - 32.2332503520119*v_TR_3_4_lv_b_i + 16.7011659854983*v_TR_3_4_lv_b_r + 112.816376232042*v_TR_3_4_lv_c_i - 58.4540809492443*v_TR_3_4_lv_c_r
        struct[0].g[24,0] = i_INV_5_a_r - 92.6871232662334*v_INV_5_a_i - 178.886372244962*v_INV_5_a_r + 26.4821149256174*v_INV_5_b_i + 51.1103920699891*v_INV_5_b_r + 26.4821149256174*v_INV_5_c_i + 51.1103920699891*v_INV_5_c_r + 92.6872395051616*v_TR_5_6_lv_a_i + 178.886372244962*v_TR_5_6_lv_a_r - 26.4820684300462*v_TR_5_6_lv_b_i - 51.1103920699891*v_TR_5_6_lv_b_r - 26.4820684300462*v_TR_5_6_lv_c_i - 51.1103920699891*v_TR_5_6_lv_c_r
        struct[0].g[25,0] = i_INV_5_a_i - 178.886372244962*v_INV_5_a_i + 92.6871232662334*v_INV_5_a_r + 51.1103920699891*v_INV_5_b_i - 26.4821149256174*v_INV_5_b_r + 51.1103920699891*v_INV_5_c_i - 26.4821149256174*v_INV_5_c_r + 178.886372244962*v_TR_5_6_lv_a_i - 92.6872395051616*v_TR_5_6_lv_a_r - 51.1103920699891*v_TR_5_6_lv_b_i + 26.4820684300462*v_TR_5_6_lv_b_r - 51.1103920699891*v_TR_5_6_lv_c_i + 26.4820684300462*v_TR_5_6_lv_c_r
        struct[0].g[26,0] = i_INV_5_b_r + 26.4821149256174*v_INV_5_a_i + 51.1103920699891*v_INV_5_a_r - 92.6871232662333*v_INV_5_b_i - 178.886372244962*v_INV_5_b_r + 26.4821149256174*v_INV_5_c_i + 51.1103920699892*v_INV_5_c_r - 26.4820684300461*v_TR_5_6_lv_a_i - 51.1103920699891*v_TR_5_6_lv_a_r + 92.6872395051615*v_TR_5_6_lv_b_i + 178.886372244962*v_TR_5_6_lv_b_r - 26.4820684300461*v_TR_5_6_lv_c_i - 51.1103920699892*v_TR_5_6_lv_c_r
        struct[0].g[27,0] = i_INV_5_b_i + 51.1103920699891*v_INV_5_a_i - 26.4821149256174*v_INV_5_a_r - 178.886372244962*v_INV_5_b_i + 92.6871232662333*v_INV_5_b_r + 51.1103920699892*v_INV_5_c_i - 26.4821149256174*v_INV_5_c_r - 51.1103920699891*v_TR_5_6_lv_a_i + 26.4820684300461*v_TR_5_6_lv_a_r + 178.886372244962*v_TR_5_6_lv_b_i - 92.6872395051615*v_TR_5_6_lv_b_r - 51.1103920699892*v_TR_5_6_lv_c_i + 26.4820684300461*v_TR_5_6_lv_c_r
        struct[0].g[28,0] = i_INV_5_c_r + 26.4821149256174*v_INV_5_a_i + 51.1103920699891*v_INV_5_a_r + 26.4821149256174*v_INV_5_b_i + 51.1103920699892*v_INV_5_b_r - 92.6871232662333*v_INV_5_c_i - 178.886372244962*v_INV_5_c_r - 26.4820684300462*v_TR_5_6_lv_a_i - 51.1103920699891*v_TR_5_6_lv_a_r - 26.4820684300461*v_TR_5_6_lv_b_i - 51.1103920699892*v_TR_5_6_lv_b_r + 92.6872395051615*v_TR_5_6_lv_c_i + 178.886372244962*v_TR_5_6_lv_c_r
        struct[0].g[29,0] = i_INV_5_c_i + 51.1103920699891*v_INV_5_a_i - 26.4821149256174*v_INV_5_a_r + 51.1103920699892*v_INV_5_b_i - 26.4821149256174*v_INV_5_b_r - 178.886372244962*v_INV_5_c_i + 92.6871232662333*v_INV_5_c_r - 51.1103920699891*v_TR_5_6_lv_a_i + 26.4820684300462*v_TR_5_6_lv_a_r - 51.1103920699892*v_TR_5_6_lv_b_i + 26.4820684300461*v_TR_5_6_lv_b_r + 178.886372244962*v_TR_5_6_lv_c_i - 92.6872395051615*v_TR_5_6_lv_c_r
        struct[0].g[30,0] = i_INV_6_a_r - 58.4995981119106*v_INV_6_a_i - 112.904579802783*v_INV_6_a_r + 16.714297176654*v_INV_6_b_i + 32.2584513722238*v_INV_6_b_r + 16.714297176654*v_INV_6_c_i + 32.2584513722239*v_INV_6_c_r + 58.4997822812349*v_TR_5_6_lv_a_i + 112.904579802783*v_TR_5_6_lv_a_r - 16.7142235089243*v_TR_5_6_lv_b_i - 32.2584513722238*v_TR_5_6_lv_b_r - 16.7142235089243*v_TR_5_6_lv_c_i - 32.2584513722239*v_TR_5_6_lv_c_r
        struct[0].g[31,0] = i_INV_6_a_i - 112.904579802783*v_INV_6_a_i + 58.4995981119106*v_INV_6_a_r + 32.2584513722238*v_INV_6_b_i - 16.714297176654*v_INV_6_b_r + 32.2584513722239*v_INV_6_c_i - 16.714297176654*v_INV_6_c_r + 112.904579802783*v_TR_5_6_lv_a_i - 58.4997822812349*v_TR_5_6_lv_a_r - 32.2584513722238*v_TR_5_6_lv_b_i + 16.7142235089243*v_TR_5_6_lv_b_r - 32.2584513722239*v_TR_5_6_lv_c_i + 16.7142235089243*v_TR_5_6_lv_c_r
        struct[0].g[32,0] = i_INV_6_b_r + 16.714297176654*v_INV_6_a_i + 32.2584513722238*v_INV_6_a_r - 58.4995981119106*v_INV_6_b_i - 112.904579802783*v_INV_6_b_r + 16.714297176654*v_INV_6_c_i + 32.2584513722239*v_INV_6_c_r - 16.7142235089243*v_TR_5_6_lv_a_i - 32.2584513722238*v_TR_5_6_lv_a_r + 58.4997822812349*v_TR_5_6_lv_b_i + 112.904579802783*v_TR_5_6_lv_b_r - 16.7142235089242*v_TR_5_6_lv_c_i - 32.2584513722239*v_TR_5_6_lv_c_r
        struct[0].g[33,0] = i_INV_6_b_i + 32.2584513722238*v_INV_6_a_i - 16.714297176654*v_INV_6_a_r - 112.904579802783*v_INV_6_b_i + 58.4995981119106*v_INV_6_b_r + 32.2584513722239*v_INV_6_c_i - 16.714297176654*v_INV_6_c_r - 32.2584513722238*v_TR_5_6_lv_a_i + 16.7142235089243*v_TR_5_6_lv_a_r + 112.904579802783*v_TR_5_6_lv_b_i - 58.4997822812349*v_TR_5_6_lv_b_r - 32.2584513722239*v_TR_5_6_lv_c_i + 16.7142235089242*v_TR_5_6_lv_c_r
        struct[0].g[34,0] = i_INV_6_c_r + 16.714297176654*v_INV_6_a_i + 32.2584513722239*v_INV_6_a_r + 16.714297176654*v_INV_6_b_i + 32.2584513722239*v_INV_6_b_r - 58.4995981119106*v_INV_6_c_i - 112.904579802783*v_INV_6_c_r - 16.7142235089243*v_TR_5_6_lv_a_i - 32.2584513722239*v_TR_5_6_lv_a_r - 16.7142235089242*v_TR_5_6_lv_b_i - 32.2584513722239*v_TR_5_6_lv_b_r + 58.4997822812349*v_TR_5_6_lv_c_i + 112.904579802783*v_TR_5_6_lv_c_r
        struct[0].g[35,0] = i_INV_6_c_i + 32.2584513722239*v_INV_6_a_i - 16.714297176654*v_INV_6_a_r + 32.2584513722239*v_INV_6_b_i - 16.714297176654*v_INV_6_b_r - 112.904579802783*v_INV_6_c_i + 58.4995981119106*v_INV_6_c_r - 32.2584513722239*v_TR_5_6_lv_a_i + 16.7142235089243*v_TR_5_6_lv_a_r - 32.2584513722239*v_TR_5_6_lv_b_i + 16.7142235089242*v_TR_5_6_lv_b_r + 112.904579802783*v_TR_5_6_lv_c_i - 58.4997822812349*v_TR_5_6_lv_c_r
        struct[0].g[36,0] = i_INV_7_a_r - 246.057560640311*v_INV_7_a_i - 474.891176542679*v_INV_7_a_r + 70.3021902075957*v_INV_7_b_i + 135.683193297908*v_INV_7_b_r + 70.3021902075957*v_INV_7_c_i + 135.683193297908*v_INV_7_c_r + 246.057604426258*v_TR_7_8_lv_a_i + 474.891176542679*v_TR_7_8_lv_a_r - 70.3021726932167*v_TR_7_8_lv_b_i - 135.683193297908*v_TR_7_8_lv_b_r - 70.3021726932166*v_TR_7_8_lv_c_i - 135.683193297908*v_TR_7_8_lv_c_r
        struct[0].g[37,0] = i_INV_7_a_i - 474.891176542679*v_INV_7_a_i + 246.057560640311*v_INV_7_a_r + 135.683193297908*v_INV_7_b_i - 70.3021902075957*v_INV_7_b_r + 135.683193297908*v_INV_7_c_i - 70.3021902075957*v_INV_7_c_r + 474.891176542679*v_TR_7_8_lv_a_i - 246.057604426258*v_TR_7_8_lv_a_r - 135.683193297908*v_TR_7_8_lv_b_i + 70.3021726932167*v_TR_7_8_lv_b_r - 135.683193297908*v_TR_7_8_lv_c_i + 70.3021726932166*v_TR_7_8_lv_c_r
        struct[0].g[38,0] = i_INV_7_b_r + 70.3021902075957*v_INV_7_a_i + 135.683193297908*v_INV_7_a_r - 246.057560640311*v_INV_7_b_i - 474.891176542679*v_INV_7_b_r + 70.3021902075956*v_INV_7_c_i + 135.683193297909*v_INV_7_c_r - 70.3021726932166*v_TR_7_8_lv_a_i - 135.683193297908*v_TR_7_8_lv_a_r + 246.057604426258*v_TR_7_8_lv_b_i + 474.891176542679*v_TR_7_8_lv_b_r - 70.3021726932165*v_TR_7_8_lv_c_i - 135.683193297909*v_TR_7_8_lv_c_r
        struct[0].g[39,0] = i_INV_7_b_i + 135.683193297908*v_INV_7_a_i - 70.3021902075957*v_INV_7_a_r - 474.891176542679*v_INV_7_b_i + 246.057560640311*v_INV_7_b_r + 135.683193297909*v_INV_7_c_i - 70.3021902075956*v_INV_7_c_r - 135.683193297908*v_TR_7_8_lv_a_i + 70.3021726932166*v_TR_7_8_lv_a_r + 474.891176542679*v_TR_7_8_lv_b_i - 246.057604426258*v_TR_7_8_lv_b_r - 135.683193297909*v_TR_7_8_lv_c_i + 70.3021726932165*v_TR_7_8_lv_c_r
        struct[0].g[40,0] = i_INV_7_c_r + 70.3021902075957*v_INV_7_a_i + 135.683193297908*v_INV_7_a_r + 70.3021902075956*v_INV_7_b_i + 135.683193297909*v_INV_7_b_r - 246.057560640311*v_INV_7_c_i - 474.891176542679*v_INV_7_c_r - 70.3021726932167*v_TR_7_8_lv_a_i - 135.683193297908*v_TR_7_8_lv_a_r - 70.3021726932165*v_TR_7_8_lv_b_i - 135.683193297909*v_TR_7_8_lv_b_r + 246.057604426258*v_TR_7_8_lv_c_i + 474.891176542679*v_TR_7_8_lv_c_r
        struct[0].g[41,0] = i_INV_7_c_i + 135.683193297908*v_INV_7_a_i - 70.3021902075957*v_INV_7_a_r + 135.683193297909*v_INV_7_b_i - 70.3021902075956*v_INV_7_b_r - 474.891176542679*v_INV_7_c_i + 246.057560640311*v_INV_7_c_r - 135.683193297908*v_TR_7_8_lv_a_i + 70.3021726932167*v_TR_7_8_lv_a_r - 135.683193297909*v_TR_7_8_lv_b_i + 70.3021726932165*v_TR_7_8_lv_b_r + 474.891176542679*v_TR_7_8_lv_c_i - 246.057604426258*v_TR_7_8_lv_c_r
        struct[0].g[42,0] = i_INV_8_a_r - 106.794071531051*v_INV_8_a_i - 206.112752761809*v_INV_8_a_r + 30.5126610438848*v_INV_8_b_i + 58.8893579319454*v_INV_8_b_r + 30.5126610438848*v_INV_8_c_i + 58.8893579319454*v_INV_8_c_r + 106.794172415445*v_TR_7_8_lv_a_i + 206.112752761809*v_TR_7_8_lv_a_r - 30.5126206901271*v_TR_7_8_lv_b_i - 58.8893579319454*v_TR_7_8_lv_b_r - 30.5126206901271*v_TR_7_8_lv_c_i - 58.8893579319454*v_TR_7_8_lv_c_r
        struct[0].g[43,0] = i_INV_8_a_i - 206.112752761809*v_INV_8_a_i + 106.794071531051*v_INV_8_a_r + 58.8893579319454*v_INV_8_b_i - 30.5126610438848*v_INV_8_b_r + 58.8893579319454*v_INV_8_c_i - 30.5126610438848*v_INV_8_c_r + 206.112752761809*v_TR_7_8_lv_a_i - 106.794172415445*v_TR_7_8_lv_a_r - 58.8893579319454*v_TR_7_8_lv_b_i + 30.5126206901271*v_TR_7_8_lv_b_r - 58.8893579319454*v_TR_7_8_lv_c_i + 30.5126206901271*v_TR_7_8_lv_c_r
        struct[0].g[44,0] = i_INV_8_b_r + 30.5126610438847*v_INV_8_a_i + 58.8893579319454*v_INV_8_a_r - 106.794071531051*v_INV_8_b_i - 206.112752761809*v_INV_8_b_r + 30.5126610438847*v_INV_8_c_i + 58.8893579319455*v_INV_8_c_r - 30.5126206901271*v_TR_7_8_lv_a_i - 58.8893579319454*v_TR_7_8_lv_a_r + 106.794172415445*v_TR_7_8_lv_b_i + 206.112752761809*v_TR_7_8_lv_b_r - 30.5126206901271*v_TR_7_8_lv_c_i - 58.8893579319455*v_TR_7_8_lv_c_r
        struct[0].g[45,0] = i_INV_8_b_i + 58.8893579319454*v_INV_8_a_i - 30.5126610438847*v_INV_8_a_r - 206.112752761809*v_INV_8_b_i + 106.794071531051*v_INV_8_b_r + 58.8893579319455*v_INV_8_c_i - 30.5126610438847*v_INV_8_c_r - 58.8893579319454*v_TR_7_8_lv_a_i + 30.5126206901271*v_TR_7_8_lv_a_r + 206.112752761809*v_TR_7_8_lv_b_i - 106.794172415445*v_TR_7_8_lv_b_r - 58.8893579319455*v_TR_7_8_lv_c_i + 30.5126206901271*v_TR_7_8_lv_c_r
        struct[0].g[46,0] = i_INV_8_c_r + 30.5126610438848*v_INV_8_a_i + 58.8893579319454*v_INV_8_a_r + 30.5126610438847*v_INV_8_b_i + 58.8893579319455*v_INV_8_b_r - 106.794071531051*v_INV_8_c_i - 206.112752761809*v_INV_8_c_r - 30.5126206901272*v_TR_7_8_lv_a_i - 58.8893579319454*v_TR_7_8_lv_a_r - 30.5126206901271*v_TR_7_8_lv_b_i - 58.8893579319455*v_TR_7_8_lv_b_r + 106.794172415445*v_TR_7_8_lv_c_i + 206.112752761809*v_TR_7_8_lv_c_r
        struct[0].g[47,0] = i_INV_8_c_i + 58.8893579319454*v_INV_8_a_i - 30.5126610438848*v_INV_8_a_r + 58.8893579319455*v_INV_8_b_i - 30.5126610438847*v_INV_8_b_r - 206.112752761809*v_INV_8_c_i + 106.794071531051*v_INV_8_c_r - 58.8893579319454*v_TR_7_8_lv_a_i + 30.5126206901272*v_TR_7_8_lv_a_r - 58.8893579319455*v_TR_7_8_lv_b_i + 30.5126206901271*v_TR_7_8_lv_b_r + 206.112752761809*v_TR_7_8_lv_c_i - 106.794172415445*v_TR_7_8_lv_c_r
        struct[0].g[48,0] = i_INV_9_a_r - 98.1763901476198*v_INV_9_a_i - 189.48064478264*v_INV_9_a_r + 28.0504724351543*v_INV_9_b_i + 54.1373270807543*v_INV_9_b_r + 28.0504724351542*v_INV_9_c_i + 54.1373270807543*v_INV_9_c_r + 98.1764998873781*v_TR_9_10_lv_a_i + 189.48064478264*v_TR_9_10_lv_a_r - 28.0504285392509*v_TR_9_10_lv_b_i - 54.1373270807543*v_TR_9_10_lv_b_r - 28.0504285392509*v_TR_9_10_lv_c_i - 54.1373270807543*v_TR_9_10_lv_c_r
        struct[0].g[49,0] = i_INV_9_a_i - 189.48064478264*v_INV_9_a_i + 98.1763901476198*v_INV_9_a_r + 54.1373270807543*v_INV_9_b_i - 28.0504724351543*v_INV_9_b_r + 54.1373270807543*v_INV_9_c_i - 28.0504724351542*v_INV_9_c_r + 189.48064478264*v_TR_9_10_lv_a_i - 98.1764998873781*v_TR_9_10_lv_a_r - 54.1373270807543*v_TR_9_10_lv_b_i + 28.0504285392509*v_TR_9_10_lv_b_r - 54.1373270807543*v_TR_9_10_lv_c_i + 28.0504285392509*v_TR_9_10_lv_c_r
        struct[0].g[50,0] = i_INV_9_b_r + 28.0504724351542*v_INV_9_a_i + 54.1373270807543*v_INV_9_a_r - 98.1763901476198*v_INV_9_b_i - 189.48064478264*v_INV_9_b_r + 28.0504724351542*v_INV_9_c_i + 54.1373270807544*v_INV_9_c_r - 28.0504285392509*v_TR_9_10_lv_a_i - 54.1373270807543*v_TR_9_10_lv_a_r + 98.1764998873781*v_TR_9_10_lv_b_i + 189.48064478264*v_TR_9_10_lv_b_r - 28.0504285392509*v_TR_9_10_lv_c_i - 54.1373270807544*v_TR_9_10_lv_c_r
        struct[0].g[51,0] = i_INV_9_b_i + 54.1373270807543*v_INV_9_a_i - 28.0504724351542*v_INV_9_a_r - 189.48064478264*v_INV_9_b_i + 98.1763901476198*v_INV_9_b_r + 54.1373270807544*v_INV_9_c_i - 28.0504724351542*v_INV_9_c_r - 54.1373270807543*v_TR_9_10_lv_a_i + 28.0504285392509*v_TR_9_10_lv_a_r + 189.48064478264*v_TR_9_10_lv_b_i - 98.1764998873781*v_TR_9_10_lv_b_r - 54.1373270807544*v_TR_9_10_lv_c_i + 28.0504285392509*v_TR_9_10_lv_c_r
        struct[0].g[52,0] = i_INV_9_c_r + 28.0504724351543*v_INV_9_a_i + 54.1373270807543*v_INV_9_a_r + 28.0504724351542*v_INV_9_b_i + 54.1373270807543*v_INV_9_b_r - 98.1763901476198*v_INV_9_c_i - 189.48064478264*v_INV_9_c_r - 28.0504285392509*v_TR_9_10_lv_a_i - 54.1373270807543*v_TR_9_10_lv_a_r - 28.0504285392509*v_TR_9_10_lv_b_i - 54.1373270807543*v_TR_9_10_lv_b_r + 98.1764998873781*v_TR_9_10_lv_c_i + 189.48064478264*v_TR_9_10_lv_c_r
        struct[0].g[53,0] = i_INV_9_c_i + 54.1373270807543*v_INV_9_a_i - 28.0504724351543*v_INV_9_a_r + 54.1373270807543*v_INV_9_b_i - 28.0504724351542*v_INV_9_b_r - 189.48064478264*v_INV_9_c_i + 98.1763901476198*v_INV_9_c_r - 54.1373270807543*v_TR_9_10_lv_a_i + 28.0504285392509*v_TR_9_10_lv_a_r - 54.1373270807543*v_TR_9_10_lv_b_i + 28.0504285392509*v_TR_9_10_lv_b_r + 189.48064478264*v_TR_9_10_lv_c_i - 98.1764998873781*v_TR_9_10_lv_c_r
        struct[0].g[54,0] = i_INV_10_a_r - 75.8057696238346*v_INV_10_a_i - 146.305409673982*v_INV_10_a_r + 21.6588887777877*v_INV_10_b_i + 41.8015456211378*v_INV_10_b_r + 21.6588887777877*v_INV_10_c_i + 41.8015456211378*v_INV_10_c_r + 75.8059117481773*v_TR_9_10_lv_a_i + 146.305409673982*v_TR_9_10_lv_a_r - 21.6588319280506*v_TR_9_10_lv_b_i - 41.8015456211378*v_TR_9_10_lv_b_r - 21.6588319280506*v_TR_9_10_lv_c_i - 41.8015456211378*v_TR_9_10_lv_c_r
        struct[0].g[55,0] = i_INV_10_a_i - 146.305409673982*v_INV_10_a_i + 75.8057696238346*v_INV_10_a_r + 41.8015456211378*v_INV_10_b_i - 21.6588887777877*v_INV_10_b_r + 41.8015456211378*v_INV_10_c_i - 21.6588887777877*v_INV_10_c_r + 146.305409673982*v_TR_9_10_lv_a_i - 75.8059117481773*v_TR_9_10_lv_a_r - 41.8015456211378*v_TR_9_10_lv_b_i + 21.6588319280506*v_TR_9_10_lv_b_r - 41.8015456211378*v_TR_9_10_lv_c_i + 21.6588319280506*v_TR_9_10_lv_c_r
        struct[0].g[56,0] = i_INV_10_b_r + 21.6588887777877*v_INV_10_a_i + 41.8015456211377*v_INV_10_a_r - 75.8057696238346*v_INV_10_b_i - 146.305409673982*v_INV_10_b_r + 21.6588887777877*v_INV_10_c_i + 41.8015456211378*v_INV_10_c_r - 21.6588319280506*v_TR_9_10_lv_a_i - 41.8015456211377*v_TR_9_10_lv_a_r + 75.8059117481773*v_TR_9_10_lv_b_i + 146.305409673982*v_TR_9_10_lv_b_r - 21.6588319280506*v_TR_9_10_lv_c_i - 41.8015456211378*v_TR_9_10_lv_c_r
        struct[0].g[57,0] = i_INV_10_b_i + 41.8015456211377*v_INV_10_a_i - 21.6588887777877*v_INV_10_a_r - 146.305409673982*v_INV_10_b_i + 75.8057696238346*v_INV_10_b_r + 41.8015456211378*v_INV_10_c_i - 21.6588887777877*v_INV_10_c_r - 41.8015456211377*v_TR_9_10_lv_a_i + 21.6588319280506*v_TR_9_10_lv_a_r + 146.305409673982*v_TR_9_10_lv_b_i - 75.8059117481773*v_TR_9_10_lv_b_r - 41.8015456211378*v_TR_9_10_lv_c_i + 21.6588319280506*v_TR_9_10_lv_c_r
        struct[0].g[58,0] = i_INV_10_c_r + 21.6588887777877*v_INV_10_a_i + 41.8015456211378*v_INV_10_a_r + 21.6588887777877*v_INV_10_b_i + 41.8015456211378*v_INV_10_b_r - 75.8057696238346*v_INV_10_c_i - 146.305409673982*v_INV_10_c_r - 21.6588319280506*v_TR_9_10_lv_a_i - 41.8015456211378*v_TR_9_10_lv_a_r - 21.6588319280506*v_TR_9_10_lv_b_i - 41.8015456211378*v_TR_9_10_lv_b_r + 75.8059117481773*v_TR_9_10_lv_c_i + 146.305409673982*v_TR_9_10_lv_c_r
        struct[0].g[59,0] = i_INV_10_c_i + 41.8015456211378*v_INV_10_a_i - 21.6588887777877*v_INV_10_a_r + 41.8015456211378*v_INV_10_b_i - 21.6588887777877*v_INV_10_b_r - 146.305409673982*v_INV_10_c_i + 75.8057696238346*v_INV_10_c_r - 41.8015456211378*v_TR_9_10_lv_a_i + 21.6588319280506*v_TR_9_10_lv_a_r - 41.8015456211378*v_TR_9_10_lv_b_i + 21.6588319280506*v_TR_9_10_lv_b_r + 146.305409673982*v_TR_9_10_lv_c_i - 75.8059117481773*v_TR_9_10_lv_c_r
        struct[0].g[60,0] = i_INV_11_a_r - 81.5760299591651*v_INV_11_a_i - 157.441992718694*v_INV_11_a_r + 23.3075276943302*v_INV_11_b_i + 44.9834264910554*v_INV_11_b_r + 23.3075276943302*v_INV_11_c_i + 44.9834264910554*v_INV_11_c_r + 81.5761620304113*v_TR_11_12_lv_a_i + 157.441992718694*v_TR_11_12_lv_a_r - 23.3074748658318*v_TR_11_12_lv_b_i - 44.9834264910554*v_TR_11_12_lv_b_r - 23.3074748658318*v_TR_11_12_lv_c_i - 44.9834264910554*v_TR_11_12_lv_c_r
        struct[0].g[61,0] = i_INV_11_a_i - 157.441992718694*v_INV_11_a_i + 81.5760299591651*v_INV_11_a_r + 44.9834264910554*v_INV_11_b_i - 23.3075276943302*v_INV_11_b_r + 44.9834264910554*v_INV_11_c_i - 23.3075276943302*v_INV_11_c_r + 157.441992718694*v_TR_11_12_lv_a_i - 81.5761620304113*v_TR_11_12_lv_a_r - 44.9834264910554*v_TR_11_12_lv_b_i + 23.3074748658318*v_TR_11_12_lv_b_r - 44.9834264910554*v_TR_11_12_lv_c_i + 23.3074748658318*v_TR_11_12_lv_c_r
        struct[0].g[62,0] = i_INV_11_b_r + 23.3075276943302*v_INV_11_a_i + 44.9834264910554*v_INV_11_a_r - 81.5760299591651*v_INV_11_b_i - 157.441992718694*v_INV_11_b_r + 23.3075276943302*v_INV_11_c_i + 44.9834264910555*v_INV_11_c_r - 23.3074748658318*v_TR_11_12_lv_a_i - 44.9834264910554*v_TR_11_12_lv_a_r + 81.5761620304112*v_TR_11_12_lv_b_i + 157.441992718694*v_TR_11_12_lv_b_r - 23.3074748658317*v_TR_11_12_lv_c_i - 44.9834264910555*v_TR_11_12_lv_c_r
        struct[0].g[63,0] = i_INV_11_b_i + 44.9834264910554*v_INV_11_a_i - 23.3075276943302*v_INV_11_a_r - 157.441992718694*v_INV_11_b_i + 81.5760299591651*v_INV_11_b_r + 44.9834264910555*v_INV_11_c_i - 23.3075276943302*v_INV_11_c_r - 44.9834264910554*v_TR_11_12_lv_a_i + 23.3074748658318*v_TR_11_12_lv_a_r + 157.441992718694*v_TR_11_12_lv_b_i - 81.5761620304112*v_TR_11_12_lv_b_r - 44.9834264910555*v_TR_11_12_lv_c_i + 23.3074748658317*v_TR_11_12_lv_c_r
        struct[0].g[64,0] = i_INV_11_c_r + 23.3075276943302*v_INV_11_a_i + 44.9834264910554*v_INV_11_a_r + 23.3075276943302*v_INV_11_b_i + 44.9834264910554*v_INV_11_b_r - 81.5760299591651*v_INV_11_c_i - 157.441992718694*v_INV_11_c_r - 23.3074748658318*v_TR_11_12_lv_a_i - 44.9834264910554*v_TR_11_12_lv_a_r - 23.3074748658317*v_TR_11_12_lv_b_i - 44.9834264910554*v_TR_11_12_lv_b_r + 81.5761620304112*v_TR_11_12_lv_c_i + 157.441992718694*v_TR_11_12_lv_c_r
        struct[0].g[65,0] = i_INV_11_c_i + 44.9834264910554*v_INV_11_a_i - 23.3075276943302*v_INV_11_a_r + 44.9834264910554*v_INV_11_b_i - 23.3075276943302*v_INV_11_b_r - 157.441992718694*v_INV_11_c_i + 81.5760299591651*v_INV_11_c_r - 44.9834264910554*v_TR_11_12_lv_a_i + 23.3074748658318*v_TR_11_12_lv_a_r - 44.9834264910554*v_TR_11_12_lv_b_i + 23.3074748658317*v_TR_11_12_lv_b_r + 157.441992718694*v_TR_11_12_lv_c_i - 81.5761620304112*v_TR_11_12_lv_c_r
        struct[0].g[66,0] = i_INV_12_a_r - 107.907168174067*v_INV_12_a_i - 208.26102727437*v_INV_12_a_r + 30.8306879425848*v_INV_12_b_i + 59.5031506498201*v_INV_12_b_r + 30.8306879425848*v_INV_12_c_i + 59.5031506498201*v_INV_12_c_r + 107.907268017809*v_TR_11_12_lv_a_i + 208.26102727437*v_TR_11_12_lv_a_r - 30.8306480050881*v_TR_11_12_lv_b_i - 59.5031506498201*v_TR_11_12_lv_b_r - 30.8306480050881*v_TR_11_12_lv_c_i - 59.5031506498201*v_TR_11_12_lv_c_r
        struct[0].g[67,0] = i_INV_12_a_i - 208.26102727437*v_INV_12_a_i + 107.907168174067*v_INV_12_a_r + 59.5031506498201*v_INV_12_b_i - 30.8306879425848*v_INV_12_b_r + 59.5031506498201*v_INV_12_c_i - 30.8306879425848*v_INV_12_c_r + 208.26102727437*v_TR_11_12_lv_a_i - 107.907268017809*v_TR_11_12_lv_a_r - 59.5031506498201*v_TR_11_12_lv_b_i + 30.8306480050881*v_TR_11_12_lv_b_r - 59.5031506498201*v_TR_11_12_lv_c_i + 30.8306480050881*v_TR_11_12_lv_c_r
        struct[0].g[68,0] = i_INV_12_b_r + 30.8306879425848*v_INV_12_a_i + 59.5031506498201*v_INV_12_a_r - 107.907168174067*v_INV_12_b_i - 208.261027274371*v_INV_12_b_r + 30.8306879425847*v_INV_12_c_i + 59.5031506498202*v_INV_12_c_r - 30.8306480050881*v_TR_11_12_lv_a_i - 59.5031506498201*v_TR_11_12_lv_a_r + 107.907268017808*v_TR_11_12_lv_b_i + 208.261027274371*v_TR_11_12_lv_b_r - 30.8306480050881*v_TR_11_12_lv_c_i - 59.5031506498202*v_TR_11_12_lv_c_r
        struct[0].g[69,0] = i_INV_12_b_i + 59.5031506498201*v_INV_12_a_i - 30.8306879425848*v_INV_12_a_r - 208.261027274371*v_INV_12_b_i + 107.907168174067*v_INV_12_b_r + 59.5031506498202*v_INV_12_c_i - 30.8306879425847*v_INV_12_c_r - 59.5031506498201*v_TR_11_12_lv_a_i + 30.8306480050881*v_TR_11_12_lv_a_r + 208.261027274371*v_TR_11_12_lv_b_i - 107.907268017808*v_TR_11_12_lv_b_r - 59.5031506498202*v_TR_11_12_lv_c_i + 30.8306480050881*v_TR_11_12_lv_c_r
        struct[0].g[70,0] = i_INV_12_c_r + 30.8306879425848*v_INV_12_a_i + 59.5031506498201*v_INV_12_a_r + 30.8306879425847*v_INV_12_b_i + 59.5031506498202*v_INV_12_b_r - 107.907168174067*v_INV_12_c_i - 208.261027274371*v_INV_12_c_r - 30.8306480050882*v_TR_11_12_lv_a_i - 59.5031506498201*v_TR_11_12_lv_a_r - 30.8306480050881*v_TR_11_12_lv_b_i - 59.5031506498202*v_TR_11_12_lv_b_r + 107.907268017808*v_TR_11_12_lv_c_i + 208.261027274371*v_TR_11_12_lv_c_r
        struct[0].g[71,0] = i_INV_12_c_i + 59.5031506498201*v_INV_12_a_i - 30.8306879425848*v_INV_12_a_r + 59.5031506498202*v_INV_12_b_i - 30.8306879425847*v_INV_12_b_r - 208.261027274371*v_INV_12_c_i + 107.907168174067*v_INV_12_c_r - 59.5031506498201*v_TR_11_12_lv_a_i + 30.8306480050882*v_TR_11_12_lv_a_r - 59.5031506498202*v_TR_11_12_lv_b_i + 30.8306480050881*v_TR_11_12_lv_b_r + 208.261027274371*v_TR_11_12_lv_c_i - 107.907268017808*v_TR_11_12_lv_c_r
        struct[0].g[72,0] = i_INV_13_a_r - 225.77493151679*v_INV_13_a_i - 435.745709926008*v_INV_13_a_r + 64.5071560124429*v_INV_13_b_i + 124.498774264574*v_INV_13_b_r + 64.5071560124428*v_INV_13_c_i + 124.498774264574*v_INV_13_c_r + 225.774979236273*v_TR_13_lv_a_i + 435.745709926008*v_TR_13_lv_a_r - 64.5071369246495*v_TR_13_lv_b_i - 124.498774264574*v_TR_13_lv_b_r - 64.5071369246495*v_TR_13_lv_c_i - 124.498774264574*v_TR_13_lv_c_r
        struct[0].g[73,0] = i_INV_13_a_i - 435.745709926008*v_INV_13_a_i + 225.77493151679*v_INV_13_a_r + 124.498774264574*v_INV_13_b_i - 64.5071560124429*v_INV_13_b_r + 124.498774264574*v_INV_13_c_i - 64.5071560124428*v_INV_13_c_r + 435.745709926008*v_TR_13_lv_a_i - 225.774979236273*v_TR_13_lv_a_r - 124.498774264574*v_TR_13_lv_b_i + 64.5071369246495*v_TR_13_lv_b_r - 124.498774264574*v_TR_13_lv_c_i + 64.5071369246495*v_TR_13_lv_c_r
        struct[0].g[74,0] = i_INV_13_b_r + 64.5071560124428*v_INV_13_a_i + 124.498774264574*v_INV_13_a_r - 225.77493151679*v_INV_13_b_i - 435.745709926008*v_INV_13_b_r + 64.5071560124428*v_INV_13_c_i + 124.498774264574*v_INV_13_c_r - 64.5071369246495*v_TR_13_lv_a_i - 124.498774264574*v_TR_13_lv_a_r + 225.774979236273*v_TR_13_lv_b_i + 435.745709926008*v_TR_13_lv_b_r - 64.5071369246494*v_TR_13_lv_c_i - 124.498774264574*v_TR_13_lv_c_r
        struct[0].g[75,0] = i_INV_13_b_i + 124.498774264574*v_INV_13_a_i - 64.5071560124428*v_INV_13_a_r - 435.745709926008*v_INV_13_b_i + 225.77493151679*v_INV_13_b_r + 124.498774264574*v_INV_13_c_i - 64.5071560124428*v_INV_13_c_r - 124.498774264574*v_TR_13_lv_a_i + 64.5071369246495*v_TR_13_lv_a_r + 435.745709926008*v_TR_13_lv_b_i - 225.774979236273*v_TR_13_lv_b_r - 124.498774264574*v_TR_13_lv_c_i + 64.5071369246494*v_TR_13_lv_c_r
        struct[0].g[76,0] = i_INV_13_c_r + 64.5071560124429*v_INV_13_a_i + 124.498774264574*v_INV_13_a_r + 64.5071560124428*v_INV_13_b_i + 124.498774264574*v_INV_13_b_r - 225.77493151679*v_INV_13_c_i - 435.745709926008*v_INV_13_c_r - 64.5071369246495*v_TR_13_lv_a_i - 124.498774264574*v_TR_13_lv_a_r - 64.5071369246494*v_TR_13_lv_b_i - 124.498774264574*v_TR_13_lv_b_r + 225.774979236273*v_TR_13_lv_c_i + 435.745709926008*v_TR_13_lv_c_r
        struct[0].g[77,0] = i_INV_13_c_i + 124.498774264574*v_INV_13_a_i - 64.5071560124429*v_INV_13_a_r + 124.498774264574*v_INV_13_b_i - 64.5071560124428*v_INV_13_b_r - 435.745709926008*v_INV_13_c_i + 225.77493151679*v_INV_13_c_r - 124.498774264574*v_TR_13_lv_a_i + 64.5071369246495*v_TR_13_lv_a_r - 124.498774264574*v_TR_13_lv_b_i + 64.5071369246494*v_TR_13_lv_b_r + 435.745709926008*v_TR_13_lv_c_i - 225.774979236273*v_TR_13_lv_c_r
        struct[0].g[78,0] = i_POIhv_a_r + 0.040290088638195*v_GRID_a_i + 0.024174053182917*v_GRID_a_r + 4.66248501556824e-18*v_GRID_b_i - 4.31760362252812e-18*v_GRID_b_r + 4.19816664496737e-18*v_GRID_c_i - 3.49608108880335e-18*v_GRID_c_r - 0.0647773858527649*v_POIhv_a_i - 0.0272349653347382*v_POIhv_a_r + 0.012243648607285*v_POIhv_b_i + 0.00153045607591063*v_POIhv_b_r + 0.012243648607285*v_POIhv_c_i + 0.00153045607591062*v_POIhv_c_r + 0.0699818508108637*v_POImv_a_i + 0.00874773135135797*v_POImv_a_r - 0.0699818508108637*v_POImv_b_i - 0.00874773135135797*v_POImv_b_r
        struct[0].g[79,0] = i_POIhv_a_i + 0.024174053182917*v_GRID_a_i - 0.040290088638195*v_GRID_a_r - 4.31760362252812e-18*v_GRID_b_i - 4.66248501556824e-18*v_GRID_b_r - 3.49608108880335e-18*v_GRID_c_i - 4.19816664496737e-18*v_GRID_c_r - 0.0272349653347382*v_POIhv_a_i + 0.0647773858527649*v_POIhv_a_r + 0.00153045607591063*v_POIhv_b_i - 0.012243648607285*v_POIhv_b_r + 0.00153045607591062*v_POIhv_c_i - 0.012243648607285*v_POIhv_c_r + 0.00874773135135797*v_POImv_a_i - 0.0699818508108637*v_POImv_a_r - 0.00874773135135797*v_POImv_b_i + 0.0699818508108637*v_POImv_b_r
        struct[0].g[80,0] = i_POIhv_b_r + 6.30775359573304e-19*v_GRID_a_i - 2.07254761002657e-18*v_GRID_a_r + 0.040290088638195*v_GRID_b_i + 0.024174053182917*v_GRID_b_r + 9.01107656533306e-19*v_GRID_c_i - 1.78419315993592e-17*v_GRID_c_r + 0.012243648607285*v_POIhv_a_i + 0.00153045607591062*v_POIhv_a_r - 0.0647773858527649*v_POIhv_b_i - 0.0272349653347383*v_POIhv_b_r + 0.012243648607285*v_POIhv_c_i + 0.00153045607591064*v_POIhv_c_r + 0.0699818508108637*v_POImv_b_i + 0.00874773135135797*v_POImv_b_r - 0.0699818508108637*v_POImv_c_i - 0.00874773135135797*v_POImv_c_r
        struct[0].g[81,0] = i_POIhv_b_i - 2.07254761002657e-18*v_GRID_a_i - 6.30775359573304e-19*v_GRID_a_r + 0.024174053182917*v_GRID_b_i - 0.040290088638195*v_GRID_b_r - 1.78419315993592e-17*v_GRID_c_i - 9.01107656533306e-19*v_GRID_c_r + 0.00153045607591062*v_POIhv_a_i - 0.012243648607285*v_POIhv_a_r - 0.0272349653347383*v_POIhv_b_i + 0.0647773858527649*v_POIhv_b_r + 0.00153045607591064*v_POIhv_c_i - 0.012243648607285*v_POIhv_c_r + 0.00874773135135797*v_POImv_b_i - 0.0699818508108637*v_POImv_b_r - 0.00874773135135797*v_POImv_c_i + 0.0699818508108637*v_POImv_c_r
        struct[0].g[82,0] = i_POIhv_c_r - 7.20886125226632e-19*v_GRID_a_i - 1.35166148479994e-18*v_GRID_a_r - 4.50553828266631e-19*v_GRID_b_i - 1.71210454741325e-17*v_GRID_b_r + 0.040290088638195*v_GRID_c_i + 0.024174053182917*v_GRID_c_r + 0.012243648607285*v_POIhv_a_i + 0.00153045607591062*v_POIhv_a_r + 0.012243648607285*v_POIhv_b_i + 0.00153045607591064*v_POIhv_b_r - 0.0647773858527649*v_POIhv_c_i - 0.0272349653347383*v_POIhv_c_r - 0.0699818508108637*v_POImv_a_i - 0.00874773135135797*v_POImv_a_r + 0.0699818508108637*v_POImv_c_i + 0.00874773135135797*v_POImv_c_r
        struct[0].g[83,0] = i_POIhv_c_i - 1.35166148479994e-18*v_GRID_a_i + 7.20886125226632e-19*v_GRID_a_r - 1.71210454741325e-17*v_GRID_b_i + 4.50553828266631e-19*v_GRID_b_r + 0.024174053182917*v_GRID_c_i - 0.040290088638195*v_GRID_c_r + 0.00153045607591062*v_POIhv_a_i - 0.012243648607285*v_POIhv_a_r + 0.00153045607591064*v_POIhv_b_i - 0.012243648607285*v_POIhv_b_r - 0.0272349653347383*v_POIhv_c_i + 0.0647773858527649*v_POIhv_c_r - 0.00874773135135797*v_POImv_a_i + 0.0699818508108637*v_POImv_a_r + 0.00874773135135797*v_POImv_c_i - 0.0699818508108637*v_POImv_c_r
        struct[0].g[84,0] = i_POImv_a_r + 0.0699818508108637*v_POIhv_a_i + 0.00874773135135797*v_POIhv_a_r - 0.0699818508108637*v_POIhv_c_i - 0.00874773135135797*v_POIhv_c_r - 33.4156859296188*v_POImv_a_i - 24.8222322123875*v_POImv_a_r + 9.4330989270973*v_POImv_b_i + 7.0643874892536*v_POImv_b_r + 9.4330989270973*v_POImv_c_i + 7.0643874892536*v_POImv_c_r + 24.3777365097524*v_TR_1_2_mv_a_i + 18.2833023823143*v_TR_1_2_mv_a_r - 6.96506757421497*v_TR_1_2_mv_b_i - 5.22380068066123*v_TR_1_2_mv_b_r - 6.96506757421497*v_TR_1_2_mv_c_i - 5.22380068066123*v_TR_1_2_mv_c_r + 8.63801621787545*v_TR_5_6_mv_a_i + 6.47851216340659*v_TR_5_6_mv_a_r - 2.4680046336787*v_TR_5_6_mv_b_i - 1.85100347525903*v_TR_5_6_mv_b_r - 2.4680046336787*v_TR_5_6_mv_c_i - 1.85100347525903*v_TR_5_6_mv_c_r
        struct[0].g[85,0] = i_POImv_a_i + 0.00874773135135797*v_POIhv_a_i - 0.0699818508108637*v_POIhv_a_r - 0.00874773135135797*v_POIhv_c_i + 0.0699818508108637*v_POIhv_c_r - 24.8222322123875*v_POImv_a_i + 33.4156859296188*v_POImv_a_r + 7.0643874892536*v_POImv_b_i - 9.4330989270973*v_POImv_b_r + 7.0643874892536*v_POImv_c_i - 9.4330989270973*v_POImv_c_r + 18.2833023823143*v_TR_1_2_mv_a_i - 24.3777365097524*v_TR_1_2_mv_a_r - 5.22380068066123*v_TR_1_2_mv_b_i + 6.96506757421497*v_TR_1_2_mv_b_r - 5.22380068066123*v_TR_1_2_mv_c_i + 6.96506757421497*v_TR_1_2_mv_c_r + 6.47851216340659*v_TR_5_6_mv_a_i - 8.63801621787545*v_TR_5_6_mv_a_r - 1.85100347525903*v_TR_5_6_mv_b_i + 2.4680046336787*v_TR_5_6_mv_b_r - 1.85100347525903*v_TR_5_6_mv_c_i + 2.4680046336787*v_TR_5_6_mv_c_r
        struct[0].g[86,0] = i_POImv_b_r - 0.0699818508108637*v_POIhv_a_i - 0.00874773135135797*v_POIhv_a_r + 0.0699818508108637*v_POIhv_b_i + 0.00874773135135797*v_POIhv_b_r + 9.4330989270973*v_POImv_a_i + 7.0643874892536*v_POImv_a_r - 33.4156859296188*v_POImv_b_i - 24.8222322123876*v_POImv_b_r + 9.4330989270973*v_POImv_c_i + 7.06438748925361*v_POImv_c_r - 6.96506757421497*v_TR_1_2_mv_a_i - 5.22380068066123*v_TR_1_2_mv_a_r + 24.3777365097524*v_TR_1_2_mv_b_i + 18.2833023823143*v_TR_1_2_mv_b_r - 6.96506757421497*v_TR_1_2_mv_c_i - 5.22380068066124*v_TR_1_2_mv_c_r - 2.4680046336787*v_TR_5_6_mv_a_i - 1.85100347525903*v_TR_5_6_mv_a_r + 8.63801621787545*v_TR_5_6_mv_b_i + 6.47851216340659*v_TR_5_6_mv_b_r - 2.4680046336787*v_TR_5_6_mv_c_i - 1.85100347525903*v_TR_5_6_mv_c_r
        struct[0].g[87,0] = i_POImv_b_i - 0.00874773135135797*v_POIhv_a_i + 0.0699818508108637*v_POIhv_a_r + 0.00874773135135797*v_POIhv_b_i - 0.0699818508108637*v_POIhv_b_r + 7.0643874892536*v_POImv_a_i - 9.4330989270973*v_POImv_a_r - 24.8222322123876*v_POImv_b_i + 33.4156859296188*v_POImv_b_r + 7.06438748925361*v_POImv_c_i - 9.4330989270973*v_POImv_c_r - 5.22380068066123*v_TR_1_2_mv_a_i + 6.96506757421497*v_TR_1_2_mv_a_r + 18.2833023823143*v_TR_1_2_mv_b_i - 24.3777365097524*v_TR_1_2_mv_b_r - 5.22380068066124*v_TR_1_2_mv_c_i + 6.96506757421497*v_TR_1_2_mv_c_r - 1.85100347525903*v_TR_5_6_mv_a_i + 2.4680046336787*v_TR_5_6_mv_a_r + 6.47851216340659*v_TR_5_6_mv_b_i - 8.63801621787545*v_TR_5_6_mv_b_r - 1.85100347525903*v_TR_5_6_mv_c_i + 2.4680046336787*v_TR_5_6_mv_c_r
        struct[0].g[88,0] = i_POImv_c_r - 0.0699818508108637*v_POIhv_b_i - 0.00874773135135797*v_POIhv_b_r + 0.0699818508108637*v_POIhv_c_i + 0.00874773135135797*v_POIhv_c_r + 9.4330989270973*v_POImv_a_i + 7.06438748925359*v_POImv_a_r + 9.4330989270973*v_POImv_b_i + 7.06438748925361*v_POImv_b_r - 33.4156859296188*v_POImv_c_i - 24.8222322123876*v_POImv_c_r - 6.96506757421497*v_TR_1_2_mv_a_i - 5.22380068066123*v_TR_1_2_mv_a_r - 6.96506757421497*v_TR_1_2_mv_b_i - 5.22380068066124*v_TR_1_2_mv_b_r + 24.3777365097524*v_TR_1_2_mv_c_i + 18.2833023823143*v_TR_1_2_mv_c_r - 2.4680046336787*v_TR_5_6_mv_a_i - 1.85100347525903*v_TR_5_6_mv_a_r - 2.4680046336787*v_TR_5_6_mv_b_i - 1.85100347525903*v_TR_5_6_mv_b_r + 8.63801621787545*v_TR_5_6_mv_c_i + 6.47851216340659*v_TR_5_6_mv_c_r
        struct[0].g[89,0] = i_POImv_c_i - 0.00874773135135797*v_POIhv_b_i + 0.0699818508108637*v_POIhv_b_r + 0.00874773135135797*v_POIhv_c_i - 0.0699818508108637*v_POIhv_c_r + 7.06438748925359*v_POImv_a_i - 9.4330989270973*v_POImv_a_r + 7.06438748925361*v_POImv_b_i - 9.4330989270973*v_POImv_b_r - 24.8222322123876*v_POImv_c_i + 33.4156859296188*v_POImv_c_r - 5.22380068066123*v_TR_1_2_mv_a_i + 6.96506757421497*v_TR_1_2_mv_a_r - 5.22380068066124*v_TR_1_2_mv_b_i + 6.96506757421497*v_TR_1_2_mv_b_r + 18.2833023823143*v_TR_1_2_mv_c_i - 24.3777365097524*v_TR_1_2_mv_c_r - 1.85100347525903*v_TR_5_6_mv_a_i + 2.4680046336787*v_TR_5_6_mv_a_r - 1.85100347525903*v_TR_5_6_mv_b_i + 2.4680046336787*v_TR_5_6_mv_b_r + 6.47851216340659*v_TR_5_6_mv_c_i - 8.63801621787545*v_TR_5_6_mv_c_r
        struct[0].g[90,0] = i_TR_1_2_mv_a_r + 24.3777365097524*v_POImv_a_i + 18.2833023823143*v_POImv_a_r - 6.96506757421497*v_POImv_b_i - 5.22380068066123*v_POImv_b_r - 6.96506757421497*v_POImv_c_i - 5.22380068066123*v_POImv_c_r + 2.3406091994174*v_TR_1_2_lv_a_i + 0.390101533236234*v_TR_1_2_lv_a_r - 2.3406091994174*v_TR_1_2_lv_b_i - 0.390101533236234*v_TR_1_2_lv_b_r - 52.7347843860809*v_TR_1_2_mv_a_i - 39.5195811550486*v_TR_1_2_mv_a_r + 15.0786865705954*v_TR_1_2_mv_b_i + 11.293239403373*v_TR_1_2_mv_b_r + 15.0786865705954*v_TR_1_2_mv_c_i + 11.293239403373*v_TR_1_2_mv_c_r + 28.3030263516338*v_TR_3_4_mv_a_i + 21.2272697637253*v_TR_3_4_mv_a_r - 8.08657895760964*v_TR_3_4_mv_b_i - 6.06493421820724*v_TR_3_4_mv_b_r - 8.08657895760964*v_TR_3_4_mv_c_i - 6.06493421820724*v_TR_3_4_mv_c_r
        struct[0].g[91,0] = i_TR_1_2_mv_a_i + 18.2833023823143*v_POImv_a_i - 24.3777365097524*v_POImv_a_r - 5.22380068066123*v_POImv_b_i + 6.96506757421497*v_POImv_b_r - 5.22380068066123*v_POImv_c_i + 6.96506757421497*v_POImv_c_r + 0.390101533236234*v_TR_1_2_lv_a_i - 2.3406091994174*v_TR_1_2_lv_a_r - 0.390101533236234*v_TR_1_2_lv_b_i + 2.3406091994174*v_TR_1_2_lv_b_r - 39.5195811550486*v_TR_1_2_mv_a_i + 52.7347843860809*v_TR_1_2_mv_a_r + 11.293239403373*v_TR_1_2_mv_b_i - 15.0786865705954*v_TR_1_2_mv_b_r + 11.293239403373*v_TR_1_2_mv_c_i - 15.0786865705954*v_TR_1_2_mv_c_r + 21.2272697637253*v_TR_3_4_mv_a_i - 28.3030263516338*v_TR_3_4_mv_a_r - 6.06493421820724*v_TR_3_4_mv_b_i + 8.08657895760964*v_TR_3_4_mv_b_r - 6.06493421820724*v_TR_3_4_mv_c_i + 8.08657895760964*v_TR_3_4_mv_c_r
        struct[0].g[92,0] = i_TR_1_2_mv_b_r - 6.96506757421497*v_POImv_a_i - 5.22380068066123*v_POImv_a_r + 24.3777365097524*v_POImv_b_i + 18.2833023823143*v_POImv_b_r - 6.96506757421497*v_POImv_c_i - 5.22380068066124*v_POImv_c_r + 2.3406091994174*v_TR_1_2_lv_b_i + 0.390101533236234*v_TR_1_2_lv_b_r - 2.3406091994174*v_TR_1_2_lv_c_i - 0.390101533236234*v_TR_1_2_lv_c_r + 15.0786865705954*v_TR_1_2_mv_a_i + 11.293239403373*v_TR_1_2_mv_a_r - 52.7347843860809*v_TR_1_2_mv_b_i - 39.5195811550487*v_TR_1_2_mv_b_r + 15.0786865705954*v_TR_1_2_mv_c_i + 11.293239403373*v_TR_1_2_mv_c_r - 8.08657895760964*v_TR_3_4_mv_a_i - 6.06493421820724*v_TR_3_4_mv_a_r + 28.3030263516338*v_TR_3_4_mv_b_i + 21.2272697637253*v_TR_3_4_mv_b_r - 8.08657895760965*v_TR_3_4_mv_c_i - 6.06493421820725*v_TR_3_4_mv_c_r
        struct[0].g[93,0] = i_TR_1_2_mv_b_i - 5.22380068066123*v_POImv_a_i + 6.96506757421497*v_POImv_a_r + 18.2833023823143*v_POImv_b_i - 24.3777365097524*v_POImv_b_r - 5.22380068066124*v_POImv_c_i + 6.96506757421497*v_POImv_c_r + 0.390101533236234*v_TR_1_2_lv_b_i - 2.3406091994174*v_TR_1_2_lv_b_r - 0.390101533236234*v_TR_1_2_lv_c_i + 2.3406091994174*v_TR_1_2_lv_c_r + 11.293239403373*v_TR_1_2_mv_a_i - 15.0786865705954*v_TR_1_2_mv_a_r - 39.5195811550487*v_TR_1_2_mv_b_i + 52.7347843860809*v_TR_1_2_mv_b_r + 11.293239403373*v_TR_1_2_mv_c_i - 15.0786865705954*v_TR_1_2_mv_c_r - 6.06493421820724*v_TR_3_4_mv_a_i + 8.08657895760964*v_TR_3_4_mv_a_r + 21.2272697637253*v_TR_3_4_mv_b_i - 28.3030263516338*v_TR_3_4_mv_b_r - 6.06493421820725*v_TR_3_4_mv_c_i + 8.08657895760965*v_TR_3_4_mv_c_r
        struct[0].g[94,0] = i_TR_1_2_mv_c_r - 6.96506757421497*v_POImv_a_i - 5.22380068066123*v_POImv_a_r - 6.96506757421497*v_POImv_b_i - 5.22380068066124*v_POImv_b_r + 24.3777365097524*v_POImv_c_i + 18.2833023823143*v_POImv_c_r - 2.3406091994174*v_TR_1_2_lv_a_i - 0.390101533236234*v_TR_1_2_lv_a_r + 2.3406091994174*v_TR_1_2_lv_c_i + 0.390101533236234*v_TR_1_2_lv_c_r + 15.0786865705954*v_TR_1_2_mv_a_i + 11.293239403373*v_TR_1_2_mv_a_r + 15.0786865705954*v_TR_1_2_mv_b_i + 11.293239403373*v_TR_1_2_mv_b_r - 52.7347843860809*v_TR_1_2_mv_c_i - 39.5195811550487*v_TR_1_2_mv_c_r - 8.08657895760965*v_TR_3_4_mv_a_i - 6.06493421820724*v_TR_3_4_mv_a_r - 8.08657895760964*v_TR_3_4_mv_b_i - 6.06493421820725*v_TR_3_4_mv_b_r + 28.3030263516338*v_TR_3_4_mv_c_i + 21.2272697637253*v_TR_3_4_mv_c_r
        struct[0].g[95,0] = i_TR_1_2_mv_c_i - 5.22380068066123*v_POImv_a_i + 6.96506757421497*v_POImv_a_r - 5.22380068066124*v_POImv_b_i + 6.96506757421497*v_POImv_b_r + 18.2833023823143*v_POImv_c_i - 24.3777365097524*v_POImv_c_r - 0.390101533236234*v_TR_1_2_lv_a_i + 2.3406091994174*v_TR_1_2_lv_a_r + 0.390101533236234*v_TR_1_2_lv_c_i - 2.3406091994174*v_TR_1_2_lv_c_r + 11.293239403373*v_TR_1_2_mv_a_i - 15.0786865705954*v_TR_1_2_mv_a_r + 11.293239403373*v_TR_1_2_mv_b_i - 15.0786865705954*v_TR_1_2_mv_b_r - 39.5195811550487*v_TR_1_2_mv_c_i + 52.7347843860809*v_TR_1_2_mv_c_r - 6.06493421820724*v_TR_3_4_mv_a_i + 8.08657895760965*v_TR_3_4_mv_a_r - 6.06493421820725*v_TR_3_4_mv_b_i + 8.08657895760964*v_TR_3_4_mv_b_r + 21.2272697637253*v_TR_3_4_mv_c_i - 28.3030263516338*v_TR_3_4_mv_c_r
        struct[0].g[96,0] = i_TR_1_2_lv_a_r + 89.5460683028705*v_INV_1_a_i + 172.82391182454*v_INV_1_a_r - 25.5845909436773*v_INV_1_b_i - 49.3782605212972*v_INV_1_b_r - 25.5845909436773*v_INV_1_c_i - 49.3782605212972*v_INV_1_c_r + 97.8438762251349*v_INV_2_a_i + 188.83868111451*v_INV_2_a_r - 27.9553932071814*v_INV_2_b_i - 53.9539088898601*v_INV_2_b_r - 27.9553932071814*v_INV_2_c_i - 53.9539088898601*v_INV_2_c_r - 390.092416801432*v_TR_1_2_lv_a_i - 395.446376722834*v_TR_1_2_lv_a_r + 53.5400763225691*v_TR_1_2_lv_b_i + 103.332169411157*v_TR_1_2_lv_b_r + 53.5400763225691*v_TR_1_2_lv_c_i + 103.332169411157*v_TR_1_2_lv_c_r + 2.3406091994174*v_TR_1_2_mv_a_i + 0.390101533236234*v_TR_1_2_mv_a_r - 2.3406091994174*v_TR_1_2_mv_c_i - 0.390101533236234*v_TR_1_2_mv_c_r
        struct[0].g[97,0] = i_TR_1_2_lv_a_i + 172.82391182454*v_INV_1_a_i - 89.5460683028705*v_INV_1_a_r - 49.3782605212972*v_INV_1_b_i + 25.5845909436773*v_INV_1_b_r - 49.3782605212972*v_INV_1_c_i + 25.5845909436773*v_INV_1_c_r + 188.83868111451*v_INV_2_a_i - 97.8438762251349*v_INV_2_a_r - 53.9539088898601*v_INV_2_b_i + 27.9553932071814*v_INV_2_b_r - 53.9539088898601*v_INV_2_c_i + 27.9553932071814*v_INV_2_c_r - 395.446376722834*v_TR_1_2_lv_a_i + 390.092416801432*v_TR_1_2_lv_a_r + 103.332169411157*v_TR_1_2_lv_b_i - 53.5400763225691*v_TR_1_2_lv_b_r + 103.332169411157*v_TR_1_2_lv_c_i - 53.5400763225691*v_TR_1_2_lv_c_r + 0.390101533236234*v_TR_1_2_mv_a_i - 2.3406091994174*v_TR_1_2_mv_a_r - 0.390101533236234*v_TR_1_2_mv_c_i + 2.3406091994174*v_TR_1_2_mv_c_r
        struct[0].g[98,0] = i_TR_1_2_lv_b_r - 25.5845909436773*v_INV_1_a_i - 49.3782605212972*v_INV_1_a_r + 89.5460683028705*v_INV_1_b_i + 172.82391182454*v_INV_1_b_r - 25.5845909436773*v_INV_1_c_i - 49.3782605212973*v_INV_1_c_r - 27.9553932071814*v_INV_2_a_i - 53.9539088898601*v_INV_2_a_r + 97.8438762251349*v_INV_2_b_i + 188.83868111451*v_INV_2_b_r - 27.9553932071814*v_INV_2_c_i - 53.9539088898602*v_INV_2_c_r + 53.5400763225691*v_TR_1_2_lv_a_i + 103.332169411157*v_TR_1_2_lv_a_r - 390.092416801432*v_TR_1_2_lv_b_i - 395.446376722835*v_TR_1_2_lv_b_r + 53.5400763225691*v_TR_1_2_lv_c_i + 103.332169411157*v_TR_1_2_lv_c_r - 2.3406091994174*v_TR_1_2_mv_a_i - 0.390101533236234*v_TR_1_2_mv_a_r + 2.3406091994174*v_TR_1_2_mv_b_i + 0.390101533236234*v_TR_1_2_mv_b_r
        struct[0].g[99,0] = i_TR_1_2_lv_b_i - 49.3782605212972*v_INV_1_a_i + 25.5845909436773*v_INV_1_a_r + 172.82391182454*v_INV_1_b_i - 89.5460683028705*v_INV_1_b_r - 49.3782605212973*v_INV_1_c_i + 25.5845909436773*v_INV_1_c_r - 53.9539088898601*v_INV_2_a_i + 27.9553932071814*v_INV_2_a_r + 188.83868111451*v_INV_2_b_i - 97.8438762251349*v_INV_2_b_r - 53.9539088898602*v_INV_2_c_i + 27.9553932071814*v_INV_2_c_r + 103.332169411157*v_TR_1_2_lv_a_i - 53.5400763225691*v_TR_1_2_lv_a_r - 395.446376722835*v_TR_1_2_lv_b_i + 390.092416801432*v_TR_1_2_lv_b_r + 103.332169411157*v_TR_1_2_lv_c_i - 53.5400763225691*v_TR_1_2_lv_c_r - 0.390101533236234*v_TR_1_2_mv_a_i + 2.3406091994174*v_TR_1_2_mv_a_r + 0.390101533236234*v_TR_1_2_mv_b_i - 2.3406091994174*v_TR_1_2_mv_b_r
        struct[0].g[100,0] = i_TR_1_2_lv_c_r - 25.5845909436773*v_INV_1_a_i - 49.3782605212972*v_INV_1_a_r - 25.5845909436772*v_INV_1_b_i - 49.3782605212973*v_INV_1_b_r + 89.5460683028705*v_INV_1_c_i + 172.82391182454*v_INV_1_c_r - 27.9553932071814*v_INV_2_a_i - 53.9539088898601*v_INV_2_a_r - 27.9553932071813*v_INV_2_b_i - 53.9539088898602*v_INV_2_b_r + 97.8438762251349*v_INV_2_c_i + 188.83868111451*v_INV_2_c_r + 53.5400763225692*v_TR_1_2_lv_a_i + 103.332169411157*v_TR_1_2_lv_a_r + 53.5400763225691*v_TR_1_2_lv_b_i + 103.332169411157*v_TR_1_2_lv_b_r - 390.092416801432*v_TR_1_2_lv_c_i - 395.446376722835*v_TR_1_2_lv_c_r - 2.3406091994174*v_TR_1_2_mv_b_i - 0.390101533236234*v_TR_1_2_mv_b_r + 2.3406091994174*v_TR_1_2_mv_c_i + 0.390101533236234*v_TR_1_2_mv_c_r
        struct[0].g[101,0] = i_TR_1_2_lv_c_i - 49.3782605212972*v_INV_1_a_i + 25.5845909436773*v_INV_1_a_r - 49.3782605212973*v_INV_1_b_i + 25.5845909436772*v_INV_1_b_r + 172.82391182454*v_INV_1_c_i - 89.5460683028705*v_INV_1_c_r - 53.9539088898601*v_INV_2_a_i + 27.9553932071814*v_INV_2_a_r - 53.9539088898602*v_INV_2_b_i + 27.9553932071813*v_INV_2_b_r + 188.83868111451*v_INV_2_c_i - 97.8438762251349*v_INV_2_c_r + 103.332169411157*v_TR_1_2_lv_a_i - 53.5400763225692*v_TR_1_2_lv_a_r + 103.332169411157*v_TR_1_2_lv_b_i - 53.5400763225691*v_TR_1_2_lv_b_r - 395.446376722835*v_TR_1_2_lv_c_i + 390.092416801432*v_TR_1_2_lv_c_r - 0.390101533236234*v_TR_1_2_mv_b_i + 2.3406091994174*v_TR_1_2_mv_b_r + 0.390101533236234*v_TR_1_2_mv_c_i - 2.3406091994174*v_TR_1_2_mv_c_r
        struct[0].g[102,0] = i_TR_3_4_mv_a_r + 28.3030263516338*v_TR_1_2_mv_a_i + 21.2272697637253*v_TR_1_2_mv_a_r - 8.08657895760964*v_TR_1_2_mv_b_i - 6.06493421820724*v_TR_1_2_mv_b_r - 8.08657895760964*v_TR_1_2_mv_c_i - 6.06493421820724*v_TR_1_2_mv_c_r + 2.3406091994174*v_TR_3_4_lv_a_i + 0.390101533236234*v_TR_3_4_lv_a_r - 2.3406091994174*v_TR_3_4_lv_b_i - 0.390101533236234*v_TR_3_4_lv_b_r - 43.3991164322381*v_TR_3_4_mv_a_i - 41.678054303702*v_TR_3_4_mv_a_r + 12.4113478527151*v_TR_3_4_mv_b_i + 11.9099460172739*v_TR_3_4_mv_b_r + 12.4113478527151*v_TR_3_4_mv_c_i + 11.9099460172739*v_TR_3_4_mv_c_r + 15.0420612397687*v_TR_7_8_mv_a_i + 20.4417755309677*v_TR_7_8_mv_a_r - 4.29773178279105*v_TR_7_8_mv_b_i - 5.8405072945622*v_TR_7_8_mv_b_r - 4.29773178279104*v_TR_7_8_mv_c_i - 5.84050729456219*v_TR_7_8_mv_c_r
        struct[0].g[103,0] = i_TR_3_4_mv_a_i + 21.2272697637253*v_TR_1_2_mv_a_i - 28.3030263516338*v_TR_1_2_mv_a_r - 6.06493421820724*v_TR_1_2_mv_b_i + 8.08657895760964*v_TR_1_2_mv_b_r - 6.06493421820724*v_TR_1_2_mv_c_i + 8.08657895760964*v_TR_1_2_mv_c_r + 0.390101533236234*v_TR_3_4_lv_a_i - 2.3406091994174*v_TR_3_4_lv_a_r - 0.390101533236234*v_TR_3_4_lv_b_i + 2.3406091994174*v_TR_3_4_lv_b_r - 41.678054303702*v_TR_3_4_mv_a_i + 43.3991164322381*v_TR_3_4_mv_a_r + 11.9099460172739*v_TR_3_4_mv_b_i - 12.4113478527151*v_TR_3_4_mv_b_r + 11.9099460172739*v_TR_3_4_mv_c_i - 12.4113478527151*v_TR_3_4_mv_c_r + 20.4417755309677*v_TR_7_8_mv_a_i - 15.0420612397687*v_TR_7_8_mv_a_r - 5.8405072945622*v_TR_7_8_mv_b_i + 4.29773178279105*v_TR_7_8_mv_b_r - 5.84050729456219*v_TR_7_8_mv_c_i + 4.29773178279104*v_TR_7_8_mv_c_r
        struct[0].g[104,0] = i_TR_3_4_mv_b_r - 8.08657895760964*v_TR_1_2_mv_a_i - 6.06493421820724*v_TR_1_2_mv_a_r + 28.3030263516338*v_TR_1_2_mv_b_i + 21.2272697637253*v_TR_1_2_mv_b_r - 8.08657895760965*v_TR_1_2_mv_c_i - 6.06493421820725*v_TR_1_2_mv_c_r + 2.3406091994174*v_TR_3_4_lv_b_i + 0.390101533236234*v_TR_3_4_lv_b_r - 2.3406091994174*v_TR_3_4_lv_c_i - 0.390101533236234*v_TR_3_4_lv_c_r + 12.4113478527151*v_TR_3_4_mv_a_i + 11.9099460172739*v_TR_3_4_mv_a_r - 43.3991164322381*v_TR_3_4_mv_b_i - 41.678054303702*v_TR_3_4_mv_b_r + 12.4113478527151*v_TR_3_4_mv_c_i + 11.909946017274*v_TR_3_4_mv_c_r - 4.29773178279105*v_TR_7_8_mv_a_i - 5.8405072945622*v_TR_7_8_mv_a_r + 15.0420612397687*v_TR_7_8_mv_b_i + 20.4417755309677*v_TR_7_8_mv_b_r - 4.29773178279105*v_TR_7_8_mv_c_i - 5.8405072945622*v_TR_7_8_mv_c_r
        struct[0].g[105,0] = i_TR_3_4_mv_b_i - 6.06493421820724*v_TR_1_2_mv_a_i + 8.08657895760964*v_TR_1_2_mv_a_r + 21.2272697637253*v_TR_1_2_mv_b_i - 28.3030263516338*v_TR_1_2_mv_b_r - 6.06493421820725*v_TR_1_2_mv_c_i + 8.08657895760965*v_TR_1_2_mv_c_r + 0.390101533236234*v_TR_3_4_lv_b_i - 2.3406091994174*v_TR_3_4_lv_b_r - 0.390101533236234*v_TR_3_4_lv_c_i + 2.3406091994174*v_TR_3_4_lv_c_r + 11.9099460172739*v_TR_3_4_mv_a_i - 12.4113478527151*v_TR_3_4_mv_a_r - 41.678054303702*v_TR_3_4_mv_b_i + 43.3991164322381*v_TR_3_4_mv_b_r + 11.909946017274*v_TR_3_4_mv_c_i - 12.4113478527151*v_TR_3_4_mv_c_r - 5.8405072945622*v_TR_7_8_mv_a_i + 4.29773178279105*v_TR_7_8_mv_a_r + 20.4417755309677*v_TR_7_8_mv_b_i - 15.0420612397687*v_TR_7_8_mv_b_r - 5.8405072945622*v_TR_7_8_mv_c_i + 4.29773178279105*v_TR_7_8_mv_c_r
        struct[0].g[106,0] = i_TR_3_4_mv_c_r - 8.08657895760965*v_TR_1_2_mv_a_i - 6.06493421820724*v_TR_1_2_mv_a_r - 8.08657895760964*v_TR_1_2_mv_b_i - 6.06493421820725*v_TR_1_2_mv_b_r + 28.3030263516338*v_TR_1_2_mv_c_i + 21.2272697637253*v_TR_1_2_mv_c_r - 2.3406091994174*v_TR_3_4_lv_a_i - 0.390101533236234*v_TR_3_4_lv_a_r + 2.3406091994174*v_TR_3_4_lv_c_i + 0.390101533236234*v_TR_3_4_lv_c_r + 12.4113478527151*v_TR_3_4_mv_a_i + 11.9099460172739*v_TR_3_4_mv_a_r + 12.4113478527151*v_TR_3_4_mv_b_i + 11.909946017274*v_TR_3_4_mv_b_r - 43.3991164322381*v_TR_3_4_mv_c_i - 41.678054303702*v_TR_3_4_mv_c_r - 4.29773178279105*v_TR_7_8_mv_a_i - 5.84050729456219*v_TR_7_8_mv_a_r - 4.29773178279104*v_TR_7_8_mv_b_i - 5.84050729456221*v_TR_7_8_mv_b_r + 15.0420612397687*v_TR_7_8_mv_c_i + 20.4417755309677*v_TR_7_8_mv_c_r
        struct[0].g[107,0] = i_TR_3_4_mv_c_i - 6.06493421820724*v_TR_1_2_mv_a_i + 8.08657895760965*v_TR_1_2_mv_a_r - 6.06493421820725*v_TR_1_2_mv_b_i + 8.08657895760964*v_TR_1_2_mv_b_r + 21.2272697637253*v_TR_1_2_mv_c_i - 28.3030263516338*v_TR_1_2_mv_c_r - 0.390101533236234*v_TR_3_4_lv_a_i + 2.3406091994174*v_TR_3_4_lv_a_r + 0.390101533236234*v_TR_3_4_lv_c_i - 2.3406091994174*v_TR_3_4_lv_c_r + 11.9099460172739*v_TR_3_4_mv_a_i - 12.4113478527151*v_TR_3_4_mv_a_r + 11.909946017274*v_TR_3_4_mv_b_i - 12.4113478527151*v_TR_3_4_mv_b_r - 41.678054303702*v_TR_3_4_mv_c_i + 43.3991164322381*v_TR_3_4_mv_c_r - 5.84050729456219*v_TR_7_8_mv_a_i + 4.29773178279105*v_TR_7_8_mv_a_r - 5.84050729456221*v_TR_7_8_mv_b_i + 4.29773178279104*v_TR_7_8_mv_b_r + 20.4417755309677*v_TR_7_8_mv_c_i - 15.0420612397687*v_TR_7_8_mv_c_r
        struct[0].g[108,0] = i_TR_3_4_lv_a_r + 107.758927311578*v_INV_3_a_i + 207.974729711346*v_INV_3_a_r - 30.7882649461652*v_INV_3_b_i - 59.4213513460989*v_INV_3_b_r - 30.7882649461652*v_INV_3_c_i - 59.4213513460989*v_INV_3_c_r + 58.4540809492443*v_INV_4_a_i + 112.816376232042*v_INV_4_a_r - 16.7011659854984*v_INV_4_b_i - 32.2332503520119*v_INV_4_b_r - 16.7011659854984*v_INV_4_c_i - 32.2332503520119*v_INV_4_c_r - 368.915426669025*v_TR_3_4_lv_a_i - 354.574889727171*v_TR_3_4_lv_a_r + 47.4895446494637*v_TR_3_4_lv_b_i + 91.6546016981108*v_TR_3_4_lv_b_r + 47.4895446494637*v_TR_3_4_lv_c_i + 91.6546016981108*v_TR_3_4_lv_c_r + 2.3406091994174*v_TR_3_4_mv_a_i + 0.390101533236234*v_TR_3_4_mv_a_r - 2.3406091994174*v_TR_3_4_mv_c_i - 0.390101533236234*v_TR_3_4_mv_c_r
        struct[0].g[109,0] = i_TR_3_4_lv_a_i + 207.974729711346*v_INV_3_a_i - 107.758927311578*v_INV_3_a_r - 59.4213513460989*v_INV_3_b_i + 30.7882649461652*v_INV_3_b_r - 59.4213513460989*v_INV_3_c_i + 30.7882649461652*v_INV_3_c_r + 112.816376232042*v_INV_4_a_i - 58.4540809492443*v_INV_4_a_r - 32.2332503520119*v_INV_4_b_i + 16.7011659854984*v_INV_4_b_r - 32.2332503520119*v_INV_4_c_i + 16.7011659854984*v_INV_4_c_r - 354.574889727171*v_TR_3_4_lv_a_i + 368.915426669025*v_TR_3_4_lv_a_r + 91.6546016981108*v_TR_3_4_lv_b_i - 47.4895446494637*v_TR_3_4_lv_b_r + 91.6546016981108*v_TR_3_4_lv_c_i - 47.4895446494637*v_TR_3_4_lv_c_r + 0.390101533236234*v_TR_3_4_mv_a_i - 2.3406091994174*v_TR_3_4_mv_a_r - 0.390101533236234*v_TR_3_4_mv_c_i + 2.3406091994174*v_TR_3_4_mv_c_r
        struct[0].g[110,0] = i_TR_3_4_lv_b_r - 30.7882649461652*v_INV_3_a_i - 59.4213513460989*v_INV_3_a_r + 107.758927311578*v_INV_3_b_i + 207.974729711346*v_INV_3_b_r - 30.7882649461651*v_INV_3_c_i - 59.421351346099*v_INV_3_c_r - 16.7011659854984*v_INV_4_a_i - 32.2332503520119*v_INV_4_a_r + 58.4540809492443*v_INV_4_b_i + 112.816376232042*v_INV_4_b_r - 16.7011659854984*v_INV_4_c_i - 32.2332503520119*v_INV_4_c_r + 47.4895446494636*v_TR_3_4_lv_a_i + 91.6546016981107*v_TR_3_4_lv_a_r - 368.915426669025*v_TR_3_4_lv_b_i - 354.574889727172*v_TR_3_4_lv_b_r + 47.4895446494636*v_TR_3_4_lv_c_i + 91.6546016981109*v_TR_3_4_lv_c_r - 2.3406091994174*v_TR_3_4_mv_a_i - 0.390101533236234*v_TR_3_4_mv_a_r + 2.3406091994174*v_TR_3_4_mv_b_i + 0.390101533236234*v_TR_3_4_mv_b_r
        struct[0].g[111,0] = i_TR_3_4_lv_b_i - 59.4213513460989*v_INV_3_a_i + 30.7882649461652*v_INV_3_a_r + 207.974729711346*v_INV_3_b_i - 107.758927311578*v_INV_3_b_r - 59.421351346099*v_INV_3_c_i + 30.7882649461651*v_INV_3_c_r - 32.2332503520119*v_INV_4_a_i + 16.7011659854984*v_INV_4_a_r + 112.816376232042*v_INV_4_b_i - 58.4540809492443*v_INV_4_b_r - 32.2332503520119*v_INV_4_c_i + 16.7011659854984*v_INV_4_c_r + 91.6546016981107*v_TR_3_4_lv_a_i - 47.4895446494636*v_TR_3_4_lv_a_r - 354.574889727172*v_TR_3_4_lv_b_i + 368.915426669025*v_TR_3_4_lv_b_r + 91.6546016981109*v_TR_3_4_lv_c_i - 47.4895446494636*v_TR_3_4_lv_c_r - 0.390101533236234*v_TR_3_4_mv_a_i + 2.3406091994174*v_TR_3_4_mv_a_r + 0.390101533236234*v_TR_3_4_mv_b_i - 2.3406091994174*v_TR_3_4_mv_b_r
        struct[0].g[112,0] = i_TR_3_4_lv_c_r - 30.7882649461652*v_INV_3_a_i - 59.4213513460989*v_INV_3_a_r - 30.7882649461651*v_INV_3_b_i - 59.421351346099*v_INV_3_b_r + 107.758927311578*v_INV_3_c_i + 207.974729711346*v_INV_3_c_r - 16.7011659854984*v_INV_4_a_i - 32.2332503520119*v_INV_4_a_r - 16.7011659854983*v_INV_4_b_i - 32.2332503520119*v_INV_4_b_r + 58.4540809492443*v_INV_4_c_i + 112.816376232042*v_INV_4_c_r + 47.4895446494637*v_TR_3_4_lv_a_i + 91.6546016981108*v_TR_3_4_lv_a_r + 47.4895446494636*v_TR_3_4_lv_b_i + 91.6546016981109*v_TR_3_4_lv_b_r - 368.915426669025*v_TR_3_4_lv_c_i - 354.574889727171*v_TR_3_4_lv_c_r - 2.3406091994174*v_TR_3_4_mv_b_i - 0.390101533236234*v_TR_3_4_mv_b_r + 2.3406091994174*v_TR_3_4_mv_c_i + 0.390101533236234*v_TR_3_4_mv_c_r
        struct[0].g[113,0] = i_TR_3_4_lv_c_i - 59.4213513460989*v_INV_3_a_i + 30.7882649461652*v_INV_3_a_r - 59.421351346099*v_INV_3_b_i + 30.7882649461651*v_INV_3_b_r + 207.974729711346*v_INV_3_c_i - 107.758927311578*v_INV_3_c_r - 32.2332503520119*v_INV_4_a_i + 16.7011659854984*v_INV_4_a_r - 32.2332503520119*v_INV_4_b_i + 16.7011659854983*v_INV_4_b_r + 112.816376232042*v_INV_4_c_i - 58.4540809492443*v_INV_4_c_r + 91.6546016981108*v_TR_3_4_lv_a_i - 47.4895446494637*v_TR_3_4_lv_a_r + 91.6546016981109*v_TR_3_4_lv_b_i - 47.4895446494636*v_TR_3_4_lv_b_r - 354.574889727171*v_TR_3_4_lv_c_i + 368.915426669025*v_TR_3_4_lv_c_r - 0.390101533236234*v_TR_3_4_mv_b_i + 2.3406091994174*v_TR_3_4_mv_b_r + 0.390101533236234*v_TR_3_4_mv_c_i - 2.3406091994174*v_TR_3_4_mv_c_r
        struct[0].g[114,0] = i_TR_5_6_mv_a_r + 8.63801621787545*v_POImv_a_i + 6.47851216340659*v_POImv_a_r - 2.4680046336787*v_POImv_b_i - 1.85100347525903*v_POImv_b_r - 2.4680046336787*v_POImv_c_i - 1.85100347525903*v_POImv_c_r + 2.3406091994174*v_TR_5_6_lv_a_i + 0.390101533236234*v_TR_5_6_lv_a_r - 2.3406091994174*v_TR_5_6_lv_b_i - 0.390101533236234*v_TR_5_6_lv_b_r - 53.186989402129*v_TR_5_6_mv_a_i - 39.8587546923895*v_TR_5_6_mv_a_r + 15.2079060840306*v_TR_5_6_mv_b_i + 11.3901461283275*v_TR_5_6_mv_b_r + 15.2079060840306*v_TR_5_6_mv_c_i + 11.3901461283275*v_TR_5_6_mv_c_r + 44.4949780266318*v_TR_9_10_mv_a_i + 33.3712335199739*v_TR_9_10_mv_a_r - 12.7128508647519*v_TR_9_10_mv_b_i - 9.53463814856397*v_TR_9_10_mv_b_r - 12.7128508647519*v_TR_9_10_mv_c_i - 9.53463814856397*v_TR_9_10_mv_c_r
        struct[0].g[115,0] = i_TR_5_6_mv_a_i + 6.47851216340659*v_POImv_a_i - 8.63801621787545*v_POImv_a_r - 1.85100347525903*v_POImv_b_i + 2.4680046336787*v_POImv_b_r - 1.85100347525903*v_POImv_c_i + 2.4680046336787*v_POImv_c_r + 0.390101533236234*v_TR_5_6_lv_a_i - 2.3406091994174*v_TR_5_6_lv_a_r - 0.390101533236234*v_TR_5_6_lv_b_i + 2.3406091994174*v_TR_5_6_lv_b_r - 39.8587546923895*v_TR_5_6_mv_a_i + 53.186989402129*v_TR_5_6_mv_a_r + 11.3901461283275*v_TR_5_6_mv_b_i - 15.2079060840306*v_TR_5_6_mv_b_r + 11.3901461283275*v_TR_5_6_mv_c_i - 15.2079060840306*v_TR_5_6_mv_c_r + 33.3712335199739*v_TR_9_10_mv_a_i - 44.4949780266318*v_TR_9_10_mv_a_r - 9.53463814856397*v_TR_9_10_mv_b_i + 12.7128508647519*v_TR_9_10_mv_b_r - 9.53463814856397*v_TR_9_10_mv_c_i + 12.7128508647519*v_TR_9_10_mv_c_r
        struct[0].g[116,0] = i_TR_5_6_mv_b_r - 2.4680046336787*v_POImv_a_i - 1.85100347525903*v_POImv_a_r + 8.63801621787545*v_POImv_b_i + 6.47851216340659*v_POImv_b_r - 2.4680046336787*v_POImv_c_i - 1.85100347525903*v_POImv_c_r + 2.3406091994174*v_TR_5_6_lv_b_i + 0.390101533236234*v_TR_5_6_lv_b_r - 2.3406091994174*v_TR_5_6_lv_c_i - 0.390101533236234*v_TR_5_6_lv_c_r + 15.2079060840306*v_TR_5_6_mv_a_i + 11.3901461283275*v_TR_5_6_mv_a_r - 53.186989402129*v_TR_5_6_mv_b_i - 39.8587546923895*v_TR_5_6_mv_b_r + 15.2079060840306*v_TR_5_6_mv_c_i + 11.3901461283275*v_TR_5_6_mv_c_r - 12.7128508647519*v_TR_9_10_mv_a_i - 9.53463814856397*v_TR_9_10_mv_a_r + 44.4949780266318*v_TR_9_10_mv_b_i + 33.3712335199739*v_TR_9_10_mv_b_r - 12.712850864752*v_TR_9_10_mv_c_i - 9.53463814856399*v_TR_9_10_mv_c_r
        struct[0].g[117,0] = i_TR_5_6_mv_b_i - 1.85100347525903*v_POImv_a_i + 2.4680046336787*v_POImv_a_r + 6.47851216340659*v_POImv_b_i - 8.63801621787545*v_POImv_b_r - 1.85100347525903*v_POImv_c_i + 2.4680046336787*v_POImv_c_r + 0.390101533236234*v_TR_5_6_lv_b_i - 2.3406091994174*v_TR_5_6_lv_b_r - 0.390101533236234*v_TR_5_6_lv_c_i + 2.3406091994174*v_TR_5_6_lv_c_r + 11.3901461283275*v_TR_5_6_mv_a_i - 15.2079060840306*v_TR_5_6_mv_a_r - 39.8587546923895*v_TR_5_6_mv_b_i + 53.186989402129*v_TR_5_6_mv_b_r + 11.3901461283275*v_TR_5_6_mv_c_i - 15.2079060840306*v_TR_5_6_mv_c_r - 9.53463814856397*v_TR_9_10_mv_a_i + 12.7128508647519*v_TR_9_10_mv_a_r + 33.3712335199739*v_TR_9_10_mv_b_i - 44.4949780266318*v_TR_9_10_mv_b_r - 9.53463814856399*v_TR_9_10_mv_c_i + 12.712850864752*v_TR_9_10_mv_c_r
        struct[0].g[118,0] = i_TR_5_6_mv_c_r - 2.4680046336787*v_POImv_a_i - 1.85100347525903*v_POImv_a_r - 2.4680046336787*v_POImv_b_i - 1.85100347525903*v_POImv_b_r + 8.63801621787545*v_POImv_c_i + 6.47851216340659*v_POImv_c_r - 2.3406091994174*v_TR_5_6_lv_a_i - 0.390101533236234*v_TR_5_6_lv_a_r + 2.3406091994174*v_TR_5_6_lv_c_i + 0.390101533236234*v_TR_5_6_lv_c_r + 15.2079060840306*v_TR_5_6_mv_a_i + 11.3901461283275*v_TR_5_6_mv_a_r + 15.2079060840306*v_TR_5_6_mv_b_i + 11.3901461283275*v_TR_5_6_mv_b_r - 53.186989402129*v_TR_5_6_mv_c_i - 39.8587546923895*v_TR_5_6_mv_c_r - 12.7128508647519*v_TR_9_10_mv_a_i - 9.53463814856397*v_TR_9_10_mv_a_r - 12.712850864752*v_TR_9_10_mv_b_i - 9.53463814856399*v_TR_9_10_mv_b_r + 44.4949780266318*v_TR_9_10_mv_c_i + 33.3712335199739*v_TR_9_10_mv_c_r
        struct[0].g[119,0] = i_TR_5_6_mv_c_i - 1.85100347525903*v_POImv_a_i + 2.4680046336787*v_POImv_a_r - 1.85100347525903*v_POImv_b_i + 2.4680046336787*v_POImv_b_r + 6.47851216340659*v_POImv_c_i - 8.63801621787545*v_POImv_c_r - 0.390101533236234*v_TR_5_6_lv_a_i + 2.3406091994174*v_TR_5_6_lv_a_r + 0.390101533236234*v_TR_5_6_lv_c_i - 2.3406091994174*v_TR_5_6_lv_c_r + 11.3901461283275*v_TR_5_6_mv_a_i - 15.2079060840306*v_TR_5_6_mv_a_r + 11.3901461283275*v_TR_5_6_mv_b_i - 15.2079060840306*v_TR_5_6_mv_b_r - 39.8587546923895*v_TR_5_6_mv_c_i + 53.186989402129*v_TR_5_6_mv_c_r - 9.53463814856397*v_TR_9_10_mv_a_i + 12.7128508647519*v_TR_9_10_mv_a_r - 9.53463814856399*v_TR_9_10_mv_b_i + 12.712850864752*v_TR_9_10_mv_b_r + 33.3712335199739*v_TR_9_10_mv_c_i - 44.4949780266318*v_TR_9_10_mv_c_r
        struct[0].g[120,0] = i_TR_5_6_lv_a_r + 92.6872395051616*v_INV_5_a_i + 178.886372244962*v_INV_5_a_r - 26.4820684300462*v_INV_5_b_i - 51.1103920699891*v_INV_5_b_r - 26.4820684300462*v_INV_5_c_i - 51.1103920699891*v_INV_5_c_r + 58.4997822812349*v_INV_6_a_i + 112.904579802783*v_INV_6_a_r - 16.7142235089243*v_INV_6_b_i - 32.2584513722238*v_INV_6_b_r - 16.7142235089243*v_INV_6_c_i - 32.2584513722239*v_INV_6_c_r - 353.889424080847*v_TR_5_6_lv_a_i - 325.574735831529*v_TR_5_6_lv_a_r + 43.1964121022714*v_TR_5_6_lv_b_i + 83.3688434422129*v_TR_5_6_lv_b_r + 43.1964121022714*v_TR_5_6_lv_c_i + 83.368843442213*v_TR_5_6_lv_c_r + 2.3406091994174*v_TR_5_6_mv_a_i + 0.390101533236234*v_TR_5_6_mv_a_r - 2.3406091994174*v_TR_5_6_mv_c_i - 0.390101533236234*v_TR_5_6_mv_c_r
        struct[0].g[121,0] = i_TR_5_6_lv_a_i + 178.886372244962*v_INV_5_a_i - 92.6872395051616*v_INV_5_a_r - 51.1103920699891*v_INV_5_b_i + 26.4820684300462*v_INV_5_b_r - 51.1103920699891*v_INV_5_c_i + 26.4820684300462*v_INV_5_c_r + 112.904579802783*v_INV_6_a_i - 58.4997822812349*v_INV_6_a_r - 32.2584513722238*v_INV_6_b_i + 16.7142235089243*v_INV_6_b_r - 32.2584513722239*v_INV_6_c_i + 16.7142235089243*v_INV_6_c_r - 325.574735831529*v_TR_5_6_lv_a_i + 353.889424080847*v_TR_5_6_lv_a_r + 83.3688434422129*v_TR_5_6_lv_b_i - 43.1964121022714*v_TR_5_6_lv_b_r + 83.368843442213*v_TR_5_6_lv_c_i - 43.1964121022714*v_TR_5_6_lv_c_r + 0.390101533236234*v_TR_5_6_mv_a_i - 2.3406091994174*v_TR_5_6_mv_a_r - 0.390101533236234*v_TR_5_6_mv_c_i + 2.3406091994174*v_TR_5_6_mv_c_r
        struct[0].g[122,0] = i_TR_5_6_lv_b_r - 26.4820684300461*v_INV_5_a_i - 51.1103920699891*v_INV_5_a_r + 92.6872395051615*v_INV_5_b_i + 178.886372244962*v_INV_5_b_r - 26.4820684300461*v_INV_5_c_i - 51.1103920699892*v_INV_5_c_r - 16.7142235089243*v_INV_6_a_i - 32.2584513722238*v_INV_6_a_r + 58.4997822812349*v_INV_6_b_i + 112.904579802783*v_INV_6_b_r - 16.7142235089242*v_INV_6_c_i - 32.2584513722239*v_INV_6_c_r + 43.1964121022714*v_TR_5_6_lv_a_i + 83.3688434422129*v_TR_5_6_lv_a_r - 353.889424080846*v_TR_5_6_lv_b_i - 325.574735831529*v_TR_5_6_lv_b_r + 43.1964121022714*v_TR_5_6_lv_c_i + 83.3688434422131*v_TR_5_6_lv_c_r - 2.3406091994174*v_TR_5_6_mv_a_i - 0.390101533236234*v_TR_5_6_mv_a_r + 2.3406091994174*v_TR_5_6_mv_b_i + 0.390101533236234*v_TR_5_6_mv_b_r
        struct[0].g[123,0] = i_TR_5_6_lv_b_i - 51.1103920699891*v_INV_5_a_i + 26.4820684300461*v_INV_5_a_r + 178.886372244962*v_INV_5_b_i - 92.6872395051615*v_INV_5_b_r - 51.1103920699892*v_INV_5_c_i + 26.4820684300461*v_INV_5_c_r - 32.2584513722238*v_INV_6_a_i + 16.7142235089243*v_INV_6_a_r + 112.904579802783*v_INV_6_b_i - 58.4997822812349*v_INV_6_b_r - 32.2584513722239*v_INV_6_c_i + 16.7142235089242*v_INV_6_c_r + 83.3688434422129*v_TR_5_6_lv_a_i - 43.1964121022714*v_TR_5_6_lv_a_r - 325.574735831529*v_TR_5_6_lv_b_i + 353.889424080846*v_TR_5_6_lv_b_r + 83.3688434422131*v_TR_5_6_lv_c_i - 43.1964121022714*v_TR_5_6_lv_c_r - 0.390101533236234*v_TR_5_6_mv_a_i + 2.3406091994174*v_TR_5_6_mv_a_r + 0.390101533236234*v_TR_5_6_mv_b_i - 2.3406091994174*v_TR_5_6_mv_b_r
        struct[0].g[124,0] = i_TR_5_6_lv_c_r - 26.4820684300462*v_INV_5_a_i - 51.1103920699891*v_INV_5_a_r - 26.4820684300461*v_INV_5_b_i - 51.1103920699892*v_INV_5_b_r + 92.6872395051615*v_INV_5_c_i + 178.886372244962*v_INV_5_c_r - 16.7142235089243*v_INV_6_a_i - 32.2584513722239*v_INV_6_a_r - 16.7142235089242*v_INV_6_b_i - 32.2584513722239*v_INV_6_b_r + 58.4997822812349*v_INV_6_c_i + 112.904579802783*v_INV_6_c_r + 43.1964121022714*v_TR_5_6_lv_a_i + 83.368843442213*v_TR_5_6_lv_a_r + 43.1964121022714*v_TR_5_6_lv_b_i + 83.3688434422131*v_TR_5_6_lv_b_r - 353.889424080846*v_TR_5_6_lv_c_i - 325.574735831529*v_TR_5_6_lv_c_r - 2.3406091994174*v_TR_5_6_mv_b_i - 0.390101533236234*v_TR_5_6_mv_b_r + 2.3406091994174*v_TR_5_6_mv_c_i + 0.390101533236234*v_TR_5_6_mv_c_r
        struct[0].g[125,0] = i_TR_5_6_lv_c_i - 51.1103920699891*v_INV_5_a_i + 26.4820684300462*v_INV_5_a_r - 51.1103920699892*v_INV_5_b_i + 26.4820684300461*v_INV_5_b_r + 178.886372244962*v_INV_5_c_i - 92.6872395051615*v_INV_5_c_r - 32.2584513722239*v_INV_6_a_i + 16.7142235089243*v_INV_6_a_r - 32.2584513722239*v_INV_6_b_i + 16.7142235089242*v_INV_6_b_r + 112.904579802783*v_INV_6_c_i - 58.4997822812349*v_INV_6_c_r + 83.368843442213*v_TR_5_6_lv_a_i - 43.1964121022714*v_TR_5_6_lv_a_r + 83.3688434422131*v_TR_5_6_lv_b_i - 43.1964121022714*v_TR_5_6_lv_b_r - 325.574735831529*v_TR_5_6_lv_c_i + 353.889424080846*v_TR_5_6_lv_c_r - 0.390101533236234*v_TR_5_6_mv_b_i + 2.3406091994174*v_TR_5_6_mv_b_r + 0.390101533236234*v_TR_5_6_mv_c_i - 2.3406091994174*v_TR_5_6_mv_c_r
        struct[0].g[126,0] = i_TR_7_8_mv_a_r + 6.60088643956832*v_TR_13_mv_a_i + 8.97043541787489*v_TR_13_mv_a_r - 1.88596755416238*v_TR_13_mv_b_i - 2.56298154796426*v_TR_13_mv_b_r - 1.88596755416237*v_TR_13_mv_c_i - 2.56298154796426*v_TR_13_mv_c_r + 15.0420612397687*v_TR_3_4_mv_a_i + 20.4417755309677*v_TR_3_4_mv_a_r - 4.29773178279105*v_TR_3_4_mv_b_i - 5.8405072945622*v_TR_3_4_mv_b_r - 4.29773178279104*v_TR_3_4_mv_c_i - 5.84050729456219*v_TR_3_4_mv_c_r + 2.3406091994174*v_TR_7_8_lv_a_i + 0.390101533236234*v_TR_7_8_lv_a_r - 2.3406091994174*v_TR_7_8_lv_b_i - 0.390101533236234*v_TR_7_8_lv_b_r - 21.6969684194189*v_TR_7_8_mv_a_i - 29.4212199578516*v_TR_7_8_mv_a_r + 6.21073968956929*v_TR_7_8_mv_b_i + 8.40799334703096*v_TR_7_8_mv_b_r + 6.21073968956928*v_TR_7_8_mv_c_i + 8.40799334703096*v_TR_7_8_mv_c_r
        struct[0].g[127,0] = i_TR_7_8_mv_a_i + 8.97043541787489*v_TR_13_mv_a_i - 6.60088643956832*v_TR_13_mv_a_r - 2.56298154796426*v_TR_13_mv_b_i + 1.88596755416238*v_TR_13_mv_b_r - 2.56298154796426*v_TR_13_mv_c_i + 1.88596755416237*v_TR_13_mv_c_r + 20.4417755309677*v_TR_3_4_mv_a_i - 15.0420612397687*v_TR_3_4_mv_a_r - 5.8405072945622*v_TR_3_4_mv_b_i + 4.29773178279105*v_TR_3_4_mv_b_r - 5.84050729456219*v_TR_3_4_mv_c_i + 4.29773178279104*v_TR_3_4_mv_c_r + 0.390101533236234*v_TR_7_8_lv_a_i - 2.3406091994174*v_TR_7_8_lv_a_r - 0.390101533236234*v_TR_7_8_lv_b_i + 2.3406091994174*v_TR_7_8_lv_b_r - 29.4212199578516*v_TR_7_8_mv_a_i + 21.6969684194189*v_TR_7_8_mv_a_r + 8.40799334703096*v_TR_7_8_mv_b_i - 6.21073968956929*v_TR_7_8_mv_b_r + 8.40799334703096*v_TR_7_8_mv_c_i - 6.21073968956928*v_TR_7_8_mv_c_r
        struct[0].g[128,0] = i_TR_7_8_mv_b_r - 1.88596755416238*v_TR_13_mv_a_i - 2.56298154796426*v_TR_13_mv_a_r + 6.60088643956832*v_TR_13_mv_b_i + 8.9704354178749*v_TR_13_mv_b_r - 1.88596755416237*v_TR_13_mv_c_i - 2.56298154796426*v_TR_13_mv_c_r - 4.29773178279105*v_TR_3_4_mv_a_i - 5.8405072945622*v_TR_3_4_mv_a_r + 15.0420612397687*v_TR_3_4_mv_b_i + 20.4417755309677*v_TR_3_4_mv_b_r - 4.29773178279105*v_TR_3_4_mv_c_i - 5.8405072945622*v_TR_3_4_mv_c_r + 2.3406091994174*v_TR_7_8_lv_b_i + 0.390101533236234*v_TR_7_8_lv_b_r - 2.3406091994174*v_TR_7_8_lv_c_i - 0.390101533236234*v_TR_7_8_lv_c_r + 6.21073968956929*v_TR_7_8_mv_a_i + 8.40799334703096*v_TR_7_8_mv_a_r - 21.6969684194189*v_TR_7_8_mv_b_i - 29.4212199578516*v_TR_7_8_mv_b_r + 6.21073968956929*v_TR_7_8_mv_c_i + 8.40799334703097*v_TR_7_8_mv_c_r
        struct[0].g[129,0] = i_TR_7_8_mv_b_i - 2.56298154796426*v_TR_13_mv_a_i + 1.88596755416238*v_TR_13_mv_a_r + 8.9704354178749*v_TR_13_mv_b_i - 6.60088643956832*v_TR_13_mv_b_r - 2.56298154796426*v_TR_13_mv_c_i + 1.88596755416237*v_TR_13_mv_c_r - 5.8405072945622*v_TR_3_4_mv_a_i + 4.29773178279105*v_TR_3_4_mv_a_r + 20.4417755309677*v_TR_3_4_mv_b_i - 15.0420612397687*v_TR_3_4_mv_b_r - 5.8405072945622*v_TR_3_4_mv_c_i + 4.29773178279105*v_TR_3_4_mv_c_r + 0.390101533236234*v_TR_7_8_lv_b_i - 2.3406091994174*v_TR_7_8_lv_b_r - 0.390101533236234*v_TR_7_8_lv_c_i + 2.3406091994174*v_TR_7_8_lv_c_r + 8.40799334703096*v_TR_7_8_mv_a_i - 6.21073968956929*v_TR_7_8_mv_a_r - 29.4212199578516*v_TR_7_8_mv_b_i + 21.6969684194189*v_TR_7_8_mv_b_r + 8.40799334703097*v_TR_7_8_mv_c_i - 6.21073968956929*v_TR_7_8_mv_c_r
        struct[0].g[130,0] = i_TR_7_8_mv_c_r - 1.88596755416237*v_TR_13_mv_a_i - 2.56298154796426*v_TR_13_mv_a_r - 1.88596755416237*v_TR_13_mv_b_i - 2.56298154796426*v_TR_13_mv_b_r + 6.60088643956831*v_TR_13_mv_c_i + 8.9704354178749*v_TR_13_mv_c_r - 4.29773178279105*v_TR_3_4_mv_a_i - 5.84050729456219*v_TR_3_4_mv_a_r - 4.29773178279104*v_TR_3_4_mv_b_i - 5.84050729456221*v_TR_3_4_mv_b_r + 15.0420612397687*v_TR_3_4_mv_c_i + 20.4417755309677*v_TR_3_4_mv_c_r - 2.3406091994174*v_TR_7_8_lv_a_i - 0.390101533236234*v_TR_7_8_lv_a_r + 2.3406091994174*v_TR_7_8_lv_c_i + 0.390101533236234*v_TR_7_8_lv_c_r + 6.21073968956929*v_TR_7_8_mv_a_i + 8.40799334703095*v_TR_7_8_mv_a_r + 6.21073968956928*v_TR_7_8_mv_b_i + 8.40799334703097*v_TR_7_8_mv_b_r - 21.6969684194189*v_TR_7_8_mv_c_i - 29.4212199578516*v_TR_7_8_mv_c_r
        struct[0].g[131,0] = i_TR_7_8_mv_c_i - 2.56298154796426*v_TR_13_mv_a_i + 1.88596755416237*v_TR_13_mv_a_r - 2.56298154796426*v_TR_13_mv_b_i + 1.88596755416237*v_TR_13_mv_b_r + 8.9704354178749*v_TR_13_mv_c_i - 6.60088643956831*v_TR_13_mv_c_r - 5.84050729456219*v_TR_3_4_mv_a_i + 4.29773178279105*v_TR_3_4_mv_a_r - 5.84050729456221*v_TR_3_4_mv_b_i + 4.29773178279104*v_TR_3_4_mv_b_r + 20.4417755309677*v_TR_3_4_mv_c_i - 15.0420612397687*v_TR_3_4_mv_c_r - 0.390101533236234*v_TR_7_8_lv_a_i + 2.3406091994174*v_TR_7_8_lv_a_r + 0.390101533236234*v_TR_7_8_lv_c_i - 2.3406091994174*v_TR_7_8_lv_c_r + 8.40799334703095*v_TR_7_8_mv_a_i - 6.21073968956929*v_TR_7_8_mv_a_r + 8.40799334703097*v_TR_7_8_mv_b_i - 6.21073968956928*v_TR_7_8_mv_b_r - 29.4212199578516*v_TR_7_8_mv_c_i + 21.6969684194189*v_TR_7_8_mv_c_r
        struct[0].g[132,0] = i_TR_7_8_lv_a_r + 246.057604426258*v_INV_7_a_i + 474.891176542679*v_INV_7_a_r - 70.3021726932167*v_INV_7_b_i - 135.683193297908*v_INV_7_b_r - 70.3021726932166*v_INV_7_c_i - 135.683193297908*v_INV_7_c_r + 106.794172415445*v_INV_8_a_i + 206.112752761809*v_INV_8_a_r - 30.5126206901271*v_INV_8_b_i - 58.8893579319454*v_INV_8_b_r - 30.5126206901271*v_INV_8_c_i - 58.8893579319454*v_INV_8_c_r - 555.554334874064*v_TR_7_8_lv_a_i - 714.787713088272*v_TR_7_8_lv_a_r + 100.81485125148*v_TR_7_8_lv_b_i + 194.572551229854*v_TR_7_8_lv_b_r + 100.81485125148*v_TR_7_8_lv_c_i + 194.572551229854*v_TR_7_8_lv_c_r + 2.3406091994174*v_TR_7_8_mv_a_i + 0.390101533236234*v_TR_7_8_mv_a_r - 2.3406091994174*v_TR_7_8_mv_c_i - 0.390101533236234*v_TR_7_8_mv_c_r
        struct[0].g[133,0] = i_TR_7_8_lv_a_i + 474.891176542679*v_INV_7_a_i - 246.057604426258*v_INV_7_a_r - 135.683193297908*v_INV_7_b_i + 70.3021726932167*v_INV_7_b_r - 135.683193297908*v_INV_7_c_i + 70.3021726932166*v_INV_7_c_r + 206.112752761809*v_INV_8_a_i - 106.794172415445*v_INV_8_a_r - 58.8893579319454*v_INV_8_b_i + 30.5126206901271*v_INV_8_b_r - 58.8893579319454*v_INV_8_c_i + 30.5126206901271*v_INV_8_c_r - 714.787713088272*v_TR_7_8_lv_a_i + 555.554334874064*v_TR_7_8_lv_a_r + 194.572551229854*v_TR_7_8_lv_b_i - 100.81485125148*v_TR_7_8_lv_b_r + 194.572551229854*v_TR_7_8_lv_c_i - 100.81485125148*v_TR_7_8_lv_c_r + 0.390101533236234*v_TR_7_8_mv_a_i - 2.3406091994174*v_TR_7_8_mv_a_r - 0.390101533236234*v_TR_7_8_mv_c_i + 2.3406091994174*v_TR_7_8_mv_c_r
        struct[0].g[134,0] = i_TR_7_8_lv_b_r - 70.3021726932166*v_INV_7_a_i - 135.683193297908*v_INV_7_a_r + 246.057604426258*v_INV_7_b_i + 474.891176542679*v_INV_7_b_r - 70.3021726932165*v_INV_7_c_i - 135.683193297909*v_INV_7_c_r - 30.5126206901271*v_INV_8_a_i - 58.8893579319454*v_INV_8_a_r + 106.794172415445*v_INV_8_b_i + 206.112752761809*v_INV_8_b_r - 30.5126206901271*v_INV_8_c_i - 58.8893579319455*v_INV_8_c_r + 100.81485125148*v_TR_7_8_lv_a_i + 194.572551229854*v_TR_7_8_lv_a_r - 555.554334874064*v_TR_7_8_lv_b_i - 714.787713088272*v_TR_7_8_lv_b_r + 100.81485125148*v_TR_7_8_lv_c_i + 194.572551229854*v_TR_7_8_lv_c_r - 2.3406091994174*v_TR_7_8_mv_a_i - 0.390101533236234*v_TR_7_8_mv_a_r + 2.3406091994174*v_TR_7_8_mv_b_i + 0.390101533236234*v_TR_7_8_mv_b_r
        struct[0].g[135,0] = i_TR_7_8_lv_b_i - 135.683193297908*v_INV_7_a_i + 70.3021726932166*v_INV_7_a_r + 474.891176542679*v_INV_7_b_i - 246.057604426258*v_INV_7_b_r - 135.683193297909*v_INV_7_c_i + 70.3021726932165*v_INV_7_c_r - 58.8893579319454*v_INV_8_a_i + 30.5126206901271*v_INV_8_a_r + 206.112752761809*v_INV_8_b_i - 106.794172415445*v_INV_8_b_r - 58.8893579319455*v_INV_8_c_i + 30.5126206901271*v_INV_8_c_r + 194.572551229854*v_TR_7_8_lv_a_i - 100.81485125148*v_TR_7_8_lv_a_r - 714.787713088272*v_TR_7_8_lv_b_i + 555.554334874064*v_TR_7_8_lv_b_r + 194.572551229854*v_TR_7_8_lv_c_i - 100.81485125148*v_TR_7_8_lv_c_r - 0.390101533236234*v_TR_7_8_mv_a_i + 2.3406091994174*v_TR_7_8_mv_a_r + 0.390101533236234*v_TR_7_8_mv_b_i - 2.3406091994174*v_TR_7_8_mv_b_r
        struct[0].g[136,0] = i_TR_7_8_lv_c_r - 70.3021726932167*v_INV_7_a_i - 135.683193297908*v_INV_7_a_r - 70.3021726932165*v_INV_7_b_i - 135.683193297909*v_INV_7_b_r + 246.057604426258*v_INV_7_c_i + 474.891176542679*v_INV_7_c_r - 30.5126206901272*v_INV_8_a_i - 58.8893579319454*v_INV_8_a_r - 30.5126206901271*v_INV_8_b_i - 58.8893579319455*v_INV_8_b_r + 106.794172415445*v_INV_8_c_i + 206.112752761809*v_INV_8_c_r + 100.814851251481*v_TR_7_8_lv_a_i + 194.572551229854*v_TR_7_8_lv_a_r + 100.81485125148*v_TR_7_8_lv_b_i + 194.572551229854*v_TR_7_8_lv_b_r - 555.554334874064*v_TR_7_8_lv_c_i - 714.787713088272*v_TR_7_8_lv_c_r - 2.3406091994174*v_TR_7_8_mv_b_i - 0.390101533236234*v_TR_7_8_mv_b_r + 2.3406091994174*v_TR_7_8_mv_c_i + 0.390101533236234*v_TR_7_8_mv_c_r
        struct[0].g[137,0] = i_TR_7_8_lv_c_i - 135.683193297908*v_INV_7_a_i + 70.3021726932167*v_INV_7_a_r - 135.683193297909*v_INV_7_b_i + 70.3021726932165*v_INV_7_b_r + 474.891176542679*v_INV_7_c_i - 246.057604426258*v_INV_7_c_r - 58.8893579319454*v_INV_8_a_i + 30.5126206901272*v_INV_8_a_r - 58.8893579319455*v_INV_8_b_i + 30.5126206901271*v_INV_8_b_r + 206.112752761809*v_INV_8_c_i - 106.794172415445*v_INV_8_c_r + 194.572551229854*v_TR_7_8_lv_a_i - 100.814851251481*v_TR_7_8_lv_a_r + 194.572551229854*v_TR_7_8_lv_b_i - 100.81485125148*v_TR_7_8_lv_b_r - 714.787713088272*v_TR_7_8_lv_c_i + 555.554334874064*v_TR_7_8_lv_c_r - 0.390101533236234*v_TR_7_8_mv_b_i + 2.3406091994174*v_TR_7_8_mv_b_r + 0.390101533236234*v_TR_7_8_mv_c_i - 2.3406091994174*v_TR_7_8_mv_c_r
        struct[0].g[138,0] = i_TR_9_10_mv_a_r + 8.85995441972108*v_TR_11_12_mv_a_i + 12.0404508780825*v_TR_11_12_mv_a_r - 2.53141554849174*v_TR_11_12_mv_b_i - 3.44012882230928*v_TR_11_12_mv_b_r - 2.53141554849173*v_TR_11_12_mv_c_i - 3.44012882230929*v_TR_11_12_mv_c_r + 44.4949780266318*v_TR_5_6_mv_a_i + 33.3712335199739*v_TR_5_6_mv_a_r - 12.7128508647519*v_TR_5_6_mv_b_i - 9.53463814856397*v_TR_5_6_mv_b_r - 12.7128508647519*v_TR_5_6_mv_c_i - 9.53463814856397*v_TR_5_6_mv_c_r + 2.3406091994174*v_TR_9_10_lv_a_i + 0.390101533236234*v_TR_9_10_lv_a_r - 2.3406091994174*v_TR_9_10_lv_b_i - 0.390101533236234*v_TR_9_10_lv_b_r - 53.4089596754468*v_TR_9_10_mv_a_i - 45.4206934070654*v_TR_9_10_mv_a_r + 15.2713041702548*v_TR_9_10_mv_b_i + 12.9792714753778*v_TR_9_10_mv_b_r + 15.2713041702547*v_TR_9_10_mv_c_i + 12.9792714753778*v_TR_9_10_mv_c_r
        struct[0].g[139,0] = i_TR_9_10_mv_a_i + 12.0404508780825*v_TR_11_12_mv_a_i - 8.85995441972108*v_TR_11_12_mv_a_r - 3.44012882230928*v_TR_11_12_mv_b_i + 2.53141554849174*v_TR_11_12_mv_b_r - 3.44012882230929*v_TR_11_12_mv_c_i + 2.53141554849173*v_TR_11_12_mv_c_r + 33.3712335199739*v_TR_5_6_mv_a_i - 44.4949780266318*v_TR_5_6_mv_a_r - 9.53463814856397*v_TR_5_6_mv_b_i + 12.7128508647519*v_TR_5_6_mv_b_r - 9.53463814856397*v_TR_5_6_mv_c_i + 12.7128508647519*v_TR_5_6_mv_c_r + 0.390101533236234*v_TR_9_10_lv_a_i - 2.3406091994174*v_TR_9_10_lv_a_r - 0.390101533236234*v_TR_9_10_lv_b_i + 2.3406091994174*v_TR_9_10_lv_b_r - 45.4206934070654*v_TR_9_10_mv_a_i + 53.4089596754468*v_TR_9_10_mv_a_r + 12.9792714753778*v_TR_9_10_mv_b_i - 15.2713041702548*v_TR_9_10_mv_b_r + 12.9792714753778*v_TR_9_10_mv_c_i - 15.2713041702547*v_TR_9_10_mv_c_r
        struct[0].g[140,0] = i_TR_9_10_mv_b_r - 2.53141554849173*v_TR_11_12_mv_a_i - 3.44012882230929*v_TR_11_12_mv_a_r + 8.85995441972108*v_TR_11_12_mv_b_i + 12.0404508780825*v_TR_11_12_mv_b_r - 2.53141554849174*v_TR_11_12_mv_c_i - 3.44012882230929*v_TR_11_12_mv_c_r - 12.7128508647519*v_TR_5_6_mv_a_i - 9.53463814856397*v_TR_5_6_mv_a_r + 44.4949780266318*v_TR_5_6_mv_b_i + 33.3712335199739*v_TR_5_6_mv_b_r - 12.712850864752*v_TR_5_6_mv_c_i - 9.53463814856399*v_TR_5_6_mv_c_r + 2.3406091994174*v_TR_9_10_lv_b_i + 0.390101533236234*v_TR_9_10_lv_b_r - 2.3406091994174*v_TR_9_10_lv_c_i - 0.390101533236234*v_TR_9_10_lv_c_r + 15.2713041702548*v_TR_9_10_mv_a_i + 12.9792714753778*v_TR_9_10_mv_a_r - 53.4089596754469*v_TR_9_10_mv_b_i - 45.4206934070654*v_TR_9_10_mv_b_r + 15.2713041702548*v_TR_9_10_mv_c_i + 12.9792714753778*v_TR_9_10_mv_c_r
        struct[0].g[141,0] = i_TR_9_10_mv_b_i - 3.44012882230929*v_TR_11_12_mv_a_i + 2.53141554849173*v_TR_11_12_mv_a_r + 12.0404508780825*v_TR_11_12_mv_b_i - 8.85995441972108*v_TR_11_12_mv_b_r - 3.44012882230929*v_TR_11_12_mv_c_i + 2.53141554849174*v_TR_11_12_mv_c_r - 9.53463814856397*v_TR_5_6_mv_a_i + 12.7128508647519*v_TR_5_6_mv_a_r + 33.3712335199739*v_TR_5_6_mv_b_i - 44.4949780266318*v_TR_5_6_mv_b_r - 9.53463814856399*v_TR_5_6_mv_c_i + 12.712850864752*v_TR_5_6_mv_c_r + 0.390101533236234*v_TR_9_10_lv_b_i - 2.3406091994174*v_TR_9_10_lv_b_r - 0.390101533236234*v_TR_9_10_lv_c_i + 2.3406091994174*v_TR_9_10_lv_c_r + 12.9792714753778*v_TR_9_10_mv_a_i - 15.2713041702548*v_TR_9_10_mv_a_r - 45.4206934070654*v_TR_9_10_mv_b_i + 53.4089596754469*v_TR_9_10_mv_b_r + 12.9792714753778*v_TR_9_10_mv_c_i - 15.2713041702548*v_TR_9_10_mv_c_r
        struct[0].g[142,0] = i_TR_9_10_mv_c_r - 2.53141554849174*v_TR_11_12_mv_a_i - 3.44012882230928*v_TR_11_12_mv_a_r - 2.53141554849174*v_TR_11_12_mv_b_i - 3.44012882230929*v_TR_11_12_mv_b_r + 8.85995441972108*v_TR_11_12_mv_c_i + 12.0404508780825*v_TR_11_12_mv_c_r - 12.7128508647519*v_TR_5_6_mv_a_i - 9.53463814856397*v_TR_5_6_mv_a_r - 12.712850864752*v_TR_5_6_mv_b_i - 9.53463814856399*v_TR_5_6_mv_b_r + 44.4949780266318*v_TR_5_6_mv_c_i + 33.3712335199739*v_TR_5_6_mv_c_r - 2.3406091994174*v_TR_9_10_lv_a_i - 0.390101533236234*v_TR_9_10_lv_a_r + 2.3406091994174*v_TR_9_10_lv_c_i + 0.390101533236234*v_TR_9_10_lv_c_r + 15.2713041702548*v_TR_9_10_mv_a_i + 12.9792714753778*v_TR_9_10_mv_a_r + 15.2713041702548*v_TR_9_10_mv_b_i + 12.9792714753778*v_TR_9_10_mv_b_r - 53.4089596754468*v_TR_9_10_mv_c_i - 45.4206934070654*v_TR_9_10_mv_c_r
        struct[0].g[143,0] = i_TR_9_10_mv_c_i - 3.44012882230928*v_TR_11_12_mv_a_i + 2.53141554849174*v_TR_11_12_mv_a_r - 3.44012882230929*v_TR_11_12_mv_b_i + 2.53141554849174*v_TR_11_12_mv_b_r + 12.0404508780825*v_TR_11_12_mv_c_i - 8.85995441972108*v_TR_11_12_mv_c_r - 9.53463814856397*v_TR_5_6_mv_a_i + 12.7128508647519*v_TR_5_6_mv_a_r - 9.53463814856399*v_TR_5_6_mv_b_i + 12.712850864752*v_TR_5_6_mv_b_r + 33.3712335199739*v_TR_5_6_mv_c_i - 44.4949780266318*v_TR_5_6_mv_c_r - 0.390101533236234*v_TR_9_10_lv_a_i + 2.3406091994174*v_TR_9_10_lv_a_r + 0.390101533236234*v_TR_9_10_lv_c_i - 2.3406091994174*v_TR_9_10_lv_c_r + 12.9792714753778*v_TR_9_10_mv_a_i - 15.2713041702548*v_TR_9_10_mv_a_r + 12.9792714753778*v_TR_9_10_mv_b_i - 15.2713041702548*v_TR_9_10_mv_b_r - 45.4206934070654*v_TR_9_10_mv_c_i + 53.4089596754468*v_TR_9_10_mv_c_r
        struct[0].g[144,0] = i_TR_9_10_lv_a_r + 75.8059117481773*v_INV_10_a_i + 146.305409673982*v_INV_10_a_r - 21.6588319280506*v_INV_10_b_i - 41.8015456211378*v_INV_10_b_r - 21.6588319280506*v_INV_10_c_i - 41.8015456211378*v_INV_10_c_r + 98.1764998873781*v_INV_9_a_i + 189.48064478264*v_INV_9_a_r - 28.0504285392509*v_INV_9_b_i - 54.1373270807543*v_INV_9_b_r - 28.0504285392509*v_INV_9_c_i - 54.1373270807543*v_INV_9_c_r - 376.684862474157*v_TR_9_10_lv_a_i - 369.569838240406*v_TR_9_10_lv_a_r + 49.709361212942*v_TR_9_10_lv_b_i + 95.9388727018921*v_TR_9_10_lv_b_r + 49.7093612129419*v_TR_9_10_lv_c_i + 95.9388727018921*v_TR_9_10_lv_c_r + 2.3406091994174*v_TR_9_10_mv_a_i + 0.390101533236234*v_TR_9_10_mv_a_r - 2.3406091994174*v_TR_9_10_mv_c_i - 0.390101533236234*v_TR_9_10_mv_c_r
        struct[0].g[145,0] = i_TR_9_10_lv_a_i + 146.305409673982*v_INV_10_a_i - 75.8059117481773*v_INV_10_a_r - 41.8015456211378*v_INV_10_b_i + 21.6588319280506*v_INV_10_b_r - 41.8015456211378*v_INV_10_c_i + 21.6588319280506*v_INV_10_c_r + 189.48064478264*v_INV_9_a_i - 98.1764998873781*v_INV_9_a_r - 54.1373270807543*v_INV_9_b_i + 28.0504285392509*v_INV_9_b_r - 54.1373270807543*v_INV_9_c_i + 28.0504285392509*v_INV_9_c_r - 369.569838240406*v_TR_9_10_lv_a_i + 376.684862474157*v_TR_9_10_lv_a_r + 95.9388727018921*v_TR_9_10_lv_b_i - 49.709361212942*v_TR_9_10_lv_b_r + 95.9388727018921*v_TR_9_10_lv_c_i - 49.7093612129419*v_TR_9_10_lv_c_r + 0.390101533236234*v_TR_9_10_mv_a_i - 2.3406091994174*v_TR_9_10_mv_a_r - 0.390101533236234*v_TR_9_10_mv_c_i + 2.3406091994174*v_TR_9_10_mv_c_r
        struct[0].g[146,0] = i_TR_9_10_lv_b_r - 21.6588319280506*v_INV_10_a_i - 41.8015456211377*v_INV_10_a_r + 75.8059117481773*v_INV_10_b_i + 146.305409673982*v_INV_10_b_r - 21.6588319280506*v_INV_10_c_i - 41.8015456211378*v_INV_10_c_r - 28.0504285392509*v_INV_9_a_i - 54.1373270807543*v_INV_9_a_r + 98.1764998873781*v_INV_9_b_i + 189.48064478264*v_INV_9_b_r - 28.0504285392509*v_INV_9_c_i - 54.1373270807544*v_INV_9_c_r + 49.7093612129419*v_TR_9_10_lv_a_i + 95.938872701892*v_TR_9_10_lv_a_r - 376.684862474157*v_TR_9_10_lv_b_i - 369.569838240406*v_TR_9_10_lv_b_r + 49.7093612129419*v_TR_9_10_lv_c_i + 95.9388727018922*v_TR_9_10_lv_c_r - 2.3406091994174*v_TR_9_10_mv_a_i - 0.390101533236234*v_TR_9_10_mv_a_r + 2.3406091994174*v_TR_9_10_mv_b_i + 0.390101533236234*v_TR_9_10_mv_b_r
        struct[0].g[147,0] = i_TR_9_10_lv_b_i - 41.8015456211377*v_INV_10_a_i + 21.6588319280506*v_INV_10_a_r + 146.305409673982*v_INV_10_b_i - 75.8059117481773*v_INV_10_b_r - 41.8015456211378*v_INV_10_c_i + 21.6588319280506*v_INV_10_c_r - 54.1373270807543*v_INV_9_a_i + 28.0504285392509*v_INV_9_a_r + 189.48064478264*v_INV_9_b_i - 98.1764998873781*v_INV_9_b_r - 54.1373270807544*v_INV_9_c_i + 28.0504285392509*v_INV_9_c_r + 95.938872701892*v_TR_9_10_lv_a_i - 49.7093612129419*v_TR_9_10_lv_a_r - 369.569838240406*v_TR_9_10_lv_b_i + 376.684862474157*v_TR_9_10_lv_b_r + 95.9388727018922*v_TR_9_10_lv_c_i - 49.7093612129419*v_TR_9_10_lv_c_r - 0.390101533236234*v_TR_9_10_mv_a_i + 2.3406091994174*v_TR_9_10_mv_a_r + 0.390101533236234*v_TR_9_10_mv_b_i - 2.3406091994174*v_TR_9_10_mv_b_r
        struct[0].g[148,0] = i_TR_9_10_lv_c_r - 21.6588319280506*v_INV_10_a_i - 41.8015456211378*v_INV_10_a_r - 21.6588319280506*v_INV_10_b_i - 41.8015456211378*v_INV_10_b_r + 75.8059117481773*v_INV_10_c_i + 146.305409673982*v_INV_10_c_r - 28.0504285392509*v_INV_9_a_i - 54.1373270807543*v_INV_9_a_r - 28.0504285392509*v_INV_9_b_i - 54.1373270807543*v_INV_9_b_r + 98.1764998873781*v_INV_9_c_i + 189.48064478264*v_INV_9_c_r + 49.709361212942*v_TR_9_10_lv_a_i + 95.9388727018921*v_TR_9_10_lv_a_r + 49.7093612129419*v_TR_9_10_lv_b_i + 95.9388727018921*v_TR_9_10_lv_b_r - 376.684862474157*v_TR_9_10_lv_c_i - 369.569838240406*v_TR_9_10_lv_c_r - 2.3406091994174*v_TR_9_10_mv_b_i - 0.390101533236234*v_TR_9_10_mv_b_r + 2.3406091994174*v_TR_9_10_mv_c_i + 0.390101533236234*v_TR_9_10_mv_c_r
        struct[0].g[149,0] = i_TR_9_10_lv_c_i - 41.8015456211378*v_INV_10_a_i + 21.6588319280506*v_INV_10_a_r - 41.8015456211378*v_INV_10_b_i + 21.6588319280506*v_INV_10_b_r + 146.305409673982*v_INV_10_c_i - 75.8059117481773*v_INV_10_c_r - 54.1373270807543*v_INV_9_a_i + 28.0504285392509*v_INV_9_a_r - 54.1373270807543*v_INV_9_b_i + 28.0504285392509*v_INV_9_b_r + 189.48064478264*v_INV_9_c_i - 98.1764998873781*v_INV_9_c_r + 95.9388727018921*v_TR_9_10_lv_a_i - 49.709361212942*v_TR_9_10_lv_a_r + 95.9388727018921*v_TR_9_10_lv_b_i - 49.7093612129419*v_TR_9_10_lv_b_r - 369.569838240406*v_TR_9_10_lv_c_i + 376.684862474157*v_TR_9_10_lv_c_r - 0.390101533236234*v_TR_9_10_mv_b_i + 2.3406091994174*v_TR_9_10_mv_b_r + 0.390101533236234*v_TR_9_10_mv_c_i - 2.3406091994174*v_TR_9_10_mv_c_r
        struct[0].g[150,0] = i_TR_11_12_mv_a_r + 2.3406091994174*v_TR_11_12_lv_a_i + 0.390101533236234*v_TR_11_12_lv_a_r - 2.3406091994174*v_TR_11_12_lv_b_i - 0.390101533236234*v_TR_11_12_lv_b_r - 8.91399122381347*v_TR_11_12_mv_a_i - 12.0494598870915*v_TR_11_12_mv_a_r + 2.55844947550343*v_TR_11_12_mv_b_i + 3.44463332681379*v_TR_11_12_mv_b_r + 2.55844947550343*v_TR_11_12_mv_c_i + 3.44463332681379*v_TR_11_12_mv_c_r + 8.85995441972108*v_TR_9_10_mv_a_i + 12.0404508780825*v_TR_9_10_mv_a_r - 2.53141554849174*v_TR_9_10_mv_b_i - 3.44012882230928*v_TR_9_10_mv_b_r - 2.53141554849173*v_TR_9_10_mv_c_i - 3.44012882230929*v_TR_9_10_mv_c_r
        struct[0].g[151,0] = i_TR_11_12_mv_a_i + 0.390101533236234*v_TR_11_12_lv_a_i - 2.3406091994174*v_TR_11_12_lv_a_r - 0.390101533236234*v_TR_11_12_lv_b_i + 2.3406091994174*v_TR_11_12_lv_b_r - 12.0494598870915*v_TR_11_12_mv_a_i + 8.91399122381347*v_TR_11_12_mv_a_r + 3.44463332681379*v_TR_11_12_mv_b_i - 2.55844947550343*v_TR_11_12_mv_b_r + 3.44463332681379*v_TR_11_12_mv_c_i - 2.55844947550343*v_TR_11_12_mv_c_r + 12.0404508780825*v_TR_9_10_mv_a_i - 8.85995441972108*v_TR_9_10_mv_a_r - 3.44012882230928*v_TR_9_10_mv_b_i + 2.53141554849174*v_TR_9_10_mv_b_r - 3.44012882230929*v_TR_9_10_mv_c_i + 2.53141554849173*v_TR_9_10_mv_c_r
        struct[0].g[152,0] = i_TR_11_12_mv_b_r + 2.3406091994174*v_TR_11_12_lv_b_i + 0.390101533236234*v_TR_11_12_lv_b_r - 2.3406091994174*v_TR_11_12_lv_c_i - 0.390101533236234*v_TR_11_12_lv_c_r + 2.55844947550343*v_TR_11_12_mv_a_i + 3.44463332681379*v_TR_11_12_mv_a_r - 8.91399122381347*v_TR_11_12_mv_b_i - 12.0494598870915*v_TR_11_12_mv_b_r + 2.55844947550343*v_TR_11_12_mv_c_i + 3.4446333268138*v_TR_11_12_mv_c_r - 2.53141554849173*v_TR_9_10_mv_a_i - 3.44012882230929*v_TR_9_10_mv_a_r + 8.85995441972108*v_TR_9_10_mv_b_i + 12.0404508780825*v_TR_9_10_mv_b_r - 2.53141554849174*v_TR_9_10_mv_c_i - 3.44012882230929*v_TR_9_10_mv_c_r
        struct[0].g[153,0] = i_TR_11_12_mv_b_i + 0.390101533236234*v_TR_11_12_lv_b_i - 2.3406091994174*v_TR_11_12_lv_b_r - 0.390101533236234*v_TR_11_12_lv_c_i + 2.3406091994174*v_TR_11_12_lv_c_r + 3.44463332681379*v_TR_11_12_mv_a_i - 2.55844947550343*v_TR_11_12_mv_a_r - 12.0494598870915*v_TR_11_12_mv_b_i + 8.91399122381347*v_TR_11_12_mv_b_r + 3.4446333268138*v_TR_11_12_mv_c_i - 2.55844947550343*v_TR_11_12_mv_c_r - 3.44012882230929*v_TR_9_10_mv_a_i + 2.53141554849173*v_TR_9_10_mv_a_r + 12.0404508780825*v_TR_9_10_mv_b_i - 8.85995441972108*v_TR_9_10_mv_b_r - 3.44012882230929*v_TR_9_10_mv_c_i + 2.53141554849174*v_TR_9_10_mv_c_r
        struct[0].g[154,0] = i_TR_11_12_mv_c_r - 2.3406091994174*v_TR_11_12_lv_a_i - 0.390101533236234*v_TR_11_12_lv_a_r + 2.3406091994174*v_TR_11_12_lv_c_i + 0.390101533236234*v_TR_11_12_lv_c_r + 2.55844947550343*v_TR_11_12_mv_a_i + 3.44463332681379*v_TR_11_12_mv_a_r + 2.55844947550343*v_TR_11_12_mv_b_i + 3.4446333268138*v_TR_11_12_mv_b_r - 8.91399122381347*v_TR_11_12_mv_c_i - 12.0494598870915*v_TR_11_12_mv_c_r - 2.53141554849174*v_TR_9_10_mv_a_i - 3.44012882230928*v_TR_9_10_mv_a_r - 2.53141554849174*v_TR_9_10_mv_b_i - 3.44012882230929*v_TR_9_10_mv_b_r + 8.85995441972108*v_TR_9_10_mv_c_i + 12.0404508780825*v_TR_9_10_mv_c_r
        struct[0].g[155,0] = i_TR_11_12_mv_c_i - 0.390101533236234*v_TR_11_12_lv_a_i + 2.3406091994174*v_TR_11_12_lv_a_r + 0.390101533236234*v_TR_11_12_lv_c_i - 2.3406091994174*v_TR_11_12_lv_c_r + 3.44463332681379*v_TR_11_12_mv_a_i - 2.55844947550343*v_TR_11_12_mv_a_r + 3.4446333268138*v_TR_11_12_mv_b_i - 2.55844947550343*v_TR_11_12_mv_b_r - 12.0494598870915*v_TR_11_12_mv_c_i + 8.91399122381347*v_TR_11_12_mv_c_r - 3.44012882230928*v_TR_9_10_mv_a_i + 2.53141554849174*v_TR_9_10_mv_a_r - 3.44012882230929*v_TR_9_10_mv_b_i + 2.53141554849174*v_TR_9_10_mv_b_r + 12.0404508780825*v_TR_9_10_mv_c_i - 8.85995441972108*v_TR_9_10_mv_c_r
        struct[0].g[156,0] = i_TR_11_12_lv_a_r + 81.5761620304113*v_INV_11_a_i + 157.441992718694*v_INV_11_a_r - 23.3074748658318*v_INV_11_b_i - 44.9834264910554*v_INV_11_b_r - 23.3074748658318*v_INV_11_c_i - 44.9834264910554*v_INV_11_c_r + 107.907268017809*v_INV_12_a_i + 208.26102727437*v_INV_12_a_r - 30.8306480050881*v_INV_12_b_i - 59.5031506498201*v_INV_12_b_r - 30.8306480050881*v_INV_12_c_i - 59.5031506498201*v_INV_12_c_r - 392.185900835935*v_TR_11_12_lv_a_i - 399.486803776848*v_TR_11_12_lv_a_r + 54.138215636915*v_TR_11_12_lv_b_i + 104.486577140876*v_TR_11_12_lv_b_r + 54.138215636915*v_TR_11_12_lv_c_i + 104.486577140876*v_TR_11_12_lv_c_r + 2.3406091994174*v_TR_11_12_mv_a_i + 0.390101533236234*v_TR_11_12_mv_a_r - 2.3406091994174*v_TR_11_12_mv_c_i - 0.390101533236234*v_TR_11_12_mv_c_r
        struct[0].g[157,0] = i_TR_11_12_lv_a_i + 157.441992718694*v_INV_11_a_i - 81.5761620304113*v_INV_11_a_r - 44.9834264910554*v_INV_11_b_i + 23.3074748658318*v_INV_11_b_r - 44.9834264910554*v_INV_11_c_i + 23.3074748658318*v_INV_11_c_r + 208.26102727437*v_INV_12_a_i - 107.907268017809*v_INV_12_a_r - 59.5031506498201*v_INV_12_b_i + 30.8306480050881*v_INV_12_b_r - 59.5031506498201*v_INV_12_c_i + 30.8306480050881*v_INV_12_c_r - 399.486803776848*v_TR_11_12_lv_a_i + 392.185900835935*v_TR_11_12_lv_a_r + 104.486577140876*v_TR_11_12_lv_b_i - 54.138215636915*v_TR_11_12_lv_b_r + 104.486577140876*v_TR_11_12_lv_c_i - 54.138215636915*v_TR_11_12_lv_c_r + 0.390101533236234*v_TR_11_12_mv_a_i - 2.3406091994174*v_TR_11_12_mv_a_r - 0.390101533236234*v_TR_11_12_mv_c_i + 2.3406091994174*v_TR_11_12_mv_c_r
        struct[0].g[158,0] = i_TR_11_12_lv_b_r - 23.3074748658318*v_INV_11_a_i - 44.9834264910554*v_INV_11_a_r + 81.5761620304112*v_INV_11_b_i + 157.441992718694*v_INV_11_b_r - 23.3074748658317*v_INV_11_c_i - 44.9834264910555*v_INV_11_c_r - 30.8306480050881*v_INV_12_a_i - 59.5031506498201*v_INV_12_a_r + 107.907268017808*v_INV_12_b_i + 208.261027274371*v_INV_12_b_r - 30.8306480050881*v_INV_12_c_i - 59.5031506498202*v_INV_12_c_r + 54.138215636915*v_TR_11_12_lv_a_i + 104.486577140876*v_TR_11_12_lv_a_r - 392.185900835935*v_TR_11_12_lv_b_i - 399.486803776848*v_TR_11_12_lv_b_r + 54.138215636915*v_TR_11_12_lv_c_i + 104.486577140876*v_TR_11_12_lv_c_r - 2.3406091994174*v_TR_11_12_mv_a_i - 0.390101533236234*v_TR_11_12_mv_a_r + 2.3406091994174*v_TR_11_12_mv_b_i + 0.390101533236234*v_TR_11_12_mv_b_r
        struct[0].g[159,0] = i_TR_11_12_lv_b_i - 44.9834264910554*v_INV_11_a_i + 23.3074748658318*v_INV_11_a_r + 157.441992718694*v_INV_11_b_i - 81.5761620304112*v_INV_11_b_r - 44.9834264910555*v_INV_11_c_i + 23.3074748658317*v_INV_11_c_r - 59.5031506498201*v_INV_12_a_i + 30.8306480050881*v_INV_12_a_r + 208.261027274371*v_INV_12_b_i - 107.907268017808*v_INV_12_b_r - 59.5031506498202*v_INV_12_c_i + 30.8306480050881*v_INV_12_c_r + 104.486577140876*v_TR_11_12_lv_a_i - 54.138215636915*v_TR_11_12_lv_a_r - 399.486803776848*v_TR_11_12_lv_b_i + 392.185900835935*v_TR_11_12_lv_b_r + 104.486577140876*v_TR_11_12_lv_c_i - 54.138215636915*v_TR_11_12_lv_c_r - 0.390101533236234*v_TR_11_12_mv_a_i + 2.3406091994174*v_TR_11_12_mv_a_r + 0.390101533236234*v_TR_11_12_mv_b_i - 2.3406091994174*v_TR_11_12_mv_b_r
        struct[0].g[160,0] = i_TR_11_12_lv_c_r - 23.3074748658318*v_INV_11_a_i - 44.9834264910554*v_INV_11_a_r - 23.3074748658317*v_INV_11_b_i - 44.9834264910554*v_INV_11_b_r + 81.5761620304112*v_INV_11_c_i + 157.441992718694*v_INV_11_c_r - 30.8306480050882*v_INV_12_a_i - 59.5031506498201*v_INV_12_a_r - 30.8306480050881*v_INV_12_b_i - 59.5031506498202*v_INV_12_b_r + 107.907268017808*v_INV_12_c_i + 208.261027274371*v_INV_12_c_r + 54.138215636915*v_TR_11_12_lv_a_i + 104.486577140876*v_TR_11_12_lv_a_r + 54.138215636915*v_TR_11_12_lv_b_i + 104.486577140876*v_TR_11_12_lv_b_r - 392.185900835935*v_TR_11_12_lv_c_i - 399.486803776848*v_TR_11_12_lv_c_r - 2.3406091994174*v_TR_11_12_mv_b_i - 0.390101533236234*v_TR_11_12_mv_b_r + 2.3406091994174*v_TR_11_12_mv_c_i + 0.390101533236234*v_TR_11_12_mv_c_r
        struct[0].g[161,0] = i_TR_11_12_lv_c_i - 44.9834264910554*v_INV_11_a_i + 23.3074748658318*v_INV_11_a_r - 44.9834264910554*v_INV_11_b_i + 23.3074748658317*v_INV_11_b_r + 157.441992718694*v_INV_11_c_i - 81.5761620304112*v_INV_11_c_r - 59.5031506498201*v_INV_12_a_i + 30.8306480050882*v_INV_12_a_r - 59.5031506498202*v_INV_12_b_i + 30.8306480050881*v_INV_12_b_r + 208.261027274371*v_INV_12_c_i - 107.907268017808*v_INV_12_c_r + 104.486577140876*v_TR_11_12_lv_a_i - 54.138215636915*v_TR_11_12_lv_a_r + 104.486577140876*v_TR_11_12_lv_b_i - 54.138215636915*v_TR_11_12_lv_b_r - 399.486803776848*v_TR_11_12_lv_c_i + 392.185900835935*v_TR_11_12_lv_c_r - 0.390101533236234*v_TR_11_12_mv_b_i + 2.3406091994174*v_TR_11_12_mv_b_r + 0.390101533236234*v_TR_11_12_mv_c_i - 2.3406091994174*v_TR_11_12_mv_c_r
        struct[0].g[162,0] = i_TR_13_mv_a_r + 1.1703045997087*v_TR_13_lv_a_i + 0.195050766618117*v_TR_13_lv_a_r - 1.1703045997087*v_TR_13_lv_b_i - 0.195050766618117*v_TR_13_lv_b_r - 6.62789031305749*v_TR_13_mv_a_i - 8.9749399223794*v_TR_13_mv_a_r + 1.89949032909103*v_TR_13_mv_b_i + 2.56523380021651*v_TR_13_mv_b_r + 1.89949032909103*v_TR_13_mv_c_i + 2.56523380021651*v_TR_13_mv_c_r + 6.60088643956832*v_TR_7_8_mv_a_i + 8.97043541787489*v_TR_7_8_mv_a_r - 1.88596755416238*v_TR_7_8_mv_b_i - 2.56298154796426*v_TR_7_8_mv_b_r - 1.88596755416237*v_TR_7_8_mv_c_i - 2.56298154796426*v_TR_7_8_mv_c_r
        struct[0].g[163,0] = i_TR_13_mv_a_i + 0.195050766618117*v_TR_13_lv_a_i - 1.1703045997087*v_TR_13_lv_a_r - 0.195050766618117*v_TR_13_lv_b_i + 1.1703045997087*v_TR_13_lv_b_r - 8.9749399223794*v_TR_13_mv_a_i + 6.62789031305749*v_TR_13_mv_a_r + 2.56523380021651*v_TR_13_mv_b_i - 1.89949032909103*v_TR_13_mv_b_r + 2.56523380021651*v_TR_13_mv_c_i - 1.89949032909103*v_TR_13_mv_c_r + 8.97043541787489*v_TR_7_8_mv_a_i - 6.60088643956832*v_TR_7_8_mv_a_r - 2.56298154796426*v_TR_7_8_mv_b_i + 1.88596755416238*v_TR_7_8_mv_b_r - 2.56298154796426*v_TR_7_8_mv_c_i + 1.88596755416237*v_TR_7_8_mv_c_r
        struct[0].g[164,0] = i_TR_13_mv_b_r + 1.1703045997087*v_TR_13_lv_b_i + 0.195050766618117*v_TR_13_lv_b_r - 1.1703045997087*v_TR_13_lv_c_i - 0.195050766618117*v_TR_13_lv_c_r + 1.89949032909103*v_TR_13_mv_a_i + 2.56523380021651*v_TR_13_mv_a_r - 6.62789031305749*v_TR_13_mv_b_i - 8.97493992237941*v_TR_13_mv_b_r + 1.89949032909103*v_TR_13_mv_c_i + 2.56523380021651*v_TR_13_mv_c_r - 1.88596755416238*v_TR_7_8_mv_a_i - 2.56298154796426*v_TR_7_8_mv_a_r + 6.60088643956832*v_TR_7_8_mv_b_i + 8.9704354178749*v_TR_7_8_mv_b_r - 1.88596755416237*v_TR_7_8_mv_c_i - 2.56298154796426*v_TR_7_8_mv_c_r
        struct[0].g[165,0] = i_TR_13_mv_b_i + 0.195050766618117*v_TR_13_lv_b_i - 1.1703045997087*v_TR_13_lv_b_r - 0.195050766618117*v_TR_13_lv_c_i + 1.1703045997087*v_TR_13_lv_c_r + 2.56523380021651*v_TR_13_mv_a_i - 1.89949032909103*v_TR_13_mv_a_r - 8.97493992237941*v_TR_13_mv_b_i + 6.62789031305749*v_TR_13_mv_b_r + 2.56523380021651*v_TR_13_mv_c_i - 1.89949032909103*v_TR_13_mv_c_r - 2.56298154796426*v_TR_7_8_mv_a_i + 1.88596755416238*v_TR_7_8_mv_a_r + 8.9704354178749*v_TR_7_8_mv_b_i - 6.60088643956832*v_TR_7_8_mv_b_r - 2.56298154796426*v_TR_7_8_mv_c_i + 1.88596755416237*v_TR_7_8_mv_c_r
        struct[0].g[166,0] = i_TR_13_mv_c_r - 1.1703045997087*v_TR_13_lv_a_i - 0.195050766618117*v_TR_13_lv_a_r + 1.1703045997087*v_TR_13_lv_c_i + 0.195050766618117*v_TR_13_lv_c_r + 1.89949032909103*v_TR_13_mv_a_i + 2.56523380021651*v_TR_13_mv_a_r + 1.89949032909103*v_TR_13_mv_b_i + 2.56523380021651*v_TR_13_mv_b_r - 6.62789031305748*v_TR_13_mv_c_i - 8.9749399223794*v_TR_13_mv_c_r - 1.88596755416237*v_TR_7_8_mv_a_i - 2.56298154796426*v_TR_7_8_mv_a_r - 1.88596755416237*v_TR_7_8_mv_b_i - 2.56298154796426*v_TR_7_8_mv_b_r + 6.60088643956831*v_TR_7_8_mv_c_i + 8.9704354178749*v_TR_7_8_mv_c_r
        struct[0].g[167,0] = i_TR_13_mv_c_i - 0.195050766618117*v_TR_13_lv_a_i + 1.1703045997087*v_TR_13_lv_a_r + 0.195050766618117*v_TR_13_lv_c_i - 1.1703045997087*v_TR_13_lv_c_r + 2.56523380021651*v_TR_13_mv_a_i - 1.89949032909103*v_TR_13_mv_a_r + 2.56523380021651*v_TR_13_mv_b_i - 1.89949032909103*v_TR_13_mv_b_r - 8.9749399223794*v_TR_13_mv_c_i + 6.62789031305748*v_TR_13_mv_c_r - 2.56298154796426*v_TR_7_8_mv_a_i + 1.88596755416237*v_TR_7_8_mv_a_r - 2.56298154796426*v_TR_7_8_mv_b_i + 1.88596755416237*v_TR_7_8_mv_b_r + 8.9704354178749*v_TR_7_8_mv_c_i - 6.60088643956831*v_TR_7_8_mv_c_r
        struct[0].g[168,0] = i_TR_13_lv_a_r + 225.774979236273*v_INV_13_a_i + 435.745709926008*v_INV_13_a_r - 64.5071369246495*v_INV_13_b_i - 124.498774264574*v_INV_13_b_r - 64.5071369246495*v_INV_13_c_i - 124.498774264574*v_INV_13_c_r - 327.126282868141*v_TR_13_lv_a_i - 452.6376018179*v_TR_13_lv_a_r + 64.5071560124429*v_TR_13_lv_b_i + 124.498774264574*v_TR_13_lv_b_r + 64.5071560124428*v_TR_13_lv_c_i + 124.498774264574*v_TR_13_lv_c_r + 1.1703045997087*v_TR_13_mv_a_i + 0.195050766618117*v_TR_13_mv_a_r - 1.1703045997087*v_TR_13_mv_c_i - 0.195050766618117*v_TR_13_mv_c_r
        struct[0].g[169,0] = i_TR_13_lv_a_i + 435.745709926008*v_INV_13_a_i - 225.774979236273*v_INV_13_a_r - 124.498774264574*v_INV_13_b_i + 64.5071369246495*v_INV_13_b_r - 124.498774264574*v_INV_13_c_i + 64.5071369246495*v_INV_13_c_r - 452.6376018179*v_TR_13_lv_a_i + 327.126282868141*v_TR_13_lv_a_r + 124.498774264574*v_TR_13_lv_b_i - 64.5071560124429*v_TR_13_lv_b_r + 124.498774264574*v_TR_13_lv_c_i - 64.5071560124428*v_TR_13_lv_c_r + 0.195050766618117*v_TR_13_mv_a_i - 1.1703045997087*v_TR_13_mv_a_r - 0.195050766618117*v_TR_13_mv_c_i + 1.1703045997087*v_TR_13_mv_c_r
        struct[0].g[170,0] = i_TR_13_lv_b_r - 64.5071369246495*v_INV_13_a_i - 124.498774264574*v_INV_13_a_r + 225.774979236273*v_INV_13_b_i + 435.745709926008*v_INV_13_b_r - 64.5071369246494*v_INV_13_c_i - 124.498774264574*v_INV_13_c_r + 64.5071560124428*v_TR_13_lv_a_i + 124.498774264574*v_TR_13_lv_a_r - 327.126282868141*v_TR_13_lv_b_i - 452.6376018179*v_TR_13_lv_b_r + 64.5071560124428*v_TR_13_lv_c_i + 124.498774264574*v_TR_13_lv_c_r - 1.1703045997087*v_TR_13_mv_a_i - 0.195050766618117*v_TR_13_mv_a_r + 1.1703045997087*v_TR_13_mv_b_i + 0.195050766618117*v_TR_13_mv_b_r
        struct[0].g[171,0] = i_TR_13_lv_b_i - 124.498774264574*v_INV_13_a_i + 64.5071369246495*v_INV_13_a_r + 435.745709926008*v_INV_13_b_i - 225.774979236273*v_INV_13_b_r - 124.498774264574*v_INV_13_c_i + 64.5071369246494*v_INV_13_c_r + 124.498774264574*v_TR_13_lv_a_i - 64.5071560124428*v_TR_13_lv_a_r - 452.6376018179*v_TR_13_lv_b_i + 327.126282868141*v_TR_13_lv_b_r + 124.498774264574*v_TR_13_lv_c_i - 64.5071560124428*v_TR_13_lv_c_r - 0.195050766618117*v_TR_13_mv_a_i + 1.1703045997087*v_TR_13_mv_a_r + 0.195050766618117*v_TR_13_mv_b_i - 1.1703045997087*v_TR_13_mv_b_r
        struct[0].g[172,0] = i_TR_13_lv_c_r - 64.5071369246495*v_INV_13_a_i - 124.498774264574*v_INV_13_a_r - 64.5071369246494*v_INV_13_b_i - 124.498774264574*v_INV_13_b_r + 225.774979236273*v_INV_13_c_i + 435.745709926008*v_INV_13_c_r + 64.5071560124429*v_TR_13_lv_a_i + 124.498774264574*v_TR_13_lv_a_r + 64.5071560124428*v_TR_13_lv_b_i + 124.498774264574*v_TR_13_lv_b_r - 327.126282868141*v_TR_13_lv_c_i - 452.6376018179*v_TR_13_lv_c_r - 1.1703045997087*v_TR_13_mv_b_i - 0.195050766618117*v_TR_13_mv_b_r + 1.1703045997087*v_TR_13_mv_c_i + 0.195050766618117*v_TR_13_mv_c_r
        struct[0].g[173,0] = i_TR_13_lv_c_i - 124.498774264574*v_INV_13_a_i + 64.5071369246495*v_INV_13_a_r - 124.498774264574*v_INV_13_b_i + 64.5071369246494*v_INV_13_b_r + 435.745709926008*v_INV_13_c_i - 225.774979236273*v_INV_13_c_r + 124.498774264574*v_TR_13_lv_a_i - 64.5071560124429*v_TR_13_lv_a_r + 124.498774264574*v_TR_13_lv_b_i - 64.5071560124428*v_TR_13_lv_b_r - 452.6376018179*v_TR_13_lv_c_i + 327.126282868141*v_TR_13_lv_c_r - 0.195050766618117*v_TR_13_mv_b_i + 1.1703045997087*v_TR_13_mv_b_r + 0.195050766618117*v_TR_13_mv_c_i - 1.1703045997087*v_TR_13_mv_c_r
        struct[0].g[174,0] = i_INV_1_a_i*v_INV_1_a_i + i_INV_1_a_r*v_INV_1_a_r - p_INV_1_a
        struct[0].g[175,0] = i_INV_1_b_i*v_INV_1_b_i + i_INV_1_b_r*v_INV_1_b_r - p_INV_1_b
        struct[0].g[176,0] = i_INV_1_c_i*v_INV_1_c_i + i_INV_1_c_r*v_INV_1_c_r - p_INV_1_c
        struct[0].g[177,0] = -i_INV_1_a_i*v_INV_1_a_r + i_INV_1_a_r*v_INV_1_a_i - q_INV_1_a
        struct[0].g[178,0] = -i_INV_1_b_i*v_INV_1_b_r + i_INV_1_b_r*v_INV_1_b_i - q_INV_1_b
        struct[0].g[179,0] = -i_INV_1_c_i*v_INV_1_c_r + i_INV_1_c_r*v_INV_1_c_i - q_INV_1_c
        struct[0].g[180,0] = -v_m_INV_1 + (v_INV_1_a_i**2 + v_INV_1_a_r**2)**0.5/V_base_INV_1
        struct[0].g[181,0] = -v_m_TR_1_2_mv + (v_TR_1_2_mv_a_i**2 + v_TR_1_2_mv_a_r**2)**0.5/V_base_TR_1_2_mv
        struct[0].g[182,0] = Dq_r_INV_1 + K_p_v_INV_1*(Dv_r_INV_1 - u_ctrl_v_INV_1*v_m_TR_1_2_mv + v_loc_ref_INV_1 - v_m_INV_1*(1.0 - u_ctrl_v_INV_1)) - i_reac_ref_INV_1
        struct[0].g[183,0] = S_base_INV_1*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_1, I_max_INV_1 < -i_reac_ref_INV_1), (I_max_INV_1, I_max_INV_1 < i_reac_ref_INV_1), (i_reac_ref_INV_1, True)])) - q_ref_INV_1
        struct[0].g[184,0] = i_INV_2_a_i*v_INV_2_a_i + i_INV_2_a_r*v_INV_2_a_r - p_INV_2_a
        struct[0].g[185,0] = i_INV_2_b_i*v_INV_2_b_i + i_INV_2_b_r*v_INV_2_b_r - p_INV_2_b
        struct[0].g[186,0] = i_INV_2_c_i*v_INV_2_c_i + i_INV_2_c_r*v_INV_2_c_r - p_INV_2_c
        struct[0].g[187,0] = -i_INV_2_a_i*v_INV_2_a_r + i_INV_2_a_r*v_INV_2_a_i - q_INV_2_a
        struct[0].g[188,0] = -i_INV_2_b_i*v_INV_2_b_r + i_INV_2_b_r*v_INV_2_b_i - q_INV_2_b
        struct[0].g[189,0] = -i_INV_2_c_i*v_INV_2_c_r + i_INV_2_c_r*v_INV_2_c_i - q_INV_2_c
        struct[0].g[190,0] = -v_m_INV_2 + (v_INV_2_a_i**2 + v_INV_2_a_r**2)**0.5/V_base_INV_2
        struct[0].g[191,0] = Dq_r_INV_2 + K_p_v_INV_2*(Dv_r_INV_2 - u_ctrl_v_INV_2*v_m_TR_1_2_mv + v_loc_ref_INV_2 - v_m_INV_2*(1.0 - u_ctrl_v_INV_2)) - i_reac_ref_INV_2
        struct[0].g[192,0] = S_base_INV_2*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_2, I_max_INV_2 < -i_reac_ref_INV_2), (I_max_INV_2, I_max_INV_2 < i_reac_ref_INV_2), (i_reac_ref_INV_2, True)])) - q_ref_INV_2
        struct[0].g[193,0] = i_INV_3_a_i*v_INV_3_a_i + i_INV_3_a_r*v_INV_3_a_r - p_INV_3_a
        struct[0].g[194,0] = i_INV_3_b_i*v_INV_3_b_i + i_INV_3_b_r*v_INV_3_b_r - p_INV_3_b
        struct[0].g[195,0] = i_INV_3_c_i*v_INV_3_c_i + i_INV_3_c_r*v_INV_3_c_r - p_INV_3_c
        struct[0].g[196,0] = -i_INV_3_a_i*v_INV_3_a_r + i_INV_3_a_r*v_INV_3_a_i - q_INV_3_a
        struct[0].g[197,0] = -i_INV_3_b_i*v_INV_3_b_r + i_INV_3_b_r*v_INV_3_b_i - q_INV_3_b
        struct[0].g[198,0] = -i_INV_3_c_i*v_INV_3_c_r + i_INV_3_c_r*v_INV_3_c_i - q_INV_3_c
        struct[0].g[199,0] = -v_m_INV_3 + (v_INV_3_a_i**2 + v_INV_3_a_r**2)**0.5/V_base_INV_3
        struct[0].g[200,0] = -v_m_TR_3_4_mv + (v_TR_3_4_mv_a_i**2 + v_TR_3_4_mv_a_r**2)**0.5/V_base_TR_3_4_mv
        struct[0].g[201,0] = Dq_r_INV_3 + K_p_v_INV_3*(Dv_r_INV_3 - u_ctrl_v_INV_3*v_m_TR_3_4_mv + v_loc_ref_INV_3 - v_m_INV_3*(1.0 - u_ctrl_v_INV_3)) - i_reac_ref_INV_3
        struct[0].g[202,0] = S_base_INV_3*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_3, I_max_INV_3 < -i_reac_ref_INV_3), (I_max_INV_3, I_max_INV_3 < i_reac_ref_INV_3), (i_reac_ref_INV_3, True)])) - q_ref_INV_3
        struct[0].g[203,0] = i_INV_4_a_i*v_INV_4_a_i + i_INV_4_a_r*v_INV_4_a_r - p_INV_4_a
        struct[0].g[204,0] = i_INV_4_b_i*v_INV_4_b_i + i_INV_4_b_r*v_INV_4_b_r - p_INV_4_b
        struct[0].g[205,0] = i_INV_4_c_i*v_INV_4_c_i + i_INV_4_c_r*v_INV_4_c_r - p_INV_4_c
        struct[0].g[206,0] = -i_INV_4_a_i*v_INV_4_a_r + i_INV_4_a_r*v_INV_4_a_i - q_INV_4_a
        struct[0].g[207,0] = -i_INV_4_b_i*v_INV_4_b_r + i_INV_4_b_r*v_INV_4_b_i - q_INV_4_b
        struct[0].g[208,0] = -i_INV_4_c_i*v_INV_4_c_r + i_INV_4_c_r*v_INV_4_c_i - q_INV_4_c
        struct[0].g[209,0] = -v_m_INV_4 + (v_INV_4_a_i**2 + v_INV_4_a_r**2)**0.5/V_base_INV_4
        struct[0].g[210,0] = Dq_r_INV_4 + K_p_v_INV_4*(Dv_r_INV_4 - u_ctrl_v_INV_4*v_m_TR_3_4_mv + v_loc_ref_INV_4 - v_m_INV_4*(1.0 - u_ctrl_v_INV_4)) - i_reac_ref_INV_4
        struct[0].g[211,0] = S_base_INV_4*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_4, I_max_INV_4 < -i_reac_ref_INV_4), (I_max_INV_4, I_max_INV_4 < i_reac_ref_INV_4), (i_reac_ref_INV_4, True)])) - q_ref_INV_4
        struct[0].g[212,0] = i_INV_5_a_i*v_INV_5_a_i + i_INV_5_a_r*v_INV_5_a_r - p_INV_5_a
        struct[0].g[213,0] = i_INV_5_b_i*v_INV_5_b_i + i_INV_5_b_r*v_INV_5_b_r - p_INV_5_b
        struct[0].g[214,0] = i_INV_5_c_i*v_INV_5_c_i + i_INV_5_c_r*v_INV_5_c_r - p_INV_5_c
        struct[0].g[215,0] = -i_INV_5_a_i*v_INV_5_a_r + i_INV_5_a_r*v_INV_5_a_i - q_INV_5_a
        struct[0].g[216,0] = -i_INV_5_b_i*v_INV_5_b_r + i_INV_5_b_r*v_INV_5_b_i - q_INV_5_b
        struct[0].g[217,0] = -i_INV_5_c_i*v_INV_5_c_r + i_INV_5_c_r*v_INV_5_c_i - q_INV_5_c
        struct[0].g[218,0] = -v_m_INV_5 + (v_INV_5_a_i**2 + v_INV_5_a_r**2)**0.5/V_base_INV_5
        struct[0].g[219,0] = -v_m_TR_5_6_mv + (v_TR_5_6_mv_a_i**2 + v_TR_5_6_mv_a_r**2)**0.5/V_base_TR_5_6_mv
        struct[0].g[220,0] = Dq_r_INV_5 + K_p_v_INV_5*(Dv_r_INV_5 - u_ctrl_v_INV_5*v_m_TR_5_6_mv + v_loc_ref_INV_5 - v_m_INV_5*(1.0 - u_ctrl_v_INV_5)) - i_reac_ref_INV_5
        struct[0].g[221,0] = S_base_INV_5*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_5, I_max_INV_5 < -i_reac_ref_INV_5), (I_max_INV_5, I_max_INV_5 < i_reac_ref_INV_5), (i_reac_ref_INV_5, True)])) - q_ref_INV_5
        struct[0].g[222,0] = i_INV_6_a_i*v_INV_6_a_i + i_INV_6_a_r*v_INV_6_a_r - p_INV_6_a
        struct[0].g[223,0] = i_INV_6_b_i*v_INV_6_b_i + i_INV_6_b_r*v_INV_6_b_r - p_INV_6_b
        struct[0].g[224,0] = i_INV_6_c_i*v_INV_6_c_i + i_INV_6_c_r*v_INV_6_c_r - p_INV_6_c
        struct[0].g[225,0] = -i_INV_6_a_i*v_INV_6_a_r + i_INV_6_a_r*v_INV_6_a_i - q_INV_6_a
        struct[0].g[226,0] = -i_INV_6_b_i*v_INV_6_b_r + i_INV_6_b_r*v_INV_6_b_i - q_INV_6_b
        struct[0].g[227,0] = -i_INV_6_c_i*v_INV_6_c_r + i_INV_6_c_r*v_INV_6_c_i - q_INV_6_c
        struct[0].g[228,0] = -v_m_INV_6 + (v_INV_6_a_i**2 + v_INV_6_a_r**2)**0.5/V_base_INV_6
        struct[0].g[229,0] = Dq_r_INV_6 + K_p_v_INV_6*(Dv_r_INV_6 - u_ctrl_v_INV_6*v_m_TR_5_6_mv + v_loc_ref_INV_6 - v_m_INV_6*(1.0 - u_ctrl_v_INV_6)) - i_reac_ref_INV_6
        struct[0].g[230,0] = S_base_INV_6*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_6, I_max_INV_6 < -i_reac_ref_INV_6), (I_max_INV_6, I_max_INV_6 < i_reac_ref_INV_6), (i_reac_ref_INV_6, True)])) - q_ref_INV_6
        struct[0].g[231,0] = i_INV_7_a_i*v_INV_7_a_i + i_INV_7_a_r*v_INV_7_a_r - p_INV_7_a
        struct[0].g[232,0] = i_INV_7_b_i*v_INV_7_b_i + i_INV_7_b_r*v_INV_7_b_r - p_INV_7_b
        struct[0].g[233,0] = i_INV_7_c_i*v_INV_7_c_i + i_INV_7_c_r*v_INV_7_c_r - p_INV_7_c
        struct[0].g[234,0] = -i_INV_7_a_i*v_INV_7_a_r + i_INV_7_a_r*v_INV_7_a_i - q_INV_7_a
        struct[0].g[235,0] = -i_INV_7_b_i*v_INV_7_b_r + i_INV_7_b_r*v_INV_7_b_i - q_INV_7_b
        struct[0].g[236,0] = -i_INV_7_c_i*v_INV_7_c_r + i_INV_7_c_r*v_INV_7_c_i - q_INV_7_c
        struct[0].g[237,0] = -v_m_INV_7 + (v_INV_7_a_i**2 + v_INV_7_a_r**2)**0.5/V_base_INV_7
        struct[0].g[238,0] = -v_m_TR_7_8_mv + (v_TR_7_8_mv_a_i**2 + v_TR_7_8_mv_a_r**2)**0.5/V_base_TR_7_8_mv
        struct[0].g[239,0] = Dq_r_INV_7 + K_p_v_INV_7*(Dv_r_INV_7 - u_ctrl_v_INV_7*v_m_TR_7_8_mv + v_loc_ref_INV_7 - v_m_INV_7*(1.0 - u_ctrl_v_INV_7)) - i_reac_ref_INV_7
        struct[0].g[240,0] = S_base_INV_7*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_7, I_max_INV_7 < -i_reac_ref_INV_7), (I_max_INV_7, I_max_INV_7 < i_reac_ref_INV_7), (i_reac_ref_INV_7, True)])) - q_ref_INV_7
        struct[0].g[241,0] = i_INV_8_a_i*v_INV_8_a_i + i_INV_8_a_r*v_INV_8_a_r - p_INV_8_a
        struct[0].g[242,0] = i_INV_8_b_i*v_INV_8_b_i + i_INV_8_b_r*v_INV_8_b_r - p_INV_8_b
        struct[0].g[243,0] = i_INV_8_c_i*v_INV_8_c_i + i_INV_8_c_r*v_INV_8_c_r - p_INV_8_c
        struct[0].g[244,0] = -i_INV_8_a_i*v_INV_8_a_r + i_INV_8_a_r*v_INV_8_a_i - q_INV_8_a
        struct[0].g[245,0] = -i_INV_8_b_i*v_INV_8_b_r + i_INV_8_b_r*v_INV_8_b_i - q_INV_8_b
        struct[0].g[246,0] = -i_INV_8_c_i*v_INV_8_c_r + i_INV_8_c_r*v_INV_8_c_i - q_INV_8_c
        struct[0].g[247,0] = -v_m_INV_8 + (v_INV_8_a_i**2 + v_INV_8_a_r**2)**0.5/V_base_INV_8
        struct[0].g[248,0] = Dq_r_INV_8 + K_p_v_INV_8*(Dv_r_INV_8 - u_ctrl_v_INV_8*v_m_TR_7_8_mv + v_loc_ref_INV_8 - v_m_INV_8*(1.0 - u_ctrl_v_INV_8)) - i_reac_ref_INV_8
        struct[0].g[249,0] = S_base_INV_8*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_8, I_max_INV_8 < -i_reac_ref_INV_8), (I_max_INV_8, I_max_INV_8 < i_reac_ref_INV_8), (i_reac_ref_INV_8, True)])) - q_ref_INV_8
        struct[0].g[250,0] = i_INV_9_a_i*v_INV_9_a_i + i_INV_9_a_r*v_INV_9_a_r - p_INV_9_a
        struct[0].g[251,0] = i_INV_9_b_i*v_INV_9_b_i + i_INV_9_b_r*v_INV_9_b_r - p_INV_9_b
        struct[0].g[252,0] = i_INV_9_c_i*v_INV_9_c_i + i_INV_9_c_r*v_INV_9_c_r - p_INV_9_c
        struct[0].g[253,0] = -i_INV_9_a_i*v_INV_9_a_r + i_INV_9_a_r*v_INV_9_a_i - q_INV_9_a
        struct[0].g[254,0] = -i_INV_9_b_i*v_INV_9_b_r + i_INV_9_b_r*v_INV_9_b_i - q_INV_9_b
        struct[0].g[255,0] = -i_INV_9_c_i*v_INV_9_c_r + i_INV_9_c_r*v_INV_9_c_i - q_INV_9_c
        struct[0].g[256,0] = -v_m_INV_9 + (v_INV_9_a_i**2 + v_INV_9_a_r**2)**0.5/V_base_INV_9
        struct[0].g[257,0] = -v_m_TR_9_10_mv + (v_TR_9_10_mv_a_i**2 + v_TR_9_10_mv_a_r**2)**0.5/V_base_TR_9_10_mv
        struct[0].g[258,0] = Dq_r_INV_9 + K_p_v_INV_9*(Dv_r_INV_9 - u_ctrl_v_INV_9*v_m_TR_9_10_mv + v_loc_ref_INV_9 - v_m_INV_9*(1.0 - u_ctrl_v_INV_9)) - i_reac_ref_INV_9
        struct[0].g[259,0] = S_base_INV_9*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_9, I_max_INV_9 < -i_reac_ref_INV_9), (I_max_INV_9, I_max_INV_9 < i_reac_ref_INV_9), (i_reac_ref_INV_9, True)])) - q_ref_INV_9
        struct[0].g[260,0] = i_INV_10_a_i*v_INV_10_a_i + i_INV_10_a_r*v_INV_10_a_r - p_INV_10_a
        struct[0].g[261,0] = i_INV_10_b_i*v_INV_10_b_i + i_INV_10_b_r*v_INV_10_b_r - p_INV_10_b
        struct[0].g[262,0] = i_INV_10_c_i*v_INV_10_c_i + i_INV_10_c_r*v_INV_10_c_r - p_INV_10_c
        struct[0].g[263,0] = -i_INV_10_a_i*v_INV_10_a_r + i_INV_10_a_r*v_INV_10_a_i - q_INV_10_a
        struct[0].g[264,0] = -i_INV_10_b_i*v_INV_10_b_r + i_INV_10_b_r*v_INV_10_b_i - q_INV_10_b
        struct[0].g[265,0] = -i_INV_10_c_i*v_INV_10_c_r + i_INV_10_c_r*v_INV_10_c_i - q_INV_10_c
        struct[0].g[266,0] = -v_m_INV_10 + (v_INV_10_a_i**2 + v_INV_10_a_r**2)**0.5/V_base_INV_10
        struct[0].g[267,0] = Dq_r_INV_10 + K_p_v_INV_10*(Dv_r_INV_10 - u_ctrl_v_INV_10*v_m_TR_9_10_mv + v_loc_ref_INV_10 - v_m_INV_10*(1.0 - u_ctrl_v_INV_10)) - i_reac_ref_INV_10
        struct[0].g[268,0] = S_base_INV_10*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_10, I_max_INV_10 < -i_reac_ref_INV_10), (I_max_INV_10, I_max_INV_10 < i_reac_ref_INV_10), (i_reac_ref_INV_10, True)])) - q_ref_INV_10
        struct[0].g[269,0] = i_INV_11_a_i*v_INV_11_a_i + i_INV_11_a_r*v_INV_11_a_r - p_INV_11_a
        struct[0].g[270,0] = i_INV_11_b_i*v_INV_11_b_i + i_INV_11_b_r*v_INV_11_b_r - p_INV_11_b
        struct[0].g[271,0] = i_INV_11_c_i*v_INV_11_c_i + i_INV_11_c_r*v_INV_11_c_r - p_INV_11_c
        struct[0].g[272,0] = -i_INV_11_a_i*v_INV_11_a_r + i_INV_11_a_r*v_INV_11_a_i - q_INV_11_a
        struct[0].g[273,0] = -i_INV_11_b_i*v_INV_11_b_r + i_INV_11_b_r*v_INV_11_b_i - q_INV_11_b
        struct[0].g[274,0] = -i_INV_11_c_i*v_INV_11_c_r + i_INV_11_c_r*v_INV_11_c_i - q_INV_11_c
        struct[0].g[275,0] = -v_m_INV_11 + (v_INV_11_a_i**2 + v_INV_11_a_r**2)**0.5/V_base_INV_11
        struct[0].g[276,0] = -v_m_TR_11_12_mv + (v_TR_11_12_mv_a_i**2 + v_TR_11_12_mv_a_r**2)**0.5/V_base_TR_11_12_mv
        struct[0].g[277,0] = Dq_r_INV_11 + K_p_v_INV_11*(Dv_r_INV_11 - u_ctrl_v_INV_11*v_m_TR_11_12_mv + v_loc_ref_INV_11 - v_m_INV_11*(1.0 - u_ctrl_v_INV_11)) - i_reac_ref_INV_11
        struct[0].g[278,0] = S_base_INV_11*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_11, I_max_INV_11 < -i_reac_ref_INV_11), (I_max_INV_11, I_max_INV_11 < i_reac_ref_INV_11), (i_reac_ref_INV_11, True)])) - q_ref_INV_11
        struct[0].g[279,0] = i_INV_12_a_i*v_INV_12_a_i + i_INV_12_a_r*v_INV_12_a_r - p_INV_12_a
        struct[0].g[280,0] = i_INV_12_b_i*v_INV_12_b_i + i_INV_12_b_r*v_INV_12_b_r - p_INV_12_b
        struct[0].g[281,0] = i_INV_12_c_i*v_INV_12_c_i + i_INV_12_c_r*v_INV_12_c_r - p_INV_12_c
        struct[0].g[282,0] = -i_INV_12_a_i*v_INV_12_a_r + i_INV_12_a_r*v_INV_12_a_i - q_INV_12_a
        struct[0].g[283,0] = -i_INV_12_b_i*v_INV_12_b_r + i_INV_12_b_r*v_INV_12_b_i - q_INV_12_b
        struct[0].g[284,0] = -i_INV_12_c_i*v_INV_12_c_r + i_INV_12_c_r*v_INV_12_c_i - q_INV_12_c
        struct[0].g[285,0] = -v_m_INV_12 + (v_INV_12_a_i**2 + v_INV_12_a_r**2)**0.5/V_base_INV_12
        struct[0].g[286,0] = Dq_r_INV_12 + K_p_v_INV_12*(Dv_r_INV_12 - u_ctrl_v_INV_12*v_m_TR_11_12_mv + v_loc_ref_INV_12 - v_m_INV_12*(1.0 - u_ctrl_v_INV_12)) - i_reac_ref_INV_12
        struct[0].g[287,0] = S_base_INV_12*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_12, I_max_INV_12 < -i_reac_ref_INV_12), (I_max_INV_12, I_max_INV_12 < i_reac_ref_INV_12), (i_reac_ref_INV_12, True)])) - q_ref_INV_12
        struct[0].g[288,0] = i_INV_13_a_i*v_INV_13_a_i + i_INV_13_a_r*v_INV_13_a_r - p_INV_13_a
        struct[0].g[289,0] = i_INV_13_b_i*v_INV_13_b_i + i_INV_13_b_r*v_INV_13_b_r - p_INV_13_b
        struct[0].g[290,0] = i_INV_13_c_i*v_INV_13_c_i + i_INV_13_c_r*v_INV_13_c_r - p_INV_13_c
        struct[0].g[291,0] = -i_INV_13_a_i*v_INV_13_a_r + i_INV_13_a_r*v_INV_13_a_i - q_INV_13_a
        struct[0].g[292,0] = -i_INV_13_b_i*v_INV_13_b_r + i_INV_13_b_r*v_INV_13_b_i - q_INV_13_b
        struct[0].g[293,0] = -i_INV_13_c_i*v_INV_13_c_r + i_INV_13_c_r*v_INV_13_c_i - q_INV_13_c
        struct[0].g[294,0] = -v_m_INV_13 + (v_INV_13_a_i**2 + v_INV_13_a_r**2)**0.5/V_base_INV_13
        struct[0].g[295,0] = -v_m_TR_13_mv + (v_TR_13_mv_a_i**2 + v_TR_13_mv_a_r**2)**0.5/V_base_TR_13_mv
        struct[0].g[296,0] = Dq_r_INV_13 + K_p_v_INV_13*(Dv_r_INV_13 - u_ctrl_v_INV_13*v_m_TR_13_mv + v_loc_ref_INV_13 - v_m_INV_13*(1.0 - u_ctrl_v_INV_13)) - i_reac_ref_INV_13
        struct[0].g[297,0] = S_base_INV_13*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_13, I_max_INV_13 < -i_reac_ref_INV_13), (I_max_INV_13, I_max_INV_13 < i_reac_ref_INV_13), (i_reac_ref_INV_13, True)])) - q_ref_INV_13
    
    # Outputs:
    if mode == 3:

    
        pass

    if mode == 10:

        struct[0].Fx_ini[0,0] = -1/T_pq_INV_1
        struct[0].Fx_ini[1,1] = -1/T_pq_INV_1
        struct[0].Fx_ini[2,2] = -1/T_pq_INV_1
        struct[0].Fx_ini[3,3] = -1/T_pq_INV_1
        struct[0].Fx_ini[4,4] = -1/T_pq_INV_1
        struct[0].Fx_ini[5,5] = -1/T_pq_INV_1
        struct[0].Fx_ini[6,6] = -1/T_pq_INV_2
        struct[0].Fx_ini[7,7] = -1/T_pq_INV_2
        struct[0].Fx_ini[8,8] = -1/T_pq_INV_2
        struct[0].Fx_ini[9,9] = -1/T_pq_INV_2
        struct[0].Fx_ini[10,10] = -1/T_pq_INV_2
        struct[0].Fx_ini[11,11] = -1/T_pq_INV_2
        struct[0].Fx_ini[12,12] = -1/T_pq_INV_3
        struct[0].Fx_ini[13,13] = -1/T_pq_INV_3
        struct[0].Fx_ini[14,14] = -1/T_pq_INV_3
        struct[0].Fx_ini[15,15] = -1/T_pq_INV_3
        struct[0].Fx_ini[16,16] = -1/T_pq_INV_3
        struct[0].Fx_ini[17,17] = -1/T_pq_INV_3
        struct[0].Fx_ini[18,18] = -1/T_pq_INV_4
        struct[0].Fx_ini[19,19] = -1/T_pq_INV_4
        struct[0].Fx_ini[20,20] = -1/T_pq_INV_4
        struct[0].Fx_ini[21,21] = -1/T_pq_INV_4
        struct[0].Fx_ini[22,22] = -1/T_pq_INV_4
        struct[0].Fx_ini[23,23] = -1/T_pq_INV_4
        struct[0].Fx_ini[24,24] = -1/T_pq_INV_5
        struct[0].Fx_ini[25,25] = -1/T_pq_INV_5
        struct[0].Fx_ini[26,26] = -1/T_pq_INV_5
        struct[0].Fx_ini[27,27] = -1/T_pq_INV_5
        struct[0].Fx_ini[28,28] = -1/T_pq_INV_5
        struct[0].Fx_ini[29,29] = -1/T_pq_INV_5
        struct[0].Fx_ini[30,30] = -1/T_pq_INV_6
        struct[0].Fx_ini[31,31] = -1/T_pq_INV_6
        struct[0].Fx_ini[32,32] = -1/T_pq_INV_6
        struct[0].Fx_ini[33,33] = -1/T_pq_INV_6
        struct[0].Fx_ini[34,34] = -1/T_pq_INV_6
        struct[0].Fx_ini[35,35] = -1/T_pq_INV_6
        struct[0].Fx_ini[36,36] = -1/T_pq_INV_7
        struct[0].Fx_ini[37,37] = -1/T_pq_INV_7
        struct[0].Fx_ini[38,38] = -1/T_pq_INV_7
        struct[0].Fx_ini[39,39] = -1/T_pq_INV_7
        struct[0].Fx_ini[40,40] = -1/T_pq_INV_7
        struct[0].Fx_ini[41,41] = -1/T_pq_INV_7
        struct[0].Fx_ini[42,42] = -1/T_pq_INV_8
        struct[0].Fx_ini[43,43] = -1/T_pq_INV_8
        struct[0].Fx_ini[44,44] = -1/T_pq_INV_8
        struct[0].Fx_ini[45,45] = -1/T_pq_INV_8
        struct[0].Fx_ini[46,46] = -1/T_pq_INV_8
        struct[0].Fx_ini[47,47] = -1/T_pq_INV_8
        struct[0].Fx_ini[48,48] = -1/T_pq_INV_9
        struct[0].Fx_ini[49,49] = -1/T_pq_INV_9
        struct[0].Fx_ini[50,50] = -1/T_pq_INV_9
        struct[0].Fx_ini[51,51] = -1/T_pq_INV_9
        struct[0].Fx_ini[52,52] = -1/T_pq_INV_9
        struct[0].Fx_ini[53,53] = -1/T_pq_INV_9
        struct[0].Fx_ini[54,54] = -1/T_pq_INV_10
        struct[0].Fx_ini[55,55] = -1/T_pq_INV_10
        struct[0].Fx_ini[56,56] = -1/T_pq_INV_10
        struct[0].Fx_ini[57,57] = -1/T_pq_INV_10
        struct[0].Fx_ini[58,58] = -1/T_pq_INV_10
        struct[0].Fx_ini[59,59] = -1/T_pq_INV_10
        struct[0].Fx_ini[60,60] = -1/T_pq_INV_11
        struct[0].Fx_ini[61,61] = -1/T_pq_INV_11
        struct[0].Fx_ini[62,62] = -1/T_pq_INV_11
        struct[0].Fx_ini[63,63] = -1/T_pq_INV_11
        struct[0].Fx_ini[64,64] = -1/T_pq_INV_11
        struct[0].Fx_ini[65,65] = -1/T_pq_INV_11
        struct[0].Fx_ini[66,66] = -1/T_pq_INV_12
        struct[0].Fx_ini[67,67] = -1/T_pq_INV_12
        struct[0].Fx_ini[68,68] = -1/T_pq_INV_12
        struct[0].Fx_ini[69,69] = -1/T_pq_INV_12
        struct[0].Fx_ini[70,70] = -1/T_pq_INV_12
        struct[0].Fx_ini[71,71] = -1/T_pq_INV_12
        struct[0].Fx_ini[72,72] = -1/T_pq_INV_13
        struct[0].Fx_ini[73,73] = -1/T_pq_INV_13
        struct[0].Fx_ini[74,74] = -1/T_pq_INV_13
        struct[0].Fx_ini[75,75] = -1/T_pq_INV_13
        struct[0].Fx_ini[76,76] = -1/T_pq_INV_13
        struct[0].Fx_ini[77,77] = -1/T_pq_INV_13

    if mode == 11:

        struct[0].Fy_ini[3,183] = 1/(3*T_pq_INV_1) 
        struct[0].Fy_ini[4,183] = 1/(3*T_pq_INV_1) 
        struct[0].Fy_ini[5,183] = 1/(3*T_pq_INV_1) 
        struct[0].Fy_ini[9,192] = 1/(3*T_pq_INV_2) 
        struct[0].Fy_ini[10,192] = 1/(3*T_pq_INV_2) 
        struct[0].Fy_ini[11,192] = 1/(3*T_pq_INV_2) 
        struct[0].Fy_ini[15,202] = 1/(3*T_pq_INV_3) 
        struct[0].Fy_ini[16,202] = 1/(3*T_pq_INV_3) 
        struct[0].Fy_ini[17,202] = 1/(3*T_pq_INV_3) 
        struct[0].Fy_ini[21,211] = 1/(3*T_pq_INV_4) 
        struct[0].Fy_ini[22,211] = 1/(3*T_pq_INV_4) 
        struct[0].Fy_ini[23,211] = 1/(3*T_pq_INV_4) 
        struct[0].Fy_ini[27,221] = 1/(3*T_pq_INV_5) 
        struct[0].Fy_ini[28,221] = 1/(3*T_pq_INV_5) 
        struct[0].Fy_ini[29,221] = 1/(3*T_pq_INV_5) 
        struct[0].Fy_ini[33,230] = 1/(3*T_pq_INV_6) 
        struct[0].Fy_ini[34,230] = 1/(3*T_pq_INV_6) 
        struct[0].Fy_ini[35,230] = 1/(3*T_pq_INV_6) 
        struct[0].Fy_ini[39,240] = 1/(3*T_pq_INV_7) 
        struct[0].Fy_ini[40,240] = 1/(3*T_pq_INV_7) 
        struct[0].Fy_ini[41,240] = 1/(3*T_pq_INV_7) 
        struct[0].Fy_ini[45,249] = 1/(3*T_pq_INV_8) 
        struct[0].Fy_ini[46,249] = 1/(3*T_pq_INV_8) 
        struct[0].Fy_ini[47,249] = 1/(3*T_pq_INV_8) 
        struct[0].Fy_ini[51,259] = 1/(3*T_pq_INV_9) 
        struct[0].Fy_ini[52,259] = 1/(3*T_pq_INV_9) 
        struct[0].Fy_ini[53,259] = 1/(3*T_pq_INV_9) 
        struct[0].Fy_ini[57,268] = 1/(3*T_pq_INV_10) 
        struct[0].Fy_ini[58,268] = 1/(3*T_pq_INV_10) 
        struct[0].Fy_ini[59,268] = 1/(3*T_pq_INV_10) 
        struct[0].Fy_ini[63,278] = 1/(3*T_pq_INV_11) 
        struct[0].Fy_ini[64,278] = 1/(3*T_pq_INV_11) 
        struct[0].Fy_ini[65,278] = 1/(3*T_pq_INV_11) 
        struct[0].Fy_ini[69,287] = 1/(3*T_pq_INV_12) 
        struct[0].Fy_ini[70,287] = 1/(3*T_pq_INV_12) 
        struct[0].Fy_ini[71,287] = 1/(3*T_pq_INV_12) 
        struct[0].Fy_ini[75,297] = 1/(3*T_pq_INV_13) 
        struct[0].Fy_ini[76,297] = 1/(3*T_pq_INV_13) 
        struct[0].Fy_ini[77,297] = 1/(3*T_pq_INV_13) 

        struct[0].Gy_ini[0,0] = -172.823911824540
        struct[0].Gy_ini[0,1] = -89.5459479864169
        struct[0].Gy_ini[0,2] = 49.3782605212972
        struct[0].Gy_ini[0,3] = 25.5846390702588
        struct[0].Gy_ini[0,4] = 49.3782605212972
        struct[0].Gy_ini[0,5] = 25.5846390702587
        struct[0].Gy_ini[0,96] = 172.823911824540
        struct[0].Gy_ini[0,97] = 89.5460683028705
        struct[0].Gy_ini[0,98] = -49.3782605212972
        struct[0].Gy_ini[0,99] = -25.5845909436773
        struct[0].Gy_ini[0,100] = -49.3782605212972
        struct[0].Gy_ini[0,101] = -25.5845909436773
        struct[0].Gy_ini[0,174] = 1
        struct[0].Gy_ini[1,0] = 89.5459479864169
        struct[0].Gy_ini[1,1] = -172.823911824540
        struct[0].Gy_ini[1,2] = -25.5846390702588
        struct[0].Gy_ini[1,3] = 49.3782605212972
        struct[0].Gy_ini[1,4] = -25.5846390702587
        struct[0].Gy_ini[1,5] = 49.3782605212972
        struct[0].Gy_ini[1,96] = -89.5460683028705
        struct[0].Gy_ini[1,97] = 172.823911824540
        struct[0].Gy_ini[1,98] = 25.5845909436773
        struct[0].Gy_ini[1,99] = -49.3782605212972
        struct[0].Gy_ini[1,100] = 25.5845909436773
        struct[0].Gy_ini[1,101] = -49.3782605212972
        struct[0].Gy_ini[1,175] = 1
        struct[0].Gy_ini[2,0] = 49.3782605212972
        struct[0].Gy_ini[2,1] = 25.5846390702587
        struct[0].Gy_ini[2,2] = -172.823911824540
        struct[0].Gy_ini[2,3] = -89.5459479864168
        struct[0].Gy_ini[2,4] = 49.3782605212973
        struct[0].Gy_ini[2,5] = 25.5846390702587
        struct[0].Gy_ini[2,96] = -49.3782605212972
        struct[0].Gy_ini[2,97] = -25.5845909436773
        struct[0].Gy_ini[2,98] = 172.823911824540
        struct[0].Gy_ini[2,99] = 89.5460683028705
        struct[0].Gy_ini[2,100] = -49.3782605212973
        struct[0].Gy_ini[2,101] = -25.5845909436773
        struct[0].Gy_ini[2,176] = 1
        struct[0].Gy_ini[3,0] = -25.5846390702587
        struct[0].Gy_ini[3,1] = 49.3782605212972
        struct[0].Gy_ini[3,2] = 89.5459479864168
        struct[0].Gy_ini[3,3] = -172.823911824540
        struct[0].Gy_ini[3,4] = -25.5846390702587
        struct[0].Gy_ini[3,5] = 49.3782605212973
        struct[0].Gy_ini[3,96] = 25.5845909436773
        struct[0].Gy_ini[3,97] = -49.3782605212972
        struct[0].Gy_ini[3,98] = -89.5460683028705
        struct[0].Gy_ini[3,99] = 172.823911824540
        struct[0].Gy_ini[3,100] = 25.5845909436773
        struct[0].Gy_ini[3,101] = -49.3782605212973
        struct[0].Gy_ini[3,177] = 1
        struct[0].Gy_ini[4,0] = 49.3782605212972
        struct[0].Gy_ini[4,1] = 25.5846390702588
        struct[0].Gy_ini[4,2] = 49.3782605212973
        struct[0].Gy_ini[4,3] = 25.5846390702587
        struct[0].Gy_ini[4,4] = -172.823911824540
        struct[0].Gy_ini[4,5] = -89.5459479864168
        struct[0].Gy_ini[4,96] = -49.3782605212972
        struct[0].Gy_ini[4,97] = -25.5845909436773
        struct[0].Gy_ini[4,98] = -49.3782605212973
        struct[0].Gy_ini[4,99] = -25.5845909436772
        struct[0].Gy_ini[4,100] = 172.823911824540
        struct[0].Gy_ini[4,101] = 89.5460683028705
        struct[0].Gy_ini[4,178] = 1
        struct[0].Gy_ini[5,0] = -25.5846390702588
        struct[0].Gy_ini[5,1] = 49.3782605212972
        struct[0].Gy_ini[5,2] = -25.5846390702587
        struct[0].Gy_ini[5,3] = 49.3782605212973
        struct[0].Gy_ini[5,4] = 89.5459479864168
        struct[0].Gy_ini[5,5] = -172.823911824540
        struct[0].Gy_ini[5,96] = 25.5845909436773
        struct[0].Gy_ini[5,97] = -49.3782605212972
        struct[0].Gy_ini[5,98] = 25.5845909436772
        struct[0].Gy_ini[5,99] = -49.3782605212973
        struct[0].Gy_ini[5,100] = -89.5460683028705
        struct[0].Gy_ini[5,101] = 172.823911824540
        struct[0].Gy_ini[5,179] = 1
        struct[0].Gy_ini[6,6] = -188.838681114510
        struct[0].Gy_ini[6,7] = -97.8437661123124
        struct[0].Gy_ini[6,8] = 53.9539088898601
        struct[0].Gy_ini[6,9] = 27.9554372523104
        struct[0].Gy_ini[6,10] = 53.9539088898601
        struct[0].Gy_ini[6,11] = 27.9554372523104
        struct[0].Gy_ini[6,96] = 188.838681114510
        struct[0].Gy_ini[6,97] = 97.8438762251349
        struct[0].Gy_ini[6,98] = -53.9539088898601
        struct[0].Gy_ini[6,99] = -27.9553932071814
        struct[0].Gy_ini[6,100] = -53.9539088898601
        struct[0].Gy_ini[6,101] = -27.9553932071814
        struct[0].Gy_ini[6,184] = 1
        struct[0].Gy_ini[7,6] = 97.8437661123124
        struct[0].Gy_ini[7,7] = -188.838681114510
        struct[0].Gy_ini[7,8] = -27.9554372523104
        struct[0].Gy_ini[7,9] = 53.9539088898601
        struct[0].Gy_ini[7,10] = -27.9554372523104
        struct[0].Gy_ini[7,11] = 53.9539088898601
        struct[0].Gy_ini[7,96] = -97.8438762251349
        struct[0].Gy_ini[7,97] = 188.838681114510
        struct[0].Gy_ini[7,98] = 27.9553932071814
        struct[0].Gy_ini[7,99] = -53.9539088898601
        struct[0].Gy_ini[7,100] = 27.9553932071814
        struct[0].Gy_ini[7,101] = -53.9539088898601
        struct[0].Gy_ini[7,185] = 1
        struct[0].Gy_ini[8,6] = 53.9539088898601
        struct[0].Gy_ini[8,7] = 27.9554372523104
        struct[0].Gy_ini[8,8] = -188.838681114510
        struct[0].Gy_ini[8,9] = -97.8437661123124
        struct[0].Gy_ini[8,10] = 53.9539088898602
        struct[0].Gy_ini[8,11] = 27.9554372523104
        struct[0].Gy_ini[8,96] = -53.9539088898601
        struct[0].Gy_ini[8,97] = -27.9553932071814
        struct[0].Gy_ini[8,98] = 188.838681114510
        struct[0].Gy_ini[8,99] = 97.8438762251349
        struct[0].Gy_ini[8,100] = -53.9539088898602
        struct[0].Gy_ini[8,101] = -27.9553932071814
        struct[0].Gy_ini[8,186] = 1
        struct[0].Gy_ini[9,6] = -27.9554372523104
        struct[0].Gy_ini[9,7] = 53.9539088898601
        struct[0].Gy_ini[9,8] = 97.8437661123124
        struct[0].Gy_ini[9,9] = -188.838681114510
        struct[0].Gy_ini[9,10] = -27.9554372523104
        struct[0].Gy_ini[9,11] = 53.9539088898602
        struct[0].Gy_ini[9,96] = 27.9553932071814
        struct[0].Gy_ini[9,97] = -53.9539088898601
        struct[0].Gy_ini[9,98] = -97.8438762251349
        struct[0].Gy_ini[9,99] = 188.838681114510
        struct[0].Gy_ini[9,100] = 27.9553932071814
        struct[0].Gy_ini[9,101] = -53.9539088898602
        struct[0].Gy_ini[9,187] = 1
        struct[0].Gy_ini[10,6] = 53.9539088898601
        struct[0].Gy_ini[10,7] = 27.9554372523104
        struct[0].Gy_ini[10,8] = 53.9539088898602
        struct[0].Gy_ini[10,9] = 27.9554372523103
        struct[0].Gy_ini[10,10] = -188.838681114510
        struct[0].Gy_ini[10,11] = -97.8437661123124
        struct[0].Gy_ini[10,96] = -53.9539088898601
        struct[0].Gy_ini[10,97] = -27.9553932071814
        struct[0].Gy_ini[10,98] = -53.9539088898602
        struct[0].Gy_ini[10,99] = -27.9553932071813
        struct[0].Gy_ini[10,100] = 188.838681114510
        struct[0].Gy_ini[10,101] = 97.8438762251349
        struct[0].Gy_ini[10,188] = 1
        struct[0].Gy_ini[11,6] = -27.9554372523104
        struct[0].Gy_ini[11,7] = 53.9539088898601
        struct[0].Gy_ini[11,8] = -27.9554372523103
        struct[0].Gy_ini[11,9] = 53.9539088898602
        struct[0].Gy_ini[11,10] = 97.8437661123124
        struct[0].Gy_ini[11,11] = -188.838681114510
        struct[0].Gy_ini[11,96] = 27.9553932071814
        struct[0].Gy_ini[11,97] = -53.9539088898601
        struct[0].Gy_ini[11,98] = 27.9553932071813
        struct[0].Gy_ini[11,99] = -53.9539088898602
        struct[0].Gy_ini[11,100] = -97.8438762251349
        struct[0].Gy_ini[11,101] = 188.838681114510
        struct[0].Gy_ini[11,189] = 1
        struct[0].Gy_ini[12,12] = -207.974729711346
        struct[0].Gy_ini[12,13] = -107.758827330392
        struct[0].Gy_ini[12,14] = 59.4213513460989
        struct[0].Gy_ini[12,15] = 30.7883049386397
        struct[0].Gy_ini[12,16] = 59.4213513460989
        struct[0].Gy_ini[12,17] = 30.7883049386397
        struct[0].Gy_ini[12,108] = 207.974729711346
        struct[0].Gy_ini[12,109] = 107.758927311578
        struct[0].Gy_ini[12,110] = -59.4213513460989
        struct[0].Gy_ini[12,111] = -30.7882649461652
        struct[0].Gy_ini[12,112] = -59.4213513460989
        struct[0].Gy_ini[12,113] = -30.7882649461652
        struct[0].Gy_ini[12,193] = 1
        struct[0].Gy_ini[13,12] = 107.758827330392
        struct[0].Gy_ini[13,13] = -207.974729711346
        struct[0].Gy_ini[13,14] = -30.7883049386397
        struct[0].Gy_ini[13,15] = 59.4213513460989
        struct[0].Gy_ini[13,16] = -30.7883049386397
        struct[0].Gy_ini[13,17] = 59.4213513460989
        struct[0].Gy_ini[13,108] = -107.758927311578
        struct[0].Gy_ini[13,109] = 207.974729711346
        struct[0].Gy_ini[13,110] = 30.7882649461652
        struct[0].Gy_ini[13,111] = -59.4213513460989
        struct[0].Gy_ini[13,112] = 30.7882649461652
        struct[0].Gy_ini[13,113] = -59.4213513460989
        struct[0].Gy_ini[13,194] = 1
        struct[0].Gy_ini[14,12] = 59.4213513460989
        struct[0].Gy_ini[14,13] = 30.7883049386397
        struct[0].Gy_ini[14,14] = -207.974729711346
        struct[0].Gy_ini[14,15] = -107.758827330392
        struct[0].Gy_ini[14,16] = 59.4213513460990
        struct[0].Gy_ini[14,17] = 30.7883049386396
        struct[0].Gy_ini[14,108] = -59.4213513460989
        struct[0].Gy_ini[14,109] = -30.7882649461652
        struct[0].Gy_ini[14,110] = 207.974729711346
        struct[0].Gy_ini[14,111] = 107.758927311578
        struct[0].Gy_ini[14,112] = -59.4213513460990
        struct[0].Gy_ini[14,113] = -30.7882649461651
        struct[0].Gy_ini[14,195] = 1
        struct[0].Gy_ini[15,12] = -30.7883049386397
        struct[0].Gy_ini[15,13] = 59.4213513460989
        struct[0].Gy_ini[15,14] = 107.758827330392
        struct[0].Gy_ini[15,15] = -207.974729711346
        struct[0].Gy_ini[15,16] = -30.7883049386396
        struct[0].Gy_ini[15,17] = 59.4213513460990
        struct[0].Gy_ini[15,108] = 30.7882649461652
        struct[0].Gy_ini[15,109] = -59.4213513460989
        struct[0].Gy_ini[15,110] = -107.758927311578
        struct[0].Gy_ini[15,111] = 207.974729711346
        struct[0].Gy_ini[15,112] = 30.7882649461651
        struct[0].Gy_ini[15,113] = -59.4213513460990
        struct[0].Gy_ini[15,196] = 1
        struct[0].Gy_ini[16,12] = 59.4213513460989
        struct[0].Gy_ini[16,13] = 30.7883049386397
        struct[0].Gy_ini[16,14] = 59.4213513460990
        struct[0].Gy_ini[16,15] = 30.7883049386396
        struct[0].Gy_ini[16,16] = -207.974729711346
        struct[0].Gy_ini[16,17] = -107.758827330392
        struct[0].Gy_ini[16,108] = -59.4213513460989
        struct[0].Gy_ini[16,109] = -30.7882649461652
        struct[0].Gy_ini[16,110] = -59.4213513460990
        struct[0].Gy_ini[16,111] = -30.7882649461651
        struct[0].Gy_ini[16,112] = 207.974729711346
        struct[0].Gy_ini[16,113] = 107.758927311578
        struct[0].Gy_ini[16,197] = 1
        struct[0].Gy_ini[17,12] = -30.7883049386397
        struct[0].Gy_ini[17,13] = 59.4213513460989
        struct[0].Gy_ini[17,14] = -30.7883049386396
        struct[0].Gy_ini[17,15] = 59.4213513460990
        struct[0].Gy_ini[17,16] = 107.758827330392
        struct[0].Gy_ini[17,17] = -207.974729711346
        struct[0].Gy_ini[17,108] = 30.7882649461652
        struct[0].Gy_ini[17,109] = -59.4213513460989
        struct[0].Gy_ini[17,110] = 30.7882649461651
        struct[0].Gy_ini[17,111] = -59.4213513460990
        struct[0].Gy_ini[17,112] = -107.758927311578
        struct[0].Gy_ini[17,113] = 207.974729711346
        struct[0].Gy_ini[17,198] = 1
        struct[0].Gy_ini[18,18] = -112.816376232042
        struct[0].Gy_ini[18,19] = -58.4538966359303
        struct[0].Gy_ini[18,20] = 32.2332503520119
        struct[0].Gy_ini[18,21] = 16.7012397108240
        struct[0].Gy_ini[18,22] = 32.2332503520119
        struct[0].Gy_ini[18,23] = 16.7012397108240
        struct[0].Gy_ini[18,108] = 112.816376232042
        struct[0].Gy_ini[18,109] = 58.4540809492443
        struct[0].Gy_ini[18,110] = -32.2332503520119
        struct[0].Gy_ini[18,111] = -16.7011659854984
        struct[0].Gy_ini[18,112] = -32.2332503520119
        struct[0].Gy_ini[18,113] = -16.7011659854984
        struct[0].Gy_ini[18,203] = 1
        struct[0].Gy_ini[19,18] = 58.4538966359303
        struct[0].Gy_ini[19,19] = -112.816376232042
        struct[0].Gy_ini[19,20] = -16.7012397108240
        struct[0].Gy_ini[19,21] = 32.2332503520119
        struct[0].Gy_ini[19,22] = -16.7012397108240
        struct[0].Gy_ini[19,23] = 32.2332503520119
        struct[0].Gy_ini[19,108] = -58.4540809492443
        struct[0].Gy_ini[19,109] = 112.816376232042
        struct[0].Gy_ini[19,110] = 16.7011659854984
        struct[0].Gy_ini[19,111] = -32.2332503520119
        struct[0].Gy_ini[19,112] = 16.7011659854984
        struct[0].Gy_ini[19,113] = -32.2332503520119
        struct[0].Gy_ini[19,204] = 1
        struct[0].Gy_ini[20,18] = 32.2332503520119
        struct[0].Gy_ini[20,19] = 16.7012397108240
        struct[0].Gy_ini[20,20] = -112.816376232042
        struct[0].Gy_ini[20,21] = -58.4538966359303
        struct[0].Gy_ini[20,22] = 32.2332503520119
        struct[0].Gy_ini[20,23] = 16.7012397108240
        struct[0].Gy_ini[20,108] = -32.2332503520119
        struct[0].Gy_ini[20,109] = -16.7011659854984
        struct[0].Gy_ini[20,110] = 112.816376232042
        struct[0].Gy_ini[20,111] = 58.4540809492443
        struct[0].Gy_ini[20,112] = -32.2332503520119
        struct[0].Gy_ini[20,113] = -16.7011659854984
        struct[0].Gy_ini[20,205] = 1
        struct[0].Gy_ini[21,18] = -16.7012397108240
        struct[0].Gy_ini[21,19] = 32.2332503520119
        struct[0].Gy_ini[21,20] = 58.4538966359303
        struct[0].Gy_ini[21,21] = -112.816376232042
        struct[0].Gy_ini[21,22] = -16.7012397108240
        struct[0].Gy_ini[21,23] = 32.2332503520119
        struct[0].Gy_ini[21,108] = 16.7011659854984
        struct[0].Gy_ini[21,109] = -32.2332503520119
        struct[0].Gy_ini[21,110] = -58.4540809492443
        struct[0].Gy_ini[21,111] = 112.816376232042
        struct[0].Gy_ini[21,112] = 16.7011659854984
        struct[0].Gy_ini[21,113] = -32.2332503520119
        struct[0].Gy_ini[21,206] = 1
        struct[0].Gy_ini[22,18] = 32.2332503520119
        struct[0].Gy_ini[22,19] = 16.7012397108240
        struct[0].Gy_ini[22,20] = 32.2332503520119
        struct[0].Gy_ini[22,21] = 16.7012397108239
        struct[0].Gy_ini[22,22] = -112.816376232042
        struct[0].Gy_ini[22,23] = -58.4538966359303
        struct[0].Gy_ini[22,108] = -32.2332503520119
        struct[0].Gy_ini[22,109] = -16.7011659854984
        struct[0].Gy_ini[22,110] = -32.2332503520119
        struct[0].Gy_ini[22,111] = -16.7011659854983
        struct[0].Gy_ini[22,112] = 112.816376232042
        struct[0].Gy_ini[22,113] = 58.4540809492443
        struct[0].Gy_ini[22,207] = 1
        struct[0].Gy_ini[23,18] = -16.7012397108240
        struct[0].Gy_ini[23,19] = 32.2332503520119
        struct[0].Gy_ini[23,20] = -16.7012397108239
        struct[0].Gy_ini[23,21] = 32.2332503520119
        struct[0].Gy_ini[23,22] = 58.4538966359303
        struct[0].Gy_ini[23,23] = -112.816376232042
        struct[0].Gy_ini[23,108] = 16.7011659854984
        struct[0].Gy_ini[23,109] = -32.2332503520119
        struct[0].Gy_ini[23,110] = 16.7011659854983
        struct[0].Gy_ini[23,111] = -32.2332503520119
        struct[0].Gy_ini[23,112] = -58.4540809492443
        struct[0].Gy_ini[23,113] = 112.816376232042
        struct[0].Gy_ini[23,208] = 1
        struct[0].Gy_ini[24,24] = -178.886372244962
        struct[0].Gy_ini[24,25] = -92.6871232662334
        struct[0].Gy_ini[24,26] = 51.1103920699891
        struct[0].Gy_ini[24,27] = 26.4821149256174
        struct[0].Gy_ini[24,28] = 51.1103920699891
        struct[0].Gy_ini[24,29] = 26.4821149256174
        struct[0].Gy_ini[24,120] = 178.886372244962
        struct[0].Gy_ini[24,121] = 92.6872395051616
        struct[0].Gy_ini[24,122] = -51.1103920699891
        struct[0].Gy_ini[24,123] = -26.4820684300462
        struct[0].Gy_ini[24,124] = -51.1103920699891
        struct[0].Gy_ini[24,125] = -26.4820684300462
        struct[0].Gy_ini[24,212] = 1
        struct[0].Gy_ini[25,24] = 92.6871232662334
        struct[0].Gy_ini[25,25] = -178.886372244962
        struct[0].Gy_ini[25,26] = -26.4821149256174
        struct[0].Gy_ini[25,27] = 51.1103920699891
        struct[0].Gy_ini[25,28] = -26.4821149256174
        struct[0].Gy_ini[25,29] = 51.1103920699891
        struct[0].Gy_ini[25,120] = -92.6872395051616
        struct[0].Gy_ini[25,121] = 178.886372244962
        struct[0].Gy_ini[25,122] = 26.4820684300462
        struct[0].Gy_ini[25,123] = -51.1103920699891
        struct[0].Gy_ini[25,124] = 26.4820684300462
        struct[0].Gy_ini[25,125] = -51.1103920699891
        struct[0].Gy_ini[25,213] = 1
        struct[0].Gy_ini[26,24] = 51.1103920699891
        struct[0].Gy_ini[26,25] = 26.4821149256174
        struct[0].Gy_ini[26,26] = -178.886372244962
        struct[0].Gy_ini[26,27] = -92.6871232662333
        struct[0].Gy_ini[26,28] = 51.1103920699892
        struct[0].Gy_ini[26,29] = 26.4821149256174
        struct[0].Gy_ini[26,120] = -51.1103920699891
        struct[0].Gy_ini[26,121] = -26.4820684300461
        struct[0].Gy_ini[26,122] = 178.886372244962
        struct[0].Gy_ini[26,123] = 92.6872395051615
        struct[0].Gy_ini[26,124] = -51.1103920699892
        struct[0].Gy_ini[26,125] = -26.4820684300461
        struct[0].Gy_ini[26,214] = 1
        struct[0].Gy_ini[27,24] = -26.4821149256174
        struct[0].Gy_ini[27,25] = 51.1103920699891
        struct[0].Gy_ini[27,26] = 92.6871232662333
        struct[0].Gy_ini[27,27] = -178.886372244962
        struct[0].Gy_ini[27,28] = -26.4821149256174
        struct[0].Gy_ini[27,29] = 51.1103920699892
        struct[0].Gy_ini[27,120] = 26.4820684300461
        struct[0].Gy_ini[27,121] = -51.1103920699891
        struct[0].Gy_ini[27,122] = -92.6872395051615
        struct[0].Gy_ini[27,123] = 178.886372244962
        struct[0].Gy_ini[27,124] = 26.4820684300461
        struct[0].Gy_ini[27,125] = -51.1103920699892
        struct[0].Gy_ini[27,215] = 1
        struct[0].Gy_ini[28,24] = 51.1103920699891
        struct[0].Gy_ini[28,25] = 26.4821149256174
        struct[0].Gy_ini[28,26] = 51.1103920699892
        struct[0].Gy_ini[28,27] = 26.4821149256174
        struct[0].Gy_ini[28,28] = -178.886372244962
        struct[0].Gy_ini[28,29] = -92.6871232662333
        struct[0].Gy_ini[28,120] = -51.1103920699891
        struct[0].Gy_ini[28,121] = -26.4820684300462
        struct[0].Gy_ini[28,122] = -51.1103920699892
        struct[0].Gy_ini[28,123] = -26.4820684300461
        struct[0].Gy_ini[28,124] = 178.886372244962
        struct[0].Gy_ini[28,125] = 92.6872395051615
        struct[0].Gy_ini[28,216] = 1
        struct[0].Gy_ini[29,24] = -26.4821149256174
        struct[0].Gy_ini[29,25] = 51.1103920699891
        struct[0].Gy_ini[29,26] = -26.4821149256174
        struct[0].Gy_ini[29,27] = 51.1103920699892
        struct[0].Gy_ini[29,28] = 92.6871232662333
        struct[0].Gy_ini[29,29] = -178.886372244962
        struct[0].Gy_ini[29,120] = 26.4820684300462
        struct[0].Gy_ini[29,121] = -51.1103920699891
        struct[0].Gy_ini[29,122] = 26.4820684300461
        struct[0].Gy_ini[29,123] = -51.1103920699892
        struct[0].Gy_ini[29,124] = -92.6872395051615
        struct[0].Gy_ini[29,125] = 178.886372244962
        struct[0].Gy_ini[29,217] = 1
        struct[0].Gy_ini[30,30] = -112.904579802783
        struct[0].Gy_ini[30,31] = -58.4995981119106
        struct[0].Gy_ini[30,32] = 32.2584513722238
        struct[0].Gy_ini[30,33] = 16.7142971766540
        struct[0].Gy_ini[30,34] = 32.2584513722239
        struct[0].Gy_ini[30,35] = 16.7142971766540
        struct[0].Gy_ini[30,120] = 112.904579802783
        struct[0].Gy_ini[30,121] = 58.4997822812349
        struct[0].Gy_ini[30,122] = -32.2584513722238
        struct[0].Gy_ini[30,123] = -16.7142235089243
        struct[0].Gy_ini[30,124] = -32.2584513722239
        struct[0].Gy_ini[30,125] = -16.7142235089243
        struct[0].Gy_ini[30,222] = 1
        struct[0].Gy_ini[31,30] = 58.4995981119106
        struct[0].Gy_ini[31,31] = -112.904579802783
        struct[0].Gy_ini[31,32] = -16.7142971766540
        struct[0].Gy_ini[31,33] = 32.2584513722238
        struct[0].Gy_ini[31,34] = -16.7142971766540
        struct[0].Gy_ini[31,35] = 32.2584513722239
        struct[0].Gy_ini[31,120] = -58.4997822812349
        struct[0].Gy_ini[31,121] = 112.904579802783
        struct[0].Gy_ini[31,122] = 16.7142235089243
        struct[0].Gy_ini[31,123] = -32.2584513722238
        struct[0].Gy_ini[31,124] = 16.7142235089243
        struct[0].Gy_ini[31,125] = -32.2584513722239
        struct[0].Gy_ini[31,223] = 1
        struct[0].Gy_ini[32,30] = 32.2584513722238
        struct[0].Gy_ini[32,31] = 16.7142971766540
        struct[0].Gy_ini[32,32] = -112.904579802783
        struct[0].Gy_ini[32,33] = -58.4995981119106
        struct[0].Gy_ini[32,34] = 32.2584513722239
        struct[0].Gy_ini[32,35] = 16.7142971766540
        struct[0].Gy_ini[32,120] = -32.2584513722238
        struct[0].Gy_ini[32,121] = -16.7142235089243
        struct[0].Gy_ini[32,122] = 112.904579802783
        struct[0].Gy_ini[32,123] = 58.4997822812349
        struct[0].Gy_ini[32,124] = -32.2584513722239
        struct[0].Gy_ini[32,125] = -16.7142235089242
        struct[0].Gy_ini[32,224] = 1
        struct[0].Gy_ini[33,30] = -16.7142971766540
        struct[0].Gy_ini[33,31] = 32.2584513722238
        struct[0].Gy_ini[33,32] = 58.4995981119106
        struct[0].Gy_ini[33,33] = -112.904579802783
        struct[0].Gy_ini[33,34] = -16.7142971766540
        struct[0].Gy_ini[33,35] = 32.2584513722239
        struct[0].Gy_ini[33,120] = 16.7142235089243
        struct[0].Gy_ini[33,121] = -32.2584513722238
        struct[0].Gy_ini[33,122] = -58.4997822812349
        struct[0].Gy_ini[33,123] = 112.904579802783
        struct[0].Gy_ini[33,124] = 16.7142235089242
        struct[0].Gy_ini[33,125] = -32.2584513722239
        struct[0].Gy_ini[33,225] = 1
        struct[0].Gy_ini[34,30] = 32.2584513722239
        struct[0].Gy_ini[34,31] = 16.7142971766540
        struct[0].Gy_ini[34,32] = 32.2584513722239
        struct[0].Gy_ini[34,33] = 16.7142971766540
        struct[0].Gy_ini[34,34] = -112.904579802783
        struct[0].Gy_ini[34,35] = -58.4995981119106
        struct[0].Gy_ini[34,120] = -32.2584513722239
        struct[0].Gy_ini[34,121] = -16.7142235089243
        struct[0].Gy_ini[34,122] = -32.2584513722239
        struct[0].Gy_ini[34,123] = -16.7142235089242
        struct[0].Gy_ini[34,124] = 112.904579802783
        struct[0].Gy_ini[34,125] = 58.4997822812349
        struct[0].Gy_ini[34,226] = 1
        struct[0].Gy_ini[35,30] = -16.7142971766540
        struct[0].Gy_ini[35,31] = 32.2584513722239
        struct[0].Gy_ini[35,32] = -16.7142971766540
        struct[0].Gy_ini[35,33] = 32.2584513722239
        struct[0].Gy_ini[35,34] = 58.4995981119106
        struct[0].Gy_ini[35,35] = -112.904579802783
        struct[0].Gy_ini[35,120] = 16.7142235089243
        struct[0].Gy_ini[35,121] = -32.2584513722239
        struct[0].Gy_ini[35,122] = 16.7142235089242
        struct[0].Gy_ini[35,123] = -32.2584513722239
        struct[0].Gy_ini[35,124] = -58.4997822812349
        struct[0].Gy_ini[35,125] = 112.904579802783
        struct[0].Gy_ini[35,227] = 1
        struct[0].Gy_ini[36,36] = -474.891176542679
        struct[0].Gy_ini[36,37] = -246.057560640311
        struct[0].Gy_ini[36,38] = 135.683193297908
        struct[0].Gy_ini[36,39] = 70.3021902075957
        struct[0].Gy_ini[36,40] = 135.683193297908
        struct[0].Gy_ini[36,41] = 70.3021902075957
        struct[0].Gy_ini[36,132] = 474.891176542679
        struct[0].Gy_ini[36,133] = 246.057604426258
        struct[0].Gy_ini[36,134] = -135.683193297908
        struct[0].Gy_ini[36,135] = -70.3021726932167
        struct[0].Gy_ini[36,136] = -135.683193297908
        struct[0].Gy_ini[36,137] = -70.3021726932166
        struct[0].Gy_ini[36,231] = 1
        struct[0].Gy_ini[37,36] = 246.057560640311
        struct[0].Gy_ini[37,37] = -474.891176542679
        struct[0].Gy_ini[37,38] = -70.3021902075957
        struct[0].Gy_ini[37,39] = 135.683193297908
        struct[0].Gy_ini[37,40] = -70.3021902075957
        struct[0].Gy_ini[37,41] = 135.683193297908
        struct[0].Gy_ini[37,132] = -246.057604426258
        struct[0].Gy_ini[37,133] = 474.891176542679
        struct[0].Gy_ini[37,134] = 70.3021726932167
        struct[0].Gy_ini[37,135] = -135.683193297908
        struct[0].Gy_ini[37,136] = 70.3021726932166
        struct[0].Gy_ini[37,137] = -135.683193297908
        struct[0].Gy_ini[37,232] = 1
        struct[0].Gy_ini[38,36] = 135.683193297908
        struct[0].Gy_ini[38,37] = 70.3021902075957
        struct[0].Gy_ini[38,38] = -474.891176542679
        struct[0].Gy_ini[38,39] = -246.057560640311
        struct[0].Gy_ini[38,40] = 135.683193297909
        struct[0].Gy_ini[38,41] = 70.3021902075956
        struct[0].Gy_ini[38,132] = -135.683193297908
        struct[0].Gy_ini[38,133] = -70.3021726932166
        struct[0].Gy_ini[38,134] = 474.891176542679
        struct[0].Gy_ini[38,135] = 246.057604426258
        struct[0].Gy_ini[38,136] = -135.683193297909
        struct[0].Gy_ini[38,137] = -70.3021726932165
        struct[0].Gy_ini[38,233] = 1
        struct[0].Gy_ini[39,36] = -70.3021902075957
        struct[0].Gy_ini[39,37] = 135.683193297908
        struct[0].Gy_ini[39,38] = 246.057560640311
        struct[0].Gy_ini[39,39] = -474.891176542679
        struct[0].Gy_ini[39,40] = -70.3021902075956
        struct[0].Gy_ini[39,41] = 135.683193297909
        struct[0].Gy_ini[39,132] = 70.3021726932166
        struct[0].Gy_ini[39,133] = -135.683193297908
        struct[0].Gy_ini[39,134] = -246.057604426258
        struct[0].Gy_ini[39,135] = 474.891176542679
        struct[0].Gy_ini[39,136] = 70.3021726932165
        struct[0].Gy_ini[39,137] = -135.683193297909
        struct[0].Gy_ini[39,234] = 1
        struct[0].Gy_ini[40,36] = 135.683193297908
        struct[0].Gy_ini[40,37] = 70.3021902075957
        struct[0].Gy_ini[40,38] = 135.683193297909
        struct[0].Gy_ini[40,39] = 70.3021902075956
        struct[0].Gy_ini[40,40] = -474.891176542679
        struct[0].Gy_ini[40,41] = -246.057560640311
        struct[0].Gy_ini[40,132] = -135.683193297908
        struct[0].Gy_ini[40,133] = -70.3021726932167
        struct[0].Gy_ini[40,134] = -135.683193297909
        struct[0].Gy_ini[40,135] = -70.3021726932165
        struct[0].Gy_ini[40,136] = 474.891176542679
        struct[0].Gy_ini[40,137] = 246.057604426258
        struct[0].Gy_ini[40,235] = 1
        struct[0].Gy_ini[41,36] = -70.3021902075957
        struct[0].Gy_ini[41,37] = 135.683193297908
        struct[0].Gy_ini[41,38] = -70.3021902075956
        struct[0].Gy_ini[41,39] = 135.683193297909
        struct[0].Gy_ini[41,40] = 246.057560640311
        struct[0].Gy_ini[41,41] = -474.891176542679
        struct[0].Gy_ini[41,132] = 70.3021726932167
        struct[0].Gy_ini[41,133] = -135.683193297908
        struct[0].Gy_ini[41,134] = 70.3021726932165
        struct[0].Gy_ini[41,135] = -135.683193297909
        struct[0].Gy_ini[41,136] = -246.057604426258
        struct[0].Gy_ini[41,137] = 474.891176542679
        struct[0].Gy_ini[41,236] = 1
        struct[0].Gy_ini[42,42] = -206.112752761809
        struct[0].Gy_ini[42,43] = -106.794071531051
        struct[0].Gy_ini[42,44] = 58.8893579319454
        struct[0].Gy_ini[42,45] = 30.5126610438848
        struct[0].Gy_ini[42,46] = 58.8893579319454
        struct[0].Gy_ini[42,47] = 30.5126610438848
        struct[0].Gy_ini[42,132] = 206.112752761809
        struct[0].Gy_ini[42,133] = 106.794172415445
        struct[0].Gy_ini[42,134] = -58.8893579319454
        struct[0].Gy_ini[42,135] = -30.5126206901271
        struct[0].Gy_ini[42,136] = -58.8893579319454
        struct[0].Gy_ini[42,137] = -30.5126206901271
        struct[0].Gy_ini[42,241] = 1
        struct[0].Gy_ini[43,42] = 106.794071531051
        struct[0].Gy_ini[43,43] = -206.112752761809
        struct[0].Gy_ini[43,44] = -30.5126610438848
        struct[0].Gy_ini[43,45] = 58.8893579319454
        struct[0].Gy_ini[43,46] = -30.5126610438848
        struct[0].Gy_ini[43,47] = 58.8893579319454
        struct[0].Gy_ini[43,132] = -106.794172415445
        struct[0].Gy_ini[43,133] = 206.112752761809
        struct[0].Gy_ini[43,134] = 30.5126206901271
        struct[0].Gy_ini[43,135] = -58.8893579319454
        struct[0].Gy_ini[43,136] = 30.5126206901271
        struct[0].Gy_ini[43,137] = -58.8893579319454
        struct[0].Gy_ini[43,242] = 1
        struct[0].Gy_ini[44,42] = 58.8893579319454
        struct[0].Gy_ini[44,43] = 30.5126610438847
        struct[0].Gy_ini[44,44] = -206.112752761809
        struct[0].Gy_ini[44,45] = -106.794071531051
        struct[0].Gy_ini[44,46] = 58.8893579319455
        struct[0].Gy_ini[44,47] = 30.5126610438847
        struct[0].Gy_ini[44,132] = -58.8893579319454
        struct[0].Gy_ini[44,133] = -30.5126206901271
        struct[0].Gy_ini[44,134] = 206.112752761809
        struct[0].Gy_ini[44,135] = 106.794172415445
        struct[0].Gy_ini[44,136] = -58.8893579319455
        struct[0].Gy_ini[44,137] = -30.5126206901271
        struct[0].Gy_ini[44,243] = 1
        struct[0].Gy_ini[45,42] = -30.5126610438847
        struct[0].Gy_ini[45,43] = 58.8893579319454
        struct[0].Gy_ini[45,44] = 106.794071531051
        struct[0].Gy_ini[45,45] = -206.112752761809
        struct[0].Gy_ini[45,46] = -30.5126610438847
        struct[0].Gy_ini[45,47] = 58.8893579319455
        struct[0].Gy_ini[45,132] = 30.5126206901271
        struct[0].Gy_ini[45,133] = -58.8893579319454
        struct[0].Gy_ini[45,134] = -106.794172415445
        struct[0].Gy_ini[45,135] = 206.112752761809
        struct[0].Gy_ini[45,136] = 30.5126206901271
        struct[0].Gy_ini[45,137] = -58.8893579319455
        struct[0].Gy_ini[45,244] = 1
        struct[0].Gy_ini[46,42] = 58.8893579319454
        struct[0].Gy_ini[46,43] = 30.5126610438848
        struct[0].Gy_ini[46,44] = 58.8893579319455
        struct[0].Gy_ini[46,45] = 30.5126610438847
        struct[0].Gy_ini[46,46] = -206.112752761809
        struct[0].Gy_ini[46,47] = -106.794071531051
        struct[0].Gy_ini[46,132] = -58.8893579319454
        struct[0].Gy_ini[46,133] = -30.5126206901272
        struct[0].Gy_ini[46,134] = -58.8893579319455
        struct[0].Gy_ini[46,135] = -30.5126206901271
        struct[0].Gy_ini[46,136] = 206.112752761809
        struct[0].Gy_ini[46,137] = 106.794172415445
        struct[0].Gy_ini[46,245] = 1
        struct[0].Gy_ini[47,42] = -30.5126610438848
        struct[0].Gy_ini[47,43] = 58.8893579319454
        struct[0].Gy_ini[47,44] = -30.5126610438847
        struct[0].Gy_ini[47,45] = 58.8893579319455
        struct[0].Gy_ini[47,46] = 106.794071531051
        struct[0].Gy_ini[47,47] = -206.112752761809
        struct[0].Gy_ini[47,132] = 30.5126206901272
        struct[0].Gy_ini[47,133] = -58.8893579319454
        struct[0].Gy_ini[47,134] = 30.5126206901271
        struct[0].Gy_ini[47,135] = -58.8893579319455
        struct[0].Gy_ini[47,136] = -106.794172415445
        struct[0].Gy_ini[47,137] = 206.112752761809
        struct[0].Gy_ini[47,246] = 1
        struct[0].Gy_ini[48,48] = -189.480644782640
        struct[0].Gy_ini[48,49] = -98.1763901476198
        struct[0].Gy_ini[48,50] = 54.1373270807543
        struct[0].Gy_ini[48,51] = 28.0504724351543
        struct[0].Gy_ini[48,52] = 54.1373270807543
        struct[0].Gy_ini[48,53] = 28.0504724351542
        struct[0].Gy_ini[48,144] = 189.480644782640
        struct[0].Gy_ini[48,145] = 98.1764998873781
        struct[0].Gy_ini[48,146] = -54.1373270807543
        struct[0].Gy_ini[48,147] = -28.0504285392509
        struct[0].Gy_ini[48,148] = -54.1373270807543
        struct[0].Gy_ini[48,149] = -28.0504285392509
        struct[0].Gy_ini[48,250] = 1
        struct[0].Gy_ini[49,48] = 98.1763901476198
        struct[0].Gy_ini[49,49] = -189.480644782640
        struct[0].Gy_ini[49,50] = -28.0504724351543
        struct[0].Gy_ini[49,51] = 54.1373270807543
        struct[0].Gy_ini[49,52] = -28.0504724351542
        struct[0].Gy_ini[49,53] = 54.1373270807543
        struct[0].Gy_ini[49,144] = -98.1764998873781
        struct[0].Gy_ini[49,145] = 189.480644782640
        struct[0].Gy_ini[49,146] = 28.0504285392509
        struct[0].Gy_ini[49,147] = -54.1373270807543
        struct[0].Gy_ini[49,148] = 28.0504285392509
        struct[0].Gy_ini[49,149] = -54.1373270807543
        struct[0].Gy_ini[49,251] = 1
        struct[0].Gy_ini[50,48] = 54.1373270807543
        struct[0].Gy_ini[50,49] = 28.0504724351542
        struct[0].Gy_ini[50,50] = -189.480644782640
        struct[0].Gy_ini[50,51] = -98.1763901476198
        struct[0].Gy_ini[50,52] = 54.1373270807544
        struct[0].Gy_ini[50,53] = 28.0504724351542
        struct[0].Gy_ini[50,144] = -54.1373270807543
        struct[0].Gy_ini[50,145] = -28.0504285392509
        struct[0].Gy_ini[50,146] = 189.480644782640
        struct[0].Gy_ini[50,147] = 98.1764998873781
        struct[0].Gy_ini[50,148] = -54.1373270807544
        struct[0].Gy_ini[50,149] = -28.0504285392509
        struct[0].Gy_ini[50,252] = 1
        struct[0].Gy_ini[51,48] = -28.0504724351542
        struct[0].Gy_ini[51,49] = 54.1373270807543
        struct[0].Gy_ini[51,50] = 98.1763901476198
        struct[0].Gy_ini[51,51] = -189.480644782640
        struct[0].Gy_ini[51,52] = -28.0504724351542
        struct[0].Gy_ini[51,53] = 54.1373270807544
        struct[0].Gy_ini[51,144] = 28.0504285392509
        struct[0].Gy_ini[51,145] = -54.1373270807543
        struct[0].Gy_ini[51,146] = -98.1764998873781
        struct[0].Gy_ini[51,147] = 189.480644782640
        struct[0].Gy_ini[51,148] = 28.0504285392509
        struct[0].Gy_ini[51,149] = -54.1373270807544
        struct[0].Gy_ini[51,253] = 1
        struct[0].Gy_ini[52,48] = 54.1373270807543
        struct[0].Gy_ini[52,49] = 28.0504724351543
        struct[0].Gy_ini[52,50] = 54.1373270807543
        struct[0].Gy_ini[52,51] = 28.0504724351542
        struct[0].Gy_ini[52,52] = -189.480644782640
        struct[0].Gy_ini[52,53] = -98.1763901476198
        struct[0].Gy_ini[52,144] = -54.1373270807543
        struct[0].Gy_ini[52,145] = -28.0504285392509
        struct[0].Gy_ini[52,146] = -54.1373270807543
        struct[0].Gy_ini[52,147] = -28.0504285392509
        struct[0].Gy_ini[52,148] = 189.480644782640
        struct[0].Gy_ini[52,149] = 98.1764998873781
        struct[0].Gy_ini[52,254] = 1
        struct[0].Gy_ini[53,48] = -28.0504724351543
        struct[0].Gy_ini[53,49] = 54.1373270807543
        struct[0].Gy_ini[53,50] = -28.0504724351542
        struct[0].Gy_ini[53,51] = 54.1373270807543
        struct[0].Gy_ini[53,52] = 98.1763901476198
        struct[0].Gy_ini[53,53] = -189.480644782640
        struct[0].Gy_ini[53,144] = 28.0504285392509
        struct[0].Gy_ini[53,145] = -54.1373270807543
        struct[0].Gy_ini[53,146] = 28.0504285392509
        struct[0].Gy_ini[53,147] = -54.1373270807543
        struct[0].Gy_ini[53,148] = -98.1764998873781
        struct[0].Gy_ini[53,149] = 189.480644782640
        struct[0].Gy_ini[53,255] = 1
        struct[0].Gy_ini[54,54] = -146.305409673982
        struct[0].Gy_ini[54,55] = -75.8057696238346
        struct[0].Gy_ini[54,56] = 41.8015456211378
        struct[0].Gy_ini[54,57] = 21.6588887777877
        struct[0].Gy_ini[54,58] = 41.8015456211378
        struct[0].Gy_ini[54,59] = 21.6588887777877
        struct[0].Gy_ini[54,144] = 146.305409673982
        struct[0].Gy_ini[54,145] = 75.8059117481773
        struct[0].Gy_ini[54,146] = -41.8015456211378
        struct[0].Gy_ini[54,147] = -21.6588319280506
        struct[0].Gy_ini[54,148] = -41.8015456211378
        struct[0].Gy_ini[54,149] = -21.6588319280506
        struct[0].Gy_ini[54,260] = 1
        struct[0].Gy_ini[55,54] = 75.8057696238346
        struct[0].Gy_ini[55,55] = -146.305409673982
        struct[0].Gy_ini[55,56] = -21.6588887777877
        struct[0].Gy_ini[55,57] = 41.8015456211378
        struct[0].Gy_ini[55,58] = -21.6588887777877
        struct[0].Gy_ini[55,59] = 41.8015456211378
        struct[0].Gy_ini[55,144] = -75.8059117481773
        struct[0].Gy_ini[55,145] = 146.305409673982
        struct[0].Gy_ini[55,146] = 21.6588319280506
        struct[0].Gy_ini[55,147] = -41.8015456211378
        struct[0].Gy_ini[55,148] = 21.6588319280506
        struct[0].Gy_ini[55,149] = -41.8015456211378
        struct[0].Gy_ini[55,261] = 1
        struct[0].Gy_ini[56,54] = 41.8015456211377
        struct[0].Gy_ini[56,55] = 21.6588887777877
        struct[0].Gy_ini[56,56] = -146.305409673982
        struct[0].Gy_ini[56,57] = -75.8057696238346
        struct[0].Gy_ini[56,58] = 41.8015456211378
        struct[0].Gy_ini[56,59] = 21.6588887777877
        struct[0].Gy_ini[56,144] = -41.8015456211377
        struct[0].Gy_ini[56,145] = -21.6588319280506
        struct[0].Gy_ini[56,146] = 146.305409673982
        struct[0].Gy_ini[56,147] = 75.8059117481773
        struct[0].Gy_ini[56,148] = -41.8015456211378
        struct[0].Gy_ini[56,149] = -21.6588319280506
        struct[0].Gy_ini[56,262] = 1
        struct[0].Gy_ini[57,54] = -21.6588887777877
        struct[0].Gy_ini[57,55] = 41.8015456211377
        struct[0].Gy_ini[57,56] = 75.8057696238346
        struct[0].Gy_ini[57,57] = -146.305409673982
        struct[0].Gy_ini[57,58] = -21.6588887777877
        struct[0].Gy_ini[57,59] = 41.8015456211378
        struct[0].Gy_ini[57,144] = 21.6588319280506
        struct[0].Gy_ini[57,145] = -41.8015456211377
        struct[0].Gy_ini[57,146] = -75.8059117481773
        struct[0].Gy_ini[57,147] = 146.305409673982
        struct[0].Gy_ini[57,148] = 21.6588319280506
        struct[0].Gy_ini[57,149] = -41.8015456211378
        struct[0].Gy_ini[57,263] = 1
        struct[0].Gy_ini[58,54] = 41.8015456211378
        struct[0].Gy_ini[58,55] = 21.6588887777877
        struct[0].Gy_ini[58,56] = 41.8015456211378
        struct[0].Gy_ini[58,57] = 21.6588887777877
        struct[0].Gy_ini[58,58] = -146.305409673982
        struct[0].Gy_ini[58,59] = -75.8057696238346
        struct[0].Gy_ini[58,144] = -41.8015456211378
        struct[0].Gy_ini[58,145] = -21.6588319280506
        struct[0].Gy_ini[58,146] = -41.8015456211378
        struct[0].Gy_ini[58,147] = -21.6588319280506
        struct[0].Gy_ini[58,148] = 146.305409673982
        struct[0].Gy_ini[58,149] = 75.8059117481773
        struct[0].Gy_ini[58,264] = 1
        struct[0].Gy_ini[59,54] = -21.6588887777877
        struct[0].Gy_ini[59,55] = 41.8015456211378
        struct[0].Gy_ini[59,56] = -21.6588887777877
        struct[0].Gy_ini[59,57] = 41.8015456211378
        struct[0].Gy_ini[59,58] = 75.8057696238346
        struct[0].Gy_ini[59,59] = -146.305409673982
        struct[0].Gy_ini[59,144] = 21.6588319280506
        struct[0].Gy_ini[59,145] = -41.8015456211378
        struct[0].Gy_ini[59,146] = 21.6588319280506
        struct[0].Gy_ini[59,147] = -41.8015456211378
        struct[0].Gy_ini[59,148] = -75.8059117481773
        struct[0].Gy_ini[59,149] = 146.305409673982
        struct[0].Gy_ini[59,265] = 1
        struct[0].Gy_ini[60,60] = -157.441992718694
        struct[0].Gy_ini[60,61] = -81.5760299591651
        struct[0].Gy_ini[60,62] = 44.9834264910554
        struct[0].Gy_ini[60,63] = 23.3075276943302
        struct[0].Gy_ini[60,64] = 44.9834264910554
        struct[0].Gy_ini[60,65] = 23.3075276943302
        struct[0].Gy_ini[60,156] = 157.441992718694
        struct[0].Gy_ini[60,157] = 81.5761620304113
        struct[0].Gy_ini[60,158] = -44.9834264910554
        struct[0].Gy_ini[60,159] = -23.3074748658318
        struct[0].Gy_ini[60,160] = -44.9834264910554
        struct[0].Gy_ini[60,161] = -23.3074748658318
        struct[0].Gy_ini[60,269] = 1
        struct[0].Gy_ini[61,60] = 81.5760299591651
        struct[0].Gy_ini[61,61] = -157.441992718694
        struct[0].Gy_ini[61,62] = -23.3075276943302
        struct[0].Gy_ini[61,63] = 44.9834264910554
        struct[0].Gy_ini[61,64] = -23.3075276943302
        struct[0].Gy_ini[61,65] = 44.9834264910554
        struct[0].Gy_ini[61,156] = -81.5761620304113
        struct[0].Gy_ini[61,157] = 157.441992718694
        struct[0].Gy_ini[61,158] = 23.3074748658318
        struct[0].Gy_ini[61,159] = -44.9834264910554
        struct[0].Gy_ini[61,160] = 23.3074748658318
        struct[0].Gy_ini[61,161] = -44.9834264910554
        struct[0].Gy_ini[61,270] = 1
        struct[0].Gy_ini[62,60] = 44.9834264910554
        struct[0].Gy_ini[62,61] = 23.3075276943302
        struct[0].Gy_ini[62,62] = -157.441992718694
        struct[0].Gy_ini[62,63] = -81.5760299591651
        struct[0].Gy_ini[62,64] = 44.9834264910555
        struct[0].Gy_ini[62,65] = 23.3075276943302
        struct[0].Gy_ini[62,156] = -44.9834264910554
        struct[0].Gy_ini[62,157] = -23.3074748658318
        struct[0].Gy_ini[62,158] = 157.441992718694
        struct[0].Gy_ini[62,159] = 81.5761620304112
        struct[0].Gy_ini[62,160] = -44.9834264910555
        struct[0].Gy_ini[62,161] = -23.3074748658317
        struct[0].Gy_ini[62,271] = 1
        struct[0].Gy_ini[63,60] = -23.3075276943302
        struct[0].Gy_ini[63,61] = 44.9834264910554
        struct[0].Gy_ini[63,62] = 81.5760299591651
        struct[0].Gy_ini[63,63] = -157.441992718694
        struct[0].Gy_ini[63,64] = -23.3075276943302
        struct[0].Gy_ini[63,65] = 44.9834264910555
        struct[0].Gy_ini[63,156] = 23.3074748658318
        struct[0].Gy_ini[63,157] = -44.9834264910554
        struct[0].Gy_ini[63,158] = -81.5761620304112
        struct[0].Gy_ini[63,159] = 157.441992718694
        struct[0].Gy_ini[63,160] = 23.3074748658317
        struct[0].Gy_ini[63,161] = -44.9834264910555
        struct[0].Gy_ini[63,272] = 1
        struct[0].Gy_ini[64,60] = 44.9834264910554
        struct[0].Gy_ini[64,61] = 23.3075276943302
        struct[0].Gy_ini[64,62] = 44.9834264910554
        struct[0].Gy_ini[64,63] = 23.3075276943302
        struct[0].Gy_ini[64,64] = -157.441992718694
        struct[0].Gy_ini[64,65] = -81.5760299591651
        struct[0].Gy_ini[64,156] = -44.9834264910554
        struct[0].Gy_ini[64,157] = -23.3074748658318
        struct[0].Gy_ini[64,158] = -44.9834264910554
        struct[0].Gy_ini[64,159] = -23.3074748658317
        struct[0].Gy_ini[64,160] = 157.441992718694
        struct[0].Gy_ini[64,161] = 81.5761620304112
        struct[0].Gy_ini[64,273] = 1
        struct[0].Gy_ini[65,60] = -23.3075276943302
        struct[0].Gy_ini[65,61] = 44.9834264910554
        struct[0].Gy_ini[65,62] = -23.3075276943302
        struct[0].Gy_ini[65,63] = 44.9834264910554
        struct[0].Gy_ini[65,64] = 81.5760299591651
        struct[0].Gy_ini[65,65] = -157.441992718694
        struct[0].Gy_ini[65,156] = 23.3074748658318
        struct[0].Gy_ini[65,157] = -44.9834264910554
        struct[0].Gy_ini[65,158] = 23.3074748658317
        struct[0].Gy_ini[65,159] = -44.9834264910554
        struct[0].Gy_ini[65,160] = -81.5761620304112
        struct[0].Gy_ini[65,161] = 157.441992718694
        struct[0].Gy_ini[65,274] = 1
        struct[0].Gy_ini[66,66] = -208.261027274370
        struct[0].Gy_ini[66,67] = -107.907168174067
        struct[0].Gy_ini[66,68] = 59.5031506498201
        struct[0].Gy_ini[66,69] = 30.8306879425848
        struct[0].Gy_ini[66,70] = 59.5031506498201
        struct[0].Gy_ini[66,71] = 30.8306879425848
        struct[0].Gy_ini[66,156] = 208.261027274370
        struct[0].Gy_ini[66,157] = 107.907268017809
        struct[0].Gy_ini[66,158] = -59.5031506498201
        struct[0].Gy_ini[66,159] = -30.8306480050881
        struct[0].Gy_ini[66,160] = -59.5031506498201
        struct[0].Gy_ini[66,161] = -30.8306480050881
        struct[0].Gy_ini[66,279] = 1
        struct[0].Gy_ini[67,66] = 107.907168174067
        struct[0].Gy_ini[67,67] = -208.261027274370
        struct[0].Gy_ini[67,68] = -30.8306879425848
        struct[0].Gy_ini[67,69] = 59.5031506498201
        struct[0].Gy_ini[67,70] = -30.8306879425848
        struct[0].Gy_ini[67,71] = 59.5031506498201
        struct[0].Gy_ini[67,156] = -107.907268017809
        struct[0].Gy_ini[67,157] = 208.261027274370
        struct[0].Gy_ini[67,158] = 30.8306480050881
        struct[0].Gy_ini[67,159] = -59.5031506498201
        struct[0].Gy_ini[67,160] = 30.8306480050881
        struct[0].Gy_ini[67,161] = -59.5031506498201
        struct[0].Gy_ini[67,280] = 1
        struct[0].Gy_ini[68,66] = 59.5031506498201
        struct[0].Gy_ini[68,67] = 30.8306879425848
        struct[0].Gy_ini[68,68] = -208.261027274371
        struct[0].Gy_ini[68,69] = -107.907168174067
        struct[0].Gy_ini[68,70] = 59.5031506498202
        struct[0].Gy_ini[68,71] = 30.8306879425847
        struct[0].Gy_ini[68,156] = -59.5031506498201
        struct[0].Gy_ini[68,157] = -30.8306480050881
        struct[0].Gy_ini[68,158] = 208.261027274371
        struct[0].Gy_ini[68,159] = 107.907268017808
        struct[0].Gy_ini[68,160] = -59.5031506498202
        struct[0].Gy_ini[68,161] = -30.8306480050881
        struct[0].Gy_ini[68,281] = 1
        struct[0].Gy_ini[69,66] = -30.8306879425848
        struct[0].Gy_ini[69,67] = 59.5031506498201
        struct[0].Gy_ini[69,68] = 107.907168174067
        struct[0].Gy_ini[69,69] = -208.261027274371
        struct[0].Gy_ini[69,70] = -30.8306879425847
        struct[0].Gy_ini[69,71] = 59.5031506498202
        struct[0].Gy_ini[69,156] = 30.8306480050881
        struct[0].Gy_ini[69,157] = -59.5031506498201
        struct[0].Gy_ini[69,158] = -107.907268017808
        struct[0].Gy_ini[69,159] = 208.261027274371
        struct[0].Gy_ini[69,160] = 30.8306480050881
        struct[0].Gy_ini[69,161] = -59.5031506498202
        struct[0].Gy_ini[69,282] = 1
        struct[0].Gy_ini[70,66] = 59.5031506498201
        struct[0].Gy_ini[70,67] = 30.8306879425848
        struct[0].Gy_ini[70,68] = 59.5031506498202
        struct[0].Gy_ini[70,69] = 30.8306879425847
        struct[0].Gy_ini[70,70] = -208.261027274371
        struct[0].Gy_ini[70,71] = -107.907168174067
        struct[0].Gy_ini[70,156] = -59.5031506498201
        struct[0].Gy_ini[70,157] = -30.8306480050882
        struct[0].Gy_ini[70,158] = -59.5031506498202
        struct[0].Gy_ini[70,159] = -30.8306480050881
        struct[0].Gy_ini[70,160] = 208.261027274371
        struct[0].Gy_ini[70,161] = 107.907268017808
        struct[0].Gy_ini[70,283] = 1
        struct[0].Gy_ini[71,66] = -30.8306879425848
        struct[0].Gy_ini[71,67] = 59.5031506498201
        struct[0].Gy_ini[71,68] = -30.8306879425847
        struct[0].Gy_ini[71,69] = 59.5031506498202
        struct[0].Gy_ini[71,70] = 107.907168174067
        struct[0].Gy_ini[71,71] = -208.261027274371
        struct[0].Gy_ini[71,156] = 30.8306480050882
        struct[0].Gy_ini[71,157] = -59.5031506498201
        struct[0].Gy_ini[71,158] = 30.8306480050881
        struct[0].Gy_ini[71,159] = -59.5031506498202
        struct[0].Gy_ini[71,160] = -107.907268017808
        struct[0].Gy_ini[71,161] = 208.261027274371
        struct[0].Gy_ini[71,284] = 1
        struct[0].Gy_ini[72,72] = -435.745709926008
        struct[0].Gy_ini[72,73] = -225.774931516790
        struct[0].Gy_ini[72,74] = 124.498774264574
        struct[0].Gy_ini[72,75] = 64.5071560124429
        struct[0].Gy_ini[72,76] = 124.498774264574
        struct[0].Gy_ini[72,77] = 64.5071560124428
        struct[0].Gy_ini[72,168] = 435.745709926008
        struct[0].Gy_ini[72,169] = 225.774979236273
        struct[0].Gy_ini[72,170] = -124.498774264574
        struct[0].Gy_ini[72,171] = -64.5071369246495
        struct[0].Gy_ini[72,172] = -124.498774264574
        struct[0].Gy_ini[72,173] = -64.5071369246495
        struct[0].Gy_ini[72,288] = 1
        struct[0].Gy_ini[73,72] = 225.774931516790
        struct[0].Gy_ini[73,73] = -435.745709926008
        struct[0].Gy_ini[73,74] = -64.5071560124429
        struct[0].Gy_ini[73,75] = 124.498774264574
        struct[0].Gy_ini[73,76] = -64.5071560124428
        struct[0].Gy_ini[73,77] = 124.498774264574
        struct[0].Gy_ini[73,168] = -225.774979236273
        struct[0].Gy_ini[73,169] = 435.745709926008
        struct[0].Gy_ini[73,170] = 64.5071369246495
        struct[0].Gy_ini[73,171] = -124.498774264574
        struct[0].Gy_ini[73,172] = 64.5071369246495
        struct[0].Gy_ini[73,173] = -124.498774264574
        struct[0].Gy_ini[73,289] = 1
        struct[0].Gy_ini[74,72] = 124.498774264574
        struct[0].Gy_ini[74,73] = 64.5071560124428
        struct[0].Gy_ini[74,74] = -435.745709926008
        struct[0].Gy_ini[74,75] = -225.774931516790
        struct[0].Gy_ini[74,76] = 124.498774264574
        struct[0].Gy_ini[74,77] = 64.5071560124428
        struct[0].Gy_ini[74,168] = -124.498774264574
        struct[0].Gy_ini[74,169] = -64.5071369246495
        struct[0].Gy_ini[74,170] = 435.745709926008
        struct[0].Gy_ini[74,171] = 225.774979236273
        struct[0].Gy_ini[74,172] = -124.498774264574
        struct[0].Gy_ini[74,173] = -64.5071369246494
        struct[0].Gy_ini[74,290] = 1
        struct[0].Gy_ini[75,72] = -64.5071560124428
        struct[0].Gy_ini[75,73] = 124.498774264574
        struct[0].Gy_ini[75,74] = 225.774931516790
        struct[0].Gy_ini[75,75] = -435.745709926008
        struct[0].Gy_ini[75,76] = -64.5071560124428
        struct[0].Gy_ini[75,77] = 124.498774264574
        struct[0].Gy_ini[75,168] = 64.5071369246495
        struct[0].Gy_ini[75,169] = -124.498774264574
        struct[0].Gy_ini[75,170] = -225.774979236273
        struct[0].Gy_ini[75,171] = 435.745709926008
        struct[0].Gy_ini[75,172] = 64.5071369246494
        struct[0].Gy_ini[75,173] = -124.498774264574
        struct[0].Gy_ini[75,291] = 1
        struct[0].Gy_ini[76,72] = 124.498774264574
        struct[0].Gy_ini[76,73] = 64.5071560124429
        struct[0].Gy_ini[76,74] = 124.498774264574
        struct[0].Gy_ini[76,75] = 64.5071560124428
        struct[0].Gy_ini[76,76] = -435.745709926008
        struct[0].Gy_ini[76,77] = -225.774931516790
        struct[0].Gy_ini[76,168] = -124.498774264574
        struct[0].Gy_ini[76,169] = -64.5071369246495
        struct[0].Gy_ini[76,170] = -124.498774264574
        struct[0].Gy_ini[76,171] = -64.5071369246494
        struct[0].Gy_ini[76,172] = 435.745709926008
        struct[0].Gy_ini[76,173] = 225.774979236273
        struct[0].Gy_ini[76,292] = 1
        struct[0].Gy_ini[77,72] = -64.5071560124429
        struct[0].Gy_ini[77,73] = 124.498774264574
        struct[0].Gy_ini[77,74] = -64.5071560124428
        struct[0].Gy_ini[77,75] = 124.498774264574
        struct[0].Gy_ini[77,76] = 225.774931516790
        struct[0].Gy_ini[77,77] = -435.745709926008
        struct[0].Gy_ini[77,168] = 64.5071369246495
        struct[0].Gy_ini[77,169] = -124.498774264574
        struct[0].Gy_ini[77,170] = 64.5071369246494
        struct[0].Gy_ini[77,171] = -124.498774264574
        struct[0].Gy_ini[77,172] = -225.774979236273
        struct[0].Gy_ini[77,173] = 435.745709926008
        struct[0].Gy_ini[77,293] = 1
        struct[0].Gy_ini[78,78] = -0.0272349653347382
        struct[0].Gy_ini[78,79] = -0.0647773858527649
        struct[0].Gy_ini[78,80] = 0.00153045607591063
        struct[0].Gy_ini[78,81] = 0.0122436486072850
        struct[0].Gy_ini[78,82] = 0.00153045607591062
        struct[0].Gy_ini[78,83] = 0.0122436486072850
        struct[0].Gy_ini[78,84] = 0.00874773135135797
        struct[0].Gy_ini[78,85] = 0.0699818508108637
        struct[0].Gy_ini[78,86] = -0.00874773135135797
        struct[0].Gy_ini[78,87] = -0.0699818508108637
        struct[0].Gy_ini[79,78] = 0.0647773858527649
        struct[0].Gy_ini[79,79] = -0.0272349653347382
        struct[0].Gy_ini[79,80] = -0.0122436486072850
        struct[0].Gy_ini[79,81] = 0.00153045607591063
        struct[0].Gy_ini[79,82] = -0.0122436486072850
        struct[0].Gy_ini[79,83] = 0.00153045607591062
        struct[0].Gy_ini[79,84] = -0.0699818508108637
        struct[0].Gy_ini[79,85] = 0.00874773135135797
        struct[0].Gy_ini[79,86] = 0.0699818508108637
        struct[0].Gy_ini[79,87] = -0.00874773135135797
        struct[0].Gy_ini[80,78] = 0.00153045607591062
        struct[0].Gy_ini[80,79] = 0.0122436486072850
        struct[0].Gy_ini[80,80] = -0.0272349653347383
        struct[0].Gy_ini[80,81] = -0.0647773858527649
        struct[0].Gy_ini[80,82] = 0.00153045607591064
        struct[0].Gy_ini[80,83] = 0.0122436486072850
        struct[0].Gy_ini[80,86] = 0.00874773135135797
        struct[0].Gy_ini[80,87] = 0.0699818508108637
        struct[0].Gy_ini[80,88] = -0.00874773135135797
        struct[0].Gy_ini[80,89] = -0.0699818508108637
        struct[0].Gy_ini[81,78] = -0.0122436486072850
        struct[0].Gy_ini[81,79] = 0.00153045607591062
        struct[0].Gy_ini[81,80] = 0.0647773858527649
        struct[0].Gy_ini[81,81] = -0.0272349653347383
        struct[0].Gy_ini[81,82] = -0.0122436486072850
        struct[0].Gy_ini[81,83] = 0.00153045607591064
        struct[0].Gy_ini[81,86] = -0.0699818508108637
        struct[0].Gy_ini[81,87] = 0.00874773135135797
        struct[0].Gy_ini[81,88] = 0.0699818508108637
        struct[0].Gy_ini[81,89] = -0.00874773135135797
        struct[0].Gy_ini[82,78] = 0.00153045607591062
        struct[0].Gy_ini[82,79] = 0.0122436486072850
        struct[0].Gy_ini[82,80] = 0.00153045607591064
        struct[0].Gy_ini[82,81] = 0.0122436486072850
        struct[0].Gy_ini[82,82] = -0.0272349653347383
        struct[0].Gy_ini[82,83] = -0.0647773858527649
        struct[0].Gy_ini[82,84] = -0.00874773135135797
        struct[0].Gy_ini[82,85] = -0.0699818508108637
        struct[0].Gy_ini[82,88] = 0.00874773135135797
        struct[0].Gy_ini[82,89] = 0.0699818508108637
        struct[0].Gy_ini[83,78] = -0.0122436486072850
        struct[0].Gy_ini[83,79] = 0.00153045607591062
        struct[0].Gy_ini[83,80] = -0.0122436486072850
        struct[0].Gy_ini[83,81] = 0.00153045607591064
        struct[0].Gy_ini[83,82] = 0.0647773858527649
        struct[0].Gy_ini[83,83] = -0.0272349653347383
        struct[0].Gy_ini[83,84] = 0.0699818508108637
        struct[0].Gy_ini[83,85] = -0.00874773135135797
        struct[0].Gy_ini[83,88] = -0.0699818508108637
        struct[0].Gy_ini[83,89] = 0.00874773135135797
        struct[0].Gy_ini[84,78] = 0.00874773135135797
        struct[0].Gy_ini[84,79] = 0.0699818508108637
        struct[0].Gy_ini[84,82] = -0.00874773135135797
        struct[0].Gy_ini[84,83] = -0.0699818508108637
        struct[0].Gy_ini[84,84] = -24.8222322123875
        struct[0].Gy_ini[84,85] = -33.4156859296188
        struct[0].Gy_ini[84,86] = 7.06438748925360
        struct[0].Gy_ini[84,87] = 9.43309892709730
        struct[0].Gy_ini[84,88] = 7.06438748925360
        struct[0].Gy_ini[84,89] = 9.43309892709730
        struct[0].Gy_ini[84,90] = 18.2833023823143
        struct[0].Gy_ini[84,91] = 24.3777365097524
        struct[0].Gy_ini[84,92] = -5.22380068066123
        struct[0].Gy_ini[84,93] = -6.96506757421497
        struct[0].Gy_ini[84,94] = -5.22380068066123
        struct[0].Gy_ini[84,95] = -6.96506757421497
        struct[0].Gy_ini[84,114] = 6.47851216340659
        struct[0].Gy_ini[84,115] = 8.63801621787545
        struct[0].Gy_ini[84,116] = -1.85100347525903
        struct[0].Gy_ini[84,117] = -2.46800463367870
        struct[0].Gy_ini[84,118] = -1.85100347525903
        struct[0].Gy_ini[84,119] = -2.46800463367870
        struct[0].Gy_ini[85,78] = -0.0699818508108637
        struct[0].Gy_ini[85,79] = 0.00874773135135797
        struct[0].Gy_ini[85,82] = 0.0699818508108637
        struct[0].Gy_ini[85,83] = -0.00874773135135797
        struct[0].Gy_ini[85,84] = 33.4156859296188
        struct[0].Gy_ini[85,85] = -24.8222322123875
        struct[0].Gy_ini[85,86] = -9.43309892709730
        struct[0].Gy_ini[85,87] = 7.06438748925360
        struct[0].Gy_ini[85,88] = -9.43309892709730
        struct[0].Gy_ini[85,89] = 7.06438748925360
        struct[0].Gy_ini[85,90] = -24.3777365097524
        struct[0].Gy_ini[85,91] = 18.2833023823143
        struct[0].Gy_ini[85,92] = 6.96506757421497
        struct[0].Gy_ini[85,93] = -5.22380068066123
        struct[0].Gy_ini[85,94] = 6.96506757421497
        struct[0].Gy_ini[85,95] = -5.22380068066123
        struct[0].Gy_ini[85,114] = -8.63801621787545
        struct[0].Gy_ini[85,115] = 6.47851216340659
        struct[0].Gy_ini[85,116] = 2.46800463367870
        struct[0].Gy_ini[85,117] = -1.85100347525903
        struct[0].Gy_ini[85,118] = 2.46800463367870
        struct[0].Gy_ini[85,119] = -1.85100347525903
        struct[0].Gy_ini[86,78] = -0.00874773135135797
        struct[0].Gy_ini[86,79] = -0.0699818508108637
        struct[0].Gy_ini[86,80] = 0.00874773135135797
        struct[0].Gy_ini[86,81] = 0.0699818508108637
        struct[0].Gy_ini[86,84] = 7.06438748925360
        struct[0].Gy_ini[86,85] = 9.43309892709730
        struct[0].Gy_ini[86,86] = -24.8222322123876
        struct[0].Gy_ini[86,87] = -33.4156859296188
        struct[0].Gy_ini[86,88] = 7.06438748925361
        struct[0].Gy_ini[86,89] = 9.43309892709730
        struct[0].Gy_ini[86,90] = -5.22380068066123
        struct[0].Gy_ini[86,91] = -6.96506757421497
        struct[0].Gy_ini[86,92] = 18.2833023823143
        struct[0].Gy_ini[86,93] = 24.3777365097524
        struct[0].Gy_ini[86,94] = -5.22380068066124
        struct[0].Gy_ini[86,95] = -6.96506757421497
        struct[0].Gy_ini[86,114] = -1.85100347525903
        struct[0].Gy_ini[86,115] = -2.46800463367870
        struct[0].Gy_ini[86,116] = 6.47851216340659
        struct[0].Gy_ini[86,117] = 8.63801621787545
        struct[0].Gy_ini[86,118] = -1.85100347525903
        struct[0].Gy_ini[86,119] = -2.46800463367870
        struct[0].Gy_ini[87,78] = 0.0699818508108637
        struct[0].Gy_ini[87,79] = -0.00874773135135797
        struct[0].Gy_ini[87,80] = -0.0699818508108637
        struct[0].Gy_ini[87,81] = 0.00874773135135797
        struct[0].Gy_ini[87,84] = -9.43309892709730
        struct[0].Gy_ini[87,85] = 7.06438748925360
        struct[0].Gy_ini[87,86] = 33.4156859296188
        struct[0].Gy_ini[87,87] = -24.8222322123876
        struct[0].Gy_ini[87,88] = -9.43309892709730
        struct[0].Gy_ini[87,89] = 7.06438748925361
        struct[0].Gy_ini[87,90] = 6.96506757421497
        struct[0].Gy_ini[87,91] = -5.22380068066123
        struct[0].Gy_ini[87,92] = -24.3777365097524
        struct[0].Gy_ini[87,93] = 18.2833023823143
        struct[0].Gy_ini[87,94] = 6.96506757421497
        struct[0].Gy_ini[87,95] = -5.22380068066124
        struct[0].Gy_ini[87,114] = 2.46800463367870
        struct[0].Gy_ini[87,115] = -1.85100347525903
        struct[0].Gy_ini[87,116] = -8.63801621787545
        struct[0].Gy_ini[87,117] = 6.47851216340659
        struct[0].Gy_ini[87,118] = 2.46800463367870
        struct[0].Gy_ini[87,119] = -1.85100347525903
        struct[0].Gy_ini[88,80] = -0.00874773135135797
        struct[0].Gy_ini[88,81] = -0.0699818508108637
        struct[0].Gy_ini[88,82] = 0.00874773135135797
        struct[0].Gy_ini[88,83] = 0.0699818508108637
        struct[0].Gy_ini[88,84] = 7.06438748925359
        struct[0].Gy_ini[88,85] = 9.43309892709730
        struct[0].Gy_ini[88,86] = 7.06438748925361
        struct[0].Gy_ini[88,87] = 9.43309892709730
        struct[0].Gy_ini[88,88] = -24.8222322123876
        struct[0].Gy_ini[88,89] = -33.4156859296188
        struct[0].Gy_ini[88,90] = -5.22380068066123
        struct[0].Gy_ini[88,91] = -6.96506757421497
        struct[0].Gy_ini[88,92] = -5.22380068066124
        struct[0].Gy_ini[88,93] = -6.96506757421497
        struct[0].Gy_ini[88,94] = 18.2833023823143
        struct[0].Gy_ini[88,95] = 24.3777365097524
        struct[0].Gy_ini[88,114] = -1.85100347525903
        struct[0].Gy_ini[88,115] = -2.46800463367870
        struct[0].Gy_ini[88,116] = -1.85100347525903
        struct[0].Gy_ini[88,117] = -2.46800463367870
        struct[0].Gy_ini[88,118] = 6.47851216340659
        struct[0].Gy_ini[88,119] = 8.63801621787545
        struct[0].Gy_ini[89,80] = 0.0699818508108637
        struct[0].Gy_ini[89,81] = -0.00874773135135797
        struct[0].Gy_ini[89,82] = -0.0699818508108637
        struct[0].Gy_ini[89,83] = 0.00874773135135797
        struct[0].Gy_ini[89,84] = -9.43309892709730
        struct[0].Gy_ini[89,85] = 7.06438748925359
        struct[0].Gy_ini[89,86] = -9.43309892709730
        struct[0].Gy_ini[89,87] = 7.06438748925361
        struct[0].Gy_ini[89,88] = 33.4156859296188
        struct[0].Gy_ini[89,89] = -24.8222322123876
        struct[0].Gy_ini[89,90] = 6.96506757421497
        struct[0].Gy_ini[89,91] = -5.22380068066123
        struct[0].Gy_ini[89,92] = 6.96506757421497
        struct[0].Gy_ini[89,93] = -5.22380068066124
        struct[0].Gy_ini[89,94] = -24.3777365097524
        struct[0].Gy_ini[89,95] = 18.2833023823143
        struct[0].Gy_ini[89,114] = 2.46800463367870
        struct[0].Gy_ini[89,115] = -1.85100347525903
        struct[0].Gy_ini[89,116] = 2.46800463367870
        struct[0].Gy_ini[89,117] = -1.85100347525903
        struct[0].Gy_ini[89,118] = -8.63801621787545
        struct[0].Gy_ini[89,119] = 6.47851216340659
        struct[0].Gy_ini[90,84] = 18.2833023823143
        struct[0].Gy_ini[90,85] = 24.3777365097524
        struct[0].Gy_ini[90,86] = -5.22380068066123
        struct[0].Gy_ini[90,87] = -6.96506757421497
        struct[0].Gy_ini[90,88] = -5.22380068066123
        struct[0].Gy_ini[90,89] = -6.96506757421497
        struct[0].Gy_ini[90,90] = -39.5195811550486
        struct[0].Gy_ini[90,91] = -52.7347843860809
        struct[0].Gy_ini[90,92] = 11.2932394033730
        struct[0].Gy_ini[90,93] = 15.0786865705954
        struct[0].Gy_ini[90,94] = 11.2932394033730
        struct[0].Gy_ini[90,95] = 15.0786865705954
        struct[0].Gy_ini[90,96] = 0.390101533236234
        struct[0].Gy_ini[90,97] = 2.34060919941740
        struct[0].Gy_ini[90,98] = -0.390101533236234
        struct[0].Gy_ini[90,99] = -2.34060919941740
        struct[0].Gy_ini[90,102] = 21.2272697637253
        struct[0].Gy_ini[90,103] = 28.3030263516338
        struct[0].Gy_ini[90,104] = -6.06493421820724
        struct[0].Gy_ini[90,105] = -8.08657895760964
        struct[0].Gy_ini[90,106] = -6.06493421820724
        struct[0].Gy_ini[90,107] = -8.08657895760964
        struct[0].Gy_ini[91,84] = -24.3777365097524
        struct[0].Gy_ini[91,85] = 18.2833023823143
        struct[0].Gy_ini[91,86] = 6.96506757421497
        struct[0].Gy_ini[91,87] = -5.22380068066123
        struct[0].Gy_ini[91,88] = 6.96506757421497
        struct[0].Gy_ini[91,89] = -5.22380068066123
        struct[0].Gy_ini[91,90] = 52.7347843860809
        struct[0].Gy_ini[91,91] = -39.5195811550486
        struct[0].Gy_ini[91,92] = -15.0786865705954
        struct[0].Gy_ini[91,93] = 11.2932394033730
        struct[0].Gy_ini[91,94] = -15.0786865705954
        struct[0].Gy_ini[91,95] = 11.2932394033730
        struct[0].Gy_ini[91,96] = -2.34060919941740
        struct[0].Gy_ini[91,97] = 0.390101533236234
        struct[0].Gy_ini[91,98] = 2.34060919941740
        struct[0].Gy_ini[91,99] = -0.390101533236234
        struct[0].Gy_ini[91,102] = -28.3030263516338
        struct[0].Gy_ini[91,103] = 21.2272697637253
        struct[0].Gy_ini[91,104] = 8.08657895760964
        struct[0].Gy_ini[91,105] = -6.06493421820724
        struct[0].Gy_ini[91,106] = 8.08657895760964
        struct[0].Gy_ini[91,107] = -6.06493421820724
        struct[0].Gy_ini[92,84] = -5.22380068066123
        struct[0].Gy_ini[92,85] = -6.96506757421497
        struct[0].Gy_ini[92,86] = 18.2833023823143
        struct[0].Gy_ini[92,87] = 24.3777365097524
        struct[0].Gy_ini[92,88] = -5.22380068066124
        struct[0].Gy_ini[92,89] = -6.96506757421497
        struct[0].Gy_ini[92,90] = 11.2932394033730
        struct[0].Gy_ini[92,91] = 15.0786865705954
        struct[0].Gy_ini[92,92] = -39.5195811550487
        struct[0].Gy_ini[92,93] = -52.7347843860809
        struct[0].Gy_ini[92,94] = 11.2932394033730
        struct[0].Gy_ini[92,95] = 15.0786865705954
        struct[0].Gy_ini[92,98] = 0.390101533236234
        struct[0].Gy_ini[92,99] = 2.34060919941740
        struct[0].Gy_ini[92,100] = -0.390101533236234
        struct[0].Gy_ini[92,101] = -2.34060919941740
        struct[0].Gy_ini[92,102] = -6.06493421820724
        struct[0].Gy_ini[92,103] = -8.08657895760964
        struct[0].Gy_ini[92,104] = 21.2272697637253
        struct[0].Gy_ini[92,105] = 28.3030263516338
        struct[0].Gy_ini[92,106] = -6.06493421820725
        struct[0].Gy_ini[92,107] = -8.08657895760965
        struct[0].Gy_ini[93,84] = 6.96506757421497
        struct[0].Gy_ini[93,85] = -5.22380068066123
        struct[0].Gy_ini[93,86] = -24.3777365097524
        struct[0].Gy_ini[93,87] = 18.2833023823143
        struct[0].Gy_ini[93,88] = 6.96506757421497
        struct[0].Gy_ini[93,89] = -5.22380068066124
        struct[0].Gy_ini[93,90] = -15.0786865705954
        struct[0].Gy_ini[93,91] = 11.2932394033730
        struct[0].Gy_ini[93,92] = 52.7347843860809
        struct[0].Gy_ini[93,93] = -39.5195811550487
        struct[0].Gy_ini[93,94] = -15.0786865705954
        struct[0].Gy_ini[93,95] = 11.2932394033730
        struct[0].Gy_ini[93,98] = -2.34060919941740
        struct[0].Gy_ini[93,99] = 0.390101533236234
        struct[0].Gy_ini[93,100] = 2.34060919941740
        struct[0].Gy_ini[93,101] = -0.390101533236234
        struct[0].Gy_ini[93,102] = 8.08657895760964
        struct[0].Gy_ini[93,103] = -6.06493421820724
        struct[0].Gy_ini[93,104] = -28.3030263516338
        struct[0].Gy_ini[93,105] = 21.2272697637253
        struct[0].Gy_ini[93,106] = 8.08657895760965
        struct[0].Gy_ini[93,107] = -6.06493421820725
        struct[0].Gy_ini[94,84] = -5.22380068066123
        struct[0].Gy_ini[94,85] = -6.96506757421497
        struct[0].Gy_ini[94,86] = -5.22380068066124
        struct[0].Gy_ini[94,87] = -6.96506757421497
        struct[0].Gy_ini[94,88] = 18.2833023823143
        struct[0].Gy_ini[94,89] = 24.3777365097524
        struct[0].Gy_ini[94,90] = 11.2932394033730
        struct[0].Gy_ini[94,91] = 15.0786865705954
        struct[0].Gy_ini[94,92] = 11.2932394033730
        struct[0].Gy_ini[94,93] = 15.0786865705954
        struct[0].Gy_ini[94,94] = -39.5195811550487
        struct[0].Gy_ini[94,95] = -52.7347843860809
        struct[0].Gy_ini[94,96] = -0.390101533236234
        struct[0].Gy_ini[94,97] = -2.34060919941740
        struct[0].Gy_ini[94,100] = 0.390101533236234
        struct[0].Gy_ini[94,101] = 2.34060919941740
        struct[0].Gy_ini[94,102] = -6.06493421820724
        struct[0].Gy_ini[94,103] = -8.08657895760965
        struct[0].Gy_ini[94,104] = -6.06493421820725
        struct[0].Gy_ini[94,105] = -8.08657895760964
        struct[0].Gy_ini[94,106] = 21.2272697637253
        struct[0].Gy_ini[94,107] = 28.3030263516338
        struct[0].Gy_ini[95,84] = 6.96506757421497
        struct[0].Gy_ini[95,85] = -5.22380068066123
        struct[0].Gy_ini[95,86] = 6.96506757421497
        struct[0].Gy_ini[95,87] = -5.22380068066124
        struct[0].Gy_ini[95,88] = -24.3777365097524
        struct[0].Gy_ini[95,89] = 18.2833023823143
        struct[0].Gy_ini[95,90] = -15.0786865705954
        struct[0].Gy_ini[95,91] = 11.2932394033730
        struct[0].Gy_ini[95,92] = -15.0786865705954
        struct[0].Gy_ini[95,93] = 11.2932394033730
        struct[0].Gy_ini[95,94] = 52.7347843860809
        struct[0].Gy_ini[95,95] = -39.5195811550487
        struct[0].Gy_ini[95,96] = 2.34060919941740
        struct[0].Gy_ini[95,97] = -0.390101533236234
        struct[0].Gy_ini[95,100] = -2.34060919941740
        struct[0].Gy_ini[95,101] = 0.390101533236234
        struct[0].Gy_ini[95,102] = 8.08657895760965
        struct[0].Gy_ini[95,103] = -6.06493421820724
        struct[0].Gy_ini[95,104] = 8.08657895760964
        struct[0].Gy_ini[95,105] = -6.06493421820725
        struct[0].Gy_ini[95,106] = -28.3030263516338
        struct[0].Gy_ini[95,107] = 21.2272697637253
        struct[0].Gy_ini[96,0] = 172.823911824540
        struct[0].Gy_ini[96,1] = 89.5460683028705
        struct[0].Gy_ini[96,2] = -49.3782605212972
        struct[0].Gy_ini[96,3] = -25.5845909436773
        struct[0].Gy_ini[96,4] = -49.3782605212972
        struct[0].Gy_ini[96,5] = -25.5845909436773
        struct[0].Gy_ini[96,6] = 188.838681114510
        struct[0].Gy_ini[96,7] = 97.8438762251349
        struct[0].Gy_ini[96,8] = -53.9539088898601
        struct[0].Gy_ini[96,9] = -27.9553932071814
        struct[0].Gy_ini[96,10] = -53.9539088898601
        struct[0].Gy_ini[96,11] = -27.9553932071814
        struct[0].Gy_ini[96,90] = 0.390101533236234
        struct[0].Gy_ini[96,91] = 2.34060919941740
        struct[0].Gy_ini[96,94] = -0.390101533236234
        struct[0].Gy_ini[96,95] = -2.34060919941740
        struct[0].Gy_ini[96,96] = -395.446376722834
        struct[0].Gy_ini[96,97] = -390.092416801432
        struct[0].Gy_ini[96,98] = 103.332169411157
        struct[0].Gy_ini[96,99] = 53.5400763225691
        struct[0].Gy_ini[96,100] = 103.332169411157
        struct[0].Gy_ini[96,101] = 53.5400763225691
        struct[0].Gy_ini[97,0] = -89.5460683028705
        struct[0].Gy_ini[97,1] = 172.823911824540
        struct[0].Gy_ini[97,2] = 25.5845909436773
        struct[0].Gy_ini[97,3] = -49.3782605212972
        struct[0].Gy_ini[97,4] = 25.5845909436773
        struct[0].Gy_ini[97,5] = -49.3782605212972
        struct[0].Gy_ini[97,6] = -97.8438762251349
        struct[0].Gy_ini[97,7] = 188.838681114510
        struct[0].Gy_ini[97,8] = 27.9553932071814
        struct[0].Gy_ini[97,9] = -53.9539088898601
        struct[0].Gy_ini[97,10] = 27.9553932071814
        struct[0].Gy_ini[97,11] = -53.9539088898601
        struct[0].Gy_ini[97,90] = -2.34060919941740
        struct[0].Gy_ini[97,91] = 0.390101533236234
        struct[0].Gy_ini[97,94] = 2.34060919941740
        struct[0].Gy_ini[97,95] = -0.390101533236234
        struct[0].Gy_ini[97,96] = 390.092416801432
        struct[0].Gy_ini[97,97] = -395.446376722834
        struct[0].Gy_ini[97,98] = -53.5400763225691
        struct[0].Gy_ini[97,99] = 103.332169411157
        struct[0].Gy_ini[97,100] = -53.5400763225691
        struct[0].Gy_ini[97,101] = 103.332169411157
        struct[0].Gy_ini[98,0] = -49.3782605212972
        struct[0].Gy_ini[98,1] = -25.5845909436773
        struct[0].Gy_ini[98,2] = 172.823911824540
        struct[0].Gy_ini[98,3] = 89.5460683028705
        struct[0].Gy_ini[98,4] = -49.3782605212973
        struct[0].Gy_ini[98,5] = -25.5845909436773
        struct[0].Gy_ini[98,6] = -53.9539088898601
        struct[0].Gy_ini[98,7] = -27.9553932071814
        struct[0].Gy_ini[98,8] = 188.838681114510
        struct[0].Gy_ini[98,9] = 97.8438762251349
        struct[0].Gy_ini[98,10] = -53.9539088898602
        struct[0].Gy_ini[98,11] = -27.9553932071814
        struct[0].Gy_ini[98,90] = -0.390101533236234
        struct[0].Gy_ini[98,91] = -2.34060919941740
        struct[0].Gy_ini[98,92] = 0.390101533236234
        struct[0].Gy_ini[98,93] = 2.34060919941740
        struct[0].Gy_ini[98,96] = 103.332169411157
        struct[0].Gy_ini[98,97] = 53.5400763225691
        struct[0].Gy_ini[98,98] = -395.446376722835
        struct[0].Gy_ini[98,99] = -390.092416801432
        struct[0].Gy_ini[98,100] = 103.332169411157
        struct[0].Gy_ini[98,101] = 53.5400763225691
        struct[0].Gy_ini[99,0] = 25.5845909436773
        struct[0].Gy_ini[99,1] = -49.3782605212972
        struct[0].Gy_ini[99,2] = -89.5460683028705
        struct[0].Gy_ini[99,3] = 172.823911824540
        struct[0].Gy_ini[99,4] = 25.5845909436773
        struct[0].Gy_ini[99,5] = -49.3782605212973
        struct[0].Gy_ini[99,6] = 27.9553932071814
        struct[0].Gy_ini[99,7] = -53.9539088898601
        struct[0].Gy_ini[99,8] = -97.8438762251349
        struct[0].Gy_ini[99,9] = 188.838681114510
        struct[0].Gy_ini[99,10] = 27.9553932071814
        struct[0].Gy_ini[99,11] = -53.9539088898602
        struct[0].Gy_ini[99,90] = 2.34060919941740
        struct[0].Gy_ini[99,91] = -0.390101533236234
        struct[0].Gy_ini[99,92] = -2.34060919941740
        struct[0].Gy_ini[99,93] = 0.390101533236234
        struct[0].Gy_ini[99,96] = -53.5400763225691
        struct[0].Gy_ini[99,97] = 103.332169411157
        struct[0].Gy_ini[99,98] = 390.092416801432
        struct[0].Gy_ini[99,99] = -395.446376722835
        struct[0].Gy_ini[99,100] = -53.5400763225691
        struct[0].Gy_ini[99,101] = 103.332169411157
        struct[0].Gy_ini[100,0] = -49.3782605212972
        struct[0].Gy_ini[100,1] = -25.5845909436773
        struct[0].Gy_ini[100,2] = -49.3782605212973
        struct[0].Gy_ini[100,3] = -25.5845909436772
        struct[0].Gy_ini[100,4] = 172.823911824540
        struct[0].Gy_ini[100,5] = 89.5460683028705
        struct[0].Gy_ini[100,6] = -53.9539088898601
        struct[0].Gy_ini[100,7] = -27.9553932071814
        struct[0].Gy_ini[100,8] = -53.9539088898602
        struct[0].Gy_ini[100,9] = -27.9553932071813
        struct[0].Gy_ini[100,10] = 188.838681114510
        struct[0].Gy_ini[100,11] = 97.8438762251349
        struct[0].Gy_ini[100,92] = -0.390101533236234
        struct[0].Gy_ini[100,93] = -2.34060919941740
        struct[0].Gy_ini[100,94] = 0.390101533236234
        struct[0].Gy_ini[100,95] = 2.34060919941740
        struct[0].Gy_ini[100,96] = 103.332169411157
        struct[0].Gy_ini[100,97] = 53.5400763225692
        struct[0].Gy_ini[100,98] = 103.332169411157
        struct[0].Gy_ini[100,99] = 53.5400763225691
        struct[0].Gy_ini[100,100] = -395.446376722835
        struct[0].Gy_ini[100,101] = -390.092416801432
        struct[0].Gy_ini[101,0] = 25.5845909436773
        struct[0].Gy_ini[101,1] = -49.3782605212972
        struct[0].Gy_ini[101,2] = 25.5845909436772
        struct[0].Gy_ini[101,3] = -49.3782605212973
        struct[0].Gy_ini[101,4] = -89.5460683028705
        struct[0].Gy_ini[101,5] = 172.823911824540
        struct[0].Gy_ini[101,6] = 27.9553932071814
        struct[0].Gy_ini[101,7] = -53.9539088898601
        struct[0].Gy_ini[101,8] = 27.9553932071813
        struct[0].Gy_ini[101,9] = -53.9539088898602
        struct[0].Gy_ini[101,10] = -97.8438762251349
        struct[0].Gy_ini[101,11] = 188.838681114510
        struct[0].Gy_ini[101,92] = 2.34060919941740
        struct[0].Gy_ini[101,93] = -0.390101533236234
        struct[0].Gy_ini[101,94] = -2.34060919941740
        struct[0].Gy_ini[101,95] = 0.390101533236234
        struct[0].Gy_ini[101,96] = -53.5400763225692
        struct[0].Gy_ini[101,97] = 103.332169411157
        struct[0].Gy_ini[101,98] = -53.5400763225691
        struct[0].Gy_ini[101,99] = 103.332169411157
        struct[0].Gy_ini[101,100] = 390.092416801432
        struct[0].Gy_ini[101,101] = -395.446376722835
        struct[0].Gy_ini[102,90] = 21.2272697637253
        struct[0].Gy_ini[102,91] = 28.3030263516338
        struct[0].Gy_ini[102,92] = -6.06493421820724
        struct[0].Gy_ini[102,93] = -8.08657895760964
        struct[0].Gy_ini[102,94] = -6.06493421820724
        struct[0].Gy_ini[102,95] = -8.08657895760964
        struct[0].Gy_ini[102,102] = -41.6780543037020
        struct[0].Gy_ini[102,103] = -43.3991164322381
        struct[0].Gy_ini[102,104] = 11.9099460172739
        struct[0].Gy_ini[102,105] = 12.4113478527151
        struct[0].Gy_ini[102,106] = 11.9099460172739
        struct[0].Gy_ini[102,107] = 12.4113478527151
        struct[0].Gy_ini[102,108] = 0.390101533236234
        struct[0].Gy_ini[102,109] = 2.34060919941740
        struct[0].Gy_ini[102,110] = -0.390101533236234
        struct[0].Gy_ini[102,111] = -2.34060919941740
        struct[0].Gy_ini[102,126] = 20.4417755309677
        struct[0].Gy_ini[102,127] = 15.0420612397687
        struct[0].Gy_ini[102,128] = -5.84050729456220
        struct[0].Gy_ini[102,129] = -4.29773178279105
        struct[0].Gy_ini[102,130] = -5.84050729456219
        struct[0].Gy_ini[102,131] = -4.29773178279104
        struct[0].Gy_ini[103,90] = -28.3030263516338
        struct[0].Gy_ini[103,91] = 21.2272697637253
        struct[0].Gy_ini[103,92] = 8.08657895760964
        struct[0].Gy_ini[103,93] = -6.06493421820724
        struct[0].Gy_ini[103,94] = 8.08657895760964
        struct[0].Gy_ini[103,95] = -6.06493421820724
        struct[0].Gy_ini[103,102] = 43.3991164322381
        struct[0].Gy_ini[103,103] = -41.6780543037020
        struct[0].Gy_ini[103,104] = -12.4113478527151
        struct[0].Gy_ini[103,105] = 11.9099460172739
        struct[0].Gy_ini[103,106] = -12.4113478527151
        struct[0].Gy_ini[103,107] = 11.9099460172739
        struct[0].Gy_ini[103,108] = -2.34060919941740
        struct[0].Gy_ini[103,109] = 0.390101533236234
        struct[0].Gy_ini[103,110] = 2.34060919941740
        struct[0].Gy_ini[103,111] = -0.390101533236234
        struct[0].Gy_ini[103,126] = -15.0420612397687
        struct[0].Gy_ini[103,127] = 20.4417755309677
        struct[0].Gy_ini[103,128] = 4.29773178279105
        struct[0].Gy_ini[103,129] = -5.84050729456220
        struct[0].Gy_ini[103,130] = 4.29773178279104
        struct[0].Gy_ini[103,131] = -5.84050729456219
        struct[0].Gy_ini[104,90] = -6.06493421820724
        struct[0].Gy_ini[104,91] = -8.08657895760964
        struct[0].Gy_ini[104,92] = 21.2272697637253
        struct[0].Gy_ini[104,93] = 28.3030263516338
        struct[0].Gy_ini[104,94] = -6.06493421820725
        struct[0].Gy_ini[104,95] = -8.08657895760965
        struct[0].Gy_ini[104,102] = 11.9099460172739
        struct[0].Gy_ini[104,103] = 12.4113478527151
        struct[0].Gy_ini[104,104] = -41.6780543037020
        struct[0].Gy_ini[104,105] = -43.3991164322381
        struct[0].Gy_ini[104,106] = 11.9099460172740
        struct[0].Gy_ini[104,107] = 12.4113478527151
        struct[0].Gy_ini[104,110] = 0.390101533236234
        struct[0].Gy_ini[104,111] = 2.34060919941740
        struct[0].Gy_ini[104,112] = -0.390101533236234
        struct[0].Gy_ini[104,113] = -2.34060919941740
        struct[0].Gy_ini[104,126] = -5.84050729456220
        struct[0].Gy_ini[104,127] = -4.29773178279105
        struct[0].Gy_ini[104,128] = 20.4417755309677
        struct[0].Gy_ini[104,129] = 15.0420612397687
        struct[0].Gy_ini[104,130] = -5.84050729456220
        struct[0].Gy_ini[104,131] = -4.29773178279105
        struct[0].Gy_ini[105,90] = 8.08657895760964
        struct[0].Gy_ini[105,91] = -6.06493421820724
        struct[0].Gy_ini[105,92] = -28.3030263516338
        struct[0].Gy_ini[105,93] = 21.2272697637253
        struct[0].Gy_ini[105,94] = 8.08657895760965
        struct[0].Gy_ini[105,95] = -6.06493421820725
        struct[0].Gy_ini[105,102] = -12.4113478527151
        struct[0].Gy_ini[105,103] = 11.9099460172739
        struct[0].Gy_ini[105,104] = 43.3991164322381
        struct[0].Gy_ini[105,105] = -41.6780543037020
        struct[0].Gy_ini[105,106] = -12.4113478527151
        struct[0].Gy_ini[105,107] = 11.9099460172740
        struct[0].Gy_ini[105,110] = -2.34060919941740
        struct[0].Gy_ini[105,111] = 0.390101533236234
        struct[0].Gy_ini[105,112] = 2.34060919941740
        struct[0].Gy_ini[105,113] = -0.390101533236234
        struct[0].Gy_ini[105,126] = 4.29773178279105
        struct[0].Gy_ini[105,127] = -5.84050729456220
        struct[0].Gy_ini[105,128] = -15.0420612397687
        struct[0].Gy_ini[105,129] = 20.4417755309677
        struct[0].Gy_ini[105,130] = 4.29773178279105
        struct[0].Gy_ini[105,131] = -5.84050729456220
        struct[0].Gy_ini[106,90] = -6.06493421820724
        struct[0].Gy_ini[106,91] = -8.08657895760965
        struct[0].Gy_ini[106,92] = -6.06493421820725
        struct[0].Gy_ini[106,93] = -8.08657895760964
        struct[0].Gy_ini[106,94] = 21.2272697637253
        struct[0].Gy_ini[106,95] = 28.3030263516338
        struct[0].Gy_ini[106,102] = 11.9099460172739
        struct[0].Gy_ini[106,103] = 12.4113478527151
        struct[0].Gy_ini[106,104] = 11.9099460172740
        struct[0].Gy_ini[106,105] = 12.4113478527151
        struct[0].Gy_ini[106,106] = -41.6780543037020
        struct[0].Gy_ini[106,107] = -43.3991164322381
        struct[0].Gy_ini[106,108] = -0.390101533236234
        struct[0].Gy_ini[106,109] = -2.34060919941740
        struct[0].Gy_ini[106,112] = 0.390101533236234
        struct[0].Gy_ini[106,113] = 2.34060919941740
        struct[0].Gy_ini[106,126] = -5.84050729456219
        struct[0].Gy_ini[106,127] = -4.29773178279105
        struct[0].Gy_ini[106,128] = -5.84050729456221
        struct[0].Gy_ini[106,129] = -4.29773178279104
        struct[0].Gy_ini[106,130] = 20.4417755309677
        struct[0].Gy_ini[106,131] = 15.0420612397687
        struct[0].Gy_ini[107,90] = 8.08657895760965
        struct[0].Gy_ini[107,91] = -6.06493421820724
        struct[0].Gy_ini[107,92] = 8.08657895760964
        struct[0].Gy_ini[107,93] = -6.06493421820725
        struct[0].Gy_ini[107,94] = -28.3030263516338
        struct[0].Gy_ini[107,95] = 21.2272697637253
        struct[0].Gy_ini[107,102] = -12.4113478527151
        struct[0].Gy_ini[107,103] = 11.9099460172739
        struct[0].Gy_ini[107,104] = -12.4113478527151
        struct[0].Gy_ini[107,105] = 11.9099460172740
        struct[0].Gy_ini[107,106] = 43.3991164322381
        struct[0].Gy_ini[107,107] = -41.6780543037020
        struct[0].Gy_ini[107,108] = 2.34060919941740
        struct[0].Gy_ini[107,109] = -0.390101533236234
        struct[0].Gy_ini[107,112] = -2.34060919941740
        struct[0].Gy_ini[107,113] = 0.390101533236234
        struct[0].Gy_ini[107,126] = 4.29773178279105
        struct[0].Gy_ini[107,127] = -5.84050729456219
        struct[0].Gy_ini[107,128] = 4.29773178279104
        struct[0].Gy_ini[107,129] = -5.84050729456221
        struct[0].Gy_ini[107,130] = -15.0420612397687
        struct[0].Gy_ini[107,131] = 20.4417755309677
        struct[0].Gy_ini[108,12] = 207.974729711346
        struct[0].Gy_ini[108,13] = 107.758927311578
        struct[0].Gy_ini[108,14] = -59.4213513460989
        struct[0].Gy_ini[108,15] = -30.7882649461652
        struct[0].Gy_ini[108,16] = -59.4213513460989
        struct[0].Gy_ini[108,17] = -30.7882649461652
        struct[0].Gy_ini[108,18] = 112.816376232042
        struct[0].Gy_ini[108,19] = 58.4540809492443
        struct[0].Gy_ini[108,20] = -32.2332503520119
        struct[0].Gy_ini[108,21] = -16.7011659854984
        struct[0].Gy_ini[108,22] = -32.2332503520119
        struct[0].Gy_ini[108,23] = -16.7011659854984
        struct[0].Gy_ini[108,102] = 0.390101533236234
        struct[0].Gy_ini[108,103] = 2.34060919941740
        struct[0].Gy_ini[108,106] = -0.390101533236234
        struct[0].Gy_ini[108,107] = -2.34060919941740
        struct[0].Gy_ini[108,108] = -354.574889727171
        struct[0].Gy_ini[108,109] = -368.915426669025
        struct[0].Gy_ini[108,110] = 91.6546016981108
        struct[0].Gy_ini[108,111] = 47.4895446494637
        struct[0].Gy_ini[108,112] = 91.6546016981108
        struct[0].Gy_ini[108,113] = 47.4895446494637
        struct[0].Gy_ini[109,12] = -107.758927311578
        struct[0].Gy_ini[109,13] = 207.974729711346
        struct[0].Gy_ini[109,14] = 30.7882649461652
        struct[0].Gy_ini[109,15] = -59.4213513460989
        struct[0].Gy_ini[109,16] = 30.7882649461652
        struct[0].Gy_ini[109,17] = -59.4213513460989
        struct[0].Gy_ini[109,18] = -58.4540809492443
        struct[0].Gy_ini[109,19] = 112.816376232042
        struct[0].Gy_ini[109,20] = 16.7011659854984
        struct[0].Gy_ini[109,21] = -32.2332503520119
        struct[0].Gy_ini[109,22] = 16.7011659854984
        struct[0].Gy_ini[109,23] = -32.2332503520119
        struct[0].Gy_ini[109,102] = -2.34060919941740
        struct[0].Gy_ini[109,103] = 0.390101533236234
        struct[0].Gy_ini[109,106] = 2.34060919941740
        struct[0].Gy_ini[109,107] = -0.390101533236234
        struct[0].Gy_ini[109,108] = 368.915426669025
        struct[0].Gy_ini[109,109] = -354.574889727171
        struct[0].Gy_ini[109,110] = -47.4895446494637
        struct[0].Gy_ini[109,111] = 91.6546016981108
        struct[0].Gy_ini[109,112] = -47.4895446494637
        struct[0].Gy_ini[109,113] = 91.6546016981108
        struct[0].Gy_ini[110,12] = -59.4213513460989
        struct[0].Gy_ini[110,13] = -30.7882649461652
        struct[0].Gy_ini[110,14] = 207.974729711346
        struct[0].Gy_ini[110,15] = 107.758927311578
        struct[0].Gy_ini[110,16] = -59.4213513460990
        struct[0].Gy_ini[110,17] = -30.7882649461651
        struct[0].Gy_ini[110,18] = -32.2332503520119
        struct[0].Gy_ini[110,19] = -16.7011659854984
        struct[0].Gy_ini[110,20] = 112.816376232042
        struct[0].Gy_ini[110,21] = 58.4540809492443
        struct[0].Gy_ini[110,22] = -32.2332503520119
        struct[0].Gy_ini[110,23] = -16.7011659854984
        struct[0].Gy_ini[110,102] = -0.390101533236234
        struct[0].Gy_ini[110,103] = -2.34060919941740
        struct[0].Gy_ini[110,104] = 0.390101533236234
        struct[0].Gy_ini[110,105] = 2.34060919941740
        struct[0].Gy_ini[110,108] = 91.6546016981107
        struct[0].Gy_ini[110,109] = 47.4895446494636
        struct[0].Gy_ini[110,110] = -354.574889727172
        struct[0].Gy_ini[110,111] = -368.915426669025
        struct[0].Gy_ini[110,112] = 91.6546016981109
        struct[0].Gy_ini[110,113] = 47.4895446494636
        struct[0].Gy_ini[111,12] = 30.7882649461652
        struct[0].Gy_ini[111,13] = -59.4213513460989
        struct[0].Gy_ini[111,14] = -107.758927311578
        struct[0].Gy_ini[111,15] = 207.974729711346
        struct[0].Gy_ini[111,16] = 30.7882649461651
        struct[0].Gy_ini[111,17] = -59.4213513460990
        struct[0].Gy_ini[111,18] = 16.7011659854984
        struct[0].Gy_ini[111,19] = -32.2332503520119
        struct[0].Gy_ini[111,20] = -58.4540809492443
        struct[0].Gy_ini[111,21] = 112.816376232042
        struct[0].Gy_ini[111,22] = 16.7011659854984
        struct[0].Gy_ini[111,23] = -32.2332503520119
        struct[0].Gy_ini[111,102] = 2.34060919941740
        struct[0].Gy_ini[111,103] = -0.390101533236234
        struct[0].Gy_ini[111,104] = -2.34060919941740
        struct[0].Gy_ini[111,105] = 0.390101533236234
        struct[0].Gy_ini[111,108] = -47.4895446494636
        struct[0].Gy_ini[111,109] = 91.6546016981107
        struct[0].Gy_ini[111,110] = 368.915426669025
        struct[0].Gy_ini[111,111] = -354.574889727172
        struct[0].Gy_ini[111,112] = -47.4895446494636
        struct[0].Gy_ini[111,113] = 91.6546016981109
        struct[0].Gy_ini[112,12] = -59.4213513460989
        struct[0].Gy_ini[112,13] = -30.7882649461652
        struct[0].Gy_ini[112,14] = -59.4213513460990
        struct[0].Gy_ini[112,15] = -30.7882649461651
        struct[0].Gy_ini[112,16] = 207.974729711346
        struct[0].Gy_ini[112,17] = 107.758927311578
        struct[0].Gy_ini[112,18] = -32.2332503520119
        struct[0].Gy_ini[112,19] = -16.7011659854984
        struct[0].Gy_ini[112,20] = -32.2332503520119
        struct[0].Gy_ini[112,21] = -16.7011659854983
        struct[0].Gy_ini[112,22] = 112.816376232042
        struct[0].Gy_ini[112,23] = 58.4540809492443
        struct[0].Gy_ini[112,104] = -0.390101533236234
        struct[0].Gy_ini[112,105] = -2.34060919941740
        struct[0].Gy_ini[112,106] = 0.390101533236234
        struct[0].Gy_ini[112,107] = 2.34060919941740
        struct[0].Gy_ini[112,108] = 91.6546016981108
        struct[0].Gy_ini[112,109] = 47.4895446494637
        struct[0].Gy_ini[112,110] = 91.6546016981109
        struct[0].Gy_ini[112,111] = 47.4895446494636
        struct[0].Gy_ini[112,112] = -354.574889727171
        struct[0].Gy_ini[112,113] = -368.915426669025
        struct[0].Gy_ini[113,12] = 30.7882649461652
        struct[0].Gy_ini[113,13] = -59.4213513460989
        struct[0].Gy_ini[113,14] = 30.7882649461651
        struct[0].Gy_ini[113,15] = -59.4213513460990
        struct[0].Gy_ini[113,16] = -107.758927311578
        struct[0].Gy_ini[113,17] = 207.974729711346
        struct[0].Gy_ini[113,18] = 16.7011659854984
        struct[0].Gy_ini[113,19] = -32.2332503520119
        struct[0].Gy_ini[113,20] = 16.7011659854983
        struct[0].Gy_ini[113,21] = -32.2332503520119
        struct[0].Gy_ini[113,22] = -58.4540809492443
        struct[0].Gy_ini[113,23] = 112.816376232042
        struct[0].Gy_ini[113,104] = 2.34060919941740
        struct[0].Gy_ini[113,105] = -0.390101533236234
        struct[0].Gy_ini[113,106] = -2.34060919941740
        struct[0].Gy_ini[113,107] = 0.390101533236234
        struct[0].Gy_ini[113,108] = -47.4895446494637
        struct[0].Gy_ini[113,109] = 91.6546016981108
        struct[0].Gy_ini[113,110] = -47.4895446494636
        struct[0].Gy_ini[113,111] = 91.6546016981109
        struct[0].Gy_ini[113,112] = 368.915426669025
        struct[0].Gy_ini[113,113] = -354.574889727171
        struct[0].Gy_ini[114,84] = 6.47851216340659
        struct[0].Gy_ini[114,85] = 8.63801621787545
        struct[0].Gy_ini[114,86] = -1.85100347525903
        struct[0].Gy_ini[114,87] = -2.46800463367870
        struct[0].Gy_ini[114,88] = -1.85100347525903
        struct[0].Gy_ini[114,89] = -2.46800463367870
        struct[0].Gy_ini[114,114] = -39.8587546923895
        struct[0].Gy_ini[114,115] = -53.1869894021290
        struct[0].Gy_ini[114,116] = 11.3901461283275
        struct[0].Gy_ini[114,117] = 15.2079060840306
        struct[0].Gy_ini[114,118] = 11.3901461283275
        struct[0].Gy_ini[114,119] = 15.2079060840306
        struct[0].Gy_ini[114,120] = 0.390101533236234
        struct[0].Gy_ini[114,121] = 2.34060919941740
        struct[0].Gy_ini[114,122] = -0.390101533236234
        struct[0].Gy_ini[114,123] = -2.34060919941740
        struct[0].Gy_ini[114,138] = 33.3712335199739
        struct[0].Gy_ini[114,139] = 44.4949780266318
        struct[0].Gy_ini[114,140] = -9.53463814856397
        struct[0].Gy_ini[114,141] = -12.7128508647519
        struct[0].Gy_ini[114,142] = -9.53463814856397
        struct[0].Gy_ini[114,143] = -12.7128508647519
        struct[0].Gy_ini[115,84] = -8.63801621787545
        struct[0].Gy_ini[115,85] = 6.47851216340659
        struct[0].Gy_ini[115,86] = 2.46800463367870
        struct[0].Gy_ini[115,87] = -1.85100347525903
        struct[0].Gy_ini[115,88] = 2.46800463367870
        struct[0].Gy_ini[115,89] = -1.85100347525903
        struct[0].Gy_ini[115,114] = 53.1869894021290
        struct[0].Gy_ini[115,115] = -39.8587546923895
        struct[0].Gy_ini[115,116] = -15.2079060840306
        struct[0].Gy_ini[115,117] = 11.3901461283275
        struct[0].Gy_ini[115,118] = -15.2079060840306
        struct[0].Gy_ini[115,119] = 11.3901461283275
        struct[0].Gy_ini[115,120] = -2.34060919941740
        struct[0].Gy_ini[115,121] = 0.390101533236234
        struct[0].Gy_ini[115,122] = 2.34060919941740
        struct[0].Gy_ini[115,123] = -0.390101533236234
        struct[0].Gy_ini[115,138] = -44.4949780266318
        struct[0].Gy_ini[115,139] = 33.3712335199739
        struct[0].Gy_ini[115,140] = 12.7128508647519
        struct[0].Gy_ini[115,141] = -9.53463814856397
        struct[0].Gy_ini[115,142] = 12.7128508647519
        struct[0].Gy_ini[115,143] = -9.53463814856397
        struct[0].Gy_ini[116,84] = -1.85100347525903
        struct[0].Gy_ini[116,85] = -2.46800463367870
        struct[0].Gy_ini[116,86] = 6.47851216340659
        struct[0].Gy_ini[116,87] = 8.63801621787545
        struct[0].Gy_ini[116,88] = -1.85100347525903
        struct[0].Gy_ini[116,89] = -2.46800463367870
        struct[0].Gy_ini[116,114] = 11.3901461283275
        struct[0].Gy_ini[116,115] = 15.2079060840306
        struct[0].Gy_ini[116,116] = -39.8587546923895
        struct[0].Gy_ini[116,117] = -53.1869894021290
        struct[0].Gy_ini[116,118] = 11.3901461283275
        struct[0].Gy_ini[116,119] = 15.2079060840306
        struct[0].Gy_ini[116,122] = 0.390101533236234
        struct[0].Gy_ini[116,123] = 2.34060919941740
        struct[0].Gy_ini[116,124] = -0.390101533236234
        struct[0].Gy_ini[116,125] = -2.34060919941740
        struct[0].Gy_ini[116,138] = -9.53463814856397
        struct[0].Gy_ini[116,139] = -12.7128508647519
        struct[0].Gy_ini[116,140] = 33.3712335199739
        struct[0].Gy_ini[116,141] = 44.4949780266318
        struct[0].Gy_ini[116,142] = -9.53463814856399
        struct[0].Gy_ini[116,143] = -12.7128508647520
        struct[0].Gy_ini[117,84] = 2.46800463367870
        struct[0].Gy_ini[117,85] = -1.85100347525903
        struct[0].Gy_ini[117,86] = -8.63801621787545
        struct[0].Gy_ini[117,87] = 6.47851216340659
        struct[0].Gy_ini[117,88] = 2.46800463367870
        struct[0].Gy_ini[117,89] = -1.85100347525903
        struct[0].Gy_ini[117,114] = -15.2079060840306
        struct[0].Gy_ini[117,115] = 11.3901461283275
        struct[0].Gy_ini[117,116] = 53.1869894021290
        struct[0].Gy_ini[117,117] = -39.8587546923895
        struct[0].Gy_ini[117,118] = -15.2079060840306
        struct[0].Gy_ini[117,119] = 11.3901461283275
        struct[0].Gy_ini[117,122] = -2.34060919941740
        struct[0].Gy_ini[117,123] = 0.390101533236234
        struct[0].Gy_ini[117,124] = 2.34060919941740
        struct[0].Gy_ini[117,125] = -0.390101533236234
        struct[0].Gy_ini[117,138] = 12.7128508647519
        struct[0].Gy_ini[117,139] = -9.53463814856397
        struct[0].Gy_ini[117,140] = -44.4949780266318
        struct[0].Gy_ini[117,141] = 33.3712335199739
        struct[0].Gy_ini[117,142] = 12.7128508647520
        struct[0].Gy_ini[117,143] = -9.53463814856399
        struct[0].Gy_ini[118,84] = -1.85100347525903
        struct[0].Gy_ini[118,85] = -2.46800463367870
        struct[0].Gy_ini[118,86] = -1.85100347525903
        struct[0].Gy_ini[118,87] = -2.46800463367870
        struct[0].Gy_ini[118,88] = 6.47851216340659
        struct[0].Gy_ini[118,89] = 8.63801621787545
        struct[0].Gy_ini[118,114] = 11.3901461283275
        struct[0].Gy_ini[118,115] = 15.2079060840306
        struct[0].Gy_ini[118,116] = 11.3901461283275
        struct[0].Gy_ini[118,117] = 15.2079060840306
        struct[0].Gy_ini[118,118] = -39.8587546923895
        struct[0].Gy_ini[118,119] = -53.1869894021290
        struct[0].Gy_ini[118,120] = -0.390101533236234
        struct[0].Gy_ini[118,121] = -2.34060919941740
        struct[0].Gy_ini[118,124] = 0.390101533236234
        struct[0].Gy_ini[118,125] = 2.34060919941740
        struct[0].Gy_ini[118,138] = -9.53463814856397
        struct[0].Gy_ini[118,139] = -12.7128508647519
        struct[0].Gy_ini[118,140] = -9.53463814856399
        struct[0].Gy_ini[118,141] = -12.7128508647520
        struct[0].Gy_ini[118,142] = 33.3712335199739
        struct[0].Gy_ini[118,143] = 44.4949780266318
        struct[0].Gy_ini[119,84] = 2.46800463367870
        struct[0].Gy_ini[119,85] = -1.85100347525903
        struct[0].Gy_ini[119,86] = 2.46800463367870
        struct[0].Gy_ini[119,87] = -1.85100347525903
        struct[0].Gy_ini[119,88] = -8.63801621787545
        struct[0].Gy_ini[119,89] = 6.47851216340659
        struct[0].Gy_ini[119,114] = -15.2079060840306
        struct[0].Gy_ini[119,115] = 11.3901461283275
        struct[0].Gy_ini[119,116] = -15.2079060840306
        struct[0].Gy_ini[119,117] = 11.3901461283275
        struct[0].Gy_ini[119,118] = 53.1869894021290
        struct[0].Gy_ini[119,119] = -39.8587546923895
        struct[0].Gy_ini[119,120] = 2.34060919941740
        struct[0].Gy_ini[119,121] = -0.390101533236234
        struct[0].Gy_ini[119,124] = -2.34060919941740
        struct[0].Gy_ini[119,125] = 0.390101533236234
        struct[0].Gy_ini[119,138] = 12.7128508647519
        struct[0].Gy_ini[119,139] = -9.53463814856397
        struct[0].Gy_ini[119,140] = 12.7128508647520
        struct[0].Gy_ini[119,141] = -9.53463814856399
        struct[0].Gy_ini[119,142] = -44.4949780266318
        struct[0].Gy_ini[119,143] = 33.3712335199739
        struct[0].Gy_ini[120,24] = 178.886372244962
        struct[0].Gy_ini[120,25] = 92.6872395051616
        struct[0].Gy_ini[120,26] = -51.1103920699891
        struct[0].Gy_ini[120,27] = -26.4820684300462
        struct[0].Gy_ini[120,28] = -51.1103920699891
        struct[0].Gy_ini[120,29] = -26.4820684300462
        struct[0].Gy_ini[120,30] = 112.904579802783
        struct[0].Gy_ini[120,31] = 58.4997822812349
        struct[0].Gy_ini[120,32] = -32.2584513722238
        struct[0].Gy_ini[120,33] = -16.7142235089243
        struct[0].Gy_ini[120,34] = -32.2584513722239
        struct[0].Gy_ini[120,35] = -16.7142235089243
        struct[0].Gy_ini[120,114] = 0.390101533236234
        struct[0].Gy_ini[120,115] = 2.34060919941740
        struct[0].Gy_ini[120,118] = -0.390101533236234
        struct[0].Gy_ini[120,119] = -2.34060919941740
        struct[0].Gy_ini[120,120] = -325.574735831529
        struct[0].Gy_ini[120,121] = -353.889424080847
        struct[0].Gy_ini[120,122] = 83.3688434422129
        struct[0].Gy_ini[120,123] = 43.1964121022714
        struct[0].Gy_ini[120,124] = 83.3688434422130
        struct[0].Gy_ini[120,125] = 43.1964121022714
        struct[0].Gy_ini[121,24] = -92.6872395051616
        struct[0].Gy_ini[121,25] = 178.886372244962
        struct[0].Gy_ini[121,26] = 26.4820684300462
        struct[0].Gy_ini[121,27] = -51.1103920699891
        struct[0].Gy_ini[121,28] = 26.4820684300462
        struct[0].Gy_ini[121,29] = -51.1103920699891
        struct[0].Gy_ini[121,30] = -58.4997822812349
        struct[0].Gy_ini[121,31] = 112.904579802783
        struct[0].Gy_ini[121,32] = 16.7142235089243
        struct[0].Gy_ini[121,33] = -32.2584513722238
        struct[0].Gy_ini[121,34] = 16.7142235089243
        struct[0].Gy_ini[121,35] = -32.2584513722239
        struct[0].Gy_ini[121,114] = -2.34060919941740
        struct[0].Gy_ini[121,115] = 0.390101533236234
        struct[0].Gy_ini[121,118] = 2.34060919941740
        struct[0].Gy_ini[121,119] = -0.390101533236234
        struct[0].Gy_ini[121,120] = 353.889424080847
        struct[0].Gy_ini[121,121] = -325.574735831529
        struct[0].Gy_ini[121,122] = -43.1964121022714
        struct[0].Gy_ini[121,123] = 83.3688434422129
        struct[0].Gy_ini[121,124] = -43.1964121022714
        struct[0].Gy_ini[121,125] = 83.3688434422130
        struct[0].Gy_ini[122,24] = -51.1103920699891
        struct[0].Gy_ini[122,25] = -26.4820684300461
        struct[0].Gy_ini[122,26] = 178.886372244962
        struct[0].Gy_ini[122,27] = 92.6872395051615
        struct[0].Gy_ini[122,28] = -51.1103920699892
        struct[0].Gy_ini[122,29] = -26.4820684300461
        struct[0].Gy_ini[122,30] = -32.2584513722238
        struct[0].Gy_ini[122,31] = -16.7142235089243
        struct[0].Gy_ini[122,32] = 112.904579802783
        struct[0].Gy_ini[122,33] = 58.4997822812349
        struct[0].Gy_ini[122,34] = -32.2584513722239
        struct[0].Gy_ini[122,35] = -16.7142235089242
        struct[0].Gy_ini[122,114] = -0.390101533236234
        struct[0].Gy_ini[122,115] = -2.34060919941740
        struct[0].Gy_ini[122,116] = 0.390101533236234
        struct[0].Gy_ini[122,117] = 2.34060919941740
        struct[0].Gy_ini[122,120] = 83.3688434422129
        struct[0].Gy_ini[122,121] = 43.1964121022714
        struct[0].Gy_ini[122,122] = -325.574735831529
        struct[0].Gy_ini[122,123] = -353.889424080846
        struct[0].Gy_ini[122,124] = 83.3688434422131
        struct[0].Gy_ini[122,125] = 43.1964121022714
        struct[0].Gy_ini[123,24] = 26.4820684300461
        struct[0].Gy_ini[123,25] = -51.1103920699891
        struct[0].Gy_ini[123,26] = -92.6872395051615
        struct[0].Gy_ini[123,27] = 178.886372244962
        struct[0].Gy_ini[123,28] = 26.4820684300461
        struct[0].Gy_ini[123,29] = -51.1103920699892
        struct[0].Gy_ini[123,30] = 16.7142235089243
        struct[0].Gy_ini[123,31] = -32.2584513722238
        struct[0].Gy_ini[123,32] = -58.4997822812349
        struct[0].Gy_ini[123,33] = 112.904579802783
        struct[0].Gy_ini[123,34] = 16.7142235089242
        struct[0].Gy_ini[123,35] = -32.2584513722239
        struct[0].Gy_ini[123,114] = 2.34060919941740
        struct[0].Gy_ini[123,115] = -0.390101533236234
        struct[0].Gy_ini[123,116] = -2.34060919941740
        struct[0].Gy_ini[123,117] = 0.390101533236234
        struct[0].Gy_ini[123,120] = -43.1964121022714
        struct[0].Gy_ini[123,121] = 83.3688434422129
        struct[0].Gy_ini[123,122] = 353.889424080846
        struct[0].Gy_ini[123,123] = -325.574735831529
        struct[0].Gy_ini[123,124] = -43.1964121022714
        struct[0].Gy_ini[123,125] = 83.3688434422131
        struct[0].Gy_ini[124,24] = -51.1103920699891
        struct[0].Gy_ini[124,25] = -26.4820684300462
        struct[0].Gy_ini[124,26] = -51.1103920699892
        struct[0].Gy_ini[124,27] = -26.4820684300461
        struct[0].Gy_ini[124,28] = 178.886372244962
        struct[0].Gy_ini[124,29] = 92.6872395051615
        struct[0].Gy_ini[124,30] = -32.2584513722239
        struct[0].Gy_ini[124,31] = -16.7142235089243
        struct[0].Gy_ini[124,32] = -32.2584513722239
        struct[0].Gy_ini[124,33] = -16.7142235089242
        struct[0].Gy_ini[124,34] = 112.904579802783
        struct[0].Gy_ini[124,35] = 58.4997822812349
        struct[0].Gy_ini[124,116] = -0.390101533236234
        struct[0].Gy_ini[124,117] = -2.34060919941740
        struct[0].Gy_ini[124,118] = 0.390101533236234
        struct[0].Gy_ini[124,119] = 2.34060919941740
        struct[0].Gy_ini[124,120] = 83.3688434422130
        struct[0].Gy_ini[124,121] = 43.1964121022714
        struct[0].Gy_ini[124,122] = 83.3688434422131
        struct[0].Gy_ini[124,123] = 43.1964121022714
        struct[0].Gy_ini[124,124] = -325.574735831529
        struct[0].Gy_ini[124,125] = -353.889424080846
        struct[0].Gy_ini[125,24] = 26.4820684300462
        struct[0].Gy_ini[125,25] = -51.1103920699891
        struct[0].Gy_ini[125,26] = 26.4820684300461
        struct[0].Gy_ini[125,27] = -51.1103920699892
        struct[0].Gy_ini[125,28] = -92.6872395051615
        struct[0].Gy_ini[125,29] = 178.886372244962
        struct[0].Gy_ini[125,30] = 16.7142235089243
        struct[0].Gy_ini[125,31] = -32.2584513722239
        struct[0].Gy_ini[125,32] = 16.7142235089242
        struct[0].Gy_ini[125,33] = -32.2584513722239
        struct[0].Gy_ini[125,34] = -58.4997822812349
        struct[0].Gy_ini[125,35] = 112.904579802783
        struct[0].Gy_ini[125,116] = 2.34060919941740
        struct[0].Gy_ini[125,117] = -0.390101533236234
        struct[0].Gy_ini[125,118] = -2.34060919941740
        struct[0].Gy_ini[125,119] = 0.390101533236234
        struct[0].Gy_ini[125,120] = -43.1964121022714
        struct[0].Gy_ini[125,121] = 83.3688434422130
        struct[0].Gy_ini[125,122] = -43.1964121022714
        struct[0].Gy_ini[125,123] = 83.3688434422131
        struct[0].Gy_ini[125,124] = 353.889424080846
        struct[0].Gy_ini[125,125] = -325.574735831529
        struct[0].Gy_ini[126,102] = 20.4417755309677
        struct[0].Gy_ini[126,103] = 15.0420612397687
        struct[0].Gy_ini[126,104] = -5.84050729456220
        struct[0].Gy_ini[126,105] = -4.29773178279105
        struct[0].Gy_ini[126,106] = -5.84050729456219
        struct[0].Gy_ini[126,107] = -4.29773178279104
        struct[0].Gy_ini[126,126] = -29.4212199578516
        struct[0].Gy_ini[126,127] = -21.6969684194189
        struct[0].Gy_ini[126,128] = 8.40799334703096
        struct[0].Gy_ini[126,129] = 6.21073968956929
        struct[0].Gy_ini[126,130] = 8.40799334703096
        struct[0].Gy_ini[126,131] = 6.21073968956928
        struct[0].Gy_ini[126,132] = 0.390101533236234
        struct[0].Gy_ini[126,133] = 2.34060919941740
        struct[0].Gy_ini[126,134] = -0.390101533236234
        struct[0].Gy_ini[126,135] = -2.34060919941740
        struct[0].Gy_ini[126,162] = 8.97043541787489
        struct[0].Gy_ini[126,163] = 6.60088643956832
        struct[0].Gy_ini[126,164] = -2.56298154796426
        struct[0].Gy_ini[126,165] = -1.88596755416238
        struct[0].Gy_ini[126,166] = -2.56298154796426
        struct[0].Gy_ini[126,167] = -1.88596755416237
        struct[0].Gy_ini[127,102] = -15.0420612397687
        struct[0].Gy_ini[127,103] = 20.4417755309677
        struct[0].Gy_ini[127,104] = 4.29773178279105
        struct[0].Gy_ini[127,105] = -5.84050729456220
        struct[0].Gy_ini[127,106] = 4.29773178279104
        struct[0].Gy_ini[127,107] = -5.84050729456219
        struct[0].Gy_ini[127,126] = 21.6969684194189
        struct[0].Gy_ini[127,127] = -29.4212199578516
        struct[0].Gy_ini[127,128] = -6.21073968956929
        struct[0].Gy_ini[127,129] = 8.40799334703096
        struct[0].Gy_ini[127,130] = -6.21073968956928
        struct[0].Gy_ini[127,131] = 8.40799334703096
        struct[0].Gy_ini[127,132] = -2.34060919941740
        struct[0].Gy_ini[127,133] = 0.390101533236234
        struct[0].Gy_ini[127,134] = 2.34060919941740
        struct[0].Gy_ini[127,135] = -0.390101533236234
        struct[0].Gy_ini[127,162] = -6.60088643956832
        struct[0].Gy_ini[127,163] = 8.97043541787489
        struct[0].Gy_ini[127,164] = 1.88596755416238
        struct[0].Gy_ini[127,165] = -2.56298154796426
        struct[0].Gy_ini[127,166] = 1.88596755416237
        struct[0].Gy_ini[127,167] = -2.56298154796426
        struct[0].Gy_ini[128,102] = -5.84050729456220
        struct[0].Gy_ini[128,103] = -4.29773178279105
        struct[0].Gy_ini[128,104] = 20.4417755309677
        struct[0].Gy_ini[128,105] = 15.0420612397687
        struct[0].Gy_ini[128,106] = -5.84050729456220
        struct[0].Gy_ini[128,107] = -4.29773178279105
        struct[0].Gy_ini[128,126] = 8.40799334703096
        struct[0].Gy_ini[128,127] = 6.21073968956929
        struct[0].Gy_ini[128,128] = -29.4212199578516
        struct[0].Gy_ini[128,129] = -21.6969684194189
        struct[0].Gy_ini[128,130] = 8.40799334703097
        struct[0].Gy_ini[128,131] = 6.21073968956929
        struct[0].Gy_ini[128,134] = 0.390101533236234
        struct[0].Gy_ini[128,135] = 2.34060919941740
        struct[0].Gy_ini[128,136] = -0.390101533236234
        struct[0].Gy_ini[128,137] = -2.34060919941740
        struct[0].Gy_ini[128,162] = -2.56298154796426
        struct[0].Gy_ini[128,163] = -1.88596755416238
        struct[0].Gy_ini[128,164] = 8.97043541787490
        struct[0].Gy_ini[128,165] = 6.60088643956832
        struct[0].Gy_ini[128,166] = -2.56298154796426
        struct[0].Gy_ini[128,167] = -1.88596755416237
        struct[0].Gy_ini[129,102] = 4.29773178279105
        struct[0].Gy_ini[129,103] = -5.84050729456220
        struct[0].Gy_ini[129,104] = -15.0420612397687
        struct[0].Gy_ini[129,105] = 20.4417755309677
        struct[0].Gy_ini[129,106] = 4.29773178279105
        struct[0].Gy_ini[129,107] = -5.84050729456220
        struct[0].Gy_ini[129,126] = -6.21073968956929
        struct[0].Gy_ini[129,127] = 8.40799334703096
        struct[0].Gy_ini[129,128] = 21.6969684194189
        struct[0].Gy_ini[129,129] = -29.4212199578516
        struct[0].Gy_ini[129,130] = -6.21073968956929
        struct[0].Gy_ini[129,131] = 8.40799334703097
        struct[0].Gy_ini[129,134] = -2.34060919941740
        struct[0].Gy_ini[129,135] = 0.390101533236234
        struct[0].Gy_ini[129,136] = 2.34060919941740
        struct[0].Gy_ini[129,137] = -0.390101533236234
        struct[0].Gy_ini[129,162] = 1.88596755416238
        struct[0].Gy_ini[129,163] = -2.56298154796426
        struct[0].Gy_ini[129,164] = -6.60088643956832
        struct[0].Gy_ini[129,165] = 8.97043541787490
        struct[0].Gy_ini[129,166] = 1.88596755416237
        struct[0].Gy_ini[129,167] = -2.56298154796426
        struct[0].Gy_ini[130,102] = -5.84050729456219
        struct[0].Gy_ini[130,103] = -4.29773178279105
        struct[0].Gy_ini[130,104] = -5.84050729456221
        struct[0].Gy_ini[130,105] = -4.29773178279104
        struct[0].Gy_ini[130,106] = 20.4417755309677
        struct[0].Gy_ini[130,107] = 15.0420612397687
        struct[0].Gy_ini[130,126] = 8.40799334703095
        struct[0].Gy_ini[130,127] = 6.21073968956929
        struct[0].Gy_ini[130,128] = 8.40799334703097
        struct[0].Gy_ini[130,129] = 6.21073968956928
        struct[0].Gy_ini[130,130] = -29.4212199578516
        struct[0].Gy_ini[130,131] = -21.6969684194189
        struct[0].Gy_ini[130,132] = -0.390101533236234
        struct[0].Gy_ini[130,133] = -2.34060919941740
        struct[0].Gy_ini[130,136] = 0.390101533236234
        struct[0].Gy_ini[130,137] = 2.34060919941740
        struct[0].Gy_ini[130,162] = -2.56298154796426
        struct[0].Gy_ini[130,163] = -1.88596755416237
        struct[0].Gy_ini[130,164] = -2.56298154796426
        struct[0].Gy_ini[130,165] = -1.88596755416237
        struct[0].Gy_ini[130,166] = 8.97043541787490
        struct[0].Gy_ini[130,167] = 6.60088643956831
        struct[0].Gy_ini[131,102] = 4.29773178279105
        struct[0].Gy_ini[131,103] = -5.84050729456219
        struct[0].Gy_ini[131,104] = 4.29773178279104
        struct[0].Gy_ini[131,105] = -5.84050729456221
        struct[0].Gy_ini[131,106] = -15.0420612397687
        struct[0].Gy_ini[131,107] = 20.4417755309677
        struct[0].Gy_ini[131,126] = -6.21073968956929
        struct[0].Gy_ini[131,127] = 8.40799334703095
        struct[0].Gy_ini[131,128] = -6.21073968956928
        struct[0].Gy_ini[131,129] = 8.40799334703097
        struct[0].Gy_ini[131,130] = 21.6969684194189
        struct[0].Gy_ini[131,131] = -29.4212199578516
        struct[0].Gy_ini[131,132] = 2.34060919941740
        struct[0].Gy_ini[131,133] = -0.390101533236234
        struct[0].Gy_ini[131,136] = -2.34060919941740
        struct[0].Gy_ini[131,137] = 0.390101533236234
        struct[0].Gy_ini[131,162] = 1.88596755416237
        struct[0].Gy_ini[131,163] = -2.56298154796426
        struct[0].Gy_ini[131,164] = 1.88596755416237
        struct[0].Gy_ini[131,165] = -2.56298154796426
        struct[0].Gy_ini[131,166] = -6.60088643956831
        struct[0].Gy_ini[131,167] = 8.97043541787490
        struct[0].Gy_ini[132,36] = 474.891176542679
        struct[0].Gy_ini[132,37] = 246.057604426258
        struct[0].Gy_ini[132,38] = -135.683193297908
        struct[0].Gy_ini[132,39] = -70.3021726932167
        struct[0].Gy_ini[132,40] = -135.683193297908
        struct[0].Gy_ini[132,41] = -70.3021726932166
        struct[0].Gy_ini[132,42] = 206.112752761809
        struct[0].Gy_ini[132,43] = 106.794172415445
        struct[0].Gy_ini[132,44] = -58.8893579319454
        struct[0].Gy_ini[132,45] = -30.5126206901271
        struct[0].Gy_ini[132,46] = -58.8893579319454
        struct[0].Gy_ini[132,47] = -30.5126206901271
        struct[0].Gy_ini[132,126] = 0.390101533236234
        struct[0].Gy_ini[132,127] = 2.34060919941740
        struct[0].Gy_ini[132,130] = -0.390101533236234
        struct[0].Gy_ini[132,131] = -2.34060919941740
        struct[0].Gy_ini[132,132] = -714.787713088272
        struct[0].Gy_ini[132,133] = -555.554334874064
        struct[0].Gy_ini[132,134] = 194.572551229854
        struct[0].Gy_ini[132,135] = 100.814851251480
        struct[0].Gy_ini[132,136] = 194.572551229854
        struct[0].Gy_ini[132,137] = 100.814851251480
        struct[0].Gy_ini[133,36] = -246.057604426258
        struct[0].Gy_ini[133,37] = 474.891176542679
        struct[0].Gy_ini[133,38] = 70.3021726932167
        struct[0].Gy_ini[133,39] = -135.683193297908
        struct[0].Gy_ini[133,40] = 70.3021726932166
        struct[0].Gy_ini[133,41] = -135.683193297908
        struct[0].Gy_ini[133,42] = -106.794172415445
        struct[0].Gy_ini[133,43] = 206.112752761809
        struct[0].Gy_ini[133,44] = 30.5126206901271
        struct[0].Gy_ini[133,45] = -58.8893579319454
        struct[0].Gy_ini[133,46] = 30.5126206901271
        struct[0].Gy_ini[133,47] = -58.8893579319454
        struct[0].Gy_ini[133,126] = -2.34060919941740
        struct[0].Gy_ini[133,127] = 0.390101533236234
        struct[0].Gy_ini[133,130] = 2.34060919941740
        struct[0].Gy_ini[133,131] = -0.390101533236234
        struct[0].Gy_ini[133,132] = 555.554334874064
        struct[0].Gy_ini[133,133] = -714.787713088272
        struct[0].Gy_ini[133,134] = -100.814851251480
        struct[0].Gy_ini[133,135] = 194.572551229854
        struct[0].Gy_ini[133,136] = -100.814851251480
        struct[0].Gy_ini[133,137] = 194.572551229854
        struct[0].Gy_ini[134,36] = -135.683193297908
        struct[0].Gy_ini[134,37] = -70.3021726932166
        struct[0].Gy_ini[134,38] = 474.891176542679
        struct[0].Gy_ini[134,39] = 246.057604426258
        struct[0].Gy_ini[134,40] = -135.683193297909
        struct[0].Gy_ini[134,41] = -70.3021726932165
        struct[0].Gy_ini[134,42] = -58.8893579319454
        struct[0].Gy_ini[134,43] = -30.5126206901271
        struct[0].Gy_ini[134,44] = 206.112752761809
        struct[0].Gy_ini[134,45] = 106.794172415445
        struct[0].Gy_ini[134,46] = -58.8893579319455
        struct[0].Gy_ini[134,47] = -30.5126206901271
        struct[0].Gy_ini[134,126] = -0.390101533236234
        struct[0].Gy_ini[134,127] = -2.34060919941740
        struct[0].Gy_ini[134,128] = 0.390101533236234
        struct[0].Gy_ini[134,129] = 2.34060919941740
        struct[0].Gy_ini[134,132] = 194.572551229854
        struct[0].Gy_ini[134,133] = 100.814851251480
        struct[0].Gy_ini[134,134] = -714.787713088272
        struct[0].Gy_ini[134,135] = -555.554334874064
        struct[0].Gy_ini[134,136] = 194.572551229854
        struct[0].Gy_ini[134,137] = 100.814851251480
        struct[0].Gy_ini[135,36] = 70.3021726932166
        struct[0].Gy_ini[135,37] = -135.683193297908
        struct[0].Gy_ini[135,38] = -246.057604426258
        struct[0].Gy_ini[135,39] = 474.891176542679
        struct[0].Gy_ini[135,40] = 70.3021726932165
        struct[0].Gy_ini[135,41] = -135.683193297909
        struct[0].Gy_ini[135,42] = 30.5126206901271
        struct[0].Gy_ini[135,43] = -58.8893579319454
        struct[0].Gy_ini[135,44] = -106.794172415445
        struct[0].Gy_ini[135,45] = 206.112752761809
        struct[0].Gy_ini[135,46] = 30.5126206901271
        struct[0].Gy_ini[135,47] = -58.8893579319455
        struct[0].Gy_ini[135,126] = 2.34060919941740
        struct[0].Gy_ini[135,127] = -0.390101533236234
        struct[0].Gy_ini[135,128] = -2.34060919941740
        struct[0].Gy_ini[135,129] = 0.390101533236234
        struct[0].Gy_ini[135,132] = -100.814851251480
        struct[0].Gy_ini[135,133] = 194.572551229854
        struct[0].Gy_ini[135,134] = 555.554334874064
        struct[0].Gy_ini[135,135] = -714.787713088272
        struct[0].Gy_ini[135,136] = -100.814851251480
        struct[0].Gy_ini[135,137] = 194.572551229854
        struct[0].Gy_ini[136,36] = -135.683193297908
        struct[0].Gy_ini[136,37] = -70.3021726932167
        struct[0].Gy_ini[136,38] = -135.683193297909
        struct[0].Gy_ini[136,39] = -70.3021726932165
        struct[0].Gy_ini[136,40] = 474.891176542679
        struct[0].Gy_ini[136,41] = 246.057604426258
        struct[0].Gy_ini[136,42] = -58.8893579319454
        struct[0].Gy_ini[136,43] = -30.5126206901272
        struct[0].Gy_ini[136,44] = -58.8893579319455
        struct[0].Gy_ini[136,45] = -30.5126206901271
        struct[0].Gy_ini[136,46] = 206.112752761809
        struct[0].Gy_ini[136,47] = 106.794172415445
        struct[0].Gy_ini[136,128] = -0.390101533236234
        struct[0].Gy_ini[136,129] = -2.34060919941740
        struct[0].Gy_ini[136,130] = 0.390101533236234
        struct[0].Gy_ini[136,131] = 2.34060919941740
        struct[0].Gy_ini[136,132] = 194.572551229854
        struct[0].Gy_ini[136,133] = 100.814851251481
        struct[0].Gy_ini[136,134] = 194.572551229854
        struct[0].Gy_ini[136,135] = 100.814851251480
        struct[0].Gy_ini[136,136] = -714.787713088272
        struct[0].Gy_ini[136,137] = -555.554334874064
        struct[0].Gy_ini[137,36] = 70.3021726932167
        struct[0].Gy_ini[137,37] = -135.683193297908
        struct[0].Gy_ini[137,38] = 70.3021726932165
        struct[0].Gy_ini[137,39] = -135.683193297909
        struct[0].Gy_ini[137,40] = -246.057604426258
        struct[0].Gy_ini[137,41] = 474.891176542679
        struct[0].Gy_ini[137,42] = 30.5126206901272
        struct[0].Gy_ini[137,43] = -58.8893579319454
        struct[0].Gy_ini[137,44] = 30.5126206901271
        struct[0].Gy_ini[137,45] = -58.8893579319455
        struct[0].Gy_ini[137,46] = -106.794172415445
        struct[0].Gy_ini[137,47] = 206.112752761809
        struct[0].Gy_ini[137,128] = 2.34060919941740
        struct[0].Gy_ini[137,129] = -0.390101533236234
        struct[0].Gy_ini[137,130] = -2.34060919941740
        struct[0].Gy_ini[137,131] = 0.390101533236234
        struct[0].Gy_ini[137,132] = -100.814851251481
        struct[0].Gy_ini[137,133] = 194.572551229854
        struct[0].Gy_ini[137,134] = -100.814851251480
        struct[0].Gy_ini[137,135] = 194.572551229854
        struct[0].Gy_ini[137,136] = 555.554334874064
        struct[0].Gy_ini[137,137] = -714.787713088272
        struct[0].Gy_ini[138,114] = 33.3712335199739
        struct[0].Gy_ini[138,115] = 44.4949780266318
        struct[0].Gy_ini[138,116] = -9.53463814856397
        struct[0].Gy_ini[138,117] = -12.7128508647519
        struct[0].Gy_ini[138,118] = -9.53463814856397
        struct[0].Gy_ini[138,119] = -12.7128508647519
        struct[0].Gy_ini[138,138] = -45.4206934070654
        struct[0].Gy_ini[138,139] = -53.4089596754468
        struct[0].Gy_ini[138,140] = 12.9792714753778
        struct[0].Gy_ini[138,141] = 15.2713041702548
        struct[0].Gy_ini[138,142] = 12.9792714753778
        struct[0].Gy_ini[138,143] = 15.2713041702547
        struct[0].Gy_ini[138,144] = 0.390101533236234
        struct[0].Gy_ini[138,145] = 2.34060919941740
        struct[0].Gy_ini[138,146] = -0.390101533236234
        struct[0].Gy_ini[138,147] = -2.34060919941740
        struct[0].Gy_ini[138,150] = 12.0404508780825
        struct[0].Gy_ini[138,151] = 8.85995441972108
        struct[0].Gy_ini[138,152] = -3.44012882230928
        struct[0].Gy_ini[138,153] = -2.53141554849174
        struct[0].Gy_ini[138,154] = -3.44012882230929
        struct[0].Gy_ini[138,155] = -2.53141554849173
        struct[0].Gy_ini[139,114] = -44.4949780266318
        struct[0].Gy_ini[139,115] = 33.3712335199739
        struct[0].Gy_ini[139,116] = 12.7128508647519
        struct[0].Gy_ini[139,117] = -9.53463814856397
        struct[0].Gy_ini[139,118] = 12.7128508647519
        struct[0].Gy_ini[139,119] = -9.53463814856397
        struct[0].Gy_ini[139,138] = 53.4089596754468
        struct[0].Gy_ini[139,139] = -45.4206934070654
        struct[0].Gy_ini[139,140] = -15.2713041702548
        struct[0].Gy_ini[139,141] = 12.9792714753778
        struct[0].Gy_ini[139,142] = -15.2713041702547
        struct[0].Gy_ini[139,143] = 12.9792714753778
        struct[0].Gy_ini[139,144] = -2.34060919941740
        struct[0].Gy_ini[139,145] = 0.390101533236234
        struct[0].Gy_ini[139,146] = 2.34060919941740
        struct[0].Gy_ini[139,147] = -0.390101533236234
        struct[0].Gy_ini[139,150] = -8.85995441972108
        struct[0].Gy_ini[139,151] = 12.0404508780825
        struct[0].Gy_ini[139,152] = 2.53141554849174
        struct[0].Gy_ini[139,153] = -3.44012882230928
        struct[0].Gy_ini[139,154] = 2.53141554849173
        struct[0].Gy_ini[139,155] = -3.44012882230929
        struct[0].Gy_ini[140,114] = -9.53463814856397
        struct[0].Gy_ini[140,115] = -12.7128508647519
        struct[0].Gy_ini[140,116] = 33.3712335199739
        struct[0].Gy_ini[140,117] = 44.4949780266318
        struct[0].Gy_ini[140,118] = -9.53463814856399
        struct[0].Gy_ini[140,119] = -12.7128508647520
        struct[0].Gy_ini[140,138] = 12.9792714753778
        struct[0].Gy_ini[140,139] = 15.2713041702548
        struct[0].Gy_ini[140,140] = -45.4206934070654
        struct[0].Gy_ini[140,141] = -53.4089596754469
        struct[0].Gy_ini[140,142] = 12.9792714753778
        struct[0].Gy_ini[140,143] = 15.2713041702548
        struct[0].Gy_ini[140,146] = 0.390101533236234
        struct[0].Gy_ini[140,147] = 2.34060919941740
        struct[0].Gy_ini[140,148] = -0.390101533236234
        struct[0].Gy_ini[140,149] = -2.34060919941740
        struct[0].Gy_ini[140,150] = -3.44012882230929
        struct[0].Gy_ini[140,151] = -2.53141554849173
        struct[0].Gy_ini[140,152] = 12.0404508780825
        struct[0].Gy_ini[140,153] = 8.85995441972108
        struct[0].Gy_ini[140,154] = -3.44012882230929
        struct[0].Gy_ini[140,155] = -2.53141554849174
        struct[0].Gy_ini[141,114] = 12.7128508647519
        struct[0].Gy_ini[141,115] = -9.53463814856397
        struct[0].Gy_ini[141,116] = -44.4949780266318
        struct[0].Gy_ini[141,117] = 33.3712335199739
        struct[0].Gy_ini[141,118] = 12.7128508647520
        struct[0].Gy_ini[141,119] = -9.53463814856399
        struct[0].Gy_ini[141,138] = -15.2713041702548
        struct[0].Gy_ini[141,139] = 12.9792714753778
        struct[0].Gy_ini[141,140] = 53.4089596754469
        struct[0].Gy_ini[141,141] = -45.4206934070654
        struct[0].Gy_ini[141,142] = -15.2713041702548
        struct[0].Gy_ini[141,143] = 12.9792714753778
        struct[0].Gy_ini[141,146] = -2.34060919941740
        struct[0].Gy_ini[141,147] = 0.390101533236234
        struct[0].Gy_ini[141,148] = 2.34060919941740
        struct[0].Gy_ini[141,149] = -0.390101533236234
        struct[0].Gy_ini[141,150] = 2.53141554849173
        struct[0].Gy_ini[141,151] = -3.44012882230929
        struct[0].Gy_ini[141,152] = -8.85995441972108
        struct[0].Gy_ini[141,153] = 12.0404508780825
        struct[0].Gy_ini[141,154] = 2.53141554849174
        struct[0].Gy_ini[141,155] = -3.44012882230929
        struct[0].Gy_ini[142,114] = -9.53463814856397
        struct[0].Gy_ini[142,115] = -12.7128508647519
        struct[0].Gy_ini[142,116] = -9.53463814856399
        struct[0].Gy_ini[142,117] = -12.7128508647520
        struct[0].Gy_ini[142,118] = 33.3712335199739
        struct[0].Gy_ini[142,119] = 44.4949780266318
        struct[0].Gy_ini[142,138] = 12.9792714753778
        struct[0].Gy_ini[142,139] = 15.2713041702548
        struct[0].Gy_ini[142,140] = 12.9792714753778
        struct[0].Gy_ini[142,141] = 15.2713041702548
        struct[0].Gy_ini[142,142] = -45.4206934070654
        struct[0].Gy_ini[142,143] = -53.4089596754468
        struct[0].Gy_ini[142,144] = -0.390101533236234
        struct[0].Gy_ini[142,145] = -2.34060919941740
        struct[0].Gy_ini[142,148] = 0.390101533236234
        struct[0].Gy_ini[142,149] = 2.34060919941740
        struct[0].Gy_ini[142,150] = -3.44012882230928
        struct[0].Gy_ini[142,151] = -2.53141554849174
        struct[0].Gy_ini[142,152] = -3.44012882230929
        struct[0].Gy_ini[142,153] = -2.53141554849174
        struct[0].Gy_ini[142,154] = 12.0404508780825
        struct[0].Gy_ini[142,155] = 8.85995441972108
        struct[0].Gy_ini[143,114] = 12.7128508647519
        struct[0].Gy_ini[143,115] = -9.53463814856397
        struct[0].Gy_ini[143,116] = 12.7128508647520
        struct[0].Gy_ini[143,117] = -9.53463814856399
        struct[0].Gy_ini[143,118] = -44.4949780266318
        struct[0].Gy_ini[143,119] = 33.3712335199739
        struct[0].Gy_ini[143,138] = -15.2713041702548
        struct[0].Gy_ini[143,139] = 12.9792714753778
        struct[0].Gy_ini[143,140] = -15.2713041702548
        struct[0].Gy_ini[143,141] = 12.9792714753778
        struct[0].Gy_ini[143,142] = 53.4089596754468
        struct[0].Gy_ini[143,143] = -45.4206934070654
        struct[0].Gy_ini[143,144] = 2.34060919941740
        struct[0].Gy_ini[143,145] = -0.390101533236234
        struct[0].Gy_ini[143,148] = -2.34060919941740
        struct[0].Gy_ini[143,149] = 0.390101533236234
        struct[0].Gy_ini[143,150] = 2.53141554849174
        struct[0].Gy_ini[143,151] = -3.44012882230928
        struct[0].Gy_ini[143,152] = 2.53141554849174
        struct[0].Gy_ini[143,153] = -3.44012882230929
        struct[0].Gy_ini[143,154] = -8.85995441972108
        struct[0].Gy_ini[143,155] = 12.0404508780825
        struct[0].Gy_ini[144,48] = 189.480644782640
        struct[0].Gy_ini[144,49] = 98.1764998873781
        struct[0].Gy_ini[144,50] = -54.1373270807543
        struct[0].Gy_ini[144,51] = -28.0504285392509
        struct[0].Gy_ini[144,52] = -54.1373270807543
        struct[0].Gy_ini[144,53] = -28.0504285392509
        struct[0].Gy_ini[144,54] = 146.305409673982
        struct[0].Gy_ini[144,55] = 75.8059117481773
        struct[0].Gy_ini[144,56] = -41.8015456211378
        struct[0].Gy_ini[144,57] = -21.6588319280506
        struct[0].Gy_ini[144,58] = -41.8015456211378
        struct[0].Gy_ini[144,59] = -21.6588319280506
        struct[0].Gy_ini[144,138] = 0.390101533236234
        struct[0].Gy_ini[144,139] = 2.34060919941740
        struct[0].Gy_ini[144,142] = -0.390101533236234
        struct[0].Gy_ini[144,143] = -2.34060919941740
        struct[0].Gy_ini[144,144] = -369.569838240406
        struct[0].Gy_ini[144,145] = -376.684862474157
        struct[0].Gy_ini[144,146] = 95.9388727018921
        struct[0].Gy_ini[144,147] = 49.7093612129420
        struct[0].Gy_ini[144,148] = 95.9388727018921
        struct[0].Gy_ini[144,149] = 49.7093612129419
        struct[0].Gy_ini[145,48] = -98.1764998873781
        struct[0].Gy_ini[145,49] = 189.480644782640
        struct[0].Gy_ini[145,50] = 28.0504285392509
        struct[0].Gy_ini[145,51] = -54.1373270807543
        struct[0].Gy_ini[145,52] = 28.0504285392509
        struct[0].Gy_ini[145,53] = -54.1373270807543
        struct[0].Gy_ini[145,54] = -75.8059117481773
        struct[0].Gy_ini[145,55] = 146.305409673982
        struct[0].Gy_ini[145,56] = 21.6588319280506
        struct[0].Gy_ini[145,57] = -41.8015456211378
        struct[0].Gy_ini[145,58] = 21.6588319280506
        struct[0].Gy_ini[145,59] = -41.8015456211378
        struct[0].Gy_ini[145,138] = -2.34060919941740
        struct[0].Gy_ini[145,139] = 0.390101533236234
        struct[0].Gy_ini[145,142] = 2.34060919941740
        struct[0].Gy_ini[145,143] = -0.390101533236234
        struct[0].Gy_ini[145,144] = 376.684862474157
        struct[0].Gy_ini[145,145] = -369.569838240406
        struct[0].Gy_ini[145,146] = -49.7093612129420
        struct[0].Gy_ini[145,147] = 95.9388727018921
        struct[0].Gy_ini[145,148] = -49.7093612129419
        struct[0].Gy_ini[145,149] = 95.9388727018921
        struct[0].Gy_ini[146,48] = -54.1373270807543
        struct[0].Gy_ini[146,49] = -28.0504285392509
        struct[0].Gy_ini[146,50] = 189.480644782640
        struct[0].Gy_ini[146,51] = 98.1764998873781
        struct[0].Gy_ini[146,52] = -54.1373270807544
        struct[0].Gy_ini[146,53] = -28.0504285392509
        struct[0].Gy_ini[146,54] = -41.8015456211377
        struct[0].Gy_ini[146,55] = -21.6588319280506
        struct[0].Gy_ini[146,56] = 146.305409673982
        struct[0].Gy_ini[146,57] = 75.8059117481773
        struct[0].Gy_ini[146,58] = -41.8015456211378
        struct[0].Gy_ini[146,59] = -21.6588319280506
        struct[0].Gy_ini[146,138] = -0.390101533236234
        struct[0].Gy_ini[146,139] = -2.34060919941740
        struct[0].Gy_ini[146,140] = 0.390101533236234
        struct[0].Gy_ini[146,141] = 2.34060919941740
        struct[0].Gy_ini[146,144] = 95.9388727018920
        struct[0].Gy_ini[146,145] = 49.7093612129419
        struct[0].Gy_ini[146,146] = -369.569838240406
        struct[0].Gy_ini[146,147] = -376.684862474157
        struct[0].Gy_ini[146,148] = 95.9388727018922
        struct[0].Gy_ini[146,149] = 49.7093612129419
        struct[0].Gy_ini[147,48] = 28.0504285392509
        struct[0].Gy_ini[147,49] = -54.1373270807543
        struct[0].Gy_ini[147,50] = -98.1764998873781
        struct[0].Gy_ini[147,51] = 189.480644782640
        struct[0].Gy_ini[147,52] = 28.0504285392509
        struct[0].Gy_ini[147,53] = -54.1373270807544
        struct[0].Gy_ini[147,54] = 21.6588319280506
        struct[0].Gy_ini[147,55] = -41.8015456211377
        struct[0].Gy_ini[147,56] = -75.8059117481773
        struct[0].Gy_ini[147,57] = 146.305409673982
        struct[0].Gy_ini[147,58] = 21.6588319280506
        struct[0].Gy_ini[147,59] = -41.8015456211378
        struct[0].Gy_ini[147,138] = 2.34060919941740
        struct[0].Gy_ini[147,139] = -0.390101533236234
        struct[0].Gy_ini[147,140] = -2.34060919941740
        struct[0].Gy_ini[147,141] = 0.390101533236234
        struct[0].Gy_ini[147,144] = -49.7093612129419
        struct[0].Gy_ini[147,145] = 95.9388727018920
        struct[0].Gy_ini[147,146] = 376.684862474157
        struct[0].Gy_ini[147,147] = -369.569838240406
        struct[0].Gy_ini[147,148] = -49.7093612129419
        struct[0].Gy_ini[147,149] = 95.9388727018922
        struct[0].Gy_ini[148,48] = -54.1373270807543
        struct[0].Gy_ini[148,49] = -28.0504285392509
        struct[0].Gy_ini[148,50] = -54.1373270807543
        struct[0].Gy_ini[148,51] = -28.0504285392509
        struct[0].Gy_ini[148,52] = 189.480644782640
        struct[0].Gy_ini[148,53] = 98.1764998873781
        struct[0].Gy_ini[148,54] = -41.8015456211378
        struct[0].Gy_ini[148,55] = -21.6588319280506
        struct[0].Gy_ini[148,56] = -41.8015456211378
        struct[0].Gy_ini[148,57] = -21.6588319280506
        struct[0].Gy_ini[148,58] = 146.305409673982
        struct[0].Gy_ini[148,59] = 75.8059117481773
        struct[0].Gy_ini[148,140] = -0.390101533236234
        struct[0].Gy_ini[148,141] = -2.34060919941740
        struct[0].Gy_ini[148,142] = 0.390101533236234
        struct[0].Gy_ini[148,143] = 2.34060919941740
        struct[0].Gy_ini[148,144] = 95.9388727018921
        struct[0].Gy_ini[148,145] = 49.7093612129420
        struct[0].Gy_ini[148,146] = 95.9388727018921
        struct[0].Gy_ini[148,147] = 49.7093612129419
        struct[0].Gy_ini[148,148] = -369.569838240406
        struct[0].Gy_ini[148,149] = -376.684862474157
        struct[0].Gy_ini[149,48] = 28.0504285392509
        struct[0].Gy_ini[149,49] = -54.1373270807543
        struct[0].Gy_ini[149,50] = 28.0504285392509
        struct[0].Gy_ini[149,51] = -54.1373270807543
        struct[0].Gy_ini[149,52] = -98.1764998873781
        struct[0].Gy_ini[149,53] = 189.480644782640
        struct[0].Gy_ini[149,54] = 21.6588319280506
        struct[0].Gy_ini[149,55] = -41.8015456211378
        struct[0].Gy_ini[149,56] = 21.6588319280506
        struct[0].Gy_ini[149,57] = -41.8015456211378
        struct[0].Gy_ini[149,58] = -75.8059117481773
        struct[0].Gy_ini[149,59] = 146.305409673982
        struct[0].Gy_ini[149,140] = 2.34060919941740
        struct[0].Gy_ini[149,141] = -0.390101533236234
        struct[0].Gy_ini[149,142] = -2.34060919941740
        struct[0].Gy_ini[149,143] = 0.390101533236234
        struct[0].Gy_ini[149,144] = -49.7093612129420
        struct[0].Gy_ini[149,145] = 95.9388727018921
        struct[0].Gy_ini[149,146] = -49.7093612129419
        struct[0].Gy_ini[149,147] = 95.9388727018921
        struct[0].Gy_ini[149,148] = 376.684862474157
        struct[0].Gy_ini[149,149] = -369.569838240406
        struct[0].Gy_ini[150,138] = 12.0404508780825
        struct[0].Gy_ini[150,139] = 8.85995441972108
        struct[0].Gy_ini[150,140] = -3.44012882230928
        struct[0].Gy_ini[150,141] = -2.53141554849174
        struct[0].Gy_ini[150,142] = -3.44012882230929
        struct[0].Gy_ini[150,143] = -2.53141554849173
        struct[0].Gy_ini[150,150] = -12.0494598870915
        struct[0].Gy_ini[150,151] = -8.91399122381347
        struct[0].Gy_ini[150,152] = 3.44463332681379
        struct[0].Gy_ini[150,153] = 2.55844947550343
        struct[0].Gy_ini[150,154] = 3.44463332681379
        struct[0].Gy_ini[150,155] = 2.55844947550343
        struct[0].Gy_ini[150,156] = 0.390101533236234
        struct[0].Gy_ini[150,157] = 2.34060919941740
        struct[0].Gy_ini[150,158] = -0.390101533236234
        struct[0].Gy_ini[150,159] = -2.34060919941740
        struct[0].Gy_ini[151,138] = -8.85995441972108
        struct[0].Gy_ini[151,139] = 12.0404508780825
        struct[0].Gy_ini[151,140] = 2.53141554849174
        struct[0].Gy_ini[151,141] = -3.44012882230928
        struct[0].Gy_ini[151,142] = 2.53141554849173
        struct[0].Gy_ini[151,143] = -3.44012882230929
        struct[0].Gy_ini[151,150] = 8.91399122381347
        struct[0].Gy_ini[151,151] = -12.0494598870915
        struct[0].Gy_ini[151,152] = -2.55844947550343
        struct[0].Gy_ini[151,153] = 3.44463332681379
        struct[0].Gy_ini[151,154] = -2.55844947550343
        struct[0].Gy_ini[151,155] = 3.44463332681379
        struct[0].Gy_ini[151,156] = -2.34060919941740
        struct[0].Gy_ini[151,157] = 0.390101533236234
        struct[0].Gy_ini[151,158] = 2.34060919941740
        struct[0].Gy_ini[151,159] = -0.390101533236234
        struct[0].Gy_ini[152,138] = -3.44012882230929
        struct[0].Gy_ini[152,139] = -2.53141554849173
        struct[0].Gy_ini[152,140] = 12.0404508780825
        struct[0].Gy_ini[152,141] = 8.85995441972108
        struct[0].Gy_ini[152,142] = -3.44012882230929
        struct[0].Gy_ini[152,143] = -2.53141554849174
        struct[0].Gy_ini[152,150] = 3.44463332681379
        struct[0].Gy_ini[152,151] = 2.55844947550343
        struct[0].Gy_ini[152,152] = -12.0494598870915
        struct[0].Gy_ini[152,153] = -8.91399122381347
        struct[0].Gy_ini[152,154] = 3.44463332681380
        struct[0].Gy_ini[152,155] = 2.55844947550343
        struct[0].Gy_ini[152,158] = 0.390101533236234
        struct[0].Gy_ini[152,159] = 2.34060919941740
        struct[0].Gy_ini[152,160] = -0.390101533236234
        struct[0].Gy_ini[152,161] = -2.34060919941740
        struct[0].Gy_ini[153,138] = 2.53141554849173
        struct[0].Gy_ini[153,139] = -3.44012882230929
        struct[0].Gy_ini[153,140] = -8.85995441972108
        struct[0].Gy_ini[153,141] = 12.0404508780825
        struct[0].Gy_ini[153,142] = 2.53141554849174
        struct[0].Gy_ini[153,143] = -3.44012882230929
        struct[0].Gy_ini[153,150] = -2.55844947550343
        struct[0].Gy_ini[153,151] = 3.44463332681379
        struct[0].Gy_ini[153,152] = 8.91399122381347
        struct[0].Gy_ini[153,153] = -12.0494598870915
        struct[0].Gy_ini[153,154] = -2.55844947550343
        struct[0].Gy_ini[153,155] = 3.44463332681380
        struct[0].Gy_ini[153,158] = -2.34060919941740
        struct[0].Gy_ini[153,159] = 0.390101533236234
        struct[0].Gy_ini[153,160] = 2.34060919941740
        struct[0].Gy_ini[153,161] = -0.390101533236234
        struct[0].Gy_ini[154,138] = -3.44012882230928
        struct[0].Gy_ini[154,139] = -2.53141554849174
        struct[0].Gy_ini[154,140] = -3.44012882230929
        struct[0].Gy_ini[154,141] = -2.53141554849174
        struct[0].Gy_ini[154,142] = 12.0404508780825
        struct[0].Gy_ini[154,143] = 8.85995441972108
        struct[0].Gy_ini[154,150] = 3.44463332681379
        struct[0].Gy_ini[154,151] = 2.55844947550343
        struct[0].Gy_ini[154,152] = 3.44463332681380
        struct[0].Gy_ini[154,153] = 2.55844947550343
        struct[0].Gy_ini[154,154] = -12.0494598870915
        struct[0].Gy_ini[154,155] = -8.91399122381347
        struct[0].Gy_ini[154,156] = -0.390101533236234
        struct[0].Gy_ini[154,157] = -2.34060919941740
        struct[0].Gy_ini[154,160] = 0.390101533236234
        struct[0].Gy_ini[154,161] = 2.34060919941740
        struct[0].Gy_ini[155,138] = 2.53141554849174
        struct[0].Gy_ini[155,139] = -3.44012882230928
        struct[0].Gy_ini[155,140] = 2.53141554849174
        struct[0].Gy_ini[155,141] = -3.44012882230929
        struct[0].Gy_ini[155,142] = -8.85995441972108
        struct[0].Gy_ini[155,143] = 12.0404508780825
        struct[0].Gy_ini[155,150] = -2.55844947550343
        struct[0].Gy_ini[155,151] = 3.44463332681379
        struct[0].Gy_ini[155,152] = -2.55844947550343
        struct[0].Gy_ini[155,153] = 3.44463332681380
        struct[0].Gy_ini[155,154] = 8.91399122381347
        struct[0].Gy_ini[155,155] = -12.0494598870915
        struct[0].Gy_ini[155,156] = 2.34060919941740
        struct[0].Gy_ini[155,157] = -0.390101533236234
        struct[0].Gy_ini[155,160] = -2.34060919941740
        struct[0].Gy_ini[155,161] = 0.390101533236234
        struct[0].Gy_ini[156,60] = 157.441992718694
        struct[0].Gy_ini[156,61] = 81.5761620304113
        struct[0].Gy_ini[156,62] = -44.9834264910554
        struct[0].Gy_ini[156,63] = -23.3074748658318
        struct[0].Gy_ini[156,64] = -44.9834264910554
        struct[0].Gy_ini[156,65] = -23.3074748658318
        struct[0].Gy_ini[156,66] = 208.261027274370
        struct[0].Gy_ini[156,67] = 107.907268017809
        struct[0].Gy_ini[156,68] = -59.5031506498201
        struct[0].Gy_ini[156,69] = -30.8306480050881
        struct[0].Gy_ini[156,70] = -59.5031506498201
        struct[0].Gy_ini[156,71] = -30.8306480050881
        struct[0].Gy_ini[156,150] = 0.390101533236234
        struct[0].Gy_ini[156,151] = 2.34060919941740
        struct[0].Gy_ini[156,154] = -0.390101533236234
        struct[0].Gy_ini[156,155] = -2.34060919941740
        struct[0].Gy_ini[156,156] = -399.486803776848
        struct[0].Gy_ini[156,157] = -392.185900835935
        struct[0].Gy_ini[156,158] = 104.486577140876
        struct[0].Gy_ini[156,159] = 54.1382156369150
        struct[0].Gy_ini[156,160] = 104.486577140876
        struct[0].Gy_ini[156,161] = 54.1382156369150
        struct[0].Gy_ini[157,60] = -81.5761620304113
        struct[0].Gy_ini[157,61] = 157.441992718694
        struct[0].Gy_ini[157,62] = 23.3074748658318
        struct[0].Gy_ini[157,63] = -44.9834264910554
        struct[0].Gy_ini[157,64] = 23.3074748658318
        struct[0].Gy_ini[157,65] = -44.9834264910554
        struct[0].Gy_ini[157,66] = -107.907268017809
        struct[0].Gy_ini[157,67] = 208.261027274370
        struct[0].Gy_ini[157,68] = 30.8306480050881
        struct[0].Gy_ini[157,69] = -59.5031506498201
        struct[0].Gy_ini[157,70] = 30.8306480050881
        struct[0].Gy_ini[157,71] = -59.5031506498201
        struct[0].Gy_ini[157,150] = -2.34060919941740
        struct[0].Gy_ini[157,151] = 0.390101533236234
        struct[0].Gy_ini[157,154] = 2.34060919941740
        struct[0].Gy_ini[157,155] = -0.390101533236234
        struct[0].Gy_ini[157,156] = 392.185900835935
        struct[0].Gy_ini[157,157] = -399.486803776848
        struct[0].Gy_ini[157,158] = -54.1382156369150
        struct[0].Gy_ini[157,159] = 104.486577140876
        struct[0].Gy_ini[157,160] = -54.1382156369150
        struct[0].Gy_ini[157,161] = 104.486577140876
        struct[0].Gy_ini[158,60] = -44.9834264910554
        struct[0].Gy_ini[158,61] = -23.3074748658318
        struct[0].Gy_ini[158,62] = 157.441992718694
        struct[0].Gy_ini[158,63] = 81.5761620304112
        struct[0].Gy_ini[158,64] = -44.9834264910555
        struct[0].Gy_ini[158,65] = -23.3074748658317
        struct[0].Gy_ini[158,66] = -59.5031506498201
        struct[0].Gy_ini[158,67] = -30.8306480050881
        struct[0].Gy_ini[158,68] = 208.261027274371
        struct[0].Gy_ini[158,69] = 107.907268017808
        struct[0].Gy_ini[158,70] = -59.5031506498202
        struct[0].Gy_ini[158,71] = -30.8306480050881
        struct[0].Gy_ini[158,150] = -0.390101533236234
        struct[0].Gy_ini[158,151] = -2.34060919941740
        struct[0].Gy_ini[158,152] = 0.390101533236234
        struct[0].Gy_ini[158,153] = 2.34060919941740
        struct[0].Gy_ini[158,156] = 104.486577140876
        struct[0].Gy_ini[158,157] = 54.1382156369150
        struct[0].Gy_ini[158,158] = -399.486803776848
        struct[0].Gy_ini[158,159] = -392.185900835935
        struct[0].Gy_ini[158,160] = 104.486577140876
        struct[0].Gy_ini[158,161] = 54.1382156369150
        struct[0].Gy_ini[159,60] = 23.3074748658318
        struct[0].Gy_ini[159,61] = -44.9834264910554
        struct[0].Gy_ini[159,62] = -81.5761620304112
        struct[0].Gy_ini[159,63] = 157.441992718694
        struct[0].Gy_ini[159,64] = 23.3074748658317
        struct[0].Gy_ini[159,65] = -44.9834264910555
        struct[0].Gy_ini[159,66] = 30.8306480050881
        struct[0].Gy_ini[159,67] = -59.5031506498201
        struct[0].Gy_ini[159,68] = -107.907268017808
        struct[0].Gy_ini[159,69] = 208.261027274371
        struct[0].Gy_ini[159,70] = 30.8306480050881
        struct[0].Gy_ini[159,71] = -59.5031506498202
        struct[0].Gy_ini[159,150] = 2.34060919941740
        struct[0].Gy_ini[159,151] = -0.390101533236234
        struct[0].Gy_ini[159,152] = -2.34060919941740
        struct[0].Gy_ini[159,153] = 0.390101533236234
        struct[0].Gy_ini[159,156] = -54.1382156369150
        struct[0].Gy_ini[159,157] = 104.486577140876
        struct[0].Gy_ini[159,158] = 392.185900835935
        struct[0].Gy_ini[159,159] = -399.486803776848
        struct[0].Gy_ini[159,160] = -54.1382156369150
        struct[0].Gy_ini[159,161] = 104.486577140876
        struct[0].Gy_ini[160,60] = -44.9834264910554
        struct[0].Gy_ini[160,61] = -23.3074748658318
        struct[0].Gy_ini[160,62] = -44.9834264910554
        struct[0].Gy_ini[160,63] = -23.3074748658317
        struct[0].Gy_ini[160,64] = 157.441992718694
        struct[0].Gy_ini[160,65] = 81.5761620304112
        struct[0].Gy_ini[160,66] = -59.5031506498201
        struct[0].Gy_ini[160,67] = -30.8306480050882
        struct[0].Gy_ini[160,68] = -59.5031506498202
        struct[0].Gy_ini[160,69] = -30.8306480050881
        struct[0].Gy_ini[160,70] = 208.261027274371
        struct[0].Gy_ini[160,71] = 107.907268017808
        struct[0].Gy_ini[160,152] = -0.390101533236234
        struct[0].Gy_ini[160,153] = -2.34060919941740
        struct[0].Gy_ini[160,154] = 0.390101533236234
        struct[0].Gy_ini[160,155] = 2.34060919941740
        struct[0].Gy_ini[160,156] = 104.486577140876
        struct[0].Gy_ini[160,157] = 54.1382156369150
        struct[0].Gy_ini[160,158] = 104.486577140876
        struct[0].Gy_ini[160,159] = 54.1382156369150
        struct[0].Gy_ini[160,160] = -399.486803776848
        struct[0].Gy_ini[160,161] = -392.185900835935
        struct[0].Gy_ini[161,60] = 23.3074748658318
        struct[0].Gy_ini[161,61] = -44.9834264910554
        struct[0].Gy_ini[161,62] = 23.3074748658317
        struct[0].Gy_ini[161,63] = -44.9834264910554
        struct[0].Gy_ini[161,64] = -81.5761620304112
        struct[0].Gy_ini[161,65] = 157.441992718694
        struct[0].Gy_ini[161,66] = 30.8306480050882
        struct[0].Gy_ini[161,67] = -59.5031506498201
        struct[0].Gy_ini[161,68] = 30.8306480050881
        struct[0].Gy_ini[161,69] = -59.5031506498202
        struct[0].Gy_ini[161,70] = -107.907268017808
        struct[0].Gy_ini[161,71] = 208.261027274371
        struct[0].Gy_ini[161,152] = 2.34060919941740
        struct[0].Gy_ini[161,153] = -0.390101533236234
        struct[0].Gy_ini[161,154] = -2.34060919941740
        struct[0].Gy_ini[161,155] = 0.390101533236234
        struct[0].Gy_ini[161,156] = -54.1382156369150
        struct[0].Gy_ini[161,157] = 104.486577140876
        struct[0].Gy_ini[161,158] = -54.1382156369150
        struct[0].Gy_ini[161,159] = 104.486577140876
        struct[0].Gy_ini[161,160] = 392.185900835935
        struct[0].Gy_ini[161,161] = -399.486803776848
        struct[0].Gy_ini[162,126] = 8.97043541787489
        struct[0].Gy_ini[162,127] = 6.60088643956832
        struct[0].Gy_ini[162,128] = -2.56298154796426
        struct[0].Gy_ini[162,129] = -1.88596755416238
        struct[0].Gy_ini[162,130] = -2.56298154796426
        struct[0].Gy_ini[162,131] = -1.88596755416237
        struct[0].Gy_ini[162,162] = -8.97493992237940
        struct[0].Gy_ini[162,163] = -6.62789031305749
        struct[0].Gy_ini[162,164] = 2.56523380021651
        struct[0].Gy_ini[162,165] = 1.89949032909103
        struct[0].Gy_ini[162,166] = 2.56523380021651
        struct[0].Gy_ini[162,167] = 1.89949032909103
        struct[0].Gy_ini[162,168] = 0.195050766618117
        struct[0].Gy_ini[162,169] = 1.17030459970870
        struct[0].Gy_ini[162,170] = -0.195050766618117
        struct[0].Gy_ini[162,171] = -1.17030459970870
        struct[0].Gy_ini[163,126] = -6.60088643956832
        struct[0].Gy_ini[163,127] = 8.97043541787489
        struct[0].Gy_ini[163,128] = 1.88596755416238
        struct[0].Gy_ini[163,129] = -2.56298154796426
        struct[0].Gy_ini[163,130] = 1.88596755416237
        struct[0].Gy_ini[163,131] = -2.56298154796426
        struct[0].Gy_ini[163,162] = 6.62789031305749
        struct[0].Gy_ini[163,163] = -8.97493992237940
        struct[0].Gy_ini[163,164] = -1.89949032909103
        struct[0].Gy_ini[163,165] = 2.56523380021651
        struct[0].Gy_ini[163,166] = -1.89949032909103
        struct[0].Gy_ini[163,167] = 2.56523380021651
        struct[0].Gy_ini[163,168] = -1.17030459970870
        struct[0].Gy_ini[163,169] = 0.195050766618117
        struct[0].Gy_ini[163,170] = 1.17030459970870
        struct[0].Gy_ini[163,171] = -0.195050766618117
        struct[0].Gy_ini[164,126] = -2.56298154796426
        struct[0].Gy_ini[164,127] = -1.88596755416238
        struct[0].Gy_ini[164,128] = 8.97043541787490
        struct[0].Gy_ini[164,129] = 6.60088643956832
        struct[0].Gy_ini[164,130] = -2.56298154796426
        struct[0].Gy_ini[164,131] = -1.88596755416237
        struct[0].Gy_ini[164,162] = 2.56523380021651
        struct[0].Gy_ini[164,163] = 1.89949032909103
        struct[0].Gy_ini[164,164] = -8.97493992237941
        struct[0].Gy_ini[164,165] = -6.62789031305749
        struct[0].Gy_ini[164,166] = 2.56523380021651
        struct[0].Gy_ini[164,167] = 1.89949032909103
        struct[0].Gy_ini[164,170] = 0.195050766618117
        struct[0].Gy_ini[164,171] = 1.17030459970870
        struct[0].Gy_ini[164,172] = -0.195050766618117
        struct[0].Gy_ini[164,173] = -1.17030459970870
        struct[0].Gy_ini[165,126] = 1.88596755416238
        struct[0].Gy_ini[165,127] = -2.56298154796426
        struct[0].Gy_ini[165,128] = -6.60088643956832
        struct[0].Gy_ini[165,129] = 8.97043541787490
        struct[0].Gy_ini[165,130] = 1.88596755416237
        struct[0].Gy_ini[165,131] = -2.56298154796426
        struct[0].Gy_ini[165,162] = -1.89949032909103
        struct[0].Gy_ini[165,163] = 2.56523380021651
        struct[0].Gy_ini[165,164] = 6.62789031305749
        struct[0].Gy_ini[165,165] = -8.97493992237941
        struct[0].Gy_ini[165,166] = -1.89949032909103
        struct[0].Gy_ini[165,167] = 2.56523380021651
        struct[0].Gy_ini[165,170] = -1.17030459970870
        struct[0].Gy_ini[165,171] = 0.195050766618117
        struct[0].Gy_ini[165,172] = 1.17030459970870
        struct[0].Gy_ini[165,173] = -0.195050766618117
        struct[0].Gy_ini[166,126] = -2.56298154796426
        struct[0].Gy_ini[166,127] = -1.88596755416237
        struct[0].Gy_ini[166,128] = -2.56298154796426
        struct[0].Gy_ini[166,129] = -1.88596755416237
        struct[0].Gy_ini[166,130] = 8.97043541787490
        struct[0].Gy_ini[166,131] = 6.60088643956831
        struct[0].Gy_ini[166,162] = 2.56523380021651
        struct[0].Gy_ini[166,163] = 1.89949032909103
        struct[0].Gy_ini[166,164] = 2.56523380021651
        struct[0].Gy_ini[166,165] = 1.89949032909103
        struct[0].Gy_ini[166,166] = -8.97493992237940
        struct[0].Gy_ini[166,167] = -6.62789031305748
        struct[0].Gy_ini[166,168] = -0.195050766618117
        struct[0].Gy_ini[166,169] = -1.17030459970870
        struct[0].Gy_ini[166,172] = 0.195050766618117
        struct[0].Gy_ini[166,173] = 1.17030459970870
        struct[0].Gy_ini[167,126] = 1.88596755416237
        struct[0].Gy_ini[167,127] = -2.56298154796426
        struct[0].Gy_ini[167,128] = 1.88596755416237
        struct[0].Gy_ini[167,129] = -2.56298154796426
        struct[0].Gy_ini[167,130] = -6.60088643956831
        struct[0].Gy_ini[167,131] = 8.97043541787490
        struct[0].Gy_ini[167,162] = -1.89949032909103
        struct[0].Gy_ini[167,163] = 2.56523380021651
        struct[0].Gy_ini[167,164] = -1.89949032909103
        struct[0].Gy_ini[167,165] = 2.56523380021651
        struct[0].Gy_ini[167,166] = 6.62789031305748
        struct[0].Gy_ini[167,167] = -8.97493992237940
        struct[0].Gy_ini[167,168] = 1.17030459970870
        struct[0].Gy_ini[167,169] = -0.195050766618117
        struct[0].Gy_ini[167,172] = -1.17030459970870
        struct[0].Gy_ini[167,173] = 0.195050766618117
        struct[0].Gy_ini[168,72] = 435.745709926008
        struct[0].Gy_ini[168,73] = 225.774979236273
        struct[0].Gy_ini[168,74] = -124.498774264574
        struct[0].Gy_ini[168,75] = -64.5071369246495
        struct[0].Gy_ini[168,76] = -124.498774264574
        struct[0].Gy_ini[168,77] = -64.5071369246495
        struct[0].Gy_ini[168,162] = 0.195050766618117
        struct[0].Gy_ini[168,163] = 1.17030459970870
        struct[0].Gy_ini[168,166] = -0.195050766618117
        struct[0].Gy_ini[168,167] = -1.17030459970870
        struct[0].Gy_ini[168,168] = -452.637601817900
        struct[0].Gy_ini[168,169] = -327.126282868141
        struct[0].Gy_ini[168,170] = 124.498774264574
        struct[0].Gy_ini[168,171] = 64.5071560124429
        struct[0].Gy_ini[168,172] = 124.498774264574
        struct[0].Gy_ini[168,173] = 64.5071560124428
        struct[0].Gy_ini[169,72] = -225.774979236273
        struct[0].Gy_ini[169,73] = 435.745709926008
        struct[0].Gy_ini[169,74] = 64.5071369246495
        struct[0].Gy_ini[169,75] = -124.498774264574
        struct[0].Gy_ini[169,76] = 64.5071369246495
        struct[0].Gy_ini[169,77] = -124.498774264574
        struct[0].Gy_ini[169,162] = -1.17030459970870
        struct[0].Gy_ini[169,163] = 0.195050766618117
        struct[0].Gy_ini[169,166] = 1.17030459970870
        struct[0].Gy_ini[169,167] = -0.195050766618117
        struct[0].Gy_ini[169,168] = 327.126282868141
        struct[0].Gy_ini[169,169] = -452.637601817900
        struct[0].Gy_ini[169,170] = -64.5071560124429
        struct[0].Gy_ini[169,171] = 124.498774264574
        struct[0].Gy_ini[169,172] = -64.5071560124428
        struct[0].Gy_ini[169,173] = 124.498774264574
        struct[0].Gy_ini[170,72] = -124.498774264574
        struct[0].Gy_ini[170,73] = -64.5071369246495
        struct[0].Gy_ini[170,74] = 435.745709926008
        struct[0].Gy_ini[170,75] = 225.774979236273
        struct[0].Gy_ini[170,76] = -124.498774264574
        struct[0].Gy_ini[170,77] = -64.5071369246494
        struct[0].Gy_ini[170,162] = -0.195050766618117
        struct[0].Gy_ini[170,163] = -1.17030459970870
        struct[0].Gy_ini[170,164] = 0.195050766618117
        struct[0].Gy_ini[170,165] = 1.17030459970870
        struct[0].Gy_ini[170,168] = 124.498774264574
        struct[0].Gy_ini[170,169] = 64.5071560124428
        struct[0].Gy_ini[170,170] = -452.637601817900
        struct[0].Gy_ini[170,171] = -327.126282868141
        struct[0].Gy_ini[170,172] = 124.498774264574
        struct[0].Gy_ini[170,173] = 64.5071560124428
        struct[0].Gy_ini[171,72] = 64.5071369246495
        struct[0].Gy_ini[171,73] = -124.498774264574
        struct[0].Gy_ini[171,74] = -225.774979236273
        struct[0].Gy_ini[171,75] = 435.745709926008
        struct[0].Gy_ini[171,76] = 64.5071369246494
        struct[0].Gy_ini[171,77] = -124.498774264574
        struct[0].Gy_ini[171,162] = 1.17030459970870
        struct[0].Gy_ini[171,163] = -0.195050766618117
        struct[0].Gy_ini[171,164] = -1.17030459970870
        struct[0].Gy_ini[171,165] = 0.195050766618117
        struct[0].Gy_ini[171,168] = -64.5071560124428
        struct[0].Gy_ini[171,169] = 124.498774264574
        struct[0].Gy_ini[171,170] = 327.126282868141
        struct[0].Gy_ini[171,171] = -452.637601817900
        struct[0].Gy_ini[171,172] = -64.5071560124428
        struct[0].Gy_ini[171,173] = 124.498774264574
        struct[0].Gy_ini[172,72] = -124.498774264574
        struct[0].Gy_ini[172,73] = -64.5071369246495
        struct[0].Gy_ini[172,74] = -124.498774264574
        struct[0].Gy_ini[172,75] = -64.5071369246494
        struct[0].Gy_ini[172,76] = 435.745709926008
        struct[0].Gy_ini[172,77] = 225.774979236273
        struct[0].Gy_ini[172,164] = -0.195050766618117
        struct[0].Gy_ini[172,165] = -1.17030459970870
        struct[0].Gy_ini[172,166] = 0.195050766618117
        struct[0].Gy_ini[172,167] = 1.17030459970870
        struct[0].Gy_ini[172,168] = 124.498774264574
        struct[0].Gy_ini[172,169] = 64.5071560124429
        struct[0].Gy_ini[172,170] = 124.498774264574
        struct[0].Gy_ini[172,171] = 64.5071560124428
        struct[0].Gy_ini[172,172] = -452.637601817900
        struct[0].Gy_ini[172,173] = -327.126282868141
        struct[0].Gy_ini[173,72] = 64.5071369246495
        struct[0].Gy_ini[173,73] = -124.498774264574
        struct[0].Gy_ini[173,74] = 64.5071369246494
        struct[0].Gy_ini[173,75] = -124.498774264574
        struct[0].Gy_ini[173,76] = -225.774979236273
        struct[0].Gy_ini[173,77] = 435.745709926008
        struct[0].Gy_ini[173,164] = 1.17030459970870
        struct[0].Gy_ini[173,165] = -0.195050766618117
        struct[0].Gy_ini[173,166] = -1.17030459970870
        struct[0].Gy_ini[173,167] = 0.195050766618117
        struct[0].Gy_ini[173,168] = -64.5071560124429
        struct[0].Gy_ini[173,169] = 124.498774264574
        struct[0].Gy_ini[173,170] = -64.5071560124428
        struct[0].Gy_ini[173,171] = 124.498774264574
        struct[0].Gy_ini[173,172] = 327.126282868141
        struct[0].Gy_ini[173,173] = -452.637601817900
        struct[0].Gy_ini[174,0] = i_INV_1_a_r
        struct[0].Gy_ini[174,1] = i_INV_1_a_i
        struct[0].Gy_ini[174,174] = v_INV_1_a_r
        struct[0].Gy_ini[174,175] = v_INV_1_a_i
        struct[0].Gy_ini[175,2] = i_INV_1_b_r
        struct[0].Gy_ini[175,3] = i_INV_1_b_i
        struct[0].Gy_ini[175,176] = v_INV_1_b_r
        struct[0].Gy_ini[175,177] = v_INV_1_b_i
        struct[0].Gy_ini[176,4] = i_INV_1_c_r
        struct[0].Gy_ini[176,5] = i_INV_1_c_i
        struct[0].Gy_ini[176,178] = v_INV_1_c_r
        struct[0].Gy_ini[176,179] = v_INV_1_c_i
        struct[0].Gy_ini[177,0] = -i_INV_1_a_i
        struct[0].Gy_ini[177,1] = i_INV_1_a_r
        struct[0].Gy_ini[177,174] = v_INV_1_a_i
        struct[0].Gy_ini[177,175] = -v_INV_1_a_r
        struct[0].Gy_ini[178,2] = -i_INV_1_b_i
        struct[0].Gy_ini[178,3] = i_INV_1_b_r
        struct[0].Gy_ini[178,176] = v_INV_1_b_i
        struct[0].Gy_ini[178,177] = -v_INV_1_b_r
        struct[0].Gy_ini[179,4] = -i_INV_1_c_i
        struct[0].Gy_ini[179,5] = i_INV_1_c_r
        struct[0].Gy_ini[179,178] = v_INV_1_c_i
        struct[0].Gy_ini[179,179] = -v_INV_1_c_r
        struct[0].Gy_ini[180,0] = 1.0*v_INV_1_a_r*(v_INV_1_a_i**2 + v_INV_1_a_r**2)**(-0.5)/V_base_INV_1
        struct[0].Gy_ini[180,1] = 1.0*v_INV_1_a_i*(v_INV_1_a_i**2 + v_INV_1_a_r**2)**(-0.5)/V_base_INV_1
        struct[0].Gy_ini[180,180] = -1
        struct[0].Gy_ini[181,90] = 1.0*v_TR_1_2_mv_a_r*(v_TR_1_2_mv_a_i**2 + v_TR_1_2_mv_a_r**2)**(-0.5)/V_base_TR_1_2_mv
        struct[0].Gy_ini[181,91] = 1.0*v_TR_1_2_mv_a_i*(v_TR_1_2_mv_a_i**2 + v_TR_1_2_mv_a_r**2)**(-0.5)/V_base_TR_1_2_mv
        struct[0].Gy_ini[181,181] = -1
        struct[0].Gy_ini[182,180] = K_p_v_INV_1*(u_ctrl_v_INV_1 - 1.0)
        struct[0].Gy_ini[182,181] = -K_p_v_INV_1*u_ctrl_v_INV_1
        struct[0].Gy_ini[182,182] = -1
        struct[0].Gy_ini[183,172] = 1.0*S_base_INV_1*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_1, I_max_INV_1 < -i_reac_ref_INV_1), (I_max_INV_1, I_max_INV_1 < i_reac_ref_INV_1), (i_reac_ref_INV_1, True)]))
        struct[0].Gy_ini[183,173] = 1.0*S_base_INV_1*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_1, I_max_INV_1 < -i_reac_ref_INV_1), (I_max_INV_1, I_max_INV_1 < i_reac_ref_INV_1), (i_reac_ref_INV_1, True)]))
        struct[0].Gy_ini[183,182] = S_base_INV_1*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_1 < i_reac_ref_INV_1) | (I_max_INV_1 < -i_reac_ref_INV_1)), (1, True)]))
        struct[0].Gy_ini[183,183] = -1
        struct[0].Gy_ini[184,6] = i_INV_2_a_r
        struct[0].Gy_ini[184,7] = i_INV_2_a_i
        struct[0].Gy_ini[184,184] = v_INV_2_a_r
        struct[0].Gy_ini[184,185] = v_INV_2_a_i
        struct[0].Gy_ini[185,8] = i_INV_2_b_r
        struct[0].Gy_ini[185,9] = i_INV_2_b_i
        struct[0].Gy_ini[185,186] = v_INV_2_b_r
        struct[0].Gy_ini[185,187] = v_INV_2_b_i
        struct[0].Gy_ini[186,10] = i_INV_2_c_r
        struct[0].Gy_ini[186,11] = i_INV_2_c_i
        struct[0].Gy_ini[186,188] = v_INV_2_c_r
        struct[0].Gy_ini[186,189] = v_INV_2_c_i
        struct[0].Gy_ini[187,6] = -i_INV_2_a_i
        struct[0].Gy_ini[187,7] = i_INV_2_a_r
        struct[0].Gy_ini[187,184] = v_INV_2_a_i
        struct[0].Gy_ini[187,185] = -v_INV_2_a_r
        struct[0].Gy_ini[188,8] = -i_INV_2_b_i
        struct[0].Gy_ini[188,9] = i_INV_2_b_r
        struct[0].Gy_ini[188,186] = v_INV_2_b_i
        struct[0].Gy_ini[188,187] = -v_INV_2_b_r
        struct[0].Gy_ini[189,10] = -i_INV_2_c_i
        struct[0].Gy_ini[189,11] = i_INV_2_c_r
        struct[0].Gy_ini[189,188] = v_INV_2_c_i
        struct[0].Gy_ini[189,189] = -v_INV_2_c_r
        struct[0].Gy_ini[190,6] = 1.0*v_INV_2_a_r*(v_INV_2_a_i**2 + v_INV_2_a_r**2)**(-0.5)/V_base_INV_2
        struct[0].Gy_ini[190,7] = 1.0*v_INV_2_a_i*(v_INV_2_a_i**2 + v_INV_2_a_r**2)**(-0.5)/V_base_INV_2
        struct[0].Gy_ini[190,190] = -1
        struct[0].Gy_ini[191,181] = -K_p_v_INV_2*u_ctrl_v_INV_2
        struct[0].Gy_ini[191,190] = K_p_v_INV_2*(u_ctrl_v_INV_2 - 1.0)
        struct[0].Gy_ini[191,191] = -1
        struct[0].Gy_ini[192,172] = 1.0*S_base_INV_2*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_2, I_max_INV_2 < -i_reac_ref_INV_2), (I_max_INV_2, I_max_INV_2 < i_reac_ref_INV_2), (i_reac_ref_INV_2, True)]))
        struct[0].Gy_ini[192,173] = 1.0*S_base_INV_2*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_2, I_max_INV_2 < -i_reac_ref_INV_2), (I_max_INV_2, I_max_INV_2 < i_reac_ref_INV_2), (i_reac_ref_INV_2, True)]))
        struct[0].Gy_ini[192,191] = S_base_INV_2*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_2 < i_reac_ref_INV_2) | (I_max_INV_2 < -i_reac_ref_INV_2)), (1, True)]))
        struct[0].Gy_ini[192,192] = -1
        struct[0].Gy_ini[193,12] = i_INV_3_a_r
        struct[0].Gy_ini[193,13] = i_INV_3_a_i
        struct[0].Gy_ini[193,193] = v_INV_3_a_r
        struct[0].Gy_ini[193,194] = v_INV_3_a_i
        struct[0].Gy_ini[194,14] = i_INV_3_b_r
        struct[0].Gy_ini[194,15] = i_INV_3_b_i
        struct[0].Gy_ini[194,195] = v_INV_3_b_r
        struct[0].Gy_ini[194,196] = v_INV_3_b_i
        struct[0].Gy_ini[195,16] = i_INV_3_c_r
        struct[0].Gy_ini[195,17] = i_INV_3_c_i
        struct[0].Gy_ini[195,197] = v_INV_3_c_r
        struct[0].Gy_ini[195,198] = v_INV_3_c_i
        struct[0].Gy_ini[196,12] = -i_INV_3_a_i
        struct[0].Gy_ini[196,13] = i_INV_3_a_r
        struct[0].Gy_ini[196,193] = v_INV_3_a_i
        struct[0].Gy_ini[196,194] = -v_INV_3_a_r
        struct[0].Gy_ini[197,14] = -i_INV_3_b_i
        struct[0].Gy_ini[197,15] = i_INV_3_b_r
        struct[0].Gy_ini[197,195] = v_INV_3_b_i
        struct[0].Gy_ini[197,196] = -v_INV_3_b_r
        struct[0].Gy_ini[198,16] = -i_INV_3_c_i
        struct[0].Gy_ini[198,17] = i_INV_3_c_r
        struct[0].Gy_ini[198,197] = v_INV_3_c_i
        struct[0].Gy_ini[198,198] = -v_INV_3_c_r
        struct[0].Gy_ini[199,12] = 1.0*v_INV_3_a_r*(v_INV_3_a_i**2 + v_INV_3_a_r**2)**(-0.5)/V_base_INV_3
        struct[0].Gy_ini[199,13] = 1.0*v_INV_3_a_i*(v_INV_3_a_i**2 + v_INV_3_a_r**2)**(-0.5)/V_base_INV_3
        struct[0].Gy_ini[199,199] = -1
        struct[0].Gy_ini[200,102] = 1.0*v_TR_3_4_mv_a_r*(v_TR_3_4_mv_a_i**2 + v_TR_3_4_mv_a_r**2)**(-0.5)/V_base_TR_3_4_mv
        struct[0].Gy_ini[200,103] = 1.0*v_TR_3_4_mv_a_i*(v_TR_3_4_mv_a_i**2 + v_TR_3_4_mv_a_r**2)**(-0.5)/V_base_TR_3_4_mv
        struct[0].Gy_ini[200,200] = -1
        struct[0].Gy_ini[201,199] = K_p_v_INV_3*(u_ctrl_v_INV_3 - 1.0)
        struct[0].Gy_ini[201,200] = -K_p_v_INV_3*u_ctrl_v_INV_3
        struct[0].Gy_ini[201,201] = -1
        struct[0].Gy_ini[202,172] = 1.0*S_base_INV_3*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_3, I_max_INV_3 < -i_reac_ref_INV_3), (I_max_INV_3, I_max_INV_3 < i_reac_ref_INV_3), (i_reac_ref_INV_3, True)]))
        struct[0].Gy_ini[202,173] = 1.0*S_base_INV_3*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_3, I_max_INV_3 < -i_reac_ref_INV_3), (I_max_INV_3, I_max_INV_3 < i_reac_ref_INV_3), (i_reac_ref_INV_3, True)]))
        struct[0].Gy_ini[202,201] = S_base_INV_3*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_3 < i_reac_ref_INV_3) | (I_max_INV_3 < -i_reac_ref_INV_3)), (1, True)]))
        struct[0].Gy_ini[202,202] = -1
        struct[0].Gy_ini[203,18] = i_INV_4_a_r
        struct[0].Gy_ini[203,19] = i_INV_4_a_i
        struct[0].Gy_ini[203,203] = v_INV_4_a_r
        struct[0].Gy_ini[203,204] = v_INV_4_a_i
        struct[0].Gy_ini[204,20] = i_INV_4_b_r
        struct[0].Gy_ini[204,21] = i_INV_4_b_i
        struct[0].Gy_ini[204,205] = v_INV_4_b_r
        struct[0].Gy_ini[204,206] = v_INV_4_b_i
        struct[0].Gy_ini[205,22] = i_INV_4_c_r
        struct[0].Gy_ini[205,23] = i_INV_4_c_i
        struct[0].Gy_ini[205,207] = v_INV_4_c_r
        struct[0].Gy_ini[205,208] = v_INV_4_c_i
        struct[0].Gy_ini[206,18] = -i_INV_4_a_i
        struct[0].Gy_ini[206,19] = i_INV_4_a_r
        struct[0].Gy_ini[206,203] = v_INV_4_a_i
        struct[0].Gy_ini[206,204] = -v_INV_4_a_r
        struct[0].Gy_ini[207,20] = -i_INV_4_b_i
        struct[0].Gy_ini[207,21] = i_INV_4_b_r
        struct[0].Gy_ini[207,205] = v_INV_4_b_i
        struct[0].Gy_ini[207,206] = -v_INV_4_b_r
        struct[0].Gy_ini[208,22] = -i_INV_4_c_i
        struct[0].Gy_ini[208,23] = i_INV_4_c_r
        struct[0].Gy_ini[208,207] = v_INV_4_c_i
        struct[0].Gy_ini[208,208] = -v_INV_4_c_r
        struct[0].Gy_ini[209,18] = 1.0*v_INV_4_a_r*(v_INV_4_a_i**2 + v_INV_4_a_r**2)**(-0.5)/V_base_INV_4
        struct[0].Gy_ini[209,19] = 1.0*v_INV_4_a_i*(v_INV_4_a_i**2 + v_INV_4_a_r**2)**(-0.5)/V_base_INV_4
        struct[0].Gy_ini[209,209] = -1
        struct[0].Gy_ini[210,200] = -K_p_v_INV_4*u_ctrl_v_INV_4
        struct[0].Gy_ini[210,209] = K_p_v_INV_4*(u_ctrl_v_INV_4 - 1.0)
        struct[0].Gy_ini[210,210] = -1
        struct[0].Gy_ini[211,172] = 1.0*S_base_INV_4*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_4, I_max_INV_4 < -i_reac_ref_INV_4), (I_max_INV_4, I_max_INV_4 < i_reac_ref_INV_4), (i_reac_ref_INV_4, True)]))
        struct[0].Gy_ini[211,173] = 1.0*S_base_INV_4*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_4, I_max_INV_4 < -i_reac_ref_INV_4), (I_max_INV_4, I_max_INV_4 < i_reac_ref_INV_4), (i_reac_ref_INV_4, True)]))
        struct[0].Gy_ini[211,210] = S_base_INV_4*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_4 < i_reac_ref_INV_4) | (I_max_INV_4 < -i_reac_ref_INV_4)), (1, True)]))
        struct[0].Gy_ini[211,211] = -1
        struct[0].Gy_ini[212,24] = i_INV_5_a_r
        struct[0].Gy_ini[212,25] = i_INV_5_a_i
        struct[0].Gy_ini[212,212] = v_INV_5_a_r
        struct[0].Gy_ini[212,213] = v_INV_5_a_i
        struct[0].Gy_ini[213,26] = i_INV_5_b_r
        struct[0].Gy_ini[213,27] = i_INV_5_b_i
        struct[0].Gy_ini[213,214] = v_INV_5_b_r
        struct[0].Gy_ini[213,215] = v_INV_5_b_i
        struct[0].Gy_ini[214,28] = i_INV_5_c_r
        struct[0].Gy_ini[214,29] = i_INV_5_c_i
        struct[0].Gy_ini[214,216] = v_INV_5_c_r
        struct[0].Gy_ini[214,217] = v_INV_5_c_i
        struct[0].Gy_ini[215,24] = -i_INV_5_a_i
        struct[0].Gy_ini[215,25] = i_INV_5_a_r
        struct[0].Gy_ini[215,212] = v_INV_5_a_i
        struct[0].Gy_ini[215,213] = -v_INV_5_a_r
        struct[0].Gy_ini[216,26] = -i_INV_5_b_i
        struct[0].Gy_ini[216,27] = i_INV_5_b_r
        struct[0].Gy_ini[216,214] = v_INV_5_b_i
        struct[0].Gy_ini[216,215] = -v_INV_5_b_r
        struct[0].Gy_ini[217,28] = -i_INV_5_c_i
        struct[0].Gy_ini[217,29] = i_INV_5_c_r
        struct[0].Gy_ini[217,216] = v_INV_5_c_i
        struct[0].Gy_ini[217,217] = -v_INV_5_c_r
        struct[0].Gy_ini[218,24] = 1.0*v_INV_5_a_r*(v_INV_5_a_i**2 + v_INV_5_a_r**2)**(-0.5)/V_base_INV_5
        struct[0].Gy_ini[218,25] = 1.0*v_INV_5_a_i*(v_INV_5_a_i**2 + v_INV_5_a_r**2)**(-0.5)/V_base_INV_5
        struct[0].Gy_ini[218,218] = -1
        struct[0].Gy_ini[219,114] = 1.0*v_TR_5_6_mv_a_r*(v_TR_5_6_mv_a_i**2 + v_TR_5_6_mv_a_r**2)**(-0.5)/V_base_TR_5_6_mv
        struct[0].Gy_ini[219,115] = 1.0*v_TR_5_6_mv_a_i*(v_TR_5_6_mv_a_i**2 + v_TR_5_6_mv_a_r**2)**(-0.5)/V_base_TR_5_6_mv
        struct[0].Gy_ini[219,219] = -1
        struct[0].Gy_ini[220,218] = K_p_v_INV_5*(u_ctrl_v_INV_5 - 1.0)
        struct[0].Gy_ini[220,219] = -K_p_v_INV_5*u_ctrl_v_INV_5
        struct[0].Gy_ini[220,220] = -1
        struct[0].Gy_ini[221,172] = 1.0*S_base_INV_5*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_5, I_max_INV_5 < -i_reac_ref_INV_5), (I_max_INV_5, I_max_INV_5 < i_reac_ref_INV_5), (i_reac_ref_INV_5, True)]))
        struct[0].Gy_ini[221,173] = 1.0*S_base_INV_5*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_5, I_max_INV_5 < -i_reac_ref_INV_5), (I_max_INV_5, I_max_INV_5 < i_reac_ref_INV_5), (i_reac_ref_INV_5, True)]))
        struct[0].Gy_ini[221,220] = S_base_INV_5*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_5 < i_reac_ref_INV_5) | (I_max_INV_5 < -i_reac_ref_INV_5)), (1, True)]))
        struct[0].Gy_ini[221,221] = -1
        struct[0].Gy_ini[222,30] = i_INV_6_a_r
        struct[0].Gy_ini[222,31] = i_INV_6_a_i
        struct[0].Gy_ini[222,222] = v_INV_6_a_r
        struct[0].Gy_ini[222,223] = v_INV_6_a_i
        struct[0].Gy_ini[223,32] = i_INV_6_b_r
        struct[0].Gy_ini[223,33] = i_INV_6_b_i
        struct[0].Gy_ini[223,224] = v_INV_6_b_r
        struct[0].Gy_ini[223,225] = v_INV_6_b_i
        struct[0].Gy_ini[224,34] = i_INV_6_c_r
        struct[0].Gy_ini[224,35] = i_INV_6_c_i
        struct[0].Gy_ini[224,226] = v_INV_6_c_r
        struct[0].Gy_ini[224,227] = v_INV_6_c_i
        struct[0].Gy_ini[225,30] = -i_INV_6_a_i
        struct[0].Gy_ini[225,31] = i_INV_6_a_r
        struct[0].Gy_ini[225,222] = v_INV_6_a_i
        struct[0].Gy_ini[225,223] = -v_INV_6_a_r
        struct[0].Gy_ini[226,32] = -i_INV_6_b_i
        struct[0].Gy_ini[226,33] = i_INV_6_b_r
        struct[0].Gy_ini[226,224] = v_INV_6_b_i
        struct[0].Gy_ini[226,225] = -v_INV_6_b_r
        struct[0].Gy_ini[227,34] = -i_INV_6_c_i
        struct[0].Gy_ini[227,35] = i_INV_6_c_r
        struct[0].Gy_ini[227,226] = v_INV_6_c_i
        struct[0].Gy_ini[227,227] = -v_INV_6_c_r
        struct[0].Gy_ini[228,30] = 1.0*v_INV_6_a_r*(v_INV_6_a_i**2 + v_INV_6_a_r**2)**(-0.5)/V_base_INV_6
        struct[0].Gy_ini[228,31] = 1.0*v_INV_6_a_i*(v_INV_6_a_i**2 + v_INV_6_a_r**2)**(-0.5)/V_base_INV_6
        struct[0].Gy_ini[228,228] = -1
        struct[0].Gy_ini[229,219] = -K_p_v_INV_6*u_ctrl_v_INV_6
        struct[0].Gy_ini[229,228] = K_p_v_INV_6*(u_ctrl_v_INV_6 - 1.0)
        struct[0].Gy_ini[229,229] = -1
        struct[0].Gy_ini[230,172] = 1.0*S_base_INV_6*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_6, I_max_INV_6 < -i_reac_ref_INV_6), (I_max_INV_6, I_max_INV_6 < i_reac_ref_INV_6), (i_reac_ref_INV_6, True)]))
        struct[0].Gy_ini[230,173] = 1.0*S_base_INV_6*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_6, I_max_INV_6 < -i_reac_ref_INV_6), (I_max_INV_6, I_max_INV_6 < i_reac_ref_INV_6), (i_reac_ref_INV_6, True)]))
        struct[0].Gy_ini[230,229] = S_base_INV_6*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_6 < i_reac_ref_INV_6) | (I_max_INV_6 < -i_reac_ref_INV_6)), (1, True)]))
        struct[0].Gy_ini[230,230] = -1
        struct[0].Gy_ini[231,36] = i_INV_7_a_r
        struct[0].Gy_ini[231,37] = i_INV_7_a_i
        struct[0].Gy_ini[231,231] = v_INV_7_a_r
        struct[0].Gy_ini[231,232] = v_INV_7_a_i
        struct[0].Gy_ini[232,38] = i_INV_7_b_r
        struct[0].Gy_ini[232,39] = i_INV_7_b_i
        struct[0].Gy_ini[232,233] = v_INV_7_b_r
        struct[0].Gy_ini[232,234] = v_INV_7_b_i
        struct[0].Gy_ini[233,40] = i_INV_7_c_r
        struct[0].Gy_ini[233,41] = i_INV_7_c_i
        struct[0].Gy_ini[233,235] = v_INV_7_c_r
        struct[0].Gy_ini[233,236] = v_INV_7_c_i
        struct[0].Gy_ini[234,36] = -i_INV_7_a_i
        struct[0].Gy_ini[234,37] = i_INV_7_a_r
        struct[0].Gy_ini[234,231] = v_INV_7_a_i
        struct[0].Gy_ini[234,232] = -v_INV_7_a_r
        struct[0].Gy_ini[235,38] = -i_INV_7_b_i
        struct[0].Gy_ini[235,39] = i_INV_7_b_r
        struct[0].Gy_ini[235,233] = v_INV_7_b_i
        struct[0].Gy_ini[235,234] = -v_INV_7_b_r
        struct[0].Gy_ini[236,40] = -i_INV_7_c_i
        struct[0].Gy_ini[236,41] = i_INV_7_c_r
        struct[0].Gy_ini[236,235] = v_INV_7_c_i
        struct[0].Gy_ini[236,236] = -v_INV_7_c_r
        struct[0].Gy_ini[237,36] = 1.0*v_INV_7_a_r*(v_INV_7_a_i**2 + v_INV_7_a_r**2)**(-0.5)/V_base_INV_7
        struct[0].Gy_ini[237,37] = 1.0*v_INV_7_a_i*(v_INV_7_a_i**2 + v_INV_7_a_r**2)**(-0.5)/V_base_INV_7
        struct[0].Gy_ini[237,237] = -1
        struct[0].Gy_ini[238,126] = 1.0*v_TR_7_8_mv_a_r*(v_TR_7_8_mv_a_i**2 + v_TR_7_8_mv_a_r**2)**(-0.5)/V_base_TR_7_8_mv
        struct[0].Gy_ini[238,127] = 1.0*v_TR_7_8_mv_a_i*(v_TR_7_8_mv_a_i**2 + v_TR_7_8_mv_a_r**2)**(-0.5)/V_base_TR_7_8_mv
        struct[0].Gy_ini[238,238] = -1
        struct[0].Gy_ini[239,237] = K_p_v_INV_7*(u_ctrl_v_INV_7 - 1.0)
        struct[0].Gy_ini[239,238] = -K_p_v_INV_7*u_ctrl_v_INV_7
        struct[0].Gy_ini[239,239] = -1
        struct[0].Gy_ini[240,172] = 1.0*S_base_INV_7*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_7, I_max_INV_7 < -i_reac_ref_INV_7), (I_max_INV_7, I_max_INV_7 < i_reac_ref_INV_7), (i_reac_ref_INV_7, True)]))
        struct[0].Gy_ini[240,173] = 1.0*S_base_INV_7*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_7, I_max_INV_7 < -i_reac_ref_INV_7), (I_max_INV_7, I_max_INV_7 < i_reac_ref_INV_7), (i_reac_ref_INV_7, True)]))
        struct[0].Gy_ini[240,239] = S_base_INV_7*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_7 < i_reac_ref_INV_7) | (I_max_INV_7 < -i_reac_ref_INV_7)), (1, True)]))
        struct[0].Gy_ini[240,240] = -1
        struct[0].Gy_ini[241,42] = i_INV_8_a_r
        struct[0].Gy_ini[241,43] = i_INV_8_a_i
        struct[0].Gy_ini[241,241] = v_INV_8_a_r
        struct[0].Gy_ini[241,242] = v_INV_8_a_i
        struct[0].Gy_ini[242,44] = i_INV_8_b_r
        struct[0].Gy_ini[242,45] = i_INV_8_b_i
        struct[0].Gy_ini[242,243] = v_INV_8_b_r
        struct[0].Gy_ini[242,244] = v_INV_8_b_i
        struct[0].Gy_ini[243,46] = i_INV_8_c_r
        struct[0].Gy_ini[243,47] = i_INV_8_c_i
        struct[0].Gy_ini[243,245] = v_INV_8_c_r
        struct[0].Gy_ini[243,246] = v_INV_8_c_i
        struct[0].Gy_ini[244,42] = -i_INV_8_a_i
        struct[0].Gy_ini[244,43] = i_INV_8_a_r
        struct[0].Gy_ini[244,241] = v_INV_8_a_i
        struct[0].Gy_ini[244,242] = -v_INV_8_a_r
        struct[0].Gy_ini[245,44] = -i_INV_8_b_i
        struct[0].Gy_ini[245,45] = i_INV_8_b_r
        struct[0].Gy_ini[245,243] = v_INV_8_b_i
        struct[0].Gy_ini[245,244] = -v_INV_8_b_r
        struct[0].Gy_ini[246,46] = -i_INV_8_c_i
        struct[0].Gy_ini[246,47] = i_INV_8_c_r
        struct[0].Gy_ini[246,245] = v_INV_8_c_i
        struct[0].Gy_ini[246,246] = -v_INV_8_c_r
        struct[0].Gy_ini[247,42] = 1.0*v_INV_8_a_r*(v_INV_8_a_i**2 + v_INV_8_a_r**2)**(-0.5)/V_base_INV_8
        struct[0].Gy_ini[247,43] = 1.0*v_INV_8_a_i*(v_INV_8_a_i**2 + v_INV_8_a_r**2)**(-0.5)/V_base_INV_8
        struct[0].Gy_ini[247,247] = -1
        struct[0].Gy_ini[248,238] = -K_p_v_INV_8*u_ctrl_v_INV_8
        struct[0].Gy_ini[248,247] = K_p_v_INV_8*(u_ctrl_v_INV_8 - 1.0)
        struct[0].Gy_ini[248,248] = -1
        struct[0].Gy_ini[249,172] = 1.0*S_base_INV_8*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_8, I_max_INV_8 < -i_reac_ref_INV_8), (I_max_INV_8, I_max_INV_8 < i_reac_ref_INV_8), (i_reac_ref_INV_8, True)]))
        struct[0].Gy_ini[249,173] = 1.0*S_base_INV_8*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_8, I_max_INV_8 < -i_reac_ref_INV_8), (I_max_INV_8, I_max_INV_8 < i_reac_ref_INV_8), (i_reac_ref_INV_8, True)]))
        struct[0].Gy_ini[249,248] = S_base_INV_8*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_8 < i_reac_ref_INV_8) | (I_max_INV_8 < -i_reac_ref_INV_8)), (1, True)]))
        struct[0].Gy_ini[249,249] = -1
        struct[0].Gy_ini[250,48] = i_INV_9_a_r
        struct[0].Gy_ini[250,49] = i_INV_9_a_i
        struct[0].Gy_ini[250,250] = v_INV_9_a_r
        struct[0].Gy_ini[250,251] = v_INV_9_a_i
        struct[0].Gy_ini[251,50] = i_INV_9_b_r
        struct[0].Gy_ini[251,51] = i_INV_9_b_i
        struct[0].Gy_ini[251,252] = v_INV_9_b_r
        struct[0].Gy_ini[251,253] = v_INV_9_b_i
        struct[0].Gy_ini[252,52] = i_INV_9_c_r
        struct[0].Gy_ini[252,53] = i_INV_9_c_i
        struct[0].Gy_ini[252,254] = v_INV_9_c_r
        struct[0].Gy_ini[252,255] = v_INV_9_c_i
        struct[0].Gy_ini[253,48] = -i_INV_9_a_i
        struct[0].Gy_ini[253,49] = i_INV_9_a_r
        struct[0].Gy_ini[253,250] = v_INV_9_a_i
        struct[0].Gy_ini[253,251] = -v_INV_9_a_r
        struct[0].Gy_ini[254,50] = -i_INV_9_b_i
        struct[0].Gy_ini[254,51] = i_INV_9_b_r
        struct[0].Gy_ini[254,252] = v_INV_9_b_i
        struct[0].Gy_ini[254,253] = -v_INV_9_b_r
        struct[0].Gy_ini[255,52] = -i_INV_9_c_i
        struct[0].Gy_ini[255,53] = i_INV_9_c_r
        struct[0].Gy_ini[255,254] = v_INV_9_c_i
        struct[0].Gy_ini[255,255] = -v_INV_9_c_r
        struct[0].Gy_ini[256,48] = 1.0*v_INV_9_a_r*(v_INV_9_a_i**2 + v_INV_9_a_r**2)**(-0.5)/V_base_INV_9
        struct[0].Gy_ini[256,49] = 1.0*v_INV_9_a_i*(v_INV_9_a_i**2 + v_INV_9_a_r**2)**(-0.5)/V_base_INV_9
        struct[0].Gy_ini[256,256] = -1
        struct[0].Gy_ini[257,138] = 1.0*v_TR_9_10_mv_a_r*(v_TR_9_10_mv_a_i**2 + v_TR_9_10_mv_a_r**2)**(-0.5)/V_base_TR_9_10_mv
        struct[0].Gy_ini[257,139] = 1.0*v_TR_9_10_mv_a_i*(v_TR_9_10_mv_a_i**2 + v_TR_9_10_mv_a_r**2)**(-0.5)/V_base_TR_9_10_mv
        struct[0].Gy_ini[257,257] = -1
        struct[0].Gy_ini[258,256] = K_p_v_INV_9*(u_ctrl_v_INV_9 - 1.0)
        struct[0].Gy_ini[258,257] = -K_p_v_INV_9*u_ctrl_v_INV_9
        struct[0].Gy_ini[258,258] = -1
        struct[0].Gy_ini[259,172] = 1.0*S_base_INV_9*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_9, I_max_INV_9 < -i_reac_ref_INV_9), (I_max_INV_9, I_max_INV_9 < i_reac_ref_INV_9), (i_reac_ref_INV_9, True)]))
        struct[0].Gy_ini[259,173] = 1.0*S_base_INV_9*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_9, I_max_INV_9 < -i_reac_ref_INV_9), (I_max_INV_9, I_max_INV_9 < i_reac_ref_INV_9), (i_reac_ref_INV_9, True)]))
        struct[0].Gy_ini[259,258] = S_base_INV_9*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_9 < i_reac_ref_INV_9) | (I_max_INV_9 < -i_reac_ref_INV_9)), (1, True)]))
        struct[0].Gy_ini[259,259] = -1
        struct[0].Gy_ini[260,54] = i_INV_10_a_r
        struct[0].Gy_ini[260,55] = i_INV_10_a_i
        struct[0].Gy_ini[260,260] = v_INV_10_a_r
        struct[0].Gy_ini[260,261] = v_INV_10_a_i
        struct[0].Gy_ini[261,56] = i_INV_10_b_r
        struct[0].Gy_ini[261,57] = i_INV_10_b_i
        struct[0].Gy_ini[261,262] = v_INV_10_b_r
        struct[0].Gy_ini[261,263] = v_INV_10_b_i
        struct[0].Gy_ini[262,58] = i_INV_10_c_r
        struct[0].Gy_ini[262,59] = i_INV_10_c_i
        struct[0].Gy_ini[262,264] = v_INV_10_c_r
        struct[0].Gy_ini[262,265] = v_INV_10_c_i
        struct[0].Gy_ini[263,54] = -i_INV_10_a_i
        struct[0].Gy_ini[263,55] = i_INV_10_a_r
        struct[0].Gy_ini[263,260] = v_INV_10_a_i
        struct[0].Gy_ini[263,261] = -v_INV_10_a_r
        struct[0].Gy_ini[264,56] = -i_INV_10_b_i
        struct[0].Gy_ini[264,57] = i_INV_10_b_r
        struct[0].Gy_ini[264,262] = v_INV_10_b_i
        struct[0].Gy_ini[264,263] = -v_INV_10_b_r
        struct[0].Gy_ini[265,58] = -i_INV_10_c_i
        struct[0].Gy_ini[265,59] = i_INV_10_c_r
        struct[0].Gy_ini[265,264] = v_INV_10_c_i
        struct[0].Gy_ini[265,265] = -v_INV_10_c_r
        struct[0].Gy_ini[266,54] = 1.0*v_INV_10_a_r*(v_INV_10_a_i**2 + v_INV_10_a_r**2)**(-0.5)/V_base_INV_10
        struct[0].Gy_ini[266,55] = 1.0*v_INV_10_a_i*(v_INV_10_a_i**2 + v_INV_10_a_r**2)**(-0.5)/V_base_INV_10
        struct[0].Gy_ini[266,266] = -1
        struct[0].Gy_ini[267,257] = -K_p_v_INV_10*u_ctrl_v_INV_10
        struct[0].Gy_ini[267,266] = K_p_v_INV_10*(u_ctrl_v_INV_10 - 1.0)
        struct[0].Gy_ini[267,267] = -1
        struct[0].Gy_ini[268,172] = 1.0*S_base_INV_10*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_10, I_max_INV_10 < -i_reac_ref_INV_10), (I_max_INV_10, I_max_INV_10 < i_reac_ref_INV_10), (i_reac_ref_INV_10, True)]))
        struct[0].Gy_ini[268,173] = 1.0*S_base_INV_10*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_10, I_max_INV_10 < -i_reac_ref_INV_10), (I_max_INV_10, I_max_INV_10 < i_reac_ref_INV_10), (i_reac_ref_INV_10, True)]))
        struct[0].Gy_ini[268,267] = S_base_INV_10*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_10 < i_reac_ref_INV_10) | (I_max_INV_10 < -i_reac_ref_INV_10)), (1, True)]))
        struct[0].Gy_ini[268,268] = -1
        struct[0].Gy_ini[269,60] = i_INV_11_a_r
        struct[0].Gy_ini[269,61] = i_INV_11_a_i
        struct[0].Gy_ini[269,269] = v_INV_11_a_r
        struct[0].Gy_ini[269,270] = v_INV_11_a_i
        struct[0].Gy_ini[270,62] = i_INV_11_b_r
        struct[0].Gy_ini[270,63] = i_INV_11_b_i
        struct[0].Gy_ini[270,271] = v_INV_11_b_r
        struct[0].Gy_ini[270,272] = v_INV_11_b_i
        struct[0].Gy_ini[271,64] = i_INV_11_c_r
        struct[0].Gy_ini[271,65] = i_INV_11_c_i
        struct[0].Gy_ini[271,273] = v_INV_11_c_r
        struct[0].Gy_ini[271,274] = v_INV_11_c_i
        struct[0].Gy_ini[272,60] = -i_INV_11_a_i
        struct[0].Gy_ini[272,61] = i_INV_11_a_r
        struct[0].Gy_ini[272,269] = v_INV_11_a_i
        struct[0].Gy_ini[272,270] = -v_INV_11_a_r
        struct[0].Gy_ini[273,62] = -i_INV_11_b_i
        struct[0].Gy_ini[273,63] = i_INV_11_b_r
        struct[0].Gy_ini[273,271] = v_INV_11_b_i
        struct[0].Gy_ini[273,272] = -v_INV_11_b_r
        struct[0].Gy_ini[274,64] = -i_INV_11_c_i
        struct[0].Gy_ini[274,65] = i_INV_11_c_r
        struct[0].Gy_ini[274,273] = v_INV_11_c_i
        struct[0].Gy_ini[274,274] = -v_INV_11_c_r
        struct[0].Gy_ini[275,60] = 1.0*v_INV_11_a_r*(v_INV_11_a_i**2 + v_INV_11_a_r**2)**(-0.5)/V_base_INV_11
        struct[0].Gy_ini[275,61] = 1.0*v_INV_11_a_i*(v_INV_11_a_i**2 + v_INV_11_a_r**2)**(-0.5)/V_base_INV_11
        struct[0].Gy_ini[275,275] = -1
        struct[0].Gy_ini[276,150] = 1.0*v_TR_11_12_mv_a_r*(v_TR_11_12_mv_a_i**2 + v_TR_11_12_mv_a_r**2)**(-0.5)/V_base_TR_11_12_mv
        struct[0].Gy_ini[276,151] = 1.0*v_TR_11_12_mv_a_i*(v_TR_11_12_mv_a_i**2 + v_TR_11_12_mv_a_r**2)**(-0.5)/V_base_TR_11_12_mv
        struct[0].Gy_ini[276,276] = -1
        struct[0].Gy_ini[277,275] = K_p_v_INV_11*(u_ctrl_v_INV_11 - 1.0)
        struct[0].Gy_ini[277,276] = -K_p_v_INV_11*u_ctrl_v_INV_11
        struct[0].Gy_ini[277,277] = -1
        struct[0].Gy_ini[278,172] = 1.0*S_base_INV_11*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_11, I_max_INV_11 < -i_reac_ref_INV_11), (I_max_INV_11, I_max_INV_11 < i_reac_ref_INV_11), (i_reac_ref_INV_11, True)]))
        struct[0].Gy_ini[278,173] = 1.0*S_base_INV_11*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_11, I_max_INV_11 < -i_reac_ref_INV_11), (I_max_INV_11, I_max_INV_11 < i_reac_ref_INV_11), (i_reac_ref_INV_11, True)]))
        struct[0].Gy_ini[278,277] = S_base_INV_11*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_11 < i_reac_ref_INV_11) | (I_max_INV_11 < -i_reac_ref_INV_11)), (1, True)]))
        struct[0].Gy_ini[278,278] = -1
        struct[0].Gy_ini[279,66] = i_INV_12_a_r
        struct[0].Gy_ini[279,67] = i_INV_12_a_i
        struct[0].Gy_ini[279,279] = v_INV_12_a_r
        struct[0].Gy_ini[279,280] = v_INV_12_a_i
        struct[0].Gy_ini[280,68] = i_INV_12_b_r
        struct[0].Gy_ini[280,69] = i_INV_12_b_i
        struct[0].Gy_ini[280,281] = v_INV_12_b_r
        struct[0].Gy_ini[280,282] = v_INV_12_b_i
        struct[0].Gy_ini[281,70] = i_INV_12_c_r
        struct[0].Gy_ini[281,71] = i_INV_12_c_i
        struct[0].Gy_ini[281,283] = v_INV_12_c_r
        struct[0].Gy_ini[281,284] = v_INV_12_c_i
        struct[0].Gy_ini[282,66] = -i_INV_12_a_i
        struct[0].Gy_ini[282,67] = i_INV_12_a_r
        struct[0].Gy_ini[282,279] = v_INV_12_a_i
        struct[0].Gy_ini[282,280] = -v_INV_12_a_r
        struct[0].Gy_ini[283,68] = -i_INV_12_b_i
        struct[0].Gy_ini[283,69] = i_INV_12_b_r
        struct[0].Gy_ini[283,281] = v_INV_12_b_i
        struct[0].Gy_ini[283,282] = -v_INV_12_b_r
        struct[0].Gy_ini[284,70] = -i_INV_12_c_i
        struct[0].Gy_ini[284,71] = i_INV_12_c_r
        struct[0].Gy_ini[284,283] = v_INV_12_c_i
        struct[0].Gy_ini[284,284] = -v_INV_12_c_r
        struct[0].Gy_ini[285,66] = 1.0*v_INV_12_a_r*(v_INV_12_a_i**2 + v_INV_12_a_r**2)**(-0.5)/V_base_INV_12
        struct[0].Gy_ini[285,67] = 1.0*v_INV_12_a_i*(v_INV_12_a_i**2 + v_INV_12_a_r**2)**(-0.5)/V_base_INV_12
        struct[0].Gy_ini[285,285] = -1
        struct[0].Gy_ini[286,276] = -K_p_v_INV_12*u_ctrl_v_INV_12
        struct[0].Gy_ini[286,285] = K_p_v_INV_12*(u_ctrl_v_INV_12 - 1.0)
        struct[0].Gy_ini[286,286] = -1
        struct[0].Gy_ini[287,172] = 1.0*S_base_INV_12*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_12, I_max_INV_12 < -i_reac_ref_INV_12), (I_max_INV_12, I_max_INV_12 < i_reac_ref_INV_12), (i_reac_ref_INV_12, True)]))
        struct[0].Gy_ini[287,173] = 1.0*S_base_INV_12*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_12, I_max_INV_12 < -i_reac_ref_INV_12), (I_max_INV_12, I_max_INV_12 < i_reac_ref_INV_12), (i_reac_ref_INV_12, True)]))
        struct[0].Gy_ini[287,286] = S_base_INV_12*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_12 < i_reac_ref_INV_12) | (I_max_INV_12 < -i_reac_ref_INV_12)), (1, True)]))
        struct[0].Gy_ini[287,287] = -1
        struct[0].Gy_ini[288,72] = i_INV_13_a_r
        struct[0].Gy_ini[288,73] = i_INV_13_a_i
        struct[0].Gy_ini[288,288] = v_INV_13_a_r
        struct[0].Gy_ini[288,289] = v_INV_13_a_i
        struct[0].Gy_ini[289,74] = i_INV_13_b_r
        struct[0].Gy_ini[289,75] = i_INV_13_b_i
        struct[0].Gy_ini[289,290] = v_INV_13_b_r
        struct[0].Gy_ini[289,291] = v_INV_13_b_i
        struct[0].Gy_ini[290,76] = i_INV_13_c_r
        struct[0].Gy_ini[290,77] = i_INV_13_c_i
        struct[0].Gy_ini[290,292] = v_INV_13_c_r
        struct[0].Gy_ini[290,293] = v_INV_13_c_i
        struct[0].Gy_ini[291,72] = -i_INV_13_a_i
        struct[0].Gy_ini[291,73] = i_INV_13_a_r
        struct[0].Gy_ini[291,288] = v_INV_13_a_i
        struct[0].Gy_ini[291,289] = -v_INV_13_a_r
        struct[0].Gy_ini[292,74] = -i_INV_13_b_i
        struct[0].Gy_ini[292,75] = i_INV_13_b_r
        struct[0].Gy_ini[292,290] = v_INV_13_b_i
        struct[0].Gy_ini[292,291] = -v_INV_13_b_r
        struct[0].Gy_ini[293,76] = -i_INV_13_c_i
        struct[0].Gy_ini[293,77] = i_INV_13_c_r
        struct[0].Gy_ini[293,292] = v_INV_13_c_i
        struct[0].Gy_ini[293,293] = -v_INV_13_c_r
        struct[0].Gy_ini[294,72] = 1.0*v_INV_13_a_r*(v_INV_13_a_i**2 + v_INV_13_a_r**2)**(-0.5)/V_base_INV_13
        struct[0].Gy_ini[294,73] = 1.0*v_INV_13_a_i*(v_INV_13_a_i**2 + v_INV_13_a_r**2)**(-0.5)/V_base_INV_13
        struct[0].Gy_ini[294,294] = -1
        struct[0].Gy_ini[295,162] = 1.0*v_TR_13_mv_a_r*(v_TR_13_mv_a_i**2 + v_TR_13_mv_a_r**2)**(-0.5)/V_base_TR_13_mv
        struct[0].Gy_ini[295,163] = 1.0*v_TR_13_mv_a_i*(v_TR_13_mv_a_i**2 + v_TR_13_mv_a_r**2)**(-0.5)/V_base_TR_13_mv
        struct[0].Gy_ini[295,295] = -1
        struct[0].Gy_ini[296,294] = K_p_v_INV_13*(u_ctrl_v_INV_13 - 1.0)
        struct[0].Gy_ini[296,295] = -K_p_v_INV_13*u_ctrl_v_INV_13
        struct[0].Gy_ini[296,296] = -1
        struct[0].Gy_ini[297,172] = 1.0*S_base_INV_13*v_TR_13_lv_c_r*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_13, I_max_INV_13 < -i_reac_ref_INV_13), (I_max_INV_13, I_max_INV_13 < i_reac_ref_INV_13), (i_reac_ref_INV_13, True)]))
        struct[0].Gy_ini[297,173] = 1.0*S_base_INV_13*v_TR_13_lv_c_i*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**(-0.5)*Piecewise(np.array([(-I_max_INV_13, I_max_INV_13 < -i_reac_ref_INV_13), (I_max_INV_13, I_max_INV_13 < i_reac_ref_INV_13), (i_reac_ref_INV_13, True)]))
        struct[0].Gy_ini[297,296] = S_base_INV_13*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(0, (I_max_INV_13 < i_reac_ref_INV_13) | (I_max_INV_13 < -i_reac_ref_INV_13)), (1, True)]))
        struct[0].Gy_ini[297,297] = -1



def run_nn(t,struct,mode):

    # Parameters:
    u_ctrl_v_INV_1 = struct[0].u_ctrl_v_INV_1
    K_p_v_INV_1 = struct[0].K_p_v_INV_1
    K_i_v_INV_1 = struct[0].K_i_v_INV_1
    V_base_INV_1 = struct[0].V_base_INV_1
    V_base_TR_1_2_mv = struct[0].V_base_TR_1_2_mv
    S_base_INV_1 = struct[0].S_base_INV_1
    I_max_INV_1 = struct[0].I_max_INV_1
    u_ctrl_v_INV_2 = struct[0].u_ctrl_v_INV_2
    K_p_v_INV_2 = struct[0].K_p_v_INV_2
    K_i_v_INV_2 = struct[0].K_i_v_INV_2
    V_base_INV_2 = struct[0].V_base_INV_2
    S_base_INV_2 = struct[0].S_base_INV_2
    I_max_INV_2 = struct[0].I_max_INV_2
    u_ctrl_v_INV_3 = struct[0].u_ctrl_v_INV_3
    K_p_v_INV_3 = struct[0].K_p_v_INV_3
    K_i_v_INV_3 = struct[0].K_i_v_INV_3
    V_base_INV_3 = struct[0].V_base_INV_3
    V_base_TR_3_4_mv = struct[0].V_base_TR_3_4_mv
    S_base_INV_3 = struct[0].S_base_INV_3
    I_max_INV_3 = struct[0].I_max_INV_3
    u_ctrl_v_INV_4 = struct[0].u_ctrl_v_INV_4
    K_p_v_INV_4 = struct[0].K_p_v_INV_4
    K_i_v_INV_4 = struct[0].K_i_v_INV_4
    V_base_INV_4 = struct[0].V_base_INV_4
    S_base_INV_4 = struct[0].S_base_INV_4
    I_max_INV_4 = struct[0].I_max_INV_4
    u_ctrl_v_INV_5 = struct[0].u_ctrl_v_INV_5
    K_p_v_INV_5 = struct[0].K_p_v_INV_5
    K_i_v_INV_5 = struct[0].K_i_v_INV_5
    V_base_INV_5 = struct[0].V_base_INV_5
    V_base_TR_5_6_mv = struct[0].V_base_TR_5_6_mv
    S_base_INV_5 = struct[0].S_base_INV_5
    I_max_INV_5 = struct[0].I_max_INV_5
    u_ctrl_v_INV_6 = struct[0].u_ctrl_v_INV_6
    K_p_v_INV_6 = struct[0].K_p_v_INV_6
    K_i_v_INV_6 = struct[0].K_i_v_INV_6
    V_base_INV_6 = struct[0].V_base_INV_6
    S_base_INV_6 = struct[0].S_base_INV_6
    I_max_INV_6 = struct[0].I_max_INV_6
    u_ctrl_v_INV_7 = struct[0].u_ctrl_v_INV_7
    K_p_v_INV_7 = struct[0].K_p_v_INV_7
    K_i_v_INV_7 = struct[0].K_i_v_INV_7
    V_base_INV_7 = struct[0].V_base_INV_7
    V_base_TR_7_8_mv = struct[0].V_base_TR_7_8_mv
    S_base_INV_7 = struct[0].S_base_INV_7
    I_max_INV_7 = struct[0].I_max_INV_7
    u_ctrl_v_INV_8 = struct[0].u_ctrl_v_INV_8
    K_p_v_INV_8 = struct[0].K_p_v_INV_8
    K_i_v_INV_8 = struct[0].K_i_v_INV_8
    V_base_INV_8 = struct[0].V_base_INV_8
    S_base_INV_8 = struct[0].S_base_INV_8
    I_max_INV_8 = struct[0].I_max_INV_8
    u_ctrl_v_INV_9 = struct[0].u_ctrl_v_INV_9
    K_p_v_INV_9 = struct[0].K_p_v_INV_9
    K_i_v_INV_9 = struct[0].K_i_v_INV_9
    V_base_INV_9 = struct[0].V_base_INV_9
    V_base_TR_9_10_mv = struct[0].V_base_TR_9_10_mv
    S_base_INV_9 = struct[0].S_base_INV_9
    I_max_INV_9 = struct[0].I_max_INV_9
    u_ctrl_v_INV_10 = struct[0].u_ctrl_v_INV_10
    K_p_v_INV_10 = struct[0].K_p_v_INV_10
    K_i_v_INV_10 = struct[0].K_i_v_INV_10
    V_base_INV_10 = struct[0].V_base_INV_10
    S_base_INV_10 = struct[0].S_base_INV_10
    I_max_INV_10 = struct[0].I_max_INV_10
    u_ctrl_v_INV_11 = struct[0].u_ctrl_v_INV_11
    K_p_v_INV_11 = struct[0].K_p_v_INV_11
    K_i_v_INV_11 = struct[0].K_i_v_INV_11
    V_base_INV_11 = struct[0].V_base_INV_11
    V_base_TR_11_12_mv = struct[0].V_base_TR_11_12_mv
    S_base_INV_11 = struct[0].S_base_INV_11
    I_max_INV_11 = struct[0].I_max_INV_11
    u_ctrl_v_INV_12 = struct[0].u_ctrl_v_INV_12
    K_p_v_INV_12 = struct[0].K_p_v_INV_12
    K_i_v_INV_12 = struct[0].K_i_v_INV_12
    V_base_INV_12 = struct[0].V_base_INV_12
    S_base_INV_12 = struct[0].S_base_INV_12
    I_max_INV_12 = struct[0].I_max_INV_12
    u_ctrl_v_INV_13 = struct[0].u_ctrl_v_INV_13
    K_p_v_INV_13 = struct[0].K_p_v_INV_13
    K_i_v_INV_13 = struct[0].K_i_v_INV_13
    V_base_INV_13 = struct[0].V_base_INV_13
    V_base_TR_13_mv = struct[0].V_base_TR_13_mv
    S_base_INV_13 = struct[0].S_base_INV_13
    I_max_INV_13 = struct[0].I_max_INV_13
    
    # Inputs:
    v_GRID_a_r = struct[0].v_GRID_a_r
    v_GRID_a_i = struct[0].v_GRID_a_i
    v_GRID_b_r = struct[0].v_GRID_b_r
    v_GRID_b_i = struct[0].v_GRID_b_i
    v_GRID_c_r = struct[0].v_GRID_c_r
    v_GRID_c_i = struct[0].v_GRID_c_i
    i_POIhv_a_r = struct[0].i_POIhv_a_r
    i_POIhv_a_i = struct[0].i_POIhv_a_i
    i_POIhv_b_r = struct[0].i_POIhv_b_r
    i_POIhv_b_i = struct[0].i_POIhv_b_i
    i_POIhv_c_r = struct[0].i_POIhv_c_r
    i_POIhv_c_i = struct[0].i_POIhv_c_i
    i_POImv_a_r = struct[0].i_POImv_a_r
    i_POImv_a_i = struct[0].i_POImv_a_i
    i_POImv_b_r = struct[0].i_POImv_b_r
    i_POImv_b_i = struct[0].i_POImv_b_i
    i_POImv_c_r = struct[0].i_POImv_c_r
    i_POImv_c_i = struct[0].i_POImv_c_i
    i_TR_1_2_mv_a_r = struct[0].i_TR_1_2_mv_a_r
    i_TR_1_2_mv_a_i = struct[0].i_TR_1_2_mv_a_i
    i_TR_1_2_mv_b_r = struct[0].i_TR_1_2_mv_b_r
    i_TR_1_2_mv_b_i = struct[0].i_TR_1_2_mv_b_i
    i_TR_1_2_mv_c_r = struct[0].i_TR_1_2_mv_c_r
    i_TR_1_2_mv_c_i = struct[0].i_TR_1_2_mv_c_i
    i_TR_1_2_lv_a_r = struct[0].i_TR_1_2_lv_a_r
    i_TR_1_2_lv_a_i = struct[0].i_TR_1_2_lv_a_i
    i_TR_1_2_lv_b_r = struct[0].i_TR_1_2_lv_b_r
    i_TR_1_2_lv_b_i = struct[0].i_TR_1_2_lv_b_i
    i_TR_1_2_lv_c_r = struct[0].i_TR_1_2_lv_c_r
    i_TR_1_2_lv_c_i = struct[0].i_TR_1_2_lv_c_i
    i_TR_3_4_mv_a_r = struct[0].i_TR_3_4_mv_a_r
    i_TR_3_4_mv_a_i = struct[0].i_TR_3_4_mv_a_i
    i_TR_3_4_mv_b_r = struct[0].i_TR_3_4_mv_b_r
    i_TR_3_4_mv_b_i = struct[0].i_TR_3_4_mv_b_i
    i_TR_3_4_mv_c_r = struct[0].i_TR_3_4_mv_c_r
    i_TR_3_4_mv_c_i = struct[0].i_TR_3_4_mv_c_i
    i_TR_3_4_lv_a_r = struct[0].i_TR_3_4_lv_a_r
    i_TR_3_4_lv_a_i = struct[0].i_TR_3_4_lv_a_i
    i_TR_3_4_lv_b_r = struct[0].i_TR_3_4_lv_b_r
    i_TR_3_4_lv_b_i = struct[0].i_TR_3_4_lv_b_i
    i_TR_3_4_lv_c_r = struct[0].i_TR_3_4_lv_c_r
    i_TR_3_4_lv_c_i = struct[0].i_TR_3_4_lv_c_i
    i_TR_5_6_mv_a_r = struct[0].i_TR_5_6_mv_a_r
    i_TR_5_6_mv_a_i = struct[0].i_TR_5_6_mv_a_i
    i_TR_5_6_mv_b_r = struct[0].i_TR_5_6_mv_b_r
    i_TR_5_6_mv_b_i = struct[0].i_TR_5_6_mv_b_i
    i_TR_5_6_mv_c_r = struct[0].i_TR_5_6_mv_c_r
    i_TR_5_6_mv_c_i = struct[0].i_TR_5_6_mv_c_i
    i_TR_5_6_lv_a_r = struct[0].i_TR_5_6_lv_a_r
    i_TR_5_6_lv_a_i = struct[0].i_TR_5_6_lv_a_i
    i_TR_5_6_lv_b_r = struct[0].i_TR_5_6_lv_b_r
    i_TR_5_6_lv_b_i = struct[0].i_TR_5_6_lv_b_i
    i_TR_5_6_lv_c_r = struct[0].i_TR_5_6_lv_c_r
    i_TR_5_6_lv_c_i = struct[0].i_TR_5_6_lv_c_i
    i_TR_7_8_mv_a_r = struct[0].i_TR_7_8_mv_a_r
    i_TR_7_8_mv_a_i = struct[0].i_TR_7_8_mv_a_i
    i_TR_7_8_mv_b_r = struct[0].i_TR_7_8_mv_b_r
    i_TR_7_8_mv_b_i = struct[0].i_TR_7_8_mv_b_i
    i_TR_7_8_mv_c_r = struct[0].i_TR_7_8_mv_c_r
    i_TR_7_8_mv_c_i = struct[0].i_TR_7_8_mv_c_i
    i_TR_7_8_lv_a_r = struct[0].i_TR_7_8_lv_a_r
    i_TR_7_8_lv_a_i = struct[0].i_TR_7_8_lv_a_i
    i_TR_7_8_lv_b_r = struct[0].i_TR_7_8_lv_b_r
    i_TR_7_8_lv_b_i = struct[0].i_TR_7_8_lv_b_i
    i_TR_7_8_lv_c_r = struct[0].i_TR_7_8_lv_c_r
    i_TR_7_8_lv_c_i = struct[0].i_TR_7_8_lv_c_i
    i_TR_9_10_mv_a_r = struct[0].i_TR_9_10_mv_a_r
    i_TR_9_10_mv_a_i = struct[0].i_TR_9_10_mv_a_i
    i_TR_9_10_mv_b_r = struct[0].i_TR_9_10_mv_b_r
    i_TR_9_10_mv_b_i = struct[0].i_TR_9_10_mv_b_i
    i_TR_9_10_mv_c_r = struct[0].i_TR_9_10_mv_c_r
    i_TR_9_10_mv_c_i = struct[0].i_TR_9_10_mv_c_i
    i_TR_9_10_lv_a_r = struct[0].i_TR_9_10_lv_a_r
    i_TR_9_10_lv_a_i = struct[0].i_TR_9_10_lv_a_i
    i_TR_9_10_lv_b_r = struct[0].i_TR_9_10_lv_b_r
    i_TR_9_10_lv_b_i = struct[0].i_TR_9_10_lv_b_i
    i_TR_9_10_lv_c_r = struct[0].i_TR_9_10_lv_c_r
    i_TR_9_10_lv_c_i = struct[0].i_TR_9_10_lv_c_i
    i_TR_11_12_mv_a_r = struct[0].i_TR_11_12_mv_a_r
    i_TR_11_12_mv_a_i = struct[0].i_TR_11_12_mv_a_i
    i_TR_11_12_mv_b_r = struct[0].i_TR_11_12_mv_b_r
    i_TR_11_12_mv_b_i = struct[0].i_TR_11_12_mv_b_i
    i_TR_11_12_mv_c_r = struct[0].i_TR_11_12_mv_c_r
    i_TR_11_12_mv_c_i = struct[0].i_TR_11_12_mv_c_i
    i_TR_11_12_lv_a_r = struct[0].i_TR_11_12_lv_a_r
    i_TR_11_12_lv_a_i = struct[0].i_TR_11_12_lv_a_i
    i_TR_11_12_lv_b_r = struct[0].i_TR_11_12_lv_b_r
    i_TR_11_12_lv_b_i = struct[0].i_TR_11_12_lv_b_i
    i_TR_11_12_lv_c_r = struct[0].i_TR_11_12_lv_c_r
    i_TR_11_12_lv_c_i = struct[0].i_TR_11_12_lv_c_i
    i_TR_13_mv_a_r = struct[0].i_TR_13_mv_a_r
    i_TR_13_mv_a_i = struct[0].i_TR_13_mv_a_i
    i_TR_13_mv_b_r = struct[0].i_TR_13_mv_b_r
    i_TR_13_mv_b_i = struct[0].i_TR_13_mv_b_i
    i_TR_13_mv_c_r = struct[0].i_TR_13_mv_c_r
    i_TR_13_mv_c_i = struct[0].i_TR_13_mv_c_i
    i_TR_13_lv_a_r = struct[0].i_TR_13_lv_a_r
    i_TR_13_lv_a_i = struct[0].i_TR_13_lv_a_i
    i_TR_13_lv_b_r = struct[0].i_TR_13_lv_b_r
    i_TR_13_lv_b_i = struct[0].i_TR_13_lv_b_i
    i_TR_13_lv_c_r = struct[0].i_TR_13_lv_c_r
    i_TR_13_lv_c_i = struct[0].i_TR_13_lv_c_i
    p_ref_INV_1 = struct[0].p_ref_INV_1
    T_pq_INV_1 = struct[0].T_pq_INV_1
    v_loc_ref_INV_1 = struct[0].v_loc_ref_INV_1
    Dv_r_INV_1 = struct[0].Dv_r_INV_1
    Dq_r_INV_1 = struct[0].Dq_r_INV_1
    p_ref_INV_2 = struct[0].p_ref_INV_2
    T_pq_INV_2 = struct[0].T_pq_INV_2
    v_loc_ref_INV_2 = struct[0].v_loc_ref_INV_2
    Dv_r_INV_2 = struct[0].Dv_r_INV_2
    Dq_r_INV_2 = struct[0].Dq_r_INV_2
    p_ref_INV_3 = struct[0].p_ref_INV_3
    T_pq_INV_3 = struct[0].T_pq_INV_3
    v_loc_ref_INV_3 = struct[0].v_loc_ref_INV_3
    Dv_r_INV_3 = struct[0].Dv_r_INV_3
    Dq_r_INV_3 = struct[0].Dq_r_INV_3
    p_ref_INV_4 = struct[0].p_ref_INV_4
    T_pq_INV_4 = struct[0].T_pq_INV_4
    v_loc_ref_INV_4 = struct[0].v_loc_ref_INV_4
    Dv_r_INV_4 = struct[0].Dv_r_INV_4
    Dq_r_INV_4 = struct[0].Dq_r_INV_4
    p_ref_INV_5 = struct[0].p_ref_INV_5
    T_pq_INV_5 = struct[0].T_pq_INV_5
    v_loc_ref_INV_5 = struct[0].v_loc_ref_INV_5
    Dv_r_INV_5 = struct[0].Dv_r_INV_5
    Dq_r_INV_5 = struct[0].Dq_r_INV_5
    p_ref_INV_6 = struct[0].p_ref_INV_6
    T_pq_INV_6 = struct[0].T_pq_INV_6
    v_loc_ref_INV_6 = struct[0].v_loc_ref_INV_6
    Dv_r_INV_6 = struct[0].Dv_r_INV_6
    Dq_r_INV_6 = struct[0].Dq_r_INV_6
    p_ref_INV_7 = struct[0].p_ref_INV_7
    T_pq_INV_7 = struct[0].T_pq_INV_7
    v_loc_ref_INV_7 = struct[0].v_loc_ref_INV_7
    Dv_r_INV_7 = struct[0].Dv_r_INV_7
    Dq_r_INV_7 = struct[0].Dq_r_INV_7
    p_ref_INV_8 = struct[0].p_ref_INV_8
    T_pq_INV_8 = struct[0].T_pq_INV_8
    v_loc_ref_INV_8 = struct[0].v_loc_ref_INV_8
    Dv_r_INV_8 = struct[0].Dv_r_INV_8
    Dq_r_INV_8 = struct[0].Dq_r_INV_8
    p_ref_INV_9 = struct[0].p_ref_INV_9
    T_pq_INV_9 = struct[0].T_pq_INV_9
    v_loc_ref_INV_9 = struct[0].v_loc_ref_INV_9
    Dv_r_INV_9 = struct[0].Dv_r_INV_9
    Dq_r_INV_9 = struct[0].Dq_r_INV_9
    p_ref_INV_10 = struct[0].p_ref_INV_10
    T_pq_INV_10 = struct[0].T_pq_INV_10
    v_loc_ref_INV_10 = struct[0].v_loc_ref_INV_10
    Dv_r_INV_10 = struct[0].Dv_r_INV_10
    Dq_r_INV_10 = struct[0].Dq_r_INV_10
    p_ref_INV_11 = struct[0].p_ref_INV_11
    T_pq_INV_11 = struct[0].T_pq_INV_11
    v_loc_ref_INV_11 = struct[0].v_loc_ref_INV_11
    Dv_r_INV_11 = struct[0].Dv_r_INV_11
    Dq_r_INV_11 = struct[0].Dq_r_INV_11
    p_ref_INV_12 = struct[0].p_ref_INV_12
    T_pq_INV_12 = struct[0].T_pq_INV_12
    v_loc_ref_INV_12 = struct[0].v_loc_ref_INV_12
    Dv_r_INV_12 = struct[0].Dv_r_INV_12
    Dq_r_INV_12 = struct[0].Dq_r_INV_12
    p_ref_INV_13 = struct[0].p_ref_INV_13
    T_pq_INV_13 = struct[0].T_pq_INV_13
    v_loc_ref_INV_13 = struct[0].v_loc_ref_INV_13
    Dv_r_INV_13 = struct[0].Dv_r_INV_13
    Dq_r_INV_13 = struct[0].Dq_r_INV_13
    
    # Dynamical states:
    p_INV_1_a = struct[0].x[0,0]
    p_INV_1_b = struct[0].x[1,0]
    p_INV_1_c = struct[0].x[2,0]
    q_INV_1_a = struct[0].x[3,0]
    q_INV_1_b = struct[0].x[4,0]
    q_INV_1_c = struct[0].x[5,0]
    p_INV_2_a = struct[0].x[6,0]
    p_INV_2_b = struct[0].x[7,0]
    p_INV_2_c = struct[0].x[8,0]
    q_INV_2_a = struct[0].x[9,0]
    q_INV_2_b = struct[0].x[10,0]
    q_INV_2_c = struct[0].x[11,0]
    p_INV_3_a = struct[0].x[12,0]
    p_INV_3_b = struct[0].x[13,0]
    p_INV_3_c = struct[0].x[14,0]
    q_INV_3_a = struct[0].x[15,0]
    q_INV_3_b = struct[0].x[16,0]
    q_INV_3_c = struct[0].x[17,0]
    p_INV_4_a = struct[0].x[18,0]
    p_INV_4_b = struct[0].x[19,0]
    p_INV_4_c = struct[0].x[20,0]
    q_INV_4_a = struct[0].x[21,0]
    q_INV_4_b = struct[0].x[22,0]
    q_INV_4_c = struct[0].x[23,0]
    p_INV_5_a = struct[0].x[24,0]
    p_INV_5_b = struct[0].x[25,0]
    p_INV_5_c = struct[0].x[26,0]
    q_INV_5_a = struct[0].x[27,0]
    q_INV_5_b = struct[0].x[28,0]
    q_INV_5_c = struct[0].x[29,0]
    p_INV_6_a = struct[0].x[30,0]
    p_INV_6_b = struct[0].x[31,0]
    p_INV_6_c = struct[0].x[32,0]
    q_INV_6_a = struct[0].x[33,0]
    q_INV_6_b = struct[0].x[34,0]
    q_INV_6_c = struct[0].x[35,0]
    p_INV_7_a = struct[0].x[36,0]
    p_INV_7_b = struct[0].x[37,0]
    p_INV_7_c = struct[0].x[38,0]
    q_INV_7_a = struct[0].x[39,0]
    q_INV_7_b = struct[0].x[40,0]
    q_INV_7_c = struct[0].x[41,0]
    p_INV_8_a = struct[0].x[42,0]
    p_INV_8_b = struct[0].x[43,0]
    p_INV_8_c = struct[0].x[44,0]
    q_INV_8_a = struct[0].x[45,0]
    q_INV_8_b = struct[0].x[46,0]
    q_INV_8_c = struct[0].x[47,0]
    p_INV_9_a = struct[0].x[48,0]
    p_INV_9_b = struct[0].x[49,0]
    p_INV_9_c = struct[0].x[50,0]
    q_INV_9_a = struct[0].x[51,0]
    q_INV_9_b = struct[0].x[52,0]
    q_INV_9_c = struct[0].x[53,0]
    p_INV_10_a = struct[0].x[54,0]
    p_INV_10_b = struct[0].x[55,0]
    p_INV_10_c = struct[0].x[56,0]
    q_INV_10_a = struct[0].x[57,0]
    q_INV_10_b = struct[0].x[58,0]
    q_INV_10_c = struct[0].x[59,0]
    p_INV_11_a = struct[0].x[60,0]
    p_INV_11_b = struct[0].x[61,0]
    p_INV_11_c = struct[0].x[62,0]
    q_INV_11_a = struct[0].x[63,0]
    q_INV_11_b = struct[0].x[64,0]
    q_INV_11_c = struct[0].x[65,0]
    p_INV_12_a = struct[0].x[66,0]
    p_INV_12_b = struct[0].x[67,0]
    p_INV_12_c = struct[0].x[68,0]
    q_INV_12_a = struct[0].x[69,0]
    q_INV_12_b = struct[0].x[70,0]
    q_INV_12_c = struct[0].x[71,0]
    p_INV_13_a = struct[0].x[72,0]
    p_INV_13_b = struct[0].x[73,0]
    p_INV_13_c = struct[0].x[74,0]
    q_INV_13_a = struct[0].x[75,0]
    q_INV_13_b = struct[0].x[76,0]
    q_INV_13_c = struct[0].x[77,0]
    
    # Algebraic states:
    v_INV_1_a_r = struct[0].y_run[0,0]
    v_INV_1_a_i = struct[0].y_run[1,0]
    v_INV_1_b_r = struct[0].y_run[2,0]
    v_INV_1_b_i = struct[0].y_run[3,0]
    v_INV_1_c_r = struct[0].y_run[4,0]
    v_INV_1_c_i = struct[0].y_run[5,0]
    v_INV_2_a_r = struct[0].y_run[6,0]
    v_INV_2_a_i = struct[0].y_run[7,0]
    v_INV_2_b_r = struct[0].y_run[8,0]
    v_INV_2_b_i = struct[0].y_run[9,0]
    v_INV_2_c_r = struct[0].y_run[10,0]
    v_INV_2_c_i = struct[0].y_run[11,0]
    v_INV_3_a_r = struct[0].y_run[12,0]
    v_INV_3_a_i = struct[0].y_run[13,0]
    v_INV_3_b_r = struct[0].y_run[14,0]
    v_INV_3_b_i = struct[0].y_run[15,0]
    v_INV_3_c_r = struct[0].y_run[16,0]
    v_INV_3_c_i = struct[0].y_run[17,0]
    v_INV_4_a_r = struct[0].y_run[18,0]
    v_INV_4_a_i = struct[0].y_run[19,0]
    v_INV_4_b_r = struct[0].y_run[20,0]
    v_INV_4_b_i = struct[0].y_run[21,0]
    v_INV_4_c_r = struct[0].y_run[22,0]
    v_INV_4_c_i = struct[0].y_run[23,0]
    v_INV_5_a_r = struct[0].y_run[24,0]
    v_INV_5_a_i = struct[0].y_run[25,0]
    v_INV_5_b_r = struct[0].y_run[26,0]
    v_INV_5_b_i = struct[0].y_run[27,0]
    v_INV_5_c_r = struct[0].y_run[28,0]
    v_INV_5_c_i = struct[0].y_run[29,0]
    v_INV_6_a_r = struct[0].y_run[30,0]
    v_INV_6_a_i = struct[0].y_run[31,0]
    v_INV_6_b_r = struct[0].y_run[32,0]
    v_INV_6_b_i = struct[0].y_run[33,0]
    v_INV_6_c_r = struct[0].y_run[34,0]
    v_INV_6_c_i = struct[0].y_run[35,0]
    v_INV_7_a_r = struct[0].y_run[36,0]
    v_INV_7_a_i = struct[0].y_run[37,0]
    v_INV_7_b_r = struct[0].y_run[38,0]
    v_INV_7_b_i = struct[0].y_run[39,0]
    v_INV_7_c_r = struct[0].y_run[40,0]
    v_INV_7_c_i = struct[0].y_run[41,0]
    v_INV_8_a_r = struct[0].y_run[42,0]
    v_INV_8_a_i = struct[0].y_run[43,0]
    v_INV_8_b_r = struct[0].y_run[44,0]
    v_INV_8_b_i = struct[0].y_run[45,0]
    v_INV_8_c_r = struct[0].y_run[46,0]
    v_INV_8_c_i = struct[0].y_run[47,0]
    v_INV_9_a_r = struct[0].y_run[48,0]
    v_INV_9_a_i = struct[0].y_run[49,0]
    v_INV_9_b_r = struct[0].y_run[50,0]
    v_INV_9_b_i = struct[0].y_run[51,0]
    v_INV_9_c_r = struct[0].y_run[52,0]
    v_INV_9_c_i = struct[0].y_run[53,0]
    v_INV_10_a_r = struct[0].y_run[54,0]
    v_INV_10_a_i = struct[0].y_run[55,0]
    v_INV_10_b_r = struct[0].y_run[56,0]
    v_INV_10_b_i = struct[0].y_run[57,0]
    v_INV_10_c_r = struct[0].y_run[58,0]
    v_INV_10_c_i = struct[0].y_run[59,0]
    v_INV_11_a_r = struct[0].y_run[60,0]
    v_INV_11_a_i = struct[0].y_run[61,0]
    v_INV_11_b_r = struct[0].y_run[62,0]
    v_INV_11_b_i = struct[0].y_run[63,0]
    v_INV_11_c_r = struct[0].y_run[64,0]
    v_INV_11_c_i = struct[0].y_run[65,0]
    v_INV_12_a_r = struct[0].y_run[66,0]
    v_INV_12_a_i = struct[0].y_run[67,0]
    v_INV_12_b_r = struct[0].y_run[68,0]
    v_INV_12_b_i = struct[0].y_run[69,0]
    v_INV_12_c_r = struct[0].y_run[70,0]
    v_INV_12_c_i = struct[0].y_run[71,0]
    v_INV_13_a_r = struct[0].y_run[72,0]
    v_INV_13_a_i = struct[0].y_run[73,0]
    v_INV_13_b_r = struct[0].y_run[74,0]
    v_INV_13_b_i = struct[0].y_run[75,0]
    v_INV_13_c_r = struct[0].y_run[76,0]
    v_INV_13_c_i = struct[0].y_run[77,0]
    v_POIhv_a_r = struct[0].y_run[78,0]
    v_POIhv_a_i = struct[0].y_run[79,0]
    v_POIhv_b_r = struct[0].y_run[80,0]
    v_POIhv_b_i = struct[0].y_run[81,0]
    v_POIhv_c_r = struct[0].y_run[82,0]
    v_POIhv_c_i = struct[0].y_run[83,0]
    v_POImv_a_r = struct[0].y_run[84,0]
    v_POImv_a_i = struct[0].y_run[85,0]
    v_POImv_b_r = struct[0].y_run[86,0]
    v_POImv_b_i = struct[0].y_run[87,0]
    v_POImv_c_r = struct[0].y_run[88,0]
    v_POImv_c_i = struct[0].y_run[89,0]
    v_TR_1_2_mv_a_r = struct[0].y_run[90,0]
    v_TR_1_2_mv_a_i = struct[0].y_run[91,0]
    v_TR_1_2_mv_b_r = struct[0].y_run[92,0]
    v_TR_1_2_mv_b_i = struct[0].y_run[93,0]
    v_TR_1_2_mv_c_r = struct[0].y_run[94,0]
    v_TR_1_2_mv_c_i = struct[0].y_run[95,0]
    v_TR_1_2_lv_a_r = struct[0].y_run[96,0]
    v_TR_1_2_lv_a_i = struct[0].y_run[97,0]
    v_TR_1_2_lv_b_r = struct[0].y_run[98,0]
    v_TR_1_2_lv_b_i = struct[0].y_run[99,0]
    v_TR_1_2_lv_c_r = struct[0].y_run[100,0]
    v_TR_1_2_lv_c_i = struct[0].y_run[101,0]
    v_TR_3_4_mv_a_r = struct[0].y_run[102,0]
    v_TR_3_4_mv_a_i = struct[0].y_run[103,0]
    v_TR_3_4_mv_b_r = struct[0].y_run[104,0]
    v_TR_3_4_mv_b_i = struct[0].y_run[105,0]
    v_TR_3_4_mv_c_r = struct[0].y_run[106,0]
    v_TR_3_4_mv_c_i = struct[0].y_run[107,0]
    v_TR_3_4_lv_a_r = struct[0].y_run[108,0]
    v_TR_3_4_lv_a_i = struct[0].y_run[109,0]
    v_TR_3_4_lv_b_r = struct[0].y_run[110,0]
    v_TR_3_4_lv_b_i = struct[0].y_run[111,0]
    v_TR_3_4_lv_c_r = struct[0].y_run[112,0]
    v_TR_3_4_lv_c_i = struct[0].y_run[113,0]
    v_TR_5_6_mv_a_r = struct[0].y_run[114,0]
    v_TR_5_6_mv_a_i = struct[0].y_run[115,0]
    v_TR_5_6_mv_b_r = struct[0].y_run[116,0]
    v_TR_5_6_mv_b_i = struct[0].y_run[117,0]
    v_TR_5_6_mv_c_r = struct[0].y_run[118,0]
    v_TR_5_6_mv_c_i = struct[0].y_run[119,0]
    v_TR_5_6_lv_a_r = struct[0].y_run[120,0]
    v_TR_5_6_lv_a_i = struct[0].y_run[121,0]
    v_TR_5_6_lv_b_r = struct[0].y_run[122,0]
    v_TR_5_6_lv_b_i = struct[0].y_run[123,0]
    v_TR_5_6_lv_c_r = struct[0].y_run[124,0]
    v_TR_5_6_lv_c_i = struct[0].y_run[125,0]
    v_TR_7_8_mv_a_r = struct[0].y_run[126,0]
    v_TR_7_8_mv_a_i = struct[0].y_run[127,0]
    v_TR_7_8_mv_b_r = struct[0].y_run[128,0]
    v_TR_7_8_mv_b_i = struct[0].y_run[129,0]
    v_TR_7_8_mv_c_r = struct[0].y_run[130,0]
    v_TR_7_8_mv_c_i = struct[0].y_run[131,0]
    v_TR_7_8_lv_a_r = struct[0].y_run[132,0]
    v_TR_7_8_lv_a_i = struct[0].y_run[133,0]
    v_TR_7_8_lv_b_r = struct[0].y_run[134,0]
    v_TR_7_8_lv_b_i = struct[0].y_run[135,0]
    v_TR_7_8_lv_c_r = struct[0].y_run[136,0]
    v_TR_7_8_lv_c_i = struct[0].y_run[137,0]
    v_TR_9_10_mv_a_r = struct[0].y_run[138,0]
    v_TR_9_10_mv_a_i = struct[0].y_run[139,0]
    v_TR_9_10_mv_b_r = struct[0].y_run[140,0]
    v_TR_9_10_mv_b_i = struct[0].y_run[141,0]
    v_TR_9_10_mv_c_r = struct[0].y_run[142,0]
    v_TR_9_10_mv_c_i = struct[0].y_run[143,0]
    v_TR_9_10_lv_a_r = struct[0].y_run[144,0]
    v_TR_9_10_lv_a_i = struct[0].y_run[145,0]
    v_TR_9_10_lv_b_r = struct[0].y_run[146,0]
    v_TR_9_10_lv_b_i = struct[0].y_run[147,0]
    v_TR_9_10_lv_c_r = struct[0].y_run[148,0]
    v_TR_9_10_lv_c_i = struct[0].y_run[149,0]
    v_TR_11_12_mv_a_r = struct[0].y_run[150,0]
    v_TR_11_12_mv_a_i = struct[0].y_run[151,0]
    v_TR_11_12_mv_b_r = struct[0].y_run[152,0]
    v_TR_11_12_mv_b_i = struct[0].y_run[153,0]
    v_TR_11_12_mv_c_r = struct[0].y_run[154,0]
    v_TR_11_12_mv_c_i = struct[0].y_run[155,0]
    v_TR_11_12_lv_a_r = struct[0].y_run[156,0]
    v_TR_11_12_lv_a_i = struct[0].y_run[157,0]
    v_TR_11_12_lv_b_r = struct[0].y_run[158,0]
    v_TR_11_12_lv_b_i = struct[0].y_run[159,0]
    v_TR_11_12_lv_c_r = struct[0].y_run[160,0]
    v_TR_11_12_lv_c_i = struct[0].y_run[161,0]
    v_TR_13_mv_a_r = struct[0].y_run[162,0]
    v_TR_13_mv_a_i = struct[0].y_run[163,0]
    v_TR_13_mv_b_r = struct[0].y_run[164,0]
    v_TR_13_mv_b_i = struct[0].y_run[165,0]
    v_TR_13_mv_c_r = struct[0].y_run[166,0]
    v_TR_13_mv_c_i = struct[0].y_run[167,0]
    v_TR_13_lv_a_r = struct[0].y_run[168,0]
    v_TR_13_lv_a_i = struct[0].y_run[169,0]
    v_TR_13_lv_b_r = struct[0].y_run[170,0]
    v_TR_13_lv_b_i = struct[0].y_run[171,0]
    v_TR_13_lv_c_r = struct[0].y_run[172,0]
    v_TR_13_lv_c_i = struct[0].y_run[173,0]
    i_INV_1_a_r = struct[0].y_run[174,0]
    i_INV_1_a_i = struct[0].y_run[175,0]
    i_INV_1_b_r = struct[0].y_run[176,0]
    i_INV_1_b_i = struct[0].y_run[177,0]
    i_INV_1_c_r = struct[0].y_run[178,0]
    i_INV_1_c_i = struct[0].y_run[179,0]
    v_m_INV_1 = struct[0].y_run[180,0]
    v_m_TR_1_2_mv = struct[0].y_run[181,0]
    i_reac_ref_INV_1 = struct[0].y_run[182,0]
    q_ref_INV_1 = struct[0].y_run[183,0]
    i_INV_2_a_r = struct[0].y_run[184,0]
    i_INV_2_a_i = struct[0].y_run[185,0]
    i_INV_2_b_r = struct[0].y_run[186,0]
    i_INV_2_b_i = struct[0].y_run[187,0]
    i_INV_2_c_r = struct[0].y_run[188,0]
    i_INV_2_c_i = struct[0].y_run[189,0]
    v_m_INV_2 = struct[0].y_run[190,0]
    i_reac_ref_INV_2 = struct[0].y_run[191,0]
    q_ref_INV_2 = struct[0].y_run[192,0]
    i_INV_3_a_r = struct[0].y_run[193,0]
    i_INV_3_a_i = struct[0].y_run[194,0]
    i_INV_3_b_r = struct[0].y_run[195,0]
    i_INV_3_b_i = struct[0].y_run[196,0]
    i_INV_3_c_r = struct[0].y_run[197,0]
    i_INV_3_c_i = struct[0].y_run[198,0]
    v_m_INV_3 = struct[0].y_run[199,0]
    v_m_TR_3_4_mv = struct[0].y_run[200,0]
    i_reac_ref_INV_3 = struct[0].y_run[201,0]
    q_ref_INV_3 = struct[0].y_run[202,0]
    i_INV_4_a_r = struct[0].y_run[203,0]
    i_INV_4_a_i = struct[0].y_run[204,0]
    i_INV_4_b_r = struct[0].y_run[205,0]
    i_INV_4_b_i = struct[0].y_run[206,0]
    i_INV_4_c_r = struct[0].y_run[207,0]
    i_INV_4_c_i = struct[0].y_run[208,0]
    v_m_INV_4 = struct[0].y_run[209,0]
    i_reac_ref_INV_4 = struct[0].y_run[210,0]
    q_ref_INV_4 = struct[0].y_run[211,0]
    i_INV_5_a_r = struct[0].y_run[212,0]
    i_INV_5_a_i = struct[0].y_run[213,0]
    i_INV_5_b_r = struct[0].y_run[214,0]
    i_INV_5_b_i = struct[0].y_run[215,0]
    i_INV_5_c_r = struct[0].y_run[216,0]
    i_INV_5_c_i = struct[0].y_run[217,0]
    v_m_INV_5 = struct[0].y_run[218,0]
    v_m_TR_5_6_mv = struct[0].y_run[219,0]
    i_reac_ref_INV_5 = struct[0].y_run[220,0]
    q_ref_INV_5 = struct[0].y_run[221,0]
    i_INV_6_a_r = struct[0].y_run[222,0]
    i_INV_6_a_i = struct[0].y_run[223,0]
    i_INV_6_b_r = struct[0].y_run[224,0]
    i_INV_6_b_i = struct[0].y_run[225,0]
    i_INV_6_c_r = struct[0].y_run[226,0]
    i_INV_6_c_i = struct[0].y_run[227,0]
    v_m_INV_6 = struct[0].y_run[228,0]
    i_reac_ref_INV_6 = struct[0].y_run[229,0]
    q_ref_INV_6 = struct[0].y_run[230,0]
    i_INV_7_a_r = struct[0].y_run[231,0]
    i_INV_7_a_i = struct[0].y_run[232,0]
    i_INV_7_b_r = struct[0].y_run[233,0]
    i_INV_7_b_i = struct[0].y_run[234,0]
    i_INV_7_c_r = struct[0].y_run[235,0]
    i_INV_7_c_i = struct[0].y_run[236,0]
    v_m_INV_7 = struct[0].y_run[237,0]
    v_m_TR_7_8_mv = struct[0].y_run[238,0]
    i_reac_ref_INV_7 = struct[0].y_run[239,0]
    q_ref_INV_7 = struct[0].y_run[240,0]
    i_INV_8_a_r = struct[0].y_run[241,0]
    i_INV_8_a_i = struct[0].y_run[242,0]
    i_INV_8_b_r = struct[0].y_run[243,0]
    i_INV_8_b_i = struct[0].y_run[244,0]
    i_INV_8_c_r = struct[0].y_run[245,0]
    i_INV_8_c_i = struct[0].y_run[246,0]
    v_m_INV_8 = struct[0].y_run[247,0]
    i_reac_ref_INV_8 = struct[0].y_run[248,0]
    q_ref_INV_8 = struct[0].y_run[249,0]
    i_INV_9_a_r = struct[0].y_run[250,0]
    i_INV_9_a_i = struct[0].y_run[251,0]
    i_INV_9_b_r = struct[0].y_run[252,0]
    i_INV_9_b_i = struct[0].y_run[253,0]
    i_INV_9_c_r = struct[0].y_run[254,0]
    i_INV_9_c_i = struct[0].y_run[255,0]
    v_m_INV_9 = struct[0].y_run[256,0]
    v_m_TR_9_10_mv = struct[0].y_run[257,0]
    i_reac_ref_INV_9 = struct[0].y_run[258,0]
    q_ref_INV_9 = struct[0].y_run[259,0]
    i_INV_10_a_r = struct[0].y_run[260,0]
    i_INV_10_a_i = struct[0].y_run[261,0]
    i_INV_10_b_r = struct[0].y_run[262,0]
    i_INV_10_b_i = struct[0].y_run[263,0]
    i_INV_10_c_r = struct[0].y_run[264,0]
    i_INV_10_c_i = struct[0].y_run[265,0]
    v_m_INV_10 = struct[0].y_run[266,0]
    i_reac_ref_INV_10 = struct[0].y_run[267,0]
    q_ref_INV_10 = struct[0].y_run[268,0]
    i_INV_11_a_r = struct[0].y_run[269,0]
    i_INV_11_a_i = struct[0].y_run[270,0]
    i_INV_11_b_r = struct[0].y_run[271,0]
    i_INV_11_b_i = struct[0].y_run[272,0]
    i_INV_11_c_r = struct[0].y_run[273,0]
    i_INV_11_c_i = struct[0].y_run[274,0]
    v_m_INV_11 = struct[0].y_run[275,0]
    v_m_TR_11_12_mv = struct[0].y_run[276,0]
    i_reac_ref_INV_11 = struct[0].y_run[277,0]
    q_ref_INV_11 = struct[0].y_run[278,0]
    i_INV_12_a_r = struct[0].y_run[279,0]
    i_INV_12_a_i = struct[0].y_run[280,0]
    i_INV_12_b_r = struct[0].y_run[281,0]
    i_INV_12_b_i = struct[0].y_run[282,0]
    i_INV_12_c_r = struct[0].y_run[283,0]
    i_INV_12_c_i = struct[0].y_run[284,0]
    v_m_INV_12 = struct[0].y_run[285,0]
    i_reac_ref_INV_12 = struct[0].y_run[286,0]
    q_ref_INV_12 = struct[0].y_run[287,0]
    i_INV_13_a_r = struct[0].y_run[288,0]
    i_INV_13_a_i = struct[0].y_run[289,0]
    i_INV_13_b_r = struct[0].y_run[290,0]
    i_INV_13_b_i = struct[0].y_run[291,0]
    i_INV_13_c_r = struct[0].y_run[292,0]
    i_INV_13_c_i = struct[0].y_run[293,0]
    v_m_INV_13 = struct[0].y_run[294,0]
    v_m_TR_13_mv = struct[0].y_run[295,0]
    i_reac_ref_INV_13 = struct[0].y_run[296,0]
    q_ref_INV_13 = struct[0].y_run[297,0]
    
    # Differential equations:
    if mode == 2:


        struct[0].f[0,0] = (-p_INV_1_a + p_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[1,0] = (-p_INV_1_b + p_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[2,0] = (-p_INV_1_c + p_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[3,0] = (-q_INV_1_a + q_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[4,0] = (-q_INV_1_b + q_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[5,0] = (-q_INV_1_c + q_ref_INV_1/3)/T_pq_INV_1
        struct[0].f[6,0] = (-p_INV_2_a + p_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[7,0] = (-p_INV_2_b + p_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[8,0] = (-p_INV_2_c + p_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[9,0] = (-q_INV_2_a + q_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[10,0] = (-q_INV_2_b + q_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[11,0] = (-q_INV_2_c + q_ref_INV_2/3)/T_pq_INV_2
        struct[0].f[12,0] = (-p_INV_3_a + p_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[13,0] = (-p_INV_3_b + p_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[14,0] = (-p_INV_3_c + p_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[15,0] = (-q_INV_3_a + q_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[16,0] = (-q_INV_3_b + q_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[17,0] = (-q_INV_3_c + q_ref_INV_3/3)/T_pq_INV_3
        struct[0].f[18,0] = (-p_INV_4_a + p_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[19,0] = (-p_INV_4_b + p_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[20,0] = (-p_INV_4_c + p_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[21,0] = (-q_INV_4_a + q_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[22,0] = (-q_INV_4_b + q_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[23,0] = (-q_INV_4_c + q_ref_INV_4/3)/T_pq_INV_4
        struct[0].f[24,0] = (-p_INV_5_a + p_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[25,0] = (-p_INV_5_b + p_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[26,0] = (-p_INV_5_c + p_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[27,0] = (-q_INV_5_a + q_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[28,0] = (-q_INV_5_b + q_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[29,0] = (-q_INV_5_c + q_ref_INV_5/3)/T_pq_INV_5
        struct[0].f[30,0] = (-p_INV_6_a + p_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[31,0] = (-p_INV_6_b + p_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[32,0] = (-p_INV_6_c + p_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[33,0] = (-q_INV_6_a + q_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[34,0] = (-q_INV_6_b + q_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[35,0] = (-q_INV_6_c + q_ref_INV_6/3)/T_pq_INV_6
        struct[0].f[36,0] = (-p_INV_7_a + p_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[37,0] = (-p_INV_7_b + p_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[38,0] = (-p_INV_7_c + p_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[39,0] = (-q_INV_7_a + q_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[40,0] = (-q_INV_7_b + q_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[41,0] = (-q_INV_7_c + q_ref_INV_7/3)/T_pq_INV_7
        struct[0].f[42,0] = (-p_INV_8_a + p_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[43,0] = (-p_INV_8_b + p_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[44,0] = (-p_INV_8_c + p_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[45,0] = (-q_INV_8_a + q_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[46,0] = (-q_INV_8_b + q_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[47,0] = (-q_INV_8_c + q_ref_INV_8/3)/T_pq_INV_8
        struct[0].f[48,0] = (-p_INV_9_a + p_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[49,0] = (-p_INV_9_b + p_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[50,0] = (-p_INV_9_c + p_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[51,0] = (-q_INV_9_a + q_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[52,0] = (-q_INV_9_b + q_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[53,0] = (-q_INV_9_c + q_ref_INV_9/3)/T_pq_INV_9
        struct[0].f[54,0] = (-p_INV_10_a + p_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[55,0] = (-p_INV_10_b + p_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[56,0] = (-p_INV_10_c + p_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[57,0] = (-q_INV_10_a + q_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[58,0] = (-q_INV_10_b + q_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[59,0] = (-q_INV_10_c + q_ref_INV_10/3)/T_pq_INV_10
        struct[0].f[60,0] = (-p_INV_11_a + p_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[61,0] = (-p_INV_11_b + p_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[62,0] = (-p_INV_11_c + p_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[63,0] = (-q_INV_11_a + q_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[64,0] = (-q_INV_11_b + q_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[65,0] = (-q_INV_11_c + q_ref_INV_11/3)/T_pq_INV_11
        struct[0].f[66,0] = (-p_INV_12_a + p_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[67,0] = (-p_INV_12_b + p_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[68,0] = (-p_INV_12_c + p_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[69,0] = (-q_INV_12_a + q_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[70,0] = (-q_INV_12_b + q_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[71,0] = (-q_INV_12_c + q_ref_INV_12/3)/T_pq_INV_12
        struct[0].f[72,0] = (-p_INV_13_a + p_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[73,0] = (-p_INV_13_b + p_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[74,0] = (-p_INV_13_c + p_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[75,0] = (-q_INV_13_a + q_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[76,0] = (-q_INV_13_b + q_ref_INV_13/3)/T_pq_INV_13
        struct[0].f[77,0] = (-q_INV_13_c + q_ref_INV_13/3)/T_pq_INV_13
    
    # Algebraic equations:
    if mode == 3:


        struct[0].g[0,0] = i_INV_1_a_r - 89.5459479864169*v_INV_1_a_i - 172.82391182454*v_INV_1_a_r + 25.5846390702588*v_INV_1_b_i + 49.3782605212972*v_INV_1_b_r + 25.5846390702587*v_INV_1_c_i + 49.3782605212972*v_INV_1_c_r + 89.5460683028705*v_TR_1_2_lv_a_i + 172.82391182454*v_TR_1_2_lv_a_r - 25.5845909436773*v_TR_1_2_lv_b_i - 49.3782605212972*v_TR_1_2_lv_b_r - 25.5845909436773*v_TR_1_2_lv_c_i - 49.3782605212972*v_TR_1_2_lv_c_r
        struct[0].g[1,0] = i_INV_1_a_i - 172.82391182454*v_INV_1_a_i + 89.5459479864169*v_INV_1_a_r + 49.3782605212972*v_INV_1_b_i - 25.5846390702588*v_INV_1_b_r + 49.3782605212972*v_INV_1_c_i - 25.5846390702587*v_INV_1_c_r + 172.82391182454*v_TR_1_2_lv_a_i - 89.5460683028705*v_TR_1_2_lv_a_r - 49.3782605212972*v_TR_1_2_lv_b_i + 25.5845909436773*v_TR_1_2_lv_b_r - 49.3782605212972*v_TR_1_2_lv_c_i + 25.5845909436773*v_TR_1_2_lv_c_r
        struct[0].g[2,0] = i_INV_1_b_r + 25.5846390702587*v_INV_1_a_i + 49.3782605212972*v_INV_1_a_r - 89.5459479864168*v_INV_1_b_i - 172.82391182454*v_INV_1_b_r + 25.5846390702587*v_INV_1_c_i + 49.3782605212973*v_INV_1_c_r - 25.5845909436773*v_TR_1_2_lv_a_i - 49.3782605212972*v_TR_1_2_lv_a_r + 89.5460683028705*v_TR_1_2_lv_b_i + 172.82391182454*v_TR_1_2_lv_b_r - 25.5845909436773*v_TR_1_2_lv_c_i - 49.3782605212973*v_TR_1_2_lv_c_r
        struct[0].g[3,0] = i_INV_1_b_i + 49.3782605212972*v_INV_1_a_i - 25.5846390702587*v_INV_1_a_r - 172.82391182454*v_INV_1_b_i + 89.5459479864168*v_INV_1_b_r + 49.3782605212973*v_INV_1_c_i - 25.5846390702587*v_INV_1_c_r - 49.3782605212972*v_TR_1_2_lv_a_i + 25.5845909436773*v_TR_1_2_lv_a_r + 172.82391182454*v_TR_1_2_lv_b_i - 89.5460683028705*v_TR_1_2_lv_b_r - 49.3782605212973*v_TR_1_2_lv_c_i + 25.5845909436773*v_TR_1_2_lv_c_r
        struct[0].g[4,0] = i_INV_1_c_r + 25.5846390702588*v_INV_1_a_i + 49.3782605212972*v_INV_1_a_r + 25.5846390702587*v_INV_1_b_i + 49.3782605212973*v_INV_1_b_r - 89.5459479864168*v_INV_1_c_i - 172.82391182454*v_INV_1_c_r - 25.5845909436773*v_TR_1_2_lv_a_i - 49.3782605212972*v_TR_1_2_lv_a_r - 25.5845909436772*v_TR_1_2_lv_b_i - 49.3782605212973*v_TR_1_2_lv_b_r + 89.5460683028705*v_TR_1_2_lv_c_i + 172.82391182454*v_TR_1_2_lv_c_r
        struct[0].g[5,0] = i_INV_1_c_i + 49.3782605212972*v_INV_1_a_i - 25.5846390702588*v_INV_1_a_r + 49.3782605212973*v_INV_1_b_i - 25.5846390702587*v_INV_1_b_r - 172.82391182454*v_INV_1_c_i + 89.5459479864168*v_INV_1_c_r - 49.3782605212972*v_TR_1_2_lv_a_i + 25.5845909436773*v_TR_1_2_lv_a_r - 49.3782605212973*v_TR_1_2_lv_b_i + 25.5845909436772*v_TR_1_2_lv_b_r + 172.82391182454*v_TR_1_2_lv_c_i - 89.5460683028705*v_TR_1_2_lv_c_r
        struct[0].g[6,0] = i_INV_2_a_r - 97.8437661123124*v_INV_2_a_i - 188.83868111451*v_INV_2_a_r + 27.9554372523104*v_INV_2_b_i + 53.9539088898601*v_INV_2_b_r + 27.9554372523104*v_INV_2_c_i + 53.9539088898601*v_INV_2_c_r + 97.8438762251349*v_TR_1_2_lv_a_i + 188.83868111451*v_TR_1_2_lv_a_r - 27.9553932071814*v_TR_1_2_lv_b_i - 53.9539088898601*v_TR_1_2_lv_b_r - 27.9553932071814*v_TR_1_2_lv_c_i - 53.9539088898601*v_TR_1_2_lv_c_r
        struct[0].g[7,0] = i_INV_2_a_i - 188.83868111451*v_INV_2_a_i + 97.8437661123124*v_INV_2_a_r + 53.9539088898601*v_INV_2_b_i - 27.9554372523104*v_INV_2_b_r + 53.9539088898601*v_INV_2_c_i - 27.9554372523104*v_INV_2_c_r + 188.83868111451*v_TR_1_2_lv_a_i - 97.8438762251349*v_TR_1_2_lv_a_r - 53.9539088898601*v_TR_1_2_lv_b_i + 27.9553932071814*v_TR_1_2_lv_b_r - 53.9539088898601*v_TR_1_2_lv_c_i + 27.9553932071814*v_TR_1_2_lv_c_r
        struct[0].g[8,0] = i_INV_2_b_r + 27.9554372523104*v_INV_2_a_i + 53.9539088898601*v_INV_2_a_r - 97.8437661123124*v_INV_2_b_i - 188.83868111451*v_INV_2_b_r + 27.9554372523104*v_INV_2_c_i + 53.9539088898602*v_INV_2_c_r - 27.9553932071814*v_TR_1_2_lv_a_i - 53.9539088898601*v_TR_1_2_lv_a_r + 97.8438762251349*v_TR_1_2_lv_b_i + 188.83868111451*v_TR_1_2_lv_b_r - 27.9553932071814*v_TR_1_2_lv_c_i - 53.9539088898602*v_TR_1_2_lv_c_r
        struct[0].g[9,0] = i_INV_2_b_i + 53.9539088898601*v_INV_2_a_i - 27.9554372523104*v_INV_2_a_r - 188.83868111451*v_INV_2_b_i + 97.8437661123124*v_INV_2_b_r + 53.9539088898602*v_INV_2_c_i - 27.9554372523104*v_INV_2_c_r - 53.9539088898601*v_TR_1_2_lv_a_i + 27.9553932071814*v_TR_1_2_lv_a_r + 188.83868111451*v_TR_1_2_lv_b_i - 97.8438762251349*v_TR_1_2_lv_b_r - 53.9539088898602*v_TR_1_2_lv_c_i + 27.9553932071814*v_TR_1_2_lv_c_r
        struct[0].g[10,0] = i_INV_2_c_r + 27.9554372523104*v_INV_2_a_i + 53.9539088898601*v_INV_2_a_r + 27.9554372523103*v_INV_2_b_i + 53.9539088898602*v_INV_2_b_r - 97.8437661123124*v_INV_2_c_i - 188.83868111451*v_INV_2_c_r - 27.9553932071814*v_TR_1_2_lv_a_i - 53.9539088898601*v_TR_1_2_lv_a_r - 27.9553932071813*v_TR_1_2_lv_b_i - 53.9539088898602*v_TR_1_2_lv_b_r + 97.8438762251349*v_TR_1_2_lv_c_i + 188.83868111451*v_TR_1_2_lv_c_r
        struct[0].g[11,0] = i_INV_2_c_i + 53.9539088898601*v_INV_2_a_i - 27.9554372523104*v_INV_2_a_r + 53.9539088898602*v_INV_2_b_i - 27.9554372523103*v_INV_2_b_r - 188.83868111451*v_INV_2_c_i + 97.8437661123124*v_INV_2_c_r - 53.9539088898601*v_TR_1_2_lv_a_i + 27.9553932071814*v_TR_1_2_lv_a_r - 53.9539088898602*v_TR_1_2_lv_b_i + 27.9553932071813*v_TR_1_2_lv_b_r + 188.83868111451*v_TR_1_2_lv_c_i - 97.8438762251349*v_TR_1_2_lv_c_r
        struct[0].g[12,0] = i_INV_3_a_r - 107.758827330392*v_INV_3_a_i - 207.974729711346*v_INV_3_a_r + 30.7883049386397*v_INV_3_b_i + 59.4213513460989*v_INV_3_b_r + 30.7883049386397*v_INV_3_c_i + 59.4213513460989*v_INV_3_c_r + 107.758927311578*v_TR_3_4_lv_a_i + 207.974729711346*v_TR_3_4_lv_a_r - 30.7882649461652*v_TR_3_4_lv_b_i - 59.4213513460989*v_TR_3_4_lv_b_r - 30.7882649461652*v_TR_3_4_lv_c_i - 59.4213513460989*v_TR_3_4_lv_c_r
        struct[0].g[13,0] = i_INV_3_a_i - 207.974729711346*v_INV_3_a_i + 107.758827330392*v_INV_3_a_r + 59.4213513460989*v_INV_3_b_i - 30.7883049386397*v_INV_3_b_r + 59.4213513460989*v_INV_3_c_i - 30.7883049386397*v_INV_3_c_r + 207.974729711346*v_TR_3_4_lv_a_i - 107.758927311578*v_TR_3_4_lv_a_r - 59.4213513460989*v_TR_3_4_lv_b_i + 30.7882649461652*v_TR_3_4_lv_b_r - 59.4213513460989*v_TR_3_4_lv_c_i + 30.7882649461652*v_TR_3_4_lv_c_r
        struct[0].g[14,0] = i_INV_3_b_r + 30.7883049386397*v_INV_3_a_i + 59.4213513460989*v_INV_3_a_r - 107.758827330392*v_INV_3_b_i - 207.974729711346*v_INV_3_b_r + 30.7883049386396*v_INV_3_c_i + 59.421351346099*v_INV_3_c_r - 30.7882649461652*v_TR_3_4_lv_a_i - 59.4213513460989*v_TR_3_4_lv_a_r + 107.758927311578*v_TR_3_4_lv_b_i + 207.974729711346*v_TR_3_4_lv_b_r - 30.7882649461651*v_TR_3_4_lv_c_i - 59.421351346099*v_TR_3_4_lv_c_r
        struct[0].g[15,0] = i_INV_3_b_i + 59.4213513460989*v_INV_3_a_i - 30.7883049386397*v_INV_3_a_r - 207.974729711346*v_INV_3_b_i + 107.758827330392*v_INV_3_b_r + 59.421351346099*v_INV_3_c_i - 30.7883049386396*v_INV_3_c_r - 59.4213513460989*v_TR_3_4_lv_a_i + 30.7882649461652*v_TR_3_4_lv_a_r + 207.974729711346*v_TR_3_4_lv_b_i - 107.758927311578*v_TR_3_4_lv_b_r - 59.421351346099*v_TR_3_4_lv_c_i + 30.7882649461651*v_TR_3_4_lv_c_r
        struct[0].g[16,0] = i_INV_3_c_r + 30.7883049386397*v_INV_3_a_i + 59.4213513460989*v_INV_3_a_r + 30.7883049386396*v_INV_3_b_i + 59.421351346099*v_INV_3_b_r - 107.758827330392*v_INV_3_c_i - 207.974729711346*v_INV_3_c_r - 30.7882649461652*v_TR_3_4_lv_a_i - 59.4213513460989*v_TR_3_4_lv_a_r - 30.7882649461651*v_TR_3_4_lv_b_i - 59.421351346099*v_TR_3_4_lv_b_r + 107.758927311578*v_TR_3_4_lv_c_i + 207.974729711346*v_TR_3_4_lv_c_r
        struct[0].g[17,0] = i_INV_3_c_i + 59.4213513460989*v_INV_3_a_i - 30.7883049386397*v_INV_3_a_r + 59.421351346099*v_INV_3_b_i - 30.7883049386396*v_INV_3_b_r - 207.974729711346*v_INV_3_c_i + 107.758827330392*v_INV_3_c_r - 59.4213513460989*v_TR_3_4_lv_a_i + 30.7882649461652*v_TR_3_4_lv_a_r - 59.421351346099*v_TR_3_4_lv_b_i + 30.7882649461651*v_TR_3_4_lv_b_r + 207.974729711346*v_TR_3_4_lv_c_i - 107.758927311578*v_TR_3_4_lv_c_r
        struct[0].g[18,0] = i_INV_4_a_r - 58.4538966359303*v_INV_4_a_i - 112.816376232042*v_INV_4_a_r + 16.701239710824*v_INV_4_b_i + 32.2332503520119*v_INV_4_b_r + 16.701239710824*v_INV_4_c_i + 32.2332503520119*v_INV_4_c_r + 58.4540809492443*v_TR_3_4_lv_a_i + 112.816376232042*v_TR_3_4_lv_a_r - 16.7011659854984*v_TR_3_4_lv_b_i - 32.2332503520119*v_TR_3_4_lv_b_r - 16.7011659854984*v_TR_3_4_lv_c_i - 32.2332503520119*v_TR_3_4_lv_c_r
        struct[0].g[19,0] = i_INV_4_a_i - 112.816376232042*v_INV_4_a_i + 58.4538966359303*v_INV_4_a_r + 32.2332503520119*v_INV_4_b_i - 16.701239710824*v_INV_4_b_r + 32.2332503520119*v_INV_4_c_i - 16.701239710824*v_INV_4_c_r + 112.816376232042*v_TR_3_4_lv_a_i - 58.4540809492443*v_TR_3_4_lv_a_r - 32.2332503520119*v_TR_3_4_lv_b_i + 16.7011659854984*v_TR_3_4_lv_b_r - 32.2332503520119*v_TR_3_4_lv_c_i + 16.7011659854984*v_TR_3_4_lv_c_r
        struct[0].g[20,0] = i_INV_4_b_r + 16.701239710824*v_INV_4_a_i + 32.2332503520119*v_INV_4_a_r - 58.4538966359303*v_INV_4_b_i - 112.816376232042*v_INV_4_b_r + 16.701239710824*v_INV_4_c_i + 32.2332503520119*v_INV_4_c_r - 16.7011659854984*v_TR_3_4_lv_a_i - 32.2332503520119*v_TR_3_4_lv_a_r + 58.4540809492443*v_TR_3_4_lv_b_i + 112.816376232042*v_TR_3_4_lv_b_r - 16.7011659854984*v_TR_3_4_lv_c_i - 32.2332503520119*v_TR_3_4_lv_c_r
        struct[0].g[21,0] = i_INV_4_b_i + 32.2332503520119*v_INV_4_a_i - 16.701239710824*v_INV_4_a_r - 112.816376232042*v_INV_4_b_i + 58.4538966359303*v_INV_4_b_r + 32.2332503520119*v_INV_4_c_i - 16.701239710824*v_INV_4_c_r - 32.2332503520119*v_TR_3_4_lv_a_i + 16.7011659854984*v_TR_3_4_lv_a_r + 112.816376232042*v_TR_3_4_lv_b_i - 58.4540809492443*v_TR_3_4_lv_b_r - 32.2332503520119*v_TR_3_4_lv_c_i + 16.7011659854984*v_TR_3_4_lv_c_r
        struct[0].g[22,0] = i_INV_4_c_r + 16.701239710824*v_INV_4_a_i + 32.2332503520119*v_INV_4_a_r + 16.7012397108239*v_INV_4_b_i + 32.2332503520119*v_INV_4_b_r - 58.4538966359303*v_INV_4_c_i - 112.816376232042*v_INV_4_c_r - 16.7011659854984*v_TR_3_4_lv_a_i - 32.2332503520119*v_TR_3_4_lv_a_r - 16.7011659854983*v_TR_3_4_lv_b_i - 32.2332503520119*v_TR_3_4_lv_b_r + 58.4540809492443*v_TR_3_4_lv_c_i + 112.816376232042*v_TR_3_4_lv_c_r
        struct[0].g[23,0] = i_INV_4_c_i + 32.2332503520119*v_INV_4_a_i - 16.701239710824*v_INV_4_a_r + 32.2332503520119*v_INV_4_b_i - 16.7012397108239*v_INV_4_b_r - 112.816376232042*v_INV_4_c_i + 58.4538966359303*v_INV_4_c_r - 32.2332503520119*v_TR_3_4_lv_a_i + 16.7011659854984*v_TR_3_4_lv_a_r - 32.2332503520119*v_TR_3_4_lv_b_i + 16.7011659854983*v_TR_3_4_lv_b_r + 112.816376232042*v_TR_3_4_lv_c_i - 58.4540809492443*v_TR_3_4_lv_c_r
        struct[0].g[24,0] = i_INV_5_a_r - 92.6871232662334*v_INV_5_a_i - 178.886372244962*v_INV_5_a_r + 26.4821149256174*v_INV_5_b_i + 51.1103920699891*v_INV_5_b_r + 26.4821149256174*v_INV_5_c_i + 51.1103920699891*v_INV_5_c_r + 92.6872395051616*v_TR_5_6_lv_a_i + 178.886372244962*v_TR_5_6_lv_a_r - 26.4820684300462*v_TR_5_6_lv_b_i - 51.1103920699891*v_TR_5_6_lv_b_r - 26.4820684300462*v_TR_5_6_lv_c_i - 51.1103920699891*v_TR_5_6_lv_c_r
        struct[0].g[25,0] = i_INV_5_a_i - 178.886372244962*v_INV_5_a_i + 92.6871232662334*v_INV_5_a_r + 51.1103920699891*v_INV_5_b_i - 26.4821149256174*v_INV_5_b_r + 51.1103920699891*v_INV_5_c_i - 26.4821149256174*v_INV_5_c_r + 178.886372244962*v_TR_5_6_lv_a_i - 92.6872395051616*v_TR_5_6_lv_a_r - 51.1103920699891*v_TR_5_6_lv_b_i + 26.4820684300462*v_TR_5_6_lv_b_r - 51.1103920699891*v_TR_5_6_lv_c_i + 26.4820684300462*v_TR_5_6_lv_c_r
        struct[0].g[26,0] = i_INV_5_b_r + 26.4821149256174*v_INV_5_a_i + 51.1103920699891*v_INV_5_a_r - 92.6871232662333*v_INV_5_b_i - 178.886372244962*v_INV_5_b_r + 26.4821149256174*v_INV_5_c_i + 51.1103920699892*v_INV_5_c_r - 26.4820684300461*v_TR_5_6_lv_a_i - 51.1103920699891*v_TR_5_6_lv_a_r + 92.6872395051615*v_TR_5_6_lv_b_i + 178.886372244962*v_TR_5_6_lv_b_r - 26.4820684300461*v_TR_5_6_lv_c_i - 51.1103920699892*v_TR_5_6_lv_c_r
        struct[0].g[27,0] = i_INV_5_b_i + 51.1103920699891*v_INV_5_a_i - 26.4821149256174*v_INV_5_a_r - 178.886372244962*v_INV_5_b_i + 92.6871232662333*v_INV_5_b_r + 51.1103920699892*v_INV_5_c_i - 26.4821149256174*v_INV_5_c_r - 51.1103920699891*v_TR_5_6_lv_a_i + 26.4820684300461*v_TR_5_6_lv_a_r + 178.886372244962*v_TR_5_6_lv_b_i - 92.6872395051615*v_TR_5_6_lv_b_r - 51.1103920699892*v_TR_5_6_lv_c_i + 26.4820684300461*v_TR_5_6_lv_c_r
        struct[0].g[28,0] = i_INV_5_c_r + 26.4821149256174*v_INV_5_a_i + 51.1103920699891*v_INV_5_a_r + 26.4821149256174*v_INV_5_b_i + 51.1103920699892*v_INV_5_b_r - 92.6871232662333*v_INV_5_c_i - 178.886372244962*v_INV_5_c_r - 26.4820684300462*v_TR_5_6_lv_a_i - 51.1103920699891*v_TR_5_6_lv_a_r - 26.4820684300461*v_TR_5_6_lv_b_i - 51.1103920699892*v_TR_5_6_lv_b_r + 92.6872395051615*v_TR_5_6_lv_c_i + 178.886372244962*v_TR_5_6_lv_c_r
        struct[0].g[29,0] = i_INV_5_c_i + 51.1103920699891*v_INV_5_a_i - 26.4821149256174*v_INV_5_a_r + 51.1103920699892*v_INV_5_b_i - 26.4821149256174*v_INV_5_b_r - 178.886372244962*v_INV_5_c_i + 92.6871232662333*v_INV_5_c_r - 51.1103920699891*v_TR_5_6_lv_a_i + 26.4820684300462*v_TR_5_6_lv_a_r - 51.1103920699892*v_TR_5_6_lv_b_i + 26.4820684300461*v_TR_5_6_lv_b_r + 178.886372244962*v_TR_5_6_lv_c_i - 92.6872395051615*v_TR_5_6_lv_c_r
        struct[0].g[30,0] = i_INV_6_a_r - 58.4995981119106*v_INV_6_a_i - 112.904579802783*v_INV_6_a_r + 16.714297176654*v_INV_6_b_i + 32.2584513722238*v_INV_6_b_r + 16.714297176654*v_INV_6_c_i + 32.2584513722239*v_INV_6_c_r + 58.4997822812349*v_TR_5_6_lv_a_i + 112.904579802783*v_TR_5_6_lv_a_r - 16.7142235089243*v_TR_5_6_lv_b_i - 32.2584513722238*v_TR_5_6_lv_b_r - 16.7142235089243*v_TR_5_6_lv_c_i - 32.2584513722239*v_TR_5_6_lv_c_r
        struct[0].g[31,0] = i_INV_6_a_i - 112.904579802783*v_INV_6_a_i + 58.4995981119106*v_INV_6_a_r + 32.2584513722238*v_INV_6_b_i - 16.714297176654*v_INV_6_b_r + 32.2584513722239*v_INV_6_c_i - 16.714297176654*v_INV_6_c_r + 112.904579802783*v_TR_5_6_lv_a_i - 58.4997822812349*v_TR_5_6_lv_a_r - 32.2584513722238*v_TR_5_6_lv_b_i + 16.7142235089243*v_TR_5_6_lv_b_r - 32.2584513722239*v_TR_5_6_lv_c_i + 16.7142235089243*v_TR_5_6_lv_c_r
        struct[0].g[32,0] = i_INV_6_b_r + 16.714297176654*v_INV_6_a_i + 32.2584513722238*v_INV_6_a_r - 58.4995981119106*v_INV_6_b_i - 112.904579802783*v_INV_6_b_r + 16.714297176654*v_INV_6_c_i + 32.2584513722239*v_INV_6_c_r - 16.7142235089243*v_TR_5_6_lv_a_i - 32.2584513722238*v_TR_5_6_lv_a_r + 58.4997822812349*v_TR_5_6_lv_b_i + 112.904579802783*v_TR_5_6_lv_b_r - 16.7142235089242*v_TR_5_6_lv_c_i - 32.2584513722239*v_TR_5_6_lv_c_r
        struct[0].g[33,0] = i_INV_6_b_i + 32.2584513722238*v_INV_6_a_i - 16.714297176654*v_INV_6_a_r - 112.904579802783*v_INV_6_b_i + 58.4995981119106*v_INV_6_b_r + 32.2584513722239*v_INV_6_c_i - 16.714297176654*v_INV_6_c_r - 32.2584513722238*v_TR_5_6_lv_a_i + 16.7142235089243*v_TR_5_6_lv_a_r + 112.904579802783*v_TR_5_6_lv_b_i - 58.4997822812349*v_TR_5_6_lv_b_r - 32.2584513722239*v_TR_5_6_lv_c_i + 16.7142235089242*v_TR_5_6_lv_c_r
        struct[0].g[34,0] = i_INV_6_c_r + 16.714297176654*v_INV_6_a_i + 32.2584513722239*v_INV_6_a_r + 16.714297176654*v_INV_6_b_i + 32.2584513722239*v_INV_6_b_r - 58.4995981119106*v_INV_6_c_i - 112.904579802783*v_INV_6_c_r - 16.7142235089243*v_TR_5_6_lv_a_i - 32.2584513722239*v_TR_5_6_lv_a_r - 16.7142235089242*v_TR_5_6_lv_b_i - 32.2584513722239*v_TR_5_6_lv_b_r + 58.4997822812349*v_TR_5_6_lv_c_i + 112.904579802783*v_TR_5_6_lv_c_r
        struct[0].g[35,0] = i_INV_6_c_i + 32.2584513722239*v_INV_6_a_i - 16.714297176654*v_INV_6_a_r + 32.2584513722239*v_INV_6_b_i - 16.714297176654*v_INV_6_b_r - 112.904579802783*v_INV_6_c_i + 58.4995981119106*v_INV_6_c_r - 32.2584513722239*v_TR_5_6_lv_a_i + 16.7142235089243*v_TR_5_6_lv_a_r - 32.2584513722239*v_TR_5_6_lv_b_i + 16.7142235089242*v_TR_5_6_lv_b_r + 112.904579802783*v_TR_5_6_lv_c_i - 58.4997822812349*v_TR_5_6_lv_c_r
        struct[0].g[36,0] = i_INV_7_a_r - 246.057560640311*v_INV_7_a_i - 474.891176542679*v_INV_7_a_r + 70.3021902075957*v_INV_7_b_i + 135.683193297908*v_INV_7_b_r + 70.3021902075957*v_INV_7_c_i + 135.683193297908*v_INV_7_c_r + 246.057604426258*v_TR_7_8_lv_a_i + 474.891176542679*v_TR_7_8_lv_a_r - 70.3021726932167*v_TR_7_8_lv_b_i - 135.683193297908*v_TR_7_8_lv_b_r - 70.3021726932166*v_TR_7_8_lv_c_i - 135.683193297908*v_TR_7_8_lv_c_r
        struct[0].g[37,0] = i_INV_7_a_i - 474.891176542679*v_INV_7_a_i + 246.057560640311*v_INV_7_a_r + 135.683193297908*v_INV_7_b_i - 70.3021902075957*v_INV_7_b_r + 135.683193297908*v_INV_7_c_i - 70.3021902075957*v_INV_7_c_r + 474.891176542679*v_TR_7_8_lv_a_i - 246.057604426258*v_TR_7_8_lv_a_r - 135.683193297908*v_TR_7_8_lv_b_i + 70.3021726932167*v_TR_7_8_lv_b_r - 135.683193297908*v_TR_7_8_lv_c_i + 70.3021726932166*v_TR_7_8_lv_c_r
        struct[0].g[38,0] = i_INV_7_b_r + 70.3021902075957*v_INV_7_a_i + 135.683193297908*v_INV_7_a_r - 246.057560640311*v_INV_7_b_i - 474.891176542679*v_INV_7_b_r + 70.3021902075956*v_INV_7_c_i + 135.683193297909*v_INV_7_c_r - 70.3021726932166*v_TR_7_8_lv_a_i - 135.683193297908*v_TR_7_8_lv_a_r + 246.057604426258*v_TR_7_8_lv_b_i + 474.891176542679*v_TR_7_8_lv_b_r - 70.3021726932165*v_TR_7_8_lv_c_i - 135.683193297909*v_TR_7_8_lv_c_r
        struct[0].g[39,0] = i_INV_7_b_i + 135.683193297908*v_INV_7_a_i - 70.3021902075957*v_INV_7_a_r - 474.891176542679*v_INV_7_b_i + 246.057560640311*v_INV_7_b_r + 135.683193297909*v_INV_7_c_i - 70.3021902075956*v_INV_7_c_r - 135.683193297908*v_TR_7_8_lv_a_i + 70.3021726932166*v_TR_7_8_lv_a_r + 474.891176542679*v_TR_7_8_lv_b_i - 246.057604426258*v_TR_7_8_lv_b_r - 135.683193297909*v_TR_7_8_lv_c_i + 70.3021726932165*v_TR_7_8_lv_c_r
        struct[0].g[40,0] = i_INV_7_c_r + 70.3021902075957*v_INV_7_a_i + 135.683193297908*v_INV_7_a_r + 70.3021902075956*v_INV_7_b_i + 135.683193297909*v_INV_7_b_r - 246.057560640311*v_INV_7_c_i - 474.891176542679*v_INV_7_c_r - 70.3021726932167*v_TR_7_8_lv_a_i - 135.683193297908*v_TR_7_8_lv_a_r - 70.3021726932165*v_TR_7_8_lv_b_i - 135.683193297909*v_TR_7_8_lv_b_r + 246.057604426258*v_TR_7_8_lv_c_i + 474.891176542679*v_TR_7_8_lv_c_r
        struct[0].g[41,0] = i_INV_7_c_i + 135.683193297908*v_INV_7_a_i - 70.3021902075957*v_INV_7_a_r + 135.683193297909*v_INV_7_b_i - 70.3021902075956*v_INV_7_b_r - 474.891176542679*v_INV_7_c_i + 246.057560640311*v_INV_7_c_r - 135.683193297908*v_TR_7_8_lv_a_i + 70.3021726932167*v_TR_7_8_lv_a_r - 135.683193297909*v_TR_7_8_lv_b_i + 70.3021726932165*v_TR_7_8_lv_b_r + 474.891176542679*v_TR_7_8_lv_c_i - 246.057604426258*v_TR_7_8_lv_c_r
        struct[0].g[42,0] = i_INV_8_a_r - 106.794071531051*v_INV_8_a_i - 206.112752761809*v_INV_8_a_r + 30.5126610438848*v_INV_8_b_i + 58.8893579319454*v_INV_8_b_r + 30.5126610438848*v_INV_8_c_i + 58.8893579319454*v_INV_8_c_r + 106.794172415445*v_TR_7_8_lv_a_i + 206.112752761809*v_TR_7_8_lv_a_r - 30.5126206901271*v_TR_7_8_lv_b_i - 58.8893579319454*v_TR_7_8_lv_b_r - 30.5126206901271*v_TR_7_8_lv_c_i - 58.8893579319454*v_TR_7_8_lv_c_r
        struct[0].g[43,0] = i_INV_8_a_i - 206.112752761809*v_INV_8_a_i + 106.794071531051*v_INV_8_a_r + 58.8893579319454*v_INV_8_b_i - 30.5126610438848*v_INV_8_b_r + 58.8893579319454*v_INV_8_c_i - 30.5126610438848*v_INV_8_c_r + 206.112752761809*v_TR_7_8_lv_a_i - 106.794172415445*v_TR_7_8_lv_a_r - 58.8893579319454*v_TR_7_8_lv_b_i + 30.5126206901271*v_TR_7_8_lv_b_r - 58.8893579319454*v_TR_7_8_lv_c_i + 30.5126206901271*v_TR_7_8_lv_c_r
        struct[0].g[44,0] = i_INV_8_b_r + 30.5126610438847*v_INV_8_a_i + 58.8893579319454*v_INV_8_a_r - 106.794071531051*v_INV_8_b_i - 206.112752761809*v_INV_8_b_r + 30.5126610438847*v_INV_8_c_i + 58.8893579319455*v_INV_8_c_r - 30.5126206901271*v_TR_7_8_lv_a_i - 58.8893579319454*v_TR_7_8_lv_a_r + 106.794172415445*v_TR_7_8_lv_b_i + 206.112752761809*v_TR_7_8_lv_b_r - 30.5126206901271*v_TR_7_8_lv_c_i - 58.8893579319455*v_TR_7_8_lv_c_r
        struct[0].g[45,0] = i_INV_8_b_i + 58.8893579319454*v_INV_8_a_i - 30.5126610438847*v_INV_8_a_r - 206.112752761809*v_INV_8_b_i + 106.794071531051*v_INV_8_b_r + 58.8893579319455*v_INV_8_c_i - 30.5126610438847*v_INV_8_c_r - 58.8893579319454*v_TR_7_8_lv_a_i + 30.5126206901271*v_TR_7_8_lv_a_r + 206.112752761809*v_TR_7_8_lv_b_i - 106.794172415445*v_TR_7_8_lv_b_r - 58.8893579319455*v_TR_7_8_lv_c_i + 30.5126206901271*v_TR_7_8_lv_c_r
        struct[0].g[46,0] = i_INV_8_c_r + 30.5126610438848*v_INV_8_a_i + 58.8893579319454*v_INV_8_a_r + 30.5126610438847*v_INV_8_b_i + 58.8893579319455*v_INV_8_b_r - 106.794071531051*v_INV_8_c_i - 206.112752761809*v_INV_8_c_r - 30.5126206901272*v_TR_7_8_lv_a_i - 58.8893579319454*v_TR_7_8_lv_a_r - 30.5126206901271*v_TR_7_8_lv_b_i - 58.8893579319455*v_TR_7_8_lv_b_r + 106.794172415445*v_TR_7_8_lv_c_i + 206.112752761809*v_TR_7_8_lv_c_r
        struct[0].g[47,0] = i_INV_8_c_i + 58.8893579319454*v_INV_8_a_i - 30.5126610438848*v_INV_8_a_r + 58.8893579319455*v_INV_8_b_i - 30.5126610438847*v_INV_8_b_r - 206.112752761809*v_INV_8_c_i + 106.794071531051*v_INV_8_c_r - 58.8893579319454*v_TR_7_8_lv_a_i + 30.5126206901272*v_TR_7_8_lv_a_r - 58.8893579319455*v_TR_7_8_lv_b_i + 30.5126206901271*v_TR_7_8_lv_b_r + 206.112752761809*v_TR_7_8_lv_c_i - 106.794172415445*v_TR_7_8_lv_c_r
        struct[0].g[48,0] = i_INV_9_a_r - 98.1763901476198*v_INV_9_a_i - 189.48064478264*v_INV_9_a_r + 28.0504724351543*v_INV_9_b_i + 54.1373270807543*v_INV_9_b_r + 28.0504724351542*v_INV_9_c_i + 54.1373270807543*v_INV_9_c_r + 98.1764998873781*v_TR_9_10_lv_a_i + 189.48064478264*v_TR_9_10_lv_a_r - 28.0504285392509*v_TR_9_10_lv_b_i - 54.1373270807543*v_TR_9_10_lv_b_r - 28.0504285392509*v_TR_9_10_lv_c_i - 54.1373270807543*v_TR_9_10_lv_c_r
        struct[0].g[49,0] = i_INV_9_a_i - 189.48064478264*v_INV_9_a_i + 98.1763901476198*v_INV_9_a_r + 54.1373270807543*v_INV_9_b_i - 28.0504724351543*v_INV_9_b_r + 54.1373270807543*v_INV_9_c_i - 28.0504724351542*v_INV_9_c_r + 189.48064478264*v_TR_9_10_lv_a_i - 98.1764998873781*v_TR_9_10_lv_a_r - 54.1373270807543*v_TR_9_10_lv_b_i + 28.0504285392509*v_TR_9_10_lv_b_r - 54.1373270807543*v_TR_9_10_lv_c_i + 28.0504285392509*v_TR_9_10_lv_c_r
        struct[0].g[50,0] = i_INV_9_b_r + 28.0504724351542*v_INV_9_a_i + 54.1373270807543*v_INV_9_a_r - 98.1763901476198*v_INV_9_b_i - 189.48064478264*v_INV_9_b_r + 28.0504724351542*v_INV_9_c_i + 54.1373270807544*v_INV_9_c_r - 28.0504285392509*v_TR_9_10_lv_a_i - 54.1373270807543*v_TR_9_10_lv_a_r + 98.1764998873781*v_TR_9_10_lv_b_i + 189.48064478264*v_TR_9_10_lv_b_r - 28.0504285392509*v_TR_9_10_lv_c_i - 54.1373270807544*v_TR_9_10_lv_c_r
        struct[0].g[51,0] = i_INV_9_b_i + 54.1373270807543*v_INV_9_a_i - 28.0504724351542*v_INV_9_a_r - 189.48064478264*v_INV_9_b_i + 98.1763901476198*v_INV_9_b_r + 54.1373270807544*v_INV_9_c_i - 28.0504724351542*v_INV_9_c_r - 54.1373270807543*v_TR_9_10_lv_a_i + 28.0504285392509*v_TR_9_10_lv_a_r + 189.48064478264*v_TR_9_10_lv_b_i - 98.1764998873781*v_TR_9_10_lv_b_r - 54.1373270807544*v_TR_9_10_lv_c_i + 28.0504285392509*v_TR_9_10_lv_c_r
        struct[0].g[52,0] = i_INV_9_c_r + 28.0504724351543*v_INV_9_a_i + 54.1373270807543*v_INV_9_a_r + 28.0504724351542*v_INV_9_b_i + 54.1373270807543*v_INV_9_b_r - 98.1763901476198*v_INV_9_c_i - 189.48064478264*v_INV_9_c_r - 28.0504285392509*v_TR_9_10_lv_a_i - 54.1373270807543*v_TR_9_10_lv_a_r - 28.0504285392509*v_TR_9_10_lv_b_i - 54.1373270807543*v_TR_9_10_lv_b_r + 98.1764998873781*v_TR_9_10_lv_c_i + 189.48064478264*v_TR_9_10_lv_c_r
        struct[0].g[53,0] = i_INV_9_c_i + 54.1373270807543*v_INV_9_a_i - 28.0504724351543*v_INV_9_a_r + 54.1373270807543*v_INV_9_b_i - 28.0504724351542*v_INV_9_b_r - 189.48064478264*v_INV_9_c_i + 98.1763901476198*v_INV_9_c_r - 54.1373270807543*v_TR_9_10_lv_a_i + 28.0504285392509*v_TR_9_10_lv_a_r - 54.1373270807543*v_TR_9_10_lv_b_i + 28.0504285392509*v_TR_9_10_lv_b_r + 189.48064478264*v_TR_9_10_lv_c_i - 98.1764998873781*v_TR_9_10_lv_c_r
        struct[0].g[54,0] = i_INV_10_a_r - 75.8057696238346*v_INV_10_a_i - 146.305409673982*v_INV_10_a_r + 21.6588887777877*v_INV_10_b_i + 41.8015456211378*v_INV_10_b_r + 21.6588887777877*v_INV_10_c_i + 41.8015456211378*v_INV_10_c_r + 75.8059117481773*v_TR_9_10_lv_a_i + 146.305409673982*v_TR_9_10_lv_a_r - 21.6588319280506*v_TR_9_10_lv_b_i - 41.8015456211378*v_TR_9_10_lv_b_r - 21.6588319280506*v_TR_9_10_lv_c_i - 41.8015456211378*v_TR_9_10_lv_c_r
        struct[0].g[55,0] = i_INV_10_a_i - 146.305409673982*v_INV_10_a_i + 75.8057696238346*v_INV_10_a_r + 41.8015456211378*v_INV_10_b_i - 21.6588887777877*v_INV_10_b_r + 41.8015456211378*v_INV_10_c_i - 21.6588887777877*v_INV_10_c_r + 146.305409673982*v_TR_9_10_lv_a_i - 75.8059117481773*v_TR_9_10_lv_a_r - 41.8015456211378*v_TR_9_10_lv_b_i + 21.6588319280506*v_TR_9_10_lv_b_r - 41.8015456211378*v_TR_9_10_lv_c_i + 21.6588319280506*v_TR_9_10_lv_c_r
        struct[0].g[56,0] = i_INV_10_b_r + 21.6588887777877*v_INV_10_a_i + 41.8015456211377*v_INV_10_a_r - 75.8057696238346*v_INV_10_b_i - 146.305409673982*v_INV_10_b_r + 21.6588887777877*v_INV_10_c_i + 41.8015456211378*v_INV_10_c_r - 21.6588319280506*v_TR_9_10_lv_a_i - 41.8015456211377*v_TR_9_10_lv_a_r + 75.8059117481773*v_TR_9_10_lv_b_i + 146.305409673982*v_TR_9_10_lv_b_r - 21.6588319280506*v_TR_9_10_lv_c_i - 41.8015456211378*v_TR_9_10_lv_c_r
        struct[0].g[57,0] = i_INV_10_b_i + 41.8015456211377*v_INV_10_a_i - 21.6588887777877*v_INV_10_a_r - 146.305409673982*v_INV_10_b_i + 75.8057696238346*v_INV_10_b_r + 41.8015456211378*v_INV_10_c_i - 21.6588887777877*v_INV_10_c_r - 41.8015456211377*v_TR_9_10_lv_a_i + 21.6588319280506*v_TR_9_10_lv_a_r + 146.305409673982*v_TR_9_10_lv_b_i - 75.8059117481773*v_TR_9_10_lv_b_r - 41.8015456211378*v_TR_9_10_lv_c_i + 21.6588319280506*v_TR_9_10_lv_c_r
        struct[0].g[58,0] = i_INV_10_c_r + 21.6588887777877*v_INV_10_a_i + 41.8015456211378*v_INV_10_a_r + 21.6588887777877*v_INV_10_b_i + 41.8015456211378*v_INV_10_b_r - 75.8057696238346*v_INV_10_c_i - 146.305409673982*v_INV_10_c_r - 21.6588319280506*v_TR_9_10_lv_a_i - 41.8015456211378*v_TR_9_10_lv_a_r - 21.6588319280506*v_TR_9_10_lv_b_i - 41.8015456211378*v_TR_9_10_lv_b_r + 75.8059117481773*v_TR_9_10_lv_c_i + 146.305409673982*v_TR_9_10_lv_c_r
        struct[0].g[59,0] = i_INV_10_c_i + 41.8015456211378*v_INV_10_a_i - 21.6588887777877*v_INV_10_a_r + 41.8015456211378*v_INV_10_b_i - 21.6588887777877*v_INV_10_b_r - 146.305409673982*v_INV_10_c_i + 75.8057696238346*v_INV_10_c_r - 41.8015456211378*v_TR_9_10_lv_a_i + 21.6588319280506*v_TR_9_10_lv_a_r - 41.8015456211378*v_TR_9_10_lv_b_i + 21.6588319280506*v_TR_9_10_lv_b_r + 146.305409673982*v_TR_9_10_lv_c_i - 75.8059117481773*v_TR_9_10_lv_c_r
        struct[0].g[60,0] = i_INV_11_a_r - 81.5760299591651*v_INV_11_a_i - 157.441992718694*v_INV_11_a_r + 23.3075276943302*v_INV_11_b_i + 44.9834264910554*v_INV_11_b_r + 23.3075276943302*v_INV_11_c_i + 44.9834264910554*v_INV_11_c_r + 81.5761620304113*v_TR_11_12_lv_a_i + 157.441992718694*v_TR_11_12_lv_a_r - 23.3074748658318*v_TR_11_12_lv_b_i - 44.9834264910554*v_TR_11_12_lv_b_r - 23.3074748658318*v_TR_11_12_lv_c_i - 44.9834264910554*v_TR_11_12_lv_c_r
        struct[0].g[61,0] = i_INV_11_a_i - 157.441992718694*v_INV_11_a_i + 81.5760299591651*v_INV_11_a_r + 44.9834264910554*v_INV_11_b_i - 23.3075276943302*v_INV_11_b_r + 44.9834264910554*v_INV_11_c_i - 23.3075276943302*v_INV_11_c_r + 157.441992718694*v_TR_11_12_lv_a_i - 81.5761620304113*v_TR_11_12_lv_a_r - 44.9834264910554*v_TR_11_12_lv_b_i + 23.3074748658318*v_TR_11_12_lv_b_r - 44.9834264910554*v_TR_11_12_lv_c_i + 23.3074748658318*v_TR_11_12_lv_c_r
        struct[0].g[62,0] = i_INV_11_b_r + 23.3075276943302*v_INV_11_a_i + 44.9834264910554*v_INV_11_a_r - 81.5760299591651*v_INV_11_b_i - 157.441992718694*v_INV_11_b_r + 23.3075276943302*v_INV_11_c_i + 44.9834264910555*v_INV_11_c_r - 23.3074748658318*v_TR_11_12_lv_a_i - 44.9834264910554*v_TR_11_12_lv_a_r + 81.5761620304112*v_TR_11_12_lv_b_i + 157.441992718694*v_TR_11_12_lv_b_r - 23.3074748658317*v_TR_11_12_lv_c_i - 44.9834264910555*v_TR_11_12_lv_c_r
        struct[0].g[63,0] = i_INV_11_b_i + 44.9834264910554*v_INV_11_a_i - 23.3075276943302*v_INV_11_a_r - 157.441992718694*v_INV_11_b_i + 81.5760299591651*v_INV_11_b_r + 44.9834264910555*v_INV_11_c_i - 23.3075276943302*v_INV_11_c_r - 44.9834264910554*v_TR_11_12_lv_a_i + 23.3074748658318*v_TR_11_12_lv_a_r + 157.441992718694*v_TR_11_12_lv_b_i - 81.5761620304112*v_TR_11_12_lv_b_r - 44.9834264910555*v_TR_11_12_lv_c_i + 23.3074748658317*v_TR_11_12_lv_c_r
        struct[0].g[64,0] = i_INV_11_c_r + 23.3075276943302*v_INV_11_a_i + 44.9834264910554*v_INV_11_a_r + 23.3075276943302*v_INV_11_b_i + 44.9834264910554*v_INV_11_b_r - 81.5760299591651*v_INV_11_c_i - 157.441992718694*v_INV_11_c_r - 23.3074748658318*v_TR_11_12_lv_a_i - 44.9834264910554*v_TR_11_12_lv_a_r - 23.3074748658317*v_TR_11_12_lv_b_i - 44.9834264910554*v_TR_11_12_lv_b_r + 81.5761620304112*v_TR_11_12_lv_c_i + 157.441992718694*v_TR_11_12_lv_c_r
        struct[0].g[65,0] = i_INV_11_c_i + 44.9834264910554*v_INV_11_a_i - 23.3075276943302*v_INV_11_a_r + 44.9834264910554*v_INV_11_b_i - 23.3075276943302*v_INV_11_b_r - 157.441992718694*v_INV_11_c_i + 81.5760299591651*v_INV_11_c_r - 44.9834264910554*v_TR_11_12_lv_a_i + 23.3074748658318*v_TR_11_12_lv_a_r - 44.9834264910554*v_TR_11_12_lv_b_i + 23.3074748658317*v_TR_11_12_lv_b_r + 157.441992718694*v_TR_11_12_lv_c_i - 81.5761620304112*v_TR_11_12_lv_c_r
        struct[0].g[66,0] = i_INV_12_a_r - 107.907168174067*v_INV_12_a_i - 208.26102727437*v_INV_12_a_r + 30.8306879425848*v_INV_12_b_i + 59.5031506498201*v_INV_12_b_r + 30.8306879425848*v_INV_12_c_i + 59.5031506498201*v_INV_12_c_r + 107.907268017809*v_TR_11_12_lv_a_i + 208.26102727437*v_TR_11_12_lv_a_r - 30.8306480050881*v_TR_11_12_lv_b_i - 59.5031506498201*v_TR_11_12_lv_b_r - 30.8306480050881*v_TR_11_12_lv_c_i - 59.5031506498201*v_TR_11_12_lv_c_r
        struct[0].g[67,0] = i_INV_12_a_i - 208.26102727437*v_INV_12_a_i + 107.907168174067*v_INV_12_a_r + 59.5031506498201*v_INV_12_b_i - 30.8306879425848*v_INV_12_b_r + 59.5031506498201*v_INV_12_c_i - 30.8306879425848*v_INV_12_c_r + 208.26102727437*v_TR_11_12_lv_a_i - 107.907268017809*v_TR_11_12_lv_a_r - 59.5031506498201*v_TR_11_12_lv_b_i + 30.8306480050881*v_TR_11_12_lv_b_r - 59.5031506498201*v_TR_11_12_lv_c_i + 30.8306480050881*v_TR_11_12_lv_c_r
        struct[0].g[68,0] = i_INV_12_b_r + 30.8306879425848*v_INV_12_a_i + 59.5031506498201*v_INV_12_a_r - 107.907168174067*v_INV_12_b_i - 208.261027274371*v_INV_12_b_r + 30.8306879425847*v_INV_12_c_i + 59.5031506498202*v_INV_12_c_r - 30.8306480050881*v_TR_11_12_lv_a_i - 59.5031506498201*v_TR_11_12_lv_a_r + 107.907268017808*v_TR_11_12_lv_b_i + 208.261027274371*v_TR_11_12_lv_b_r - 30.8306480050881*v_TR_11_12_lv_c_i - 59.5031506498202*v_TR_11_12_lv_c_r
        struct[0].g[69,0] = i_INV_12_b_i + 59.5031506498201*v_INV_12_a_i - 30.8306879425848*v_INV_12_a_r - 208.261027274371*v_INV_12_b_i + 107.907168174067*v_INV_12_b_r + 59.5031506498202*v_INV_12_c_i - 30.8306879425847*v_INV_12_c_r - 59.5031506498201*v_TR_11_12_lv_a_i + 30.8306480050881*v_TR_11_12_lv_a_r + 208.261027274371*v_TR_11_12_lv_b_i - 107.907268017808*v_TR_11_12_lv_b_r - 59.5031506498202*v_TR_11_12_lv_c_i + 30.8306480050881*v_TR_11_12_lv_c_r
        struct[0].g[70,0] = i_INV_12_c_r + 30.8306879425848*v_INV_12_a_i + 59.5031506498201*v_INV_12_a_r + 30.8306879425847*v_INV_12_b_i + 59.5031506498202*v_INV_12_b_r - 107.907168174067*v_INV_12_c_i - 208.261027274371*v_INV_12_c_r - 30.8306480050882*v_TR_11_12_lv_a_i - 59.5031506498201*v_TR_11_12_lv_a_r - 30.8306480050881*v_TR_11_12_lv_b_i - 59.5031506498202*v_TR_11_12_lv_b_r + 107.907268017808*v_TR_11_12_lv_c_i + 208.261027274371*v_TR_11_12_lv_c_r
        struct[0].g[71,0] = i_INV_12_c_i + 59.5031506498201*v_INV_12_a_i - 30.8306879425848*v_INV_12_a_r + 59.5031506498202*v_INV_12_b_i - 30.8306879425847*v_INV_12_b_r - 208.261027274371*v_INV_12_c_i + 107.907168174067*v_INV_12_c_r - 59.5031506498201*v_TR_11_12_lv_a_i + 30.8306480050882*v_TR_11_12_lv_a_r - 59.5031506498202*v_TR_11_12_lv_b_i + 30.8306480050881*v_TR_11_12_lv_b_r + 208.261027274371*v_TR_11_12_lv_c_i - 107.907268017808*v_TR_11_12_lv_c_r
        struct[0].g[72,0] = i_INV_13_a_r - 225.77493151679*v_INV_13_a_i - 435.745709926008*v_INV_13_a_r + 64.5071560124429*v_INV_13_b_i + 124.498774264574*v_INV_13_b_r + 64.5071560124428*v_INV_13_c_i + 124.498774264574*v_INV_13_c_r + 225.774979236273*v_TR_13_lv_a_i + 435.745709926008*v_TR_13_lv_a_r - 64.5071369246495*v_TR_13_lv_b_i - 124.498774264574*v_TR_13_lv_b_r - 64.5071369246495*v_TR_13_lv_c_i - 124.498774264574*v_TR_13_lv_c_r
        struct[0].g[73,0] = i_INV_13_a_i - 435.745709926008*v_INV_13_a_i + 225.77493151679*v_INV_13_a_r + 124.498774264574*v_INV_13_b_i - 64.5071560124429*v_INV_13_b_r + 124.498774264574*v_INV_13_c_i - 64.5071560124428*v_INV_13_c_r + 435.745709926008*v_TR_13_lv_a_i - 225.774979236273*v_TR_13_lv_a_r - 124.498774264574*v_TR_13_lv_b_i + 64.5071369246495*v_TR_13_lv_b_r - 124.498774264574*v_TR_13_lv_c_i + 64.5071369246495*v_TR_13_lv_c_r
        struct[0].g[74,0] = i_INV_13_b_r + 64.5071560124428*v_INV_13_a_i + 124.498774264574*v_INV_13_a_r - 225.77493151679*v_INV_13_b_i - 435.745709926008*v_INV_13_b_r + 64.5071560124428*v_INV_13_c_i + 124.498774264574*v_INV_13_c_r - 64.5071369246495*v_TR_13_lv_a_i - 124.498774264574*v_TR_13_lv_a_r + 225.774979236273*v_TR_13_lv_b_i + 435.745709926008*v_TR_13_lv_b_r - 64.5071369246494*v_TR_13_lv_c_i - 124.498774264574*v_TR_13_lv_c_r
        struct[0].g[75,0] = i_INV_13_b_i + 124.498774264574*v_INV_13_a_i - 64.5071560124428*v_INV_13_a_r - 435.745709926008*v_INV_13_b_i + 225.77493151679*v_INV_13_b_r + 124.498774264574*v_INV_13_c_i - 64.5071560124428*v_INV_13_c_r - 124.498774264574*v_TR_13_lv_a_i + 64.5071369246495*v_TR_13_lv_a_r + 435.745709926008*v_TR_13_lv_b_i - 225.774979236273*v_TR_13_lv_b_r - 124.498774264574*v_TR_13_lv_c_i + 64.5071369246494*v_TR_13_lv_c_r
        struct[0].g[76,0] = i_INV_13_c_r + 64.5071560124429*v_INV_13_a_i + 124.498774264574*v_INV_13_a_r + 64.5071560124428*v_INV_13_b_i + 124.498774264574*v_INV_13_b_r - 225.77493151679*v_INV_13_c_i - 435.745709926008*v_INV_13_c_r - 64.5071369246495*v_TR_13_lv_a_i - 124.498774264574*v_TR_13_lv_a_r - 64.5071369246494*v_TR_13_lv_b_i - 124.498774264574*v_TR_13_lv_b_r + 225.774979236273*v_TR_13_lv_c_i + 435.745709926008*v_TR_13_lv_c_r
        struct[0].g[77,0] = i_INV_13_c_i + 124.498774264574*v_INV_13_a_i - 64.5071560124429*v_INV_13_a_r + 124.498774264574*v_INV_13_b_i - 64.5071560124428*v_INV_13_b_r - 435.745709926008*v_INV_13_c_i + 225.77493151679*v_INV_13_c_r - 124.498774264574*v_TR_13_lv_a_i + 64.5071369246495*v_TR_13_lv_a_r - 124.498774264574*v_TR_13_lv_b_i + 64.5071369246494*v_TR_13_lv_b_r + 435.745709926008*v_TR_13_lv_c_i - 225.774979236273*v_TR_13_lv_c_r
        struct[0].g[78,0] = i_POIhv_a_r + 0.040290088638195*v_GRID_a_i + 0.024174053182917*v_GRID_a_r + 4.66248501556824e-18*v_GRID_b_i - 4.31760362252812e-18*v_GRID_b_r + 4.19816664496737e-18*v_GRID_c_i - 3.49608108880335e-18*v_GRID_c_r - 0.0647773858527649*v_POIhv_a_i - 0.0272349653347382*v_POIhv_a_r + 0.012243648607285*v_POIhv_b_i + 0.00153045607591063*v_POIhv_b_r + 0.012243648607285*v_POIhv_c_i + 0.00153045607591062*v_POIhv_c_r + 0.0699818508108637*v_POImv_a_i + 0.00874773135135797*v_POImv_a_r - 0.0699818508108637*v_POImv_b_i - 0.00874773135135797*v_POImv_b_r
        struct[0].g[79,0] = i_POIhv_a_i + 0.024174053182917*v_GRID_a_i - 0.040290088638195*v_GRID_a_r - 4.31760362252812e-18*v_GRID_b_i - 4.66248501556824e-18*v_GRID_b_r - 3.49608108880335e-18*v_GRID_c_i - 4.19816664496737e-18*v_GRID_c_r - 0.0272349653347382*v_POIhv_a_i + 0.0647773858527649*v_POIhv_a_r + 0.00153045607591063*v_POIhv_b_i - 0.012243648607285*v_POIhv_b_r + 0.00153045607591062*v_POIhv_c_i - 0.012243648607285*v_POIhv_c_r + 0.00874773135135797*v_POImv_a_i - 0.0699818508108637*v_POImv_a_r - 0.00874773135135797*v_POImv_b_i + 0.0699818508108637*v_POImv_b_r
        struct[0].g[80,0] = i_POIhv_b_r + 6.30775359573304e-19*v_GRID_a_i - 2.07254761002657e-18*v_GRID_a_r + 0.040290088638195*v_GRID_b_i + 0.024174053182917*v_GRID_b_r + 9.01107656533306e-19*v_GRID_c_i - 1.78419315993592e-17*v_GRID_c_r + 0.012243648607285*v_POIhv_a_i + 0.00153045607591062*v_POIhv_a_r - 0.0647773858527649*v_POIhv_b_i - 0.0272349653347383*v_POIhv_b_r + 0.012243648607285*v_POIhv_c_i + 0.00153045607591064*v_POIhv_c_r + 0.0699818508108637*v_POImv_b_i + 0.00874773135135797*v_POImv_b_r - 0.0699818508108637*v_POImv_c_i - 0.00874773135135797*v_POImv_c_r
        struct[0].g[81,0] = i_POIhv_b_i - 2.07254761002657e-18*v_GRID_a_i - 6.30775359573304e-19*v_GRID_a_r + 0.024174053182917*v_GRID_b_i - 0.040290088638195*v_GRID_b_r - 1.78419315993592e-17*v_GRID_c_i - 9.01107656533306e-19*v_GRID_c_r + 0.00153045607591062*v_POIhv_a_i - 0.012243648607285*v_POIhv_a_r - 0.0272349653347383*v_POIhv_b_i + 0.0647773858527649*v_POIhv_b_r + 0.00153045607591064*v_POIhv_c_i - 0.012243648607285*v_POIhv_c_r + 0.00874773135135797*v_POImv_b_i - 0.0699818508108637*v_POImv_b_r - 0.00874773135135797*v_POImv_c_i + 0.0699818508108637*v_POImv_c_r
        struct[0].g[82,0] = i_POIhv_c_r - 7.20886125226632e-19*v_GRID_a_i - 1.35166148479994e-18*v_GRID_a_r - 4.50553828266631e-19*v_GRID_b_i - 1.71210454741325e-17*v_GRID_b_r + 0.040290088638195*v_GRID_c_i + 0.024174053182917*v_GRID_c_r + 0.012243648607285*v_POIhv_a_i + 0.00153045607591062*v_POIhv_a_r + 0.012243648607285*v_POIhv_b_i + 0.00153045607591064*v_POIhv_b_r - 0.0647773858527649*v_POIhv_c_i - 0.0272349653347383*v_POIhv_c_r - 0.0699818508108637*v_POImv_a_i - 0.00874773135135797*v_POImv_a_r + 0.0699818508108637*v_POImv_c_i + 0.00874773135135797*v_POImv_c_r
        struct[0].g[83,0] = i_POIhv_c_i - 1.35166148479994e-18*v_GRID_a_i + 7.20886125226632e-19*v_GRID_a_r - 1.71210454741325e-17*v_GRID_b_i + 4.50553828266631e-19*v_GRID_b_r + 0.024174053182917*v_GRID_c_i - 0.040290088638195*v_GRID_c_r + 0.00153045607591062*v_POIhv_a_i - 0.012243648607285*v_POIhv_a_r + 0.00153045607591064*v_POIhv_b_i - 0.012243648607285*v_POIhv_b_r - 0.0272349653347383*v_POIhv_c_i + 0.0647773858527649*v_POIhv_c_r - 0.00874773135135797*v_POImv_a_i + 0.0699818508108637*v_POImv_a_r + 0.00874773135135797*v_POImv_c_i - 0.0699818508108637*v_POImv_c_r
        struct[0].g[84,0] = i_POImv_a_r + 0.0699818508108637*v_POIhv_a_i + 0.00874773135135797*v_POIhv_a_r - 0.0699818508108637*v_POIhv_c_i - 0.00874773135135797*v_POIhv_c_r - 33.4156859296188*v_POImv_a_i - 24.8222322123875*v_POImv_a_r + 9.4330989270973*v_POImv_b_i + 7.0643874892536*v_POImv_b_r + 9.4330989270973*v_POImv_c_i + 7.0643874892536*v_POImv_c_r + 24.3777365097524*v_TR_1_2_mv_a_i + 18.2833023823143*v_TR_1_2_mv_a_r - 6.96506757421497*v_TR_1_2_mv_b_i - 5.22380068066123*v_TR_1_2_mv_b_r - 6.96506757421497*v_TR_1_2_mv_c_i - 5.22380068066123*v_TR_1_2_mv_c_r + 8.63801621787545*v_TR_5_6_mv_a_i + 6.47851216340659*v_TR_5_6_mv_a_r - 2.4680046336787*v_TR_5_6_mv_b_i - 1.85100347525903*v_TR_5_6_mv_b_r - 2.4680046336787*v_TR_5_6_mv_c_i - 1.85100347525903*v_TR_5_6_mv_c_r
        struct[0].g[85,0] = i_POImv_a_i + 0.00874773135135797*v_POIhv_a_i - 0.0699818508108637*v_POIhv_a_r - 0.00874773135135797*v_POIhv_c_i + 0.0699818508108637*v_POIhv_c_r - 24.8222322123875*v_POImv_a_i + 33.4156859296188*v_POImv_a_r + 7.0643874892536*v_POImv_b_i - 9.4330989270973*v_POImv_b_r + 7.0643874892536*v_POImv_c_i - 9.4330989270973*v_POImv_c_r + 18.2833023823143*v_TR_1_2_mv_a_i - 24.3777365097524*v_TR_1_2_mv_a_r - 5.22380068066123*v_TR_1_2_mv_b_i + 6.96506757421497*v_TR_1_2_mv_b_r - 5.22380068066123*v_TR_1_2_mv_c_i + 6.96506757421497*v_TR_1_2_mv_c_r + 6.47851216340659*v_TR_5_6_mv_a_i - 8.63801621787545*v_TR_5_6_mv_a_r - 1.85100347525903*v_TR_5_6_mv_b_i + 2.4680046336787*v_TR_5_6_mv_b_r - 1.85100347525903*v_TR_5_6_mv_c_i + 2.4680046336787*v_TR_5_6_mv_c_r
        struct[0].g[86,0] = i_POImv_b_r - 0.0699818508108637*v_POIhv_a_i - 0.00874773135135797*v_POIhv_a_r + 0.0699818508108637*v_POIhv_b_i + 0.00874773135135797*v_POIhv_b_r + 9.4330989270973*v_POImv_a_i + 7.0643874892536*v_POImv_a_r - 33.4156859296188*v_POImv_b_i - 24.8222322123876*v_POImv_b_r + 9.4330989270973*v_POImv_c_i + 7.06438748925361*v_POImv_c_r - 6.96506757421497*v_TR_1_2_mv_a_i - 5.22380068066123*v_TR_1_2_mv_a_r + 24.3777365097524*v_TR_1_2_mv_b_i + 18.2833023823143*v_TR_1_2_mv_b_r - 6.96506757421497*v_TR_1_2_mv_c_i - 5.22380068066124*v_TR_1_2_mv_c_r - 2.4680046336787*v_TR_5_6_mv_a_i - 1.85100347525903*v_TR_5_6_mv_a_r + 8.63801621787545*v_TR_5_6_mv_b_i + 6.47851216340659*v_TR_5_6_mv_b_r - 2.4680046336787*v_TR_5_6_mv_c_i - 1.85100347525903*v_TR_5_6_mv_c_r
        struct[0].g[87,0] = i_POImv_b_i - 0.00874773135135797*v_POIhv_a_i + 0.0699818508108637*v_POIhv_a_r + 0.00874773135135797*v_POIhv_b_i - 0.0699818508108637*v_POIhv_b_r + 7.0643874892536*v_POImv_a_i - 9.4330989270973*v_POImv_a_r - 24.8222322123876*v_POImv_b_i + 33.4156859296188*v_POImv_b_r + 7.06438748925361*v_POImv_c_i - 9.4330989270973*v_POImv_c_r - 5.22380068066123*v_TR_1_2_mv_a_i + 6.96506757421497*v_TR_1_2_mv_a_r + 18.2833023823143*v_TR_1_2_mv_b_i - 24.3777365097524*v_TR_1_2_mv_b_r - 5.22380068066124*v_TR_1_2_mv_c_i + 6.96506757421497*v_TR_1_2_mv_c_r - 1.85100347525903*v_TR_5_6_mv_a_i + 2.4680046336787*v_TR_5_6_mv_a_r + 6.47851216340659*v_TR_5_6_mv_b_i - 8.63801621787545*v_TR_5_6_mv_b_r - 1.85100347525903*v_TR_5_6_mv_c_i + 2.4680046336787*v_TR_5_6_mv_c_r
        struct[0].g[88,0] = i_POImv_c_r - 0.0699818508108637*v_POIhv_b_i - 0.00874773135135797*v_POIhv_b_r + 0.0699818508108637*v_POIhv_c_i + 0.00874773135135797*v_POIhv_c_r + 9.4330989270973*v_POImv_a_i + 7.06438748925359*v_POImv_a_r + 9.4330989270973*v_POImv_b_i + 7.06438748925361*v_POImv_b_r - 33.4156859296188*v_POImv_c_i - 24.8222322123876*v_POImv_c_r - 6.96506757421497*v_TR_1_2_mv_a_i - 5.22380068066123*v_TR_1_2_mv_a_r - 6.96506757421497*v_TR_1_2_mv_b_i - 5.22380068066124*v_TR_1_2_mv_b_r + 24.3777365097524*v_TR_1_2_mv_c_i + 18.2833023823143*v_TR_1_2_mv_c_r - 2.4680046336787*v_TR_5_6_mv_a_i - 1.85100347525903*v_TR_5_6_mv_a_r - 2.4680046336787*v_TR_5_6_mv_b_i - 1.85100347525903*v_TR_5_6_mv_b_r + 8.63801621787545*v_TR_5_6_mv_c_i + 6.47851216340659*v_TR_5_6_mv_c_r
        struct[0].g[89,0] = i_POImv_c_i - 0.00874773135135797*v_POIhv_b_i + 0.0699818508108637*v_POIhv_b_r + 0.00874773135135797*v_POIhv_c_i - 0.0699818508108637*v_POIhv_c_r + 7.06438748925359*v_POImv_a_i - 9.4330989270973*v_POImv_a_r + 7.06438748925361*v_POImv_b_i - 9.4330989270973*v_POImv_b_r - 24.8222322123876*v_POImv_c_i + 33.4156859296188*v_POImv_c_r - 5.22380068066123*v_TR_1_2_mv_a_i + 6.96506757421497*v_TR_1_2_mv_a_r - 5.22380068066124*v_TR_1_2_mv_b_i + 6.96506757421497*v_TR_1_2_mv_b_r + 18.2833023823143*v_TR_1_2_mv_c_i - 24.3777365097524*v_TR_1_2_mv_c_r - 1.85100347525903*v_TR_5_6_mv_a_i + 2.4680046336787*v_TR_5_6_mv_a_r - 1.85100347525903*v_TR_5_6_mv_b_i + 2.4680046336787*v_TR_5_6_mv_b_r + 6.47851216340659*v_TR_5_6_mv_c_i - 8.63801621787545*v_TR_5_6_mv_c_r
        struct[0].g[90,0] = i_TR_1_2_mv_a_r + 24.3777365097524*v_POImv_a_i + 18.2833023823143*v_POImv_a_r - 6.96506757421497*v_POImv_b_i - 5.22380068066123*v_POImv_b_r - 6.96506757421497*v_POImv_c_i - 5.22380068066123*v_POImv_c_r + 2.3406091994174*v_TR_1_2_lv_a_i + 0.390101533236234*v_TR_1_2_lv_a_r - 2.3406091994174*v_TR_1_2_lv_b_i - 0.390101533236234*v_TR_1_2_lv_b_r - 52.7347843860809*v_TR_1_2_mv_a_i - 39.5195811550486*v_TR_1_2_mv_a_r + 15.0786865705954*v_TR_1_2_mv_b_i + 11.293239403373*v_TR_1_2_mv_b_r + 15.0786865705954*v_TR_1_2_mv_c_i + 11.293239403373*v_TR_1_2_mv_c_r + 28.3030263516338*v_TR_3_4_mv_a_i + 21.2272697637253*v_TR_3_4_mv_a_r - 8.08657895760964*v_TR_3_4_mv_b_i - 6.06493421820724*v_TR_3_4_mv_b_r - 8.08657895760964*v_TR_3_4_mv_c_i - 6.06493421820724*v_TR_3_4_mv_c_r
        struct[0].g[91,0] = i_TR_1_2_mv_a_i + 18.2833023823143*v_POImv_a_i - 24.3777365097524*v_POImv_a_r - 5.22380068066123*v_POImv_b_i + 6.96506757421497*v_POImv_b_r - 5.22380068066123*v_POImv_c_i + 6.96506757421497*v_POImv_c_r + 0.390101533236234*v_TR_1_2_lv_a_i - 2.3406091994174*v_TR_1_2_lv_a_r - 0.390101533236234*v_TR_1_2_lv_b_i + 2.3406091994174*v_TR_1_2_lv_b_r - 39.5195811550486*v_TR_1_2_mv_a_i + 52.7347843860809*v_TR_1_2_mv_a_r + 11.293239403373*v_TR_1_2_mv_b_i - 15.0786865705954*v_TR_1_2_mv_b_r + 11.293239403373*v_TR_1_2_mv_c_i - 15.0786865705954*v_TR_1_2_mv_c_r + 21.2272697637253*v_TR_3_4_mv_a_i - 28.3030263516338*v_TR_3_4_mv_a_r - 6.06493421820724*v_TR_3_4_mv_b_i + 8.08657895760964*v_TR_3_4_mv_b_r - 6.06493421820724*v_TR_3_4_mv_c_i + 8.08657895760964*v_TR_3_4_mv_c_r
        struct[0].g[92,0] = i_TR_1_2_mv_b_r - 6.96506757421497*v_POImv_a_i - 5.22380068066123*v_POImv_a_r + 24.3777365097524*v_POImv_b_i + 18.2833023823143*v_POImv_b_r - 6.96506757421497*v_POImv_c_i - 5.22380068066124*v_POImv_c_r + 2.3406091994174*v_TR_1_2_lv_b_i + 0.390101533236234*v_TR_1_2_lv_b_r - 2.3406091994174*v_TR_1_2_lv_c_i - 0.390101533236234*v_TR_1_2_lv_c_r + 15.0786865705954*v_TR_1_2_mv_a_i + 11.293239403373*v_TR_1_2_mv_a_r - 52.7347843860809*v_TR_1_2_mv_b_i - 39.5195811550487*v_TR_1_2_mv_b_r + 15.0786865705954*v_TR_1_2_mv_c_i + 11.293239403373*v_TR_1_2_mv_c_r - 8.08657895760964*v_TR_3_4_mv_a_i - 6.06493421820724*v_TR_3_4_mv_a_r + 28.3030263516338*v_TR_3_4_mv_b_i + 21.2272697637253*v_TR_3_4_mv_b_r - 8.08657895760965*v_TR_3_4_mv_c_i - 6.06493421820725*v_TR_3_4_mv_c_r
        struct[0].g[93,0] = i_TR_1_2_mv_b_i - 5.22380068066123*v_POImv_a_i + 6.96506757421497*v_POImv_a_r + 18.2833023823143*v_POImv_b_i - 24.3777365097524*v_POImv_b_r - 5.22380068066124*v_POImv_c_i + 6.96506757421497*v_POImv_c_r + 0.390101533236234*v_TR_1_2_lv_b_i - 2.3406091994174*v_TR_1_2_lv_b_r - 0.390101533236234*v_TR_1_2_lv_c_i + 2.3406091994174*v_TR_1_2_lv_c_r + 11.293239403373*v_TR_1_2_mv_a_i - 15.0786865705954*v_TR_1_2_mv_a_r - 39.5195811550487*v_TR_1_2_mv_b_i + 52.7347843860809*v_TR_1_2_mv_b_r + 11.293239403373*v_TR_1_2_mv_c_i - 15.0786865705954*v_TR_1_2_mv_c_r - 6.06493421820724*v_TR_3_4_mv_a_i + 8.08657895760964*v_TR_3_4_mv_a_r + 21.2272697637253*v_TR_3_4_mv_b_i - 28.3030263516338*v_TR_3_4_mv_b_r - 6.06493421820725*v_TR_3_4_mv_c_i + 8.08657895760965*v_TR_3_4_mv_c_r
        struct[0].g[94,0] = i_TR_1_2_mv_c_r - 6.96506757421497*v_POImv_a_i - 5.22380068066123*v_POImv_a_r - 6.96506757421497*v_POImv_b_i - 5.22380068066124*v_POImv_b_r + 24.3777365097524*v_POImv_c_i + 18.2833023823143*v_POImv_c_r - 2.3406091994174*v_TR_1_2_lv_a_i - 0.390101533236234*v_TR_1_2_lv_a_r + 2.3406091994174*v_TR_1_2_lv_c_i + 0.390101533236234*v_TR_1_2_lv_c_r + 15.0786865705954*v_TR_1_2_mv_a_i + 11.293239403373*v_TR_1_2_mv_a_r + 15.0786865705954*v_TR_1_2_mv_b_i + 11.293239403373*v_TR_1_2_mv_b_r - 52.7347843860809*v_TR_1_2_mv_c_i - 39.5195811550487*v_TR_1_2_mv_c_r - 8.08657895760965*v_TR_3_4_mv_a_i - 6.06493421820724*v_TR_3_4_mv_a_r - 8.08657895760964*v_TR_3_4_mv_b_i - 6.06493421820725*v_TR_3_4_mv_b_r + 28.3030263516338*v_TR_3_4_mv_c_i + 21.2272697637253*v_TR_3_4_mv_c_r
        struct[0].g[95,0] = i_TR_1_2_mv_c_i - 5.22380068066123*v_POImv_a_i + 6.96506757421497*v_POImv_a_r - 5.22380068066124*v_POImv_b_i + 6.96506757421497*v_POImv_b_r + 18.2833023823143*v_POImv_c_i - 24.3777365097524*v_POImv_c_r - 0.390101533236234*v_TR_1_2_lv_a_i + 2.3406091994174*v_TR_1_2_lv_a_r + 0.390101533236234*v_TR_1_2_lv_c_i - 2.3406091994174*v_TR_1_2_lv_c_r + 11.293239403373*v_TR_1_2_mv_a_i - 15.0786865705954*v_TR_1_2_mv_a_r + 11.293239403373*v_TR_1_2_mv_b_i - 15.0786865705954*v_TR_1_2_mv_b_r - 39.5195811550487*v_TR_1_2_mv_c_i + 52.7347843860809*v_TR_1_2_mv_c_r - 6.06493421820724*v_TR_3_4_mv_a_i + 8.08657895760965*v_TR_3_4_mv_a_r - 6.06493421820725*v_TR_3_4_mv_b_i + 8.08657895760964*v_TR_3_4_mv_b_r + 21.2272697637253*v_TR_3_4_mv_c_i - 28.3030263516338*v_TR_3_4_mv_c_r
        struct[0].g[96,0] = i_TR_1_2_lv_a_r + 89.5460683028705*v_INV_1_a_i + 172.82391182454*v_INV_1_a_r - 25.5845909436773*v_INV_1_b_i - 49.3782605212972*v_INV_1_b_r - 25.5845909436773*v_INV_1_c_i - 49.3782605212972*v_INV_1_c_r + 97.8438762251349*v_INV_2_a_i + 188.83868111451*v_INV_2_a_r - 27.9553932071814*v_INV_2_b_i - 53.9539088898601*v_INV_2_b_r - 27.9553932071814*v_INV_2_c_i - 53.9539088898601*v_INV_2_c_r - 390.092416801432*v_TR_1_2_lv_a_i - 395.446376722834*v_TR_1_2_lv_a_r + 53.5400763225691*v_TR_1_2_lv_b_i + 103.332169411157*v_TR_1_2_lv_b_r + 53.5400763225691*v_TR_1_2_lv_c_i + 103.332169411157*v_TR_1_2_lv_c_r + 2.3406091994174*v_TR_1_2_mv_a_i + 0.390101533236234*v_TR_1_2_mv_a_r - 2.3406091994174*v_TR_1_2_mv_c_i - 0.390101533236234*v_TR_1_2_mv_c_r
        struct[0].g[97,0] = i_TR_1_2_lv_a_i + 172.82391182454*v_INV_1_a_i - 89.5460683028705*v_INV_1_a_r - 49.3782605212972*v_INV_1_b_i + 25.5845909436773*v_INV_1_b_r - 49.3782605212972*v_INV_1_c_i + 25.5845909436773*v_INV_1_c_r + 188.83868111451*v_INV_2_a_i - 97.8438762251349*v_INV_2_a_r - 53.9539088898601*v_INV_2_b_i + 27.9553932071814*v_INV_2_b_r - 53.9539088898601*v_INV_2_c_i + 27.9553932071814*v_INV_2_c_r - 395.446376722834*v_TR_1_2_lv_a_i + 390.092416801432*v_TR_1_2_lv_a_r + 103.332169411157*v_TR_1_2_lv_b_i - 53.5400763225691*v_TR_1_2_lv_b_r + 103.332169411157*v_TR_1_2_lv_c_i - 53.5400763225691*v_TR_1_2_lv_c_r + 0.390101533236234*v_TR_1_2_mv_a_i - 2.3406091994174*v_TR_1_2_mv_a_r - 0.390101533236234*v_TR_1_2_mv_c_i + 2.3406091994174*v_TR_1_2_mv_c_r
        struct[0].g[98,0] = i_TR_1_2_lv_b_r - 25.5845909436773*v_INV_1_a_i - 49.3782605212972*v_INV_1_a_r + 89.5460683028705*v_INV_1_b_i + 172.82391182454*v_INV_1_b_r - 25.5845909436773*v_INV_1_c_i - 49.3782605212973*v_INV_1_c_r - 27.9553932071814*v_INV_2_a_i - 53.9539088898601*v_INV_2_a_r + 97.8438762251349*v_INV_2_b_i + 188.83868111451*v_INV_2_b_r - 27.9553932071814*v_INV_2_c_i - 53.9539088898602*v_INV_2_c_r + 53.5400763225691*v_TR_1_2_lv_a_i + 103.332169411157*v_TR_1_2_lv_a_r - 390.092416801432*v_TR_1_2_lv_b_i - 395.446376722835*v_TR_1_2_lv_b_r + 53.5400763225691*v_TR_1_2_lv_c_i + 103.332169411157*v_TR_1_2_lv_c_r - 2.3406091994174*v_TR_1_2_mv_a_i - 0.390101533236234*v_TR_1_2_mv_a_r + 2.3406091994174*v_TR_1_2_mv_b_i + 0.390101533236234*v_TR_1_2_mv_b_r
        struct[0].g[99,0] = i_TR_1_2_lv_b_i - 49.3782605212972*v_INV_1_a_i + 25.5845909436773*v_INV_1_a_r + 172.82391182454*v_INV_1_b_i - 89.5460683028705*v_INV_1_b_r - 49.3782605212973*v_INV_1_c_i + 25.5845909436773*v_INV_1_c_r - 53.9539088898601*v_INV_2_a_i + 27.9553932071814*v_INV_2_a_r + 188.83868111451*v_INV_2_b_i - 97.8438762251349*v_INV_2_b_r - 53.9539088898602*v_INV_2_c_i + 27.9553932071814*v_INV_2_c_r + 103.332169411157*v_TR_1_2_lv_a_i - 53.5400763225691*v_TR_1_2_lv_a_r - 395.446376722835*v_TR_1_2_lv_b_i + 390.092416801432*v_TR_1_2_lv_b_r + 103.332169411157*v_TR_1_2_lv_c_i - 53.5400763225691*v_TR_1_2_lv_c_r - 0.390101533236234*v_TR_1_2_mv_a_i + 2.3406091994174*v_TR_1_2_mv_a_r + 0.390101533236234*v_TR_1_2_mv_b_i - 2.3406091994174*v_TR_1_2_mv_b_r
        struct[0].g[100,0] = i_TR_1_2_lv_c_r - 25.5845909436773*v_INV_1_a_i - 49.3782605212972*v_INV_1_a_r - 25.5845909436772*v_INV_1_b_i - 49.3782605212973*v_INV_1_b_r + 89.5460683028705*v_INV_1_c_i + 172.82391182454*v_INV_1_c_r - 27.9553932071814*v_INV_2_a_i - 53.9539088898601*v_INV_2_a_r - 27.9553932071813*v_INV_2_b_i - 53.9539088898602*v_INV_2_b_r + 97.8438762251349*v_INV_2_c_i + 188.83868111451*v_INV_2_c_r + 53.5400763225692*v_TR_1_2_lv_a_i + 103.332169411157*v_TR_1_2_lv_a_r + 53.5400763225691*v_TR_1_2_lv_b_i + 103.332169411157*v_TR_1_2_lv_b_r - 390.092416801432*v_TR_1_2_lv_c_i - 395.446376722835*v_TR_1_2_lv_c_r - 2.3406091994174*v_TR_1_2_mv_b_i - 0.390101533236234*v_TR_1_2_mv_b_r + 2.3406091994174*v_TR_1_2_mv_c_i + 0.390101533236234*v_TR_1_2_mv_c_r
        struct[0].g[101,0] = i_TR_1_2_lv_c_i - 49.3782605212972*v_INV_1_a_i + 25.5845909436773*v_INV_1_a_r - 49.3782605212973*v_INV_1_b_i + 25.5845909436772*v_INV_1_b_r + 172.82391182454*v_INV_1_c_i - 89.5460683028705*v_INV_1_c_r - 53.9539088898601*v_INV_2_a_i + 27.9553932071814*v_INV_2_a_r - 53.9539088898602*v_INV_2_b_i + 27.9553932071813*v_INV_2_b_r + 188.83868111451*v_INV_2_c_i - 97.8438762251349*v_INV_2_c_r + 103.332169411157*v_TR_1_2_lv_a_i - 53.5400763225692*v_TR_1_2_lv_a_r + 103.332169411157*v_TR_1_2_lv_b_i - 53.5400763225691*v_TR_1_2_lv_b_r - 395.446376722835*v_TR_1_2_lv_c_i + 390.092416801432*v_TR_1_2_lv_c_r - 0.390101533236234*v_TR_1_2_mv_b_i + 2.3406091994174*v_TR_1_2_mv_b_r + 0.390101533236234*v_TR_1_2_mv_c_i - 2.3406091994174*v_TR_1_2_mv_c_r
        struct[0].g[102,0] = i_TR_3_4_mv_a_r + 28.3030263516338*v_TR_1_2_mv_a_i + 21.2272697637253*v_TR_1_2_mv_a_r - 8.08657895760964*v_TR_1_2_mv_b_i - 6.06493421820724*v_TR_1_2_mv_b_r - 8.08657895760964*v_TR_1_2_mv_c_i - 6.06493421820724*v_TR_1_2_mv_c_r + 2.3406091994174*v_TR_3_4_lv_a_i + 0.390101533236234*v_TR_3_4_lv_a_r - 2.3406091994174*v_TR_3_4_lv_b_i - 0.390101533236234*v_TR_3_4_lv_b_r - 43.3991164322381*v_TR_3_4_mv_a_i - 41.678054303702*v_TR_3_4_mv_a_r + 12.4113478527151*v_TR_3_4_mv_b_i + 11.9099460172739*v_TR_3_4_mv_b_r + 12.4113478527151*v_TR_3_4_mv_c_i + 11.9099460172739*v_TR_3_4_mv_c_r + 15.0420612397687*v_TR_7_8_mv_a_i + 20.4417755309677*v_TR_7_8_mv_a_r - 4.29773178279105*v_TR_7_8_mv_b_i - 5.8405072945622*v_TR_7_8_mv_b_r - 4.29773178279104*v_TR_7_8_mv_c_i - 5.84050729456219*v_TR_7_8_mv_c_r
        struct[0].g[103,0] = i_TR_3_4_mv_a_i + 21.2272697637253*v_TR_1_2_mv_a_i - 28.3030263516338*v_TR_1_2_mv_a_r - 6.06493421820724*v_TR_1_2_mv_b_i + 8.08657895760964*v_TR_1_2_mv_b_r - 6.06493421820724*v_TR_1_2_mv_c_i + 8.08657895760964*v_TR_1_2_mv_c_r + 0.390101533236234*v_TR_3_4_lv_a_i - 2.3406091994174*v_TR_3_4_lv_a_r - 0.390101533236234*v_TR_3_4_lv_b_i + 2.3406091994174*v_TR_3_4_lv_b_r - 41.678054303702*v_TR_3_4_mv_a_i + 43.3991164322381*v_TR_3_4_mv_a_r + 11.9099460172739*v_TR_3_4_mv_b_i - 12.4113478527151*v_TR_3_4_mv_b_r + 11.9099460172739*v_TR_3_4_mv_c_i - 12.4113478527151*v_TR_3_4_mv_c_r + 20.4417755309677*v_TR_7_8_mv_a_i - 15.0420612397687*v_TR_7_8_mv_a_r - 5.8405072945622*v_TR_7_8_mv_b_i + 4.29773178279105*v_TR_7_8_mv_b_r - 5.84050729456219*v_TR_7_8_mv_c_i + 4.29773178279104*v_TR_7_8_mv_c_r
        struct[0].g[104,0] = i_TR_3_4_mv_b_r - 8.08657895760964*v_TR_1_2_mv_a_i - 6.06493421820724*v_TR_1_2_mv_a_r + 28.3030263516338*v_TR_1_2_mv_b_i + 21.2272697637253*v_TR_1_2_mv_b_r - 8.08657895760965*v_TR_1_2_mv_c_i - 6.06493421820725*v_TR_1_2_mv_c_r + 2.3406091994174*v_TR_3_4_lv_b_i + 0.390101533236234*v_TR_3_4_lv_b_r - 2.3406091994174*v_TR_3_4_lv_c_i - 0.390101533236234*v_TR_3_4_lv_c_r + 12.4113478527151*v_TR_3_4_mv_a_i + 11.9099460172739*v_TR_3_4_mv_a_r - 43.3991164322381*v_TR_3_4_mv_b_i - 41.678054303702*v_TR_3_4_mv_b_r + 12.4113478527151*v_TR_3_4_mv_c_i + 11.909946017274*v_TR_3_4_mv_c_r - 4.29773178279105*v_TR_7_8_mv_a_i - 5.8405072945622*v_TR_7_8_mv_a_r + 15.0420612397687*v_TR_7_8_mv_b_i + 20.4417755309677*v_TR_7_8_mv_b_r - 4.29773178279105*v_TR_7_8_mv_c_i - 5.8405072945622*v_TR_7_8_mv_c_r
        struct[0].g[105,0] = i_TR_3_4_mv_b_i - 6.06493421820724*v_TR_1_2_mv_a_i + 8.08657895760964*v_TR_1_2_mv_a_r + 21.2272697637253*v_TR_1_2_mv_b_i - 28.3030263516338*v_TR_1_2_mv_b_r - 6.06493421820725*v_TR_1_2_mv_c_i + 8.08657895760965*v_TR_1_2_mv_c_r + 0.390101533236234*v_TR_3_4_lv_b_i - 2.3406091994174*v_TR_3_4_lv_b_r - 0.390101533236234*v_TR_3_4_lv_c_i + 2.3406091994174*v_TR_3_4_lv_c_r + 11.9099460172739*v_TR_3_4_mv_a_i - 12.4113478527151*v_TR_3_4_mv_a_r - 41.678054303702*v_TR_3_4_mv_b_i + 43.3991164322381*v_TR_3_4_mv_b_r + 11.909946017274*v_TR_3_4_mv_c_i - 12.4113478527151*v_TR_3_4_mv_c_r - 5.8405072945622*v_TR_7_8_mv_a_i + 4.29773178279105*v_TR_7_8_mv_a_r + 20.4417755309677*v_TR_7_8_mv_b_i - 15.0420612397687*v_TR_7_8_mv_b_r - 5.8405072945622*v_TR_7_8_mv_c_i + 4.29773178279105*v_TR_7_8_mv_c_r
        struct[0].g[106,0] = i_TR_3_4_mv_c_r - 8.08657895760965*v_TR_1_2_mv_a_i - 6.06493421820724*v_TR_1_2_mv_a_r - 8.08657895760964*v_TR_1_2_mv_b_i - 6.06493421820725*v_TR_1_2_mv_b_r + 28.3030263516338*v_TR_1_2_mv_c_i + 21.2272697637253*v_TR_1_2_mv_c_r - 2.3406091994174*v_TR_3_4_lv_a_i - 0.390101533236234*v_TR_3_4_lv_a_r + 2.3406091994174*v_TR_3_4_lv_c_i + 0.390101533236234*v_TR_3_4_lv_c_r + 12.4113478527151*v_TR_3_4_mv_a_i + 11.9099460172739*v_TR_3_4_mv_a_r + 12.4113478527151*v_TR_3_4_mv_b_i + 11.909946017274*v_TR_3_4_mv_b_r - 43.3991164322381*v_TR_3_4_mv_c_i - 41.678054303702*v_TR_3_4_mv_c_r - 4.29773178279105*v_TR_7_8_mv_a_i - 5.84050729456219*v_TR_7_8_mv_a_r - 4.29773178279104*v_TR_7_8_mv_b_i - 5.84050729456221*v_TR_7_8_mv_b_r + 15.0420612397687*v_TR_7_8_mv_c_i + 20.4417755309677*v_TR_7_8_mv_c_r
        struct[0].g[107,0] = i_TR_3_4_mv_c_i - 6.06493421820724*v_TR_1_2_mv_a_i + 8.08657895760965*v_TR_1_2_mv_a_r - 6.06493421820725*v_TR_1_2_mv_b_i + 8.08657895760964*v_TR_1_2_mv_b_r + 21.2272697637253*v_TR_1_2_mv_c_i - 28.3030263516338*v_TR_1_2_mv_c_r - 0.390101533236234*v_TR_3_4_lv_a_i + 2.3406091994174*v_TR_3_4_lv_a_r + 0.390101533236234*v_TR_3_4_lv_c_i - 2.3406091994174*v_TR_3_4_lv_c_r + 11.9099460172739*v_TR_3_4_mv_a_i - 12.4113478527151*v_TR_3_4_mv_a_r + 11.909946017274*v_TR_3_4_mv_b_i - 12.4113478527151*v_TR_3_4_mv_b_r - 41.678054303702*v_TR_3_4_mv_c_i + 43.3991164322381*v_TR_3_4_mv_c_r - 5.84050729456219*v_TR_7_8_mv_a_i + 4.29773178279105*v_TR_7_8_mv_a_r - 5.84050729456221*v_TR_7_8_mv_b_i + 4.29773178279104*v_TR_7_8_mv_b_r + 20.4417755309677*v_TR_7_8_mv_c_i - 15.0420612397687*v_TR_7_8_mv_c_r
        struct[0].g[108,0] = i_TR_3_4_lv_a_r + 107.758927311578*v_INV_3_a_i + 207.974729711346*v_INV_3_a_r - 30.7882649461652*v_INV_3_b_i - 59.4213513460989*v_INV_3_b_r - 30.7882649461652*v_INV_3_c_i - 59.4213513460989*v_INV_3_c_r + 58.4540809492443*v_INV_4_a_i + 112.816376232042*v_INV_4_a_r - 16.7011659854984*v_INV_4_b_i - 32.2332503520119*v_INV_4_b_r - 16.7011659854984*v_INV_4_c_i - 32.2332503520119*v_INV_4_c_r - 368.915426669025*v_TR_3_4_lv_a_i - 354.574889727171*v_TR_3_4_lv_a_r + 47.4895446494637*v_TR_3_4_lv_b_i + 91.6546016981108*v_TR_3_4_lv_b_r + 47.4895446494637*v_TR_3_4_lv_c_i + 91.6546016981108*v_TR_3_4_lv_c_r + 2.3406091994174*v_TR_3_4_mv_a_i + 0.390101533236234*v_TR_3_4_mv_a_r - 2.3406091994174*v_TR_3_4_mv_c_i - 0.390101533236234*v_TR_3_4_mv_c_r
        struct[0].g[109,0] = i_TR_3_4_lv_a_i + 207.974729711346*v_INV_3_a_i - 107.758927311578*v_INV_3_a_r - 59.4213513460989*v_INV_3_b_i + 30.7882649461652*v_INV_3_b_r - 59.4213513460989*v_INV_3_c_i + 30.7882649461652*v_INV_3_c_r + 112.816376232042*v_INV_4_a_i - 58.4540809492443*v_INV_4_a_r - 32.2332503520119*v_INV_4_b_i + 16.7011659854984*v_INV_4_b_r - 32.2332503520119*v_INV_4_c_i + 16.7011659854984*v_INV_4_c_r - 354.574889727171*v_TR_3_4_lv_a_i + 368.915426669025*v_TR_3_4_lv_a_r + 91.6546016981108*v_TR_3_4_lv_b_i - 47.4895446494637*v_TR_3_4_lv_b_r + 91.6546016981108*v_TR_3_4_lv_c_i - 47.4895446494637*v_TR_3_4_lv_c_r + 0.390101533236234*v_TR_3_4_mv_a_i - 2.3406091994174*v_TR_3_4_mv_a_r - 0.390101533236234*v_TR_3_4_mv_c_i + 2.3406091994174*v_TR_3_4_mv_c_r
        struct[0].g[110,0] = i_TR_3_4_lv_b_r - 30.7882649461652*v_INV_3_a_i - 59.4213513460989*v_INV_3_a_r + 107.758927311578*v_INV_3_b_i + 207.974729711346*v_INV_3_b_r - 30.7882649461651*v_INV_3_c_i - 59.421351346099*v_INV_3_c_r - 16.7011659854984*v_INV_4_a_i - 32.2332503520119*v_INV_4_a_r + 58.4540809492443*v_INV_4_b_i + 112.816376232042*v_INV_4_b_r - 16.7011659854984*v_INV_4_c_i - 32.2332503520119*v_INV_4_c_r + 47.4895446494636*v_TR_3_4_lv_a_i + 91.6546016981107*v_TR_3_4_lv_a_r - 368.915426669025*v_TR_3_4_lv_b_i - 354.574889727172*v_TR_3_4_lv_b_r + 47.4895446494636*v_TR_3_4_lv_c_i + 91.6546016981109*v_TR_3_4_lv_c_r - 2.3406091994174*v_TR_3_4_mv_a_i - 0.390101533236234*v_TR_3_4_mv_a_r + 2.3406091994174*v_TR_3_4_mv_b_i + 0.390101533236234*v_TR_3_4_mv_b_r
        struct[0].g[111,0] = i_TR_3_4_lv_b_i - 59.4213513460989*v_INV_3_a_i + 30.7882649461652*v_INV_3_a_r + 207.974729711346*v_INV_3_b_i - 107.758927311578*v_INV_3_b_r - 59.421351346099*v_INV_3_c_i + 30.7882649461651*v_INV_3_c_r - 32.2332503520119*v_INV_4_a_i + 16.7011659854984*v_INV_4_a_r + 112.816376232042*v_INV_4_b_i - 58.4540809492443*v_INV_4_b_r - 32.2332503520119*v_INV_4_c_i + 16.7011659854984*v_INV_4_c_r + 91.6546016981107*v_TR_3_4_lv_a_i - 47.4895446494636*v_TR_3_4_lv_a_r - 354.574889727172*v_TR_3_4_lv_b_i + 368.915426669025*v_TR_3_4_lv_b_r + 91.6546016981109*v_TR_3_4_lv_c_i - 47.4895446494636*v_TR_3_4_lv_c_r - 0.390101533236234*v_TR_3_4_mv_a_i + 2.3406091994174*v_TR_3_4_mv_a_r + 0.390101533236234*v_TR_3_4_mv_b_i - 2.3406091994174*v_TR_3_4_mv_b_r
        struct[0].g[112,0] = i_TR_3_4_lv_c_r - 30.7882649461652*v_INV_3_a_i - 59.4213513460989*v_INV_3_a_r - 30.7882649461651*v_INV_3_b_i - 59.421351346099*v_INV_3_b_r + 107.758927311578*v_INV_3_c_i + 207.974729711346*v_INV_3_c_r - 16.7011659854984*v_INV_4_a_i - 32.2332503520119*v_INV_4_a_r - 16.7011659854983*v_INV_4_b_i - 32.2332503520119*v_INV_4_b_r + 58.4540809492443*v_INV_4_c_i + 112.816376232042*v_INV_4_c_r + 47.4895446494637*v_TR_3_4_lv_a_i + 91.6546016981108*v_TR_3_4_lv_a_r + 47.4895446494636*v_TR_3_4_lv_b_i + 91.6546016981109*v_TR_3_4_lv_b_r - 368.915426669025*v_TR_3_4_lv_c_i - 354.574889727171*v_TR_3_4_lv_c_r - 2.3406091994174*v_TR_3_4_mv_b_i - 0.390101533236234*v_TR_3_4_mv_b_r + 2.3406091994174*v_TR_3_4_mv_c_i + 0.390101533236234*v_TR_3_4_mv_c_r
        struct[0].g[113,0] = i_TR_3_4_lv_c_i - 59.4213513460989*v_INV_3_a_i + 30.7882649461652*v_INV_3_a_r - 59.421351346099*v_INV_3_b_i + 30.7882649461651*v_INV_3_b_r + 207.974729711346*v_INV_3_c_i - 107.758927311578*v_INV_3_c_r - 32.2332503520119*v_INV_4_a_i + 16.7011659854984*v_INV_4_a_r - 32.2332503520119*v_INV_4_b_i + 16.7011659854983*v_INV_4_b_r + 112.816376232042*v_INV_4_c_i - 58.4540809492443*v_INV_4_c_r + 91.6546016981108*v_TR_3_4_lv_a_i - 47.4895446494637*v_TR_3_4_lv_a_r + 91.6546016981109*v_TR_3_4_lv_b_i - 47.4895446494636*v_TR_3_4_lv_b_r - 354.574889727171*v_TR_3_4_lv_c_i + 368.915426669025*v_TR_3_4_lv_c_r - 0.390101533236234*v_TR_3_4_mv_b_i + 2.3406091994174*v_TR_3_4_mv_b_r + 0.390101533236234*v_TR_3_4_mv_c_i - 2.3406091994174*v_TR_3_4_mv_c_r
        struct[0].g[114,0] = i_TR_5_6_mv_a_r + 8.63801621787545*v_POImv_a_i + 6.47851216340659*v_POImv_a_r - 2.4680046336787*v_POImv_b_i - 1.85100347525903*v_POImv_b_r - 2.4680046336787*v_POImv_c_i - 1.85100347525903*v_POImv_c_r + 2.3406091994174*v_TR_5_6_lv_a_i + 0.390101533236234*v_TR_5_6_lv_a_r - 2.3406091994174*v_TR_5_6_lv_b_i - 0.390101533236234*v_TR_5_6_lv_b_r - 53.186989402129*v_TR_5_6_mv_a_i - 39.8587546923895*v_TR_5_6_mv_a_r + 15.2079060840306*v_TR_5_6_mv_b_i + 11.3901461283275*v_TR_5_6_mv_b_r + 15.2079060840306*v_TR_5_6_mv_c_i + 11.3901461283275*v_TR_5_6_mv_c_r + 44.4949780266318*v_TR_9_10_mv_a_i + 33.3712335199739*v_TR_9_10_mv_a_r - 12.7128508647519*v_TR_9_10_mv_b_i - 9.53463814856397*v_TR_9_10_mv_b_r - 12.7128508647519*v_TR_9_10_mv_c_i - 9.53463814856397*v_TR_9_10_mv_c_r
        struct[0].g[115,0] = i_TR_5_6_mv_a_i + 6.47851216340659*v_POImv_a_i - 8.63801621787545*v_POImv_a_r - 1.85100347525903*v_POImv_b_i + 2.4680046336787*v_POImv_b_r - 1.85100347525903*v_POImv_c_i + 2.4680046336787*v_POImv_c_r + 0.390101533236234*v_TR_5_6_lv_a_i - 2.3406091994174*v_TR_5_6_lv_a_r - 0.390101533236234*v_TR_5_6_lv_b_i + 2.3406091994174*v_TR_5_6_lv_b_r - 39.8587546923895*v_TR_5_6_mv_a_i + 53.186989402129*v_TR_5_6_mv_a_r + 11.3901461283275*v_TR_5_6_mv_b_i - 15.2079060840306*v_TR_5_6_mv_b_r + 11.3901461283275*v_TR_5_6_mv_c_i - 15.2079060840306*v_TR_5_6_mv_c_r + 33.3712335199739*v_TR_9_10_mv_a_i - 44.4949780266318*v_TR_9_10_mv_a_r - 9.53463814856397*v_TR_9_10_mv_b_i + 12.7128508647519*v_TR_9_10_mv_b_r - 9.53463814856397*v_TR_9_10_mv_c_i + 12.7128508647519*v_TR_9_10_mv_c_r
        struct[0].g[116,0] = i_TR_5_6_mv_b_r - 2.4680046336787*v_POImv_a_i - 1.85100347525903*v_POImv_a_r + 8.63801621787545*v_POImv_b_i + 6.47851216340659*v_POImv_b_r - 2.4680046336787*v_POImv_c_i - 1.85100347525903*v_POImv_c_r + 2.3406091994174*v_TR_5_6_lv_b_i + 0.390101533236234*v_TR_5_6_lv_b_r - 2.3406091994174*v_TR_5_6_lv_c_i - 0.390101533236234*v_TR_5_6_lv_c_r + 15.2079060840306*v_TR_5_6_mv_a_i + 11.3901461283275*v_TR_5_6_mv_a_r - 53.186989402129*v_TR_5_6_mv_b_i - 39.8587546923895*v_TR_5_6_mv_b_r + 15.2079060840306*v_TR_5_6_mv_c_i + 11.3901461283275*v_TR_5_6_mv_c_r - 12.7128508647519*v_TR_9_10_mv_a_i - 9.53463814856397*v_TR_9_10_mv_a_r + 44.4949780266318*v_TR_9_10_mv_b_i + 33.3712335199739*v_TR_9_10_mv_b_r - 12.712850864752*v_TR_9_10_mv_c_i - 9.53463814856399*v_TR_9_10_mv_c_r
        struct[0].g[117,0] = i_TR_5_6_mv_b_i - 1.85100347525903*v_POImv_a_i + 2.4680046336787*v_POImv_a_r + 6.47851216340659*v_POImv_b_i - 8.63801621787545*v_POImv_b_r - 1.85100347525903*v_POImv_c_i + 2.4680046336787*v_POImv_c_r + 0.390101533236234*v_TR_5_6_lv_b_i - 2.3406091994174*v_TR_5_6_lv_b_r - 0.390101533236234*v_TR_5_6_lv_c_i + 2.3406091994174*v_TR_5_6_lv_c_r + 11.3901461283275*v_TR_5_6_mv_a_i - 15.2079060840306*v_TR_5_6_mv_a_r - 39.8587546923895*v_TR_5_6_mv_b_i + 53.186989402129*v_TR_5_6_mv_b_r + 11.3901461283275*v_TR_5_6_mv_c_i - 15.2079060840306*v_TR_5_6_mv_c_r - 9.53463814856397*v_TR_9_10_mv_a_i + 12.7128508647519*v_TR_9_10_mv_a_r + 33.3712335199739*v_TR_9_10_mv_b_i - 44.4949780266318*v_TR_9_10_mv_b_r - 9.53463814856399*v_TR_9_10_mv_c_i + 12.712850864752*v_TR_9_10_mv_c_r
        struct[0].g[118,0] = i_TR_5_6_mv_c_r - 2.4680046336787*v_POImv_a_i - 1.85100347525903*v_POImv_a_r - 2.4680046336787*v_POImv_b_i - 1.85100347525903*v_POImv_b_r + 8.63801621787545*v_POImv_c_i + 6.47851216340659*v_POImv_c_r - 2.3406091994174*v_TR_5_6_lv_a_i - 0.390101533236234*v_TR_5_6_lv_a_r + 2.3406091994174*v_TR_5_6_lv_c_i + 0.390101533236234*v_TR_5_6_lv_c_r + 15.2079060840306*v_TR_5_6_mv_a_i + 11.3901461283275*v_TR_5_6_mv_a_r + 15.2079060840306*v_TR_5_6_mv_b_i + 11.3901461283275*v_TR_5_6_mv_b_r - 53.186989402129*v_TR_5_6_mv_c_i - 39.8587546923895*v_TR_5_6_mv_c_r - 12.7128508647519*v_TR_9_10_mv_a_i - 9.53463814856397*v_TR_9_10_mv_a_r - 12.712850864752*v_TR_9_10_mv_b_i - 9.53463814856399*v_TR_9_10_mv_b_r + 44.4949780266318*v_TR_9_10_mv_c_i + 33.3712335199739*v_TR_9_10_mv_c_r
        struct[0].g[119,0] = i_TR_5_6_mv_c_i - 1.85100347525903*v_POImv_a_i + 2.4680046336787*v_POImv_a_r - 1.85100347525903*v_POImv_b_i + 2.4680046336787*v_POImv_b_r + 6.47851216340659*v_POImv_c_i - 8.63801621787545*v_POImv_c_r - 0.390101533236234*v_TR_5_6_lv_a_i + 2.3406091994174*v_TR_5_6_lv_a_r + 0.390101533236234*v_TR_5_6_lv_c_i - 2.3406091994174*v_TR_5_6_lv_c_r + 11.3901461283275*v_TR_5_6_mv_a_i - 15.2079060840306*v_TR_5_6_mv_a_r + 11.3901461283275*v_TR_5_6_mv_b_i - 15.2079060840306*v_TR_5_6_mv_b_r - 39.8587546923895*v_TR_5_6_mv_c_i + 53.186989402129*v_TR_5_6_mv_c_r - 9.53463814856397*v_TR_9_10_mv_a_i + 12.7128508647519*v_TR_9_10_mv_a_r - 9.53463814856399*v_TR_9_10_mv_b_i + 12.712850864752*v_TR_9_10_mv_b_r + 33.3712335199739*v_TR_9_10_mv_c_i - 44.4949780266318*v_TR_9_10_mv_c_r
        struct[0].g[120,0] = i_TR_5_6_lv_a_r + 92.6872395051616*v_INV_5_a_i + 178.886372244962*v_INV_5_a_r - 26.4820684300462*v_INV_5_b_i - 51.1103920699891*v_INV_5_b_r - 26.4820684300462*v_INV_5_c_i - 51.1103920699891*v_INV_5_c_r + 58.4997822812349*v_INV_6_a_i + 112.904579802783*v_INV_6_a_r - 16.7142235089243*v_INV_6_b_i - 32.2584513722238*v_INV_6_b_r - 16.7142235089243*v_INV_6_c_i - 32.2584513722239*v_INV_6_c_r - 353.889424080847*v_TR_5_6_lv_a_i - 325.574735831529*v_TR_5_6_lv_a_r + 43.1964121022714*v_TR_5_6_lv_b_i + 83.3688434422129*v_TR_5_6_lv_b_r + 43.1964121022714*v_TR_5_6_lv_c_i + 83.368843442213*v_TR_5_6_lv_c_r + 2.3406091994174*v_TR_5_6_mv_a_i + 0.390101533236234*v_TR_5_6_mv_a_r - 2.3406091994174*v_TR_5_6_mv_c_i - 0.390101533236234*v_TR_5_6_mv_c_r
        struct[0].g[121,0] = i_TR_5_6_lv_a_i + 178.886372244962*v_INV_5_a_i - 92.6872395051616*v_INV_5_a_r - 51.1103920699891*v_INV_5_b_i + 26.4820684300462*v_INV_5_b_r - 51.1103920699891*v_INV_5_c_i + 26.4820684300462*v_INV_5_c_r + 112.904579802783*v_INV_6_a_i - 58.4997822812349*v_INV_6_a_r - 32.2584513722238*v_INV_6_b_i + 16.7142235089243*v_INV_6_b_r - 32.2584513722239*v_INV_6_c_i + 16.7142235089243*v_INV_6_c_r - 325.574735831529*v_TR_5_6_lv_a_i + 353.889424080847*v_TR_5_6_lv_a_r + 83.3688434422129*v_TR_5_6_lv_b_i - 43.1964121022714*v_TR_5_6_lv_b_r + 83.368843442213*v_TR_5_6_lv_c_i - 43.1964121022714*v_TR_5_6_lv_c_r + 0.390101533236234*v_TR_5_6_mv_a_i - 2.3406091994174*v_TR_5_6_mv_a_r - 0.390101533236234*v_TR_5_6_mv_c_i + 2.3406091994174*v_TR_5_6_mv_c_r
        struct[0].g[122,0] = i_TR_5_6_lv_b_r - 26.4820684300461*v_INV_5_a_i - 51.1103920699891*v_INV_5_a_r + 92.6872395051615*v_INV_5_b_i + 178.886372244962*v_INV_5_b_r - 26.4820684300461*v_INV_5_c_i - 51.1103920699892*v_INV_5_c_r - 16.7142235089243*v_INV_6_a_i - 32.2584513722238*v_INV_6_a_r + 58.4997822812349*v_INV_6_b_i + 112.904579802783*v_INV_6_b_r - 16.7142235089242*v_INV_6_c_i - 32.2584513722239*v_INV_6_c_r + 43.1964121022714*v_TR_5_6_lv_a_i + 83.3688434422129*v_TR_5_6_lv_a_r - 353.889424080846*v_TR_5_6_lv_b_i - 325.574735831529*v_TR_5_6_lv_b_r + 43.1964121022714*v_TR_5_6_lv_c_i + 83.3688434422131*v_TR_5_6_lv_c_r - 2.3406091994174*v_TR_5_6_mv_a_i - 0.390101533236234*v_TR_5_6_mv_a_r + 2.3406091994174*v_TR_5_6_mv_b_i + 0.390101533236234*v_TR_5_6_mv_b_r
        struct[0].g[123,0] = i_TR_5_6_lv_b_i - 51.1103920699891*v_INV_5_a_i + 26.4820684300461*v_INV_5_a_r + 178.886372244962*v_INV_5_b_i - 92.6872395051615*v_INV_5_b_r - 51.1103920699892*v_INV_5_c_i + 26.4820684300461*v_INV_5_c_r - 32.2584513722238*v_INV_6_a_i + 16.7142235089243*v_INV_6_a_r + 112.904579802783*v_INV_6_b_i - 58.4997822812349*v_INV_6_b_r - 32.2584513722239*v_INV_6_c_i + 16.7142235089242*v_INV_6_c_r + 83.3688434422129*v_TR_5_6_lv_a_i - 43.1964121022714*v_TR_5_6_lv_a_r - 325.574735831529*v_TR_5_6_lv_b_i + 353.889424080846*v_TR_5_6_lv_b_r + 83.3688434422131*v_TR_5_6_lv_c_i - 43.1964121022714*v_TR_5_6_lv_c_r - 0.390101533236234*v_TR_5_6_mv_a_i + 2.3406091994174*v_TR_5_6_mv_a_r + 0.390101533236234*v_TR_5_6_mv_b_i - 2.3406091994174*v_TR_5_6_mv_b_r
        struct[0].g[124,0] = i_TR_5_6_lv_c_r - 26.4820684300462*v_INV_5_a_i - 51.1103920699891*v_INV_5_a_r - 26.4820684300461*v_INV_5_b_i - 51.1103920699892*v_INV_5_b_r + 92.6872395051615*v_INV_5_c_i + 178.886372244962*v_INV_5_c_r - 16.7142235089243*v_INV_6_a_i - 32.2584513722239*v_INV_6_a_r - 16.7142235089242*v_INV_6_b_i - 32.2584513722239*v_INV_6_b_r + 58.4997822812349*v_INV_6_c_i + 112.904579802783*v_INV_6_c_r + 43.1964121022714*v_TR_5_6_lv_a_i + 83.368843442213*v_TR_5_6_lv_a_r + 43.1964121022714*v_TR_5_6_lv_b_i + 83.3688434422131*v_TR_5_6_lv_b_r - 353.889424080846*v_TR_5_6_lv_c_i - 325.574735831529*v_TR_5_6_lv_c_r - 2.3406091994174*v_TR_5_6_mv_b_i - 0.390101533236234*v_TR_5_6_mv_b_r + 2.3406091994174*v_TR_5_6_mv_c_i + 0.390101533236234*v_TR_5_6_mv_c_r
        struct[0].g[125,0] = i_TR_5_6_lv_c_i - 51.1103920699891*v_INV_5_a_i + 26.4820684300462*v_INV_5_a_r - 51.1103920699892*v_INV_5_b_i + 26.4820684300461*v_INV_5_b_r + 178.886372244962*v_INV_5_c_i - 92.6872395051615*v_INV_5_c_r - 32.2584513722239*v_INV_6_a_i + 16.7142235089243*v_INV_6_a_r - 32.2584513722239*v_INV_6_b_i + 16.7142235089242*v_INV_6_b_r + 112.904579802783*v_INV_6_c_i - 58.4997822812349*v_INV_6_c_r + 83.368843442213*v_TR_5_6_lv_a_i - 43.1964121022714*v_TR_5_6_lv_a_r + 83.3688434422131*v_TR_5_6_lv_b_i - 43.1964121022714*v_TR_5_6_lv_b_r - 325.574735831529*v_TR_5_6_lv_c_i + 353.889424080846*v_TR_5_6_lv_c_r - 0.390101533236234*v_TR_5_6_mv_b_i + 2.3406091994174*v_TR_5_6_mv_b_r + 0.390101533236234*v_TR_5_6_mv_c_i - 2.3406091994174*v_TR_5_6_mv_c_r
        struct[0].g[126,0] = i_TR_7_8_mv_a_r + 6.60088643956832*v_TR_13_mv_a_i + 8.97043541787489*v_TR_13_mv_a_r - 1.88596755416238*v_TR_13_mv_b_i - 2.56298154796426*v_TR_13_mv_b_r - 1.88596755416237*v_TR_13_mv_c_i - 2.56298154796426*v_TR_13_mv_c_r + 15.0420612397687*v_TR_3_4_mv_a_i + 20.4417755309677*v_TR_3_4_mv_a_r - 4.29773178279105*v_TR_3_4_mv_b_i - 5.8405072945622*v_TR_3_4_mv_b_r - 4.29773178279104*v_TR_3_4_mv_c_i - 5.84050729456219*v_TR_3_4_mv_c_r + 2.3406091994174*v_TR_7_8_lv_a_i + 0.390101533236234*v_TR_7_8_lv_a_r - 2.3406091994174*v_TR_7_8_lv_b_i - 0.390101533236234*v_TR_7_8_lv_b_r - 21.6969684194189*v_TR_7_8_mv_a_i - 29.4212199578516*v_TR_7_8_mv_a_r + 6.21073968956929*v_TR_7_8_mv_b_i + 8.40799334703096*v_TR_7_8_mv_b_r + 6.21073968956928*v_TR_7_8_mv_c_i + 8.40799334703096*v_TR_7_8_mv_c_r
        struct[0].g[127,0] = i_TR_7_8_mv_a_i + 8.97043541787489*v_TR_13_mv_a_i - 6.60088643956832*v_TR_13_mv_a_r - 2.56298154796426*v_TR_13_mv_b_i + 1.88596755416238*v_TR_13_mv_b_r - 2.56298154796426*v_TR_13_mv_c_i + 1.88596755416237*v_TR_13_mv_c_r + 20.4417755309677*v_TR_3_4_mv_a_i - 15.0420612397687*v_TR_3_4_mv_a_r - 5.8405072945622*v_TR_3_4_mv_b_i + 4.29773178279105*v_TR_3_4_mv_b_r - 5.84050729456219*v_TR_3_4_mv_c_i + 4.29773178279104*v_TR_3_4_mv_c_r + 0.390101533236234*v_TR_7_8_lv_a_i - 2.3406091994174*v_TR_7_8_lv_a_r - 0.390101533236234*v_TR_7_8_lv_b_i + 2.3406091994174*v_TR_7_8_lv_b_r - 29.4212199578516*v_TR_7_8_mv_a_i + 21.6969684194189*v_TR_7_8_mv_a_r + 8.40799334703096*v_TR_7_8_mv_b_i - 6.21073968956929*v_TR_7_8_mv_b_r + 8.40799334703096*v_TR_7_8_mv_c_i - 6.21073968956928*v_TR_7_8_mv_c_r
        struct[0].g[128,0] = i_TR_7_8_mv_b_r - 1.88596755416238*v_TR_13_mv_a_i - 2.56298154796426*v_TR_13_mv_a_r + 6.60088643956832*v_TR_13_mv_b_i + 8.9704354178749*v_TR_13_mv_b_r - 1.88596755416237*v_TR_13_mv_c_i - 2.56298154796426*v_TR_13_mv_c_r - 4.29773178279105*v_TR_3_4_mv_a_i - 5.8405072945622*v_TR_3_4_mv_a_r + 15.0420612397687*v_TR_3_4_mv_b_i + 20.4417755309677*v_TR_3_4_mv_b_r - 4.29773178279105*v_TR_3_4_mv_c_i - 5.8405072945622*v_TR_3_4_mv_c_r + 2.3406091994174*v_TR_7_8_lv_b_i + 0.390101533236234*v_TR_7_8_lv_b_r - 2.3406091994174*v_TR_7_8_lv_c_i - 0.390101533236234*v_TR_7_8_lv_c_r + 6.21073968956929*v_TR_7_8_mv_a_i + 8.40799334703096*v_TR_7_8_mv_a_r - 21.6969684194189*v_TR_7_8_mv_b_i - 29.4212199578516*v_TR_7_8_mv_b_r + 6.21073968956929*v_TR_7_8_mv_c_i + 8.40799334703097*v_TR_7_8_mv_c_r
        struct[0].g[129,0] = i_TR_7_8_mv_b_i - 2.56298154796426*v_TR_13_mv_a_i + 1.88596755416238*v_TR_13_mv_a_r + 8.9704354178749*v_TR_13_mv_b_i - 6.60088643956832*v_TR_13_mv_b_r - 2.56298154796426*v_TR_13_mv_c_i + 1.88596755416237*v_TR_13_mv_c_r - 5.8405072945622*v_TR_3_4_mv_a_i + 4.29773178279105*v_TR_3_4_mv_a_r + 20.4417755309677*v_TR_3_4_mv_b_i - 15.0420612397687*v_TR_3_4_mv_b_r - 5.8405072945622*v_TR_3_4_mv_c_i + 4.29773178279105*v_TR_3_4_mv_c_r + 0.390101533236234*v_TR_7_8_lv_b_i - 2.3406091994174*v_TR_7_8_lv_b_r - 0.390101533236234*v_TR_7_8_lv_c_i + 2.3406091994174*v_TR_7_8_lv_c_r + 8.40799334703096*v_TR_7_8_mv_a_i - 6.21073968956929*v_TR_7_8_mv_a_r - 29.4212199578516*v_TR_7_8_mv_b_i + 21.6969684194189*v_TR_7_8_mv_b_r + 8.40799334703097*v_TR_7_8_mv_c_i - 6.21073968956929*v_TR_7_8_mv_c_r
        struct[0].g[130,0] = i_TR_7_8_mv_c_r - 1.88596755416237*v_TR_13_mv_a_i - 2.56298154796426*v_TR_13_mv_a_r - 1.88596755416237*v_TR_13_mv_b_i - 2.56298154796426*v_TR_13_mv_b_r + 6.60088643956831*v_TR_13_mv_c_i + 8.9704354178749*v_TR_13_mv_c_r - 4.29773178279105*v_TR_3_4_mv_a_i - 5.84050729456219*v_TR_3_4_mv_a_r - 4.29773178279104*v_TR_3_4_mv_b_i - 5.84050729456221*v_TR_3_4_mv_b_r + 15.0420612397687*v_TR_3_4_mv_c_i + 20.4417755309677*v_TR_3_4_mv_c_r - 2.3406091994174*v_TR_7_8_lv_a_i - 0.390101533236234*v_TR_7_8_lv_a_r + 2.3406091994174*v_TR_7_8_lv_c_i + 0.390101533236234*v_TR_7_8_lv_c_r + 6.21073968956929*v_TR_7_8_mv_a_i + 8.40799334703095*v_TR_7_8_mv_a_r + 6.21073968956928*v_TR_7_8_mv_b_i + 8.40799334703097*v_TR_7_8_mv_b_r - 21.6969684194189*v_TR_7_8_mv_c_i - 29.4212199578516*v_TR_7_8_mv_c_r
        struct[0].g[131,0] = i_TR_7_8_mv_c_i - 2.56298154796426*v_TR_13_mv_a_i + 1.88596755416237*v_TR_13_mv_a_r - 2.56298154796426*v_TR_13_mv_b_i + 1.88596755416237*v_TR_13_mv_b_r + 8.9704354178749*v_TR_13_mv_c_i - 6.60088643956831*v_TR_13_mv_c_r - 5.84050729456219*v_TR_3_4_mv_a_i + 4.29773178279105*v_TR_3_4_mv_a_r - 5.84050729456221*v_TR_3_4_mv_b_i + 4.29773178279104*v_TR_3_4_mv_b_r + 20.4417755309677*v_TR_3_4_mv_c_i - 15.0420612397687*v_TR_3_4_mv_c_r - 0.390101533236234*v_TR_7_8_lv_a_i + 2.3406091994174*v_TR_7_8_lv_a_r + 0.390101533236234*v_TR_7_8_lv_c_i - 2.3406091994174*v_TR_7_8_lv_c_r + 8.40799334703095*v_TR_7_8_mv_a_i - 6.21073968956929*v_TR_7_8_mv_a_r + 8.40799334703097*v_TR_7_8_mv_b_i - 6.21073968956928*v_TR_7_8_mv_b_r - 29.4212199578516*v_TR_7_8_mv_c_i + 21.6969684194189*v_TR_7_8_mv_c_r
        struct[0].g[132,0] = i_TR_7_8_lv_a_r + 246.057604426258*v_INV_7_a_i + 474.891176542679*v_INV_7_a_r - 70.3021726932167*v_INV_7_b_i - 135.683193297908*v_INV_7_b_r - 70.3021726932166*v_INV_7_c_i - 135.683193297908*v_INV_7_c_r + 106.794172415445*v_INV_8_a_i + 206.112752761809*v_INV_8_a_r - 30.5126206901271*v_INV_8_b_i - 58.8893579319454*v_INV_8_b_r - 30.5126206901271*v_INV_8_c_i - 58.8893579319454*v_INV_8_c_r - 555.554334874064*v_TR_7_8_lv_a_i - 714.787713088272*v_TR_7_8_lv_a_r + 100.81485125148*v_TR_7_8_lv_b_i + 194.572551229854*v_TR_7_8_lv_b_r + 100.81485125148*v_TR_7_8_lv_c_i + 194.572551229854*v_TR_7_8_lv_c_r + 2.3406091994174*v_TR_7_8_mv_a_i + 0.390101533236234*v_TR_7_8_mv_a_r - 2.3406091994174*v_TR_7_8_mv_c_i - 0.390101533236234*v_TR_7_8_mv_c_r
        struct[0].g[133,0] = i_TR_7_8_lv_a_i + 474.891176542679*v_INV_7_a_i - 246.057604426258*v_INV_7_a_r - 135.683193297908*v_INV_7_b_i + 70.3021726932167*v_INV_7_b_r - 135.683193297908*v_INV_7_c_i + 70.3021726932166*v_INV_7_c_r + 206.112752761809*v_INV_8_a_i - 106.794172415445*v_INV_8_a_r - 58.8893579319454*v_INV_8_b_i + 30.5126206901271*v_INV_8_b_r - 58.8893579319454*v_INV_8_c_i + 30.5126206901271*v_INV_8_c_r - 714.787713088272*v_TR_7_8_lv_a_i + 555.554334874064*v_TR_7_8_lv_a_r + 194.572551229854*v_TR_7_8_lv_b_i - 100.81485125148*v_TR_7_8_lv_b_r + 194.572551229854*v_TR_7_8_lv_c_i - 100.81485125148*v_TR_7_8_lv_c_r + 0.390101533236234*v_TR_7_8_mv_a_i - 2.3406091994174*v_TR_7_8_mv_a_r - 0.390101533236234*v_TR_7_8_mv_c_i + 2.3406091994174*v_TR_7_8_mv_c_r
        struct[0].g[134,0] = i_TR_7_8_lv_b_r - 70.3021726932166*v_INV_7_a_i - 135.683193297908*v_INV_7_a_r + 246.057604426258*v_INV_7_b_i + 474.891176542679*v_INV_7_b_r - 70.3021726932165*v_INV_7_c_i - 135.683193297909*v_INV_7_c_r - 30.5126206901271*v_INV_8_a_i - 58.8893579319454*v_INV_8_a_r + 106.794172415445*v_INV_8_b_i + 206.112752761809*v_INV_8_b_r - 30.5126206901271*v_INV_8_c_i - 58.8893579319455*v_INV_8_c_r + 100.81485125148*v_TR_7_8_lv_a_i + 194.572551229854*v_TR_7_8_lv_a_r - 555.554334874064*v_TR_7_8_lv_b_i - 714.787713088272*v_TR_7_8_lv_b_r + 100.81485125148*v_TR_7_8_lv_c_i + 194.572551229854*v_TR_7_8_lv_c_r - 2.3406091994174*v_TR_7_8_mv_a_i - 0.390101533236234*v_TR_7_8_mv_a_r + 2.3406091994174*v_TR_7_8_mv_b_i + 0.390101533236234*v_TR_7_8_mv_b_r
        struct[0].g[135,0] = i_TR_7_8_lv_b_i - 135.683193297908*v_INV_7_a_i + 70.3021726932166*v_INV_7_a_r + 474.891176542679*v_INV_7_b_i - 246.057604426258*v_INV_7_b_r - 135.683193297909*v_INV_7_c_i + 70.3021726932165*v_INV_7_c_r - 58.8893579319454*v_INV_8_a_i + 30.5126206901271*v_INV_8_a_r + 206.112752761809*v_INV_8_b_i - 106.794172415445*v_INV_8_b_r - 58.8893579319455*v_INV_8_c_i + 30.5126206901271*v_INV_8_c_r + 194.572551229854*v_TR_7_8_lv_a_i - 100.81485125148*v_TR_7_8_lv_a_r - 714.787713088272*v_TR_7_8_lv_b_i + 555.554334874064*v_TR_7_8_lv_b_r + 194.572551229854*v_TR_7_8_lv_c_i - 100.81485125148*v_TR_7_8_lv_c_r - 0.390101533236234*v_TR_7_8_mv_a_i + 2.3406091994174*v_TR_7_8_mv_a_r + 0.390101533236234*v_TR_7_8_mv_b_i - 2.3406091994174*v_TR_7_8_mv_b_r
        struct[0].g[136,0] = i_TR_7_8_lv_c_r - 70.3021726932167*v_INV_7_a_i - 135.683193297908*v_INV_7_a_r - 70.3021726932165*v_INV_7_b_i - 135.683193297909*v_INV_7_b_r + 246.057604426258*v_INV_7_c_i + 474.891176542679*v_INV_7_c_r - 30.5126206901272*v_INV_8_a_i - 58.8893579319454*v_INV_8_a_r - 30.5126206901271*v_INV_8_b_i - 58.8893579319455*v_INV_8_b_r + 106.794172415445*v_INV_8_c_i + 206.112752761809*v_INV_8_c_r + 100.814851251481*v_TR_7_8_lv_a_i + 194.572551229854*v_TR_7_8_lv_a_r + 100.81485125148*v_TR_7_8_lv_b_i + 194.572551229854*v_TR_7_8_lv_b_r - 555.554334874064*v_TR_7_8_lv_c_i - 714.787713088272*v_TR_7_8_lv_c_r - 2.3406091994174*v_TR_7_8_mv_b_i - 0.390101533236234*v_TR_7_8_mv_b_r + 2.3406091994174*v_TR_7_8_mv_c_i + 0.390101533236234*v_TR_7_8_mv_c_r
        struct[0].g[137,0] = i_TR_7_8_lv_c_i - 135.683193297908*v_INV_7_a_i + 70.3021726932167*v_INV_7_a_r - 135.683193297909*v_INV_7_b_i + 70.3021726932165*v_INV_7_b_r + 474.891176542679*v_INV_7_c_i - 246.057604426258*v_INV_7_c_r - 58.8893579319454*v_INV_8_a_i + 30.5126206901272*v_INV_8_a_r - 58.8893579319455*v_INV_8_b_i + 30.5126206901271*v_INV_8_b_r + 206.112752761809*v_INV_8_c_i - 106.794172415445*v_INV_8_c_r + 194.572551229854*v_TR_7_8_lv_a_i - 100.814851251481*v_TR_7_8_lv_a_r + 194.572551229854*v_TR_7_8_lv_b_i - 100.81485125148*v_TR_7_8_lv_b_r - 714.787713088272*v_TR_7_8_lv_c_i + 555.554334874064*v_TR_7_8_lv_c_r - 0.390101533236234*v_TR_7_8_mv_b_i + 2.3406091994174*v_TR_7_8_mv_b_r + 0.390101533236234*v_TR_7_8_mv_c_i - 2.3406091994174*v_TR_7_8_mv_c_r
        struct[0].g[138,0] = i_TR_9_10_mv_a_r + 8.85995441972108*v_TR_11_12_mv_a_i + 12.0404508780825*v_TR_11_12_mv_a_r - 2.53141554849174*v_TR_11_12_mv_b_i - 3.44012882230928*v_TR_11_12_mv_b_r - 2.53141554849173*v_TR_11_12_mv_c_i - 3.44012882230929*v_TR_11_12_mv_c_r + 44.4949780266318*v_TR_5_6_mv_a_i + 33.3712335199739*v_TR_5_6_mv_a_r - 12.7128508647519*v_TR_5_6_mv_b_i - 9.53463814856397*v_TR_5_6_mv_b_r - 12.7128508647519*v_TR_5_6_mv_c_i - 9.53463814856397*v_TR_5_6_mv_c_r + 2.3406091994174*v_TR_9_10_lv_a_i + 0.390101533236234*v_TR_9_10_lv_a_r - 2.3406091994174*v_TR_9_10_lv_b_i - 0.390101533236234*v_TR_9_10_lv_b_r - 53.4089596754468*v_TR_9_10_mv_a_i - 45.4206934070654*v_TR_9_10_mv_a_r + 15.2713041702548*v_TR_9_10_mv_b_i + 12.9792714753778*v_TR_9_10_mv_b_r + 15.2713041702547*v_TR_9_10_mv_c_i + 12.9792714753778*v_TR_9_10_mv_c_r
        struct[0].g[139,0] = i_TR_9_10_mv_a_i + 12.0404508780825*v_TR_11_12_mv_a_i - 8.85995441972108*v_TR_11_12_mv_a_r - 3.44012882230928*v_TR_11_12_mv_b_i + 2.53141554849174*v_TR_11_12_mv_b_r - 3.44012882230929*v_TR_11_12_mv_c_i + 2.53141554849173*v_TR_11_12_mv_c_r + 33.3712335199739*v_TR_5_6_mv_a_i - 44.4949780266318*v_TR_5_6_mv_a_r - 9.53463814856397*v_TR_5_6_mv_b_i + 12.7128508647519*v_TR_5_6_mv_b_r - 9.53463814856397*v_TR_5_6_mv_c_i + 12.7128508647519*v_TR_5_6_mv_c_r + 0.390101533236234*v_TR_9_10_lv_a_i - 2.3406091994174*v_TR_9_10_lv_a_r - 0.390101533236234*v_TR_9_10_lv_b_i + 2.3406091994174*v_TR_9_10_lv_b_r - 45.4206934070654*v_TR_9_10_mv_a_i + 53.4089596754468*v_TR_9_10_mv_a_r + 12.9792714753778*v_TR_9_10_mv_b_i - 15.2713041702548*v_TR_9_10_mv_b_r + 12.9792714753778*v_TR_9_10_mv_c_i - 15.2713041702547*v_TR_9_10_mv_c_r
        struct[0].g[140,0] = i_TR_9_10_mv_b_r - 2.53141554849173*v_TR_11_12_mv_a_i - 3.44012882230929*v_TR_11_12_mv_a_r + 8.85995441972108*v_TR_11_12_mv_b_i + 12.0404508780825*v_TR_11_12_mv_b_r - 2.53141554849174*v_TR_11_12_mv_c_i - 3.44012882230929*v_TR_11_12_mv_c_r - 12.7128508647519*v_TR_5_6_mv_a_i - 9.53463814856397*v_TR_5_6_mv_a_r + 44.4949780266318*v_TR_5_6_mv_b_i + 33.3712335199739*v_TR_5_6_mv_b_r - 12.712850864752*v_TR_5_6_mv_c_i - 9.53463814856399*v_TR_5_6_mv_c_r + 2.3406091994174*v_TR_9_10_lv_b_i + 0.390101533236234*v_TR_9_10_lv_b_r - 2.3406091994174*v_TR_9_10_lv_c_i - 0.390101533236234*v_TR_9_10_lv_c_r + 15.2713041702548*v_TR_9_10_mv_a_i + 12.9792714753778*v_TR_9_10_mv_a_r - 53.4089596754469*v_TR_9_10_mv_b_i - 45.4206934070654*v_TR_9_10_mv_b_r + 15.2713041702548*v_TR_9_10_mv_c_i + 12.9792714753778*v_TR_9_10_mv_c_r
        struct[0].g[141,0] = i_TR_9_10_mv_b_i - 3.44012882230929*v_TR_11_12_mv_a_i + 2.53141554849173*v_TR_11_12_mv_a_r + 12.0404508780825*v_TR_11_12_mv_b_i - 8.85995441972108*v_TR_11_12_mv_b_r - 3.44012882230929*v_TR_11_12_mv_c_i + 2.53141554849174*v_TR_11_12_mv_c_r - 9.53463814856397*v_TR_5_6_mv_a_i + 12.7128508647519*v_TR_5_6_mv_a_r + 33.3712335199739*v_TR_5_6_mv_b_i - 44.4949780266318*v_TR_5_6_mv_b_r - 9.53463814856399*v_TR_5_6_mv_c_i + 12.712850864752*v_TR_5_6_mv_c_r + 0.390101533236234*v_TR_9_10_lv_b_i - 2.3406091994174*v_TR_9_10_lv_b_r - 0.390101533236234*v_TR_9_10_lv_c_i + 2.3406091994174*v_TR_9_10_lv_c_r + 12.9792714753778*v_TR_9_10_mv_a_i - 15.2713041702548*v_TR_9_10_mv_a_r - 45.4206934070654*v_TR_9_10_mv_b_i + 53.4089596754469*v_TR_9_10_mv_b_r + 12.9792714753778*v_TR_9_10_mv_c_i - 15.2713041702548*v_TR_9_10_mv_c_r
        struct[0].g[142,0] = i_TR_9_10_mv_c_r - 2.53141554849174*v_TR_11_12_mv_a_i - 3.44012882230928*v_TR_11_12_mv_a_r - 2.53141554849174*v_TR_11_12_mv_b_i - 3.44012882230929*v_TR_11_12_mv_b_r + 8.85995441972108*v_TR_11_12_mv_c_i + 12.0404508780825*v_TR_11_12_mv_c_r - 12.7128508647519*v_TR_5_6_mv_a_i - 9.53463814856397*v_TR_5_6_mv_a_r - 12.712850864752*v_TR_5_6_mv_b_i - 9.53463814856399*v_TR_5_6_mv_b_r + 44.4949780266318*v_TR_5_6_mv_c_i + 33.3712335199739*v_TR_5_6_mv_c_r - 2.3406091994174*v_TR_9_10_lv_a_i - 0.390101533236234*v_TR_9_10_lv_a_r + 2.3406091994174*v_TR_9_10_lv_c_i + 0.390101533236234*v_TR_9_10_lv_c_r + 15.2713041702548*v_TR_9_10_mv_a_i + 12.9792714753778*v_TR_9_10_mv_a_r + 15.2713041702548*v_TR_9_10_mv_b_i + 12.9792714753778*v_TR_9_10_mv_b_r - 53.4089596754468*v_TR_9_10_mv_c_i - 45.4206934070654*v_TR_9_10_mv_c_r
        struct[0].g[143,0] = i_TR_9_10_mv_c_i - 3.44012882230928*v_TR_11_12_mv_a_i + 2.53141554849174*v_TR_11_12_mv_a_r - 3.44012882230929*v_TR_11_12_mv_b_i + 2.53141554849174*v_TR_11_12_mv_b_r + 12.0404508780825*v_TR_11_12_mv_c_i - 8.85995441972108*v_TR_11_12_mv_c_r - 9.53463814856397*v_TR_5_6_mv_a_i + 12.7128508647519*v_TR_5_6_mv_a_r - 9.53463814856399*v_TR_5_6_mv_b_i + 12.712850864752*v_TR_5_6_mv_b_r + 33.3712335199739*v_TR_5_6_mv_c_i - 44.4949780266318*v_TR_5_6_mv_c_r - 0.390101533236234*v_TR_9_10_lv_a_i + 2.3406091994174*v_TR_9_10_lv_a_r + 0.390101533236234*v_TR_9_10_lv_c_i - 2.3406091994174*v_TR_9_10_lv_c_r + 12.9792714753778*v_TR_9_10_mv_a_i - 15.2713041702548*v_TR_9_10_mv_a_r + 12.9792714753778*v_TR_9_10_mv_b_i - 15.2713041702548*v_TR_9_10_mv_b_r - 45.4206934070654*v_TR_9_10_mv_c_i + 53.4089596754468*v_TR_9_10_mv_c_r
        struct[0].g[144,0] = i_TR_9_10_lv_a_r + 75.8059117481773*v_INV_10_a_i + 146.305409673982*v_INV_10_a_r - 21.6588319280506*v_INV_10_b_i - 41.8015456211378*v_INV_10_b_r - 21.6588319280506*v_INV_10_c_i - 41.8015456211378*v_INV_10_c_r + 98.1764998873781*v_INV_9_a_i + 189.48064478264*v_INV_9_a_r - 28.0504285392509*v_INV_9_b_i - 54.1373270807543*v_INV_9_b_r - 28.0504285392509*v_INV_9_c_i - 54.1373270807543*v_INV_9_c_r - 376.684862474157*v_TR_9_10_lv_a_i - 369.569838240406*v_TR_9_10_lv_a_r + 49.709361212942*v_TR_9_10_lv_b_i + 95.9388727018921*v_TR_9_10_lv_b_r + 49.7093612129419*v_TR_9_10_lv_c_i + 95.9388727018921*v_TR_9_10_lv_c_r + 2.3406091994174*v_TR_9_10_mv_a_i + 0.390101533236234*v_TR_9_10_mv_a_r - 2.3406091994174*v_TR_9_10_mv_c_i - 0.390101533236234*v_TR_9_10_mv_c_r
        struct[0].g[145,0] = i_TR_9_10_lv_a_i + 146.305409673982*v_INV_10_a_i - 75.8059117481773*v_INV_10_a_r - 41.8015456211378*v_INV_10_b_i + 21.6588319280506*v_INV_10_b_r - 41.8015456211378*v_INV_10_c_i + 21.6588319280506*v_INV_10_c_r + 189.48064478264*v_INV_9_a_i - 98.1764998873781*v_INV_9_a_r - 54.1373270807543*v_INV_9_b_i + 28.0504285392509*v_INV_9_b_r - 54.1373270807543*v_INV_9_c_i + 28.0504285392509*v_INV_9_c_r - 369.569838240406*v_TR_9_10_lv_a_i + 376.684862474157*v_TR_9_10_lv_a_r + 95.9388727018921*v_TR_9_10_lv_b_i - 49.709361212942*v_TR_9_10_lv_b_r + 95.9388727018921*v_TR_9_10_lv_c_i - 49.7093612129419*v_TR_9_10_lv_c_r + 0.390101533236234*v_TR_9_10_mv_a_i - 2.3406091994174*v_TR_9_10_mv_a_r - 0.390101533236234*v_TR_9_10_mv_c_i + 2.3406091994174*v_TR_9_10_mv_c_r
        struct[0].g[146,0] = i_TR_9_10_lv_b_r - 21.6588319280506*v_INV_10_a_i - 41.8015456211377*v_INV_10_a_r + 75.8059117481773*v_INV_10_b_i + 146.305409673982*v_INV_10_b_r - 21.6588319280506*v_INV_10_c_i - 41.8015456211378*v_INV_10_c_r - 28.0504285392509*v_INV_9_a_i - 54.1373270807543*v_INV_9_a_r + 98.1764998873781*v_INV_9_b_i + 189.48064478264*v_INV_9_b_r - 28.0504285392509*v_INV_9_c_i - 54.1373270807544*v_INV_9_c_r + 49.7093612129419*v_TR_9_10_lv_a_i + 95.938872701892*v_TR_9_10_lv_a_r - 376.684862474157*v_TR_9_10_lv_b_i - 369.569838240406*v_TR_9_10_lv_b_r + 49.7093612129419*v_TR_9_10_lv_c_i + 95.9388727018922*v_TR_9_10_lv_c_r - 2.3406091994174*v_TR_9_10_mv_a_i - 0.390101533236234*v_TR_9_10_mv_a_r + 2.3406091994174*v_TR_9_10_mv_b_i + 0.390101533236234*v_TR_9_10_mv_b_r
        struct[0].g[147,0] = i_TR_9_10_lv_b_i - 41.8015456211377*v_INV_10_a_i + 21.6588319280506*v_INV_10_a_r + 146.305409673982*v_INV_10_b_i - 75.8059117481773*v_INV_10_b_r - 41.8015456211378*v_INV_10_c_i + 21.6588319280506*v_INV_10_c_r - 54.1373270807543*v_INV_9_a_i + 28.0504285392509*v_INV_9_a_r + 189.48064478264*v_INV_9_b_i - 98.1764998873781*v_INV_9_b_r - 54.1373270807544*v_INV_9_c_i + 28.0504285392509*v_INV_9_c_r + 95.938872701892*v_TR_9_10_lv_a_i - 49.7093612129419*v_TR_9_10_lv_a_r - 369.569838240406*v_TR_9_10_lv_b_i + 376.684862474157*v_TR_9_10_lv_b_r + 95.9388727018922*v_TR_9_10_lv_c_i - 49.7093612129419*v_TR_9_10_lv_c_r - 0.390101533236234*v_TR_9_10_mv_a_i + 2.3406091994174*v_TR_9_10_mv_a_r + 0.390101533236234*v_TR_9_10_mv_b_i - 2.3406091994174*v_TR_9_10_mv_b_r
        struct[0].g[148,0] = i_TR_9_10_lv_c_r - 21.6588319280506*v_INV_10_a_i - 41.8015456211378*v_INV_10_a_r - 21.6588319280506*v_INV_10_b_i - 41.8015456211378*v_INV_10_b_r + 75.8059117481773*v_INV_10_c_i + 146.305409673982*v_INV_10_c_r - 28.0504285392509*v_INV_9_a_i - 54.1373270807543*v_INV_9_a_r - 28.0504285392509*v_INV_9_b_i - 54.1373270807543*v_INV_9_b_r + 98.1764998873781*v_INV_9_c_i + 189.48064478264*v_INV_9_c_r + 49.709361212942*v_TR_9_10_lv_a_i + 95.9388727018921*v_TR_9_10_lv_a_r + 49.7093612129419*v_TR_9_10_lv_b_i + 95.9388727018921*v_TR_9_10_lv_b_r - 376.684862474157*v_TR_9_10_lv_c_i - 369.569838240406*v_TR_9_10_lv_c_r - 2.3406091994174*v_TR_9_10_mv_b_i - 0.390101533236234*v_TR_9_10_mv_b_r + 2.3406091994174*v_TR_9_10_mv_c_i + 0.390101533236234*v_TR_9_10_mv_c_r
        struct[0].g[149,0] = i_TR_9_10_lv_c_i - 41.8015456211378*v_INV_10_a_i + 21.6588319280506*v_INV_10_a_r - 41.8015456211378*v_INV_10_b_i + 21.6588319280506*v_INV_10_b_r + 146.305409673982*v_INV_10_c_i - 75.8059117481773*v_INV_10_c_r - 54.1373270807543*v_INV_9_a_i + 28.0504285392509*v_INV_9_a_r - 54.1373270807543*v_INV_9_b_i + 28.0504285392509*v_INV_9_b_r + 189.48064478264*v_INV_9_c_i - 98.1764998873781*v_INV_9_c_r + 95.9388727018921*v_TR_9_10_lv_a_i - 49.709361212942*v_TR_9_10_lv_a_r + 95.9388727018921*v_TR_9_10_lv_b_i - 49.7093612129419*v_TR_9_10_lv_b_r - 369.569838240406*v_TR_9_10_lv_c_i + 376.684862474157*v_TR_9_10_lv_c_r - 0.390101533236234*v_TR_9_10_mv_b_i + 2.3406091994174*v_TR_9_10_mv_b_r + 0.390101533236234*v_TR_9_10_mv_c_i - 2.3406091994174*v_TR_9_10_mv_c_r
        struct[0].g[150,0] = i_TR_11_12_mv_a_r + 2.3406091994174*v_TR_11_12_lv_a_i + 0.390101533236234*v_TR_11_12_lv_a_r - 2.3406091994174*v_TR_11_12_lv_b_i - 0.390101533236234*v_TR_11_12_lv_b_r - 8.91399122381347*v_TR_11_12_mv_a_i - 12.0494598870915*v_TR_11_12_mv_a_r + 2.55844947550343*v_TR_11_12_mv_b_i + 3.44463332681379*v_TR_11_12_mv_b_r + 2.55844947550343*v_TR_11_12_mv_c_i + 3.44463332681379*v_TR_11_12_mv_c_r + 8.85995441972108*v_TR_9_10_mv_a_i + 12.0404508780825*v_TR_9_10_mv_a_r - 2.53141554849174*v_TR_9_10_mv_b_i - 3.44012882230928*v_TR_9_10_mv_b_r - 2.53141554849173*v_TR_9_10_mv_c_i - 3.44012882230929*v_TR_9_10_mv_c_r
        struct[0].g[151,0] = i_TR_11_12_mv_a_i + 0.390101533236234*v_TR_11_12_lv_a_i - 2.3406091994174*v_TR_11_12_lv_a_r - 0.390101533236234*v_TR_11_12_lv_b_i + 2.3406091994174*v_TR_11_12_lv_b_r - 12.0494598870915*v_TR_11_12_mv_a_i + 8.91399122381347*v_TR_11_12_mv_a_r + 3.44463332681379*v_TR_11_12_mv_b_i - 2.55844947550343*v_TR_11_12_mv_b_r + 3.44463332681379*v_TR_11_12_mv_c_i - 2.55844947550343*v_TR_11_12_mv_c_r + 12.0404508780825*v_TR_9_10_mv_a_i - 8.85995441972108*v_TR_9_10_mv_a_r - 3.44012882230928*v_TR_9_10_mv_b_i + 2.53141554849174*v_TR_9_10_mv_b_r - 3.44012882230929*v_TR_9_10_mv_c_i + 2.53141554849173*v_TR_9_10_mv_c_r
        struct[0].g[152,0] = i_TR_11_12_mv_b_r + 2.3406091994174*v_TR_11_12_lv_b_i + 0.390101533236234*v_TR_11_12_lv_b_r - 2.3406091994174*v_TR_11_12_lv_c_i - 0.390101533236234*v_TR_11_12_lv_c_r + 2.55844947550343*v_TR_11_12_mv_a_i + 3.44463332681379*v_TR_11_12_mv_a_r - 8.91399122381347*v_TR_11_12_mv_b_i - 12.0494598870915*v_TR_11_12_mv_b_r + 2.55844947550343*v_TR_11_12_mv_c_i + 3.4446333268138*v_TR_11_12_mv_c_r - 2.53141554849173*v_TR_9_10_mv_a_i - 3.44012882230929*v_TR_9_10_mv_a_r + 8.85995441972108*v_TR_9_10_mv_b_i + 12.0404508780825*v_TR_9_10_mv_b_r - 2.53141554849174*v_TR_9_10_mv_c_i - 3.44012882230929*v_TR_9_10_mv_c_r
        struct[0].g[153,0] = i_TR_11_12_mv_b_i + 0.390101533236234*v_TR_11_12_lv_b_i - 2.3406091994174*v_TR_11_12_lv_b_r - 0.390101533236234*v_TR_11_12_lv_c_i + 2.3406091994174*v_TR_11_12_lv_c_r + 3.44463332681379*v_TR_11_12_mv_a_i - 2.55844947550343*v_TR_11_12_mv_a_r - 12.0494598870915*v_TR_11_12_mv_b_i + 8.91399122381347*v_TR_11_12_mv_b_r + 3.4446333268138*v_TR_11_12_mv_c_i - 2.55844947550343*v_TR_11_12_mv_c_r - 3.44012882230929*v_TR_9_10_mv_a_i + 2.53141554849173*v_TR_9_10_mv_a_r + 12.0404508780825*v_TR_9_10_mv_b_i - 8.85995441972108*v_TR_9_10_mv_b_r - 3.44012882230929*v_TR_9_10_mv_c_i + 2.53141554849174*v_TR_9_10_mv_c_r
        struct[0].g[154,0] = i_TR_11_12_mv_c_r - 2.3406091994174*v_TR_11_12_lv_a_i - 0.390101533236234*v_TR_11_12_lv_a_r + 2.3406091994174*v_TR_11_12_lv_c_i + 0.390101533236234*v_TR_11_12_lv_c_r + 2.55844947550343*v_TR_11_12_mv_a_i + 3.44463332681379*v_TR_11_12_mv_a_r + 2.55844947550343*v_TR_11_12_mv_b_i + 3.4446333268138*v_TR_11_12_mv_b_r - 8.91399122381347*v_TR_11_12_mv_c_i - 12.0494598870915*v_TR_11_12_mv_c_r - 2.53141554849174*v_TR_9_10_mv_a_i - 3.44012882230928*v_TR_9_10_mv_a_r - 2.53141554849174*v_TR_9_10_mv_b_i - 3.44012882230929*v_TR_9_10_mv_b_r + 8.85995441972108*v_TR_9_10_mv_c_i + 12.0404508780825*v_TR_9_10_mv_c_r
        struct[0].g[155,0] = i_TR_11_12_mv_c_i - 0.390101533236234*v_TR_11_12_lv_a_i + 2.3406091994174*v_TR_11_12_lv_a_r + 0.390101533236234*v_TR_11_12_lv_c_i - 2.3406091994174*v_TR_11_12_lv_c_r + 3.44463332681379*v_TR_11_12_mv_a_i - 2.55844947550343*v_TR_11_12_mv_a_r + 3.4446333268138*v_TR_11_12_mv_b_i - 2.55844947550343*v_TR_11_12_mv_b_r - 12.0494598870915*v_TR_11_12_mv_c_i + 8.91399122381347*v_TR_11_12_mv_c_r - 3.44012882230928*v_TR_9_10_mv_a_i + 2.53141554849174*v_TR_9_10_mv_a_r - 3.44012882230929*v_TR_9_10_mv_b_i + 2.53141554849174*v_TR_9_10_mv_b_r + 12.0404508780825*v_TR_9_10_mv_c_i - 8.85995441972108*v_TR_9_10_mv_c_r
        struct[0].g[156,0] = i_TR_11_12_lv_a_r + 81.5761620304113*v_INV_11_a_i + 157.441992718694*v_INV_11_a_r - 23.3074748658318*v_INV_11_b_i - 44.9834264910554*v_INV_11_b_r - 23.3074748658318*v_INV_11_c_i - 44.9834264910554*v_INV_11_c_r + 107.907268017809*v_INV_12_a_i + 208.26102727437*v_INV_12_a_r - 30.8306480050881*v_INV_12_b_i - 59.5031506498201*v_INV_12_b_r - 30.8306480050881*v_INV_12_c_i - 59.5031506498201*v_INV_12_c_r - 392.185900835935*v_TR_11_12_lv_a_i - 399.486803776848*v_TR_11_12_lv_a_r + 54.138215636915*v_TR_11_12_lv_b_i + 104.486577140876*v_TR_11_12_lv_b_r + 54.138215636915*v_TR_11_12_lv_c_i + 104.486577140876*v_TR_11_12_lv_c_r + 2.3406091994174*v_TR_11_12_mv_a_i + 0.390101533236234*v_TR_11_12_mv_a_r - 2.3406091994174*v_TR_11_12_mv_c_i - 0.390101533236234*v_TR_11_12_mv_c_r
        struct[0].g[157,0] = i_TR_11_12_lv_a_i + 157.441992718694*v_INV_11_a_i - 81.5761620304113*v_INV_11_a_r - 44.9834264910554*v_INV_11_b_i + 23.3074748658318*v_INV_11_b_r - 44.9834264910554*v_INV_11_c_i + 23.3074748658318*v_INV_11_c_r + 208.26102727437*v_INV_12_a_i - 107.907268017809*v_INV_12_a_r - 59.5031506498201*v_INV_12_b_i + 30.8306480050881*v_INV_12_b_r - 59.5031506498201*v_INV_12_c_i + 30.8306480050881*v_INV_12_c_r - 399.486803776848*v_TR_11_12_lv_a_i + 392.185900835935*v_TR_11_12_lv_a_r + 104.486577140876*v_TR_11_12_lv_b_i - 54.138215636915*v_TR_11_12_lv_b_r + 104.486577140876*v_TR_11_12_lv_c_i - 54.138215636915*v_TR_11_12_lv_c_r + 0.390101533236234*v_TR_11_12_mv_a_i - 2.3406091994174*v_TR_11_12_mv_a_r - 0.390101533236234*v_TR_11_12_mv_c_i + 2.3406091994174*v_TR_11_12_mv_c_r
        struct[0].g[158,0] = i_TR_11_12_lv_b_r - 23.3074748658318*v_INV_11_a_i - 44.9834264910554*v_INV_11_a_r + 81.5761620304112*v_INV_11_b_i + 157.441992718694*v_INV_11_b_r - 23.3074748658317*v_INV_11_c_i - 44.9834264910555*v_INV_11_c_r - 30.8306480050881*v_INV_12_a_i - 59.5031506498201*v_INV_12_a_r + 107.907268017808*v_INV_12_b_i + 208.261027274371*v_INV_12_b_r - 30.8306480050881*v_INV_12_c_i - 59.5031506498202*v_INV_12_c_r + 54.138215636915*v_TR_11_12_lv_a_i + 104.486577140876*v_TR_11_12_lv_a_r - 392.185900835935*v_TR_11_12_lv_b_i - 399.486803776848*v_TR_11_12_lv_b_r + 54.138215636915*v_TR_11_12_lv_c_i + 104.486577140876*v_TR_11_12_lv_c_r - 2.3406091994174*v_TR_11_12_mv_a_i - 0.390101533236234*v_TR_11_12_mv_a_r + 2.3406091994174*v_TR_11_12_mv_b_i + 0.390101533236234*v_TR_11_12_mv_b_r
        struct[0].g[159,0] = i_TR_11_12_lv_b_i - 44.9834264910554*v_INV_11_a_i + 23.3074748658318*v_INV_11_a_r + 157.441992718694*v_INV_11_b_i - 81.5761620304112*v_INV_11_b_r - 44.9834264910555*v_INV_11_c_i + 23.3074748658317*v_INV_11_c_r - 59.5031506498201*v_INV_12_a_i + 30.8306480050881*v_INV_12_a_r + 208.261027274371*v_INV_12_b_i - 107.907268017808*v_INV_12_b_r - 59.5031506498202*v_INV_12_c_i + 30.8306480050881*v_INV_12_c_r + 104.486577140876*v_TR_11_12_lv_a_i - 54.138215636915*v_TR_11_12_lv_a_r - 399.486803776848*v_TR_11_12_lv_b_i + 392.185900835935*v_TR_11_12_lv_b_r + 104.486577140876*v_TR_11_12_lv_c_i - 54.138215636915*v_TR_11_12_lv_c_r - 0.390101533236234*v_TR_11_12_mv_a_i + 2.3406091994174*v_TR_11_12_mv_a_r + 0.390101533236234*v_TR_11_12_mv_b_i - 2.3406091994174*v_TR_11_12_mv_b_r
        struct[0].g[160,0] = i_TR_11_12_lv_c_r - 23.3074748658318*v_INV_11_a_i - 44.9834264910554*v_INV_11_a_r - 23.3074748658317*v_INV_11_b_i - 44.9834264910554*v_INV_11_b_r + 81.5761620304112*v_INV_11_c_i + 157.441992718694*v_INV_11_c_r - 30.8306480050882*v_INV_12_a_i - 59.5031506498201*v_INV_12_a_r - 30.8306480050881*v_INV_12_b_i - 59.5031506498202*v_INV_12_b_r + 107.907268017808*v_INV_12_c_i + 208.261027274371*v_INV_12_c_r + 54.138215636915*v_TR_11_12_lv_a_i + 104.486577140876*v_TR_11_12_lv_a_r + 54.138215636915*v_TR_11_12_lv_b_i + 104.486577140876*v_TR_11_12_lv_b_r - 392.185900835935*v_TR_11_12_lv_c_i - 399.486803776848*v_TR_11_12_lv_c_r - 2.3406091994174*v_TR_11_12_mv_b_i - 0.390101533236234*v_TR_11_12_mv_b_r + 2.3406091994174*v_TR_11_12_mv_c_i + 0.390101533236234*v_TR_11_12_mv_c_r
        struct[0].g[161,0] = i_TR_11_12_lv_c_i - 44.9834264910554*v_INV_11_a_i + 23.3074748658318*v_INV_11_a_r - 44.9834264910554*v_INV_11_b_i + 23.3074748658317*v_INV_11_b_r + 157.441992718694*v_INV_11_c_i - 81.5761620304112*v_INV_11_c_r - 59.5031506498201*v_INV_12_a_i + 30.8306480050882*v_INV_12_a_r - 59.5031506498202*v_INV_12_b_i + 30.8306480050881*v_INV_12_b_r + 208.261027274371*v_INV_12_c_i - 107.907268017808*v_INV_12_c_r + 104.486577140876*v_TR_11_12_lv_a_i - 54.138215636915*v_TR_11_12_lv_a_r + 104.486577140876*v_TR_11_12_lv_b_i - 54.138215636915*v_TR_11_12_lv_b_r - 399.486803776848*v_TR_11_12_lv_c_i + 392.185900835935*v_TR_11_12_lv_c_r - 0.390101533236234*v_TR_11_12_mv_b_i + 2.3406091994174*v_TR_11_12_mv_b_r + 0.390101533236234*v_TR_11_12_mv_c_i - 2.3406091994174*v_TR_11_12_mv_c_r
        struct[0].g[162,0] = i_TR_13_mv_a_r + 1.1703045997087*v_TR_13_lv_a_i + 0.195050766618117*v_TR_13_lv_a_r - 1.1703045997087*v_TR_13_lv_b_i - 0.195050766618117*v_TR_13_lv_b_r - 6.62789031305749*v_TR_13_mv_a_i - 8.9749399223794*v_TR_13_mv_a_r + 1.89949032909103*v_TR_13_mv_b_i + 2.56523380021651*v_TR_13_mv_b_r + 1.89949032909103*v_TR_13_mv_c_i + 2.56523380021651*v_TR_13_mv_c_r + 6.60088643956832*v_TR_7_8_mv_a_i + 8.97043541787489*v_TR_7_8_mv_a_r - 1.88596755416238*v_TR_7_8_mv_b_i - 2.56298154796426*v_TR_7_8_mv_b_r - 1.88596755416237*v_TR_7_8_mv_c_i - 2.56298154796426*v_TR_7_8_mv_c_r
        struct[0].g[163,0] = i_TR_13_mv_a_i + 0.195050766618117*v_TR_13_lv_a_i - 1.1703045997087*v_TR_13_lv_a_r - 0.195050766618117*v_TR_13_lv_b_i + 1.1703045997087*v_TR_13_lv_b_r - 8.9749399223794*v_TR_13_mv_a_i + 6.62789031305749*v_TR_13_mv_a_r + 2.56523380021651*v_TR_13_mv_b_i - 1.89949032909103*v_TR_13_mv_b_r + 2.56523380021651*v_TR_13_mv_c_i - 1.89949032909103*v_TR_13_mv_c_r + 8.97043541787489*v_TR_7_8_mv_a_i - 6.60088643956832*v_TR_7_8_mv_a_r - 2.56298154796426*v_TR_7_8_mv_b_i + 1.88596755416238*v_TR_7_8_mv_b_r - 2.56298154796426*v_TR_7_8_mv_c_i + 1.88596755416237*v_TR_7_8_mv_c_r
        struct[0].g[164,0] = i_TR_13_mv_b_r + 1.1703045997087*v_TR_13_lv_b_i + 0.195050766618117*v_TR_13_lv_b_r - 1.1703045997087*v_TR_13_lv_c_i - 0.195050766618117*v_TR_13_lv_c_r + 1.89949032909103*v_TR_13_mv_a_i + 2.56523380021651*v_TR_13_mv_a_r - 6.62789031305749*v_TR_13_mv_b_i - 8.97493992237941*v_TR_13_mv_b_r + 1.89949032909103*v_TR_13_mv_c_i + 2.56523380021651*v_TR_13_mv_c_r - 1.88596755416238*v_TR_7_8_mv_a_i - 2.56298154796426*v_TR_7_8_mv_a_r + 6.60088643956832*v_TR_7_8_mv_b_i + 8.9704354178749*v_TR_7_8_mv_b_r - 1.88596755416237*v_TR_7_8_mv_c_i - 2.56298154796426*v_TR_7_8_mv_c_r
        struct[0].g[165,0] = i_TR_13_mv_b_i + 0.195050766618117*v_TR_13_lv_b_i - 1.1703045997087*v_TR_13_lv_b_r - 0.195050766618117*v_TR_13_lv_c_i + 1.1703045997087*v_TR_13_lv_c_r + 2.56523380021651*v_TR_13_mv_a_i - 1.89949032909103*v_TR_13_mv_a_r - 8.97493992237941*v_TR_13_mv_b_i + 6.62789031305749*v_TR_13_mv_b_r + 2.56523380021651*v_TR_13_mv_c_i - 1.89949032909103*v_TR_13_mv_c_r - 2.56298154796426*v_TR_7_8_mv_a_i + 1.88596755416238*v_TR_7_8_mv_a_r + 8.9704354178749*v_TR_7_8_mv_b_i - 6.60088643956832*v_TR_7_8_mv_b_r - 2.56298154796426*v_TR_7_8_mv_c_i + 1.88596755416237*v_TR_7_8_mv_c_r
        struct[0].g[166,0] = i_TR_13_mv_c_r - 1.1703045997087*v_TR_13_lv_a_i - 0.195050766618117*v_TR_13_lv_a_r + 1.1703045997087*v_TR_13_lv_c_i + 0.195050766618117*v_TR_13_lv_c_r + 1.89949032909103*v_TR_13_mv_a_i + 2.56523380021651*v_TR_13_mv_a_r + 1.89949032909103*v_TR_13_mv_b_i + 2.56523380021651*v_TR_13_mv_b_r - 6.62789031305748*v_TR_13_mv_c_i - 8.9749399223794*v_TR_13_mv_c_r - 1.88596755416237*v_TR_7_8_mv_a_i - 2.56298154796426*v_TR_7_8_mv_a_r - 1.88596755416237*v_TR_7_8_mv_b_i - 2.56298154796426*v_TR_7_8_mv_b_r + 6.60088643956831*v_TR_7_8_mv_c_i + 8.9704354178749*v_TR_7_8_mv_c_r
        struct[0].g[167,0] = i_TR_13_mv_c_i - 0.195050766618117*v_TR_13_lv_a_i + 1.1703045997087*v_TR_13_lv_a_r + 0.195050766618117*v_TR_13_lv_c_i - 1.1703045997087*v_TR_13_lv_c_r + 2.56523380021651*v_TR_13_mv_a_i - 1.89949032909103*v_TR_13_mv_a_r + 2.56523380021651*v_TR_13_mv_b_i - 1.89949032909103*v_TR_13_mv_b_r - 8.9749399223794*v_TR_13_mv_c_i + 6.62789031305748*v_TR_13_mv_c_r - 2.56298154796426*v_TR_7_8_mv_a_i + 1.88596755416237*v_TR_7_8_mv_a_r - 2.56298154796426*v_TR_7_8_mv_b_i + 1.88596755416237*v_TR_7_8_mv_b_r + 8.9704354178749*v_TR_7_8_mv_c_i - 6.60088643956831*v_TR_7_8_mv_c_r
        struct[0].g[168,0] = i_TR_13_lv_a_r + 225.774979236273*v_INV_13_a_i + 435.745709926008*v_INV_13_a_r - 64.5071369246495*v_INV_13_b_i - 124.498774264574*v_INV_13_b_r - 64.5071369246495*v_INV_13_c_i - 124.498774264574*v_INV_13_c_r - 327.126282868141*v_TR_13_lv_a_i - 452.6376018179*v_TR_13_lv_a_r + 64.5071560124429*v_TR_13_lv_b_i + 124.498774264574*v_TR_13_lv_b_r + 64.5071560124428*v_TR_13_lv_c_i + 124.498774264574*v_TR_13_lv_c_r + 1.1703045997087*v_TR_13_mv_a_i + 0.195050766618117*v_TR_13_mv_a_r - 1.1703045997087*v_TR_13_mv_c_i - 0.195050766618117*v_TR_13_mv_c_r
        struct[0].g[169,0] = i_TR_13_lv_a_i + 435.745709926008*v_INV_13_a_i - 225.774979236273*v_INV_13_a_r - 124.498774264574*v_INV_13_b_i + 64.5071369246495*v_INV_13_b_r - 124.498774264574*v_INV_13_c_i + 64.5071369246495*v_INV_13_c_r - 452.6376018179*v_TR_13_lv_a_i + 327.126282868141*v_TR_13_lv_a_r + 124.498774264574*v_TR_13_lv_b_i - 64.5071560124429*v_TR_13_lv_b_r + 124.498774264574*v_TR_13_lv_c_i - 64.5071560124428*v_TR_13_lv_c_r + 0.195050766618117*v_TR_13_mv_a_i - 1.1703045997087*v_TR_13_mv_a_r - 0.195050766618117*v_TR_13_mv_c_i + 1.1703045997087*v_TR_13_mv_c_r
        struct[0].g[170,0] = i_TR_13_lv_b_r - 64.5071369246495*v_INV_13_a_i - 124.498774264574*v_INV_13_a_r + 225.774979236273*v_INV_13_b_i + 435.745709926008*v_INV_13_b_r - 64.5071369246494*v_INV_13_c_i - 124.498774264574*v_INV_13_c_r + 64.5071560124428*v_TR_13_lv_a_i + 124.498774264574*v_TR_13_lv_a_r - 327.126282868141*v_TR_13_lv_b_i - 452.6376018179*v_TR_13_lv_b_r + 64.5071560124428*v_TR_13_lv_c_i + 124.498774264574*v_TR_13_lv_c_r - 1.1703045997087*v_TR_13_mv_a_i - 0.195050766618117*v_TR_13_mv_a_r + 1.1703045997087*v_TR_13_mv_b_i + 0.195050766618117*v_TR_13_mv_b_r
        struct[0].g[171,0] = i_TR_13_lv_b_i - 124.498774264574*v_INV_13_a_i + 64.5071369246495*v_INV_13_a_r + 435.745709926008*v_INV_13_b_i - 225.774979236273*v_INV_13_b_r - 124.498774264574*v_INV_13_c_i + 64.5071369246494*v_INV_13_c_r + 124.498774264574*v_TR_13_lv_a_i - 64.5071560124428*v_TR_13_lv_a_r - 452.6376018179*v_TR_13_lv_b_i + 327.126282868141*v_TR_13_lv_b_r + 124.498774264574*v_TR_13_lv_c_i - 64.5071560124428*v_TR_13_lv_c_r - 0.195050766618117*v_TR_13_mv_a_i + 1.1703045997087*v_TR_13_mv_a_r + 0.195050766618117*v_TR_13_mv_b_i - 1.1703045997087*v_TR_13_mv_b_r
        struct[0].g[172,0] = i_TR_13_lv_c_r - 64.5071369246495*v_INV_13_a_i - 124.498774264574*v_INV_13_a_r - 64.5071369246494*v_INV_13_b_i - 124.498774264574*v_INV_13_b_r + 225.774979236273*v_INV_13_c_i + 435.745709926008*v_INV_13_c_r + 64.5071560124429*v_TR_13_lv_a_i + 124.498774264574*v_TR_13_lv_a_r + 64.5071560124428*v_TR_13_lv_b_i + 124.498774264574*v_TR_13_lv_b_r - 327.126282868141*v_TR_13_lv_c_i - 452.6376018179*v_TR_13_lv_c_r - 1.1703045997087*v_TR_13_mv_b_i - 0.195050766618117*v_TR_13_mv_b_r + 1.1703045997087*v_TR_13_mv_c_i + 0.195050766618117*v_TR_13_mv_c_r
        struct[0].g[173,0] = i_TR_13_lv_c_i - 124.498774264574*v_INV_13_a_i + 64.5071369246495*v_INV_13_a_r - 124.498774264574*v_INV_13_b_i + 64.5071369246494*v_INV_13_b_r + 435.745709926008*v_INV_13_c_i - 225.774979236273*v_INV_13_c_r + 124.498774264574*v_TR_13_lv_a_i - 64.5071560124429*v_TR_13_lv_a_r + 124.498774264574*v_TR_13_lv_b_i - 64.5071560124428*v_TR_13_lv_b_r - 452.6376018179*v_TR_13_lv_c_i + 327.126282868141*v_TR_13_lv_c_r - 0.195050766618117*v_TR_13_mv_b_i + 1.1703045997087*v_TR_13_mv_b_r + 0.195050766618117*v_TR_13_mv_c_i - 1.1703045997087*v_TR_13_mv_c_r
        struct[0].g[174,0] = i_INV_1_a_i*v_INV_1_a_i + i_INV_1_a_r*v_INV_1_a_r - p_INV_1_a
        struct[0].g[175,0] = i_INV_1_b_i*v_INV_1_b_i + i_INV_1_b_r*v_INV_1_b_r - p_INV_1_b
        struct[0].g[176,0] = i_INV_1_c_i*v_INV_1_c_i + i_INV_1_c_r*v_INV_1_c_r - p_INV_1_c
        struct[0].g[177,0] = -i_INV_1_a_i*v_INV_1_a_r + i_INV_1_a_r*v_INV_1_a_i - q_INV_1_a
        struct[0].g[178,0] = -i_INV_1_b_i*v_INV_1_b_r + i_INV_1_b_r*v_INV_1_b_i - q_INV_1_b
        struct[0].g[179,0] = -i_INV_1_c_i*v_INV_1_c_r + i_INV_1_c_r*v_INV_1_c_i - q_INV_1_c
        struct[0].g[180,0] = -v_m_INV_1 + (v_INV_1_a_i**2 + v_INV_1_a_r**2)**0.5/V_base_INV_1
        struct[0].g[181,0] = -v_m_TR_1_2_mv + (v_TR_1_2_mv_a_i**2 + v_TR_1_2_mv_a_r**2)**0.5/V_base_TR_1_2_mv
        struct[0].g[182,0] = Dq_r_INV_1 + K_p_v_INV_1*(Dv_r_INV_1 - u_ctrl_v_INV_1*v_m_TR_1_2_mv + v_loc_ref_INV_1 - v_m_INV_1*(1.0 - u_ctrl_v_INV_1)) - i_reac_ref_INV_1
        struct[0].g[183,0] = S_base_INV_1*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_1, I_max_INV_1 < -i_reac_ref_INV_1), (I_max_INV_1, I_max_INV_1 < i_reac_ref_INV_1), (i_reac_ref_INV_1, True)])) - q_ref_INV_1
        struct[0].g[184,0] = i_INV_2_a_i*v_INV_2_a_i + i_INV_2_a_r*v_INV_2_a_r - p_INV_2_a
        struct[0].g[185,0] = i_INV_2_b_i*v_INV_2_b_i + i_INV_2_b_r*v_INV_2_b_r - p_INV_2_b
        struct[0].g[186,0] = i_INV_2_c_i*v_INV_2_c_i + i_INV_2_c_r*v_INV_2_c_r - p_INV_2_c
        struct[0].g[187,0] = -i_INV_2_a_i*v_INV_2_a_r + i_INV_2_a_r*v_INV_2_a_i - q_INV_2_a
        struct[0].g[188,0] = -i_INV_2_b_i*v_INV_2_b_r + i_INV_2_b_r*v_INV_2_b_i - q_INV_2_b
        struct[0].g[189,0] = -i_INV_2_c_i*v_INV_2_c_r + i_INV_2_c_r*v_INV_2_c_i - q_INV_2_c
        struct[0].g[190,0] = -v_m_INV_2 + (v_INV_2_a_i**2 + v_INV_2_a_r**2)**0.5/V_base_INV_2
        struct[0].g[191,0] = Dq_r_INV_2 + K_p_v_INV_2*(Dv_r_INV_2 - u_ctrl_v_INV_2*v_m_TR_1_2_mv + v_loc_ref_INV_2 - v_m_INV_2*(1.0 - u_ctrl_v_INV_2)) - i_reac_ref_INV_2
        struct[0].g[192,0] = S_base_INV_2*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_2, I_max_INV_2 < -i_reac_ref_INV_2), (I_max_INV_2, I_max_INV_2 < i_reac_ref_INV_2), (i_reac_ref_INV_2, True)])) - q_ref_INV_2
        struct[0].g[193,0] = i_INV_3_a_i*v_INV_3_a_i + i_INV_3_a_r*v_INV_3_a_r - p_INV_3_a
        struct[0].g[194,0] = i_INV_3_b_i*v_INV_3_b_i + i_INV_3_b_r*v_INV_3_b_r - p_INV_3_b
        struct[0].g[195,0] = i_INV_3_c_i*v_INV_3_c_i + i_INV_3_c_r*v_INV_3_c_r - p_INV_3_c
        struct[0].g[196,0] = -i_INV_3_a_i*v_INV_3_a_r + i_INV_3_a_r*v_INV_3_a_i - q_INV_3_a
        struct[0].g[197,0] = -i_INV_3_b_i*v_INV_3_b_r + i_INV_3_b_r*v_INV_3_b_i - q_INV_3_b
        struct[0].g[198,0] = -i_INV_3_c_i*v_INV_3_c_r + i_INV_3_c_r*v_INV_3_c_i - q_INV_3_c
        struct[0].g[199,0] = -v_m_INV_3 + (v_INV_3_a_i**2 + v_INV_3_a_r**2)**0.5/V_base_INV_3
        struct[0].g[200,0] = -v_m_TR_3_4_mv + (v_TR_3_4_mv_a_i**2 + v_TR_3_4_mv_a_r**2)**0.5/V_base_TR_3_4_mv
        struct[0].g[201,0] = Dq_r_INV_3 + K_p_v_INV_3*(Dv_r_INV_3 - u_ctrl_v_INV_3*v_m_TR_3_4_mv + v_loc_ref_INV_3 - v_m_INV_3*(1.0 - u_ctrl_v_INV_3)) - i_reac_ref_INV_3
        struct[0].g[202,0] = S_base_INV_3*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_3, I_max_INV_3 < -i_reac_ref_INV_3), (I_max_INV_3, I_max_INV_3 < i_reac_ref_INV_3), (i_reac_ref_INV_3, True)])) - q_ref_INV_3
        struct[0].g[203,0] = i_INV_4_a_i*v_INV_4_a_i + i_INV_4_a_r*v_INV_4_a_r - p_INV_4_a
        struct[0].g[204,0] = i_INV_4_b_i*v_INV_4_b_i + i_INV_4_b_r*v_INV_4_b_r - p_INV_4_b
        struct[0].g[205,0] = i_INV_4_c_i*v_INV_4_c_i + i_INV_4_c_r*v_INV_4_c_r - p_INV_4_c
        struct[0].g[206,0] = -i_INV_4_a_i*v_INV_4_a_r + i_INV_4_a_r*v_INV_4_a_i - q_INV_4_a
        struct[0].g[207,0] = -i_INV_4_b_i*v_INV_4_b_r + i_INV_4_b_r*v_INV_4_b_i - q_INV_4_b
        struct[0].g[208,0] = -i_INV_4_c_i*v_INV_4_c_r + i_INV_4_c_r*v_INV_4_c_i - q_INV_4_c
        struct[0].g[209,0] = -v_m_INV_4 + (v_INV_4_a_i**2 + v_INV_4_a_r**2)**0.5/V_base_INV_4
        struct[0].g[210,0] = Dq_r_INV_4 + K_p_v_INV_4*(Dv_r_INV_4 - u_ctrl_v_INV_4*v_m_TR_3_4_mv + v_loc_ref_INV_4 - v_m_INV_4*(1.0 - u_ctrl_v_INV_4)) - i_reac_ref_INV_4
        struct[0].g[211,0] = S_base_INV_4*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_4, I_max_INV_4 < -i_reac_ref_INV_4), (I_max_INV_4, I_max_INV_4 < i_reac_ref_INV_4), (i_reac_ref_INV_4, True)])) - q_ref_INV_4
        struct[0].g[212,0] = i_INV_5_a_i*v_INV_5_a_i + i_INV_5_a_r*v_INV_5_a_r - p_INV_5_a
        struct[0].g[213,0] = i_INV_5_b_i*v_INV_5_b_i + i_INV_5_b_r*v_INV_5_b_r - p_INV_5_b
        struct[0].g[214,0] = i_INV_5_c_i*v_INV_5_c_i + i_INV_5_c_r*v_INV_5_c_r - p_INV_5_c
        struct[0].g[215,0] = -i_INV_5_a_i*v_INV_5_a_r + i_INV_5_a_r*v_INV_5_a_i - q_INV_5_a
        struct[0].g[216,0] = -i_INV_5_b_i*v_INV_5_b_r + i_INV_5_b_r*v_INV_5_b_i - q_INV_5_b
        struct[0].g[217,0] = -i_INV_5_c_i*v_INV_5_c_r + i_INV_5_c_r*v_INV_5_c_i - q_INV_5_c
        struct[0].g[218,0] = -v_m_INV_5 + (v_INV_5_a_i**2 + v_INV_5_a_r**2)**0.5/V_base_INV_5
        struct[0].g[219,0] = -v_m_TR_5_6_mv + (v_TR_5_6_mv_a_i**2 + v_TR_5_6_mv_a_r**2)**0.5/V_base_TR_5_6_mv
        struct[0].g[220,0] = Dq_r_INV_5 + K_p_v_INV_5*(Dv_r_INV_5 - u_ctrl_v_INV_5*v_m_TR_5_6_mv + v_loc_ref_INV_5 - v_m_INV_5*(1.0 - u_ctrl_v_INV_5)) - i_reac_ref_INV_5
        struct[0].g[221,0] = S_base_INV_5*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_5, I_max_INV_5 < -i_reac_ref_INV_5), (I_max_INV_5, I_max_INV_5 < i_reac_ref_INV_5), (i_reac_ref_INV_5, True)])) - q_ref_INV_5
        struct[0].g[222,0] = i_INV_6_a_i*v_INV_6_a_i + i_INV_6_a_r*v_INV_6_a_r - p_INV_6_a
        struct[0].g[223,0] = i_INV_6_b_i*v_INV_6_b_i + i_INV_6_b_r*v_INV_6_b_r - p_INV_6_b
        struct[0].g[224,0] = i_INV_6_c_i*v_INV_6_c_i + i_INV_6_c_r*v_INV_6_c_r - p_INV_6_c
        struct[0].g[225,0] = -i_INV_6_a_i*v_INV_6_a_r + i_INV_6_a_r*v_INV_6_a_i - q_INV_6_a
        struct[0].g[226,0] = -i_INV_6_b_i*v_INV_6_b_r + i_INV_6_b_r*v_INV_6_b_i - q_INV_6_b
        struct[0].g[227,0] = -i_INV_6_c_i*v_INV_6_c_r + i_INV_6_c_r*v_INV_6_c_i - q_INV_6_c
        struct[0].g[228,0] = -v_m_INV_6 + (v_INV_6_a_i**2 + v_INV_6_a_r**2)**0.5/V_base_INV_6
        struct[0].g[229,0] = Dq_r_INV_6 + K_p_v_INV_6*(Dv_r_INV_6 - u_ctrl_v_INV_6*v_m_TR_5_6_mv + v_loc_ref_INV_6 - v_m_INV_6*(1.0 - u_ctrl_v_INV_6)) - i_reac_ref_INV_6
        struct[0].g[230,0] = S_base_INV_6*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_6, I_max_INV_6 < -i_reac_ref_INV_6), (I_max_INV_6, I_max_INV_6 < i_reac_ref_INV_6), (i_reac_ref_INV_6, True)])) - q_ref_INV_6
        struct[0].g[231,0] = i_INV_7_a_i*v_INV_7_a_i + i_INV_7_a_r*v_INV_7_a_r - p_INV_7_a
        struct[0].g[232,0] = i_INV_7_b_i*v_INV_7_b_i + i_INV_7_b_r*v_INV_7_b_r - p_INV_7_b
        struct[0].g[233,0] = i_INV_7_c_i*v_INV_7_c_i + i_INV_7_c_r*v_INV_7_c_r - p_INV_7_c
        struct[0].g[234,0] = -i_INV_7_a_i*v_INV_7_a_r + i_INV_7_a_r*v_INV_7_a_i - q_INV_7_a
        struct[0].g[235,0] = -i_INV_7_b_i*v_INV_7_b_r + i_INV_7_b_r*v_INV_7_b_i - q_INV_7_b
        struct[0].g[236,0] = -i_INV_7_c_i*v_INV_7_c_r + i_INV_7_c_r*v_INV_7_c_i - q_INV_7_c
        struct[0].g[237,0] = -v_m_INV_7 + (v_INV_7_a_i**2 + v_INV_7_a_r**2)**0.5/V_base_INV_7
        struct[0].g[238,0] = -v_m_TR_7_8_mv + (v_TR_7_8_mv_a_i**2 + v_TR_7_8_mv_a_r**2)**0.5/V_base_TR_7_8_mv
        struct[0].g[239,0] = Dq_r_INV_7 + K_p_v_INV_7*(Dv_r_INV_7 - u_ctrl_v_INV_7*v_m_TR_7_8_mv + v_loc_ref_INV_7 - v_m_INV_7*(1.0 - u_ctrl_v_INV_7)) - i_reac_ref_INV_7
        struct[0].g[240,0] = S_base_INV_7*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_7, I_max_INV_7 < -i_reac_ref_INV_7), (I_max_INV_7, I_max_INV_7 < i_reac_ref_INV_7), (i_reac_ref_INV_7, True)])) - q_ref_INV_7
        struct[0].g[241,0] = i_INV_8_a_i*v_INV_8_a_i + i_INV_8_a_r*v_INV_8_a_r - p_INV_8_a
        struct[0].g[242,0] = i_INV_8_b_i*v_INV_8_b_i + i_INV_8_b_r*v_INV_8_b_r - p_INV_8_b
        struct[0].g[243,0] = i_INV_8_c_i*v_INV_8_c_i + i_INV_8_c_r*v_INV_8_c_r - p_INV_8_c
        struct[0].g[244,0] = -i_INV_8_a_i*v_INV_8_a_r + i_INV_8_a_r*v_INV_8_a_i - q_INV_8_a
        struct[0].g[245,0] = -i_INV_8_b_i*v_INV_8_b_r + i_INV_8_b_r*v_INV_8_b_i - q_INV_8_b
        struct[0].g[246,0] = -i_INV_8_c_i*v_INV_8_c_r + i_INV_8_c_r*v_INV_8_c_i - q_INV_8_c
        struct[0].g[247,0] = -v_m_INV_8 + (v_INV_8_a_i**2 + v_INV_8_a_r**2)**0.5/V_base_INV_8
        struct[0].g[248,0] = Dq_r_INV_8 + K_p_v_INV_8*(Dv_r_INV_8 - u_ctrl_v_INV_8*v_m_TR_7_8_mv + v_loc_ref_INV_8 - v_m_INV_8*(1.0 - u_ctrl_v_INV_8)) - i_reac_ref_INV_8
        struct[0].g[249,0] = S_base_INV_8*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_8, I_max_INV_8 < -i_reac_ref_INV_8), (I_max_INV_8, I_max_INV_8 < i_reac_ref_INV_8), (i_reac_ref_INV_8, True)])) - q_ref_INV_8
        struct[0].g[250,0] = i_INV_9_a_i*v_INV_9_a_i + i_INV_9_a_r*v_INV_9_a_r - p_INV_9_a
        struct[0].g[251,0] = i_INV_9_b_i*v_INV_9_b_i + i_INV_9_b_r*v_INV_9_b_r - p_INV_9_b
        struct[0].g[252,0] = i_INV_9_c_i*v_INV_9_c_i + i_INV_9_c_r*v_INV_9_c_r - p_INV_9_c
        struct[0].g[253,0] = -i_INV_9_a_i*v_INV_9_a_r + i_INV_9_a_r*v_INV_9_a_i - q_INV_9_a
        struct[0].g[254,0] = -i_INV_9_b_i*v_INV_9_b_r + i_INV_9_b_r*v_INV_9_b_i - q_INV_9_b
        struct[0].g[255,0] = -i_INV_9_c_i*v_INV_9_c_r + i_INV_9_c_r*v_INV_9_c_i - q_INV_9_c
        struct[0].g[256,0] = -v_m_INV_9 + (v_INV_9_a_i**2 + v_INV_9_a_r**2)**0.5/V_base_INV_9
        struct[0].g[257,0] = -v_m_TR_9_10_mv + (v_TR_9_10_mv_a_i**2 + v_TR_9_10_mv_a_r**2)**0.5/V_base_TR_9_10_mv
        struct[0].g[258,0] = Dq_r_INV_9 + K_p_v_INV_9*(Dv_r_INV_9 - u_ctrl_v_INV_9*v_m_TR_9_10_mv + v_loc_ref_INV_9 - v_m_INV_9*(1.0 - u_ctrl_v_INV_9)) - i_reac_ref_INV_9
        struct[0].g[259,0] = S_base_INV_9*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_9, I_max_INV_9 < -i_reac_ref_INV_9), (I_max_INV_9, I_max_INV_9 < i_reac_ref_INV_9), (i_reac_ref_INV_9, True)])) - q_ref_INV_9
        struct[0].g[260,0] = i_INV_10_a_i*v_INV_10_a_i + i_INV_10_a_r*v_INV_10_a_r - p_INV_10_a
        struct[0].g[261,0] = i_INV_10_b_i*v_INV_10_b_i + i_INV_10_b_r*v_INV_10_b_r - p_INV_10_b
        struct[0].g[262,0] = i_INV_10_c_i*v_INV_10_c_i + i_INV_10_c_r*v_INV_10_c_r - p_INV_10_c
        struct[0].g[263,0] = -i_INV_10_a_i*v_INV_10_a_r + i_INV_10_a_r*v_INV_10_a_i - q_INV_10_a
        struct[0].g[264,0] = -i_INV_10_b_i*v_INV_10_b_r + i_INV_10_b_r*v_INV_10_b_i - q_INV_10_b
        struct[0].g[265,0] = -i_INV_10_c_i*v_INV_10_c_r + i_INV_10_c_r*v_INV_10_c_i - q_INV_10_c
        struct[0].g[266,0] = -v_m_INV_10 + (v_INV_10_a_i**2 + v_INV_10_a_r**2)**0.5/V_base_INV_10
        struct[0].g[267,0] = Dq_r_INV_10 + K_p_v_INV_10*(Dv_r_INV_10 - u_ctrl_v_INV_10*v_m_TR_9_10_mv + v_loc_ref_INV_10 - v_m_INV_10*(1.0 - u_ctrl_v_INV_10)) - i_reac_ref_INV_10
        struct[0].g[268,0] = S_base_INV_10*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_10, I_max_INV_10 < -i_reac_ref_INV_10), (I_max_INV_10, I_max_INV_10 < i_reac_ref_INV_10), (i_reac_ref_INV_10, True)])) - q_ref_INV_10
        struct[0].g[269,0] = i_INV_11_a_i*v_INV_11_a_i + i_INV_11_a_r*v_INV_11_a_r - p_INV_11_a
        struct[0].g[270,0] = i_INV_11_b_i*v_INV_11_b_i + i_INV_11_b_r*v_INV_11_b_r - p_INV_11_b
        struct[0].g[271,0] = i_INV_11_c_i*v_INV_11_c_i + i_INV_11_c_r*v_INV_11_c_r - p_INV_11_c
        struct[0].g[272,0] = -i_INV_11_a_i*v_INV_11_a_r + i_INV_11_a_r*v_INV_11_a_i - q_INV_11_a
        struct[0].g[273,0] = -i_INV_11_b_i*v_INV_11_b_r + i_INV_11_b_r*v_INV_11_b_i - q_INV_11_b
        struct[0].g[274,0] = -i_INV_11_c_i*v_INV_11_c_r + i_INV_11_c_r*v_INV_11_c_i - q_INV_11_c
        struct[0].g[275,0] = -v_m_INV_11 + (v_INV_11_a_i**2 + v_INV_11_a_r**2)**0.5/V_base_INV_11
        struct[0].g[276,0] = -v_m_TR_11_12_mv + (v_TR_11_12_mv_a_i**2 + v_TR_11_12_mv_a_r**2)**0.5/V_base_TR_11_12_mv
        struct[0].g[277,0] = Dq_r_INV_11 + K_p_v_INV_11*(Dv_r_INV_11 - u_ctrl_v_INV_11*v_m_TR_11_12_mv + v_loc_ref_INV_11 - v_m_INV_11*(1.0 - u_ctrl_v_INV_11)) - i_reac_ref_INV_11
        struct[0].g[278,0] = S_base_INV_11*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_11, I_max_INV_11 < -i_reac_ref_INV_11), (I_max_INV_11, I_max_INV_11 < i_reac_ref_INV_11), (i_reac_ref_INV_11, True)])) - q_ref_INV_11
        struct[0].g[279,0] = i_INV_12_a_i*v_INV_12_a_i + i_INV_12_a_r*v_INV_12_a_r - p_INV_12_a
        struct[0].g[280,0] = i_INV_12_b_i*v_INV_12_b_i + i_INV_12_b_r*v_INV_12_b_r - p_INV_12_b
        struct[0].g[281,0] = i_INV_12_c_i*v_INV_12_c_i + i_INV_12_c_r*v_INV_12_c_r - p_INV_12_c
        struct[0].g[282,0] = -i_INV_12_a_i*v_INV_12_a_r + i_INV_12_a_r*v_INV_12_a_i - q_INV_12_a
        struct[0].g[283,0] = -i_INV_12_b_i*v_INV_12_b_r + i_INV_12_b_r*v_INV_12_b_i - q_INV_12_b
        struct[0].g[284,0] = -i_INV_12_c_i*v_INV_12_c_r + i_INV_12_c_r*v_INV_12_c_i - q_INV_12_c
        struct[0].g[285,0] = -v_m_INV_12 + (v_INV_12_a_i**2 + v_INV_12_a_r**2)**0.5/V_base_INV_12
        struct[0].g[286,0] = Dq_r_INV_12 + K_p_v_INV_12*(Dv_r_INV_12 - u_ctrl_v_INV_12*v_m_TR_11_12_mv + v_loc_ref_INV_12 - v_m_INV_12*(1.0 - u_ctrl_v_INV_12)) - i_reac_ref_INV_12
        struct[0].g[287,0] = S_base_INV_12*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_12, I_max_INV_12 < -i_reac_ref_INV_12), (I_max_INV_12, I_max_INV_12 < i_reac_ref_INV_12), (i_reac_ref_INV_12, True)])) - q_ref_INV_12
        struct[0].g[288,0] = i_INV_13_a_i*v_INV_13_a_i + i_INV_13_a_r*v_INV_13_a_r - p_INV_13_a
        struct[0].g[289,0] = i_INV_13_b_i*v_INV_13_b_i + i_INV_13_b_r*v_INV_13_b_r - p_INV_13_b
        struct[0].g[290,0] = i_INV_13_c_i*v_INV_13_c_i + i_INV_13_c_r*v_INV_13_c_r - p_INV_13_c
        struct[0].g[291,0] = -i_INV_13_a_i*v_INV_13_a_r + i_INV_13_a_r*v_INV_13_a_i - q_INV_13_a
        struct[0].g[292,0] = -i_INV_13_b_i*v_INV_13_b_r + i_INV_13_b_r*v_INV_13_b_i - q_INV_13_b
        struct[0].g[293,0] = -i_INV_13_c_i*v_INV_13_c_r + i_INV_13_c_r*v_INV_13_c_i - q_INV_13_c
        struct[0].g[294,0] = -v_m_INV_13 + (v_INV_13_a_i**2 + v_INV_13_a_r**2)**0.5/V_base_INV_13
        struct[0].g[295,0] = -v_m_TR_13_mv + (v_TR_13_mv_a_i**2 + v_TR_13_mv_a_r**2)**0.5/V_base_TR_13_mv
        struct[0].g[296,0] = Dq_r_INV_13 + K_p_v_INV_13*(Dv_r_INV_13 - u_ctrl_v_INV_13*v_m_TR_13_mv + v_loc_ref_INV_13 - v_m_INV_13*(1.0 - u_ctrl_v_INV_13)) - i_reac_ref_INV_13
        struct[0].g[297,0] = S_base_INV_13*(v_TR_13_lv_c_i**2 + v_TR_13_lv_c_r**2)**0.5*Piecewise(np.array([(-I_max_INV_13, I_max_INV_13 < -i_reac_ref_INV_13), (I_max_INV_13, I_max_INV_13 < i_reac_ref_INV_13), (i_reac_ref_INV_13, True)])) - q_ref_INV_13
    
    # Outputs:
    if mode == 3:

    
        pass

    if mode == 10:

        struct[0].Fx[0,0] = -1/T_pq_INV_1
        struct[0].Fx[1,1] = -1/T_pq_INV_1
        struct[0].Fx[2,2] = -1/T_pq_INV_1
        struct[0].Fx[3,3] = -1/T_pq_INV_1
        struct[0].Fx[4,4] = -1/T_pq_INV_1
        struct[0].Fx[5,5] = -1/T_pq_INV_1
        struct[0].Fx[6,6] = -1/T_pq_INV_2
        struct[0].Fx[7,7] = -1/T_pq_INV_2
        struct[0].Fx[8,8] = -1/T_pq_INV_2
        struct[0].Fx[9,9] = -1/T_pq_INV_2
        struct[0].Fx[10,10] = -1/T_pq_INV_2
        struct[0].Fx[11,11] = -1/T_pq_INV_2
        struct[0].Fx[12,12] = -1/T_pq_INV_3
        struct[0].Fx[13,13] = -1/T_pq_INV_3
        struct[0].Fx[14,14] = -1/T_pq_INV_3
        struct[0].Fx[15,15] = -1/T_pq_INV_3
        struct[0].Fx[16,16] = -1/T_pq_INV_3
        struct[0].Fx[17,17] = -1/T_pq_INV_3
        struct[0].Fx[18,18] = -1/T_pq_INV_4
        struct[0].Fx[19,19] = -1/T_pq_INV_4
        struct[0].Fx[20,20] = -1/T_pq_INV_4
        struct[0].Fx[21,21] = -1/T_pq_INV_4
        struct[0].Fx[22,22] = -1/T_pq_INV_4
        struct[0].Fx[23,23] = -1/T_pq_INV_4
        struct[0].Fx[24,24] = -1/T_pq_INV_5
        struct[0].Fx[25,25] = -1/T_pq_INV_5
        struct[0].Fx[26,26] = -1/T_pq_INV_5
        struct[0].Fx[27,27] = -1/T_pq_INV_5
        struct[0].Fx[28,28] = -1/T_pq_INV_5
        struct[0].Fx[29,29] = -1/T_pq_INV_5
        struct[0].Fx[30,30] = -1/T_pq_INV_6
        struct[0].Fx[31,31] = -1/T_pq_INV_6
        struct[0].Fx[32,32] = -1/T_pq_INV_6
        struct[0].Fx[33,33] = -1/T_pq_INV_6
        struct[0].Fx[34,34] = -1/T_pq_INV_6
        struct[0].Fx[35,35] = -1/T_pq_INV_6
        struct[0].Fx[36,36] = -1/T_pq_INV_7
        struct[0].Fx[37,37] = -1/T_pq_INV_7
        struct[0].Fx[38,38] = -1/T_pq_INV_7
        struct[0].Fx[39,39] = -1/T_pq_INV_7
        struct[0].Fx[40,40] = -1/T_pq_INV_7
        struct[0].Fx[41,41] = -1/T_pq_INV_7
        struct[0].Fx[42,42] = -1/T_pq_INV_8
        struct[0].Fx[43,43] = -1/T_pq_INV_8
        struct[0].Fx[44,44] = -1/T_pq_INV_8
        struct[0].Fx[45,45] = -1/T_pq_INV_8
        struct[0].Fx[46,46] = -1/T_pq_INV_8
        struct[0].Fx[47,47] = -1/T_pq_INV_8
        struct[0].Fx[48,48] = -1/T_pq_INV_9
        struct[0].Fx[49,49] = -1/T_pq_INV_9
        struct[0].Fx[50,50] = -1/T_pq_INV_9
        struct[0].Fx[51,51] = -1/T_pq_INV_9
        struct[0].Fx[52,52] = -1/T_pq_INV_9
        struct[0].Fx[53,53] = -1/T_pq_INV_9
        struct[0].Fx[54,54] = -1/T_pq_INV_10
        struct[0].Fx[55,55] = -1/T_pq_INV_10
        struct[0].Fx[56,56] = -1/T_pq_INV_10
        struct[0].Fx[57,57] = -1/T_pq_INV_10
        struct[0].Fx[58,58] = -1/T_pq_INV_10
        struct[0].Fx[59,59] = -1/T_pq_INV_10
        struct[0].Fx[60,60] = -1/T_pq_INV_11
        struct[0].Fx[61,61] = -1/T_pq_INV_11
        struct[0].Fx[62,62] = -1/T_pq_INV_11
        struct[0].Fx[63,63] = -1/T_pq_INV_11
        struct[0].Fx[64,64] = -1/T_pq_INV_11
        struct[0].Fx[65,65] = -1/T_pq_INV_11
        struct[0].Fx[66,66] = -1/T_pq_INV_12
        struct[0].Fx[67,67] = -1/T_pq_INV_12
        struct[0].Fx[68,68] = -1/T_pq_INV_12
        struct[0].Fx[69,69] = -1/T_pq_INV_12
        struct[0].Fx[70,70] = -1/T_pq_INV_12
        struct[0].Fx[71,71] = -1/T_pq_INV_12
        struct[0].Fx[72,72] = -1/T_pq_INV_13
        struct[0].Fx[73,73] = -1/T_pq_INV_13
        struct[0].Fx[74,74] = -1/T_pq_INV_13
        struct[0].Fx[75,75] = -1/T_pq_INV_13
        struct[0].Fx[76,76] = -1/T_pq_INV_13
        struct[0].Fx[77,77] = -1/T_pq_INV_13

    if mode == 11:

        struct[0].Fy[3,183] = 1/(3*T_pq_INV_1)
        struct[0].Fy[4,183] = 1/(3*T_pq_INV_1)
        struct[0].Fy[5,183] = 1/(3*T_pq_INV_1)
        struct[0].Fy[9,192] = 1/(3*T_pq_INV_2)
        struct[0].Fy[10,192] = 1/(3*T_pq_INV_2)
        struct[0].Fy[11,192] = 1/(3*T_pq_INV_2)
        struct[0].Fy[15,202] = 1/(3*T_pq_INV_3)
        struct[0].Fy[16,202] = 1/(3*T_pq_INV_3)
        struct[0].Fy[17,202] = 1/(3*T_pq_INV_3)
        struct[0].Fy[21,211] = 1/(3*T_pq_INV_4)
        struct[0].Fy[22,211] = 1/(3*T_pq_INV_4)
        struct[0].Fy[23,211] = 1/(3*T_pq_INV_4)
        struct[0].Fy[27,221] = 1/(3*T_pq_INV_5)
        struct[0].Fy[28,221] = 1/(3*T_pq_INV_5)
        struct[0].Fy[29,221] = 1/(3*T_pq_INV_5)
        struct[0].Fy[33,230] = 1/(3*T_pq_INV_6)
        struct[0].Fy[34,230] = 1/(3*T_pq_INV_6)
        struct[0].Fy[35,230] = 1/(3*T_pq_INV_6)
        struct[0].Fy[39,240] = 1/(3*T_pq_INV_7)
        struct[0].Fy[40,240] = 1/(3*T_pq_INV_7)
        struct[0].Fy[41,240] = 1/(3*T_pq_INV_7)
        struct[0].Fy[45,249] = 1/(3*T_pq_INV_8)
        struct[0].Fy[46,249] = 1/(3*T_pq_INV_8)
        struct[0].Fy[47,249] = 1/(3*T_pq_INV_8)
        struct[0].Fy[51,259] = 1/(3*T_pq_INV_9)
        struct[0].Fy[52,259] = 1/(3*T_pq_INV_9)
        struct[0].Fy[53,259] = 1/(3*T_pq_INV_9)
        struct[0].Fy[57,268] = 1/(3*T_pq_INV_10)
        struct[0].Fy[58,268] = 1/(3*T_pq_INV_10)
        struct[0].Fy[59,268] = 1/(3*T_pq_INV_10)
        struct[0].Fy[63,278] = 1/(3*T_pq_INV_11)
        struct[0].Fy[64,278] = 1/(3*T_pq_INV_11)
        struct[0].Fy[65,278] = 1/(3*T_pq_INV_11)
        struct[0].Fy[69,287] = 1/(3*T_pq_INV_12)
        struct[0].Fy[70,287] = 1/(3*T_pq_INV_12)
        struct[0].Fy[71,287] = 1/(3*T_pq_INV_12)
        struct[0].Fy[75,297] = 1/(3*T_pq_INV_13)
        struct[0].Fy[76,297] = 1/(3*T_pq_INV_13)
        struct[0].Fy[77,297] = 1/(3*T_pq_INV_13)

        struct[0].Gy[0,0] = -172.823911824540
        struct[0].Gy[0,1] = -89.5459479864169
        struct[0].Gy[0,2] = 49.3782605212972
        struct[0].Gy[0,3] = 25.5846390702588
        struct[0].Gy[0,4] = 49.3782605212972
        struct[0].Gy[0,5] = 25.5846390702587
        struct[0].Gy[0,96] = 172.823911824540
        struct[0].Gy[0,97] = 89.5460683028705
        struct[0].Gy[0,98] = -49.3782605212972
        struct[0].Gy[0,99] = -25.5845909436773
        struct[0].Gy[0,100] = -49.3782605212972
        struct[0].Gy[0,101] = -25.5845909436773
        struct[0].Gy[0,174] = 1
        struct[0].Gy[1,0] = 89.5459479864169
        struct[0].Gy[1,1] = -172.823911824540
        struct[0].Gy[1,2] = -25.5846390702588
        struct[0].Gy[1,3] = 49.3782605212972
        struct[0].Gy[1,4] = -25.5846390702587
        struct[0].Gy[1,5] = 49.3782605212972
        struct[0].Gy[1,96] = -89.5460683028705
        struct[0].Gy[1,97] = 172.823911824540
        struct[0].Gy[1,98] = 25.5845909436773
        struct[0].Gy[1,99] = -49.3782605212972
        struct[0].Gy[1,100] = 25.5845909436773
        struct[0].Gy[1,101] = -49.3782605212972
        struct[0].Gy[1,175] = 1
        struct[0].Gy[2,0] = 49.3782605212972
        struct[0].Gy[2,1] = 25.5846390702587
        struct[0].Gy[2,2] = -172.823911824540
        struct[0].Gy[2,3] = -89.5459479864168
        struct[0].Gy[2,4] = 49.3782605212973
        struct[0].Gy[2,5] = 25.5846390702587
        struct[0].Gy[2,96] = -49.3782605212972
        struct[0].Gy[2,97] = -25.5845909436773
        struct[0].Gy[2,98] = 172.823911824540
        struct[0].Gy[2,99] = 89.5460683028705
        struct[0].Gy[2,100] = -49.3782605212973
        struct[0].Gy[2,101] = -25.5845909436773
        struct[0].Gy[2,176] = 1
        struct[0].Gy[3,0] = -25.5846390702587
        struct[0].Gy[3,1] = 49.3782605212972
        struct[0].Gy[3,2] = 89.5459479864168
        struct[0].Gy[3,3] = -172.823911824540
        struct[0].Gy[3,4] = -25.5846390702587
        struct[0].Gy[3,5] = 49.3782605212973
        struct[0].Gy[3,96] = 25.5845909436773
        struct[0].Gy[3,97] = -49.3782605212972
        struct[0].Gy[3,98] = -89.5460683028705
        struct[0].Gy[3,99] = 172.823911824540
        struct[0].Gy[3,100] = 25.5845909436773
        struct[0].Gy[3,101] = -49.3782605212973
        struct[0].Gy[3,177] = 1
        struct[0].Gy[4,0] = 49.3782605212972
        struct[0].Gy[4,1] = 25.5846390702588
        struct[0].Gy[4,2] = 49.3782605212973
        struct[0].Gy[4,3] = 25.5846390702587
        struct[0].Gy[4,4] = -172.823911824540
        struct[0].Gy[4,5] = -89.5459479864168
        struct[0].Gy[4,96] = -49.3782605212972
        struct[0].Gy[4,97] = -25.5845909436773
        struct[0].Gy[4,98] = -49.3782605212973
        struct[0].Gy[4,99] = -25.5845909436772
        struct[0].Gy[4,100] = 172.823911824540
        struct[0].Gy[4,101] = 89.5460683028705
        struct[0].Gy[4,178] = 1
        struct[0].Gy[5,0] = -25.5846390702588
        struct[0].Gy[5,1] = 49.3782605212972
        struct[0].Gy[5,2] = -25.5846390702587
        struct[0].Gy[5,3] = 49.3782605212973
        struct[0].Gy[5,4] = 89.5459479864168
        struct[0].Gy[5,5] = -172.823911824540
        struct[0].Gy[5,96] = 25.5845909436773
        struct[0].Gy[5,97] = -49.3782605212972
        struct[0].Gy[5,98] = 25.5845909436772
        struct[0].Gy[5,99] = -49.3782605212973
        struct[0].Gy[5,100] = -89.5460683028705
        struct[0].Gy[5,101] = 172.823911824540
        struct[0].Gy[5,179] = 1
        struct[0].Gy[6,6] = -188.838681114510
        struct[0].Gy[6,7] = -97.8437661123124
        struct[0].Gy[6,8] = 53.9539088898601
        struct[0].Gy[6,9] = 27.9554372523104
        struct[0].Gy[6,10] = 53.9539088898601
        struct[0].Gy[6,11] = 27.9554372523104
        struct[0].Gy[6,96] = 188.838681114510
        struct[0].Gy[6,97] = 97.8438762251349
        struct[0].Gy[6,98] = -53.9539088898601
        struct[0].Gy[6,99] = -27.9553932071814
        struct[0].Gy[6,100] = -53.9539088898601
        struct[0].Gy[6,101] = -27.9553932071814
        struct[0].Gy[6,184] = 1
        struct[0].Gy[7,6] = 97.8437661123124
        struct[0].Gy[7,7] = -188.838681114510
        struct[0].Gy[7,8] = -27.9554372523104
        struct[0].Gy[7,9] = 53.9539088898601
        struct[0].Gy[7,10] = -27.9554372523104
        struct[0].Gy[7,11] = 53.9539088898601
        struct[0].Gy[7,96] = -97.8438762251349
        struct[0].Gy[7,97] = 188.838681114510
        struct[0].Gy[7,98] = 27.9553932071814
        struct[0].Gy[7,99] = -53.9539088898601
        struct[0].Gy[7,100] = 27.9553932071814
        struct[0].Gy[7,101] = -53.9539088898601
        struct[0].Gy[7,185] = 1
        struct[0].Gy[8,6] = 53.9539088898601
        struct[0].Gy[8,7] = 27.9554372523104
        struct[0].Gy[8,8] = -188.838681114510
        struct[0].Gy[8,9] = -97.8437661123124
        struct[0].Gy[8,10] = 53.9539088898602
        struct[0].Gy[8,11] = 27.9554372523104
        struct[0].Gy[8,96] = -53.9539088898601
        struct[0].Gy[8,97] = -27.9553932071814
        struct[0].Gy[8,98] = 188.838681114510
        struct[0].Gy[8,99] = 97.8438762251349
        struct[0].Gy[8,100] = -53.9539088898602
        struct[0].Gy[8,101] = -27.9553932071814
        struct[0].Gy[8,186] = 1
        struct[0].Gy[9,6] = -27.9554372523104
        struct[0].Gy[9,7] = 53.9539088898601
        struct[0].Gy[9,8] = 97.8437661123124
        struct[0].Gy[9,9] = -188.838681114510
        struct[0].Gy[9,10] = -27.9554372523104
        struct[0].Gy[9,11] = 53.9539088898602
        struct[0].Gy[9,96] = 27.9553932071814
        struct[0].Gy[9,97] = -53.9539088898601
        struct[0].Gy[9,98] = -97.8438762251349
        struct[0].Gy[9,99] = 188.838681114510
        struct[0].Gy[9,100] = 27.9553932071814
        struct[0].Gy[9,101] = -53.9539088898602
        struct[0].Gy[9,187] = 1
        struct[0].Gy[10,6] = 53.9539088898601
        struct[0].Gy[10,7] = 27.9554372523104
        struct[0].Gy[10,8] = 53.9539088898602
        struct[0].Gy[10,9] = 27.9554372523103
        struct[0].Gy[10,10] = -188.838681114510
        struct[0].Gy[10,11] = -97.8437661123124
        struct[0].Gy[10,96] = -53.9539088898601
        struct[0].Gy[10,97] = -27.9553932071814
        struct[0].Gy[10,98] = -53.9539088898602
        struct[0].Gy[10,99] = -27.9553932071813
        struct[0].Gy[10,100] = 188.838681114510
        struct[0].Gy[10,101] = 97.8438762251349
        struct[0].Gy[10,188] = 1
        struct[0].Gy[11,6] = -27.9554372523104
        struct[0].Gy[11,7] = 53.9539088898601
        struct[0].Gy[11,8] = -27.9554372523103
        struct[0].Gy[11,9] = 53.9539088898602
        struct[0].Gy[11,10] = 97.8437661123124
        struct[0].Gy[11,11] = -188.838681114510
        struct[0].Gy[11,96] = 27.9553932071814
        struct[0].Gy[11,97] = -53.9539088898601
        struct[0].Gy[11,98] = 27.9553932071813
        struct[0].Gy[11,99] = -53.9539088898602
        struct[0].Gy[11,100] = -97.8438762251349
        struct[0].Gy[11,101] = 188.838681114510
        struct[0].Gy[11,189] = 1
        struct[0].Gy[12,12] = -207.974729711346
        struct[0].Gy[12,13] = -107.758827330392
        struct[0].Gy[12,14] = 59.4213513460989
        struct[0].Gy[12,15] = 30.7883049386397
        struct[0].Gy[12,16] = 59.4213513460989
        struct[0].Gy[12,17] = 30.7883049386397
        struct[0].Gy[12,108] = 207.974729711346
        struct[0].Gy[12,109] = 107.758927311578
        struct[0].Gy[12,110] = -59.4213513460989
        struct[0].Gy[12,111] = -30.7882649461652
        struct[0].Gy[12,112] = -59.4213513460989
        struct[0].Gy[12,113] = -30.7882649461652
        struct[0].Gy[12,193] = 1
        struct[0].Gy[13,12] = 107.758827330392
        struct[0].Gy[13,13] = -207.974729711346
        struct[0].Gy[13,14] = -30.7883049386397
        struct[0].Gy[13,15] = 59.4213513460989
        struct[0].Gy[13,16] = -30.7883049386397
        struct[0].Gy[13,17] = 59.4213513460989
        struct[0].Gy[13,108] = -107.758927311578
        struct[0].Gy[13,109] = 207.974729711346
        struct[0].Gy[13,110] = 30.7882649461652
        struct[0].Gy[13,111] = -59.4213513460989
        struct[0].Gy[13,112] = 30.7882649461652
        struct[0].Gy[13,113] = -59.4213513460989
        struct[0].Gy[13,194] = 1
        struct[0].Gy[14,12] = 59.4213513460989
        struct[0].Gy[14,13] = 30.7883049386397
        struct[0].Gy[14,14] = -207.974729711346
        struct[0].Gy[14,15] = -107.758827330392
        struct[0].Gy[14,16] = 59.4213513460990
        struct[0].Gy[14,17] = 30.7883049386396
        struct[0].Gy[14,108] = -59.4213513460989
        struct[0].Gy[14,109] = -30.7882649461652
        struct[0].Gy[14,110] = 207.974729711346
        struct[0].Gy[14,111] = 107.758927311578
        struct[0].Gy[14,112] = -59.4213513460990
        struct[0].Gy[14,113] = -30.7882649461651
        struct[0].Gy[14,195] = 1
        struct[0].Gy[15,12] = -30.7883049386397
        struct[0].Gy[15,13] = 59.4213513460989
        struct[0].Gy[15,14] = 107.758827330392
        struct[0].Gy[15,15] = -207.974729711346
        struct[0].Gy[15,16] = -30.7883049386396
        struct[0].Gy[15,17] = 59.4213513460990
        struct[0].Gy[15,108] = 30.7882649461652
        struct[0].Gy[15,109] = -59.4213513460989
        struct[0].Gy[15,110] = -107.758927311578
        struct[0].Gy[15,111] = 207.974729711346
        struct[0].Gy[15,112] = 30.7882649461651
        struct[0].Gy[15,113] = -59.4213513460990
        struct[0].Gy[15,196] = 1
        struct[0].Gy[16,12] = 59.4213513460989
        struct[0].Gy[16,13] = 30.7883049386397
        struct[0].Gy[16,14] = 59.4213513460990
        struct[0].Gy[16,15] = 30.7883049386396
        struct[0].Gy[16,16] = -207.974729711346
        struct[0].Gy[16,17] = -107.758827330392
        struct[0].Gy[16,108] = -59.4213513460989
        struct[0].Gy[16,109] = -30.7882649461652
        struct[0].Gy[16,110] = -59.4213513460990
        struct[0].Gy[16,111] = -30.7882649461651
        struct[0].Gy[16,112] = 207.974729711346
        struct[0].Gy[16,113] = 107.758927311578
        struct[0].Gy[16,197] = 1
        struct[0].Gy[17,12] = -30.7883049386397
        struct[0].Gy[17,13] = 59.4213513460989
        struct[0].Gy[17,14] = -30.7883049386396
        struct[0].Gy[17,15] = 59.4213513460990
        struct[0].Gy[17,16] = 107.758827330392
        struct[0].Gy[17,17] = -207.974729711346
        struct[0].Gy[17,108] = 30.7882649461652
        struct[0].Gy[17,109] = -59.4213513460989
        struct[0].Gy[17,110] = 30.7882649461651
        struct[0].Gy[17,111] = -59.4213513460990
        struct[0].Gy[17,112] = -107.758927311578
        struct[0].Gy[17,113] = 207.974729711346
        struct[0].Gy[17,198] = 1
        struct[0].Gy[18,18] = -112.816376232042
        struct[0].Gy[18,19] = -58.4538966359303
        struct[0].Gy[18,20] = 32.2332503520119
        struct[0].Gy[18,21] = 16.7012397108240
        struct[0].Gy[18,22] = 32.2332503520119
        struct[0].Gy[18,23] = 16.7012397108240
        struct[0].Gy[18,108] = 112.816376232042
        struct[0].Gy[18,109] = 58.4540809492443
        struct[0].Gy[18,110] = -32.2332503520119
        struct[0].Gy[18,111] = -16.7011659854984
        struct[0].Gy[18,112] = -32.2332503520119
        struct[0].Gy[18,113] = -16.7011659854984
        struct[0].Gy[18,203] = 1
        struct[0].Gy[19,18] = 58.4538966359303
        struct[0].Gy[19,19] = -112.816376232042
        struct[0].Gy[19,20] = -16.7012397108240
        struct[0].Gy[19,21] = 32.2332503520119
        struct[0].Gy[19,22] = -16.7012397108240
        struct[0].Gy[19,23] = 32.2332503520119
        struct[0].Gy[19,108] = -58.4540809492443
        struct[0].Gy[19,109] = 112.816376232042
        struct[0].Gy[19,110] = 16.7011659854984
        struct[0].Gy[19,111] = -32.2332503520119
        struct[0].Gy[19,112] = 16.7011659854984
        struct[0].Gy[19,113] = -32.2332503520119
        struct[0].Gy[19,204] = 1
        struct[0].Gy[20,18] = 32.2332503520119
        struct[0].Gy[20,19] = 16.7012397108240
        struct[0].Gy[20,20] = -112.816376232042
        struct[0].Gy[20,21] = -58.4538966359303
        struct[0].Gy[20,22] = 32.2332503520119
        struct[0].Gy[20,23] = 16.7012397108240
        struct[0].Gy[20,108] = -32.2332503520119
        struct[0].Gy[20,109] = -16.7011659854984
        struct[0].Gy[20,110] = 112.816376232042
        struct[0].Gy[20,111] = 58.4540809492443
        struct[0].Gy[20,112] = -32.2332503520119
        struct[0].Gy[20,113] = -16.7011659854984
        struct[0].Gy[20,205] = 1
        struct[0].Gy[21,18] = -16.7012397108240
        struct[0].Gy[21,19] = 32.2332503520119
        struct[0].Gy[21,20] = 58.4538966359303
        struct[0].Gy[21,21] = -112.816376232042
        struct[0].Gy[21,22] = -16.7012397108240
        struct[0].Gy[21,23] = 32.2332503520119
        struct[0].Gy[21,108] = 16.7011659854984
        struct[0].Gy[21,109] = -32.2332503520119
        struct[0].Gy[21,110] = -58.4540809492443
        struct[0].Gy[21,111] = 112.816376232042
        struct[0].Gy[21,112] = 16.7011659854984
        struct[0].Gy[21,113] = -32.2332503520119
        struct[0].Gy[21,206] = 1
        struct[0].Gy[22,18] = 32.2332503520119
        struct[0].Gy[22,19] = 16.7012397108240
        struct[0].Gy[22,20] = 32.2332503520119
        struct[0].Gy[22,21] = 16.7012397108239
        struct[0].Gy[22,22] = -112.816376232042
        struct[0].Gy[22,23] = -58.4538966359303
        struct[0].Gy[22,108] = -32.2332503520119
        struct[0].Gy[22,109] = -16.7011659854984
        struct[0].Gy[22,110] = -32.2332503520119
        struct[0].Gy[22,111] = -16.7011659854983
        struct[0].Gy[22,112] = 112.816376232042
        struct[0].Gy[22,113] = 58.4540809492443
        struct[0].Gy[22,207] = 1
        struct[0].Gy[23,18] = -16.7012397108240
        struct[0].Gy[23,19] = 32.2332503520119
        struct[0].Gy[23,20] = -16.7012397108239
        struct[0].Gy[23,21] = 32.2332503520119
        struct[0].Gy[23,22] = 58.4538966359303
        struct[0].Gy[23,23] = -112.816376232042
        struct[0].Gy[23,108] = 16.7011659854984
        struct[0].Gy[23,109] = -32.2332503520119
        struct[0].Gy[23,110] = 16.7011659854983
        struct[0].Gy[23,111] = -32.2332503520119
        struct[0].Gy[23,112] = -58.4540809492443
        struct[0].Gy[23,113] = 112.816376232042
        struct[0].Gy[23,208] = 1
        struct[0].Gy[24,24] = -178.886372244962
        struct[0].Gy[24,25] = -92.6871232662334
        struct[0].Gy[24,26] = 51.1103920699891
        struct[0].Gy[24,27] = 26.4821149256174
        struct[0].Gy[24,28] = 51.1103920699891
        struct[0].Gy[24,29] = 26.4821149256174
        struct[0].Gy[24,120] = 178.886372244962
        struct[0].Gy[24,121] = 92.6872395051616
        struct[0].Gy[24,122] = -51.1103920699891
        struct[0].Gy[24,123] = -26.4820684300462
        struct[0].Gy[24,124] = -51.1103920699891
        struct[0].Gy[24,125] = -26.4820684300462
        struct[0].Gy[24,212] = 1
        struct[0].Gy[25,24] = 92.6871232662334
        struct[0].Gy[25,25] = -178.886372244962
        struct[0].Gy[25,26] = -26.4821149256174
        struct[0].Gy[25,27] = 51.1103920699891
        struct[0].Gy[25,28] = -26.4821149256174
        struct[0].Gy[25,29] = 51.1103920699891
        struct[0].Gy[25,120] = -92.6872395051616
        struct[0].Gy[25,121] = 178.886372244962
        struct[0].Gy[25,122] = 26.4820684300462
        struct[0].Gy[25,123] = -51.1103920699891
        struct[0].Gy[25,124] = 26.4820684300462
        struct[0].Gy[25,125] = -51.1103920699891
        struct[0].Gy[25,213] = 1
        struct[0].Gy[26,24] = 51.1103920699891
        struct[0].Gy[26,25] = 26.4821149256174
        struct[0].Gy[26,26] = -178.886372244962
        struct[0].Gy[26,27] = -92.6871232662333
        struct[0].Gy[26,28] = 51.1103920699892
        struct[0].Gy[26,29] = 26.4821149256174
        struct[0].Gy[26,120] = -51.1103920699891
        struct[0].Gy[26,121] = -26.4820684300461
        struct[0].Gy[26,122] = 178.886372244962
        struct[0].Gy[26,123] = 92.6872395051615
        struct[0].Gy[26,124] = -51.1103920699892
        struct[0].Gy[26,125] = -26.4820684300461
        struct[0].Gy[26,214] = 1
        struct[0].Gy[27,24] = -26.4821149256174
        struct[0].Gy[27,25] = 51.1103920699891
        struct[0].Gy[27,26] = 92.6871232662333
        struct[0].Gy[27,27] = -178.886372244962
        struct[0].Gy[27,28] = -26.4821149256174
        struct[0].Gy[27,29] = 51.1103920699892
        struct[0].Gy[27,120] = 26.4820684300461
        struct[0].Gy[27,121] = -51.1103920699891
        struct[0].Gy[27,122] = -92.6872395051615
        struct[0].Gy[27,123] = 178.886372244962
        struct[0].Gy[27,124] = 26.4820684300461
        struct[0].Gy[27,125] = -51.1103920699892
        struct[0].Gy[27,215] = 1
        struct[0].Gy[28,24] = 51.1103920699891
        struct[0].Gy[28,25] = 26.4821149256174
        struct[0].Gy[28,26] = 51.1103920699892
        struct[0].Gy[28,27] = 26.4821149256174
        struct[0].Gy[28,28] = -178.886372244962
        struct[0].Gy[28,29] = -92.6871232662333
        struct[0].Gy[28,120] = -51.1103920699891
        struct[0].Gy[28,121] = -26.4820684300462
        struct[0].Gy[28,122] = -51.1103920699892
        struct[0].Gy[28,123] = -26.4820684300461
        struct[0].Gy[28,124] = 178.886372244962
        struct[0].Gy[28,125] = 92.6872395051615
        struct[0].Gy[28,216] = 1
        struct[0].Gy[29,24] = -26.4821149256174
        struct[0].Gy[29,25] = 51.1103920699891
        struct[0].Gy[29,26] = -26.4821149256174
        struct[0].Gy[29,27] = 51.1103920699892
        struct[0].Gy[29,28] = 92.6871232662333
        struct[0].Gy[29,29] = -178.886372244962
        struct[0].Gy[29,120] = 26.4820684300462
        struct[0].Gy[29,121] = -51.1103920699891
        struct[0].Gy[29,122] = 26.4820684300461
        struct[0].Gy[29,123] = -51.1103920699892
        struct[0].Gy[29,124] = -92.6872395051615
        struct[0].Gy[29,125] = 178.886372244962
        struct[0].Gy[29,217] = 1
        struct[0].Gy[30,30] = -112.904579802783
        struct[0].Gy[30,31] = -58.4995981119106
        struct[0].Gy[30,32] = 32.2584513722238
        struct[0].Gy[30,33] = 16.7142971766540
        struct[0].Gy[30,34] = 32.2584513722239
        struct[0].Gy[30,35] = 16.7142971766540
        struct[0].Gy[30,120] = 112.904579802783
        struct[0].Gy[30,121] = 58.4997822812349
        struct[0].Gy[30,122] = -32.2584513722238
        struct[0].Gy[30,123] = -16.7142235089243
        struct[0].Gy[30,124] = -32.2584513722239
        struct[0].Gy[30,125] = -16.7142235089243
        struct[0].Gy[30,222] = 1
        struct[0].Gy[31,30] = 58.4995981119106
        struct[0].Gy[31,31] = -112.904579802783
        struct[0].Gy[31,32] = -16.7142971766540
        struct[0].Gy[31,33] = 32.2584513722238
        struct[0].Gy[31,34] = -16.7142971766540
        struct[0].Gy[31,35] = 32.2584513722239
        struct[0].Gy[31,120] = -58.4997822812349
        struct[0].Gy[31,121] = 112.904579802783
        struct[0].Gy[31,122] = 16.7142235089243
        struct[0].Gy[31,123] = -32.2584513722238
        struct[0].Gy[31,124] = 16.7142235089243
        struct[0].Gy[31,125] = -32.2584513722239
        struct[0].Gy[31,223] = 1
        struct[0].Gy[32,30] = 32.2584513722238
        struct[0].Gy[32,31] = 16.7142971766540
        struct[0].Gy[32,32] = -112.904579802783
        struct[0].Gy[32,33] = -58.4995981119106
        struct[0].Gy[32,34] = 32.2584513722239
        struct[0].Gy[32,35] = 16.7142971766540
        struct[0].Gy[32,120] = -32.2584513722238
        struct[0].Gy[32,121] = -16.7142235089243
        struct[0].Gy[32,122] = 112.904579802783
        struct[0].Gy[32,123] = 58.4997822812349
        struct[0].Gy[32,124] = -32.2584513722239
        struct[0].Gy[32,125] = -16.7142235089242
        struct[0].Gy[32,224] = 1
        struct[0].Gy[33,30] = -16.7142971766540
        struct[0].Gy[33,31] = 32.2584513722238
        struct[0].Gy[33,32] = 58.4995981119106
        struct[0].Gy[33,33] = -112.904579802783
        struct[0].Gy[33,34] = -16.7142971766540
        struct[0].Gy[33,35] = 32.2584513722239
        struct[0].Gy[33,120] = 16.7142235089243
        struct[0].Gy[33,121] = -32.2584513722238
        struct[0].Gy[33,122] = -58.4997822812349
        struct[0].Gy[33,123] = 112.904579802783
        struct[0].Gy[33,124] = 16.7142235089242
        struct[0].Gy[33,125] = -32.2584513722239
        struct[0].Gy[33,225] = 1
        struct[0].Gy[34,30] = 32.2584513722239
        struct[0].Gy[34,31] = 16.7142971766540
        struct[0].Gy[34,32] = 32.2584513722239
        struct[0].Gy[34,33] = 16.7142971766540
        struct[0].Gy[34,34] = -112.904579802783
        struct[0].Gy[34,35] = -58.4995981119106
        struct[0].Gy[34,120] = -32.2584513722239
        struct[0].Gy[34,121] = -16.7142235089243
        struct[0].Gy[34,122] = -32.2584513722239
        struct[0].Gy[34,123] = -16.7142235089242
        struct[0].Gy[34,124] = 112.904579802783
        struct[0].Gy[34,125] = 58.4997822812349
        struct[0].Gy[34,226] = 1
        struct[0].Gy[35,30] = -16.7142971766540
        struct[0].Gy[35,31] = 32.2584513722239
        struct[0].Gy[35,32] = -16.7142971766540
        struct[0].Gy[35,33] = 32.2584513722239
        struct[0].Gy[35,34] = 58.4995981119106
        struct[0].Gy[35,35] = -112.904579802783
        struct[0].Gy[35,120] = 16.7142235089243
        struct[0].Gy[35,121] = -32.2584513722239
        struct[0].Gy[35,122] = 16.7142235089242
        struct[0].Gy[35,123] = -32.2584513722239
        struct[0].Gy[35,124] = -58.4997822812349
        struct[0].Gy[35,125] = 112.904579802783
        struct[0].Gy[35,227] = 1
        struct[0].Gy[36,36] = -474.891176542679
        struct[0].Gy[36,37] = -246.057560640311
        struct[0].Gy[36,38] = 135.683193297908
        struct[0].Gy[36,39] = 70.3021902075957
        struct[0].Gy[36,40] = 135.683193297908
        struct[0].Gy[36,41] = 70.3021902075957
        struct[0].Gy[36,132] = 474.891176542679
        struct[0].Gy[36,133] = 246.057604426258
        struct[0].Gy[36,134] = -135.683193297908
        struct[0].Gy[36,135] = -70.3021726932167
        struct[0].Gy[36,136] = -135.683193297908
        struct[0].Gy[36,137] = -70.3021726932166
        struct[0].Gy[36,231] = 1
        struct[0].Gy[37,36] = 246.057560640311
        struct[0].Gy[37,37] = -474.891176542679
        struct[0].Gy[37,38] = -70.3021902075957
        struct[0].Gy[37,39] = 135.683193297908
        struct[0].Gy[37,40] = -70.3021902075957
        struct[0].Gy[37,41] = 135.683193297908
        struct[0].Gy[37,132] = -246.057604426258
        struct[0].Gy[37,133] = 474.891176542679
        struct[0].Gy[37,134] = 70.3021726932167
        struct[0].Gy[37,135] = -135.683193297908
        struct[0].Gy[37,136] = 70.3021726932166
        struct[0].Gy[37,137] = -135.683193297908
        struct[0].Gy[37,232] = 1
        struct[0].Gy[38,36] = 135.683193297908
        struct[0].Gy[38,37] = 70.3021902075957
        struct[0].Gy[38,38] = -474.891176542679
        struct[0].Gy[38,39] = -246.057560640311
        struct[0].Gy[38,40] = 135.683193297909
        struct[0].Gy[38,41] = 70.3021902075956
        struct[0].Gy[38,132] = -135.683193297908
        struct[0].Gy[38,133] = -70.3021726932166
        struct[0].Gy[38,134] = 474.891176542679
        struct[0].Gy[38,135] = 246.057604426258
        struct[0].Gy[38,136] = -135.683193297909
        struct[0].Gy[38,137] = -70.3021726932165
        struct[0].Gy[38,233] = 1
        struct[0].Gy[39,36] = -70.3021902075957
        struct[0].Gy[39,37] = 135.683193297908
        struct[0].Gy[39,38] = 246.057560640311
        struct[0].Gy[39,39] = -474.891176542679
        struct[0].Gy[39,40] = -70.3021902075956
        struct[0].Gy[39,41] = 135.683193297909
        struct[0].Gy[39,132] = 70.3021726932166
        struct[0].Gy[39,133] = -135.683193297908
        struct[0].Gy[39,134] = -246.057604426258
        struct[0].Gy[39,135] = 474.891176542679
        struct[0].Gy[39,136] = 70.3021726932165
        struct[0].Gy[39,137] = -135.683193297909
        struct[0].Gy[39,234] = 1
        struct[0].Gy[40,36] = 135.683193297908
        struct[0].Gy[40,37] = 70.3021902075957
        struct[0].Gy[40,38] = 135.683193297909
        struct[0].Gy[40,39] = 70.3021902075956
        struct[0].Gy[40,40] = -474.891176542679
        struct[0].Gy[40,41] = -246.057560640311
        struct[0].Gy[40,132] = -135.683193297908
        struct[0].Gy[40,133] = -70.3021726932167
        struct[0].Gy[40,134] = -135.683193297909
        struct[0].Gy[40,135] = -70.3021726932165
        struct[0].Gy[40,136] = 474.891176542679
        struct[0].Gy[40,137] = 246.057604426258
        struct[0].Gy[40,235] = 1
        struct[0].Gy[41,36] = -70.3021902075957
        struct[0].Gy[41,37] = 135.683193297908
        struct[0].Gy[41,38] = -70.3021902075956
        struct[0].Gy[41,39] = 135.683193297909
        struct[0].Gy[41,40] = 246.057560640311
        struct[0].Gy[41,41] = -474.891176542679
        struct[0].Gy[41,132] = 70.3021726932167
        struct[0].Gy[41,133] = -135.683193297908
        struct[0].Gy[41,134] = 70.3021726932165
        struct[0].Gy[41,135] = -135.683193297909
        struct[0].Gy[41,136] = -246.057604426258
        struct[0].Gy[41,137] = 474.891176542679
        struct[0].Gy[41,236] = 1
        struct[0].Gy[42,42] = -206.112752761809
        struct[0].Gy[42,43] = -106.794071531051
        struct[0].Gy[42,44] = 58.8893579319454
        struct[0].Gy[42,45] = 30.5126610438848
        struct[0].Gy[42,46] = 58.8893579319454
        struct[0].Gy[42,47] = 30.5126610438848
        struct[0].Gy[42,132] = 206.112752761809
        struct[0].Gy[42,133] = 106.794172415445
        struct[0].Gy[42,134] = -58.8893579319454
        struct[0].Gy[42,135] = -30.5126206901271
        struct[0].Gy[42,136] = -58.8893579319454
        struct[0].Gy[42,137] = -30.5126206901271
        struct[0].Gy[42,241] = 1
        struct[0].Gy[43,42] = 106.794071531051
        struct[0].Gy[43,43] = -206.112752761809
        struct[0].Gy[43,44] = -30.5126610438848
        struct[0].Gy[43,45] = 58.8893579319454
        struct[0].Gy[43,46] = -30.5126610438848
        struct[0].Gy[43,47] = 58.8893579319454
        struct[0].Gy[43,132] = -106.794172415445
        struct[0].Gy[43,133] = 206.112752761809
        struct[0].Gy[43,134] = 30.5126206901271
        struct[0].Gy[43,135] = -58.8893579319454
        struct[0].Gy[43,136] = 30.5126206901271
        struct[0].Gy[43,137] = -58.8893579319454
        struct[0].Gy[43,242] = 1
        struct[0].Gy[44,42] = 58.8893579319454
        struct[0].Gy[44,43] = 30.5126610438847
        struct[0].Gy[44,44] = -206.112752761809
        struct[0].Gy[44,45] = -106.794071531051
        struct[0].Gy[44,46] = 58.8893579319455
        struct[0].Gy[44,47] = 30.5126610438847
        struct[0].Gy[44,132] = -58.8893579319454
        struct[0].Gy[44,133] = -30.5126206901271
        struct[0].Gy[44,134] = 206.112752761809
        struct[0].Gy[44,135] = 106.794172415445
        struct[0].Gy[44,136] = -58.8893579319455
        struct[0].Gy[44,137] = -30.5126206901271
        struct[0].Gy[44,243] = 1
        struct[0].Gy[45,42] = -30.5126610438847
        struct[0].Gy[45,43] = 58.8893579319454
        struct[0].Gy[45,44] = 106.794071531051
        struct[0].Gy[45,45] = -206.112752761809
        struct[0].Gy[45,46] = -30.5126610438847
        struct[0].Gy[45,47] = 58.8893579319455
        struct[0].Gy[45,132] = 30.5126206901271
        struct[0].Gy[45,133] = -58.8893579319454
        struct[0].Gy[45,134] = -106.794172415445
        struct[0].Gy[45,135] = 206.112752761809
        struct[0].Gy[45,136] = 30.5126206901271
        struct[0].Gy[45,137] = -58.8893579319455
        struct[0].Gy[45,244] = 1
        struct[0].Gy[46,42] = 58.8893579319454
        struct[0].Gy[46,43] = 30.5126610438848
        struct[0].Gy[46,44] = 58.8893579319455
        struct[0].Gy[46,45] = 30.5126610438847
        struct[0].Gy[46,46] = -206.112752761809
        struct[0].Gy[46,47] = -106.794071531051
        struct[0].Gy[46,132] = -58.8893579319454
        struct[0].Gy[46,133] = -30.5126206901272
        struct[0].Gy[46,134] = -58.8893579319455
        struct[0].Gy[46,135] = -30.5126206901271
        struct[0].Gy[46,136] = 206.112752761809
        struct[0].Gy[46,137] = 106.794172415445
        struct[0].Gy[46,245] = 1
        struct[0].Gy[47,42] = -30.5126610438848
        struct[0].Gy[47,43] = 58.8893579319454
        struct[0].Gy[47,44] = -30.5126610438847
        struct[0].Gy[47,45] = 58.8893579319455
        struct[0].Gy[47,46] = 106.794071531051
        struct[0].Gy[47,47] = -206.112752761809
        struct[0].Gy[47,132] = 30.5126206901272
        struct[0].Gy[47,133] = -58.8893579319454
        struct[0].Gy[47,134] = 30.5126206901271
        struct[0].Gy[47,135] = -58.8893579319455
        struct[0].Gy[47,136] = -106.794172415445
        struct[0].Gy[47,137] = 206.112752761809
        struct[0].Gy[47,246] = 1
        struct[0].Gy[48,48] = -189.480644782640
        struct[0].Gy[48,49] = -98.1763901476198
        struct[0].Gy[48,50] = 54.1373270807543
        struct[0].Gy[48,51] = 28.0504724351543
        struct[0].Gy[48,52] = 54.1373270807543
        struct[0].Gy[48,53] = 28.0504724351542
        struct[0].Gy[48,144] = 189.480644782640
        struct[0].Gy[48,145] = 98.1764998873781
        struct[0].Gy[48,146] = -54.1373270807543
        struct[0].Gy[48,147] = -28.0504285392509
        struct[0].Gy[48,148] = -54.1373270807543
        struct[0].Gy[48,149] = -28.0504285392509
        struct[0].Gy[48,250] = 1
        struct[0].Gy[49,48] = 98.1763901476198
        struct[0].Gy[49,49] = -189.480644782640
        struct[0].Gy[49,50] = -28.0504724351543
        struct[0].Gy[49,51] = 54.1373270807543
        struct[0].Gy[49,52] = -28.0504724351542
        struct[0].Gy[49,53] = 54.1373270807543
        struct[0].Gy[49,144] = -98.1764998873781
        struct[0].Gy[49,145] = 189.480644782640
        struct[0].Gy[49,146] = 28.0504285392509
        struct[0].Gy[49,147] = -54.1373270807543
        struct[0].Gy[49,148] = 28.0504285392509
        struct[0].Gy[49,149] = -54.1373270807543
        struct[0].Gy[49,251] = 1
        struct[0].Gy[50,48] = 54.1373270807543
        struct[0].Gy[50,49] = 28.0504724351542
        struct[0].Gy[50,50] = -189.480644782640
        struct[0].Gy[50,51] = -98.1763901476198
        struct[0].Gy[50,52] = 54.1373270807544
        struct[0].Gy[50,53] = 28.0504724351542
        struct[0].Gy[50,144] = -54.1373270807543
        struct[0].Gy[50,145] = -28.0504285392509
        struct[0].Gy[50,146] = 189.480644782640
        struct[0].Gy[50,147] = 98.1764998873781
        struct[0].Gy[50,148] = -54.1373270807544
        struct[0].Gy[50,149] = -28.0504285392509
        struct[0].Gy[50,252] = 1
        struct[0].Gy[51,48] = -28.0504724351542
        struct[0].Gy[51,49] = 54.1373270807543
        struct[0].Gy[51,50] = 98.1763901476198
        struct[0].Gy[51,51] = -189.480644782640
        struct[0].Gy[51,52] = -28.0504724351542
        struct[0].Gy[51,53] = 54.1373270807544
        struct[0].Gy[51,144] = 28.0504285392509
        struct[0].Gy[51,145] = -54.1373270807543
        struct[0].Gy[51,146] = -98.1764998873781
        struct[0].Gy[51,147] = 189.480644782640
        struct[0].Gy[51,148] = 28.0504285392509
        struct[0].Gy[51,149] = -54.1373270807544
        struct[0].Gy[51,253] = 1
        struct[0].Gy[52,48] = 54.1373270807543
        struct[0].Gy[52,49] = 28.0504724351543
        struct[0].Gy[52,50] = 54.1373270807543
        struct[0].Gy[52,51] = 28.0504724351542
        struct[0].Gy[52,52] = -189.480644782640
        struct[0].Gy[52,53] = -98.1763901476198
        struct[0].Gy[52,144] = -54.1373270807543
        struct[0].Gy[52,145] = -28.0504285392509
        struct[0].Gy[52,146] = -54.1373270807543
        struct[0].Gy[52,147] = -28.0504285392509
        struct[0].Gy[52,148] = 189.480644782640
        struct[0].Gy[52,149] = 98.1764998873781
        struct[0].Gy[52,254] = 1
        struct[0].Gy[53,48] = -28.0504724351543
        struct[0].Gy[53,49] = 54.1373270807543
        struct[0].Gy[53,50] = -28.0504724351542
        struct[0].Gy[53,51] = 54.1373270807543
        struct[0].Gy[53,52] = 98.1763901476198
        struct[0].Gy[53,53] = -189.480644782640
        struct[0].Gy[53,144] = 28.0504285392509
        struct[0].Gy[53,145] = -54.1373270807543
        struct[0].Gy[53,146] = 28.0504285392509
        struct[0].Gy[53,147] = -54.1373270807543
        struct[0].Gy[53,148] = -98.1764998873781
        struct[0].Gy[53,149] = 189.480644782640
        struct[0].Gy[53,255] = 1
        struct[0].Gy[54,54] = -146.305409673982
        struct[0].Gy[54,55] = -75.8057696238346
        struct[0].Gy[54,56] = 41.8015456211378
        struct[0].Gy[54,57] = 21.6588887777877
        struct[0].Gy[54,58] = 41.8015456211378
        struct[0].Gy[54,59] = 21.6588887777877
        struct[0].Gy[54,144] = 146.305409673982
        struct[0].Gy[54,145] = 75.8059117481773
        struct[0].Gy[54,146] = -41.8015456211378
        struct[0].Gy[54,147] = -21.6588319280506
        struct[0].Gy[54,148] = -41.8015456211378
        struct[0].Gy[54,149] = -21.6588319280506
        struct[0].Gy[54,260] = 1
        struct[0].Gy[55,54] = 75.8057696238346
        struct[0].Gy[55,55] = -146.305409673982
        struct[0].Gy[55,56] = -21.6588887777877
        struct[0].Gy[55,57] = 41.8015456211378
        struct[0].Gy[55,58] = -21.6588887777877
        struct[0].Gy[55,59] = 41.8015456211378
        struct[0].Gy[55,144] = -75.8059117481773
        struct[0].Gy[55,145] = 146.305409673982
        struct[0].Gy[55,146] = 21.6588319280506
        struct[0].Gy[55,147] = -41.8015456211378
        struct[0].Gy[55,148] = 21.6588319280506
        struct[0].Gy[55,149] = -41.8015456211378
        struct[0].Gy[55,261] = 1
        struct[0].Gy[56,54] = 41.8015456211377
        struct[0].Gy[56,55] = 21.6588887777877
        struct[0].Gy[56,56] = -146.305409673982
        struct[0].Gy[56,57] = -75.8057696238346
        struct[0].Gy[56,58] = 41.8015456211378
        struct[0].Gy[56,59] = 21.6588887777877
        struct[0].Gy[56,144] = -41.8015456211377
        struct[0].Gy[56,145] = -21.6588319280506
        struct[0].Gy[56,146] = 146.305409673982
        struct[0].Gy[56,147] = 75.8059117481773
        struct[0].Gy[56,148] = -41.8015456211378
        struct[0].Gy[56,149] = -21.6588319280506
        struct[0].Gy[56,262] = 1
        struct[0].Gy[57,54] = -21.6588887777877
        struct[0].Gy[57,55] = 41.8015456211377
        struct[0].Gy[57,56] = 75.8057696238346
        struct[0].Gy[57,57] = -146.305409673982
        struct[0].Gy[57,58] = -21.6588887777877
        struct[0].Gy[57,59] = 41.8015456211378
        struct[0].Gy[57,144] = 21.6588319280506
        struct[0].Gy[57,145] = -41.8015456211377
        struct[0].Gy[57,146] = -75.8059117481773
        struct[0].Gy[57,147] = 146.305409673982
        struct[0].Gy[57,148] = 21.6588319280506
        struct[0].Gy[57,149] = -41.8015456211378
        struct[0].Gy[57,263] = 1
        struct[0].Gy[58,54] = 41.8015456211378
        struct[0].Gy[58,55] = 21.6588887777877
        struct[0].Gy[58,56] = 41.8015456211378
        struct[0].Gy[58,57] = 21.6588887777877
        struct[0].Gy[58,58] = -146.305409673982
        struct[0].Gy[58,59] = -75.8057696238346
        struct[0].Gy[58,144] = -41.8015456211378
        struct[0].Gy[58,145] = -21.6588319280506
        struct[0].Gy[58,146] = -41.8015456211378
        struct[0].Gy[58,147] = -21.6588319280506
        struct[0].Gy[58,148] = 146.305409673982
        struct[0].Gy[58,149] = 75.8059117481773
        struct[0].Gy[58,264] = 1
        struct[0].Gy[59,54] = -21.6588887777877
        struct[0].Gy[59,55] = 41.8015456211378
        struct[0].Gy[59,56] = -21.6588887777877
        struct[0].Gy[59,57] = 41.8015456211378
        struct[0].Gy[59,58] = 75.8057696238346
        struct[0].Gy[59,59] = -146.305409673982
        struct[0].Gy[59,144] = 21.6588319280506
        struct[0].Gy[59,145] = -41.8015456211378
        struct[0].Gy[59,146] = 21.6588319280506
        struct[0].Gy[59,147] = -41.8015456211378
        struct[0].Gy[59,148] = -75.8059117481773
        struct[0].Gy[59,149] = 146.305409673982
        struct[0].Gy[59,265] = 1
        struct[0].Gy[60,60] = -157.441992718694
        struct[0].Gy[60,61] = -81.5760299591651
        struct[0].Gy[60,62] = 44.9834264910554
        struct[0].Gy[60,63] = 23.3075276943302
        struct[0].Gy[60,64] = 44.9834264910554
        struct[0].Gy[60,65] = 23.3075276943302
        struct[0].Gy[60,156] = 157.441992718694
        struct[0].Gy[60,157] = 81.5761620304113
        struct[0].Gy[60,158] = -44.9834264910554
        struct[0].Gy[60,159] = -23.3074748658318
        struct[0].Gy[60,160] = -44.9834264910554
        struct[0].Gy[60,161] = -23.3074748658318
        struct[0].Gy[60,269] = 1
        struct[0].Gy[61,60] = 81.5760299591651
        struct[0].Gy[61,61] = -157.441992718694
        struct[0].Gy[61,62] = -23.3075276943302
        struct[0].Gy[61,63] = 44.9834264910554
        struct[0].Gy[61,64] = -23.3075276943302
        struct[0].Gy[61,65] = 44.9834264910554
        struct[0].Gy[61,156] = -81.5761620304113
        struct[0].Gy[61,157] = 157.441992718694
        struct[0].Gy[61,158] = 23.3074748658318
        struct[0].Gy[61,159] = -44.9834264910554
        struct[0].Gy[61,160] = 23.3074748658318
        struct[0].Gy[61,161] = -44.9834264910554
        struct[0].Gy[61,270] = 1
        struct[0].Gy[62,60] = 44.9834264910554
        struct[0].Gy[62,61] = 23.3075276943302
        struct[0].Gy[62,62] = -157.441992718694
        struct[0].Gy[62,63] = -81.5760299591651
        struct[0].Gy[62,64] = 44.9834264910555
        struct[0].Gy[62,65] = 23.3075276943302
        struct[0].Gy[62,156] = -44.9834264910554
        struct[0].Gy[62,157] = -23.3074748658318
        struct[0].Gy[62,158] = 157.441992718694
        struct[0].Gy[62,159] = 81.5761620304112
        struct[0].Gy[62,160] = -44.9834264910555
        struct[0].Gy[62,161] = -23.3074748658317
        struct[0].Gy[62,271] = 1
        struct[0].Gy[63,60] = -23.3075276943302
        struct[0].Gy[63,61] = 44.9834264910554
        struct[0].Gy[63,62] = 81.5760299591651
        struct[0].Gy[63,63] = -157.441992718694
        struct[0].Gy[63,64] = -23.3075276943302
        struct[0].Gy[63,65] = 44.9834264910555
        struct[0].Gy[63,156] = 23.3074748658318
        struct[0].Gy[63,157] = -44.9834264910554
        struct[0].Gy[63,158] = -81.5761620304112
        struct[0].Gy[63,159] = 157.441992718694
        struct[0].Gy[63,160] = 23.3074748658317
        struct[0].Gy[63,161] = -44.9834264910555
        struct[0].Gy[63,272] = 1
        struct[0].Gy[64,60] = 44.9834264910554
        struct[0].Gy[64,61] = 23.3075276943302
        struct[0].Gy[64,62] = 44.9834264910554
        struct[0].Gy[64,63] = 23.3075276943302
        struct[0].Gy[64,64] = -157.441992718694
        struct[0].Gy[64,65] = -81.5760299591651
        struct[0].Gy[64,156] = -44.9834264910554
        struct[0].Gy[64,157] = -23.3074748658318
        struct[0].Gy[64,158] = -44.9834264910554
        struct[0].Gy[64,159] = -23.3074748658317
        struct[0].Gy[64,160] = 157.441992718694
        struct[0].Gy[64,161] = 81.5761620304112
        struct[0].Gy[64,273] = 1
        struct[0].Gy[65,60] = -23.3075276943302
        struct[0].Gy[65,61] = 44.9834264910554
        struct[0].Gy[65,62] = -23.3075276943302
        struct[0].Gy[65,63] = 44.9834264910554
        struct[0].Gy[65,64] = 81.5760299591651
        struct[0].Gy[65,65] = -157.441992718694
        struct[0].Gy[65,156] = 23.3074748658318
        struct[0].Gy[65,157] = -44.9834264910554
        struct[0].Gy[65,158] = 23.3074748658317
        struct[0].Gy[65,159] = -44.9834264910554
        struct[0].Gy[65,160] = -81.5761620304112
        struct[0].Gy[65,161] = 157.441992718694
        struct[0].Gy[65,274] = 1
        struct[0].Gy[66,66] = -208.261027274370
        struct[0].Gy[66,67] = -107.907168174067
        struct[0].Gy[66,68] = 59.5031506498201
        struct[0].Gy[66,69] = 30.8306879425848
        struct[0].Gy[66,70] = 59.5031506498201
        struct[0].Gy[66,71] = 30.8306879425848
        struct[0].Gy[66,156] = 208.261027274370
        struct[0].Gy[66,157] = 107.907268017809
        struct[0].Gy[66,158] = -59.5031506498201
        struct[0].Gy[66,159] = -30.8306480050881
        struct[0].Gy[66,160] = -59.5031506498201
        struct[0].Gy[66,161] = -30.8306480050881
        struct[0].Gy[66,279] = 1
        struct[0].Gy[67,66] = 107.907168174067
        struct[0].Gy[67,67] = -208.261027274370
        struct[0].Gy[67,68] = -30.8306879425848
        struct[0].Gy[67,69] = 59.5031506498201
        struct[0].Gy[67,70] = -30.8306879425848
        struct[0].Gy[67,71] = 59.5031506498201
        struct[0].Gy[67,156] = -107.907268017809
        struct[0].Gy[67,157] = 208.261027274370
        struct[0].Gy[67,158] = 30.8306480050881
        struct[0].Gy[67,159] = -59.5031506498201
        struct[0].Gy[67,160] = 30.8306480050881
        struct[0].Gy[67,161] = -59.5031506498201
        struct[0].Gy[67,280] = 1
        struct[0].Gy[68,66] = 59.5031506498201
        struct[0].Gy[68,67] = 30.8306879425848
        struct[0].Gy[68,68] = -208.261027274371
        struct[0].Gy[68,69] = -107.907168174067
        struct[0].Gy[68,70] = 59.5031506498202
        struct[0].Gy[68,71] = 30.8306879425847
        struct[0].Gy[68,156] = -59.5031506498201
        struct[0].Gy[68,157] = -30.8306480050881
        struct[0].Gy[68,158] = 208.261027274371
        struct[0].Gy[68,159] = 107.907268017808
        struct[0].Gy[68,160] = -59.5031506498202
        struct[0].Gy[68,161] = -30.8306480050881
        struct[0].Gy[68,281] = 1
        struct[0].Gy[69,66] = -30.8306879425848
        struct[0].Gy[69,67] = 59.5031506498201
        struct[0].Gy[69,68] = 107.907168174067
        struct[0].Gy[69,69] = -208.261027274371
        struct[0].Gy[69,70] = -30.8306879425847
        struct[0].Gy[69,71] = 59.5031506498202
        struct[0].Gy[69,156] = 30.8306480050881
        struct[0].Gy[69,157] = -59.5031506498201
        struct[0].Gy[69,158] = -107.907268017808
        struct[0].Gy[69,159] = 208.261027274371
        struct[0].Gy[69,160] = 30.8306480050881
        struct[0].Gy[69,161] = -59.5031506498202
        struct[0].Gy[69,282] = 1
        struct[0].Gy[70,66] = 59.5031506498201
        struct[0].Gy[70,67] = 30.8306879425848
        struct[0].Gy[70,68] = 59.5031506498202
        struct[0].Gy[70,69] = 30.8306879425847
        struct[0].Gy[70,70] = -208.261027274371
        struct[0].Gy[70,71] = -107.907168174067
        struct[0].Gy[70,156] = -59.5031506498201
        struct[0].Gy[70,157] = -30.8306480050882
        struct[0].Gy[70,158] = -59.5031506498202
        struct[0].Gy[70,159] = -30.8306480050881
        struct[0].Gy[70,160] = 208.261027274371
        struct[0].Gy[70,161] = 107.907268017808
        struct[0].Gy[70,283] = 1
        struct[0].Gy[71,66] = -30.8306879425848
        struct[0].Gy[71,67] = 59.5031506498201
        struct[0].Gy[71,68] = -30.8306879425847
        struct[0].Gy[71,69] = 59.5031506498202
        struct[0].Gy[71,70] = 107.907168174067
        struct[0].Gy[71,71] = -208.261027274371
        struct[0].Gy[71,156] = 30.8306480050882
        struct[0].Gy[71,157] = -59.5031506498201
        struct[0].Gy[71,158] = 30.8306480050881
        struct[0].Gy[71,159] = -59.5031506498202
        struct[0].Gy[71,160] = -107.907268017808
        struct[0].Gy[71,161] = 208.261027274371
        struct[0].Gy[71,284] = 1
        struct[0].Gy[72,72] = -435.745709926008
        struct[0].Gy[72,73] = -225.774931516790
        struct[0].Gy[72,74] = 124.498774264574
        struct[0].Gy[72,75] = 64.5071560124429
        struct[0].Gy[72,76] = 124.498774264574
        struct[0].Gy[72,77] = 64.5071560124428
        struct[0].Gy[72,168] = 435.745709926008
        struct[0].Gy[72,169] = 225.774979236273
        struct[0].Gy[72,170] = -124.498774264574
        struct[0].Gy[72,171] = -64.5071369246495
        struct[0].Gy[72,172] = -124.498774264574
        struct[0].Gy[72,173] = -64.5071369246495
        struct[0].Gy[72,288] = 1
        struct[0].Gy[73,72] = 225.774931516790
        struct[0].Gy[73,73] = -435.745709926008
        struct[0].Gy[73,74] = -64.5071560124429
        struct[0].Gy[73,75] = 124.498774264574
        struct[0].Gy[73,76] = -64.5071560124428
        struct[0].Gy[73,77] = 124.498774264574
        struct[0].Gy[73,168] = -225.774979236273
        struct[0].Gy[73,169] = 435.745709926008
        struct[0].Gy[73,170] = 64.5071369246495
        struct[0].Gy[73,171] = -124.498774264574
        struct[0].Gy[73,172] = 64.5071369246495
        struct[0].Gy[73,173] = -124.498774264574
        struct[0].Gy[73,289] = 1
        struct[0].Gy[74,72] = 124.498774264574
        struct[0].Gy[74,73] = 64.5071560124428
        struct[0].Gy[74,74] = -435.745709926008
        struct[0].Gy[74,75] = -225.774931516790
        struct[0].Gy[74,76] = 124.498774264574
        struct[0].Gy[74,77] = 64.5071560124428
        struct[0].Gy[74,168] = -124.498774264574
        struct[0].Gy[74,169] = -64.5071369246495
        struct[0].Gy[74,170] = 435.745709926008
        struct[0].Gy[74,171] = 225.774979236273
        struct[0].Gy[74,172] = -124.498774264574
        struct[0].Gy[74,173] = -64.5071369246494
        struct[0].Gy[74,290] = 1
        struct[0].Gy[75,72] = -64.5071560124428
        struct[0].Gy[75,73] = 124.498774264574
        struct[0].Gy[75,74] = 225.774931516790
        struct[0].Gy[75,75] = -435.745709926008
        struct[0].Gy[75,76] = -64.5071560124428
        struct[0].Gy[75,77] = 124.498774264574
        struct[0].Gy[75,168] = 64.5071369246495
        struct[0].Gy[75,169] = -124.498774264574
        struct[0].Gy[75,170] = -225.774979236273
        struct[0].Gy[75,171] = 435.745709926008
        struct[0].Gy[75,172] = 64.5071369246494
        struct[0].Gy[75,173] = -124.498774264574
        struct[0].Gy[75,291] = 1
        struct[0].Gy[76,72] = 124.498774264574
        struct[0].Gy[76,73] = 64.5071560124429
        struct[0].Gy[76,74] = 124.498774264574
        struct[0].Gy[76,75] = 64.5071560124428
        struct[0].Gy[76,76] = -435.745709926008
        struct[0].Gy[76,77] = -225.774931516790
        struct[0].Gy[76,168] = -124.498774264574
        struct[0].Gy[76,169] = -64.5071369246495
        struct[0].Gy[76,170] = -124.498774264574
        struct[0].Gy[76,171] = -64.5071369246494
        struct[0].Gy[76,172] = 435.745709926008
        struct[0].Gy[76,173] = 225.774979236273
        struct[0].Gy[76,292] = 1
        struct[0].Gy[77,72] = -64.5071560124429
        struct[0].Gy[77,73] = 124.498774264574
        struct[0].Gy[77,74] = -64.5071560124428
        struct[0].Gy[77,75] = 124.498774264574
        struct[0].Gy[77,76] = 225.774931516790
        struct[0].Gy[77,77] = -435.745709926008
        struct[0].Gy[77,168] = 64.5071369246495
        struct[0].Gy[77,169] = -124.498774264574
        struct[0].Gy[77,170] = 64.5071369246494
        struct[0].Gy[77,171] = -124.498774264574
        struct[0].Gy[77,172] = -225.774979236273
        struct[0].Gy[77,173] = 435.745709926008
        struct[0].Gy[77,293] = 1
        struct[0].Gy[78,78] = -0.0272349653347382
        struct[0].Gy[78,79] = -0.0647773858527649
        struct[0].Gy[78,80] = 0.00153045607591063
        struct[0].Gy[78,81] = 0.0122436486072850
        struct[0].Gy[78,82] = 0.00153045607591062
        struct[0].Gy[78,83] = 0.0122436486072850
        struct[0].Gy[78,84] = 0.00874773135135797
        struct[0].Gy[78,85] = 0.0699818508108637
        struct[0].Gy[78,86] = -0.00874773135135797
        struct[0].Gy[78,87] = -0.0699818508108637
        struct[0].Gy[79,78] = 0.0647773858527649
        struct[0].Gy[79,79] = -0.0272349653347382
        struct[0].Gy[79,80] = -0.0122436486072850
        struct[0].Gy[79,81] = 0.00153045607591063
        struct[0].Gy[79,82] = -0.0122436486072850
        struct[0].Gy[79,83] = 0.00153045607591062
        struct[0].Gy[79,84] = -0.0699818508108637
        struct[0].Gy[79,85] = 0.00874773135135797
        struct[0].Gy[79,86] = 0.0699818508108637
        struct[0].Gy[79,87] = -0.00874773135135797
        struct[0].Gy[80,78] = 0.00153045607591062
        struct[0].Gy[80,79] = 0.0122436486072850
        struct[0].Gy[80,80] = -0.0272349653347383
        struct[0].Gy[80,81] = -0.0647773858527649
        struct[0].Gy[80,82] = 0.00153045607591064
        struct[0].Gy[80,83] = 0.0122436486072850
        struct[0].Gy[80,86] = 0.00874773135135797
        struct[0].Gy[80,87] = 0.0699818508108637
        struct[0].Gy[80,88] = -0.00874773135135797
        struct[0].Gy[80,89] = -0.0699818508108637
        struct[0].Gy[81,78] = -0.0122436486072850
        struct[0].Gy[81,79] = 0.00153045607591062
        struct[0].Gy[81,80] = 0.0647773858527649
        struct[0].Gy[81,81] = -0.0272349653347383
        struct[0].Gy[81,82] = -0.0122436486072850
        struct[0].Gy[81,83] = 0.00153045607591064
        struct[0].Gy[81,86] = -0.0699818508108637
        struct[0].Gy[81,87] = 0.00874773135135797
        struct[0].Gy[81,88] = 0.0699818508108637
        struct[0].Gy[81,89] = -0.00874773135135797
        struct[0].Gy[82,78] = 0.00153045607591062
        struct[0].Gy[82,79] = 0.0122436486072850
        struct[0].Gy[82,80] = 0.00153045607591064
        struct[0].Gy[82,81] = 0.0122436486072850
        struct[0].Gy[82,82] = -0.0272349653347383
        struct[0].Gy[82,83] = -0.0647773858527649
        struct[0].Gy[82,84] = -0.00874773135135797
        struct[0].Gy[82,85] = -0.0699818508108637
        struct[0].Gy[82,88] = 0.00874773135135797
        struct[0].Gy[82,89] = 0.0699818508108637
        struct[0].Gy[83,78] = -0.0122436486072850
        struct[0].Gy[83,79] = 0.00153045607591062
        struct[0].Gy[83,80] = -0.0122436486072850
        struct[0].Gy[83,81] = 0.00153045607591064
        struct[0].Gy[83,82] = 0.0647773858527649
        struct[0].Gy[83,83] = -0.0272349653347383
        struct[0].Gy[83,84] = 0.0699818508108637
        struct[0].Gy[83,85] = -0.00874773135135797
        struct[0].Gy[83,88] = -0.0699818508108637
        struct[0].Gy[83,89] = 0.00874773135135797
        struct[0].Gy[84,78] = 0.00874773135135797
        struct[0].Gy[84,79] = 0.0699818508108637
        struct[0].Gy[84,82] = -0.00874773135135797
        struct[0].Gy[84,83] = -0.0699818508108637
        struct[0].Gy[84,84] = -24.8222322123875
        struct[0].Gy[84,85] = -33.4156859296188
        struct[0].Gy[84,86] = 7.06438748925360
        struct[0].Gy[84,87] = 9.43309892709730
        struct[0].Gy[84,88] = 7.06438748925360
        struct[0].Gy[84,89] = 9.43309892709730
        struct[0].Gy[84,90] = 18.2833023823143
        struct[0].Gy[84,91] = 24.3777365097524
        struct[0].Gy[84,92] = -5.22380068066123
        struct[0].Gy[84,93] = -6.96506757421497
        struct[0].Gy[84,94] = -5.22380068066123
        struct[0].Gy[84,95] = -6.96506757421497
        struct[0].Gy[84,114] = 6.47851216340659
        struct[0].Gy[84,115] = 8.63801621787545
        struct[0].Gy[84,116] = -1.85100347525903
        struct[0].Gy[84,117] = -2.46800463367870
        struct[0].Gy[84,118] = -1.85100347525903
        struct[0].Gy[84,119] = -2.46800463367870
        struct[0].Gy[85,78] = -0.0699818508108637
        struct[0].Gy[85,79] = 0.00874773135135797
        struct[0].Gy[85,82] = 0.0699818508108637
        struct[0].Gy[85,83] = -0.00874773135135797
        struct[0].Gy[85,84] = 33.4156859296188
        struct[0].Gy[85,85] = -24.8222322123875
        struct[0].Gy[85,86] = -9.43309892709730
        struct[0].Gy[85,87] = 7.06438748925360
        struct[0].Gy[85,88] = -9.43309892709730
        struct[0].Gy[85,89] = 7.06438748925360
        struct[0].Gy[85,90] = -24.3777365097524
        struct[0].Gy[85,91] = 18.2833023823143
        struct[0].Gy[85,92] = 6.96506757421497
        struct[0].Gy[85,93] = -5.22380068066123
        struct[0].Gy[85,94] = 6.96506757421497
        struct[0].Gy[85,95] = -5.22380068066123
        struct[0].Gy[85,114] = -8.63801621787545
        struct[0].Gy[85,115] = 6.47851216340659
        struct[0].Gy[85,116] = 2.46800463367870
        struct[0].Gy[85,117] = -1.85100347525903
        struct[0].Gy[85,118] = 2.46800463367870
        struct[0].Gy[85,119] = -1.85100347525903
        struct[0].Gy[86,78] = -0.00874773135135797
        struct[0].Gy[86,79] = -0.0699818508108637
        struct[0].Gy[86,80] = 0.00874773135135797
        struct[0].Gy[86,81] = 0.0699818508108637
        struct[0].Gy[86,84] = 7.06438748925360
        struct[0].Gy[86,85] = 9.43309892709730
        struct[0].Gy[86,86] = -24.8222322123876
        struct[0].Gy[86,87] = -33.4156859296188
        struct[0].Gy[86,88] = 7.06438748925361
        struct[0].Gy[86,89] = 9.43309892709730
        struct[0].Gy[86,90] = -5.22380068066123
        struct[0].Gy[86,91] = -6.96506757421497
        struct[0].Gy[86,92] = 18.2833023823143
        struct[0].Gy[86,93] = 24.3777365097524
        struct[0].Gy[86,94] = -5.22380068066124
        struct[0].Gy[86,95] = -6.96506757421497
        struct[0].Gy[86,114] = -1.85100347525903
        struct[0].Gy[86,115] = -2.46800463367870
        struct[0].Gy[86,116] = 6.47851216340659
        struct[0].Gy[86,117] = 8.63801621787545
        struct[0].Gy[86,118] = -1.85100347525903
        struct[0].Gy[86,119] = -2.46800463367870
        struct[0].Gy[87,78] = 0.0699818508108637
        struct[0].Gy[87,79] = -0.00874773135135797
        struct[0].Gy[87,80] = -0.0699818508108637
        struct[0].Gy[87,81] = 0.00874773135135797
        struct[0].Gy[87,84] = -9.43309892709730
        struct[0].Gy[87,85] = 7.06438748925360
        struct[0].Gy[87,86] = 33.4156859296188
        struct[0].Gy[87,87] = -24.8222322123876
        struct[0].Gy[87,88] = -9.43309892709730
        struct[0].Gy[87,89] = 7.06438748925361
        struct[0].Gy[87,90] = 6.96506757421497
        struct[0].Gy[87,91] = -5.22380068066123
        struct[0].Gy[87,92] = -24.3777365097524
        struct[0].Gy[87,93] = 18.2833023823143
        struct[0].Gy[87,94] = 6.96506757421497
        struct[0].Gy[87,95] = -5.22380068066124
        struct[0].Gy[87,114] = 2.46800463367870
        struct[0].Gy[87,115] = -1.85100347525903
        struct[0].Gy[87,116] = -8.63801621787545
        struct[0].Gy[87,117] = 6.47851216340659
        struct[0].Gy[87,118] = 2.46800463367870
        struct[0].Gy[87,119] = -1.85100347525903
        struct[0].Gy[88,80] = -0.00874773135135797
        struct[0].Gy[88,81] = -0.0699818508108637
        struct[0].Gy[88,82] = 0.00874773135135797
        struct[0].Gy[88,83] = 0.0699818508108637
        struct[0].Gy[88,84] = 7.06438748925359
        struct[0].Gy[88,85] = 9.43309892709730
        struct[0].Gy[88,86] = 7.06438748925361
        struct[0].Gy[88,87] = 9.43309892709730
        struct[0].Gy[88,88] = -24.8222322123876
        struct[0].Gy[88,89] = -33.4156859296188
        struct[0].Gy[88,90] = -5.22380068066123
        struct[0].Gy[88,91] = -6.96506757421497
        struct[0].Gy[88,92] = -5.22380068066124
        struct[0].Gy[88,93] = -6.96506757421497
        struct[0].Gy[88,94] = 18.2833023823143
        struct[0].Gy[88,95] = 24.3777365097524
        struct[0].Gy[88,114] = -1.85100347525903
        struct[0].Gy[88,115] = -2.46800463367870
        struct[0].Gy[88,116] = -1.85100347525903
        struct[0].Gy[88,117] = -2.46800463367870
        struct[0].Gy[88,118] = 6.47851216340659
        struct[0].Gy[88,119] = 8.63801621787545
        struct[0].Gy[89,80] = 0.0699818508108637
        struct[0].Gy[89,81] = -0.00874773135135797
        struct[0].Gy[89,82] = -0.0699818508108637
        struct[0].Gy[89,83] = 0.00874773135135797
        struct[0].Gy[89,84] = -9.43309892709730
        struct[0].Gy[89,85] = 7.06438748925359
        struct[0].Gy[89,86] = -9.43309892709730
        struct[0].Gy[89,87] = 7.06438748925361
        struct[0].Gy[89,88] = 33.4156859296188
        struct[0].Gy[89,89] = -24.8222322123876
        struct[0].Gy[89,90] = 6.96506757421497
        struct[0].Gy[89,91] = -5.22380068066123
        struct[0].Gy[89,92] = 6.96506757421497
        struct[0].Gy[89,93] = -5.22380068066124
        struct[0].Gy[89,94] = -24.3777365097524
        struct[0].Gy[89,95] = 18.2833023823143
        struct[0].Gy[89,114] = 2.46800463367870
        struct[0].Gy[89,115] = -1.85100347525903
        struct[0].Gy[89,116] = 2.46800463367870
        struct[0].Gy[89,117] = -1.85100347525903
        struct[0].Gy[89,118] = -8.63801621787545
        struct[0].Gy[89,119] = 6.47851216340659
        struct[0].Gy[90,84] = 18.2833023823143
        struct[0].Gy[90,85] = 24.3777365097524
        struct[0].Gy[90,86] = -5.22380068066123
        struct[0].Gy[90,87] = -6.96506757421497
        struct[0].Gy[90,88] = -5.22380068066123
        struct[0].Gy[90,89] = -6.96506757421497
        struct[0].Gy[90,90] = -39.5195811550486
        struct[0].Gy[90,91] = -52.7347843860809
        struct[0].Gy[90,92] = 11.2932394033730
        struct[0].Gy[90,93] = 15.0786865705954
        struct[0].Gy[90,94] = 11.2932394033730
        struct[0].Gy[90,95] = 15.0786865705954
        struct[0].Gy[90,96] = 0.390101533236234
        struct[0].Gy[90,97] = 2.34060919941740
        struct[0].Gy[90,98] = -0.390101533236234
        struct[0].Gy[90,99] = -2.34060919941740
        struct[0].Gy[90,102] = 21.2272697637253
        struct[0].Gy[90,103] = 28.3030263516338
        struct[0].Gy[90,104] = -6.06493421820724
        struct[0].Gy[90,105] = -8.08657895760964
        struct[0].Gy[90,106] = -6.06493421820724
        struct[0].Gy[90,107] = -8.08657895760964
        struct[0].Gy[91,84] = -24.3777365097524
        struct[0].Gy[91,85] = 18.2833023823143
        struct[0].Gy[91,86] = 6.96506757421497
        struct[0].Gy[91,87] = -5.22380068066123
        struct[0].Gy[91,88] = 6.96506757421497
        struct[0].Gy[91,89] = -5.22380068066123
        struct[0].Gy[91,90] = 52.7347843860809
        struct[0].Gy[91,91] = -39.5195811550486
        struct[0].Gy[91,92] = -15.0786865705954
        struct[0].Gy[91,93] = 11.2932394033730
        struct[0].Gy[91,94] = -15.0786865705954
        struct[0].Gy[91,95] = 11.2932394033730
        struct[0].Gy[91,96] = -2.34060919941740
        struct[0].Gy[91,97] = 0.390101533236234
        struct[0].Gy[91,98] = 2.34060919941740
        struct[0].Gy[91,99] = -0.390101533236234
        struct[0].Gy[91,102] = -28.3030263516338
        struct[0].Gy[91,103] = 21.2272697637253
        struct[0].Gy[91,104] = 8.08657895760964
        struct[0].Gy[91,105] = -6.06493421820724
        struct[0].Gy[91,106] = 8.08657895760964
        struct[0].Gy[91,107] = -6.06493421820724
        struct[0].Gy[92,84] = -5.22380068066123
        struct[0].Gy[92,85] = -6.96506757421497
        struct[0].Gy[92,86] = 18.2833023823143
        struct[0].Gy[92,87] = 24.3777365097524
        struct[0].Gy[92,88] = -5.22380068066124
        struct[0].Gy[92,89] = -6.96506757421497
        struct[0].Gy[92,90] = 11.2932394033730
        struct[0].Gy[92,91] = 15.0786865705954
        struct[0].Gy[92,92] = -39.5195811550487
        struct[0].Gy[92,93] = -52.7347843860809
        struct[0].Gy[92,94] = 11.2932394033730
        struct[0].Gy[92,95] = 15.0786865705954
        struct[0].Gy[92,98] = 0.390101533236234
        struct[0].Gy[92,99] = 2.34060919941740
        struct[0].Gy[92,100] = -0.390101533236234
        struct[0].Gy[92,101] = -2.34060919941740
        struct[0].Gy[92,102] = -6.06493421820724
        struct[0].Gy[92,103] = -8.08657895760964
        struct[0].Gy[92,104] = 21.2272697637253
        struct[0].Gy[92,105] = 28.3030263516338
        struct[0].Gy[92,106] = -6.06493421820725
        struct[0].Gy[92,107] = -8.08657895760965
        struct[0].Gy[93,84] = 6.96506757421497
        struct[0].Gy[93,85] = -5.22380068066123
        struct[0].Gy[93,86] = -24.3777365097524
        struct[0].Gy[93,87] = 18.2833023823143
        struct[0].Gy[93,88] = 6.96506757421497
        struct[0].Gy[93,89] = -5.22380068066124
        struct[0].Gy[93,90] = -15.0786865705954
        struct[0].Gy[93,91] = 11.2932394033730
        struct[0].Gy[93,92] = 52.7347843860809
        struct[0].Gy[93,93] = -39.5195811550487
        struct[0].Gy[93,94] = -15.0786865705954
        struct[0].Gy[93,95] = 11.2932394033730
        struct[0].Gy[93,98] = -2.34060919941740
        struct[0].Gy[93,99] = 0.390101533236234
        struct[0].Gy[93,100] = 2.34060919941740
        struct[0].Gy[93,101] = -0.390101533236234
        struct[0].Gy[93,102] = 8.08657895760964
        struct[0].Gy[93,103] = -6.06493421820724
        struct[0].Gy[93,104] = -28.3030263516338
        struct[0].Gy[93,105] = 21.2272697637253
        struct[0].Gy[93,106] = 8.08657895760965
        struct[0].Gy[93,107] = -6.06493421820725
        struct[0].Gy[94,84] = -5.22380068066123
        struct[0].Gy[94,85] = -6.96506757421497
        struct[0].Gy[94,86] = -5.22380068066124
        struct[0].Gy[94,87] = -6.96506757421497
        struct[0].Gy[94,88] = 18.2833023823143
        struct[0].Gy[94,89] = 24.3777365097524
        struct[0].Gy[94,90] = 11.2932394033730
        struct[0].Gy[94,91] = 15.0786865705954
        struct[0].Gy[94,92] = 11.2932394033730
        struct[0].Gy[94,93] = 15.0786865705954
        struct[0].Gy[94,94] = -39.5195811550487
        struct[0].Gy[94,95] = -52.7347843860809
        struct[0].Gy[94,96] = -0.390101533236234
        struct[0].Gy[94,97] = -2.34060919941740
        struct[0].Gy[94,100] = 0.390101533236234
        struct[0].Gy[94,101] = 2.34060919941740
        struct[0].Gy[94,102] = -6.06493421820724
        struct[0].Gy[94,103] = -8.08657895760965
        struct[0].Gy[94,104] = -6.06493421820725
        struct[0].Gy[94,105] = -8.08657895760964
        struct[0].Gy[94,106] = 21.2272697637253
        struct[0].Gy[94,107] = 28.3030263516338
        struct[0].Gy[95,84] = 6.96506757421497
        struct[0].Gy[95,85] = -5.22380068066123
        struct[0].Gy[95,86] = 6.96506757421497
        struct[0].Gy[95,87] = -5.22380068066124
        struct[0].Gy[95,88] = -24.3777365097524
        struct[0].Gy[95,89] = 18.2833023823143
        struct[0].Gy[95,90] = -15.0786865705954
        struct[0].Gy[95,91] = 11.2932394033730
        struct[0].Gy[95,92] = -15.0786865705954
        struct[0].Gy[95,93] = 11.2932394033730
        struct[0].Gy[95,94] = 52.7347843860809
        struct[0].Gy[95,95] = -39.5195811550487
        struct[0].Gy[95,96] = 2.34060919941740
        struct[0].Gy[95,97] = -0.390101533236234
        struct[0].Gy[95,100] = -2.34060919941740
        struct[0].Gy[95,101] = 0.390101533236234
        struct[0].Gy[95,102] = 8.08657895760965
        struct[0].Gy[95,103] = -6.06493421820724
        struct[0].Gy[95,104] = 8.08657895760964
        struct[0].Gy[95,105] = -6.06493421820725
        struct[0].Gy[95,106] = -28.3030263516338
        struct[0].Gy[95,107] = 21.2272697637253
        struct[0].Gy[96,0] = 172.823911824540
        struct[0].Gy[96,1] = 89.5460683028705
        struct[0].Gy[96,2] = -49.3782605212972
        struct[0].Gy[96,3] = -25.5845909436773
        struct[0].Gy[96,4] = -49.3782605212972
        struct[0].Gy[96,5] = -25.5845909436773
        struct[0].Gy[96,6] = 188.838681114510
        struct[0].Gy[96,7] = 97.8438762251349
        struct[0].Gy[96,8] = -53.9539088898601
        struct[0].Gy[96,9] = -27.9553932071814
        struct[0].Gy[96,10] = -53.9539088898601
        struct[0].Gy[96,11] = -27.9553932071814
        struct[0].Gy[96,90] = 0.390101533236234
        struct[0].Gy[96,91] = 2.34060919941740
        struct[0].Gy[96,94] = -0.390101533236234
        struct[0].Gy[96,95] = -2.34060919941740
        struct[0].Gy[96,96] = -395.446376722834
        struct[0].Gy[96,97] = -390.092416801432
        struct[0].Gy[96,98] = 103.332169411157
        struct[0].Gy[96,99] = 53.5400763225691
        struct[0].Gy[96,100] = 103.332169411157
        struct[0].Gy[96,101] = 53.5400763225691
        struct[0].Gy[97,0] = -89.5460683028705
        struct[0].Gy[97,1] = 172.823911824540
        struct[0].Gy[97,2] = 25.5845909436773
        struct[0].Gy[97,3] = -49.3782605212972
        struct[0].Gy[97,4] = 25.5845909436773
        struct[0].Gy[97,5] = -49.3782605212972
        struct[0].Gy[97,6] = -97.8438762251349
        struct[0].Gy[97,7] = 188.838681114510
        struct[0].Gy[97,8] = 27.9553932071814
        struct[0].Gy[97,9] = -53.9539088898601
        struct[0].Gy[97,10] = 27.9553932071814
        struct[0].Gy[97,11] = -53.9539088898601
        struct[0].Gy[97,90] = -2.34060919941740
        struct[0].Gy[97,91] = 0.390101533236234
        struct[0].Gy[97,94] = 2.34060919941740
        struct[0].Gy[97,95] = -0.390101533236234
        struct[0].Gy[97,96] = 390.092416801432
        struct[0].Gy[97,97] = -395.446376722834
        struct[0].Gy[97,98] = -53.5400763225691
        struct[0].Gy[97,99] = 103.332169411157
        struct[0].Gy[97,100] = -53.5400763225691
        struct[0].Gy[97,101] = 103.332169411157
        struct[0].Gy[98,0] = -49.3782605212972
        struct[0].Gy[98,1] = -25.5845909436773
        struct[0].Gy[98,2] = 172.823911824540
        struct[0].Gy[98,3] = 89.5460683028705
        struct[0].Gy[98,4] = -49.3782605212973
        struct[0].Gy[98,5] = -25.5845909436773
        struct[0].Gy[98,6] = -53.9539088898601
        struct[0].Gy[98,7] = -27.9553932071814
        struct[0].Gy[98,8] = 188.838681114510
        struct[0].Gy[98,9] = 97.8438762251349
        struct[0].Gy[98,10] = -53.9539088898602
        struct[0].Gy[98,11] = -27.9553932071814
        struct[0].Gy[98,90] = -0.390101533236234
        struct[0].Gy[98,91] = -2.34060919941740
        struct[0].Gy[98,92] = 0.390101533236234
        struct[0].Gy[98,93] = 2.34060919941740
        struct[0].Gy[98,96] = 103.332169411157
        struct[0].Gy[98,97] = 53.5400763225691
        struct[0].Gy[98,98] = -395.446376722835
        struct[0].Gy[98,99] = -390.092416801432
        struct[0].Gy[98,100] = 103.332169411157
        struct[0].Gy[98,101] = 53.5400763225691
        struct[0].Gy[99,0] = 25.5845909436773
        struct[0].Gy[99,1] = -49.3782605212972
        struct[0].Gy[99,2] = -89.5460683028705
        struct[0].Gy[99,3] = 172.823911824540
        struct[0].Gy[99,4] = 25.5845909436773
        struct[0].Gy[99,5] = -49.3782605212973
        struct[0].Gy[99,6] = 27.9553932071814
        struct[0].Gy[99,7] = -53.9539088898601
        struct[0].Gy[99,8] = -97.8438762251349
        struct[0].Gy[99,9] = 188.838681114510
        struct[0].Gy[99,10] = 27.9553932071814
        struct[0].Gy[99,11] = -53.9539088898602
        struct[0].Gy[99,90] = 2.34060919941740
        struct[0].Gy[99,91] = -0.390101533236234
        struct[0].Gy[99,92] = -2.34060919941740
        struct[0].Gy[99,93] = 0.390101533236234
        struct[0].Gy[99,96] = -53.5400763225691
        struct[0].Gy[99,97] = 103.332169411157
        struct[0].Gy[99,98] = 390.092416801432
        struct[0].Gy[99,99] = -395.446376722835
        struct[0].Gy[99,100] = -53.5400763225691
        struct[0].Gy[99,101] = 103.332169411157
        struct[0].Gy[100,0] = -49.3782605212972
        struct[0].Gy[100,1] = -25.5845909436773
        struct[0].Gy[100,2] = -49.3782605212973
        struct[0].Gy[100,3] = -25.5845909436772
        struct[0].Gy[100,4] = 172.823911824540
        struct[0].Gy[100,5] = 89.5460683028705
        struct[0].Gy[100,6] = -53.9539088898601
        struct[0].Gy[100,7] = -27.9553932071814
        struct[0].Gy[100,8] = -53.9539088898602
        struct[0].Gy[100,9] = -27.9553932071813
        struct[0].Gy[100,10] = 188.838681114510
        struct[0].Gy[100,11] = 97.8438762251349
        struct[0].Gy[100,92] = -0.39