# ansidocs

Ansidocs is a command line tool designed to help collate and generate documentation for your Ansible project. <br>

See the `example_projects` folder in this repo for examples of the READMEs generated by this tool.

## Usage

After installing the pip package, a command line utility should be available in your virtual environment.

To see available options and the help message, simply run:
``` bash
ansidocs
# or
ansidocs -h
```

To generate documentation for a project in directory `/my/project`:
``` bash
ansidocs gen -d '/my/project'
```

## Configuration

Ansidocs comes with support for the common Ansible project layouts: roles and collections. You can modify how these projects are processed <br>
or create your own project layout by modifying the configuration files.

By default, config files are located in your user directory at `~/.ansidocs`. Files are placed here once the program is run, or by running <br>
the config generation command:
```bash
ansidocs config
```

You can forcefully remove this directory and recreate it by using the refresh flag:
```bash
ansidocs config -r
```

### Customizing Project Layouts and READMEs

Its possbile to customize or create your own project layout, as well as modify the existing templates used for README generation.

#### Project Layouts

A project layout is a configuration entry that describes where different pieces of your project exist relative to the root directory. <br>
Although the types of project parts are limitted to what the program supports, you can add, remove, or move the project parts. <br>
To do this, modify the existing configuration file (by default at `~/.ansidocs/ansidocs.yml`). In that file, there is a dictionary <br>
called `project_layouts`. <br>

<b>Note:</b> The meta file attribute is used to link a project layout to your project. So, no layouts should have the same meta file <br>
value, and the meta file must exist in your project for the program to recognize its layout.

An example of the project layout struct can be found in your configuration file.

#### Customizing README Templates

Each project layout has the option to define a custom README template and add, remove, or reformat data. The templates are found in your <br>
configuration directory, (by default at `~/.ansidocs/templates`). If the program finds a folder with the same name as your layout, it will <br>
look in that directory for templates before falling back to the `defaults` directory.

When a project's README is rendered, it occurs in 4 stages:
1. render description.md.j2
2. render usage.md.j2
3. render footer.md.j2
4. Compile those renderings as variables, and use them to render README.md.j2

#### Special Documentation Files

If your project layout defines a `docs` attribute and that directory exists, ansidocs will look in that directory for certain files and include them in the README generation. <br>
Some supported documents include:

<b>usage.md</b> - This file will be injected at the top of the `Usage` section in your README.md. The file should be pure markdown, there will be no templating or substitution done on this file.

<b>description.md</b> - This file will be injected at the top of the `Description` section in your README.md. The file should be pure markdown, there will be no templating or substitution done on this file.

<b>defaults.yml</b> - This file should contain descriptions for defaults defined in your project, if any. This file is YAML and should match the keys in your `defaults/main.yml` or corresponding defaults file. Values should be strings that are used as descriptions when compiling the defaults markdown table
