# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../nbs/agents/processors/02_eoq_preprocessors.ipynb.

# %% auto 0
__all__ = ['GetInventory']

# %% ../../../nbs/agents/processors/02_eoq_preprocessors.ipynb 4
# General libraries:
import numpy as np

# %% ../../../nbs/agents/processors/02_eoq_preprocessors.ipynb 6
class GetInventory():
    """
    This class implements a processor that get the inventory from the state.

    Args:
        num_features (int): Number of features in the state.
        num_products (int): Number of products in the state.

    """
    

    def __init__(self, num_features, num_products, max_l = None):
        self.num_features = num_features
        self.num_products = num_products
        self.max_l = max_l
    
    def __call__(self, input):
        #assert len(input) == self.num_features + self.num_products
        assert len(input.shape) == 1
        
        if self.max_l is not None:
            return input[self.num_features:self.num_features+self.num_products+np.max(self.max_l)*self.num_products]
        else:
            return input[self.num_features:self.num_features+self.num_products]
