from importlib.metadata import version

__author__ = "Braden Griebel"
__version__ = version("metworkpy")
__all__ = [
    "utils",
    "imat",
    "gpr",
    "information",
    "divergence",
    "network",
    "synleth",
    "read_model",
    "write_model",
    "model_eq",
    "model_bounds_eq",
    "mutual_information",
    "mi_network_adjacency_matrix",
    "kl_divergence",
    "js_divergence",
    "create_metabolic_network",
    "create_mutual_information_network",
    "create_adjacency_matrix",
    "label_density",
    "find_dense_clusters",
    "gene_to_reaction_df",
    "gene_to_reaction_list",
    "gene_to_reaction_dict",
    "reaction_to_gene_df",
    "reaction_to_gene_dict",
    "reaction_to_gene_list",
    "bipartite_project",
    "find_metabolite_synthesis_network_genes",
    "find_metabolite_synthesis_network_reactions",
    "metchange",
    "metabolites",
    "eval_gpr",
    "gene_to_rxn_weights",
    "race_gene_set_entropy",
    "infer_gene_set_entropy",
    "crane_gene_set_entropy",
    "dirac_gene_set_entropy",
    "dirac_gene_set_classification",
    "crane_gene_set_classification",
    "DiracClassifier",
    "CraneClassifier",
]

from metworkpy import (
    utils,
    imat,
    gpr,
    information,
    divergence,
    metabolites,
    network,
    synleth,
)

from metworkpy.utils import (
    read_model,
    write_model,
    model_eq,
    model_bounds_eq,
    gene_to_reaction_dict,
    gene_to_reaction_df,
    gene_to_reaction_list,
    reaction_to_gene_list,
    reaction_to_gene_dict,
    reaction_to_gene_df,
)

from metworkpy.information import mutual_information, mi_network_adjacency_matrix

from metworkpy.divergence import kl_divergence, js_divergence

from metworkpy.network import (
    create_metabolic_network,
    create_mutual_information_network,
    create_adjacency_matrix,
    label_density,
    find_dense_clusters,
    bipartite_project,
)

from metworkpy.metabolites import (
    find_metabolite_synthesis_network_reactions,
    find_metabolite_synthesis_network_genes,
    metchange,
)

from metworkpy.gpr import eval_gpr, gene_to_rxn_weights

from metworkpy.rank_entropy import (
    race_gene_set_entropy,
    infer_gene_set_entropy,
    crane_gene_set_entropy,
    dirac_gene_set_entropy,
    dirac_gene_set_classification,
    crane_gene_set_classification,
    DiracClassifier,
    CraneClassifier,
)
