# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

try:
    from pydantic.v1 import validate_arguments, ValidationError
except ImportError:
    from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
try:
    from pydantic.v1 import Field, StrictBool, StrictBytes, StrictStr, conint, constr, validator
except ImportError:
    from pydantic import Field, StrictBool, StrictBytes, StrictStr, conint, constr, validator

from typing import Optional, Union

from lakefs_sdk.models.object_copy_creation import ObjectCopyCreation
from lakefs_sdk.models.object_error_list import ObjectErrorList
from lakefs_sdk.models.object_stats import ObjectStats
from lakefs_sdk.models.object_stats_list import ObjectStatsList
from lakefs_sdk.models.path_list import PathList
from lakefs_sdk.models.underlying_object_properties import UnderlyingObjectProperties
from lakefs_sdk.models.update_object_user_metadata import UpdateObjectUserMetadata

from lakefs_sdk.api_client import ApiClient
from lakefs_sdk.api_response import ApiResponse
from lakefs_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ObjectsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def copy_object(self, repository : StrictStr, branch : Annotated[StrictStr, Field(..., description="destination branch for the copy")], dest_path : Annotated[StrictStr, Field(..., description="destination path relative to the branch")], object_copy_creation : ObjectCopyCreation, **kwargs) -> ObjectStats:  # noqa: E501
        """create a copy of an object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.copy_object(repository, branch, dest_path, object_copy_creation, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param branch: destination branch for the copy (required)
        :type branch: str
        :param dest_path: destination path relative to the branch (required)
        :type dest_path: str
        :param object_copy_creation: (required)
        :type object_copy_creation: ObjectCopyCreation
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ObjectStats
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the copy_object_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.copy_object_with_http_info(repository, branch, dest_path, object_copy_creation, **kwargs)  # noqa: E501

    @validate_arguments
    def copy_object_with_http_info(self, repository : StrictStr, branch : Annotated[StrictStr, Field(..., description="destination branch for the copy")], dest_path : Annotated[StrictStr, Field(..., description="destination path relative to the branch")], object_copy_creation : ObjectCopyCreation, **kwargs) -> ApiResponse:  # noqa: E501
        """create a copy of an object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.copy_object_with_http_info(repository, branch, dest_path, object_copy_creation, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param branch: destination branch for the copy (required)
        :type branch: str
        :param dest_path: destination path relative to the branch (required)
        :type dest_path: str
        :param object_copy_creation: (required)
        :type object_copy_creation: ObjectCopyCreation
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ObjectStats, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'repository',
            'branch',
            'dest_path',
            'object_copy_creation'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_object" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['repository']:
            _path_params['repository'] = _params['repository']

        if _params['branch']:
            _path_params['branch'] = _params['branch']


        # process the query parameters
        _query_params = []
        if _params.get('dest_path') is not None:  # noqa: E501
            _query_params.append(('dest_path', _params['dest_path']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['object_copy_creation'] is not None:
            _body_params = _params['object_copy_creation']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basic_auth', 'cookie_auth', 'oidc_auth', 'saml_auth', 'jwt_token']  # noqa: E501

        _response_types_map = {
            '201': "ObjectStats",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '429': None,
        }

        return self.api_client.call_api(
            '/repositories/{repository}/branches/{branch}/objects/copy', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_object(self, repository : StrictStr, branch : StrictStr, path : Annotated[StrictStr, Field(..., description="relative to the branch")], force : Optional[StrictBool] = None, **kwargs) -> None:  # noqa: E501
        """delete object. Missing objects will not return a NotFound error.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_object(repository, branch, path, force, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param branch: (required)
        :type branch: str
        :param path: relative to the branch (required)
        :type path: str
        :param force:
        :type force: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_object_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_object_with_http_info(repository, branch, path, force, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_object_with_http_info(self, repository : StrictStr, branch : StrictStr, path : Annotated[StrictStr, Field(..., description="relative to the branch")], force : Optional[StrictBool] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """delete object. Missing objects will not return a NotFound error.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_object_with_http_info(repository, branch, path, force, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param branch: (required)
        :type branch: str
        :param path: relative to the branch (required)
        :type path: str
        :param force:
        :type force: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'repository',
            'branch',
            'path',
            'force'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_object" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['repository']:
            _path_params['repository'] = _params['repository']

        if _params['branch']:
            _path_params['branch'] = _params['branch']


        # process the query parameters
        _query_params = []
        if _params.get('path') is not None:  # noqa: E501
            _query_params.append(('path', _params['path']))

        if _params.get('force') is not None:  # noqa: E501
            _query_params.append(('force', _params['force']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basic_auth', 'cookie_auth', 'oidc_auth', 'saml_auth', 'jwt_token']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/repositories/{repository}/branches/{branch}/objects', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_objects(self, repository : StrictStr, branch : StrictStr, path_list : PathList, force : Optional[StrictBool] = None, **kwargs) -> ObjectErrorList:  # noqa: E501
        """delete objects. Missing objects will not return a NotFound error.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_objects(repository, branch, path_list, force, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param branch: (required)
        :type branch: str
        :param path_list: (required)
        :type path_list: PathList
        :param force:
        :type force: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ObjectErrorList
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_objects_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_objects_with_http_info(repository, branch, path_list, force, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_objects_with_http_info(self, repository : StrictStr, branch : StrictStr, path_list : PathList, force : Optional[StrictBool] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """delete objects. Missing objects will not return a NotFound error.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_objects_with_http_info(repository, branch, path_list, force, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param branch: (required)
        :type branch: str
        :param path_list: (required)
        :type path_list: PathList
        :param force:
        :type force: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ObjectErrorList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'repository',
            'branch',
            'path_list',
            'force'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_objects" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['repository']:
            _path_params['repository'] = _params['repository']

        if _params['branch']:
            _path_params['branch'] = _params['branch']


        # process the query parameters
        _query_params = []
        if _params.get('force') is not None:  # noqa: E501
            _query_params.append(('force', _params['force']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['path_list'] is not None:
            _body_params = _params['path_list']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basic_auth', 'cookie_auth', 'oidc_auth', 'saml_auth', 'jwt_token']  # noqa: E501

        _response_types_map = {
            '200': "ObjectErrorList",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '429': None,
        }

        return self.api_client.call_api(
            '/repositories/{repository}/branches/{branch}/objects/delete', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_object(self, repository : StrictStr, ref : Annotated[StrictStr, Field(..., description="a reference (could be either a branch or a commit ID)")], path : Annotated[StrictStr, Field(..., description="relative to the ref")], range : Annotated[Optional[constr(strict=True)], Field(description="Byte range to retrieve")] = None, if_none_match : Annotated[Optional[StrictStr], Field(description="Returns response only if the object does not have a matching ETag")] = None, presign : Optional[StrictBool] = None, **kwargs) -> bytearray:  # noqa: E501
        """get object content  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_object(repository, ref, path, range, if_none_match, presign, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param ref: a reference (could be either a branch or a commit ID) (required)
        :type ref: str
        :param path: relative to the ref (required)
        :type path: str
        :param range: Byte range to retrieve
        :type range: str
        :param if_none_match: Returns response only if the object does not have a matching ETag
        :type if_none_match: str
        :param presign:
        :type presign: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_object_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_object_with_http_info(repository, ref, path, range, if_none_match, presign, **kwargs)  # noqa: E501

    @validate_arguments
    def get_object_with_http_info(self, repository : StrictStr, ref : Annotated[StrictStr, Field(..., description="a reference (could be either a branch or a commit ID)")], path : Annotated[StrictStr, Field(..., description="relative to the ref")], range : Annotated[Optional[constr(strict=True)], Field(description="Byte range to retrieve")] = None, if_none_match : Annotated[Optional[StrictStr], Field(description="Returns response only if the object does not have a matching ETag")] = None, presign : Optional[StrictBool] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get object content  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_object_with_http_info(repository, ref, path, range, if_none_match, presign, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param ref: a reference (could be either a branch or a commit ID) (required)
        :type ref: str
        :param path: relative to the ref (required)
        :type path: str
        :param range: Byte range to retrieve
        :type range: str
        :param if_none_match: Returns response only if the object does not have a matching ETag
        :type if_none_match: str
        :param presign:
        :type presign: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'repository',
            'ref',
            'path',
            'range',
            'if_none_match',
            'presign'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_object" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['repository']:
            _path_params['repository'] = _params['repository']

        if _params['ref']:
            _path_params['ref'] = _params['ref']


        # process the query parameters
        _query_params = []
        if _params.get('path') is not None:  # noqa: E501
            _query_params.append(('path', _params['path']))

        if _params.get('presign') is not None:  # noqa: E501
            _query_params.append(('presign', _params['presign']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['range']:
            _header_params['Range'] = _params['range']

        if _params['if_none_match']:
            _header_params['If-None-Match'] = _params['if_none_match']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basic_auth', 'cookie_auth', 'oidc_auth', 'saml_auth', 'jwt_token']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '206': "bytearray",
            '302': None,
            '304': None,
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '410': "Error",
            '416': "Error",
            '429': None,
        }

        return self.api_client.call_api(
            '/repositories/{repository}/refs/{ref}/objects', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_underlying_properties(self, repository : StrictStr, ref : Annotated[StrictStr, Field(..., description="a reference (could be either a branch or a commit ID)")], path : Annotated[StrictStr, Field(..., description="relative to the branch")], **kwargs) -> UnderlyingObjectProperties:  # noqa: E501
        """get object properties on underlying storage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_underlying_properties(repository, ref, path, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param ref: a reference (could be either a branch or a commit ID) (required)
        :type ref: str
        :param path: relative to the branch (required)
        :type path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UnderlyingObjectProperties
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_underlying_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_underlying_properties_with_http_info(repository, ref, path, **kwargs)  # noqa: E501

    @validate_arguments
    def get_underlying_properties_with_http_info(self, repository : StrictStr, ref : Annotated[StrictStr, Field(..., description="a reference (could be either a branch or a commit ID)")], path : Annotated[StrictStr, Field(..., description="relative to the branch")], **kwargs) -> ApiResponse:  # noqa: E501
        """get object properties on underlying storage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_underlying_properties_with_http_info(repository, ref, path, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param ref: a reference (could be either a branch or a commit ID) (required)
        :type ref: str
        :param path: relative to the branch (required)
        :type path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UnderlyingObjectProperties, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'repository',
            'ref',
            'path'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_underlying_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['repository']:
            _path_params['repository'] = _params['repository']

        if _params['ref']:
            _path_params['ref'] = _params['ref']


        # process the query parameters
        _query_params = []
        if _params.get('path') is not None:  # noqa: E501
            _query_params.append(('path', _params['path']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basic_auth', 'cookie_auth', 'oidc_auth', 'saml_auth', 'jwt_token']  # noqa: E501

        _response_types_map = {
            '200': "UnderlyingObjectProperties",
            '401': "Error",
            '404': "Error",
            '429': None,
        }

        return self.api_client.call_api(
            '/repositories/{repository}/refs/{ref}/objects/underlyingProperties', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def head_object(self, repository : StrictStr, ref : Annotated[StrictStr, Field(..., description="a reference (could be either a branch or a commit ID)")], path : Annotated[StrictStr, Field(..., description="relative to the ref")], range : Annotated[Optional[constr(strict=True)], Field(description="Byte range to retrieve")] = None, **kwargs) -> None:  # noqa: E501
        """check if object exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.head_object(repository, ref, path, range, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param ref: a reference (could be either a branch or a commit ID) (required)
        :type ref: str
        :param path: relative to the ref (required)
        :type path: str
        :param range: Byte range to retrieve
        :type range: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the head_object_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.head_object_with_http_info(repository, ref, path, range, **kwargs)  # noqa: E501

    @validate_arguments
    def head_object_with_http_info(self, repository : StrictStr, ref : Annotated[StrictStr, Field(..., description="a reference (could be either a branch or a commit ID)")], path : Annotated[StrictStr, Field(..., description="relative to the ref")], range : Annotated[Optional[constr(strict=True)], Field(description="Byte range to retrieve")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """check if object exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.head_object_with_http_info(repository, ref, path, range, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param ref: a reference (could be either a branch or a commit ID) (required)
        :type ref: str
        :param path: relative to the ref (required)
        :type path: str
        :param range: Byte range to retrieve
        :type range: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'repository',
            'ref',
            'path',
            'range'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method head_object" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['repository']:
            _path_params['repository'] = _params['repository']

        if _params['ref']:
            _path_params['ref'] = _params['ref']


        # process the query parameters
        _query_params = []
        if _params.get('path') is not None:  # noqa: E501
            _query_params.append(('path', _params['path']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['range']:
            _header_params['Range'] = _params['range']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = ['basic_auth', 'cookie_auth', 'oidc_auth', 'saml_auth', 'jwt_token']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/repositories/{repository}/refs/{ref}/objects', 'HEAD',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_objects(self, repository : StrictStr, ref : Annotated[StrictStr, Field(..., description="a reference (could be either a branch or a commit ID)")], user_metadata : Optional[StrictBool] = None, presign : Optional[StrictBool] = None, after : Annotated[Optional[StrictStr], Field(description="return items after this value")] = None, amount : Annotated[Optional[conint(strict=True, le=1000, ge=-1)], Field(description="how many items to return")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="delimiter used to group common prefixes by")] = None, prefix : Annotated[Optional[StrictStr], Field(description="return items prefixed with this value")] = None, **kwargs) -> ObjectStatsList:  # noqa: E501
        """list objects under a given prefix  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_objects(repository, ref, user_metadata, presign, after, amount, delimiter, prefix, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param ref: a reference (could be either a branch or a commit ID) (required)
        :type ref: str
        :param user_metadata:
        :type user_metadata: bool
        :param presign:
        :type presign: bool
        :param after: return items after this value
        :type after: str
        :param amount: how many items to return
        :type amount: int
        :param delimiter: delimiter used to group common prefixes by
        :type delimiter: str
        :param prefix: return items prefixed with this value
        :type prefix: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ObjectStatsList
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_objects_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_objects_with_http_info(repository, ref, user_metadata, presign, after, amount, delimiter, prefix, **kwargs)  # noqa: E501

    @validate_arguments
    def list_objects_with_http_info(self, repository : StrictStr, ref : Annotated[StrictStr, Field(..., description="a reference (could be either a branch or a commit ID)")], user_metadata : Optional[StrictBool] = None, presign : Optional[StrictBool] = None, after : Annotated[Optional[StrictStr], Field(description="return items after this value")] = None, amount : Annotated[Optional[conint(strict=True, le=1000, ge=-1)], Field(description="how many items to return")] = None, delimiter : Annotated[Optional[StrictStr], Field(description="delimiter used to group common prefixes by")] = None, prefix : Annotated[Optional[StrictStr], Field(description="return items prefixed with this value")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """list objects under a given prefix  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_objects_with_http_info(repository, ref, user_metadata, presign, after, amount, delimiter, prefix, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param ref: a reference (could be either a branch or a commit ID) (required)
        :type ref: str
        :param user_metadata:
        :type user_metadata: bool
        :param presign:
        :type presign: bool
        :param after: return items after this value
        :type after: str
        :param amount: how many items to return
        :type amount: int
        :param delimiter: delimiter used to group common prefixes by
        :type delimiter: str
        :param prefix: return items prefixed with this value
        :type prefix: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ObjectStatsList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'repository',
            'ref',
            'user_metadata',
            'presign',
            'after',
            'amount',
            'delimiter',
            'prefix'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_objects" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['repository']:
            _path_params['repository'] = _params['repository']

        if _params['ref']:
            _path_params['ref'] = _params['ref']


        # process the query parameters
        _query_params = []
        if _params.get('user_metadata') is not None:  # noqa: E501
            _query_params.append(('user_metadata', _params['user_metadata']))

        if _params.get('presign') is not None:  # noqa: E501
            _query_params.append(('presign', _params['presign']))

        if _params.get('after') is not None:  # noqa: E501
            _query_params.append(('after', _params['after']))

        if _params.get('amount') is not None:  # noqa: E501
            _query_params.append(('amount', _params['amount']))

        if _params.get('delimiter') is not None:  # noqa: E501
            _query_params.append(('delimiter', _params['delimiter']))

        if _params.get('prefix') is not None:  # noqa: E501
            _query_params.append(('prefix', _params['prefix']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basic_auth', 'cookie_auth', 'oidc_auth', 'saml_auth', 'jwt_token']  # noqa: E501

        _response_types_map = {
            '200': "ObjectStatsList",
            '401': "Error",
            '404': "Error",
            '429': None,
        }

        return self.api_client.call_api(
            '/repositories/{repository}/refs/{ref}/objects/ls', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def stat_object(self, repository : StrictStr, ref : Annotated[StrictStr, Field(..., description="a reference (could be either a branch or a commit ID)")], path : Annotated[StrictStr, Field(..., description="relative to the branch")], user_metadata : Optional[StrictBool] = None, presign : Optional[StrictBool] = None, **kwargs) -> ObjectStats:  # noqa: E501
        """get object metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stat_object(repository, ref, path, user_metadata, presign, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param ref: a reference (could be either a branch or a commit ID) (required)
        :type ref: str
        :param path: relative to the branch (required)
        :type path: str
        :param user_metadata:
        :type user_metadata: bool
        :param presign:
        :type presign: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ObjectStats
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the stat_object_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.stat_object_with_http_info(repository, ref, path, user_metadata, presign, **kwargs)  # noqa: E501

    @validate_arguments
    def stat_object_with_http_info(self, repository : StrictStr, ref : Annotated[StrictStr, Field(..., description="a reference (could be either a branch or a commit ID)")], path : Annotated[StrictStr, Field(..., description="relative to the branch")], user_metadata : Optional[StrictBool] = None, presign : Optional[StrictBool] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get object metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stat_object_with_http_info(repository, ref, path, user_metadata, presign, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param ref: a reference (could be either a branch or a commit ID) (required)
        :type ref: str
        :param path: relative to the branch (required)
        :type path: str
        :param user_metadata:
        :type user_metadata: bool
        :param presign:
        :type presign: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ObjectStats, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'repository',
            'ref',
            'path',
            'user_metadata',
            'presign'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stat_object" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['repository']:
            _path_params['repository'] = _params['repository']

        if _params['ref']:
            _path_params['ref'] = _params['ref']


        # process the query parameters
        _query_params = []
        if _params.get('path') is not None:  # noqa: E501
            _query_params.append(('path', _params['path']))

        if _params.get('user_metadata') is not None:  # noqa: E501
            _query_params.append(('user_metadata', _params['user_metadata']))

        if _params.get('presign') is not None:  # noqa: E501
            _query_params.append(('presign', _params['presign']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basic_auth', 'cookie_auth', 'oidc_auth', 'saml_auth', 'jwt_token']  # noqa: E501

        _response_types_map = {
            '200': "ObjectStats",
            '401': "Error",
            '404': "Error",
            '400': "Error",
            '410': None,
            '429': None,
        }

        return self.api_client.call_api(
            '/repositories/{repository}/refs/{ref}/objects/stat', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_object_user_metadata(self, repository : StrictStr, branch : Annotated[StrictStr, Field(..., description="branch to update")], path : Annotated[StrictStr, Field(..., description="path to object relative to the branch")], update_object_user_metadata : UpdateObjectUserMetadata, **kwargs) -> None:  # noqa: E501
        """rewrite (all) object metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_object_user_metadata(repository, branch, path, update_object_user_metadata, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param branch: branch to update (required)
        :type branch: str
        :param path: path to object relative to the branch (required)
        :type path: str
        :param update_object_user_metadata: (required)
        :type update_object_user_metadata: UpdateObjectUserMetadata
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_object_user_metadata_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.update_object_user_metadata_with_http_info(repository, branch, path, update_object_user_metadata, **kwargs)  # noqa: E501

    @validate_arguments
    def update_object_user_metadata_with_http_info(self, repository : StrictStr, branch : Annotated[StrictStr, Field(..., description="branch to update")], path : Annotated[StrictStr, Field(..., description="path to object relative to the branch")], update_object_user_metadata : UpdateObjectUserMetadata, **kwargs) -> ApiResponse:  # noqa: E501
        """rewrite (all) object metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_object_user_metadata_with_http_info(repository, branch, path, update_object_user_metadata, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param branch: branch to update (required)
        :type branch: str
        :param path: path to object relative to the branch (required)
        :type path: str
        :param update_object_user_metadata: (required)
        :type update_object_user_metadata: UpdateObjectUserMetadata
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'repository',
            'branch',
            'path',
            'update_object_user_metadata'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_object_user_metadata" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['repository']:
            _path_params['repository'] = _params['repository']

        if _params['branch']:
            _path_params['branch'] = _params['branch']


        # process the query parameters
        _query_params = []
        if _params.get('path') is not None:  # noqa: E501
            _query_params.append(('path', _params['path']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_object_user_metadata'] is not None:
            _body_params = _params['update_object_user_metadata']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basic_auth', 'cookie_auth', 'oidc_auth', 'saml_auth', 'jwt_token']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/repositories/{repository}/branches/{branch}/objects/stat/user_metadata', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def upload_object(self, repository : StrictStr, branch : StrictStr, path : Annotated[StrictStr, Field(..., description="relative to the branch")], if_none_match : Annotated[Optional[StrictStr], Field(description="Set to \"*\" to atomically allow the upload only if the key has no object yet. Other values are not supported.")] = None, storage_class : Annotated[Optional[StrictStr], Field(description="Deprecated, this capability will not be supported in future releases.")] = None, force : Optional[StrictBool] = None, content : Annotated[Optional[Union[StrictBytes, StrictStr]], Field(description="Only a single file per upload which must be named \\\"content\\\".")] = None, **kwargs) -> ObjectStats:  # noqa: E501
        """upload_object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_object(repository, branch, path, if_none_match, storage_class, force, content, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param branch: (required)
        :type branch: str
        :param path: relative to the branch (required)
        :type path: str
        :param if_none_match: Set to \"*\" to atomically allow the upload only if the key has no object yet. Other values are not supported.
        :type if_none_match: str
        :param storage_class: Deprecated, this capability will not be supported in future releases.
        :type storage_class: str
        :param force:
        :type force: bool
        :param content: Only a single file per upload which must be named \\\"content\\\".
        :type content: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ObjectStats
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upload_object_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.upload_object_with_http_info(repository, branch, path, if_none_match, storage_class, force, content, **kwargs)  # noqa: E501

    @validate_arguments
    def upload_object_with_http_info(self, repository : StrictStr, branch : StrictStr, path : Annotated[StrictStr, Field(..., description="relative to the branch")], if_none_match : Annotated[Optional[StrictStr], Field(description="Set to \"*\" to atomically allow the upload only if the key has no object yet. Other values are not supported.")] = None, storage_class : Annotated[Optional[StrictStr], Field(description="Deprecated, this capability will not be supported in future releases.")] = None, force : Optional[StrictBool] = None, content : Annotated[Optional[Union[StrictBytes, StrictStr]], Field(description="Only a single file per upload which must be named \\\"content\\\".")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """upload_object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_object_with_http_info(repository, branch, path, if_none_match, storage_class, force, content, async_req=True)
        >>> result = thread.get()

        :param repository: (required)
        :type repository: str
        :param branch: (required)
        :type branch: str
        :param path: relative to the branch (required)
        :type path: str
        :param if_none_match: Set to \"*\" to atomically allow the upload only if the key has no object yet. Other values are not supported.
        :type if_none_match: str
        :param storage_class: Deprecated, this capability will not be supported in future releases.
        :type storage_class: str
        :param force:
        :type force: bool
        :param content: Only a single file per upload which must be named \\\"content\\\".
        :type content: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ObjectStats, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'repository',
            'branch',
            'path',
            'if_none_match',
            'storage_class',
            'force',
            'content'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_object" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['repository']:
            _path_params['repository'] = _params['repository']

        if _params['branch']:
            _path_params['branch'] = _params['branch']


        # process the query parameters
        _query_params = []
        if _params.get('path') is not None:  # noqa: E501
            _query_params.append(('path', _params['path']))

        if _params.get('storage_class') is not None:  # noqa: E501
            _query_params.append(('storageClass', _params['storage_class']))

        if _params.get('force') is not None:  # noqa: E501
            _query_params.append(('force', _params['force']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['if_none_match']:
            _header_params['If-None-Match'] = _params['if_none_match']

        # process the form parameters
        _form_params = []
        _files = {}
        if _params['content']:
            _files['content'] = _params['content']

        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data', 'application/octet-stream']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basic_auth', 'cookie_auth', 'oidc_auth', 'saml_auth', 'jwt_token']  # noqa: E501

        _response_types_map = {
            '201': "ObjectStats",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '412': "Error",
            '429': None,
        }

        return self.api_client.call_api(
            '/repositories/{repository}/branches/{branch}/objects', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
