# haplohub
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 1.0.0
- Generator version: 7.11.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import haplohub
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import haplohub
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import haplohub
from haplohub.rest import ApiException
from pprint import pprint

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: 
configuration = haplohub.Configuration(
    access_token=os.environ["API_KEY"]
)


# Enter a context with an instance of the API client
with haplohub.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = haplohub.ApiKeyApi(api_client)
    create_api_key_schema = haplohub.CreateApiKeySchema() # CreateApiKeySchema | 

    try:
        # Create Api Key
        api_response = api_instance.haplohub_api_v1_api_key_create_api_key(create_api_key_schema)
        print("The response of ApiKeyApi->haplohub_api_v1_api_key_create_api_key:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ApiKeyApi->haplohub_api_v1_api_key_create_api_key: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApiKeyApi* | [**haplohub_api_v1_api_key_create_api_key**](docs/ApiKeyApi.md#haplohub_api_v1_api_key_create_api_key) | **POST** /api/v1/api-key/ | Create Api Key
*ApiKeyApi* | [**haplohub_api_v1_api_key_delete_api_key**](docs/ApiKeyApi.md#haplohub_api_v1_api_key_delete_api_key) | **DELETE** /api/v1/api-key/{api_key_id}/ | Delete Api Key
*ApiKeyApi* | [**haplohub_api_v1_api_key_list_api_keys**](docs/ApiKeyApi.md#haplohub_api_v1_api_key_list_api_keys) | **GET** /api/v1/api-key/ | List Api Keys
*BiomarkerApi* | [**list_biomarker_results**](docs/BiomarkerApi.md#list_biomarker_results) | **GET** /api/v1/cohort/{cohort_id}/biomarker/result/ | List biomarker results
*CohortApi* | [**create_cohort**](docs/CohortApi.md#create_cohort) | **POST** /api/v1/cohort/ | Create cohort
*CohortApi* | [**delete_cohort**](docs/CohortApi.md#delete_cohort) | **DELETE** /api/v1/cohort/{cohort_id}/ | Delete cohort
*CohortApi* | [**get_cohort**](docs/CohortApi.md#get_cohort) | **GET** /api/v1/cohort/{cohort_id}/ | Get cohort
*CohortApi* | [**list_cohorts**](docs/CohortApi.md#list_cohorts) | **GET** /api/v1/cohort/ | List cohorts
*CohortApi* | [**update_cohort**](docs/CohortApi.md#update_cohort) | **PUT** /api/v1/cohort/{cohort_id}/ | Update cohort
*EnvironmentApi* | [**create_environment**](docs/EnvironmentApi.md#create_environment) | **POST** /api/v1/environment/ | Create environment
*EnvironmentApi* | [**list_environments**](docs/EnvironmentApi.md#list_environments) | **GET** /api/v1/environment/ | List environments
*EnvironmentApi* | [**switch_environment**](docs/EnvironmentApi.md#switch_environment) | **POST** /api/v1/environment/{environment_id}/switch/ | Switch environment
*FileApi* | [**delete_file**](docs/FileApi.md#delete_file) | **DELETE** /api/v1/cohort/{cohort_id}/file/{file_id}/ | Delete file
*FileApi* | [**download_link**](docs/FileApi.md#download_link) | **POST** /api/v1/cohort/{cohort_id}/file/{file_id}/download-link/ | Get download link
*FileApi* | [**download_link_by_path**](docs/FileApi.md#download_link_by_path) | **POST** /api/v1/cohort/{cohort_id}/file/download-link/ | Get download link by file path
*FileApi* | [**get_file**](docs/FileApi.md#get_file) | **GET** /api/v1/cohort/{cohort_id}/file/{file_id}/ | Get file
*FileApi* | [**list_files**](docs/FileApi.md#list_files) | **GET** /api/v1/cohort/{cohort_id}/file/ | List files
*LogApi* | [**list_logs**](docs/LogApi.md#list_logs) | **GET** /api/v1/log/ | List logs
*MemberApi* | [**create_member**](docs/MemberApi.md#create_member) | **POST** /api/v1/cohort/{cohort_id}/member/ | Create member
*MemberApi* | [**delete_member**](docs/MemberApi.md#delete_member) | **DELETE** /api/v1/cohort/{cohort_id}/member/{member_id}/ | Delete member
*MemberApi* | [**get_member**](docs/MemberApi.md#get_member) | **GET** /api/v1/cohort/{cohort_id}/member/{member_id}/ | Get member
*MemberApi* | [**list_members**](docs/MemberApi.md#list_members) | **GET** /api/v1/cohort/{cohort_id}/member/ | List members
*MemberApi* | [**update_member**](docs/MemberApi.md#update_member) | **PUT** /api/v1/cohort/{cohort_id}/member/{member_id}/ | Update member
*MemberReportApi* | [**create_member_report**](docs/MemberReportApi.md#create_member_report) | **POST** /api/v1/cohort/{cohort_id}/member/{member_id}/report/{report_template_id}/create/ | Create member report
*MetadataApi* | [**list_accession**](docs/MetadataApi.md#list_accession) | **GET** /api/v1/metadata/accession/ | List Accessions
*ModelApi* | [**create_model**](docs/ModelApi.md#create_model) | **POST** /api/v1/model/ | Create model
*ModelApi* | [**list_models**](docs/ModelApi.md#list_models) | **GET** /api/v1/model/ | List models
*ModelApi* | [**push_model**](docs/ModelApi.md#push_model) | **POST** /api/v1/model/{model_id}/push/ | Push model
*PredictionApi* | [**get_prediction**](docs/PredictionApi.md#get_prediction) | **GET** /api/v1/prediction/{prediction_id}/ | Get prediction
*PredictionApi* | [**get_prediction_results**](docs/PredictionApi.md#get_prediction_results) | **GET** /api/v1/prediction/{prediction_id}/results/ | Get prediction results
*PredictionApi* | [**list_predictions**](docs/PredictionApi.md#list_predictions) | **GET** /api/v1/prediction/ | List predictions
*PredictionApi* | [**run_prediction**](docs/PredictionApi.md#run_prediction) | **POST** /api/v1/prediction/ | Run prediction
*ReportTemplateApi* | [**create_report_template**](docs/ReportTemplateApi.md#create_report_template) | **POST** /api/v1/report-template/ | Create report template
*ReportTemplateApi* | [**delete_report_template**](docs/ReportTemplateApi.md#delete_report_template) | **DELETE** /api/v1/report-template/{report_template_id}/ | Delete report template
*ReportTemplateApi* | [**get_report_template**](docs/ReportTemplateApi.md#get_report_template) | **GET** /api/v1/report-template/{report_template_id}/ | Get report template
*ReportTemplateApi* | [**list_report_templates**](docs/ReportTemplateApi.md#list_report_templates) | **GET** /api/v1/report-template/ | List report templates
*ReportTemplateApi* | [**preview_report_template**](docs/ReportTemplateApi.md#preview_report_template) | **GET** /api/v1/report-template/{report_template_id}/preview/ | Preview report template
*ReportTemplateApi* | [**update_report_template**](docs/ReportTemplateApi.md#update_report_template) | **PUT** /api/v1/report-template/{report_template_id}/ | Update report template
*SampleApi* | [**create_sample**](docs/SampleApi.md#create_sample) | **POST** /api/v1/cohort/{cohort_id}/sample/ | Create sample
*SampleApi* | [**delete_sample**](docs/SampleApi.md#delete_sample) | **DELETE** /api/v1/cohort/{cohort_id}/sample/{sample_id}/ | Delete sample
*SampleApi* | [**get_sample**](docs/SampleApi.md#get_sample) | **GET** /api/v1/cohort/{cohort_id}/sample/{sample_id}/ | Get sample
*SampleApi* | [**hgvs_dosage**](docs/SampleApi.md#hgvs_dosage) | **GET** /api/v1/sample/ | Fetch the dosage of a given allele for a sample based on the hgvs nomenclature. For example &#39;NC_000001.11:g.11794419T&gt;G&#39;
*SampleApi* | [**list_samples**](docs/SampleApi.md#list_samples) | **GET** /api/v1/cohort/{cohort_id}/sample/ | List samples
*SampleApi* | [**update_sample**](docs/SampleApi.md#update_sample) | **PUT** /api/v1/cohort/{cohort_id}/sample/{sample_id}/ | Update sample
*UploadApi* | [**create_upload_request**](docs/UploadApi.md#create_upload_request) | **POST** /api/v1/cohort/{cohort_id}/upload/request/ | Create upload request
*VariantApi* | [**get_variant**](docs/VariantApi.md#get_variant) | **POST** /api/v1/cohort/{cohort_id}/variant/ | Get Variant
*VariantApi* | [**lookup_hgvs**](docs/VariantApi.md#lookup_hgvs) | **POST** /api/v1/cohort/{cohort_id}/variant/hgvs/ | Lookup Hgvs
*WorkflowApi* | [**get_workflow_run**](docs/WorkflowApi.md#get_workflow_run) | **GET** /api/v1/workflow/run/{workflow_run_id}/ | Get workflow run
*WorkflowApi* | [**list_workflow_runs**](docs/WorkflowApi.md#list_workflow_runs) | **GET** /api/v1/workflow/run/ | List workflow runs
*DefaultApi* | [**status**](docs/DefaultApi.md#status) | **GET** /api/v1/status/ | Status


## Documentation For Models

 - [AccessionSchema](docs/AccessionSchema.md)
 - [ApiKeySchema](docs/ApiKeySchema.md)
 - [AuthSchema](docs/AuthSchema.md)
 - [BiomarkerResultSchema](docs/BiomarkerResultSchema.md)
 - [CohortDetailSchema](docs/CohortDetailSchema.md)
 - [CohortSchema](docs/CohortSchema.md)
 - [CreateApiKeySchema](docs/CreateApiKeySchema.md)
 - [CreateCohortRequest](docs/CreateCohortRequest.md)
 - [CreateCohortResponse](docs/CreateCohortResponse.md)
 - [CreateEnvironmentRequest](docs/CreateEnvironmentRequest.md)
 - [CreateEnvironmentResponse](docs/CreateEnvironmentResponse.md)
 - [CreateMemberRequest](docs/CreateMemberRequest.md)
 - [CreateModelRequest](docs/CreateModelRequest.md)
 - [CreateModelResponse](docs/CreateModelResponse.md)
 - [CreateReportTemplateRequest](docs/CreateReportTemplateRequest.md)
 - [CreateReportTemplateResponse](docs/CreateReportTemplateResponse.md)
 - [CreateSampleRequest](docs/CreateSampleRequest.md)
 - [CreateUploadRequestRequest](docs/CreateUploadRequestRequest.md)
 - [DetailWorkflowRunSchema](docs/DetailWorkflowRunSchema.md)
 - [DirSchema](docs/DirSchema.md)
 - [DownloadLinkSchema](docs/DownloadLinkSchema.md)
 - [EnvironmentSchema](docs/EnvironmentSchema.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [ErrorSchema](docs/ErrorSchema.md)
 - [FileDirSchema](docs/FileDirSchema.md)
 - [FileInfo](docs/FileInfo.md)
 - [FileSchema](docs/FileSchema.md)
 - [GenericResponse](docs/GenericResponse.md)
 - [GetCohortResponse](docs/GetCohortResponse.md)
 - [GetHgvsResponse](docs/GetHgvsResponse.md)
 - [GetPredictionResponse](docs/GetPredictionResponse.md)
 - [GetPredictionResultsResponse](docs/GetPredictionResultsResponse.md)
 - [GetReportTemplateResponse](docs/GetReportTemplateResponse.md)
 - [GetVariantRequest](docs/GetVariantRequest.md)
 - [HgvsDosageSchema](docs/HgvsDosageSchema.md)
 - [HgvsSchema](docs/HgvsSchema.md)
 - [InfinityPaginatedResponseLogSchema](docs/InfinityPaginatedResponseLogSchema.md)
 - [ListFilesFilter](docs/ListFilesFilter.md)
 - [LogSchema](docs/LogSchema.md)
 - [LookupHgvsRequest](docs/LookupHgvsRequest.md)
 - [MLModelSchema](docs/MLModelSchema.md)
 - [MemberSchema](docs/MemberSchema.md)
 - [ModelId](docs/ModelId.md)
 - [OrderSchema](docs/OrderSchema.md)
 - [PaginatedResponseAccessionSchema](docs/PaginatedResponseAccessionSchema.md)
 - [PaginatedResponseApiKeySchema](docs/PaginatedResponseApiKeySchema.md)
 - [PaginatedResponseCohortSchema](docs/PaginatedResponseCohortSchema.md)
 - [PaginatedResponseEnvironmentSchema](docs/PaginatedResponseEnvironmentSchema.md)
 - [PaginatedResponseMLModelSchema](docs/PaginatedResponseMLModelSchema.md)
 - [PaginatedResponseMemberSchema](docs/PaginatedResponseMemberSchema.md)
 - [PaginatedResponsePredictionSchema](docs/PaginatedResponsePredictionSchema.md)
 - [PaginatedResponseReportTemplateSchema](docs/PaginatedResponseReportTemplateSchema.md)
 - [PaginatedResponseSampleSchema](docs/PaginatedResponseSampleSchema.md)
 - [PaginatedResponseWorkflowRunSchema](docs/PaginatedResponseWorkflowRunSchema.md)
 - [PredictionResultsSchema](docs/PredictionResultsSchema.md)
 - [PredictionSchema](docs/PredictionSchema.md)
 - [PredictionStatus](docs/PredictionStatus.md)
 - [PushCredentials](docs/PushCredentials.md)
 - [PushModelRequest](docs/PushModelRequest.md)
 - [ReportTemplateSchema](docs/ReportTemplateSchema.md)
 - [ReportType](docs/ReportType.md)
 - [RequestSchema](docs/RequestSchema.md)
 - [Response](docs/Response.md)
 - [ResponseSchema](docs/ResponseSchema.md)
 - [ResponseStatus](docs/ResponseStatus.md)
 - [ResultListResponseBiomarkerResultSchema](docs/ResultListResponseBiomarkerResultSchema.md)
 - [ResultListResponseHgvsSchema](docs/ResultListResponseHgvsSchema.md)
 - [ResultListResponseVariantSchema](docs/ResultListResponseVariantSchema.md)
 - [ResultResponse](docs/ResultResponse.md)
 - [ResultResponseApiKeySchema](docs/ResultResponseApiKeySchema.md)
 - [ResultResponseDetailWorkflowRunSchema](docs/ResultResponseDetailWorkflowRunSchema.md)
 - [ResultResponseDownloadLinkSchema](docs/ResultResponseDownloadLinkSchema.md)
 - [ResultResponseFileDirSchema](docs/ResultResponseFileDirSchema.md)
 - [ResultResponseFileSchema](docs/ResultResponseFileSchema.md)
 - [ResultResponseMemberSchema](docs/ResultResponseMemberSchema.md)
 - [ResultResponsePushCredentials](docs/ResultResponsePushCredentials.md)
 - [ResultResponseSampleSchema](docs/ResultResponseSampleSchema.md)
 - [ResultResponseUploadRequestResponse](docs/ResultResponseUploadRequestResponse.md)
 - [ResultSchema](docs/ResultSchema.md)
 - [RunPredictionRequest](docs/RunPredictionRequest.md)
 - [RunPredictionResponse](docs/RunPredictionResponse.md)
 - [SampleSchema](docs/SampleSchema.md)
 - [SuccessResponse](docs/SuccessResponse.md)
 - [SwitchEnvironmentResponse](docs/SwitchEnvironmentResponse.md)
 - [TenantSchema](docs/TenantSchema.md)
 - [UpdateCohortRequest](docs/UpdateCohortRequest.md)
 - [UpdateCohortResponse](docs/UpdateCohortResponse.md)
 - [UpdateMemberRequest](docs/UpdateMemberRequest.md)
 - [UpdateReportTemplateRequest](docs/UpdateReportTemplateRequest.md)
 - [UpdateReportTemplateResponse](docs/UpdateReportTemplateResponse.md)
 - [UpdateSampleRequest](docs/UpdateSampleRequest.md)
 - [UploadLink](docs/UploadLink.md)
 - [UploadRequestResponse](docs/UploadRequestResponse.md)
 - [UploadType](docs/UploadType.md)
 - [UserSchema](docs/UserSchema.md)
 - [VariantRange](docs/VariantRange.md)
 - [VariantSchema](docs/VariantSchema.md)
 - [WorkflowHistorySchema](docs/WorkflowHistorySchema.md)
 - [WorkflowRunSchema](docs/WorkflowRunSchema.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="Auth0JWTBearer"></a>
### Auth0JWTBearer

- **Type**: Bearer authentication


## Author




