# coding: utf-8

"""
HaploHub API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 1.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

import re  # noqa: F401
from typing import Optional

from pydantic import StrictBool, StrictStr, validate_arguments

from haplohub.api_client import ApiClient
from haplohub.api_response import ApiResponse
from haplohub.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from haplohub.models.result_response import ResultResponse
from haplohub.models.result_response_download_link_schema import ResultResponseDownloadLinkSchema
from haplohub.models.result_response_file_dir_schema import ResultResponseFileDirSchema
from haplohub.models.result_response_file_schema import ResultResponseFileSchema


class FileApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def delete_file(self, cohort_id: StrictStr, file_id: StrictStr, **kwargs) -> ResultResponse:  # noqa: E501
        """Delete file  # noqa: E501

        Delete file by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_file(cohort_id, file_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param file_id: (required)
        :type file_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResultResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the delete_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_file_with_http_info(cohort_id, file_id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_file_with_http_info(self, cohort_id: StrictStr, file_id: StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete file  # noqa: E501

        Delete file by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_file_with_http_info(cohort_id, file_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param file_id: (required)
        :type file_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResultResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["cohort_id", "file_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s' to method delete_file" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["cohort_id"] is not None:
            _path_params["cohort_id"] = _params["cohort_id"]

        if _params["file_id"] is not None:
            _path_params["file_id"] = _params["file_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["Auth0JWTBearer"]  # noqa: E501

        _response_types_map = {
            "200": "ResultResponse",
        }

        return self.api_client.call_api(
            "/api/v1/cohort/{cohort_id}/file/{file_id}/",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def download_link(self, cohort_id: StrictStr, file_id: StrictStr, **kwargs) -> ResultResponseDownloadLinkSchema:  # noqa: E501
        """Get download link  # noqa: E501

        Get download link by file ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_link(cohort_id, file_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param file_id: (required)
        :type file_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResultResponseDownloadLinkSchema
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the download_link_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.download_link_with_http_info(cohort_id, file_id, **kwargs)  # noqa: E501

    @validate_arguments
    def download_link_with_http_info(self, cohort_id: StrictStr, file_id: StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get download link  # noqa: E501

        Get download link by file ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_link_with_http_info(cohort_id, file_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param file_id: (required)
        :type file_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResultResponseDownloadLinkSchema, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["cohort_id", "file_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s' to method download_link" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["cohort_id"] is not None:
            _path_params["cohort_id"] = _params["cohort_id"]

        if _params["file_id"] is not None:
            _path_params["file_id"] = _params["file_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["Auth0JWTBearer"]  # noqa: E501

        _response_types_map = {
            "200": "ResultResponseDownloadLinkSchema",
        }

        return self.api_client.call_api(
            "/api/v1/cohort/{cohort_id}/file/{file_id}/download-link/",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def download_link_by_path(self, cohort_id: StrictStr, path: StrictStr, **kwargs) -> ResultResponseDownloadLinkSchema:  # noqa: E501
        """Get download link by file path  # noqa: E501

        Get download link by file path  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_link_by_path(cohort_id, path, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param path: (required)
        :type path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResultResponseDownloadLinkSchema
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the download_link_by_path_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.download_link_by_path_with_http_info(cohort_id, path, **kwargs)  # noqa: E501

    @validate_arguments
    def download_link_by_path_with_http_info(self, cohort_id: StrictStr, path: StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get download link by file path  # noqa: E501

        Get download link by file path  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_link_by_path_with_http_info(cohort_id, path, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param path: (required)
        :type path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResultResponseDownloadLinkSchema, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["cohort_id", "path"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s' to method download_link_by_path" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["cohort_id"] is not None:
            _path_params["cohort_id"] = _params["cohort_id"]

        # process the query parameters
        _query_params = []
        if _params.get("path") is not None:  # noqa: E501
            _query_params.append(("path", _params["path"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["Auth0JWTBearer"]  # noqa: E501

        _response_types_map = {
            "200": "ResultResponseDownloadLinkSchema",
        }

        return self.api_client.call_api(
            "/api/v1/cohort/{cohort_id}/file/download-link/",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_file(self, cohort_id: StrictStr, file_id: StrictStr, **kwargs) -> ResultResponseFileSchema:  # noqa: E501
        """Get file  # noqa: E501

        Get file by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file(cohort_id, file_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param file_id: (required)
        :type file_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResultResponseFileSchema
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_file_with_http_info(cohort_id, file_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_file_with_http_info(self, cohort_id: StrictStr, file_id: StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get file  # noqa: E501

        Get file by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_with_http_info(cohort_id, file_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param file_id: (required)
        :type file_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResultResponseFileSchema, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["cohort_id", "file_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s' to method get_file" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["cohort_id"] is not None:
            _path_params["cohort_id"] = _params["cohort_id"]

        if _params["file_id"] is not None:
            _path_params["file_id"] = _params["file_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["Auth0JWTBearer"]  # noqa: E501

        _response_types_map = {
            "200": "ResultResponseFileSchema",
        }

        return self.api_client.call_api(
            "/api/v1/cohort/{cohort_id}/file/{file_id}/",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_files(
        self,
        cohort_id: StrictStr,
        recursive: Optional[StrictBool] = None,
        sample_id: Optional[StrictStr] = None,
        member_id: Optional[StrictStr] = None,
        path: Optional[StrictStr] = None,
        **kwargs,
    ) -> ResultResponseFileDirSchema:  # noqa: E501
        """List files  # noqa: E501

        List all files  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_files(cohort_id, recursive, sample_id, member_id, path, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param recursive:
        :type recursive: bool
        :param sample_id:
        :type sample_id: str
        :param member_id:
        :type member_id: str
        :param path:
        :type path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResultResponseFileDirSchema
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_files_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_files_with_http_info(cohort_id, recursive, sample_id, member_id, path, **kwargs)  # noqa: E501

    @validate_arguments
    def list_files_with_http_info(
        self,
        cohort_id: StrictStr,
        recursive: Optional[StrictBool] = None,
        sample_id: Optional[StrictStr] = None,
        member_id: Optional[StrictStr] = None,
        path: Optional[StrictStr] = None,
        **kwargs,
    ) -> ApiResponse:  # noqa: E501
        """List files  # noqa: E501

        List all files  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_files_with_http_info(cohort_id, recursive, sample_id, member_id, path, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param recursive:
        :type recursive: bool
        :param sample_id:
        :type sample_id: str
        :param member_id:
        :type member_id: str
        :param path:
        :type path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResultResponseFileDirSchema, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["cohort_id", "recursive", "sample_id", "member_id", "path"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s' to method list_files" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["cohort_id"] is not None:
            _path_params["cohort_id"] = _params["cohort_id"]

        # process the query parameters
        _query_params = []
        if _params.get("recursive") is not None:  # noqa: E501
            _query_params.append(("recursive", _params["recursive"]))

        if _params.get("sample_id") is not None:  # noqa: E501
            _query_params.append(("sample_id", _params["sample_id"]))

        if _params.get("member_id") is not None:  # noqa: E501
            _query_params.append(("member_id", _params["member_id"]))

        if _params.get("path") is not None:  # noqa: E501
            _query_params.append(("path", _params["path"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["Auth0JWTBearer"]  # noqa: E501

        _response_types_map = {
            "200": "ResultResponseFileDirSchema",
        }

        return self.api_client.call_api(
            "/api/v1/cohort/{cohort_id}/file/",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
