# coding: utf-8

"""
HaploHub API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 1.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

import re  # noqa: F401

from pydantic import StrictStr, validate_arguments

from haplohub.api_client import ApiClient
from haplohub.api_response import ApiResponse
from haplohub.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from haplohub.models.create_sample_request import CreateSampleRequest
from haplohub.models.get_hgvs_response import GetHgvsResponse
from haplohub.models.paginated_response_sample_schema import PaginatedResponseSampleSchema
from haplohub.models.result_response_sample_schema import ResultResponseSampleSchema
from haplohub.models.success_response import SuccessResponse
from haplohub.models.update_sample_request import UpdateSampleRequest


class SampleApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_sample(
        self, cohort_id: StrictStr, create_sample_request: CreateSampleRequest, **kwargs
    ) -> ResultResponseSampleSchema:  # noqa: E501
        """Create sample  # noqa: E501

        Create a new sample  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_sample(cohort_id, create_sample_request, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param create_sample_request: (required)
        :type create_sample_request: CreateSampleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResultResponseSampleSchema
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the create_sample_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.create_sample_with_http_info(cohort_id, create_sample_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_sample_with_http_info(
        self, cohort_id: StrictStr, create_sample_request: CreateSampleRequest, **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Create sample  # noqa: E501

        Create a new sample  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_sample_with_http_info(cohort_id, create_sample_request, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param create_sample_request: (required)
        :type create_sample_request: CreateSampleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResultResponseSampleSchema, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["cohort_id", "create_sample_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s' to method create_sample" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["cohort_id"] is not None:
            _path_params["cohort_id"] = _params["cohort_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["create_sample_request"] is not None:
            _body_params = _params["create_sample_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get("_content_type", self.api_client.select_header_content_type(["application/json"]))
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["Auth0JWTBearer"]  # noqa: E501

        _response_types_map = {
            "200": "ResultResponseSampleSchema",
        }

        return self.api_client.call_api(
            "/api/v1/cohort/{cohort_id}/sample/",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_sample(self, cohort_id: StrictStr, sample_id: StrictStr, **kwargs) -> SuccessResponse:  # noqa: E501
        """Delete sample  # noqa: E501

        Delete sample by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_sample(cohort_id, sample_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param sample_id: (required)
        :type sample_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the delete_sample_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_sample_with_http_info(cohort_id, sample_id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_sample_with_http_info(self, cohort_id: StrictStr, sample_id: StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete sample  # noqa: E501

        Delete sample by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_sample_with_http_info(cohort_id, sample_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param sample_id: (required)
        :type sample_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["cohort_id", "sample_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s' to method delete_sample" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["cohort_id"] is not None:
            _path_params["cohort_id"] = _params["cohort_id"]

        if _params["sample_id"] is not None:
            _path_params["sample_id"] = _params["sample_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["Auth0JWTBearer"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/api/v1/cohort/{cohort_id}/sample/{sample_id}/",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_sample(self, cohort_id: StrictStr, sample_id: StrictStr, **kwargs) -> ResultResponseSampleSchema:  # noqa: E501
        """Get sample  # noqa: E501

        Get sample by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sample(cohort_id, sample_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param sample_id: (required)
        :type sample_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResultResponseSampleSchema
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_sample_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_sample_with_http_info(cohort_id, sample_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_sample_with_http_info(self, cohort_id: StrictStr, sample_id: StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get sample  # noqa: E501

        Get sample by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sample_with_http_info(cohort_id, sample_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param sample_id: (required)
        :type sample_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResultResponseSampleSchema, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["cohort_id", "sample_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s' to method get_sample" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["cohort_id"] is not None:
            _path_params["cohort_id"] = _params["cohort_id"]

        if _params["sample_id"] is not None:
            _path_params["sample_id"] = _params["sample_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["Auth0JWTBearer"]  # noqa: E501

        _response_types_map = {
            "200": "ResultResponseSampleSchema",
        }

        return self.api_client.call_api(
            "/api/v1/cohort/{cohort_id}/sample/{sample_id}/",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def hgvs_dosage(self, sample_id: StrictStr, description: StrictStr, **kwargs) -> GetHgvsResponse:  # noqa: E501
        """Fetch the dosage of a given allele for a sample based on the hgvs nomenclature. For example 'NC_000001.11:g.11794419T>G'  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.hgvs_dosage(sample_id, description, async_req=True)
        >>> result = thread.get()

        :param sample_id: (required)
        :type sample_id: str
        :param description: (required)
        :type description: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetHgvsResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the hgvs_dosage_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.hgvs_dosage_with_http_info(sample_id, description, **kwargs)  # noqa: E501

    @validate_arguments
    def hgvs_dosage_with_http_info(self, sample_id: StrictStr, description: StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Fetch the dosage of a given allele for a sample based on the hgvs nomenclature. For example 'NC_000001.11:g.11794419T>G'  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.hgvs_dosage_with_http_info(sample_id, description, async_req=True)
        >>> result = thread.get()

        :param sample_id: (required)
        :type sample_id: str
        :param description: (required)
        :type description: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetHgvsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["sample_id", "description"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s' to method hgvs_dosage" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get("sample_id") is not None:  # noqa: E501
            _query_params.append(("sample_id", _params["sample_id"]))

        if _params.get("description") is not None:  # noqa: E501
            _query_params.append(("description", _params["description"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["Auth0JWTBearer"]  # noqa: E501

        _response_types_map = {
            "200": "GetHgvsResponse",
        }

        return self.api_client.call_api(
            "/api/v1/sample/",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_samples(self, cohort_id: StrictStr, **kwargs) -> PaginatedResponseSampleSchema:  # noqa: E501
        """List samples  # noqa: E501

        List all samples  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_samples(cohort_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PaginatedResponseSampleSchema
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_samples_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_samples_with_http_info(cohort_id, **kwargs)  # noqa: E501

    @validate_arguments
    def list_samples_with_http_info(self, cohort_id: StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """List samples  # noqa: E501

        List all samples  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_samples_with_http_info(cohort_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaginatedResponseSampleSchema, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["cohort_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s' to method list_samples" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["cohort_id"] is not None:
            _path_params["cohort_id"] = _params["cohort_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["Auth0JWTBearer"]  # noqa: E501

        _response_types_map = {
            "200": "PaginatedResponseSampleSchema",
        }

        return self.api_client.call_api(
            "/api/v1/cohort/{cohort_id}/sample/",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def update_sample(
        self, cohort_id: StrictStr, sample_id: StrictStr, update_sample_request: UpdateSampleRequest, **kwargs
    ) -> ResultResponseSampleSchema:  # noqa: E501
        """Update sample  # noqa: E501

        Update sample by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_sample(cohort_id, sample_id, update_sample_request, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param sample_id: (required)
        :type sample_id: str
        :param update_sample_request: (required)
        :type update_sample_request: UpdateSampleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResultResponseSampleSchema
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the update_sample_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.update_sample_with_http_info(cohort_id, sample_id, update_sample_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_sample_with_http_info(
        self, cohort_id: StrictStr, sample_id: StrictStr, update_sample_request: UpdateSampleRequest, **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Update sample  # noqa: E501

        Update sample by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_sample_with_http_info(cohort_id, sample_id, update_sample_request, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param sample_id: (required)
        :type sample_id: str
        :param update_sample_request: (required)
        :type update_sample_request: UpdateSampleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResultResponseSampleSchema, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["cohort_id", "sample_id", "update_sample_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s' to method update_sample" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["cohort_id"] is not None:
            _path_params["cohort_id"] = _params["cohort_id"]

        if _params["sample_id"] is not None:
            _path_params["sample_id"] = _params["sample_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["update_sample_request"] is not None:
            _body_params = _params["update_sample_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get("_content_type", self.api_client.select_header_content_type(["application/json"]))
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["Auth0JWTBearer"]  # noqa: E501

        _response_types_map = {
            "200": "ResultResponseSampleSchema",
        }

        return self.api_client.call_api(
            "/api/v1/cohort/{cohort_id}/sample/{sample_id}/",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
