# coding: utf-8

"""
HaploHub API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 1.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

import re  # noqa: F401

from pydantic import StrictStr, validate_arguments

from haplohub.api_client import ApiClient
from haplohub.api_response import ApiResponse
from haplohub.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from haplohub.models.finish_uploading_request import FinishUploadingRequest
from haplohub.models.paginated_response_sample_file_schema import PaginatedResponseSampleFileSchema
from haplohub.models.result_response import ResultResponse
from haplohub.models.result_response_download_link_schema import ResultResponseDownloadLinkSchema
from haplohub.models.result_response_sample_file_schema import ResultResponseSampleFileSchema


class SampleFileApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def delete_sample_file(self, cohort_id: StrictStr, sample_file_id: StrictStr, **kwargs) -> ResultResponse:  # noqa: E501
        """Delete sample file  # noqa: E501

        Delete sample file by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_sample_file(cohort_id, sample_file_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param sample_file_id: (required)
        :type sample_file_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResultResponse
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the delete_sample_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_sample_file_with_http_info(cohort_id, sample_file_id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_sample_file_with_http_info(self, cohort_id: StrictStr, sample_file_id: StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete sample file  # noqa: E501

        Delete sample file by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_sample_file_with_http_info(cohort_id, sample_file_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param sample_file_id: (required)
        :type sample_file_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResultResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["cohort_id", "sample_file_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s' to method delete_sample_file" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["cohort_id"] is not None:
            _path_params["cohort_id"] = _params["cohort_id"]

        if _params["sample_file_id"] is not None:
            _path_params["sample_file_id"] = _params["sample_file_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["Auth0JWTBearer"]  # noqa: E501

        _response_types_map = {
            "200": "ResultResponse",
        }

        return self.api_client.call_api(
            "/api/v1/cohort/{cohort_id}/sample-file/{sample_file_id}/",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def download_link(self, cohort_id: StrictStr, sample_file_id: StrictStr, **kwargs) -> ResultResponseDownloadLinkSchema:  # noqa: E501
        """Get download link  # noqa: E501

        Get download link by sample file ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_link(cohort_id, sample_file_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param sample_file_id: (required)
        :type sample_file_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResultResponseDownloadLinkSchema
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the download_link_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.download_link_with_http_info(cohort_id, sample_file_id, **kwargs)  # noqa: E501

    @validate_arguments
    def download_link_with_http_info(self, cohort_id: StrictStr, sample_file_id: StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get download link  # noqa: E501

        Get download link by sample file ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_link_with_http_info(cohort_id, sample_file_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param sample_file_id: (required)
        :type sample_file_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResultResponseDownloadLinkSchema, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["cohort_id", "sample_file_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s' to method download_link" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["cohort_id"] is not None:
            _path_params["cohort_id"] = _params["cohort_id"]

        if _params["sample_file_id"] is not None:
            _path_params["sample_file_id"] = _params["sample_file_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["Auth0JWTBearer"]  # noqa: E501

        _response_types_map = {
            "200": "ResultResponseDownloadLinkSchema",
        }

        return self.api_client.call_api(
            "/api/v1/cohort/{cohort_id}/sample-file/{sample_file_id}/download-link/",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def finish_uploading(
        self, cohort_id: StrictStr, finish_uploading_request: FinishUploadingRequest, **kwargs
    ) -> ResultResponseSampleFileSchema:  # noqa: E501
        """Finish uploading  # noqa: E501

        Finish uploading a new sample file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.finish_uploading(cohort_id, finish_uploading_request, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param finish_uploading_request: (required)
        :type finish_uploading_request: FinishUploadingRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResultResponseSampleFileSchema
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the finish_uploading_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.finish_uploading_with_http_info(cohort_id, finish_uploading_request, **kwargs)  # noqa: E501

    @validate_arguments
    def finish_uploading_with_http_info(
        self, cohort_id: StrictStr, finish_uploading_request: FinishUploadingRequest, **kwargs
    ) -> ApiResponse:  # noqa: E501
        """Finish uploading  # noqa: E501

        Finish uploading a new sample file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.finish_uploading_with_http_info(cohort_id, finish_uploading_request, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param finish_uploading_request: (required)
        :type finish_uploading_request: FinishUploadingRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResultResponseSampleFileSchema, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["cohort_id", "finish_uploading_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s' to method finish_uploading" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["cohort_id"] is not None:
            _path_params["cohort_id"] = _params["cohort_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["finish_uploading_request"] is not None:
            _body_params = _params["finish_uploading_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get("_content_type", self.api_client.select_header_content_type(["application/json"]))
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["Auth0JWTBearer"]  # noqa: E501

        _response_types_map = {
            "200": "ResultResponseSampleFileSchema",
        }

        return self.api_client.call_api(
            "/api/v1/cohort/{cohort_id}/sample-file/finish-uploading/",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_sample_file(self, cohort_id: StrictStr, sample_file_id: StrictStr, **kwargs) -> ResultResponseSampleFileSchema:  # noqa: E501
        """Get sample file  # noqa: E501

        Get sample file by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sample_file(cohort_id, sample_file_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param sample_file_id: (required)
        :type sample_file_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResultResponseSampleFileSchema
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the get_sample_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_sample_file_with_http_info(cohort_id, sample_file_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_sample_file_with_http_info(self, cohort_id: StrictStr, sample_file_id: StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get sample file  # noqa: E501

        Get sample file by its ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sample_file_with_http_info(cohort_id, sample_file_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param sample_file_id: (required)
        :type sample_file_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResultResponseSampleFileSchema, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["cohort_id", "sample_file_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s' to method get_sample_file" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["cohort_id"] is not None:
            _path_params["cohort_id"] = _params["cohort_id"]

        if _params["sample_file_id"] is not None:
            _path_params["sample_file_id"] = _params["sample_file_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["Auth0JWTBearer"]  # noqa: E501

        _response_types_map = {
            "200": "ResultResponseSampleFileSchema",
        }

        return self.api_client.call_api(
            "/api/v1/cohort/{cohort_id}/sample-file/{sample_file_id}/",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_sample_files(self, cohort_id: StrictStr, **kwargs) -> PaginatedResponseSampleFileSchema:  # noqa: E501
        """List sample files  # noqa: E501

        List all sample files  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_sample_files(cohort_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PaginatedResponseSampleFileSchema
        """
        kwargs["_return_http_data_only"] = True
        if "_preload_content" in kwargs:
            message = "Error! Please call the list_sample_files_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_sample_files_with_http_info(cohort_id, **kwargs)  # noqa: E501

    @validate_arguments
    def list_sample_files_with_http_info(self, cohort_id: StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """List sample files  # noqa: E501

        List all sample files  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_sample_files_with_http_info(cohort_id, async_req=True)
        >>> result = thread.get()

        :param cohort_id: (required)
        :type cohort_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaginatedResponseSampleFileSchema, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["cohort_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s' to method list_sample_files" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["cohort_id"] is not None:
            _path_params["cohort_id"] = _params["cohort_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["Auth0JWTBearer"]  # noqa: E501

        _response_types_map = {
            "200": "PaginatedResponseSampleFileSchema",
        }

        return self.api_client.call_api(
            "/api/v1/cohort/{cohort_id}/sample-file/",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
