# coding: utf-8

"""
HaploHub API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 1.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from pydantic import BaseModel, Field, conlist

from haplohub.models.order_schema import OrderSchema
from haplohub.models.result_schema import ResultSchema


class BiomarkerResultSchema(BaseModel):
    """
    BiomarkerResultSchema
    """

    order: OrderSchema = Field(...)
    results: conlist(ResultSchema) = Field(...)
    __properties = ["order", "results"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BiomarkerResultSchema:
        """Create an instance of BiomarkerResultSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of order
        if self.order:
            _dict["order"] = self.order.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in results (list)
        _items = []
        if self.results:
            for _item in self.results:
                if _item:
                    _items.append(_item.to_dict())
            _dict["results"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BiomarkerResultSchema:
        """Create an instance of BiomarkerResultSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BiomarkerResultSchema.parse_obj(obj)

        _obj = BiomarkerResultSchema.parse_obj(
            {
                "order": OrderSchema.from_dict(obj.get("order")) if obj.get("order") is not None else None,
                "results": [ResultSchema.from_dict(_item) for _item in obj.get("results")]
                if obj.get("results") is not None
                else None,
            }
        )
        return _obj
