# coding: utf-8

"""
HaploHub API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 1.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Optional

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist, constr

from haplohub.models.file_schema import FileSchema
from haplohub.models.sample_schema import SampleSchema


class CohortDetailSchema(BaseModel):
    """
    CohortDetailSchema
    """

    id: Optional[StrictInt] = None
    name: constr(strict=True, max_length=255) = Field(...)
    read_only: Optional[StrictBool] = False
    description: StrictStr = Field(...)
    created: Optional[datetime] = None
    modified: Optional[datetime] = None
    samples: conlist(SampleSchema) = Field(...)
    files: conlist(FileSchema) = Field(...)
    __properties = ["id", "name", "read_only", "description", "created", "modified", "samples", "files"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CohortDetailSchema:
        """Create an instance of CohortDetailSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in samples (list)
        _items = []
        if self.samples:
            for _item in self.samples:
                if _item:
                    _items.append(_item.to_dict())
            _dict["samples"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item in self.files:
                if _item:
                    _items.append(_item.to_dict())
            _dict["files"] = _items
        # set to None if id (nullable) is None
        # and __fields_set__ contains the field
        if self.id is None and "id" in self.__fields_set__:
            _dict["id"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CohortDetailSchema:
        """Create an instance of CohortDetailSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CohortDetailSchema.parse_obj(obj)

        _obj = CohortDetailSchema.parse_obj(
            {
                "id": obj.get("id"),
                "name": obj.get("name"),
                "read_only": obj.get("read_only") if obj.get("read_only") is not None else False,
                "description": obj.get("description"),
                "created": obj.get("created"),
                "modified": obj.get("modified"),
                "samples": [SampleSchema.from_dict(_item) for _item in obj.get("samples")]
                if obj.get("samples") is not None
                else None,
                "files": [FileSchema.from_dict(_item) for _item in obj.get("files")] if obj.get("files") is not None else None,
            }
        )
        return _obj
