# coding: utf-8

"""
HaploHub API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 1.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, conlist

from haplohub.models.file_info import FileInfo
from haplohub.models.upload_type import UploadType


class CreateUploadRequestRequest(BaseModel):
    """
    CreateUploadRequestRequest
    """

    upload_request_id: StrictStr = Field(...)
    files: conlist(FileInfo) = Field(...)
    file_type: UploadType = Field(...)
    sample_id: Optional[StrictStr] = None
    member_id: Optional[StrictStr] = None
    __properties = ["upload_request_id", "files", "file_type", "sample_id", "member_id"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateUploadRequestRequest:
        """Create an instance of CreateUploadRequestRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item in self.files:
                if _item:
                    _items.append(_item.to_dict())
            _dict["files"] = _items
        # set to None if sample_id (nullable) is None
        # and __fields_set__ contains the field
        if self.sample_id is None and "sample_id" in self.__fields_set__:
            _dict["sample_id"] = None

        # set to None if member_id (nullable) is None
        # and __fields_set__ contains the field
        if self.member_id is None and "member_id" in self.__fields_set__:
            _dict["member_id"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateUploadRequestRequest:
        """Create an instance of CreateUploadRequestRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateUploadRequestRequest.parse_obj(obj)

        _obj = CreateUploadRequestRequest.parse_obj(
            {
                "upload_request_id": obj.get("upload_request_id"),
                "files": [FileInfo.from_dict(_item) for _item in obj.get("files")] if obj.get("files") is not None else None,
                "file_type": obj.get("file_type"),
                "sample_id": obj.get("sample_id"),
                "member_id": obj.get("member_id"),
            }
        )
        return _obj
