# coding: utf-8

"""
HaploHub API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 1.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictInt, conlist, constr

from haplohub.models.user_schema import UserSchema
from haplohub.models.workflow_history_schema import WorkflowHistorySchema


class DetailWorkflowRunSchema(BaseModel):
    """
    DetailWorkflowRunSchema
    """

    triggered_by: Optional[UserSchema] = None
    id: Optional[StrictInt] = None
    workflow_id: constr(strict=True, max_length=255) = Field(...)
    workflow_type: constr(strict=True, max_length=255) = Field(...)
    started_at: datetime = Field(...)
    extra: Dict[str, Any] = Field(...)
    history: conlist(WorkflowHistorySchema) = Field(...)
    __properties = ["triggered_by", "id", "workflow_id", "workflow_type", "started_at", "extra", "history"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DetailWorkflowRunSchema:
        """Create an instance of DetailWorkflowRunSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of triggered_by
        if self.triggered_by:
            _dict["triggered_by"] = self.triggered_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in history (list)
        _items = []
        if self.history:
            for _item in self.history:
                if _item:
                    _items.append(_item.to_dict())
            _dict["history"] = _items
        # set to None if triggered_by (nullable) is None
        # and __fields_set__ contains the field
        if self.triggered_by is None and "triggered_by" in self.__fields_set__:
            _dict["triggered_by"] = None

        # set to None if id (nullable) is None
        # and __fields_set__ contains the field
        if self.id is None and "id" in self.__fields_set__:
            _dict["id"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DetailWorkflowRunSchema:
        """Create an instance of DetailWorkflowRunSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DetailWorkflowRunSchema.parse_obj(obj)

        _obj = DetailWorkflowRunSchema.parse_obj(
            {
                "triggered_by": UserSchema.from_dict(obj.get("triggered_by")) if obj.get("triggered_by") is not None else None,
                "id": obj.get("id"),
                "workflow_id": obj.get("workflow_id"),
                "workflow_type": obj.get("workflow_type"),
                "started_at": obj.get("started_at"),
                "extra": obj.get("extra"),
                "history": [WorkflowHistorySchema.from_dict(_item) for _item in obj.get("history")]
                if obj.get("history") is not None
                else None,
            }
        )
        return _obj
