# coding: utf-8

"""
HaploHub API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 1.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from pydantic import BaseModel, Field, StrictStr, conlist

from haplohub.models.dir_schema import DirSchema
from haplohub.models.file_schema import FileSchema


class FileDirSchema(BaseModel):
    """
    FileDirSchema
    """

    location: StrictStr = Field(...)
    dirs: conlist(DirSchema) = Field(...)
    files: conlist(FileSchema) = Field(...)
    __properties = ["location", "dirs", "files"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FileDirSchema:
        """Create an instance of FileDirSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in dirs (list)
        _items = []
        if self.dirs:
            for _item in self.dirs:
                if _item:
                    _items.append(_item.to_dict())
            _dict["dirs"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item in self.files:
                if _item:
                    _items.append(_item.to_dict())
            _dict["files"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FileDirSchema:
        """Create an instance of FileDirSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FileDirSchema.parse_obj(obj)

        _obj = FileDirSchema.parse_obj(
            {
                "location": obj.get("location"),
                "dirs": [DirSchema.from_dict(_item) for _item in obj.get("dirs")] if obj.get("dirs") is not None else None,
                "files": [FileSchema.from_dict(_item) for _item in obj.get("files")] if obj.get("files") is not None else None,
            }
        )
        return _obj
