# coding: utf-8

"""
HaploHub API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 1.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from pydantic import BaseModel, Field, StrictInt, conlist

from haplohub.models.variant_range import VariantRange


class GetVariantRequest(BaseModel):
    """
    GetVariantRequest
    """

    sample_id: StrictInt = Field(...)
    variants: conlist(VariantRange) = Field(...)
    __properties = ["sample_id", "variants"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetVariantRequest:
        """Create an instance of GetVariantRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in variants (list)
        _items = []
        if self.variants:
            for _item in self.variants:
                if _item:
                    _items.append(_item.to_dict())
            _dict["variants"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetVariantRequest:
        """Create an instance of GetVariantRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GetVariantRequest.parse_obj(obj)

        _obj = GetVariantRequest.parse_obj(
            {
                "sample_id": obj.get("sample_id"),
                "variants": [VariantRange.from_dict(_item) for _item in obj.get("variants")]
                if obj.get("variants") is not None
                else None,
            }
        )
        return _obj
