# coding: utf-8

"""
HaploHub API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 1.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr


class ReportTemplateSchema(BaseModel):
    """
    ReportTemplateSchema
    """

    id: Optional[StrictInt] = None
    name: constr(strict=True, max_length=255) = Field(...)
    description: Optional[StrictStr] = ""
    report_type: Optional[constr(strict=True, max_length=255)] = "text"
    template: Optional[StrictStr] = ""
    created: Optional[datetime] = None
    modified: Optional[datetime] = None
    __properties = ["id", "name", "description", "report_type", "template", "created", "modified"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReportTemplateSchema:
        """Create an instance of ReportTemplateSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if id (nullable) is None
        # and __fields_set__ contains the field
        if self.id is None and "id" in self.__fields_set__:
            _dict["id"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ReportTemplateSchema:
        """Create an instance of ReportTemplateSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ReportTemplateSchema.parse_obj(obj)

        _obj = ReportTemplateSchema.parse_obj(
            {
                "id": obj.get("id"),
                "name": obj.get("name"),
                "description": obj.get("description") if obj.get("description") is not None else "",
                "report_type": obj.get("report_type") if obj.get("report_type") is not None else "text",
                "template": obj.get("template") if obj.get("template") is not None else "",
                "created": obj.get("created"),
                "modified": obj.get("modified"),
            }
        )
        return _obj
