# coding: utf-8

"""
HaploHub API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 1.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional, Union

from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, conlist


class VariantSchema(BaseModel):
    """
    VariantSchema
    """

    accession: StrictStr = Field(...)
    position: StrictInt = Field(...)
    id: StrictStr = Field(...)
    reference: StrictStr = Field(...)
    alternate: conlist(StrictStr) = Field(...)
    dosage: StrictInt = Field(...)
    is_called: StrictBool = Field(...)
    quality: Optional[Union[StrictFloat, StrictInt]] = Field(...)
    __properties = ["accession", "position", "id", "reference", "alternate", "dosage", "is_called", "quality"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VariantSchema:
        """Create an instance of VariantSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if quality (nullable) is None
        # and __fields_set__ contains the field
        if self.quality is None and "quality" in self.__fields_set__:
            _dict["quality"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VariantSchema:
        """Create an instance of VariantSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VariantSchema.parse_obj(obj)

        _obj = VariantSchema.parse_obj(
            {
                "accession": obj.get("accession"),
                "position": obj.get("position"),
                "id": obj.get("id"),
                "reference": obj.get("reference"),
                "alternate": obj.get("alternate"),
                "dosage": obj.get("dosage"),
                "is_called": obj.get("is_called"),
                "quality": obj.get("quality"),
            }
        )
        return _obj
