(bitstream-generation)=
# FASM to Bitstream

This section contains information on how to generate a bitstream from a FASM file.

## User guide

We have provided two methods for the user to generate bitstreams. The first method is done using the CLI provided and
the second method which the user calls the script manually. The first method is recommended, as it provides all the necessary information to generate the bitstream. The second method is provided for cases where the user has
decided not to work with the FABulous project structure.

### Generating a bitstream using the CLI

To generate a bitstream using the CLI, the user must first generate the bitstream specification using the CLI. To
generate the bitstream specification, we can call the `gen_bitstream_spec` command from the CLI. It is expected that
the user had also run synthesis and place and route for the design, which generates the `.fasm` file of the design.

To generate the bitstream, the user can call the `gen_bitstream_binary <design.fasm>` command from the CLI, where the
`design.fasm` is the `.fasm` file generated by synthesis and place and route.

The resulting bitstream is placed in the same directory as where the `fasm` file is located and named as
`design.bin`.

### Manually generating a bitstream

To generate the necessary materials to generate a bitstream, run `$FAB_ROOT/fabric_generator/fabric_gen.py` with the `-GenBitstreamSpec` flag.

With the FASM file generated by Nextpnr, you can run this command for bitstream generation.

```console
(venv)$ bit_gen -genBitstream <fasm_file> meta_data.txt <bitstream file>
```

| Argument         | Description                                                        |
|------------------|--------------------------------------------------------------------|
| <fasm_file>      | the FASM file generated by Nextpnr in previous compilation         |
| <bitstream_file> | User can define the output binary file name with ``.bin`` format   |

### Example

The following command lowers the FASM representation of the placed and routed `sequential_16bit_en` design into a bitstream file.

```console
(venv)$ bit_gen -genBitstream 16bit_sequential_en.fasm meta_data.txt 16bit_sequential_en_output.bin
```

(belmap)=

## Changing or adding new primitives

For a change in the primitives or adding new primitives, you can simply add them within the primitive file. As an
example, in the `LUT4c_frame_config` primitive description below there are 16 configuration bits for INIT values,
1 configuration bit `FF` for the flip-flop bypass switch, 1 configuration bit `IOmux` for the carry input switch and
1 configuration bit `SET_NORESET` for the SET or RESET switch, which means there are 19 configuration bits for each
LUT4 parameters setting. The number of entries in the mapping needs to match the `NoConfigBits` otherwise, the tool
will give an error.

```verilog
(*FABulous, BelMap,
INIT=0,
INIT[1]=1,
INIT[2]=2,
INIT[3]=3,
INIT[4]=4,
INIT[5]=5,
INIT[6]=6,
INIT[7]=7,
INIT[8]=8,
INIT[9]=9,
INIT[10]=10,
INIT[11]=11,
INIT[12]=12,
INIT[13]=13,
INIT[14]=14,
INIT[15]=15,
FF=16,
IOmux=17,
SET_NORESET=18
*)
module LUT4c_frame_config (I0, I1, I2, I3, O, Ci, Co, SR, EN, UserCLK, ConfigBits);
parameter NoConfigBits = 19 ;
...
endmodule
```
