# generated by datamodel-codegen:
#   filename:  data.json
#   timestamp: 2021-01-27T01:23:27+00:00

from __future__ import annotations

from typing import Any, List, Optional

from pydantic import BaseModel

from tautulli.internal import utils as internal_utils, static
from tautulli.tools.utils import to_human_bitrate


class Session(BaseModel):
    session_key: Optional[str]
    media_type: Optional[str]
    view_offset: Optional[str]
    progress_percent: Optional[str]
    quality_profile: Optional[str]
    synced_version_profile: Optional[str]
    optimized_version_profile: Optional[str]
    user: Optional[str]
    channel_stream: Optional[int]
    section_id: Optional[str]
    library_name: Optional[str]
    rating_key: Optional[str]
    parent_rating_key: Optional[str]
    grandparent_rating_key: Optional[str]
    title: Optional[str]
    parent_title: Optional[str]
    grandparent_title: Optional[str]
    original_title: Optional[str]
    sort_title: Optional[str]
    media_index: Optional[str]
    parent_media_index: Optional[str]
    studio: Optional[str]
    content_rating: Optional[str]
    summary: Optional[str]
    tagline: Optional[str]
    rating: Optional[str]
    rating_image: Optional[str]
    audience_rating: Optional[str]
    audience_rating_image: Optional[str]
    user_rating: Optional[str]
    duration: Optional[str]
    year: Optional[str]
    thumb: Optional[str]
    parent_thumb: Optional[str]
    grandparent_thumb: Optional[str]
    art: Optional[str]
    banner: Optional[str]
    originally_available_at: Optional[str]
    added_at: Optional[str]
    updated_at: Optional[str]
    last_viewed_at: Optional[str]
    guid: Optional[str]
    parent_guid: Optional[str]
    grandparent_guid: Optional[str]
    directors: Optional[List]
    writers: Optional[List]
    actors: Optional[List]
    genres: Optional[List[str]]
    labels: Optional[List]
    collections: Optional[List]
    guids: Optional[List]
    full_title: Optional[str]
    children_count: Optional[int]
    live: Optional[int]
    id: Optional[str]
    container: Optional[str]
    bitrate: Optional[str]
    height: Optional[str]
    width: Optional[str]
    aspect_ratio: Optional[str]
    video_codec: Optional[str]
    video_resolution: Optional[str]
    video_full_resolution: Optional[str]
    video_framerate: Optional[str]
    video_profile: Optional[str]
    audio_codec: Optional[str]
    audio_channels: Optional[str]
    audio_channel_layout: Optional[str]
    audio_profile: Optional[str]
    optimized_version: Optional[int]
    channel_call_sign: Optional[str]
    channel_identifier: Optional[str]
    channel_thumb: Optional[str]
    file: Optional[str]
    file_size: Optional[str]
    indexes: Optional[int]
    selected: Optional[int]
    type: Optional[str]
    video_codec_level: Optional[str]
    video_bitrate: Optional[str]
    video_bit_depth: Optional[str]
    video_chroma_subsampling: Optional[str]
    video_color_primaries: Optional[str]
    video_color_range: Optional[str]
    video_color_space: Optional[str]
    video_color_trc: Optional[str]
    video_frame_rate: Optional[str]
    video_ref_frames: Optional[str]
    video_height: Optional[str]
    video_width: Optional[str]
    video_language: Optional[str]
    video_language_code: Optional[str]
    video_scan_type: Optional[str]
    audio_bitrate: Optional[str]
    audio_bitrate_mode: Optional[str]
    audio_sample_rate: Optional[str]
    audio_language: Optional[str]
    audio_language_code: Optional[str]
    subtitle_codec: Optional[str]
    subtitle_container: Optional[str]
    subtitle_format: Optional[str]
    subtitle_forced: Optional[int]
    subtitle_location: Optional[str]
    subtitle_language: Optional[str]
    subtitle_language_code: Optional[str]
    row_id: Optional[int]
    user_id: Optional[int]
    username: Optional[str]
    friendly_name: Optional[str]
    user_thumb: Optional[str]
    email: Optional[str]
    is_active: Optional[int]
    is_admin: Optional[int]
    is_home_user: Optional[int]
    is_allow_sync: Optional[int]
    is_restricted: Optional[int]
    do_notify: Optional[int]
    keep_history: Optional[int]
    deleted_user: Optional[int]
    allow_guest: Optional[int]
    shared_libraries: Optional[List[str]]
    ip_address: Optional[str]
    ip_address_public: Optional[str]
    device: Optional[str]
    platform: Optional[str]
    platform_name: Optional[str]
    platform_version: Optional[str]
    product: Optional[str]
    product_version: Optional[str]
    profile: Optional[str]
    player: Optional[str]
    machine_id: Optional[str]
    state: Optional[str]
    local: Optional[int]
    relayed: Optional[int]
    secure: Optional[int]
    session_id: Optional[str]
    bandwidth: Optional[str]
    location: Optional[str]
    transcode_key: Optional[str]
    transcode_throttled: Optional[int]
    transcode_progress: Optional[int]
    transcode_speed: Optional[str]
    transcode_audio_channels: Optional[str]
    transcode_audio_codec: Optional[str]
    transcode_video_codec: Optional[str]
    transcode_width: Optional[str]
    transcode_height: Optional[str]
    transcode_container: Optional[str]
    transcode_protocol: Optional[str]
    transcode_hw_requested: Optional[int]
    transcode_hw_decode: Optional[str]
    transcode_hw_decode_title: Optional[str]
    transcode_hw_encode: Optional[str]
    transcode_hw_encode_title: Optional[str]
    transcode_hw_full_pipeline: Optional[int]
    transcode_max_offset_available: Optional[int]
    transcode_min_offset_available: Optional[int]
    audio_decision: Optional[str]
    video_decision: Optional[str]
    subtitle_decision: Optional[str]
    throttled: Optional[str]
    transcode_hw_decoding: Optional[int]
    transcode_hw_encoding: Optional[int]
    stream_container: Optional[str]
    stream_bitrate: Optional[str]
    stream_aspect_ratio: Optional[str]
    stream_audio_codec: Optional[str]
    stream_audio_channels: Optional[str]
    stream_audio_channel_layout: Optional[str]
    stream_video_codec: Optional[str]
    stream_video_framerate: Optional[str]
    stream_video_resolution: Optional[str]
    stream_video_height: Optional[str]
    stream_video_width: Optional[str]
    stream_duration: Optional[str]
    stream_container_decision: Optional[str]
    optimized_version_title: Optional[str]
    synced_version: Optional[int]
    live_uuid: Optional[str]
    bif_thumb: Optional[str]
    subtitles: Optional[int]
    transcode_decision: Optional[str]
    container_decision: Optional[str]
    stream_video_full_resolution: Optional[str] = None
    video_dynamic_range: Optional[str]
    stream_video_dynamic_range: Optional[str]
    stream_video_bitrate: Optional[str]
    stream_video_bit_depth: Optional[str]
    stream_video_chroma_subsampling: Optional[str]
    stream_video_color_primaries: Optional[str]
    stream_video_color_range: Optional[str]
    stream_video_color_space: Optional[str]
    stream_video_color_trc: Optional[str]
    stream_video_codec_level: Optional[str]
    stream_video_ref_frames: Optional[str]
    stream_video_language: Optional[str]
    stream_video_language_code: Optional[str]
    stream_video_scan_type: Optional[str]
    stream_video_decision: Optional[str]
    stream_audio_bitrate: Optional[str]
    stream_audio_bitrate_mode: Optional[str]
    stream_audio_sample_rate: Optional[str]
    stream_audio_channel_layout_: Optional[str]
    stream_audio_language: Optional[str]
    stream_audio_language_code: Optional[str]
    stream_audio_decision: Optional[str]
    stream_subtitle_codec: Optional[str]
    stream_subtitle_container: Optional[str]
    stream_subtitle_format: Optional[str]
    stream_subtitle_forced: Optional[int]
    stream_subtitle_location: Optional[str]
    stream_subtitle_language: Optional[str]
    stream_subtitle_language_code: Optional[str]
    stream_subtitle_decision: Optional[str]
    stream_subtitle_transient: Optional[int]

    @property
    def duration_milliseconds(self):
        try:
            return int(self.duration)
        except:
            return 0

    @property
    def location_milliseconds(self):
        try:
            return int(self.view_offset)
        except:
            return 0

    @property
    def progress_percentage(self):
        if not self.duration_milliseconds:
            return 0
        return int(self.location_milliseconds / self.duration_milliseconds)

    @property
    def progress_marker(self):
        if not self.location_milliseconds or not self.duration_milliseconds:
            return ""
        current_progress_min_sec = internal_utils.milliseconds_to_minutes_seconds(
            milliseconds=self.location_milliseconds)
        total_min_sec = internal_utils.milliseconds_to_minutes_seconds(milliseconds=self.duration_milliseconds)
        return f"{current_progress_min_sec}/{total_min_sec}"

    @property
    def eta(self):
        if not self.duration_milliseconds or not self.location_milliseconds:
            return ""
        milliseconds_remaining = self.duration_milliseconds - self.location_milliseconds
        eta_datetime = internal_utils.now_plus_milliseconds(milliseconds=milliseconds_remaining)
        eta_string = internal_utils.datetime_to_string(datetime_object=eta_datetime, string_format="%H:%M")
        return eta_string

    @property
    def status_icon(self):
        """
        Get icon for a stream state

        :returns: emoji icon
        """
        return static.switcher.get(self.state, "")

    @property
    def type_icon(self):
        if self.media_type in static.media_type_icons:
            return static.media_type_icons[self.media_type]
        # thanks twilsonco
        elif self.live:
            return static.media_type_icons['live']
        return ""

    @property
    def human_bandwidth(self) -> str:
        try:
            return to_human_bitrate(float(self.bandwidth))
        except:
            return to_human_bitrate(0)

    @property
    def transcoding_stub(self):
        return ' (Transcode)' if self.stream_container_decision == 'transcode' else ''

    @property
    def summary(self) -> str:
        return f"{static.session_title_message.format(icon=self.status_icon, username=self.username, media_type_icon=self.type_icon, title=self.title)}\n" \
               f"{static.session_player_message.format(product=self.product, player=self.player)}\n" \
               f"{static.session_details_message.format(quality_profile=self.quality_profile, bandwidth=self.human_bandwidth, transcoding=self.transcoding_stub)}\n" \
               f"{static.session_progress_message.format(progress=self.progress_marker, eta=self.eta)}"


class Activity(BaseModel):
    stream_count: Optional[str]
    sessions: Optional[List[Session]]
    stream_count_direct_play: Optional[int]
    stream_count_direct_stream: Optional[int]
    stream_count_transcode: Optional[int]
    total_bandwidth: Optional[int]
    lan_bandwidth: Optional[int]
    wan_bandwidth: Optional[int]

    @property
    def summary(self) -> ActivitySummary:
        return build_summary_from_activity_object(activity=self)


class Response(BaseModel):
    result: Optional[str]
    message: Any
    data: Activity


class Model(BaseModel):
    response: Response


class ActivitySummary(BaseModel):
    stream_count: Optional[str] = "0"
    transcode_count: Optional[int] = 0
    total_bandwidth: Optional[int] = 0
    lan_bandwidth: Optional[int] = 0

    @property
    def message(self):
        """
        Get activity summary message

        :returns: Summary message
        :rtype: Optional[str]
        """
        overview_message = ""
        stream_count = 0
        try:
            stream_count = int(self.stream_count)
        except:
            pass

        if stream_count > 0:
            overview_message += static.sessions_message.format(stream_count=stream_count,
                                                               word=internal_utils.make_plural(word='stream',
                                                                                               count=stream_count))
            if self.transcode_count > 0:
                overview_message += f" ({static.transcodes_message.format(transcode_count=self.transcode_count, word=internal_utils.make_plural(word='transcode', count=self.transcode_count))}) "

        if self.total_bandwidth > 0:
            overview_message += f" | {static.bandwidth_message.format(bandwidth=to_human_bitrate(float(self.total_bandwidth)))}"
            if self.lan_bandwidth > 0:
                overview_message += f" {static.lan_bandwidth_message.format(bandwidth=to_human_bitrate(float(self.lan_bandwidth)))}"

        return overview_message


def build_summary_from_activity_object(activity: Activity) -> ActivitySummary:
    """
    Create an ActivitySummary using an Activity object

    :param activity: Activity object to use for Overview
    :type activity: Activity
    :returns: ActivitySummary object
    :rtype: ActivitySummary
    """
    overview = ActivitySummary()
    overview.stream_count = activity.stream_count
    overview.transcode_count = activity.stream_count_transcode
    overview.total_bandwidth = activity.total_bandwidth
    overview.lan_bandwidth = activity.lan_bandwidth

    return overview


def build_summary_from_activity_json(activity_data: dict) -> ActivitySummary:
    """
    Create an ActivitySummary using Activity JSON data

    :param activity_data: Activity JSON data to use for Overview
    :type activity_data: dict
    :returns: ActivitySummary object
    :rtype: ActivitySummary
    """
    return ActivitySummary(**activity_data)
