"""
neuroglancer-related utility functions
"""
from importlib.metadata import version, PackageNotFoundError

try:
    __version__ = version("ngsidekick")
except PackageNotFoundError:
    # Package is not installed
    __version__ = "unknown"

from .storage import download_ngstate, upload_ngstate, upload_ngstates, upload_json, upload_to_bucket, make_bucket_public
from .util import parse_nglink, format_nglink, layer_dict, layer_state
from .annotations.local import (
    local_annotation_json, extract_local_annotations,

    # deprecated names
    extract_annotations, annotation_layer_json, point_annotation_layer_json
)
from .annotations.precomputed import write_precomputed_annotations
from .segmentprops import segment_properties_json, segment_properties_to_dataframe
from .segmentcolors import hex_string_from_segment_id
