### async_generator



```python
async def mytest():
    for i in range(10):
        yield i
```
调用方式1:

```python
a=mytest()
await anext(a)
```

调用方式2:

```python
[item async for item in mytest()]
```

### async_context

定义异步上下文生成器函数


```python
@contextlib.asynccontextmanager
async def get_db0():  # 在 depends 中使用
    async with sessionmanager.session() as session:
        yield session
```

调用异步上下文管理器生成器对象
__aenter__, __aexit__ 是异步上下文在进入代码块和离开代码块会执行的逻辑.

```python
async with get_db0() as session:
    # session.xxx
    pass
```
