import pytest
import emberfactory
import re
import os
from pathlib import Path
import xml.etree.ElementTree as ET
import json
"""
Early and basic implementation of Flask app testing
---------------------------------------------------
The purpose of this file is to help development. ** It is not intended to help new users testing the app **

The main aim is to produce the .pdf from a set of test .xlsx files (i.e. the test is more input related than 
code-functionality related, although doing some more testing of code functionality is possible)
"""

outdir = Path('instance/out/test/')
refdir = Path('/Users/marbaix/BurningEmbers/EmberData/bench/pre-release-tests/v2.1')
cfgfile = "../instance/test_emberfactory.json"
if os.path.exists(cfgfile):
    # You may insert your specific paths here
    with open(cfgfile) as json_data_file:
        cfg = json.load(json_data_file)
else:
    cfg = {}


@pytest.fixture
def client():
    app = emberfactory.create_app()
    app.config['TESTING'] = True  # Probably not used so far, at least, not explicitly used in EF's code
    with app.test_client() as client:
        yield client  # (from flask tuto, but not sure that it is useful here: only one client anyway so purpose?)
    # Any operation to be done after tests would take place here


def test_documentation(client):
    rv = client.post('/doc/tutorial')
    assert b'starting point to learn' in rv.data, "Having trouble displaying the tutorial ?!"
    rv = client.post('/doc/parameters')
    assert b'This page documents parameters' in rv.data, "Having trouble displaying the parameters' reference ?!"


def test_file_processing(client):
    # Upload and process all files from a test directory (you may add your own in the config file, see above)
    if "testdirs" in cfg:
        testdirs = cfg["testdirs"]
    else:
        testdirs = [os.path.join(os.path.dirname(emberfactory.__file__), "doc/examples")]
    # Tests below do not intent in succeeding or failing but rather in issuing warnings. However,
    # all my attempts at writing warnings directly to stdout or using warnings.warn() with a hook
    # had the same strange result that it would continue the last line of test reports from pytest / assess statements,
    # hence this poor solution of ending a line (which we do not know why it was not ended yet) with a print():
    print("\n")
    testfiles = []
    for adir in testdirs:
        for afile in os.listdir(adir):
            if os.path.splitext(afile)[-1] == '.xlsx' \
                    and os.path.splitext(afile)[0] != "colors" and os.path.splitext(afile)[0][0] != '~':
                testfiles.append(os.path.join(adir, afile))

    try:
        for f in os.listdir(outdir):
            os.remove(os.path.join(outdir, f))
    except OSError:
        try:
            os.makedirs(outdir)
        except OSError:
            print("Could not get a clean out/test directory.")
    print(f"Writing to {outdir}")

    for filename in testfiles:
        # Submit file for processing
        print (filename)
        rv = client.post('/process', data=dict(
            file=(open(filename, 'rb'), filename),
            csys="standard",
            delfile=1
        ), follow_redirects=True)

        if "To download" not in rv.text:
            critical = re.findall(r'class="critical">(.*?)</p>|(CRITICAL ERROR.*?)</p>', str(rv.data))
            if len(critical) > 0 and critical[0]:
                print(critical)
            else:
                print(rv.text)
            assert False  # If someone has the time to improve... We need a clear explanation for the failure.

        if "Warning messages" in rv.text:
            print(f"Warnings for: {filename}")
            print("\t", re.findall(r'class="error">(.*?)</p>', str(rv.data)))

        # Download the result to the out/test folder.
        if "To download" in rv.text:
            producedfiles = re.findall(r'/out/(.+?)"', str(rv.data))
            testfile = [file for file in producedfiles if ".svg" in file][0]
            rv = client.post('/out/'+testfile)
            with open(outdir / testfile, 'w+b') as fout:
                fout.write(rv.data)
                fout.close()

            testfile = [file for file in producedfiles if ".pdf" in file][0]
            rv = client.post('/out/'+testfile)
            with open(outdir / testfile, 'w+b') as fout:
                fout.write(rv.data)
                fout.close()

def compare_svg(ref_file: Path, out_file: Path) -> str | None:
    """Return None if SVGs are equivalent, else a short diff."""
    # Written with AI contribution.
    ref_tree = ET.parse(ref_file)
    out_tree = ET.parse(out_file)
    ref_root = ref_tree.getroot()
    out_root = out_tree.getroot()

    # Note: root tags are not compared here.
    # Compare children recursively
    def compare_elements(e1, e2, path="/"):
        if e1.tag != e2.tag:
            return f"Tag mismatch: {e1.tag} != {e2.tag}"
        if e1.attrib != e2.attrib:
            return f"Attributes mismatch: {e1.attrib} != {e2.attrib}"
        if (e1.text or "").strip() != (e2.text or "").strip():
            return f"Text mismatch: {e1.text} != {e2.text}"
        if len(e1) != len(e2):
            return f"Children count mismatch: {len(e1)} != {len(e2)}"
        for i, (c1, c2) in enumerate(zip(e1, e2), 1):
            sub_path = f"{path}/{c1.tag}[{i}]"
            msg = compare_elements(c1, c2, sub_path)  # Further compare children
            if msg:
                return msg
        return None

    return compare_elements(ref_root, out_root)

# @pytest.mark.skip(reason="Output file comparison is disabled; to enable, comment the mark.skip line.")
# @pytest.mark.parametrize("ref_file", refdir.glob("*.svg"))
# def test_svg_file_matches_reference(ref_file):
#     out_file = outdir / ref_file.name
#     assert out_file, f"Missing output file: {out_file}"
#     msg = compare_svg(ref_file, out_file)
#     assert msg is None, f"{ref_file.name} differs.\n{msg}"
