# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.provider_api_key_page_public import ProviderApiKeyPagePublic
from ..types.provider_api_key_public import ProviderApiKeyPublic
from .raw_client import AsyncRawLlmProviderKeyClient, RawLlmProviderKeyClient
from .types.provider_api_key_write_provider import ProviderApiKeyWriteProvider

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class LlmProviderKeyClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawLlmProviderKeyClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawLlmProviderKeyClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawLlmProviderKeyClient
        """
        return self._raw_client

    def delete_llm_provider_api_keys_batch(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete LLM Provider's ApiKeys batch

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.llm_provider_key.delete_llm_provider_api_keys_batch(ids=['ids'], )
        """
        _response = self._raw_client.delete_llm_provider_api_keys_batch(ids=ids, request_options=request_options)
        return _response.data

    def find_llm_provider_keys(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProviderApiKeyPagePublic:
        """
        Find LLM Provider's ApiKeys

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProviderApiKeyPagePublic
            LLMProviderApiKey resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.llm_provider_key.find_llm_provider_keys()
        """
        _response = self._raw_client.find_llm_provider_keys(request_options=request_options)
        return _response.data

    def store_llm_provider_api_key(
        self,
        *,
        provider: ProviderApiKeyWriteProvider,
        api_key: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        headers: typing.Optional[typing.Dict[str, str]] = OMIT,
        configuration: typing.Optional[typing.Dict[str, str]] = OMIT,
        base_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Store LLM Provider's ApiKey

        Parameters
        ----------
        provider : ProviderApiKeyWriteProvider

        api_key : typing.Optional[str]

        name : typing.Optional[str]

        headers : typing.Optional[typing.Dict[str, str]]

        configuration : typing.Optional[typing.Dict[str, str]]

        base_url : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.llm_provider_key.store_llm_provider_api_key(provider="openai", )
        """
        _response = self._raw_client.store_llm_provider_api_key(
            provider=provider,
            api_key=api_key,
            name=name,
            headers=headers,
            configuration=configuration,
            base_url=base_url,
            request_options=request_options,
        )
        return _response.data

    def get_llm_provider_api_key_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProviderApiKeyPublic:
        """
        Get LLM Provider's ApiKey by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProviderApiKeyPublic
            LLMProviderApiKey resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.llm_provider_key.get_llm_provider_api_key_by_id(id='id', )
        """
        _response = self._raw_client.get_llm_provider_api_key_by_id(id, request_options=request_options)
        return _response.data

    def update_llm_provider_api_key(
        self,
        id: str,
        *,
        api_key: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        headers: typing.Optional[typing.Dict[str, str]] = OMIT,
        configuration: typing.Optional[typing.Dict[str, str]] = OMIT,
        base_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update LLM Provider's ApiKey

        Parameters
        ----------
        id : str

        api_key : typing.Optional[str]

        name : typing.Optional[str]

        headers : typing.Optional[typing.Dict[str, str]]

        configuration : typing.Optional[typing.Dict[str, str]]

        base_url : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.llm_provider_key.update_llm_provider_api_key(id='id', )
        """
        _response = self._raw_client.update_llm_provider_api_key(
            id,
            api_key=api_key,
            name=name,
            headers=headers,
            configuration=configuration,
            base_url=base_url,
            request_options=request_options,
        )
        return _response.data


class AsyncLlmProviderKeyClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawLlmProviderKeyClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawLlmProviderKeyClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawLlmProviderKeyClient
        """
        return self._raw_client

    async def delete_llm_provider_api_keys_batch(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete LLM Provider's ApiKeys batch

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.llm_provider_key.delete_llm_provider_api_keys_batch(ids=['ids'], )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_llm_provider_api_keys_batch(ids=ids, request_options=request_options)
        return _response.data

    async def find_llm_provider_keys(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProviderApiKeyPagePublic:
        """
        Find LLM Provider's ApiKeys

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProviderApiKeyPagePublic
            LLMProviderApiKey resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.llm_provider_key.find_llm_provider_keys()
        asyncio.run(main())
        """
        _response = await self._raw_client.find_llm_provider_keys(request_options=request_options)
        return _response.data

    async def store_llm_provider_api_key(
        self,
        *,
        provider: ProviderApiKeyWriteProvider,
        api_key: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        headers: typing.Optional[typing.Dict[str, str]] = OMIT,
        configuration: typing.Optional[typing.Dict[str, str]] = OMIT,
        base_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Store LLM Provider's ApiKey

        Parameters
        ----------
        provider : ProviderApiKeyWriteProvider

        api_key : typing.Optional[str]

        name : typing.Optional[str]

        headers : typing.Optional[typing.Dict[str, str]]

        configuration : typing.Optional[typing.Dict[str, str]]

        base_url : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.llm_provider_key.store_llm_provider_api_key(provider="openai", )
        asyncio.run(main())
        """
        _response = await self._raw_client.store_llm_provider_api_key(
            provider=provider,
            api_key=api_key,
            name=name,
            headers=headers,
            configuration=configuration,
            base_url=base_url,
            request_options=request_options,
        )
        return _response.data

    async def get_llm_provider_api_key_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProviderApiKeyPublic:
        """
        Get LLM Provider's ApiKey by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProviderApiKeyPublic
            LLMProviderApiKey resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.llm_provider_key.get_llm_provider_api_key_by_id(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_llm_provider_api_key_by_id(id, request_options=request_options)
        return _response.data

    async def update_llm_provider_api_key(
        self,
        id: str,
        *,
        api_key: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        headers: typing.Optional[typing.Dict[str, str]] = OMIT,
        configuration: typing.Optional[typing.Dict[str, str]] = OMIT,
        base_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update LLM Provider's ApiKey

        Parameters
        ----------
        id : str

        api_key : typing.Optional[str]

        name : typing.Optional[str]

        headers : typing.Optional[typing.Dict[str, str]]

        configuration : typing.Optional[typing.Dict[str, str]]

        base_url : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.llm_provider_key.update_llm_provider_api_key(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_llm_provider_api_key(
            id,
            api_key=api_key,
            name=name,
            headers=headers,
            configuration=configuration,
            base_url=base_url,
            request_options=request_options,
        )
        return _response.data
