# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .comment import Comment
from .experiment_status import ExperimentStatus
from .experiment_type import ExperimentType
from .feedback_score_average import FeedbackScoreAverage
from .json_list_string import JsonListString
from .percentage_values import PercentageValues
from .prompt_version_link import PromptVersionLink


class Experiment(UniversalBaseModel):
    id: typing.Optional[str] = None
    dataset_name: str
    dataset_id: typing.Optional[str] = None
    name: typing.Optional[str] = None
    metadata: typing.Optional[JsonListString] = None
    type: typing.Optional[ExperimentType] = None
    optimization_id: typing.Optional[str] = None
    feedback_scores: typing.Optional[typing.List[FeedbackScoreAverage]] = None
    comments: typing.Optional[typing.List[Comment]] = None
    trace_count: typing.Optional[int] = None
    created_at: typing.Optional[dt.datetime] = None
    duration: typing.Optional[PercentageValues] = None
    total_estimated_cost: typing.Optional[float] = None
    total_estimated_cost_avg: typing.Optional[float] = None
    usage: typing.Optional[typing.Dict[str, float]] = None
    last_updated_at: typing.Optional[dt.datetime] = None
    created_by: typing.Optional[str] = None
    last_updated_by: typing.Optional[str] = None
    status: typing.Optional[ExperimentStatus] = None
    prompt_version: typing.Optional[PromptVersionLink] = None
    prompt_versions: typing.Optional[typing.List[PromptVersionLink]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
