# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .comment import Comment
from .error_info import ErrorInfo
from .feedback_score import FeedbackScore
from .json_list_string import JsonListString
from .span_type import SpanType


class Span(UniversalBaseModel):
    id: typing.Optional[str] = None
    project_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    If null, the default project is used
    """

    project_id: typing.Optional[str] = None
    trace_id: typing.Optional[str] = None
    parent_span_id: typing.Optional[str] = None
    name: typing.Optional[str] = None
    type: typing.Optional[SpanType] = None
    start_time: dt.datetime
    end_time: typing.Optional[dt.datetime] = None
    input: typing.Optional[JsonListString] = None
    output: typing.Optional[JsonListString] = None
    metadata: typing.Optional[JsonListString] = None
    model: typing.Optional[str] = None
    provider: typing.Optional[str] = None
    tags: typing.Optional[typing.List[str]] = None
    usage: typing.Optional[typing.Dict[str, int]] = None
    error_info: typing.Optional[ErrorInfo] = None
    created_at: typing.Optional[dt.datetime] = None
    last_updated_at: typing.Optional[dt.datetime] = None
    created_by: typing.Optional[str] = None
    last_updated_by: typing.Optional[str] = None
    feedback_scores: typing.Optional[typing.List[FeedbackScore]] = None
    comments: typing.Optional[typing.List[Comment]] = None
    total_estimated_cost: typing.Optional[float] = None
    total_estimated_cost_version: typing.Optional[str] = None
    duration: typing.Optional[float] = pydantic.Field(default=None)
    """
    Duration in milliseconds as a decimal number to support sub-millisecond precision
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
